/* EpisodesPage.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from EpisodesPage.vala, do not modify */

/*-
 * Copyright 2016-2021 elementary, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Artem Anufrij <artem.anufrij@live.de>
 *
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <granite-7.h>
#include <glib.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>

#define AUDIENCE_SERVICES_POSTER_WIDTH 300
#define AUDIENCE_SERVICES_POSTER_HEIGHT ((gint) ((AUDIENCE_SERVICES_POSTER_WIDTH * 9) / 16))
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define AUDIENCE_TYPE_EPISODES_PAGE (audience_episodes_page_get_type ())
#define AUDIENCE_EPISODES_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_EPISODES_PAGE, AudienceEpisodesPage))
#define AUDIENCE_EPISODES_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_EPISODES_PAGE, AudienceEpisodesPageClass))
#define AUDIENCE_IS_EPISODES_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_EPISODES_PAGE))
#define AUDIENCE_IS_EPISODES_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_EPISODES_PAGE))
#define AUDIENCE_EPISODES_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_EPISODES_PAGE, AudienceEpisodesPageClass))

typedef struct _AudienceEpisodesPage AudienceEpisodesPage;
typedef struct _AudienceEpisodesPageClass AudienceEpisodesPageClass;
typedef struct _AudienceEpisodesPagePrivate AudienceEpisodesPagePrivate;
enum  {
	AUDIENCE_EPISODES_PAGE_0_PROPERTY,
	AUDIENCE_EPISODES_PAGE_NUM_PROPERTIES
};
static GParamSpec* audience_episodes_page_properties[AUDIENCE_EPISODES_PAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM (audience_objects_media_item_get_type ())
#define AUDIENCE_OBJECTS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM, AudienceObjectsMediaItem))
#define AUDIENCE_OBJECTS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM, AudienceObjectsMediaItemClass))
#define AUDIENCE_OBJECTS_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM))
#define AUDIENCE_OBJECTS_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM))
#define AUDIENCE_OBJECTS_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM, AudienceObjectsMediaItemClass))

typedef struct _AudienceObjectsMediaItem AudienceObjectsMediaItem;
typedef struct _AudienceObjectsMediaItemClass AudienceObjectsMediaItemClass;

#define AUDIENCE_TYPE_PLAYBACK_MANAGER (audience_playback_manager_get_type ())
#define AUDIENCE_PLAYBACK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_PLAYBACK_MANAGER, AudiencePlaybackManager))
#define AUDIENCE_PLAYBACK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_PLAYBACK_MANAGER, AudiencePlaybackManagerClass))
#define AUDIENCE_IS_PLAYBACK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_PLAYBACK_MANAGER))
#define AUDIENCE_IS_PLAYBACK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_PLAYBACK_MANAGER))
#define AUDIENCE_PLAYBACK_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_PLAYBACK_MANAGER, AudiencePlaybackManagerClass))

typedef struct _AudiencePlaybackManager AudiencePlaybackManager;
typedef struct _AudiencePlaybackManagerClass AudiencePlaybackManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define AUDIENCE_TYPE_WINDOW (audience_window_get_type ())
#define AUDIENCE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_WINDOW, AudienceWindow))
#define AUDIENCE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_WINDOW, AudienceWindowClass))
#define AUDIENCE_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_WINDOW))
#define AUDIENCE_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_WINDOW))
#define AUDIENCE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_WINDOW, AudienceWindowClass))

typedef struct _AudienceWindow AudienceWindow;
typedef struct _AudienceWindowClass AudienceWindowClass;

#define AUDIENCE_TYPE_APP (audience_app_get_type ())
#define AUDIENCE_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_APP, AudienceApp))
#define AUDIENCE_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_APP, AudienceAppClass))
#define AUDIENCE_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_APP))
#define AUDIENCE_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_APP))
#define AUDIENCE_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_APP, AudienceAppClass))

typedef struct _AudienceApp AudienceApp;
typedef struct _AudienceAppClass AudienceAppClass;
typedef struct _AudienceAppPrivate AudienceAppPrivate;
typedef enum  {
	AUDIENCE_WINDOW_NAVIGATION_PAGE_WELCOME,
	AUDIENCE_WINDOW_NAVIGATION_PAGE_LIBRARY,
	AUDIENCE_WINDOW_NAVIGATION_PAGE_EPISODES
} AudienceWindowNavigationPage;

#define AUDIENCE_WINDOW_TYPE_NAVIGATION_PAGE (audience_window_navigation_page_get_type ())

#define AUDIENCE_TYPE_HEADER_BAR (audience_header_bar_get_type ())
#define AUDIENCE_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_HEADER_BAR, AudienceHeaderBar))
#define AUDIENCE_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_HEADER_BAR, AudienceHeaderBarClass))
#define AUDIENCE_IS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_HEADER_BAR))
#define AUDIENCE_IS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_HEADER_BAR))
#define AUDIENCE_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_HEADER_BAR, AudienceHeaderBarClass))

typedef struct _AudienceHeaderBar AudienceHeaderBar;
typedef struct _AudienceHeaderBarClass AudienceHeaderBarClass;
typedef enum  {
	AUDIENCE_LIBRARY_ITEM_STYLE_THUMBNAIL,
	AUDIENCE_LIBRARY_ITEM_STYLE_ROW
} AudienceLibraryItemStyle;

#define AUDIENCE_LIBRARY_ITEM_TYPE_STYLE (audience_library_item_style_get_type ())

#define AUDIENCE_TYPE_LIBRARY_ITEM (audience_library_item_get_type ())
#define AUDIENCE_LIBRARY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItem))
#define AUDIENCE_LIBRARY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItemClass))
#define AUDIENCE_IS_LIBRARY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_LIBRARY_ITEM))
#define AUDIENCE_IS_LIBRARY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_LIBRARY_ITEM))
#define AUDIENCE_LIBRARY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItemClass))

typedef struct _AudienceLibraryItem AudienceLibraryItem;
typedef struct _AudienceLibraryItemClass AudienceLibraryItemClass;

struct _AudienceEpisodesPage {
	AdwNavigationPage parent_instance;
	AudienceEpisodesPagePrivate * priv;
};

struct _AudienceEpisodesPageClass {
	AdwNavigationPageClass parent_class;
};

struct _AudienceEpisodesPagePrivate {
	GtkPicture* poster;
	GtkFilterListModel* filter_model;
	GtkSearchEntry* search_entry;
	GtkListView* view_episodes;
	GranitePlaceholder* alert_view;
};

struct _AudienceApp {
	GtkApplication parent_instance;
	AudienceAppPrivate * priv;
	AudienceWindow* mainwindow;
	GVolumeMonitor* monitor;
};

struct _AudienceAppClass {
	GtkApplicationClass parent_class;
};

static gint AudienceEpisodesPage_private_offset;
static gpointer audience_episodes_page_parent_class = NULL;
VALA_EXTERN GSettings* audience_settings;

VALA_EXTERN GType audience_episodes_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceEpisodesPage, g_object_unref)
VALA_EXTERN void audience_episodes_page_search (AudienceEpisodesPage* self);
VALA_EXTERN GType audience_objects_media_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceObjectsMediaItem, g_object_unref)
VALA_EXTERN void audience_episodes_page_set_show (AudienceEpisodesPage* self,
                                      AudienceObjectsMediaItem* item);
VALA_EXTERN GListStore* audience_objects_media_item_get_children (AudienceObjectsMediaItem* self);
VALA_EXTERN GdkPixbuf* audience_objects_media_item_get_poster (AudienceObjectsMediaItem* self);
static void audience_episodes_page_play_video (AudienceEpisodesPage* self,
                                        guint position);
VALA_EXTERN const gchar* audience_objects_media_item_get_uri (AudienceObjectsMediaItem* self);
static void _vala_array_add11 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
VALA_EXTERN GType audience_playback_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudiencePlaybackManager, g_object_unref)
VALA_EXTERN AudiencePlaybackManager* audience_playback_manager_get_default (void);
VALA_EXTERN void audience_playback_manager_clear_playlist (AudiencePlaybackManager* self,
                                               gboolean should_stop);
VALA_EXTERN void audience_playback_manager_append_to_playlist (AudiencePlaybackManager* self,
                                                   gchar** uris,
                                                   gint uris_length1);
VALA_EXTERN GType audience_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceWindow, g_object_unref)
VALA_EXTERN GType audience_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceApp, g_object_unref)
VALA_EXTERN AudienceApp* audience_app_get_instance (void);
VALA_EXTERN GType audience_window_navigation_page_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void audience_window_play_file (AudienceWindow* self,
                                const gchar* uri,
                                AudienceWindowNavigationPage origin,
                                gboolean from_beginning);
static void audience_episodes_page_filter (AudienceEpisodesPage* self);
static gboolean audience_episodes_page_episodes_filter_func (AudienceEpisodesPage* self,
                                                      GObject* obj);
VALA_EXTERN const gchar* audience_objects_media_item_get_title (AudienceObjectsMediaItem* self);
VALA_EXTERN AudienceEpisodesPage* audience_episodes_page_new (void);
VALA_EXTERN AudienceEpisodesPage* audience_episodes_page_construct (GType object_type);
static GObject * audience_episodes_page_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
VALA_EXTERN GType audience_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceHeaderBar, g_object_unref)
VALA_EXTERN AudienceHeaderBar* audience_header_bar_new (void);
VALA_EXTERN AudienceHeaderBar* audience_header_bar_construct (GType object_type);
VALA_EXTERN GtkHeaderBar* audience_header_bar_get_header_bar (AudienceHeaderBar* self);
static gboolean _audience_episodes_page_episodes_filter_func_gtk_custom_filter_func (GObject* item,
                                                                              gpointer self);
static void _audience_episodes_page___lambda63_ (AudienceEpisodesPage* self,
                                          GObject* obj);
VALA_EXTERN GType audience_library_item_style_get_type (void) G_GNUC_CONST ;
VALA_EXTERN AudienceLibraryItem* audience_library_item_new (AudienceLibraryItemStyle style);
VALA_EXTERN AudienceLibraryItem* audience_library_item_construct (GType object_type,
                                                      AudienceLibraryItemStyle style);
VALA_EXTERN GType audience_library_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceLibraryItem, g_object_unref)
static void __audience_episodes_page___lambda63__gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                                              GObject* object,
                                                                              gpointer self);
static void _audience_episodes_page___lambda64_ (AudienceEpisodesPage* self,
                                          GObject* obj);
VALA_EXTERN void audience_library_item_bind (AudienceLibraryItem* self,
                                 AudienceObjectsMediaItem* item);
static void __audience_episodes_page___lambda64__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                                             GObject* object,
                                                                             gpointer self);
static void _audience_episodes_page_play_video_gtk_list_view_activate (GtkListView* _sender,
                                                                guint position,
                                                                gpointer self);
static void _audience_episodes_page_filter_gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                     gpointer self);
static gboolean _audience_episodes_page___lambda65_ (AudienceEpisodesPage* self,
                                              guint keyval);
static gboolean __audience_episodes_page___lambda65__gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                                    guint keyval,
                                                                                    guint keycode,
                                                                                    GdkModifierType state,
                                                                                    gpointer self);
static void audience_episodes_page_finalize (GObject * obj);
static GType audience_episodes_page_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
audience_episodes_page_get_instance_private (AudienceEpisodesPage* self)
{
	return G_STRUCT_MEMBER_P (self, AudienceEpisodesPage_private_offset);
}

void
audience_episodes_page_search (AudienceEpisodesPage* self)
{
	GtkSearchEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->search_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
}

void
audience_episodes_page_set_show (AudienceEpisodesPage* self,
                                 AudienceObjectsMediaItem* item)
{
	GtkFilterListModel* _tmp0_;
	GListStore* _tmp1_;
	GListStore* _tmp2_;
	GtkPicture* _tmp3_;
	GdkPixbuf* _tmp4_;
	GdkPixbuf* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = self->priv->filter_model;
	_tmp1_ = audience_objects_media_item_get_children (item);
	_tmp2_ = _tmp1_;
	gtk_filter_list_model_set_model (_tmp0_, (GListModel*) _tmp2_);
	_tmp3_ = self->priv->poster;
	_tmp4_ = audience_objects_media_item_get_poster (item);
	_tmp5_ = _tmp4_;
	gtk_picture_set_pixbuf (_tmp3_, _tmp5_);
}

static void
_vala_array_add11 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
audience_episodes_page_play_video (AudienceEpisodesPage* self,
                                   guint position)
{
	AudienceObjectsMediaItem* video = NULL;
	GtkFilterListModel* _tmp0_;
	GObject* _tmp1_;
	gchar** videos = NULL;
	AudienceObjectsMediaItem* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gint videos_length1;
	gint _videos_size_;
	GSettings* _tmp7_;
	AudiencePlaybackManager* playback_manager = NULL;
	AudiencePlaybackManager* _tmp18_;
	AudiencePlaybackManager* _tmp19_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	gboolean from_beginning = FALSE;
	AudienceObjectsMediaItem* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	GSettings* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gboolean _tmp27_;
	AudienceWindow* window = NULL;
	AudienceApp* _tmp28_;
	AudienceApp* _tmp29_;
	AudienceWindow* _tmp30_;
	AudienceWindow* _tmp31_;
	AudienceWindow* _tmp32_;
	AudienceObjectsMediaItem* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->filter_model;
	_tmp1_ = g_list_model_get_item ((GListModel*) _tmp0_, position);
	video = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM, AudienceObjectsMediaItem);
	_tmp2_ = video;
	_tmp3_ = audience_objects_media_item_get_uri (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = g_new0 (gchar*, 1 + 1);
	_tmp6_[0] = _tmp5_;
	videos = _tmp6_;
	videos_length1 = 1;
	_videos_size_ = videos_length1;
	_tmp7_ = audience_settings;
	if (g_settings_get_boolean (_tmp7_, "autoqueue-next")) {
		{
			guint _tmp8_;
			gboolean _tmp9_ = FALSE;
			_tmp8_ = position;
			position = _tmp8_ + 1;
			_tmp9_ = TRUE;
			while (TRUE) {
				GtkFilterListModel* _tmp11_;
				GtkFilterListModel* _tmp12_;
				GObject* _tmp13_;
				AudienceObjectsMediaItem* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				if (!_tmp9_) {
					guint _tmp10_;
					_tmp10_ = position;
					position = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp11_ = self->priv->filter_model;
				if (!(position < g_list_model_get_n_items ((GListModel*) _tmp11_))) {
					break;
				}
				_tmp12_ = self->priv->filter_model;
				_tmp13_ = g_list_model_get_item ((GListModel*) _tmp12_, position);
				_tmp14_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM, AudienceObjectsMediaItem);
				_tmp15_ = audience_objects_media_item_get_uri (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = g_strdup (_tmp16_);
				_vala_array_add11 (&videos, &videos_length1, &_videos_size_, _tmp17_);
				_g_object_unref0 (_tmp14_);
			}
		}
	}
	_tmp18_ = audience_playback_manager_get_default ();
	_tmp19_ = _g_object_ref0 (_tmp18_);
	playback_manager = _tmp19_;
	audience_playback_manager_clear_playlist (playback_manager, TRUE);
	_tmp20_ = videos;
	_tmp20__length1 = videos_length1;
	audience_playback_manager_append_to_playlist (playback_manager, _tmp20_, (gint) _tmp20__length1);
	_tmp21_ = video;
	_tmp22_ = audience_objects_media_item_get_uri (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = audience_settings;
	_tmp25_ = g_settings_get_string (_tmp24_, "current-video");
	_tmp26_ = _tmp25_;
	_tmp27_ = g_strcmp0 (_tmp23_, _tmp26_) != 0;
	_g_free0 (_tmp26_);
	from_beginning = _tmp27_;
	_tmp28_ = audience_app_get_instance ();
	_tmp29_ = _tmp28_;
	_tmp30_ = _tmp29_->mainwindow;
	_tmp31_ = _g_object_ref0 (_tmp30_);
	_tmp32_ = _tmp31_;
	_g_object_unref0 (_tmp29_);
	window = _tmp32_;
	_tmp33_ = video;
	_tmp34_ = audience_objects_media_item_get_uri (_tmp33_);
	_tmp35_ = _tmp34_;
	audience_window_play_file (window, _tmp35_, AUDIENCE_WINDOW_NAVIGATION_PAGE_EPISODES, from_beginning);
	_g_object_unref0 (window);
	_g_object_unref0 (playback_manager);
	videos = (_vala_array_free (videos, videos_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (video);
}

static void
audience_episodes_page_filter (AudienceEpisodesPage* self)
{
	GtkFilterListModel* _tmp0_;
	GListModel* _tmp1_;
	GListModel* _tmp2_;
	GtkFilterListModel* _tmp3_;
	GListModel* _tmp4_;
	GListModel* _tmp5_;
	GtkFilterListModel* _tmp6_;
	GListModel* _tmp7_;
	GListModel* _tmp8_;
	GtkFilterListModel* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->filter_model;
	_tmp1_ = gtk_filter_list_model_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->filter_model;
	_tmp4_ = gtk_filter_list_model_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->filter_model;
	_tmp7_ = gtk_filter_list_model_get_model (_tmp6_);
	_tmp8_ = _tmp7_;
	g_list_model_items_changed (_tmp2_, (guint) 0, g_list_model_get_n_items (_tmp5_), g_list_model_get_n_items (_tmp8_));
	_tmp9_ = self->priv->filter_model;
	if (g_list_model_get_n_items ((GListModel*) _tmp9_) == ((guint) 0)) {
		GranitePlaceholder* _tmp10_;
		GtkSearchEntry* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		GranitePlaceholder* _tmp16_;
		_tmp10_ = self->priv->alert_view;
		_tmp11_ = self->priv->search_entry;
		_tmp12_ = gtk_editable_get_text ((GtkEditable*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strdup_printf (_ ("No Results for “%s”"), _tmp13_);
		_tmp15_ = _tmp14_;
		granite_placeholder_set_title (_tmp10_, _tmp15_);
		_g_free0 (_tmp15_);
		_tmp16_ = self->priv->alert_view;
		gtk_widget_set_visible ((GtkWidget*) _tmp16_, TRUE);
	} else {
		GranitePlaceholder* _tmp17_;
		_tmp17_ = self->priv->alert_view;
		gtk_widget_set_visible ((GtkWidget*) _tmp17_, FALSE);
	}
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
audience_episodes_page_episodes_filter_func (AudienceEpisodesPage* self,
                                             GObject* obj)
{
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gchar** filter_elements = NULL;
	GtkSearchEntry* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint filter_elements_length1;
	gint _filter_elements_size_;
	gchar* video_title = NULL;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (obj != NULL, FALSE);
	_tmp0_ = self->priv->search_entry;
	_tmp1_ = gtk_editable_get_text ((GtkEditable*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		result = TRUE;
		return result;
	}
	_tmp5_ = self->priv->search_entry;
	_tmp6_ = gtk_editable_get_text ((GtkEditable*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, " ", 0);
	filter_elements = _tmp9_;
	filter_elements_length1 = _vala_array_length (_tmp8_);
	_filter_elements_size_ = filter_elements_length1;
	_tmp10_ = audience_objects_media_item_get_title (G_TYPE_CHECK_INSTANCE_CAST (obj, AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM, AudienceObjectsMediaItem));
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup (_tmp11_);
	video_title = _tmp12_;
	_tmp13_ = filter_elements;
	_tmp13__length1 = filter_elements_length1;
	{
		gchar** filter_element_collection = NULL;
		gint filter_element_collection_length1 = 0;
		gint _filter_element_collection_size_ = 0;
		gint filter_element_it = 0;
		filter_element_collection = _tmp13_;
		filter_element_collection_length1 = _tmp13__length1;
		for (filter_element_it = 0; filter_element_it < filter_element_collection_length1; filter_element_it = filter_element_it + 1) {
			gchar* _tmp14_;
			gchar* filter_element = NULL;
			_tmp14_ = g_strdup (filter_element_collection[filter_element_it]);
			filter_element = _tmp14_;
			{
				const gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gboolean _tmp21_;
				_tmp15_ = video_title;
				_tmp16_ = g_utf8_strdown (_tmp15_, (gssize) -1);
				_tmp17_ = _tmp16_;
				_tmp18_ = filter_element;
				_tmp19_ = g_utf8_strdown (_tmp18_, (gssize) -1);
				_tmp20_ = _tmp19_;
				_tmp21_ = !string_contains (_tmp17_, _tmp20_);
				_g_free0 (_tmp20_);
				_g_free0 (_tmp17_);
				if (_tmp21_) {
					result = FALSE;
					_g_free0 (filter_element);
					_g_free0 (video_title);
					filter_elements = (_vala_array_free (filter_elements, filter_elements_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_g_free0 (filter_element);
			}
		}
	}
	result = TRUE;
	_g_free0 (video_title);
	filter_elements = (_vala_array_free (filter_elements, filter_elements_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

AudienceEpisodesPage*
audience_episodes_page_construct (GType object_type)
{
	AudienceEpisodesPage * self = NULL;
	self = (AudienceEpisodesPage*) g_object_new (object_type, NULL);
	return self;
}

AudienceEpisodesPage*
audience_episodes_page_new (void)
{
	return audience_episodes_page_construct (AUDIENCE_TYPE_EPISODES_PAGE);
}

static gboolean
_audience_episodes_page_episodes_filter_func_gtk_custom_filter_func (GObject* item,
                                                                     gpointer self)
{
	gboolean result;
	result = audience_episodes_page_episodes_filter_func ((AudienceEpisodesPage*) self, item);
	return result;
}

static void
_audience_episodes_page___lambda63_ (AudienceEpisodesPage* self,
                                     GObject* obj)
{
	GtkListItem* item = NULL;
	GtkListItem* _tmp0_;
	GtkListItem* _tmp1_;
	AudienceLibraryItem* _tmp2_;
	AudienceLibraryItem* _tmp3_;
	g_return_if_fail (obj != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (obj, gtk_list_item_get_type (), GtkListItem));
	item = _tmp0_;
	_tmp1_ = item;
	_tmp2_ = audience_library_item_new (AUDIENCE_LIBRARY_ITEM_STYLE_ROW);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	gtk_list_item_set_child (_tmp1_, (GtkWidget*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (item);
}

static void
__audience_episodes_page___lambda63__gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                                         GObject* object,
                                                                         gpointer self)
{
	_audience_episodes_page___lambda63_ ((AudienceEpisodesPage*) self, object);
}

static void
_audience_episodes_page___lambda64_ (AudienceEpisodesPage* self,
                                     GObject* obj)
{
	GtkListItem* item = NULL;
	GtkListItem* _tmp0_;
	GtkListItem* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GtkListItem* _tmp4_;
	GObject* _tmp5_;
	GObject* _tmp6_;
	g_return_if_fail (obj != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (obj, gtk_list_item_get_type (), GtkListItem));
	item = _tmp0_;
	_tmp1_ = item;
	_tmp2_ = gtk_list_item_get_child (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = item;
	_tmp5_ = gtk_list_item_get_item (_tmp4_);
	_tmp6_ = _tmp5_;
	audience_library_item_bind (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItem), G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM, AudienceObjectsMediaItem));
	_g_object_unref0 (item);
}

static void
__audience_episodes_page___lambda64__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                                        GObject* object,
                                                                        gpointer self)
{
	_audience_episodes_page___lambda64_ ((AudienceEpisodesPage*) self, object);
}

static void
_audience_episodes_page_play_video_gtk_list_view_activate (GtkListView* _sender,
                                                           guint position,
                                                           gpointer self)
{
	audience_episodes_page_play_video ((AudienceEpisodesPage*) self, position);
}

static void
_audience_episodes_page_filter_gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                gpointer self)
{
	audience_episodes_page_filter ((AudienceEpisodesPage*) self);
}

static gboolean
_audience_episodes_page___lambda65_ (AudienceEpisodesPage* self,
                                     guint keyval)
{
	gboolean result;
	if (keyval == GDK_KEY_Escape) {
		GtkSearchEntry* _tmp0_;
		_tmp0_ = self->priv->search_entry;
		gtk_editable_set_text ((GtkEditable*) _tmp0_, "");
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
__audience_episodes_page___lambda65__gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                           guint keyval,
                                                                           guint keycode,
                                                                           GdkModifierType state,
                                                                           gpointer self)
{
	gboolean result;
	result = _audience_episodes_page___lambda65_ ((AudienceEpisodesPage*) self, keyval);
	return result;
}

static GObject *
audience_episodes_page_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AudienceEpisodesPage * self;
	gchar* _tmp0_;
	GtkSearchEntry* _tmp1_ = NULL;
	GraniteModeSwitch* autoqueue_next = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GraniteModeSwitch* _tmp4_ = NULL;
	GSettings* _tmp5_;
	GraniteModeSwitch* _tmp6_;
	AudienceHeaderBar* header_bar = NULL;
	AudienceHeaderBar* _tmp7_;
	AudienceHeaderBar* _tmp8_;
	GtkHeaderBar* _tmp9_;
	GtkHeaderBar* _tmp10_;
	GtkSearchEntry* _tmp11_;
	AudienceHeaderBar* _tmp12_;
	GtkHeaderBar* _tmp13_;
	GtkHeaderBar* _tmp14_;
	GraniteModeSwitch* _tmp15_;
	GtkPicture* _tmp16_ = NULL;
	GtkPicture* _tmp17_;
	GtkCustomFilter* _tmp18_;
	GtkFilterListModel* _tmp19_;
	GtkNoSelection* selection_model = NULL;
	GtkFilterListModel* _tmp20_;
	GListModel* _tmp21_;
	GtkNoSelection* _tmp22_;
	GtkSignalListItemFactory* factory = NULL;
	GtkSignalListItemFactory* _tmp23_;
	GtkNoSelection* _tmp24_;
	GtkSelectionModel* _tmp25_;
	GtkSignalListItemFactory* _tmp26_;
	GtkListItemFactory* _tmp27_;
	GtkListView* _tmp28_ = NULL;
	GtkListView* _tmp29_;
	GtkScrolledWindow* scrolled_window = NULL;
	GtkListView* _tmp30_;
	GtkWidget* _tmp31_;
	GtkScrolledWindow* _tmp32_ = NULL;
	gchar* _tmp33_;
	GThemedIcon* _tmp34_;
	GranitePlaceholder* _tmp35_ = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp36_ = NULL;
	GtkGrid* _tmp37_;
	GtkPicture* _tmp38_;
	GtkGrid* _tmp39_;
	GtkScrolledWindow* _tmp40_;
	GtkGrid* _tmp41_;
	GranitePlaceholder* _tmp42_;
	GtkBox* box = NULL;
	GtkBox* _tmp43_;
	GtkBox* _tmp44_;
	AudienceHeaderBar* _tmp45_;
	GtkBox* _tmp46_;
	GtkGrid* _tmp47_;
	GtkBox* _tmp48_;
	GtkSignalListItemFactory* _tmp49_;
	GtkSignalListItemFactory* _tmp50_;
	GtkListView* _tmp51_;
	GtkSearchEntry* _tmp52_;
	GtkEventControllerKey* search_entry_key_controller = NULL;
	GtkEventControllerKey* _tmp53_;
	GtkSearchEntry* _tmp54_;
	GtkEventControllerKey* _tmp55_;
	GtkEventController* _tmp56_;
	GtkEventControllerKey* _tmp57_;
	parent_class = G_OBJECT_CLASS (audience_episodes_page_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AUDIENCE_TYPE_EPISODES_PAGE, AudienceEpisodesPage);
	_tmp0_ = g_strdup (_ ("Search Videos"));
	_tmp1_ = (GtkSearchEntry*) gtk_search_entry_new ();
	g_object_set (_tmp1_, "placeholder-text", _tmp0_, NULL);
	_g_free0 (_tmp0_);
	gtk_widget_set_valign ((GtkWidget*) _tmp1_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->search_entry);
	self->priv->search_entry = _tmp1_;
	_tmp2_ = g_strdup (_ ("Play one video"));
	_tmp3_ = g_strdup (_ ("Automatically play next videos"));
	_tmp4_ = granite_mode_switch_new_from_icon_name ("media-playlist-repeat-one-symbolic", "media-playlist-consecutive-symbolic");
	granite_mode_switch_set_primary_icon_tooltip_text (_tmp4_, _tmp2_);
	_g_free0 (_tmp2_);
	granite_mode_switch_set_secondary_icon_tooltip_text (_tmp4_, _tmp3_);
	_g_free0 (_tmp3_);
	gtk_widget_set_valign ((GtkWidget*) _tmp4_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp4_);
	autoqueue_next = _tmp4_;
	_tmp5_ = audience_settings;
	_tmp6_ = autoqueue_next;
	g_settings_bind (_tmp5_, "autoqueue-next", (GObject*) _tmp6_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp7_ = audience_header_bar_new ();
	g_object_ref_sink (_tmp7_);
	header_bar = _tmp7_;
	_tmp8_ = header_bar;
	_tmp9_ = audience_header_bar_get_header_bar (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->search_entry;
	gtk_header_bar_pack_end (_tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = header_bar;
	_tmp13_ = audience_header_bar_get_header_bar (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = autoqueue_next;
	gtk_header_bar_pack_end (_tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = (GtkPicture*) gtk_picture_new ();
	g_object_set ((GtkWidget*) _tmp16_, "height-request", AUDIENCE_SERVICES_POSTER_HEIGHT, NULL);
	g_object_set ((GtkWidget*) _tmp16_, "width-request", AUDIENCE_SERVICES_POSTER_WIDTH, NULL);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp16_, 24);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp16_, 24);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp16_, 24);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp16_, 0);
	gtk_widget_set_valign ((GtkWidget*) _tmp16_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->poster);
	self->priv->poster = _tmp16_;
	_tmp17_ = self->priv->poster;
	gtk_widget_add_css_class ((GtkWidget*) _tmp17_, GRANITE_STYLE_CLASS_CARD);
	_tmp18_ = gtk_custom_filter_new (_audience_episodes_page_episodes_filter_func_gtk_custom_filter_func, g_object_ref (self), g_object_unref);
	_tmp19_ = gtk_filter_list_model_new (NULL, (GtkFilter*) _tmp18_);
	_g_object_unref0 (self->priv->filter_model);
	self->priv->filter_model = _tmp19_;
	_tmp20_ = self->priv->filter_model;
	_tmp21_ = _g_object_ref0 ((GListModel*) _tmp20_);
	_tmp22_ = gtk_no_selection_new (_tmp21_);
	selection_model = _tmp22_;
	_tmp23_ = (GtkSignalListItemFactory*) gtk_signal_list_item_factory_new ();
	factory = _tmp23_;
	_tmp24_ = selection_model;
	_tmp25_ = _g_object_ref0 ((GtkSelectionModel*) _tmp24_);
	_tmp26_ = factory;
	_tmp27_ = _g_object_ref0 ((GtkListItemFactory*) _tmp26_);
	_tmp28_ = (GtkListView*) gtk_list_view_new (_tmp25_, _tmp27_);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp28_, 24);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp28_, 24);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp28_, 24);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp28_, 24);
	gtk_list_view_set_single_click_activate (_tmp28_, TRUE);
	gtk_widget_set_valign ((GtkWidget*) _tmp28_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->priv->view_episodes);
	self->priv->view_episodes = _tmp28_;
	_tmp29_ = self->priv->view_episodes;
	gtk_widget_add_css_class ((GtkWidget*) _tmp29_, GRANITE_STYLE_CLASS_BACKGROUND);
	_tmp30_ = self->priv->view_episodes;
	_tmp31_ = _g_object_ref0 ((GtkWidget*) _tmp30_);
	_tmp32_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp32_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp32_, TRUE);
	gtk_scrolled_window_set_child (_tmp32_, _tmp31_);
	_g_object_unref0 (_tmp31_);
	g_object_ref_sink (_tmp32_);
	scrolled_window = _tmp32_;
	_tmp33_ = g_strdup (_ ("Try changing search terms."));
	_tmp34_ = (GThemedIcon*) g_themed_icon_new ("edit-find-symbolic");
	_tmp35_ = granite_placeholder_new ("");
	granite_placeholder_set_description (_tmp35_, _tmp33_);
	_g_free0 (_tmp33_);
	granite_placeholder_set_icon (_tmp35_, (GIcon*) _tmp34_);
	_g_object_unref0 (_tmp34_);
	gtk_widget_set_visible ((GtkWidget*) _tmp35_, FALSE);
	g_object_ref_sink (_tmp35_);
	_g_object_unref0 (self->priv->alert_view);
	self->priv->alert_view = _tmp35_;
	_tmp36_ = (GtkGrid*) gtk_grid_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp36_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp36_, TRUE);
	g_object_ref_sink (_tmp36_);
	grid = _tmp36_;
	_tmp37_ = grid;
	_tmp38_ = self->priv->poster;
	gtk_grid_attach (_tmp37_, (GtkWidget*) _tmp38_, 0, 1, 1, 1);
	_tmp39_ = grid;
	_tmp40_ = scrolled_window;
	gtk_grid_attach (_tmp39_, (GtkWidget*) _tmp40_, 1, 1, 1, 1);
	_tmp41_ = grid;
	_tmp42_ = self->priv->alert_view;
	gtk_grid_attach (_tmp41_, (GtkWidget*) _tmp42_, 1, 1, 1, 1);
	_tmp43_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp43_);
	box = _tmp43_;
	_tmp44_ = box;
	_tmp45_ = header_bar;
	gtk_box_append (_tmp44_, (GtkWidget*) _tmp45_);
	_tmp46_ = box;
	_tmp47_ = grid;
	gtk_box_append (_tmp46_, (GtkWidget*) _tmp47_);
	_tmp48_ = box;
	adw_navigation_page_set_child ((AdwNavigationPage*) self, (GtkWidget*) _tmp48_);
	adw_navigation_page_set_title ((AdwNavigationPage*) self, _ ("Episodes"));
	_tmp49_ = factory;
	g_signal_connect_object (_tmp49_, "setup", (GCallback) __audience_episodes_page___lambda63__gtk_signal_list_item_factory_setup, self, 0);
	_tmp50_ = factory;
	g_signal_connect_object (_tmp50_, "bind", (GCallback) __audience_episodes_page___lambda64__gtk_signal_list_item_factory_bind, self, 0);
	_tmp51_ = self->priv->view_episodes;
	g_signal_connect_object (_tmp51_, "activate", (GCallback) _audience_episodes_page_play_video_gtk_list_view_activate, self, 0);
	_tmp52_ = self->priv->search_entry;
	g_signal_connect_object (_tmp52_, "search-changed", (GCallback) _audience_episodes_page_filter_gtk_search_entry_search_changed, self, 0);
	_tmp53_ = (GtkEventControllerKey*) gtk_event_controller_key_new ();
	search_entry_key_controller = _tmp53_;
	_tmp54_ = self->priv->search_entry;
	_tmp55_ = search_entry_key_controller;
	_tmp56_ = _g_object_ref0 ((GtkEventController*) _tmp55_);
	gtk_widget_add_controller ((GtkWidget*) _tmp54_, _tmp56_);
	_tmp57_ = search_entry_key_controller;
	g_signal_connect_object (_tmp57_, "key-pressed", (GCallback) __audience_episodes_page___lambda65__gtk_event_controller_key_key_pressed, self, 0);
	_g_object_unref0 (search_entry_key_controller);
	_g_object_unref0 (box);
	_g_object_unref0 (grid);
	_g_object_unref0 (scrolled_window);
	_g_object_unref0 (factory);
	_g_object_unref0 (selection_model);
	_g_object_unref0 (header_bar);
	_g_object_unref0 (autoqueue_next);
	return obj;
}

static void
audience_episodes_page_class_init (AudienceEpisodesPageClass * klass,
                                   gpointer klass_data)
{
	audience_episodes_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AudienceEpisodesPage_private_offset);
	G_OBJECT_CLASS (klass)->constructor = audience_episodes_page_constructor;
	G_OBJECT_CLASS (klass)->finalize = audience_episodes_page_finalize;
}

static void
audience_episodes_page_instance_init (AudienceEpisodesPage * self,
                                      gpointer klass)
{
	self->priv = audience_episodes_page_get_instance_private (self);
}

static void
audience_episodes_page_finalize (GObject * obj)
{
	AudienceEpisodesPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AUDIENCE_TYPE_EPISODES_PAGE, AudienceEpisodesPage);
	_g_object_unref0 (self->priv->poster);
	_g_object_unref0 (self->priv->filter_model);
	_g_object_unref0 (self->priv->search_entry);
	_g_object_unref0 (self->priv->view_episodes);
	_g_object_unref0 (self->priv->alert_view);
	G_OBJECT_CLASS (audience_episodes_page_parent_class)->finalize (obj);
}

static GType
audience_episodes_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AudienceEpisodesPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) audience_episodes_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AudienceEpisodesPage), 0, (GInstanceInitFunc) audience_episodes_page_instance_init, NULL };
	GType audience_episodes_page_type_id;
	audience_episodes_page_type_id = g_type_register_static (adw_navigation_page_get_type (), "AudienceEpisodesPage", &g_define_type_info, 0);
	AudienceEpisodesPage_private_offset = g_type_add_instance_private (audience_episodes_page_type_id, sizeof (AudienceEpisodesPagePrivate));
	return audience_episodes_page_type_id;
}

GType
audience_episodes_page_get_type (void)
{
	static volatile gsize audience_episodes_page_type_id__once = 0;
	if (g_once_init_enter (&audience_episodes_page_type_id__once)) {
		GType audience_episodes_page_type_id;
		audience_episodes_page_type_id = audience_episodes_page_get_type_once ();
		g_once_init_leave (&audience_episodes_page_type_id__once, audience_episodes_page_type_id);
	}
	return audience_episodes_page_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

