// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

var (
	protoPoolKeyValue = sync.Pool{
		New: func() any {
			return &otlpcommon.KeyValue{}
		},
	}
)

func NewOrigKeyValue() *otlpcommon.KeyValue {
	if !UseProtoPooling.IsEnabled() {
		return &otlpcommon.KeyValue{}
	}
	return protoPoolKeyValue.Get().(*otlpcommon.KeyValue)
}

func DeleteOrigKeyValue(orig *otlpcommon.KeyValue, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	DeleteOrigAnyValue(&orig.Value, false)

	orig.Reset()
	if nullable {
		protoPoolKeyValue.Put(orig)
	}
}

func CopyOrigKeyValue(dest, src *otlpcommon.KeyValue) {
	// If copying to same object, just return.
	if src == dest {
		return
	}
	dest.Key = src.Key
	CopyOrigAnyValue(&dest.Value, &src.Value)
}

func GenTestOrigKeyValue() *otlpcommon.KeyValue {
	orig := NewOrigKeyValue()
	orig.Key = "test_key"
	orig.Value = *GenTestOrigAnyValue()
	return orig
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigKeyValue(orig *otlpcommon.KeyValue, dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.Key != "" {
		dest.WriteObjectField("key")
		dest.WriteString(orig.Key)
	}
	dest.WriteObjectField("value")
	MarshalJSONOrigAnyValue(&orig.Value, dest)
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigAttribute unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigKeyValue(orig *otlpcommon.KeyValue, iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "key":
			orig.Key = iter.ReadString()
		case "value":
			UnmarshalJSONOrigAnyValue(&orig.Value, iter)
		default:
			iter.Skip()
		}
	}
}

func SizeProtoOrigKeyValue(orig *otlpcommon.KeyValue) int {
	var n int
	var l int
	_ = l
	l = len(orig.Key)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = SizeProtoOrigAnyValue(&orig.Value)
	n += 1 + proto.Sov(uint64(l)) + l
	return n
}

func MarshalProtoOrigKeyValue(orig *otlpcommon.KeyValue, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	l = len(orig.Key)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.Key)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}

	l = MarshalProtoOrigAnyValue(&orig.Value, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x12

	return len(buf) - pos
}

func UnmarshalProtoOrigKeyValue(orig *otlpcommon.KeyValue, buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Key = string(buf[startPos:pos])

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = UnmarshalProtoOrigAnyValue(&orig.Value, buf[startPos:pos])
			if err != nil {
				return err
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}
