
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kpixmapregionselectordialog_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"
#include "ktimecombobox_wrapper.h"

// Argument includes
#include <kpixmapregionselectorwidget.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qimage.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpixmap.h>
#include <qpoint.h>
#include <qrect.h>
#include <qsize.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KPixmapRegionSelectorDialog_Type = nullptr;
static PyTypeObject *Sbk_KPixmapRegionSelectorDialog_TypeF(void)
{
    return _Sbk_KPixmapRegionSelectorDialog_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KPixmapRegionSelectorDialogWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KPixmapRegionSelectorDialogWrapper::KPixmapRegionSelectorDialogWrapper(::QWidget * parent) : KPixmapRegionSelectorDialog(parent)
{
}

void KPixmapRegionSelectorDialogWrapper::accept()
{
    static const char *funcName = "accept";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::accept();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KPixmapRegionSelectorDialog", funcName, gil, pyOverride);
}

void KPixmapRegionSelectorDialogWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, event);
}

void KPixmapRegionSelectorDialogWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, event);
}

void KPixmapRegionSelectorDialogWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, event);
}

void KPixmapRegionSelectorDialogWrapper::closeEvent(::QCloseEvent * arg__1)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::closeEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, arg__1);
}

void KPixmapRegionSelectorDialogWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, signal);
}

void KPixmapRegionSelectorDialogWrapper::contextMenuEvent(::QContextMenuEvent * arg__1)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::contextMenuEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, arg__1);
}

void KPixmapRegionSelectorDialogWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, event);
}

int KPixmapRegionSelectorDialogWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KPixmapRegionSelectorDialog", funcName, gil, pyOverride);
}

void KPixmapRegionSelectorDialogWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, signal);
}

void KPixmapRegionSelectorDialogWrapper::done(int arg__1)
{
    static const char *funcName = "done";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::done(arg__1);
    }
    sbk_o_done("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, arg__1);
}

void KPixmapRegionSelectorDialogWrapper::sbk_o_done(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, int arg__1)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &arg__1)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
        arg__1
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KPixmapRegionSelectorDialogWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, event);
}

void KPixmapRegionSelectorDialogWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, event);
}

void KPixmapRegionSelectorDialogWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, event);
}

void KPixmapRegionSelectorDialogWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, event);
}

void KPixmapRegionSelectorDialogWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, event);
}

bool KPixmapRegionSelectorDialogWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, event);
}

bool KPixmapRegionSelectorDialogWrapper::eventFilter(::QObject * arg__1, ::QEvent * arg__2)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::eventFilter(arg__1, arg__2);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, arg__1, arg__2);
}

int KPixmapRegionSelectorDialogWrapper::exec()
{
    static const char *funcName = "exec";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::exec();
    }
    return sbk_o_exec("KPixmapRegionSelectorDialog", funcName, gil, pyOverride);
}

int KPixmapRegionSelectorDialogWrapper::sbk_o_exec(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return 0;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);

    return cppResult;
}

void KPixmapRegionSelectorDialogWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, event);
}

bool KPixmapRegionSelectorDialogWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, next);
}

void KPixmapRegionSelectorDialogWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, event);
}

bool KPixmapRegionSelectorDialogWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KPixmapRegionSelectorDialog", funcName, gil, pyOverride);
}

int KPixmapRegionSelectorDialogWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, arg__1);
}

void KPixmapRegionSelectorDialogWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, event);
}

void KPixmapRegionSelectorDialogWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, painter);
}

void KPixmapRegionSelectorDialogWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, event);
}

::QVariant KPixmapRegionSelectorDialogWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, arg__1);
}

void KPixmapRegionSelectorDialogWrapper::keyPressEvent(::QKeyEvent * arg__1)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::keyPressEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, arg__1);
}

void KPixmapRegionSelectorDialogWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, event);
}

void KPixmapRegionSelectorDialogWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, event);
}

int KPixmapRegionSelectorDialogWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, arg__1);
}

::QSize KPixmapRegionSelectorDialogWrapper::minimumSizeHint() const
{
    static const char *funcName = "minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KPixmapRegionSelectorDialog", funcName, gil, pyOverride);
}

void KPixmapRegionSelectorDialogWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, event);
}

void KPixmapRegionSelectorDialogWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, event);
}

void KPixmapRegionSelectorDialogWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, event);
}

void KPixmapRegionSelectorDialogWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, event);
}

void KPixmapRegionSelectorDialogWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, event);
}

bool KPixmapRegionSelectorDialogWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, eventType, message, result);
}

void KPixmapRegionSelectorDialogWrapper::open()
{
    static const char *funcName = "open";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::open();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KPixmapRegionSelectorDialog", funcName, gil, pyOverride);
}

::QPaintEngine * KPixmapRegionSelectorDialogWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KPixmapRegionSelectorDialog", funcName, gil, pyOverride);
}

void KPixmapRegionSelectorDialogWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEvent(event);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, event);
}

::QPaintDevice * KPixmapRegionSelectorDialogWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, offset);
}

void KPixmapRegionSelectorDialogWrapper::reject()
{
    static const char *funcName = "reject";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::reject();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KPixmapRegionSelectorDialog", funcName, gil, pyOverride);
}

void KPixmapRegionSelectorDialogWrapper::resizeEvent(::QResizeEvent * arg__1)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::resizeEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, arg__1);
}

void KPixmapRegionSelectorDialogWrapper::setVisible(bool visible)
{
    static const char *funcName = "setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, visible);
}

::QPainter * KPixmapRegionSelectorDialogWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KPixmapRegionSelectorDialog", funcName, gil, pyOverride);
}

void KPixmapRegionSelectorDialogWrapper::showEvent(::QShowEvent * arg__1)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::showEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, arg__1);
}

::QSize KPixmapRegionSelectorDialogWrapper::sizeHint() const
{
    static const char *funcName = "sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[48], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KPixmapRegionSelectorDialog", funcName, gil, pyOverride);
}

void KPixmapRegionSelectorDialogWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[49], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, event);
}

void KPixmapRegionSelectorDialogWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[50], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, event);
}

void KPixmapRegionSelectorDialogWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapRegionSelectorDialog_TypeF(), gil, funcName, m_PyMethodCache[51], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KPixmapRegionSelectorDialog", funcName, gil, pyOverride, event);
}

const QMetaObject *KPixmapRegionSelectorDialogWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KPixmapRegionSelectorDialog::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KPixmapRegionSelectorDialogWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KPixmapRegionSelectorDialog::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KPixmapRegionSelectorDialogWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KPixmapRegionSelectorDialogWrapper *>(this));
    }
    return KPixmapRegionSelectorDialog::qt_metacast(_clname);
}

KPixmapRegionSelectorDialogWrapper::~KPixmapRegionSelectorDialogWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KPixmapRegionSelectorDialog_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KPixmapRegionSelectorDialog_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KPixmapRegionSelectorDialog >()))
        return -1;

    KPixmapRegionSelectorDialogWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KPixmapRegionSelectorDialog", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KPixmapRegionSelectorDialog::KPixmapRegionSelectorDialog(QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // KPixmapRegionSelectorDialog(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KPixmapRegionSelectorDialog(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorDialog_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorDialog_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorDialog_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KPixmapRegionSelectorDialog(QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KPixmapRegionSelectorDialogWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KPixmapRegionSelectorDialogWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KPixmapRegionSelectorDialog >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorDialog_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorDialog_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KPixmapRegionSelectorDialogFunc_adjustRegionSelectorWidgetSizeToFitScreen(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapRegionSelectorDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // adjustRegionSelectorWidgetSizeToFitScreen()
        cppSelf->adjustRegionSelectorWidgetSizeToFitScreen();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPixmapRegionSelectorDialogFunc_getSelectedImage(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 4));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "getSelectedImage", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorDialog_IDX]);

    if (PyArg_ParseTuple(args, "|OOOO:getSelectedImage", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KPixmapRegionSelectorDialog::getSelectedImage(QPixmap,QWidget*=)->QImage
    // 1: static KPixmapRegionSelectorDialog::getSelectedImage(QPixmap,int,int,QWidget*=)->QImage
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // getSelectedImage(QPixmap,QWidget*)
        } else if (numArgs >= 3
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 1; // getSelectedImage(QPixmap,int,int,QWidget*)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[3])))) {
                overloadId = 1; // getSelectedImage(QPixmap,int,int,QWidget*)
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1])))) {
            overloadId = 0; // getSelectedImage(QPixmap,QWidget*)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "getSelectedImage", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorDialog_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // getSelectedImage(const QPixmap &pixmap, QWidget *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 1}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "getSelectedImage", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorDialog_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPixmap cppArg0_local;
            ::QPixmap *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QWidget *cppArg1 = nullptr;
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // getSelectedImage(QPixmap,QWidget*)
                QImage cppResult = ::KPixmapRegionSelectorDialog::getSelectedImage(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QImage_IDX]), &cppResult);
            }
            break;
        }
        case 1: // getSelectedImage(const QPixmap &pixmap, int aspectRatioWidth, int aspectRatioHeight, QWidget *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 3}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[3]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "getSelectedImage", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorDialog_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPixmap cppArg0_local;
            ::QPixmap *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QWidget *cppArg3 = nullptr;
            if (pythonToCpp[3])
                pythonToCpp[3](pyArgs[3], &cppArg3);

            if (Shiboken::Errors::occurred() == nullptr) {
                // getSelectedImage(QPixmap,int,int,QWidget*)
                QImage cppResult = ::KPixmapRegionSelectorDialog::getSelectedImage(*cppArg0, cppArg1, cppArg2, cppArg3);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QImage_IDX]), &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPixmapRegionSelectorDialogFunc_getSelectedRegion(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 4));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "getSelectedRegion", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorDialog_IDX]);

    if (PyArg_ParseTuple(args, "|OOOO:getSelectedRegion", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KPixmapRegionSelectorDialog::getSelectedRegion(QPixmap,QWidget*=)->QRect
    // 1: static KPixmapRegionSelectorDialog::getSelectedRegion(QPixmap,int,int,QWidget*=)->QRect
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // getSelectedRegion(QPixmap,QWidget*)
        } else if (numArgs >= 3
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 1; // getSelectedRegion(QPixmap,int,int,QWidget*)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[3])))) {
                overloadId = 1; // getSelectedRegion(QPixmap,int,int,QWidget*)
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1])))) {
            overloadId = 0; // getSelectedRegion(QPixmap,QWidget*)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "getSelectedRegion", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorDialog_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // getSelectedRegion(const QPixmap &pixmap, QWidget *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 1}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "getSelectedRegion", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorDialog_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPixmap cppArg0_local;
            ::QPixmap *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QWidget *cppArg1 = nullptr;
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // getSelectedRegion(QPixmap,QWidget*)
                QRect cppResult = ::KPixmapRegionSelectorDialog::getSelectedRegion(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QRect_IDX]), &cppResult);
            }
            break;
        }
        case 1: // getSelectedRegion(const QPixmap &pixmap, int aspectRatioWidth, int aspectRatioHeight, QWidget *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 3}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[3]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "getSelectedRegion", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorDialog_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPixmap cppArg0_local;
            ::QPixmap *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QWidget *cppArg3 = nullptr;
            if (pythonToCpp[3])
                pythonToCpp[3](pyArgs[3], &cppArg3);

            if (Shiboken::Errors::occurred() == nullptr) {
                // getSelectedRegion(QPixmap,int,int,QWidget*)
                QRect cppResult = ::KPixmapRegionSelectorDialog::getSelectedRegion(*cppArg0, cppArg1, cppArg2, cppArg3);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QRect_IDX]), &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPixmapRegionSelectorDialogFunc_pixmapRegionSelectorWidget(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapRegionSelectorDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // pixmapRegionSelectorWidget()const
        KPixmapRegionSelectorWidget * cppResult = const_cast<const ::KPixmapRegionSelectorDialog *>(cppSelf)->pixmapRegionSelectorWidget();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KPixmapRegionSelectorDialog_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KPixmapRegionSelectorDialog_methods[] = {
    {"adjustRegionSelectorWidgetSizeToFitScreen", reinterpret_cast<PyCFunction>(Sbk_KPixmapRegionSelectorDialogFunc_adjustRegionSelectorWidgetSizeToFitScreen), METH_NOARGS, nullptr},
    {"getSelectedImage", reinterpret_cast<PyCFunction>(Sbk_KPixmapRegionSelectorDialogFunc_getSelectedImage), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"getSelectedRegion", reinterpret_cast<PyCFunction>(Sbk_KPixmapRegionSelectorDialogFunc_getSelectedRegion), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"pixmapRegionSelectorWidget", reinterpret_cast<PyCFunction>(Sbk_KPixmapRegionSelectorDialogFunc_pixmapRegionSelectorWidget), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KPixmapRegionSelectorDialog_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KPixmapRegionSelectorDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KPixmapRegionSelectorDialogWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KPixmapRegionSelectorDialog_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KPixmapRegionSelectorDialog_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KPixmapRegionSelectorDialogSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KPixmapRegionSelectorDialog *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QDialog_IDX]))
        return static_cast< ::QDialog *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KPixmapRegionSelectorDialog_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KPixmapRegionSelectorDialog_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KPixmapRegionSelectorDialog_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KPixmapRegionSelectorDialog_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KPixmapRegionSelectorDialog_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KPixmapRegionSelectorDialog_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KPixmapRegionSelectorDialog_spec = {
    "1:KWidgetsAddons.KPixmapRegionSelectorDialog",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KPixmapRegionSelectorDialog_slots
};

} //extern "C"

static void *Sbk_KPixmapRegionSelectorDialog_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KPixmapRegionSelectorDialog *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KPixmapRegionSelectorDialog *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KPixmapRegionSelectorDialog *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KPixmapRegionSelectorDialog_PythonToCpp_KPixmapRegionSelectorDialog_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KPixmapRegionSelectorDialog_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KPixmapRegionSelectorDialog_PythonToCpp_KPixmapRegionSelectorDialog_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KPixmapRegionSelectorDialog_TypeF()))
        return KPixmapRegionSelectorDialog_PythonToCpp_KPixmapRegionSelectorDialog_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KPixmapRegionSelectorDialog_PTR_CppToPython_KPixmapRegionSelectorDialog(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KPixmapRegionSelectorDialog *>(const_cast<void *>(cppIn)), Sbk_KPixmapRegionSelectorDialog_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KPixmapRegionSelectorDialog_SignatureStrings[] = {
    "KWidgetsAddons.KPixmapRegionSelectorDialog(self,parent:PySide6.QtWidgets.QWidget=nullptr)",
    "KWidgetsAddons.KPixmapRegionSelectorDialog.adjustRegionSelectorWidgetSizeToFitScreen(self)",
    "1:KWidgetsAddons.KPixmapRegionSelectorDialog.getSelectedImage(pixmap:typing.Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage],parent:PySide6.QtWidgets.QWidget=nullptr)->PySide6.QtGui.QImage",
    "0:KWidgetsAddons.KPixmapRegionSelectorDialog.getSelectedImage(pixmap:typing.Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage],aspectRatioWidth:int,aspectRatioHeight:int,parent:PySide6.QtWidgets.QWidget=nullptr)->PySide6.QtGui.QImage",
    "1:KWidgetsAddons.KPixmapRegionSelectorDialog.getSelectedRegion(pixmap:typing.Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage],parent:PySide6.QtWidgets.QWidget=nullptr)->PySide6.QtCore.QRect",
    "0:KWidgetsAddons.KPixmapRegionSelectorDialog.getSelectedRegion(pixmap:typing.Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage],aspectRatioWidth:int,aspectRatioHeight:int,parent:PySide6.QtWidgets.QWidget=nullptr)->PySide6.QtCore.QRect",
    "KWidgetsAddons.KPixmapRegionSelectorDialog.pixmapRegionSelectorWidget(self)->KWidgetsAddons.KPixmapRegionSelectorWidget",
    nullptr}; // Sentinel
#else
static constexpr size_t KPixmapRegionSelectorDialog_SignatureByteSize = 250;
static constexpr uint8_t KPixmapRegionSelectorDialog_SignatureBytes[250] = {
    0x78, 0xda, 0xc5, 0x53, 0x4d, 0x6b, 0x02, 0x31, 0x14, 0xbc, 0xef, 0xaf, 0xe8, 0x51, 0x41, 0x43,
    0xbd, 0xf4, 0xb0, 0xa0, 0x20, 0x95, 0x6a, 0xd9, 0x8b, 0xbb, 0xdb, 0xd2, 0x83, 0xf4, 0x10, 0x36,
    0xaf, 0xf1, 0x49, 0x4c, 0x42, 0xf2, 0x16, 0xaa, 0xbf, 0xbe, 0xdb, 0xa4, 0xe0, 0x07, 0x1e, 0xd6,
    0x8f, 0xe2, 0x2d, 0xcc, 0x7b, 0x33, 0xcc, 0xbc, 0x21, 0xd9, 0x07, 0x0a, 0x09, 0xe4, 0xc7, 0x42,
    0x18, 0xed, 0x59, 0x36, 0xc7, 0xef, 0x35, 0xb7, 0x05, 0x48, 0x34, 0xba, 0x04, 0x05, 0x15, 0x19,
    0x37, 0x41, 0xae, 0x8c, 0xec, 0x78, 0x50, 0x5f, 0x3d, 0xcb, 0x1d, 0x68, 0x4a, 0xe7, 0x9b, 0x12,
    0x05, 0x3c, 0xb1, 0x9c, 0xfe, 0xf8, 0x2c, 0x8f, 0x8f, 0xa1, 0xae, 0x95, 0xb2, 0xe4, 0xba, 0x49,
    0xd6, 0x5a, 0x99, 0x71, 0xb1, 0xaa, 0x3d, 0x1d, 0x8e, 0x22, 0xbb, 0xc4, 0x2d, 0xbc, 0x99, 0x17,
    0xa4, 0xb2, 0x72, 0x00, 0x3a, 0x78, 0xe8, 0x26, 0x83, 0xf4, 0x0c, 0xf1, 0x5f, 0x95, 0x80, 0x80,
    0x78, 0x5d, 0x73, 0x09, 0x1d, 0x1b, 0x76, 0x53, 0xda, 0x58, 0xd4, 0x92, 0xbd, 0xeb, 0x86, 0xb2,
    0xd8, 0xe5, 0x99, 0xd6, 0xc8, 0xf2, 0x28, 0xd7, 0x7b, 0x38, 0x82, 0x03, 0xff, 0xb3, 0xfd, 0x0d,
    0xfa, 0xa3, 0x53, 0x02, 0xc9, 0xe3, 0x7d, 0xed, 0x73, 0x6f, 0x1b, 0xb9, 0x82, 0x13, 0x9a, 0xc6,
    0x06, 0x2d, 0x53, 0xd4, 0xb4, 0x0f, 0xce, 0x00, 0xe5, 0x92, 0x02, 0x7a, 0x6d, 0xd2, 0x4b, 0x8b,
    0x8a, 0xf3, 0x3b, 0x35, 0xf5, 0x6c, 0x1c, 0xb0, 0xbc, 0x68, 0x8c, 0x5c, 0xdc, 0xd4, 0xad, 0xfc,
    0xff, 0x77, 0x55, 0x7b, 0x51, 0xcf, 0x08, 0x6a, 0x4f, 0x8c, 0x22, 0x3b, 0xfe, 0xcf, 0xfe, 0xa8,
    0x8d, 0x58, 0x5c, 0x49, 0x7e, 0x00, 0xae, 0x0e, 0xab, 0xc2
};
#endif

PyTypeObject *init_KPixmapRegionSelectorDialog(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorDialog_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorDialog_IDX].type;

    Shiboken::AutoDecRef Sbk_KPixmapRegionSelectorDialog_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QDialog_IDX]))));

    _Sbk_KPixmapRegionSelectorDialog_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KPixmapRegionSelectorDialog",
        "KPixmapRegionSelectorDialog*",
        &Sbk_KPixmapRegionSelectorDialog_spec,
        &Shiboken::callCppDestructor< KPixmapRegionSelectorDialog >,
        Sbk_KPixmapRegionSelectorDialog_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = Sbk_KPixmapRegionSelectorDialog_TypeF(); // references _Sbk_KPixmapRegionSelectorDialog_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KPixmapRegionSelectorDialog_SignatureStrings);
#else
    InitSignatureBytes(pyType, KPixmapRegionSelectorDialog_SignatureBytes, KPixmapRegionSelectorDialog_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KPixmapRegionSelectorDialog_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorDialog_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KPixmapRegionSelectorDialog_PythonToCpp_KPixmapRegionSelectorDialog_PTR,
        is_KPixmapRegionSelectorDialog_PythonToCpp_KPixmapRegionSelectorDialog_PTR_Convertible,
        KPixmapRegionSelectorDialog_PTR_CppToPython_KPixmapRegionSelectorDialog);

    Shiboken::Conversions::registerConverterName(converter, "KPixmapRegionSelectorDialog");
    Shiboken::Conversions::registerConverterName(converter, "KPixmapRegionSelectorDialog*");
    Shiboken::Conversions::registerConverterName(converter, "KPixmapRegionSelectorDialog&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KPixmapRegionSelectorDialog).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KPixmapRegionSelectorDialogWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KPixmapRegionSelectorDialog_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KPixmapRegionSelectorDialog_TypeF(), &Sbk_KPixmapRegionSelectorDialogSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KPixmapRegionSelectorDialog_TypeF(), &Sbk_KPixmapRegionSelectorDialog_typeDiscovery);

    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KPixmapRegionSelectorDialog::staticMetaObject, sizeof(KPixmapRegionSelectorDialogWrapper));

    return pyType;
}
