/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, zeromq, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_zeromq_pull_source = R"doc(Receive messages on ZMQ PULL socket and source stream.

This block will connect to a ZMQ PUSH socket, then produce all incoming messages as streaming output.

Constructor Specific Documentation:

Return a shared_ptr to a new instance of gr::zeromq::pull_source.

Args:
    itemsize : Size of a stream item in bytes.
    vlen : Vector length of the input items. Note that one vector is one item.
    address : ZMQ socket address specifier.
    timeout : Receive timeout in milliseconds, default is 100ms, 1us increments.
    pass_tags : Whether source will look for and deserialize tags.
    hwm : High Watermark to configure the socket to (-1 => zmq's default)
    bind : If true this block will bind to the address, otherwise it will connect; the default is to connect)doc";


static const char* __doc_gr_zeromq_pull_source_pull_source_0 = R"doc()doc";


static const char* __doc_gr_zeromq_pull_source_pull_source_1 = R"doc()doc";


static const char* __doc_gr_zeromq_pull_source_make = R"doc(Receive messages on ZMQ PULL socket and source stream.

This block will connect to a ZMQ PUSH socket, then produce all incoming messages as streaming output.

Constructor Specific Documentation:

Return a shared_ptr to a new instance of gr::zeromq::pull_source.

Args:
    itemsize : Size of a stream item in bytes.
    vlen : Vector length of the input items. Note that one vector is one item.
    address : ZMQ socket address specifier.
    timeout : Receive timeout in milliseconds, default is 100ms, 1us increments.
    pass_tags : Whether source will look for and deserialize tags.
    hwm : High Watermark to configure the socket to (-1 => zmq's default)
    bind : If true this block will bind to the address, otherwise it will connect; the default is to connect)doc";


static const char* __doc_gr_zeromq_pull_source_last_endpoint = R"doc(Return a std::string of ZMQ_LAST_ENDPOINT from the underlying ZMQ socket.)doc";
