/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_tagged_stream_mux = R"doc(Combines tagged streams.

Takes N streams as input. Each stream is tagged with packet lengths. Packets are output sequentially from each input stream.


The output signal has a new length tag, which is the sum of all individual length tags. The old length tags are discarded.


All other tags are propagated as expected, i.e. they stay associated with the same input item. There are cases when this behaviour is undesirable. One special case is when a tag at the first element (the head item) of one input port must stay on the head item of the output port. To achieve this, set  to the port that will receive these special tags.

Constructor Specific Documentation:

Make a tagged stream mux block.

Args:
    itemsize : Items size (number of bytes per item)
    lengthtagname : Length tag key
    tag_preserve_head_pos : Preserves the head position of tags on this input port)doc";


static const char* __doc_gr_blocks_tagged_stream_mux_tagged_stream_mux = R"doc()doc";


static const char* __doc_gr_blocks_tagged_stream_mux_make = R"doc(Combines tagged streams.

Takes N streams as input. Each stream is tagged with packet lengths. Packets are output sequentially from each input stream.


The output signal has a new length tag, which is the sum of all individual length tags. The old length tags are discarded.


All other tags are propagated as expected, i.e. they stay associated with the same input item. There are cases when this behaviour is undesirable. One special case is when a tag at the first element (the head item) of one input port must stay on the head item of the output port. To achieve this, set  to the port that will receive these special tags.

Constructor Specific Documentation:

Make a tagged stream mux block.

Args:
    itemsize : Items size (number of bytes per item)
    lengthtagname : Length tag key
    tag_preserve_head_pos : Preserves the head position of tags on this input port)doc";
