/* buttons-conversion.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from buttons-conversion.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <gio/gio.h>
#include "calculator.h"
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_CONVERSION_BUTTON_PANEL (conversion_button_panel_get_type ())
#define CONVERSION_BUTTON_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONVERSION_BUTTON_PANEL, ConversionButtonPanel))
#define CONVERSION_BUTTON_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONVERSION_BUTTON_PANEL, ConversionButtonPanelClass))
#define IS_CONVERSION_BUTTON_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONVERSION_BUTTON_PANEL))
#define IS_CONVERSION_BUTTON_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONVERSION_BUTTON_PANEL))
#define CONVERSION_BUTTON_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONVERSION_BUTTON_PANEL, ConversionButtonPanelClass))

typedef struct _ConversionButtonPanel ConversionButtonPanel;
typedef struct _ConversionButtonPanelClass ConversionButtonPanelClass;
typedef struct _ConversionButtonPanelPrivate ConversionButtonPanelPrivate;

#define TYPE_MATH_CONVERTER (math_converter_get_type ())
#define MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_CONVERTER, MathConverter))
#define MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_CONVERTER, MathConverterClass))
#define IS_MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_CONVERTER))
#define IS_MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_CONVERTER))
#define MATH_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_CONVERTER, MathConverterClass))

typedef struct _MathConverter MathConverter;
typedef struct _MathConverterClass MathConverterClass;
enum  {
	CONVERSION_BUTTON_PANEL_0_PROPERTY,
	CONVERSION_BUTTON_PANEL_NUM_PROPERTIES
};
static GParamSpec* conversion_button_panel_properties[CONVERSION_BUTTON_PANEL_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MATH_BUTTONS (math_buttons_get_type ())
#define MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_BUTTONS, MathButtons))
#define MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_BUTTONS, MathButtonsClass))
#define IS_MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_BUTTONS))
#define IS_MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_BUTTONS))
#define MATH_BUTTONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_BUTTONS, MathButtonsClass))

typedef struct _MathButtons MathButtons;
typedef struct _MathButtonsClass MathButtonsClass;
typedef struct _Block2Data Block2Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef enum  {
	BUTTON_MODE_BASIC,
	BUTTON_MODE_ADVANCED,
	BUTTON_MODE_FINANCIAL,
	BUTTON_MODE_PROGRAMMING,
	BUTTON_MODE_KEYBOARD,
	BUTTON_MODE_CONVERSION
} ButtonMode;

#define TYPE_BUTTON_MODE (button_mode_get_type ())
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _ConversionButtonPanel {
	AdwBin parent_instance;
	ConversionButtonPanelPrivate * priv;
};

struct _ConversionButtonPanelClass {
	AdwBinClass parent_class;
};

struct _ConversionButtonPanelPrivate {
	MathConverter* converter;
	GtkWidget* basic;
	GtkGrid* dec_buttons;
	GtkGrid* hex_buttons;
	GtkButton* calc_numeric_point_button;
	GtkStack* calc_mutable_button;
	GList* hex_button_list;
	AdwDialog* rate_details_dialog;
	AdwPreferencesGroup* from_group;
	AdwActionRow* from_date;
	AdwActionRow* from_source;
	AdwPreferencesGroup* to_group;
	AdwActionRow* to_date;
	AdwActionRow* to_source;
	GSimpleActionGroup* action_group;
};

struct _Block2Data {
	int _ref_count_;
	ConversionButtonPanel* self;
	MathButtons* buttons;
};

static gint ConversionButtonPanel_private_offset;
static gpointer conversion_button_panel_parent_class = NULL;

VALA_EXTERN GType conversion_button_panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConversionButtonPanel, g_object_unref)
VALA_EXTERN GType math_converter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathConverter, g_object_unref)
static void conversion_button_panel_on_insert (ConversionButtonPanel* self,
                                        GSimpleAction* action,
                                        GVariant* param);
static void _conversion_button_panel_on_insert_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self);
static void conversion_button_panel_on_insert_digit (ConversionButtonPanel* self,
                                              GSimpleAction* action,
                                              GVariant* param);
static void _conversion_button_panel_on_insert_digit_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                GVariant* parameter,
                                                                                gpointer self);
static void conversion_button_panel_on_insert_numeric_point (ConversionButtonPanel* self);
static void _conversion_button_panel_on_insert_numeric_point_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                        GVariant* parameter,
                                                                                        gpointer self);
static void conversion_button_panel_on_insert_dms (ConversionButtonPanel* self);
static void _conversion_button_panel_on_insert_dms_gsimple_action_activate_callback (GSimpleAction* action,
                                                                              GVariant* parameter,
                                                                              gpointer self);
static void conversion_button_panel_on_change_sign (ConversionButtonPanel* self);
static void _conversion_button_panel_on_change_sign_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self);
static void conversion_button_panel_on_rate_details (ConversionButtonPanel* self);
static void _conversion_button_panel_on_rate_details_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                GVariant* parameter,
                                                                                gpointer self);
static void conversion_button_panel_on_clear (ConversionButtonPanel* self);
static void _conversion_button_panel_on_clear_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void conversion_button_panel_on_swap_units (ConversionButtonPanel* self);
static void _conversion_button_panel_on_swap_units_gsimple_action_activate_callback (GSimpleAction* action,
                                                                              GVariant* parameter,
                                                                              gpointer self);
static void conversion_button_panel_on_backspace (ConversionButtonPanel* self);
static void _conversion_button_panel_on_backspace_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN GType math_buttons_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathButtons, g_object_unref)
VALA_EXTERN ConversionButtonPanel* conversion_button_panel_new (MathButtons* buttons);
VALA_EXTERN ConversionButtonPanel* conversion_button_panel_construct (GType object_type,
                                                          MathButtons* buttons);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
VALA_EXTERN MathConverter* math_buttons_get_converter (MathButtons* self);
static void conversion_button_panel_correct_text_direction (ConversionButtonPanel* self);
VALA_EXTERN MathEquation* math_buttons_get_equation (MathButtons* self);
static void __lambda37_ (Block2Data* _data2_);
VALA_EXTERN GType button_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ButtonMode math_buttons_get_mode (MathButtons* self);
static void conversion_button_panel_converter_changed_cb (ConversionButtonPanel* self);
static void ___lambda37__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void _conversion_button_panel_converter_changed_cb_math_converter_changed (MathConverter* _sender,
                                                                           gpointer self);
VALA_EXTERN void math_converter_insert_text (MathConverter* self,
                                 const gchar* text,
                                 gboolean replace_zero);
VALA_EXTERN void math_converter_insert_numeric_point (MathConverter* self);
VALA_EXTERN void math_converter_insert_dms (MathConverter* self);
VALA_EXTERN void math_converter_change_sign (MathConverter* self);
VALA_EXTERN gboolean math_converter_get_box_visible (MathConverter* self);
VALA_EXTERN void math_converter_get_conversion (MathConverter* self,
                                    Unit** from_unit,
                                    Unit** to_unit);
VALA_EXTERN void math_converter_clear (MathConverter* self);
VALA_EXTERN void math_converter_swap_units (MathConverter* self);
VALA_EXTERN void math_converter_backspace (MathConverter* self);
VALA_EXTERN gchar* math_converter_get_category (MathConverter* self);
VALA_EXTERN gchar* math_converter_get_focus_unit (MathConverter* self);
static void conversion_button_panel_launch_attribution_link (ConversionButtonPanel* self,
                                                      AdwActionRow* row);
static void _conversion_button_panel_launch_attribution_link_adw_action_row_activated (AdwActionRow* _sender,
                                                                                gpointer self);
static void conversion_button_panel_refresh_rates (ConversionButtonPanel* self);
VALA_EXTERN gboolean math_converter_refresh_rates (MathConverter* self);
static void _conversion_button_panel_refresh_rates_adw_button_row_activated (AdwButtonRow* _sender,
                                                                      gpointer self);
static void conversion_button_panel_finalize (GObject * obj);
static GType conversion_button_panel_get_type_once (void);

static const GActionEntry CONVERSION_BUTTON_PANEL_action_entries[9] = {{"insert-general", _conversion_button_panel_on_insert_gsimple_action_activate_callback, "s"}, {"insert-digit", _conversion_button_panel_on_insert_digit_gsimple_action_activate_callback, "i"}, {"insert-numeric-point", _conversion_button_panel_on_insert_numeric_point_gsimple_action_activate_callback}, {"insert-dms", _conversion_button_panel_on_insert_dms_gsimple_action_activate_callback}, {"change-sign", _conversion_button_panel_on_change_sign_gsimple_action_activate_callback}, {"rate-details", _conversion_button_panel_on_rate_details_gsimple_action_activate_callback}, {"clear", _conversion_button_panel_on_clear_gsimple_action_activate_callback}, {"swap-units", _conversion_button_panel_on_swap_units_gsimple_action_activate_callback}, {"backspace", _conversion_button_panel_on_backspace_gsimple_action_activate_callback}};

static inline gpointer
conversion_button_panel_get_instance_private (ConversionButtonPanel* self)
{
	return G_STRUCT_MEMBER_P (self, ConversionButtonPanel_private_offset);
}

static void
_conversion_button_panel_on_insert_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self)
{
	conversion_button_panel_on_insert ((ConversionButtonPanel*) self, action, parameter);
}

static void
_conversion_button_panel_on_insert_digit_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self)
{
	conversion_button_panel_on_insert_digit ((ConversionButtonPanel*) self, action, parameter);
}

static void
_conversion_button_panel_on_insert_numeric_point_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                   GVariant* parameter,
                                                                                   gpointer self)
{
	conversion_button_panel_on_insert_numeric_point ((ConversionButtonPanel*) self);
}

static void
_conversion_button_panel_on_insert_dms_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self)
{
	conversion_button_panel_on_insert_dms ((ConversionButtonPanel*) self);
}

static void
_conversion_button_panel_on_change_sign_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self)
{
	conversion_button_panel_on_change_sign ((ConversionButtonPanel*) self);
}

static void
_conversion_button_panel_on_rate_details_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self)
{
	conversion_button_panel_on_rate_details ((ConversionButtonPanel*) self);
}

static void
_conversion_button_panel_on_clear_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	conversion_button_panel_on_clear ((ConversionButtonPanel*) self);
}

static void
_conversion_button_panel_on_swap_units_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self)
{
	conversion_button_panel_on_swap_units ((ConversionButtonPanel*) self);
}

static void
_conversion_button_panel_on_backspace_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self)
{
	conversion_button_panel_on_backspace ((ConversionButtonPanel*) self);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		ConversionButtonPanel* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->buttons);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

static void
__lambda37_ (Block2Data* _data2_)
{
	ConversionButtonPanel* self;
	ButtonMode _tmp0_;
	ButtonMode _tmp1_;
	self = _data2_->self;
	_tmp0_ = math_buttons_get_mode (_data2_->buttons);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == BUTTON_MODE_CONVERSION) {
		conversion_button_panel_converter_changed_cb (self);
	}
}

static void
___lambda37__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda37_ (self);
}

static void
_conversion_button_panel_converter_changed_cb_math_converter_changed (MathConverter* _sender,
                                                                      gpointer self)
{
	conversion_button_panel_converter_changed_cb ((ConversionButtonPanel*) self);
}

ConversionButtonPanel*
conversion_button_panel_construct (GType object_type,
                                   MathButtons* buttons)
{
	ConversionButtonPanel * self = NULL;
	Block2Data* _data2_;
	MathButtons* _tmp0_;
	MathConverter* _tmp1_;
	MathConverter* _tmp2_;
	MathConverter* _tmp3_;
	GSimpleActionGroup* _tmp4_;
	GSimpleActionGroup* _tmp5_;
	GtkButton* _tmp6_;
	MathEquation* _tmp7_;
	MathEquation* _tmp8_;
	Serializer* _tmp9_;
	Serializer* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	MathConverter* _tmp20_;
	g_return_val_if_fail (buttons != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (buttons);
	_g_object_unref0 (_data2_->buttons);
	_data2_->buttons = _tmp0_;
	self = (ConversionButtonPanel*) g_object_new (object_type, NULL);
	_data2_->self = g_object_ref (self);
	_tmp1_ = math_buttons_get_converter (_data2_->buttons);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->converter);
	self->priv->converter = _tmp3_;
	_tmp4_ = self->priv->action_group;
	g_action_map_add_action_entries ((GActionMap*) _tmp4_, CONVERSION_BUTTON_PANEL_action_entries, (gint) G_N_ELEMENTS (CONVERSION_BUTTON_PANEL_action_entries), self);
	_tmp5_ = self->priv->action_group;
	gtk_widget_insert_action_group ((GtkWidget*) self, "cal", (GActionGroup*) _tmp5_);
	conversion_button_panel_correct_text_direction (self);
	_tmp6_ = self->priv->calc_numeric_point_button;
	_tmp7_ = math_buttons_get_equation (_data2_->buttons);
	_tmp8_ = _tmp7_;
	_tmp9_ = math_equation_get_serializer (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_unichar_to_string (serializer_get_radix (_tmp10_));
	_tmp12_ = _tmp11_;
	gtk_button_set_label (_tmp6_, _tmp12_);
	_g_free0 (_tmp12_);
	{
		gint row = 0;
		row = 2;
		{
			gboolean _tmp13_ = FALSE;
			_tmp13_ = TRUE;
			while (TRUE) {
				if (!_tmp13_) {
					gint _tmp14_;
					_tmp14_ = row;
					row = _tmp14_ - 1;
				}
				_tmp13_ = FALSE;
				if (!(row >= 0)) {
					break;
				}
				{
					gint column = 0;
					column = 0;
					{
						gboolean _tmp15_ = FALSE;
						_tmp15_ = TRUE;
						while (TRUE) {
							GtkGrid* _tmp17_;
							GtkWidget* _tmp18_;
							GtkButton* _tmp19_;
							if (!_tmp15_) {
								gint _tmp16_;
								_tmp16_ = column;
								column = _tmp16_ + 1;
							}
							_tmp15_ = FALSE;
							if (!(column <= 4)) {
								break;
							}
							_tmp17_ = self->priv->hex_buttons;
							_tmp18_ = gtk_grid_get_child_at (_tmp17_, column, row);
							_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, gtk_button_get_type ()) ? ((GtkButton*) _tmp18_) : NULL);
							self->priv->hex_button_list = g_list_append (self->priv->hex_button_list, _tmp19_);
						}
					}
				}
			}
		}
	}
	g_signal_connect_data ((GObject*) _data2_->buttons, "notify::mode", (GCallback) ___lambda37__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp20_ = self->priv->converter;
	g_signal_connect_object (_tmp20_, "changed", (GCallback) _conversion_button_panel_converter_changed_cb_math_converter_changed, self, 0);
	conversion_button_panel_converter_changed_cb (self);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return self;
}

ConversionButtonPanel*
conversion_button_panel_new (MathButtons* buttons)
{
	return conversion_button_panel_construct (TYPE_CONVERSION_BUTTON_PANEL, buttons);
}

static void
conversion_button_panel_correct_text_direction (ConversionButtonPanel* self)
{
	GtkWidget* _tmp0_;
	GtkGrid* _tmp1_;
	GtkGrid* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->basic;
	gtk_widget_set_direction (_tmp0_, GTK_TEXT_DIR_LTR);
	_tmp1_ = self->priv->dec_buttons;
	gtk_widget_set_direction ((GtkWidget*) _tmp1_, GTK_TEXT_DIR_LTR);
	_tmp2_ = self->priv->hex_buttons;
	gtk_widget_set_direction ((GtkWidget*) _tmp2_, GTK_TEXT_DIR_LTR);
}

static void
conversion_button_panel_on_insert (ConversionButtonPanel* self,
                                   GSimpleAction* action,
                                   GVariant* param)
{
	MathConverter* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->converter;
	_tmp1_ = g_variant_get_string (param, NULL);
	math_converter_insert_text (_tmp0_, _tmp1_, TRUE);
}

static void
conversion_button_panel_on_insert_digit (ConversionButtonPanel* self,
                                         GSimpleAction* action,
                                         GVariant* param)
{
	MathConverter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->converter;
	_tmp1_ = g_strdup_printf ("%X", g_variant_get_int32 (param));
	_tmp2_ = _tmp1_;
	math_converter_insert_text (_tmp0_, _tmp2_, TRUE);
	_g_free0 (_tmp2_);
}

static void
conversion_button_panel_on_insert_numeric_point (ConversionButtonPanel* self)
{
	MathConverter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->converter;
	math_converter_insert_numeric_point (_tmp0_);
}

static void
conversion_button_panel_on_insert_dms (ConversionButtonPanel* self)
{
	MathConverter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->converter;
	math_converter_insert_dms (_tmp0_);
}

static void
conversion_button_panel_on_change_sign (ConversionButtonPanel* self)
{
	MathConverter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->converter;
	math_converter_change_sign (_tmp0_);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
conversion_button_panel_on_rate_details (ConversionButtonPanel* self)
{
	MathConverter* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	Unit* from_unit = NULL;
	Unit* to_unit = NULL;
	MathConverter* _tmp3_;
	Unit* _tmp4_ = NULL;
	Unit* _tmp5_ = NULL;
	CurrencyManager* currency_manager = NULL;
	CurrencyManager* _tmp6_;
	Currency* from_currency = NULL;
	CurrencyManager* _tmp7_;
	Unit* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	Currency* _tmp12_;
	Currency* _tmp13_;
	Currency* to_currency = NULL;
	CurrencyManager* _tmp14_;
	Unit* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	Currency* _tmp19_;
	Currency* _tmp20_;
	AdwPreferencesGroup* _tmp21_;
	Unit* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	AdwActionRow* _tmp28_;
	Currency* _tmp29_;
	Currency* _tmp30_;
	AdwPreferencesGroup* _tmp60_;
	Unit* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	AdwActionRow* _tmp67_;
	Currency* _tmp68_;
	Currency* _tmp69_;
	AdwDialog* _tmp99_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->converter;
	_tmp1_ = math_converter_get_box_visible (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->converter;
	math_converter_get_conversion (_tmp3_, &_tmp4_, &_tmp5_);
	_g_object_unref0 (from_unit);
	from_unit = _tmp4_;
	_g_object_unref0 (to_unit);
	to_unit = _tmp5_;
	_tmp6_ = currency_manager_get_default (TRUE, TRUE);
	currency_manager = _tmp6_;
	_tmp7_ = currency_manager;
	_tmp8_ = from_unit;
	_tmp9_ = unit_get_name (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp12_ = currency_manager_get_currency (_tmp7_, _tmp11_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	from_currency = _tmp13_;
	_tmp14_ = currency_manager;
	_tmp15_ = to_unit;
	_tmp16_ = unit_get_name (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = _tmp17_;
	_tmp19_ = currency_manager_get_currency (_tmp14_, _tmp18_);
	_tmp20_ = _tmp19_;
	_g_free0 (_tmp18_);
	to_currency = _tmp20_;
	_tmp21_ = self->priv->from_group;
	_tmp22_ = from_unit;
	_tmp23_ = unit_get_display_name (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = _tmp24_;
	_tmp26_ = string_replace (_tmp25_, "&", "&amp;");
	_tmp27_ = _tmp26_;
	adw_preferences_group_set_title (_tmp21_, _tmp27_);
	_g_free0 (_tmp27_);
	_g_free0 (_tmp25_);
	_tmp28_ = self->priv->from_source;
	_tmp29_ = from_currency;
	gtk_widget_set_visible ((GtkWidget*) _tmp28_, _tmp29_ != NULL);
	_tmp30_ = from_currency;
	if (_tmp30_ != NULL) {
		GDateTime* date = NULL;
		Currency* _tmp31_;
		CurrencyProvider* _tmp32_;
		CurrencyProvider* _tmp33_;
		Currency* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		GDateTime* _tmp38_;
		GDateTime* _tmp39_;
		gchar* _tmp40_ = NULL;
		GDateTime* _tmp41_;
		AdwActionRow* _tmp45_;
		AdwActionRow* _tmp46_;
		Currency* _tmp47_;
		CurrencyProvider* _tmp48_;
		CurrencyProvider* _tmp49_;
		const gchar* _tmp50_;
		const gchar* _tmp51_;
		AdwActionRow* _tmp52_;
		Currency* _tmp53_;
		CurrencyProvider* _tmp54_;
		CurrencyProvider* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		_tmp31_ = from_currency;
		_tmp32_ = currency_get_provider (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = from_currency;
		_tmp35_ = currency_get_date (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = _tmp36_;
		_tmp38_ = currency_provider_parse_date (_tmp33_, _tmp37_);
		_tmp39_ = _tmp38_;
		_g_free0 (_tmp37_);
		date = _tmp39_;
		_tmp41_ = date;
		if (_tmp41_ != NULL) {
			GDateTime* _tmp42_;
			gchar* _tmp43_;
			_tmp42_ = date;
			_tmp43_ = g_date_time_format (_tmp42_, "%x");
			_g_free0 (_tmp40_);
			_tmp40_ = _tmp43_;
		} else {
			gchar* _tmp44_;
			_tmp44_ = g_strdup (_ ("Not Available"));
			_g_free0 (_tmp40_);
			_tmp40_ = _tmp44_;
		}
		_tmp45_ = self->priv->from_date;
		adw_action_row_set_subtitle (_tmp45_, _tmp40_);
		_tmp46_ = self->priv->from_source;
		_tmp47_ = from_currency;
		_tmp48_ = currency_get_provider (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = currency_provider_get_provider_name (_tmp49_);
		_tmp51_ = _tmp50_;
		adw_action_row_set_subtitle (_tmp46_, _tmp51_);
		_tmp52_ = self->priv->from_source;
		_tmp53_ = from_currency;
		_tmp54_ = currency_get_provider (_tmp53_);
		_tmp55_ = _tmp54_;
		_tmp56_ = currency_provider_get_attribution_link (_tmp55_);
		_tmp57_ = _tmp56_;
		_tmp58_ = _tmp57_;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp52_, _tmp58_);
		_g_free0 (_tmp58_);
		_g_free0 (_tmp40_);
		_g_date_time_unref0 (date);
	} else {
		AdwActionRow* _tmp59_;
		_tmp59_ = self->priv->from_date;
		adw_action_row_set_subtitle (_tmp59_, _ ("Not Available"));
	}
	_tmp60_ = self->priv->to_group;
	_tmp61_ = to_unit;
	_tmp62_ = unit_get_display_name (_tmp61_);
	_tmp63_ = _tmp62_;
	_tmp64_ = _tmp63_;
	_tmp65_ = string_replace (_tmp64_, "&", "&amp;");
	_tmp66_ = _tmp65_;
	adw_preferences_group_set_title (_tmp60_, _tmp66_);
	_g_free0 (_tmp66_);
	_g_free0 (_tmp64_);
	_tmp67_ = self->priv->to_source;
	_tmp68_ = to_currency;
	gtk_widget_set_visible ((GtkWidget*) _tmp67_, _tmp68_ != NULL);
	_tmp69_ = to_currency;
	if (_tmp69_ != NULL) {
		GDateTime* date = NULL;
		Currency* _tmp70_;
		CurrencyProvider* _tmp71_;
		CurrencyProvider* _tmp72_;
		Currency* _tmp73_;
		gchar* _tmp74_;
		gchar* _tmp75_;
		gchar* _tmp76_;
		GDateTime* _tmp77_;
		GDateTime* _tmp78_;
		gchar* _tmp79_ = NULL;
		GDateTime* _tmp80_;
		AdwActionRow* _tmp84_;
		AdwActionRow* _tmp85_;
		Currency* _tmp86_;
		CurrencyProvider* _tmp87_;
		CurrencyProvider* _tmp88_;
		const gchar* _tmp89_;
		const gchar* _tmp90_;
		AdwActionRow* _tmp91_;
		Currency* _tmp92_;
		CurrencyProvider* _tmp93_;
		CurrencyProvider* _tmp94_;
		gchar* _tmp95_;
		gchar* _tmp96_;
		gchar* _tmp97_;
		_tmp70_ = to_currency;
		_tmp71_ = currency_get_provider (_tmp70_);
		_tmp72_ = _tmp71_;
		_tmp73_ = to_currency;
		_tmp74_ = currency_get_date (_tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = _tmp75_;
		_tmp77_ = currency_provider_parse_date (_tmp72_, _tmp76_);
		_tmp78_ = _tmp77_;
		_g_free0 (_tmp76_);
		date = _tmp78_;
		_tmp80_ = date;
		if (_tmp80_ != NULL) {
			GDateTime* _tmp81_;
			gchar* _tmp82_;
			_tmp81_ = date;
			_tmp82_ = g_date_time_format (_tmp81_, "%x");
			_g_free0 (_tmp79_);
			_tmp79_ = _tmp82_;
		} else {
			gchar* _tmp83_;
			_tmp83_ = g_strdup (_ ("Not Available"));
			_g_free0 (_tmp79_);
			_tmp79_ = _tmp83_;
		}
		_tmp84_ = self->priv->to_date;
		adw_action_row_set_subtitle (_tmp84_, _tmp79_);
		_tmp85_ = self->priv->to_source;
		_tmp86_ = to_currency;
		_tmp87_ = currency_get_provider (_tmp86_);
		_tmp88_ = _tmp87_;
		_tmp89_ = currency_provider_get_provider_name (_tmp88_);
		_tmp90_ = _tmp89_;
		adw_action_row_set_subtitle (_tmp85_, _tmp90_);
		_tmp91_ = self->priv->to_source;
		_tmp92_ = to_currency;
		_tmp93_ = currency_get_provider (_tmp92_);
		_tmp94_ = _tmp93_;
		_tmp95_ = currency_provider_get_attribution_link (_tmp94_);
		_tmp96_ = _tmp95_;
		_tmp97_ = _tmp96_;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp91_, _tmp97_);
		_g_free0 (_tmp97_);
		_g_free0 (_tmp79_);
		_g_date_time_unref0 (date);
	} else {
		AdwActionRow* _tmp98_;
		_tmp98_ = self->priv->to_date;
		adw_action_row_set_subtitle (_tmp98_, _ ("Not Available"));
	}
	_tmp99_ = self->priv->rate_details_dialog;
	adw_dialog_present (_tmp99_, (GtkWidget*) self);
	_g_object_unref0 (to_currency);
	_g_object_unref0 (from_currency);
	_g_object_unref0 (currency_manager);
	_g_object_unref0 (to_unit);
	_g_object_unref0 (from_unit);
}

static void
conversion_button_panel_on_clear (ConversionButtonPanel* self)
{
	MathConverter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->converter;
	math_converter_clear (_tmp0_);
}

static void
conversion_button_panel_on_swap_units (ConversionButtonPanel* self)
{
	MathConverter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->converter;
	math_converter_swap_units (_tmp0_);
}

static void
conversion_button_panel_on_backspace (ConversionButtonPanel* self)
{
	MathConverter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->converter;
	math_converter_backspace (_tmp0_);
}

static void
conversion_button_panel_converter_changed_cb (ConversionButtonPanel* self)
{
	gchar* category = NULL;
	MathConverter* _tmp0_;
	gchar* _tmp1_;
	gchar* unit = NULL;
	MathConverter* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->converter;
	_tmp1_ = math_converter_get_category (_tmp0_);
	category = _tmp1_;
	_tmp2_ = self->priv->converter;
	_tmp3_ = math_converter_get_focus_unit (_tmp2_);
	unit = _tmp3_;
	_tmp4_ = category;
	if (g_strcmp0 (_tmp4_, "numberbase") == 0) {
		GtkGrid* _tmp5_;
		gint number_base = 0;
		const gchar* _tmp6_;
		gint i = 0;
		GList* _tmp7_;
		_tmp5_ = self->priv->hex_buttons;
		gtk_widget_set_visible ((GtkWidget*) _tmp5_, TRUE);
		_tmp6_ = unit;
		number_base = atoi (_tmp6_);
		i = 1;
		_tmp7_ = self->priv->hex_button_list;
		{
			GList* button_collection = NULL;
			GList* button_it = NULL;
			button_collection = _tmp7_;
			for (button_it = button_collection; button_it != NULL; button_it = button_it->next) {
				GtkButton* _tmp8_;
				GtkButton* button = NULL;
				_tmp8_ = _g_object_ref0 ((GtkButton*) button_it->data);
				button = _tmp8_;
				{
					GtkButton* _tmp9_;
					gint _tmp10_;
					_tmp9_ = button;
					gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, i < number_base);
					_tmp10_ = i;
					i = _tmp10_ + 1;
					_g_object_unref0 (button);
				}
			}
		}
	} else {
		GtkGrid* _tmp11_;
		_tmp11_ = self->priv->hex_buttons;
		gtk_widget_set_visible ((GtkWidget*) _tmp11_, FALSE);
	}
	_tmp13_ = category;
	if (g_strcmp0 (_tmp13_, "angle") == 0) {
		gboolean _tmp14_ = FALSE;
		const gchar* _tmp15_;
		_tmp15_ = unit;
		if (g_strcmp0 (_tmp15_, "degree") == 0) {
			_tmp14_ = TRUE;
		} else {
			const gchar* _tmp16_;
			_tmp16_ = unit;
			_tmp14_ = g_strcmp0 (_tmp16_, "dms") == 0;
		}
		_tmp12_ = _tmp14_;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		GtkStack* _tmp17_;
		GtkSelectionModel* _tmp18_;
		GtkSelectionModel* _tmp19_;
		GtkSelectionModel* _tmp20_;
		_tmp17_ = self->priv->calc_mutable_button;
		_tmp18_ = gtk_stack_get_pages (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = _tmp19_;
		gtk_selection_model_select_item (_tmp20_, (guint) 0, TRUE);
		_g_object_unref0 (_tmp20_);
	} else {
		gboolean _tmp21_ = FALSE;
		const gchar* _tmp22_;
		_tmp22_ = category;
		if (g_strcmp0 (_tmp22_, "angle") == 0) {
			const gchar* _tmp23_;
			_tmp23_ = unit;
			_tmp21_ = g_strcmp0 (_tmp23_, "radian") == 0;
		} else {
			_tmp21_ = FALSE;
		}
		if (_tmp21_) {
			GtkStack* _tmp24_;
			GtkSelectionModel* _tmp25_;
			GtkSelectionModel* _tmp26_;
			GtkSelectionModel* _tmp27_;
			_tmp24_ = self->priv->calc_mutable_button;
			_tmp25_ = gtk_stack_get_pages (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = _tmp26_;
			gtk_selection_model_select_item (_tmp27_, (guint) 1, TRUE);
			_g_object_unref0 (_tmp27_);
		} else {
			gboolean _tmp28_ = FALSE;
			const gchar* _tmp29_;
			_tmp29_ = category;
			if (g_strcmp0 (_tmp29_, "temperature") == 0) {
				_tmp28_ = TRUE;
			} else {
				const gchar* _tmp30_;
				_tmp30_ = category;
				_tmp28_ = g_strcmp0 (_tmp30_, "numberbase") == 0;
			}
			if (_tmp28_) {
				GtkStack* _tmp31_;
				GtkSelectionModel* _tmp32_;
				GtkSelectionModel* _tmp33_;
				GtkSelectionModel* _tmp34_;
				_tmp31_ = self->priv->calc_mutable_button;
				_tmp32_ = gtk_stack_get_pages (_tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = _tmp33_;
				gtk_selection_model_select_item (_tmp34_, (guint) 2, TRUE);
				_g_object_unref0 (_tmp34_);
			} else {
				const gchar* _tmp35_;
				_tmp35_ = category;
				if (g_strcmp0 (_tmp35_, "currency") == 0) {
					GtkStack* _tmp36_;
					GtkSelectionModel* _tmp37_;
					GtkSelectionModel* _tmp38_;
					GtkSelectionModel* _tmp39_;
					_tmp36_ = self->priv->calc_mutable_button;
					_tmp37_ = gtk_stack_get_pages (_tmp36_);
					_tmp38_ = _tmp37_;
					_tmp39_ = _tmp38_;
					gtk_selection_model_select_item (_tmp39_, (guint) 3, TRUE);
					_g_object_unref0 (_tmp39_);
				} else {
					GtkStack* _tmp40_;
					GtkSelectionModel* _tmp41_;
					GtkSelectionModel* _tmp42_;
					GtkSelectionModel* _tmp43_;
					_tmp40_ = self->priv->calc_mutable_button;
					_tmp41_ = gtk_stack_get_pages (_tmp40_);
					_tmp42_ = _tmp41_;
					_tmp43_ = _tmp42_;
					gtk_selection_model_select_item (_tmp43_, (guint) 4, TRUE);
					_g_object_unref0 (_tmp43_);
				}
			}
		}
	}
	_g_free0 (unit);
	_g_free0 (category);
}

static void
conversion_button_panel_launch_attribution_link (ConversionButtonPanel* self,
                                                 AdwActionRow* row)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GtkUriLauncher* _tmp2_;
	GtkUriLauncher* _tmp3_;
	GtkRoot* _tmp4_;
	GtkRoot* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = gtk_widget_get_tooltip_text ((GtkWidget*) row);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_uri_launcher_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gtk_widget_get_root ((GtkWidget*) self);
	_tmp5_ = _tmp4_;
	gtk_uri_launcher_launch (_tmp3_, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_window_get_type (), GtkWindow), NULL, NULL, NULL);
	_g_object_unref0 (_tmp3_);
}

static void
_conversion_button_panel_launch_attribution_link_adw_action_row_activated (AdwActionRow* _sender,
                                                                           gpointer self)
{
	conversion_button_panel_launch_attribution_link ((ConversionButtonPanel*) self, _sender);
}

static void
conversion_button_panel_refresh_rates (ConversionButtonPanel* self)
{
	MathConverter* _tmp0_;
	AdwDialog* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->converter;
	math_converter_refresh_rates (_tmp0_);
	_tmp1_ = self->priv->rate_details_dialog;
	adw_dialog_close (_tmp1_);
}

static void
_conversion_button_panel_refresh_rates_adw_button_row_activated (AdwButtonRow* _sender,
                                                                 gpointer self)
{
	conversion_button_panel_refresh_rates ((ConversionButtonPanel*) self);
}

static void
conversion_button_panel_class_init (ConversionButtonPanelClass * klass,
                                    gpointer klass_data)
{
	conversion_button_panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ConversionButtonPanel_private_offset);
	G_OBJECT_CLASS (klass)->finalize = conversion_button_panel_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/calculator/buttons-conversion.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "basic", FALSE, ConversionButtonPanel_private_offset + G_STRUCT_OFFSET (ConversionButtonPanelPrivate, basic));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "dec_buttons", FALSE, ConversionButtonPanel_private_offset + G_STRUCT_OFFSET (ConversionButtonPanelPrivate, dec_buttons));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "hex_buttons", FALSE, ConversionButtonPanel_private_offset + G_STRUCT_OFFSET (ConversionButtonPanelPrivate, hex_buttons));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "calc_numeric_point_button", FALSE, ConversionButtonPanel_private_offset + G_STRUCT_OFFSET (ConversionButtonPanelPrivate, calc_numeric_point_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "calc_mutable_button", FALSE, ConversionButtonPanel_private_offset + G_STRUCT_OFFSET (ConversionButtonPanelPrivate, calc_mutable_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "rate_details_dialog", FALSE, ConversionButtonPanel_private_offset + G_STRUCT_OFFSET (ConversionButtonPanelPrivate, rate_details_dialog));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "from_group", FALSE, ConversionButtonPanel_private_offset + G_STRUCT_OFFSET (ConversionButtonPanelPrivate, from_group));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "from_date", FALSE, ConversionButtonPanel_private_offset + G_STRUCT_OFFSET (ConversionButtonPanelPrivate, from_date));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "from_source", FALSE, ConversionButtonPanel_private_offset + G_STRUCT_OFFSET (ConversionButtonPanelPrivate, from_source));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "to_group", FALSE, ConversionButtonPanel_private_offset + G_STRUCT_OFFSET (ConversionButtonPanelPrivate, to_group));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "to_date", FALSE, ConversionButtonPanel_private_offset + G_STRUCT_OFFSET (ConversionButtonPanelPrivate, to_date));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "to_source", FALSE, ConversionButtonPanel_private_offset + G_STRUCT_OFFSET (ConversionButtonPanelPrivate, to_source));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "launch_attribution_link", G_CALLBACK(_conversion_button_panel_launch_attribution_link_adw_action_row_activated));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "refresh_rates", G_CALLBACK(_conversion_button_panel_refresh_rates_adw_button_row_activated));
}

static void
conversion_button_panel_instance_init (ConversionButtonPanel * self,
                                       gpointer klass)
{
	GSimpleActionGroup* _tmp0_;
	self->priv = conversion_button_panel_get_instance_private (self);
	self->priv->hex_button_list = NULL;
	_tmp0_ = g_simple_action_group_new ();
	self->priv->action_group = _tmp0_;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
conversion_button_panel_finalize (GObject * obj)
{
	ConversionButtonPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONVERSION_BUTTON_PANEL, ConversionButtonPanel);
	_g_object_unref0 (self->priv->converter);
	(self->priv->hex_button_list == NULL) ? NULL : (self->priv->hex_button_list = (_g_list_free__g_object_unref0_ (self->priv->hex_button_list), NULL));
	_g_object_unref0 (self->priv->action_group);
	G_OBJECT_CLASS (conversion_button_panel_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
conversion_button_panel_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ConversionButtonPanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) conversion_button_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConversionButtonPanel), 0, (GInstanceInitFunc) conversion_button_panel_instance_init, NULL };
	GType conversion_button_panel_type_id;
	conversion_button_panel_type_id = g_type_register_static (adw_bin_get_type (), "ConversionButtonPanel", &g_define_type_info, 0);
	ConversionButtonPanel_private_offset = g_type_add_instance_private (conversion_button_panel_type_id, sizeof (ConversionButtonPanelPrivate));
	return conversion_button_panel_type_id;
}

GType
conversion_button_panel_get_type (void)
{
	static gsize conversion_button_panel_type_id__once = 0;
	if (g_once_init_enter (&conversion_button_panel_type_id__once)) {
		GType conversion_button_panel_type_id;
		conversion_button_panel_type_id = conversion_button_panel_get_type_once ();
		g_once_init_leave (&conversion_button_panel_type_id__once, conversion_button_panel_type_id);
	}
	return conversion_button_panel_type_id__once;
}

