//
// Automatically generated by ipdlc.
// Edit at your own risk
//

#ifndef GraphicsMessages_h
#define GraphicsMessages_h

#include "mozilla/Attributes.h"
#include "IPCMessageStart.h"
#include "mozilla/RefPtr.h"
#include "nsString.h"
#include "nsTArray.h"
#include "nsTHashtable.h"
#include "mozilla/MozPromise.h"
#include "mozilla/OperatorNewExtensions.h"
#include "mozilla/UniquePtr.h"
#include "mozilla/ipc/ByteBuf.h"
#include "mozilla/ipc/FileDescriptor.h"
#include "mozilla/ipc/IPCForwards.h"
#include "mozilla/ipc/Shmem.h"

// Headers for typedefs
#include "gfxTelemetry.h"
#include "mozilla/D3DMessageUtils.h"
#include "mozilla/gfx/D3D11Checks.h"
#include "mozilla/gfx/Point.h"
#include "mozilla/gfx/Types.h"
#include "mozilla/ipc/IPDLStructMember.h"


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct D3D11DeviceStatus|
//
namespace mozilla {
namespace gfx {
class D3D11DeviceStatus final
{
private:
    typedef ::uint32_t uint32_t;
    typedef ::DxgiAdapterDesc DxgiAdapterDesc;
    typedef ::int32_t int32_t;
    typedef ::mozilla::gfx::D3D11Checks::VideoFormatOptionSet VideoFormatOptionSet;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    D3D11DeviceStatus() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT D3D11DeviceStatus(
            const bool& _isWARP,
            const bool& _textureSharingWorks,
            const uint32_t& _featureLevel,
            const DxgiAdapterDesc& _adapter,
            const int32_t& _sequenceNumber,
            const VideoFormatOptionSet& _formatOptions) :
        isWARP_(_isWARP),
        textureSharingWorks_(_textureSharingWorks),
        adapter_(_adapter),
        formatOptions_(_formatOptions),
        featureLevel_(_featureLevel),
        sequenceNumber_(_sequenceNumber)
    {
    }

    MOZ_IMPLICIT D3D11DeviceStatus(
            bool&& _isWARP,
            bool&& _textureSharingWorks,
            uint32_t&& _featureLevel,
            DxgiAdapterDesc&& _adapter,
            int32_t&& _sequenceNumber,
            VideoFormatOptionSet&& _formatOptions) :
        isWARP_(std::move(_isWARP)),
        textureSharingWorks_(std::move(_textureSharingWorks)),
        adapter_(std::move(_adapter)),
        formatOptions_(std::move(_formatOptions)),
        featureLevel_(std::move(_featureLevel)),
        sequenceNumber_(std::move(_sequenceNumber))
    {
    }

    bool&
    isWARP()
    {
        return isWARP_;
    }
    const bool&
    isWARP() const
    {
        return isWARP_;
    }

    bool&
    textureSharingWorks()
    {
        return textureSharingWorks_;
    }
    const bool&
    textureSharingWorks() const
    {
        return textureSharingWorks_;
    }

    uint32_t&
    featureLevel()
    {
        return featureLevel_;
    }
    const uint32_t&
    featureLevel() const
    {
        return featureLevel_;
    }

    DxgiAdapterDesc&
    adapter()
    {
        return adapter_;
    }
    const DxgiAdapterDesc&
    adapter() const
    {
        return adapter_;
    }

    int32_t&
    sequenceNumber()
    {
        return sequenceNumber_;
    }
    const int32_t&
    sequenceNumber() const
    {
        return sequenceNumber_;
    }

    VideoFormatOptionSet&
    formatOptions()
    {
        return formatOptions_;
    }
    const VideoFormatOptionSet&
    formatOptions() const
    {
        return formatOptions_;
    }

private:
    void
    StaticAssertions() const;
    ::mozilla::ipc::IPDLStructMember<bool> isWARP_;
    ::mozilla::ipc::IPDLStructMember<bool> textureSharingWorks_;
    ::mozilla::ipc::IPDLStructMember<DxgiAdapterDesc> adapter_;
    ::mozilla::ipc::IPDLStructMember<VideoFormatOptionSet> formatOptions_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> featureLevel_;
    ::mozilla::ipc::IPDLStructMember<int32_t> sequenceNumber_;
};
} // namespace gfx
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::gfx::D3D11DeviceStatus>
{
    typedef ::mozilla::gfx::D3D11DeviceStatus paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct DevicePrefs|
//
namespace mozilla {
namespace gfx {
class DevicePrefs final
{
private:
    typedef ::mozilla::gfx::FeatureStatus FeatureStatus;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    DevicePrefs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT DevicePrefs(
            const FeatureStatus& _hwCompositing,
            const FeatureStatus& _d3d11Compositing,
            const FeatureStatus& _oglCompositing,
            const FeatureStatus& _d3d11HwAngle) :
        hwCompositing_(_hwCompositing),
        d3d11Compositing_(_d3d11Compositing),
        oglCompositing_(_oglCompositing),
        d3d11HwAngle_(_d3d11HwAngle)
    {
    }

    MOZ_IMPLICIT DevicePrefs(
            FeatureStatus&& _hwCompositing,
            FeatureStatus&& _d3d11Compositing,
            FeatureStatus&& _oglCompositing,
            FeatureStatus&& _d3d11HwAngle) :
        hwCompositing_(std::move(_hwCompositing)),
        d3d11Compositing_(std::move(_d3d11Compositing)),
        oglCompositing_(std::move(_oglCompositing)),
        d3d11HwAngle_(std::move(_d3d11HwAngle))
    {
    }

    FeatureStatus&
    hwCompositing()
    {
        return hwCompositing_;
    }
    const FeatureStatus&
    hwCompositing() const
    {
        return hwCompositing_;
    }

    FeatureStatus&
    d3d11Compositing()
    {
        return d3d11Compositing_;
    }
    const FeatureStatus&
    d3d11Compositing() const
    {
        return d3d11Compositing_;
    }

    FeatureStatus&
    oglCompositing()
    {
        return oglCompositing_;
    }
    const FeatureStatus&
    oglCompositing() const
    {
        return oglCompositing_;
    }

    FeatureStatus&
    d3d11HwAngle()
    {
        return d3d11HwAngle_;
    }
    const FeatureStatus&
    d3d11HwAngle() const
    {
        return d3d11HwAngle_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<FeatureStatus> hwCompositing_;
    ::mozilla::ipc::IPDLStructMember<FeatureStatus> d3d11Compositing_;
    ::mozilla::ipc::IPDLStructMember<FeatureStatus> oglCompositing_;
    ::mozilla::ipc::IPDLStructMember<FeatureStatus> d3d11HwAngle_;
};
} // namespace gfx
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::gfx::DevicePrefs>
{
    typedef ::mozilla::gfx::DevicePrefs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ContentDeviceData|
//
namespace mozilla {
namespace gfx {
class ContentDeviceData final
{
private:
    typedef ::mozilla::gfx::DevicePrefs DevicePrefs;
    typedef ::mozilla::gfx::D3D11DeviceStatus D3D11DeviceStatus;
    typedef ::uint8_t uint8_t;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ContentDeviceData() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ContentDeviceData(
            const DevicePrefs& _prefs,
            const D3D11DeviceStatus& _d3d11,
            const nsTArray<uint8_t>& _cmsOutputProfileData) :
        prefs_(_prefs),
        d3d11_(_d3d11),
        cmsOutputProfileData_(_cmsOutputProfileData)
    {
    }

    MOZ_IMPLICIT ContentDeviceData(
            DevicePrefs&& _prefs,
            D3D11DeviceStatus&& _d3d11,
            nsTArray<uint8_t>&& _cmsOutputProfileData) :
        prefs_(std::move(_prefs)),
        d3d11_(std::move(_d3d11)),
        cmsOutputProfileData_(std::move(_cmsOutputProfileData))
    {
    }

    DevicePrefs&
    prefs()
    {
        return prefs_;
    }
    const DevicePrefs&
    prefs() const
    {
        return prefs_;
    }

    D3D11DeviceStatus&
    d3d11()
    {
        return d3d11_;
    }
    const D3D11DeviceStatus&
    d3d11() const
    {
        return d3d11_;
    }

    nsTArray<uint8_t>&
    cmsOutputProfileData()
    {
        return cmsOutputProfileData_;
    }
    const nsTArray<uint8_t>&
    cmsOutputProfileData() const
    {
        return cmsOutputProfileData_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<DevicePrefs> prefs_;
    ::mozilla::ipc::IPDLStructMember<D3D11DeviceStatus> d3d11_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<uint8_t>> cmsOutputProfileData_;
};
} // namespace gfx
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::gfx::ContentDeviceData>
{
    typedef ::mozilla::gfx::ContentDeviceData paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct FeatureFailure|
//
namespace mozilla {
namespace gfx {
class FeatureFailure final
{
private:
    typedef ::mozilla::gfx::FeatureStatus FeatureStatus;
    typedef ::nsCString nsCString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    FeatureFailure() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT FeatureFailure(
            const FeatureStatus& _status,
            const nsCString& _message,
            const nsCString& _failureId) :
        status_(_status),
        message_(_message),
        failureId_(_failureId)
    {
    }

    MOZ_IMPLICIT FeatureFailure(
            FeatureStatus&& _status,
            nsCString&& _message,
            nsCString&& _failureId) :
        status_(std::move(_status)),
        message_(std::move(_message)),
        failureId_(std::move(_failureId))
    {
    }

    FeatureStatus&
    status()
    {
        return status_;
    }
    const FeatureStatus&
    status() const
    {
        return status_;
    }

    nsCString&
    message()
    {
        return message_;
    }
    const nsCString&
    message() const
    {
        return message_;
    }

    nsCString&
    failureId()
    {
        return failureId_;
    }
    const nsCString&
    failureId() const
    {
        return failureId_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<FeatureStatus> status_;
    ::mozilla::ipc::IPDLStructMember<nsCString> message_;
    ::mozilla::ipc::IPDLStructMember<nsCString> failureId_;
};
} // namespace gfx
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::gfx::FeatureFailure>
{
    typedef ::mozilla::gfx::FeatureFailure paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct GPUDeviceData|
//
namespace mozilla {
namespace gfx {
class GPUDeviceData final
{
private:
    typedef ::mozilla::gfx::FeatureFailure FeatureFailure;
    typedef ::mozilla::gfx::D3D11DeviceStatus D3D11DeviceStatus;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    GPUDeviceData() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT GPUDeviceData(
            const mozilla::Maybe<FeatureFailure>& _d3d11Compositing,
            const mozilla::Maybe<FeatureFailure>& _oglCompositing,
            const mozilla::Maybe<D3D11DeviceStatus>& _gpuDevice) :
        d3d11Compositing_(_d3d11Compositing),
        oglCompositing_(_oglCompositing),
        gpuDevice_(_gpuDevice)
    {
    }

    MOZ_IMPLICIT GPUDeviceData(
            mozilla::Maybe<FeatureFailure>&& _d3d11Compositing,
            mozilla::Maybe<FeatureFailure>&& _oglCompositing,
            mozilla::Maybe<D3D11DeviceStatus>&& _gpuDevice) :
        d3d11Compositing_(std::move(_d3d11Compositing)),
        oglCompositing_(std::move(_oglCompositing)),
        gpuDevice_(std::move(_gpuDevice))
    {
    }

    mozilla::Maybe<FeatureFailure>&
    d3d11Compositing()
    {
        return d3d11Compositing_;
    }
    const mozilla::Maybe<FeatureFailure>&
    d3d11Compositing() const
    {
        return d3d11Compositing_;
    }

    mozilla::Maybe<FeatureFailure>&
    oglCompositing()
    {
        return oglCompositing_;
    }
    const mozilla::Maybe<FeatureFailure>&
    oglCompositing() const
    {
        return oglCompositing_;
    }

    mozilla::Maybe<D3D11DeviceStatus>&
    gpuDevice()
    {
        return gpuDevice_;
    }
    const mozilla::Maybe<D3D11DeviceStatus>&
    gpuDevice() const
    {
        return gpuDevice_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<FeatureFailure>> d3d11Compositing_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<FeatureFailure>> oglCompositing_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<D3D11DeviceStatus>> gpuDevice_;
};
} // namespace gfx
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::gfx::GPUDeviceData>
{
    typedef ::mozilla::gfx::GPUDeviceData paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union GfxVarValue|
//
namespace mozilla {
namespace gfx {
class GfxVarValue final
{
public:
    enum Type {
        T__None,
        TBackendType = 1,
        Tbool,
        TgfxImageFormat,
        TIntSize,
        TnsCString,
        TnsString,
        Tint32_t,
        Tuint64_t,
        Tfloat,
        TArrayOfuint64_t,
        T__Last = TArrayOfuint64_t
    };

private:
    typedef ::mozilla::gfx::BackendType BackendType;
    typedef ::gfxImageFormat gfxImageFormat;
    typedef ::mozilla::gfx::IntSize IntSize;
    typedef ::nsCString nsCString;
    typedef ::nsString nsString;
    typedef ::int32_t int32_t;
    typedef ::uint64_t uint64_t;
    typedef BackendType BackendType__tdef;
    typedef bool bool__tdef;
    typedef gfxImageFormat gfxImageFormat__tdef;
    typedef IntSize IntSize__tdef;
    typedef nsCString nsCString__tdef;
    typedef nsString nsString__tdef;
    typedef int32_t int32_t__tdef;
    typedef uint64_t uint64_t__tdef;
    typedef float float__tdef;
    typedef nsTArray<uint64_t> ArrayOfuint64_t__tdef;

    BackendType*
    ptr_BackendType()
    {
        return (&(mVBackendType));
    }
    const BackendType*
    constptr_BackendType() const
    {
        return (&(mVBackendType));
    }
    bool*
    ptr_bool()
    {
        return (&(mVbool));
    }
    const bool*
    constptr_bool() const
    {
        return (&(mVbool));
    }
    gfxImageFormat*
    ptr_gfxImageFormat()
    {
        return (&(mVgfxImageFormat));
    }
    const gfxImageFormat*
    constptr_gfxImageFormat() const
    {
        return (&(mVgfxImageFormat));
    }
    IntSize*
    ptr_IntSize()
    {
        return (&(mVIntSize));
    }
    const IntSize*
    constptr_IntSize() const
    {
        return (&(mVIntSize));
    }
    nsCString*
    ptr_nsCString()
    {
        return (&(mVnsCString));
    }
    const nsCString*
    constptr_nsCString() const
    {
        return (&(mVnsCString));
    }
    nsString*
    ptr_nsString()
    {
        return (&(mVnsString));
    }
    const nsString*
    constptr_nsString() const
    {
        return (&(mVnsString));
    }
    int32_t*
    ptr_int32_t()
    {
        return (&(mVint32_t));
    }
    const int32_t*
    constptr_int32_t() const
    {
        return (&(mVint32_t));
    }
    uint64_t*
    ptr_uint64_t()
    {
        return (&(mVuint64_t));
    }
    const uint64_t*
    constptr_uint64_t() const
    {
        return (&(mVuint64_t));
    }
    float*
    ptr_float()
    {
        return (&(mVfloat));
    }
    const float*
    constptr_float() const
    {
        return (&(mVfloat));
    }
    nsTArray<uint64_t>*
    ptr_ArrayOfuint64_t()
    {
        return (&(mVArrayOfuint64_t));
    }
    const nsTArray<uint64_t>*
    constptr_ArrayOfuint64_t() const
    {
        return (&(mVArrayOfuint64_t));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT GfxVarValue() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT GfxVarValue(const BackendType& aOther);

    MOZ_IMPLICIT GfxVarValue(BackendType&& aOther);

    MOZ_IMPLICIT GfxVarValue(const bool& aOther);

    MOZ_IMPLICIT GfxVarValue(bool&& aOther);

    MOZ_IMPLICIT GfxVarValue(const gfxImageFormat& aOther);

    MOZ_IMPLICIT GfxVarValue(gfxImageFormat&& aOther);

    MOZ_IMPLICIT GfxVarValue(const IntSize& aOther);

    MOZ_IMPLICIT GfxVarValue(IntSize&& aOther);

    MOZ_IMPLICIT GfxVarValue(const nsCString& aOther);

    MOZ_IMPLICIT GfxVarValue(nsCString&& aOther);

    MOZ_IMPLICIT GfxVarValue(const nsString& aOther);

    MOZ_IMPLICIT GfxVarValue(nsString&& aOther);

    MOZ_IMPLICIT GfxVarValue(const int32_t& aOther);

    MOZ_IMPLICIT GfxVarValue(int32_t&& aOther);

    MOZ_IMPLICIT GfxVarValue(const uint64_t& aOther);

    MOZ_IMPLICIT GfxVarValue(uint64_t&& aOther);

    MOZ_IMPLICIT GfxVarValue(const float& aOther);

    MOZ_IMPLICIT GfxVarValue(float&& aOther);

    MOZ_IMPLICIT GfxVarValue(const nsTArray<uint64_t>& aOther);

    MOZ_IMPLICIT GfxVarValue(nsTArray<uint64_t>&& aOther);

    MOZ_IMPLICIT GfxVarValue(const GfxVarValue& aOther);

    MOZ_IMPLICIT GfxVarValue(GfxVarValue&& aOther);

    ~GfxVarValue();

    Type
    type() const
    {
        return mType;
    }

    GfxVarValue&
    operator=(const BackendType& aRhs);

    GfxVarValue&
    operator=(BackendType&& aRhs);

    GfxVarValue&
    operator=(const bool& aRhs);

    GfxVarValue&
    operator=(bool&& aRhs);

    GfxVarValue&
    operator=(const gfxImageFormat& aRhs);

    GfxVarValue&
    operator=(gfxImageFormat&& aRhs);

    GfxVarValue&
    operator=(const IntSize& aRhs);

    GfxVarValue&
    operator=(IntSize&& aRhs);

    GfxVarValue&
    operator=(const nsCString& aRhs);

    GfxVarValue&
    operator=(nsCString&& aRhs);

    GfxVarValue&
    operator=(const nsString& aRhs);

    GfxVarValue&
    operator=(nsString&& aRhs);

    GfxVarValue&
    operator=(const int32_t& aRhs);

    GfxVarValue&
    operator=(int32_t&& aRhs);

    GfxVarValue&
    operator=(const uint64_t& aRhs);

    GfxVarValue&
    operator=(uint64_t&& aRhs);

    GfxVarValue&
    operator=(const float& aRhs);

    GfxVarValue&
    operator=(float&& aRhs);

    GfxVarValue&
    operator=(const nsTArray<uint64_t>& aRhs);

    GfxVarValue&
    operator=(nsTArray<uint64_t>&& aRhs);

    GfxVarValue&
    operator=(const GfxVarValue& aRhs);

    GfxVarValue&
    operator=(GfxVarValue&& aRhs);

    BackendType&
    get_BackendType()
    {
        AssertSanity(TBackendType);
        return (*(ptr_BackendType()));
    }
    const BackendType&
    get_BackendType() const
    {
        AssertSanity(TBackendType);
        return (*(constptr_BackendType()));
    }
    operator BackendType&()
    {
        return get_BackendType();
    }
    operator const BackendType&() const
    {
        return get_BackendType();
    }

    bool&
    get_bool()
    {
        AssertSanity(Tbool);
        return (*(ptr_bool()));
    }
    const bool&
    get_bool() const
    {
        AssertSanity(Tbool);
        return (*(constptr_bool()));
    }
    operator bool&()
    {
        return get_bool();
    }
    operator const bool&() const
    {
        return get_bool();
    }

    gfxImageFormat&
    get_gfxImageFormat()
    {
        AssertSanity(TgfxImageFormat);
        return (*(ptr_gfxImageFormat()));
    }
    const gfxImageFormat&
    get_gfxImageFormat() const
    {
        AssertSanity(TgfxImageFormat);
        return (*(constptr_gfxImageFormat()));
    }
    operator gfxImageFormat&()
    {
        return get_gfxImageFormat();
    }
    operator const gfxImageFormat&() const
    {
        return get_gfxImageFormat();
    }

    IntSize&
    get_IntSize()
    {
        AssertSanity(TIntSize);
        return (*(ptr_IntSize()));
    }
    const IntSize&
    get_IntSize() const
    {
        AssertSanity(TIntSize);
        return (*(constptr_IntSize()));
    }
    operator IntSize&()
    {
        return get_IntSize();
    }
    operator const IntSize&() const
    {
        return get_IntSize();
    }

    nsCString&
    get_nsCString()
    {
        AssertSanity(TnsCString);
        return (*(ptr_nsCString()));
    }
    const nsCString&
    get_nsCString() const
    {
        AssertSanity(TnsCString);
        return (*(constptr_nsCString()));
    }
    operator nsCString&()
    {
        return get_nsCString();
    }
    operator const nsCString&() const
    {
        return get_nsCString();
    }

    nsString&
    get_nsString()
    {
        AssertSanity(TnsString);
        return (*(ptr_nsString()));
    }
    const nsString&
    get_nsString() const
    {
        AssertSanity(TnsString);
        return (*(constptr_nsString()));
    }
    operator nsString&()
    {
        return get_nsString();
    }
    operator const nsString&() const
    {
        return get_nsString();
    }

    int32_t&
    get_int32_t()
    {
        AssertSanity(Tint32_t);
        return (*(ptr_int32_t()));
    }
    const int32_t&
    get_int32_t() const
    {
        AssertSanity(Tint32_t);
        return (*(constptr_int32_t()));
    }
    operator int32_t&()
    {
        return get_int32_t();
    }
    operator const int32_t&() const
    {
        return get_int32_t();
    }

    uint64_t&
    get_uint64_t()
    {
        AssertSanity(Tuint64_t);
        return (*(ptr_uint64_t()));
    }
    const uint64_t&
    get_uint64_t() const
    {
        AssertSanity(Tuint64_t);
        return (*(constptr_uint64_t()));
    }
    operator uint64_t&()
    {
        return get_uint64_t();
    }
    operator const uint64_t&() const
    {
        return get_uint64_t();
    }

    float&
    get_float()
    {
        AssertSanity(Tfloat);
        return (*(ptr_float()));
    }
    const float&
    get_float() const
    {
        AssertSanity(Tfloat);
        return (*(constptr_float()));
    }
    operator float&()
    {
        return get_float();
    }
    operator const float&() const
    {
        return get_float();
    }

    nsTArray<uint64_t>&
    get_ArrayOfuint64_t()
    {
        AssertSanity(TArrayOfuint64_t);
        return (*(ptr_ArrayOfuint64_t()));
    }
    const nsTArray<uint64_t>&
    get_ArrayOfuint64_t() const
    {
        AssertSanity(TArrayOfuint64_t);
        return (*(constptr_ArrayOfuint64_t()));
    }
    operator nsTArray<uint64_t>&()
    {
        return get_ArrayOfuint64_t();
    }
    operator const nsTArray<uint64_t>&() const
    {
        return get_ArrayOfuint64_t();
    }

private:
    union {
        BackendType mVBackendType;
        bool mVbool;
        gfxImageFormat mVgfxImageFormat;
        IntSize mVIntSize;
        nsCString mVnsCString;
        nsString mVnsString;
        int32_t mVint32_t;
        uint64_t mVuint64_t;
        float mVfloat;
        nsTArray<uint64_t> mVArrayOfuint64_t;
    };
    Type mType;
};
} // namespace gfx
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::gfx::GfxVarValue>
{
    typedef ::mozilla::gfx::GfxVarValue paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct GfxVarUpdate|
//
namespace mozilla {
namespace gfx {
class GfxVarUpdate final
{
private:
    typedef ::uint32_t uint32_t;
    typedef ::mozilla::gfx::GfxVarValue GfxVarValue;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    GfxVarUpdate() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT GfxVarUpdate(
            const uint32_t& _index,
            const GfxVarValue& _value) :
        value_(_value),
        index_(_index)
    {
    }

    MOZ_IMPLICIT GfxVarUpdate(
            uint32_t&& _index,
            GfxVarValue&& _value) :
        value_(std::move(_value)),
        index_(std::move(_index))
    {
    }

    uint32_t&
    index()
    {
        return index_;
    }
    const uint32_t&
    index() const
    {
        return index_;
    }

    GfxVarValue&
    value()
    {
        return value_;
    }
    const GfxVarValue&
    value() const
    {
        return value_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<GfxVarValue> value_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> index_;
};
} // namespace gfx
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::gfx::GfxVarUpdate>
{
    typedef ::mozilla::gfx::GfxVarUpdate paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct GfxInfoFeatureStatus|
//
namespace mozilla {
namespace gfx {
class GfxInfoFeatureStatus final
{
private:
    typedef ::int32_t int32_t;
    typedef ::nsCString nsCString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    GfxInfoFeatureStatus() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT GfxInfoFeatureStatus(
            const int32_t& _feature,
            const int32_t& _status,
            const nsCString& _failureId) :
        failureId_(_failureId),
        feature_(_feature),
        status_(_status)
    {
    }

    MOZ_IMPLICIT GfxInfoFeatureStatus(
            int32_t&& _feature,
            int32_t&& _status,
            nsCString&& _failureId) :
        failureId_(std::move(_failureId)),
        feature_(std::move(_feature)),
        status_(std::move(_status))
    {
    }

    int32_t&
    feature()
    {
        return feature_;
    }
    const int32_t&
    feature() const
    {
        return feature_;
    }

    int32_t&
    status()
    {
        return status_;
    }
    const int32_t&
    status() const
    {
        return status_;
    }

    nsCString&
    failureId()
    {
        return failureId_;
    }
    const nsCString&
    failureId() const
    {
        return failureId_;
    }

private:
    void
    StaticAssertions() const;
    ::mozilla::ipc::IPDLStructMember<nsCString> failureId_;
    ::mozilla::ipc::IPDLStructMember<int32_t> feature_;
    ::mozilla::ipc::IPDLStructMember<int32_t> status_;
};
} // namespace gfx
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::gfx::GfxInfoFeatureStatus>
{
    typedef ::mozilla::gfx::GfxInfoFeatureStatus paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC

#endif // ifndef GraphicsMessages_h
