/* THIS FILE IS AUTOGENERATED FROM DOMCollectedFrames.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "DOMCollectedFramesBinding.h"
#include "MainThreadUtils.h"
#include "js/Array.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/ForOfIterator.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/FloatingPoint.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/SimpleGlobalObject.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;



DOMCollectedFrame::DOMCollectedFrame()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
DOMCollectedFrame::InitIds(JSContext* cx, DOMCollectedFrameAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->timeOffset_id.init(cx, "timeOffset") ||
      !atomsCache->dataUri_id.init(cx, "dataUri")) {
    return false;
  }
  return true;
}

bool
DOMCollectedFrame::Init(const char* sourceDescription, bool passedToJSImpl)
{
  return true;
}

bool
DOMCollectedFrame::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  DOMCollectedFrameAtoms* atomsCache = GetAtomCache<DOMCollectedFrameAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsCString const & currentValue = mDataUri;
    if (!NonVoidByteStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->dataUri_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    double const & currentValue = mTimeOffset;
    temp.set(JS_NumberValue(double(currentValue)));
    if (!JS_DefinePropertyById(cx, obj, atomsCache->timeOffset_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
DOMCollectedFrame::TraceDictionary(JSTracer* trc)
{
}

DOMCollectedFrame&
DOMCollectedFrame::operator=(const DOMCollectedFrame& aOther)
{
  DictionaryBase::operator=(aOther);
  mDataUri = aOther.mDataUri;
  mTimeOffset = aOther.mTimeOffset;
  return *this;
}



DOMCollectedFrames::DOMCollectedFrames()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
DOMCollectedFrames::InitIds(JSContext* cx, DOMCollectedFramesAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->recordingStart_id.init(cx, "recordingStart") ||
      !atomsCache->frames_id.init(cx, "frames")) {
    return false;
  }
  return true;
}

bool
DOMCollectedFrames::Init(const char* sourceDescription, bool passedToJSImpl)
{
  return true;
}

bool
DOMCollectedFrames::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  DOMCollectedFramesAtoms* atomsCache = GetAtomCache<DOMCollectedFramesAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Sequence<DOMCollectedFrame> const & currentValue = mFrames;

    uint32_t length = currentValue.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      return false;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
            return false;
          }
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          return false;
        }
      }
    }
    temp.setObject(*returnArray);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->frames_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    double const & currentValue = mRecordingStart;
    temp.set(JS_NumberValue(double(currentValue)));
    if (!JS_DefinePropertyById(cx, obj, atomsCache->recordingStart_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
DOMCollectedFrames::TraceDictionary(JSTracer* trc)
{
}

DOMCollectedFrames&
DOMCollectedFrames::operator=(const DOMCollectedFrames& aOther)
{
  DictionaryBase::operator=(aOther);
  mFrames = aOther.mFrames;
  mRecordingStart = aOther.mRecordingStart;
  return *this;
}


} // namespace mozilla::dom
