/* app_sound_control.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from app_sound_control.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "org.buddiesofbudgie.budgie-desktop.raven.widget.SoundOutput.h"
#include <pulse/pulseaudio.h>
#include <gvc-mixer-control.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gvc-mixer-stream.h>
#include <gio/gdesktopappinfo.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BUDGIE_APP_SOUND_CONTROL_0_PROPERTY,
	BUDGIE_APP_SOUND_CONTROL_NUM_PROPERTIES
};
static GParamSpec* budgie_app_sound_control_properties[BUDGIE_APP_SOUND_CONTROL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _BudgieAppSoundControlPrivate {
	GvcMixerControl* mixer;
	GtkBox* app_info_header;
	GtkImage* app_image;
	GtkLabel* app_label;
	GtkButton* app_mute_button;
	GtkScale* volume_slider;
	guint32* volume;
	GtkImage* audio_not_muted;
	GtkImage* audio_muted;
	gulong scale_id;
};

static gint BudgieAppSoundControl_private_offset;
static gpointer budgie_app_sound_control_parent_class = NULL;
static GType budgie_app_sound_control_type_id = 0;

static void budgie_app_sound_control_toggle_mute_state (BudgieAppSoundControl* self);
static void _budgie_app_sound_control_toggle_mute_state_gtk_button_clicked (GtkButton* _sender,
                                                                     gpointer self);
static guint32 budgie_app_sound_control_get_base_volume (BudgieAppSoundControl* self);
static void budgie_app_sound_control_set_mute_ui (BudgieAppSoundControl* self);
static guint32* _uint32_dup (guint32* self);
static void budgie_app_sound_control_on_slider_change (BudgieAppSoundControl* self);
static void _budgie_app_sound_control_on_slider_change_gtk_range_value_changed (GtkRange* _sender,
                                                                         gpointer self);
static void budgie_app_sound_control_finalize (GObject * obj);

static inline gpointer
budgie_app_sound_control_get_instance_private (BudgieAppSoundControl* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieAppSoundControl_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
_budgie_app_sound_control_toggle_mute_state_gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self)
{
	budgie_app_sound_control_toggle_mute_state ((BudgieAppSoundControl*) self);
}

static guint32*
_uint32_dup (guint32* self)
{
	guint32* dup;
	dup = g_new0 (guint32, 1);
	memcpy (dup, self, sizeof (guint32));
	return dup;
}

static gpointer
__uint32_dup0 (gpointer self)
{
	return self ? _uint32_dup (self) : NULL;
}

static void
_budgie_app_sound_control_on_slider_change_gtk_range_value_changed (GtkRange* _sender,
                                                                    gpointer self)
{
	budgie_app_sound_control_on_slider_change ((BudgieAppSoundControl*) self);
}

BudgieAppSoundControl*
budgie_app_sound_control_construct (GType object_type,
                                    GvcMixerControl* c_mixer,
                                    GvcMixerStream* c_primary,
                                    GvcMixerStream* c_stream,
                                    const gchar* c_icon,
                                    const gchar* c_name)
{
	BudgieAppSoundControl * self = NULL;
	GvcMixerControl* _tmp0_;
	GvcMixerStream* _tmp1_;
	GvcMixerStream* _tmp2_;
	gchar* _tmp3_;
	gchar* alsa_beg = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GDesktopAppInfo* info = NULL;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GDesktopAppInfo* _tmp18_;
	GDesktopAppInfo* _tmp19_;
	GDesktopAppInfo* _tmp20_;
	gchar* stream_name = NULL;
	GvcMixerStream* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	GtkIconTheme* current_theme = NULL;
	GtkIconTheme* _tmp31_;
	GtkIconTheme* _tmp32_;
	gchar* usable_icon_name = NULL;
	gchar* _tmp33_;
	GtkIconTheme* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp42_;
	GtkImage* _tmp52_;
	GtkImage* _tmp53_;
	GtkImage* _tmp54_;
	GtkImage* _tmp55_;
	GtkBox* app_info = NULL;
	GtkBox* _tmp56_;
	GtkBox* _tmp57_;
	const gchar* _tmp58_;
	GtkLabel* _tmp59_;
	GtkLabel* _tmp60_;
	GtkLabel* _tmp61_;
	GtkLabel* _tmp62_;
	GtkLabel* _tmp63_;
	GtkButton* _tmp64_;
	GtkButton* _tmp65_;
	GtkStyleContext* _tmp66_;
	GtkButton* _tmp67_;
	GtkBox* _tmp68_;
	GtkLabel* _tmp69_;
	GtkBox* _tmp70_;
	GtkButton* _tmp71_;
	guint32 max_vol = 0U;
	guint32 stream_volume = 0U;
	GvcMixerStream* _tmp72_;
	guint32 max_vol_step = 0U;
	GtkScale* _tmp73_;
	GtkScale* _tmp74_;
	GtkScale* _tmp75_;
	guint32* _tmp76_;
	GtkScale* _tmp77_;
	GtkScale* _tmp78_;
	gulong _tmp79_;
	GtkBox* _tmp80_;
	GtkBox* _tmp81_;
	GtkBox* _tmp82_;
	GtkScale* _tmp83_;
	const gchar* _tmp84_;
	GtkImage* _tmp85_;
	GtkImage* _tmp86_;
	GtkBox* _tmp88_;
	g_return_val_if_fail (c_mixer != NULL, NULL);
	g_return_val_if_fail (c_primary != NULL, NULL);
	g_return_val_if_fail (c_stream != NULL, NULL);
	g_return_val_if_fail (c_icon != NULL, NULL);
	g_return_val_if_fail (c_name != NULL, NULL);
	self = (BudgieAppSoundControl*) g_object_new (object_type, "orientation", GTK_ORIENTATION_HORIZONTAL, "margin", 4, NULL);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_START);
	gtk_widget_set_margin_start ((GtkWidget*) self, 10);
	gtk_widget_set_margin_end ((GtkWidget*) self, 10);
	if (c_mixer == NULL) {
		return self;
	}
	if (c_primary == NULL) {
		return self;
	}
	_tmp0_ = _g_object_ref0 (c_mixer);
	_g_object_unref0 (self->priv->mixer);
	self->priv->mixer = _tmp0_;
	_tmp1_ = _g_object_ref0 (c_primary);
	_g_object_unref0 (self->primary_stream);
	self->primary_stream = _tmp1_;
	_tmp2_ = _g_object_ref0 (c_stream);
	_g_object_unref0 (self->stream);
	self->stream = _tmp2_;
	_tmp3_ = g_strdup (c_name);
	_g_free0 (self->app_name);
	self->app_name = _tmp3_;
	_tmp4_ = g_strdup ("ALSA plug-in [");
	alsa_beg = _tmp4_;
	_tmp5_ = self->app_name;
	_tmp6_ = alsa_beg;
	if (g_str_has_prefix (_tmp5_, _tmp6_)) {
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gchar* _tmp14_;
		_tmp7_ = self->app_name;
		_tmp8_ = alsa_beg;
		_tmp9_ = string_replace (_tmp7_, _tmp8_, "");
		_g_free0 (self->app_name);
		self->app_name = _tmp9_;
		_tmp10_ = self->app_name;
		_tmp11_ = self->app_name;
		_tmp12_ = strlen (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = string_substring (_tmp10_, (glong) 0, (glong) (_tmp13_ - 1));
		_g_free0 (self->app_name);
		self->app_name = _tmp14_;
	}
	_tmp15_ = self->app_name;
	_tmp16_ = g_strconcat (_tmp15_, ".desktop", NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_desktop_app_info_new (_tmp17_);
	_tmp19_ = _tmp18_;
	_g_free0 (_tmp17_);
	info = _tmp19_;
	_tmp20_ = info;
	if (_tmp20_ != NULL) {
		gchar* desktop_app_name = NULL;
		GDesktopAppInfo* _tmp21_;
		gchar* _tmp22_;
		gboolean _tmp23_ = FALSE;
		const gchar* _tmp24_;
		_tmp21_ = info;
		_tmp22_ = g_desktop_app_info_get_string (_tmp21_, "Name");
		desktop_app_name = _tmp22_;
		_tmp24_ = desktop_app_name;
		if (g_strcmp0 (_tmp24_, "") != 0) {
			const gchar* _tmp25_;
			_tmp25_ = desktop_app_name;
			_tmp23_ = _tmp25_ != NULL;
		} else {
			_tmp23_ = FALSE;
		}
		if (_tmp23_) {
			const gchar* _tmp26_;
			gchar* _tmp27_;
			_tmp26_ = desktop_app_name;
			_tmp27_ = g_strdup (_tmp26_);
			_g_free0 (self->app_name);
			self->app_name = _tmp27_;
		}
		_g_free0 (desktop_app_name);
	}
	_tmp28_ = self->stream;
	_tmp29_ = gvc_mixer_stream_get_name (_tmp28_);
	_tmp30_ = g_strdup (_tmp29_);
	stream_name = _tmp30_;
	_tmp31_ = gtk_icon_theme_get_default ();
	_tmp32_ = _g_object_ref0 (_tmp31_);
	current_theme = _tmp32_;
	_tmp33_ = g_strdup (c_icon);
	usable_icon_name = _tmp33_;
	_tmp34_ = current_theme;
	_tmp35_ = self->app_name;
	if (gtk_icon_theme_has_icon (_tmp34_, _tmp35_)) {
		const gchar* _tmp36_;
		gchar* _tmp37_;
		_tmp36_ = self->app_name;
		_tmp37_ = g_strdup (_tmp36_);
		_g_free0 (usable_icon_name);
		usable_icon_name = _tmp37_;
	} else {
		GtkIconTheme* _tmp38_;
		const gchar* _tmp39_;
		_tmp38_ = current_theme;
		_tmp39_ = stream_name;
		if (gtk_icon_theme_has_icon (_tmp38_, _tmp39_)) {
			const gchar* _tmp40_;
			gchar* _tmp41_;
			_tmp40_ = stream_name;
			_tmp41_ = g_strdup (_tmp40_);
			_g_free0 (usable_icon_name);
			usable_icon_name = _tmp41_;
		}
	}
	_tmp42_ = usable_icon_name;
	if (g_strcmp0 (_tmp42_, "applications-multimedia") != 0) {
		const gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		const gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		_tmp43_ = self->app_name;
		_tmp44_ = string_substring (_tmp43_, (glong) 0, (glong) 1);
		_tmp45_ = _tmp44_;
		_tmp46_ = g_ascii_strup (_tmp45_, (gssize) -1);
		_tmp47_ = _tmp46_;
		_tmp48_ = self->app_name;
		_tmp49_ = string_substring (_tmp48_, (glong) 1, (glong) -1);
		_tmp50_ = _tmp49_;
		_tmp51_ = g_strconcat (_tmp47_, _tmp50_, NULL);
		_g_free0 (self->app_name);
		self->app_name = _tmp51_;
		_g_free0 (_tmp50_);
		_g_free0 (_tmp47_);
		_g_free0 (_tmp45_);
	}
	_tmp52_ = (GtkImage*) gtk_image_new_from_icon_name ("audio-volume-high-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp52_);
	_g_object_unref0 (self->priv->audio_not_muted);
	self->priv->audio_not_muted = _tmp52_;
	_tmp53_ = self->priv->audio_not_muted;
	gtk_image_set_pixel_size (_tmp53_, 12);
	_tmp54_ = (GtkImage*) gtk_image_new_from_icon_name ("audio-volume-muted-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp54_);
	_g_object_unref0 (self->priv->audio_muted);
	self->priv->audio_muted = _tmp54_;
	_tmp55_ = self->priv->audio_muted;
	gtk_image_set_pixel_size (_tmp55_, 12);
	_tmp56_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp56_);
	app_info = _tmp56_;
	_tmp57_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp57_);
	_g_object_unref0 (self->priv->app_info_header);
	self->priv->app_info_header = _tmp57_;
	_tmp58_ = self->app_name;
	_tmp59_ = (GtkLabel*) gtk_label_new (_tmp58_);
	g_object_ref_sink (_tmp59_);
	_g_object_unref0 (self->priv->app_label);
	self->priv->app_label = _tmp59_;
	_tmp60_ = self->priv->app_label;
	gtk_label_set_ellipsize (_tmp60_, PANGO_ELLIPSIZE_END);
	_tmp61_ = self->priv->app_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp61_, GTK_ALIGN_START);
	_tmp62_ = self->priv->app_label;
	gtk_label_set_justify (_tmp62_, GTK_JUSTIFY_LEFT);
	_tmp63_ = self->priv->app_label;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp63_, 10);
	_tmp64_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp64_);
	_g_object_unref0 (self->priv->app_mute_button);
	self->priv->app_mute_button = _tmp64_;
	_tmp65_ = self->priv->app_mute_button;
	_tmp66_ = gtk_widget_get_style_context ((GtkWidget*) _tmp65_);
	gtk_style_context_add_class (_tmp66_, "flat");
	_tmp67_ = self->priv->app_mute_button;
	g_signal_connect_object (_tmp67_, "clicked", (GCallback) _budgie_app_sound_control_toggle_mute_state_gtk_button_clicked, self, 0);
	_tmp68_ = self->priv->app_info_header;
	_tmp69_ = self->priv->app_label;
	gtk_box_pack_start (_tmp68_, (GtkWidget*) _tmp69_, FALSE, TRUE, (guint) 0);
	_tmp70_ = self->priv->app_info_header;
	_tmp71_ = self->priv->app_mute_button;
	gtk_box_pack_end (_tmp70_, (GtkWidget*) _tmp71_, FALSE, FALSE, (guint) 0);
	max_vol = budgie_app_sound_control_get_base_volume (self);
	_tmp72_ = self->stream;
	stream_volume = gvc_mixer_stream_get_volume (_tmp72_);
	max_vol_step = max_vol / 20;
	_tmp73_ = (GtkScale*) gtk_scale_new_with_range (GTK_ORIENTATION_HORIZONTAL, (gdouble) 0, (gdouble) max_vol, (gdouble) max_vol_step);
	g_object_ref_sink (_tmp73_);
	_g_object_unref0 (self->priv->volume_slider);
	self->priv->volume_slider = _tmp73_;
	_tmp74_ = self->priv->volume_slider;
	gtk_scale_set_draw_value (_tmp74_, FALSE);
	_tmp75_ = self->priv->volume_slider;
	gtk_range_set_increments ((GtkRange*) _tmp75_, (gdouble) max_vol_step, (gdouble) max_vol_step);
	budgie_app_sound_control_set_mute_ui (self);
	_tmp76_ = __uint32_dup0 (&stream_volume);
	_g_free0 (self->priv->volume);
	self->priv->volume = _tmp76_;
	_tmp77_ = self->priv->volume_slider;
	gtk_range_set_value ((GtkRange*) _tmp77_, (gdouble) stream_volume);
	_tmp78_ = self->priv->volume_slider;
	_tmp79_ = g_signal_connect_object ((GtkRange*) _tmp78_, "value-changed", (GCallback) _budgie_app_sound_control_on_slider_change_gtk_range_value_changed, self, 0);
	self->priv->scale_id = _tmp79_;
	_tmp80_ = app_info;
	_tmp81_ = self->priv->app_info_header;
	gtk_box_pack_start (_tmp80_, (GtkWidget*) _tmp81_, TRUE, FALSE, (guint) 0);
	_tmp82_ = app_info;
	_tmp83_ = self->priv->volume_slider;
	gtk_box_pack_end (_tmp82_, (GtkWidget*) _tmp83_, TRUE, FALSE, (guint) 0);
	_tmp84_ = usable_icon_name;
	_tmp85_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp84_, (GtkIconSize) GTK_ICON_SIZE_DND);
	g_object_ref_sink (_tmp85_);
	_g_object_unref0 (self->priv->app_image);
	self->priv->app_image = _tmp85_;
	_tmp86_ = self->priv->app_image;
	if (_tmp86_ != NULL) {
		GtkImage* _tmp87_;
		_tmp87_ = self->priv->app_image;
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp87_, FALSE, FALSE, (guint) 0);
	}
	_tmp88_ = app_info;
	gtk_box_pack_end ((GtkBox*) self, (GtkWidget*) _tmp88_, TRUE, TRUE, (guint) 0);
	_g_object_unref0 (app_info);
	_g_free0 (usable_icon_name);
	_g_object_unref0 (current_theme);
	_g_free0 (stream_name);
	_g_object_unref0 (info);
	_g_free0 (alsa_beg);
	return self;
}

BudgieAppSoundControl*
budgie_app_sound_control_new (GvcMixerControl* c_mixer,
                              GvcMixerStream* c_primary,
                              GvcMixerStream* c_stream,
                              const gchar* c_icon,
                              const gchar* c_name)
{
	return budgie_app_sound_control_construct (BUDGIE_TYPE_APP_SOUND_CONTROL, c_mixer, c_primary, c_stream, c_icon, c_name);
}

/**
 * get_base_volume will get the recommended base volume based on the stream and primary device stream
 */
static guint32
budgie_app_sound_control_get_base_volume (BudgieAppSoundControl* self)
{
	guint32 base_vol = 0U;
	GvcMixerStream* _tmp0_;
	guint32 primary_stream_vol = 0U;
	GvcMixerStream* _tmp1_;
	guint32 _tmp2_ = 0U;
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->stream;
	base_vol = gvc_mixer_stream_get_volume (_tmp0_);
	_tmp1_ = self->primary_stream;
	primary_stream_vol = gvc_mixer_stream_get_base_volume (_tmp1_);
	if (base_vol < primary_stream_vol) {
		_tmp2_ = primary_stream_vol;
	} else {
		_tmp2_ = base_vol;
	}
	result = _tmp2_;
	return result;
}

/**
 * on_slider_change will handle when our volume_slider scale changes
 */
static void
budgie_app_sound_control_on_slider_change (BudgieAppSoundControl* self)
{
	gdouble slider_value = 0.0;
	GtkScale* _tmp0_;
	GtkScale* _tmp1_;
	guint32 stream_vol = 0U;
	guint32* _tmp2_;
	GvcMixerStream* _tmp3_;
	GtkScale* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->volume_slider;
	slider_value = gtk_range_get_value ((GtkRange*) _tmp0_);
	_tmp1_ = self->priv->volume_slider;
	g_signal_handler_block (_tmp1_, self->priv->scale_id);
	stream_vol = (guint32) slider_value;
	_tmp2_ = __uint32_dup0 (&stream_vol);
	_g_free0 (self->priv->volume);
	self->priv->volume = _tmp2_;
	_tmp3_ = self->stream;
	if (gvc_mixer_stream_set_volume (_tmp3_, stream_vol)) {
		GvcMixerStream* _tmp4_;
		_tmp4_ = self->stream;
		gvc_mixer_stream_push_volume (_tmp4_);
	}
	_tmp5_ = self->priv->volume_slider;
	g_signal_handler_unblock (_tmp5_, self->priv->scale_id);
}

/**
 * refresh is responsible for performing UI refresh / updating
 */
void
budgie_app_sound_control_refresh (BudgieAppSoundControl* self)
{
	gchar* stream_name = NULL;
	GvcMixerStream* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->stream;
	_tmp1_ = gvc_mixer_stream_get_name (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	stream_name = _tmp2_;
	_tmp3_ = self->app_name;
	_tmp4_ = stream_name;
	if (g_strcmp0 (_tmp3_, _tmp4_) != 0) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		GtkLabel* _tmp7_;
		const gchar* _tmp8_;
		_tmp5_ = stream_name;
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (self->app_name);
		self->app_name = _tmp6_;
		_tmp7_ = self->priv->app_label;
		_tmp8_ = stream_name;
		gtk_label_set_label (_tmp7_, _tmp8_);
	}
	budgie_app_sound_control_refresh_volume (self);
	_g_free0 (stream_name);
}

/**
 * refresh_volume is our function for updating the volume slider and mute UI
 */
void
budgie_app_sound_control_refresh_volume (BudgieAppSoundControl* self)
{
	guint32 vol = 0U;
	GvcMixerStream* _tmp0_;
	GtkScale* _tmp1_;
	guint32* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->stream;
	vol = gvc_mixer_stream_get_volume (_tmp0_);
	_tmp1_ = self->priv->volume_slider;
	if (gtk_range_get_value ((GtkRange*) _tmp1_) != ((gdouble) vol)) {
		GtkScale* _tmp2_;
		_tmp2_ = self->priv->volume_slider;
		gtk_range_set_value ((GtkRange*) _tmp2_, (gdouble) vol);
	}
	_tmp3_ = __uint32_dup0 (&vol);
	_g_free0 (self->priv->volume);
	self->priv->volume = _tmp3_;
	budgie_app_sound_control_set_mute_ui (self);
}

/**
 * set_mute_ui will set the image for the app_mute_button and change dim state of the input
 */
static void
budgie_app_sound_control_set_mute_ui (BudgieAppSoundControl* self)
{
	GvcMixerStream* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->stream;
	if (gvc_mixer_stream_get_is_muted (_tmp0_)) {
		GtkButton* _tmp1_;
		GtkImage* _tmp2_;
		_tmp1_ = self->priv->app_mute_button;
		_tmp2_ = self->priv->audio_muted;
		gtk_button_set_image (_tmp1_, (GtkWidget*) _tmp2_);
	} else {
		GtkButton* _tmp3_;
		GtkImage* _tmp4_;
		_tmp3_ = self->priv->app_mute_button;
		_tmp4_ = self->priv->audio_not_muted;
		gtk_button_set_image (_tmp3_, (GtkWidget*) _tmp4_);
	}
}

static void
budgie_app_sound_control_toggle_mute_state (BudgieAppSoundControl* self)
{
	GtkScale* _tmp0_;
	GvcMixerStream* _tmp1_;
	GvcMixerStream* _tmp2_;
	GvcMixerStream* _tmp3_;
	GvcMixerStream* _tmp4_;
	GtkScale* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->volume_slider;
	g_signal_handler_block (_tmp0_, self->priv->scale_id);
	_tmp1_ = self->stream;
	_tmp2_ = self->stream;
	gvc_mixer_stream_change_is_muted (_tmp1_, !gvc_mixer_stream_get_is_muted (_tmp2_));
	_tmp3_ = self->stream;
	_tmp4_ = self->stream;
	gvc_mixer_stream_set_is_muted (_tmp3_, !gvc_mixer_stream_get_is_muted (_tmp4_));
	budgie_app_sound_control_set_mute_ui (self);
	_tmp5_ = self->priv->volume_slider;
	g_signal_handler_unblock (_tmp5_, self->priv->scale_id);
}

static void
budgie_app_sound_control_class_init (BudgieAppSoundControlClass * klass,
                                     gpointer klass_data)
{
	budgie_app_sound_control_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieAppSoundControl_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_app_sound_control_finalize;
}

static void
budgie_app_sound_control_instance_init (BudgieAppSoundControl * self,
                                        gpointer klass)
{
	gchar* _tmp0_;
	self->priv = budgie_app_sound_control_get_instance_private (self);
	self->priv->mixer = NULL;
	self->primary_stream = NULL;
	self->stream = NULL;
	self->priv->app_info_header = NULL;
	self->priv->app_image = NULL;
	self->priv->app_label = NULL;
	self->priv->app_mute_button = NULL;
	self->priv->volume_slider = NULL;
	self->priv->audio_not_muted = NULL;
	self->priv->audio_muted = NULL;
	_tmp0_ = g_strdup ("");
	self->app_name = _tmp0_;
}

static void
budgie_app_sound_control_finalize (GObject * obj)
{
	BudgieAppSoundControl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_APP_SOUND_CONTROL, BudgieAppSoundControl);
	_g_object_unref0 (self->priv->mixer);
	_g_object_unref0 (self->primary_stream);
	_g_object_unref0 (self->stream);
	_g_object_unref0 (self->priv->app_info_header);
	_g_object_unref0 (self->priv->app_image);
	_g_object_unref0 (self->priv->app_label);
	_g_object_unref0 (self->priv->app_mute_button);
	_g_object_unref0 (self->priv->volume_slider);
	_g_free0 (self->priv->volume);
	_g_object_unref0 (self->priv->audio_not_muted);
	_g_object_unref0 (self->priv->audio_muted);
	_g_free0 (self->app_name);
	G_OBJECT_CLASS (budgie_app_sound_control_parent_class)->finalize (obj);
}

GType
budgie_app_sound_control_get_type (void)
{
	return budgie_app_sound_control_type_id;
}

GType
budgie_app_sound_control_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieAppSoundControlClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_app_sound_control_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieAppSoundControl), 0, (GInstanceInitFunc) budgie_app_sound_control_instance_init, NULL };
	budgie_app_sound_control_type_id = g_type_module_register_type (module, gtk_box_get_type (), "BudgieAppSoundControl", &g_define_type_info, 0);
	BudgieAppSoundControl_private_offset = sizeof (BudgieAppSoundControlPrivate);
	return budgie_app_sound_control_type_id;
}

