/* src/bazaar.p/bz-repository.h
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#include <glib-object.h>


G_BEGIN_DECLS



#define BZ_TYPE_REPOSITORY (bz_repository_get_type ())
G_DECLARE_FINAL_TYPE (BzRepository, bz_repository, BZ, REPOSITORY, GObject)

BzRepository *
bz_repository_new (void);

gboolean
bz_repository_get_is_user (BzRepository *self);

const char *
bz_repository_get_title (BzRepository *self);

const char *
bz_repository_get_url (BzRepository *self);

const char *
bz_repository_get_name (BzRepository *self);

void
bz_repository_set_is_user (BzRepository *self,
    gboolean is_user);

void
bz_repository_set_title (BzRepository *self,
    const char *title);

void
bz_repository_set_url (BzRepository *self,
    const char *url);

void
bz_repository_set_name (BzRepository *self,
    const char *name);

G_END_DECLS

/* End of src/bazaar.p/bz-repository.h */
