import { CancellationToken, Location, Position, ReferenceContext } from 'vscode-languageserver';
import { Document } from '../../../lib/documents';
import { FindComponentReferencesProvider, FindReferencesProvider } from '../../interfaces';
import { LSAndTSDocResolver } from '../LSAndTSDocResolver';
export declare class FindReferencesProviderImpl implements FindReferencesProvider {
    private readonly lsAndTsDocResolver;
    private readonly componentReferencesProvider;
    constructor(lsAndTsDocResolver: LSAndTSDocResolver, componentReferencesProvider: FindComponentReferencesProvider);
    findReferences(document: Document, position: Position, context: ReferenceContext, cancellationToken?: CancellationToken): Promise<Location[] | null>;
    private isScriptStartOrEndTag;
    private isPositionForComponentCodeLens;
    /**
     * If references of a $store are searched, also find references for the corresponding store
     * and vice versa.
     */
    private getStoreReferences;
    private checkIfHasAliasedComponentReference;
    private mapReference;
    private getLSAndTSDoc;
}
