/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.VariableSimpleIF;

public class VariableSimpleImpl
implements VariableSimpleIF {
    private final String name;
    private final String desc;
    private final String units;
    private final DataType dt;
    private final List<Attribute> atts = new ArrayList<Attribute>();
    private final List<Dimension> dims;
    private final int[] shape;

    public static VariableSimpleImpl makeScalar(String name, String desc, String units, DataType dt) {
        return new VariableSimpleImpl(name, desc, units, dt, null);
    }

    public static VariableSimpleImpl makeString(String name, String desc, String units, int str_len) {
        Dimension d = new Dimension(name + "_strlen", str_len, false, false, false);
        return new VariableSimpleImpl(name, desc, units, DataType.CHAR, Arrays.asList(d));
    }

    public static VariableSimpleImpl changeShape(VariableSimpleIF proxy, List<Dimension> dims) {
        VariableSimpleImpl result = new VariableSimpleImpl(proxy.getShortName(), proxy.getDescription(), proxy.getUnitsString(), proxy.getDataType(), dims);
        for (Attribute att : proxy.getAttributes()) {
            result.add(att);
        }
        return result;
    }

    VariableSimpleImpl(String name, String desc, String units, DataType dt, List<Dimension> dims) {
        this.name = name;
        this.desc = desc;
        this.units = units;
        this.dt = dt;
        if (dims == null) {
            this.dims = new ArrayList<Dimension>();
            this.shape = new int[0];
        } else {
            this.dims = dims;
            this.shape = new int[dims.size()];
            int count = 0;
            for (Dimension d : dims) {
                this.shape[count++] = d.getLength();
            }
        }
        if (units != null) {
            this.atts.add(new Attribute("units", units));
        }
        if (desc != null) {
            this.atts.add(new Attribute("long_name", desc));
        }
    }

    public VariableSimpleImpl add(Attribute att) {
        this.atts.add(att);
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullName() {
        return this.name;
    }

    @Override
    public String getShortName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public String getUnitsString() {
        return this.units;
    }

    @Override
    public int getRank() {
        return this.shape.length;
    }

    @Override
    public int[] getShape() {
        return this.shape;
    }

    @Override
    public List<Dimension> getDimensions() {
        return this.dims;
    }

    @Override
    public DataType getDataType() {
        return this.dt;
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.atts;
    }

    @Override
    public Attribute findAttributeIgnoreCase(String name) {
        for (Attribute att : this.atts) {
            if (!att.getShortName().equalsIgnoreCase(name)) continue;
            return att;
        }
        return null;
    }

    @Override
    public int compareTo(VariableSimpleIF o) {
        return this.name.compareTo(o.getShortName());
    }
}

