/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.value.constant;

import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import org.apache.solr.analytics.facet.compare.ConstantComparator;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.constant.ConstantValue;

public class ConstantDoubleValue
extends ConstantValue
implements DoubleValue.CastingDoubleValue {
    private final double value;
    private final String valueStr;
    public static final String name = "const_double";
    private final String exprStr;

    public ConstantDoubleValue(double value) {
        this.value = value;
        this.valueStr = Double.toString(value);
        this.exprStr = ConstantValue.createExpressionString(this, this.valueStr);
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public String getString() {
        return this.valueStr;
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public void streamDoubles(DoubleConsumer cons) {
        cons.accept(this.value);
    }

    @Override
    public void streamStrings(Consumer<String> cons) {
        cons.accept(this.valueStr);
    }

    @Override
    public void streamObjects(Consumer<Object> cons) {
        cons.accept(this.value);
    }

    @Override
    public ConstantComparator getObjectComparator(String expression) {
        return new ConstantComparator();
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return AnalyticsValueStream.ExpressionType.CONST;
    }
}

