/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.QueryTimeout;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.LRUQueryCache;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TaskExecutor;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.TimeLimitingBulkScorer;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopFieldCollectorManager;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TopScoreDocCollectorManager;
import org.apache.lucene.search.TotalHitCountCollectorManager;
import org.apache.lucene.search.UsageTrackingQueryCachingPolicy;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.BM25Similarity;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.automaton.ByteRunAutomaton;

public class IndexSearcher {
    static int maxClauseCount = 1024;
    private static QueryCache DEFAULT_QUERY_CACHE;
    private static QueryCachingPolicy DEFAULT_CACHING_POLICY;
    private QueryTimeout queryTimeout = null;
    private volatile boolean partialResult = false;
    private static final int TOTAL_HITS_THRESHOLD = 1000;
    private static final int MAX_DOCS_PER_SLICE = 250000;
    private static final int MAX_SEGMENTS_PER_SLICE = 5;
    final IndexReader reader;
    protected final IndexReaderContext readerContext;
    protected final List<LeafReaderContext> leafContexts;
    private final Supplier<LeafSlice[]> leafSlicesSupplier;
    private final Executor executor;
    private final TaskExecutor taskExecutor;
    private static final Similarity defaultSimilarity;
    private QueryCache queryCache = DEFAULT_QUERY_CACHE;
    private QueryCachingPolicy queryCachingPolicy = DEFAULT_CACHING_POLICY;
    private Similarity similarity = defaultSimilarity;

    public static Similarity getDefaultSimilarity() {
        return defaultSimilarity;
    }

    public List<LeafReaderContext> getLeafContexts() {
        return this.leafContexts;
    }

    public static QueryCache getDefaultQueryCache() {
        return DEFAULT_QUERY_CACHE;
    }

    public static void setDefaultQueryCache(QueryCache defaultQueryCache) {
        DEFAULT_QUERY_CACHE = defaultQueryCache;
    }

    public static QueryCachingPolicy getDefaultQueryCachingPolicy() {
        return DEFAULT_CACHING_POLICY;
    }

    public static void setDefaultQueryCachingPolicy(QueryCachingPolicy defaultQueryCachingPolicy) {
        DEFAULT_CACHING_POLICY = defaultQueryCachingPolicy;
    }

    public IndexSearcher(IndexReader r) {
        this(r, null);
    }

    public IndexSearcher(IndexReader r, Executor executor) {
        this(r.getContext(), executor);
    }

    public IndexSearcher(IndexReaderContext context, Executor executor) {
        assert (context.isTopLevel) : "IndexSearcher's ReaderContext must be topLevel for reader " + String.valueOf(context.reader());
        this.reader = context.reader();
        this.executor = executor;
        this.taskExecutor = executor == null ? new TaskExecutor(Runnable::run) : new TaskExecutor(executor);
        this.readerContext = context;
        this.leafContexts = context.leaves();
        Function<List<LeafReaderContext>, LeafSlice[]> slicesProvider = executor == null ? leaves -> {
            LeafSlice[] leafSliceArray;
            if (leaves.isEmpty()) {
                leafSliceArray = new LeafSlice[]{};
            } else {
                LeafSlice[] leafSliceArray2 = new LeafSlice[1];
                leafSliceArray = leafSliceArray2;
                leafSliceArray2[0] = new LeafSlice(new ArrayList<LeafReaderContext>((Collection<LeafReaderContext>)leaves));
            }
            return leafSliceArray;
        } : this::slices;
        this.leafSlicesSupplier = new CachingLeafSlicesSupplier(slicesProvider, this.leafContexts);
    }

    public IndexSearcher(IndexReaderContext context) {
        this(context, null);
    }

    public static int getMaxClauseCount() {
        return maxClauseCount;
    }

    public static void setMaxClauseCount(int value) {
        if (value < 1) {
            throw new IllegalArgumentException("maxClauseCount must be >= 1");
        }
        maxClauseCount = value;
    }

    public void setQueryCache(QueryCache queryCache) {
        this.queryCache = queryCache;
    }

    public QueryCache getQueryCache() {
        return this.queryCache;
    }

    public void setQueryCachingPolicy(QueryCachingPolicy queryCachingPolicy) {
        this.queryCachingPolicy = Objects.requireNonNull(queryCachingPolicy);
    }

    public QueryCachingPolicy getQueryCachingPolicy() {
        return this.queryCachingPolicy;
    }

    protected LeafSlice[] slices(List<LeafReaderContext> leaves) {
        return IndexSearcher.slices(leaves, 250000, 5);
    }

    public static LeafSlice[] slices(List<LeafReaderContext> leaves, int maxDocsPerSlice, int maxSegmentsPerSlice) {
        ArrayList<LeafReaderContext> sortedLeaves = new ArrayList<LeafReaderContext>(leaves);
        Collections.sort(sortedLeaves, Collections.reverseOrder(Comparator.comparingInt(l -> l.reader().maxDoc())));
        ArrayList<List<LeafReaderContext>> groupedLeaves = new ArrayList<List<LeafReaderContext>>();
        long docSum = 0L;
        ArrayList<LeafReaderContext> group = null;
        for (LeafReaderContext ctx : sortedLeaves) {
            if (ctx.reader().maxDoc() > maxDocsPerSlice) {
                assert (group == null);
                groupedLeaves.add(Collections.singletonList(ctx));
                continue;
            }
            if (group == null) {
                group = new ArrayList<LeafReaderContext>();
                group.add(ctx);
                groupedLeaves.add(group);
            } else {
                group.add(ctx);
            }
            if (group.size() < maxSegmentsPerSlice && (docSum += (long)ctx.reader().maxDoc()) <= (long)maxDocsPerSlice) continue;
            group = null;
            docSum = 0L;
        }
        LeafSlice[] slices = new LeafSlice[groupedLeaves.size()];
        int upto = 0;
        for (List list : groupedLeaves) {
            slices[upto] = new LeafSlice(list);
            ++upto;
        }
        return slices;
    }

    public IndexReader getIndexReader() {
        return this.reader;
    }

    @Deprecated
    public Document doc(int docID) throws IOException {
        return this.reader.document(docID);
    }

    @Deprecated
    public void doc(int docID, StoredFieldVisitor fieldVisitor) throws IOException {
        this.reader.document(docID, fieldVisitor);
    }

    @Deprecated
    public Document doc(int docID, Set<String> fieldsToLoad) throws IOException {
        return this.reader.document(docID, fieldsToLoad);
    }

    public StoredFields storedFields() throws IOException {
        return this.reader.storedFields();
    }

    public void setSimilarity(Similarity similarity) {
        this.similarity = similarity;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public int count(Query query) throws IOException {
        if ((query = this.rewrite(new ConstantScoreQuery(query))) instanceof ConstantScoreQuery) {
            query = ((ConstantScoreQuery)query).getQuery();
        }
        if (query instanceof BooleanQuery && !this.reader.hasDeletions() && ((BooleanQuery)query).isTwoClausePureDisjunctionWithTerms()) {
            Query[] queries = ((BooleanQuery)query).rewriteTwoClauseDisjunctionWithTermsForCount(this);
            int countTerm1 = this.count(queries[0]);
            int countTerm2 = this.count(queries[1]);
            if (countTerm1 == 0 || countTerm2 == 0) {
                return Math.max(countTerm1, countTerm2);
            }
            if ((double)Math.min(countTerm1, countTerm2) / (double)Math.max(countTerm1, countTerm2) < 0.1) {
                return countTerm1 + countTerm2 - this.count(queries[2]);
            }
        }
        return this.search((Query)new ConstantScoreQuery(query), new TotalHitCountCollectorManager());
    }

    public final LeafSlice[] getSlices() {
        return this.leafSlicesSupplier.get();
    }

    public TopDocs searchAfter(ScoreDoc after, Query query, int numHits) throws IOException {
        int limit = Math.max(1, this.reader.maxDoc());
        if (after != null && after.doc >= limit) {
            throw new IllegalArgumentException("after.doc exceeds the number of documents in the reader: after.doc=" + after.doc + " limit=" + limit);
        }
        int cappedNumHits = Math.min(numHits, limit);
        boolean supportsConcurrency = this.getSlices().length > 1;
        TopScoreDocCollectorManager manager = new TopScoreDocCollectorManager(cappedNumHits, after, 1000, supportsConcurrency);
        return this.search(query, manager);
    }

    public QueryTimeout getTimeout() {
        return this.queryTimeout;
    }

    public void setTimeout(QueryTimeout queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public TopDocs search(Query query, int n) throws IOException {
        return this.searchAfter(null, query, n);
    }

    @Deprecated
    public void search(Query query, Collector results) throws IOException {
        query = this.rewrite(query, results.scoreMode().needsScores());
        this.search(this.leafContexts, this.createWeight(query, results.scoreMode(), 1.0f), results);
    }

    public boolean timedOut() {
        return this.partialResult;
    }

    public TopFieldDocs search(Query query, int n, Sort sort, boolean doDocScores) throws IOException {
        return this.searchAfter(null, query, n, sort, doDocScores);
    }

    public TopFieldDocs search(Query query, int n, Sort sort) throws IOException {
        return this.searchAfter(null, query, n, sort, false);
    }

    public TopDocs searchAfter(ScoreDoc after, Query query, int n, Sort sort) throws IOException {
        return this.searchAfter(after, query, n, sort, false);
    }

    public TopFieldDocs searchAfter(ScoreDoc after, Query query, int numHits, Sort sort, boolean doDocScores) throws IOException {
        if (after != null && !(after instanceof FieldDoc)) {
            throw new IllegalArgumentException("after must be a FieldDoc; got " + String.valueOf(after));
        }
        return this.searchAfter((FieldDoc)after, query, numHits, sort, doDocScores);
    }

    private TopFieldDocs searchAfter(FieldDoc after, Query query, int numHits, Sort sort, boolean doDocScores) throws IOException {
        int limit = Math.max(1, this.reader.maxDoc());
        if (after != null && after.doc >= limit) {
            throw new IllegalArgumentException("after.doc exceeds the number of documents in the reader: after.doc=" + after.doc + " limit=" + limit);
        }
        int cappedNumHits = Math.min(numHits, limit);
        Sort rewrittenSort = sort.rewrite(this);
        LeafSlice[] leafSlices = this.getSlices();
        boolean supportsConcurrency = leafSlices.length > 1;
        TopFieldCollectorManager manager = new TopFieldCollectorManager(rewrittenSort, cappedNumHits, after, 1000, supportsConcurrency);
        TopFieldDocs topDocs = this.search(query, manager);
        if (doDocScores) {
            TopFieldCollector.populateScores(topDocs.scoreDocs, this, query);
        }
        return topDocs;
    }

    public <C extends Collector, T> T search(Query query, CollectorManager<C, T> collectorManager) throws IOException {
        C firstCollector = collectorManager.newCollector();
        query = this.rewrite(query, firstCollector.scoreMode().needsScores());
        Weight weight = this.createWeight(query, firstCollector.scoreMode(), 1.0f);
        return this.search(weight, collectorManager, firstCollector);
    }

    private <C extends Collector, T> T search(Weight weight, CollectorManager<C, T> collectorManager, C firstCollector) throws IOException {
        LeafSlice[] leafSlices = this.getSlices();
        if (leafSlices.length == 0) {
            assert (this.leafContexts.isEmpty());
            return collectorManager.reduce(Collections.singletonList(firstCollector));
        }
        ArrayList<C> collectors = new ArrayList<C>(leafSlices.length);
        collectors.add(firstCollector);
        ScoreMode scoreMode = firstCollector.scoreMode();
        for (int i = 1; i < leafSlices.length; ++i) {
            C collector = collectorManager.newCollector();
            collectors.add(collector);
            if (scoreMode == collector.scoreMode()) continue;
            throw new IllegalStateException("CollectorManager does not always produce collectors with the same score mode");
        }
        ArrayList listTasks = new ArrayList(leafSlices.length);
        for (int i = 0; i < leafSlices.length; ++i) {
            LeafReaderContext[] leaves = leafSlices[i].leaves;
            Collector collector = (Collector)collectors.get(i);
            listTasks.add(() -> {
                this.search(Arrays.asList(leaves), weight, collector);
                return collector;
            });
        }
        List results = this.taskExecutor.invokeAll(listTasks);
        return collectorManager.reduce(results);
    }

    protected void search(List<LeafReaderContext> leaves, Weight weight, Collector collector) throws IOException {
        collector.setWeight(weight);
        for (LeafReaderContext ctx : leaves) {
            this.searchLeaf(ctx, weight, collector);
        }
    }

    protected void searchLeaf(LeafReaderContext ctx, Weight weight, Collector collector) throws IOException {
        LeafCollector leafCollector;
        try {
            leafCollector = collector.getLeafCollector(ctx);
        }
        catch (CollectionTerminatedException e) {
            return;
        }
        BulkScorer scorer = weight.bulkScorer(ctx);
        if (scorer != null) {
            if (this.queryTimeout != null) {
                scorer = new TimeLimitingBulkScorer(scorer, this.queryTimeout);
            }
            try {
                scorer.score(leafCollector, ctx.reader().getLiveDocs());
            }
            catch (CollectionTerminatedException collectionTerminatedException) {
            }
            catch (TimeLimitingBulkScorer.TimeExceededException e) {
                this.partialResult = true;
            }
        }
        leafCollector.finish();
    }

    public Query rewrite(Query original) throws IOException {
        Query query = original;
        Query rewrittenQuery = query.rewrite(this);
        while (rewrittenQuery != query) {
            query = rewrittenQuery;
            rewrittenQuery = query.rewrite(this);
        }
        query.visit(IndexSearcher.getNumClausesCheckVisitor());
        return query;
    }

    private Query rewrite(Query original, boolean needsScores) throws IOException {
        if (needsScores) {
            return this.rewrite(original);
        }
        return this.rewrite(new ConstantScoreQuery(original));
    }

    private static QueryVisitor getNumClausesCheckVisitor() {
        return new QueryVisitor(){
            int numClauses;

            @Override
            public QueryVisitor getSubVisitor(BooleanClause.Occur occur, Query parent) {
                return this;
            }

            @Override
            public void visitLeaf(Query query) {
                if (this.numClauses > maxClauseCount) {
                    throw new TooManyNestedClauses();
                }
                ++this.numClauses;
            }

            @Override
            public void consumeTerms(Query query, Term ... terms) {
                if (this.numClauses > maxClauseCount) {
                    throw new TooManyNestedClauses();
                }
                ++this.numClauses;
            }

            @Override
            public void consumeTermsMatching(Query query, String field, Supplier<ByteRunAutomaton> automaton) {
                if (this.numClauses > maxClauseCount) {
                    throw new TooManyNestedClauses();
                }
                ++this.numClauses;
            }
        };
    }

    public Explanation explain(Query query, int doc) throws IOException {
        query = this.rewrite(query);
        return this.explain(this.createWeight(query, ScoreMode.COMPLETE, 1.0f), doc);
    }

    protected Explanation explain(Weight weight, int doc) throws IOException {
        int n = ReaderUtil.subIndex(doc, this.leafContexts);
        LeafReaderContext ctx = this.leafContexts.get(n);
        int deBasedDoc = doc - ctx.docBase;
        Bits liveDocs = ctx.reader().getLiveDocs();
        if (liveDocs != null && !liveDocs.get(deBasedDoc)) {
            return Explanation.noMatch("Document " + doc + " is deleted", new Explanation[0]);
        }
        return weight.explain(ctx, deBasedDoc);
    }

    public Weight createWeight(Query query, ScoreMode scoreMode, float boost) throws IOException {
        QueryCache queryCache = this.queryCache;
        Weight weight = query.createWeight(this, scoreMode, boost);
        if (!scoreMode.needsScores() && queryCache != null) {
            weight = queryCache.doCache(weight, this.queryCachingPolicy);
        }
        return weight;
    }

    public IndexReaderContext getTopReaderContext() {
        return this.readerContext;
    }

    public String toString() {
        return "IndexSearcher(" + String.valueOf(this.reader) + "; taskExecutor=" + String.valueOf(this.taskExecutor) + ")";
    }

    public TermStatistics termStatistics(Term term, int docFreq, long totalTermFreq) throws IOException {
        return new TermStatistics(term.bytes(), docFreq, totalTermFreq);
    }

    public CollectionStatistics collectionStatistics(String field) throws IOException {
        assert (field != null);
        long docCount = 0L;
        long sumTotalTermFreq = 0L;
        long sumDocFreq = 0L;
        for (LeafReaderContext leaf : this.reader.leaves()) {
            Terms terms = Terms.getTerms(leaf.reader(), field);
            docCount += (long)terms.getDocCount();
            sumTotalTermFreq += terms.getSumTotalTermFreq();
            sumDocFreq += terms.getSumDocFreq();
        }
        if (docCount == 0L) {
            return null;
        }
        return new CollectionStatistics(field, this.reader.maxDoc(), docCount, sumTotalTermFreq, sumDocFreq);
    }

    @Deprecated
    public Executor getExecutor() {
        return this.executor;
    }

    public TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    static {
        DEFAULT_CACHING_POLICY = new UsageTrackingQueryCachingPolicy();
        int maxCachedQueries = 1000;
        long maxRamBytesUsed = Math.min(0x2000000L, Runtime.getRuntime().maxMemory() / 20L);
        DEFAULT_QUERY_CACHE = new LRUQueryCache(1000, maxRamBytesUsed);
        defaultSimilarity = new BM25Similarity();
    }

    private static class CachingLeafSlicesSupplier
    implements Supplier<LeafSlice[]> {
        private volatile LeafSlice[] leafSlices;
        private final Function<List<LeafReaderContext>, LeafSlice[]> sliceProvider;
        private final List<LeafReaderContext> leaves;

        private CachingLeafSlicesSupplier(Function<List<LeafReaderContext>, LeafSlice[]> provider, List<LeafReaderContext> leaves) {
            this.sliceProvider = Objects.requireNonNull(provider, "leaf slice provider cannot be null");
            this.leaves = Objects.requireNonNull(leaves, "list of LeafReaderContext cannot be null");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public LeafSlice[] get() {
            if (this.leafSlices == null) {
                CachingLeafSlicesSupplier cachingLeafSlicesSupplier = this;
                synchronized (cachingLeafSlicesSupplier) {
                    if (this.leafSlices == null) {
                        this.leafSlices = Objects.requireNonNull(this.sliceProvider.apply(this.leaves), "slices computed by the provider is null");
                    }
                }
            }
            return this.leafSlices;
        }
    }

    public static class TooManyNestedClauses
    extends TooManyClauses {
        public TooManyNestedClauses() {
            super("Query contains too many nested clauses; maxClauseCount is set to " + IndexSearcher.getMaxClauseCount());
        }
    }

    public static class TooManyClauses
    extends RuntimeException {
        private final int maxClauseCount = IndexSearcher.getMaxClauseCount();

        public TooManyClauses(String msg) {
            super(msg);
        }

        public TooManyClauses() {
            this("maxClauseCount is set to " + IndexSearcher.getMaxClauseCount());
        }

        public int getMaxClauseCount() {
            return this.maxClauseCount;
        }
    }

    public static class LeafSlice {
        public final LeafReaderContext[] leaves;

        public LeafSlice(List<LeafReaderContext> leavesList) {
            Collections.sort(leavesList, Comparator.comparingInt(l -> l.docBase));
            this.leaves = leavesList.toArray(new LeafReaderContext[0]);
        }
    }
}

