/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling.suggest;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.store.FSDirectory;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.spelling.suggest.jaspell.JaspellLookupFactory;

public abstract class LookupFactory {
    public static String DEFAULT_FILE_BASED_DICT = JaspellLookupFactory.class.getName();
    private static FSDirectory tmpBuildDir;

    public abstract Lookup create(NamedList<?> var1, SolrCore var2);

    public abstract String storeFileName();

    protected static synchronized FSDirectory getTempDir() {
        if (tmpBuildDir == null) {
            String tempDirPath = System.getProperty("java.io.tmpdir");
            if (tempDirPath == null) {
                throw new RuntimeException("Java has no temporary folder property (java.io.tmpdir)?");
            }
            try {
                tmpBuildDir = FSDirectory.open((Path)Paths.get(tempDirPath, new String[0]));
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return tmpBuildDir;
    }
}

