/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.jersey;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.apache.solr.api.JerseyResource;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.handler.admin.ZookeeperRead;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.jersey.RequestContextKeys;
import org.apache.solr.request.SolrQueryRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaTypeOverridingFilter
implements ContainerResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final List<Class<? extends JerseyResource>> EXEMPTED_RESOURCES = List.of(ZookeeperRead.class);
    @Context
    private ResourceInfo resourceInfo;

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        SolrParams params;
        if (responseContext.getStatus() >= 400) {
            return;
        }
        if (this.resourceInfo.getResourceClass() == null || EXEMPTED_RESOURCES.contains(this.resourceInfo.getResourceClass())) {
            return;
        }
        SolrQueryRequest solrQueryRequest = (SolrQueryRequest)requestContext.getProperty(RequestContextKeys.SOLR_QUERY_REQUEST);
        SolrParams solrParams = params = solrQueryRequest != null ? solrQueryRequest.getParams() : null;
        if (params != null && params.get("wt") != null) {
            String mediaType = V2ApiUtils.getMediaTypeFromWtParam(params, null);
            if (mediaType != null) {
                responseContext.getHeaders().putSingle((Object)"Content-Type", (Object)mediaType);
            }
        } else if (!requestContext.getHeaders().containsKey((Object)"Accept") || "*/*".equals(requestContext.getHeaderString("Accept"))) {
            responseContext.getHeaders().putSingle((Object)"Content-Type", (Object)"application/json");
        }
    }
}

