/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import org.apache.solr.client.api.endpoint.CollectionSnapshotApis;
import org.apache.solr.client.api.model.ListCollectionSnapshotsResponse;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.snapshots.CollectionSnapshotMetaData;
import org.apache.solr.core.snapshots.SolrSnapshotManager;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class ListCollectionSnapshots
extends AdminAPIBase
implements CollectionSnapshotApis.List {
    @Inject
    public ListCollectionSnapshots(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @PermissionName(value=PermissionNameProvider.Name.COLL_READ_PERM)
    public ListCollectionSnapshotsResponse listSnapshots(String collName) throws Exception {
        ListCollectionSnapshotsResponse response = this.instantiateJerseyResponse(ListCollectionSnapshotsResponse.class);
        CoreContainer coreContainer = this.fetchAndValidateZooKeeperAwareCoreContainer();
        ListCollectionSnapshots.recordCollectionForLogAndTracing(collName, this.solrQueryRequest);
        String collectionName = this.resolveCollectionName(collName, true);
        SolrZkClient client = coreContainer.getZkController().getZkClient();
        Collection<CollectionSnapshotMetaData> m = SolrSnapshotManager.listSnapshots(client, collectionName);
        HashMap snapshots = CollectionUtil.newHashMap((int)m.size());
        for (CollectionSnapshotMetaData metaData : m) {
            snapshots.put(metaData.getName(), metaData);
        }
        response.snapshots = snapshots;
        return response;
    }
}

