/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata;

import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.NameSpace;

public final class NameToIdentifier
implements ReferenceIdentifier {
    private final GenericName name;

    public NameToIdentifier(GenericName genericName) {
        ArgumentChecks.ensureNonNull("name", genericName);
        this.name = genericName;
    }

    private static GenericName scope(GenericName genericName) {
        NameSpace nameSpace;
        if (genericName != null && (nameSpace = genericName.scope()) != null && !nameSpace.isGlobal()) {
            return nameSpace.name();
        }
        return null;
    }

    public Citation getAuthority() {
        GenericName genericName = NameToIdentifier.scope(this.name);
        if (genericName == null && (genericName = NameToIdentifier.scope((GenericName)this.name.tip())) == null) {
            return null;
        }
        return Citations.fromName(genericName.head().toString());
    }

    public static String getCodeSpace(GenericName genericName, Locale locale) {
        GenericName genericName2 = NameToIdentifier.scope((GenericName)genericName.tip());
        return genericName2 != null ? NameToIdentifier.toString((GenericName)genericName2.tip(), locale) : null;
    }

    public String getCodeSpace() {
        return NameToIdentifier.getCodeSpace(this.name, null);
    }

    public String getCode() {
        return this.name.tip().toString();
    }

    public String getVersion() {
        return null;
    }

    public int hashCode() {
        return ~Objects.hashCode(this.name);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            return Objects.equals(this.name, ((NameToIdentifier)object).name);
        }
        return false;
    }

    public String toString() {
        String string = this.getCode();
        String string2 = this.getCodeSpace();
        if (string2 != null && !string2.isEmpty()) {
            return string2 + ':' + string;
        }
        return string;
    }

    public static String toString(GenericName genericName, Locale locale) {
        if (genericName != null) {
            String string;
            InternationalString internationalString;
            if (locale != null && (internationalString = genericName.toInternationalString()) != null && (string = internationalString.toString(locale)) != null) {
                return string;
            }
            return genericName.toString();
        }
        return null;
    }

    public static boolean isHeuristicMatchForIdentifier(Iterable<? extends ReferenceIdentifier> iterable, String string) {
        if (string != null && iterable != null) {
            int n = string.indexOf(58);
            if (n < 0) {
                for (Identifier identifier : iterable) {
                    if (!string.equalsIgnoreCase(identifier.getCode())) continue;
                    return true;
                }
                return false;
            }
            do {
                String string2 = string.substring(0, n).trim();
                String string3 = string.substring(++n).trim();
                for (ReferenceIdentifier referenceIdentifier : iterable) {
                    if (!string2.equalsIgnoreCase(referenceIdentifier.getCodeSpace()) || !string3.equalsIgnoreCase(referenceIdentifier.getCode())) continue;
                    return true;
                }
            } while ((n = string.indexOf(58, n)) >= 0);
        }
        return false;
    }

    public static boolean isHeuristicMatchForName(Identifier identifier, Collection<GenericName> collection, CharSequence charSequence, Simplifier simplifier) {
        if (charSequence != null) {
            CharSequence charSequence2;
            String string = charSequence2 = identifier != null ? identifier.getCode() : null;
            if (charSequence.equals(charSequence2)) {
                return true;
            }
            if (CharSequences.equalsFiltered(charSequence = simplifier.apply(charSequence), charSequence2 = simplifier.apply(charSequence2), Characters.Filter.LETTERS_AND_DIGITS, true)) {
                return true;
            }
            if (collection != null) {
                for (GenericName genericName : collection) {
                    CharSequence charSequence3;
                    if (genericName == null || !CharSequences.equalsFiltered(charSequence, charSequence3 = simplifier.apply(genericName.tip().toString()), Characters.Filter.LETTERS_AND_DIGITS, true)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isHeuristicMatchForName(IdentifiedObject identifiedObject, String string) {
        return NameToIdentifier.isHeuristicMatchForName((Identifier)identifiedObject.getName(), identifiedObject.getAlias(), string, Simplifier.DEFAULT);
    }

    public static class Simplifier {
        public static final String ESRI_DATUM_PREFIX = "D_";
        public static final Simplifier DEFAULT = new Simplifier();

        protected Simplifier() {
        }

        protected CharSequence apply(CharSequence charSequence) {
            return CharSequences.toASCII(charSequence);
        }
    }
}

