/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.ui;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroClass;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSprite;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.watabou.noosa.Image;
import com.watabou.utils.RectF;

public enum Icons {
    ENTER,
    GOLD,
    RANKINGS,
    BADGES,
    NEWS,
    CHANGES,
    PREFS,
    SHPX,
    JOURNAL,
    EXIT,
    DISPLAY,
    DISPLAY_LAND,
    DISPLAY_PORT,
    DATA,
    AUDIO,
    LANGS,
    CONTROLLER,
    KEYBOARD,
    STATS,
    CHALLENGE_GREY,
    SCROLL_GREY,
    SEED,
    LEFTARROW,
    RIGHTARROW,
    CALENDAR,
    CHEVRON,
    SHUFFLE,
    TARGET,
    INFO,
    WARNING,
    UNCHECKED,
    CHECKED,
    CLOSE,
    PLUS,
    REPEAT,
    ARROW,
    CHALLENGE_COLOR,
    SCROLL_COLOR,
    COPY,
    PASTE,
    BACKPACK_LRG,
    TALENT,
    MAGNIFY,
    SNAKE,
    BUFFS,
    CATALOG,
    ALCHEMY,
    GRASS,
    STAIRS,
    STAIRS_CHASM,
    STAIRS_WATER,
    STAIRS_GRASS,
    STAIRS_DARK,
    STAIRS_LARGE,
    STAIRS_TRAPS,
    STAIRS_SECRETS,
    WELL_HEALTH,
    WELL_AWARENESS,
    SACRIFICE_ALTAR,
    DISTANT_WELL,
    SKULL,
    BUSY,
    COMPASS,
    SLEEP,
    ALERT,
    LOST,
    INVESTIGATE,
    DEPTH,
    DEPTH_CHASM,
    DEPTH_WATER,
    DEPTH_GRASS,
    DEPTH_DARK,
    DEPTH_LARGE,
    DEPTH_TRAPS,
    DEPTH_SECRETS,
    CHAL_COUNT,
    COIN_SML,
    ENERGY_SML,
    BACKPACK,
    SEED_POUCH,
    SCROLL_HOLDER,
    WAND_HOLSTER,
    POTION_BANDOLIER,
    LIBGDX,
    ALEKS,
    WATA,
    CELESTI,
    KRISTJAN,
    CUBE_CODE,
    PURIGRO,
    ARCNOR;


    public Image get() {
        return Icons.get(this);
    }

    public static Image get(Icons type) {
        Image icon = new Image("interfaces/icons.png");
        switch (type) {
            case ENTER: {
                icon.frame(icon.texture.uvRectBySize(0.0f, 0.0f, 16.0f, 16.0f));
                break;
            }
            case GOLD: {
                icon.frame(icon.texture.uvRectBySize(17.0f, 0.0f, 17.0f, 16.0f));
                break;
            }
            case RANKINGS: {
                icon.frame(icon.texture.uvRectBySize(34.0f, 0.0f, 17.0f, 16.0f));
                break;
            }
            case BADGES: {
                icon.frame(icon.texture.uvRectBySize(51.0f, 0.0f, 16.0f, 16.0f));
                break;
            }
            case NEWS: {
                icon.frame(icon.texture.uvRectBySize(68.0f, 0.0f, 16.0f, 15.0f));
                break;
            }
            case CHANGES: {
                icon.frame(icon.texture.uvRectBySize(85.0f, 0.0f, 15.0f, 15.0f));
                break;
            }
            case PREFS: {
                icon.frame(icon.texture.uvRectBySize(102.0f, 0.0f, 14.0f, 14.0f));
                break;
            }
            case SHPX: {
                icon.frame(icon.texture.uvRectBySize(119.0f, 0.0f, 16.0f, 16.0f));
                break;
            }
            case JOURNAL: {
                icon.frame(icon.texture.uvRectBySize(136.0f, 0.0f, 17.0f, 15.0f));
                break;
            }
            case EXIT: {
                icon.frame(icon.texture.uvRectBySize(0.0f, 16.0f, 15.0f, 11.0f));
                break;
            }
            case DISPLAY: {
                if (!PixelScene.landscape()) {
                    return Icons.get(DISPLAY_PORT);
                }
                return Icons.get(DISPLAY_LAND);
            }
            case DISPLAY_PORT: {
                icon.frame(icon.texture.uvRectBySize(16.0f, 16.0f, 12.0f, 16.0f));
                break;
            }
            case DISPLAY_LAND: {
                icon.frame(icon.texture.uvRectBySize(32.0f, 16.0f, 16.0f, 12.0f));
                break;
            }
            case DATA: {
                icon.frame(icon.texture.uvRectBySize(48.0f, 16.0f, 14.0f, 15.0f));
                break;
            }
            case AUDIO: {
                icon.frame(icon.texture.uvRectBySize(64.0f, 16.0f, 14.0f, 14.0f));
                break;
            }
            case LANGS: {
                icon.frame(icon.texture.uvRectBySize(80.0f, 16.0f, 14.0f, 11.0f));
                break;
            }
            case CONTROLLER: {
                icon.frame(icon.texture.uvRectBySize(96.0f, 16.0f, 16.0f, 12.0f));
                break;
            }
            case KEYBOARD: {
                icon.frame(icon.texture.uvRectBySize(112.0f, 16.0f, 15.0f, 12.0f));
                break;
            }
            case STATS: {
                icon.frame(icon.texture.uvRectBySize(128.0f, 16.0f, 16.0f, 13.0f));
                break;
            }
            case CHALLENGE_GREY: {
                icon.frame(icon.texture.uvRectBySize(144.0f, 16.0f, 15.0f, 12.0f));
                break;
            }
            case SCROLL_GREY: {
                icon.frame(icon.texture.uvRectBySize(160.0f, 16.0f, 15.0f, 14.0f));
                break;
            }
            case SEED: {
                icon.frame(icon.texture.uvRectBySize(176.0f, 16.0f, 15.0f, 10.0f));
                break;
            }
            case LEFTARROW: {
                icon.frame(icon.texture.uvRectBySize(192.0f, 16.0f, 14.0f, 9.0f));
                break;
            }
            case RIGHTARROW: {
                icon.frame(icon.texture.uvRectBySize(208.0f, 16.0f, 14.0f, 9.0f));
                break;
            }
            case CALENDAR: {
                icon.frame(icon.texture.uvRectBySize(224.0f, 16.0f, 15.0f, 12.0f));
                break;
            }
            case CHEVRON: {
                icon.frame(icon.texture.uvRectBySize(240.0f, 16.0f, 13.0f, 10.0f));
                break;
            }
            case SHUFFLE: {
                icon.frame(icon.texture.uvRectBySize(240.0f, 32.0f, 15.0f, 12.0f));
                break;
            }
            case TARGET: {
                icon.frame(icon.texture.uvRectBySize(0.0f, 32.0f, 16.0f, 16.0f));
                break;
            }
            case INFO: {
                icon.frame(icon.texture.uvRectBySize(16.0f, 32.0f, 14.0f, 14.0f));
                break;
            }
            case WARNING: {
                icon.frame(icon.texture.uvRectBySize(32.0f, 32.0f, 14.0f, 14.0f));
                break;
            }
            case UNCHECKED: {
                icon.frame(icon.texture.uvRectBySize(48.0f, 32.0f, 12.0f, 12.0f));
                break;
            }
            case CHECKED: {
                icon.frame(icon.texture.uvRectBySize(64.0f, 32.0f, 12.0f, 12.0f));
                break;
            }
            case CLOSE: {
                icon.frame(icon.texture.uvRectBySize(80.0f, 32.0f, 11.0f, 11.0f));
                break;
            }
            case PLUS: {
                icon.frame(icon.texture.uvRectBySize(96.0f, 32.0f, 11.0f, 11.0f));
                break;
            }
            case REPEAT: {
                icon.frame(icon.texture.uvRectBySize(112.0f, 32.0f, 11.0f, 11.0f));
                break;
            }
            case ARROW: {
                icon.frame(icon.texture.uvRectBySize(128.0f, 32.0f, 11.0f, 11.0f));
                break;
            }
            case CHALLENGE_COLOR: {
                icon.frame(icon.texture.uvRectBySize(144.0f, 32.0f, 15.0f, 12.0f));
                break;
            }
            case SCROLL_COLOR: {
                icon.frame(icon.texture.uvRectBySize(160.0f, 32.0f, 15.0f, 14.0f));
                break;
            }
            case COPY: {
                icon.frame(icon.texture.uvRectBySize(176.0f, 32.0f, 13.0f, 13.0f));
                break;
            }
            case PASTE: {
                icon.frame(icon.texture.uvRectBySize(192.0f, 32.0f, 13.0f, 13.0f));
                break;
            }
            case BACKPACK_LRG: {
                icon.frame(icon.texture.uvRectBySize(0.0f, 48.0f, 16.0f, 16.0f));
                break;
            }
            case TALENT: {
                icon.frame(icon.texture.uvRectBySize(16.0f, 48.0f, 13.0f, 13.0f));
                break;
            }
            case MAGNIFY: {
                icon.frame(icon.texture.uvRectBySize(32.0f, 48.0f, 14.0f, 14.0f));
                break;
            }
            case SNAKE: {
                icon.frame(icon.texture.uvRectBySize(48.0f, 48.0f, 9.0f, 13.0f));
                break;
            }
            case BUFFS: {
                icon.frame(icon.texture.uvRectBySize(64.0f, 48.0f, 16.0f, 15.0f));
                break;
            }
            case CATALOG: {
                icon.frame(icon.texture.uvRectBySize(80.0f, 48.0f, 13.0f, 16.0f));
                break;
            }
            case ALCHEMY: {
                icon.frame(icon.texture.uvRectBySize(96.0f, 48.0f, 16.0f, 16.0f));
                break;
            }
            case GRASS: {
                icon.frame(icon.texture.uvRectBySize(112.0f, 48.0f, 16.0f, 16.0f));
                break;
            }
            case STAIRS: {
                icon.frame(icon.texture.uvRectBySize(0.0f, 64.0f, 15.0f, 16.0f));
                break;
            }
            case STAIRS_CHASM: {
                icon.frame(icon.texture.uvRectBySize(16.0f, 64.0f, 15.0f, 16.0f));
                break;
            }
            case STAIRS_WATER: {
                icon.frame(icon.texture.uvRectBySize(32.0f, 64.0f, 15.0f, 16.0f));
                break;
            }
            case STAIRS_GRASS: {
                icon.frame(icon.texture.uvRectBySize(48.0f, 64.0f, 15.0f, 16.0f));
                break;
            }
            case STAIRS_DARK: {
                icon.frame(icon.texture.uvRectBySize(64.0f, 64.0f, 15.0f, 16.0f));
                break;
            }
            case STAIRS_LARGE: {
                icon.frame(icon.texture.uvRectBySize(80.0f, 64.0f, 15.0f, 16.0f));
                break;
            }
            case STAIRS_TRAPS: {
                icon.frame(icon.texture.uvRectBySize(96.0f, 64.0f, 15.0f, 16.0f));
                break;
            }
            case STAIRS_SECRETS: {
                icon.frame(icon.texture.uvRectBySize(112.0f, 64.0f, 15.0f, 16.0f));
                break;
            }
            case WELL_HEALTH: {
                icon.frame(icon.texture.uvRectBySize(128.0f, 64.0f, 16.0f, 16.0f));
                break;
            }
            case WELL_AWARENESS: {
                icon.frame(icon.texture.uvRectBySize(144.0f, 64.0f, 16.0f, 16.0f));
                break;
            }
            case SACRIFICE_ALTAR: {
                icon.frame(icon.texture.uvRectBySize(160.0f, 64.0f, 16.0f, 16.0f));
                break;
            }
            case DISTANT_WELL: {
                icon.frame(icon.texture.uvRectBySize(176.0f, 64.0f, 16.0f, 16.0f));
                break;
            }
            case SKULL: {
                icon.frame(icon.texture.uvRectBySize(0.0f, 80.0f, 8.0f, 8.0f));
                break;
            }
            case BUSY: {
                icon.frame(icon.texture.uvRectBySize(8.0f, 80.0f, 8.0f, 8.0f));
                break;
            }
            case COMPASS: {
                icon.frame(icon.texture.uvRectBySize(0.0f, 88.0f, 7.0f, 5.0f));
                break;
            }
            case SLEEP: {
                icon.frame(icon.texture.uvRectBySize(7.0f, 88.0f, 9.0f, 8.0f));
                break;
            }
            case ALERT: {
                icon.frame(icon.texture.uvRectBySize(16.0f, 80.0f, 8.0f, 8.0f));
                break;
            }
            case LOST: {
                icon.frame(icon.texture.uvRectBySize(24.0f, 80.0f, 8.0f, 8.0f));
                break;
            }
            case INVESTIGATE: {
                icon.frame(icon.texture.uvRectBySize(16.0f, 88.0f, 8.0f, 8.0f));
                break;
            }
            case DEPTH: {
                icon.frame(icon.texture.uvRectBySize(32 + Icons.runTypeOfsX(), 80 + Icons.runTypeOfsY(), 6.0f, 7.0f));
                break;
            }
            case DEPTH_CHASM: {
                icon.frame(icon.texture.uvRectBySize(40 + Icons.runTypeOfsX(), 80 + Icons.runTypeOfsY(), 7.0f, 7.0f));
                break;
            }
            case DEPTH_WATER: {
                icon.frame(icon.texture.uvRectBySize(48 + Icons.runTypeOfsX(), 80 + Icons.runTypeOfsY(), 7.0f, 7.0f));
                break;
            }
            case DEPTH_GRASS: {
                icon.frame(icon.texture.uvRectBySize(56 + Icons.runTypeOfsX(), 80 + Icons.runTypeOfsY(), 7.0f, 7.0f));
                break;
            }
            case DEPTH_DARK: {
                icon.frame(icon.texture.uvRectBySize(64 + Icons.runTypeOfsX(), 80 + Icons.runTypeOfsY(), 7.0f, 7.0f));
                break;
            }
            case DEPTH_LARGE: {
                icon.frame(icon.texture.uvRectBySize(72 + Icons.runTypeOfsX(), 80 + Icons.runTypeOfsY(), 7.0f, 7.0f));
                break;
            }
            case DEPTH_TRAPS: {
                icon.frame(icon.texture.uvRectBySize(80 + Icons.runTypeOfsX(), 80 + Icons.runTypeOfsY(), 7.0f, 7.0f));
                break;
            }
            case DEPTH_SECRETS: {
                icon.frame(icon.texture.uvRectBySize(88 + Icons.runTypeOfsX(), 80 + Icons.runTypeOfsY(), 7.0f, 7.0f));
                break;
            }
            case CHAL_COUNT: {
                icon.frame(icon.texture.uvRectBySize(160.0f, 80.0f, 7.0f, 7.0f));
                break;
            }
            case COIN_SML: {
                icon.frame(icon.texture.uvRectBySize(168.0f, 80.0f, 7.0f, 7.0f));
                break;
            }
            case ENERGY_SML: {
                icon.frame(icon.texture.uvRectBySize(168.0f, 88.0f, 8.0f, 7.0f));
                break;
            }
            case BACKPACK: {
                icon.frame(icon.texture.uvRectBySize(176.0f, 80.0f, 10.0f, 10.0f));
                break;
            }
            case SCROLL_HOLDER: {
                icon.frame(icon.texture.uvRectBySize(186.0f, 80.0f, 10.0f, 10.0f));
                break;
            }
            case SEED_POUCH: {
                icon.frame(icon.texture.uvRectBySize(196.0f, 80.0f, 10.0f, 10.0f));
                break;
            }
            case WAND_HOLSTER: {
                icon.frame(icon.texture.uvRectBySize(206.0f, 80.0f, 10.0f, 10.0f));
                break;
            }
            case POTION_BANDOLIER: {
                icon.frame(icon.texture.uvRectBySize(216.0f, 80.0f, 10.0f, 10.0f));
                break;
            }
            case LIBGDX: {
                icon.frame(icon.texture.uvRectBySize(0.0f, 96.0f, 16.0f, 13.0f));
                break;
            }
            case ALEKS: {
                icon.frame(icon.texture.uvRectBySize(16.0f, 96.0f, 16.0f, 13.0f));
                break;
            }
            case WATA: {
                icon.frame(icon.texture.uvRectBySize(0.0f, 112.0f, 17.0f, 12.0f));
                break;
            }
            case CELESTI: {
                icon.frame(icon.texture.uvRectBySize(32.0f, 96.0f, 32.0f, 32.0f));
                icon.scale.set(PixelScene.align(0.49f));
                break;
            }
            case KRISTJAN: {
                icon.frame(icon.texture.uvRectBySize(64.0f, 96.0f, 32.0f, 32.0f));
                icon.scale.set(PixelScene.align(0.49f));
                break;
            }
            case ARCNOR: {
                icon.frame(icon.texture.uvRectBySize(96.0f, 96.0f, 32.0f, 32.0f));
                icon.scale.set(PixelScene.align(0.49f));
                break;
            }
            case PURIGRO: {
                icon.frame(icon.texture.uvRectBySize(128.0f, 96.0f, 32.0f, 32.0f));
                icon.scale.set(PixelScene.align(0.49f));
                break;
            }
            case CUBE_CODE: {
                icon.frame(icon.texture.uvRectBySize(160.0f, 96.0f, 27.0f, 30.0f));
                icon.scale.set(PixelScene.align(0.49f));
            }
        }
        return icon;
    }

    private static int runTypeOfsX() {
        return Dungeon.daily ? 64 : 0;
    }

    private static int runTypeOfsY() {
        if (Dungeon.daily && Dungeon.dailyReplay || !Dungeon.daily && !Dungeon.customSeedText.isEmpty()) {
            return 8;
        }
        return 0;
    }

    public static Image get(HeroClass cl) {
        switch (cl) {
            case WARRIOR: {
                return new ItemSprite(ItemSpriteSheet.SEAL);
            }
            case MAGE: {
                ItemSprite result = new ItemSprite(ItemSpriteSheet.MAGES_STAFF);
                RectF frame = result.frame();
                frame.top += frame.height() / 8.0f;
                result.frame(frame);
                return result;
            }
            case ROGUE: {
                return new ItemSprite(ItemSpriteSheet.ARTIFACT_CLOAK);
            }
            case HUNTRESS: {
                return new ItemSprite(ItemSpriteSheet.SPIRIT_BOW);
            }
            case DUELIST: {
                return new ItemSprite(ItemSpriteSheet.RAPIER);
            }
            case CLERIC: {
                return new ItemSprite(ItemSpriteSheet.ARTIFACT_TOME);
            }
        }
        return null;
    }

    public static Image get(Level.Feeling feeling) {
        switch (feeling) {
            default: {
                return Icons.get(DEPTH);
            }
            case CHASM: {
                return Icons.get(DEPTH_CHASM);
            }
            case WATER: {
                return Icons.get(DEPTH_WATER);
            }
            case GRASS: {
                return Icons.get(DEPTH_GRASS);
            }
            case DARK: {
                return Icons.get(DEPTH_DARK);
            }
            case LARGE: {
                return Icons.get(DEPTH_LARGE);
            }
            case TRAPS: {
                return Icons.get(DEPTH_TRAPS);
            }
            case SECRETS: 
        }
        return Icons.get(DEPTH_SECRETS);
    }

    public static Image getLarge(Level.Feeling feeling) {
        switch (feeling) {
            default: {
                return Icons.get(STAIRS);
            }
            case CHASM: {
                return Icons.get(STAIRS_CHASM);
            }
            case WATER: {
                return Icons.get(STAIRS_WATER);
            }
            case GRASS: {
                return Icons.get(STAIRS_GRASS);
            }
            case DARK: {
                return Icons.get(STAIRS_DARK);
            }
            case LARGE: {
                return Icons.get(STAIRS_LARGE);
            }
            case TRAPS: {
                return Icons.get(STAIRS_TRAPS);
            }
            case SECRETS: 
        }
        return Icons.get(STAIRS_SECRETS);
    }
}

