/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.splines;

import java.util.List;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.p5edges.splines.NubSpline;
import org.eclipse.elk.alg.layered.p5edges.splines.SplinesMath;
import org.eclipse.elk.core.math.KVector;

public final class NubsSelfLoop
extends NubSpline {
    private static final double FRACTION = 1.3;
    private static final double HALF = 0.5;
    private KVector firstLabelPosition = new KVector();

    private NubsSelfLoop(NubsSelfLoop nubs) {
        super(nubs);
        this.firstLabelPosition = nubs.firstLabelPosition;
    }

    private NubsSelfLoop(int dim, KVector ... kVectors) {
        super(true, dim, kVectors);
    }

    public NubsSelfLoop(int dimension, List<KVector> kVectors) {
        super(true, dimension, kVectors);
    }

    public NubsSelfLoop(boolean clamped, int dimension, List<KVector> kVectors) {
        super(clamped, dimension, kVectors);
    }

    public KVector getFirstLabelPosition() {
        return this.firstLabelPosition;
    }

    public void setFirstLabelPosition(KVector position) {
        this.firstLabelPosition = position;
    }

    public static NubsSelfLoop createSideSelfLoop(LPort source, LPort target, double length) {
        double direction = SplinesMath.portSideToDirection(source.getSide());
        KVector sourcePos = source.getPosition().clone().add(source.getAnchor());
        KVector targetPos = target.getPosition().clone().add(target.getAnchor());
        KVector firstCP = new KVector(sourcePos).add(new KVector(direction).scale(length));
        KVector thirdCP = new KVector(targetPos).add(new KVector(direction).scale(length));
        KVector mid = new KVector(firstCP).sub(thirdCP).scale(0.5);
        KVector secondCP = new KVector(thirdCP).add(mid).add(new KVector(direction).scale(mid.length()));
        NubsSelfLoop nubs = new NubsSelfLoop(3, sourcePos, firstCP, secondCP, thirdCP, targetPos);
        return nubs;
    }

    public static NubsSelfLoop createCornerSelfLoop(LPort source, LPort target, double sourceHeight, double targetHeight) {
        double sourceDir = SplinesMath.portSideToDirection(source.getSide());
        double targetDir = SplinesMath.portSideToDirection(target.getSide());
        KVector sourcePos = source.getPosition().clone().add(source.getAnchor());
        KVector targetPos = target.getPosition().clone().add(target.getAnchor());
        KVector firstCP = sourcePos.clone().add(new KVector(sourceDir).scale(1.3 * sourceHeight));
        KVector thirdCP = targetPos.clone().add(new KVector(targetDir).scale(1.3 * targetHeight));
        double cornerX = 0.0;
        double cornerY = 0.0;
        switch (source.getSide()) {
            case WEST: {
                cornerX = 2.0 * (sourcePos.x - sourceHeight) - 0.5 * (firstCP.x + thirdCP.x);
                break;
            }
            case EAST: {
                cornerX = 2.0 * (sourcePos.x + sourceHeight) - 0.5 * (firstCP.x + thirdCP.x);
                break;
            }
            case NORTH: {
                cornerY = 2.0 * (sourcePos.y - sourceHeight) - 0.5 * (firstCP.y + thirdCP.y);
                break;
            }
            case SOUTH: {
                cornerY = 2.0 * (sourcePos.y + sourceHeight) - 0.5 * (firstCP.y + thirdCP.y);
                break;
            }
        }
        switch (target.getSide()) {
            case WEST: {
                cornerX = 2.0 * (targetPos.x - targetHeight) - 0.5 * (thirdCP.x + firstCP.x);
                break;
            }
            case EAST: {
                cornerX = 2.0 * (targetPos.x + targetHeight) - 0.5 * (thirdCP.x + firstCP.x);
                break;
            }
            case NORTH: {
                cornerY = 2.0 * (targetPos.y - targetHeight) - 0.5 * (thirdCP.y + firstCP.y);
                break;
            }
            case SOUTH: {
                cornerY = 2.0 * (targetPos.y + targetHeight) - 0.5 * (thirdCP.y + firstCP.y);
                break;
            }
        }
        KVector secondCP = new KVector(cornerX, cornerY);
        return new NubsSelfLoop(3, sourcePos, firstCP, secondCP, thirdCP, targetPos);
    }

    public static NubsSelfLoop createAcrossSelfLoop(LPort source, LPort target, KVector sourceBendPoint, List<KVector> cornerBendPoints, KVector targetBendPoint) {
        KVector sourcePos = source.getPosition().clone().add(source.getAnchor());
        KVector targetPos = target.getPosition().clone().add(target.getAnchor());
        assert (cornerBendPoints.size() == 2);
        KVector thirdCP = cornerBendPoints.get(0);
        KVector fourthCP = cornerBendPoints.get(1);
        KVector middleCP = fourthCP.clone().add(thirdCP).scale(0.5);
        return new NubsSelfLoop(3, sourcePos, sourceBendPoint, thirdCP, middleCP, fourthCP, targetBendPoint, targetPos);
    }

    public static NubsSelfLoop createThreeSideSelfLoop(LPort source, LPort target, KVector sourceBendPoint, List<KVector> cornerBendPoints, KVector targetBendPoint) {
        KVector sourcePos = source.getPosition().clone().add(source.getAnchor());
        KVector targetPos = target.getPosition().clone().add(target.getAnchor());
        assert (cornerBendPoints.size() == 3);
        KVector thirdCP = cornerBendPoints.get(0);
        KVector fourthCP = cornerBendPoints.get(1);
        KVector fifthCP = cornerBendPoints.get(2);
        return new NubsSelfLoop(3, sourcePos, sourceBendPoint, thirdCP, fourthCP, fifthCP, targetBendPoint, targetPos);
    }

    public static NubsSelfLoop createFourSideSelfLoop(LPort source, LPort target, KVector sourceBendPoint, List<KVector> cornerBendPoints, KVector targetBendPoint) {
        KVector sourcePos = source.getPosition().clone().add(source.getAnchor());
        KVector targetPos = target.getPosition().clone().add(target.getAnchor());
        assert (cornerBendPoints.size() == 4);
        KVector thirdCP = cornerBendPoints.get(0);
        KVector fourthCP = cornerBendPoints.get(1);
        KVector fifthCP = cornerBendPoints.get(2);
        KVector sixthCP = cornerBendPoints.get(3);
        return new NubsSelfLoop(3, sourcePos, sourceBendPoint, thirdCP, fourthCP, fifthCP, sixthCP, targetBendPoint, targetPos);
    }
}

