/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.memorycontainer;

import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;

public class MemoryDecisionRequest
implements ToXContentObject {
    private List<OldMemory> oldMemory;
    private List<String> retrievedFacts;

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("old_memory");
        if (this.oldMemory != null) {
            for (OldMemory memory : this.oldMemory) {
                memory.toXContent(builder, params);
            }
        }
        builder.endArray();
        builder.startArray("retrieved_facts");
        if (this.retrievedFacts != null) {
            for (String fact : this.retrievedFacts) {
                builder.value(fact);
            }
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public String toJsonString() {
        try {
            XContentBuilder builder = XContentBuilder.builder((XContent)JsonXContent.jsonXContent);
            this.toXContent(builder, ToXContent.EMPTY_PARAMS);
            return builder.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize MemoryDecisionRequest", e);
        }
    }

    @Generated
    MemoryDecisionRequest(List<OldMemory> oldMemory, List<String> retrievedFacts) {
        this.oldMemory = oldMemory;
        this.retrievedFacts = retrievedFacts;
    }

    @Generated
    public static MemoryDecisionRequestBuilder builder() {
        return new MemoryDecisionRequestBuilder();
    }

    @Generated
    public List<OldMemory> getOldMemory() {
        return this.oldMemory;
    }

    @Generated
    public List<String> getRetrievedFacts() {
        return this.retrievedFacts;
    }

    @Generated
    public void setOldMemory(List<OldMemory> oldMemory) {
        this.oldMemory = oldMemory;
    }

    @Generated
    public void setRetrievedFacts(List<String> retrievedFacts) {
        this.retrievedFacts = retrievedFacts;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MemoryDecisionRequest)) {
            return false;
        }
        MemoryDecisionRequest other = (MemoryDecisionRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<OldMemory> this$oldMemory = this.getOldMemory();
        List<OldMemory> other$oldMemory = other.getOldMemory();
        if (this$oldMemory == null ? other$oldMemory != null : !((Object)this$oldMemory).equals(other$oldMemory)) {
            return false;
        }
        List<String> this$retrievedFacts = this.getRetrievedFacts();
        List<String> other$retrievedFacts = other.getRetrievedFacts();
        return !(this$retrievedFacts == null ? other$retrievedFacts != null : !((Object)this$retrievedFacts).equals(other$retrievedFacts));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MemoryDecisionRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<OldMemory> $oldMemory = this.getOldMemory();
        result = result * 59 + ($oldMemory == null ? 43 : ((Object)$oldMemory).hashCode());
        List<String> $retrievedFacts = this.getRetrievedFacts();
        result = result * 59 + ($retrievedFacts == null ? 43 : ((Object)$retrievedFacts).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MemoryDecisionRequest(oldMemory=" + String.valueOf(this.getOldMemory()) + ", retrievedFacts=" + String.valueOf(this.getRetrievedFacts()) + ")";
    }

    public static class OldMemory
    implements ToXContentObject {
        private String id;
        private String text;
        private float score;

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("id", this.id);
            builder.field("text", this.text);
            builder.field("score", this.score);
            builder.endObject();
            return builder;
        }

        @Generated
        OldMemory(String id, String text, float score) {
            this.id = id;
            this.text = text;
            this.score = score;
        }

        @Generated
        public static OldMemoryBuilder builder() {
            return new OldMemoryBuilder();
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getText() {
            return this.text;
        }

        @Generated
        public float getScore() {
            return this.score;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setText(String text) {
            this.text = text;
        }

        @Generated
        public void setScore(float score) {
            this.score = score;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OldMemory)) {
                return false;
            }
            OldMemory other = (OldMemory)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Float.compare(this.getScore(), other.getScore()) != 0) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            return !(this$text == null ? other$text != null : !this$text.equals(other$text));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OldMemory;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Float.floatToIntBits(this.getScore());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MemoryDecisionRequest.OldMemory(id=" + this.getId() + ", text=" + this.getText() + ", score=" + this.getScore() + ")";
        }

        @Generated
        public static class OldMemoryBuilder {
            @Generated
            private String id;
            @Generated
            private String text;
            @Generated
            private float score;

            @Generated
            OldMemoryBuilder() {
            }

            @Generated
            public OldMemoryBuilder id(String id) {
                this.id = id;
                return this;
            }

            @Generated
            public OldMemoryBuilder text(String text) {
                this.text = text;
                return this;
            }

            @Generated
            public OldMemoryBuilder score(float score) {
                this.score = score;
                return this;
            }

            @Generated
            public OldMemory build() {
                return new OldMemory(this.id, this.text, this.score);
            }

            @Generated
            public String toString() {
                return "MemoryDecisionRequest.OldMemory.OldMemoryBuilder(id=" + this.id + ", text=" + this.text + ", score=" + this.score + ")";
            }
        }
    }

    @Generated
    public static class MemoryDecisionRequestBuilder {
        @Generated
        private List<OldMemory> oldMemory;
        @Generated
        private List<String> retrievedFacts;

        @Generated
        MemoryDecisionRequestBuilder() {
        }

        @Generated
        public MemoryDecisionRequestBuilder oldMemory(List<OldMemory> oldMemory) {
            this.oldMemory = oldMemory;
            return this;
        }

        @Generated
        public MemoryDecisionRequestBuilder retrievedFacts(List<String> retrievedFacts) {
            this.retrievedFacts = retrievedFacts;
            return this;
        }

        @Generated
        public MemoryDecisionRequest build() {
            return new MemoryDecisionRequest(this.oldMemory, this.retrievedFacts);
        }

        @Generated
        public String toString() {
            return "MemoryDecisionRequest.MemoryDecisionRequestBuilder(oldMemory=" + String.valueOf(this.oldMemory) + ", retrievedFacts=" + String.valueOf(this.retrievedFacts) + ")";
        }
    }
}

