/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.text.impl;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import org.tribuo.data.text.DocumentPreprocessor;

public class CasingPreprocessor
implements DocumentPreprocessor {
    @Config(description="Which casing operation to apply.")
    private CasingOperation op = CasingOperation.LOWERCASE;

    private CasingPreprocessor() {
    }

    public CasingPreprocessor(CasingOperation op) {
        this.op = op;
    }

    @Override
    public String processDoc(String doc) {
        return this.op.applyCase(doc);
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "DocumentPreprocessor");
    }

    public static enum CasingOperation {
        LOWERCASE,
        UPPERCASE;


        public String applyCase(String input) {
            switch (this) {
                case UPPERCASE: {
                    return input.toUpperCase();
                }
                case LOWERCASE: {
                    return input.toLowerCase();
                }
            }
            throw new IllegalStateException("Unexpected enum value " + this.toString());
        }
    }
}

