/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.derivedsource;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.SegmentReadState;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.support.XContentMapValues;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.knn.index.codec.derivedsource.DerivedFieldInfo;
import org.opensearch.knn.index.codec.derivedsource.DerivedSourceLuceneHelper;
import org.opensearch.knn.index.codec.derivedsource.DerivedSourceReaders;
import org.opensearch.knn.index.codec.derivedsource.PerFieldDerivedVectorTransformer;
import org.opensearch.knn.index.codec.derivedsource.PerFieldDerivedVectorTransformerFactory;

public class DerivedSourceVectorTransformer {
    @Generated
    private static final Logger log = LogManager.getLogger(DerivedSourceVectorTransformer.class);
    private final DerivedSourceReaders derivedSourceReaders;
    Function<Map<String, Object>, Map<String, Object>> derivedSourceVectorTransformer;
    Map<String, PerFieldDerivedVectorTransformer> perFieldDerivedVectorTransformers;
    private boolean isNested;
    private final DerivedSourceLuceneHelper derivedSourceLuceneHelper;

    public DerivedSourceVectorTransformer(DerivedSourceReaders derivedSourceReaders, SegmentReadState segmentReadState, List<DerivedFieldInfo> fieldsToInjectVector) {
        this.derivedSourceReaders = derivedSourceReaders;
        this.perFieldDerivedVectorTransformers = new HashMap<String, PerFieldDerivedVectorTransformer>();
        HashMap<String, PerFieldDerivedVectorTransformer> perFieldDerivedVectorTransformersFunctionValues = new HashMap<String, PerFieldDerivedVectorTransformer>();
        for (DerivedFieldInfo derivedFieldInfo : fieldsToInjectVector) {
            this.isNested = derivedFieldInfo.isNested() || this.isNested;
            PerFieldDerivedVectorTransformer perFieldDerivedVectorTransformer = PerFieldDerivedVectorTransformerFactory.create(derivedFieldInfo.fieldInfo(), derivedFieldInfo.isNested(), derivedSourceReaders);
            this.perFieldDerivedVectorTransformers.put(derivedFieldInfo.name(), perFieldDerivedVectorTransformer);
            perFieldDerivedVectorTransformersFunctionValues.put(derivedFieldInfo.name(), perFieldDerivedVectorTransformer);
        }
        this.derivedSourceVectorTransformer = XContentMapValues.transform(perFieldDerivedVectorTransformersFunctionValues, (boolean)true);
        this.derivedSourceLuceneHelper = new DerivedSourceLuceneHelper(derivedSourceReaders, segmentReadState);
    }

    public byte[] injectVectors(int docId, byte[] sourceAsBytes) throws IOException {
        Tuple mapTuple = XContentHelper.convertToMap((BytesReference)BytesReference.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(sourceAsBytes)), (boolean)true, (MediaType)MediaTypeRegistry.getDefaultMediaType());
        Map sourceAsMap = (Map)mapTuple.v2();
        int offset = 0;
        if (this.isNested) {
            offset = this.derivedSourceLuceneHelper.getFirstChild(docId);
        }
        for (PerFieldDerivedVectorTransformer vectorTransformer : this.perFieldDerivedVectorTransformers.values()) {
            vectorTransformer.setCurrentDoc(offset, docId);
        }
        Map<String, Object> copy = this.derivedSourceVectorTransformer.apply(sourceAsMap);
        BytesStreamOutput bStream = new BytesStreamOutput(1024);
        MediaType actualContentType = (MediaType)mapTuple.v1();
        XContentBuilder builder = MediaTypeRegistry.contentBuilder((MediaType)actualContentType, (OutputStream)bStream).map(copy);
        builder.close();
        return BytesReference.toBytes((BytesReference)BytesReference.bytes((XContentBuilder)builder));
    }

    public boolean shouldInject(String[] includes, String[] excludes) {
        if (includes != null && includes != Strings.EMPTY_ARRAY) {
            for (String includedField : includes) {
                if (!this.perFieldDerivedVectorTransformers.containsKey(includedField)) continue;
                return true;
            }
        }
        if (excludes != null && excludes != Strings.EMPTY_ARRAY) {
            int excludedVectorFieldCount = 0;
            for (String excludedField : excludes) {
                if (!this.perFieldDerivedVectorTransformers.containsKey(excludedField)) continue;
                ++excludedVectorFieldCount;
            }
            return excludedVectorFieldCount < this.perFieldDerivedVectorTransformers.size();
        }
        return true;
    }
}

