/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.util.Optional;
import java.util.stream.Stream;
import oracle.net.resolver.TimeUnit;

public class TimeUnitSuffixUtility {
    private static int getTimeInMilliseconds(String value) {
        Optional<TimeUnit> suffix = Stream.of(TimeUnit.values()).filter(p -> value.toUpperCase().endsWith(p.name())).findAny();
        if (suffix.isPresent()) {
            return Integer.parseInt(value.toUpperCase().replaceFirst(suffix.get().name(), "").trim()) * suffix.get().getMultiplier();
        }
        return Integer.parseInt(value);
    }

    public static int getTimeInMilliseconds(String value, boolean valueInSeconds) {
        if (!value.isEmpty() && value.matches("\\d*")) {
            return valueInSeconds ? Integer.parseInt(value) * 1000 : Integer.parseInt(value);
        }
        return TimeUnitSuffixUtility.getTimeInMilliseconds(value);
    }

    public static int getTimeInMilliseconds(String value, boolean valueInSeconds, int defaultValue) {
        try {
            return TimeUnitSuffixUtility.getTimeInMilliseconds(value, valueInSeconds);
        }
        catch (NumberFormatException numberFormatException) {
            return valueInSeconds ? defaultValue * 1000 : defaultValue;
        }
    }
}

