/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.builder.adapter;

import java.util.Iterator;
import org.xmlpull.v1.builder.Iterable;
import org.xmlpull.v1.builder.XmlAttribute;
import org.xmlpull.v1.builder.XmlBuilderException;
import org.xmlpull.v1.builder.XmlContainer;
import org.xmlpull.v1.builder.XmlDocument;
import org.xmlpull.v1.builder.XmlElement;
import org.xmlpull.v1.builder.XmlNamespace;

public class XmlElementAdapter
implements XmlElement {
    private XmlElementAdapter topAdapter;
    private XmlElement target;
    private XmlContainer parent;

    public XmlElementAdapter(XmlElement target) {
        this.setTarget(target);
    }

    private void setTarget(XmlElement target) {
        this.target = target;
        if (target.getParent() != null) {
            this.parent = target.getParent();
            if (this.parent instanceof XmlDocument) {
                XmlDocument doc = (XmlDocument)this.parent;
                doc.setDocumentElement(this);
            }
            if (this.parent instanceof XmlElement) {
                XmlElement parentEl = (XmlElement)this.parent;
                parentEl.replaceChild(this, target);
            }
        }
        Iterator iter = target.children();
        while (iter.hasNext()) {
            Object child = iter.next();
            this.fixImportedChildParent(child);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        XmlElementAdapter ela = (XmlElementAdapter)super.clone();
        ela.parent = null;
        ela.target = (XmlElement)this.target.clone();
        return ela;
    }

    public XmlElement getTarget() {
        return this.target;
    }

    public XmlElementAdapter getTopAdapter() {
        return this.topAdapter != null ? this.topAdapter : this;
    }

    public void setTopAdapter(XmlElementAdapter adapter) {
        this.topAdapter = adapter;
        if (this.target instanceof XmlElementAdapter) {
            ((XmlElementAdapter)this.target).setTopAdapter(adapter);
        }
    }

    public static XmlElementAdapter castOrWrap(XmlElement el, Class adapterClass) {
        if (el == null) {
            throw new IllegalArgumentException("null element can not be wrapped");
        }
        if (!XmlElementAdapter.class.isAssignableFrom(adapterClass)) {
            throw new IllegalArgumentException("class for cast/wrap must extend " + XmlElementAdapter.class);
        }
        if (el instanceof XmlElementAdapter) {
            XmlElementAdapter currentAdap = (XmlElementAdapter)el;
            Class<?> currentAdapClass = currentAdap.getClass();
            if (adapterClass.isAssignableFrom(currentAdapClass)) {
                return currentAdap;
            }
            XmlElementAdapter topAdapter = currentAdap = currentAdap.getTopAdapter();
            while (currentAdap.topAdapter != null) {
                currentAdapClass = currentAdap.getClass();
                if (currentAdapClass.isAssignableFrom(adapterClass)) {
                    return currentAdap;
                }
                if (!(currentAdap.target instanceof XmlElementAdapter)) break;
                currentAdap = (XmlElementAdapter)currentAdap.target;
            }
            try {
                currentAdap.topAdapter = (XmlElementAdapter)adapterClass.getConstructor(XmlElement.class).newInstance(topAdapter);
                currentAdap.topAdapter.setTopAdapter(currentAdap.topAdapter);
                return currentAdap.topAdapter;
            }
            catch (Exception e) {
                throw new XmlBuilderException("could not create wrapper of " + adapterClass, e);
            }
        }
        try {
            XmlElementAdapter t = (XmlElementAdapter)adapterClass.getConstructor(XmlElement.class).newInstance(el);
            return t;
        }
        catch (Exception e) {
            throw new XmlBuilderException("could not wrap element " + el, e);
        }
    }

    private void fixImportedChildParent(Object child) {
        XmlElement childEl;
        XmlContainer childElParent;
        if (child instanceof XmlElement && (childElParent = (childEl = (XmlElement)child).getParent()) == this.target) {
            childEl.setParent(this);
        }
    }

    private XmlElement fixElementParent(XmlElement el) {
        el.setParent(this);
        return el;
    }

    @Override
    public XmlContainer getRoot() {
        XmlContainer root = this.target.getRoot();
        if (root == this.target) {
            root = this;
        }
        return root;
    }

    @Override
    public XmlContainer getParent() {
        return this.parent;
    }

    @Override
    public void setParent(XmlContainer parent) {
        this.parent = parent;
    }

    @Override
    public XmlNamespace newNamespace(String prefix, String namespaceName) {
        return this.target.newNamespace(prefix, namespaceName);
    }

    @Override
    public XmlAttribute attribute(String attributeName) {
        return this.target.attribute(attributeName);
    }

    @Override
    public XmlAttribute attribute(XmlNamespace attributeNamespaceName, String attributeName) {
        return this.target.attribute(attributeNamespaceName, attributeName);
    }

    @Override
    public XmlAttribute findAttribute(String attributeNamespaceName, String attributeName) {
        return this.target.findAttribute(attributeNamespaceName, attributeName);
    }

    @Override
    public Iterator attributes() {
        return this.target.attributes();
    }

    @Override
    public void removeAllChildren() {
        this.target.removeAllChildren();
    }

    @Override
    public XmlAttribute addAttribute(String attributeType, String attributePrefix, String attributeNamespace, String attributeName, String attributeValue, boolean specified) {
        return this.target.addAttribute(attributeType, attributePrefix, attributeNamespace, attributeName, attributeValue, specified);
    }

    @Override
    public String getAttributeValue(String attributeNamespaceName, String attributeName) {
        return this.target.getAttributeValue(attributeNamespaceName, attributeName);
    }

    @Override
    public XmlAttribute addAttribute(XmlNamespace namespace, String name, String value) {
        return this.target.addAttribute(namespace, name, value);
    }

    @Override
    public String getNamespaceName() {
        return this.target.getNamespaceName();
    }

    @Override
    public void ensureChildrenCapacity(int minCapacity) {
        this.target.ensureChildrenCapacity(minCapacity);
    }

    @Override
    public Iterator namespaces() {
        return this.target.namespaces();
    }

    @Override
    public void removeAllAttributes() {
        this.target.removeAllAttributes();
    }

    @Override
    public XmlNamespace getNamespace() {
        return this.target.getNamespace();
    }

    @Override
    public String getBaseUri() {
        return this.target.getBaseUri();
    }

    @Override
    public void removeAttribute(XmlAttribute attr) {
        this.target.removeAttribute(attr);
    }

    @Override
    public XmlNamespace declareNamespace(String prefix, String namespaceName) {
        return this.target.declareNamespace(prefix, namespaceName);
    }

    @Override
    public void removeAllNamespaceDeclarations() {
        this.target.removeAllNamespaceDeclarations();
    }

    @Override
    public boolean hasAttributes() {
        return this.target.hasAttributes();
    }

    @Override
    public XmlAttribute addAttribute(String type, XmlNamespace namespace, String name, String value, boolean specified) {
        return this.target.addAttribute(type, namespace, name, value, specified);
    }

    @Override
    public XmlNamespace declareNamespace(XmlNamespace namespace) {
        return this.target.declareNamespace(namespace);
    }

    @Override
    public XmlAttribute addAttribute(String name, String value) {
        return this.target.addAttribute(name, value);
    }

    @Override
    public boolean hasNamespaceDeclarations() {
        return this.target.hasNamespaceDeclarations();
    }

    @Override
    public XmlNamespace lookupNamespaceByName(String namespaceName) {
        XmlContainer p;
        XmlNamespace ns = this.target.lookupNamespaceByName(namespaceName);
        if (ns == null && (p = this.getParent()) instanceof XmlElement) {
            XmlElement e = (XmlElement)p;
            return e.lookupNamespaceByName(namespaceName);
        }
        return ns;
    }

    @Override
    public XmlNamespace lookupNamespaceByPrefix(String namespacePrefix) {
        XmlContainer p;
        XmlNamespace ns = this.target.lookupNamespaceByPrefix(namespacePrefix);
        if (ns == null && (p = this.getParent()) instanceof XmlElement) {
            XmlElement e = (XmlElement)p;
            return e.lookupNamespaceByPrefix(namespacePrefix);
        }
        return ns;
    }

    @Override
    public XmlNamespace newNamespace(String namespaceName) {
        return this.target.newNamespace(namespaceName);
    }

    @Override
    public void setBaseUri(String baseUri) {
        this.target.setBaseUri(baseUri);
    }

    @Override
    public void setNamespace(XmlNamespace namespace) {
        this.target.setNamespace(namespace);
    }

    @Override
    public void ensureNamespaceDeclarationsCapacity(int minCapacity) {
        this.target.ensureNamespaceDeclarationsCapacity(minCapacity);
    }

    @Override
    public String getName() {
        return this.target.getName();
    }

    @Override
    public void setName(String name) {
        this.target.setName(name);
    }

    @Override
    public XmlAttribute addAttribute(String type, XmlNamespace namespace, String name, String value) {
        return this.target.addAttribute(type, namespace, name, value);
    }

    @Override
    public void ensureAttributeCapacity(int minCapacity) {
        this.target.ensureAttributeCapacity(minCapacity);
    }

    @Override
    public XmlAttribute addAttribute(XmlAttribute attributeValueToAdd) {
        return this.target.addAttribute(attributeValueToAdd);
    }

    @Override
    public XmlElement element(int position) {
        return this.target.element(position);
    }

    @Override
    public XmlElement requiredElement(XmlNamespace n, String name) {
        return this.target.requiredElement(n, name);
    }

    @Override
    public XmlElement element(XmlNamespace n, String name) {
        return this.target.element(n, name);
    }

    @Override
    public XmlElement element(XmlNamespace n, String name, boolean create) {
        return this.target.element(n, name, create);
    }

    @Override
    public Iterable elements(XmlNamespace n, String name) {
        return this.target.elements(n, name);
    }

    @Override
    public XmlElement findElementByName(String name, XmlElement elementToStartLooking) {
        return this.target.findElementByName(name, elementToStartLooking);
    }

    @Override
    public XmlElement newElement(XmlNamespace namespace, String name) {
        return this.target.newElement(namespace, name);
    }

    @Override
    public XmlElement addElement(XmlElement child) {
        return this.fixElementParent(this.target.addElement(child));
    }

    @Override
    public XmlElement addElement(int pos, XmlElement child) {
        return this.fixElementParent(this.target.addElement(pos, child));
    }

    @Override
    public XmlElement addElement(String name) {
        return this.fixElementParent(this.target.addElement(name));
    }

    @Override
    public XmlElement findElementByName(String namespaceName, String name) {
        return this.target.findElementByName(namespaceName, name);
    }

    @Override
    public void addChild(Object child) {
        this.target.addChild(child);
        this.fixImportedChildParent(child);
    }

    @Override
    public void insertChild(int pos, Object childToInsert) {
        this.target.insertChild(pos, childToInsert);
        this.fixImportedChildParent(childToInsert);
    }

    @Override
    public XmlElement findElementByName(String name) {
        return this.target.findElementByName(name);
    }

    @Override
    public XmlElement findElementByName(String namespaceName, String name, XmlElement elementToStartLooking) {
        return this.target.findElementByName(namespaceName, name, elementToStartLooking);
    }

    @Override
    public void removeChild(Object child) {
        this.target.removeChild(child);
    }

    @Override
    public Iterator children() {
        return this.target.children();
    }

    @Override
    public Iterable requiredElementContent() {
        return this.target.requiredElementContent();
    }

    @Override
    public String requiredTextContent() {
        return this.target.requiredTextContent();
    }

    @Override
    public boolean hasChild(Object child) {
        return this.target.hasChild(child);
    }

    @Override
    public XmlElement newElement(String namespaceName, String name) {
        return this.target.newElement(namespaceName, name);
    }

    @Override
    public XmlElement addElement(XmlNamespace namespace, String name) {
        return this.fixElementParent(this.target.addElement(namespace, name));
    }

    @Override
    public boolean hasChildren() {
        return this.target.hasChildren();
    }

    @Override
    public void addChild(int pos, Object child) {
        this.target.addChild(pos, child);
        this.fixImportedChildParent(child);
    }

    @Override
    public void replaceChild(Object newChild, Object oldChild) {
        this.target.replaceChild(newChild, oldChild);
        this.fixImportedChildParent(newChild);
    }

    @Override
    public XmlElement newElement(String name) {
        return this.target.newElement(name);
    }

    @Override
    public void replaceChildrenWithText(String textContent) {
        this.target.replaceChildrenWithText(textContent);
    }
}

