/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model.schema;

import java.math.BigDecimal;
import java.util.Objects;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.DiffResult;

public class ChangedMultipleOf
implements Changed {
    private final BigDecimal left;
    private final BigDecimal right;

    public ChangedMultipleOf(BigDecimal leftMultipleOf, BigDecimal rightMultipleOf) {
        this.left = leftMultipleOf;
        this.right = rightMultipleOf;
    }

    @Override
    public DiffResult isChanged() {
        if (Objects.equals(this.left, this.right)) {
            return DiffResult.NO_CHANGES;
        }
        if (this.right == null) {
            return DiffResult.COMPATIBLE;
        }
        return DiffResult.INCOMPATIBLE;
    }

    public BigDecimal getLeft() {
        return this.left;
    }

    public BigDecimal getRight() {
        return this.right;
    }

    public String toString() {
        return "ChangedMultipleOf [left=" + this.left + ", right=" + this.right + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangedMultipleOf that = (ChangedMultipleOf)o;
        return Objects.equals(this.left, that.getLeft()) && Objects.equals(this.right, that.getRight());
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }
}

