/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.share;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kafka.server.share.SharePartition;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.server.share.SharePartitionKey;

public class SharePartitionCache {
    private final Map<String, Set<TopicIdPartition>> groups = new HashMap<String, Set<TopicIdPartition>>();
    private final Map<SharePartitionKey, SharePartition> partitions = new ConcurrentHashMap<SharePartitionKey, SharePartition>();

    SharePartitionCache() {
    }

    public SharePartition get(SharePartitionKey partitionKey) {
        return this.partitions.get(partitionKey);
    }

    public synchronized Set<TopicIdPartition> topicIdPartitionsForGroup(String groupId) {
        return this.groups.containsKey(groupId) ? Set.copyOf((Collection)this.groups.get(groupId)) : Set.of();
    }

    public synchronized SharePartition remove(SharePartitionKey partitionKey) {
        this.groups.computeIfPresent(partitionKey.groupId(), (k, v) -> {
            v.remove(partitionKey.topicIdPartition());
            return v.isEmpty() ? null : v;
        });
        return this.partitions.remove(partitionKey);
    }

    public synchronized SharePartition computeIfAbsent(SharePartitionKey partitionKey, Function<SharePartitionKey, SharePartition> mappingFunction) {
        this.groups.computeIfAbsent(partitionKey.groupId(), (? super K k) -> new HashSet()).add(partitionKey.topicIdPartition());
        return this.partitions.computeIfAbsent(partitionKey, mappingFunction);
    }

    public Set<SharePartitionKey> cachedSharePartitionKeys() {
        return this.partitions.keySet();
    }

    void put(SharePartitionKey partitionKey, SharePartition sharePartition) {
        this.partitions.put(partitionKey, sharePartition);
    }

    int size() {
        return this.partitions.size();
    }

    boolean containsKey(SharePartitionKey partitionKey) {
        return this.partitions.containsKey(partitionKey);
    }

    boolean isEmpty() {
        return this.partitions.isEmpty();
    }

    synchronized Map<String, Set<TopicIdPartition>> groups() {
        return Map.copyOf(this.groups);
    }
}

