/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.awt.Component;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.io.GpxWriter;
import org.openstreetmap.josm.io.session.GenericSessionExporter;
import org.openstreetmap.josm.io.session.SessionWriter;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.w3c.dom.Element;

public class GpxTracksSessionExporter
extends GenericSessionExporter<GpxLayer> {
    private Instant metaTime;
    private JCheckBox chkMarkers;
    private boolean hasMarkerLayer;

    public GpxTracksSessionExporter(GpxLayer layer) {
        this(layer, "tracks");
    }

    protected GpxTracksSessionExporter(GpxLayer layer, String type) {
        super(layer, type, "0.1", "gpx");
        if (layer.data == null) {
            throw new IllegalArgumentException("GPX layer without data: " + String.valueOf(layer));
        }
        this.hasMarkerLayer = layer.getLinkedMarkerLayer() != null && layer.getLinkedMarkerLayer().data != null && !layer.getLinkedMarkerLayer().data.isEmpty();
    }

    @Override
    public JPanel getExportPanel() {
        JPanel p = super.getExportPanel();
        if (this.hasMarkerLayer) {
            this.chkMarkers = new JCheckBox();
            this.chkMarkers.setText(I18n.tr("include marker layer \"{0}\"", ((GpxLayer)this.layer).getLinkedMarkerLayer().getName()));
            this.chkMarkers.setSelected(true);
            p.add((Component)this.chkMarkers, GBC.eol().insets(12, 0, 0, 5));
        }
        return p;
    }

    @Override
    public Element export(SessionWriter.ExportSupport support) throws IOException {
        Element el = super.export(support);
        if (this.hasMarkerLayer && (this.chkMarkers == null || this.chkMarkers.isSelected())) {
            Element markerEl = support.createElement("markerLayer");
            markerEl.setAttribute("index", Integer.toString(support.getLayerIndexOf(((GpxLayer)this.layer).getLinkedMarkerLayer())));
            markerEl.setAttribute("name", ((GpxLayer)this.layer).getLinkedMarkerLayer().getName());
            markerEl.setAttribute("visible", Boolean.toString(((GpxLayer)this.layer).getLinkedMarkerLayer().isVisible()));
            if (((GpxLayer)this.layer).getLinkedMarkerLayer().getOpacity() != 1.0) {
                markerEl.setAttribute("opacity", Double.toString(((GpxLayer)this.layer).getLinkedMarkerLayer().getOpacity()));
            }
            el.appendChild(markerEl);
        }
        return el;
    }

    @Override
    protected void addDataFile(OutputStream out) {
        OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        GpxWriter w = new GpxWriter(new PrintWriter(writer));
        if (this.metaTime != null) {
            w.setMetaTime(this.metaTime);
        }
        w.write(((GpxLayer)this.layer).data);
        w.flush();
    }

    protected void setMetaTime(Instant metaTime) {
        this.metaTime = metaTime;
    }
}

