/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Collection;
import java.util.Collections;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.FilterMatcher;
import org.openstreetmap.josm.data.osm.IFilterablePrimitive;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.search.SearchParseError;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

public final class FilterWorker {
    private FilterWorker() {
    }

    public static <T extends IPrimitive & IFilterablePrimitive> boolean executeFilters(Collection<T> all, Filter ... filters) throws SearchParseError {
        return FilterWorker.executeFilters(all, FilterMatcher.of(filters));
    }

    public static <T extends IPrimitive & IFilterablePrimitive> boolean executeFilters(Collection<T> all, FilterMatcher filterMatcher) {
        boolean changed = FilterWorker.doExecuteFilters(SubclassFilteredCollection.filter(all, arg_0 -> FilterWorker.lambda$executeFilters$0(IRelation.class, arg_0)), filterMatcher);
        changed |= FilterWorker.doExecuteFilters(SubclassFilteredCollection.filter(all, arg_0 -> FilterWorker.lambda$executeFilters$1(IWay.class, arg_0)), filterMatcher);
        return changed |= FilterWorker.doExecuteFilters(SubclassFilteredCollection.filter(all, arg_0 -> FilterWorker.lambda$executeFilters$2(INode.class, arg_0)), filterMatcher);
    }

    private static <T extends IPrimitive & IFilterablePrimitive> boolean doExecuteFilters(Collection<T> all, FilterMatcher filterMatcher) {
        boolean changed = false;
        for (IPrimitive primitive : all) {
            FilterMatcher.FilterType hiddenType = filterMatcher.isHidden(primitive);
            if (hiddenType != FilterMatcher.FilterType.NOT_FILTERED) {
                changed |= ((IFilterablePrimitive)((Object)primitive)).setDisabledState(true);
                ((IFilterablePrimitive)((Object)primitive)).setHiddenType(hiddenType == FilterMatcher.FilterType.EXPLICIT);
                continue;
            }
            FilterMatcher.FilterType disabledType = filterMatcher.isDisabled(primitive);
            if (disabledType != FilterMatcher.FilterType.NOT_FILTERED) {
                changed |= ((IFilterablePrimitive)((Object)primitive)).setDisabledState(false);
                ((IFilterablePrimitive)((Object)primitive)).setDisabledType(disabledType == FilterMatcher.FilterType.EXPLICIT);
                continue;
            }
            changed |= ((IFilterablePrimitive)((Object)primitive)).unsetDisabledState();
        }
        return changed;
    }

    public static <T extends IPrimitive & IFilterablePrimitive> boolean executeFilters(T primitive, FilterMatcher filterMatcher) {
        return FilterWorker.doExecuteFilters(Collections.singleton(primitive), filterMatcher);
    }

    public static <T extends IPrimitive & IFilterablePrimitive> boolean clearFilterFlags(Collection<T> prims) {
        boolean changed = false;
        for (IPrimitive osm : prims) {
            changed |= ((IFilterablePrimitive)((Object)osm)).unsetDisabledState();
        }
        return changed;
    }

    private static /* synthetic */ boolean lambda$executeFilters$2(Class rec$, Object x$0) {
        return rec$.isInstance(x$0);
    }

    private static /* synthetic */ boolean lambda$executeFilters$1(Class rec$, Object x$0) {
        return rec$.isInstance(x$0);
    }

    private static /* synthetic */ boolean lambda$executeFilters$0(Class rec$, Object x$0) {
        return rec$.isInstance(x$0);
    }
}

