/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote;

import com.jetbrains.cef.remote.ThriftTransport;
import com.jetbrains.cef.remote.thrift.TException;
import com.jetbrains.cef.remote.thrift.protocol.TBinaryProtocol;
import com.jetbrains.cef.remote.thrift.protocol.TProtocol;
import com.jetbrains.cef.remote.thrift.transport.TSocket;
import com.jetbrains.cef.remote.thrift.transport.TTransport;
import com.jetbrains.cef.remote.thrift.transport.TTransportException;
import com.jetbrains.cef.remote.thrift_codegen.Server;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.cef.misc.CefLog;

public class RpcExecutor {
    private TTransport myTransport;
    private TProtocol myProtocol;
    private Server.Iface myServer;

    public RpcExecutor openTransport(ThriftTransport thriftServer) throws TTransportException {
        if (thriftServer.isTcp()) {
            this.openTcpTransport(thriftServer.getPort());
        } else {
            this.openPipeTransport(thriftServer);
        }
        return this;
    }

    private void openTcpTransport(int port) throws TTransportException {
        try {
            this.myTransport = new TSocket("localhost", port);
            this.myTransport.open();
            this.myProtocol = new TBinaryProtocol(this.myTransport);
            this.myServer = new Server.Client(this.myProtocol);
        }
        catch (TTransportException e) {
            this.myTransport = null;
            throw e;
        }
    }

    public void openPipeTransport(ThriftTransport thriftServer) throws TTransportException {
        this.myTransport = thriftServer.openPipeTransport();
        this.myProtocol = new TBinaryProtocol(this.myTransport);
        this.myServer = new Server.Client(this.myProtocol);
    }

    public TTransport getTransport() {
        return this.myTransport;
    }

    public boolean isValid() {
        TTransport t = this.myTransport;
        return t != null && t.isOpen();
    }

    public synchronized int connect(ThriftTransport thriftBackward, boolean asMaster) {
        if (this.myTransport == null) {
            return -1;
        }
        try {
            return thriftBackward.isTcp() ? this.myServer.connectTcp(thriftBackward.getPort(), asMaster) : this.myServer.connect(thriftBackward.getPipe(), asMaster);
        }
        catch (TException e) {
            this.onThriftException(e);
            return -1;
        }
    }

    public synchronized void exec(Rpc r) {
        if (this.myTransport == null) {
            return;
        }
        try {
            r.run(this.myServer);
        }
        catch (TException e) {
            this.onThriftException(e);
        }
    }

    public synchronized <T> T execObj(RpcObj<T> r) {
        if (this.myTransport == null) {
            return null;
        }
        try {
            return r.run(this.myServer);
        }
        catch (TException e) {
            this.onThriftException(e);
            return null;
        }
    }

    public synchronized void closeTransport() {
        if (this.myTransport != null) {
            this.myTransport.close();
            this.myTransport = null;
        }
    }

    private void onThriftException(TException e) {
        CefLog.Debug("thrift exception '%s'", e.getMessage());
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        CefLog.Debug(sw.getBuffer().toString(), new Object[0]);
    }

    public static interface Rpc {
        public void run(Server.Iface var1) throws TException;
    }

    public static interface RpcObj<T> {
        public T run(Server.Iface var1) throws TException;
    }
}

