/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleTooling;

import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.gradleTooling.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/gradleTooling/KotlinNativeHomeEvaluator;", "", "<init>", "()V", "KOTLIN_NATIVE_HOME_PRIVATE_PROPERTY", "", "FALLBACK_ACCESSOR_CLASS", "FALLBACK_ACCESSOR_METHOD", "getKotlinNativeHome", "project", "Lorg/gradle/api/Project;", "getKotlinNativeHomePrimary", "getKotlinNativeHomeFallback", "intellij.kotlin.gradle.tooling.impl"})
public final class KotlinNativeHomeEvaluator {
    @NotNull
    public static final KotlinNativeHomeEvaluator INSTANCE = new KotlinNativeHomeEvaluator();
    @NotNull
    private static final String KOTLIN_NATIVE_HOME_PRIVATE_PROPERTY = "konanHome";
    @NotNull
    private static final String FALLBACK_ACCESSOR_CLASS = "org.jetbrains.kotlin.compilerRunner.KotlinNativeToolRunnerKt";
    @NotNull
    private static final String FALLBACK_ACCESSOR_METHOD = "getKonanHome";

    private KotlinNativeHomeEvaluator() {
    }

    @Nullable
    public final String getKotlinNativeHome(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = this.getKotlinNativeHomePrimary(project);
        if (string == null) {
            string = this.getKotlinNativeHomeFallback(project);
        }
        return string;
    }

    private final String getKotlinNativeHomePrimary(Project project) {
        return (String)project.findProperty(KOTLIN_NATIVE_HOME_PRIVATE_PROPERTY);
    }

    private final String getKotlinNativeHomeFallback(Project project) {
        Class<?> clazz;
        Class<?> clazz2 = project.getExtensions().findByName("kotlin");
        if (clazz2 == null || (clazz2 = clazz2.getClass()) == null || (clazz2 = clazz2.getClassLoader()) == null) {
            return null;
        }
        Class<?> kotlinExtensionClassLoader = clazz2;
        try {
            clazz = Class.forName(FALLBACK_ACCESSOR_CLASS, true, (ClassLoader)((Object)kotlinExtensionClassLoader));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        Class<?> accessorClass = clazz;
        Intrinsics.checkNotNull(accessorClass);
        Object[] objectArray = new Class[]{Project.class};
        Method method = UtilsKt.getMethodOrNull(accessorClass, FALLBACK_ACCESSOR_METHOD, objectArray);
        if (method == null) {
            return null;
        }
        Method accessorMethod = method;
        objectArray = new Object[]{project};
        Object object = accessorMethod.invoke(null, objectArray);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        return (String)object;
    }
}

