/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.actions;

import com.intellij.CommonBundle;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.DefaultCoverageFileProvider;
import com.intellij.coverage.actions.ExternalReportImportManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class CoverageSuiteChooserDialog
extends DialogWrapper {
    @NonNls
    private static final String LOCAL = "Local";
    private final Project myProject;
    private final CheckboxTree mySuitesTree;
    private final CoverageDataManager myCoverageManager;
    private final CheckedTreeNode myRootNode;

    public CoverageSuiteChooserDialog(Project project) {
        super(project, true);
        this.myProject = project;
        this.myCoverageManager = CoverageDataManager.getInstance(project);
        this.myRootNode = new CheckedTreeNode((Object)"");
        this.initTree();
        this.mySuitesTree = new CheckboxTree(new SuitesRenderer(), this.myRootNode){

            protected void installSpeedSearch() {
                TreeSpeedSearch.installOn((JTree)((Object)this), (boolean)false, path -> {
                    DefaultMutableTreeNode component = (DefaultMutableTreeNode)path.getLastPathComponent();
                    Object userObject = component.getUserObject();
                    if (userObject instanceof CoverageSuite) {
                        return ((CoverageSuite)userObject).getPresentableName();
                    }
                    return userObject.toString();
                });
            }
        };
        this.mySuitesTree.getEmptyText().appendText(CoverageBundle.message("no.coverage.suites.configured", new Object[0]));
        this.mySuitesTree.setRootVisible(false);
        this.mySuitesTree.setShowsRootHandles(false);
        TreeUtil.installActions((JTree)this.mySuitesTree);
        TreeUtil.expandAll((JTree)this.mySuitesTree);
        TreeUtil.promiseSelectFirst((JTree)this.mySuitesTree);
        this.mySuitesTree.setMinimumSize(new Dimension(25, -1));
        this.setOKButtonText(CoverageBundle.message("coverage.data.show.selected.button", new Object[0]));
        this.init();
        this.setTitle(CoverageBundle.message("choose.coverage.suite.to.display", new Object[0]));
    }

    protected JComponent createCenterPanel() {
        return ScrollPaneFactory.createScrollPane((Component)this.mySuitesTree);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySuitesTree;
    }

    protected JComponent createNorthPanel() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new AddExternalSuiteAction());
        group.add((AnAction)new RemoveSuiteAction());
        group.add((AnAction)new DeleteSuiteAction());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("CoverageSuiteChooser", (ActionGroup)group, true);
        toolbar.setTargetComponent((JComponent)this.mySuitesTree);
        return toolbar.getComponent();
    }

    @VisibleForTesting
    public void doOKAction() {
        List<CoverageSuite> suites = this.collectSelectedSuites();
        ExternalReportImportManager.getInstance(this.myProject).openSuites(suites, true, ExternalReportImportManager.Source.DIALOG);
        super.doOKAction();
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), new NoCoverageAction(), this.getCancelAction()};
        if (actionArray == null) {
            CoverageSuiteChooserDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    private static String getCoverageRunnerTitle(CoverageRunner coverageRunner) {
        return CoverageBundle.message("coverage.data.runner.name", coverageRunner.getPresentableName());
    }

    private List<CoverageSuite> collectSelectedSuites() {
        ArrayList<CoverageSuite> suites = new ArrayList<CoverageSuite>();
        TreeUtil.treeNodeTraverser((TreeNode)this.myRootNode).traverse(TreeTraversal.PRE_ORDER_DFS).processEach(treeNode -> {
            Object userObject;
            CheckedTreeNode checkedTreeNode;
            if (treeNode instanceof CheckedTreeNode && (checkedTreeNode = (CheckedTreeNode)treeNode).isChecked() && (userObject = checkedTreeNode.getUserObject()) instanceof CoverageSuite) {
                CoverageSuite suite = (CoverageSuite)userObject;
                suites.add(suite);
            }
            return true;
        });
        return suites;
    }

    private void selectSuites(List<CoverageSuite> suites) {
        TreeUtil.treeNodeTraverser((TreeNode)this.myRootNode).traverse(TreeTraversal.PRE_ORDER_DFS).processEach(treeNode -> {
            if (treeNode instanceof CheckedTreeNode) {
                CheckedTreeNode checkedTreeNode;
                Object userObject = (checkedTreeNode = (CheckedTreeNode)treeNode).getUserObject();
                checkedTreeNode.setChecked(userObject instanceof CoverageSuite && suites.contains(userObject));
            }
            return true;
        });
    }

    private void initTree() {
        this.myRootNode.removeAllChildren();
        HashMap<CoverageRunner, Map<String, List<CoverageSuite>>> grouped = new HashMap<CoverageRunner, Map<String, List<CoverageSuite>>>();
        CoverageSuiteChooserDialog.groupSuites(grouped, this.myCoverageManager.getSuites());
        ArrayList<CoverageRunner> runners = new ArrayList<CoverageRunner>(grouped.keySet());
        runners.sort((o1, o2) -> o1.getPresentableName().compareToIgnoreCase(o2.getPresentableName()));
        for (CoverageRunner runner : runners) {
            DefaultMutableTreeNode runnerNode = new DefaultMutableTreeNode(CoverageSuiteChooserDialog.getCoverageRunnerTitle(runner));
            this.myRootNode.add((MutableTreeNode)runnerNode);
            Map<String, List<CoverageSuite>> providers = grouped.get(runner);
            if (providers.size() == 1) {
                String providerKey = providers.keySet().iterator().next();
                DefaultMutableTreeNode parent = runnerNode;
                if (!CoverageSuiteChooserDialog.isLocalProvider(providerKey)) {
                    DefaultMutableTreeNode remoteNode = new DefaultMutableTreeNode(CoverageBundle.message("remote.suites.node", new Object[0]));
                    parent.add(remoteNode);
                    parent = remoteNode;
                }
                List<CoverageSuite> suites = providers.get(providerKey);
                this.createSuitesNodes(suites, parent);
                continue;
            }
            DefaultMutableTreeNode localNode = new DefaultMutableTreeNode(LOCAL);
            DefaultMutableTreeNode remoteNode = new DefaultMutableTreeNode(CoverageBundle.message("remote.suites.node", new Object[0]));
            runnerNode.add(localNode);
            runnerNode.add(remoteNode);
            for (Map.Entry<String, List<CoverageSuite>> entry : providers.entrySet()) {
                DefaultMutableTreeNode parent = CoverageSuiteChooserDialog.isLocalProvider(entry.getKey()) ? localNode : remoteNode;
                this.createSuitesNodes(entry.getValue(), parent);
            }
        }
    }

    private void createSuitesNodes(@Unmodifiable List<CoverageSuite> suites, DefaultMutableTreeNode parent) {
        suites = ContainerUtil.sorted(suites, (o1, o2) -> o1.getPresentableName().compareToIgnoreCase(o2.getPresentableName()));
        for (CoverageSuite suite : suites) {
            CheckedTreeNode treeNode = new CheckedTreeNode((Object)suite);
            treeNode.setChecked(this.isSuiteActive(suite));
            parent.add((MutableTreeNode)treeNode);
        }
    }

    private static boolean isLocalProvider(String providerKey) {
        return Comparing.strEqual((String)providerKey, (String)DefaultCoverageFileProvider.DEFAULT_LOCAL_PROVIDER_KEY);
    }

    private boolean isSuiteActive(CoverageSuite suite) {
        return ContainerUtil.exists(this.myCoverageManager.activeSuites(), bundle -> bundle.contains(suite));
    }

    private static void groupSuites(HashMap<CoverageRunner, Map<String, List<CoverageSuite>>> grouped, CoverageSuite[] suites) {
        for (CoverageSuite suite : suites) {
            String string;
            DefaultCoverageFileProvider defaultProvider;
            CoverageFileProvider provider = suite.getCoverageDataFileProvider();
            if (provider instanceof DefaultCoverageFileProvider && CoverageSuiteChooserDialog.isLocalProvider((defaultProvider = (DefaultCoverageFileProvider)provider).getSourceProvider()) && !provider.ensureFileExists()) continue;
            Map byProviders = grouped.computeIfAbsent(suite.getRunner(), unused -> new HashMap());
            if (provider instanceof DefaultCoverageFileProvider) {
                DefaultCoverageFileProvider defaultProvider2 = (DefaultCoverageFileProvider)provider;
                string = defaultProvider2.getSourceProvider();
            } else {
                string = provider.getClass().getName();
            }
            String sourceProvider = string;
            List list = byProviders.computeIfAbsent(sourceProvider, unused -> new ArrayList());
            list.add(suite);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/actions/CoverageSuiteChooserDialog", "createActions"));
    }

    private static class SuitesRenderer
    extends CheckboxTree.CheckboxTreeCellRenderer {
        private SuitesRenderer() {
        }

        public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode defaultNode;
            Object userObject;
            if (value instanceof CheckedTreeNode) {
                CheckedTreeNode checkedTreeNode = (CheckedTreeNode)value;
                Object userObject2 = checkedTreeNode.getUserObject();
                if (userObject2 instanceof CoverageSuite) {
                    CoverageSuite suite = (CoverageSuite)userObject2;
                    this.getTextRenderer().append(suite.getPresentableName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    String date = " (" + DateFormatUtil.formatPrettyDateTime((long)suite.getLastCoverageTimeStamp()) + ")";
                    this.getTextRenderer().append(date, SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            } else if (value instanceof DefaultMutableTreeNode && (userObject = (defaultNode = (DefaultMutableTreeNode)value).getUserObject()) instanceof String) {
                @Nls String name = (String)userObject;
                this.getTextRenderer().append(name);
            }
        }
    }

    private final class AddExternalSuiteAction
    extends AnAction {
        AddExternalSuiteAction() {
            super(CommonBundle.message((String)"button.add", (Object[])new Object[0]), CommonBundle.message((String)"button.add", (Object[])new Object[0]), IconUtil.getAddIcon());
            this.registerCustomShortcutSet(CommonShortcuts.getInsert(), (JComponent)CoverageSuiteChooserDialog.this.mySuitesTree);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List<CoverageSuite> suites;
            if (e == null) {
                AddExternalSuiteAction.$$$reportNull$$$0(0);
            }
            if (!(suites = ExternalReportImportManager.getInstance(CoverageSuiteChooserDialog.this.myProject).chooseAndImportCoverageReportsFromDisc()).isEmpty()) {
                List<CoverageSuite> currentlySelected = CoverageSuiteChooserDialog.this.collectSelectedSuites();
                currentlySelected.addAll(suites);
                CoverageSuiteChooserDialog.this.initTree();
                CoverageSuiteChooserDialog.this.selectSuites(currentlySelected);
                ((DefaultTreeModel)CoverageSuiteChooserDialog.this.mySuitesTree.getModel()).reload();
                TreeUtil.expandAll((JTree)CoverageSuiteChooserDialog.this.mySuitesTree);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/coverage/actions/CoverageSuiteChooserDialog$AddExternalSuiteAction", "actionPerformed"));
        }
    }

    private final class RemoveSuiteAction
    extends AnAction {
        RemoveSuiteAction() {
            super(CommonBundle.message((String)"button.remove", (Object[])new Object[0]), CommonBundle.message((String)"button.remove", (Object[])new Object[0]), PlatformIcons.DELETE_ICON);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            CheckedTreeNode[] selectedNodes;
            if (e == null) {
                RemoveSuiteAction.$$$reportNull$$$0(0);
            }
            for (CheckedTreeNode selectedNode : selectedNodes = (CheckedTreeNode[])CoverageSuiteChooserDialog.this.mySuitesTree.getSelectedNodes(CheckedTreeNode.class, null)) {
                Object userObject = selectedNode.getUserObject();
                if (!(userObject instanceof CoverageSuite)) continue;
                CoverageSuite selectedSuite = (CoverageSuite)userObject;
                CoverageSuiteChooserDialog.this.myCoverageManager.unregisterCoverageSuite(selectedSuite);
                TreeUtil.removeLastPathComponent((JTree)CoverageSuiteChooserDialog.this.mySuitesTree, (TreePath)new TreePath(selectedNode.getPath()));
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoveSuiteAction.$$$reportNull$$$0(1);
            }
            CheckedTreeNode[] selectedSuites = (CheckedTreeNode[])CoverageSuiteChooserDialog.this.mySuitesTree.getSelectedNodes(CheckedTreeNode.class, null);
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(selectedSuites.length > 0);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                RemoveSuiteAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/coverage/actions/CoverageSuiteChooserDialog$RemoveSuiteAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/coverage/actions/CoverageSuiteChooserDialog$RemoveSuiteAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private final class DeleteSuiteAction
    extends AnAction {
        DeleteSuiteAction() {
            super(CommonBundle.message((String)"button.delete", (Object[])new Object[0]), CommonBundle.message((String)"button.delete", (Object[])new Object[0]), AllIcons.Actions.GC);
            this.registerCustomShortcutSet(CommonShortcuts.getDelete(), (JComponent)CoverageSuiteChooserDialog.this.mySuitesTree);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            CheckedTreeNode[] selectedNodes;
            if (e == null) {
                DeleteSuiteAction.$$$reportNull$$$0(0);
            }
            for (CheckedTreeNode selectedNode : selectedNodes = (CheckedTreeNode[])CoverageSuiteChooserDialog.this.mySuitesTree.getSelectedNodes(CheckedTreeNode.class, null)) {
                CoverageSuite selectedSuite;
                Object userObject = selectedNode.getUserObject();
                if (!(userObject instanceof CoverageSuite) || !(selectedSuite = (CoverageSuite)userObject).canRemove()) continue;
                CoverageSuiteChooserDialog.this.myCoverageManager.removeCoverageSuite(selectedSuite);
                TreeUtil.removeLastPathComponent((JTree)CoverageSuiteChooserDialog.this.mySuitesTree, (TreePath)new TreePath(selectedNode.getPath()));
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                DeleteSuiteAction.$$$reportNull$$$0(1);
            }
            CheckedTreeNode[] selectedSuites = (CheckedTreeNode[])CoverageSuiteChooserDialog.this.mySuitesTree.getSelectedNodes(CheckedTreeNode.class, null);
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(false);
            for (CheckedTreeNode node : selectedSuites) {
                CoverageSuite selectedSuite;
                Object userObject = node.getUserObject();
                if (!(userObject instanceof CoverageSuite) || !(selectedSuite = (CoverageSuite)userObject).canRemove()) continue;
                presentation.setEnabled(true);
                return;
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                DeleteSuiteAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/coverage/actions/CoverageSuiteChooserDialog$DeleteSuiteAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/coverage/actions/CoverageSuiteChooserDialog$DeleteSuiteAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    public final class NoCoverageAction
    extends DialogWrapper.DialogWrapperAction {
        @VisibleForTesting
        public NoCoverageAction() {
            super((DialogWrapper)CoverageSuiteChooserDialog.this, CoverageBundle.message("coverage.data.no.coverage.button", new Object[0]));
        }

        @VisibleForTesting
        public void doAction(ActionEvent e) {
            for (CoverageSuitesBundle suitesBundle : CoverageSuiteChooserDialog.this.myCoverageManager.activeSuites()) {
                CoverageSuiteChooserDialog.this.myCoverageManager.closeSuitesBundle(suitesBundle);
            }
            CoverageSuiteChooserDialog.this.close(0);
        }
    }
}

