/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index.vfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.vcs.log.Hash;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.i18n.GitBundle;
import git4idea.index.vfs.GitIndexFileSystem;
import git4idea.index.vfs.GitIndexFileSystemRefresher;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 N2\u00020\u00012\u00020\u0002:\u0002NOB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u0016J\u0013\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0016J\b\u0010\u001f\u001a\u00020\u001dH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020!H\u0016J\b\u0010#\u001a\u00020!H\u0016J\b\u0010$\u001a\u00020!H\u0016J\b\u0010%\u001a\u00020\u001dH\u0016J\b\u0010)\u001a\u00020\u0015H\u0016J\b\u0010*\u001a\u00020\u0015H\u0016J\b\u0010+\u001a\u00020\u0015H\u0016J\b\u0010,\u001a\u00020-H\u0016J\"\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u001d2\b\u00102\u001a\u0004\u0018\u000103H\u0016J'\u00104\u001a\u00020/2\b\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u00020\u00152\u0006\u00108\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b9J'\u0010:\u001a\u00020/2\b\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u00020\u00152\u0006\u00108\u001a\u00020\u001dH\u0001\u00a2\u0006\u0002\b;J%\u0010<\u001a\u00020/2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u00152\u0006\u0010=\u001a\u00020\u0015H\u0001\u00a2\u0006\u0002\b>J\"\u0010?\u001a\u00020@2\b\u0010A\u001a\u0004\u0018\u00010B2\u0006\u0010=\u001a\u00020\u00152\u0006\u0010C\u001a\u00020\u0015H\u0016J\b\u0010D\u001a\u00020EH\u0016J\b\u0010F\u001a\u00020GH\u0016J\u0013\u0010H\u001a\u00020\u001d2\b\u0010I\u001a\u0004\u0018\u00010BH\u0096\u0002J\b\u0010J\u001a\u00020KH\u0016J\r\u0010L\u001a\u00070!\u00a2\u0006\u0002\bMH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020\u001d8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006P"}, d2={"Lgit4idea/index/vfs/GitIndexVirtualFile;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/openapi/vfs/VirtualFilePathWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "root", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vcs/FilePath;)V", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getFilePath", "()Lcom/intellij/openapi/vcs/FilePath;", "data", "Lgit4idea/index/vfs/GitIndexVirtualFile$CachedData;", "getData$intellij_vcs_git", "()Lgit4idea/index/vfs/GitIndexVirtualFile$CachedData;", "setData$intellij_vcs_git", "(Lgit4idea/index/vfs/GitIndexVirtualFile$CachedData;)V", "modificationStamp", "", "getFileSystem", "Lgit4idea/index/vfs/GitIndexFileSystem;", "getParent", "getChildren", "", "()[Lcom/intellij/openapi/vfs/VirtualFile;", "isWritable", "", "isDirectory", "isValid", "getName", "", "getPresentableName", "getPath", "getPresentablePath", "enforcePresentableName", "isExecutable", "isExecutable$intellij_vcs_git", "()Z", "getLength", "getTimeStamp", "getModificationStamp", "getFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "refresh", "", "asynchronous", "recursive", "postRunnable", "Ljava/lang/Runnable;", "setInitialData", "newHash", "Lcom/intellij/vcs/log/Hash;", "newLength", "newExecutable", "setInitialData$intellij_vcs_git", "setDataFromRefresh", "setDataFromRefresh$intellij_vcs_git", "setDataFromWrite", "newModificationStamp", "setDataFromWrite$intellij_vcs_git", "getOutputStream", "Ljava/io/OutputStream;", "requestor", "", "newTimeStamp", "getInputStream", "Ljava/io/InputStream;", "contentsToByteArray", "", "equals", "other", "hashCode", "", "toString", "Lorg/jetbrains/annotations/NonNls;", "Companion", "CachedData", "intellij.vcs.git"})
public final class GitIndexVirtualFile
extends VirtualFile
implements VirtualFilePathWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile root;
    @NotNull
    private final FilePath filePath;
    @Nullable
    private volatile CachedData data;
    private volatile long modificationStamp;
    @NotNull
    private static final Logger LOG;
    private static final char SEPARATOR = ':';

    public GitIndexVirtualFile(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.project = project;
        this.root = root;
        this.filePath = filePath;
        this.putUserData(FileDocumentManagerBase.TRACK_NON_PHYSICAL, true);
        this.modificationStamp = LocalTimeCounter.currentTime();
    }

    @NotNull
    public final VirtualFile getRoot() {
        return this.root;
    }

    @NotNull
    public final FilePath getFilePath() {
        return this.filePath;
    }

    @Nullable
    public final CachedData getData$intellij_vcs_git() {
        return this.data;
    }

    public final void setData$intellij_vcs_git(@Nullable CachedData cachedData) {
        this.data = cachedData;
    }

    @NotNull
    public GitIndexFileSystem getFileSystem() {
        return GitIndexFileSystem.Companion.getInstance();
    }

    @Nullable
    public VirtualFile getParent() {
        return null;
    }

    @NotNull
    public VirtualFile[] getChildren() {
        Intrinsics.checkNotNullExpressionValue((Object)VirtualFile.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        return VirtualFile.EMPTY_ARRAY;
    }

    public boolean isWritable() {
        return true;
    }

    public boolean isDirectory() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValid() {
        if (this.project.isDisposed()) return false;
        if (this.data == null) return true;
        CachedData cachedData = this.data;
        if (cachedData == null) return false;
        Hash hash = cachedData.getHash();
        if (hash == null) return false;
        return true;
    }

    @NotNull
    public String getName() {
        String string = this.filePath.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NotNull
    public String getPresentableName() {
        Object[] objectArray = new Object[]{this.filePath.getName()};
        String string = GitBundle.message("stage.vfs.presentable.file.name", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getPath() {
        return GitIndexVirtualFile.Companion.encode(this.project, this.root, this.filePath);
    }

    @NotNull
    public String getPresentablePath() {
        String string = this.filePath.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    public boolean enforcePresentableName() {
        return true;
    }

    public final boolean isExecutable$intellij_vcs_git() {
        CachedData cachedData = this.data;
        return cachedData != null ? cachedData.isExecutable() : false;
    }

    public long getLength() {
        CachedData cachedData = this.data;
        return cachedData != null ? cachedData.getLength() : 0L;
    }

    public long getTimeStamp() {
        return 0L;
    }

    public long getModificationStamp() {
        return this.modificationStamp;
    }

    @NotNull
    public FileType getFileType() {
        VirtualFile virtualFile = this.filePath.getVirtualFile();
        if (virtualFile == null || (virtualFile = virtualFile.getFileType()) == null) {
            FileType fileType = super.getFileType();
            virtualFile = fileType;
            Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        }
        return virtualFile;
    }

    public void refresh(boolean asynchronous, boolean recursive, @Nullable Runnable postRunnable) {
        LOG.error("Refreshing index files is not supported (called for " + this + "). Use GitIndexFileSystemRefresher to refresh.");
    }

    public final void setInitialData$intellij_vcs_git(@Nullable Hash newHash, long newLength, boolean newExecutable) {
        this.data = new CachedData(newHash, newLength, newExecutable);
    }

    @RequiresWriteLock
    public final void setDataFromRefresh$intellij_vcs_git(@Nullable Hash newHash, long newLength, boolean newExecutable) {
        this.data = new CachedData(newHash, newLength, newExecutable);
    }

    @RequiresWriteLock
    public final void setDataFromWrite$intellij_vcs_git(@NotNull Hash newHash, long newLength, long newModificationStamp) {
        Intrinsics.checkNotNullParameter((Object)newHash, (String)"newHash");
        this.data = new CachedData(newHash, newLength, this.isExecutable$intellij_vcs_git());
        this.modificationStamp = newModificationStamp;
    }

    @NotNull
    public OutputStream getOutputStream(@Nullable Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        ByteArrayOutputStream outputStream2 = new ByteArrayOutputStream(this, requestor, newModificationStamp){
            final /* synthetic */ GitIndexVirtualFile this$0;
            final /* synthetic */ Object $requestor;
            final /* synthetic */ long $newModificationStamp;
            {
                this.this$0 = $receiver;
                this.$requestor = $requestor;
                this.$newModificationStamp = $newModificationStamp;
            }

            public void close() {
                GitIndexFileSystemRefresher gitIndexFileSystemRefresher = GitIndexFileSystemRefresher.Companion.getInstance(GitIndexVirtualFile.access$getProject$p(this.this$0));
                byte[] byArray = this.toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
                gitIndexFileSystemRefresher.write$intellij_vcs_git(this.this$0, this.$requestor, byArray, this.$newModificationStamp);
            }
        };
        OutputStream outputStream3 = VfsUtilCore.outputStreamAddingBOM((OutputStream)outputStream2, (VirtualFile)this);
        Intrinsics.checkNotNullExpressionValue((Object)outputStream3, (String)"outputStreamAddingBOM(...)");
        return outputStream3;
    }

    @NotNull
    public InputStream getInputStream() throws IOException {
        InputStream inputStream = VfsUtilCore.byteStreamSkippingBOM((byte[])this.contentsToByteArray(), (VirtualFile)this);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"byteStreamSkippingBOM(...)");
        return inputStream;
    }

    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        if (this.data == null) {
            GitIndexFileSystemRefresher.Companion.getInstance(this.project).initialRefresh(CollectionsKt.listOf((Object)((Object)this)));
        }
        try {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                Object[] objectArray = new Object[]{this.getName()};
                Object object = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> GitIndexVirtualFile.contentsToByteArray$lambda$0(this), GitBundle.message("stage.vfs.read.process", objectArray), false, this.project);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runProcessWithProgressSynchronously(...)");
                return (byte[])object;
            }
            return GitIndexFileSystemRefresher.Companion.getInstance(this.project).readContentFromGit$intellij_vcs_git(this.root, this.filePath);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type git4idea.index.vfs.GitIndexVirtualFile");
        GitIndexVirtualFile cfr_ignored_0 = (GitIndexVirtualFile)((Object)other);
        if (!Intrinsics.areEqual((Object)this.project, (Object)((GitIndexVirtualFile)((Object)other)).project)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.root, (Object)((GitIndexVirtualFile)((Object)other)).root)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.filePath, (Object)((GitIndexVirtualFile)((Object)other)).filePath);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.project, this.root, this.filePath};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        return "GitIndexVirtualFile: [" + this.root.getName() + "]/" + VcsFileUtil.relativePath((VirtualFile)this.root, (FilePath)this.filePath);
    }

    private static final byte[] contentsToByteArray$lambda$0(GitIndexVirtualFile this$0) {
        return GitIndexFileSystemRefresher.Companion.getInstance(this$0.project).readContentFromGit$intellij_vcs_git(this$0.root, this$0.filePath);
    }

    public static final /* synthetic */ Project access$getProject$p(GitIndexVirtualFile $this) {
        return $this.project;
    }

    static {
        Logger logger = Logger.getInstance(GitIndexVirtualFile.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lgit4idea/index/vfs/GitIndexVirtualFile$CachedData;", "", "hash", "Lcom/intellij/vcs/log/Hash;", "length", "", "isExecutable", "", "<init>", "(Lcom/intellij/vcs/log/Hash;JZ)V", "getHash", "()Lcom/intellij/vcs/log/Hash;", "getLength", "()J", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.vcs.git"})
    public static final class CachedData {
        @Nullable
        private final Hash hash;
        private final long length;
        private final boolean isExecutable;

        public CachedData(@Nullable Hash hash, long length, boolean isExecutable) {
            this.hash = hash;
            this.length = length;
            this.isExecutable = isExecutable;
        }

        @Nullable
        public final Hash getHash() {
            return this.hash;
        }

        public final long getLength() {
            return this.length;
        }

        public final boolean isExecutable() {
            return this.isExecutable;
        }

        @Nullable
        public final Hash component1() {
            return this.hash;
        }

        public final long component2() {
            return this.length;
        }

        public final boolean component3() {
            return this.isExecutable;
        }

        @NotNull
        public final CachedData copy(@Nullable Hash hash, long length, boolean isExecutable) {
            return new CachedData(hash, length, isExecutable);
        }

        public static /* synthetic */ CachedData copy$default(CachedData cachedData, Hash hash, long l, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                hash = cachedData.hash;
            }
            if ((n & 2) != 0) {
                l = cachedData.length;
            }
            if ((n & 4) != 0) {
                bl = cachedData.isExecutable;
            }
            return cachedData.copy(hash, l, bl);
        }

        @NotNull
        public String toString() {
            return "CachedData(hash=" + this.hash + ", length=" + this.length + ", isExecutable=" + this.isExecutable + ")";
        }

        public int hashCode() {
            int result2 = this.hash == null ? 0 : this.hash.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.length);
            result2 = result2 * 31 + Boolean.hashCode(this.isExecutable);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CachedData)) {
                return false;
            }
            CachedData cachedData = (CachedData)other;
            if (!Intrinsics.areEqual((Object)this.hash, (Object)cachedData.hash)) {
                return false;
            }
            if (this.length != cachedData.length) {
                return false;
            }
            return this.isExecutable == cachedData.isExecutable;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\"\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\nJ\u000e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lgit4idea/index/vfs/GitIndexVirtualFile$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "SEPARATOR", "", "encode", "", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "decode", "Lkotlin/Triple;", "path", "extractPresentableUrl", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitIndexVirtualFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitIndexVirtualFile.kt\ngit4idea/index/vfs/GitIndexVirtualFile$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,170:1\n1310#2,2:171\n*S KotlinDebug\n*F\n+ 1 GitIndexVirtualFile.kt\ngit4idea/index/vfs/GitIndexVirtualFile$Companion\n*L\n152#1:171,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String encode(Project project, VirtualFile root, FilePath filePath) {
            return StringUtil.escapeChar((String)project.getLocationHash(), (char)':') + ":" + StringUtil.escapeChar((String)root.getPath(), (char)':') + ":" + StringUtil.escapeChar((String)filePath.getPath(), (char)':');
        }

        @Nullable
        public final Triple<Project, VirtualFile, FilePath> decode(@NotNull String path) {
            Object object;
            List components;
            block4: {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                char[] cArray = new char[]{':'};
                components = StringsKt.split$default((CharSequence)path, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                if (components.size() != 3) {
                    return null;
                }
                String string = StringUtil.unescapeChar((String)((String)components.get(0)), (char)':');
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unescapeChar(...)");
                String locationHash = string;
                Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
                Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
                Object[] $this$firstOrNull$iv = projectArray;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Project it = (Project)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getLocationHash(), (Object)locationHash)) continue;
                    object = element$iv;
                    break block4;
                }
                object = null;
            }
            Project project = (Project)object;
            if (project == null) {
                return null;
            }
            Project project2 = project;
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(StringUtil.unescapeChar((String)((String)components.get(1)), (char)':'));
            if (virtualFile == null) {
                return null;
            }
            VirtualFile root = virtualFile;
            FilePath filePath = VcsUtil.getFilePath((String)StringUtil.unescapeChar((String)((String)components.get(2)), (char)':'), (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
            FilePath filePath2 = filePath;
            return new Triple((Object)project2, (Object)root, (Object)filePath2);
        }

        @NotNull
        public final String extractPresentableUrl(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return StringsKt.replace$default((String)StringsKt.substringAfterLast$default((String)path, (char)':', null, (int)2, null), (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

