---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Mailchimp API key'
---

## Description

The response body contains content that matches the pattern of a Mailchimp API key was identified. API keys can be used send emails, create and send marketing campaigns, access customer lists and email addresses. A malicious actor with access to this key can perform any API request to Mailchimp without restriction.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To revoke an API key:

- Sign in to your Mailchimp account at <https://login.mailchimp.com/>
- Select your profile icon then select Profile
- Select the Extras dropdown list then choose "API keys"
- Find the identified key and select "Revoke"
- When prompted, type "REVOKE" to confirm and select "Revoke" in the "Revoke API Key" dialog

For more information, please see [Mailchimp's documentation on API key security](https://mailchimp.com/help/about-api-keys/#api+key+security).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.72 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
