# frozen_string_literal: true

class CreateVulnerabilityFindingRiskScores < Gitlab::Database::Migration[2.3]
  milestone '18.5'

  disable_ddl_transaction!

  def up
    create_table :vulnerability_finding_risk_scores, if_not_exists: true, id: false do |t| # rubocop:disable Migration/EnsureFactoryForTable -- False Positive
      t.bigint :finding_id, primary_key: true, default: nil
      t.timestamps_with_timezone null: false
      t.bigint :project_id, null: false
      t.float :risk_score, null: false, default: 0.0

      t.index :finding_id, unique: true,
        name: 'index_vulnerability_risk_scores_on_vulnerability_finding'
      t.index :project_id, unique: false,
        name: 'index_vulnerability_risk_scores_on_vulnerability_project'
    end

    add_concurrent_foreign_key :vulnerability_finding_risk_scores, :vulnerability_occurrences,
      column: :finding_id, on_delete: :cascade
  end

  def down
    drop_table :vulnerability_finding_risk_scores
  end
end
