"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BrokenCircuitError = void 0;
class BrokenCircuitError extends Error {
    /**
     * Exception thrown from {@link CircuitBreakerPolicy.execute} when the
     * circuit breaker is open.
     */
    constructor(message = 'Execution prevented because the circuit breaker is open') {
        super(message);
        this.isBrokenCircuitError = true;
    }
}
exports.BrokenCircuitError = BrokenCircuitError;//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/bf9252a2fb45be6893dd8870c0bf37e2e1766d61/node_modules/cockatiel/dist/errors/BrokenCircuitError.js.map