﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/comprehend/Comprehend_EXPORTS.h>
#include <aws/comprehend/model/DominantLanguageDetectionJobProperties.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Comprehend {
namespace Model {
class ListDominantLanguageDetectionJobsResult {
 public:
  AWS_COMPREHEND_API ListDominantLanguageDetectionJobsResult() = default;
  AWS_COMPREHEND_API ListDominantLanguageDetectionJobsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_COMPREHEND_API ListDominantLanguageDetectionJobsResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A list containing the properties of each job that is returned.</p>
   */
  inline const Aws::Vector<DominantLanguageDetectionJobProperties>& GetDominantLanguageDetectionJobPropertiesList() const {
    return m_dominantLanguageDetectionJobPropertiesList;
  }
  template <typename DominantLanguageDetectionJobPropertiesListT = Aws::Vector<DominantLanguageDetectionJobProperties>>
  void SetDominantLanguageDetectionJobPropertiesList(DominantLanguageDetectionJobPropertiesListT&& value) {
    m_dominantLanguageDetectionJobPropertiesListHasBeenSet = true;
    m_dominantLanguageDetectionJobPropertiesList = std::forward<DominantLanguageDetectionJobPropertiesListT>(value);
  }
  template <typename DominantLanguageDetectionJobPropertiesListT = Aws::Vector<DominantLanguageDetectionJobProperties>>
  ListDominantLanguageDetectionJobsResult& WithDominantLanguageDetectionJobPropertiesList(
      DominantLanguageDetectionJobPropertiesListT&& value) {
    SetDominantLanguageDetectionJobPropertiesList(std::forward<DominantLanguageDetectionJobPropertiesListT>(value));
    return *this;
  }
  template <typename DominantLanguageDetectionJobPropertiesListT = DominantLanguageDetectionJobProperties>
  ListDominantLanguageDetectionJobsResult& AddDominantLanguageDetectionJobPropertiesList(
      DominantLanguageDetectionJobPropertiesListT&& value) {
    m_dominantLanguageDetectionJobPropertiesListHasBeenSet = true;
    m_dominantLanguageDetectionJobPropertiesList.emplace_back(std::forward<DominantLanguageDetectionJobPropertiesListT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Identifies the next page of results to return.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListDominantLanguageDetectionJobsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListDominantLanguageDetectionJobsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<DominantLanguageDetectionJobProperties> m_dominantLanguageDetectionJobPropertiesList;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_dominantLanguageDetectionJobPropertiesListHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Comprehend
}  // namespace Aws
