/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, qtgui, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_qtgui_number_sink = R"doc(A graphical sink to display numerical values of input streams.

Displays the data stream in as a number in a simple text box GUI along with an optional bar graph. The bar graph can be set to horizontal (NUM_GRAPH_HORIZ), vertical (NUM_GRAPH_VERT), or no graph (NUM_GRAPH_NONE).


The displayed value can be the average of the input stream, in which case all items received are averaged. If not averaging, the display simply samples a value in the data stream based on the update time of this block.


Note that due to a flaw in the implementation, this block cannot receive integer value inputs. It will take chars, shorts, and floats and properly convert them by setting itemsize of the constructor to one of these three values (sizeof_char, sizeof_short, and sizeof_float, respectively). If using integers, the block treats these as floats. Instead, put the integer input stream through an gr::blocks::int_to_float converter block.

Constructor Specific Documentation:

Build a number sink.

Args:
    itemsize : Size of input item stream
    average : Averaging coefficient (0 - 1)
    graph_type : Type of graph to use (number_sink::graph_t)
    nconnections : number of signals connected to sink
    parent : a QWidget parent object, if any)doc";


static const char* __doc_gr_qtgui_number_sink_number_sink_0 = R"doc()doc";


static const char* __doc_gr_qtgui_number_sink_number_sink_1 = R"doc()doc";


static const char* __doc_gr_qtgui_number_sink_make = R"doc(A graphical sink to display numerical values of input streams.

Displays the data stream in as a number in a simple text box GUI along with an optional bar graph. The bar graph can be set to horizontal (NUM_GRAPH_HORIZ), vertical (NUM_GRAPH_VERT), or no graph (NUM_GRAPH_NONE).


The displayed value can be the average of the input stream, in which case all items received are averaged. If not averaging, the display simply samples a value in the data stream based on the update time of this block.


Note that due to a flaw in the implementation, this block cannot receive integer value inputs. It will take chars, shorts, and floats and properly convert them by setting itemsize of the constructor to one of these three values (sizeof_char, sizeof_short, and sizeof_float, respectively). If using integers, the block treats these as floats. Instead, put the integer input stream through an gr::blocks::int_to_float converter block.

Constructor Specific Documentation:

Build a number sink.

Args:
    itemsize : Size of input item stream
    average : Averaging coefficient (0 - 1)
    graph_type : Type of graph to use (number_sink::graph_t)
    nconnections : number of signals connected to sink
    parent : a QWidget parent object, if any)doc";


static const char* __doc_gr_qtgui_number_sink_exec_ = R"doc()doc";


static const char* __doc_gr_qtgui_number_sink_qwidget = R"doc()doc";


static const char* __doc_gr_qtgui_number_sink_set_update_time = R"doc()doc";


static const char* __doc_gr_qtgui_number_sink_set_average = R"doc()doc";


static const char* __doc_gr_qtgui_number_sink_set_graph_type = R"doc()doc";


static const char* __doc_gr_qtgui_number_sink_set_color_0 = R"doc()doc";


static const char* __doc_gr_qtgui_number_sink_set_color_1 = R"doc()doc";


static const char* __doc_gr_qtgui_number_sink_set_label = R"doc()doc";


static const char* __doc_gr_qtgui_number_sink_set_min = R"doc()doc";


static const char* __doc_gr_qtgui_number_sink_set_max = R"doc()doc";


static const char* __doc_gr_qtgui_number_sink_set_title = R"doc()doc";


static const char* __doc_gr_qtgui_number_sink_set_unit = R"doc()doc";


static const char* __doc_gr_qtgui_number_sink_set_factor = R"doc()doc";


static const char* __doc_gr_qtgui_number_sink_average = R"doc()doc";


static const char* __doc_gr_qtgui_number_sink_graph_type = R"doc()doc";


static const char* __doc_gr_qtgui_number_sink_color_min = R"doc()doc";


static const char* __doc_gr_qtgui_number_sink_color_max = R"doc()doc";


static const char* __doc_gr_qtgui_number_sink_label = R"doc()doc";


static const char* __doc_gr_qtgui_number_sink_min = R"doc()doc";


static const char* __doc_gr_qtgui_number_sink_max = R"doc()doc";


static const char* __doc_gr_qtgui_number_sink_title = R"doc()doc";


static const char* __doc_gr_qtgui_number_sink_unit = R"doc()doc";


static const char* __doc_gr_qtgui_number_sink_factor = R"doc()doc";


static const char* __doc_gr_qtgui_number_sink_enable_menu = R"doc()doc";


static const char* __doc_gr_qtgui_number_sink_enable_autoscale = R"doc()doc";


static const char* __doc_gr_qtgui_number_sink_reset = R"doc()doc";
