/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_probe_mpsk_snr_est_c = R"doc(A probe for computing SNR of a PSK signal.

This is a probe block (a sink) that can be used to monitor and retrieve estimations of the signal SNR. This probe is designed for use with M-PSK signals especially. The type of estimator is specified as the  parameter in the constructor. The estimators tend to trade off performance for accuracy, although experimentation should be done to figure out the right approach for a given implementation. Further, the current set of estimators are designed and proven theoretically under AWGN conditions; some amount of error should be assumed and/or estimated for real channel conditions.


The block has three output message ports that will emit a message every msg_samples number of samples. These message ports are: 
Some calibration is required to convert dBx of the signal and noise power estimates to real measurements, such as dBm.


The estimator is normally placed before clock recovery.

Constructor Specific Documentation:

Make an MPSK SNR probe.


Parameters:

Args:
    type : the type of estimator to use see gr::digital::snr_est_type_t for details about the types.
    msg_nsamples : [not implemented yet] after this many samples, a message containing the SNR (key='snr') will be sent
    alpha : the update rate of internal running average calculations. Needs to be between 0 and 1, where higher value adjusts faster to new data.)doc";


static const char* __doc_gr_digital_probe_mpsk_snr_est_c_probe_mpsk_snr_est_c_0 =
    R"doc()doc";


static const char* __doc_gr_digital_probe_mpsk_snr_est_c_probe_mpsk_snr_est_c_1 =
    R"doc()doc";


static const char* __doc_gr_digital_probe_mpsk_snr_est_c_make = R"doc(A probe for computing SNR of a PSK signal.

This is a probe block (a sink) that can be used to monitor and retrieve estimations of the signal SNR. This probe is designed for use with M-PSK signals especially. The type of estimator is specified as the  parameter in the constructor. The estimators tend to trade off performance for accuracy, although experimentation should be done to figure out the right approach for a given implementation. Further, the current set of estimators are designed and proven theoretically under AWGN conditions; some amount of error should be assumed and/or estimated for real channel conditions.


The block has three output message ports that will emit a message every msg_samples number of samples. These message ports are: 
Some calibration is required to convert dBx of the signal and noise power estimates to real measurements, such as dBm.


The estimator is normally placed before clock recovery.

Constructor Specific Documentation:

Make an MPSK SNR probe.


Parameters:

Args:
    type : the type of estimator to use see gr::digital::snr_est_type_t for details about the types.
    msg_nsamples : [not implemented yet] after this many samples, a message containing the SNR (key='snr') will be sent
    alpha : the update rate of internal running average calculations. Needs to be between 0 and 1, where higher value adjusts faster to new data.)doc";


static const char* __doc_gr_digital_probe_mpsk_snr_est_c_snr = R"doc(Return the estimated signal-to-noise ratio in decibels.)doc";


static const char* __doc_gr_digital_probe_mpsk_snr_est_c_signal = R"doc(Return the estimated signal power in decibels.)doc";


static const char* __doc_gr_digital_probe_mpsk_snr_est_c_noise = R"doc(Return the estimated noise power in decibels.)doc";


static const char* __doc_gr_digital_probe_mpsk_snr_est_c_type = R"doc(Return the type of estimator in use.)doc";


static const char* __doc_gr_digital_probe_mpsk_snr_est_c_msg_nsample = R"doc(Return how many samples between SNR messages.)doc";


static const char* __doc_gr_digital_probe_mpsk_snr_est_c_alpha = R"doc(Get the running-average coefficient.)doc";


static const char* __doc_gr_digital_probe_mpsk_snr_est_c_set_type = R"doc(Set type of estimator to use.)doc";


static const char* __doc_gr_digital_probe_mpsk_snr_est_c_set_msg_nsample = R"doc(Set the number of samples between SNR messages.)doc";


static const char* __doc_gr_digital_probe_mpsk_snr_est_c_set_alpha = R"doc(Set the running-average coefficient.)doc";
