/* SourceList.c generated by valac 0.56.17, the Vala compiler
 * generated from SourceList.vala, do not modify */

/*
 *  Copyright (C) 2012-2014 Victor Martinez <victoreduardm@gmail.com>
 *
 *  This program or library is free software; you can redistribute it
 *  and/or modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 3 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General
 *  Public License along with this library; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301 USA.
 */
/**
     * = WORKING INTERNALS =
     *
     * In order to offer a transparent Item-based API, and avoid the need of providing methods
     * to deal with items directly on the SourceList widget, it was decided to follow a monitor-like
     * implementation, where the source list permanently monitors its root item and any other
     * child item added to it. The task of monitoring the properties of the items has been
     * divided among different objects, as shown below:
     *
     * Monitored by: Object::method that receives the signals indicating the property change.
     * Applied by: Object::method that actually updates the tree to reflect the property changes
     *             (directly or indirectly, as in the case of the tree data model).
     *
     * ---------------------------------------------------------------------------------------------
     *   PROPERTY        |  MONITORED BY                     |  APPLIED BY
     * ---------------------------------------------------------------------------------------------
     * + Item            |                                   |
     *   - parent        | Not monitored                     | N/A
     *   - name          | DataModel::on_item_prop_changed   | Tree::name_cell_data_func
     *   - editable      | DataModel::on_item_prop_changed   | Queried when needed (See Tree::start_editing_item)
     *   - visible       | DataModel::on_item_prop_changed   | DataModel::filter_visible_func
     *   - icon          | DataModel::on_item_prop_changed   | Tree::icon_cell_data_func
     *   - activatable   | Same as @icon                     | Same as @icon
     * + ExpandableItem  |                                   |
     *   - collapsible   | DataModel::on_item_prop_changed   | Tree::update_expansion
     *                   |                                   | Tree::expander_cell_data_func
     *   - expanded      | Same as @collapsible              | Same as @collapsible
     * ---------------------------------------------------------------------------------------------
     * * Only automatic properties are monitored. ExpandableItem's additions/removals are handled by
     *   DataModel::add_item() and DataModel::remove_item()
     *
     * Other features:
     * - Sorting: this happens on the tree-model level (DataModel).
     */

#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>
#include <cairo-gobject.h>
#include <granite.h>

#define CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_ITEM_PARENT_NEEDS_UPDATE "item-parent-needs-update"
#define CIANO_WIDGETS_SOURCE_LIST_CELL_RENDERER_ICON_ICON_SIZE GTK_ICON_SIZE_MENU
#define CIANO_WIDGETS_SOURCE_LIST_TREE_DEFAULT_STYLESHEET "\n" \
"            .source-list.badge {\n" \
"                border-radius: 10px;\n" \
"                border-width: 0;\n" \
"                padding: 1px 2px 1px 2px;\n" \
"                font-weight: bold;\n" \
"            }\n" \
"        "
#define CIANO_WIDGETS_SOURCE_LIST_TREE_STYLE_PROP_LEVEL_INDENTATION "level-indentation"
#define CIANO_WIDGETS_SOURCE_LIST_TREE_STYLE_PROP_LEFT_PADDING "left-padding"
#define CIANO_WIDGETS_SOURCE_LIST_TREE_STYLE_PROP_EXPANDER_SPACING "expander-spacing"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CIANO_WIDGETS_TYPE_SOURCE_LIST_SORTABLE (ciano_widgets_source_list_sortable_get_type ())
#define CIANO_WIDGETS_SOURCE_LIST_SORTABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CIANO_WIDGETS_TYPE_SOURCE_LIST_SORTABLE, CianoWidgetsSourceListSortable))
#define CIANO_WIDGETS_IS_SOURCE_LIST_SORTABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CIANO_WIDGETS_TYPE_SOURCE_LIST_SORTABLE))
#define CIANO_WIDGETS_SOURCE_LIST_SORTABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CIANO_WIDGETS_TYPE_SOURCE_LIST_SORTABLE, CianoWidgetsSourceListSortableIface))

typedef struct _CianoWidgetsSourceListSortable CianoWidgetsSourceListSortable;
typedef struct _CianoWidgetsSourceListSortableIface CianoWidgetsSourceListSortableIface;

#define CIANO_WIDGETS_SOURCE_LIST_TYPE_ITEM (ciano_widgets_source_list_item_get_type ())
#define CIANO_WIDGETS_SOURCE_LIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CIANO_WIDGETS_SOURCE_LIST_TYPE_ITEM, CianoWidgetsSourceListItem))
#define CIANO_WIDGETS_SOURCE_LIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CIANO_WIDGETS_SOURCE_LIST_TYPE_ITEM, CianoWidgetsSourceListItemClass))
#define CIANO_WIDGETS_SOURCE_LIST_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CIANO_WIDGETS_SOURCE_LIST_TYPE_ITEM))
#define CIANO_WIDGETS_SOURCE_LIST_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CIANO_WIDGETS_SOURCE_LIST_TYPE_ITEM))
#define CIANO_WIDGETS_SOURCE_LIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CIANO_WIDGETS_SOURCE_LIST_TYPE_ITEM, CianoWidgetsSourceListItemClass))

typedef struct _CianoWidgetsSourceListItem CianoWidgetsSourceListItem;
typedef struct _CianoWidgetsSourceListItemClass CianoWidgetsSourceListItemClass;

#define CIANO_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM (ciano_widgets_source_list_expandable_item_get_type ())
#define CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CIANO_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, CianoWidgetsSourceListExpandableItem))
#define CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CIANO_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, CianoWidgetsSourceListExpandableItemClass))
#define CIANO_WIDGETS_SOURCE_LIST_IS_EXPANDABLE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CIANO_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM))
#define CIANO_WIDGETS_SOURCE_LIST_IS_EXPANDABLE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CIANO_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM))
#define CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CIANO_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, CianoWidgetsSourceListExpandableItemClass))

typedef struct _CianoWidgetsSourceListExpandableItem CianoWidgetsSourceListExpandableItem;
typedef struct _CianoWidgetsSourceListExpandableItemClass CianoWidgetsSourceListExpandableItemClass;
enum  {
	CIANO_WIDGETS_SOURCE_LIST_SORTABLE_USER_MOVED_ITEM_SIGNAL,
	CIANO_WIDGETS_SOURCE_LIST_SORTABLE_NUM_SIGNALS
};
static guint ciano_widgets_source_list_sortable_signals[CIANO_WIDGETS_SOURCE_LIST_SORTABLE_NUM_SIGNALS] = {0};

#define CIANO_WIDGETS_TYPE_SOURCE_LIST_DRAG_SOURCE (ciano_widgets_source_list_drag_source_get_type ())
#define CIANO_WIDGETS_SOURCE_LIST_DRAG_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CIANO_WIDGETS_TYPE_SOURCE_LIST_DRAG_SOURCE, CianoWidgetsSourceListDragSource))
#define CIANO_WIDGETS_IS_SOURCE_LIST_DRAG_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CIANO_WIDGETS_TYPE_SOURCE_LIST_DRAG_SOURCE))
#define CIANO_WIDGETS_SOURCE_LIST_DRAG_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CIANO_WIDGETS_TYPE_SOURCE_LIST_DRAG_SOURCE, CianoWidgetsSourceListDragSourceIface))

typedef struct _CianoWidgetsSourceListDragSource CianoWidgetsSourceListDragSource;
typedef struct _CianoWidgetsSourceListDragSourceIface CianoWidgetsSourceListDragSourceIface;

#define CIANO_WIDGETS_TYPE_SOURCE_LIST_DRAG_DEST (ciano_widgets_source_list_drag_dest_get_type ())
#define CIANO_WIDGETS_SOURCE_LIST_DRAG_DEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CIANO_WIDGETS_TYPE_SOURCE_LIST_DRAG_DEST, CianoWidgetsSourceListDragDest))
#define CIANO_WIDGETS_IS_SOURCE_LIST_DRAG_DEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CIANO_WIDGETS_TYPE_SOURCE_LIST_DRAG_DEST))
#define CIANO_WIDGETS_SOURCE_LIST_DRAG_DEST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CIANO_WIDGETS_TYPE_SOURCE_LIST_DRAG_DEST, CianoWidgetsSourceListDragDestIface))

typedef struct _CianoWidgetsSourceListDragDest CianoWidgetsSourceListDragDest;
typedef struct _CianoWidgetsSourceListDragDestIface CianoWidgetsSourceListDragDestIface;

#define CIANO_WIDGETS_TYPE_SOURCE_LIST (ciano_widgets_source_list_get_type ())
#define CIANO_WIDGETS_SOURCE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CIANO_WIDGETS_TYPE_SOURCE_LIST, CianoWidgetsSourceList))
#define CIANO_WIDGETS_SOURCE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CIANO_WIDGETS_TYPE_SOURCE_LIST, CianoWidgetsSourceListClass))
#define CIANO_WIDGETS_IS_SOURCE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CIANO_WIDGETS_TYPE_SOURCE_LIST))
#define CIANO_WIDGETS_IS_SOURCE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CIANO_WIDGETS_TYPE_SOURCE_LIST))
#define CIANO_WIDGETS_SOURCE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CIANO_WIDGETS_TYPE_SOURCE_LIST, CianoWidgetsSourceListClass))

typedef struct _CianoWidgetsSourceList CianoWidgetsSourceList;
typedef struct _CianoWidgetsSourceListClass CianoWidgetsSourceListClass;
typedef struct _CianoWidgetsSourceListPrivate CianoWidgetsSourceListPrivate;

#define CIANO_WIDGETS_SOURCE_LIST_TYPE_TREE (ciano_widgets_source_list_tree_get_type ())
#define CIANO_WIDGETS_SOURCE_LIST_TREE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CIANO_WIDGETS_SOURCE_LIST_TYPE_TREE, CianoWidgetsSourceListTree))
#define CIANO_WIDGETS_SOURCE_LIST_TREE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CIANO_WIDGETS_SOURCE_LIST_TYPE_TREE, CianoWidgetsSourceListTreeClass))
#define CIANO_WIDGETS_SOURCE_LIST_IS_TREE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CIANO_WIDGETS_SOURCE_LIST_TYPE_TREE))
#define CIANO_WIDGETS_SOURCE_LIST_IS_TREE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CIANO_WIDGETS_SOURCE_LIST_TYPE_TREE))
#define CIANO_WIDGETS_SOURCE_LIST_TREE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CIANO_WIDGETS_SOURCE_LIST_TYPE_TREE, CianoWidgetsSourceListTreeClass))

typedef struct _CianoWidgetsSourceListTree CianoWidgetsSourceListTree;
typedef struct _CianoWidgetsSourceListTreeClass CianoWidgetsSourceListTreeClass;

#define CIANO_WIDGETS_SOURCE_LIST_TYPE_DATA_MODEL (ciano_widgets_source_list_data_model_get_type ())
#define CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CIANO_WIDGETS_SOURCE_LIST_TYPE_DATA_MODEL, CianoWidgetsSourceListDataModel))
#define CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CIANO_WIDGETS_SOURCE_LIST_TYPE_DATA_MODEL, CianoWidgetsSourceListDataModelClass))
#define CIANO_WIDGETS_SOURCE_LIST_IS_DATA_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CIANO_WIDGETS_SOURCE_LIST_TYPE_DATA_MODEL))
#define CIANO_WIDGETS_SOURCE_LIST_IS_DATA_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CIANO_WIDGETS_SOURCE_LIST_TYPE_DATA_MODEL))
#define CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CIANO_WIDGETS_SOURCE_LIST_TYPE_DATA_MODEL, CianoWidgetsSourceListDataModelClass))

typedef struct _CianoWidgetsSourceListDataModel CianoWidgetsSourceListDataModel;
typedef struct _CianoWidgetsSourceListDataModelClass CianoWidgetsSourceListDataModelClass;
enum  {
	CIANO_WIDGETS_SOURCE_LIST_0_PROPERTY,
	CIANO_WIDGETS_SOURCE_LIST_ROOT_PROPERTY,
	CIANO_WIDGETS_SOURCE_LIST_SELECTED_PROPERTY,
	CIANO_WIDGETS_SOURCE_LIST_ELLIPSIZE_MODE_PROPERTY,
	CIANO_WIDGETS_SOURCE_LIST_EDITING_PROPERTY,
	CIANO_WIDGETS_SOURCE_LIST_SORT_DIRECTION_PROPERTY,
	CIANO_WIDGETS_SOURCE_LIST_NUM_PROPERTIES
};
static GParamSpec* ciano_widgets_source_list_properties[CIANO_WIDGETS_SOURCE_LIST_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef gboolean (*CianoWidgetsSourceListVisibleFunc) (CianoWidgetsSourceListItem* item, gpointer user_data);
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))
#define __vala_GtkTreeIter_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreeIter_free (var), NULL)))
typedef struct _CianoWidgetsSourceListItemPrivate CianoWidgetsSourceListItemPrivate;
enum  {
	CIANO_WIDGETS_SOURCE_LIST_ITEM_0_PROPERTY,
	CIANO_WIDGETS_SOURCE_LIST_ITEM_PARENT_PROPERTY,
	CIANO_WIDGETS_SOURCE_LIST_ITEM_NAME_PROPERTY,
	CIANO_WIDGETS_SOURCE_LIST_ITEM_BADGE_PROPERTY,
	CIANO_WIDGETS_SOURCE_LIST_ITEM_EDITABLE_PROPERTY,
	CIANO_WIDGETS_SOURCE_LIST_ITEM_VISIBLE_PROPERTY,
	CIANO_WIDGETS_SOURCE_LIST_ITEM_SELECTABLE_PROPERTY,
	CIANO_WIDGETS_SOURCE_LIST_ITEM_ICON_PROPERTY,
	CIANO_WIDGETS_SOURCE_LIST_ITEM_ACTIVATABLE_PROPERTY,
	CIANO_WIDGETS_SOURCE_LIST_ITEM_NUM_PROPERTIES
};
static GParamSpec* ciano_widgets_source_list_item_properties[CIANO_WIDGETS_SOURCE_LIST_ITEM_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	CIANO_WIDGETS_SOURCE_LIST_ITEM_EDITED_SIGNAL,
	CIANO_WIDGETS_SOURCE_LIST_ITEM_ACTION_ACTIVATED_SIGNAL,
	CIANO_WIDGETS_SOURCE_LIST_ITEM_ACTIVATED_SIGNAL,
	CIANO_WIDGETS_SOURCE_LIST_ITEM_NUM_SIGNALS
};
static guint ciano_widgets_source_list_item_signals[CIANO_WIDGETS_SOURCE_LIST_ITEM_NUM_SIGNALS] = {0};
typedef struct _CianoWidgetsSourceListExpandableItemPrivate CianoWidgetsSourceListExpandableItemPrivate;
enum  {
	CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_0_PROPERTY,
	CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_COLLAPSIBLE_PROPERTY,
	CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_EXPANDED_PROPERTY,
	CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_N_CHILDREN_PROPERTY,
	CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_CHILDREN_PROPERTY,
	CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_NUM_PROPERTIES
};
static GParamSpec* ciano_widgets_source_list_expandable_item_properties[CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_NUM_PROPERTIES];
enum  {
	CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_CHILD_ADDED_SIGNAL,
	CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_CHILD_REMOVED_SIGNAL,
	CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_TOGGLED_SIGNAL,
	CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_NUM_SIGNALS
};
static guint ciano_widgets_source_list_expandable_item_signals[CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_NUM_SIGNALS] = {0};
typedef struct _CianoWidgetsSourceListDataModelPrivate CianoWidgetsSourceListDataModelPrivate;

#define CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_NODE_WRAPPER (ciano_widgets_source_list_data_model_node_wrapper_get_type ())
#define CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_NODE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_NODE_WRAPPER, CianoWidgetsSourceListDataModelNodeWrapper))
#define CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_NODE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_NODE_WRAPPER, CianoWidgetsSourceListDataModelNodeWrapperClass))
#define CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_IS_NODE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_NODE_WRAPPER))
#define CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_IS_NODE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_NODE_WRAPPER))
#define CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_NODE_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_NODE_WRAPPER, CianoWidgetsSourceListDataModelNodeWrapperClass))

typedef struct _CianoWidgetsSourceListDataModelNodeWrapper CianoWidgetsSourceListDataModelNodeWrapper;
typedef struct _CianoWidgetsSourceListDataModelNodeWrapperClass CianoWidgetsSourceListDataModelNodeWrapperClass;

#define CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_ITEM_MONITOR (ciano_widgets_source_list_data_model_item_monitor_get_type ())
#define CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_ITEM_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_ITEM_MONITOR, CianoWidgetsSourceListDataModelItemMonitor))
#define CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_ITEM_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_ITEM_MONITOR, CianoWidgetsSourceListDataModelItemMonitorClass))
#define CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_IS_ITEM_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_ITEM_MONITOR))
#define CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_IS_ITEM_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_ITEM_MONITOR))
#define CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_ITEM_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_ITEM_MONITOR, CianoWidgetsSourceListDataModelItemMonitorClass))

typedef struct _CianoWidgetsSourceListDataModelItemMonitor CianoWidgetsSourceListDataModelItemMonitor;
typedef struct _CianoWidgetsSourceListDataModelItemMonitorClass CianoWidgetsSourceListDataModelItemMonitorClass;
enum  {
	CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_0_PROPERTY,
	CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_ROOT_PROPERTY,
	CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_NUM_PROPERTIES
};
static GParamSpec* ciano_widgets_source_list_data_model_properties[CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_NUM_PROPERTIES];
typedef enum  {
	CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_COLUMN_ITEM,
	CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_COLUMN_N_COLUMNS
} CianoWidgetsSourceListDataModelColumn;

#define CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_COLUMN (ciano_widgets_source_list_data_model_column_get_type ())
#define _ciano_widgets_source_list_data_model_node_wrapper_unref0(var) ((var == NULL) ? NULL : (var = (ciano_widgets_source_list_data_model_node_wrapper_unref (var), NULL)))
#define _ciano_widgets_source_list_data_model_item_monitor_unref0(var) ((var == NULL) ? NULL : (var = (ciano_widgets_source_list_data_model_item_monitor_unref (var), NULL)))
typedef struct _Block8Data Block8Data;
typedef struct _CianoWidgetsSourceListDataModelNodeWrapperPrivate CianoWidgetsSourceListDataModelNodeWrapperPrivate;
#define __vala_GtkTreeRowReference_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreeRowReference_free (var), NULL)))
typedef struct _CianoWidgetsSourceListDataModelParamSpecNodeWrapper CianoWidgetsSourceListDataModelParamSpecNodeWrapper;
typedef struct _CianoWidgetsSourceListDataModelItemMonitorPrivate CianoWidgetsSourceListDataModelItemMonitorPrivate;
typedef struct _CianoWidgetsSourceListDataModelParamSpecItemMonitor CianoWidgetsSourceListDataModelParamSpecItemMonitor;
enum  {
	CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_ITEM_MONITOR_CHANGED_SIGNAL,
	CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_ITEM_MONITOR_NUM_SIGNALS
};
static guint ciano_widgets_source_list_data_model_item_monitor_signals[CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_ITEM_MONITOR_NUM_SIGNALS] = {0};
enum  {
	CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_ITEM_UPDATED_SIGNAL,
	CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_NUM_SIGNALS
};
static guint ciano_widgets_source_list_data_model_signals[CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_NUM_SIGNALS] = {0};

#define CIANO_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_ICON (ciano_widgets_source_list_cell_renderer_icon_get_type ())
#define CIANO_WIDGETS_SOURCE_LIST_CELL_RENDERER_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CIANO_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_ICON, CianoWidgetsSourceListCellRendererIcon))
#define CIANO_WIDGETS_SOURCE_LIST_CELL_RENDERER_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CIANO_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_ICON, CianoWidgetsSourceListCellRendererIconClass))
#define CIANO_WIDGETS_SOURCE_LIST_IS_CELL_RENDERER_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CIANO_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_ICON))
#define CIANO_WIDGETS_SOURCE_LIST_IS_CELL_RENDERER_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CIANO_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_ICON))
#define CIANO_WIDGETS_SOURCE_LIST_CELL_RENDERER_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CIANO_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_ICON, CianoWidgetsSourceListCellRendererIconClass))

typedef struct _CianoWidgetsSourceListCellRendererIcon CianoWidgetsSourceListCellRendererIcon;
typedef struct _CianoWidgetsSourceListCellRendererIconClass CianoWidgetsSourceListCellRendererIconClass;
typedef struct _CianoWidgetsSourceListCellRendererIconPrivate CianoWidgetsSourceListCellRendererIconPrivate;
enum  {
	CIANO_WIDGETS_SOURCE_LIST_CELL_RENDERER_ICON_0_PROPERTY,
	CIANO_WIDGETS_SOURCE_LIST_CELL_RENDERER_ICON_NUM_PROPERTIES
};
static GParamSpec* ciano_widgets_source_list_cell_renderer_icon_properties[CIANO_WIDGETS_SOURCE_LIST_CELL_RENDERER_ICON_NUM_PROPERTIES];
enum  {
	CIANO_WIDGETS_SOURCE_LIST_CELL_RENDERER_ICON_ACTIVATED_SIGNAL,
	CIANO_WIDGETS_SOURCE_LIST_CELL_RENDERER_ICON_NUM_SIGNALS
};
static guint ciano_widgets_source_list_cell_renderer_icon_signals[CIANO_WIDGETS_SOURCE_LIST_CELL_RENDERER_ICON_NUM_SIGNALS] = {0};

#define CIANO_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_SPACER (ciano_widgets_source_list_cell_renderer_spacer_get_type ())
#define CIANO_WIDGETS_SOURCE_LIST_CELL_RENDERER_SPACER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CIANO_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_SPACER, CianoWidgetsSourceListCellRendererSpacer))
#define CIANO_WIDGETS_SOURCE_LIST_CELL_RENDERER_SPACER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CIANO_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_SPACER, CianoWidgetsSourceListCellRendererSpacerClass))
#define CIANO_WIDGETS_SOURCE_LIST_IS_CELL_RENDERER_SPACER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CIANO_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_SPACER))
#define CIANO_WIDGETS_SOURCE_LIST_IS_CELL_RENDERER_SPACER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CIANO_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_SPACER))
#define CIANO_WIDGETS_SOURCE_LIST_CELL_RENDERER_SPACER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CIANO_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_SPACER, CianoWidgetsSourceListCellRendererSpacerClass))

typedef struct _CianoWidgetsSourceListCellRendererSpacer CianoWidgetsSourceListCellRendererSpacer;
typedef struct _CianoWidgetsSourceListCellRendererSpacerClass CianoWidgetsSourceListCellRendererSpacerClass;
typedef struct _CianoWidgetsSourceListCellRendererSpacerPrivate CianoWidgetsSourceListCellRendererSpacerPrivate;
enum  {
	CIANO_WIDGETS_SOURCE_LIST_CELL_RENDERER_SPACER_0_PROPERTY,
	CIANO_WIDGETS_SOURCE_LIST_CELL_RENDERER_SPACER_LEVEL_PROPERTY,
	CIANO_WIDGETS_SOURCE_LIST_CELL_RENDERER_SPACER_NUM_PROPERTIES
};
static GParamSpec* ciano_widgets_source_list_cell_renderer_spacer_properties[CIANO_WIDGETS_SOURCE_LIST_CELL_RENDERER_SPACER_NUM_PROPERTIES];
typedef struct _CianoWidgetsSourceListTreePrivate CianoWidgetsSourceListTreePrivate;
enum  {
	CIANO_WIDGETS_SOURCE_LIST_TREE_0_PROPERTY,
	CIANO_WIDGETS_SOURCE_LIST_TREE_DATA_MODEL_PROPERTY,
	CIANO_WIDGETS_SOURCE_LIST_TREE_SELECTED_ITEM_PROPERTY,
	CIANO_WIDGETS_SOURCE_LIST_TREE_EDITING_PROPERTY,
	CIANO_WIDGETS_SOURCE_LIST_TREE_ELLIPSIZE_MODE_PROPERTY,
	CIANO_WIDGETS_SOURCE_LIST_TREE_NUM_PROPERTIES
};
static GParamSpec* ciano_widgets_source_list_tree_properties[CIANO_WIDGETS_SOURCE_LIST_TREE_NUM_PROPERTIES];
typedef enum  {
	CIANO_WIDGETS_SOURCE_LIST_TREE_COLUMN_ITEM,
	CIANO_WIDGETS_SOURCE_LIST_TREE_COLUMN_N_COLS
} CianoWidgetsSourceListTreeColumn;

#define CIANO_WIDGETS_SOURCE_LIST_TREE_TYPE_COLUMN (ciano_widgets_source_list_tree_column_get_type ())
#define _gtk_target_list_unref0(var) ((var == NULL) ? NULL : (var = (gtk_target_list_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_param_spec_unref0(var) ((var == NULL) ? NULL : (var = (g_param_spec_unref (var), NULL)))
enum  {
	CIANO_WIDGETS_SOURCE_LIST_TREE_ITEM_SELECTED_SIGNAL,
	CIANO_WIDGETS_SOURCE_LIST_TREE_NUM_SIGNALS
};
static guint ciano_widgets_source_list_tree_signals[CIANO_WIDGETS_SOURCE_LIST_TREE_NUM_SIGNALS] = {0};
enum  {
	CIANO_WIDGETS_SOURCE_LIST_ITEM_SELECTED_SIGNAL,
	CIANO_WIDGETS_SOURCE_LIST_NUM_SIGNALS
};
static guint ciano_widgets_source_list_signals[CIANO_WIDGETS_SOURCE_LIST_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CianoWidgetsSourceListSortableIface {
	GTypeInterface parent_iface;
	gboolean (*allow_dnd_sorting) (CianoWidgetsSourceListSortable* self);
	gint (*compare) (CianoWidgetsSourceListSortable* self, CianoWidgetsSourceListItem* a, CianoWidgetsSourceListItem* b);
};

struct _CianoWidgetsSourceListDragSourceIface {
	GTypeInterface parent_iface;
	gboolean (*draggable) (CianoWidgetsSourceListDragSource* self);
	void (*prepare_selection_data) (CianoWidgetsSourceListDragSource* self, GtkSelectionData* selection_data);
};

struct _CianoWidgetsSourceListDragDestIface {
	GTypeInterface parent_iface;
	gboolean (*data_drop_possible) (CianoWidgetsSourceListDragDest* self, GdkDragContext* context, GtkSelectionData* data);
	GdkDragAction (*data_received) (CianoWidgetsSourceListDragDest* self, GdkDragContext* context, GtkSelectionData* data);
};

struct _CianoWidgetsSourceList {
	GtkScrolledWindow parent_instance;
	CianoWidgetsSourceListPrivate * priv;
};

struct _CianoWidgetsSourceListClass {
	GtkScrolledWindowClass parent_class;
	void (*item_selected) (CianoWidgetsSourceList* self, CianoWidgetsSourceListItem* item);
};

struct _CianoWidgetsSourceListPrivate {
	CianoWidgetsSourceListTree* tree;
	CianoWidgetsSourceListDataModel* data_model;
};

struct _CianoWidgetsSourceListItem {
	GObject parent_instance;
	CianoWidgetsSourceListItemPrivate * priv;
};

struct _CianoWidgetsSourceListItemClass {
	GObjectClass parent_class;
	GtkMenu* (*get_context_menu) (CianoWidgetsSourceListItem* self);
	void (*edited) (CianoWidgetsSourceListItem* self, const gchar* new_name);
	void (*action_activated) (CianoWidgetsSourceListItem* self);
	void (*activated) (CianoWidgetsSourceListItem* self);
};

struct _CianoWidgetsSourceListItemPrivate {
	CianoWidgetsSourceListExpandableItem* _parent;
	gchar* _name;
	gchar* _badge;
	gboolean _editable;
	gboolean _visible;
	gboolean _selectable;
	GIcon* _icon;
	GIcon* _activatable;
};

struct _CianoWidgetsSourceListExpandableItem {
	CianoWidgetsSourceListItem parent_instance;
	CianoWidgetsSourceListExpandableItemPrivate * priv;
};

struct _CianoWidgetsSourceListExpandableItemClass {
	CianoWidgetsSourceListItemClass parent_class;
	void (*toggled) (CianoWidgetsSourceListExpandableItem* self);
};

struct _CianoWidgetsSourceListExpandableItemPrivate {
	gboolean _collapsible;
	gboolean _expanded;
	GeeCollection* children_list;
};

struct _CianoWidgetsSourceListDataModel {
	GtkTreeModelFilter parent_instance;
	CianoWidgetsSourceListDataModelPrivate * priv;
};

struct _CianoWidgetsSourceListDataModelClass {
	GtkTreeModelFilterClass parent_class;
};

struct _CianoWidgetsSourceListDataModelPrivate {
	CianoWidgetsSourceListExpandableItem* _root;
	GeeHashMap* items;
	GeeHashMap* monitors;
	GtkTreeStore* child_tree;
	CianoWidgetsSourceListVisibleFunc filter_func;
	gpointer filter_func_target;
};

struct _Block8Data {
	int _ref_count_;
	CianoWidgetsSourceListDataModel* self;
	CianoWidgetsSourceListExpandableItem* parent;
};

struct _CianoWidgetsSourceListDataModelNodeWrapper {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CianoWidgetsSourceListDataModelNodeWrapperPrivate * priv;
};

struct _CianoWidgetsSourceListDataModelNodeWrapperClass {
	GTypeClass parent_class;
	void (*finalize) (CianoWidgetsSourceListDataModelNodeWrapper *self);
};

struct _CianoWidgetsSourceListDataModelNodeWrapperPrivate {
	GtkTreeRowReference* row_reference;
};

struct _CianoWidgetsSourceListDataModelParamSpecNodeWrapper {
	GParamSpec parent_instance;
};

struct _CianoWidgetsSourceListDataModelItemMonitor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CianoWidgetsSourceListDataModelItemMonitorPrivate * priv;
};

struct _CianoWidgetsSourceListDataModelItemMonitorClass {
	GTypeClass parent_class;
	void (*finalize) (CianoWidgetsSourceListDataModelItemMonitor *self);
};

struct _CianoWidgetsSourceListDataModelItemMonitorPrivate {
	CianoWidgetsSourceListItem* item;
};

struct _CianoWidgetsSourceListDataModelParamSpecItemMonitor {
	GParamSpec parent_instance;
};

struct _CianoWidgetsSourceListCellRendererIcon {
	GtkCellRendererPixbuf parent_instance;
	CianoWidgetsSourceListCellRendererIconPrivate * priv;
};

struct _CianoWidgetsSourceListCellRendererIconClass {
	GtkCellRendererPixbufClass parent_class;
};

struct _CianoWidgetsSourceListCellRendererSpacer {
	GtkCellRenderer parent_instance;
	CianoWidgetsSourceListCellRendererSpacerPrivate * priv;
};

struct _CianoWidgetsSourceListCellRendererSpacerClass {
	GtkCellRendererClass parent_class;
};

struct _CianoWidgetsSourceListCellRendererSpacerPrivate {
	gint _level;
};

struct _CianoWidgetsSourceListTree {
	GtkTreeView parent_instance;
	CianoWidgetsSourceListTreePrivate * priv;
};

struct _CianoWidgetsSourceListTreeClass {
	GtkTreeViewClass parent_class;
};

struct _CianoWidgetsSourceListTreePrivate {
	CianoWidgetsSourceListDataModel* _data_model;
	CianoWidgetsSourceListItem* selected;
	CianoWidgetsSourceListItem* edited;
	GtkEntry* editable_entry;
	GtkCellRendererText* text_cell;
	CianoWidgetsSourceListCellRendererIcon* icon_cell;
	CianoWidgetsSourceListCellRendererIcon* activatable_cell;
	GraniteWidgetsCellRendererBadge* badge_cell;
	GraniteWidgetsCellRendererExpander* primary_expander_cell;
	GraniteWidgetsCellRendererExpander* secondary_expander_cell;
	GeeHashMap* spacer_cells;
	gboolean unselectable_item_clicked;
};

static gint CianoWidgetsSourceList_private_offset;
static gpointer ciano_widgets_source_list_parent_class = NULL;
static gint CianoWidgetsSourceListItem_private_offset;
static gpointer ciano_widgets_source_list_item_parent_class = NULL;
static gint CianoWidgetsSourceListExpandableItem_private_offset;
static gpointer ciano_widgets_source_list_expandable_item_parent_class = NULL;
static gint CianoWidgetsSourceListDataModel_private_offset;
static gpointer ciano_widgets_source_list_data_model_parent_class = NULL;
static gint CianoWidgetsSourceListDataModelNodeWrapper_private_offset;
static gpointer ciano_widgets_source_list_data_model_node_wrapper_parent_class = NULL;
static gint CianoWidgetsSourceListDataModelItemMonitor_private_offset;
static gpointer ciano_widgets_source_list_data_model_item_monitor_parent_class = NULL;
static GtkTreeDragSourceIface * ciano_widgets_source_list_data_model_gtk_tree_drag_source_parent_iface = NULL;
static GtkTreeDragDestIface * ciano_widgets_source_list_data_model_gtk_tree_drag_dest_parent_iface = NULL;
static gpointer ciano_widgets_source_list_cell_renderer_icon_parent_class = NULL;
static gint CianoWidgetsSourceListCellRendererSpacer_private_offset;
static gpointer ciano_widgets_source_list_cell_renderer_spacer_parent_class = NULL;
static gint CianoWidgetsSourceListTree_private_offset;
static gpointer ciano_widgets_source_list_tree_parent_class = NULL;

VALA_EXTERN GType ciano_widgets_source_list_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CianoWidgetsSourceListItem, g_object_unref)
VALA_EXTERN GType ciano_widgets_source_list_expandable_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CianoWidgetsSourceListExpandableItem, g_object_unref)
VALA_EXTERN GType ciano_widgets_source_list_sortable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CianoWidgetsSourceListSortable, g_object_unref)
VALA_EXTERN gboolean ciano_widgets_source_list_sortable_allow_dnd_sorting (CianoWidgetsSourceListSortable* self);
VALA_EXTERN gint ciano_widgets_source_list_sortable_compare (CianoWidgetsSourceListSortable* self,
                                                 CianoWidgetsSourceListItem* a,
                                                 CianoWidgetsSourceListItem* b);
static GType ciano_widgets_source_list_sortable_get_type_once (void);
VALA_EXTERN GType ciano_widgets_source_list_drag_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CianoWidgetsSourceListDragSource, g_object_unref)
VALA_EXTERN gboolean ciano_widgets_source_list_drag_source_draggable (CianoWidgetsSourceListDragSource* self);
VALA_EXTERN void ciano_widgets_source_list_drag_source_prepare_selection_data (CianoWidgetsSourceListDragSource* self,
                                                                   GtkSelectionData* selection_data);
static GType ciano_widgets_source_list_drag_source_get_type_once (void);
VALA_EXTERN GType ciano_widgets_source_list_drag_dest_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CianoWidgetsSourceListDragDest, g_object_unref)
VALA_EXTERN gboolean ciano_widgets_source_list_drag_dest_data_drop_possible (CianoWidgetsSourceListDragDest* self,
                                                                 GdkDragContext* context,
                                                                 GtkSelectionData* data);
VALA_EXTERN GdkDragAction ciano_widgets_source_list_drag_dest_data_received (CianoWidgetsSourceListDragDest* self,
                                                                 GdkDragContext* context,
                                                                 GtkSelectionData* data);
static GType ciano_widgets_source_list_drag_dest_get_type_once (void);
VALA_EXTERN GType ciano_widgets_source_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CianoWidgetsSourceList, g_object_unref)
static GType ciano_widgets_source_list_tree_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CianoWidgetsSourceListTree, g_object_unref)
static GType ciano_widgets_source_list_data_model_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CianoWidgetsSourceListDataModel, g_object_unref)
static CianoWidgetsSourceListDataModel* ciano_widgets_source_list_data_model_new (void);
static CianoWidgetsSourceListDataModel* ciano_widgets_source_list_data_model_construct (GType object_type);
VALA_EXTERN CianoWidgetsSourceList* ciano_widgets_source_list_new (CianoWidgetsSourceListExpandableItem* root);
VALA_EXTERN CianoWidgetsSourceList* ciano_widgets_source_list_construct (GType object_type,
                                                             CianoWidgetsSourceListExpandableItem* root);
VALA_EXTERN void ciano_widgets_source_list_set_root (CianoWidgetsSourceList* self,
                                         CianoWidgetsSourceListExpandableItem* value);
static CianoWidgetsSourceListTree* ciano_widgets_source_list_tree_new (CianoWidgetsSourceListDataModel* data_model);
static CianoWidgetsSourceListTree* ciano_widgets_source_list_tree_construct (GType object_type,
                                                                      CianoWidgetsSourceListDataModel* data_model);
static void __lambda7_ (CianoWidgetsSourceList* self,
                 CianoWidgetsSourceListItem* item);
static void ___lambda7__ciano_widgets_source_list_tree_item_selected (CianoWidgetsSourceListTree* _sender,
                                                               CianoWidgetsSourceListItem* item,
                                                               gpointer self);
VALA_EXTERN gboolean ciano_widgets_source_list_has_item (CianoWidgetsSourceList* self,
                                             CianoWidgetsSourceListItem* item);
static gboolean ciano_widgets_source_list_data_model_has_item (CianoWidgetsSourceListDataModel* self,
                                                        CianoWidgetsSourceListItem* item);
VALA_EXTERN void ciano_widgets_source_list_set_filter_func (CianoWidgetsSourceList* self,
                                                CianoWidgetsSourceListVisibleFunc visible_func,
                                                gpointer visible_func_target,
                                                gboolean refilter);
static void ciano_widgets_source_list_data_model_set_filter_func (CianoWidgetsSourceListDataModel* self,
                                                           CianoWidgetsSourceListVisibleFunc visible_func,
                                                           gpointer visible_func_target);
VALA_EXTERN void ciano_widgets_source_list_refilter (CianoWidgetsSourceList* self);
VALA_EXTERN gboolean ciano_widgets_source_list_is_item_expanded (CianoWidgetsSourceList* self,
                                                     CianoWidgetsSourceListItem* item);
static GtkTreePath* ciano_widgets_source_list_data_model_get_item_path (CianoWidgetsSourceListDataModel* self,
                                                                 CianoWidgetsSourceListItem* item);
static void _vala_GtkTreePath_free (GtkTreePath* self);
VALA_EXTERN gboolean ciano_widgets_source_list_start_editing_item (CianoWidgetsSourceList* self,
                                                       CianoWidgetsSourceListItem* item);
static gboolean ciano_widgets_source_list_tree_start_editing_item (CianoWidgetsSourceListTree* self,
                                                            CianoWidgetsSourceListItem* item);
VALA_EXTERN void ciano_widgets_source_list_stop_editing (CianoWidgetsSourceList* self);
VALA_EXTERN gboolean ciano_widgets_source_list_get_editing (CianoWidgetsSourceList* self);
static void ciano_widgets_source_list_tree_stop_editing (CianoWidgetsSourceListTree* self);
VALA_EXTERN void ciano_widgets_source_list_enable_drag_source (CianoWidgetsSourceList* self,
                                                   GtkTargetEntry* src_entries,
                                                   gint src_entries_length1);
static void ciano_widgets_source_list_tree_configure_drag_source (CianoWidgetsSourceListTree* self,
                                                           GtkTargetEntry* src_entries,
                                                           gint src_entries_length1);
VALA_EXTERN void ciano_widgets_source_list_disable_drag_source (CianoWidgetsSourceList* self);
VALA_EXTERN void ciano_widgets_source_list_enable_drag_dest (CianoWidgetsSourceList* self,
                                                 GtkTargetEntry* dest_entries,
                                                 gint dest_entries_length1,
                                                 GdkDragAction actions);
static void ciano_widgets_source_list_tree_configure_drag_dest (CianoWidgetsSourceListTree* self,
                                                         GtkTargetEntry* dest_entries,
                                                         gint dest_entries_length1,
                                                         GdkDragAction actions);
VALA_EXTERN void ciano_widgets_source_list_disable_drag_dest (CianoWidgetsSourceList* self);
VALA_EXTERN gboolean ciano_widgets_source_list_scroll_to_item (CianoWidgetsSourceList* self,
                                                   CianoWidgetsSourceListItem* item,
                                                   gboolean expand_parents,
                                                   gboolean use_align,
                                                   gfloat row_align);
VALA_EXTERN CianoWidgetsSourceListExpandableItem* ciano_widgets_source_list_item_get_parent (CianoWidgetsSourceListItem* self);
VALA_EXTERN void ciano_widgets_source_list_expandable_item_expand_with_parents (CianoWidgetsSourceListExpandableItem* self);
static gboolean ciano_widgets_source_list_tree_scroll_to_item (CianoWidgetsSourceListTree* self,
                                                        CianoWidgetsSourceListItem* item,
                                                        gboolean use_align,
                                                        gfloat row_align);
VALA_EXTERN CianoWidgetsSourceListItem* ciano_widgets_source_list_get_previous_item (CianoWidgetsSourceList* self,
                                                                         CianoWidgetsSourceListItem* reference);
static GtkTreeIter* ciano_widgets_source_list_data_model_get_item_iter (CianoWidgetsSourceListDataModel* self,
                                                                 CianoWidgetsSourceListItem* item);
static CianoWidgetsSourceListItem* ciano_widgets_source_list_data_model_get_item (CianoWidgetsSourceListDataModel* self,
                                                                           GtkTreeIter* iter);
static void _vala_GtkTreeIter_free (GtkTreeIter* self);
VALA_EXTERN CianoWidgetsSourceListItem* ciano_widgets_source_list_get_next_item (CianoWidgetsSourceList* self,
                                                                     CianoWidgetsSourceListItem* reference);
VALA_EXTERN CianoWidgetsSourceListItem* ciano_widgets_source_list_get_first_child (CianoWidgetsSourceList* self,
                                                                       CianoWidgetsSourceListExpandableItem* parent);
static CianoWidgetsSourceListItem* ciano_widgets_source_list_get_nth_child (CianoWidgetsSourceList* self,
                                                                     CianoWidgetsSourceListExpandableItem* parent,
                                                                     gint index);
VALA_EXTERN CianoWidgetsSourceListItem* ciano_widgets_source_list_get_last_child (CianoWidgetsSourceList* self,
                                                                      CianoWidgetsSourceListExpandableItem* parent);
VALA_EXTERN guint ciano_widgets_source_list_get_n_visible_children (CianoWidgetsSourceList* self,
                                                        CianoWidgetsSourceListExpandableItem* parent);
VALA_EXTERN CianoWidgetsSourceListExpandableItem* ciano_widgets_source_list_get_root (CianoWidgetsSourceList* self);
static CianoWidgetsSourceListExpandableItem* ciano_widgets_source_list_data_model_get_root (CianoWidgetsSourceListDataModel* self);
static void ciano_widgets_source_list_data_model_set_root (CianoWidgetsSourceListDataModel* self,
                                                    CianoWidgetsSourceListExpandableItem* value);
VALA_EXTERN CianoWidgetsSourceListItem* ciano_widgets_source_list_get_selected (CianoWidgetsSourceList* self);
static CianoWidgetsSourceListItem* ciano_widgets_source_list_tree_get_selected_item (CianoWidgetsSourceListTree* self);
VALA_EXTERN void ciano_widgets_source_list_set_selected (CianoWidgetsSourceList* self,
                                             CianoWidgetsSourceListItem* value);
static void ciano_widgets_source_list_tree_set_selected_item (CianoWidgetsSourceListTree* self,
                                                       CianoWidgetsSourceListItem* value);
VALA_EXTERN PangoEllipsizeMode ciano_widgets_source_list_get_ellipsize_mode (CianoWidgetsSourceList* self);
static PangoEllipsizeMode ciano_widgets_source_list_tree_get_ellipsize_mode (CianoWidgetsSourceListTree* self);
VALA_EXTERN void ciano_widgets_source_list_set_ellipsize_mode (CianoWidgetsSourceList* self,
                                                   PangoEllipsizeMode value);
static void ciano_widgets_source_list_tree_set_ellipsize_mode (CianoWidgetsSourceListTree* self,
                                                        PangoEllipsizeMode value);
static gboolean ciano_widgets_source_list_tree_get_editing (CianoWidgetsSourceListTree* self);
VALA_EXTERN GtkSortType ciano_widgets_source_list_get_sort_direction (CianoWidgetsSourceList* self) G_GNUC_DEPRECATED ;
VALA_EXTERN void ciano_widgets_source_list_set_sort_direction (CianoWidgetsSourceList* self,
                                                   GtkSortType value) G_GNUC_DEPRECATED ;
static void ciano_widgets_source_list_real_item_selected (CianoWidgetsSourceList* self,
                                                   CianoWidgetsSourceListItem* item);
VALA_EXTERN GtkMenu* ciano_widgets_source_list_item_get_context_menu (CianoWidgetsSourceListItem* self);
VALA_EXTERN CianoWidgetsSourceListItem* ciano_widgets_source_list_item_new (const gchar* name);
VALA_EXTERN CianoWidgetsSourceListItem* ciano_widgets_source_list_item_construct (GType object_type,
                                                                      const gchar* name);
VALA_EXTERN void ciano_widgets_source_list_item_set_name (CianoWidgetsSourceListItem* self,
                                              const gchar* value);
static GtkMenu* ciano_widgets_source_list_item_real_get_context_menu (CianoWidgetsSourceListItem* self);
VALA_EXTERN void ciano_widgets_source_list_item_set_parent (CianoWidgetsSourceListItem* self,
                                                CianoWidgetsSourceListExpandableItem* value);
VALA_EXTERN const gchar* ciano_widgets_source_list_item_get_name (CianoWidgetsSourceListItem* self);
VALA_EXTERN const gchar* ciano_widgets_source_list_item_get_badge (CianoWidgetsSourceListItem* self);
VALA_EXTERN void ciano_widgets_source_list_item_set_badge (CianoWidgetsSourceListItem* self,
                                               const gchar* value);
VALA_EXTERN gboolean ciano_widgets_source_list_item_get_editable (CianoWidgetsSourceListItem* self);
VALA_EXTERN void ciano_widgets_source_list_item_set_editable (CianoWidgetsSourceListItem* self,
                                                  gboolean value);
VALA_EXTERN gboolean ciano_widgets_source_list_item_get_visible (CianoWidgetsSourceListItem* self);
VALA_EXTERN void ciano_widgets_source_list_item_set_visible (CianoWidgetsSourceListItem* self,
                                                 gboolean value);
VALA_EXTERN gboolean ciano_widgets_source_list_item_get_selectable (CianoWidgetsSourceListItem* self);
VALA_EXTERN void ciano_widgets_source_list_item_set_selectable (CianoWidgetsSourceListItem* self,
                                                    gboolean value);
VALA_EXTERN GIcon* ciano_widgets_source_list_item_get_icon (CianoWidgetsSourceListItem* self);
VALA_EXTERN void ciano_widgets_source_list_item_set_icon (CianoWidgetsSourceListItem* self,
                                              GIcon* value);
VALA_EXTERN GIcon* ciano_widgets_source_list_item_get_activatable (CianoWidgetsSourceListItem* self);
VALA_EXTERN void ciano_widgets_source_list_item_set_activatable (CianoWidgetsSourceListItem* self,
                                                     GIcon* value);
static void ciano_widgets_source_list_item_real_edited (CianoWidgetsSourceListItem* self,
                                                 const gchar* new_name);
static void ciano_widgets_source_list_item_real_action_activated (CianoWidgetsSourceListItem* self);
static void ciano_widgets_source_list_item_real_activated (CianoWidgetsSourceListItem* self);
static void ciano_widgets_source_list_item_finalize (GObject * obj);
static GType ciano_widgets_source_list_item_get_type_once (void);
static void _vala_ciano_widgets_source_list_item_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec);
static void _vala_ciano_widgets_source_list_item_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec);
VALA_EXTERN CianoWidgetsSourceListExpandableItem* ciano_widgets_source_list_expandable_item_new (const gchar* name);
VALA_EXTERN CianoWidgetsSourceListExpandableItem* ciano_widgets_source_list_expandable_item_construct (GType object_type,
                                                                                           const gchar* name);
VALA_EXTERN gboolean ciano_widgets_source_list_expandable_item_contains (CianoWidgetsSourceListExpandableItem* self,
                                                             CianoWidgetsSourceListItem* item);
VALA_EXTERN void ciano_widgets_source_list_expandable_item_add (CianoWidgetsSourceListExpandableItem* self,
                                                    CianoWidgetsSourceListItem* item);
VALA_EXTERN void ciano_widgets_source_list_expandable_item_remove (CianoWidgetsSourceListExpandableItem* self,
                                                       CianoWidgetsSourceListItem* item);
VALA_EXTERN void ciano_widgets_source_list_expandable_item_clear (CianoWidgetsSourceListExpandableItem* self);
VALA_EXTERN GeeCollection* ciano_widgets_source_list_expandable_item_get_children (CianoWidgetsSourceListExpandableItem* self);
VALA_EXTERN void ciano_widgets_source_list_expandable_item_expand_all (CianoWidgetsSourceListExpandableItem* self,
                                                           gboolean inclusive,
                                                           gboolean recursive);
static void ciano_widgets_source_list_expandable_item_set_expansion (CianoWidgetsSourceListExpandableItem* item,
                                                              gboolean inclusive,
                                                              gboolean recursive,
                                                              gboolean expanded);
VALA_EXTERN void ciano_widgets_source_list_expandable_item_collapse_all (CianoWidgetsSourceListExpandableItem* self,
                                                             gboolean inclusive,
                                                             gboolean recursive);
VALA_EXTERN void ciano_widgets_source_list_expandable_item_set_expanded (CianoWidgetsSourceListExpandableItem* self,
                                                             gboolean value);
VALA_EXTERN void ciano_widgets_source_list_expandable_item_collapse_with_parents (CianoWidgetsSourceListExpandableItem* self);
VALA_EXTERN gboolean ciano_widgets_source_list_expandable_item_get_collapsible (CianoWidgetsSourceListExpandableItem* self);
VALA_EXTERN void ciano_widgets_source_list_expandable_item_set_collapsible (CianoWidgetsSourceListExpandableItem* self,
                                                                gboolean value);
VALA_EXTERN gboolean ciano_widgets_source_list_expandable_item_get_expanded (CianoWidgetsSourceListExpandableItem* self);
VALA_EXTERN guint ciano_widgets_source_list_expandable_item_get_n_children (CianoWidgetsSourceListExpandableItem* self);
static void ciano_widgets_source_list_expandable_item_real_toggled (CianoWidgetsSourceListExpandableItem* self);
static void ciano_widgets_source_list_expandable_item_finalize (GObject * obj);
static GType ciano_widgets_source_list_expandable_item_get_type_once (void);
static void _vala_ciano_widgets_source_list_expandable_item_get_property (GObject * object,
                                                                   guint property_id,
                                                                   GValue * value,
                                                                   GParamSpec * pspec);
static void _vala_ciano_widgets_source_list_expandable_item_set_property (GObject * object,
                                                                   guint property_id,
                                                                   const GValue * value,
                                                                   GParamSpec * pspec);
static gpointer ciano_widgets_source_list_data_model_node_wrapper_ref (gpointer instance);
static void ciano_widgets_source_list_data_model_node_wrapper_unref (gpointer instance);
static GParamSpec* ciano_widgets_source_list_data_model_param_spec_node_wrapper (const gchar* name,
                                                                          const gchar* nick,
                                                                          const gchar* blurb,
                                                                          GType object_type,
                                                                          GParamFlags flags) G_GNUC_UNUSED ;
static void ciano_widgets_source_list_data_model_value_set_node_wrapper (GValue* value,
                                                                  gpointer v_object) G_GNUC_UNUSED ;
static void ciano_widgets_source_list_data_model_value_take_node_wrapper (GValue* value,
                                                                   gpointer v_object) G_GNUC_UNUSED ;
static gpointer ciano_widgets_source_list_data_model_value_get_node_wrapper (const GValue* value) G_GNUC_UNUSED ;
static GType ciano_widgets_source_list_data_model_node_wrapper_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CianoWidgetsSourceListDataModelNodeWrapper, ciano_widgets_source_list_data_model_node_wrapper_unref)
static gpointer ciano_widgets_source_list_data_model_item_monitor_ref (gpointer instance);
static void ciano_widgets_source_list_data_model_item_monitor_unref (gpointer instance);
static GParamSpec* ciano_widgets_source_list_data_model_param_spec_item_monitor (const gchar* name,
                                                                          const gchar* nick,
                                                                          const gchar* blurb,
                                                                          GType object_type,
                                                                          GParamFlags flags) G_GNUC_UNUSED ;
static void ciano_widgets_source_list_data_model_value_set_item_monitor (GValue* value,
                                                                  gpointer v_object) G_GNUC_UNUSED ;
static void ciano_widgets_source_list_data_model_value_take_item_monitor (GValue* value,
                                                                   gpointer v_object) G_GNUC_UNUSED ;
static gpointer ciano_widgets_source_list_data_model_value_get_item_monitor (const GValue* value) G_GNUC_UNUSED ;
static GType ciano_widgets_source_list_data_model_item_monitor_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CianoWidgetsSourceListDataModelItemMonitor, ciano_widgets_source_list_data_model_item_monitor_unref)
static GType ciano_widgets_source_list_data_model_column_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType ciano_widgets_source_list_data_model_column_type (CianoWidgetsSourceListDataModelColumn self);
static gint ciano_widgets_source_list_data_model_child_model_sort_func (CianoWidgetsSourceListDataModel* self,
                                                                 GtkTreeModel* model,
                                                                 GtkTreeIter* a,
                                                                 GtkTreeIter* b);
static gint _ciano_widgets_source_list_data_model_child_model_sort_func_gtk_tree_iter_compare_func (GtkTreeModel* model,
                                                                                             GtkTreeIter* a,
                                                                                             GtkTreeIter* b,
                                                                                             gpointer self);
static void ciano_widgets_source_list_data_model_resort (CianoWidgetsSourceListDataModel* self);
static gboolean ciano_widgets_source_list_data_model_filter_visible_func (CianoWidgetsSourceListDataModel* self,
                                                                   GtkTreeModel* child_model,
                                                                   GtkTreeIter* iter);
static gboolean _ciano_widgets_source_list_data_model_filter_visible_func_gtk_tree_model_filter_visible_func (GtkTreeModel* model,
                                                                                                       GtkTreeIter* iter,
                                                                                                       gpointer self);
static void ciano_widgets_source_list_data_model_update_item (CianoWidgetsSourceListDataModel* self,
                                                       CianoWidgetsSourceListItem* item);
static GtkTreePath* ciano_widgets_source_list_data_model_node_wrapper_get_path (CianoWidgetsSourceListDataModelNodeWrapper* self);
static GtkTreeIter* ciano_widgets_source_list_data_model_node_wrapper_get_iter (CianoWidgetsSourceListDataModelNodeWrapper* self);
static void ciano_widgets_source_list_data_model_add_item (CianoWidgetsSourceListDataModel* self,
                                                    CianoWidgetsSourceListItem* item);
static GtkTreeIter* ciano_widgets_source_list_data_model_get_item_child_iter (CianoWidgetsSourceListDataModel* self,
                                                                       CianoWidgetsSourceListItem* item);
static GtkTreeIter* _vala_GtkTreeIter_copy (GtkTreeIter* self);
static CianoWidgetsSourceListDataModelNodeWrapper* ciano_widgets_source_list_data_model_node_wrapper_new (GtkTreeModel* model,
                                                                                                   GtkTreeIter* iter);
static CianoWidgetsSourceListDataModelNodeWrapper* ciano_widgets_source_list_data_model_node_wrapper_construct (GType object_type,
                                                                                                         GtkTreeModel* model,
                                                                                                         GtkTreeIter* iter);
static void ciano_widgets_source_list_data_model_add_property_monitor (CianoWidgetsSourceListDataModel* self,
                                                                CianoWidgetsSourceListItem* item);
static void ciano_widgets_source_list_data_model_push_parent_update (CianoWidgetsSourceListDataModel* self,
                                                              CianoWidgetsSourceListExpandableItem* parent);
static void ciano_widgets_source_list_data_model_add_children_monitor (CianoWidgetsSourceListDataModel* self,
                                                                CianoWidgetsSourceListExpandableItem* item);
static void ciano_widgets_source_list_data_model_remove_item (CianoWidgetsSourceListDataModel* self,
                                                       CianoWidgetsSourceListItem* item);
static void ciano_widgets_source_list_data_model_remove_property_monitor (CianoWidgetsSourceListDataModel* self,
                                                                   CianoWidgetsSourceListItem* item);
static void ciano_widgets_source_list_data_model_remove_children_monitor (CianoWidgetsSourceListDataModel* self,
                                                                   CianoWidgetsSourceListExpandableItem* item);
static CianoWidgetsSourceListDataModelItemMonitor* ciano_widgets_source_list_data_model_item_monitor_new (CianoWidgetsSourceListItem* item);
static CianoWidgetsSourceListDataModelItemMonitor* ciano_widgets_source_list_data_model_item_monitor_construct (GType object_type,
                                                                                                         CianoWidgetsSourceListItem* item);
static void ciano_widgets_source_list_data_model_on_item_prop_changed (CianoWidgetsSourceListDataModel* self,
                                                                CianoWidgetsSourceListItem* item,
                                                                const gchar* prop_name);
static void _ciano_widgets_source_list_data_model_on_item_prop_changed_ciano_widgets_source_list_data_model_item_monitor_changed (CianoWidgetsSourceListDataModelItemMonitor* _sender,
                                                                                                                           CianoWidgetsSourceListItem* _self_,
                                                                                                                           const gchar* prop_name,
                                                                                                                           gpointer self);
static void ciano_widgets_source_list_data_model_on_item_child_added (CianoWidgetsSourceListDataModel* self,
                                                               CianoWidgetsSourceListItem* item);
static void _ciano_widgets_source_list_data_model_on_item_child_added_ciano_widgets_source_list_expandable_item_child_added (CianoWidgetsSourceListExpandableItem* _sender,
                                                                                                                      CianoWidgetsSourceListItem* item,
                                                                                                                      gpointer self);
static void ciano_widgets_source_list_data_model_on_item_child_removed (CianoWidgetsSourceListDataModel* self,
                                                                 CianoWidgetsSourceListItem* item);
static void _ciano_widgets_source_list_data_model_on_item_child_removed_ciano_widgets_source_list_expandable_item_child_removed (CianoWidgetsSourceListExpandableItem* _sender,
                                                                                                                          CianoWidgetsSourceListItem* item,
                                                                                                                          gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static gboolean ___lambda6_ (Block8Data* _data8_);
static gboolean ____lambda6__gsource_func (gpointer self);
static CianoWidgetsSourceListItem* ciano_widgets_source_list_data_model_get_item_from_path (CianoWidgetsSourceListDataModel* self,
                                                                                     GtkTreePath* path);
static GtkTreePath* ciano_widgets_source_list_data_model_get_item_child_path (CianoWidgetsSourceListDataModel* self,
                                                                       CianoWidgetsSourceListItem* item);
static gboolean ciano_widgets_source_list_data_model_is_category (CianoWidgetsSourceListDataModel* self,
                                                           CianoWidgetsSourceListItem* item,
                                                           GtkTreeIter* iter,
                                                           GtkTreePath* path);
static gboolean ciano_widgets_source_list_data_model_is_iter_at_root_level (CianoWidgetsSourceListDataModel* self,
                                                                     GtkTreeIter* iter);
static gboolean ciano_widgets_source_list_data_model_is_path_at_root_level (CianoWidgetsSourceListDataModel* self,
                                                                     GtkTreePath* path);
static gboolean ciano_widgets_source_list_data_model_real_drag_data_received (GtkTreeDragDest* base,
                                                                       GtkTreePath* dest,
                                                                       GtkSelectionData* selection_data);
static gboolean ciano_widgets_source_list_data_model_child_tree_drag_data_received (CianoWidgetsSourceListDataModel* self,
                                                                             GtkTreePath* dest,
                                                                             GtkTreePath* src_path);
static GtkTreePath* _vala_GtkTreePath_copy (GtkTreePath* self);
static void ciano_widgets_source_list_data_model_recursive_node_copy (CianoWidgetsSourceListDataModel* self,
                                                               GtkTreeIter* src_iter,
                                                               GtkTreeIter* dest_iter);
static void ciano_widgets_source_list_data_model_move_item (CianoWidgetsSourceListDataModel* self,
                                                     GtkTreeIter* src_iter,
                                                     GtkTreeIter* dest_iter);
static gboolean ciano_widgets_source_list_data_model_real_row_drop_possible (GtkTreeDragDest* base,
                                                                      GtkTreePath* dest,
                                                                      GtkSelectionData* selection_data);
static gint* _vala_array_dup3 (gint* self,
                        gssize length);
static gint* _vala_array_dup4 (gint* self,
                        gssize length);
static gboolean ciano_widgets_source_list_data_model_real_drag_data_get (GtkTreeDragSource* base,
                                                                  GtkTreePath* path,
                                                                  GtkSelectionData* selection_data);
static gboolean ciano_widgets_source_list_data_model_real_row_draggable (GtkTreeDragSource* base,
                                                                  GtkTreePath* path);
static void _vala_GtkTreeRowReference_free (GtkTreeRowReference* self);
static gboolean ciano_widgets_source_list_data_model_node_wrapper_get_valid (CianoWidgetsSourceListDataModelNodeWrapper* self);
static void ciano_widgets_source_list_data_model_node_wrapper_finalize (CianoWidgetsSourceListDataModelNodeWrapper * obj);
static GType ciano_widgets_source_list_data_model_node_wrapper_get_type_once (void);
static void ciano_widgets_source_list_data_model_item_monitor_on_notify (CianoWidgetsSourceListDataModelItemMonitor* self,
                                                                  GParamSpec* prop);
static void _ciano_widgets_source_list_data_model_item_monitor_on_notify_g_object_notify (GObject* _sender,
                                                                                   GParamSpec* pspec,
                                                                                   gpointer self);
static void g_cclosure_user_marshal_VOID__OBJECT_STRING (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void ciano_widgets_source_list_data_model_item_monitor_finalize (CianoWidgetsSourceListDataModelItemMonitor * obj);
static GType ciano_widgets_source_list_data_model_item_monitor_get_type_once (void);
static void ciano_widgets_source_list_data_model_finalize (GObject * obj);
static GType ciano_widgets_source_list_data_model_get_type_once (void);
static void _vala_ciano_widgets_source_list_data_model_get_property (GObject * object,
                                                              guint property_id,
                                                              GValue * value,
                                                              GParamSpec * pspec);
static void _vala_ciano_widgets_source_list_data_model_set_property (GObject * object,
                                                              guint property_id,
                                                              const GValue * value,
                                                              GParamSpec * pspec);
static GType ciano_widgets_source_list_cell_renderer_icon_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CianoWidgetsSourceListCellRendererIcon, g_object_unref)
static CianoWidgetsSourceListCellRendererIcon* ciano_widgets_source_list_cell_renderer_icon_new (void);
static CianoWidgetsSourceListCellRendererIcon* ciano_widgets_source_list_cell_renderer_icon_construct (GType object_type);
static gboolean ciano_widgets_source_list_cell_renderer_icon_real_activate (GtkCellRenderer* base,
                                                                     GdkEvent* event,
                                                                     GtkWidget* widget,
                                                                     const gchar* path,
                                                                     GdkRectangle* background_area,
                                                                     GdkRectangle* cell_area,
                                                                     GtkCellRendererState flags);
static GType ciano_widgets_source_list_cell_renderer_icon_get_type_once (void);
static GType ciano_widgets_source_list_cell_renderer_spacer_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CianoWidgetsSourceListCellRendererSpacer, g_object_unref)
static GtkSizeRequestMode ciano_widgets_source_list_cell_renderer_spacer_real_get_request_mode (GtkCellRenderer* base);
static void ciano_widgets_source_list_cell_renderer_spacer_real_get_preferred_width (GtkCellRenderer* base,
                                                                              GtkWidget* widget,
                                                                              gint* min_size,
                                                                              gint* natural_size);
static void ciano_widgets_source_list_cell_renderer_spacer_real_get_preferred_height_for_width (GtkCellRenderer* base,
                                                                                         GtkWidget* widget,
                                                                                         gint width,
                                                                                         gint* min_height,
                                                                                         gint* natural_height);
static void ciano_widgets_source_list_cell_renderer_spacer_real_render (GtkCellRenderer* base,
                                                                 cairo_t* context,
                                                                 GtkWidget* widget,
                                                                 GdkRectangle* bg_area,
                                                                 GdkRectangle* cell_area,
                                                                 GtkCellRendererState flags);
static void ciano_widgets_source_list_cell_renderer_spacer_real_get_size (GtkCellRenderer* base,
                                                                   GtkWidget* widget,
                                                                   GdkRectangle* cell_area,
                                                                   gint* x_offset,
                                                                   gint* y_offset,
                                                                   gint* width,
                                                                   gint* height) G_GNUC_DEPRECATED ;
static CianoWidgetsSourceListCellRendererSpacer* ciano_widgets_source_list_cell_renderer_spacer_new (void);
static CianoWidgetsSourceListCellRendererSpacer* ciano_widgets_source_list_cell_renderer_spacer_construct (GType object_type);
static gint ciano_widgets_source_list_cell_renderer_spacer_get_level (CianoWidgetsSourceListCellRendererSpacer* self);
static void ciano_widgets_source_list_cell_renderer_spacer_set_level (CianoWidgetsSourceListCellRendererSpacer* self,
                                                               gint value);
static void ciano_widgets_source_list_cell_renderer_spacer_finalize (GObject * obj);
static GType ciano_widgets_source_list_cell_renderer_spacer_get_type_once (void);
static void _vala_ciano_widgets_source_list_cell_renderer_spacer_get_property (GObject * object,
                                                                        guint property_id,
                                                                        GValue * value,
                                                                        GParamSpec * pspec);
static void _vala_ciano_widgets_source_list_cell_renderer_spacer_set_property (GObject * object,
                                                                        guint property_id,
                                                                        const GValue * value,
                                                                        GParamSpec * pspec);
static void ciano_widgets_source_list_tree_on_editing_started (CianoWidgetsSourceListTree* self,
                                                        GtkCellEditable* editable,
                                                        const gchar* path);
static void _ciano_widgets_source_list_tree_on_editing_started_gtk_cell_renderer_editing_started (GtkCellRenderer* _sender,
                                                                                           GtkCellEditable* editable,
                                                                                           const gchar* path,
                                                                                           gpointer self);
static void ciano_widgets_source_list_tree_on_editing_canceled (CianoWidgetsSourceListTree* self);
static void _ciano_widgets_source_list_tree_on_editing_canceled_gtk_cell_renderer_editing_canceled (GtkCellRenderer* _sender,
                                                                                             gpointer self);
static void ciano_widgets_source_list_tree_disable_item_property_monitor (CianoWidgetsSourceListTree* self);
static GType ciano_widgets_source_list_tree_column_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void ciano_widgets_source_list_tree_set_data_model (CianoWidgetsSourceListTree* self,
                                                    CianoWidgetsSourceListDataModel* value);
static void ciano_widgets_source_list_tree_expander_cell_data_func (CianoWidgetsSourceListTree* self,
                                                             GtkCellLayout* layout,
                                                             GtkCellRenderer* renderer,
                                                             GtkTreeModel* model,
                                                             GtkTreeIter* iter);
static void _ciano_widgets_source_list_tree_expander_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                                        GtkCellRenderer* cell,
                                                                                        GtkTreeModel* tree_model,
                                                                                        GtkTreeIter* iter,
                                                                                        gpointer self);
static void ciano_widgets_source_list_tree_on_activatable_activated (CianoWidgetsSourceListTree* self,
                                                              const gchar* item_path_str);
static void _ciano_widgets_source_list_tree_on_activatable_activated_ciano_widgets_source_list_cell_renderer_icon_activated (CianoWidgetsSourceListCellRendererIcon* _sender,
                                                                                                                      const gchar* path,
                                                                                                                      gpointer self);
static void ciano_widgets_source_list_tree_icon_cell_data_func (CianoWidgetsSourceListTree* self,
                                                         GtkCellLayout* layout,
                                                         GtkCellRenderer* renderer,
                                                         GtkTreeModel* model,
                                                         GtkTreeIter* iter);
static void _ciano_widgets_source_list_tree_icon_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                                    GtkCellRenderer* cell,
                                                                                    GtkTreeModel* tree_model,
                                                                                    GtkTreeIter* iter,
                                                                                    gpointer self);
static void ciano_widgets_source_list_tree_badge_cell_data_func (CianoWidgetsSourceListTree* self,
                                                          GtkCellLayout* layout,
                                                          GtkCellRenderer* renderer,
                                                          GtkTreeModel* model,
                                                          GtkTreeIter* iter);
static void _ciano_widgets_source_list_tree_badge_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                                     GtkCellRenderer* cell,
                                                                                     GtkTreeModel* tree_model,
                                                                                     GtkTreeIter* iter,
                                                                                     gpointer self);
static void ciano_widgets_source_list_tree_name_cell_data_func (CianoWidgetsSourceListTree* self,
                                                         GtkCellLayout* layout,
                                                         GtkCellRenderer* renderer,
                                                         GtkTreeModel* model,
                                                         GtkTreeIter* iter);
static void _ciano_widgets_source_list_tree_name_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                                    GtkCellRenderer* cell,
                                                                                    GtkTreeModel* tree_model,
                                                                                    GtkTreeIter* iter,
                                                                                    gpointer self);
static gboolean ciano_widgets_source_list_tree_select_func (CianoWidgetsSourceListTree* self,
                                                     GtkTreeSelection* selection,
                                                     GtkTreeModel* model,
                                                     GtkTreePath* path,
                                                     gboolean path_currently_selected);
static gboolean _ciano_widgets_source_list_tree_select_func_gtk_tree_selection_func (GtkTreeSelection* selection,
                                                                              GtkTreeModel* model,
                                                                              GtkTreePath* path,
                                                                              gboolean path_currently_selected,
                                                                              gpointer self);
static void ciano_widgets_source_list_tree_enable_item_property_monitor (CianoWidgetsSourceListTree* self);
static void ciano_widgets_source_list_tree_add_spacer_cell_for_level (CianoWidgetsSourceListTree* self,
                                                               gint level,
                                                               gboolean check_previous);
static gboolean ciano_widgets_source_list_tree_real_drag_motion (GtkWidget* base,
                                                          GdkDragContext* context,
                                                          gint x,
                                                          gint y,
                                                          guint time);
static CianoWidgetsSourceListDataModel* ciano_widgets_source_list_tree_get_data_model (CianoWidgetsSourceListTree* self);
static void ciano_widgets_source_list_tree_real_drag_data_received (GtkWidget* base,
                                                             GdkDragContext* context,
                                                             gint x,
                                                             gint y,
                                                             GtkSelectionData* selection_data,
                                                             guint info,
                                                             guint time);
static GtkTargetEntry* ciano_widgets_source_list_tree_append_row_target_entry (GtkTargetEntry* orig,
                                                                        gint orig_length1,
                                                                        gint* result_length1);
static void _vala_array_add1 (GtkTargetEntry* * array,
                       gint* length,
                       gint* size,
                       const GtkTargetEntry* value);
static void _vala_array_add2 (GtkTargetEntry* * array,
                       gint* length,
                       gint* size,
                       const GtkTargetEntry* value);
static void ciano_widgets_source_list_tree_on_model_item_updated (CianoWidgetsSourceListTree* self,
                                                           CianoWidgetsSourceListItem* item);
static void _ciano_widgets_source_list_tree_on_model_item_updated_ciano_widgets_source_list_data_model_item_updated (CianoWidgetsSourceListDataModel* _sender,
                                                                                                              CianoWidgetsSourceListItem* item,
                                                                                                              gpointer self);
static void ciano_widgets_source_list_tree_update_expansion (CianoWidgetsSourceListTree* self,
                                                      CianoWidgetsSourceListExpandableItem* expandable_item);
static void ciano_widgets_source_list_tree_spacer_cell_data_func (GtkCellLayout* layout,
                                                           GtkCellRenderer* renderer,
                                                           GtkTreeModel* model,
                                                           GtkTreeIter* iter);
static void _ciano_widgets_source_list_tree_spacer_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                                      GtkCellRenderer* cell,
                                                                                      GtkTreeModel* tree_model,
                                                                                      GtkTreeIter* iter,
                                                                                      gpointer self);
static GtkTreePath* ciano_widgets_source_list_tree_get_selected_path (CianoWidgetsSourceListTree* self);
static void __vala_GtkTreePath_free0_ (gpointer var);
static inline void _g_list_free___vala_GtkTreePath_free0_ (GList* self);
static void ciano_widgets_source_list_tree_set_selected (CianoWidgetsSourceListTree* self,
                                                  CianoWidgetsSourceListItem* item,
                                                  gboolean scroll_to_item);
static void ciano_widgets_source_list_tree_real_cursor_changed (GtkTreeView* base);
static void ciano_widgets_source_list_tree_on_editing_done (CianoWidgetsSourceListTree* self);
static void _ciano_widgets_source_list_tree_on_editing_done_gtk_cell_editable_editing_done (GtkCellEditable* _sender,
                                                                                     gpointer self);
static CianoWidgetsSourceListItem* ciano_widgets_source_list_tree_get_item_from_path_string (CianoWidgetsSourceListTree* self,
                                                                                      const gchar* item_path_str);
static gboolean ciano_widgets_source_list_tree_toggle_expansion (CianoWidgetsSourceListTree* self,
                                                          CianoWidgetsSourceListExpandableItem* item);
static void ciano_widgets_source_list_tree_real_row_expanded (GtkTreeView* base,
                                                       GtkTreeIter* iter,
                                                       GtkTreePath* path);
static void ciano_widgets_source_list_tree_real_row_collapsed (GtkTreeView* base,
                                                        GtkTreeIter* iter,
                                                        GtkTreePath* path);
static void ciano_widgets_source_list_tree_real_row_activated (GtkTreeView* base,
                                                        GtkTreePath* path,
                                                        GtkTreeViewColumn* column);
static gboolean ciano_widgets_source_list_tree_real_key_release_event (GtkWidget* base,
                                                                GdkEventKey* event);
static gboolean ciano_widgets_source_list_tree_real_button_release_event (GtkWidget* base,
                                                                   GdkEventButton* event);
static gboolean ciano_widgets_source_list_tree_real_button_press_event (GtkWidget* base,
                                                                 GdkEventButton* event);
static gboolean ciano_widgets_source_list_tree_popup_context_menu (CianoWidgetsSourceListTree* self,
                                                            CianoWidgetsSourceListItem* item,
                                                            GdkEventButton* event);
static gboolean ciano_widgets_source_list_tree_over_cell (CianoWidgetsSourceListTree* self,
                                                   GtkTreeViewColumn* col,
                                                   GtkTreePath* path,
                                                   GtkCellRenderer* cell,
                                                   gint x);
static gboolean ciano_widgets_source_list_tree_over_primary_expander (CianoWidgetsSourceListTree* self,
                                                               GtkTreeViewColumn* col,
                                                               GtkTreePath* path,
                                                               gint x);
static gint ciano_widgets_source_list_tree_get_cell_width (CianoWidgetsSourceListTree* self,
                                                    GtkCellRenderer* cell_renderer);
static gboolean ciano_widgets_source_list_tree_real_popup_menu (GtkWidget* base);
static void ciano_widgets_source_list_tree_menu_position_func (CianoWidgetsSourceListTree* self,
                                                        GtkMenu* menu,
                                                        gint* x,
                                                        gint* y,
                                                        gboolean* push_in);
static void _ciano_widgets_source_list_tree_menu_position_func_gtk_menu_position_func (GtkMenu* menu,
                                                                                gint* x,
                                                                                gint* y,
                                                                                gboolean* push_in,
                                                                                gpointer self);
static CianoWidgetsSourceListItem* ciano_widgets_source_list_tree_get_item_from_model (GtkTreeModel* model,
                                                                                GtkTreeIter* iter);
static void ciano_widgets_source_list_tree_finalize (GObject * obj);
static GType ciano_widgets_source_list_tree_get_type_once (void);
static void _vala_ciano_widgets_source_list_tree_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec);
static void _vala_ciano_widgets_source_list_tree_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec);
static void ciano_widgets_source_list_finalize (GObject * obj);
static GType ciano_widgets_source_list_get_type_once (void);
static void _vala_ciano_widgets_source_list_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_ciano_widgets_source_list_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

/**
     * Whether this item will allow users to re-arrange its children via DnD.
     *
     * This feature can co-exist with a sort algorithm (implemented
     * by {@link Granite.Widgets.SourceListSortable.compare}), but
     * the actual order of the items in the list will always
     * honor that method. The sort function has to be compatible with
     * the kind of DnD reordering the item wants to allow, since the user can
     * only reorder those items for which //compare// returns 0.
     *
     * @return Whether the item's children can be re-arranged by users.
     * @since 0.3
     */
gboolean
ciano_widgets_source_list_sortable_allow_dnd_sorting (CianoWidgetsSourceListSortable* self)
{
	CianoWidgetsSourceListSortableIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = CIANO_WIDGETS_SOURCE_LIST_SORTABLE_GET_INTERFACE (self);
	if (_iface_->allow_dnd_sorting) {
		return _iface_->allow_dnd_sorting (self);
	}
	return FALSE;
}

/**
     * Should return a negative integer, zero, or a positive integer if ''a''
     * sorts //before// ''b'', ''a'' sorts //with// ''b'', or ''a'' sorts
     * //after// ''b'' respectively. If two items compare as equal, their
     * order in the sorted source list is undefined.
     *
     * In order to ensure that the source list behaves as expected, this
     * method must define a partial order on the source list tree; i.e. it
     * must be reflexive, antisymmetric and transitive. Not complying with
     * those requirements could make the program fall into an infinite loop
     * and freeze the user interface.
     *
     * Should return //0// to allow any pair of items to be sortable via DnD.
     *
     * @param a First item.
     * @param b Second item.
     * @return A //negative// integer if //a// sorts before //b//,
     *         //zero// if //a// equals //b//, or a //positive//
     *         integer if //a// sorts after //b//.
     * @since 0.3
     */
gint
ciano_widgets_source_list_sortable_compare (CianoWidgetsSourceListSortable* self,
                                            CianoWidgetsSourceListItem* a,
                                            CianoWidgetsSourceListItem* b)
{
	CianoWidgetsSourceListSortableIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = CIANO_WIDGETS_SOURCE_LIST_SORTABLE_GET_INTERFACE (self);
	if (_iface_->compare) {
		return _iface_->compare (self, a, b);
	}
	return -1;
}

static void
ciano_widgets_source_list_sortable_default_init (CianoWidgetsSourceListSortableIface * iface,
                                                 gpointer iface_data)
{
	/**
	     * Emitted after a user has re-ordered an item via DnD.
	     *
	     * @param moved The item that was moved to a different position by the user.
	     * @since 0.3
	     */
	ciano_widgets_source_list_sortable_signals[CIANO_WIDGETS_SOURCE_LIST_SORTABLE_USER_MOVED_ITEM_SIGNAL] = g_signal_new ("user-moved-item", CIANO_WIDGETS_TYPE_SOURCE_LIST_SORTABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, CIANO_WIDGETS_SOURCE_LIST_TYPE_ITEM);
}

/**
 * An interface for sorting items.
 *
 * @since 0.3
 */
static GType
ciano_widgets_source_list_sortable_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CianoWidgetsSourceListSortableIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ciano_widgets_source_list_sortable_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType ciano_widgets_source_list_sortable_type_id;
	ciano_widgets_source_list_sortable_type_id = g_type_register_static (G_TYPE_INTERFACE, "CianoWidgetsSourceListSortable", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (ciano_widgets_source_list_sortable_type_id, CIANO_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM);
	return ciano_widgets_source_list_sortable_type_id;
}

GType
ciano_widgets_source_list_sortable_get_type (void)
{
	static volatile gsize ciano_widgets_source_list_sortable_type_id__once = 0;
	if (g_once_init_enter (&ciano_widgets_source_list_sortable_type_id__once)) {
		GType ciano_widgets_source_list_sortable_type_id;
		ciano_widgets_source_list_sortable_type_id = ciano_widgets_source_list_sortable_get_type_once ();
		g_once_init_leave (&ciano_widgets_source_list_sortable_type_id__once, ciano_widgets_source_list_sortable_type_id);
	}
	return ciano_widgets_source_list_sortable_type_id__once;
}

/**
     * Determines whether this item can be dragged outside the source list widget.
     *
     * Even if this method returns //false//, the item could still be dragged around
     * within the source list if its parent allows DnD reordering. This only happens
     * when the parent implements {@link Granite.Widgets.SourceListSortable}.
     *
     * @return //true// if the item can be dragged; //false// otherwise.
     * @since 0.3
     * @see Granite.Widgets.SourceListSortable
     */
gboolean
ciano_widgets_source_list_drag_source_draggable (CianoWidgetsSourceListDragSource* self)
{
	CianoWidgetsSourceListDragSourceIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = CIANO_WIDGETS_SOURCE_LIST_DRAG_SOURCE_GET_INTERFACE (self);
	if (_iface_->draggable) {
		return _iface_->draggable (self);
	}
	return FALSE;
}

/**
     * This method is called when the drop site requests the data which is dragged.
     *
     * It is the responsibility of this method to fill //selection_data// with the
     * data in the format which is indicated by {@link Gtk.SelectionData.get_target}.
     *
     * @param selection_data {@link Gtk.SelectionData} containing source data.
     * @since 0.3
     * @see Gtk.SelectionData.set
     * @see Gtk.SelectionData.set_uris
     * @see Gtk.SelectionData.set_text
     */
void
ciano_widgets_source_list_drag_source_prepare_selection_data (CianoWidgetsSourceListDragSource* self,
                                                              GtkSelectionData* selection_data)
{
	CianoWidgetsSourceListDragSourceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = CIANO_WIDGETS_SOURCE_LIST_DRAG_SOURCE_GET_INTERFACE (self);
	if (_iface_->prepare_selection_data) {
		_iface_->prepare_selection_data (self, selection_data);
	}
}

static void
ciano_widgets_source_list_drag_source_default_init (CianoWidgetsSourceListDragSourceIface * iface,
                                                    gpointer iface_data)
{
}

/**
 * An interface for dragging items out of the source list widget.
 *
 * @since 0.3
 */
static GType
ciano_widgets_source_list_drag_source_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CianoWidgetsSourceListDragSourceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ciano_widgets_source_list_drag_source_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType ciano_widgets_source_list_drag_source_type_id;
	ciano_widgets_source_list_drag_source_type_id = g_type_register_static (G_TYPE_INTERFACE, "CianoWidgetsSourceListDragSource", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (ciano_widgets_source_list_drag_source_type_id, CIANO_WIDGETS_SOURCE_LIST_TYPE_ITEM);
	return ciano_widgets_source_list_drag_source_type_id;
}

GType
ciano_widgets_source_list_drag_source_get_type (void)
{
	static volatile gsize ciano_widgets_source_list_drag_source_type_id__once = 0;
	if (g_once_init_enter (&ciano_widgets_source_list_drag_source_type_id__once)) {
		GType ciano_widgets_source_list_drag_source_type_id;
		ciano_widgets_source_list_drag_source_type_id = ciano_widgets_source_list_drag_source_get_type_once ();
		g_once_init_leave (&ciano_widgets_source_list_drag_source_type_id__once, ciano_widgets_source_list_drag_source_type_id);
	}
	return ciano_widgets_source_list_drag_source_type_id__once;
}

/**
     * Determines whether //data// can be dropped into this item.
     *
     * @param context The drag context.
     * @param data {@link Gtk.SelectionData} containing source data.
     * @return //true// if the drop is possible; //false// otherwise.
     * @since 0.3
     */
gboolean
ciano_widgets_source_list_drag_dest_data_drop_possible (CianoWidgetsSourceListDragDest* self,
                                                        GdkDragContext* context,
                                                        GtkSelectionData* data)
{
	CianoWidgetsSourceListDragDestIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = CIANO_WIDGETS_SOURCE_LIST_DRAG_DEST_GET_INTERFACE (self);
	if (_iface_->data_drop_possible) {
		return _iface_->data_drop_possible (self, context, data);
	}
	return FALSE;
}

/**
     * If a data drop is deemed possible, then this method is called
     * when the data is actually dropped into this item. Any actions
     * consequence of the data received should be handled here.
     *
     * @param context The drag context.
     * @param data {@link Gtk.SelectionData} containing source data.
     * @return The action taken, or //0// to indicate that the dropped data was not accepted.
     * @since 0.3
     */
GdkDragAction
ciano_widgets_source_list_drag_dest_data_received (CianoWidgetsSourceListDragDest* self,
                                                   GdkDragContext* context,
                                                   GtkSelectionData* data)
{
	CianoWidgetsSourceListDragDestIface* _iface_;
	g_return_val_if_fail (self != NULL, 0U);
	_iface_ = CIANO_WIDGETS_SOURCE_LIST_DRAG_DEST_GET_INTERFACE (self);
	if (_iface_->data_received) {
		return _iface_->data_received (self, context, data);
	}
	return 0U;
}

static void
ciano_widgets_source_list_drag_dest_default_init (CianoWidgetsSourceListDragDestIface * iface,
                                                  gpointer iface_data)
{
}

/**
 * An interface for receiving data from other widgets via drag-and-drop.
 *
 * @since 0.3
 */
static GType
ciano_widgets_source_list_drag_dest_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CianoWidgetsSourceListDragDestIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ciano_widgets_source_list_drag_dest_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType ciano_widgets_source_list_drag_dest_type_id;
	ciano_widgets_source_list_drag_dest_type_id = g_type_register_static (G_TYPE_INTERFACE, "CianoWidgetsSourceListDragDest", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (ciano_widgets_source_list_drag_dest_type_id, CIANO_WIDGETS_SOURCE_LIST_TYPE_ITEM);
	return ciano_widgets_source_list_drag_dest_type_id;
}

GType
ciano_widgets_source_list_drag_dest_get_type (void)
{
	static volatile gsize ciano_widgets_source_list_drag_dest_type_id__once = 0;
	if (g_once_init_enter (&ciano_widgets_source_list_drag_dest_type_id__once)) {
		GType ciano_widgets_source_list_drag_dest_type_id;
		ciano_widgets_source_list_drag_dest_type_id = ciano_widgets_source_list_drag_dest_get_type_once ();
		g_once_init_leave (&ciano_widgets_source_list_drag_dest_type_id__once, ciano_widgets_source_list_drag_dest_type_id);
	}
	return ciano_widgets_source_list_drag_dest_type_id__once;
}

static inline gpointer
ciano_widgets_source_list_get_instance_private (CianoWidgetsSourceList* self)
{
	return G_STRUCT_MEMBER_P (self, CianoWidgetsSourceList_private_offset);
}

/**
     * Creates a new {@link Granite.Widgets.SourceList}.
     *
     * @return A new {@link Granite.Widgets.SourceList}.
     * @since 0.2
     */
static void
__lambda7_ (CianoWidgetsSourceList* self,
            CianoWidgetsSourceListItem* item)
{
	g_signal_emit (self, ciano_widgets_source_list_signals[CIANO_WIDGETS_SOURCE_LIST_ITEM_SELECTED_SIGNAL], 0, item);
}

static void
___lambda7__ciano_widgets_source_list_tree_item_selected (CianoWidgetsSourceListTree* _sender,
                                                          CianoWidgetsSourceListItem* item,
                                                          gpointer self)
{
	__lambda7_ ((CianoWidgetsSourceList*) self, item);
}

CianoWidgetsSourceList*
ciano_widgets_source_list_construct (GType object_type,
                                     CianoWidgetsSourceListExpandableItem* root)
{
	CianoWidgetsSourceList * self = NULL;
	CianoWidgetsSourceListDataModel* _tmp0_;
	CianoWidgetsSourceListTree* _tmp1_;
	CianoWidgetsSourceListTree* _tmp2_;
	CianoWidgetsSourceListTree* _tmp3_;
	CianoWidgetsSourceListTree* _tmp4_;
	g_return_val_if_fail (root != NULL, NULL);
	self = (CianoWidgetsSourceList*) g_object_new (object_type, NULL);
	ciano_widgets_source_list_set_root (self, root);
	gtk_widget_push_composite_child ();
	_tmp0_ = self->priv->data_model;
	_tmp1_ = ciano_widgets_source_list_tree_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->tree);
	self->priv->tree = _tmp1_;
	_tmp2_ = self->priv->tree;
	gtk_widget_set_composite_name ((GtkWidget*) _tmp2_, "treeview");
	gtk_widget_pop_composite_child ();
	gtk_scrolled_window_set_policy ((GtkScrolledWindow*) self, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	_tmp3_ = self->priv->tree;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp3_);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp4_ = self->priv->tree;
	g_signal_connect_object (_tmp4_, "item-selected", (GCallback) ___lambda7__ciano_widgets_source_list_tree_item_selected, self, 0);
	return self;
}

CianoWidgetsSourceList*
ciano_widgets_source_list_new (CianoWidgetsSourceListExpandableItem* root)
{
	return ciano_widgets_source_list_construct (CIANO_WIDGETS_TYPE_SOURCE_LIST, root);
}

/**
     * Checks whether //item// is part of the source list.
     *
     * @param item The item to query.
     * @return //true// if the item belongs to the source list; //false// otherwise.
     * @since 0.2
     */
gboolean
ciano_widgets_source_list_has_item (CianoWidgetsSourceList* self,
                                    CianoWidgetsSourceListItem* item)
{
	CianoWidgetsSourceListDataModel* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp0_ = self->priv->data_model;
	result = ciano_widgets_source_list_data_model_has_item (_tmp0_, item);
	return result;
}

/**
     * Sets the method used for filtering out items.
     *
     * @param visible_func The method to use for filtering items.
     * @param refilter Whether to call {@link Granite.Widgets.SourceList.refilter} using the new function.
     * @see Granite.Widgets.SourceList.VisibleFunc
     * @see Granite.Widgets.SourceList.refilter
     * @since 0.2
     */
void
ciano_widgets_source_list_set_filter_func (CianoWidgetsSourceList* self,
                                           CianoWidgetsSourceListVisibleFunc visible_func,
                                           gpointer visible_func_target,
                                           gboolean refilter)
{
	CianoWidgetsSourceListDataModel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->data_model;
	ciano_widgets_source_list_data_model_set_filter_func (_tmp0_, visible_func, visible_func_target);
	if (refilter) {
		ciano_widgets_source_list_refilter (self);
	}
}

/**
     * Applies the filter method set by {@link Granite.Widgets.SourceList.set_filter_func}
     * to all the items that are part of the current tree.
     *
     * @see Granite.Widgets.SourceList.VisibleFunc
     * @see Granite.Widgets.SourceList.set_filter_func
     * @since 0.2
     */
void
ciano_widgets_source_list_refilter (CianoWidgetsSourceList* self)
{
	CianoWidgetsSourceListDataModel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->data_model;
	gtk_tree_model_filter_refilter ((GtkTreeModelFilter*) _tmp0_);
}

/**
     * Queries the actual expansion state of //item//.
     *
     * @see Granite.Widgets.SourceList.ExpandableItem.expanded
     * @return Whether //item// is expanded or not.
     * @since 0.2
     */
static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

gboolean
ciano_widgets_source_list_is_item_expanded (CianoWidgetsSourceList* self,
                                            CianoWidgetsSourceListItem* item)
{
	GtkTreePath* path = NULL;
	CianoWidgetsSourceListDataModel* _tmp0_;
	GtkTreePath* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GtkTreePath* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	_vala_return_val_if_fail (ciano_widgets_source_list_has_item (self, item), "has_item (item)", FALSE);
	_tmp0_ = self->priv->data_model;
	_tmp1_ = ciano_widgets_source_list_data_model_get_item_path (_tmp0_, item);
	path = _tmp1_;
	_tmp3_ = path;
	if (_tmp3_ != NULL) {
		CianoWidgetsSourceListTree* _tmp4_;
		GtkTreePath* _tmp5_;
		_tmp4_ = self->priv->tree;
		_tmp5_ = path;
		_tmp2_ = gtk_tree_view_row_expanded ((GtkTreeView*) _tmp4_, _tmp5_);
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	__vala_GtkTreePath_free0 (path);
	return result;
}

/**
     * If //item// is editable, this activates the editor; otherwise, it does nothing.
     * If an item was already being edited, this will fail.
     *
     * @param item Item to edit.
     * @see Granite.Widgets.SourceList.Item.editable
     * @see Granite.Widgets.SourceList.editing
     * @see Granite.Widgets.SourceList.stop_editing
     * @return true if the editing started successfully; false otherwise.
     * @since 0.2
     */
gboolean
ciano_widgets_source_list_start_editing_item (CianoWidgetsSourceList* self,
                                              CianoWidgetsSourceListItem* item)
{
	CianoWidgetsSourceListTree* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	_vala_return_val_if_fail (ciano_widgets_source_list_has_item (self, item), "has_item (item)", FALSE);
	_tmp0_ = self->priv->tree;
	result = ciano_widgets_source_list_tree_start_editing_item (_tmp0_, item);
	return result;
}

/**
     * Cancels any editing operation going on.
     *
     * @see Granite.Widgets.SourceList.editing
     * @see Granite.Widgets.SourceList.start_editing_item
     * @since 0.2
     */
void
ciano_widgets_source_list_stop_editing (CianoWidgetsSourceList* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ciano_widgets_source_list_get_editing (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		CianoWidgetsSourceListTree* _tmp2_;
		_tmp2_ = self->priv->tree;
		ciano_widgets_source_list_tree_stop_editing (_tmp2_);
	}
}

/**
     * Turns Source List into a //drag source//.
     *
     * This enables items that implement {@link Granite.Widgets.SourceListDragSource}
     * to be dragged outside the Source List and drop data into external widgets.
     *
     * @param src_entries an array of {@link Gtk.TargetEntry}s indicating the targets
     * that the drag will support.
     * @see Granite.Widgets.SourceListDragSource
     * @see Granite.Widgets.SourceList.disable_drag_source
     * @since 0.3
     */
void
ciano_widgets_source_list_enable_drag_source (CianoWidgetsSourceList* self,
                                              GtkTargetEntry* src_entries,
                                              gint src_entries_length1)
{
	CianoWidgetsSourceListTree* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tree;
	ciano_widgets_source_list_tree_configure_drag_source (_tmp0_, src_entries, (gint) src_entries_length1);
}

/**
     * Undoes the effect of {@link Granite.Widgets.SourceList.enable_drag_source}
     *
     * @see Granite.Widgets.SourceList.enable_drag_source
     * @since 0.3
     */
void
ciano_widgets_source_list_disable_drag_source (CianoWidgetsSourceList* self)
{
	CianoWidgetsSourceListTree* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tree;
	ciano_widgets_source_list_tree_configure_drag_source (_tmp0_, NULL, (gint) 0);
}

/**
     * Turns Source List into a //drop destination//.
     *
     * This enables items that implement {@link Granite.Widgets.SourceListDragDest}
     * to receive data from external widgets via drag-and-drop.
     *
     * @param dest_entries an array of {@link Gtk.TargetEntry}s indicating the drop
     * types that Source List items will accept.
     * @param actions a bitmask of possible actions for a drop onto Source List items.
     * @see Granite.Widgets.SourceListDragDest
     * @see Granite.Widgets.SourceList.disable_drag_dest
     * @since 0.3
     */
void
ciano_widgets_source_list_enable_drag_dest (CianoWidgetsSourceList* self,
                                            GtkTargetEntry* dest_entries,
                                            gint dest_entries_length1,
                                            GdkDragAction actions)
{
	CianoWidgetsSourceListTree* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tree;
	ciano_widgets_source_list_tree_configure_drag_dest (_tmp0_, dest_entries, (gint) dest_entries_length1, actions);
}

/**
     * Undoes the effect of {@link Granite.Widgets.SourceList.enable_drag_dest}
     *
     * @see Granite.Widgets.SourceList.enable_drag_dest
     * @since 0.3
     */
void
ciano_widgets_source_list_disable_drag_dest (CianoWidgetsSourceList* self)
{
	CianoWidgetsSourceListTree* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tree;
	ciano_widgets_source_list_tree_configure_drag_dest (_tmp0_, NULL, (gint) 0, 0);
}

/**
     * Scrolls the source list tree to make //item// visible.
     *
     * {@link Granite.Widgets.SourceList.ExpandableItem.expand_with_parents} is called
     * for the item's parent if //expand_parents// is //true//, to make sure it's not
     * hidden behind a collapsed row.
     *
     * If use_align is //false//, then the row_align argument is ignored, and the tree
     * does the minimum amount of work to scroll the item onto the screen. This means that
     * the item will be scrolled to the edge closest to its current position. If the item
     * is currently visible on the screen, nothing is done.
     *
     * @param item Item to scroll to.
     * @param expand_parents Whether to recursively expand item's parent in case they are collapsed.
     * @param use_align Whether to use the //row_align// argument.
     * @param row_align The vertical alignment of //item//. 0.0 means top, 0.5 center, and 1.0 bottom.
     * @return //true// if successful; //false// otherwise.
     * @since 0.2
     */
gboolean
ciano_widgets_source_list_scroll_to_item (CianoWidgetsSourceList* self,
                                          CianoWidgetsSourceListItem* item,
                                          gboolean expand_parents,
                                          gboolean use_align,
                                          gfloat row_align)
{
	gboolean _tmp0_ = FALSE;
	CianoWidgetsSourceListTree* _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	_vala_return_val_if_fail (ciano_widgets_source_list_has_item (self, item), "has_item (item)", FALSE);
	if (expand_parents) {
		CianoWidgetsSourceListExpandableItem* _tmp1_;
		CianoWidgetsSourceListExpandableItem* _tmp2_;
		_tmp1_ = ciano_widgets_source_list_item_get_parent (item);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		CianoWidgetsSourceListExpandableItem* _tmp3_;
		CianoWidgetsSourceListExpandableItem* _tmp4_;
		_tmp3_ = ciano_widgets_source_list_item_get_parent (item);
		_tmp4_ = _tmp3_;
		ciano_widgets_source_list_expandable_item_expand_with_parents (_tmp4_);
	}
	_tmp5_ = self->priv->tree;
	result = ciano_widgets_source_list_tree_scroll_to_item (_tmp5_, item, use_align, row_align);
	return result;
}

/**
     * Gets the previous item with respect to //reference//.
     *
     * @param reference Item to use as reference.
     * @return The item that appears before //reference//, or //null// if there's none.
     * @since 0.2
     */
static void
_vala_GtkTreeIter_free (GtkTreeIter* self)
{
	g_boxed_free (gtk_tree_iter_get_type (), self);
}

CianoWidgetsSourceListItem*
ciano_widgets_source_list_get_previous_item (CianoWidgetsSourceList* self,
                                             CianoWidgetsSourceListItem* reference)
{
	GtkTreeIter* iter = NULL;
	CianoWidgetsSourceListDataModel* _tmp0_;
	GtkTreeIter* _tmp1_;
	GtkTreeIter* _tmp2_;
	CianoWidgetsSourceListItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (reference != NULL, NULL);
	_vala_return_val_if_fail (ciano_widgets_source_list_has_item (self, reference), "has_item (reference)", NULL);
	_tmp0_ = self->priv->data_model;
	_tmp1_ = ciano_widgets_source_list_data_model_get_item_iter (_tmp0_, reference);
	iter = _tmp1_;
	_tmp2_ = iter;
	if (_tmp2_ != NULL) {
		GtkTreeIter new_iter = {0};
		GtkTreeIter* _tmp3_;
		CianoWidgetsSourceListDataModel* _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = iter;
		new_iter = *_tmp3_;
		_tmp4_ = self->priv->data_model;
		_tmp5_ = gtk_tree_model_iter_previous ((GtkTreeModel*) _tmp4_, &new_iter);
		if (_tmp5_) {
			CianoWidgetsSourceListDataModel* _tmp6_;
			GtkTreeIter _tmp7_;
			CianoWidgetsSourceListItem* _tmp8_;
			_tmp6_ = self->priv->data_model;
			_tmp7_ = new_iter;
			_tmp8_ = ciano_widgets_source_list_data_model_get_item (_tmp6_, &_tmp7_);
			result = _tmp8_;
			__vala_GtkTreeIter_free0 (iter);
			return result;
		}
	}
	result = NULL;
	__vala_GtkTreeIter_free0 (iter);
	return result;
}

/**
     * Gets the next item with respect to //reference//.
     *
     * @param reference Item to use as reference.
     * @return The item that appears after //reference//, or //null// if there's none.
     * @since 0.2
     */
CianoWidgetsSourceListItem*
ciano_widgets_source_list_get_next_item (CianoWidgetsSourceList* self,
                                         CianoWidgetsSourceListItem* reference)
{
	GtkTreeIter* iter = NULL;
	CianoWidgetsSourceListDataModel* _tmp0_;
	GtkTreeIter* _tmp1_;
	GtkTreeIter* _tmp2_;
	CianoWidgetsSourceListItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (reference != NULL, NULL);
	_vala_return_val_if_fail (ciano_widgets_source_list_has_item (self, reference), "has_item (reference)", NULL);
	_tmp0_ = self->priv->data_model;
	_tmp1_ = ciano_widgets_source_list_data_model_get_item_iter (_tmp0_, reference);
	iter = _tmp1_;
	_tmp2_ = iter;
	if (_tmp2_ != NULL) {
		GtkTreeIter new_iter = {0};
		GtkTreeIter* _tmp3_;
		CianoWidgetsSourceListDataModel* _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = iter;
		new_iter = *_tmp3_;
		_tmp4_ = self->priv->data_model;
		_tmp5_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp4_, &new_iter);
		if (_tmp5_) {
			CianoWidgetsSourceListDataModel* _tmp6_;
			GtkTreeIter _tmp7_;
			CianoWidgetsSourceListItem* _tmp8_;
			_tmp6_ = self->priv->data_model;
			_tmp7_ = new_iter;
			_tmp8_ = ciano_widgets_source_list_data_model_get_item (_tmp6_, &_tmp7_);
			result = _tmp8_;
			__vala_GtkTreeIter_free0 (iter);
			return result;
		}
	}
	result = NULL;
	__vala_GtkTreeIter_free0 (iter);
	return result;
}

/**
     * Gets the first visible child of an expandable item.
     *
     * @param parent Parent of the child to look up.
     * @return The first visible child of //parent//, or null if it was not found.
     * @since 0.2
     */
CianoWidgetsSourceListItem*
ciano_widgets_source_list_get_first_child (CianoWidgetsSourceList* self,
                                           CianoWidgetsSourceListExpandableItem* parent)
{
	CianoWidgetsSourceListItem* _tmp0_;
	CianoWidgetsSourceListItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	_tmp0_ = ciano_widgets_source_list_get_nth_child (self, parent, 0);
	result = _tmp0_;
	return result;
}

/**
     * Gets the last visible child of an expandable item.
     *
     * @param parent Parent of the child to look up.
     * @return The last visible child of //parent//, or null if it was not found.
     * @since 0.2
     */
CianoWidgetsSourceListItem*
ciano_widgets_source_list_get_last_child (CianoWidgetsSourceList* self,
                                          CianoWidgetsSourceListExpandableItem* parent)
{
	CianoWidgetsSourceListItem* _tmp0_;
	CianoWidgetsSourceListItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	_tmp0_ = ciano_widgets_source_list_get_nth_child (self, parent, ((gint) ciano_widgets_source_list_get_n_visible_children (self, parent)) - 1);
	result = _tmp0_;
	return result;
}

/**
     * Gets the number of visible children of an expandable item.
     *
     * @param parent Item to query.
     * @return Number of visible children of //parent//.
     * @since 0.2
     */
guint
ciano_widgets_source_list_get_n_visible_children (CianoWidgetsSourceList* self,
                                                  CianoWidgetsSourceListExpandableItem* parent)
{
	GtkTreeIter* parent_iter = NULL;
	CianoWidgetsSourceListDataModel* _tmp0_;
	GtkTreeIter* _tmp1_;
	CianoWidgetsSourceListDataModel* _tmp2_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (parent != NULL, 0U);
	_tmp0_ = self->priv->data_model;
	_tmp1_ = ciano_widgets_source_list_data_model_get_item_iter (_tmp0_, (CianoWidgetsSourceListItem*) parent);
	parent_iter = _tmp1_;
	_tmp2_ = self->priv->data_model;
	result = (guint) gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp2_, parent_iter);
	__vala_GtkTreeIter_free0 (parent_iter);
	return result;
}

static CianoWidgetsSourceListItem*
ciano_widgets_source_list_get_nth_child (CianoWidgetsSourceList* self,
                                         CianoWidgetsSourceListExpandableItem* parent,
                                         gint index)
{
	GtkTreeIter* parent_iter = NULL;
	CianoWidgetsSourceListDataModel* _tmp0_;
	GtkTreeIter* _tmp1_;
	GtkTreeIter child_iter = {0};
	CianoWidgetsSourceListDataModel* _tmp2_;
	GtkTreeIter* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_;
	CianoWidgetsSourceListItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	if (index < 0) {
		result = NULL;
		return result;
	}
	_tmp0_ = self->priv->data_model;
	_tmp1_ = ciano_widgets_source_list_data_model_get_item_iter (_tmp0_, (CianoWidgetsSourceListItem*) parent);
	parent_iter = _tmp1_;
	_tmp2_ = self->priv->data_model;
	_tmp3_ = parent_iter;
	_tmp5_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp2_, &_tmp4_, _tmp3_, index);
	child_iter = _tmp4_;
	if (_tmp5_) {
		CianoWidgetsSourceListDataModel* _tmp6_;
		GtkTreeIter _tmp7_;
		CianoWidgetsSourceListItem* _tmp8_;
		_tmp6_ = self->priv->data_model;
		_tmp7_ = child_iter;
		_tmp8_ = ciano_widgets_source_list_data_model_get_item (_tmp6_, &_tmp7_);
		result = _tmp8_;
		__vala_GtkTreeIter_free0 (parent_iter);
		return result;
	}
	result = NULL;
	__vala_GtkTreeIter_free0 (parent_iter);
	return result;
}

CianoWidgetsSourceListExpandableItem*
ciano_widgets_source_list_get_root (CianoWidgetsSourceList* self)
{
	CianoWidgetsSourceListExpandableItem* result;
	CianoWidgetsSourceListDataModel* _tmp0_;
	CianoWidgetsSourceListExpandableItem* _tmp1_;
	CianoWidgetsSourceListExpandableItem* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->data_model;
	_tmp1_ = ciano_widgets_source_list_data_model_get_root (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
ciano_widgets_source_list_set_root (CianoWidgetsSourceList* self,
                                    CianoWidgetsSourceListExpandableItem* value)
{
	CianoWidgetsSourceListDataModel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->data_model;
	ciano_widgets_source_list_data_model_set_root (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, ciano_widgets_source_list_properties[CIANO_WIDGETS_SOURCE_LIST_ROOT_PROPERTY]);
}

CianoWidgetsSourceListItem*
ciano_widgets_source_list_get_selected (CianoWidgetsSourceList* self)
{
	CianoWidgetsSourceListItem* result;
	CianoWidgetsSourceListTree* _tmp0_;
	CianoWidgetsSourceListItem* _tmp1_;
	CianoWidgetsSourceListItem* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->tree;
	_tmp1_ = ciano_widgets_source_list_tree_get_selected_item (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
ciano_widgets_source_list_set_selected (CianoWidgetsSourceList* self,
                                        CianoWidgetsSourceListItem* value)
{
	gboolean _tmp0_ = FALSE;
	CianoWidgetsSourceListTree* _tmp5_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		CianoWidgetsSourceListExpandableItem* _tmp1_;
		CianoWidgetsSourceListExpandableItem* _tmp2_;
		_tmp1_ = ciano_widgets_source_list_item_get_parent (value);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		CianoWidgetsSourceListExpandableItem* _tmp3_;
		CianoWidgetsSourceListExpandableItem* _tmp4_;
		_tmp3_ = ciano_widgets_source_list_item_get_parent (value);
		_tmp4_ = _tmp3_;
		ciano_widgets_source_list_expandable_item_expand_with_parents (_tmp4_);
	}
	_tmp5_ = self->priv->tree;
	ciano_widgets_source_list_tree_set_selected_item (_tmp5_, value);
	g_object_notify_by_pspec ((GObject *) self, ciano_widgets_source_list_properties[CIANO_WIDGETS_SOURCE_LIST_SELECTED_PROPERTY]);
}

PangoEllipsizeMode
ciano_widgets_source_list_get_ellipsize_mode (CianoWidgetsSourceList* self)
{
	PangoEllipsizeMode result;
	CianoWidgetsSourceListTree* _tmp0_;
	PangoEllipsizeMode _tmp1_;
	PangoEllipsizeMode _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->tree;
	_tmp1_ = ciano_widgets_source_list_tree_get_ellipsize_mode (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
ciano_widgets_source_list_set_ellipsize_mode (CianoWidgetsSourceList* self,
                                              PangoEllipsizeMode value)
{
	CianoWidgetsSourceListTree* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tree;
	ciano_widgets_source_list_tree_set_ellipsize_mode (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, ciano_widgets_source_list_properties[CIANO_WIDGETS_SOURCE_LIST_ELLIPSIZE_MODE_PROPERTY]);
}

gboolean
ciano_widgets_source_list_get_editing (CianoWidgetsSourceList* self)
{
	gboolean result;
	CianoWidgetsSourceListTree* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->tree;
	_tmp1_ = ciano_widgets_source_list_tree_get_editing (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

GtkSortType
ciano_widgets_source_list_get_sort_direction (CianoWidgetsSourceList* self)
{
	GtkSortType result;
	g_return_val_if_fail (self != NULL, 0);
	result = GTK_SORT_ASCENDING;
	return result;
}

void
ciano_widgets_source_list_set_sort_direction (CianoWidgetsSourceList* self,
                                              GtkSortType value)
{
	g_return_if_fail (self != NULL);
	g_warning ("SourceList.vala:2615: sort_direction is deprecated and no longer used");
	g_object_notify_by_pspec ((GObject *) self, ciano_widgets_source_list_properties[CIANO_WIDGETS_SOURCE_LIST_SORT_DIRECTION_PROPERTY]);
}

static void
ciano_widgets_source_list_real_item_selected (CianoWidgetsSourceList* self,
                                              CianoWidgetsSourceListItem* item)
{
}

static inline gpointer
ciano_widgets_source_list_item_get_instance_private (CianoWidgetsSourceListItem* self)
{
	return G_STRUCT_MEMBER_P (self, CianoWidgetsSourceListItem_private_offset);
}

/**
         * Creates a new {@link Granite.Widgets.SourceList.Item}.
         *
         * @param name Name of the item.
         * @return (transfer full) A new {@link Granite.Widgets.SourceList.Item}.
         * @since 0.2
         */
CianoWidgetsSourceListItem*
ciano_widgets_source_list_item_construct (GType object_type,
                                          const gchar* name)
{
	CianoWidgetsSourceListItem * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (CianoWidgetsSourceListItem*) g_object_new (object_type, NULL);
	ciano_widgets_source_list_item_set_name (self, name);
	return self;
}

CianoWidgetsSourceListItem*
ciano_widgets_source_list_item_new (const gchar* name)
{
	return ciano_widgets_source_list_item_construct (CIANO_WIDGETS_SOURCE_LIST_TYPE_ITEM, name);
}

/**
         * Invoked when the item is secondary-clicked or when the usual menu keys are pressed.
         *
         * @return A {@link Gtk.Menu} or //null// if nothing should be displayed.
         * @since 0.2
         */
static GtkMenu*
ciano_widgets_source_list_item_real_get_context_menu (CianoWidgetsSourceListItem* self)
{
	GtkMenu* result;
	result = NULL;
	return result;
}

GtkMenu*
ciano_widgets_source_list_item_get_context_menu (CianoWidgetsSourceListItem* self)
{
	CianoWidgetsSourceListItemClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = CIANO_WIDGETS_SOURCE_LIST_ITEM_GET_CLASS (self);
	if (_klass_->get_context_menu) {
		return _klass_->get_context_menu (self);
	}
	return NULL;
}

CianoWidgetsSourceListExpandableItem*
ciano_widgets_source_list_item_get_parent (CianoWidgetsSourceListItem* self)
{
	CianoWidgetsSourceListExpandableItem* result;
	CianoWidgetsSourceListExpandableItem* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_parent;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
ciano_widgets_source_list_item_set_parent (CianoWidgetsSourceListItem* self,
                                           CianoWidgetsSourceListExpandableItem* value)
{
	CianoWidgetsSourceListExpandableItem* old_value;
	g_return_if_fail (self != NULL);
	old_value = ciano_widgets_source_list_item_get_parent (self);
	if (old_value != value) {
		CianoWidgetsSourceListExpandableItem* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_parent);
		self->priv->_parent = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, ciano_widgets_source_list_item_properties[CIANO_WIDGETS_SOURCE_LIST_ITEM_PARENT_PROPERTY]);
	}
}

const gchar*
ciano_widgets_source_list_item_get_name (CianoWidgetsSourceListItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

void
ciano_widgets_source_list_item_set_name (CianoWidgetsSourceListItem* self,
                                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = ciano_widgets_source_list_item_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, ciano_widgets_source_list_item_properties[CIANO_WIDGETS_SOURCE_LIST_ITEM_NAME_PROPERTY]);
	}
}

const gchar*
ciano_widgets_source_list_item_get_badge (CianoWidgetsSourceListItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_badge;
	result = _tmp0_;
	return result;
}

void
ciano_widgets_source_list_item_set_badge (CianoWidgetsSourceListItem* self,
                                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = ciano_widgets_source_list_item_get_badge (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_badge);
		self->priv->_badge = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, ciano_widgets_source_list_item_properties[CIANO_WIDGETS_SOURCE_LIST_ITEM_BADGE_PROPERTY]);
	}
}

gboolean
ciano_widgets_source_list_item_get_editable (CianoWidgetsSourceListItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_editable;
	return result;
}

void
ciano_widgets_source_list_item_set_editable (CianoWidgetsSourceListItem* self,
                                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = ciano_widgets_source_list_item_get_editable (self);
	if (old_value != value) {
		self->priv->_editable = value;
		g_object_notify_by_pspec ((GObject *) self, ciano_widgets_source_list_item_properties[CIANO_WIDGETS_SOURCE_LIST_ITEM_EDITABLE_PROPERTY]);
	}
}

gboolean
ciano_widgets_source_list_item_get_visible (CianoWidgetsSourceListItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_visible;
	return result;
}

void
ciano_widgets_source_list_item_set_visible (CianoWidgetsSourceListItem* self,
                                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = ciano_widgets_source_list_item_get_visible (self);
	if (old_value != value) {
		self->priv->_visible = value;
		g_object_notify_by_pspec ((GObject *) self, ciano_widgets_source_list_item_properties[CIANO_WIDGETS_SOURCE_LIST_ITEM_VISIBLE_PROPERTY]);
	}
}

gboolean
ciano_widgets_source_list_item_get_selectable (CianoWidgetsSourceListItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_selectable;
	return result;
}

void
ciano_widgets_source_list_item_set_selectable (CianoWidgetsSourceListItem* self,
                                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = ciano_widgets_source_list_item_get_selectable (self);
	if (old_value != value) {
		self->priv->_selectable = value;
		g_object_notify_by_pspec ((GObject *) self, ciano_widgets_source_list_item_properties[CIANO_WIDGETS_SOURCE_LIST_ITEM_SELECTABLE_PROPERTY]);
	}
}

GIcon*
ciano_widgets_source_list_item_get_icon (CianoWidgetsSourceListItem* self)
{
	GIcon* result;
	GIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon;
	result = _tmp0_;
	return result;
}

void
ciano_widgets_source_list_item_set_icon (CianoWidgetsSourceListItem* self,
                                         GIcon* value)
{
	GIcon* old_value;
	g_return_if_fail (self != NULL);
	old_value = ciano_widgets_source_list_item_get_icon (self);
	if (old_value != value) {
		GIcon* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_icon);
		self->priv->_icon = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, ciano_widgets_source_list_item_properties[CIANO_WIDGETS_SOURCE_LIST_ITEM_ICON_PROPERTY]);
	}
}

GIcon*
ciano_widgets_source_list_item_get_activatable (CianoWidgetsSourceListItem* self)
{
	GIcon* result;
	GIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_activatable;
	result = _tmp0_;
	return result;
}

void
ciano_widgets_source_list_item_set_activatable (CianoWidgetsSourceListItem* self,
                                                GIcon* value)
{
	GIcon* old_value;
	g_return_if_fail (self != NULL);
	old_value = ciano_widgets_source_list_item_get_activatable (self);
	if (old_value != value) {
		GIcon* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_activatable);
		self->priv->_activatable = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, ciano_widgets_source_list_item_properties[CIANO_WIDGETS_SOURCE_LIST_ITEM_ACTIVATABLE_PROPERTY]);
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
ciano_widgets_source_list_item_real_edited (CianoWidgetsSourceListItem* self,
                                            const gchar* new_name)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	g_return_if_fail (new_name != NULL);
	_tmp1_ = self->priv->_editable;
	if (_tmp1_) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = string_strip (new_name);
		_tmp3_ = _tmp2_;
		_tmp0_ = g_strcmp0 (_tmp3_, "") != 0;
		_g_free0 (_tmp3_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ciano_widgets_source_list_item_set_name (self, new_name);
	}
}

static void
ciano_widgets_source_list_item_real_action_activated (CianoWidgetsSourceListItem* self)
{
}

static void
ciano_widgets_source_list_item_real_activated (CianoWidgetsSourceListItem* self)
{
}

static void
ciano_widgets_source_list_item_class_init (CianoWidgetsSourceListItemClass * klass,
                                           gpointer klass_data)
{
	ciano_widgets_source_list_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CianoWidgetsSourceListItem_private_offset);
	((CianoWidgetsSourceListItemClass *) klass)->get_context_menu = (GtkMenu* (*) (CianoWidgetsSourceListItem*)) ciano_widgets_source_list_item_real_get_context_menu;
	((CianoWidgetsSourceListItemClass *) klass)->edited = ciano_widgets_source_list_item_real_edited;
	((CianoWidgetsSourceListItemClass *) klass)->action_activated = ciano_widgets_source_list_item_real_action_activated;
	((CianoWidgetsSourceListItemClass *) klass)->activated = ciano_widgets_source_list_item_real_activated;
	G_OBJECT_CLASS (klass)->get_property = _vala_ciano_widgets_source_list_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_ciano_widgets_source_list_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = ciano_widgets_source_list_item_finalize;
	/**
	         * Parent {@link Granite.Widgets.SourceList.ExpandableItem} of the item.
	         * ''Must not'' be modified.
	         *
	         * @since 0.2
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CIANO_WIDGETS_SOURCE_LIST_ITEM_PARENT_PROPERTY, ciano_widgets_source_list_item_properties[CIANO_WIDGETS_SOURCE_LIST_ITEM_PARENT_PROPERTY] = g_param_spec_object ("parent", "parent", "parent", CIANO_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * The item's name. Primary and most important information.
	         *
	         * @since 0.2
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CIANO_WIDGETS_SOURCE_LIST_ITEM_NAME_PROPERTY, ciano_widgets_source_list_item_properties[CIANO_WIDGETS_SOURCE_LIST_ITEM_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * A badge shown next to the item's name.
	         *
	         * It can be used for displaying the number of unread messages in the "Inbox" item,
	         * for instance.
	         *
	         * @since 0.2
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CIANO_WIDGETS_SOURCE_LIST_ITEM_BADGE_PROPERTY, ciano_widgets_source_list_item_properties[CIANO_WIDGETS_SOURCE_LIST_ITEM_BADGE_PROPERTY] = g_param_spec_string ("badge", "badge", "badge", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Whether the item's name can be edited from within the source list.
	         *
	         * When this property is set to //true//, users can edit the item by pressing
	         * the F2 key, or by double-clicking its name.
	         *
	         * ''This property only works for selectable items''.
	         *
	         * @see Granite.Widgets.SourceList.Item.selectable
	         * @see Granite.Widgets.SourceList.start_editing_item
	         * @since 0.2
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CIANO_WIDGETS_SOURCE_LIST_ITEM_EDITABLE_PROPERTY, ciano_widgets_source_list_item_properties[CIANO_WIDGETS_SOURCE_LIST_ITEM_EDITABLE_PROPERTY] = g_param_spec_boolean ("editable", "editable", "editable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Whether the item should appear in the source list's tree or not.
	         *
	         * @since 0.2
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CIANO_WIDGETS_SOURCE_LIST_ITEM_VISIBLE_PROPERTY, ciano_widgets_source_list_item_properties[CIANO_WIDGETS_SOURCE_LIST_ITEM_VISIBLE_PROPERTY] = g_param_spec_boolean ("visible", "visible", "visible", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Whether the item can be selected or not.
	         *
	         * Setting this property to true doesn't guarantee that the item will actually be
	         * selectable, since there are other external factors to take into account, like the
	         * item's {@link Granite.Widgets.SourceList.Item.visible} property; whether the item is
	         * a category; the parent item is collapsed, etc.
	         *
	         * @see Granite.Widgets.SourceList.Item.visible
	         * @since 0.2
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CIANO_WIDGETS_SOURCE_LIST_ITEM_SELECTABLE_PROPERTY, ciano_widgets_source_list_item_properties[CIANO_WIDGETS_SOURCE_LIST_ITEM_SELECTABLE_PROPERTY] = g_param_spec_boolean ("selectable", "selectable", "selectable", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Primary icon.
	         *
	         * This property should be used to give the user an idea of what the item represents
	         * (i.e. content type.)
	         *
	         * @since 0.2
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CIANO_WIDGETS_SOURCE_LIST_ITEM_ICON_PROPERTY, ciano_widgets_source_list_item_properties[CIANO_WIDGETS_SOURCE_LIST_ITEM_ICON_PROPERTY] = g_param_spec_object ("icon", "icon", "icon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * An activatable icon that works like a button.
	         *
	         * It can be used for e.g. showing an //"eject"// icon on a device's item.
	         *
	         * @see Granite.Widgets.SourceList.Item.action_activated
	         * @since 0.2
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CIANO_WIDGETS_SOURCE_LIST_ITEM_ACTIVATABLE_PROPERTY, ciano_widgets_source_list_item_properties[CIANO_WIDGETS_SOURCE_LIST_ITEM_ACTIVATABLE_PROPERTY] = g_param_spec_object ("activatable", "activatable", "activatable", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Emitted when the user has finished editing the item's name.
	         *
	         * By default, if the name doesn't consist of white space, it is automatically assigned
	         * to the {@link Granite.Widgets.SourceList.Item.name} property. The default behavior can
	         * be changed by overriding this signal.
	         * @param new_name The item's new name (result of editing.)
	         * @since 0.2
	         */
	ciano_widgets_source_list_item_signals[CIANO_WIDGETS_SOURCE_LIST_ITEM_EDITED_SIGNAL] = g_signal_new ("edited", CIANO_WIDGETS_SOURCE_LIST_TYPE_ITEM, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (CianoWidgetsSourceListItemClass, edited), NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	/**
	         * The {@link Granite.Widgets.SourceList.Item.activatable} icon was activated.
	         *
	         * @see Granite.Widgets.SourceList.Item.activatable
	         * @since 0.2
	         */
	ciano_widgets_source_list_item_signals[CIANO_WIDGETS_SOURCE_LIST_ITEM_ACTION_ACTIVATED_SIGNAL] = g_signal_new ("action-activated", CIANO_WIDGETS_SOURCE_LIST_TYPE_ITEM, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (CianoWidgetsSourceListItemClass, action_activated), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	         * Emitted when the item is double-clicked or when it is selected and one of the keys:
	         * Space, Shift+Space, Return or Enter is pressed. This signal is //also// for
	         * editable items.
	         *
	         * @since 0.2
	         */
	ciano_widgets_source_list_item_signals[CIANO_WIDGETS_SOURCE_LIST_ITEM_ACTIVATED_SIGNAL] = g_signal_new ("activated", CIANO_WIDGETS_SOURCE_LIST_TYPE_ITEM, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (CianoWidgetsSourceListItemClass, activated), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
ciano_widgets_source_list_item_instance_init (CianoWidgetsSourceListItem * self,
                                              gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = ciano_widgets_source_list_item_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_name = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_badge = _tmp1_;
	self->priv->_editable = FALSE;
	self->priv->_visible = TRUE;
	self->priv->_selectable = TRUE;
}

static void
ciano_widgets_source_list_item_finalize (GObject * obj)
{
	CianoWidgetsSourceListItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CIANO_WIDGETS_SOURCE_LIST_TYPE_ITEM, CianoWidgetsSourceListItem);
	_g_object_unref0 (self->priv->_parent);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_badge);
	_g_object_unref0 (self->priv->_icon);
	_g_object_unref0 (self->priv->_activatable);
	G_OBJECT_CLASS (ciano_widgets_source_list_item_parent_class)->finalize (obj);
}

/**
     * A source list entry.
     *
     * Any change made to any of its properties will be ''automatically'' reflected
     * by the {@link Granite.Widgets.SourceList} widget.
     *
     * @since 0.2
     */
static GType
ciano_widgets_source_list_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CianoWidgetsSourceListItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ciano_widgets_source_list_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CianoWidgetsSourceListItem), 0, (GInstanceInitFunc) ciano_widgets_source_list_item_instance_init, NULL };
	GType ciano_widgets_source_list_item_type_id;
	ciano_widgets_source_list_item_type_id = g_type_register_static (G_TYPE_OBJECT, "CianoWidgetsSourceListItem", &g_define_type_info, 0);
	CianoWidgetsSourceListItem_private_offset = g_type_add_instance_private (ciano_widgets_source_list_item_type_id, sizeof (CianoWidgetsSourceListItemPrivate));
	return ciano_widgets_source_list_item_type_id;
}

GType
ciano_widgets_source_list_item_get_type (void)
{
	static volatile gsize ciano_widgets_source_list_item_type_id__once = 0;
	if (g_once_init_enter (&ciano_widgets_source_list_item_type_id__once)) {
		GType ciano_widgets_source_list_item_type_id;
		ciano_widgets_source_list_item_type_id = ciano_widgets_source_list_item_get_type_once ();
		g_once_init_leave (&ciano_widgets_source_list_item_type_id__once, ciano_widgets_source_list_item_type_id);
	}
	return ciano_widgets_source_list_item_type_id__once;
}

static void
_vala_ciano_widgets_source_list_item_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec)
{
	CianoWidgetsSourceListItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CIANO_WIDGETS_SOURCE_LIST_TYPE_ITEM, CianoWidgetsSourceListItem);
	switch (property_id) {
		case CIANO_WIDGETS_SOURCE_LIST_ITEM_PARENT_PROPERTY:
		g_value_set_object (value, ciano_widgets_source_list_item_get_parent (self));
		break;
		case CIANO_WIDGETS_SOURCE_LIST_ITEM_NAME_PROPERTY:
		g_value_set_string (value, ciano_widgets_source_list_item_get_name (self));
		break;
		case CIANO_WIDGETS_SOURCE_LIST_ITEM_BADGE_PROPERTY:
		g_value_set_string (value, ciano_widgets_source_list_item_get_badge (self));
		break;
		case CIANO_WIDGETS_SOURCE_LIST_ITEM_EDITABLE_PROPERTY:
		g_value_set_boolean (value, ciano_widgets_source_list_item_get_editable (self));
		break;
		case CIANO_WIDGETS_SOURCE_LIST_ITEM_VISIBLE_PROPERTY:
		g_value_set_boolean (value, ciano_widgets_source_list_item_get_visible (self));
		break;
		case CIANO_WIDGETS_SOURCE_LIST_ITEM_SELECTABLE_PROPERTY:
		g_value_set_boolean (value, ciano_widgets_source_list_item_get_selectable (self));
		break;
		case CIANO_WIDGETS_SOURCE_LIST_ITEM_ICON_PROPERTY:
		g_value_set_object (value, ciano_widgets_source_list_item_get_icon (self));
		break;
		case CIANO_WIDGETS_SOURCE_LIST_ITEM_ACTIVATABLE_PROPERTY:
		g_value_set_object (value, ciano_widgets_source_list_item_get_activatable (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_ciano_widgets_source_list_item_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec)
{
	CianoWidgetsSourceListItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CIANO_WIDGETS_SOURCE_LIST_TYPE_ITEM, CianoWidgetsSourceListItem);
	switch (property_id) {
		case CIANO_WIDGETS_SOURCE_LIST_ITEM_PARENT_PROPERTY:
		ciano_widgets_source_list_item_set_parent (self, g_value_get_object (value));
		break;
		case CIANO_WIDGETS_SOURCE_LIST_ITEM_NAME_PROPERTY:
		ciano_widgets_source_list_item_set_name (self, g_value_get_string (value));
		break;
		case CIANO_WIDGETS_SOURCE_LIST_ITEM_BADGE_PROPERTY:
		ciano_widgets_source_list_item_set_badge (self, g_value_get_string (value));
		break;
		case CIANO_WIDGETS_SOURCE_LIST_ITEM_EDITABLE_PROPERTY:
		ciano_widgets_source_list_item_set_editable (self, g_value_get_boolean (value));
		break;
		case CIANO_WIDGETS_SOURCE_LIST_ITEM_VISIBLE_PROPERTY:
		ciano_widgets_source_list_item_set_visible (self, g_value_get_boolean (value));
		break;
		case CIANO_WIDGETS_SOURCE_LIST_ITEM_SELECTABLE_PROPERTY:
		ciano_widgets_source_list_item_set_selectable (self, g_value_get_boolean (value));
		break;
		case CIANO_WIDGETS_SOURCE_LIST_ITEM_ICON_PROPERTY:
		ciano_widgets_source_list_item_set_icon (self, g_value_get_object (value));
		break;
		case CIANO_WIDGETS_SOURCE_LIST_ITEM_ACTIVATABLE_PROPERTY:
		ciano_widgets_source_list_item_set_activatable (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
ciano_widgets_source_list_expandable_item_get_instance_private (CianoWidgetsSourceListExpandableItem* self)
{
	return G_STRUCT_MEMBER_P (self, CianoWidgetsSourceListExpandableItem_private_offset);
}

/**
         * Creates a new {@link Granite.Widgets.SourceList.ExpandableItem}
         *
         * @param name Title of the item.
         * @return (transfer full) A new {@link Granite.Widgets.SourceList.ExpandableItem}.
         * @since 0.2
         */
CianoWidgetsSourceListExpandableItem*
ciano_widgets_source_list_expandable_item_construct (GType object_type,
                                                     const gchar* name)
{
	CianoWidgetsSourceListExpandableItem * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (CianoWidgetsSourceListExpandableItem*) ciano_widgets_source_list_item_construct (object_type, name);
	ciano_widgets_source_list_item_set_editable ((CianoWidgetsSourceListItem*) self, FALSE);
	return self;
}

CianoWidgetsSourceListExpandableItem*
ciano_widgets_source_list_expandable_item_new (const gchar* name)
{
	return ciano_widgets_source_list_expandable_item_construct (CIANO_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, name);
}

/**
         * Checks whether the item contains the specified child.
         *
         * This method only considers the item's immediate children.
         *
         * @param item Item to search.
         * @return Whether the item was found or not.
         * @since 0.2
         */
gboolean
ciano_widgets_source_list_expandable_item_contains (CianoWidgetsSourceListExpandableItem* self,
                                                    CianoWidgetsSourceListItem* item)
{
	GeeCollection* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp0_ = self->priv->children_list;
	result = gee_collection_contains (_tmp0_, item);
	return result;
}

/**
         * Adds an item.
         *
         * {@link Granite.Widgets.SourceList.ExpandableItem.child_added} is fired after the item is added.
         *
         * While adding a child item, //the item it's being added to will set itself as the parent//.
         * Please note that items are required to have their //parent// property set to //null// before
         * being added, so make sure the item is removed from its previous parent before attempting
         * to add it to another item. For instance:
         * {{{
         * if (item.parent != null)
         *     item.parent.remove (item); // this will set item's parent to null
         * new_parent.add (item);
         * }}}
         *
         * @param item The item to add. Its parent __must__ be //null//.
         * @see Granite.Widgets.SourceList.ExpandableItem.child_added
         * @see Granite.Widgets.SourceList.ExpandableItem.remove
         * @since 0.2
         */
void
ciano_widgets_source_list_expandable_item_add (CianoWidgetsSourceListExpandableItem* self,
                                               CianoWidgetsSourceListItem* item)
{
	CianoWidgetsSourceListExpandableItem* _tmp0_;
	CianoWidgetsSourceListExpandableItem* _tmp1_;
	GeeCollection* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = ciano_widgets_source_list_item_get_parent (item);
	_tmp1_ = _tmp0_;
	_vala_return_if_fail (_tmp1_ == NULL, "item.parent == null");
	ciano_widgets_source_list_item_set_parent (item, self);
	_tmp2_ = self->priv->children_list;
	gee_collection_add (_tmp2_, item);
	g_signal_emit (self, ciano_widgets_source_list_expandable_item_signals[CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_CHILD_ADDED_SIGNAL], 0, item);
}

/**
         * Removes an item.
         *
         * The {@link Granite.Widgets.SourceList.ExpandableItem.child_removed} signal is fired
         * //after removing the item//. Finally (i.e. after all the handlers have been invoked),
         * the item's {@link Granite.Widgets.SourceList.Item.parent} property is set to //null//.
         * This has the advantage of letting signal handlers know the parent from which //item//
         * is being removed.
         *
         * @param item The item to remove. This will fail if item has a different parent.
         * @see Granite.Widgets.SourceList.ExpandableItem.child_removed
         * @see Granite.Widgets.SourceList.ExpandableItem.clear
         * @since 0.2
         */
void
ciano_widgets_source_list_expandable_item_remove (CianoWidgetsSourceListExpandableItem* self,
                                                  CianoWidgetsSourceListItem* item)
{
	CianoWidgetsSourceListExpandableItem* _tmp0_;
	CianoWidgetsSourceListExpandableItem* _tmp1_;
	GeeCollection* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = ciano_widgets_source_list_item_get_parent (item);
	_tmp1_ = _tmp0_;
	_vala_return_if_fail (_tmp1_ == self, "item.parent == this");
	_tmp2_ = self->priv->children_list;
	gee_collection_remove (_tmp2_, item);
	g_signal_emit (self, ciano_widgets_source_list_expandable_item_signals[CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_CHILD_REMOVED_SIGNAL], 0, item);
	ciano_widgets_source_list_item_set_parent (item, NULL);
}

/**
         * Removes all the items contained by the item. It works similarly to
         * {@link Granite.Widgets.SourceList.ExpandableItem.remove}.
         *
         * @see Granite.Widgets.SourceList.ExpandableItem.remove
         * @see Granite.Widgets.SourceList.ExpandableItem.child_removed
         * @since 0.2
         */
void
ciano_widgets_source_list_expandable_item_clear (CianoWidgetsSourceListExpandableItem* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _item_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = ciano_widgets_source_list_expandable_item_get_children (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_item_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			CianoWidgetsSourceListItem* item = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			CianoWidgetsSourceListItem* _tmp8_;
			_tmp5_ = _item_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _item_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			item = (CianoWidgetsSourceListItem*) _tmp7_;
			_tmp8_ = item;
			ciano_widgets_source_list_expandable_item_remove (self, _tmp8_);
			_g_object_unref0 (item);
		}
		_g_object_unref0 (_item_it);
	}
}

/**
         * Expands the item and/or its children.
         *
         * @param inclusive Whether to also expand this item (true), or only its children (false).
         * @param recursive Whether to recursively expand all the children (true), or only
         * immediate children (false).
         * @see Granite.Widgets.SourceList.ExpandableItem.expanded
         * @since 0.2
         */
void
ciano_widgets_source_list_expandable_item_expand_all (CianoWidgetsSourceListExpandableItem* self,
                                                      gboolean inclusive,
                                                      gboolean recursive)
{
	g_return_if_fail (self != NULL);
	ciano_widgets_source_list_expandable_item_set_expansion (self, inclusive, recursive, TRUE);
}

/**
         * Collapses the item and/or its children.
         *
         * @param inclusive Whether to also collapse this item (true), or only its children (false).
         * @param recursive Whether to recursively collapse all the children (true), or only
         * immediate children (false).
         * @see Granite.Widgets.SourceList.ExpandableItem.expanded
         * @since 0.2
         */
void
ciano_widgets_source_list_expandable_item_collapse_all (CianoWidgetsSourceListExpandableItem* self,
                                                        gboolean inclusive,
                                                        gboolean recursive)
{
	g_return_if_fail (self != NULL);
	ciano_widgets_source_list_expandable_item_set_expansion (self, inclusive, recursive, FALSE);
}

static void
ciano_widgets_source_list_expandable_item_set_expansion (CianoWidgetsSourceListExpandableItem* item,
                                                         gboolean inclusive,
                                                         gboolean recursive,
                                                         gboolean expanded)
{
	g_return_if_fail (item != NULL);
	if (inclusive) {
		ciano_widgets_source_list_expandable_item_set_expanded (item, expanded);
	}
	{
		GeeIterator* _child_item_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = ciano_widgets_source_list_expandable_item_get_children (item);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_child_item_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			CianoWidgetsSourceListItem* child_item = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			CianoWidgetsSourceListExpandableItem* child_expandable_item = NULL;
			CianoWidgetsSourceListItem* _tmp8_;
			CianoWidgetsSourceListExpandableItem* _tmp9_;
			CianoWidgetsSourceListExpandableItem* _tmp10_;
			_tmp5_ = _child_item_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _child_item_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			child_item = (CianoWidgetsSourceListItem*) _tmp7_;
			_tmp8_ = child_item;
			_tmp9_ = _g_object_ref0 (CIANO_WIDGETS_SOURCE_LIST_IS_EXPANDABLE_ITEM (_tmp8_) ? ((CianoWidgetsSourceListExpandableItem*) _tmp8_) : NULL);
			child_expandable_item = _tmp9_;
			_tmp10_ = child_expandable_item;
			if (_tmp10_ != NULL) {
				if (recursive) {
					CianoWidgetsSourceListExpandableItem* _tmp11_;
					_tmp11_ = child_expandable_item;
					ciano_widgets_source_list_expandable_item_set_expansion (_tmp11_, TRUE, TRUE, expanded);
				} else {
					CianoWidgetsSourceListExpandableItem* _tmp12_;
					_tmp12_ = child_expandable_item;
					ciano_widgets_source_list_expandable_item_set_expanded (_tmp12_, expanded);
				}
			}
			_g_object_unref0 (child_expandable_item);
			_g_object_unref0 (child_item);
		}
		_g_object_unref0 (_child_item_it);
	}
}

/**
         * Recursively expands the item along with its parent(s).
         *
         * @see Granite.Widgets.SourceList.ExpandableItem.expanded
         * @since 0.2
         */
void
ciano_widgets_source_list_expandable_item_expand_with_parents (CianoWidgetsSourceListExpandableItem* self)
{
	CianoWidgetsSourceListExpandableItem* _tmp0_;
	CianoWidgetsSourceListExpandableItem* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ciano_widgets_source_list_item_get_parent ((CianoWidgetsSourceListItem*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		CianoWidgetsSourceListExpandableItem* _tmp2_;
		CianoWidgetsSourceListExpandableItem* _tmp3_;
		_tmp2_ = ciano_widgets_source_list_item_get_parent ((CianoWidgetsSourceListItem*) self);
		_tmp3_ = _tmp2_;
		ciano_widgets_source_list_expandable_item_expand_with_parents (_tmp3_);
	}
	ciano_widgets_source_list_expandable_item_set_expanded (self, TRUE);
}

/**
         * Recursively collapses the item along with its parent(s).
         *
         * @see Granite.Widgets.SourceList.ExpandableItem.expanded
         * @since 0.2
         */
void
ciano_widgets_source_list_expandable_item_collapse_with_parents (CianoWidgetsSourceListExpandableItem* self)
{
	CianoWidgetsSourceListExpandableItem* _tmp0_;
	CianoWidgetsSourceListExpandableItem* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ciano_widgets_source_list_item_get_parent ((CianoWidgetsSourceListItem*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		CianoWidgetsSourceListExpandableItem* _tmp2_;
		CianoWidgetsSourceListExpandableItem* _tmp3_;
		_tmp2_ = ciano_widgets_source_list_item_get_parent ((CianoWidgetsSourceListItem*) self);
		_tmp3_ = _tmp2_;
		ciano_widgets_source_list_expandable_item_collapse_with_parents (_tmp3_);
	}
	ciano_widgets_source_list_expandable_item_set_expanded (self, FALSE);
}

gboolean
ciano_widgets_source_list_expandable_item_get_collapsible (CianoWidgetsSourceListExpandableItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_collapsible;
	return result;
}

void
ciano_widgets_source_list_expandable_item_set_collapsible (CianoWidgetsSourceListExpandableItem* self,
                                                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = ciano_widgets_source_list_expandable_item_get_collapsible (self);
	if (old_value != value) {
		self->priv->_collapsible = value;
		g_object_notify_by_pspec ((GObject *) self, ciano_widgets_source_list_expandable_item_properties[CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_COLLAPSIBLE_PROPERTY]);
	}
}

gboolean
ciano_widgets_source_list_expandable_item_get_expanded (CianoWidgetsSourceListExpandableItem* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_expanded) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_;
		_tmp1_ = self->priv->_collapsible;
		_tmp0_ = !_tmp1_;
	}
	result = _tmp0_;
	return result;
}

void
ciano_widgets_source_list_expandable_item_set_expanded (CianoWidgetsSourceListExpandableItem* self,
                                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	if (value != self->priv->_expanded) {
		self->priv->_expanded = value;
		g_signal_emit (self, ciano_widgets_source_list_expandable_item_signals[CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_TOGGLED_SIGNAL], 0);
	}
	g_object_notify_by_pspec ((GObject *) self, ciano_widgets_source_list_expandable_item_properties[CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_EXPANDED_PROPERTY]);
}

guint
ciano_widgets_source_list_expandable_item_get_n_children (CianoWidgetsSourceListExpandableItem* self)
{
	guint result;
	GeeCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->children_list;
	_tmp1_ = gee_collection_get_size (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (guint) _tmp2_;
	return result;
}

GeeCollection*
ciano_widgets_source_list_expandable_item_get_children (CianoWidgetsSourceListExpandableItem* self)
{
	GeeCollection* result;
	GeeArrayList* children_list_copy = NULL;
	GeeArrayList* _tmp0_;
	GeeCollection* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (CIANO_WIDGETS_SOURCE_LIST_TYPE_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	children_list_copy = _tmp0_;
	_tmp1_ = self->priv->children_list;
	gee_array_list_add_all (children_list_copy, _tmp1_);
	result = (GeeCollection*) children_list_copy;
	return result;
}

static void
ciano_widgets_source_list_expandable_item_real_toggled (CianoWidgetsSourceListExpandableItem* self)
{
}

static void
ciano_widgets_source_list_expandable_item_class_init (CianoWidgetsSourceListExpandableItemClass * klass,
                                                      gpointer klass_data)
{
	ciano_widgets_source_list_expandable_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CianoWidgetsSourceListExpandableItem_private_offset);
	((CianoWidgetsSourceListExpandableItemClass *) klass)->toggled = ciano_widgets_source_list_expandable_item_real_toggled;
	G_OBJECT_CLASS (klass)->get_property = _vala_ciano_widgets_source_list_expandable_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_ciano_widgets_source_list_expandable_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = ciano_widgets_source_list_expandable_item_finalize;
	/**
	         * Whether the item is collapsible or not.
	         *
	         * When set to //false//, the item is //always// expanded and the expander is
	         * not shown. Please note that this will also affect the value returned by the
	         * {@link Granite.Widgets.SourceList.ExpandableItem.expanded} property.
	         *
	         * @see Granite.Widgets.SourceList.ExpandableItem.expanded
	         * @since 0.2
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_COLLAPSIBLE_PROPERTY, ciano_widgets_source_list_expandable_item_properties[CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_COLLAPSIBLE_PROPERTY] = g_param_spec_boolean ("collapsible", "collapsible", "collapsible", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_EXPANDED_PROPERTY, ciano_widgets_source_list_expandable_item_properties[CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_EXPANDED_PROPERTY] = g_param_spec_boolean ("expanded", "expanded", "expanded", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Number of children contained by the item.
	         *
	         * @since 0.2
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_N_CHILDREN_PROPERTY, ciano_widgets_source_list_expandable_item_properties[CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_N_CHILDREN_PROPERTY] = g_param_spec_uint ("n-children", "n-children", "n-children", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	         * The item's children.
	         *
	         * This returns a newly-created list containing the children.
	         * It's safe to iterate it while removing items with
	         * {@link Granite.Widgets.SourceList.ExpandableItem.remove}
	         *
	         * @since 0.2
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_CHILDREN_PROPERTY, ciano_widgets_source_list_expandable_item_properties[CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_CHILDREN_PROPERTY] = g_param_spec_object ("children", "children", "children", GEE_TYPE_COLLECTION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	         * Emitted when an item is added.
	         *
	         * @param item Item added.
	         * @see Granite.Widgets.SourceList.ExpandableItem.add
	         * @since 0.2
	         */
	ciano_widgets_source_list_expandable_item_signals[CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_CHILD_ADDED_SIGNAL] = g_signal_new ("child-added", CIANO_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, CIANO_WIDGETS_SOURCE_LIST_TYPE_ITEM);
	/**
	         * Emitted when an item is removed.
	         *
	         * @param item Item removed.
	         * @see Granite.Widgets.SourceList.ExpandableItem.remove
	         * @since 0.2
	         */
	ciano_widgets_source_list_expandable_item_signals[CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_CHILD_REMOVED_SIGNAL] = g_signal_new ("child-removed", CIANO_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, CIANO_WIDGETS_SOURCE_LIST_TYPE_ITEM);
	/**
	         * Emitted when the item is expanded or collapsed.
	         *
	         * @since 0.2
	         */
	ciano_widgets_source_list_expandable_item_signals[CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_TOGGLED_SIGNAL] = g_signal_new ("toggled", CIANO_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (CianoWidgetsSourceListExpandableItemClass, toggled), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
ciano_widgets_source_list_expandable_item_instance_init (CianoWidgetsSourceListExpandableItem * self,
                                                         gpointer klass)
{
	GeeArrayList* _tmp0_;
	self->priv = ciano_widgets_source_list_expandable_item_get_instance_private (self);
	self->priv->_collapsible = TRUE;
	self->priv->_expanded = FALSE;
	_tmp0_ = gee_array_list_new (CIANO_WIDGETS_SOURCE_LIST_TYPE_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->children_list = (GeeCollection*) _tmp0_;
}

static void
ciano_widgets_source_list_expandable_item_finalize (GObject * obj)
{
	CianoWidgetsSourceListExpandableItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CIANO_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, CianoWidgetsSourceListExpandableItem);
	_g_object_unref0 (self->priv->children_list);
	G_OBJECT_CLASS (ciano_widgets_source_list_expandable_item_parent_class)->finalize (obj);
}

/**
     * An item that can contain more items.
     *
     * It supports all the properties inherited from {@link Granite.Widgets.SourceList.Item},
     * and behaves like a normal item, except when it is located at the root level; in that case,
     * the following properties are ignored by the widget:
     *
     * * {@link Granite.Widgets.SourceList.Item.selectable}
     * * {@link Granite.Widgets.SourceList.Item.editable}
     * * {@link Granite.Widgets.SourceList.Item.icon}
     * * {@link Granite.Widgets.SourceList.Item.activatable}
     * * {@link Granite.Widgets.SourceList.Item.badge}
     *
     * Root-level expandable items (i.e. Main Categories) are ''not'' displayed when they contain
     * zero visible children.
     *
     * @since 0.2
     */
static GType
ciano_widgets_source_list_expandable_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CianoWidgetsSourceListExpandableItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ciano_widgets_source_list_expandable_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CianoWidgetsSourceListExpandableItem), 0, (GInstanceInitFunc) ciano_widgets_source_list_expandable_item_instance_init, NULL };
	GType ciano_widgets_source_list_expandable_item_type_id;
	ciano_widgets_source_list_expandable_item_type_id = g_type_register_static (CIANO_WIDGETS_SOURCE_LIST_TYPE_ITEM, "CianoWidgetsSourceListExpandableItem", &g_define_type_info, 0);
	CianoWidgetsSourceListExpandableItem_private_offset = g_type_add_instance_private (ciano_widgets_source_list_expandable_item_type_id, sizeof (CianoWidgetsSourceListExpandableItemPrivate));
	return ciano_widgets_source_list_expandable_item_type_id;
}

GType
ciano_widgets_source_list_expandable_item_get_type (void)
{
	static volatile gsize ciano_widgets_source_list_expandable_item_type_id__once = 0;
	if (g_once_init_enter (&ciano_widgets_source_list_expandable_item_type_id__once)) {
		GType ciano_widgets_source_list_expandable_item_type_id;
		ciano_widgets_source_list_expandable_item_type_id = ciano_widgets_source_list_expandable_item_get_type_once ();
		g_once_init_leave (&ciano_widgets_source_list_expandable_item_type_id__once, ciano_widgets_source_list_expandable_item_type_id);
	}
	return ciano_widgets_source_list_expandable_item_type_id__once;
}

static void
_vala_ciano_widgets_source_list_expandable_item_get_property (GObject * object,
                                                              guint property_id,
                                                              GValue * value,
                                                              GParamSpec * pspec)
{
	CianoWidgetsSourceListExpandableItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CIANO_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, CianoWidgetsSourceListExpandableItem);
	switch (property_id) {
		case CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_COLLAPSIBLE_PROPERTY:
		g_value_set_boolean (value, ciano_widgets_source_list_expandable_item_get_collapsible (self));
		break;
		case CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_EXPANDED_PROPERTY:
		g_value_set_boolean (value, ciano_widgets_source_list_expandable_item_get_expanded (self));
		break;
		case CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_N_CHILDREN_PROPERTY:
		g_value_set_uint (value, ciano_widgets_source_list_expandable_item_get_n_children (self));
		break;
		case CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_CHILDREN_PROPERTY:
		g_value_take_object (value, ciano_widgets_source_list_expandable_item_get_children (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_ciano_widgets_source_list_expandable_item_set_property (GObject * object,
                                                              guint property_id,
                                                              const GValue * value,
                                                              GParamSpec * pspec)
{
	CianoWidgetsSourceListExpandableItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CIANO_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, CianoWidgetsSourceListExpandableItem);
	switch (property_id) {
		case CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_COLLAPSIBLE_PROPERTY:
		ciano_widgets_source_list_expandable_item_set_collapsible (self, g_value_get_boolean (value));
		break;
		case CIANO_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_EXPANDED_PROPERTY:
		ciano_widgets_source_list_expandable_item_set_expanded (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
ciano_widgets_source_list_data_model_get_instance_private (CianoWidgetsSourceListDataModel* self)
{
	return G_STRUCT_MEMBER_P (self, CianoWidgetsSourceListDataModel_private_offset);
}

static GType
ciano_widgets_source_list_data_model_column_type (CianoWidgetsSourceListDataModelColumn self)
{
	GType result;
	switch (self) {
		case CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_COLUMN_ITEM:
		{
			result = CIANO_WIDGETS_SOURCE_LIST_TYPE_ITEM;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
ciano_widgets_source_list_data_model_column_get_type_once (void)
{
	static const GEnumValue values[] = {{CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_COLUMN_ITEM, "CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_COLUMN_ITEM", "item"}, {CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_COLUMN_N_COLUMNS, "CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
	GType ciano_widgets_source_list_data_model_column_type_id;
	ciano_widgets_source_list_data_model_column_type_id = g_enum_register_static ("CianoWidgetsSourceListDataModelColumn", values);
	return ciano_widgets_source_list_data_model_column_type_id;
}

static GType
ciano_widgets_source_list_data_model_column_get_type (void)
{
	static volatile gsize ciano_widgets_source_list_data_model_column_type_id__once = 0;
	if (g_once_init_enter (&ciano_widgets_source_list_data_model_column_type_id__once)) {
		GType ciano_widgets_source_list_data_model_column_type_id;
		ciano_widgets_source_list_data_model_column_type_id = ciano_widgets_source_list_data_model_column_get_type_once ();
		g_once_init_leave (&ciano_widgets_source_list_data_model_column_type_id__once, ciano_widgets_source_list_data_model_column_type_id);
	}
	return ciano_widgets_source_list_data_model_column_type_id__once;
}

static gint
_ciano_widgets_source_list_data_model_child_model_sort_func_gtk_tree_iter_compare_func (GtkTreeModel* model,
                                                                                        GtkTreeIter* a,
                                                                                        GtkTreeIter* b,
                                                                                        gpointer self)
{
	gint result;
	result = ciano_widgets_source_list_data_model_child_model_sort_func ((CianoWidgetsSourceListDataModel*) self, model, a, b);
	return result;
}

static gboolean
_ciano_widgets_source_list_data_model_filter_visible_func_gtk_tree_model_filter_visible_func (GtkTreeModel* model,
                                                                                              GtkTreeIter* iter,
                                                                                              gpointer self)
{
	gboolean result;
	result = ciano_widgets_source_list_data_model_filter_visible_func ((CianoWidgetsSourceListDataModel*) self, model, iter);
	return result;
}

static CianoWidgetsSourceListDataModel*
ciano_widgets_source_list_data_model_construct (GType object_type)
{
	CianoWidgetsSourceListDataModel * self = NULL;
	GtkTreeStore* child_tree = NULL;
	GtkTreeStore* _tmp0_;
	GtkTreeStore* _tmp1_;
	_tmp0_ = gtk_tree_store_new ((gint) CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_COLUMN_N_COLUMNS, ciano_widgets_source_list_data_model_column_type (CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_COLUMN_ITEM));
	child_tree = _tmp0_;
	self = (CianoWidgetsSourceListDataModel*) g_object_new (object_type, "child-model", child_tree, "virtual-root", NULL, NULL);
	_tmp1_ = _g_object_ref0 (child_tree);
	_g_object_unref0 (self->priv->child_tree);
	self->priv->child_tree = _tmp1_;
	gtk_tree_sortable_set_default_sort_func ((GtkTreeSortable*) child_tree, _ciano_widgets_source_list_data_model_child_model_sort_func_gtk_tree_iter_compare_func, g_object_ref (self), g_object_unref);
	ciano_widgets_source_list_data_model_resort (self);
	gtk_tree_model_filter_set_visible_func ((GtkTreeModelFilter*) self, _ciano_widgets_source_list_data_model_filter_visible_func_gtk_tree_model_filter_visible_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (child_tree);
	return self;
}

static CianoWidgetsSourceListDataModel*
ciano_widgets_source_list_data_model_new (void)
{
	return ciano_widgets_source_list_data_model_construct (CIANO_WIDGETS_SOURCE_LIST_TYPE_DATA_MODEL);
}

static gboolean
ciano_widgets_source_list_data_model_has_item (CianoWidgetsSourceListDataModel* self,
                                               CianoWidgetsSourceListItem* item)
{
	GeeHashMap* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp0_ = self->priv->items;
	result = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, item);
	return result;
}

static void
ciano_widgets_source_list_data_model_update_item (CianoWidgetsSourceListDataModel* self,
                                                  CianoWidgetsSourceListItem* item)
{
	CianoWidgetsSourceListExpandableItem* _tmp0_;
	CianoWidgetsSourceListExpandableItem* _tmp1_;
	CianoWidgetsSourceListDataModelNodeWrapper* node_reference = NULL;
	GeeHashMap* _tmp2_;
	gpointer _tmp3_;
	CianoWidgetsSourceListDataModelNodeWrapper* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_vala_return_if_fail (ciano_widgets_source_list_data_model_has_item (self, item), "has_item (item)");
	_tmp0_ = ciano_widgets_source_list_data_model_get_root (self);
	_tmp1_ = _tmp0_;
	_vala_assert (_tmp1_ != NULL, "root != null");
	_tmp2_ = self->priv->items;
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, item);
	node_reference = (CianoWidgetsSourceListDataModelNodeWrapper*) _tmp3_;
	_tmp4_ = node_reference;
	if (_tmp4_ != NULL) {
		GtkTreePath* path = NULL;
		CianoWidgetsSourceListDataModelNodeWrapper* _tmp5_;
		GtkTreePath* _tmp6_;
		GtkTreePath* _tmp7_;
		GtkTreeIter* iter = NULL;
		CianoWidgetsSourceListDataModelNodeWrapper* _tmp8_;
		GtkTreeIter* _tmp9_;
		GtkTreeIter* _tmp10_;
		gboolean _tmp11_ = FALSE;
		GtkTreePath* _tmp12_;
		_tmp5_ = node_reference;
		_tmp6_ = ciano_widgets_source_list_data_model_node_wrapper_get_path (_tmp5_);
		_tmp7_ = _tmp6_;
		path = _tmp7_;
		_tmp8_ = node_reference;
		_tmp9_ = ciano_widgets_source_list_data_model_node_wrapper_get_iter (_tmp8_);
		_tmp10_ = _tmp9_;
		iter = _tmp10_;
		_tmp12_ = path;
		if (_tmp12_ != NULL) {
			GtkTreeIter* _tmp13_;
			_tmp13_ = iter;
			_tmp11_ = _tmp13_ != NULL;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			GtkTreeStore* _tmp14_;
			GtkTreePath* _tmp15_;
			GtkTreeIter* _tmp16_;
			GtkTreeIter _tmp17_;
			_tmp14_ = self->priv->child_tree;
			_tmp15_ = path;
			_tmp16_ = iter;
			_tmp17_ = *_tmp16_;
			gtk_tree_model_row_changed ((GtkTreeModel*) _tmp14_, _tmp15_, &_tmp17_);
			g_signal_emit (self, ciano_widgets_source_list_data_model_signals[CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_ITEM_UPDATED_SIGNAL], 0, item);
		}
		__vala_GtkTreeIter_free0 (iter);
		__vala_GtkTreePath_free0 (path);
	}
	_ciano_widgets_source_list_data_model_node_wrapper_unref0 (node_reference);
}

static GtkTreeIter*
_vala_GtkTreeIter_copy (GtkTreeIter* self)
{
	return g_boxed_copy (gtk_tree_iter_get_type (), self);
}

static gpointer
__vala_GtkTreeIter_copy0 (gpointer self)
{
	return self ? _vala_GtkTreeIter_copy (self) : NULL;
}

static void
ciano_widgets_source_list_data_model_add_item (CianoWidgetsSourceListDataModel* self,
                                               CianoWidgetsSourceListItem* item)
{
	CianoWidgetsSourceListExpandableItem* _tmp0_;
	CianoWidgetsSourceListExpandableItem* _tmp1_;
	GtkTreeIter* parent_child_iter = NULL;
	GtkTreeIter* child_iter = NULL;
	CianoWidgetsSourceListExpandableItem* parent = NULL;
	CianoWidgetsSourceListExpandableItem* _tmp2_;
	CianoWidgetsSourceListExpandableItem* _tmp3_;
	CianoWidgetsSourceListExpandableItem* _tmp4_;
	gboolean _tmp5_ = FALSE;
	CianoWidgetsSourceListExpandableItem* _tmp6_;
	GtkTreeStore* _tmp15_;
	GtkTreeIter* _tmp16_;
	GtkTreeIter _tmp17_ = {0};
	GtkTreeIter _tmp18_;
	GtkTreeIter* _tmp19_;
	GtkTreeStore* _tmp20_;
	GtkTreeIter* _tmp21_;
	GtkTreeIter _tmp22_;
	GeeHashMap* _tmp23_;
	GtkTreeStore* _tmp24_;
	GtkTreeIter* _tmp25_;
	GtkTreeIter _tmp26_;
	CianoWidgetsSourceListDataModelNodeWrapper* _tmp27_;
	CianoWidgetsSourceListDataModelNodeWrapper* _tmp28_;
	CianoWidgetsSourceListExpandableItem* _tmp29_;
	CianoWidgetsSourceListExpandableItem* expandable = NULL;
	CianoWidgetsSourceListExpandableItem* _tmp30_;
	CianoWidgetsSourceListExpandableItem* _tmp31_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_vala_return_if_fail (!ciano_widgets_source_list_data_model_has_item (self, item), "!has_item (item)");
	_tmp0_ = ciano_widgets_source_list_data_model_get_root (self);
	_tmp1_ = _tmp0_;
	_vala_assert (_tmp1_ != NULL, "root != null");
	parent_child_iter = NULL;
	_tmp2_ = ciano_widgets_source_list_item_get_parent (item);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	parent = _tmp4_;
	_tmp6_ = parent;
	if (_tmp6_ != NULL) {
		CianoWidgetsSourceListExpandableItem* _tmp7_;
		CianoWidgetsSourceListExpandableItem* _tmp8_;
		CianoWidgetsSourceListExpandableItem* _tmp9_;
		_tmp7_ = parent;
		_tmp8_ = ciano_widgets_source_list_data_model_get_root (self);
		_tmp9_ = _tmp8_;
		_tmp5_ = _tmp7_ != _tmp9_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		CianoWidgetsSourceListExpandableItem* _tmp10_;
		CianoWidgetsSourceListExpandableItem* _tmp12_;
		GtkTreeIter* _tmp13_;
		GtkTreeIter* _tmp14_;
		_tmp10_ = parent;
		if (!ciano_widgets_source_list_data_model_has_item (self, (CianoWidgetsSourceListItem*) _tmp10_)) {
			CianoWidgetsSourceListExpandableItem* _tmp11_;
			_tmp11_ = parent;
			ciano_widgets_source_list_data_model_add_item (self, (CianoWidgetsSourceListItem*) _tmp11_);
		}
		_tmp12_ = parent;
		_tmp13_ = ciano_widgets_source_list_data_model_get_item_child_iter (self, (CianoWidgetsSourceListItem*) _tmp12_);
		__vala_GtkTreeIter_free0 (parent_child_iter);
		parent_child_iter = _tmp13_;
		_tmp14_ = parent_child_iter;
		_vala_assert (_tmp14_ != NULL, "parent_child_iter != null");
	}
	_tmp15_ = self->priv->child_tree;
	_tmp16_ = parent_child_iter;
	gtk_tree_store_append (_tmp15_, &_tmp17_, _tmp16_);
	__vala_GtkTreeIter_free0 (child_iter);
	_tmp18_ = _tmp17_;
	_tmp19_ = __vala_GtkTreeIter_copy0 (&_tmp18_);
	child_iter = _tmp19_;
	_tmp20_ = self->priv->child_tree;
	_tmp21_ = child_iter;
	_tmp22_ = *_tmp21_;
	gtk_tree_store_set (_tmp20_, &_tmp22_, CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_COLUMN_ITEM, item, -1, -1);
	_tmp23_ = self->priv->items;
	_tmp24_ = self->priv->child_tree;
	_tmp25_ = child_iter;
	_tmp26_ = *_tmp25_;
	_tmp27_ = ciano_widgets_source_list_data_model_node_wrapper_new ((GtkTreeModel*) _tmp24_, &_tmp26_);
	_tmp28_ = _tmp27_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp23_, item, _tmp28_);
	_ciano_widgets_source_list_data_model_node_wrapper_unref0 (_tmp28_);
	g_signal_emit (self, ciano_widgets_source_list_data_model_signals[CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_ITEM_UPDATED_SIGNAL], 0, item);
	ciano_widgets_source_list_data_model_add_property_monitor (self, item);
	_tmp29_ = parent;
	ciano_widgets_source_list_data_model_push_parent_update (self, _tmp29_);
	_tmp30_ = _g_object_ref0 (CIANO_WIDGETS_SOURCE_LIST_IS_EXPANDABLE_ITEM (item) ? ((CianoWidgetsSourceListExpandableItem*) item) : NULL);
	expandable = _tmp30_;
	_tmp31_ = expandable;
	if (_tmp31_ != NULL) {
		CianoWidgetsSourceListExpandableItem* _tmp42_;
		{
			GeeIterator* _child_item_it = NULL;
			CianoWidgetsSourceListExpandableItem* _tmp32_;
			GeeCollection* _tmp33_;
			GeeCollection* _tmp34_;
			GeeCollection* _tmp35_;
			GeeIterator* _tmp36_;
			GeeIterator* _tmp37_;
			_tmp32_ = expandable;
			_tmp33_ = ciano_widgets_source_list_expandable_item_get_children (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = _tmp34_;
			_tmp36_ = gee_iterable_iterator ((GeeIterable*) _tmp35_);
			_tmp37_ = _tmp36_;
			_g_object_unref0 (_tmp35_);
			_child_item_it = _tmp37_;
			while (TRUE) {
				GeeIterator* _tmp38_;
				CianoWidgetsSourceListItem* child_item = NULL;
				GeeIterator* _tmp39_;
				gpointer _tmp40_;
				CianoWidgetsSourceListItem* _tmp41_;
				_tmp38_ = _child_item_it;
				if (!gee_iterator_next (_tmp38_)) {
					break;
				}
				_tmp39_ = _child_item_it;
				_tmp40_ = gee_iterator_get (_tmp39_);
				child_item = (CianoWidgetsSourceListItem*) _tmp40_;
				_tmp41_ = child_item;
				ciano_widgets_source_list_data_model_add_item (self, _tmp41_);
				_g_object_unref0 (child_item);
			}
			_g_object_unref0 (_child_item_it);
		}
		_tmp42_ = expandable;
		ciano_widgets_source_list_data_model_add_children_monitor (self, _tmp42_);
	}
	_g_object_unref0 (expandable);
	_g_object_unref0 (parent);
	__vala_GtkTreeIter_free0 (child_iter);
	__vala_GtkTreeIter_free0 (parent_child_iter);
}

static void
ciano_widgets_source_list_data_model_remove_item (CianoWidgetsSourceListDataModel* self,
                                                  CianoWidgetsSourceListItem* item)
{
	CianoWidgetsSourceListExpandableItem* _tmp0_;
	CianoWidgetsSourceListExpandableItem* _tmp1_;
	GtkTreeIter* child_iter = NULL;
	GtkTreeIter* _tmp2_;
	GeeHashMap* _tmp3_;
	GtkTreeIter* _tmp4_;
	CianoWidgetsSourceListExpandableItem* _tmp6_;
	CianoWidgetsSourceListExpandableItem* _tmp7_;
	CianoWidgetsSourceListExpandableItem* expandable = NULL;
	CianoWidgetsSourceListExpandableItem* _tmp8_;
	CianoWidgetsSourceListExpandableItem* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_vala_return_if_fail (ciano_widgets_source_list_data_model_has_item (self, item), "has_item (item)");
	_tmp0_ = ciano_widgets_source_list_data_model_get_root (self);
	_tmp1_ = _tmp0_;
	_vala_assert (_tmp1_ != NULL, "root != null");
	ciano_widgets_source_list_data_model_remove_property_monitor (self, item);
	_tmp2_ = ciano_widgets_source_list_data_model_get_item_child_iter (self, item);
	child_iter = _tmp2_;
	_tmp3_ = self->priv->items;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp3_, item, NULL);
	_tmp4_ = child_iter;
	if (_tmp4_ != NULL) {
		GtkTreeStore* _tmp5_;
		_tmp5_ = self->priv->child_tree;
		gtk_tree_store_remove (_tmp5_, child_iter);
	}
	_tmp6_ = ciano_widgets_source_list_item_get_parent (item);
	_tmp7_ = _tmp6_;
	ciano_widgets_source_list_data_model_push_parent_update (self, _tmp7_);
	_tmp8_ = _g_object_ref0 (CIANO_WIDGETS_SOURCE_LIST_IS_EXPANDABLE_ITEM (item) ? ((CianoWidgetsSourceListExpandableItem*) item) : NULL);
	expandable = _tmp8_;
	_tmp9_ = expandable;
	if (_tmp9_ != NULL) {
		CianoWidgetsSourceListExpandableItem* _tmp10_;
		_tmp10_ = expandable;
		ciano_widgets_source_list_data_model_remove_children_monitor (self, _tmp10_);
		{
			GeeIterator* _child_item_it = NULL;
			CianoWidgetsSourceListExpandableItem* _tmp11_;
			GeeCollection* _tmp12_;
			GeeCollection* _tmp13_;
			GeeCollection* _tmp14_;
			GeeIterator* _tmp15_;
			GeeIterator* _tmp16_;
			_tmp11_ = expandable;
			_tmp12_ = ciano_widgets_source_list_expandable_item_get_children (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = _tmp13_;
			_tmp15_ = gee_iterable_iterator ((GeeIterable*) _tmp14_);
			_tmp16_ = _tmp15_;
			_g_object_unref0 (_tmp14_);
			_child_item_it = _tmp16_;
			while (TRUE) {
				GeeIterator* _tmp17_;
				CianoWidgetsSourceListItem* child_item = NULL;
				GeeIterator* _tmp18_;
				gpointer _tmp19_;
				CianoWidgetsSourceListItem* _tmp20_;
				_tmp17_ = _child_item_it;
				if (!gee_iterator_next (_tmp17_)) {
					break;
				}
				_tmp18_ = _child_item_it;
				_tmp19_ = gee_iterator_get (_tmp18_);
				child_item = (CianoWidgetsSourceListItem*) _tmp19_;
				_tmp20_ = child_item;
				ciano_widgets_source_list_data_model_remove_item (self, _tmp20_);
				_g_object_unref0 (child_item);
			}
			_g_object_unref0 (_child_item_it);
		}
	}
	_g_object_unref0 (expandable);
	__vala_GtkTreeIter_free0 (child_iter);
}

static void
_ciano_widgets_source_list_data_model_on_item_prop_changed_ciano_widgets_source_list_data_model_item_monitor_changed (CianoWidgetsSourceListDataModelItemMonitor* _sender,
                                                                                                                      CianoWidgetsSourceListItem* _self_,
                                                                                                                      const gchar* prop_name,
                                                                                                                      gpointer self)
{
	ciano_widgets_source_list_data_model_on_item_prop_changed ((CianoWidgetsSourceListDataModel*) self, _self_, prop_name);
}

static void
ciano_widgets_source_list_data_model_add_property_monitor (CianoWidgetsSourceListDataModel* self,
                                                           CianoWidgetsSourceListItem* item)
{
	CianoWidgetsSourceListDataModelItemMonitor* wrapper = NULL;
	CianoWidgetsSourceListDataModelItemMonitor* _tmp0_;
	GeeHashMap* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = ciano_widgets_source_list_data_model_item_monitor_new (item);
	wrapper = _tmp0_;
	_tmp1_ = self->priv->monitors;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp1_, item, wrapper);
	g_signal_connect_object (wrapper, "changed", (GCallback) _ciano_widgets_source_list_data_model_on_item_prop_changed_ciano_widgets_source_list_data_model_item_monitor_changed, self, 0);
	_ciano_widgets_source_list_data_model_item_monitor_unref0 (wrapper);
}

static void
ciano_widgets_source_list_data_model_remove_property_monitor (CianoWidgetsSourceListDataModel* self,
                                                              CianoWidgetsSourceListItem* item)
{
	CianoWidgetsSourceListDataModelItemMonitor* wrapper = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	CianoWidgetsSourceListDataModelItemMonitor* _tmp2_;
	GeeHashMap* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = self->priv->monitors;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, item);
	wrapper = (CianoWidgetsSourceListDataModelItemMonitor*) _tmp1_;
	_tmp2_ = wrapper;
	if (_tmp2_ != NULL) {
		CianoWidgetsSourceListDataModelItemMonitor* _tmp3_;
		guint _tmp4_;
		_tmp3_ = wrapper;
		g_signal_parse_name ("changed", CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_ITEM_MONITOR, &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _ciano_widgets_source_list_data_model_on_item_prop_changed_ciano_widgets_source_list_data_model_item_monitor_changed, self);
	}
	_tmp5_ = self->priv->monitors;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp5_, item, NULL);
	_ciano_widgets_source_list_data_model_item_monitor_unref0 (wrapper);
}

static void
_ciano_widgets_source_list_data_model_on_item_child_added_ciano_widgets_source_list_expandable_item_child_added (CianoWidgetsSourceListExpandableItem* _sender,
                                                                                                                 CianoWidgetsSourceListItem* item,
                                                                                                                 gpointer self)
{
	ciano_widgets_source_list_data_model_on_item_child_added ((CianoWidgetsSourceListDataModel*) self, item);
}

static void
_ciano_widgets_source_list_data_model_on_item_child_removed_ciano_widgets_source_list_expandable_item_child_removed (CianoWidgetsSourceListExpandableItem* _sender,
                                                                                                                     CianoWidgetsSourceListItem* item,
                                                                                                                     gpointer self)
{
	ciano_widgets_source_list_data_model_on_item_child_removed ((CianoWidgetsSourceListDataModel*) self, item);
}

static void
ciano_widgets_source_list_data_model_add_children_monitor (CianoWidgetsSourceListDataModel* self,
                                                           CianoWidgetsSourceListExpandableItem* item)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	g_signal_connect_object (item, "child-added", (GCallback) _ciano_widgets_source_list_data_model_on_item_child_added_ciano_widgets_source_list_expandable_item_child_added, self, G_CONNECT_AFTER);
	g_signal_connect_object (item, "child-removed", (GCallback) _ciano_widgets_source_list_data_model_on_item_child_removed_ciano_widgets_source_list_expandable_item_child_removed, self, G_CONNECT_AFTER);
}

static void
ciano_widgets_source_list_data_model_remove_children_monitor (CianoWidgetsSourceListDataModel* self,
                                                              CianoWidgetsSourceListExpandableItem* item)
{
	guint _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	g_signal_parse_name ("child-added", CIANO_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (item, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _ciano_widgets_source_list_data_model_on_item_child_added_ciano_widgets_source_list_expandable_item_child_added, self);
	g_signal_parse_name ("child-removed", CIANO_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (item, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _ciano_widgets_source_list_data_model_on_item_child_removed_ciano_widgets_source_list_expandable_item_child_removed, self);
}

static void
ciano_widgets_source_list_data_model_on_item_child_added (CianoWidgetsSourceListDataModel* self,
                                                          CianoWidgetsSourceListItem* item)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	ciano_widgets_source_list_data_model_add_item (self, item);
}

static void
ciano_widgets_source_list_data_model_on_item_child_removed (CianoWidgetsSourceListDataModel* self,
                                                            CianoWidgetsSourceListItem* item)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	ciano_widgets_source_list_data_model_remove_item (self, item);
}

static void
ciano_widgets_source_list_data_model_on_item_prop_changed (CianoWidgetsSourceListDataModel* self,
                                                           CianoWidgetsSourceListItem* item,
                                                           const gchar* prop_name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	g_return_if_fail (prop_name != NULL);
	if (g_strcmp0 (prop_name, "parent") != 0) {
		ciano_widgets_source_list_data_model_update_item (self, item);
	}
}

/**
         * Pushes a call to update_item() if //parent// is not //null//.
         *
         * This is needed because the visibility of categories depends on their n_children property,
         * and also because item expansion should be updated after adding or removing items.
         * If many updates are pushed, and the item has still not been updated, only one is processed.
         * This guarantees efficiency as updating a category item could trigger expensive actions.
         */
static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		CianoWidgetsSourceListDataModel* self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->parent);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static gboolean
___lambda6_ (Block8Data* _data8_)
{
	CianoWidgetsSourceListDataModel* self;
	gboolean result;
	self = _data8_->self;
	if (_data8_->parent != NULL) {
		ciano_widgets_source_list_data_model_update_item (self, (CianoWidgetsSourceListItem*) _data8_->parent);
		g_object_set_data_full ((GObject*) _data8_->parent, CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_ITEM_PARENT_NEEDS_UPDATE, (gpointer) ((gintptr) FALSE), NULL);
	}
	result = FALSE;
	return result;
}

static gboolean
____lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda6_ (self);
	return result;
}

static void
ciano_widgets_source_list_data_model_push_parent_update (CianoWidgetsSourceListDataModel* self,
                                                         CianoWidgetsSourceListExpandableItem* parent)
{
	Block8Data* _data8_;
	CianoWidgetsSourceListExpandableItem* _tmp0_;
	gboolean needs_update = FALSE;
	gconstpointer _tmp1_;
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp2_;
	GtkTreePath* _tmp3_;
	g_return_if_fail (self != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (parent);
	_g_object_unref0 (_data8_->parent);
	_data8_->parent = _tmp0_;
	if (_data8_->parent == NULL) {
		block8_data_unref (_data8_);
		_data8_ = NULL;
		return;
	}
	_tmp1_ = g_object_get_data ((GObject*) _data8_->parent, CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_ITEM_PARENT_NEEDS_UPDATE);
	needs_update = (gboolean) ((gintptr) _tmp1_);
	if (needs_update) {
		block8_data_unref (_data8_);
		_data8_ = NULL;
		return;
	}
	_tmp2_ = ciano_widgets_source_list_data_model_get_item_path (self, (CianoWidgetsSourceListItem*) _data8_->parent);
	path = _tmp2_;
	_tmp3_ = path;
	if (_tmp3_ != NULL) {
		g_object_set_data_full ((GObject*) _data8_->parent, CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_ITEM_PARENT_NEEDS_UPDATE, (gpointer) ((gintptr) TRUE), NULL);
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda6__gsource_func, block8_data_ref (_data8_), block8_data_unref);
	}
	__vala_GtkTreePath_free0 (path);
	block8_data_unref (_data8_);
	_data8_ = NULL;
}

/**
         * Returns the Item pointed by iter, or null if the iter doesn't refer to a valid item.
         */
static CianoWidgetsSourceListItem*
ciano_widgets_source_list_data_model_get_item (CianoWidgetsSourceListDataModel* self,
                                               GtkTreeIter* iter)
{
	CianoWidgetsSourceListItem* item = NULL;
	GtkTreeIter _tmp0_;
	CianoWidgetsSourceListItem* _tmp1_ = NULL;
	CianoWidgetsSourceListItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = *iter;
	gtk_tree_model_get ((GtkTreeModel*) self, &_tmp0_, CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_COLUMN_ITEM, &_tmp1_, -1, -1);
	_g_object_unref0 (item);
	item = _tmp1_;
	result = item;
	return result;
}

/**
         * Returns the Item pointed by path, or null if the path doesn't refer to a valid item.
         */
static CianoWidgetsSourceListItem*
ciano_widgets_source_list_data_model_get_item_from_path (CianoWidgetsSourceListDataModel* self,
                                                         GtkTreePath* path)
{
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	CianoWidgetsSourceListItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp1_ = gtk_tree_model_get_iter ((GtkTreeModel*) self, &_tmp0_, path);
	iter = _tmp0_;
	if (_tmp1_) {
		GtkTreeIter _tmp2_;
		CianoWidgetsSourceListItem* _tmp3_;
		_tmp2_ = iter;
		_tmp3_ = ciano_widgets_source_list_data_model_get_item (self, &_tmp2_);
		result = _tmp3_;
		return result;
	}
	result = NULL;
	return result;
}

/**
         * Returns a newly-created path pointing to the item, or null in case a valid path
         * is not found.
         */
static GtkTreePath*
ciano_widgets_source_list_data_model_get_item_path (CianoWidgetsSourceListDataModel* self,
                                                    CianoWidgetsSourceListItem* item)
{
	GtkTreePath* path = NULL;
	GtkTreePath* child_path = NULL;
	GtkTreePath* _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	path = NULL;
	_tmp0_ = ciano_widgets_source_list_data_model_get_item_child_path (self, item);
	child_path = _tmp0_;
	_tmp1_ = child_path;
	if (_tmp1_ != NULL) {
		GtkTreePath* _tmp2_;
		GtkTreePath* _tmp3_;
		_tmp2_ = child_path;
		_tmp3_ = gtk_tree_model_filter_convert_child_path_to_path ((GtkTreeModelFilter*) self, _tmp2_);
		__vala_GtkTreePath_free0 (path);
		path = _tmp3_;
	}
	result = path;
	__vala_GtkTreePath_free0 (child_path);
	return result;
}

/**
         * Returns a newly-created iterator pointing to the item, or null in case a valid iter
         * was not found.
         */
static GtkTreeIter*
ciano_widgets_source_list_data_model_get_item_iter (CianoWidgetsSourceListDataModel* self,
                                                    CianoWidgetsSourceListItem* item)
{
	GtkTreeIter* child_iter = NULL;
	GtkTreeIter* _tmp0_;
	GtkTreeIter* _tmp1_;
	GtkTreeIter* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = ciano_widgets_source_list_data_model_get_item_child_iter (self, item);
	child_iter = _tmp0_;
	_tmp1_ = child_iter;
	if (_tmp1_ != NULL) {
		GtkTreeIter iter = {0};
		GtkTreeIter* _tmp2_;
		GtkTreeIter _tmp3_ = {0};
		GtkTreeIter _tmp4_;
		gboolean _tmp5_;
		_tmp2_ = child_iter;
		_tmp4_ = *_tmp2_;
		_tmp5_ = gtk_tree_model_filter_convert_child_iter_to_iter ((GtkTreeModelFilter*) self, &_tmp3_, &_tmp4_);
		iter = _tmp3_;
		if (_tmp5_) {
			GtkTreeIter* _tmp6_;
			_tmp6_ = __vala_GtkTreeIter_copy0 (&iter);
			result = _tmp6_;
			__vala_GtkTreeIter_free0 (child_iter);
			return result;
		}
	}
	result = NULL;
	__vala_GtkTreeIter_free0 (child_iter);
	return result;
}

/**
         * External "extra" filter method.
         */
static void
ciano_widgets_source_list_data_model_set_filter_func (CianoWidgetsSourceListDataModel* self,
                                                      CianoWidgetsSourceListVisibleFunc visible_func,
                                                      gpointer visible_func_target)
{
	g_return_if_fail (self != NULL);
	self->priv->filter_func = visible_func;
	self->priv->filter_func_target = visible_func_target;
}

/**
         * Checks whether an item is a category (i.e. a root-level expandable item).
         * The caller must pass an iter or path pointing to the item, but not both
         * (one of them must be null.)
         *
         * TODO: instead of checking the position of the iter or path, we should simply
         * check whether the item's parent is the root item and whether the item is
         * expandable. We don't do so right now because vala still allows client code
         * to access the Item.parent property, even though its setter is defined as internal.
         */
static gboolean
ciano_widgets_source_list_data_model_is_category (CianoWidgetsSourceListDataModel* self,
                                                  CianoWidgetsSourceListItem* item,
                                                  GtkTreeIter* iter,
                                                  GtkTreePath* path)
{
	gboolean is_category = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	is_category = FALSE;
	if (CIANO_WIDGETS_SOURCE_LIST_IS_EXPANDABLE_ITEM (item)) {
		if (iter != NULL) {
			GtkTreeIter _tmp0_;
			_vala_assert (path == NULL, "path == null");
			_tmp0_ = *iter;
			is_category = ciano_widgets_source_list_data_model_is_iter_at_root_level (self, &_tmp0_);
		} else {
			_vala_assert (iter == NULL, "iter == null");
			is_category = ciano_widgets_source_list_data_model_is_path_at_root_level (self, path);
		}
	}
	result = is_category;
	return result;
}

static gboolean
ciano_widgets_source_list_data_model_is_iter_at_root_level (CianoWidgetsSourceListDataModel* self,
                                                            GtkTreeIter* iter)
{
	GtkTreeIter _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	_tmp1_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = ciano_widgets_source_list_data_model_is_path_at_root_level (self, _tmp2_);
	__vala_GtkTreePath_free0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static gboolean
ciano_widgets_source_list_data_model_is_path_at_root_level (CianoWidgetsSourceListDataModel* self,
                                                            GtkTreePath* path)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	result = gtk_tree_path_get_depth (path) == 1;
	return result;
}

static void
ciano_widgets_source_list_data_model_resort (CianoWidgetsSourceListDataModel* self)
{
	GtkTreeStore* _tmp0_;
	GtkTreeStore* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->child_tree;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp0_, GTK_TREE_SORTABLE_UNSORTED_SORT_COLUMN_ID, GTK_SORT_ASCENDING);
	_tmp1_ = self->priv->child_tree;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp1_, GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID, GTK_SORT_ASCENDING);
}

static gint
ciano_widgets_source_list_data_model_child_model_sort_func (CianoWidgetsSourceListDataModel* self,
                                                            GtkTreeModel* model,
                                                            GtkTreeIter* a,
                                                            GtkTreeIter* b)
{
	gint order = 0;
	CianoWidgetsSourceListItem* item_a = NULL;
	CianoWidgetsSourceListItem* item_b = NULL;
	GtkTreeStore* _tmp0_;
	GtkTreeIter _tmp1_;
	CianoWidgetsSourceListItem* _tmp2_ = NULL;
	GtkTreeStore* _tmp3_;
	GtkTreeIter _tmp4_;
	CianoWidgetsSourceListItem* _tmp5_ = NULL;
	CianoWidgetsSourceListItem* _tmp6_;
	CianoWidgetsSourceListExpandableItem* _tmp7_;
	CianoWidgetsSourceListExpandableItem* _tmp8_;
	CianoWidgetsSourceListItem* _tmp9_;
	CianoWidgetsSourceListExpandableItem* _tmp10_;
	CianoWidgetsSourceListExpandableItem* _tmp11_;
	CianoWidgetsSourceListSortable* parent = NULL;
	CianoWidgetsSourceListItem* _tmp12_;
	CianoWidgetsSourceListExpandableItem* _tmp13_;
	CianoWidgetsSourceListExpandableItem* _tmp14_;
	CianoWidgetsSourceListSortable* _tmp15_;
	CianoWidgetsSourceListSortable* _tmp16_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (model != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	order = 0;
	_tmp0_ = self->priv->child_tree;
	_tmp1_ = *a;
	gtk_tree_model_get ((GtkTreeModel*) _tmp0_, &_tmp1_, CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_COLUMN_ITEM, &_tmp2_, -1, -1);
	_g_object_unref0 (item_a);
	item_a = _tmp2_;
	_tmp3_ = self->priv->child_tree;
	_tmp4_ = *b;
	gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_COLUMN_ITEM, &_tmp5_, -1, -1);
	_g_object_unref0 (item_b);
	item_b = _tmp5_;
	_tmp6_ = item_a;
	_tmp7_ = ciano_widgets_source_list_item_get_parent (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = item_b;
	_tmp10_ = ciano_widgets_source_list_item_get_parent (_tmp9_);
	_tmp11_ = _tmp10_;
	_vala_assert (_tmp8_ == _tmp11_, "item_a.parent == item_b.parent");
	_tmp12_ = item_a;
	_tmp13_ = ciano_widgets_source_list_item_get_parent (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _g_object_ref0 (CIANO_WIDGETS_IS_SOURCE_LIST_SORTABLE (_tmp14_) ? ((CianoWidgetsSourceListSortable*) _tmp14_) : NULL);
	parent = _tmp15_;
	_tmp16_ = parent;
	if (_tmp16_ != NULL) {
		CianoWidgetsSourceListSortable* _tmp17_;
		CianoWidgetsSourceListItem* _tmp18_;
		CianoWidgetsSourceListItem* _tmp19_;
		_tmp17_ = parent;
		_tmp18_ = item_a;
		_tmp19_ = item_b;
		order = ciano_widgets_source_list_sortable_compare (_tmp17_, _tmp18_, _tmp19_);
	}
	result = order;
	_g_object_unref0 (parent);
	_g_object_unref0 (item_b);
	_g_object_unref0 (item_a);
	return result;
}

static GtkTreeIter*
ciano_widgets_source_list_data_model_get_item_child_iter (CianoWidgetsSourceListDataModel* self,
                                                          CianoWidgetsSourceListItem* item)
{
	GtkTreeIter* child_iter = NULL;
	CianoWidgetsSourceListDataModelNodeWrapper* child_node_wrapper = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	CianoWidgetsSourceListDataModelNodeWrapper* _tmp2_;
	GtkTreeIter* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	child_iter = NULL;
	_tmp0_ = self->priv->items;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, item);
	child_node_wrapper = (CianoWidgetsSourceListDataModelNodeWrapper*) _tmp1_;
	_tmp2_ = child_node_wrapper;
	if (_tmp2_ != NULL) {
		CianoWidgetsSourceListDataModelNodeWrapper* _tmp3_;
		GtkTreeIter* _tmp4_;
		GtkTreeIter* _tmp5_;
		_tmp3_ = child_node_wrapper;
		_tmp4_ = ciano_widgets_source_list_data_model_node_wrapper_get_iter (_tmp3_);
		_tmp5_ = _tmp4_;
		__vala_GtkTreeIter_free0 (child_iter);
		child_iter = _tmp5_;
	}
	result = child_iter;
	_ciano_widgets_source_list_data_model_node_wrapper_unref0 (child_node_wrapper);
	return result;
}

static GtkTreePath*
ciano_widgets_source_list_data_model_get_item_child_path (CianoWidgetsSourceListDataModel* self,
                                                          CianoWidgetsSourceListItem* item)
{
	GtkTreePath* child_path = NULL;
	CianoWidgetsSourceListDataModelNodeWrapper* child_node_wrapper = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	CianoWidgetsSourceListDataModelNodeWrapper* _tmp2_;
	GtkTreePath* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	child_path = NULL;
	_tmp0_ = self->priv->items;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, item);
	child_node_wrapper = (CianoWidgetsSourceListDataModelNodeWrapper*) _tmp1_;
	_tmp2_ = child_node_wrapper;
	if (_tmp2_ != NULL) {
		CianoWidgetsSourceListDataModelNodeWrapper* _tmp3_;
		GtkTreePath* _tmp4_;
		GtkTreePath* _tmp5_;
		_tmp3_ = child_node_wrapper;
		_tmp4_ = ciano_widgets_source_list_data_model_node_wrapper_get_path (_tmp3_);
		_tmp5_ = _tmp4_;
		__vala_GtkTreePath_free0 (child_path);
		child_path = _tmp5_;
	}
	result = child_path;
	_ciano_widgets_source_list_data_model_node_wrapper_unref0 (child_node_wrapper);
	return result;
}

/**
         * Filters the child-tree items based on their "visible" property.
         */
static gboolean
ciano_widgets_source_list_data_model_filter_visible_func (CianoWidgetsSourceListDataModel* self,
                                                          GtkTreeModel* child_model,
                                                          GtkTreeIter* iter)
{
	gboolean item_visible = FALSE;
	CianoWidgetsSourceListItem* item = NULL;
	GtkTreeStore* _tmp0_;
	GtkTreeIter _tmp1_;
	CianoWidgetsSourceListItem* _tmp2_ = NULL;
	CianoWidgetsSourceListItem* _tmp3_;
	CianoWidgetsSourceListVisibleFunc _tmp27_;
	gpointer _tmp27__target;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (child_model != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	item_visible = FALSE;
	_tmp0_ = self->priv->child_tree;
	_tmp1_ = *iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp0_, &_tmp1_, CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_COLUMN_ITEM, &_tmp2_, -1, -1);
	_g_object_unref0 (item);
	item = _tmp2_;
	_tmp3_ = item;
	if (_tmp3_ != NULL) {
		CianoWidgetsSourceListItem* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		CianoWidgetsSourceListExpandableItem* expandable = NULL;
		CianoWidgetsSourceListItem* _tmp7_;
		CianoWidgetsSourceListExpandableItem* _tmp8_;
		gboolean _tmp9_ = FALSE;
		CianoWidgetsSourceListExpandableItem* _tmp10_;
		_tmp4_ = item;
		_tmp5_ = ciano_widgets_source_list_item_get_visible (_tmp4_);
		_tmp6_ = _tmp5_;
		item_visible = _tmp6_;
		_tmp7_ = item;
		_tmp8_ = _g_object_ref0 (CIANO_WIDGETS_SOURCE_LIST_IS_EXPANDABLE_ITEM (_tmp7_) ? ((CianoWidgetsSourceListExpandableItem*) _tmp7_) : NULL);
		expandable = _tmp8_;
		_tmp10_ = expandable;
		if (_tmp10_ != NULL) {
			GtkTreeStore* _tmp11_;
			GtkTreeIter _tmp12_;
			_tmp11_ = self->priv->child_tree;
			_tmp12_ = *iter;
			_tmp9_ = gtk_tree_store_iter_depth (_tmp11_, &_tmp12_) == 0;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			guint n_visible_children = 0U;
			gboolean _tmp26_ = FALSE;
			n_visible_children = (guint) 0;
			{
				GeeIterator* _child_item_it = NULL;
				CianoWidgetsSourceListExpandableItem* _tmp13_;
				GeeCollection* _tmp14_;
				GeeCollection* _tmp15_;
				GeeCollection* _tmp16_;
				GeeIterator* _tmp17_;
				GeeIterator* _tmp18_;
				_tmp13_ = expandable;
				_tmp14_ = ciano_widgets_source_list_expandable_item_get_children (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = _tmp15_;
				_tmp17_ = gee_iterable_iterator ((GeeIterable*) _tmp16_);
				_tmp18_ = _tmp17_;
				_g_object_unref0 (_tmp16_);
				_child_item_it = _tmp18_;
				while (TRUE) {
					GeeIterator* _tmp19_;
					CianoWidgetsSourceListItem* child_item = NULL;
					GeeIterator* _tmp20_;
					gpointer _tmp21_;
					CianoWidgetsSourceListItem* _tmp22_;
					gboolean _tmp23_;
					gboolean _tmp24_;
					_tmp19_ = _child_item_it;
					if (!gee_iterator_next (_tmp19_)) {
						break;
					}
					_tmp20_ = _child_item_it;
					_tmp21_ = gee_iterator_get (_tmp20_);
					child_item = (CianoWidgetsSourceListItem*) _tmp21_;
					_tmp22_ = child_item;
					_tmp23_ = ciano_widgets_source_list_item_get_visible (_tmp22_);
					_tmp24_ = _tmp23_;
					if (_tmp24_) {
						guint _tmp25_;
						_tmp25_ = n_visible_children;
						n_visible_children = _tmp25_ + 1;
					}
					_g_object_unref0 (child_item);
				}
				_g_object_unref0 (_child_item_it);
			}
			if (item_visible) {
				_tmp26_ = n_visible_children > ((guint) 0);
			} else {
				_tmp26_ = FALSE;
			}
			item_visible = _tmp26_;
		}
		_g_object_unref0 (expandable);
	}
	_tmp27_ = self->priv->filter_func;
	_tmp27__target = self->priv->filter_func_target;
	if (_tmp27_ != NULL) {
		gboolean _tmp28_ = FALSE;
		if (item_visible) {
			CianoWidgetsSourceListVisibleFunc _tmp29_;
			gpointer _tmp29__target;
			CianoWidgetsSourceListItem* _tmp30_;
			_tmp29_ = self->priv->filter_func;
			_tmp29__target = self->priv->filter_func_target;
			_tmp30_ = item;
			_tmp28_ = _tmp29_ (_tmp30_, _tmp29__target);
		} else {
			_tmp28_ = FALSE;
		}
		item_visible = _tmp28_;
	}
	result = item_visible;
	_g_object_unref0 (item);
	return result;
}

/**
         * TreeDragDest implementation
         */
static gboolean
ciano_widgets_source_list_data_model_real_drag_data_received (GtkTreeDragDest* base,
                                                              GtkTreePath* dest,
                                                              GtkSelectionData* selection_data)
{
	CianoWidgetsSourceListDataModel * self;
	GtkTreeModel* model = NULL;
	GtkTreePath* src_path = NULL;
	gboolean _tmp0_ = FALSE;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreePath* _tmp2_ = NULL;
	gboolean _tmp3_;
	GtkTreeModel* _tmp4_;
	gboolean result;
	self = (CianoWidgetsSourceListDataModel*) base;
	g_return_val_if_fail (dest != NULL, FALSE);
	g_return_val_if_fail (selection_data != NULL, FALSE);
	_tmp3_ = gtk_tree_get_row_drag_data (selection_data, &_tmp1_, &_tmp2_);
	_g_object_unref0 (model);
	_tmp4_ = _g_object_ref0 (_tmp1_);
	model = _tmp4_;
	__vala_GtkTreePath_free0 (src_path);
	src_path = _tmp2_;
	if (_tmp3_) {
		GtkTreeModel* _tmp5_;
		GtkTreeStore* _tmp6_;
		_tmp5_ = model;
		_tmp6_ = self->priv->child_tree;
		_tmp0_ = _tmp5_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_tree_model_get_type (), GtkTreeModel);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkTreePath* child_dest = NULL;
		GtkTreePath* _tmp7_;
		GtkTreePath* _tmp8_;
		_tmp7_ = gtk_tree_model_filter_convert_path_to_child_path ((GtkTreeModelFilter*) self, dest);
		child_dest = _tmp7_;
		_tmp8_ = child_dest;
		if (_tmp8_ != NULL) {
			GtkTreePath* _tmp9_;
			GtkTreePath* _tmp10_;
			_tmp9_ = child_dest;
			_tmp10_ = src_path;
			if (ciano_widgets_source_list_data_model_child_tree_drag_data_received (self, _tmp9_, _tmp10_)) {
				result = TRUE;
				__vala_GtkTreePath_free0 (child_dest);
				__vala_GtkTreePath_free0 (src_path);
				_g_object_unref0 (model);
				return result;
			}
		}
		__vala_GtkTreePath_free0 (child_dest);
	}
	result = FALSE;
	__vala_GtkTreePath_free0 (src_path);
	_g_object_unref0 (model);
	return result;
}

static GtkTreePath*
_vala_GtkTreePath_copy (GtkTreePath* self)
{
	return g_boxed_copy (gtk_tree_path_get_type (), self);
}

static gpointer
__vala_GtkTreePath_copy0 (gpointer self)
{
	return self ? _vala_GtkTreePath_copy (self) : NULL;
}

static gboolean
ciano_widgets_source_list_data_model_child_tree_drag_data_received (CianoWidgetsSourceListDataModel* self,
                                                                    GtkTreePath* dest,
                                                                    GtkTreePath* src_path)
{
	gboolean retval = FALSE;
	GtkTreeIter src_iter = {0};
	GtkTreeIter dest_iter = {0};
	GtkTreeStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	GtkTreePath* prev = NULL;
	GtkTreePath* _tmp3_;
	GtkTreePath* _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dest != NULL, FALSE);
	g_return_val_if_fail (src_path != NULL, FALSE);
	retval = FALSE;
	_tmp0_ = self->priv->child_tree;
	_tmp2_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp0_, &_tmp1_, src_path);
	src_iter = _tmp1_;
	if (!_tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = __vala_GtkTreePath_copy0 (dest);
	prev = _tmp3_;
	_tmp4_ = prev;
	if (!gtk_tree_path_prev (_tmp4_)) {
		GtkTreePath* parent = NULL;
		GtkTreePath* _tmp5_;
		GtkTreeIter* dest_parent = NULL;
		gboolean _tmp6_ = FALSE;
		GtkTreePath* _tmp7_;
		GtkTreeStore* _tmp14_;
		GtkTreeIter* _tmp15_;
		GtkTreeIter _tmp16_ = {0};
		_tmp5_ = __vala_GtkTreePath_copy0 (dest);
		parent = _tmp5_;
		dest_parent = NULL;
		_tmp7_ = parent;
		if (gtk_tree_path_up (_tmp7_)) {
			GtkTreePath* _tmp8_;
			_tmp8_ = parent;
			_tmp6_ = gtk_tree_path_get_depth (_tmp8_) > 0;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			GtkTreeStore* _tmp9_;
			GtkTreePath* _tmp10_;
			GtkTreeIter _tmp11_ = {0};
			GtkTreeIter _tmp12_;
			GtkTreeIter* _tmp13_;
			_tmp9_ = self->priv->child_tree;
			_tmp10_ = parent;
			gtk_tree_model_get_iter ((GtkTreeModel*) _tmp9_, &_tmp11_, _tmp10_);
			__vala_GtkTreeIter_free0 (dest_parent);
			_tmp12_ = _tmp11_;
			_tmp13_ = __vala_GtkTreeIter_copy0 (&_tmp12_);
			dest_parent = _tmp13_;
		}
		_tmp14_ = self->priv->child_tree;
		_tmp15_ = dest_parent;
		gtk_tree_store_prepend (_tmp14_, &_tmp16_, _tmp15_);
		dest_iter = _tmp16_;
		retval = TRUE;
		__vala_GtkTreeIter_free0 (dest_parent);
		__vala_GtkTreePath_free0 (parent);
	} else {
		GtkTreeStore* _tmp17_;
		GtkTreePath* _tmp18_;
		GtkTreeIter _tmp19_ = {0};
		gboolean _tmp20_;
		_tmp17_ = self->priv->child_tree;
		_tmp18_ = prev;
		_tmp20_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp17_, &_tmp19_, _tmp18_);
		dest_iter = _tmp19_;
		if (_tmp20_) {
			GtkTreeIter tmp_iter = {0};
			GtkTreeIter _tmp21_;
			GtkTreeStore* _tmp22_;
			GtkTreeIter _tmp23_;
			GtkTreeIter _tmp24_ = {0};
			_tmp21_ = dest_iter;
			tmp_iter = _tmp21_;
			_tmp22_ = self->priv->child_tree;
			_tmp23_ = tmp_iter;
			gtk_tree_store_insert_after (_tmp22_, &_tmp24_, NULL, &_tmp23_);
			dest_iter = _tmp24_;
			retval = TRUE;
		}
	}
	if (retval) {
		GtkTreeIter _tmp25_;
		GtkTreeIter _tmp26_;
		CianoWidgetsSourceListItem* item = NULL;
		GtkTreeStore* _tmp27_;
		GtkTreeIter _tmp28_;
		CianoWidgetsSourceListItem* _tmp29_ = NULL;
		CianoWidgetsSourceListItem* _tmp30_;
		CianoWidgetsSourceListItem* _tmp31_;
		CianoWidgetsSourceListSortable* parent = NULL;
		CianoWidgetsSourceListItem* _tmp32_;
		CianoWidgetsSourceListExpandableItem* _tmp33_;
		CianoWidgetsSourceListExpandableItem* _tmp34_;
		CianoWidgetsSourceListSortable* _tmp35_;
		CianoWidgetsSourceListSortable* _tmp36_;
		CianoWidgetsSourceListSortable* _tmp37_;
		CianoWidgetsSourceListItem* _tmp38_;
		_tmp25_ = src_iter;
		_tmp26_ = dest_iter;
		ciano_widgets_source_list_data_model_recursive_node_copy (self, &_tmp25_, &_tmp26_);
		_tmp27_ = self->priv->child_tree;
		_tmp28_ = src_iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp27_, &_tmp28_, CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_COLUMN_ITEM, &_tmp29_, -1, -1);
		_g_object_unref0 (item);
		item = _tmp29_;
		_tmp30_ = item;
		g_return_val_if_fail (_tmp30_ != NULL, retval);
		_tmp31_ = item;
		ciano_widgets_source_list_data_model_update_item (self, _tmp31_);
		_tmp32_ = item;
		_tmp33_ = ciano_widgets_source_list_item_get_parent (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = _g_object_ref0 (CIANO_WIDGETS_IS_SOURCE_LIST_SORTABLE (_tmp34_) ? ((CianoWidgetsSourceListSortable*) _tmp34_) : NULL);
		parent = _tmp35_;
		_tmp36_ = parent;
		g_return_val_if_fail (_tmp36_ != NULL, retval);
		_tmp37_ = parent;
		_tmp38_ = item;
		g_signal_emit (_tmp37_, ciano_widgets_source_list_sortable_signals[CIANO_WIDGETS_SOURCE_LIST_SORTABLE_USER_MOVED_ITEM_SIGNAL], 0, _tmp38_);
		_g_object_unref0 (parent);
		_g_object_unref0 (item);
	}
	result = retval;
	__vala_GtkTreePath_free0 (prev);
	return result;
}

static void
ciano_widgets_source_list_data_model_recursive_node_copy (CianoWidgetsSourceListDataModel* self,
                                                          GtkTreeIter* src_iter,
                                                          GtkTreeIter* dest_iter)
{
	GtkTreeIter _tmp0_;
	GtkTreeIter _tmp1_;
	GtkTreeIter child = {0};
	GtkTreeStore* _tmp2_;
	GtkTreeIter _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (src_iter != NULL);
	g_return_if_fail (dest_iter != NULL);
	_tmp0_ = *src_iter;
	_tmp1_ = *dest_iter;
	ciano_widgets_source_list_data_model_move_item (self, &_tmp0_, &_tmp1_);
	_tmp2_ = self->priv->child_tree;
	_tmp3_ = *src_iter;
	_tmp5_ = gtk_tree_model_iter_children ((GtkTreeModel*) _tmp2_, &_tmp4_, &_tmp3_);
	child = _tmp4_;
	if (_tmp5_) {
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				GtkTreeIter copy = {0};
				GtkTreeStore* _tmp9_;
				GtkTreeIter _tmp10_;
				GtkTreeIter _tmp11_ = {0};
				GtkTreeIter _tmp12_;
				GtkTreeIter _tmp13_;
				if (!_tmp6_) {
					GtkTreeStore* _tmp7_;
					gboolean _tmp8_;
					_tmp7_ = self->priv->child_tree;
					_tmp8_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp7_, &child);
					if (!_tmp8_) {
						break;
					}
				}
				_tmp6_ = FALSE;
				_tmp9_ = self->priv->child_tree;
				_tmp10_ = *dest_iter;
				gtk_tree_store_append (_tmp9_, &_tmp11_, &_tmp10_);
				copy = _tmp11_;
				_tmp12_ = child;
				_tmp13_ = copy;
				ciano_widgets_source_list_data_model_recursive_node_copy (self, &_tmp12_, &_tmp13_);
			}
		}
	}
}

static void
ciano_widgets_source_list_data_model_move_item (CianoWidgetsSourceListDataModel* self,
                                                GtkTreeIter* src_iter,
                                                GtkTreeIter* dest_iter)
{
	CianoWidgetsSourceListItem* item = NULL;
	GtkTreeStore* _tmp0_;
	GtkTreeIter _tmp1_;
	CianoWidgetsSourceListItem* _tmp2_ = NULL;
	GtkTreeStore* _tmp3_;
	GtkTreeIter _tmp4_;
	GeeHashMap* _tmp5_;
	GtkTreeStore* _tmp6_;
	GtkTreeIter _tmp7_;
	CianoWidgetsSourceListDataModelNodeWrapper* _tmp8_;
	CianoWidgetsSourceListDataModelNodeWrapper* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (src_iter != NULL);
	g_return_if_fail (dest_iter != NULL);
	_tmp0_ = self->priv->child_tree;
	_tmp1_ = *src_iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp0_, &_tmp1_, CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_COLUMN_ITEM, &_tmp2_, -1, -1);
	_g_object_unref0 (item);
	item = _tmp2_;
	g_return_if_fail (item != NULL);
	_tmp3_ = self->priv->child_tree;
	_tmp4_ = *dest_iter;
	gtk_tree_store_set (_tmp3_, &_tmp4_, CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_COLUMN_ITEM, item, -1, -1);
	_tmp5_ = self->priv->items;
	_tmp6_ = self->priv->child_tree;
	_tmp7_ = *dest_iter;
	_tmp8_ = ciano_widgets_source_list_data_model_node_wrapper_new ((GtkTreeModel*) _tmp6_, &_tmp7_);
	_tmp9_ = _tmp8_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp5_, item, _tmp9_);
	_ciano_widgets_source_list_data_model_node_wrapper_unref0 (_tmp9_);
	_g_object_unref0 (item);
}

static gint*
_vala_array_dup3 (gint* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gint));
	}
	return NULL;
}

static gint*
_vala_array_dup4 (gint* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gint));
	}
	return NULL;
}

static gboolean
ciano_widgets_source_list_data_model_real_row_drop_possible (GtkTreeDragDest* base,
                                                             GtkTreePath* dest,
                                                             GtkSelectionData* selection_data)
{
	CianoWidgetsSourceListDataModel * self;
	GtkTreeModel* model = NULL;
	GtkTreePath* src_path = NULL;
	gboolean _tmp0_ = FALSE;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreePath* _tmp2_ = NULL;
	gboolean _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreePath* child_dest = NULL;
	GtkTreePath* _tmp7_;
	gboolean _tmp8_ = FALSE;
	GtkTreePath* _tmp9_;
	gint src_depth = 0;
	GtkTreePath* _tmp12_;
	gint dest_depth = 0;
	GtkTreePath* _tmp13_;
	CianoWidgetsSourceListItem* parent = NULL;
	CianoWidgetsSourceListSortable* sortable = NULL;
	CianoWidgetsSourceListItem* _tmp35_;
	CianoWidgetsSourceListSortable* _tmp36_;
	gboolean _tmp37_ = FALSE;
	CianoWidgetsSourceListSortable* _tmp38_;
	CianoWidgetsSourceListItem* dest_item = NULL;
	CianoWidgetsSourceListItem* _tmp40_;
	CianoWidgetsSourceListItem* _tmp41_;
	CianoWidgetsSourceListItem* source_item = NULL;
	GtkTreePath* filter_src_path = NULL;
	GtkTreePath* _tmp42_;
	GtkTreePath* _tmp43_;
	GtkTreePath* _tmp44_;
	CianoWidgetsSourceListItem* _tmp47_;
	CianoWidgetsSourceListSortable* _tmp48_;
	CianoWidgetsSourceListItem* _tmp49_;
	CianoWidgetsSourceListItem* _tmp50_;
	gboolean result;
	self = (CianoWidgetsSourceListDataModel*) base;
	g_return_val_if_fail (dest != NULL, FALSE);
	g_return_val_if_fail (selection_data != NULL, FALSE);
	_tmp3_ = gtk_tree_get_row_drag_data (selection_data, &_tmp1_, &_tmp2_);
	_g_object_unref0 (model);
	_tmp4_ = _g_object_ref0 (_tmp1_);
	model = _tmp4_;
	__vala_GtkTreePath_free0 (src_path);
	src_path = _tmp2_;
	if (!_tmp3_) {
		_tmp0_ = TRUE;
	} else {
		GtkTreeModel* _tmp5_;
		GtkTreeStore* _tmp6_;
		_tmp5_ = model;
		_tmp6_ = self->priv->child_tree;
		_tmp0_ = _tmp5_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_tree_model_get_type (), GtkTreeModel);
	}
	if (_tmp0_) {
		result = FALSE;
		__vala_GtkTreePath_free0 (src_path);
		_g_object_unref0 (model);
		return result;
	}
	_tmp7_ = gtk_tree_model_filter_convert_path_to_child_path ((GtkTreeModelFilter*) self, dest);
	child_dest = _tmp7_;
	_tmp9_ = child_dest;
	if (_tmp9_ == NULL) {
		_tmp8_ = TRUE;
	} else {
		GtkTreePath* _tmp10_;
		GtkTreePath* _tmp11_;
		_tmp10_ = src_path;
		_tmp11_ = child_dest;
		_tmp8_ = gtk_tree_path_compare (_tmp10_, _tmp11_) == 0;
	}
	if (_tmp8_) {
		result = FALSE;
		__vala_GtkTreePath_free0 (child_dest);
		__vala_GtkTreePath_free0 (src_path);
		_g_object_unref0 (model);
		return result;
	}
	_tmp12_ = src_path;
	src_depth = gtk_tree_path_get_depth (_tmp12_);
	_tmp13_ = child_dest;
	dest_depth = gtk_tree_path_get_depth (_tmp13_);
	if (src_depth != dest_depth) {
		result = FALSE;
		__vala_GtkTreePath_free0 (child_dest);
		__vala_GtkTreePath_free0 (src_path);
		_g_object_unref0 (model);
		return result;
	}
	if (src_depth < 1) {
		result = FALSE;
		__vala_GtkTreePath_free0 (child_dest);
		__vala_GtkTreePath_free0 (src_path);
		_g_object_unref0 (model);
		return result;
	}
	parent = NULL;
	if (src_depth == 1) {
		CianoWidgetsSourceListExpandableItem* _tmp14_;
		CianoWidgetsSourceListExpandableItem* _tmp15_;
		CianoWidgetsSourceListItem* _tmp16_;
		_tmp14_ = ciano_widgets_source_list_data_model_get_root (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = _g_object_ref0 ((CianoWidgetsSourceListItem*) _tmp15_);
		_g_object_unref0 (parent);
		parent = _tmp16_;
	} else {
		gint* src_indices = NULL;
		GtkTreePath* _tmp17_;
		gint _tmp18_ = 0;
		gint* _tmp19_;
		gint* _tmp20_;
		gint _tmp20__length1;
		gint src_indices_length1;
		gint _src_indices_size_;
		gint* dest_indices = NULL;
		GtkTreePath* _tmp21_;
		gint _tmp22_ = 0;
		gint* _tmp23_;
		gint* _tmp24_;
		gint _tmp24__length1;
		gint dest_indices_length1;
		gint _dest_indices_size_;
		gint src_parent_index = 0;
		gint* _tmp25_;
		gint _tmp25__length1;
		gint _tmp26_;
		gint dest_parent_index = 0;
		gint* _tmp27_;
		gint _tmp27__length1;
		gint _tmp28_;
		GtkTreePath* dest_parent = NULL;
		GtkTreePath* _tmp29_;
		gboolean _tmp30_ = FALSE;
		GtkTreePath* _tmp31_;
		GtkTreePath* _tmp33_;
		CianoWidgetsSourceListItem* _tmp34_;
		_vala_assert (dest_depth > 1, "dest_depth > 1");
		_tmp17_ = src_path;
		_tmp19_ = gtk_tree_path_get_indices_with_depth (_tmp17_, &_tmp18_);
		_tmp20_ = (_tmp19_ != NULL) ? _vala_array_dup3 (_tmp19_, _tmp18_) : _tmp19_;
		_tmp20__length1 = _tmp18_;
		src_indices = _tmp20_;
		src_indices_length1 = _tmp20__length1;
		_src_indices_size_ = src_indices_length1;
		_tmp21_ = child_dest;
		_tmp23_ = gtk_tree_path_get_indices_with_depth (_tmp21_, &_tmp22_);
		_tmp24_ = (_tmp23_ != NULL) ? _vala_array_dup4 (_tmp23_, _tmp22_) : _tmp23_;
		_tmp24__length1 = _tmp22_;
		dest_indices = _tmp24_;
		dest_indices_length1 = _tmp24__length1;
		_dest_indices_size_ = dest_indices_length1;
		_tmp25_ = src_indices;
		_tmp25__length1 = src_indices_length1;
		_tmp26_ = _tmp25_[src_depth - 2];
		src_parent_index = _tmp26_;
		_tmp27_ = dest_indices;
		_tmp27__length1 = dest_indices_length1;
		_tmp28_ = _tmp27_[dest_depth - 2];
		dest_parent_index = _tmp28_;
		if (src_parent_index != dest_parent_index) {
			result = FALSE;
			dest_indices = (g_free (dest_indices), NULL);
			src_indices = (g_free (src_indices), NULL);
			_g_object_unref0 (parent);
			__vala_GtkTreePath_free0 (child_dest);
			__vala_GtkTreePath_free0 (src_path);
			_g_object_unref0 (model);
			return result;
		}
		_tmp29_ = __vala_GtkTreePath_copy0 (dest);
		dest_parent = _tmp29_;
		_tmp31_ = dest_parent;
		if (!gtk_tree_path_up (_tmp31_)) {
			_tmp30_ = TRUE;
		} else {
			GtkTreePath* _tmp32_;
			_tmp32_ = dest_parent;
			_tmp30_ = gtk_tree_path_get_depth (_tmp32_) < 1;
		}
		if (_tmp30_) {
			result = FALSE;
			__vala_GtkTreePath_free0 (dest_parent);
			dest_indices = (g_free (dest_indices), NULL);
			src_indices = (g_free (src_indices), NULL);
			_g_object_unref0 (parent);
			__vala_GtkTreePath_free0 (child_dest);
			__vala_GtkTreePath_free0 (src_path);
			_g_object_unref0 (model);
			return result;
		}
		_tmp33_ = dest_parent;
		_tmp34_ = ciano_widgets_source_list_data_model_get_item_from_path (self, _tmp33_);
		_g_object_unref0 (parent);
		parent = _tmp34_;
		__vala_GtkTreePath_free0 (dest_parent);
		dest_indices = (g_free (dest_indices), NULL);
		src_indices = (g_free (src_indices), NULL);
	}
	_tmp35_ = parent;
	_tmp36_ = _g_object_ref0 (CIANO_WIDGETS_IS_SOURCE_LIST_SORTABLE (_tmp35_) ? ((CianoWidgetsSourceListSortable*) _tmp35_) : NULL);
	sortable = _tmp36_;
	_tmp38_ = sortable;
	if (_tmp38_ == NULL) {
		_tmp37_ = TRUE;
	} else {
		CianoWidgetsSourceListSortable* _tmp39_;
		_tmp39_ = sortable;
		_tmp37_ = !ciano_widgets_source_list_sortable_allow_dnd_sorting (_tmp39_);
	}
	if (_tmp37_) {
		result = FALSE;
		_g_object_unref0 (sortable);
		_g_object_unref0 (parent);
		__vala_GtkTreePath_free0 (child_dest);
		__vala_GtkTreePath_free0 (src_path);
		_g_object_unref0 (model);
		return result;
	}
	_tmp40_ = ciano_widgets_source_list_data_model_get_item_from_path (self, dest);
	dest_item = _tmp40_;
	_tmp41_ = dest_item;
	if (_tmp41_ == NULL) {
		result = TRUE;
		_g_object_unref0 (dest_item);
		_g_object_unref0 (sortable);
		_g_object_unref0 (parent);
		__vala_GtkTreePath_free0 (child_dest);
		__vala_GtkTreePath_free0 (src_path);
		_g_object_unref0 (model);
		return result;
	}
	source_item = NULL;
	_tmp42_ = src_path;
	_tmp43_ = gtk_tree_model_filter_convert_child_path_to_path ((GtkTreeModelFilter*) self, _tmp42_);
	filter_src_path = _tmp43_;
	_tmp44_ = filter_src_path;
	if (_tmp44_ != NULL) {
		GtkTreePath* _tmp45_;
		CianoWidgetsSourceListItem* _tmp46_;
		_tmp45_ = filter_src_path;
		_tmp46_ = ciano_widgets_source_list_data_model_get_item_from_path (self, _tmp45_);
		_g_object_unref0 (source_item);
		source_item = _tmp46_;
	}
	_tmp47_ = source_item;
	if (_tmp47_ == NULL) {
		result = FALSE;
		__vala_GtkTreePath_free0 (filter_src_path);
		_g_object_unref0 (source_item);
		_g_object_unref0 (dest_item);
		_g_object_unref0 (sortable);
		_g_object_unref0 (parent);
		__vala_GtkTreePath_free0 (child_dest);
		__vala_GtkTreePath_free0 (src_path);
		_g_object_unref0 (model);
		return result;
	}
	_tmp48_ = sortable;
	_tmp49_ = dest_item;
	_tmp50_ = source_item;
	if (ciano_widgets_source_list_sortable_compare (_tmp48_, _tmp49_, _tmp50_) >= 0) {
		CianoWidgetsSourceListItem* dest_item_prev = NULL;
		CianoWidgetsSourceListItem* _tmp51_;
		gboolean _tmp52_ = FALSE;
		gboolean _tmp53_ = FALSE;
		CianoWidgetsSourceListItem* _tmp54_;
		if (!gtk_tree_path_prev (dest)) {
			result = TRUE;
			__vala_GtkTreePath_free0 (filter_src_path);
			_g_object_unref0 (source_item);
			_g_object_unref0 (dest_item);
			_g_object_unref0 (sortable);
			_g_object_unref0 (parent);
			__vala_GtkTreePath_free0 (child_dest);
			__vala_GtkTreePath_free0 (src_path);
			_g_object_unref0 (model);
			return result;
		}
		_tmp51_ = ciano_widgets_source_list_data_model_get_item_from_path (self, dest);
		dest_item_prev = _tmp51_;
		_tmp54_ = dest_item_prev;
		if (_tmp54_ != NULL) {
			CianoWidgetsSourceListItem* _tmp55_;
			CianoWidgetsSourceListItem* _tmp56_;
			_tmp55_ = dest_item_prev;
			_tmp56_ = source_item;
			_tmp53_ = _tmp55_ != _tmp56_;
		} else {
			_tmp53_ = FALSE;
		}
		if (_tmp53_) {
			CianoWidgetsSourceListSortable* _tmp57_;
			CianoWidgetsSourceListItem* _tmp58_;
			CianoWidgetsSourceListItem* _tmp59_;
			_tmp57_ = sortable;
			_tmp58_ = dest_item_prev;
			_tmp59_ = source_item;
			_tmp52_ = ciano_widgets_source_list_sortable_compare (_tmp57_, _tmp58_, _tmp59_) <= 0;
		} else {
			_tmp52_ = FALSE;
		}
		result = _tmp52_;
		_g_object_unref0 (dest_item_prev);
		__vala_GtkTreePath_free0 (filter_src_path);
		_g_object_unref0 (source_item);
		_g_object_unref0 (dest_item);
		_g_object_unref0 (sortable);
		_g_object_unref0 (parent);
		__vala_GtkTreePath_free0 (child_dest);
		__vala_GtkTreePath_free0 (src_path);
		_g_object_unref0 (model);
		return result;
	}
	result = FALSE;
	__vala_GtkTreePath_free0 (filter_src_path);
	_g_object_unref0 (source_item);
	_g_object_unref0 (dest_item);
	_g_object_unref0 (sortable);
	_g_object_unref0 (parent);
	__vala_GtkTreePath_free0 (child_dest);
	__vala_GtkTreePath_free0 (src_path);
	_g_object_unref0 (model);
	return result;
}

/**
         * Override default implementation of TreeDragSource
         *
         * drag_data_delete is not overriden because the default implementation
         * does exactly what we need.
         */
static gboolean
ciano_widgets_source_list_data_model_real_drag_data_get (GtkTreeDragSource* base,
                                                         GtkTreePath* path,
                                                         GtkSelectionData* selection_data)
{
	CianoWidgetsSourceListDataModel * self;
	CianoWidgetsSourceListDragSource* drag_source_item = NULL;
	CianoWidgetsSourceListItem* _tmp0_;
	CianoWidgetsSourceListDragSource* _tmp1_;
	gboolean _tmp2_ = FALSE;
	CianoWidgetsSourceListDragSource* _tmp3_;
	gboolean result;
	self = (CianoWidgetsSourceListDataModel*) base;
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (selection_data != NULL, FALSE);
	if (gtk_selection_data_get_target (selection_data) == gdk_atom_intern_static_string ("GTK_TREE_MODEL_ROW")) {
		result = ciano_widgets_source_list_data_model_gtk_tree_drag_source_parent_iface->drag_data_get ((GtkTreeDragSource*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_model_filter_get_type (), GtkTreeModelFilter), path, selection_data);
		return result;
	}
	_tmp0_ = ciano_widgets_source_list_data_model_get_item_from_path (self, path);
	_tmp1_ = CIANO_WIDGETS_IS_SOURCE_LIST_DRAG_SOURCE (_tmp0_) ? ((CianoWidgetsSourceListDragSource*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	drag_source_item = _tmp1_;
	_tmp3_ = drag_source_item;
	if (_tmp3_ != NULL) {
		CianoWidgetsSourceListDragSource* _tmp4_;
		_tmp4_ = drag_source_item;
		_tmp2_ = ciano_widgets_source_list_drag_source_draggable (_tmp4_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		CianoWidgetsSourceListDragSource* _tmp5_;
		_tmp5_ = drag_source_item;
		ciano_widgets_source_list_drag_source_prepare_selection_data (_tmp5_, selection_data);
		result = TRUE;
		_g_object_unref0 (drag_source_item);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (drag_source_item);
	return result;
}

static gboolean
ciano_widgets_source_list_data_model_real_row_draggable (GtkTreeDragSource* base,
                                                         GtkTreePath* path)
{
	CianoWidgetsSourceListDataModel * self;
	CianoWidgetsSourceListItem* item = NULL;
	CianoWidgetsSourceListItem* _tmp0_;
	CianoWidgetsSourceListItem* _tmp1_;
	gboolean result;
	self = (CianoWidgetsSourceListDataModel*) base;
	g_return_val_if_fail (path != NULL, FALSE);
	if (!ciano_widgets_source_list_data_model_gtk_tree_drag_source_parent_iface->row_draggable ((GtkTreeDragSource*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_model_filter_get_type (), GtkTreeModelFilter), path)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = ciano_widgets_source_list_data_model_get_item_from_path (self, path);
	item = _tmp0_;
	_tmp1_ = item;
	if (_tmp1_ != NULL) {
		CianoWidgetsSourceListSortable* sortable_item = NULL;
		CianoWidgetsSourceListItem* _tmp2_;
		CianoWidgetsSourceListExpandableItem* _tmp3_;
		CianoWidgetsSourceListExpandableItem* _tmp4_;
		CianoWidgetsSourceListSortable* _tmp5_;
		gboolean _tmp6_ = FALSE;
		CianoWidgetsSourceListSortable* _tmp7_;
		CianoWidgetsSourceListDragSource* drag_source_item = NULL;
		CianoWidgetsSourceListItem* _tmp9_;
		CianoWidgetsSourceListDragSource* _tmp10_;
		gboolean _tmp11_ = FALSE;
		CianoWidgetsSourceListDragSource* _tmp12_;
		_tmp2_ = item;
		_tmp3_ = ciano_widgets_source_list_item_get_parent (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _g_object_ref0 (CIANO_WIDGETS_IS_SOURCE_LIST_SORTABLE (_tmp4_) ? ((CianoWidgetsSourceListSortable*) _tmp4_) : NULL);
		sortable_item = _tmp5_;
		_tmp7_ = sortable_item;
		if (_tmp7_ != NULL) {
			CianoWidgetsSourceListSortable* _tmp8_;
			_tmp8_ = sortable_item;
			_tmp6_ = ciano_widgets_source_list_sortable_allow_dnd_sorting (_tmp8_);
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			result = TRUE;
			_g_object_unref0 (sortable_item);
			_g_object_unref0 (item);
			return result;
		}
		_tmp9_ = item;
		_tmp10_ = _g_object_ref0 (CIANO_WIDGETS_IS_SOURCE_LIST_DRAG_SOURCE (_tmp9_) ? ((CianoWidgetsSourceListDragSource*) _tmp9_) : NULL);
		drag_source_item = _tmp10_;
		_tmp12_ = drag_source_item;
		if (_tmp12_ != NULL) {
			CianoWidgetsSourceListDragSource* _tmp13_;
			_tmp13_ = drag_source_item;
			_tmp11_ = ciano_widgets_source_list_drag_source_draggable (_tmp13_);
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			result = TRUE;
			_g_object_unref0 (drag_source_item);
			_g_object_unref0 (sortable_item);
			_g_object_unref0 (item);
			return result;
		}
		_g_object_unref0 (drag_source_item);
		_g_object_unref0 (sortable_item);
	}
	result = FALSE;
	_g_object_unref0 (item);
	return result;
}

static CianoWidgetsSourceListExpandableItem*
ciano_widgets_source_list_data_model_get_root (CianoWidgetsSourceListDataModel* self)
{
	CianoWidgetsSourceListExpandableItem* result;
	CianoWidgetsSourceListExpandableItem* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_root;
	result = _tmp0_;
	return result;
}

static void
ciano_widgets_source_list_data_model_set_root (CianoWidgetsSourceListDataModel* self,
                                               CianoWidgetsSourceListExpandableItem* value)
{
	CianoWidgetsSourceListExpandableItem* _tmp0_;
	CianoWidgetsSourceListExpandableItem* _tmp12_;
	CianoWidgetsSourceListExpandableItem* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_root;
	if (_tmp0_ != NULL) {
		CianoWidgetsSourceListExpandableItem* _tmp1_;
		_tmp1_ = self->priv->_root;
		ciano_widgets_source_list_data_model_remove_children_monitor (self, _tmp1_);
		{
			GeeIterator* _item_it = NULL;
			CianoWidgetsSourceListExpandableItem* _tmp2_;
			GeeCollection* _tmp3_;
			GeeCollection* _tmp4_;
			GeeCollection* _tmp5_;
			GeeIterator* _tmp6_;
			GeeIterator* _tmp7_;
			_tmp2_ = self->priv->_root;
			_tmp3_ = ciano_widgets_source_list_expandable_item_get_children (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = _tmp4_;
			_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
			_tmp7_ = _tmp6_;
			_g_object_unref0 (_tmp5_);
			_item_it = _tmp7_;
			while (TRUE) {
				GeeIterator* _tmp8_;
				CianoWidgetsSourceListItem* item = NULL;
				GeeIterator* _tmp9_;
				gpointer _tmp10_;
				CianoWidgetsSourceListItem* _tmp11_;
				_tmp8_ = _item_it;
				if (!gee_iterator_next (_tmp8_)) {
					break;
				}
				_tmp9_ = _item_it;
				_tmp10_ = gee_iterator_get (_tmp9_);
				item = (CianoWidgetsSourceListItem*) _tmp10_;
				_tmp11_ = item;
				ciano_widgets_source_list_data_model_remove_item (self, _tmp11_);
				_g_object_unref0 (item);
			}
			_g_object_unref0 (_item_it);
		}
	}
	_tmp12_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_root);
	self->priv->_root = _tmp12_;
	_tmp13_ = self->priv->_root;
	ciano_widgets_source_list_data_model_add_children_monitor (self, _tmp13_);
	{
		GeeIterator* _item_it = NULL;
		CianoWidgetsSourceListExpandableItem* _tmp14_;
		GeeCollection* _tmp15_;
		GeeCollection* _tmp16_;
		GeeCollection* _tmp17_;
		GeeIterator* _tmp18_;
		GeeIterator* _tmp19_;
		_tmp14_ = self->priv->_root;
		_tmp15_ = ciano_widgets_source_list_expandable_item_get_children (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _tmp16_;
		_tmp18_ = gee_iterable_iterator ((GeeIterable*) _tmp17_);
		_tmp19_ = _tmp18_;
		_g_object_unref0 (_tmp17_);
		_item_it = _tmp19_;
		while (TRUE) {
			GeeIterator* _tmp20_;
			CianoWidgetsSourceListItem* item = NULL;
			GeeIterator* _tmp21_;
			gpointer _tmp22_;
			CianoWidgetsSourceListItem* _tmp23_;
			_tmp20_ = _item_it;
			if (!gee_iterator_next (_tmp20_)) {
				break;
			}
			_tmp21_ = _item_it;
			_tmp22_ = gee_iterator_get (_tmp21_);
			item = (CianoWidgetsSourceListItem*) _tmp22_;
			_tmp23_ = item;
			ciano_widgets_source_list_data_model_add_item (self, _tmp23_);
			_g_object_unref0 (item);
		}
		_g_object_unref0 (_item_it);
	}
	g_object_notify_by_pspec ((GObject *) self, ciano_widgets_source_list_data_model_properties[CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_ROOT_PROPERTY]);
}

static inline gpointer
ciano_widgets_source_list_data_model_node_wrapper_get_instance_private (CianoWidgetsSourceListDataModelNodeWrapper* self)
{
	return G_STRUCT_MEMBER_P (self, CianoWidgetsSourceListDataModelNodeWrapper_private_offset);
}

static void
_vala_GtkTreeRowReference_free (GtkTreeRowReference* self)
{
	g_boxed_free (gtk_tree_row_reference_get_type (), self);
}

static CianoWidgetsSourceListDataModelNodeWrapper*
ciano_widgets_source_list_data_model_node_wrapper_construct (GType object_type,
                                                             GtkTreeModel* model,
                                                             GtkTreeIter* iter)
{
	CianoWidgetsSourceListDataModelNodeWrapper* self = NULL;
	GtkTreeIter _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* _tmp2_;
	GtkTreeRowReference* _tmp3_;
	g_return_val_if_fail (model != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	self = (CianoWidgetsSourceListDataModelNodeWrapper*) g_type_create_instance (object_type);
	_tmp0_ = *iter;
	_tmp1_ = gtk_tree_model_get_path (model, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_tree_row_reference_new (model, _tmp2_);
	__vala_GtkTreeRowReference_free0 (self->priv->row_reference);
	self->priv->row_reference = _tmp3_;
	__vala_GtkTreePath_free0 (_tmp2_);
	return self;
}

static CianoWidgetsSourceListDataModelNodeWrapper*
ciano_widgets_source_list_data_model_node_wrapper_new (GtkTreeModel* model,
                                                       GtkTreeIter* iter)
{
	return ciano_widgets_source_list_data_model_node_wrapper_construct (CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_NODE_WRAPPER, model, iter);
}

static GtkTreeIter*
ciano_widgets_source_list_data_model_node_wrapper_get_iter (CianoWidgetsSourceListDataModelNodeWrapper* self)
{
	GtkTreeIter* result;
	GtkTreeIter* rv = NULL;
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	rv = NULL;
	_tmp0_ = ciano_widgets_source_list_data_model_node_wrapper_get_valid (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GtkTreePath* _path = NULL;
		GtkTreePath* _tmp2_;
		GtkTreePath* _tmp3_;
		GtkTreePath* _tmp4_;
		_tmp2_ = ciano_widgets_source_list_data_model_node_wrapper_get_path (self);
		_tmp3_ = _tmp2_;
		_path = _tmp3_;
		_tmp4_ = _path;
		if (_tmp4_ != NULL) {
			GtkTreeIter _iter = {0};
			GtkTreeRowReference* _tmp5_;
			GtkTreeModel* _tmp6_;
			GtkTreePath* _tmp7_;
			GtkTreeIter _tmp8_ = {0};
			gboolean _tmp9_;
			_tmp5_ = self->priv->row_reference;
			_tmp6_ = gtk_tree_row_reference_get_model (_tmp5_);
			_tmp7_ = _path;
			_tmp9_ = gtk_tree_model_get_iter (_tmp6_, &_tmp8_, _tmp7_);
			_iter = _tmp8_;
			if (_tmp9_) {
				GtkTreeIter _tmp10_;
				GtkTreeIter* _tmp11_;
				_tmp10_ = _iter;
				_tmp11_ = __vala_GtkTreeIter_copy0 (&_tmp10_);
				__vala_GtkTreeIter_free0 (rv);
				rv = _tmp11_;
			}
		}
		__vala_GtkTreePath_free0 (_path);
	}
	result = rv;
	return result;
}

static GtkTreePath*
ciano_widgets_source_list_data_model_node_wrapper_get_path (CianoWidgetsSourceListDataModelNodeWrapper* self)
{
	GtkTreePath* result;
	GtkTreePath* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = ciano_widgets_source_list_data_model_node_wrapper_get_valid (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkTreeRowReference* _tmp3_;
		GtkTreePath* _tmp4_;
		_tmp3_ = self->priv->row_reference;
		_tmp4_ = gtk_tree_row_reference_get_path (_tmp3_);
		__vala_GtkTreePath_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	} else {
		__vala_GtkTreePath_free0 (_tmp0_);
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

static gboolean
ciano_widgets_source_list_data_model_node_wrapper_get_valid (CianoWidgetsSourceListDataModelNodeWrapper* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	GtkTreeRowReference* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->row_reference;
	if (_tmp1_ != NULL) {
		GtkTreeRowReference* _tmp2_;
		_tmp2_ = self->priv->row_reference;
		_tmp0_ = gtk_tree_row_reference_valid (_tmp2_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
ciano_widgets_source_list_data_model_value_node_wrapper_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
ciano_widgets_source_list_data_model_value_node_wrapper_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		ciano_widgets_source_list_data_model_node_wrapper_unref (value->data[0].v_pointer);
	}
}

static void
ciano_widgets_source_list_data_model_value_node_wrapper_copy_value (const GValue* src_value,
                                                                    GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = ciano_widgets_source_list_data_model_node_wrapper_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
ciano_widgets_source_list_data_model_value_node_wrapper_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
ciano_widgets_source_list_data_model_value_node_wrapper_collect_value (GValue* value,
                                                                       guint n_collect_values,
                                                                       GTypeCValue* collect_values,
                                                                       guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		CianoWidgetsSourceListDataModelNodeWrapper * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = ciano_widgets_source_list_data_model_node_wrapper_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
ciano_widgets_source_list_data_model_value_node_wrapper_lcopy_value (const GValue* value,
                                                                     guint n_collect_values,
                                                                     GTypeCValue* collect_values,
                                                                     guint collect_flags)
{
	CianoWidgetsSourceListDataModelNodeWrapper ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = ciano_widgets_source_list_data_model_node_wrapper_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
ciano_widgets_source_list_data_model_param_spec_node_wrapper (const gchar* name,
                                                              const gchar* nick,
                                                              const gchar* blurb,
                                                              GType object_type,
                                                              GParamFlags flags)
{
	CianoWidgetsSourceListDataModelParamSpecNodeWrapper* spec;
	g_return_val_if_fail (g_type_is_a (object_type, CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_NODE_WRAPPER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
ciano_widgets_source_list_data_model_value_get_node_wrapper (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_NODE_WRAPPER), NULL);
	return value->data[0].v_pointer;
}

static void
ciano_widgets_source_list_data_model_value_set_node_wrapper (GValue* value,
                                                             gpointer v_object)
{
	CianoWidgetsSourceListDataModelNodeWrapper * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_NODE_WRAPPER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_NODE_WRAPPER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		ciano_widgets_source_list_data_model_node_wrapper_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ciano_widgets_source_list_data_model_node_wrapper_unref (old);
	}
}

static void
ciano_widgets_source_list_data_model_value_take_node_wrapper (GValue* value,
                                                              gpointer v_object)
{
	CianoWidgetsSourceListDataModelNodeWrapper * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_NODE_WRAPPER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_NODE_WRAPPER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ciano_widgets_source_list_data_model_node_wrapper_unref (old);
	}
}

static void
ciano_widgets_source_list_data_model_node_wrapper_class_init (CianoWidgetsSourceListDataModelNodeWrapperClass * klass,
                                                              gpointer klass_data)
{
	ciano_widgets_source_list_data_model_node_wrapper_parent_class = g_type_class_peek_parent (klass);
	((CianoWidgetsSourceListDataModelNodeWrapperClass *) klass)->finalize = ciano_widgets_source_list_data_model_node_wrapper_finalize;
	g_type_class_adjust_private_offset (klass, &CianoWidgetsSourceListDataModelNodeWrapper_private_offset);
}

static void
ciano_widgets_source_list_data_model_node_wrapper_instance_init (CianoWidgetsSourceListDataModelNodeWrapper * self,
                                                                 gpointer klass)
{
	self->priv = ciano_widgets_source_list_data_model_node_wrapper_get_instance_private (self);
	self->ref_count = 1;
}

static void
ciano_widgets_source_list_data_model_node_wrapper_finalize (CianoWidgetsSourceListDataModelNodeWrapper * obj)
{
	CianoWidgetsSourceListDataModelNodeWrapper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_NODE_WRAPPER, CianoWidgetsSourceListDataModelNodeWrapper);
	g_signal_handlers_destroy (self);
	__vala_GtkTreeRowReference_free0 (self->priv->row_reference);
}

/**
         * An object that references a particular row in a model. This class is a wrapper built around
         * Gtk.TreeRowReference, and exists with the purpose of ensuring we never use invalid tree paths
         * or iters in the model, since most of these errors provoke failures due to GTK+ assertions
         * or, even worse, unexpected behavior.
         */
static GType
ciano_widgets_source_list_data_model_node_wrapper_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { ciano_widgets_source_list_data_model_value_node_wrapper_init, ciano_widgets_source_list_data_model_value_node_wrapper_free_value, ciano_widgets_source_list_data_model_value_node_wrapper_copy_value, ciano_widgets_source_list_data_model_value_node_wrapper_peek_pointer, "p", ciano_widgets_source_list_data_model_value_node_wrapper_collect_value, "p", ciano_widgets_source_list_data_model_value_node_wrapper_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (CianoWidgetsSourceListDataModelNodeWrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ciano_widgets_source_list_data_model_node_wrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CianoWidgetsSourceListDataModelNodeWrapper), 0, (GInstanceInitFunc) ciano_widgets_source_list_data_model_node_wrapper_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType ciano_widgets_source_list_data_model_node_wrapper_type_id;
	ciano_widgets_source_list_data_model_node_wrapper_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CianoWidgetsSourceListDataModelNodeWrapper", &g_define_type_info, &g_define_type_fundamental_info, 0);
	CianoWidgetsSourceListDataModelNodeWrapper_private_offset = g_type_add_instance_private (ciano_widgets_source_list_data_model_node_wrapper_type_id, sizeof (CianoWidgetsSourceListDataModelNodeWrapperPrivate));
	return ciano_widgets_source_list_data_model_node_wrapper_type_id;
}

static GType
ciano_widgets_source_list_data_model_node_wrapper_get_type (void)
{
	static volatile gsize ciano_widgets_source_list_data_model_node_wrapper_type_id__once = 0;
	if (g_once_init_enter (&ciano_widgets_source_list_data_model_node_wrapper_type_id__once)) {
		GType ciano_widgets_source_list_data_model_node_wrapper_type_id;
		ciano_widgets_source_list_data_model_node_wrapper_type_id = ciano_widgets_source_list_data_model_node_wrapper_get_type_once ();
		g_once_init_leave (&ciano_widgets_source_list_data_model_node_wrapper_type_id__once, ciano_widgets_source_list_data_model_node_wrapper_type_id);
	}
	return ciano_widgets_source_list_data_model_node_wrapper_type_id__once;
}

static gpointer
ciano_widgets_source_list_data_model_node_wrapper_ref (gpointer instance)
{
	CianoWidgetsSourceListDataModelNodeWrapper * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
ciano_widgets_source_list_data_model_node_wrapper_unref (gpointer instance)
{
	CianoWidgetsSourceListDataModelNodeWrapper * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_NODE_WRAPPER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
ciano_widgets_source_list_data_model_item_monitor_get_instance_private (CianoWidgetsSourceListDataModelItemMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, CianoWidgetsSourceListDataModelItemMonitor_private_offset);
}

static void
_ciano_widgets_source_list_data_model_item_monitor_on_notify_g_object_notify (GObject* _sender,
                                                                              GParamSpec* pspec,
                                                                              gpointer self)
{
	ciano_widgets_source_list_data_model_item_monitor_on_notify ((CianoWidgetsSourceListDataModelItemMonitor*) self, pspec);
}

static CianoWidgetsSourceListDataModelItemMonitor*
ciano_widgets_source_list_data_model_item_monitor_construct (GType object_type,
                                                             CianoWidgetsSourceListItem* item)
{
	CianoWidgetsSourceListDataModelItemMonitor* self = NULL;
	CianoWidgetsSourceListItem* _tmp0_;
	g_return_val_if_fail (item != NULL, NULL);
	self = (CianoWidgetsSourceListDataModelItemMonitor*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (item);
	_g_object_unref0 (self->priv->item);
	self->priv->item = _tmp0_;
	g_signal_connect_after ((GObject*) item, "notify", (GCallback) _ciano_widgets_source_list_data_model_item_monitor_on_notify_g_object_notify, self);
	return self;
}

static CianoWidgetsSourceListDataModelItemMonitor*
ciano_widgets_source_list_data_model_item_monitor_new (CianoWidgetsSourceListItem* item)
{
	return ciano_widgets_source_list_data_model_item_monitor_construct (CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_ITEM_MONITOR, item);
}

static void
ciano_widgets_source_list_data_model_item_monitor_on_notify (CianoWidgetsSourceListDataModelItemMonitor* self,
                                                             GParamSpec* prop)
{
	CianoWidgetsSourceListItem* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prop != NULL);
	_tmp0_ = self->priv->item;
	_tmp1_ = prop->name;
	g_signal_emit (self, ciano_widgets_source_list_data_model_item_monitor_signals[CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_ITEM_MONITOR_CHANGED_SIGNAL], 0, _tmp0_, _tmp1_);
}

static void
g_cclosure_user_marshal_VOID__OBJECT_STRING (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_STRING) (gpointer data1, gpointer arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_string (param_values + 2), data2);
}

static void
ciano_widgets_source_list_data_model_value_item_monitor_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
ciano_widgets_source_list_data_model_value_item_monitor_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		ciano_widgets_source_list_data_model_item_monitor_unref (value->data[0].v_pointer);
	}
}

static void
ciano_widgets_source_list_data_model_value_item_monitor_copy_value (const GValue* src_value,
                                                                    GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = ciano_widgets_source_list_data_model_item_monitor_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
ciano_widgets_source_list_data_model_value_item_monitor_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
ciano_widgets_source_list_data_model_value_item_monitor_collect_value (GValue* value,
                                                                       guint n_collect_values,
                                                                       GTypeCValue* collect_values,
                                                                       guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		CianoWidgetsSourceListDataModelItemMonitor * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = ciano_widgets_source_list_data_model_item_monitor_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
ciano_widgets_source_list_data_model_value_item_monitor_lcopy_value (const GValue* value,
                                                                     guint n_collect_values,
                                                                     GTypeCValue* collect_values,
                                                                     guint collect_flags)
{
	CianoWidgetsSourceListDataModelItemMonitor ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = ciano_widgets_source_list_data_model_item_monitor_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
ciano_widgets_source_list_data_model_param_spec_item_monitor (const gchar* name,
                                                              const gchar* nick,
                                                              const gchar* blurb,
                                                              GType object_type,
                                                              GParamFlags flags)
{
	CianoWidgetsSourceListDataModelParamSpecItemMonitor* spec;
	g_return_val_if_fail (g_type_is_a (object_type, CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_ITEM_MONITOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
ciano_widgets_source_list_data_model_value_get_item_monitor (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_ITEM_MONITOR), NULL);
	return value->data[0].v_pointer;
}

static void
ciano_widgets_source_list_data_model_value_set_item_monitor (GValue* value,
                                                             gpointer v_object)
{
	CianoWidgetsSourceListDataModelItemMonitor * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_ITEM_MONITOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_ITEM_MONITOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		ciano_widgets_source_list_data_model_item_monitor_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ciano_widgets_source_list_data_model_item_monitor_unref (old);
	}
}

static void
ciano_widgets_source_list_data_model_value_take_item_monitor (GValue* value,
                                                              gpointer v_object)
{
	CianoWidgetsSourceListDataModelItemMonitor * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_ITEM_MONITOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_ITEM_MONITOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ciano_widgets_source_list_data_model_item_monitor_unref (old);
	}
}

static void
ciano_widgets_source_list_data_model_item_monitor_class_init (CianoWidgetsSourceListDataModelItemMonitorClass * klass,
                                                              gpointer klass_data)
{
	ciano_widgets_source_list_data_model_item_monitor_parent_class = g_type_class_peek_parent (klass);
	((CianoWidgetsSourceListDataModelItemMonitorClass *) klass)->finalize = ciano_widgets_source_list_data_model_item_monitor_finalize;
	g_type_class_adjust_private_offset (klass, &CianoWidgetsSourceListDataModelItemMonitor_private_offset);
	ciano_widgets_source_list_data_model_item_monitor_signals[CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_ITEM_MONITOR_CHANGED_SIGNAL] = g_signal_new ("changed", CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_ITEM_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_STRING, G_TYPE_NONE, 2, CIANO_WIDGETS_SOURCE_LIST_TYPE_ITEM, G_TYPE_STRING);
}

static void
ciano_widgets_source_list_data_model_item_monitor_instance_init (CianoWidgetsSourceListDataModelItemMonitor * self,
                                                                 gpointer klass)
{
	self->priv = ciano_widgets_source_list_data_model_item_monitor_get_instance_private (self);
	self->ref_count = 1;
}

static void
ciano_widgets_source_list_data_model_item_monitor_finalize (CianoWidgetsSourceListDataModelItemMonitor * obj)
{
	CianoWidgetsSourceListDataModelItemMonitor * self;
	CianoWidgetsSourceListItem* _tmp0_;
	guint _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_ITEM_MONITOR, CianoWidgetsSourceListDataModelItemMonitor);
	g_signal_handlers_destroy (self);
	_tmp0_ = self->priv->item;
	g_signal_parse_name ("notify", G_TYPE_OBJECT, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _ciano_widgets_source_list_data_model_item_monitor_on_notify_g_object_notify, self);
	_g_object_unref0 (self->priv->item);
}

/**
         * Helper object used to monitor item property changes.
         */
static GType
ciano_widgets_source_list_data_model_item_monitor_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { ciano_widgets_source_list_data_model_value_item_monitor_init, ciano_widgets_source_list_data_model_value_item_monitor_free_value, ciano_widgets_source_list_data_model_value_item_monitor_copy_value, ciano_widgets_source_list_data_model_value_item_monitor_peek_pointer, "p", ciano_widgets_source_list_data_model_value_item_monitor_collect_value, "p", ciano_widgets_source_list_data_model_value_item_monitor_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (CianoWidgetsSourceListDataModelItemMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ciano_widgets_source_list_data_model_item_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CianoWidgetsSourceListDataModelItemMonitor), 0, (GInstanceInitFunc) ciano_widgets_source_list_data_model_item_monitor_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType ciano_widgets_source_list_data_model_item_monitor_type_id;
	ciano_widgets_source_list_data_model_item_monitor_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CianoWidgetsSourceListDataModelItemMonitor", &g_define_type_info, &g_define_type_fundamental_info, 0);
	CianoWidgetsSourceListDataModelItemMonitor_private_offset = g_type_add_instance_private (ciano_widgets_source_list_data_model_item_monitor_type_id, sizeof (CianoWidgetsSourceListDataModelItemMonitorPrivate));
	return ciano_widgets_source_list_data_model_item_monitor_type_id;
}

static GType
ciano_widgets_source_list_data_model_item_monitor_get_type (void)
{
	static volatile gsize ciano_widgets_source_list_data_model_item_monitor_type_id__once = 0;
	if (g_once_init_enter (&ciano_widgets_source_list_data_model_item_monitor_type_id__once)) {
		GType ciano_widgets_source_list_data_model_item_monitor_type_id;
		ciano_widgets_source_list_data_model_item_monitor_type_id = ciano_widgets_source_list_data_model_item_monitor_get_type_once ();
		g_once_init_leave (&ciano_widgets_source_list_data_model_item_monitor_type_id__once, ciano_widgets_source_list_data_model_item_monitor_type_id);
	}
	return ciano_widgets_source_list_data_model_item_monitor_type_id__once;
}

static gpointer
ciano_widgets_source_list_data_model_item_monitor_ref (gpointer instance)
{
	CianoWidgetsSourceListDataModelItemMonitor * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
ciano_widgets_source_list_data_model_item_monitor_unref (gpointer instance)
{
	CianoWidgetsSourceListDataModelItemMonitor * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_ITEM_MONITOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
ciano_widgets_source_list_data_model_class_init (CianoWidgetsSourceListDataModelClass * klass,
                                                 gpointer klass_data)
{
	ciano_widgets_source_list_data_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CianoWidgetsSourceListDataModel_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_ciano_widgets_source_list_data_model_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_ciano_widgets_source_list_data_model_set_property;
	G_OBJECT_CLASS (klass)->finalize = ciano_widgets_source_list_data_model_finalize;
	/**
	         * Root item.
	         *
	         * This item is not actually part of the model. It's only used as a proxy
	         * for adding and removing items.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_ROOT_PROPERTY, ciano_widgets_source_list_data_model_properties[CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_ROOT_PROPERTY] = g_param_spec_object ("root", "root", "root", CIANO_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	ciano_widgets_source_list_data_model_signals[CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_ITEM_UPDATED_SIGNAL] = g_signal_new ("item-updated", CIANO_WIDGETS_SOURCE_LIST_TYPE_DATA_MODEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, CIANO_WIDGETS_SOURCE_LIST_TYPE_ITEM);
}

static void
ciano_widgets_source_list_data_model_gtk_tree_drag_source_interface_init (GtkTreeDragSourceIface * iface,
                                                                          gpointer iface_data)
{
	ciano_widgets_source_list_data_model_gtk_tree_drag_source_parent_iface = g_type_interface_peek_parent (iface);
	iface->drag_data_get = (gboolean (*) (GtkTreeDragSource*, GtkTreePath*, GtkSelectionData*)) ciano_widgets_source_list_data_model_real_drag_data_get;
	iface->row_draggable = (gboolean (*) (GtkTreeDragSource*, GtkTreePath*)) ciano_widgets_source_list_data_model_real_row_draggable;
}

static void
ciano_widgets_source_list_data_model_gtk_tree_drag_dest_interface_init (GtkTreeDragDestIface * iface,
                                                                        gpointer iface_data)
{
	ciano_widgets_source_list_data_model_gtk_tree_drag_dest_parent_iface = g_type_interface_peek_parent (iface);
	iface->drag_data_received = (gboolean (*) (GtkTreeDragDest*, GtkTreePath*, GtkSelectionData*)) ciano_widgets_source_list_data_model_real_drag_data_received;
	iface->row_drop_possible = (gboolean (*) (GtkTreeDragDest*, GtkTreePath*, GtkSelectionData*)) ciano_widgets_source_list_data_model_real_row_drop_possible;
}

static void
ciano_widgets_source_list_data_model_instance_init (CianoWidgetsSourceListDataModel * self,
                                                    gpointer klass)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	self->priv = ciano_widgets_source_list_data_model_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (CIANO_WIDGETS_SOURCE_LIST_TYPE_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_NODE_WRAPPER, (GBoxedCopyFunc) ciano_widgets_source_list_data_model_node_wrapper_ref, (GDestroyNotify) ciano_widgets_source_list_data_model_node_wrapper_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->items = _tmp0_;
	_tmp1_ = gee_hash_map_new (CIANO_WIDGETS_SOURCE_LIST_TYPE_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_ITEM_MONITOR, (GBoxedCopyFunc) ciano_widgets_source_list_data_model_item_monitor_ref, (GDestroyNotify) ciano_widgets_source_list_data_model_item_monitor_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->monitors = _tmp1_;
}

static void
ciano_widgets_source_list_data_model_finalize (GObject * obj)
{
	CianoWidgetsSourceListDataModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CIANO_WIDGETS_SOURCE_LIST_TYPE_DATA_MODEL, CianoWidgetsSourceListDataModel);
	_g_object_unref0 (self->priv->_root);
	_g_object_unref0 (self->priv->items);
	_g_object_unref0 (self->priv->monitors);
	_g_object_unref0 (self->priv->child_tree);
	G_OBJECT_CLASS (ciano_widgets_source_list_data_model_parent_class)->finalize (obj);
}

/**
     * The model backing the SourceList tree.
     *
     * It monitors item property changes, and handles children additions and removals. It also controls
     * the visibility of the items based on their "visible" property, and on their number of children,
     * if they happen to be categories. Its main purpose is to provide an easy and practical interface
     * for sorting, adding, removing and updating items, eliminating the need of repeatedly dealing with
     * the Gtk.TreeModel API directly.
     */
static GType
ciano_widgets_source_list_data_model_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CianoWidgetsSourceListDataModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ciano_widgets_source_list_data_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CianoWidgetsSourceListDataModel), 0, (GInstanceInitFunc) ciano_widgets_source_list_data_model_instance_init, NULL };
	static const GInterfaceInfo gtk_tree_drag_source_info = { (GInterfaceInitFunc) ciano_widgets_source_list_data_model_gtk_tree_drag_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gtk_tree_drag_dest_info = { (GInterfaceInitFunc) ciano_widgets_source_list_data_model_gtk_tree_drag_dest_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType ciano_widgets_source_list_data_model_type_id;
	ciano_widgets_source_list_data_model_type_id = g_type_register_static (gtk_tree_model_filter_get_type (), "CianoWidgetsSourceListDataModel", &g_define_type_info, 0);
	g_type_add_interface_static (ciano_widgets_source_list_data_model_type_id, gtk_tree_drag_source_get_type (), &gtk_tree_drag_source_info);
	g_type_add_interface_static (ciano_widgets_source_list_data_model_type_id, gtk_tree_drag_dest_get_type (), &gtk_tree_drag_dest_info);
	CianoWidgetsSourceListDataModel_private_offset = g_type_add_instance_private (ciano_widgets_source_list_data_model_type_id, sizeof (CianoWidgetsSourceListDataModelPrivate));
	return ciano_widgets_source_list_data_model_type_id;
}

static GType
ciano_widgets_source_list_data_model_get_type (void)
{
	static volatile gsize ciano_widgets_source_list_data_model_type_id__once = 0;
	if (g_once_init_enter (&ciano_widgets_source_list_data_model_type_id__once)) {
		GType ciano_widgets_source_list_data_model_type_id;
		ciano_widgets_source_list_data_model_type_id = ciano_widgets_source_list_data_model_get_type_once ();
		g_once_init_leave (&ciano_widgets_source_list_data_model_type_id__once, ciano_widgets_source_list_data_model_type_id);
	}
	return ciano_widgets_source_list_data_model_type_id__once;
}

static void
_vala_ciano_widgets_source_list_data_model_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec)
{
	CianoWidgetsSourceListDataModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CIANO_WIDGETS_SOURCE_LIST_TYPE_DATA_MODEL, CianoWidgetsSourceListDataModel);
	switch (property_id) {
		case CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_ROOT_PROPERTY:
		g_value_set_object (value, ciano_widgets_source_list_data_model_get_root (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_ciano_widgets_source_list_data_model_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec)
{
	CianoWidgetsSourceListDataModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CIANO_WIDGETS_SOURCE_LIST_TYPE_DATA_MODEL, CianoWidgetsSourceListDataModel);
	switch (property_id) {
		case CIANO_WIDGETS_SOURCE_LIST_DATA_MODEL_ROOT_PROPERTY:
		ciano_widgets_source_list_data_model_set_root (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static CianoWidgetsSourceListCellRendererIcon*
ciano_widgets_source_list_cell_renderer_icon_construct (GType object_type)
{
	CianoWidgetsSourceListCellRendererIcon * self = NULL;
	self = (CianoWidgetsSourceListCellRendererIcon*) g_object_new (object_type, NULL);
	g_object_set ((GtkCellRenderer*) self, "mode", GTK_CELL_RENDERER_MODE_ACTIVATABLE, NULL);
	g_object_set ((GtkCellRendererPixbuf*) self, "stock-size", (guint) CIANO_WIDGETS_SOURCE_LIST_CELL_RENDERER_ICON_ICON_SIZE, NULL);
	g_object_set ((GtkCellRendererPixbuf*) self, "follow-state", TRUE, NULL);
	return self;
}

static CianoWidgetsSourceListCellRendererIcon*
ciano_widgets_source_list_cell_renderer_icon_new (void)
{
	return ciano_widgets_source_list_cell_renderer_icon_construct (CIANO_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_ICON);
}

static gboolean
ciano_widgets_source_list_cell_renderer_icon_real_activate (GtkCellRenderer* base,
                                                            GdkEvent* event,
                                                            GtkWidget* widget,
                                                            const gchar* path,
                                                            GdkRectangle* background_area,
                                                            GdkRectangle* cell_area,
                                                            GtkCellRendererState flags)
{
	CianoWidgetsSourceListCellRendererIcon * self;
	gboolean result;
	self = (CianoWidgetsSourceListCellRendererIcon*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (background_area != NULL, FALSE);
	g_return_val_if_fail (cell_area != NULL, FALSE);
	g_signal_emit (self, ciano_widgets_source_list_cell_renderer_icon_signals[CIANO_WIDGETS_SOURCE_LIST_CELL_RENDERER_ICON_ACTIVATED_SIGNAL], 0, path);
	result = TRUE;
	return result;
}

static void
ciano_widgets_source_list_cell_renderer_icon_class_init (CianoWidgetsSourceListCellRendererIconClass * klass,
                                                         gpointer klass_data)
{
	ciano_widgets_source_list_cell_renderer_icon_parent_class = g_type_class_peek_parent (klass);
	((GtkCellRendererClass *) klass)->activate = (gboolean (*) (GtkCellRenderer*, GdkEvent*, GtkWidget*, const gchar*, GdkRectangle*, GdkRectangle*, GtkCellRendererState)) ciano_widgets_source_list_cell_renderer_icon_real_activate;
	ciano_widgets_source_list_cell_renderer_icon_signals[CIANO_WIDGETS_SOURCE_LIST_CELL_RENDERER_ICON_ACTIVATED_SIGNAL] = g_signal_new ("activated", CIANO_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_ICON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
ciano_widgets_source_list_cell_renderer_icon_instance_init (CianoWidgetsSourceListCellRendererIcon * self,
                                                            gpointer klass)
{
}

/**
     * Class responsible for rendering Item.icon and Item.activatable. It also
     * notifies about clicks through the activated() signal.
     */
static GType
ciano_widgets_source_list_cell_renderer_icon_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CianoWidgetsSourceListCellRendererIconClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ciano_widgets_source_list_cell_renderer_icon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CianoWidgetsSourceListCellRendererIcon), 0, (GInstanceInitFunc) ciano_widgets_source_list_cell_renderer_icon_instance_init, NULL };
	GType ciano_widgets_source_list_cell_renderer_icon_type_id;
	ciano_widgets_source_list_cell_renderer_icon_type_id = g_type_register_static (gtk_cell_renderer_pixbuf_get_type (), "CianoWidgetsSourceListCellRendererIcon", &g_define_type_info, 0);
	return ciano_widgets_source_list_cell_renderer_icon_type_id;
}

static GType
ciano_widgets_source_list_cell_renderer_icon_get_type (void)
{
	static volatile gsize ciano_widgets_source_list_cell_renderer_icon_type_id__once = 0;
	if (g_once_init_enter (&ciano_widgets_source_list_cell_renderer_icon_type_id__once)) {
		GType ciano_widgets_source_list_cell_renderer_icon_type_id;
		ciano_widgets_source_list_cell_renderer_icon_type_id = ciano_widgets_source_list_cell_renderer_icon_get_type_once ();
		g_once_init_leave (&ciano_widgets_source_list_cell_renderer_icon_type_id__once, ciano_widgets_source_list_cell_renderer_icon_type_id);
	}
	return ciano_widgets_source_list_cell_renderer_icon_type_id__once;
}

static inline gpointer
ciano_widgets_source_list_cell_renderer_spacer_get_instance_private (CianoWidgetsSourceListCellRendererSpacer* self)
{
	return G_STRUCT_MEMBER_P (self, CianoWidgetsSourceListCellRendererSpacer_private_offset);
}

static GtkSizeRequestMode
ciano_widgets_source_list_cell_renderer_spacer_real_get_request_mode (GtkCellRenderer* base)
{
	CianoWidgetsSourceListCellRendererSpacer * self;
	GtkSizeRequestMode result;
	self = (CianoWidgetsSourceListCellRendererSpacer*) base;
	result = GTK_SIZE_REQUEST_HEIGHT_FOR_WIDTH;
	return result;
}

static void
ciano_widgets_source_list_cell_renderer_spacer_real_get_preferred_width (GtkCellRenderer* base,
                                                                         GtkWidget* widget,
                                                                         gint* min_size,
                                                                         gint* natural_size)
{
	CianoWidgetsSourceListCellRendererSpacer * self;
	gint _vala_min_size = 0;
	gint _vala_natural_size = 0;
	guint _tmp0_;
	guint _tmp1_;
	self = (CianoWidgetsSourceListCellRendererSpacer*) base;
	g_return_if_fail (widget != NULL);
	g_object_get ((GtkCellRenderer*) self, "xpad", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_vala_natural_size = 2 * ((gint) _tmp1_);
	_vala_min_size = _vala_natural_size;
	if (min_size) {
		*min_size = _vala_min_size;
	}
	if (natural_size) {
		*natural_size = _vala_natural_size;
	}
}

static void
ciano_widgets_source_list_cell_renderer_spacer_real_get_preferred_height_for_width (GtkCellRenderer* base,
                                                                                    GtkWidget* widget,
                                                                                    gint width,
                                                                                    gint* min_height,
                                                                                    gint* natural_height)
{
	CianoWidgetsSourceListCellRendererSpacer * self;
	gint _vala_min_height = 0;
	gint _vala_natural_height = 0;
	guint _tmp0_;
	guint _tmp1_;
	self = (CianoWidgetsSourceListCellRendererSpacer*) base;
	g_return_if_fail (widget != NULL);
	g_object_get ((GtkCellRenderer*) self, "ypad", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_vala_natural_height = 2 * ((gint) _tmp1_);
	_vala_min_height = _vala_natural_height;
	if (min_height) {
		*min_height = _vala_min_height;
	}
	if (natural_height) {
		*natural_height = _vala_natural_height;
	}
}

static void
ciano_widgets_source_list_cell_renderer_spacer_real_render (GtkCellRenderer* base,
                                                            cairo_t* context,
                                                            GtkWidget* widget,
                                                            GdkRectangle* bg_area,
                                                            GdkRectangle* cell_area,
                                                            GtkCellRendererState flags)
{
	CianoWidgetsSourceListCellRendererSpacer * self;
	self = (CianoWidgetsSourceListCellRendererSpacer*) base;
	g_return_if_fail (context != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (bg_area != NULL);
	g_return_if_fail (cell_area != NULL);
}

static void
ciano_widgets_source_list_cell_renderer_spacer_real_get_size (GtkCellRenderer* base,
                                                              GtkWidget* widget,
                                                              GdkRectangle* cell_area,
                                                              gint* x_offset,
                                                              gint* y_offset,
                                                              gint* width,
                                                              gint* height)
{
	CianoWidgetsSourceListCellRendererSpacer * self;
	gint _vala_x_offset = 0;
	gint _vala_y_offset = 0;
	gint _vala_width = 0;
	gint _vala_height = 0;
	self = (CianoWidgetsSourceListCellRendererSpacer*) base;
	g_return_if_fail (widget != NULL);
	g_assert_not_reached ();
}

static CianoWidgetsSourceListCellRendererSpacer*
ciano_widgets_source_list_cell_renderer_spacer_construct (GType object_type)
{
	CianoWidgetsSourceListCellRendererSpacer * self = NULL;
	self = (CianoWidgetsSourceListCellRendererSpacer*) g_object_new (object_type, NULL);
	return self;
}

static CianoWidgetsSourceListCellRendererSpacer*
ciano_widgets_source_list_cell_renderer_spacer_new (void)
{
	return ciano_widgets_source_list_cell_renderer_spacer_construct (CIANO_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_SPACER);
}

static gint
ciano_widgets_source_list_cell_renderer_spacer_get_level (CianoWidgetsSourceListCellRendererSpacer* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_level;
	return result;
}

static void
ciano_widgets_source_list_cell_renderer_spacer_set_level (CianoWidgetsSourceListCellRendererSpacer* self,
                                                          gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = ciano_widgets_source_list_cell_renderer_spacer_get_level (self);
	if (old_value != value) {
		self->priv->_level = value;
		g_object_notify_by_pspec ((GObject *) self, ciano_widgets_source_list_cell_renderer_spacer_properties[CIANO_WIDGETS_SOURCE_LIST_CELL_RENDERER_SPACER_LEVEL_PROPERTY]);
	}
}

static void
ciano_widgets_source_list_cell_renderer_spacer_class_init (CianoWidgetsSourceListCellRendererSpacerClass * klass,
                                                           gpointer klass_data)
{
	ciano_widgets_source_list_cell_renderer_spacer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CianoWidgetsSourceListCellRendererSpacer_private_offset);
	((GtkCellRendererClass *) klass)->get_request_mode = (GtkSizeRequestMode (*) (GtkCellRenderer*)) ciano_widgets_source_list_cell_renderer_spacer_real_get_request_mode;
	((GtkCellRendererClass *) klass)->get_preferred_width = (void (*) (GtkCellRenderer*, GtkWidget*, gint*, gint*)) ciano_widgets_source_list_cell_renderer_spacer_real_get_preferred_width;
	((GtkCellRendererClass *) klass)->get_preferred_height_for_width = (void (*) (GtkCellRenderer*, GtkWidget*, gint, gint*, gint*)) ciano_widgets_source_list_cell_renderer_spacer_real_get_preferred_height_for_width;
	((GtkCellRendererClass *) klass)->render = (void (*) (GtkCellRenderer*, cairo_t*, GtkWidget*, GdkRectangle*, GdkRectangle*, GtkCellRendererState)) ciano_widgets_source_list_cell_renderer_spacer_real_render;
	((GtkCellRendererClass *) klass)->get_size = (void (*) (GtkCellRenderer*, GtkWidget*, GdkRectangle*, gint*, gint*, gint*, gint*)) ciano_widgets_source_list_cell_renderer_spacer_real_get_size;
	G_OBJECT_CLASS (klass)->get_property = _vala_ciano_widgets_source_list_cell_renderer_spacer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_ciano_widgets_source_list_cell_renderer_spacer_set_property;
	G_OBJECT_CLASS (klass)->finalize = ciano_widgets_source_list_cell_renderer_spacer_finalize;
	/**
	         * Indentation level represented by this cell renderer
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CIANO_WIDGETS_SOURCE_LIST_CELL_RENDERER_SPACER_LEVEL_PROPERTY, ciano_widgets_source_list_cell_renderer_spacer_properties[CIANO_WIDGETS_SOURCE_LIST_CELL_RENDERER_SPACER_LEVEL_PROPERTY] = g_param_spec_int ("level", "level", "level", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
ciano_widgets_source_list_cell_renderer_spacer_instance_init (CianoWidgetsSourceListCellRendererSpacer * self,
                                                              gpointer klass)
{
	self->priv = ciano_widgets_source_list_cell_renderer_spacer_get_instance_private (self);
	self->priv->_level = -1;
}

static void
ciano_widgets_source_list_cell_renderer_spacer_finalize (GObject * obj)
{
	CianoWidgetsSourceListCellRendererSpacer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CIANO_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_SPACER, CianoWidgetsSourceListCellRendererSpacer);
	G_OBJECT_CLASS (ciano_widgets_source_list_cell_renderer_spacer_parent_class)->finalize (obj);
}

/**
     * A cell renderer that only adds space.
     */
static GType
ciano_widgets_source_list_cell_renderer_spacer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CianoWidgetsSourceListCellRendererSpacerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ciano_widgets_source_list_cell_renderer_spacer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CianoWidgetsSourceListCellRendererSpacer), 0, (GInstanceInitFunc) ciano_widgets_source_list_cell_renderer_spacer_instance_init, NULL };
	GType ciano_widgets_source_list_cell_renderer_spacer_type_id;
	ciano_widgets_source_list_cell_renderer_spacer_type_id = g_type_register_static (gtk_cell_renderer_get_type (), "CianoWidgetsSourceListCellRendererSpacer", &g_define_type_info, 0);
	CianoWidgetsSourceListCellRendererSpacer_private_offset = g_type_add_instance_private (ciano_widgets_source_list_cell_renderer_spacer_type_id, sizeof (CianoWidgetsSourceListCellRendererSpacerPrivate));
	return ciano_widgets_source_list_cell_renderer_spacer_type_id;
}

static GType
ciano_widgets_source_list_cell_renderer_spacer_get_type (void)
{
	static volatile gsize ciano_widgets_source_list_cell_renderer_spacer_type_id__once = 0;
	if (g_once_init_enter (&ciano_widgets_source_list_cell_renderer_spacer_type_id__once)) {
		GType ciano_widgets_source_list_cell_renderer_spacer_type_id;
		ciano_widgets_source_list_cell_renderer_spacer_type_id = ciano_widgets_source_list_cell_renderer_spacer_get_type_once ();
		g_once_init_leave (&ciano_widgets_source_list_cell_renderer_spacer_type_id__once, ciano_widgets_source_list_cell_renderer_spacer_type_id);
	}
	return ciano_widgets_source_list_cell_renderer_spacer_type_id__once;
}

static void
_vala_ciano_widgets_source_list_cell_renderer_spacer_get_property (GObject * object,
                                                                   guint property_id,
                                                                   GValue * value,
                                                                   GParamSpec * pspec)
{
	CianoWidgetsSourceListCellRendererSpacer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CIANO_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_SPACER, CianoWidgetsSourceListCellRendererSpacer);
	switch (property_id) {
		case CIANO_WIDGETS_SOURCE_LIST_CELL_RENDERER_SPACER_LEVEL_PROPERTY:
		g_value_set_int (value, ciano_widgets_source_list_cell_renderer_spacer_get_level (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_ciano_widgets_source_list_cell_renderer_spacer_set_property (GObject * object,
                                                                   guint property_id,
                                                                   const GValue * value,
                                                                   GParamSpec * pspec)
{
	CianoWidgetsSourceListCellRendererSpacer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CIANO_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_SPACER, CianoWidgetsSourceListCellRendererSpacer);
	switch (property_id) {
		case CIANO_WIDGETS_SOURCE_LIST_CELL_RENDERER_SPACER_LEVEL_PROPERTY:
		ciano_widgets_source_list_cell_renderer_spacer_set_level (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
ciano_widgets_source_list_tree_get_instance_private (CianoWidgetsSourceListTree* self)
{
	return G_STRUCT_MEMBER_P (self, CianoWidgetsSourceListTree_private_offset);
}

static void
_ciano_widgets_source_list_tree_on_editing_started_gtk_cell_renderer_editing_started (GtkCellRenderer* _sender,
                                                                                      GtkCellEditable* editable,
                                                                                      const gchar* path,
                                                                                      gpointer self)
{
	ciano_widgets_source_list_tree_on_editing_started ((CianoWidgetsSourceListTree*) self, editable, path);
}

static void
_ciano_widgets_source_list_tree_on_editing_canceled_gtk_cell_renderer_editing_canceled (GtkCellRenderer* _sender,
                                                                                        gpointer self)
{
	ciano_widgets_source_list_tree_on_editing_canceled ((CianoWidgetsSourceListTree*) self);
}

static GType
ciano_widgets_source_list_tree_column_get_type_once (void)
{
	static const GEnumValue values[] = {{CIANO_WIDGETS_SOURCE_LIST_TREE_COLUMN_ITEM, "CIANO_WIDGETS_SOURCE_LIST_TREE_COLUMN_ITEM", "item"}, {CIANO_WIDGETS_SOURCE_LIST_TREE_COLUMN_N_COLS, "CIANO_WIDGETS_SOURCE_LIST_TREE_COLUMN_N_COLS", "n-cols"}, {0, NULL, NULL}};
	GType ciano_widgets_source_list_tree_column_type_id;
	ciano_widgets_source_list_tree_column_type_id = g_enum_register_static ("CianoWidgetsSourceListTreeColumn", values);
	return ciano_widgets_source_list_tree_column_type_id;
}

static GType
ciano_widgets_source_list_tree_column_get_type (void)
{
	static volatile gsize ciano_widgets_source_list_tree_column_type_id__once = 0;
	if (g_once_init_enter (&ciano_widgets_source_list_tree_column_type_id__once)) {
		GType ciano_widgets_source_list_tree_column_type_id;
		ciano_widgets_source_list_tree_column_type_id = ciano_widgets_source_list_tree_column_get_type_once ();
		g_once_init_leave (&ciano_widgets_source_list_tree_column_type_id__once, ciano_widgets_source_list_tree_column_type_id);
	}
	return ciano_widgets_source_list_tree_column_type_id__once;
}

static void
_ciano_widgets_source_list_tree_expander_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                                   GtkCellRenderer* cell,
                                                                                   GtkTreeModel* tree_model,
                                                                                   GtkTreeIter* iter,
                                                                                   gpointer self)
{
	ciano_widgets_source_list_tree_expander_cell_data_func ((CianoWidgetsSourceListTree*) self, cell_layout, cell, tree_model, iter);
}

static void
_ciano_widgets_source_list_tree_on_activatable_activated_ciano_widgets_source_list_cell_renderer_icon_activated (CianoWidgetsSourceListCellRendererIcon* _sender,
                                                                                                                 const gchar* path,
                                                                                                                 gpointer self)
{
	ciano_widgets_source_list_tree_on_activatable_activated ((CianoWidgetsSourceListTree*) self, path);
}

static void
_ciano_widgets_source_list_tree_icon_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                               GtkCellRenderer* cell,
                                                                               GtkTreeModel* tree_model,
                                                                               GtkTreeIter* iter,
                                                                               gpointer self)
{
	ciano_widgets_source_list_tree_icon_cell_data_func ((CianoWidgetsSourceListTree*) self, cell_layout, cell, tree_model, iter);
}

static void
_ciano_widgets_source_list_tree_badge_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                                GtkCellRenderer* cell,
                                                                                GtkTreeModel* tree_model,
                                                                                GtkTreeIter* iter,
                                                                                gpointer self)
{
	ciano_widgets_source_list_tree_badge_cell_data_func ((CianoWidgetsSourceListTree*) self, cell_layout, cell, tree_model, iter);
}

static void
_ciano_widgets_source_list_tree_name_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                               GtkCellRenderer* cell,
                                                                               GtkTreeModel* tree_model,
                                                                               GtkTreeIter* iter,
                                                                               gpointer self)
{
	ciano_widgets_source_list_tree_name_cell_data_func ((CianoWidgetsSourceListTree*) self, cell_layout, cell, tree_model, iter);
}

static gboolean
_ciano_widgets_source_list_tree_select_func_gtk_tree_selection_func (GtkTreeSelection* selection,
                                                                     GtkTreeModel* model,
                                                                     GtkTreePath* path,
                                                                     gboolean path_currently_selected,
                                                                     gpointer self)
{
	gboolean result;
	result = ciano_widgets_source_list_tree_select_func ((CianoWidgetsSourceListTree*) self, selection, model, path, path_currently_selected);
	return result;
}

static CianoWidgetsSourceListTree*
ciano_widgets_source_list_tree_construct (GType object_type,
                                          CianoWidgetsSourceListDataModel* data_model)
{
	CianoWidgetsSourceListTree * self = NULL;
	GtkCssProvider* _tmp0_;
	GtkCssProvider* _tmp1_;
	GtkTreeViewColumn* item_column = NULL;
	GtkTreeViewColumn* _tmp2_;
	GraniteWidgetsCellRendererExpander* _tmp3_;
	GraniteWidgetsCellRendererExpander* _tmp4_;
	GraniteWidgetsCellRendererExpander* _tmp5_;
	GraniteWidgetsCellRendererExpander* _tmp6_;
	GraniteWidgetsCellRendererExpander* _tmp7_;
	CianoWidgetsSourceListCellRendererIcon* _tmp8_;
	CianoWidgetsSourceListCellRendererIcon* _tmp9_;
	CianoWidgetsSourceListCellRendererIcon* _tmp10_;
	CianoWidgetsSourceListCellRendererIcon* _tmp11_;
	CianoWidgetsSourceListCellRendererIcon* _tmp12_;
	GraniteWidgetsCellRendererBadge* _tmp13_;
	GraniteWidgetsCellRendererBadge* _tmp14_;
	GraniteWidgetsCellRendererBadge* _tmp15_;
	GraniteWidgetsCellRendererBadge* _tmp16_;
	GraniteWidgetsCellRendererBadge* _tmp17_;
	GtkCellRendererText* _tmp18_;
	GtkCellRendererText* _tmp19_;
	GtkCellRendererText* _tmp20_;
	GtkCellRendererText* _tmp21_;
	GtkCellRendererText* _tmp22_;
	GtkCellRendererText* _tmp23_;
	GtkCellRendererText* _tmp24_;
	GtkCellRendererText* _tmp25_;
	GtkCellRendererText* _tmp26_;
	CianoWidgetsSourceListCellRendererIcon* _tmp27_;
	CianoWidgetsSourceListCellRendererIcon* _tmp28_;
	CianoWidgetsSourceListCellRendererIcon* _tmp29_;
	CianoWidgetsSourceListCellRendererIcon* _tmp30_;
	GraniteWidgetsCellRendererExpander* _tmp31_;
	gint expander_spacing = 0;
	gint _tmp32_ = 0;
	GraniteWidgetsCellRendererExpander* _tmp33_;
	GraniteWidgetsCellRendererExpander* _tmp34_;
	GraniteWidgetsCellRendererExpander* _tmp35_;
	GtkTreeSelection* selection = NULL;
	GtkTreeSelection* _tmp36_;
	GtkTreeSelection* _tmp37_;
	g_return_val_if_fail (data_model != NULL, NULL);
	self = (CianoWidgetsSourceListTree*) g_object_new (object_type, NULL);
	_tmp0_ = granite_widgets_utils_set_theming ((GtkWidget*) self, CIANO_WIDGETS_SOURCE_LIST_TREE_DEFAULT_STYLESHEET, GRANITE_STYLE_CLASS_SOURCE_LIST, GTK_STYLE_PROVIDER_PRIORITY_FALLBACK);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
	ciano_widgets_source_list_tree_set_data_model (self, data_model);
	gtk_tree_view_set_model ((GtkTreeView*) self, (GtkTreeModel*) data_model);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_FILL);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_FILL);
	g_object_set ((GtkWidget*) self, "expand", TRUE, NULL);
	gtk_tree_view_set_enable_search ((GtkTreeView*) self, FALSE);
	gtk_tree_view_set_headers_visible ((GtkTreeView*) self, FALSE);
	g_object_set ((GtkTreeView*) self, "enable-grid-lines", GTK_TREE_VIEW_GRID_LINES_NONE, NULL);
	gtk_tree_view_set_expander_column ((GtkTreeView*) self, NULL);
	gtk_tree_view_set_show_expanders ((GtkTreeView*) self, FALSE);
	_tmp2_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp2_);
	item_column = _tmp2_;
	gtk_tree_view_column_set_expand (item_column, TRUE);
	gtk_tree_view_insert_column ((GtkTreeView*) self, item_column, (gint) CIANO_WIDGETS_SOURCE_LIST_TREE_COLUMN_ITEM);
	_tmp3_ = granite_widgets_cell_renderer_expander_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->secondary_expander_cell);
	self->priv->secondary_expander_cell = _tmp3_;
	_tmp4_ = self->priv->secondary_expander_cell;
	granite_widgets_cell_renderer_expander_set_is_category_expander (_tmp4_, TRUE);
	_tmp5_ = self->priv->secondary_expander_cell;
	g_object_set ((GtkCellRenderer*) _tmp5_, "xpad", (guint) 10, NULL);
	_tmp6_ = self->priv->secondary_expander_cell;
	gtk_cell_layout_pack_end ((GtkCellLayout*) item_column, (GtkCellRenderer*) _tmp6_, FALSE);
	_tmp7_ = self->priv->secondary_expander_cell;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) item_column, (GtkCellRenderer*) _tmp7_, _ciano_widgets_source_list_tree_expander_cell_data_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp8_ = ciano_widgets_source_list_cell_renderer_icon_new ();
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->activatable_cell);
	self->priv->activatable_cell = _tmp8_;
	_tmp9_ = self->priv->activatable_cell;
	g_object_set ((GtkCellRenderer*) _tmp9_, "xpad", (guint) 6, NULL);
	_tmp10_ = self->priv->activatable_cell;
	g_signal_connect_object (_tmp10_, "activated", (GCallback) _ciano_widgets_source_list_tree_on_activatable_activated_ciano_widgets_source_list_cell_renderer_icon_activated, self, 0);
	_tmp11_ = self->priv->activatable_cell;
	gtk_cell_layout_pack_end ((GtkCellLayout*) item_column, (GtkCellRenderer*) _tmp11_, FALSE);
	_tmp12_ = self->priv->activatable_cell;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) item_column, (GtkCellRenderer*) _tmp12_, _ciano_widgets_source_list_tree_icon_cell_data_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp13_ = granite_widgets_cell_renderer_badge_new ();
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->badge_cell);
	self->priv->badge_cell = _tmp13_;
	_tmp14_ = self->priv->badge_cell;
	g_object_set ((GtkCellRenderer*) _tmp14_, "xpad", (guint) 1, NULL);
	_tmp15_ = self->priv->badge_cell;
	g_object_set ((GtkCellRenderer*) _tmp15_, "xalign", (gfloat) 1, NULL);
	_tmp16_ = self->priv->badge_cell;
	gtk_cell_layout_pack_end ((GtkCellLayout*) item_column, (GtkCellRenderer*) _tmp16_, FALSE);
	_tmp17_ = self->priv->badge_cell;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) item_column, (GtkCellRenderer*) _tmp17_, _ciano_widgets_source_list_tree_badge_cell_data_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp18_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->text_cell);
	self->priv->text_cell = _tmp18_;
	_tmp19_ = self->priv->text_cell;
	g_object_set (_tmp19_, "editable-set", TRUE, NULL);
	_tmp20_ = self->priv->text_cell;
	g_object_set (_tmp20_, "editable", FALSE, NULL);
	_tmp21_ = self->priv->text_cell;
	g_signal_connect_object ((GtkCellRenderer*) _tmp21_, "editing-started", (GCallback) _ciano_widgets_source_list_tree_on_editing_started_gtk_cell_renderer_editing_started, self, 0);
	_tmp22_ = self->priv->text_cell;
	g_signal_connect_object ((GtkCellRenderer*) _tmp22_, "editing-canceled", (GCallback) _ciano_widgets_source_list_tree_on_editing_canceled_gtk_cell_renderer_editing_canceled, self, 0);
	_tmp23_ = self->priv->text_cell;
	g_object_set (_tmp23_, "ellipsize", PANGO_ELLIPSIZE_END, NULL);
	_tmp24_ = self->priv->text_cell;
	g_object_set ((GtkCellRenderer*) _tmp24_, "xalign", (gfloat) 0, NULL);
	_tmp25_ = self->priv->text_cell;
	gtk_cell_layout_pack_end ((GtkCellLayout*) item_column, (GtkCellRenderer*) _tmp25_, TRUE);
	_tmp26_ = self->priv->text_cell;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) item_column, (GtkCellRenderer*) _tmp26_, _ciano_widgets_source_list_tree_name_cell_data_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp27_ = ciano_widgets_source_list_cell_renderer_icon_new ();
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->priv->icon_cell);
	self->priv->icon_cell = _tmp27_;
	_tmp28_ = self->priv->icon_cell;
	g_object_set ((GtkCellRenderer*) _tmp28_, "xpad", (guint) 2, NULL);
	_tmp29_ = self->priv->icon_cell;
	gtk_cell_layout_pack_end ((GtkCellLayout*) item_column, (GtkCellRenderer*) _tmp29_, FALSE);
	_tmp30_ = self->priv->icon_cell;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) item_column, (GtkCellRenderer*) _tmp30_, _ciano_widgets_source_list_tree_icon_cell_data_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp31_ = granite_widgets_cell_renderer_expander_new ();
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (self->priv->primary_expander_cell);
	self->priv->primary_expander_cell = _tmp31_;
	gtk_widget_style_get ((GtkWidget*) self, CIANO_WIDGETS_SOURCE_LIST_TREE_STYLE_PROP_EXPANDER_SPACING, &_tmp32_, NULL);
	expander_spacing = _tmp32_;
	_tmp33_ = self->priv->primary_expander_cell;
	g_object_set ((GtkCellRenderer*) _tmp33_, "xpad", (guint) (expander_spacing / 2), NULL);
	_tmp34_ = self->priv->primary_expander_cell;
	gtk_cell_layout_pack_end ((GtkCellLayout*) item_column, (GtkCellRenderer*) _tmp34_, FALSE);
	_tmp35_ = self->priv->primary_expander_cell;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) item_column, (GtkCellRenderer*) _tmp35_, _ciano_widgets_source_list_tree_expander_cell_data_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp36_ = gtk_tree_view_get_selection ((GtkTreeView*) self);
	_tmp37_ = _g_object_ref0 (_tmp36_);
	selection = _tmp37_;
	gtk_tree_selection_set_mode (selection, GTK_SELECTION_BROWSE);
	gtk_tree_selection_set_select_function (selection, _ciano_widgets_source_list_tree_select_func_gtk_tree_selection_func, g_object_ref (self), g_object_unref);
	ciano_widgets_source_list_tree_enable_item_property_monitor (self);
	ciano_widgets_source_list_tree_add_spacer_cell_for_level (self, 1, TRUE);
	ciano_widgets_source_list_tree_configure_drag_source (self, NULL, (gint) 0);
	ciano_widgets_source_list_tree_configure_drag_dest (self, NULL, (gint) 0, 0);
	_g_object_unref0 (selection);
	_g_object_unref0 (item_column);
	return self;
}

static CianoWidgetsSourceListTree*
ciano_widgets_source_list_tree_new (CianoWidgetsSourceListDataModel* data_model)
{
	return ciano_widgets_source_list_tree_construct (CIANO_WIDGETS_SOURCE_LIST_TYPE_TREE, data_model);
}

static gpointer
_gtk_target_list_ref0 (gpointer self)
{
	return self ? gtk_target_list_ref (self) : NULL;
}

static gboolean
ciano_widgets_source_list_tree_real_drag_motion (GtkWidget* base,
                                                 GdkDragContext* context,
                                                 gint x,
                                                 gint y,
                                                 guint time)
{
	CianoWidgetsSourceListTree * self;
	GtkTreePath* suggested_path = NULL;
	GtkTreePath* current_path = NULL;
	GtkTreeViewDropPosition suggested_pos = 0;
	GtkTreeViewDropPosition current_pos = 0;
	GtkTreePath* _tmp0_ = NULL;
	GtkTreeViewDropPosition _tmp1_ = 0;
	gboolean _tmp2_;
	gboolean result;
	self = (CianoWidgetsSourceListTree*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	if (!GTK_WIDGET_CLASS (ciano_widgets_source_list_tree_parent_class)->drag_motion ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), context, x, y, time)) {
		result = FALSE;
		return result;
	}
	_tmp2_ = gtk_tree_view_get_dest_row_at_pos ((GtkTreeView*) self, x, y, &_tmp0_, &_tmp1_);
	__vala_GtkTreePath_free0 (suggested_path);
	suggested_path = _tmp0_;
	suggested_pos = _tmp1_;
	if (_tmp2_) {
		GtkTreePath* _tmp3_ = NULL;
		GtkTreeViewDropPosition _tmp4_ = 0;
		gboolean _tmp5_ = FALSE;
		GtkTreePath* _tmp6_;
		gtk_tree_view_get_drag_dest_row ((GtkTreeView*) self, &_tmp3_, &_tmp4_);
		__vala_GtkTreePath_free0 (current_path);
		current_path = _tmp3_;
		current_pos = _tmp4_;
		_tmp6_ = current_path;
		if (_tmp6_ != NULL) {
			GtkTreePath* _tmp7_;
			GtkTreePath* _tmp8_;
			_tmp7_ = suggested_path;
			_tmp8_ = current_path;
			_tmp5_ = gtk_tree_path_compare (_tmp7_, _tmp8_) == 0;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			GtkWidget* source_widget = NULL;
			GtkWidget* _tmp9_;
			GtkWidget* _tmp10_;
			gboolean dragging_treemodel_row = FALSE;
			GtkWidget* _tmp11_;
			_tmp9_ = gtk_drag_get_source_widget (context);
			_tmp10_ = _g_object_ref0 (_tmp9_);
			source_widget = _tmp10_;
			_tmp11_ = source_widget;
			dragging_treemodel_row = _tmp11_ == G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget);
			if (dragging_treemodel_row) {
				if (current_pos != GTK_TREE_VIEW_DROP_BEFORE) {
					if (current_pos == GTK_TREE_VIEW_DROP_INTO_OR_BEFORE) {
						GtkTreePath* _tmp12_;
						_tmp12_ = current_path;
						gtk_tree_view_set_drag_dest_row ((GtkTreeView*) self, _tmp12_, GTK_TREE_VIEW_DROP_BEFORE);
					} else {
						gtk_tree_view_set_drag_dest_row ((GtkTreeView*) self, NULL, GTK_TREE_VIEW_DROP_AFTER);
					}
				}
			} else {
				CianoWidgetsSourceListDragDest* dest = NULL;
				CianoWidgetsSourceListDataModel* _tmp15_;
				GtkTreePath* _tmp16_;
				CianoWidgetsSourceListItem* _tmp17_;
				CianoWidgetsSourceListDragDest* _tmp18_;
				CianoWidgetsSourceListDragDest* _tmp19_;
				if (current_pos == GTK_TREE_VIEW_DROP_BEFORE) {
					GtkTreePath* _tmp13_;
					_tmp13_ = current_path;
					gtk_tree_view_set_drag_dest_row ((GtkTreeView*) self, _tmp13_, GTK_TREE_VIEW_DROP_INTO_OR_BEFORE);
				} else {
					if (current_pos == GTK_TREE_VIEW_DROP_AFTER) {
						GtkTreePath* _tmp14_;
						_tmp14_ = current_path;
						gtk_tree_view_set_drag_dest_row ((GtkTreeView*) self, _tmp14_, GTK_TREE_VIEW_DROP_INTO_OR_AFTER);
					}
				}
				_tmp15_ = self->priv->_data_model;
				_tmp16_ = current_path;
				_tmp17_ = ciano_widgets_source_list_data_model_get_item_from_path (_tmp15_, _tmp16_);
				_tmp18_ = CIANO_WIDGETS_IS_SOURCE_LIST_DRAG_DEST (_tmp17_) ? ((CianoWidgetsSourceListDragDest*) _tmp17_) : NULL;
				if (_tmp18_ == NULL) {
					_g_object_unref0 (_tmp17_);
				}
				dest = _tmp18_;
				_tmp19_ = dest;
				if (_tmp19_ != NULL) {
					GtkTargetList* target_list = NULL;
					GtkTargetList* _tmp20_;
					GtkTargetList* _tmp21_;
					GdkAtom target = (GdkAtom) 0U;
					GtkTargetList* _tmp22_;
					_tmp20_ = gtk_drag_dest_get_target_list ((GtkWidget*) self);
					_tmp21_ = _gtk_target_list_ref0 (_tmp20_);
					target_list = _tmp21_;
					_tmp22_ = target_list;
					target = gtk_drag_dest_find_target ((GtkWidget*) self, context, _tmp22_);
					g_object_set_data_full ((GObject*) context, "suggested-dnd-action", (gpointer) ((gintptr) gdk_drag_context_get_suggested_action (context)), NULL);
					gtk_drag_get_data ((GtkWidget*) self, context, target, (guint32) time);
					_gtk_target_list_unref0 (target_list);
				} else {
					gtk_tree_view_set_drag_dest_row ((GtkTreeView*) self, NULL, GTK_TREE_VIEW_DROP_BEFORE);
				}
				_g_object_unref0 (dest);
			}
			_g_object_unref0 (source_widget);
		}
	} else {
		gtk_tree_view_set_drag_dest_row ((GtkTreeView*) self, NULL, GTK_TREE_VIEW_DROP_AFTER);
		result = FALSE;
		__vala_GtkTreePath_free0 (current_path);
		__vala_GtkTreePath_free0 (suggested_path);
		return result;
	}
	result = TRUE;
	__vala_GtkTreePath_free0 (current_path);
	__vala_GtkTreePath_free0 (suggested_path);
	return result;
}

static void
ciano_widgets_source_list_tree_real_drag_data_received (GtkWidget* base,
                                                        GdkDragContext* context,
                                                        gint x,
                                                        gint y,
                                                        GtkSelectionData* selection_data,
                                                        guint info,
                                                        guint time)
{
	CianoWidgetsSourceListTree * self;
	GtkTargetList* target_list = NULL;
	GtkTargetList* _tmp0_;
	GtkTargetList* _tmp1_;
	GdkAtom target = (GdkAtom) 0U;
	GtkTargetList* _tmp2_;
	GtkTreePath* path = NULL;
	GtkTreeViewDropPosition pos = 0;
	gconstpointer _tmp3_;
	self = (CianoWidgetsSourceListTree*) base;
	g_return_if_fail (context != NULL);
	g_return_if_fail (selection_data != NULL);
	_tmp0_ = gtk_drag_dest_get_target_list ((GtkWidget*) self);
	_tmp1_ = _gtk_target_list_ref0 (_tmp0_);
	target_list = _tmp1_;
	_tmp2_ = target_list;
	target = gtk_drag_dest_find_target ((GtkWidget*) self, context, _tmp2_);
	if (target == gdk_atom_intern_static_string ("GTK_TREE_MODEL_ROW")) {
		GTK_WIDGET_CLASS (ciano_widgets_source_list_tree_parent_class)->drag_data_received ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), context, x, y, selection_data, info, time);
		_gtk_target_list_unref0 (target_list);
		return;
	}
	_tmp3_ = g_object_get_data ((GObject*) context, "suggested-dnd-action");
	if (((gint) ((gintptr) _tmp3_)) != 0) {
		GtkTreePath* _tmp4_ = NULL;
		GtkTreeViewDropPosition _tmp5_ = 0;
		GtkTreePath* _tmp6_;
		g_object_set_data_full ((GObject*) context, "suggested-dnd-action", (gpointer) ((gintptr) 0), NULL);
		gtk_tree_view_get_drag_dest_row ((GtkTreeView*) self, &_tmp4_, &_tmp5_);
		__vala_GtkTreePath_free0 (path);
		path = _tmp4_;
		pos = _tmp5_;
		_tmp6_ = path;
		if (_tmp6_ != NULL) {
			CianoWidgetsSourceListDragDest* dest = NULL;
			CianoWidgetsSourceListDataModel* _tmp7_;
			GtkTreePath* _tmp8_;
			CianoWidgetsSourceListItem* _tmp9_;
			CianoWidgetsSourceListDragDest* _tmp10_;
			gboolean _tmp11_ = FALSE;
			CianoWidgetsSourceListDragDest* _tmp12_;
			_tmp7_ = self->priv->_data_model;
			_tmp8_ = path;
			_tmp9_ = ciano_widgets_source_list_data_model_get_item_from_path (_tmp7_, _tmp8_);
			_tmp10_ = CIANO_WIDGETS_IS_SOURCE_LIST_DRAG_DEST (_tmp9_) ? ((CianoWidgetsSourceListDragDest*) _tmp9_) : NULL;
			if (_tmp10_ == NULL) {
				_g_object_unref0 (_tmp9_);
			}
			dest = _tmp10_;
			_tmp12_ = dest;
			if (_tmp12_ == NULL) {
				_tmp11_ = TRUE;
			} else {
				CianoWidgetsSourceListDragDest* _tmp13_;
				_tmp13_ = dest;
				_tmp11_ = !ciano_widgets_source_list_drag_dest_data_drop_possible (_tmp13_, context, selection_data);
			}
			if (_tmp11_) {
				gtk_tree_view_set_drag_dest_row ((GtkTreeView*) self, NULL, GTK_TREE_VIEW_DROP_BEFORE);
				gdk_drag_status (context, 0, (guint32) time);
				_g_object_unref0 (dest);
				__vala_GtkTreePath_free0 (path);
				_gtk_target_list_unref0 (target_list);
				return;
			}
			_g_object_unref0 (dest);
		}
		gdk_drag_status (context, gdk_drag_context_get_suggested_action (context), (guint32) time);
	} else {
		GtkTreePath* _tmp14_ = NULL;
		GtkTreeViewDropPosition _tmp15_ = 0;
		gboolean _tmp16_;
		_tmp16_ = gtk_tree_view_get_dest_row_at_pos ((GtkTreeView*) self, x, y, &_tmp14_, &_tmp15_);
		__vala_GtkTreePath_free0 (path);
		path = _tmp14_;
		pos = _tmp15_;
		if (_tmp16_) {
			CianoWidgetsSourceListDragDest* drag_dest = NULL;
			CianoWidgetsSourceListDataModel* _tmp17_;
			GtkTreePath* _tmp18_;
			CianoWidgetsSourceListItem* _tmp19_;
			CianoWidgetsSourceListDragDest* _tmp20_;
			CianoWidgetsSourceListDragDest* _tmp21_;
			_tmp17_ = self->priv->_data_model;
			_tmp18_ = path;
			_tmp19_ = ciano_widgets_source_list_data_model_get_item_from_path (_tmp17_, _tmp18_);
			_tmp20_ = CIANO_WIDGETS_IS_SOURCE_LIST_DRAG_DEST (_tmp19_) ? ((CianoWidgetsSourceListDragDest*) _tmp19_) : NULL;
			if (_tmp20_ == NULL) {
				_g_object_unref0 (_tmp19_);
			}
			drag_dest = _tmp20_;
			_tmp21_ = drag_dest;
			if (_tmp21_ != NULL) {
				GdkDragAction action = 0U;
				CianoWidgetsSourceListDragDest* _tmp22_;
				_tmp22_ = drag_dest;
				action = ciano_widgets_source_list_drag_dest_data_received (_tmp22_, context, selection_data);
				gtk_drag_finish (context, action != 0, action == GDK_ACTION_MOVE, (guint32) time);
				_g_object_unref0 (drag_dest);
				__vala_GtkTreePath_free0 (path);
				_gtk_target_list_unref0 (target_list);
				return;
			}
			_g_object_unref0 (drag_dest);
		}
		gtk_drag_finish (context, FALSE, FALSE, (guint32) time);
	}
	__vala_GtkTreePath_free0 (path);
	_gtk_target_list_unref0 (target_list);
}

static void
ciano_widgets_source_list_tree_configure_drag_source (CianoWidgetsSourceListTree* self,
                                                      GtkTargetEntry* src_entries,
                                                      gint src_entries_length1)
{
	GtkTargetEntry* entries = NULL;
	gint _tmp0_ = 0;
	GtkTargetEntry* _tmp1_;
	gint entries_length1;
	gint _entries_size_;
	g_return_if_fail (self != NULL);
	_tmp1_ = ciano_widgets_source_list_tree_append_row_target_entry (src_entries, (gint) src_entries_length1, &_tmp0_);
	entries = _tmp1_;
	entries_length1 = _tmp0_;
	_entries_size_ = entries_length1;
	gtk_tree_view_unset_rows_drag_source ((GtkTreeView*) self);
	gtk_tree_view_enable_model_drag_source ((GtkTreeView*) self, GDK_BUTTON1_MASK, entries, (gint) entries_length1, GDK_ACTION_MOVE);
	entries = (g_free (entries), NULL);
}

static void
ciano_widgets_source_list_tree_configure_drag_dest (CianoWidgetsSourceListTree* self,
                                                    GtkTargetEntry* dest_entries,
                                                    gint dest_entries_length1,
                                                    GdkDragAction actions)
{
	GtkTargetEntry* entries = NULL;
	gint _tmp0_ = 0;
	GtkTargetEntry* _tmp1_;
	gint entries_length1;
	gint _entries_size_;
	g_return_if_fail (self != NULL);
	_tmp1_ = ciano_widgets_source_list_tree_append_row_target_entry (dest_entries, (gint) dest_entries_length1, &_tmp0_);
	entries = _tmp1_;
	entries_length1 = _tmp0_;
	_entries_size_ = entries_length1;
	gtk_tree_view_unset_rows_drag_dest ((GtkTreeView*) self);
	gtk_tree_view_enable_model_drag_dest ((GtkTreeView*) self, entries, (gint) entries_length1, GDK_ACTION_MOVE | actions);
	entries = (g_free (entries), NULL);
}

static void
_vala_array_add1 (GtkTargetEntry* * array,
                  gint* length,
                  gint* size,
                  const GtkTargetEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkTargetEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add2 (GtkTargetEntry* * array,
                  gint* length,
                  gint* size,
                  const GtkTargetEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkTargetEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static GtkTargetEntry*
ciano_widgets_source_list_tree_append_row_target_entry (GtkTargetEntry* orig,
                                                        gint orig_length1,
                                                        gint* result_length1)
{
	static const GtkTargetEntry row_target_entry = {"GTK_TREE_MODEL_ROW", (guint) GTK_TARGET_SAME_WIDGET, (guint) 0};
	GtkTargetEntry* entries = NULL;
	GtkTargetEntry* _tmp0_;
	gint entries_length1;
	gint _entries_size_;
	GtkTargetEntry* _tmp2_;
	gint _tmp2__length1;
	GtkTargetEntry* result;
	_tmp0_ = g_new0 (GtkTargetEntry, 0);
	entries = _tmp0_;
	entries_length1 = 0;
	_entries_size_ = entries_length1;
	_vala_array_add1 (&entries, &entries_length1, &_entries_size_, &row_target_entry);
	if (orig != NULL) {
		{
			GtkTargetEntry* target_entry_collection = NULL;
			gint target_entry_collection_length1 = 0;
			gint _target_entry_collection_size_ = 0;
			gint target_entry_it = 0;
			target_entry_collection = orig;
			target_entry_collection_length1 = orig_length1;
			for (target_entry_it = 0; target_entry_it < target_entry_collection_length1; target_entry_it = target_entry_it + 1) {
				GtkTargetEntry target_entry = {0};
				target_entry = target_entry_collection[target_entry_it];
				{
					GtkTargetEntry _tmp1_;
					_tmp1_ = target_entry;
					_vala_array_add2 (&entries, &entries_length1, &_entries_size_, &_tmp1_);
				}
			}
		}
	}
	_tmp2_ = entries;
	_tmp2__length1 = entries_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
_ciano_widgets_source_list_tree_on_model_item_updated_ciano_widgets_source_list_data_model_item_updated (CianoWidgetsSourceListDataModel* _sender,
                                                                                                         CianoWidgetsSourceListItem* item,
                                                                                                         gpointer self)
{
	ciano_widgets_source_list_tree_on_model_item_updated ((CianoWidgetsSourceListTree*) self, item);
}

static void
ciano_widgets_source_list_tree_enable_item_property_monitor (CianoWidgetsSourceListTree* self)
{
	CianoWidgetsSourceListDataModel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_data_model;
	g_signal_connect_object (_tmp0_, "item-updated", (GCallback) _ciano_widgets_source_list_tree_on_model_item_updated_ciano_widgets_source_list_data_model_item_updated, self, G_CONNECT_AFTER);
}

static void
ciano_widgets_source_list_tree_disable_item_property_monitor (CianoWidgetsSourceListTree* self)
{
	CianoWidgetsSourceListDataModel* _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_data_model;
	g_signal_parse_name ("item-updated", CIANO_WIDGETS_SOURCE_LIST_TYPE_DATA_MODEL, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _ciano_widgets_source_list_tree_on_model_item_updated_ciano_widgets_source_list_data_model_item_updated, self);
}

static void
ciano_widgets_source_list_tree_on_model_item_updated (CianoWidgetsSourceListTree* self,
                                                      CianoWidgetsSourceListItem* item)
{
	CianoWidgetsSourceListExpandableItem* expandable_item = NULL;
	CianoWidgetsSourceListExpandableItem* _tmp0_;
	CianoWidgetsSourceListExpandableItem* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = _g_object_ref0 (CIANO_WIDGETS_SOURCE_LIST_IS_EXPANDABLE_ITEM (item) ? ((CianoWidgetsSourceListExpandableItem*) item) : NULL);
	expandable_item = _tmp0_;
	_tmp1_ = expandable_item;
	if (_tmp1_ != NULL) {
		CianoWidgetsSourceListExpandableItem* _tmp2_;
		_tmp2_ = expandable_item;
		ciano_widgets_source_list_tree_update_expansion (self, _tmp2_);
	}
	_g_object_unref0 (expandable_item);
}

static void
_ciano_widgets_source_list_tree_spacer_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                                 GtkCellRenderer* cell,
                                                                                 GtkTreeModel* tree_model,
                                                                                 GtkTreeIter* iter,
                                                                                 gpointer self)
{
	ciano_widgets_source_list_tree_spacer_cell_data_func (cell_layout, cell, tree_model, iter);
}

static void
ciano_widgets_source_list_tree_add_spacer_cell_for_level (CianoWidgetsSourceListTree* self,
                                                          gint level,
                                                          gboolean check_previous)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp2_;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (level > 0, "level > 0");
	_tmp0_ = self->priv->spacer_cells;
	if (_tmp0_ == NULL) {
		GeeHashMap* _tmp1_;
		_tmp1_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, CIANO_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_SPACER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (self->priv->spacer_cells);
		self->priv->spacer_cells = _tmp1_;
	}
	_tmp2_ = self->priv->spacer_cells;
	if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp2_, (gpointer) ((gintptr) level))) {
		CianoWidgetsSourceListCellRendererSpacer* spacer_cell = NULL;
		CianoWidgetsSourceListCellRendererSpacer* _tmp3_;
		CianoWidgetsSourceListCellRendererSpacer* _tmp4_;
		GeeHashMap* _tmp5_;
		CianoWidgetsSourceListCellRendererSpacer* _tmp6_;
		guint cell_xpadding = 0U;
		CianoWidgetsSourceListCellRendererSpacer* _tmp9_;
		GtkTreeViewColumn* item_column = NULL;
		GtkTreeViewColumn* _tmp10_;
		GtkTreeViewColumn* _tmp11_;
		GtkTreeViewColumn* _tmp12_;
		CianoWidgetsSourceListCellRendererSpacer* _tmp13_;
		GtkTreeViewColumn* _tmp14_;
		CianoWidgetsSourceListCellRendererSpacer* _tmp15_;
		_tmp3_ = ciano_widgets_source_list_cell_renderer_spacer_new ();
		g_object_ref_sink (_tmp3_);
		spacer_cell = _tmp3_;
		_tmp4_ = spacer_cell;
		ciano_widgets_source_list_cell_renderer_spacer_set_level (_tmp4_, level);
		_tmp5_ = self->priv->spacer_cells;
		_tmp6_ = spacer_cell;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp5_, (gpointer) ((gintptr) level), _tmp6_);
		switch (level) {
			case 1:
			{
				gint left_padding = 0;
				gint _tmp7_ = 0;
				gtk_widget_style_get ((GtkWidget*) self, CIANO_WIDGETS_SOURCE_LIST_TREE_STYLE_PROP_LEFT_PADDING, &_tmp7_, NULL);
				left_padding = _tmp7_;
				cell_xpadding = (guint) (left_padding / 2);
				break;
			}
			case 2:
			{
				cell_xpadding = (guint) 0;
				break;
			}
			default:
			{
				gint level_indentation = 0;
				gint _tmp8_ = 0;
				gtk_widget_style_get ((GtkWidget*) self, CIANO_WIDGETS_SOURCE_LIST_TREE_STYLE_PROP_LEVEL_INDENTATION, &_tmp8_, NULL);
				level_indentation = _tmp8_;
				cell_xpadding = (guint) (level_indentation / 2);
				break;
			}
		}
		_tmp9_ = spacer_cell;
		g_object_set ((GtkCellRenderer*) _tmp9_, "xpad", cell_xpadding, NULL);
		_tmp10_ = gtk_tree_view_get_column ((GtkTreeView*) self, (gint) CIANO_WIDGETS_SOURCE_LIST_TREE_COLUMN_ITEM);
		_tmp11_ = _g_object_ref0 (_tmp10_);
		item_column = _tmp11_;
		_tmp12_ = item_column;
		_tmp13_ = spacer_cell;
		gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp12_, (GtkCellRenderer*) _tmp13_, FALSE);
		_tmp14_ = item_column;
		_tmp15_ = spacer_cell;
		gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp14_, (GtkCellRenderer*) _tmp15_, _ciano_widgets_source_list_tree_spacer_cell_data_func_gtk_cell_layout_data_func, NULL, NULL);
		if (check_previous) {
			{
				gint i = 0;
				i = level - 1;
				{
					gboolean _tmp16_ = FALSE;
					_tmp16_ = TRUE;
					while (TRUE) {
						if (!_tmp16_) {
							gint _tmp17_;
							_tmp17_ = i;
							i = _tmp17_ - 1;
						}
						_tmp16_ = FALSE;
						if (!(i > 0)) {
							break;
						}
						ciano_widgets_source_list_tree_add_spacer_cell_for_level (self, i, FALSE);
					}
				}
			}
		}
		_g_object_unref0 (item_column);
		_g_object_unref0 (spacer_cell);
	}
}

/**
         * Evaluates whether the item at the specified path can be selected or not.
         */
static gboolean
ciano_widgets_source_list_tree_select_func (CianoWidgetsSourceListTree* self,
                                            GtkTreeSelection* selection,
                                            GtkTreeModel* model,
                                            GtkTreePath* path,
                                            gboolean path_currently_selected)
{
	gboolean selectable = FALSE;
	CianoWidgetsSourceListItem* item = NULL;
	CianoWidgetsSourceListDataModel* _tmp0_;
	CianoWidgetsSourceListItem* _tmp1_;
	CianoWidgetsSourceListItem* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (selection != NULL, FALSE);
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	selectable = FALSE;
	_tmp0_ = self->priv->_data_model;
	_tmp1_ = ciano_widgets_source_list_data_model_get_item_from_path (_tmp0_, path);
	item = _tmp1_;
	_tmp2_ = item;
	if (_tmp2_ != NULL) {
		CianoWidgetsSourceListDataModel* _tmp3_;
		CianoWidgetsSourceListItem* _tmp4_;
		_tmp3_ = self->priv->_data_model;
		_tmp4_ = item;
		if (!ciano_widgets_source_list_data_model_is_category (_tmp3_, _tmp4_, NULL, path)) {
			CianoWidgetsSourceListItem* _tmp5_;
			gboolean _tmp6_;
			gboolean _tmp7_;
			_tmp5_ = item;
			_tmp6_ = ciano_widgets_source_list_item_get_selectable (_tmp5_);
			_tmp7_ = _tmp6_;
			selectable = _tmp7_;
		}
	}
	result = selectable;
	_g_object_unref0 (item);
	return result;
}

static void
__vala_GtkTreePath_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL));
}

static inline void
_g_list_free___vala_GtkTreePath_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) __vala_GtkTreePath_free0_);
}

static GtkTreePath*
ciano_widgets_source_list_tree_get_selected_path (CianoWidgetsSourceListTree* self)
{
	GtkTreePath* selected_path = NULL;
	GtkTreeSelection* selection = NULL;
	GtkTreeSelection* _tmp0_;
	GtkTreeSelection* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GtkTreeSelection* _tmp11_;
	GtkTreePath* result;
	g_return_val_if_fail (self != NULL, NULL);
	selected_path = NULL;
	_tmp0_ = gtk_tree_view_get_selection ((GtkTreeView*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	selection = _tmp1_;
	_tmp2_ = selection;
	if (_tmp2_ != NULL) {
		GtkTreeModel* model = NULL;
		GList* selected_rows = NULL;
		GtkTreeSelection* _tmp3_;
		GtkTreeModel* _tmp4_ = NULL;
		GList* _tmp5_;
		GtkTreeModel* _tmp6_;
		GList* _tmp7_;
		_tmp3_ = selection;
		_tmp5_ = gtk_tree_selection_get_selected_rows (_tmp3_, &_tmp4_);
		_g_object_unref0 (model);
		_tmp6_ = _g_object_ref0 (_tmp4_);
		model = _tmp6_;
		selected_rows = _tmp5_;
		_tmp7_ = selected_rows;
		if (g_list_length (_tmp7_) == ((guint) 1)) {
			GList* _tmp8_;
			gconstpointer _tmp9_;
			GtkTreePath* _tmp10_;
			_tmp8_ = selected_rows;
			_tmp9_ = g_list_nth_data (_tmp8_, (guint) 0);
			_tmp10_ = __vala_GtkTreePath_copy0 ((GtkTreePath*) _tmp9_);
			__vala_GtkTreePath_free0 (selected_path);
			selected_path = _tmp10_;
		}
		(selected_rows == NULL) ? NULL : (selected_rows = (_g_list_free___vala_GtkTreePath_free0_ (selected_rows), NULL));
		_g_object_unref0 (model);
	}
	_tmp11_ = selection;
	gtk_tree_selection_unselect_all (_tmp11_);
	result = selected_path;
	_g_object_unref0 (selection);
	return result;
}

static void
ciano_widgets_source_list_tree_set_selected (CianoWidgetsSourceListTree* self,
                                             CianoWidgetsSourceListItem* item,
                                             gboolean scroll_to_item)
{
	g_return_if_fail (self != NULL);
	if (item == NULL) {
		GtkTreeSelection* selection = NULL;
		GtkTreeSelection* _tmp0_;
		GtkTreeSelection* _tmp1_;
		GtkTreeSelection* _tmp2_;
		_tmp0_ = gtk_tree_view_get_selection ((GtkTreeView*) self);
		_tmp1_ = _g_object_ref0 (_tmp0_);
		selection = _tmp1_;
		_tmp2_ = selection;
		if (_tmp2_ != NULL) {
			GtkTreeSelection* _tmp3_;
			_tmp3_ = selection;
			gtk_tree_selection_unselect_all (_tmp3_);
		}
		_g_object_unref0 (self->priv->selected);
		self->priv->selected = NULL;
		g_signal_emit (self, ciano_widgets_source_list_tree_signals[CIANO_WIDGETS_SOURCE_LIST_TREE_ITEM_SELECTED_SIGNAL], 0, NULL);
		_g_object_unref0 (selection);
	} else {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = ciano_widgets_source_list_item_get_selectable (item);
		_tmp5_ = _tmp4_;
		if (_tmp5_) {
			GtkTreePath* to_select = NULL;
			CianoWidgetsSourceListDataModel* _tmp6_;
			GtkTreePath* _tmp7_;
			GtkTreePath* _tmp8_;
			if (scroll_to_item) {
				ciano_widgets_source_list_tree_scroll_to_item (self, item, FALSE, (gfloat) 0);
			}
			_tmp6_ = self->priv->_data_model;
			_tmp7_ = ciano_widgets_source_list_data_model_get_item_path (_tmp6_, item);
			to_select = _tmp7_;
			_tmp8_ = to_select;
			if (_tmp8_ != NULL) {
				GtkTreePath* _tmp9_;
				GtkTreeViewColumn* _tmp10_;
				GtkCellRendererText* _tmp11_;
				_tmp9_ = to_select;
				_tmp10_ = gtk_tree_view_get_column ((GtkTreeView*) self, (gint) CIANO_WIDGETS_SOURCE_LIST_TREE_COLUMN_ITEM);
				_tmp11_ = self->priv->text_cell;
				gtk_tree_view_set_cursor_on_cell ((GtkTreeView*) self, _tmp9_, _tmp10_, (GtkCellRenderer*) _tmp11_, FALSE);
			}
			__vala_GtkTreePath_free0 (to_select);
		}
	}
}

static void
ciano_widgets_source_list_tree_real_cursor_changed (GtkTreeView* base)
{
	CianoWidgetsSourceListTree * self;
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp0_;
	CianoWidgetsSourceListItem* _tmp1_ = NULL;
	GtkTreePath* _tmp2_;
	CianoWidgetsSourceListItem* new_item = NULL;
	CianoWidgetsSourceListItem* _tmp6_;
	CianoWidgetsSourceListItem* _tmp7_;
	self = (CianoWidgetsSourceListTree*) base;
	_tmp0_ = ciano_widgets_source_list_tree_get_selected_path (self);
	path = _tmp0_;
	_tmp2_ = path;
	if (_tmp2_ != NULL) {
		CianoWidgetsSourceListDataModel* _tmp3_;
		GtkTreePath* _tmp4_;
		CianoWidgetsSourceListItem* _tmp5_;
		_tmp3_ = self->priv->_data_model;
		_tmp4_ = path;
		_tmp5_ = ciano_widgets_source_list_data_model_get_item_from_path (_tmp3_, _tmp4_);
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp5_;
	} else {
		_g_object_unref0 (_tmp1_);
		_tmp1_ = NULL;
	}
	_tmp6_ = _g_object_ref0 (_tmp1_);
	new_item = _tmp6_;
	_tmp7_ = new_item;
	if (_tmp7_ != NULL) {
		CianoWidgetsSourceListItem* _tmp8_;
		CianoWidgetsSourceListItem* _tmp9_;
		CianoWidgetsSourceListItem* _tmp10_;
		_tmp8_ = new_item;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		_g_object_unref0 (self->priv->selected);
		self->priv->selected = _tmp9_;
		_tmp10_ = new_item;
		g_signal_emit (self, ciano_widgets_source_list_tree_signals[CIANO_WIDGETS_SOURCE_LIST_TREE_ITEM_SELECTED_SIGNAL], 0, _tmp10_);
	}
	_g_object_unref0 (new_item);
	_g_object_unref0 (_tmp1_);
	__vala_GtkTreePath_free0 (path);
}

static gboolean
ciano_widgets_source_list_tree_scroll_to_item (CianoWidgetsSourceListTree* self,
                                               CianoWidgetsSourceListItem* item,
                                               gboolean use_align,
                                               gfloat row_align)
{
	gboolean scrolled = FALSE;
	GtkTreePath* path = NULL;
	CianoWidgetsSourceListDataModel* _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	scrolled = FALSE;
	_tmp0_ = self->priv->_data_model;
	_tmp1_ = ciano_widgets_source_list_data_model_get_item_path (_tmp0_, item);
	path = _tmp1_;
	_tmp2_ = path;
	if (_tmp2_ != NULL) {
		GtkTreePath* _tmp3_;
		_tmp3_ = path;
		gtk_tree_view_scroll_to_cell ((GtkTreeView*) self, _tmp3_, NULL, use_align, row_align, (gfloat) 0);
		scrolled = TRUE;
	}
	result = scrolled;
	__vala_GtkTreePath_free0 (path);
	return result;
}

static gboolean
ciano_widgets_source_list_tree_start_editing_item (CianoWidgetsSourceListTree* self,
                                                   CianoWidgetsSourceListItem* item)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GtkTreePath* path = NULL;
	CianoWidgetsSourceListDataModel* _tmp8_;
	GtkTreePath* _tmp9_;
	GtkTreePath* _tmp10_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp0_ = ciano_widgets_source_list_item_get_editable (item);
	_tmp1_ = _tmp0_;
	_vala_return_val_if_fail (_tmp1_, "item.editable", FALSE);
	_tmp2_ = ciano_widgets_source_list_item_get_selectable (item);
	_tmp3_ = _tmp2_;
	_vala_return_val_if_fail (_tmp3_, "item.selectable", FALSE);
	_tmp5_ = ciano_widgets_source_list_tree_get_editing (self);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		CianoWidgetsSourceListItem* _tmp7_;
		_tmp7_ = self->priv->edited;
		_tmp4_ = item == _tmp7_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		result = FALSE;
		return result;
	}
	_tmp8_ = self->priv->_data_model;
	_tmp9_ = ciano_widgets_source_list_data_model_get_item_path (_tmp8_, item);
	path = _tmp9_;
	_tmp10_ = path;
	if (_tmp10_ != NULL) {
		GtkCellRendererText* _tmp11_;
		GtkTreePath* _tmp12_;
		GtkTreeViewColumn* _tmp13_;
		GtkCellRendererText* _tmp14_;
		self->priv->edited = item;
		_tmp11_ = self->priv->text_cell;
		g_object_set (_tmp11_, "editable", TRUE, NULL);
		_tmp12_ = path;
		_tmp13_ = gtk_tree_view_get_column ((GtkTreeView*) self, (gint) CIANO_WIDGETS_SOURCE_LIST_TREE_COLUMN_ITEM);
		_tmp14_ = self->priv->text_cell;
		gtk_tree_view_set_cursor_on_cell ((GtkTreeView*) self, _tmp12_, _tmp13_, (GtkCellRenderer*) _tmp14_, TRUE);
	} else {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp15_ = ciano_widgets_source_list_item_get_name (item);
		_tmp16_ = _tmp15_;
		g_warning ("SourceList.vala:2022: Could not edit \"%s\": path not found", _tmp16_);
	}
	_tmp17_ = ciano_widgets_source_list_tree_get_editing (self);
	_tmp18_ = _tmp17_;
	result = _tmp18_;
	__vala_GtkTreePath_free0 (path);
	return result;
}

static void
ciano_widgets_source_list_tree_stop_editing (CianoWidgetsSourceListTree* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp1_ = ciano_widgets_source_list_tree_get_editing (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		CianoWidgetsSourceListItem* _tmp3_;
		_tmp3_ = self->priv->edited;
		_tmp0_ = _tmp3_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkTreePath* path = NULL;
		CianoWidgetsSourceListDataModel* _tmp4_;
		CianoWidgetsSourceListItem* _tmp5_;
		GtkTreePath* _tmp6_;
		GtkTreePath* _tmp7_;
		_tmp4_ = self->priv->_data_model;
		_tmp5_ = self->priv->edited;
		_tmp6_ = ciano_widgets_source_list_data_model_get_item_path (_tmp4_, _tmp5_);
		path = _tmp6_;
		_tmp7_ = path;
		if (_tmp7_ != NULL) {
			GtkTreePath* _tmp8_;
			GtkTreeViewColumn* _tmp9_;
			GtkCellRendererText* _tmp10_;
			_tmp8_ = path;
			_tmp9_ = gtk_tree_view_get_column ((GtkTreeView*) self, (gint) CIANO_WIDGETS_SOURCE_LIST_TREE_COLUMN_ITEM);
			_tmp10_ = self->priv->text_cell;
			gtk_tree_view_set_cursor_on_cell ((GtkTreeView*) self, _tmp8_, _tmp9_, (GtkCellRenderer*) _tmp10_, FALSE);
		}
		__vala_GtkTreePath_free0 (path);
	}
}

static void
_ciano_widgets_source_list_tree_on_editing_done_gtk_cell_editable_editing_done (GtkCellEditable* _sender,
                                                                                gpointer self)
{
	ciano_widgets_source_list_tree_on_editing_done ((CianoWidgetsSourceListTree*) self);
}

static void
ciano_widgets_source_list_tree_on_editing_started (CianoWidgetsSourceListTree* self,
                                                   GtkCellEditable* editable,
                                                   const gchar* path)
{
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editable != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (editable, gtk_entry_get_type ()) ? ((GtkEntry*) editable) : NULL);
	_g_object_unref0 (self->priv->editable_entry);
	self->priv->editable_entry = _tmp0_;
	_tmp1_ = self->priv->editable_entry;
	if (_tmp1_ != NULL) {
		GtkEntry* _tmp2_;
		GtkEntry* _tmp3_;
		_tmp2_ = self->priv->editable_entry;
		g_signal_connect_object ((GtkCellEditable*) _tmp2_, "editing-done", (GCallback) _ciano_widgets_source_list_tree_on_editing_done_gtk_cell_editable_editing_done, self, 0);
		_tmp3_ = self->priv->editable_entry;
		g_object_set (_tmp3_, "editable", TRUE, NULL);
	}
}

static void
ciano_widgets_source_list_tree_on_editing_canceled (CianoWidgetsSourceListTree* self)
{
	GtkEntry* _tmp0_;
	GtkCellRendererText* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->editable_entry;
	if (_tmp0_ != NULL) {
		GtkEntry* _tmp1_;
		GtkEntry* _tmp2_;
		guint _tmp3_;
		_tmp1_ = self->priv->editable_entry;
		g_object_set (_tmp1_, "editable", FALSE, NULL);
		_tmp2_ = self->priv->editable_entry;
		g_signal_parse_name ("editing-done", gtk_cell_editable_get_type (), &_tmp3_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkCellEditable*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _ciano_widgets_source_list_tree_on_editing_done_gtk_cell_editable_editing_done, self);
	}
	_tmp4_ = self->priv->text_cell;
	g_object_set (_tmp4_, "editable", FALSE, NULL);
	self->priv->edited = NULL;
}

static void
ciano_widgets_source_list_tree_on_editing_done (CianoWidgetsSourceListTree* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	CianoWidgetsSourceListItem* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp2_ = self->priv->edited;
	if (_tmp2_ != NULL) {
		CianoWidgetsSourceListItem* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = self->priv->edited;
		_tmp4_ = ciano_widgets_source_list_item_get_editable (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GtkEntry* _tmp6_;
		_tmp6_ = self->priv->editable_entry;
		_tmp0_ = _tmp6_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		CianoWidgetsSourceListItem* _tmp7_;
		GtkEntry* _tmp8_;
		const gchar* _tmp9_;
		_tmp7_ = self->priv->edited;
		_tmp8_ = self->priv->editable_entry;
		_tmp9_ = gtk_entry_get_text (_tmp8_);
		g_signal_emit (_tmp7_, ciano_widgets_source_list_item_signals[CIANO_WIDGETS_SOURCE_LIST_ITEM_EDITED_SIGNAL], 0, _tmp9_);
	}
	ciano_widgets_source_list_tree_on_editing_canceled (self);
}

static void
ciano_widgets_source_list_tree_on_activatable_activated (CianoWidgetsSourceListTree* self,
                                                         const gchar* item_path_str)
{
	CianoWidgetsSourceListItem* item = NULL;
	CianoWidgetsSourceListItem* _tmp0_;
	CianoWidgetsSourceListItem* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item_path_str != NULL);
	_tmp0_ = ciano_widgets_source_list_tree_get_item_from_path_string (self, item_path_str);
	item = _tmp0_;
	_tmp1_ = item;
	if (_tmp1_ != NULL) {
		CianoWidgetsSourceListItem* _tmp2_;
		_tmp2_ = item;
		g_signal_emit (_tmp2_, ciano_widgets_source_list_item_signals[CIANO_WIDGETS_SOURCE_LIST_ITEM_ACTION_ACTIVATED_SIGNAL], 0);
	}
	_g_object_unref0 (item);
}

static CianoWidgetsSourceListItem*
ciano_widgets_source_list_tree_get_item_from_path_string (CianoWidgetsSourceListTree* self,
                                                          const gchar* item_path_str)
{
	GtkTreePath* item_path = NULL;
	GtkTreePath* _tmp0_;
	CianoWidgetsSourceListDataModel* _tmp1_;
	CianoWidgetsSourceListItem* _tmp2_;
	CianoWidgetsSourceListItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item_path_str != NULL, NULL);
	_tmp0_ = gtk_tree_path_new_from_string (item_path_str);
	item_path = _tmp0_;
	_tmp1_ = self->priv->_data_model;
	_tmp2_ = ciano_widgets_source_list_data_model_get_item_from_path (_tmp1_, item_path);
	result = _tmp2_;
	__vala_GtkTreePath_free0 (item_path);
	return result;
}

static gboolean
ciano_widgets_source_list_tree_toggle_expansion (CianoWidgetsSourceListTree* self,
                                                 CianoWidgetsSourceListExpandableItem* item)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp0_ = ciano_widgets_source_list_expandable_item_get_collapsible (item);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = ciano_widgets_source_list_expandable_item_get_expanded (item);
		_tmp3_ = _tmp2_;
		ciano_widgets_source_list_expandable_item_set_expanded (item, !_tmp3_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

/**
         * Updates the tree to reflect the ''expanded'' property of expandable_item.
         */
static void
ciano_widgets_source_list_tree_update_expansion (CianoWidgetsSourceListTree* self,
                                                 CianoWidgetsSourceListExpandableItem* expandable_item)
{
	GtkTreePath* path = NULL;
	CianoWidgetsSourceListDataModel* _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (expandable_item != NULL);
	_tmp0_ = self->priv->_data_model;
	_tmp1_ = ciano_widgets_source_list_data_model_get_item_path (_tmp0_, (CianoWidgetsSourceListItem*) expandable_item);
	path = _tmp1_;
	_tmp2_ = path;
	if (_tmp2_ != NULL) {
		GtkTreePath* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = path;
		ciano_widgets_source_list_tree_add_spacer_cell_for_level (self, gtk_tree_path_get_depth (_tmp3_) + 1, TRUE);
		_tmp4_ = ciano_widgets_source_list_expandable_item_get_expanded (expandable_item);
		_tmp5_ = _tmp4_;
		if (_tmp5_) {
			GtkTreePath* _tmp6_;
			_tmp6_ = path;
			gtk_tree_view_expand_row ((GtkTreeView*) self, _tmp6_, FALSE);
			{
				GeeIterator* _child_item_it = NULL;
				GeeCollection* _tmp7_;
				GeeCollection* _tmp8_;
				GeeCollection* _tmp9_;
				GeeIterator* _tmp10_;
				GeeIterator* _tmp11_;
				_tmp7_ = ciano_widgets_source_list_expandable_item_get_children (expandable_item);
				_tmp8_ = _tmp7_;
				_tmp9_ = _tmp8_;
				_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
				_tmp11_ = _tmp10_;
				_g_object_unref0 (_tmp9_);
				_child_item_it = _tmp11_;
				while (TRUE) {
					GeeIterator* _tmp12_;
					CianoWidgetsSourceListItem* child_item = NULL;
					GeeIterator* _tmp13_;
					gpointer _tmp14_;
					CianoWidgetsSourceListExpandableItem* child_expandable_item = NULL;
					CianoWidgetsSourceListItem* _tmp15_;
					CianoWidgetsSourceListExpandableItem* _tmp16_;
					CianoWidgetsSourceListExpandableItem* _tmp17_;
					_tmp12_ = _child_item_it;
					if (!gee_iterator_next (_tmp12_)) {
						break;
					}
					_tmp13_ = _child_item_it;
					_tmp14_ = gee_iterator_get (_tmp13_);
					child_item = (CianoWidgetsSourceListItem*) _tmp14_;
					_tmp15_ = child_item;
					_tmp16_ = _g_object_ref0 (CIANO_WIDGETS_SOURCE_LIST_IS_EXPANDABLE_ITEM (_tmp15_) ? ((CianoWidgetsSourceListExpandableItem*) _tmp15_) : NULL);
					child_expandable_item = _tmp16_;
					_tmp17_ = child_expandable_item;
					if (_tmp17_ != NULL) {
						CianoWidgetsSourceListExpandableItem* _tmp18_;
						_tmp18_ = child_expandable_item;
						ciano_widgets_source_list_tree_update_expansion (self, _tmp18_);
					}
					_g_object_unref0 (child_expandable_item);
					_g_object_unref0 (child_item);
				}
				_g_object_unref0 (_child_item_it);
			}
		} else {
			GtkTreePath* _tmp19_;
			_tmp19_ = path;
			gtk_tree_view_collapse_row ((GtkTreeView*) self, _tmp19_);
		}
	}
	__vala_GtkTreePath_free0 (path);
}

static void
ciano_widgets_source_list_tree_real_row_expanded (GtkTreeView* base,
                                                  GtkTreeIter* iter,
                                                  GtkTreePath* path)
{
	CianoWidgetsSourceListTree * self;
	CianoWidgetsSourceListExpandableItem* item = NULL;
	CianoWidgetsSourceListDataModel* _tmp0_;
	GtkTreeIter _tmp1_;
	CianoWidgetsSourceListItem* _tmp2_;
	CianoWidgetsSourceListExpandableItem* _tmp3_;
	self = (CianoWidgetsSourceListTree*) base;
	g_return_if_fail (iter != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->_data_model;
	_tmp1_ = *iter;
	_tmp2_ = ciano_widgets_source_list_data_model_get_item (_tmp0_, &_tmp1_);
	_tmp3_ = CIANO_WIDGETS_SOURCE_LIST_IS_EXPANDABLE_ITEM (_tmp2_) ? ((CianoWidgetsSourceListExpandableItem*) _tmp2_) : NULL;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (_tmp2_);
	}
	item = _tmp3_;
	g_return_if_fail (item != NULL);
	ciano_widgets_source_list_tree_disable_item_property_monitor (self);
	ciano_widgets_source_list_expandable_item_set_expanded (item, TRUE);
	ciano_widgets_source_list_tree_enable_item_property_monitor (self);
	_g_object_unref0 (item);
}

static void
ciano_widgets_source_list_tree_real_row_collapsed (GtkTreeView* base,
                                                   GtkTreeIter* iter,
                                                   GtkTreePath* path)
{
	CianoWidgetsSourceListTree * self;
	CianoWidgetsSourceListExpandableItem* item = NULL;
	CianoWidgetsSourceListDataModel* _tmp0_;
	GtkTreeIter _tmp1_;
	CianoWidgetsSourceListItem* _tmp2_;
	CianoWidgetsSourceListExpandableItem* _tmp3_;
	self = (CianoWidgetsSourceListTree*) base;
	g_return_if_fail (iter != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->_data_model;
	_tmp1_ = *iter;
	_tmp2_ = ciano_widgets_source_list_data_model_get_item (_tmp0_, &_tmp1_);
	_tmp3_ = CIANO_WIDGETS_SOURCE_LIST_IS_EXPANDABLE_ITEM (_tmp2_) ? ((CianoWidgetsSourceListExpandableItem*) _tmp2_) : NULL;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (_tmp2_);
	}
	item = _tmp3_;
	g_return_if_fail (item != NULL);
	ciano_widgets_source_list_tree_disable_item_property_monitor (self);
	ciano_widgets_source_list_expandable_item_set_expanded (item, FALSE);
	ciano_widgets_source_list_tree_enable_item_property_monitor (self);
	_g_object_unref0 (item);
}

static void
ciano_widgets_source_list_tree_real_row_activated (GtkTreeView* base,
                                                   GtkTreePath* path,
                                                   GtkTreeViewColumn* column)
{
	CianoWidgetsSourceListTree * self;
	GtkTreeViewColumn* _tmp0_;
	self = (CianoWidgetsSourceListTree*) base;
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	_tmp0_ = gtk_tree_view_get_column ((GtkTreeView*) self, (gint) CIANO_WIDGETS_SOURCE_LIST_TREE_COLUMN_ITEM);
	if (column == _tmp0_) {
		CianoWidgetsSourceListItem* item = NULL;
		CianoWidgetsSourceListDataModel* _tmp1_;
		CianoWidgetsSourceListItem* _tmp2_;
		CianoWidgetsSourceListItem* _tmp3_;
		_tmp1_ = self->priv->_data_model;
		_tmp2_ = ciano_widgets_source_list_data_model_get_item_from_path (_tmp1_, path);
		item = _tmp2_;
		_tmp3_ = item;
		if (_tmp3_ != NULL) {
			CianoWidgetsSourceListItem* _tmp4_;
			_tmp4_ = item;
			g_signal_emit (_tmp4_, ciano_widgets_source_list_item_signals[CIANO_WIDGETS_SOURCE_LIST_ITEM_ACTIVATED_SIGNAL], 0);
		}
		_g_object_unref0 (item);
	}
}

static gboolean
ciano_widgets_source_list_tree_real_key_release_event (GtkWidget* base,
                                                       GdkEventKey* event)
{
	CianoWidgetsSourceListTree * self;
	CianoWidgetsSourceListItem* _tmp0_;
	CianoWidgetsSourceListItem* _tmp1_;
	gboolean result;
	self = (CianoWidgetsSourceListTree*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = ciano_widgets_source_list_tree_get_selected_item (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		switch (event->keyval) {
			case GDK_KEY_F2:
			{
				GdkModifierType modifiers = 0U;
				gboolean _tmp2_ = FALSE;
				modifiers = gtk_accelerator_get_default_mod_mask ();
				if ((event->state & modifiers) == 0) {
					CianoWidgetsSourceListItem* _tmp3_;
					CianoWidgetsSourceListItem* _tmp4_;
					gboolean _tmp5_;
					gboolean _tmp6_;
					_tmp3_ = ciano_widgets_source_list_tree_get_selected_item (self);
					_tmp4_ = _tmp3_;
					_tmp5_ = ciano_widgets_source_list_item_get_editable (_tmp4_);
					_tmp6_ = _tmp5_;
					_tmp2_ = _tmp6_;
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					CianoWidgetsSourceListItem* _tmp7_;
					CianoWidgetsSourceListItem* _tmp8_;
					_tmp7_ = ciano_widgets_source_list_tree_get_selected_item (self);
					_tmp8_ = _tmp7_;
					ciano_widgets_source_list_tree_start_editing_item (self, _tmp8_);
				}
				break;
			}
			default:
			break;
		}
	}
	result = GTK_WIDGET_CLASS (ciano_widgets_source_list_tree_parent_class)->key_release_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), event);
	return result;
}

static gboolean
ciano_widgets_source_list_tree_real_button_release_event (GtkWidget* base,
                                                          GdkEventButton* event)
{
	CianoWidgetsSourceListTree * self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = (CianoWidgetsSourceListTree*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (self->priv->unselectable_item_clicked) {
		GdkWindow* _tmp1_;
		GdkWindow* _tmp2_;
		_tmp1_ = event->window;
		_tmp2_ = gtk_tree_view_get_bin_window ((GtkTreeView*) self);
		_tmp0_ = _tmp1_ == _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkTreePath* path = NULL;
		GtkTreeViewColumn* column = NULL;
		gint x = 0;
		gint y = 0;
		gint cell_x = 0;
		gint cell_y = 0;
		GtkTreePath* _tmp3_ = NULL;
		GtkTreeViewColumn* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gboolean _tmp7_;
		GtkTreeViewColumn* _tmp8_;
		self->priv->unselectable_item_clicked = FALSE;
		x = (gint) event->x;
		y = (gint) event->y;
		_tmp7_ = gtk_tree_view_get_path_at_pos ((GtkTreeView*) self, x, y, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
		__vala_GtkTreePath_free0 (path);
		path = _tmp3_;
		_g_object_unref0 (column);
		_tmp8_ = _g_object_ref0 (_tmp4_);
		column = _tmp8_;
		cell_x = _tmp5_;
		cell_y = _tmp6_;
		if (_tmp7_) {
			CianoWidgetsSourceListExpandableItem* item = NULL;
			CianoWidgetsSourceListDataModel* _tmp9_;
			GtkTreePath* _tmp10_;
			CianoWidgetsSourceListItem* _tmp11_;
			CianoWidgetsSourceListExpandableItem* _tmp12_;
			CianoWidgetsSourceListExpandableItem* _tmp13_;
			_tmp9_ = self->priv->_data_model;
			_tmp10_ = path;
			_tmp11_ = ciano_widgets_source_list_data_model_get_item_from_path (_tmp9_, _tmp10_);
			_tmp12_ = CIANO_WIDGETS_SOURCE_LIST_IS_EXPANDABLE_ITEM (_tmp11_) ? ((CianoWidgetsSourceListExpandableItem*) _tmp11_) : NULL;
			if (_tmp12_ == NULL) {
				_g_object_unref0 (_tmp11_);
			}
			item = _tmp12_;
			_tmp13_ = item;
			if (_tmp13_ != NULL) {
				gboolean _tmp14_ = FALSE;
				CianoWidgetsSourceListExpandableItem* _tmp15_;
				gboolean _tmp16_;
				gboolean _tmp17_;
				_tmp15_ = item;
				_tmp16_ = ciano_widgets_source_list_item_get_selectable ((CianoWidgetsSourceListItem*) _tmp15_);
				_tmp17_ = _tmp16_;
				if (!_tmp17_) {
					_tmp14_ = TRUE;
				} else {
					CianoWidgetsSourceListDataModel* _tmp18_;
					CianoWidgetsSourceListExpandableItem* _tmp19_;
					GtkTreePath* _tmp20_;
					_tmp18_ = self->priv->_data_model;
					_tmp19_ = item;
					_tmp20_ = path;
					_tmp14_ = ciano_widgets_source_list_data_model_is_category (_tmp18_, (CianoWidgetsSourceListItem*) _tmp19_, NULL, _tmp20_);
				}
				if (_tmp14_) {
					CianoWidgetsSourceListExpandableItem* _tmp21_;
					_tmp21_ = item;
					ciano_widgets_source_list_tree_toggle_expansion (self, _tmp21_);
				}
			}
			_g_object_unref0 (item);
		}
		_g_object_unref0 (column);
		__vala_GtkTreePath_free0 (path);
	}
	result = GTK_WIDGET_CLASS (ciano_widgets_source_list_tree_parent_class)->button_release_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), event);
	return result;
}

static gboolean
ciano_widgets_source_list_tree_real_button_press_event (GtkWidget* base,
                                                        GdkEventButton* event)
{
	CianoWidgetsSourceListTree * self;
	GdkWindow* _tmp0_;
	GdkWindow* _tmp1_;
	GtkTreePath* path = NULL;
	GtkTreeViewColumn* column = NULL;
	gint x = 0;
	gint y = 0;
	gint cell_x = 0;
	gint cell_y = 0;
	GtkTreePath* _tmp2_ = NULL;
	GtkTreeViewColumn* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_;
	GtkTreeViewColumn* _tmp7_;
	gboolean result;
	self = (CianoWidgetsSourceListTree*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event->window;
	_tmp1_ = gtk_tree_view_get_bin_window ((GtkTreeView*) self);
	if (_tmp0_ != _tmp1_) {
		result = GTK_WIDGET_CLASS (ciano_widgets_source_list_tree_parent_class)->button_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), event);
		return result;
	}
	x = (gint) event->x;
	y = (gint) event->y;
	_tmp6_ = gtk_tree_view_get_path_at_pos ((GtkTreeView*) self, x, y, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
	__vala_GtkTreePath_free0 (path);
	path = _tmp2_;
	_g_object_unref0 (column);
	_tmp7_ = _g_object_ref0 (_tmp3_);
	column = _tmp7_;
	cell_x = _tmp4_;
	cell_y = _tmp5_;
	if (_tmp6_) {
		CianoWidgetsSourceListItem* item = NULL;
		CianoWidgetsSourceListDataModel* _tmp8_;
		GtkTreePath* _tmp9_;
		CianoWidgetsSourceListItem* _tmp10_;
		GdkRectangle start_cell_area = {0};
		GtkTreePath* _tmp11_;
		GtkTreeViewColumn* _tmp12_;
		GdkRectangle _tmp13_ = {0};
		GdkRectangle _tmp14_;
		gboolean _tmp15_ = FALSE;
		CianoWidgetsSourceListItem* _tmp16_;
		_tmp8_ = self->priv->_data_model;
		_tmp9_ = path;
		_tmp10_ = ciano_widgets_source_list_data_model_get_item_from_path (_tmp8_, _tmp9_);
		item = _tmp10_;
		_tmp11_ = path;
		_tmp12_ = gtk_tree_view_get_column ((GtkTreeView*) self, 0);
		gtk_tree_view_get_cell_area ((GtkTreeView*) self, _tmp11_, _tmp12_, &_tmp13_);
		start_cell_area = _tmp13_;
		_tmp14_ = start_cell_area;
		cell_x -= _tmp14_.x;
		_tmp16_ = item;
		if (_tmp16_ != NULL) {
			GtkTreeViewColumn* _tmp17_;
			GtkTreeViewColumn* _tmp18_;
			_tmp17_ = column;
			_tmp18_ = gtk_tree_view_get_column ((GtkTreeView*) self, (gint) CIANO_WIDGETS_SOURCE_LIST_TREE_COLUMN_ITEM);
			_tmp15_ = _tmp17_ == _tmp18_;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			ciano_widgets_source_list_tree_stop_editing (self);
			if (event->button == ((guint) GDK_BUTTON_SECONDARY)) {
				CianoWidgetsSourceListItem* _tmp19_;
				_tmp19_ = item;
				ciano_widgets_source_list_tree_popup_context_menu (self, _tmp19_, event);
			} else {
				if (event->button == ((guint) GDK_BUTTON_PRIMARY)) {
					gboolean is_expandable = FALSE;
					CianoWidgetsSourceListItem* _tmp20_;
					gboolean _tmp21_ = FALSE;
					gboolean is_category = FALSE;
					_tmp20_ = item;
					is_expandable = CIANO_WIDGETS_SOURCE_LIST_IS_EXPANDABLE_ITEM (_tmp20_);
					if (is_expandable) {
						CianoWidgetsSourceListDataModel* _tmp22_;
						CianoWidgetsSourceListItem* _tmp23_;
						GtkTreePath* _tmp24_;
						_tmp22_ = self->priv->_data_model;
						_tmp23_ = item;
						_tmp24_ = path;
						_tmp21_ = ciano_widgets_source_list_data_model_is_category (_tmp22_, _tmp23_, NULL, _tmp24_);
					} else {
						_tmp21_ = FALSE;
					}
					is_category = _tmp21_;
					if (event->type == GDK_BUTTON_PRESS) {
						if (is_expandable) {
							gboolean _tmp25_ = FALSE;
							gboolean _tmp33_ = FALSE;
							gboolean _tmp34_ = FALSE;
							if (is_category) {
								_tmp25_ = TRUE;
							} else {
								gboolean _tmp26_ = FALSE;
								CianoWidgetsSourceListItem* _tmp27_;
								gboolean _tmp28_;
								gboolean _tmp29_;
								_tmp27_ = item;
								_tmp28_ = ciano_widgets_source_list_item_get_selectable (_tmp27_);
								_tmp29_ = _tmp28_;
								if (!_tmp29_) {
									GtkTreeViewColumn* _tmp30_;
									GtkTreePath* _tmp31_;
									CianoWidgetsSourceListCellRendererIcon* _tmp32_;
									_tmp30_ = column;
									_tmp31_ = path;
									_tmp32_ = self->priv->activatable_cell;
									_tmp26_ = !ciano_widgets_source_list_tree_over_cell (self, _tmp30_, _tmp31_, (GtkCellRenderer*) _tmp32_, cell_x);
								} else {
									_tmp26_ = FALSE;
								}
								_tmp25_ = _tmp26_;
							}
							self->priv->unselectable_item_clicked = _tmp25_;
							if (!self->priv->unselectable_item_clicked) {
								GtkTreeViewColumn* _tmp35_;
								GtkTreePath* _tmp36_;
								_tmp35_ = column;
								_tmp36_ = path;
								_tmp34_ = ciano_widgets_source_list_tree_over_primary_expander (self, _tmp35_, _tmp36_, cell_x);
							} else {
								_tmp34_ = FALSE;
							}
							if (_tmp34_) {
								CianoWidgetsSourceListItem* _tmp37_;
								_tmp37_ = item;
								_tmp33_ = ciano_widgets_source_list_tree_toggle_expansion (self, CIANO_WIDGETS_SOURCE_LIST_IS_EXPANDABLE_ITEM (_tmp37_) ? ((CianoWidgetsSourceListExpandableItem*) _tmp37_) : NULL);
							} else {
								_tmp33_ = FALSE;
							}
							if (_tmp33_) {
								result = TRUE;
								_g_object_unref0 (item);
								_g_object_unref0 (column);
								__vala_GtkTreePath_free0 (path);
								return result;
							}
						}
					} else {
						gboolean _tmp38_ = FALSE;
						gboolean _tmp39_ = FALSE;
						gboolean _tmp40_ = FALSE;
						gboolean _tmp41_ = FALSE;
						gboolean _tmp42_ = FALSE;
						if (event->type == GDK_2BUTTON_PRESS) {
							_tmp42_ = !is_category;
						} else {
							_tmp42_ = FALSE;
						}
						if (_tmp42_) {
							CianoWidgetsSourceListItem* _tmp43_;
							gboolean _tmp44_;
							gboolean _tmp45_;
							_tmp43_ = item;
							_tmp44_ = ciano_widgets_source_list_item_get_editable (_tmp43_);
							_tmp45_ = _tmp44_;
							_tmp41_ = _tmp45_;
						} else {
							_tmp41_ = FALSE;
						}
						if (_tmp41_) {
							CianoWidgetsSourceListItem* _tmp46_;
							gboolean _tmp47_;
							gboolean _tmp48_;
							_tmp46_ = item;
							_tmp47_ = ciano_widgets_source_list_item_get_selectable (_tmp46_);
							_tmp48_ = _tmp47_;
							_tmp40_ = _tmp48_;
						} else {
							_tmp40_ = FALSE;
						}
						if (_tmp40_) {
							GtkTreeViewColumn* _tmp49_;
							GtkTreePath* _tmp50_;
							GtkCellRendererText* _tmp51_;
							_tmp49_ = column;
							_tmp50_ = path;
							_tmp51_ = self->priv->text_cell;
							_tmp39_ = ciano_widgets_source_list_tree_over_cell (self, _tmp49_, _tmp50_, (GtkCellRenderer*) _tmp51_, cell_x);
						} else {
							_tmp39_ = FALSE;
						}
						if (_tmp39_) {
							CianoWidgetsSourceListItem* _tmp52_;
							_tmp52_ = item;
							_tmp38_ = ciano_widgets_source_list_tree_start_editing_item (self, _tmp52_);
						} else {
							_tmp38_ = FALSE;
						}
						if (_tmp38_) {
							result = TRUE;
							_g_object_unref0 (item);
							_g_object_unref0 (column);
							__vala_GtkTreePath_free0 (path);
							return result;
						}
					}
				}
			}
		}
		_g_object_unref0 (item);
	}
	result = GTK_WIDGET_CLASS (ciano_widgets_source_list_tree_parent_class)->button_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), event);
	_g_object_unref0 (column);
	__vala_GtkTreePath_free0 (path);
	return result;
}

static gboolean
ciano_widgets_source_list_tree_over_primary_expander (CianoWidgetsSourceListTree* self,
                                                      GtkTreeViewColumn* col,
                                                      GtkTreePath* path,
                                                      gint x)
{
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_;
	GraniteWidgetsCellRendererExpander* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeModel* _tmp6_;
	GtkTreeIter _tmp7_;
	GraniteWidgetsCellRendererExpander* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	GtkTreeModel* _tmp11_;
	GtkTreeModel* _tmp12_;
	GtkTreeIter _tmp13_;
	gint indentation_level = 0;
	CianoWidgetsSourceListCellRendererSpacer* last_spacer_cell = NULL;
	GeeHashMap* _tmp14_;
	gpointer _tmp15_;
	CianoWidgetsSourceListCellRendererSpacer* _tmp16_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (col != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = gtk_tree_view_get_model ((GtkTreeView*) self);
	_tmp1_ = _tmp0_;
	_tmp3_ = gtk_tree_model_get_iter (_tmp1_, &_tmp2_, path);
	iter = _tmp2_;
	if (!_tmp3_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = self->priv->primary_expander_cell;
	_tmp5_ = gtk_tree_view_get_model ((GtkTreeView*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = iter;
	ciano_widgets_source_list_tree_expander_cell_data_func (self, (GtkCellLayout*) col, (GtkCellRenderer*) _tmp4_, _tmp6_, &_tmp7_);
	_tmp8_ = self->priv->primary_expander_cell;
	_tmp9_ = gtk_cell_renderer_get_visible ((GtkCellRenderer*) _tmp8_);
	_tmp10_ = _tmp9_;
	if (!_tmp10_) {
		result = FALSE;
		return result;
	}
	_tmp11_ = gtk_tree_view_get_model ((GtkTreeView*) self);
	_tmp12_ = _tmp11_;
	_tmp13_ = iter;
	if (gtk_tree_model_iter_n_children (_tmp12_, &_tmp13_) < 1) {
		result = FALSE;
		return result;
	}
	indentation_level = gtk_tree_path_get_depth (path);
	_tmp14_ = self->priv->spacer_cells;
	_tmp15_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp14_, (gpointer) ((gintptr) indentation_level));
	last_spacer_cell = (CianoWidgetsSourceListCellRendererSpacer*) _tmp15_;
	_tmp16_ = last_spacer_cell;
	if (_tmp16_ != NULL) {
		gint cell_x = 0;
		gint cell_width = 0;
		CianoWidgetsSourceListCellRendererSpacer* _tmp17_;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gboolean _tmp20_;
		_tmp17_ = last_spacer_cell;
		_tmp20_ = gtk_tree_view_column_cell_get_position (col, (GtkCellRenderer*) _tmp17_, &_tmp18_, &_tmp19_);
		cell_x = _tmp18_;
		cell_width = _tmp19_;
		if (_tmp20_) {
			gint expander_width = 0;
			GraniteWidgetsCellRendererExpander* _tmp21_;
			gboolean is_ltr = FALSE;
			GtkTextDirection dir = 0;
			gboolean _tmp23_ = FALSE;
			_tmp21_ = self->priv->primary_expander_cell;
			expander_width = ciano_widgets_source_list_tree_get_cell_width (self, (GtkCellRenderer*) _tmp21_) + 1;
			is_ltr = FALSE;
			dir = gtk_widget_get_direction ((GtkWidget*) self);
			if (dir == GTK_TEXT_DIR_NONE) {
				dir = gtk_widget_get_default_direction ();
			}
			if (dir == GTK_TEXT_DIR_LTR) {
				is_ltr = TRUE;
			}
			if (is_ltr) {
				gint indentation_offset = 0;
				gboolean _tmp22_ = FALSE;
				indentation_offset = cell_x + cell_width;
				if (x >= indentation_offset) {
					_tmp22_ = x <= (indentation_offset + expander_width);
				} else {
					_tmp22_ = FALSE;
				}
				result = _tmp22_;
				_g_object_unref0 (last_spacer_cell);
				return result;
			}
			if (x <= cell_x) {
				_tmp23_ = x >= (cell_x - expander_width);
			} else {
				_tmp23_ = FALSE;
			}
			result = _tmp23_;
			_g_object_unref0 (last_spacer_cell);
			return result;
		}
	}
	result = FALSE;
	_g_object_unref0 (last_spacer_cell);
	return result;
}

static gboolean
ciano_widgets_source_list_tree_over_cell (CianoWidgetsSourceListTree* self,
                                          GtkTreeViewColumn* col,
                                          GtkTreePath* path,
                                          GtkCellRenderer* cell,
                                          gint x)
{
	gint cell_x = 0;
	gint cell_width = 0;
	gboolean found = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (col != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (cell != NULL, FALSE);
	_tmp2_ = gtk_tree_view_column_cell_get_position (col, cell, &_tmp0_, &_tmp1_);
	cell_x = _tmp0_;
	cell_width = _tmp1_;
	found = _tmp2_;
	if (found) {
		_tmp4_ = x > cell_x;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = x < (cell_x + cell_width);
	} else {
		_tmp3_ = FALSE;
	}
	result = _tmp3_;
	return result;
}

static gint
ciano_widgets_source_list_tree_get_cell_width (CianoWidgetsSourceListTree* self,
                                               GtkCellRenderer* cell_renderer)
{
	GtkRequisition min_req = {0};
	GtkRequisition _tmp0_ = {0};
	GtkRequisition _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (cell_renderer != NULL, 0);
	gtk_cell_renderer_get_preferred_size (cell_renderer, (GtkWidget*) self, &_tmp0_, NULL);
	min_req = _tmp0_;
	_tmp1_ = min_req;
	result = _tmp1_.width;
	return result;
}

static gboolean
ciano_widgets_source_list_tree_real_popup_menu (GtkWidget* base)
{
	CianoWidgetsSourceListTree * self;
	gboolean result;
	self = (CianoWidgetsSourceListTree*) base;
	result = ciano_widgets_source_list_tree_popup_context_menu (self, NULL, NULL);
	return result;
}

static void
_ciano_widgets_source_list_tree_menu_position_func_gtk_menu_position_func (GtkMenu* menu,
                                                                           gint* x,
                                                                           gint* y,
                                                                           gboolean* push_in,
                                                                           gpointer self)
{
	ciano_widgets_source_list_tree_menu_position_func ((CianoWidgetsSourceListTree*) self, menu, x, y, push_in);
	g_object_unref (self);
}

static gboolean
ciano_widgets_source_list_tree_popup_context_menu (CianoWidgetsSourceListTree* self,
                                                   CianoWidgetsSourceListItem* item,
                                                   GdkEventButton* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (item == NULL) {
		CianoWidgetsSourceListItem* _tmp0_;
		CianoWidgetsSourceListItem* _tmp1_;
		_tmp0_ = ciano_widgets_source_list_tree_get_selected_item (self);
		_tmp1_ = _tmp0_;
		item = _tmp1_;
	}
	if (item != NULL) {
		GtkMenu* menu = NULL;
		GtkMenu* _tmp2_;
		GtkMenu* _tmp3_;
		_tmp2_ = ciano_widgets_source_list_item_get_context_menu (item);
		menu = _tmp2_;
		_tmp3_ = menu;
		if (_tmp3_ != NULL) {
			guint32 _tmp4_ = 0U;
			guint32 time = 0U;
			guint _tmp5_ = 0U;
			guint button = 0U;
			GtkMenu* _tmp6_;
			if (event != NULL) {
				_tmp4_ = event->time;
			} else {
				_tmp4_ = gtk_get_current_event_time ();
			}
			time = _tmp4_;
			if (event != NULL) {
				_tmp5_ = event->button;
			} else {
				_tmp5_ = (guint) 0;
			}
			button = _tmp5_;
			_tmp6_ = menu;
			gtk_menu_attach_to_widget (_tmp6_, (GtkWidget*) self, NULL);
			if (event != NULL) {
				GtkMenu* _tmp7_;
				_tmp7_ = menu;
				gtk_menu_popup (_tmp7_, NULL, NULL, NULL, NULL, button, time);
			} else {
				GtkMenu* _tmp8_;
				GtkMenu* _tmp9_;
				_tmp8_ = menu;
				gtk_menu_popup (_tmp8_, NULL, NULL, _ciano_widgets_source_list_tree_menu_position_func_gtk_menu_position_func, g_object_ref (self), button, time);
				_tmp9_ = menu;
				gtk_menu_shell_select_first ((GtkMenuShell*) _tmp9_, FALSE);
			}
			result = TRUE;
			_g_object_unref0 (menu);
			return result;
		}
		_g_object_unref0 (menu);
	}
	result = FALSE;
	return result;
}

/**
         * Positions a menu based on an item's coordinates.
         *
         * This function is only used for menu pop-ups triggered by events other than button
         * presses (e.g. key-press events). Since such events provide no coordinates, it is
         * assumed that the item in question is the one currently selected.
         */
static void
ciano_widgets_source_list_tree_menu_position_func (CianoWidgetsSourceListTree* self,
                                                   GtkMenu* menu,
                                                   gint* x,
                                                   gint* y,
                                                   gboolean* push_in)
{
	gint _vala_x = 0;
	gint _vala_y = 0;
	gboolean _vala_push_in = FALSE;
	gboolean _tmp0_ = FALSE;
	CianoWidgetsSourceListItem* _tmp1_;
	CianoWidgetsSourceListItem* _tmp2_;
	GtkTreePath* path = NULL;
	CianoWidgetsSourceListDataModel* _tmp3_;
	CianoWidgetsSourceListItem* _tmp4_;
	CianoWidgetsSourceListItem* _tmp5_;
	GtkTreePath* _tmp6_;
	GtkTreePath* _tmp7_;
	GdkRectangle item_bin_coords = {0};
	GtkTreePath* _tmp8_;
	GtkTreeViewColumn* _tmp9_;
	GdkRectangle _tmp10_ = {0};
	gint item_y = 0;
	GdkRectangle _tmp11_;
	GdkRectangle _tmp12_;
	gint item_x = 0;
	GdkRectangle _tmp13_;
	gboolean is_ltr = FALSE;
	GtkTextDirection dir = 0;
	gint widget_x = 0;
	gint widget_y = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	GdkWindow* _tmp17_;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	_vala_push_in = TRUE;
	_vala_y = 0;
	_vala_x = _vala_y;
	_tmp1_ = ciano_widgets_source_list_tree_get_selected_item (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !gtk_widget_get_realized ((GtkWidget*) self);
	}
	if (_tmp0_) {
		if (x) {
			*x = _vala_x;
		}
		if (y) {
			*y = _vala_y;
		}
		if (push_in) {
			*push_in = _vala_push_in;
		}
		return;
	}
	_tmp3_ = self->priv->_data_model;
	_tmp4_ = ciano_widgets_source_list_tree_get_selected_item (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = ciano_widgets_source_list_data_model_get_item_path (_tmp3_, _tmp5_);
	path = _tmp6_;
	_tmp7_ = path;
	if (_tmp7_ == NULL) {
		__vala_GtkTreePath_free0 (path);
		if (x) {
			*x = _vala_x;
		}
		if (y) {
			*y = _vala_y;
		}
		if (push_in) {
			*push_in = _vala_push_in;
		}
		return;
	}
	_tmp8_ = path;
	_tmp9_ = gtk_tree_view_get_column ((GtkTreeView*) self, (gint) CIANO_WIDGETS_SOURCE_LIST_TREE_COLUMN_ITEM);
	gtk_tree_view_get_cell_area ((GtkTreeView*) self, _tmp8_, _tmp9_, &_tmp10_);
	item_bin_coords = _tmp10_;
	_tmp11_ = item_bin_coords;
	_tmp12_ = item_bin_coords;
	item_y = _tmp11_.y + (_tmp12_.height / 2);
	_tmp13_ = item_bin_coords;
	item_x = _tmp13_.x;
	is_ltr = FALSE;
	dir = gtk_widget_get_direction ((GtkWidget*) self);
	if (dir == GTK_TEXT_DIR_NONE) {
		dir = gtk_widget_get_default_direction ();
	}
	if (dir == GTK_TEXT_DIR_LTR) {
		is_ltr = TRUE;
	}
	if (is_ltr) {
		GdkRectangle _tmp14_;
		_tmp14_ = item_bin_coords;
		item_x += _tmp14_.width - 6;
	}
	gtk_tree_view_convert_bin_window_to_widget_coords ((GtkTreeView*) self, item_x, item_y, &_tmp15_, &_tmp16_);
	widget_x = _tmp15_;
	widget_y = _tmp16_;
	_tmp17_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_get_origin (_tmp17_, &_tmp18_, &_tmp19_);
	_vala_x = _tmp18_;
	_vala_y = _tmp19_;
	_vala_x = _vala_x + CLAMP (widget_x, 0, gtk_widget_get_allocated_width ((GtkWidget*) self));
	_vala_y = _vala_y + CLAMP (widget_y, 0, gtk_widget_get_allocated_height ((GtkWidget*) self));
	if (!is_ltr) {
		GtkRequisition menu_req = {0};
		GtkRequisition _tmp20_ = {0};
		GtkRequisition _tmp21_;
		gtk_widget_get_preferred_size ((GtkWidget*) menu, &_tmp20_, NULL);
		menu_req = _tmp20_;
		_tmp21_ = menu_req;
		_vala_y = _vala_y - _tmp21_.width;
	}
	__vala_GtkTreePath_free0 (path);
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (push_in) {
		*push_in = _vala_push_in;
	}
}

static CianoWidgetsSourceListItem*
ciano_widgets_source_list_tree_get_item_from_model (GtkTreeModel* model,
                                                    GtkTreeIter* iter)
{
	CianoWidgetsSourceListDataModel* data_model = NULL;
	CianoWidgetsSourceListDataModel* _tmp0_;
	GtkTreeIter _tmp1_;
	CianoWidgetsSourceListItem* _tmp2_;
	CianoWidgetsSourceListItem* result;
	g_return_val_if_fail (model != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = _g_object_ref0 (CIANO_WIDGETS_SOURCE_LIST_IS_DATA_MODEL (model) ? ((CianoWidgetsSourceListDataModel*) model) : NULL);
	data_model = _tmp0_;
	_vala_assert (data_model != NULL, "data_model != null");
	_tmp1_ = *iter;
	_tmp2_ = ciano_widgets_source_list_data_model_get_item (data_model, &_tmp1_);
	result = _tmp2_;
	_g_object_unref0 (data_model);
	return result;
}

static void
ciano_widgets_source_list_tree_spacer_cell_data_func (GtkCellLayout* layout,
                                                      GtkCellRenderer* renderer,
                                                      GtkTreeModel* model,
                                                      GtkTreeIter* iter)
{
	CianoWidgetsSourceListCellRendererSpacer* spacer = NULL;
	CianoWidgetsSourceListCellRendererSpacer* _tmp0_;
	CianoWidgetsSourceListCellRendererSpacer* _tmp1_;
	CianoWidgetsSourceListCellRendererSpacer* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GtkTreePath* path = NULL;
	GtkTreeIter _tmp5_;
	GtkTreePath* _tmp6_;
	gint level = 0;
	GtkTreePath* _tmp7_;
	CianoWidgetsSourceListCellRendererSpacer* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	g_return_if_fail (layout != NULL);
	g_return_if_fail (renderer != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = _g_object_ref0 (CIANO_WIDGETS_SOURCE_LIST_IS_CELL_RENDERER_SPACER (renderer) ? ((CianoWidgetsSourceListCellRendererSpacer*) renderer) : NULL);
	spacer = _tmp0_;
	_tmp1_ = spacer;
	_vala_assert (_tmp1_ != NULL, "spacer != null");
	_tmp2_ = spacer;
	_tmp3_ = ciano_widgets_source_list_cell_renderer_spacer_get_level (_tmp2_);
	_tmp4_ = _tmp3_;
	_vala_assert (_tmp4_ > 0, "spacer.level > 0");
	_tmp5_ = *iter;
	_tmp6_ = gtk_tree_model_get_path (model, &_tmp5_);
	path = _tmp6_;
	level = -1;
	_tmp7_ = path;
	if (_tmp7_ != NULL) {
		GtkTreePath* _tmp8_;
		_tmp8_ = path;
		level = gtk_tree_path_get_depth (_tmp8_);
	}
	_tmp9_ = spacer;
	_tmp10_ = ciano_widgets_source_list_cell_renderer_spacer_get_level (_tmp9_);
	_tmp11_ = _tmp10_;
	gtk_cell_renderer_set_visible (renderer, _tmp11_ <= level);
	__vala_GtkTreePath_free0 (path);
	_g_object_unref0 (spacer);
}

static void
ciano_widgets_source_list_tree_name_cell_data_func (CianoWidgetsSourceListTree* self,
                                                    GtkCellLayout* layout,
                                                    GtkCellRenderer* renderer,
                                                    GtkTreeModel* model,
                                                    GtkTreeIter* iter)
{
	GtkCellRendererText* text_renderer = NULL;
	GtkCellRendererText* _tmp0_;
	GtkCellRendererText* _tmp1_;
	GString* text = NULL;
	GString* _tmp2_;
	PangoWeight weight = 0;
	CianoWidgetsSourceListItem* item = NULL;
	GtkTreeIter _tmp3_;
	CianoWidgetsSourceListItem* _tmp4_;
	CianoWidgetsSourceListItem* _tmp5_;
	GtkCellRendererText* _tmp13_;
	GtkCellRendererText* _tmp14_;
	GString* _tmp15_;
	const gchar* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (layout != NULL);
	g_return_if_fail (renderer != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (renderer, gtk_cell_renderer_text_get_type ()) ? ((GtkCellRendererText*) renderer) : NULL);
	text_renderer = _tmp0_;
	_tmp1_ = text_renderer;
	_vala_assert (_tmp1_ != NULL, "text_renderer != null");
	_tmp2_ = g_string_new ("");
	text = _tmp2_;
	weight = PANGO_WEIGHT_NORMAL;
	_tmp3_ = *iter;
	_tmp4_ = ciano_widgets_source_list_tree_get_item_from_model (model, &_tmp3_);
	item = _tmp4_;
	_tmp5_ = item;
	if (_tmp5_ != NULL) {
		GString* _tmp6_;
		CianoWidgetsSourceListItem* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		CianoWidgetsSourceListDataModel* _tmp10_;
		CianoWidgetsSourceListItem* _tmp11_;
		GtkTreeIter _tmp12_;
		_tmp6_ = text;
		_tmp7_ = item;
		_tmp8_ = ciano_widgets_source_list_item_get_name (_tmp7_);
		_tmp9_ = _tmp8_;
		g_string_append (_tmp6_, _tmp9_);
		_tmp10_ = self->priv->_data_model;
		_tmp11_ = item;
		_tmp12_ = *iter;
		if (ciano_widgets_source_list_data_model_is_category (_tmp10_, _tmp11_, &_tmp12_, NULL)) {
			weight = PANGO_WEIGHT_BOLD;
		}
	}
	_tmp13_ = text_renderer;
	g_object_set (_tmp13_, "weight", (gint) weight, NULL);
	_tmp14_ = text_renderer;
	_tmp15_ = text;
	_tmp16_ = _tmp15_->str;
	g_object_set (_tmp14_, "text", _tmp16_, NULL);
	_g_object_unref0 (item);
	_g_string_free0 (text);
	_g_object_unref0 (text_renderer);
}

static void
ciano_widgets_source_list_tree_badge_cell_data_func (CianoWidgetsSourceListTree* self,
                                                     GtkCellLayout* layout,
                                                     GtkCellRenderer* renderer,
                                                     GtkTreeModel* model,
                                                     GtkTreeIter* iter)
{
	GraniteWidgetsCellRendererBadge* badge_renderer = NULL;
	GraniteWidgetsCellRendererBadge* _tmp0_;
	GraniteWidgetsCellRendererBadge* _tmp1_;
	gchar* text = NULL;
	gchar* _tmp2_;
	gboolean visible = FALSE;
	CianoWidgetsSourceListItem* item = NULL;
	GtkTreeIter _tmp3_;
	CianoWidgetsSourceListItem* _tmp4_;
	CianoWidgetsSourceListItem* _tmp5_;
	GraniteWidgetsCellRendererBadge* _tmp23_;
	GraniteWidgetsCellRendererBadge* _tmp24_;
	const gchar* _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (layout != NULL);
	g_return_if_fail (renderer != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (renderer, GRANITE_WIDGETS_TYPE_CELL_RENDERER_BADGE) ? ((GraniteWidgetsCellRendererBadge*) renderer) : NULL);
	badge_renderer = _tmp0_;
	_tmp1_ = badge_renderer;
	_vala_assert (_tmp1_ != NULL, "badge_renderer != null");
	_tmp2_ = g_strdup ("");
	text = _tmp2_;
	visible = FALSE;
	_tmp3_ = *iter;
	_tmp4_ = ciano_widgets_source_list_tree_get_item_from_model (model, &_tmp3_);
	item = _tmp4_;
	_tmp5_ = item;
	if (_tmp5_ != NULL) {
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		CianoWidgetsSourceListDataModel* _tmp8_;
		CianoWidgetsSourceListItem* _tmp9_;
		GtkTreeIter _tmp10_;
		_tmp8_ = self->priv->_data_model;
		_tmp9_ = item;
		_tmp10_ = *iter;
		if (!ciano_widgets_source_list_data_model_is_category (_tmp8_, _tmp9_, &_tmp10_, NULL)) {
			CianoWidgetsSourceListItem* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			_tmp11_ = item;
			_tmp12_ = ciano_widgets_source_list_item_get_badge (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp7_ = _tmp13_ != NULL;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			CianoWidgetsSourceListItem* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp14_ = item;
			_tmp15_ = ciano_widgets_source_list_item_get_badge (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = string_strip (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp6_ = g_strcmp0 (_tmp18_, "") != 0;
			_g_free0 (_tmp18_);
		} else {
			_tmp6_ = FALSE;
		}
		visible = _tmp6_;
		if (visible) {
			CianoWidgetsSourceListItem* _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			gchar* _tmp22_;
			_tmp19_ = item;
			_tmp20_ = ciano_widgets_source_list_item_get_badge (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = g_strdup (_tmp21_);
			_g_free0 (text);
			text = _tmp22_;
		}
	}
	_tmp23_ = badge_renderer;
	gtk_cell_renderer_set_visible ((GtkCellRenderer*) _tmp23_, visible);
	_tmp24_ = badge_renderer;
	_tmp25_ = text;
	granite_widgets_cell_renderer_badge_set_text (_tmp24_, _tmp25_);
	_g_object_unref0 (item);
	_g_free0 (text);
	_g_object_unref0 (badge_renderer);
}

static void
ciano_widgets_source_list_tree_icon_cell_data_func (CianoWidgetsSourceListTree* self,
                                                    GtkCellLayout* layout,
                                                    GtkCellRenderer* renderer,
                                                    GtkTreeModel* model,
                                                    GtkTreeIter* iter)
{
	CianoWidgetsSourceListCellRendererIcon* icon_renderer = NULL;
	CianoWidgetsSourceListCellRendererIcon* _tmp0_;
	CianoWidgetsSourceListCellRendererIcon* _tmp1_;
	gboolean visible = FALSE;
	GIcon* icon = NULL;
	CianoWidgetsSourceListItem* item = NULL;
	GtkTreeIter _tmp2_;
	CianoWidgetsSourceListItem* _tmp3_;
	CianoWidgetsSourceListItem* _tmp4_;
	gboolean _tmp20_ = FALSE;
	CianoWidgetsSourceListCellRendererIcon* _tmp22_;
	GIcon* _tmp23_ = NULL;
	CianoWidgetsSourceListCellRendererIcon* _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (layout != NULL);
	g_return_if_fail (renderer != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = _g_object_ref0 (CIANO_WIDGETS_SOURCE_LIST_IS_CELL_RENDERER_ICON (renderer) ? ((CianoWidgetsSourceListCellRendererIcon*) renderer) : NULL);
	icon_renderer = _tmp0_;
	_tmp1_ = icon_renderer;
	_vala_assert (_tmp1_ != NULL, "icon_renderer != null");
	visible = FALSE;
	icon = NULL;
	_tmp2_ = *iter;
	_tmp3_ = ciano_widgets_source_list_tree_get_item_from_model (model, &_tmp2_);
	item = _tmp3_;
	_tmp4_ = item;
	if (_tmp4_ != NULL) {
		CianoWidgetsSourceListDataModel* _tmp5_;
		CianoWidgetsSourceListItem* _tmp6_;
		GtkTreeIter _tmp7_;
		_tmp5_ = self->priv->_data_model;
		_tmp6_ = item;
		_tmp7_ = *iter;
		visible = !ciano_widgets_source_list_data_model_is_category (_tmp5_, _tmp6_, &_tmp7_, NULL);
		if (visible) {
			CianoWidgetsSourceListCellRendererIcon* _tmp8_;
			CianoWidgetsSourceListCellRendererIcon* _tmp9_;
			_tmp8_ = icon_renderer;
			_tmp9_ = self->priv->icon_cell;
			if (_tmp8_ == _tmp9_) {
				CianoWidgetsSourceListItem* _tmp10_;
				GIcon* _tmp11_;
				GIcon* _tmp12_;
				GIcon* _tmp13_;
				_tmp10_ = item;
				_tmp11_ = ciano_widgets_source_list_item_get_icon (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = _g_object_ref0 (_tmp12_);
				_g_object_unref0 (icon);
				icon = _tmp13_;
			} else {
				CianoWidgetsSourceListCellRendererIcon* _tmp14_;
				CianoWidgetsSourceListCellRendererIcon* _tmp15_;
				_tmp14_ = icon_renderer;
				_tmp15_ = self->priv->activatable_cell;
				if (_tmp14_ == _tmp15_) {
					CianoWidgetsSourceListItem* _tmp16_;
					GIcon* _tmp17_;
					GIcon* _tmp18_;
					GIcon* _tmp19_;
					_tmp16_ = item;
					_tmp17_ = ciano_widgets_source_list_item_get_activatable (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = _g_object_ref0 (_tmp18_);
					_g_object_unref0 (icon);
					icon = _tmp19_;
				} else {
					g_assert_not_reached ();
				}
			}
		}
	}
	if (visible) {
		GIcon* _tmp21_;
		_tmp21_ = icon;
		_tmp20_ = _tmp21_ != NULL;
	} else {
		_tmp20_ = FALSE;
	}
	visible = _tmp20_;
	_tmp22_ = icon_renderer;
	gtk_cell_renderer_set_visible ((GtkCellRenderer*) _tmp22_, visible);
	if (visible) {
		GIcon* _tmp24_;
		_tmp24_ = icon;
		_tmp23_ = _tmp24_;
	} else {
		_tmp23_ = NULL;
	}
	_tmp25_ = icon_renderer;
	g_object_set ((GtkCellRendererPixbuf*) _tmp25_, "gicon", _tmp23_, NULL);
	_g_object_unref0 (item);
	_g_object_unref0 (icon);
	_g_object_unref0 (icon_renderer);
}

/**
         * Controls expander visibility.
         */
static void
ciano_widgets_source_list_tree_expander_cell_data_func (CianoWidgetsSourceListTree* self,
                                                        GtkCellLayout* layout,
                                                        GtkCellRenderer* renderer,
                                                        GtkTreeModel* model,
                                                        GtkTreeIter* iter)
{
	CianoWidgetsSourceListItem* item = NULL;
	GtkTreeIter _tmp0_;
	CianoWidgetsSourceListItem* _tmp1_;
	CianoWidgetsSourceListItem* _tmp2_;
	GraniteWidgetsCellRendererExpander* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (layout != NULL);
	g_return_if_fail (renderer != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	_tmp1_ = ciano_widgets_source_list_tree_get_item_from_model (model, &_tmp0_);
	item = _tmp1_;
	_tmp2_ = item;
	if (_tmp2_ != NULL) {
		CianoWidgetsSourceListExpandableItem* expandable_item = NULL;
		CianoWidgetsSourceListItem* _tmp3_;
		CianoWidgetsSourceListExpandableItem* _tmp4_;
		CianoWidgetsSourceListExpandableItem* _tmp5_;
		_tmp3_ = item;
		_tmp4_ = _g_object_ref0 (CIANO_WIDGETS_SOURCE_LIST_IS_EXPANDABLE_ITEM (_tmp3_) ? ((CianoWidgetsSourceListExpandableItem*) _tmp3_) : NULL);
		expandable_item = _tmp4_;
		_tmp5_ = expandable_item;
		if (_tmp5_ != NULL) {
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_;
			gboolean _tmp8_;
			g_object_get (renderer, "is-expander", &_tmp7_, NULL);
			_tmp8_ = _tmp7_;
			if (_tmp8_) {
				CianoWidgetsSourceListExpandableItem* _tmp9_;
				gboolean _tmp10_;
				gboolean _tmp11_;
				_tmp9_ = expandable_item;
				_tmp10_ = ciano_widgets_source_list_expandable_item_get_collapsible (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp6_ = _tmp11_;
			} else {
				_tmp6_ = FALSE;
			}
			g_object_set (renderer, "is-expander", _tmp6_, NULL);
		}
		_g_object_unref0 (expandable_item);
	}
	_tmp12_ = self->priv->primary_expander_cell;
	if (renderer == G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_cell_renderer_get_type (), GtkCellRenderer)) {
		CianoWidgetsSourceListDataModel* _tmp13_;
		GtkTreeIter _tmp14_;
		_tmp13_ = self->priv->_data_model;
		_tmp14_ = *iter;
		gtk_cell_renderer_set_visible (renderer, !ciano_widgets_source_list_data_model_is_iter_at_root_level (_tmp13_, &_tmp14_));
	} else {
		GraniteWidgetsCellRendererExpander* _tmp15_;
		_tmp15_ = self->priv->secondary_expander_cell;
		if (renderer == G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_cell_renderer_get_type (), GtkCellRenderer)) {
			CianoWidgetsSourceListDataModel* _tmp16_;
			CianoWidgetsSourceListItem* _tmp17_;
			GtkTreeIter _tmp18_;
			_tmp16_ = self->priv->_data_model;
			_tmp17_ = item;
			_tmp18_ = *iter;
			gtk_cell_renderer_set_visible (renderer, ciano_widgets_source_list_data_model_is_category (_tmp16_, _tmp17_, &_tmp18_, NULL));
		} else {
			g_assert_not_reached ();
		}
	}
	_g_object_unref0 (item);
}

static CianoWidgetsSourceListDataModel*
ciano_widgets_source_list_tree_get_data_model (CianoWidgetsSourceListTree* self)
{
	CianoWidgetsSourceListDataModel* result;
	CianoWidgetsSourceListDataModel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_model;
	result = _tmp0_;
	return result;
}

static void
ciano_widgets_source_list_tree_set_data_model (CianoWidgetsSourceListTree* self,
                                               CianoWidgetsSourceListDataModel* value)
{
	CianoWidgetsSourceListDataModel* old_value;
	g_return_if_fail (self != NULL);
	old_value = ciano_widgets_source_list_tree_get_data_model (self);
	if (old_value != value) {
		CianoWidgetsSourceListDataModel* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_data_model);
		self->priv->_data_model = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, ciano_widgets_source_list_tree_properties[CIANO_WIDGETS_SOURCE_LIST_TREE_DATA_MODEL_PROPERTY]);
	}
}

static CianoWidgetsSourceListItem*
ciano_widgets_source_list_tree_get_selected_item (CianoWidgetsSourceListTree* self)
{
	CianoWidgetsSourceListItem* result;
	CianoWidgetsSourceListItem* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->selected;
	result = _tmp0_;
	return result;
}

static void
ciano_widgets_source_list_tree_set_selected_item (CianoWidgetsSourceListTree* self,
                                                  CianoWidgetsSourceListItem* value)
{
	g_return_if_fail (self != NULL);
	ciano_widgets_source_list_tree_set_selected (self, value, TRUE);
	g_object_notify_by_pspec ((GObject *) self, ciano_widgets_source_list_tree_properties[CIANO_WIDGETS_SOURCE_LIST_TREE_SELECTED_ITEM_PROPERTY]);
}

static gboolean
ciano_widgets_source_list_tree_get_editing (CianoWidgetsSourceListTree* self)
{
	gboolean result;
	GtkCellRendererText* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->text_cell;
	g_object_get ((GtkCellRenderer*) _tmp0_, "editing", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static PangoEllipsizeMode
ciano_widgets_source_list_tree_get_ellipsize_mode (CianoWidgetsSourceListTree* self)
{
	PangoEllipsizeMode result;
	GtkCellRendererText* _tmp0_;
	PangoEllipsizeMode _tmp1_;
	PangoEllipsizeMode _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->text_cell;
	g_object_get (_tmp0_, "ellipsize", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
ciano_widgets_source_list_tree_set_ellipsize_mode (CianoWidgetsSourceListTree* self,
                                                   PangoEllipsizeMode value)
{
	GtkCellRendererText* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->text_cell;
	g_object_set (_tmp0_, "ellipsize", value, NULL);
	g_object_notify_by_pspec ((GObject *) self, ciano_widgets_source_list_tree_properties[CIANO_WIDGETS_SOURCE_LIST_TREE_ELLIPSIZE_MODE_PROPERTY]);
}

static void
ciano_widgets_source_list_tree_class_init (CianoWidgetsSourceListTreeClass * klass,
                                           gpointer klass_data)
{
	GParamSpecInt* _tmp0_;
	GParamSpecInt* _tmp1_;
	GParamSpecInt* _tmp2_;
	GParamSpecInt* _tmp3_;
	GParamSpecInt* _tmp4_;
	GParamSpecInt* _tmp5_;
	ciano_widgets_source_list_tree_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CianoWidgetsSourceListTree_private_offset);
	((GtkWidgetClass *) klass)->drag_motion = (gboolean (*) (GtkWidget*, GdkDragContext*, gint, gint, guint)) ciano_widgets_source_list_tree_real_drag_motion;
	((GtkWidgetClass *) klass)->drag_data_received = (void (*) (GtkWidget*, GdkDragContext*, gint, gint, GtkSelectionData*, guint, guint)) ciano_widgets_source_list_tree_real_drag_data_received;
	((GtkTreeViewClass *) klass)->cursor_changed = (void (*) (GtkTreeView*)) ciano_widgets_source_list_tree_real_cursor_changed;
	((GtkTreeViewClass *) klass)->row_expanded = (void (*) (GtkTreeView*, GtkTreeIter*, GtkTreePath*)) ciano_widgets_source_list_tree_real_row_expanded;
	((GtkTreeViewClass *) klass)->row_collapsed = (void (*) (GtkTreeView*, GtkTreeIter*, GtkTreePath*)) ciano_widgets_source_list_tree_real_row_collapsed;
	((GtkTreeViewClass *) klass)->row_activated = (void (*) (GtkTreeView*, GtkTreePath*, GtkTreeViewColumn*)) ciano_widgets_source_list_tree_real_row_activated;
	((GtkWidgetClass *) klass)->key_release_event = (gboolean (*) (GtkWidget*, GdkEventKey*)) ciano_widgets_source_list_tree_real_key_release_event;
	((GtkWidgetClass *) klass)->button_release_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) ciano_widgets_source_list_tree_real_button_release_event;
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) ciano_widgets_source_list_tree_real_button_press_event;
	((GtkWidgetClass *) klass)->popup_menu = (gboolean (*) (GtkWidget*)) ciano_widgets_source_list_tree_real_popup_menu;
	G_OBJECT_CLASS (klass)->get_property = _vala_ciano_widgets_source_list_tree_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_ciano_widgets_source_list_tree_set_property;
	G_OBJECT_CLASS (klass)->finalize = ciano_widgets_source_list_tree_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CIANO_WIDGETS_SOURCE_LIST_TREE_DATA_MODEL_PROPERTY, ciano_widgets_source_list_tree_properties[CIANO_WIDGETS_SOURCE_LIST_TREE_DATA_MODEL_PROPERTY] = g_param_spec_object ("data-model", "data-model", "data-model", CIANO_WIDGETS_SOURCE_LIST_TYPE_DATA_MODEL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CIANO_WIDGETS_SOURCE_LIST_TREE_SELECTED_ITEM_PROPERTY, ciano_widgets_source_list_tree_properties[CIANO_WIDGETS_SOURCE_LIST_TREE_SELECTED_ITEM_PROPERTY] = g_param_spec_object ("selected-item", "selected-item", "selected-item", CIANO_WIDGETS_SOURCE_LIST_TYPE_ITEM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CIANO_WIDGETS_SOURCE_LIST_TREE_EDITING_PROPERTY, ciano_widgets_source_list_tree_properties[CIANO_WIDGETS_SOURCE_LIST_TREE_EDITING_PROPERTY] = g_param_spec_boolean ("editing", "editing", "editing", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CIANO_WIDGETS_SOURCE_LIST_TREE_ELLIPSIZE_MODE_PROPERTY, ciano_widgets_source_list_tree_properties[CIANO_WIDGETS_SOURCE_LIST_TREE_ELLIPSIZE_MODE_PROPERTY] = g_param_spec_enum ("ellipsize-mode", "ellipsize-mode", "ellipsize-mode", pango_ellipsize_mode_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	ciano_widgets_source_list_tree_signals[CIANO_WIDGETS_SOURCE_LIST_TREE_ITEM_SELECTED_SIGNAL] = g_signal_new ("item-selected", CIANO_WIDGETS_SOURCE_LIST_TYPE_TREE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, CIANO_WIDGETS_SOURCE_LIST_TYPE_ITEM);
	_tmp0_ = (GParamSpecInt*) g_param_spec_int (CIANO_WIDGETS_SOURCE_LIST_TREE_STYLE_PROP_LEVEL_INDENTATION, "Level Indentation", "Space to add at the beginning of every indentation level. Must be an e" \
"ven number.", 1, 50, 6, G_PARAM_READABLE);
	_tmp1_ = _tmp0_;
	gtk_widget_class_install_style_property (GTK_WIDGET_CLASS (klass), (GParamSpec*) _tmp1_);
	_g_param_spec_unref0 (_tmp1_);
	_tmp2_ = (GParamSpecInt*) g_param_spec_int (CIANO_WIDGETS_SOURCE_LIST_TREE_STYLE_PROP_LEFT_PADDING, "Left Padding", "Padding added to the left side of the tree. Must be an even number.", 1, 50, 4, G_PARAM_READABLE);
	_tmp3_ = _tmp2_;
	gtk_widget_class_install_style_property (GTK_WIDGET_CLASS (klass), (GParamSpec*) _tmp3_);
	_g_param_spec_unref0 (_tmp3_);
	_tmp4_ = (GParamSpecInt*) g_param_spec_int (CIANO_WIDGETS_SOURCE_LIST_TREE_STYLE_PROP_EXPANDER_SPACING, "Expander Spacing", "Space added between an item and its expander. Must be an even number.", 1, 50, 4, G_PARAM_READABLE);
	_tmp5_ = _tmp4_;
	gtk_widget_class_install_style_property (GTK_WIDGET_CLASS (klass), (GParamSpec*) _tmp5_);
	_g_param_spec_unref0 (_tmp5_);
}

static void
ciano_widgets_source_list_tree_instance_init (CianoWidgetsSourceListTree * self,
                                              gpointer klass)
{
	self->priv = ciano_widgets_source_list_tree_get_instance_private (self);
	self->priv->unselectable_item_clicked = FALSE;
}

static void
ciano_widgets_source_list_tree_finalize (GObject * obj)
{
	CianoWidgetsSourceListTree * self;
	GtkCellRendererText* _tmp0_;
	guint _tmp1_;
	GtkCellRendererText* _tmp2_;
	guint _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CIANO_WIDGETS_SOURCE_LIST_TYPE_TREE, CianoWidgetsSourceListTree);
	_tmp0_ = self->priv->text_cell;
	g_signal_parse_name ("editing-started", gtk_cell_renderer_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkCellRenderer*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _ciano_widgets_source_list_tree_on_editing_started_gtk_cell_renderer_editing_started, self);
	_tmp2_ = self->priv->text_cell;
	g_signal_parse_name ("editing-canceled", gtk_cell_renderer_get_type (), &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkCellRenderer*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _ciano_widgets_source_list_tree_on_editing_canceled_gtk_cell_renderer_editing_canceled, self);
	ciano_widgets_source_list_tree_disable_item_property_monitor (self);
	_g_object_unref0 (self->priv->_data_model);
	_g_object_unref0 (self->priv->selected);
	_g_object_unref0 (self->priv->editable_entry);
	_g_object_unref0 (self->priv->text_cell);
	_g_object_unref0 (self->priv->icon_cell);
	_g_object_unref0 (self->priv->activatable_cell);
	_g_object_unref0 (self->priv->badge_cell);
	_g_object_unref0 (self->priv->primary_expander_cell);
	_g_object_unref0 (self->priv->secondary_expander_cell);
	_g_object_unref0 (self->priv->spacer_cells);
	G_OBJECT_CLASS (ciano_widgets_source_list_tree_parent_class)->finalize (obj);
}

/**
     * The tree that actually displays the items.
     *
     * All the user interaction happens here.
     */
static GType
ciano_widgets_source_list_tree_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CianoWidgetsSourceListTreeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ciano_widgets_source_list_tree_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CianoWidgetsSourceListTree), 0, (GInstanceInitFunc) ciano_widgets_source_list_tree_instance_init, NULL };
	GType ciano_widgets_source_list_tree_type_id;
	ciano_widgets_source_list_tree_type_id = g_type_register_static (gtk_tree_view_get_type (), "CianoWidgetsSourceListTree", &g_define_type_info, 0);
	CianoWidgetsSourceListTree_private_offset = g_type_add_instance_private (ciano_widgets_source_list_tree_type_id, sizeof (CianoWidgetsSourceListTreePrivate));
	return ciano_widgets_source_list_tree_type_id;
}

static GType
ciano_widgets_source_list_tree_get_type (void)
{
	static volatile gsize ciano_widgets_source_list_tree_type_id__once = 0;
	if (g_once_init_enter (&ciano_widgets_source_list_tree_type_id__once)) {
		GType ciano_widgets_source_list_tree_type_id;
		ciano_widgets_source_list_tree_type_id = ciano_widgets_source_list_tree_get_type_once ();
		g_once_init_leave (&ciano_widgets_source_list_tree_type_id__once, ciano_widgets_source_list_tree_type_id);
	}
	return ciano_widgets_source_list_tree_type_id__once;
}

static void
_vala_ciano_widgets_source_list_tree_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec)
{
	CianoWidgetsSourceListTree * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CIANO_WIDGETS_SOURCE_LIST_TYPE_TREE, CianoWidgetsSourceListTree);
	switch (property_id) {
		case CIANO_WIDGETS_SOURCE_LIST_TREE_DATA_MODEL_PROPERTY:
		g_value_set_object (value, ciano_widgets_source_list_tree_get_data_model (self));
		break;
		case CIANO_WIDGETS_SOURCE_LIST_TREE_SELECTED_ITEM_PROPERTY:
		g_value_set_object (value, ciano_widgets_source_list_tree_get_selected_item (self));
		break;
		case CIANO_WIDGETS_SOURCE_LIST_TREE_EDITING_PROPERTY:
		g_value_set_boolean (value, ciano_widgets_source_list_tree_get_editing (self));
		break;
		case CIANO_WIDGETS_SOURCE_LIST_TREE_ELLIPSIZE_MODE_PROPERTY:
		g_value_set_enum (value, ciano_widgets_source_list_tree_get_ellipsize_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_ciano_widgets_source_list_tree_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec)
{
	CianoWidgetsSourceListTree * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CIANO_WIDGETS_SOURCE_LIST_TYPE_TREE, CianoWidgetsSourceListTree);
	switch (property_id) {
		case CIANO_WIDGETS_SOURCE_LIST_TREE_DATA_MODEL_PROPERTY:
		ciano_widgets_source_list_tree_set_data_model (self, g_value_get_object (value));
		break;
		case CIANO_WIDGETS_SOURCE_LIST_TREE_SELECTED_ITEM_PROPERTY:
		ciano_widgets_source_list_tree_set_selected_item (self, g_value_get_object (value));
		break;
		case CIANO_WIDGETS_SOURCE_LIST_TREE_ELLIPSIZE_MODE_PROPERTY:
		ciano_widgets_source_list_tree_set_ellipsize_mode (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
ciano_widgets_source_list_class_init (CianoWidgetsSourceListClass * klass,
                                      gpointer klass_data)
{
	ciano_widgets_source_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CianoWidgetsSourceList_private_offset);
	((CianoWidgetsSourceListClass *) klass)->item_selected = ciano_widgets_source_list_real_item_selected;
	G_OBJECT_CLASS (klass)->get_property = _vala_ciano_widgets_source_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_ciano_widgets_source_list_set_property;
	G_OBJECT_CLASS (klass)->finalize = ciano_widgets_source_list_finalize;
	/**
	     * Root-level expandable item.
	     *
	     * This item contains the first-level source list items. It //only serves as an item container//.
	     * It is used to add and remove items to/from the widget.
	     *
	     * Internally, it allows the source list to connect to its {@link Granite.Widgets.SourceList.ExpandableItem.child_added}
	     * and {@link Granite.Widgets.SourceList.ExpandableItem.child_removed} signals in order to monitor
	     * new children additions/removals.
	     *
	     * @since 0.2
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CIANO_WIDGETS_SOURCE_LIST_ROOT_PROPERTY, ciano_widgets_source_list_properties[CIANO_WIDGETS_SOURCE_LIST_ROOT_PROPERTY] = g_param_spec_object ("root", "root", "root", CIANO_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The current selected item.
	     *
	     * Setting it to //null// un-selects the previously selected item, if there was any.
	     * {@link Granite.Widgets.SourceList.ExpandableItem.expand_with_parents} is called on the
	     * item's parent to make sure it's possible to select it.
	     *
	     * @since 0.2
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CIANO_WIDGETS_SOURCE_LIST_SELECTED_PROPERTY, ciano_widgets_source_list_properties[CIANO_WIDGETS_SOURCE_LIST_SELECTED_PROPERTY] = g_param_spec_object ("selected", "selected", "selected", CIANO_WIDGETS_SOURCE_LIST_TYPE_ITEM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Text ellipsize mode.
	     *
	     * @since 0.2
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CIANO_WIDGETS_SOURCE_LIST_ELLIPSIZE_MODE_PROPERTY, ciano_widgets_source_list_properties[CIANO_WIDGETS_SOURCE_LIST_ELLIPSIZE_MODE_PROPERTY] = g_param_spec_enum ("ellipsize-mode", "ellipsize-mode", "ellipsize-mode", pango_ellipsize_mode_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Whether an item is being edited.
	     *
	     * @see Granite.Widgets.SourceList.start_editing_item
	     * @since 0.2
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CIANO_WIDGETS_SOURCE_LIST_EDITING_PROPERTY, ciano_widgets_source_list_properties[CIANO_WIDGETS_SOURCE_LIST_EDITING_PROPERTY] = g_param_spec_boolean ("editing", "editing", "editing", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Sort direction to use along with the sort function.
	     *
	     * This property is no longer used. It doesn't do anything.
	     *
	     * @since 0.2
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CIANO_WIDGETS_SOURCE_LIST_SORT_DIRECTION_PROPERTY, ciano_widgets_source_list_properties[CIANO_WIDGETS_SOURCE_LIST_SORT_DIRECTION_PROPERTY] = g_param_spec_enum ("sort-direction", "sort-direction", "sort-direction", gtk_sort_type_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_DEPRECATED));
	/**
	     * Emitted when the source list selection changes.
	     *
	     * @param item Selected item; //null// if nothing is selected.
	     * @since 0.2
	     */
	ciano_widgets_source_list_signals[CIANO_WIDGETS_SOURCE_LIST_ITEM_SELECTED_SIGNAL] = g_signal_new ("item-selected", CIANO_WIDGETS_TYPE_SOURCE_LIST, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (CianoWidgetsSourceListClass, item_selected), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, CIANO_WIDGETS_SOURCE_LIST_TYPE_ITEM);
}

static void
ciano_widgets_source_list_instance_init (CianoWidgetsSourceList * self,
                                         gpointer klass)
{
	CianoWidgetsSourceListDataModel* _tmp0_;
	self->priv = ciano_widgets_source_list_get_instance_private (self);
	_tmp0_ = ciano_widgets_source_list_data_model_new ();
	self->priv->data_model = _tmp0_;
}

static void
ciano_widgets_source_list_finalize (GObject * obj)
{
	CianoWidgetsSourceList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CIANO_WIDGETS_TYPE_SOURCE_LIST, CianoWidgetsSourceList);
	_g_object_unref0 (self->priv->tree);
	_g_object_unref0 (self->priv->data_model);
	G_OBJECT_CLASS (ciano_widgets_source_list_parent_class)->finalize (obj);
}

/**
 * A widget that can display a list of items organized in categories.
 *
 * The source list widget consists of a collection of items, some of which are also expandable (and
 * thus can contain more items). All the items displayed in the source list are children of the widget's
 * root item. The API is meant to be used as follows:
 *
 * 1. Create the items you want to display in the source list, setting the appropriate values for their
 * properties. The desired hierarchy is achieved by creating expandable items and adding items to them.
 * These will be displayed as descendants in the widget's tree structure. The expandable items that are
 * not nested inside any other item are considered to be at root level, and should be added to
 * the widget's root item.<<BR>>
 *
 * Expandable items located at the root level are treated as categories, and only support text.
 *
 * ''Example''<<BR>>
 * The final tree will have the following structure:
 * {{{
 * Libraries
 *   Music
 * Stores
 *   My Store
 *      Music
 *      Podcasts
 * Devices
 *   Player 1
 *   Player 2
 * }}}
 *
 * {{{
 * var library_category = new Granite.Widgets.SourceList.ExpandableItem ("Libraries");
 * var store_category = new Granite.Widgets.SourceList.ExpandableItem ("Stores");
 * var device_category = new Granite.Widgets.SourceList.ExpandableItem ("Devices");
 *
 * var music_item = new Granite.Widgets.SourceList.Item ("Music");
 *
 * // "Libraries" will be the parent category of "Music"
 * library_category.add (music_item);
 *
 * // We plan to add sub-items to the store, so let's use an expandable item
 * var my_store_item = new Granite.Widgets.SourceList.ExpandableItem ("My Store");
 * store_category.add (my_store_item);
 *
 * var my_store_podcast_item = new Granite.Widgets.SourceList.Item ("Podcasts");
 * var my_store_music_item = new Granite.Widgets.SourceList.Item ("Music");
 *
 * my_store_item.add (my_store_music_item);
 * my_store_item.add (my_store_podcast_item);
 *
 * var player1_item = new Granite.Widgets.SourceList.Item ("Player 1");
 * var player2_item = new Granite.Widgets.SourceList.Item ("Player 2");
 *
 * device_category.add (player1_item);
 * device_category.add (player2_item);
 * }}}
 *
 * 2. Create a source list widget.<<BR>>
 * {{{
 * var source_list = new Granite.Widgets.SourceList ();
 * }}}
 *
 * 3. Add root-level items to the {@link Granite.Widgets.SourceList.root} item.
 * This item only serves as a container, and all its properties are ignored by the widget.
 *
 * {{{
 * // This will add the main categories (including their children) to the source list. After
 * // having being added to be widget, any other item added to any of these items
 * // (or any other child item in a deeper level) will be automatically added too.
 * // There's no need to deal with the source list widget directly.
 *
 * var root = source_list.root;
 *
 * root.add (library_category);
 * root.add (store_category);
 * root.add (device_category);
 * }}}
 *
 * The steps mentioned above are enough for initializing the source list. Future changes to the items'
 * properties are ''automatically'' reflected by the widget.
 *
 * Final steps would involve connecting handlers to the source list events, being
 * {@link Granite.Widgets.SourceList.item_selected} the most important, as it indicates that
 * the selection was modified.
 *
 * It is strongly recommended to pack the source list into the GUI using the
 * {@link Granite.Widgets.ThinPaned} widget. It has aesthetic advantages and offers a wider
 * re-size handle than {@link Gtk.Paned}. This is usually done as follows:
 * {{{
 * var pane = new Granite.Widgets.ThinPaned ();
 * pane.pack1 (source_list, false, false);
 * pane.pack2 (content_area, true, false);
 * }}}
 *
 * @since 0.2
 * @see Granite.Widgets.ThinPaned
 */
static GType
ciano_widgets_source_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CianoWidgetsSourceListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ciano_widgets_source_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CianoWidgetsSourceList), 0, (GInstanceInitFunc) ciano_widgets_source_list_instance_init, NULL };
	GType ciano_widgets_source_list_type_id;
	ciano_widgets_source_list_type_id = g_type_register_static (gtk_scrolled_window_get_type (), "CianoWidgetsSourceList", &g_define_type_info, 0);
	CianoWidgetsSourceList_private_offset = g_type_add_instance_private (ciano_widgets_source_list_type_id, sizeof (CianoWidgetsSourceListPrivate));
	return ciano_widgets_source_list_type_id;
}

GType
ciano_widgets_source_list_get_type (void)
{
	static volatile gsize ciano_widgets_source_list_type_id__once = 0;
	if (g_once_init_enter (&ciano_widgets_source_list_type_id__once)) {
		GType ciano_widgets_source_list_type_id;
		ciano_widgets_source_list_type_id = ciano_widgets_source_list_get_type_once ();
		g_once_init_leave (&ciano_widgets_source_list_type_id__once, ciano_widgets_source_list_type_id);
	}
	return ciano_widgets_source_list_type_id__once;
}

static void
_vala_ciano_widgets_source_list_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	CianoWidgetsSourceList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CIANO_WIDGETS_TYPE_SOURCE_LIST, CianoWidgetsSourceList);
	switch (property_id) {
		case CIANO_WIDGETS_SOURCE_LIST_ROOT_PROPERTY:
		g_value_set_object (value, ciano_widgets_source_list_get_root (self));
		break;
		case CIANO_WIDGETS_SOURCE_LIST_SELECTED_PROPERTY:
		g_value_set_object (value, ciano_widgets_source_list_get_selected (self));
		break;
		case CIANO_WIDGETS_SOURCE_LIST_ELLIPSIZE_MODE_PROPERTY:
		g_value_set_enum (value, ciano_widgets_source_list_get_ellipsize_mode (self));
		break;
		case CIANO_WIDGETS_SOURCE_LIST_EDITING_PROPERTY:
		g_value_set_boolean (value, ciano_widgets_source_list_get_editing (self));
		break;
		case CIANO_WIDGETS_SOURCE_LIST_SORT_DIRECTION_PROPERTY:
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
		g_value_set_enum (value, ciano_widgets_source_list_get_sort_direction (self));
G_GNUC_END_IGNORE_DEPRECATIONS
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_ciano_widgets_source_list_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	CianoWidgetsSourceList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CIANO_WIDGETS_TYPE_SOURCE_LIST, CianoWidgetsSourceList);
	switch (property_id) {
		case CIANO_WIDGETS_SOURCE_LIST_ROOT_PROPERTY:
		ciano_widgets_source_list_set_root (self, g_value_get_object (value));
		break;
		case CIANO_WIDGETS_SOURCE_LIST_SELECTED_PROPERTY:
		ciano_widgets_source_list_set_selected (self, g_value_get_object (value));
		break;
		case CIANO_WIDGETS_SOURCE_LIST_ELLIPSIZE_MODE_PROPERTY:
		ciano_widgets_source_list_set_ellipsize_mode (self, g_value_get_enum (value));
		break;
		case CIANO_WIDGETS_SOURCE_LIST_SORT_DIRECTION_PROPERTY:
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
		ciano_widgets_source_list_set_sort_direction (self, g_value_get_enum (value));
G_GNUC_END_IGNORE_DEPRECATIONS
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

