/* TimeUtil.c generated by valac 0.56.17, the Vala compiler
 * generated from TimeUtil.vala, do not modify */

/*
* Copyright (c) 2017 Robert San <robertsanseries@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
* 
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CIANO_UTILS_TYPE_TIME_UTIL (ciano_utils_time_util_get_type ())
#define CIANO_UTILS_TIME_UTIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CIANO_UTILS_TYPE_TIME_UTIL, CianoUtilsTimeUtil))
#define CIANO_UTILS_TIME_UTIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CIANO_UTILS_TYPE_TIME_UTIL, CianoUtilsTimeUtilClass))
#define CIANO_UTILS_IS_TIME_UTIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CIANO_UTILS_TYPE_TIME_UTIL))
#define CIANO_UTILS_IS_TIME_UTIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CIANO_UTILS_TYPE_TIME_UTIL))
#define CIANO_UTILS_TIME_UTIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CIANO_UTILS_TYPE_TIME_UTIL, CianoUtilsTimeUtilClass))

typedef struct _CianoUtilsTimeUtil CianoUtilsTimeUtil;
typedef struct _CianoUtilsTimeUtilClass CianoUtilsTimeUtilClass;
typedef struct _CianoUtilsTimeUtilPrivate CianoUtilsTimeUtilPrivate;
typedef struct _CianoUtilsParamSpecTimeUtil CianoUtilsParamSpecTimeUtil;

struct _CianoUtilsTimeUtil {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CianoUtilsTimeUtilPrivate * priv;
};

struct _CianoUtilsTimeUtilClass {
	GTypeClass parent_class;
	void (*finalize) (CianoUtilsTimeUtil *self);
};

struct _CianoUtilsParamSpecTimeUtil {
	GParamSpec parent_instance;
};

static gpointer ciano_utils_time_util_parent_class = NULL;

VALA_EXTERN gpointer ciano_utils_time_util_ref (gpointer instance);
VALA_EXTERN void ciano_utils_time_util_unref (gpointer instance);
VALA_EXTERN GParamSpec* ciano_utils_param_spec_time_util (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
VALA_EXTERN void ciano_utils_value_set_time_util (GValue* value,
                                      gpointer v_object);
VALA_EXTERN void ciano_utils_value_take_time_util (GValue* value,
                                       gpointer v_object);
VALA_EXTERN gpointer ciano_utils_value_get_time_util (const GValue* value);
VALA_EXTERN GType ciano_utils_time_util_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CianoUtilsTimeUtil, ciano_utils_time_util_unref)
VALA_EXTERN gint ciano_utils_time_util_duration_in_seconds (const gchar* duration);
VALA_EXTERN CianoUtilsTimeUtil* ciano_utils_time_util_new (void);
VALA_EXTERN CianoUtilsTimeUtil* ciano_utils_time_util_construct (GType object_type);
static void ciano_utils_time_util_finalize (CianoUtilsTimeUtil * obj);
static GType ciano_utils_time_util_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

/**
         * Responsible for getting the value of in string duration in 
         * the format "00:00:00:00.00" and returning the duration in seconds.
         *
         * Exemple:
         * > TimeUtil.duration_in_seconds("00:01:14:36.00")  = 74
         * 
         * @param  {@code string} duration
         * @return {@code int}
         */
gint
ciano_utils_time_util_duration_in_seconds (const gchar* duration)
{
	gchar** str = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint str_length1;
	gint _str_size_;
	gchar** time = NULL;
	const gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint time_length1;
	gint _time_size_;
	gint hours = 0;
	const gchar* _tmp5_;
	gint mins = 0;
	const gchar* _tmp6_;
	gint secs = 0;
	const gchar* _tmp7_;
	gint result;
	g_return_val_if_fail (duration != NULL, 0);
	_tmp1_ = _tmp0_ = g_strsplit (duration, ".", 0);
	str = _tmp1_;
	str_length1 = _vala_array_length (_tmp0_);
	_str_size_ = str_length1;
	_tmp2_ = str[0];
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, ":", 0);
	time = _tmp4_;
	time_length1 = _vala_array_length (_tmp3_);
	_time_size_ = time_length1;
	_tmp5_ = time[0];
	hours = atoi (_tmp5_);
	_tmp6_ = time[1];
	mins = atoi (_tmp6_);
	_tmp7_ = time[2];
	secs = atoi (_tmp7_);
	result = (secs + (hours * 3600)) + (mins * 60);
	time = (_vala_array_free (time, time_length1, (GDestroyNotify) g_free), NULL);
	str = (_vala_array_free (str, str_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

CianoUtilsTimeUtil*
ciano_utils_time_util_construct (GType object_type)
{
	CianoUtilsTimeUtil* self = NULL;
	self = (CianoUtilsTimeUtil*) g_type_create_instance (object_type);
	return self;
}

CianoUtilsTimeUtil*
ciano_utils_time_util_new (void)
{
	return ciano_utils_time_util_construct (CIANO_UTILS_TYPE_TIME_UTIL);
}

static void
ciano_utils_value_time_util_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
ciano_utils_value_time_util_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		ciano_utils_time_util_unref (value->data[0].v_pointer);
	}
}

static void
ciano_utils_value_time_util_copy_value (const GValue* src_value,
                                        GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = ciano_utils_time_util_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
ciano_utils_value_time_util_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
ciano_utils_value_time_util_collect_value (GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		CianoUtilsTimeUtil * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = ciano_utils_time_util_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
ciano_utils_value_time_util_lcopy_value (const GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	CianoUtilsTimeUtil ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = ciano_utils_time_util_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
ciano_utils_param_spec_time_util (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags)
{
	CianoUtilsParamSpecTimeUtil* spec;
	g_return_val_if_fail (g_type_is_a (object_type, CIANO_UTILS_TYPE_TIME_UTIL), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
ciano_utils_value_get_time_util (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CIANO_UTILS_TYPE_TIME_UTIL), NULL);
	return value->data[0].v_pointer;
}

void
ciano_utils_value_set_time_util (GValue* value,
                                 gpointer v_object)
{
	CianoUtilsTimeUtil * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CIANO_UTILS_TYPE_TIME_UTIL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CIANO_UTILS_TYPE_TIME_UTIL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		ciano_utils_time_util_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ciano_utils_time_util_unref (old);
	}
}

void
ciano_utils_value_take_time_util (GValue* value,
                                  gpointer v_object)
{
	CianoUtilsTimeUtil * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CIANO_UTILS_TYPE_TIME_UTIL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CIANO_UTILS_TYPE_TIME_UTIL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ciano_utils_time_util_unref (old);
	}
}

static void
ciano_utils_time_util_class_init (CianoUtilsTimeUtilClass * klass,
                                  gpointer klass_data)
{
	ciano_utils_time_util_parent_class = g_type_class_peek_parent (klass);
	((CianoUtilsTimeUtilClass *) klass)->finalize = ciano_utils_time_util_finalize;
}

static void
ciano_utils_time_util_instance_init (CianoUtilsTimeUtil * self,
                                     gpointer klass)
{
	self->ref_count = 1;
}

static void
ciano_utils_time_util_finalize (CianoUtilsTimeUtil * obj)
{
	CianoUtilsTimeUtil * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CIANO_UTILS_TYPE_TIME_UTIL, CianoUtilsTimeUtil);
	g_signal_handlers_destroy (self);
}

/**
     * The class {@code TimeUtil} handles time-related data.
     *
     * @since 0.1.0
     */
static GType
ciano_utils_time_util_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { ciano_utils_value_time_util_init, ciano_utils_value_time_util_free_value, ciano_utils_value_time_util_copy_value, ciano_utils_value_time_util_peek_pointer, "p", ciano_utils_value_time_util_collect_value, "p", ciano_utils_value_time_util_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (CianoUtilsTimeUtilClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ciano_utils_time_util_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CianoUtilsTimeUtil), 0, (GInstanceInitFunc) ciano_utils_time_util_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType ciano_utils_time_util_type_id;
	ciano_utils_time_util_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CianoUtilsTimeUtil", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return ciano_utils_time_util_type_id;
}

GType
ciano_utils_time_util_get_type (void)
{
	static volatile gsize ciano_utils_time_util_type_id__once = 0;
	if (g_once_init_enter (&ciano_utils_time_util_type_id__once)) {
		GType ciano_utils_time_util_type_id;
		ciano_utils_time_util_type_id = ciano_utils_time_util_get_type_once ();
		g_once_init_leave (&ciano_utils_time_util_type_id__once, ciano_utils_time_util_type_id);
	}
	return ciano_utils_time_util_type_id__once;
}

gpointer
ciano_utils_time_util_ref (gpointer instance)
{
	CianoUtilsTimeUtil * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
ciano_utils_time_util_unref (gpointer instance)
{
	CianoUtilsTimeUtil * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CIANO_UTILS_TIME_UTIL_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

