/* calendar.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from calendar.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "org.buddiesofbudgie.budgie-desktop.raven.widget.Calendar.h"
#include <glib.h>
#include <gio/gio.h>
#include <string.h>
#include <stdlib.h>
#include "raven-plugin.h"
#include <glib-object.h>
#include <gtk/gtk.h>
#include <libpeas.h>

#define CALENDAR_RAVEN_WIDGET_date_format "%e %b %Y"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	RAVEN_TO_CALENDAR_REMOTE_EXPANSION_CHANGED_SIGNAL,
	RAVEN_TO_CALENDAR_REMOTE_NUM_SIGNALS
};
static guint raven_to_calendar_remote_signals[RAVEN_TO_CALENDAR_REMOTE_NUM_SIGNALS] = {0};
typedef GDBusProxy RavenToCalendarRemoteProxy;
typedef GDBusProxyClass RavenToCalendarRemoteProxyClass;
enum  {
	CALENDAR_RAVEN_PLUGIN_0_PROPERTY,
	CALENDAR_RAVEN_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* calendar_raven_plugin_properties[CALENDAR_RAVEN_PLUGIN_NUM_PROPERTIES];
enum  {
	CALENDAR_RAVEN_WIDGET_0_PROPERTY,
	CALENDAR_RAVEN_WIDGET_NUM_PROPERTIES
};
static GParamSpec* calendar_raven_widget_properties[CALENDAR_RAVEN_WIDGET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	CALENDAR_RAVEN_WIDGET_SETTINGS_0_PROPERTY,
	CALENDAR_RAVEN_WIDGET_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* calendar_raven_widget_settings_properties[CALENDAR_RAVEN_WIDGET_SETTINGS_NUM_PROPERTIES];

struct _CalendarRavenWidgetPrivate {
	GtkBox* header;
	GtkButton* header_reveal_button;
	GtkRevealer* content_revealer;
	GtkBox* content;
	GtkLabel* header_label;
	GtkBox* main_box;
	GtkCalendar* cal;
	RavenToCalendarRemote* raven_proxy;
};

struct _CalendarRavenWidgetSettingsPrivate {
	GtkSwitch* switch_show_day_names;
	GtkSwitch* switch_show_week_numbers;
};

static GType raven_to_calendar_remote_type_id = 0;
static gpointer calendar_raven_plugin_parent_class = NULL;
static BudgieRavenPluginIface * calendar_raven_plugin_budgie_raven_plugin_parent_iface = NULL;
static GType calendar_raven_plugin_type_id = 0;
static gint CalendarRavenWidget_private_offset;
static gpointer calendar_raven_widget_parent_class = NULL;
static GType calendar_raven_widget_type_id = 0;
static gint CalendarRavenWidgetSettings_private_offset;
static gpointer calendar_raven_widget_settings_parent_class = NULL;
static GType calendar_raven_widget_settings_type_id = 0;

static void raven_to_calendar_remote_proxy_g_signal (GDBusProxy* proxy,
                                              const gchar* sender_name,
                                              const gchar* signal_name,
                                              GVariant* parameters);
static void _dbus_handle_raven_to_calendar_remote_expansion_changed (RavenToCalendarRemote* self,
                                                              GVariant* parameters);
static void raven_to_calendar_remote_proxy_raven_to_calendar_remote_interface_init (RavenToCalendarRemoteIface* iface);
static void raven_to_calendar_remote_dbus_interface_method_call (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* method_name,
                                                          GVariant* parameters,
                                                          GDBusMethodInvocation* invocation,
                                                          gpointer user_data);
static GVariant* raven_to_calendar_remote_dbus_interface_get_property (GDBusConnection* connection,
                                                                const gchar* sender,
                                                                const gchar* object_path,
                                                                const gchar* interface_name,
                                                                const gchar* property_name,
                                                                GError** error,
                                                                gpointer user_data);
static gboolean raven_to_calendar_remote_dbus_interface_set_property (GDBusConnection* connection,
                                                               const gchar* sender,
                                                               const gchar* object_path,
                                                               const gchar* interface_name,
                                                               const gchar* property_name,
                                                               GVariant* value,
                                                               GError** error,
                                                               gpointer user_data);
static void _dbus_raven_to_calendar_remote_expansion_changed (GObject* _sender,
                                                       gboolean is_expanded,
                                                       gpointer* _data);
static void _raven_to_calendar_remote_unregister_object (gpointer user_data);
static BudgieRavenWidget* calendar_raven_plugin_real_new_widget_instance (BudgieRavenPlugin* base,
                                                                   const gchar* uuid,
                                                                   GSettings* settings);
static gboolean calendar_raven_plugin_real_supports_settings (BudgieRavenPlugin* base);
static void __lambda4_ (CalendarRavenWidget* self);
static void ___lambda4__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
static void __lambda5_ (CalendarRavenWidget* self);
static gboolean calendar_raven_widget_update_selection (CalendarRavenWidget* self);
static void ___lambda5__gtk_calendar_month_changed (GtkCalendar* _sender,
                                             gpointer self);
static void calendar_raven_widget_settings_updated (CalendarRavenWidget* self,
                                             const gchar* key);
static void _calendar_raven_widget_settings_updated_g_settings_changed (GSettings* _sender,
                                                                 const gchar* key,
                                                                 gpointer self);
static void calendar_raven_widget_on_raven_get (CalendarRavenWidget* self,
                                         GObject* o,
                                         GAsyncResult* res);
static void _calendar_raven_widget_on_raven_get_gasync_ready_callback (GObject* source_object,
                                                                GAsyncResult* res,
                                                                gpointer self);
static void ___lambda6_ (CalendarRavenWidget* self,
                  gboolean is_expanded);
static gboolean calendar_raven_widget_on_visibility_changed (CalendarRavenWidget* self,
                                                      gboolean is_expanded);
static void ____lambda6__raven_to_calendar_remote_expansion_changed (RavenToCalendarRemote* _sender,
                                                              gboolean is_expanded,
                                                              gpointer self);
static GtkWidget* calendar_raven_widget_real_build_settings_ui (BudgieRavenWidget* base);
static void calendar_raven_widget_finalize (GObject * obj);
static void calendar_raven_widget_settings_finalize (GObject * obj);

static const GDBusMethodInfo * const _raven_to_calendar_remote_dbus_method_info[] = {NULL};
static const GDBusArgInfo _raven_to_calendar_remote_dbus_arg_info_expansion_changed_is_expanded = {-1, "is_expanded", "b", NULL};
static const GDBusArgInfo * const _raven_to_calendar_remote_dbus_arg_info_expansion_changed[] = {&_raven_to_calendar_remote_dbus_arg_info_expansion_changed_is_expanded, NULL};
static const GDBusSignalInfo _raven_to_calendar_remote_dbus_signal_info_expansion_changed = {-1, "ExpansionChanged", (GDBusArgInfo **) (&_raven_to_calendar_remote_dbus_arg_info_expansion_changed), NULL};
static const GDBusSignalInfo * const _raven_to_calendar_remote_dbus_signal_info[] = {&_raven_to_calendar_remote_dbus_signal_info_expansion_changed, NULL};
static const GDBusPropertyInfo * const _raven_to_calendar_remote_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _raven_to_calendar_remote_dbus_interface_info = {-1, "org.budgie_desktop.Raven", (GDBusMethodInfo **) (&_raven_to_calendar_remote_dbus_method_info), (GDBusSignalInfo **) (&_raven_to_calendar_remote_dbus_signal_info), (GDBusPropertyInfo **) (&_raven_to_calendar_remote_dbus_property_info), NULL};
static const GDBusInterfaceVTable _raven_to_calendar_remote_dbus_interface_vtable = {raven_to_calendar_remote_dbus_interface_method_call, raven_to_calendar_remote_dbus_interface_get_property, raven_to_calendar_remote_dbus_interface_set_property};

static void
raven_to_calendar_remote_default_init (RavenToCalendarRemoteIface * iface,
                                       gpointer iface_data)
{
	raven_to_calendar_remote_signals[RAVEN_TO_CALENDAR_REMOTE_EXPANSION_CHANGED_SIGNAL] = g_signal_new ("expansion-changed", TYPE_RAVEN_TO_CALENDAR_REMOTE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}

GType
raven_to_calendar_remote_get_type (void)
{
	return raven_to_calendar_remote_type_id;
}

GType
raven_to_calendar_remote_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (RavenToCalendarRemoteIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) raven_to_calendar_remote_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	raven_to_calendar_remote_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "RavenToCalendarRemote", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (raven_to_calendar_remote_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (raven_to_calendar_remote_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) raven_to_calendar_remote_proxy_get_type);
	g_type_set_qdata (raven_to_calendar_remote_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.budgie_desktop.Raven");
	g_type_set_qdata (raven_to_calendar_remote_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_raven_to_calendar_remote_dbus_interface_info));
	g_type_set_qdata (raven_to_calendar_remote_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) raven_to_calendar_remote_register_object);
	return raven_to_calendar_remote_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (RavenToCalendarRemoteProxy, raven_to_calendar_remote_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (TYPE_RAVEN_TO_CALENDAR_REMOTE, raven_to_calendar_remote_proxy_raven_to_calendar_remote_interface_init) )
static void
raven_to_calendar_remote_proxy_class_init (RavenToCalendarRemoteProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = raven_to_calendar_remote_proxy_g_signal;
}

static void
_dbus_handle_raven_to_calendar_remote_expansion_changed (RavenToCalendarRemote* self,
                                                         GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gboolean is_expanded = FALSE;
	GVariant* _tmp0_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	is_expanded = g_variant_get_boolean (_tmp0_);
	g_variant_unref (_tmp0_);
	g_signal_emit_by_name (self, "expansion-changed", is_expanded);
}

static void
raven_to_calendar_remote_proxy_g_signal (GDBusProxy* proxy,
                                         const gchar* sender_name,
                                         const gchar* signal_name,
                                         GVariant* parameters)
{
	if (strcmp (signal_name, "ExpansionChanged") == 0) {
		_dbus_handle_raven_to_calendar_remote_expansion_changed ((RavenToCalendarRemote*) proxy, parameters);
	}
}

static void
raven_to_calendar_remote_proxy_class_finalize (RavenToCalendarRemoteProxyClass* klass)
{
}

void
raven_to_calendar_remote_proxy_register_dynamic_type (GTypeModule* module)
{
	raven_to_calendar_remote_proxy_register_type (module);
}

static void
raven_to_calendar_remote_proxy_init (RavenToCalendarRemoteProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_raven_to_calendar_remote_dbus_interface_info));
}

static void
raven_to_calendar_remote_proxy_raven_to_calendar_remote_interface_init (RavenToCalendarRemoteIface* iface)
{
}

static void
raven_to_calendar_remote_dbus_interface_method_call (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* method_name,
                                                     GVariant* parameters,
                                                     GDBusMethodInvocation* invocation,
                                                     gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
raven_to_calendar_remote_dbus_interface_get_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GError** error,
                                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
raven_to_calendar_remote_dbus_interface_set_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GVariant* value,
                                                      GError** error,
                                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_raven_to_calendar_remote_expansion_changed (GObject* _sender,
                                                  gboolean is_expanded,
                                                  gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (is_expanded));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.budgie_desktop.Raven", "ExpansionChanged", _arguments, NULL);
}

guint
raven_to_calendar_remote_register_object (gpointer object,
                                          GDBusConnection* connection,
                                          const gchar* path,
                                          GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_raven_to_calendar_remote_dbus_interface_info), &_raven_to_calendar_remote_dbus_interface_vtable, data, _raven_to_calendar_remote_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "expansion-changed", (GCallback) _dbus_raven_to_calendar_remote_expansion_changed, data);
	return result;
}

static void
_raven_to_calendar_remote_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_raven_to_calendar_remote_expansion_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static BudgieRavenWidget*
calendar_raven_plugin_real_new_widget_instance (BudgieRavenPlugin* base,
                                                const gchar* uuid,
                                                GSettings* settings)
{
	CalendarRavenPlugin * self;
	CalendarRavenWidget* _tmp0_;
	BudgieRavenWidget* result;
	self = (CalendarRavenPlugin*) base;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = calendar_raven_widget_new (uuid, settings);
	g_object_ref_sink (_tmp0_);
	result = (BudgieRavenWidget*) _tmp0_;
	return result;
}

static gboolean
calendar_raven_plugin_real_supports_settings (BudgieRavenPlugin* base)
{
	CalendarRavenPlugin * self;
	gboolean result;
	self = (CalendarRavenPlugin*) base;
	result = TRUE;
	return result;
}

CalendarRavenPlugin*
calendar_raven_plugin_construct (GType object_type)
{
	CalendarRavenPlugin * self = NULL;
	self = (CalendarRavenPlugin*) g_object_new (object_type, NULL);
	return self;
}

CalendarRavenPlugin*
calendar_raven_plugin_new (void)
{
	return calendar_raven_plugin_construct (TYPE_CALENDAR_RAVEN_PLUGIN);
}

static void
calendar_raven_plugin_class_init (CalendarRavenPluginClass * klass,
                                  gpointer klass_data)
{
	calendar_raven_plugin_parent_class = g_type_class_peek_parent (klass);
}

static void
calendar_raven_plugin_budgie_raven_plugin_interface_init (BudgieRavenPluginIface * iface,
                                                          gpointer iface_data)
{
	calendar_raven_plugin_budgie_raven_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->new_widget_instance = (BudgieRavenWidget* (*) (BudgieRavenPlugin*, const gchar*, GSettings*)) calendar_raven_plugin_real_new_widget_instance;
	iface->supports_settings = (gboolean (*) (BudgieRavenPlugin*)) calendar_raven_plugin_real_supports_settings;
}

static void
calendar_raven_plugin_instance_init (CalendarRavenPlugin * self,
                                     gpointer klass)
{
}

GType
calendar_raven_plugin_get_type (void)
{
	return calendar_raven_plugin_type_id;
}

GType
calendar_raven_plugin_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (CalendarRavenPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) calendar_raven_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CalendarRavenPlugin), 0, (GInstanceInitFunc) calendar_raven_plugin_instance_init, NULL };
	static const GInterfaceInfo budgie_raven_plugin_info = { (GInterfaceInitFunc) calendar_raven_plugin_budgie_raven_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	calendar_raven_plugin_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "CalendarRavenPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, calendar_raven_plugin_type_id, budgie_raven_plugin_get_type (), &budgie_raven_plugin_info);
	return calendar_raven_plugin_type_id;
}

static inline gpointer
calendar_raven_widget_get_instance_private (CalendarRavenWidget* self)
{
	return G_STRUCT_MEMBER_P (self, CalendarRavenWidget_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda4_ (CalendarRavenWidget* self)
{
	GtkRevealer* _tmp0_;
	GtkRevealer* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GtkImage* image = NULL;
	GtkButton* _tmp4_;
	GtkWidget* _tmp5_;
	GtkImage* _tmp6_;
	GtkRevealer* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	_tmp0_ = self->priv->content_revealer;
	_tmp1_ = self->priv->content_revealer;
	_tmp2_ = gtk_revealer_get_child_revealed (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_revealer_set_reveal_child (_tmp0_, !_tmp3_);
	_tmp4_ = self->priv->header_reveal_button;
	_tmp5_ = gtk_button_get_image (_tmp4_);
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_image_get_type (), GtkImage));
	image = _tmp6_;
	_tmp7_ = self->priv->content_revealer;
	_tmp8_ = gtk_revealer_get_reveal_child (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		GtkImage* _tmp10_;
		_tmp10_ = image;
		gtk_image_set_from_icon_name (_tmp10_, "pan-down-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	} else {
		GtkImage* _tmp11_;
		_tmp11_ = image;
		gtk_image_set_from_icon_name (_tmp11_, "pan-end-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	}
	_g_object_unref0 (image);
}

static void
___lambda4__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
	__lambda4_ ((CalendarRavenWidget*) self);
}

static void
__lambda5_ (CalendarRavenWidget* self)
{
	calendar_raven_widget_update_selection (self);
}

static void
___lambda5__gtk_calendar_month_changed (GtkCalendar* _sender,
                                        gpointer self)
{
	__lambda5_ ((CalendarRavenWidget*) self);
}

static void
_calendar_raven_widget_settings_updated_g_settings_changed (GSettings* _sender,
                                                            const gchar* key,
                                                            gpointer self)
{
	calendar_raven_widget_settings_updated ((CalendarRavenWidget*) self, key);
}

static void
_calendar_raven_widget_on_raven_get_gasync_ready_callback (GObject* source_object,
                                                           GAsyncResult* res,
                                                           gpointer self)
{
	calendar_raven_widget_on_raven_get ((CalendarRavenWidget*) self, source_object, res);
	g_object_unref (self);
}

CalendarRavenWidget*
calendar_raven_widget_construct (GType object_type,
                                 const gchar* uuid,
                                 GSettings* settings)
{
	CalendarRavenWidget * self = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	GtkBox* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkBox* _tmp5_;
	GtkBox* _tmp6_;
	GtkImage* icon = NULL;
	GtkImage* _tmp7_;
	GtkBox* _tmp8_;
	GDateTime* time = NULL;
	GDateTime* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GtkLabel* _tmp12_;
	GtkBox* _tmp13_;
	GtkLabel* _tmp14_;
	GtkBox* _tmp15_;
	GtkBox* _tmp16_;
	GtkStyleContext* _tmp17_;
	GtkRevealer* _tmp18_;
	GtkRevealer* _tmp19_;
	GtkBox* _tmp20_;
	GtkRevealer* _tmp21_;
	GtkBox* _tmp22_;
	GtkRevealer* _tmp23_;
	GtkButton* _tmp24_;
	GtkButton* _tmp25_;
	GtkStyleContext* _tmp26_;
	GtkButton* _tmp27_;
	GtkStyleContext* _tmp28_;
	GtkButton* _tmp29_;
	GtkButton* _tmp30_;
	GtkButton* _tmp31_;
	GtkBox* _tmp32_;
	GtkButton* _tmp33_;
	GtkCalendar* _tmp34_;
	GtkCalendar* _tmp35_;
	GtkStyleContext* _tmp36_;
	GtkBox* _tmp37_;
	GtkCalendar* _tmp38_;
	GtkCalendar* _tmp39_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (uuid != NULL, NULL);
	self = (CalendarRavenWidget*) g_object_new (object_type, NULL);
	budgie_raven_widget_initialize ((BudgieRavenWidget*) self, uuid, settings);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->main_box);
	self->priv->main_box = _tmp0_;
	_tmp1_ = self->priv->main_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp1_);
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->header);
	self->priv->header = _tmp2_;
	_tmp3_ = self->priv->header;
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
	gtk_style_context_add_class (_tmp4_, "raven-header");
	_tmp5_ = self->priv->main_box;
	_tmp6_ = self->priv->header;
	gtk_container_add ((GtkContainer*) _tmp5_, (GtkWidget*) _tmp6_);
	_tmp7_ = (GtkImage*) gtk_image_new_from_icon_name ("x-office-calendar-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp7_);
	icon = _tmp7_;
	g_object_set ((GtkWidget*) icon, "margin", 4, NULL);
	gtk_widget_set_margin_start ((GtkWidget*) icon, 12);
	gtk_widget_set_margin_end ((GtkWidget*) icon, 10);
	_tmp8_ = self->priv->header;
	gtk_container_add ((GtkContainer*) _tmp8_, (GtkWidget*) icon);
	_tmp9_ = g_date_time_new_now_local ();
	time = _tmp9_;
	_tmp10_ = g_date_time_format (time, CALENDAR_RAVEN_WIDGET_date_format);
	_tmp11_ = _tmp10_;
	_tmp12_ = (GtkLabel*) gtk_label_new (_tmp11_);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->header_label);
	self->priv->header_label = _tmp12_;
	_g_free0 (_tmp11_);
	_tmp13_ = self->priv->header;
	_tmp14_ = self->priv->header_label;
	gtk_container_add ((GtkContainer*) _tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->content);
	self->priv->content = _tmp15_;
	_tmp16_ = self->priv->content;
	_tmp17_ = gtk_widget_get_style_context ((GtkWidget*) _tmp16_);
	gtk_style_context_add_class (_tmp17_, "raven-background");
	_tmp18_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->content_revealer);
	self->priv->content_revealer = _tmp18_;
	_tmp19_ = self->priv->content_revealer;
	_tmp20_ = self->priv->content;
	gtk_container_add ((GtkContainer*) _tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = self->priv->content_revealer;
	gtk_revealer_set_reveal_child (_tmp21_, TRUE);
	_tmp22_ = self->priv->main_box;
	_tmp23_ = self->priv->content_revealer;
	gtk_container_add ((GtkContainer*) _tmp22_, (GtkWidget*) _tmp23_);
	_tmp24_ = (GtkButton*) gtk_button_new_from_icon_name ("pan-down-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->header_reveal_button);
	self->priv->header_reveal_button = _tmp24_;
	_tmp25_ = self->priv->header_reveal_button;
	_tmp26_ = gtk_widget_get_style_context ((GtkWidget*) _tmp25_);
	gtk_style_context_add_class (_tmp26_, "flat");
	_tmp27_ = self->priv->header_reveal_button;
	_tmp28_ = gtk_widget_get_style_context ((GtkWidget*) _tmp27_);
	gtk_style_context_add_class (_tmp28_, "expander-button");
	_tmp29_ = self->priv->header_reveal_button;
	g_object_set ((GtkWidget*) _tmp29_, "margin", 4, NULL);
	_tmp30_ = self->priv->header_reveal_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp30_, GTK_ALIGN_CENTER);
	_tmp31_ = self->priv->header_reveal_button;
	g_signal_connect_object (_tmp31_, "clicked", (GCallback) ___lambda4__gtk_button_clicked, self, 0);
	_tmp32_ = self->priv->header;
	_tmp33_ = self->priv->header_reveal_button;
	gtk_box_pack_end (_tmp32_, (GtkWidget*) _tmp33_, FALSE, FALSE, (guint) 0);
	_tmp34_ = (GtkCalendar*) gtk_calendar_new ();
	g_object_ref_sink (_tmp34_);
	_g_object_unref0 (self->priv->cal);
	self->priv->cal = _tmp34_;
	_tmp35_ = self->priv->cal;
	_tmp36_ = gtk_widget_get_style_context ((GtkWidget*) _tmp35_);
	gtk_style_context_add_class (_tmp36_, "raven-calendar");
	_tmp37_ = self->priv->content;
	_tmp38_ = self->priv->cal;
	gtk_container_add ((GtkContainer*) _tmp37_, (GtkWidget*) _tmp38_);
	_tmp39_ = self->priv->cal;
	g_signal_connect_object (_tmp39_, "month-changed", (GCallback) ___lambda5__gtk_calendar_month_changed, self, 0);
	g_signal_connect_object (settings, "changed", (GCallback) _calendar_raven_widget_settings_updated_g_settings_changed, self, 0);
	calendar_raven_widget_settings_updated (self, "show-week-numbers");
	calendar_raven_widget_settings_updated (self, "show-day-names");
	gtk_widget_show_all ((GtkWidget*) self);
	g_async_initable_new_async (TYPE_RAVEN_TO_CALENDAR_REMOTE_PROXY, 0, NULL, _calendar_raven_widget_on_raven_get_gasync_ready_callback, g_object_ref (self), "g-flags", 0, "g-name", RAVEN_DBUS_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", RAVEN_DBUS_OBJECT_PATH, "g-interface-name", "org.budgie_desktop.Raven", NULL);
	_g_date_time_unref0 (time);
	_g_object_unref0 (icon);
	return self;
}

CalendarRavenWidget*
calendar_raven_widget_new (const gchar* uuid,
                           GSettings* settings)
{
	return calendar_raven_widget_construct (TYPE_CALENDAR_RAVEN_WIDGET, uuid, settings);
}

static void
___lambda6_ (CalendarRavenWidget* self,
             gboolean is_expanded)
{
	calendar_raven_widget_on_visibility_changed (self, is_expanded);
}

static void
____lambda6__raven_to_calendar_remote_expansion_changed (RavenToCalendarRemote* _sender,
                                                         gboolean is_expanded,
                                                         gpointer self)
{
	___lambda6_ ((CalendarRavenWidget*) self, is_expanded);
}

static void
calendar_raven_widget_on_raven_get (CalendarRavenWidget* self,
                                    GObject* o,
                                    GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RavenToCalendarRemote* _tmp0_ = NULL;
		RavenToCalendarRemote* _tmp1_;
		RavenToCalendarRemote* _tmp2_;
		RavenToCalendarRemote* _tmp3_;
		RavenToCalendarRemote* _tmp4_;
		_tmp1_ = g_async_result_get_source_object (res);
		_tmp2_ = (RavenToCalendarRemote*) g_async_initable_new_finish ((GAsyncInitable *) _tmp1_, res, &_inner_error0_);
		g_object_unref (_tmp1_);
		_tmp0_ = (RavenToCalendarRemote*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->raven_proxy);
		self->priv->raven_proxy = _tmp3_;
		_tmp4_ = self->priv->raven_proxy;
		g_signal_connect_object (_tmp4_, "expansion-changed", (GCallback) ____lambda6__raven_to_calendar_remote_expansion_changed, self, 0);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("calendar.vala:108: Failed to get Raven proxy: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
calendar_raven_widget_settings_updated (CalendarRavenWidget* self,
                                        const gchar* key)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, "show-week-numbers") == 0) {
		GtkCalendar* _tmp0_;
		GSettings* _tmp1_;
		_tmp0_ = self->priv->cal;
		_tmp1_ = budgie_raven_widget_get_instance_settings ((BudgieRavenWidget*) self);
		g_object_set (_tmp0_, "show-week-numbers", g_settings_get_boolean (_tmp1_, key), NULL);
	} else {
		if (g_strcmp0 (key, "show-day-names") == 0) {
			GtkCalendar* _tmp2_;
			GSettings* _tmp3_;
			_tmp2_ = self->priv->cal;
			_tmp3_ = budgie_raven_widget_get_instance_settings ((BudgieRavenWidget*) self);
			g_object_set (_tmp2_, "show-day-names", g_settings_get_boolean (_tmp3_, key), NULL);
		}
	}
}

static gboolean
calendar_raven_widget_on_visibility_changed (CalendarRavenWidget* self,
                                             gboolean is_expanded)
{
	GDateTime* time = NULL;
	GDateTime* _tmp0_;
	GtkCalendar* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GtkCalendar* _tmp4_;
	GDateTime* _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!is_expanded) {
		result = TRUE;
		return result;
	}
	_tmp0_ = g_date_time_new_now_local ();
	time = _tmp0_;
	_tmp1_ = self->priv->cal;
	_tmp2_ = time;
	_tmp3_ = time;
	gtk_calendar_select_month (_tmp1_, (guint) (g_date_time_get_month (_tmp2_) - 1), (guint) g_date_time_get_year (_tmp3_));
	_tmp4_ = self->priv->cal;
	_tmp5_ = time;
	g_object_set (_tmp4_, "day", g_date_time_get_day_of_month (_tmp5_), NULL);
	result = TRUE;
	_g_date_time_unref0 (time);
	return result;
}

static gboolean
calendar_raven_widget_update_selection (CalendarRavenWidget* self)
{
	GDateTime* time = NULL;
	GDateTime* _tmp0_;
	gchar* strf = NULL;
	GDateTime* _tmp1_;
	gchar* _tmp2_;
	GtkLabel* _tmp3_;
	const gchar* _tmp4_;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	GtkCalendar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GDateTime* _tmp10_;
	GtkCalendar* _tmp16_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_date_time_new_now_local ();
	time = _tmp0_;
	_tmp1_ = time;
	_tmp2_ = g_date_time_format (_tmp1_, CALENDAR_RAVEN_WIDGET_date_format);
	strf = _tmp2_;
	_tmp3_ = self->priv->header_label;
	_tmp4_ = strf;
	gtk_label_set_label (_tmp3_, _tmp4_);
	_tmp7_ = self->priv->cal;
	g_object_get (_tmp7_, "month", &_tmp8_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = time;
	if ((_tmp9_ + 1) == g_date_time_get_month (_tmp10_)) {
		GtkCalendar* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		GDateTime* _tmp14_;
		_tmp11_ = self->priv->cal;
		g_object_get (_tmp11_, "year", &_tmp12_, NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = time;
		_tmp6_ = _tmp13_ == g_date_time_get_year (_tmp14_);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		GDateTime* _tmp15_;
		_tmp15_ = time;
		_tmp5_ = g_date_time_get_day_of_month (_tmp15_);
	} else {
		_tmp5_ = 0;
	}
	_tmp16_ = self->priv->cal;
	g_object_set (_tmp16_, "day", _tmp5_, NULL);
	result = TRUE;
	_g_free0 (strf);
	_g_date_time_unref0 (time);
	return result;
}

static GtkWidget*
calendar_raven_widget_real_build_settings_ui (BudgieRavenWidget* base)
{
	CalendarRavenWidget * self;
	GSettings* _tmp0_;
	CalendarRavenWidgetSettings* _tmp1_;
	GtkWidget* result;
	self = (CalendarRavenWidget*) base;
	_tmp0_ = budgie_raven_widget_get_instance_settings ((BudgieRavenWidget*) self);
	_tmp1_ = calendar_raven_widget_settings_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	result = (GtkWidget*) _tmp1_;
	return result;
}

static void
calendar_raven_widget_class_init (CalendarRavenWidgetClass * klass,
                                  gpointer klass_data)
{
	calendar_raven_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CalendarRavenWidget_private_offset);
	((BudgieRavenWidgetClass *) klass)->build_settings_ui = (GtkWidget* (*) (BudgieRavenWidget*)) calendar_raven_widget_real_build_settings_ui;
	G_OBJECT_CLASS (klass)->finalize = calendar_raven_widget_finalize;
}

static void
calendar_raven_widget_instance_init (CalendarRavenWidget * self,
                                     gpointer klass)
{
	self->priv = calendar_raven_widget_get_instance_private (self);
	self->priv->header = NULL;
	self->priv->header_reveal_button = NULL;
	self->priv->content_revealer = NULL;
	self->priv->content = NULL;
	self->priv->header_label = NULL;
	self->priv->main_box = NULL;
	self->priv->cal = NULL;
	self->priv->raven_proxy = NULL;
}

static void
calendar_raven_widget_finalize (GObject * obj)
{
	CalendarRavenWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CALENDAR_RAVEN_WIDGET, CalendarRavenWidget);
	_g_object_unref0 (self->priv->header);
	_g_object_unref0 (self->priv->header_reveal_button);
	_g_object_unref0 (self->priv->content_revealer);
	_g_object_unref0 (self->priv->content);
	_g_object_unref0 (self->priv->header_label);
	_g_object_unref0 (self->priv->main_box);
	_g_object_unref0 (self->priv->cal);
	_g_object_unref0 (self->priv->raven_proxy);
	G_OBJECT_CLASS (calendar_raven_widget_parent_class)->finalize (obj);
}

GType
calendar_raven_widget_get_type (void)
{
	return calendar_raven_widget_type_id;
}

GType
calendar_raven_widget_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (CalendarRavenWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) calendar_raven_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CalendarRavenWidget), 0, (GInstanceInitFunc) calendar_raven_widget_instance_init, NULL };
	calendar_raven_widget_type_id = g_type_module_register_type (module, budgie_raven_widget_get_type (), "CalendarRavenWidget", &g_define_type_info, 0);
	CalendarRavenWidget_private_offset = sizeof (CalendarRavenWidgetPrivate);
	return calendar_raven_widget_type_id;
}

static inline gpointer
calendar_raven_widget_settings_get_instance_private (CalendarRavenWidgetSettings* self)
{
	return G_STRUCT_MEMBER_P (self, CalendarRavenWidgetSettings_private_offset);
}

CalendarRavenWidgetSettings*
calendar_raven_widget_settings_construct (GType object_type,
                                          GSettings* settings)
{
	CalendarRavenWidgetSettings * self = NULL;
	GtkSwitch* _tmp0_;
	GtkSwitch* _tmp1_;
	self = (CalendarRavenWidgetSettings*) g_object_new (object_type, NULL);
	_tmp0_ = self->priv->switch_show_day_names;
	g_settings_bind (settings, "show-day-names", (GObject*) _tmp0_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp1_ = self->priv->switch_show_week_numbers;
	g_settings_bind (settings, "show-week-numbers", (GObject*) _tmp1_, "active", G_SETTINGS_BIND_DEFAULT);
	return self;
}

CalendarRavenWidgetSettings*
calendar_raven_widget_settings_new (GSettings* settings)
{
	return calendar_raven_widget_settings_construct (TYPE_CALENDAR_RAVEN_WIDGET_SETTINGS, settings);
}

static void
calendar_raven_widget_settings_class_init (CalendarRavenWidgetSettingsClass * klass,
                                           gpointer klass_data)
{
	calendar_raven_widget_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CalendarRavenWidgetSettings_private_offset);
	G_OBJECT_CLASS (klass)->finalize = calendar_raven_widget_settings_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/buddiesofbudgie/budgie-desktop/raven/widget/Calendar/settings.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_show_day_names", FALSE, CalendarRavenWidgetSettings_private_offset + G_STRUCT_OFFSET (CalendarRavenWidgetSettingsPrivate, switch_show_day_names));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_show_week_numbers", FALSE, CalendarRavenWidgetSettings_private_offset + G_STRUCT_OFFSET (CalendarRavenWidgetSettingsPrivate, switch_show_week_numbers));
}

static void
calendar_raven_widget_settings_instance_init (CalendarRavenWidgetSettings * self,
                                              gpointer klass)
{
	self->priv = calendar_raven_widget_settings_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
calendar_raven_widget_settings_finalize (GObject * obj)
{
	CalendarRavenWidgetSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CALENDAR_RAVEN_WIDGET_SETTINGS, CalendarRavenWidgetSettings);
	G_OBJECT_CLASS (calendar_raven_widget_settings_parent_class)->finalize (obj);
}

GType
calendar_raven_widget_settings_get_type (void)
{
	return calendar_raven_widget_settings_type_id;
}

GType
calendar_raven_widget_settings_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (CalendarRavenWidgetSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) calendar_raven_widget_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CalendarRavenWidgetSettings), 0, (GInstanceInitFunc) calendar_raven_widget_settings_instance_init, NULL };
	calendar_raven_widget_settings_type_id = g_type_module_register_type (module, gtk_grid_get_type (), "CalendarRavenWidgetSettings", &g_define_type_info, 0);
	CalendarRavenWidgetSettings_private_offset = sizeof (CalendarRavenWidgetSettingsPrivate);
	return calendar_raven_widget_settings_type_id;
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	calendar_raven_plugin_register_type (module);
	calendar_raven_widget_register_type (module);
	calendar_raven_widget_settings_register_type (module);
	raven_to_calendar_remote_register_type (module);
	raven_to_calendar_remote_proxy_register_dynamic_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, budgie_raven_plugin_get_type (), TYPE_CALENDAR_RAVEN_PLUGIN);
	_g_object_unref0 (objmodule);
}

