// java wrapper for vtkCommunicator object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkCommunicator.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkCommunicator_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkCommunicator",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCommunicator_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCommunicator_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCommunicator_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCommunicator_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCommunicator_SetNumberOfProcesses_14(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfProcesses(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCommunicator_GetNumberOfProcesses_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfProcesses();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCommunicator_GetLocalProcessId_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLocalProcessId();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCommunicator_Send_17(JNIEnv* env, jobject obj,jobject id0,jint id1,jint id2)
{
  vtkDataObject * temp0;
  int   temp1;
  int   temp2;
  int   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Send(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCommunicator_Send_18(JNIEnv* env, jobject obj,jobject id0,jint id1,jint id2)
{
  vtkDataArray * temp0;
  int   temp1;
  int   temp2;
  int   temp20;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Send(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCommunicator_Send_19(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jlong id1,jint id2,jint id3)
{
  char * temp0;
  long long   temp1;
  int   temp2;
  int   temp3;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Send(temp0,temp1,temp2,temp3);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCommunicator_Receive_110(JNIEnv* env, jobject obj,jobject id0,jint id1,jint id2)
{
  vtkDataObject * temp0;
  int   temp1;
  int   temp2;
  int   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Receive(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCommunicator_ReceiveDataObject_111(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  vtkDataObject * temp20;
  temp0 = id0;
  temp1 = id1;

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ReceiveDataObject(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCommunicator_Receive_112(JNIEnv* env, jobject obj,jobject id0,jint id1,jint id2)
{
  vtkDataArray * temp0;
  int   temp1;
  int   temp2;
  int   temp20;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Receive(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCommunicator_Receive_113(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jlong id1,jint id2,jint id3)
{
  char * temp0;
  long long   temp1;
  int   temp2;
  int   temp3;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Receive(temp0,temp1,temp2,temp3);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCommunicator_GetCount_114(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCount();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCommunicator_Barrier_115(JNIEnv* env, jobject obj)
{

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  op->Barrier();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCommunicator_Broadcast_116(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jlong id1,jint id2)
{
  char * temp0;
  long long   temp1;
  int   temp2;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;
  temp2 = id2;

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Broadcast(temp0,temp1,temp2);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCommunicator_Broadcast_117(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkDataObject * temp0;
  int   temp1;
  int   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Broadcast(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCommunicator_Broadcast_118(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkDataArray * temp0;
  int   temp1;
  int   temp20;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Broadcast(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCommunicator_Gather_119(JNIEnv* env, jobject obj, jbyteArray id0, jint len0, jbyteArray id1, jint len1,jlong id2,jint id3)
{
  char * temp0;
  char * temp1;
  long long   temp2;
  int   temp3;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);
  temp2 = id2;
  temp3 = id3;

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Gather(temp0,temp1,temp2,temp3);
  delete[] temp0;
  delete[] temp1;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCommunicator_Gather_120(JNIEnv* env, jobject obj,jobject id0,jobject id1,jint id2)
{
  vtkDataArray * temp0;
  vtkDataArray * temp1;
  int   temp2;
  int   temp20;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Gather(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCommunicator_GatherV_121(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2,jobject id3,jint id4)
{
  vtkDataArray * temp0;
  vtkDataArray * temp1;
  vtkIdTypeArray * temp2;
  vtkIdTypeArray * temp3;
  int   temp4;
  int   temp20;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = id4;

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GatherV(temp0,temp1,temp2,temp3,temp4);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCommunicator_GatherV_122(JNIEnv* env, jobject obj,jobject id0,jobject id1,jint id2)
{
  vtkDataArray * temp0;
  vtkDataArray * temp1;
  int   temp2;
  int   temp20;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GatherV(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCommunicator_Scatter_123(JNIEnv* env, jobject obj, jbyteArray id0, jint len0, jbyteArray id1, jint len1,jlong id2,jint id3)
{
  char * temp0;
  char * temp1;
  long long   temp2;
  int   temp3;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);
  temp2 = id2;
  temp3 = id3;

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Scatter(temp0,temp1,temp2,temp3);
  delete[] temp0;
  delete[] temp1;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCommunicator_Scatter_124(JNIEnv* env, jobject obj,jobject id0,jobject id1,jint id2)
{
  vtkDataArray * temp0;
  vtkDataArray * temp1;
  int   temp2;
  int   temp20;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Scatter(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCommunicator_AllGather_125(JNIEnv* env, jobject obj, jbyteArray id0, jint len0, jbyteArray id1, jint len1,jlong id2)
{
  char * temp0;
  char * temp1;
  long long   temp2;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);
  temp2 = id2;

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AllGather(temp0,temp1,temp2);
  delete[] temp0;
  delete[] temp1;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCommunicator_AllGather_126(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkDataArray * temp0;
  vtkDataArray * temp1;
  int   temp20;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AllGather(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCommunicator_AllGatherV_127(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkDataArray * temp0;
  vtkDataArray * temp1;
  int   temp20;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AllGatherV(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCommunicator_Reduce_128(JNIEnv* env, jobject obj, jbyteArray id0, jint len0, jbyteArray id1, jint len1,jlong id2,jint id3,jint id4)
{
  char * temp0;
  char * temp1;
  long long   temp2;
  int   temp3;
  int   temp4;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Reduce(temp0,temp1,temp2,temp3,temp4);
  delete[] temp0;
  delete[] temp1;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCommunicator_Reduce_129(JNIEnv* env, jobject obj,jobject id0,jobject id1,jint id2,jint id3)
{
  vtkDataArray * temp0;
  vtkDataArray * temp1;
  int   temp2;
  int   temp3;
  int   temp20;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;
  temp3 = id3;

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Reduce(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCommunicator_AllReduce_130(JNIEnv* env, jobject obj, jbyteArray id0, jint len0, jbyteArray id1, jint len1,jlong id2,jint id3)
{
  char * temp0;
  char * temp1;
  long long   temp2;
  int   temp3;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);
  temp2 = id2;
  temp3 = id3;

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AllReduce(temp0,temp1,temp2,temp3);
  delete[] temp0;
  delete[] temp1;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCommunicator_AllReduce_131(JNIEnv* env, jobject obj,jobject id0,jobject id1,jint id2)
{
  vtkDataArray * temp0;
  vtkDataArray * temp1;
  int   temp2;
  int   temp20;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AllReduce(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCommunicator_CanProbe_132(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CanProbe();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCommunicator_SetUseCopy_133(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseCopy(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCommunicator_GetParentProcessor_134(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetParentProcessor(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCommunicator_GetLeftChildProcessor_135(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLeftChildProcessor(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCommunicator_MarshalDataObject_136(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkDataObject * temp0;
  vtkCharArray * temp1;
  int   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkCharArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->MarshalDataObject(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCommunicator_UnMarshalDataObject_137(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkCharArray * temp0;
  vtkDataObject * temp1;
  int   temp20;
  temp0 = static_cast<vtkCharArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id1));

  vtkCommunicator* op = static_cast<vtkCommunicator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->UnMarshalDataObject(temp0,temp1);
  return temp20;

}
