// java wrapper for vtkGlyph3D object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkGlyph3D.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPolyDataAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkGlyph3D_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkGlyph3D",dType)) { return me; }
  if ((res= vtkPolyDataAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGlyph3D_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGlyph3D_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGlyph3D_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGlyph3D_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_SetSourceData_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPolyData * temp0;
  temp0 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSourceData(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_SetSourceData_15(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkPolyData * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id1));

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSourceData(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_SetSourceConnection_16(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkAlgorithmOutput * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id1));

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSourceConnection(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_SetSourceConnection_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAlgorithmOutput * temp0;
  temp0 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSourceConnection(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGlyph3D_GetSource_18(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkPolyData * temp20;
  temp0 = id0;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSource(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_SetScaling_19(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScaling(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_ScalingOn_110(JNIEnv* env, jobject obj)
{

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ScalingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_ScalingOff_111(JNIEnv* env, jobject obj)
{

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ScalingOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGlyph3D_GetScaling_112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScaling();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_SetScaleMode_113(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScaleMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGlyph3D_GetScaleMode_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScaleMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_SetScaleModeToScaleByScalar_115(JNIEnv* env, jobject obj)
{

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScaleModeToScaleByScalar();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_SetScaleModeToScaleByVector_116(JNIEnv* env, jobject obj)
{

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScaleModeToScaleByVector();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_SetScaleModeToScaleByVectorComponents_117(JNIEnv* env, jobject obj)
{

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScaleModeToScaleByVectorComponents();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_SetScaleModeToDataScalingOff_118(JNIEnv* env, jobject obj)
{

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScaleModeToDataScalingOff();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkGlyph3D_GetScaleModeAsString_119(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScaleModeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_SetColorMode_120(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGlyph3D_GetColorMode_121(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_SetColorModeToColorByScale_122(JNIEnv* env, jobject obj)
{

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorModeToColorByScale();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_SetColorModeToColorByScalar_123(JNIEnv* env, jobject obj)
{

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorModeToColorByScalar();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_SetColorModeToColorByVector_124(JNIEnv* env, jobject obj)
{

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorModeToColorByVector();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkGlyph3D_GetColorModeAsString_125(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorModeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_SetScaleFactor_126(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScaleFactor(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkGlyph3D_GetScaleFactor_127(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScaleFactor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_SetRange_128(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRange(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_SetRange_129(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRange(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkGlyph3D_GetRange_130(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRange();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_SetOrient_131(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrient(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_OrientOn_132(JNIEnv* env, jobject obj)
{

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->OrientOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_OrientOff_133(JNIEnv* env, jobject obj)
{

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->OrientOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGlyph3D_GetOrient_134(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrient();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_SetClamping_135(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetClamping(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_ClampingOn_136(JNIEnv* env, jobject obj)
{

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClampingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_ClampingOff_137(JNIEnv* env, jobject obj)
{

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClampingOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGlyph3D_GetClamping_138(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetClamping();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_SetVectorMode_139(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVectorMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGlyph3D_GetVectorMode_140(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVectorMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_SetVectorModeToUseVector_141(JNIEnv* env, jobject obj)
{

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVectorModeToUseVector();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_SetVectorModeToUseNormal_142(JNIEnv* env, jobject obj)
{

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVectorModeToUseNormal();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_SetVectorModeToVectorRotationOff_143(JNIEnv* env, jobject obj)
{

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVectorModeToVectorRotationOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_SetVectorModeToFollowCameraDirection_144(JNIEnv* env, jobject obj)
{

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVectorModeToFollowCameraDirection();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkGlyph3D_GetVectorModeAsString_145(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVectorModeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkGlyph3D_GetFollowedCameraPosition_146(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFollowedCameraPosition();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkGlyph3D_GetFollowedCameraViewUp_147(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFollowedCameraViewUp();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_SetIndexMode_148(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIndexMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGlyph3D_GetIndexMode_149(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIndexMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_SetIndexModeToScalar_150(JNIEnv* env, jobject obj)
{

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIndexModeToScalar();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_SetIndexModeToVector_151(JNIEnv* env, jobject obj)
{

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIndexModeToVector();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_SetIndexModeToOff_152(JNIEnv* env, jobject obj)
{

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIndexModeToOff();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkGlyph3D_GetIndexModeAsString_153(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIndexModeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_SetGeneratePointIds_154(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGeneratePointIds(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGlyph3D_GetGeneratePointIds_155(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGeneratePointIds();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_GeneratePointIdsOn_156(JNIEnv* env, jobject obj)
{

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GeneratePointIdsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_GeneratePointIdsOff_157(JNIEnv* env, jobject obj)
{

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GeneratePointIdsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_SetPointIdsName_158(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPointIdsName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkGlyph3D_GetPointIdsName_159(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointIdsName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_SetFillCellData_160(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFillCellData(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGlyph3D_GetFillCellData_161(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFillCellData();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_FillCellDataOn_162(JNIEnv* env, jobject obj)
{

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->FillCellDataOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_FillCellDataOff_163(JNIEnv* env, jobject obj)
{

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->FillCellDataOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGlyph3D_IsPointVisible_164(JNIEnv* env, jobject obj,jobject id0,jlong id1)
{
  vtkDataSet * temp0;
  long long   temp1;
  int   temp20;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsPointVisible(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_SetSourceTransform_165(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTransform * temp0;
  temp0 = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSourceTransform(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGlyph3D_GetSourceTransform_166(JNIEnv* env, jobject obj)
{
  vtkTransform * temp20;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSourceTransform();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGlyph3D_GetMTime_167(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGlyph3D_SetOutputPointsPrecision_168(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputPointsPrecision(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGlyph3D_GetOutputPointsPrecision_169(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGlyph3D* op = static_cast<vtkGlyph3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputPointsPrecision();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkGlyph3D_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkGlyph3D::New());
}
