// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "Basis_HGrad_PyrF2Gradient.h"

const char *Basis_HGrad_PyrF2Gradient =
"const RealT HALF = 0.5;\n"
"const RealT ONE = 1.;\n"
"const RealT ZERO = 0.;\n"
"const RealT TWO = 2.;\n"
"const RealT THREE = 3.;\n"
"const RealT FOUR = 4.;\n"
"const RealT SIXTEENTHIRDS = 16. / 3.;\n"
"const RealT EIGHT = 8.;\n"
"const RealT TWENTYSEVEN = 27.;\n"
"const RealT FOURTH = 0.25;\n"
"const RealT NINTH = 1. / 9.;\n"
"const RealT THREESIXTYFOURTHS = 3. / 64.;\n"
"const RealT EIGHTH = 1. / 8.;\n"
"const RealT FOURNINTHS = 4. / 9.;\n"
"const RealT THREESIXTEENTHS = 3. / 16.;\n"
"const RealT NINESIXTEENTHS = 9. / 16.;\n"
"\n"
"const RealT K1 = -0.25;\n"
"const RealT K5 = ONE;\n"
"const RealT K6 = -HALF;\n"
"const RealT K10 = -ONE;\n"
"const RealT K14 = ONE;\n"
"const RealT K15A = TWENTYSEVEN / EIGHT;\n"
"const RealT K15B = -TWENTYSEVEN / EIGHT;\n"
"const RealT K19 = -SIXTEENTHIRDS;\n"
"\n"
"RealT r2 = rr * rr;\n"
"RealT s2 = ss * ss;\n"
"RealT t2 = tt * tt;\n"
"RealT rs = rr * ss;\n"
"RealT rt = rr * tt;\n"
"RealT st = ss * tt;\n"
"RealT r2s = r2 * ss;\n"
"RealT rs2 = rr * s2;\n"
"RealT r2s2 = r2 * s2;\n"
"\n"
"RealT tm = tt - ONE;\n"
"RealT tm2 = tm * tm;\n"
"RealT tm3 = tm2 * tm;\n"
"RealT tm4 = tm3 * tm;\n"
"\n"
"// Be sure that the basis functions are defined when tt is very close to 1.\n"
"RealT mt = abs(tm) > eps ? ONE / tm : ZERO;\n"
"RealT m2t = abs(tm2) > eps ? ONE / tm2 : ZERO;\n"
"RealT m3t = abs(tm3) > eps ? ONE / tm3 : ZERO;\n"
"RealT m4t = abs(tm4) > eps ? ONE / tm4 : ZERO;\n"
"\n"
"basisGradient[0] = K1 * (rs * mt - rr - ss + tt + (ss * mt - ONE) * (rr + ss - ONE) - ONE);\n"
"basisGradient[1] = K1 * (rs * mt - rr - ss + tt + (rr * mt - ONE) * (rr + ss - ONE) - ONE);\n"
"basisGradient[2] = K1 * (-rs * m2t + ONE) * (rr + ss - ONE);\n"
"\n"
"basisGradient[3] = K1 * (rs * mt - rr + ss - tt + (-ss * mt + ONE) * (-rr + ss - ONE) + ONE);\n"
"basisGradient[4] = K1 * (-rs * mt + rr - ss + tt + (-rr * mt - ONE) * (-rr + ss - ONE) - ONE);\n"
"basisGradient[5] = K1 * (rs * m2t + ONE) * (-rr + ss - ONE);\n"
"\n"
"basisGradient[6] = K1 * (-rs * mt - rr - ss - tt + (ss * mt + ONE) * (-rr - ss - ONE) + ONE);\n"
"basisGradient[7] = K1 * (-rs * mt - rr - ss - tt + (rr * mt + ONE) * (-rr - ss - ONE) + ONE);\n"
"basisGradient[8] = K1 * (-rs * m2t + ONE) * (-rr - ss - ONE);\n"
"\n"
"basisGradient[9] = K1 * (-rs * mt - rr + ss + tt + (-ss * mt - ONE) * (rr - ss - ONE) - ONE);\n"
"basisGradient[10] = K1 * (rs * mt + rr - ss - tt + (-rr * mt + ONE) * (rr - ss - ONE) + ONE);\n"
"basisGradient[11] = K1 * (rs * m2t + ONE) * (rr - ss - ONE);\n"
"\n"
"basisGradient[12] = ZERO;\n"
"basisGradient[13] = ZERO;\n"
"basisGradient[14] = K5 * (FOUR * tt - ONE);\n"
"\n"
"basisGradient[15] = K6 * (-TWO * rs * mt + TWO * rr);\n"
"basisGradient[16] = K6 * (-r2 * mt + tt - ONE);\n"
"basisGradient[17] = K6 * (r2s * m2t + ss - TWO * tt + TWO);\n"
"\n"
"basisGradient[18] = K6 * (s2 * mt - tt + ONE);\n"
"basisGradient[19] = K6 * (TWO * rs * mt + TWO * ss);\n"
"basisGradient[20] = K6 * (-rs2 * m2t - rr - TWO * tt + TWO);\n"
"\n"
"basisGradient[21] = K6 * (TWO * rs * mt + TWO * rr);\n"
"basisGradient[22] = K6 * (r2 * mt - tt + ONE);\n"
"basisGradient[23] = K6 * (-r2s * m2t - ss - TWO * tt + TWO);\n"
"\n"
"basisGradient[24] = K6 * (-s2 * mt + tt - ONE);\n"
"basisGradient[25] = K6 * (-TWO * rs * mt + TWO * ss);\n"
"basisGradient[26] = K6 * (rs2 * m2t + rr - TWO * tt + TWO);\n"
"\n"
"basisGradient[27] = K10 * (ss + ss * mt - tt);\n"
"basisGradient[28] = K10 * (rr + rr * mt - tt);\n"
"basisGradient[29] = K10 * (-rs * m2t - rr - ss + TWO * tt - ONE);\n"
"\n"
"basisGradient[30] = K10 * (-ss - ss * mt + tt);\n"
"basisGradient[31] = K10 * (-rr - rr * mt - tt);\n"
"basisGradient[32] = K10 * (rs * m2t + rr - ss + TWO * tt - ONE);\n"
"\n"
"basisGradient[33] = K10 * (ss + ss * mt + tt);\n"
"basisGradient[34] = K10 * (rr + rr * mt + tt);\n"
"basisGradient[35] = K10 * (-rs * m2t + rr + ss + TWO * tt - ONE);\n"
"\n"
"basisGradient[36] = K10 * (-ss - ss * mt - tt);\n"
"basisGradient[37] = K10 * (-rr - rr * mt + tt);\n"
"basisGradient[38] = K10 * (rs * m2t - rr + ss + TWO * tt - ONE);\n"
"\n"
"basisGradient[39] = K14 * (TWO * rs2 * m2t - TWO * rr);\n"
"basisGradient[40] = K14 * (TWO * r2s * m2t - TWO * ss);\n"
"basisGradient[41] = K14 * (-TWO * r2s2 * m3t + TWO * tt - TWO);\n"
"\n"
"basisGradient[42] = K15A * (TWO * rs + TWO * rs * mt - TWO * rs2 * mt - TWO * rs2 * m2t);\n"
"basisGradient[43] = K15A * (-TWO * r2s * mt - TWO * r2s * m2t + r2 + r2 * mt + TWO * st + tt - t2);\n"
"basisGradient[44] =\n"
"  K15A * (-r2s * m2t - r2s2 * (-TWO * tt + TWO) * m4t + r2s2 * m2t - TWO * st + ss + s2);\n"
"\n"
"basisGradient[45] = K15B * (TWO * rs2 * mt + TWO * rs2 * m2t - TWO * rt + s2 + s2 * mt + tt - t2);\n"
"basisGradient[46] = K15B * (TWO * rs + TWO * rs * mt + TWO * r2s * mt + TWO * r2s * m2t);\n"
"basisGradient[47] =\n"
"  K15B * (-rs2 * m2t - TWO * rt + rr + r2s2 * (-TWO * tt + TWO) * m4t - r2s2 * m2t - r2);\n"
"\n"
"basisGradient[48] = K15B * (TWO * rs + TWO * rs * mt + TWO * rs2 * mt + TWO * rs2 * m2t);\n"
"basisGradient[49] = K15B * (TWO * r2s * mt + TWO * r2s * m2t + r2 + r2 * mt - TWO * st + tt - t2);\n"
"basisGradient[50] =\n"
"  K15B * (-r2s * m2t + r2s2 * (-TWO * tt + TWO) * m4t - r2s2 * m2t - TWO * st + ss - s2);\n"
"\n"
"basisGradient[51] = K15A * (-TWO * rs2 * mt - TWO * rs2 * m2t + TWO * rt + s2 + s2 * mt + tt - t2);\n"
"basisGradient[52] = K15A * (TWO * rs + TWO * rs * mt - TWO * r2s * mt - TWO * r2s * m2t);\n"
"basisGradient[53] =\n"
"  K15A * (-rs2 * m2t - TWO * rt + rr - r2s2 * (-TWO * tt + TWO) * m4t + r2s2 * m2t + r2);\n"
"\n"
"basisGradient[54] = K19 * (TWO * rs2 * m2t + TWO * rs2 * m3t - TWO * rr - TWO * rr * mt);\n"
"basisGradient[55] = K19 * (TWO * r2s * m2t + TWO * r2s * m3t - TWO * ss - TWO * ss * mt);\n"
"basisGradient[56] =\n"
"  K19 * (-TWO * r2s2 * m3t - THREE * r2s2 * m4t + r2 * m2t + s2 * m2t + TWO * tt - ONE);\n"
"\n"
"// MODIFICATIONS TO d/dr(basis)\n"
"\n"
"basisGradient[0] = basisGradient[0] + basisGradient[39] * FOURTH +\n"
"  basisGradient[54] * THREESIXTYFOURTHS + NINTH * (basisGradient[42] + basisGradient[51]);\n"
"basisGradient[3] = basisGradient[3] + basisGradient[39] * FOURTH +\n"
"  basisGradient[54] * THREESIXTYFOURTHS + NINTH * (basisGradient[42] + basisGradient[45]);\n"
"basisGradient[6] = basisGradient[6] + basisGradient[39] * FOURTH +\n"
"  basisGradient[54] * THREESIXTYFOURTHS + NINTH * (basisGradient[45] + basisGradient[48]);\n"
"basisGradient[9] = basisGradient[9] + basisGradient[39] * FOURTH +\n"
"  basisGradient[54] * THREESIXTYFOURTHS + NINTH * (basisGradient[48] + basisGradient[51]);\n"
"basisGradient[12] = basisGradient[12] + basisGradient[54] * EIGHTH +\n"
"  NINTH * (basisGradient[42] + basisGradient[45] + basisGradient[48] + basisGradient[51]);\n"
"basisGradient[15] = basisGradient[15] - basisGradient[39] * HALF - basisGradient[42] * FOURNINTHS;\n"
"basisGradient[18] = basisGradient[18] - basisGradient[39] * HALF - basisGradient[45] * FOURNINTHS;\n"
"basisGradient[21] = basisGradient[21] - basisGradient[39] * HALF - basisGradient[48] * FOURNINTHS;\n"
"basisGradient[24] = basisGradient[24] - basisGradient[39] * HALF - basisGradient[51] * FOURNINTHS;\n"
"basisGradient[27] = basisGradient[27] - basisGradient[54] * THREESIXTEENTHS +\n"
"  FOURNINTHS * (-basisGradient[42] - basisGradient[51]);\n"
"basisGradient[30] = basisGradient[30] - basisGradient[54] * THREESIXTEENTHS +\n"
"  FOURNINTHS * (-basisGradient[42] - basisGradient[45]);\n"
"basisGradient[33] = basisGradient[33] - basisGradient[54] * THREESIXTEENTHS +\n"
"  FOURNINTHS * (-basisGradient[45] - basisGradient[48]);\n"
"basisGradient[36] = basisGradient[36] - basisGradient[54] * THREESIXTEENTHS +\n"
"  FOURNINTHS * (-basisGradient[48] - basisGradient[51]);\n"
"basisGradient[39] = basisGradient[39] - basisGradient[54] * NINESIXTEENTHS;\n"
"\n"
"// MODIFICATIONS TO d/ds(basis)\n"
"\n"
"basisGradient[1] = basisGradient[1] + basisGradient[40] * FOURTH +\n"
"  basisGradient[55] * THREESIXTYFOURTHS + NINTH * (basisGradient[43] + basisGradient[52]);\n"
"basisGradient[4] = basisGradient[4] + basisGradient[40] * FOURTH +\n"
"  basisGradient[55] * THREESIXTYFOURTHS + NINTH * (basisGradient[43] + basisGradient[46]);\n"
"basisGradient[7] = basisGradient[7] + basisGradient[40] * FOURTH +\n"
"  basisGradient[55] * THREESIXTYFOURTHS + NINTH * (basisGradient[46] + basisGradient[49]);\n"
"basisGradient[10] = basisGradient[10] + basisGradient[40] * FOURTH +\n"
"  basisGradient[55] * THREESIXTYFOURTHS + NINTH * (basisGradient[49] + basisGradient[52]);\n"
"basisGradient[13] = basisGradient[13] + basisGradient[55] * EIGHTH +\n"
"  NINTH * (basisGradient[43] + basisGradient[46] + basisGradient[49] + basisGradient[52]);\n"
"basisGradient[16] = basisGradient[16] - basisGradient[40] * HALF - basisGradient[43] * FOURNINTHS;\n"
"basisGradient[19] = basisGradient[19] - basisGradient[40] * HALF - basisGradient[46] * FOURNINTHS;\n"
"basisGradient[22] = basisGradient[22] - basisGradient[40] * HALF - basisGradient[49] * FOURNINTHS;\n"
"basisGradient[25] = basisGradient[25] - basisGradient[40] * HALF - basisGradient[52] * FOURNINTHS;\n"
"basisGradient[28] = basisGradient[28] - basisGradient[55] * THREESIXTEENTHS +\n"
"  FOURNINTHS * (-basisGradient[43] - basisGradient[52]);\n"
"basisGradient[31] = basisGradient[31] - basisGradient[55] * THREESIXTEENTHS +\n"
"  FOURNINTHS * (-basisGradient[43] - basisGradient[46]);\n"
"basisGradient[34] = basisGradient[34] - basisGradient[55] * THREESIXTEENTHS +\n"
"  FOURNINTHS * (-basisGradient[46] - basisGradient[49]);\n"
"basisGradient[37] = basisGradient[37] - basisGradient[55] * THREESIXTEENTHS +\n"
"  FOURNINTHS * (-basisGradient[49] - basisGradient[52]);\n"
"basisGradient[40] = basisGradient[40] - basisGradient[55] * NINESIXTEENTHS;\n"
"\n"
"// MODIFICATIONS TO d/dt(basis)\n"
"\n"
"basisGradient[2] = basisGradient[2] + basisGradient[41] * FOURTH +\n"
"  basisGradient[56] * THREESIXTYFOURTHS + NINTH * (basisGradient[44] + basisGradient[53]);\n"
"basisGradient[5] = basisGradient[5] + basisGradient[41] * FOURTH +\n"
"  basisGradient[56] * THREESIXTYFOURTHS + NINTH * (basisGradient[44] + basisGradient[47]);\n"
"basisGradient[8] = basisGradient[8] + basisGradient[41] * FOURTH +\n"
"  basisGradient[56] * THREESIXTYFOURTHS + NINTH * (basisGradient[47] + basisGradient[50]);\n"
"basisGradient[11] = basisGradient[11] + basisGradient[41] * FOURTH +\n"
"  basisGradient[56] * THREESIXTYFOURTHS + NINTH * (basisGradient[50] + basisGradient[53]);\n"
"basisGradient[14] = basisGradient[14] + basisGradient[56] * EIGHTH +\n"
"  NINTH * (basisGradient[44] + basisGradient[47] + basisGradient[50] + basisGradient[53]);\n"
"basisGradient[17] = basisGradient[17] - basisGradient[41] * HALF - basisGradient[44] * FOURNINTHS;\n"
"basisGradient[20] = basisGradient[20] - basisGradient[41] * HALF - basisGradient[47] * FOURNINTHS;\n"
"basisGradient[23] = basisGradient[23] - basisGradient[41] * HALF - basisGradient[50] * FOURNINTHS;\n"
"basisGradient[26] = basisGradient[26] - basisGradient[41] * HALF - basisGradient[53] * FOURNINTHS;\n"
"basisGradient[29] = basisGradient[29] - basisGradient[56] * THREESIXTEENTHS +\n"
"  FOURNINTHS * (-basisGradient[44] - basisGradient[53]);\n"
"basisGradient[32] = basisGradient[32] - basisGradient[56] * THREESIXTEENTHS +\n"
"  FOURNINTHS * (-basisGradient[44] - basisGradient[47]);\n"
"basisGradient[35] = basisGradient[35] - basisGradient[56] * THREESIXTEENTHS +\n"
"  FOURNINTHS * (-basisGradient[47] - basisGradient[50]);\n"
"basisGradient[38] = basisGradient[38] - basisGradient[56] * THREESIXTEENTHS +\n"
"  FOURNINTHS * (-basisGradient[50] - basisGradient[53]);\n"
"basisGradient[41] = basisGradient[41] - basisGradient[56] * NINESIXTEENTHS;\n"
"";
