// python wrapper for vtkCPXMLPWriterPipeline
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkCPXMLPWriterPipeline.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkCPXMLPWriterPipeline(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkCPXMLPWriterPipeline_ClassNew(); }

#ifndef DECLARED_PyvtkCPPipeline_ClassNew
extern "C" { PyObject *PyvtkCPPipeline_ClassNew(); }
#define DECLARED_PyvtkCPPipeline_ClassNew
#endif

static PyObject *
PyvtkCPXMLPWriterPipeline_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkCPXMLPWriterPipeline::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPXMLPWriterPipeline_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPXMLPWriterPipeline *op = static_cast<vtkCPXMLPWriterPipeline *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkCPXMLPWriterPipeline::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPXMLPWriterPipeline_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkCPXMLPWriterPipeline *tempr = vtkCPXMLPWriterPipeline::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPXMLPWriterPipeline_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPXMLPWriterPipeline *op = static_cast<vtkCPXMLPWriterPipeline *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkCPXMLPWriterPipeline *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkCPXMLPWriterPipeline::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPXMLPWriterPipeline_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkCPXMLPWriterPipeline::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPXMLPWriterPipeline_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPXMLPWriterPipeline *op = static_cast<vtkCPXMLPWriterPipeline *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkCPXMLPWriterPipeline::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPXMLPWriterPipeline_RequestDataDescription(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RequestDataDescription");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPXMLPWriterPipeline *op = static_cast<vtkCPXMLPWriterPipeline *>(vp);

  vtkCPDataDescription *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkCPDataDescription"))
  {
    int tempr = (ap.IsBound() ?
      op->RequestDataDescription(temp0) :
      op->vtkCPXMLPWriterPipeline::RequestDataDescription(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPXMLPWriterPipeline_CoProcess(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CoProcess");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPXMLPWriterPipeline *op = static_cast<vtkCPXMLPWriterPipeline *>(vp);

  vtkCPDataDescription *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkCPDataDescription"))
  {
    int tempr = (ap.IsBound() ?
      op->CoProcess(temp0) :
      op->vtkCPXMLPWriterPipeline::CoProcess(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPXMLPWriterPipeline_SetOutputFrequency(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutputFrequency");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPXMLPWriterPipeline *op = static_cast<vtkCPXMLPWriterPipeline *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOutputFrequency(temp0);
    }
    else
    {
      op->vtkCPXMLPWriterPipeline::SetOutputFrequency(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCPXMLPWriterPipeline_GetOutputFrequencyMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOutputFrequencyMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPXMLPWriterPipeline *op = static_cast<vtkCPXMLPWriterPipeline *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetOutputFrequencyMinValue() :
      op->vtkCPXMLPWriterPipeline::GetOutputFrequencyMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPXMLPWriterPipeline_GetOutputFrequencyMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOutputFrequencyMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPXMLPWriterPipeline *op = static_cast<vtkCPXMLPWriterPipeline *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetOutputFrequencyMaxValue() :
      op->vtkCPXMLPWriterPipeline::GetOutputFrequencyMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPXMLPWriterPipeline_GetOutputFrequency(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOutputFrequency");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPXMLPWriterPipeline *op = static_cast<vtkCPXMLPWriterPipeline *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetOutputFrequency() :
      op->vtkCPXMLPWriterPipeline::GetOutputFrequency());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPXMLPWriterPipeline_SetPaddingAmount(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPaddingAmount");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPXMLPWriterPipeline *op = static_cast<vtkCPXMLPWriterPipeline *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPaddingAmount(temp0);
    }
    else
    {
      op->vtkCPXMLPWriterPipeline::SetPaddingAmount(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCPXMLPWriterPipeline_GetPaddingAmountMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPaddingAmountMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPXMLPWriterPipeline *op = static_cast<vtkCPXMLPWriterPipeline *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPaddingAmountMinValue() :
      op->vtkCPXMLPWriterPipeline::GetPaddingAmountMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPXMLPWriterPipeline_GetPaddingAmountMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPaddingAmountMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPXMLPWriterPipeline *op = static_cast<vtkCPXMLPWriterPipeline *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPaddingAmountMaxValue() :
      op->vtkCPXMLPWriterPipeline::GetPaddingAmountMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPXMLPWriterPipeline_GetPaddingAmount(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPaddingAmount");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPXMLPWriterPipeline *op = static_cast<vtkCPXMLPWriterPipeline *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPaddingAmount() :
      op->vtkCPXMLPWriterPipeline::GetPaddingAmount());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPXMLPWriterPipeline_SetPath(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPath");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPXMLPWriterPipeline *op = static_cast<vtkCPXMLPWriterPipeline *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPath(temp0);
    }
    else
    {
      op->vtkCPXMLPWriterPipeline::SetPath(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCPXMLPWriterPipeline_GetPath(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPath");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPXMLPWriterPipeline *op = static_cast<vtkCPXMLPWriterPipeline *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetPath() :
      op->vtkCPXMLPWriterPipeline::GetPath());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkCPXMLPWriterPipeline_Methods[] = {
  {"IsTypeOf", PyvtkCPXMLPWriterPipeline_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkCPXMLPWriterPipeline_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkCPXMLPWriterPipeline_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkCPXMLPWriterPipeline\nC++: static vtkCPXMLPWriterPipeline *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkCPXMLPWriterPipeline_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkCPXMLPWriterPipeline\nC++: vtkCPXMLPWriterPipeline *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkCPXMLPWriterPipeline_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkCPXMLPWriterPipeline_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"RequestDataDescription", PyvtkCPXMLPWriterPipeline_RequestDataDescription, METH_VARARGS,
   "RequestDataDescription(self, dataDescription:vtkCPDataDescription)\n     -> int\nC++: int RequestDataDescription(\n    vtkCPDataDescription *dataDescription) override;\n\nConfiguration Step: The coprocessor first determines if any\ncoprocessing needs to be done at this TimeStep/Time combination\nreturning 1 if it does and 0 otherwise.  If coprocessing does\nneed to be performed this time step it fills in the FieldNames\narray that the coprocessor requires in order to fulfill all the\ncoprocessing requests for this TimeStep/Time combination.\n"},
  {"CoProcess", PyvtkCPXMLPWriterPipeline_CoProcess, METH_VARARGS,
   "CoProcess(self, dataDescription:vtkCPDataDescription) -> int\nC++: int CoProcess(vtkCPDataDescription *dataDescription)\n    override;\n\nExecute the pipeline. Returns 1 for success and 0 for failure.\n"},
  {"SetOutputFrequency", PyvtkCPXMLPWriterPipeline_SetOutputFrequency, METH_VARARGS,
   "SetOutputFrequency(self, _arg:int) -> None\nC++: virtual void SetOutputFrequency(int _arg)\n\nSet the output frequency for this pipeline. The default is 1.\n"},
  {"GetOutputFrequencyMinValue", PyvtkCPXMLPWriterPipeline_GetOutputFrequencyMinValue, METH_VARARGS,
   "GetOutputFrequencyMinValue(self) -> int\nC++: virtual int GetOutputFrequencyMinValue()\n\n"},
  {"GetOutputFrequencyMaxValue", PyvtkCPXMLPWriterPipeline_GetOutputFrequencyMaxValue, METH_VARARGS,
   "GetOutputFrequencyMaxValue(self) -> int\nC++: virtual int GetOutputFrequencyMaxValue()\n\n"},
  {"GetOutputFrequency", PyvtkCPXMLPWriterPipeline_GetOutputFrequency, METH_VARARGS,
   "GetOutputFrequency(self) -> int\nC++: virtual int GetOutputFrequency()\n\n"},
  {"SetPaddingAmount", PyvtkCPXMLPWriterPipeline_SetPaddingAmount, METH_VARARGS,
   "SetPaddingAmount(self, _arg:int) -> None\nC++: virtual void SetPaddingAmount(int _arg)\n\nSet the padding amount for the time index portion of the\ngenerated files. The default is 0.\n"},
  {"GetPaddingAmountMinValue", PyvtkCPXMLPWriterPipeline_GetPaddingAmountMinValue, METH_VARARGS,
   "GetPaddingAmountMinValue(self) -> int\nC++: virtual int GetPaddingAmountMinValue()\n\n"},
  {"GetPaddingAmountMaxValue", PyvtkCPXMLPWriterPipeline_GetPaddingAmountMaxValue, METH_VARARGS,
   "GetPaddingAmountMaxValue(self) -> int\nC++: virtual int GetPaddingAmountMaxValue()\n\n"},
  {"GetPaddingAmount", PyvtkCPXMLPWriterPipeline_GetPaddingAmount, METH_VARARGS,
   "GetPaddingAmount(self) -> int\nC++: virtual int GetPaddingAmount()\n\n"},
  {"SetPath", PyvtkCPXMLPWriterPipeline_SetPath, METH_VARARGS,
   "SetPath(self, _arg:str) -> None\nC++: virtual void SetPath(std::string _arg)\n\nSet the path to the generated files.\n"},
  {"GetPath", PyvtkCPXMLPWriterPipeline_GetPath, METH_VARARGS,
   "GetPath(self) -> str\nC++: virtual std::string GetPath()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkCPXMLPWriterPipeline_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("output_frequency"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCPXMLPWriterPipeline_GetOutputFrequency(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCPXMLPWriterPipeline_SetOutputFrequency(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCPXMLPWriterPipeline_SetOutputFrequency(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOutputFrequency/SetOutputFrequency\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("padding_amount"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCPXMLPWriterPipeline_GetPaddingAmount(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCPXMLPWriterPipeline_SetPaddingAmount(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCPXMLPWriterPipeline_SetPaddingAmount(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPaddingAmount/SetPaddingAmount\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("path"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCPXMLPWriterPipeline_GetPath(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCPXMLPWriterPipeline_SetPath(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCPXMLPWriterPipeline_SetPath(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPath/SetPath\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkCPXMLPWriterPipeline_Doc =
  "vtkCPXMLPWriterPipeline - @ingroup CoProcessing\n\n"
  "Superclass: vtkCPPipeline\n\n"
  "Generic PXML writer pipeline to write out the full Catalyst input\n"
  "datasets. The filename will correspond to the input name/channel\n"
  "identifier with time step and file extension (e.g. \"input_0.pvtu\" for\n"
  "an unstructured dataset with no padding).\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkCPXMLPWriterPipeline_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVCatalyst.vtkCPXMLPWriterPipeline", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkCPXMLPWriterPipeline_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkCPXMLPWriterPipeline_StaticNew()
{
  return vtkCPXMLPWriterPipeline::New();
}

PyObject *PyvtkCPXMLPWriterPipeline_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkCPXMLPWriterPipeline_Type, PyvtkCPXMLPWriterPipeline_Methods,
    "vtkCPXMLPWriterPipeline",
 &PyvtkCPXMLPWriterPipeline_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkCPPipeline_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkCPXMLPWriterPipeline_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkCPXMLPWriterPipeline(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkCPXMLPWriterPipeline_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkCPXMLPWriterPipeline", o) != 0)
  {
    Py_DECREF(o);
  }

}

