/* automatically generated by rust-bindgen 0.72.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    fn extract_bit(byte: u8, index: usize) -> bool {
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        Self::extract_bit(byte, index)
    }
    #[inline]
    pub unsafe fn raw_get_bit(this: *const Self, index: usize) -> bool {
        debug_assert!(index / 8 < core::mem::size_of::<Storage>());
        let byte_index = index / 8;
        let byte = unsafe {
            *(core::ptr::addr_of!((*this).storage) as *const u8).offset(byte_index as isize)
        };
        Self::extract_bit(byte, index)
    }
    #[inline]
    fn change_bit(byte: u8, index: usize, val: bool) -> u8 {
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            byte | mask
        } else {
            byte & !mask
        }
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        *byte = Self::change_bit(*byte, index, val);
    }
    #[inline]
    pub unsafe fn raw_set_bit(this: *mut Self, index: usize, val: bool) {
        debug_assert!(index / 8 < core::mem::size_of::<Storage>());
        let byte_index = index / 8;
        let byte = unsafe {
            (core::ptr::addr_of_mut!((*this).storage) as *mut u8).offset(byte_index as isize)
        };
        unsafe { *byte = Self::change_bit(*byte, index, val) };
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub unsafe fn raw_get(this: *const Self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < core::mem::size_of::<Storage>());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= core::mem::size_of::<Storage>());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if unsafe { Self::raw_get_bit(this, i + bit_offset) } {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
    #[inline]
    pub unsafe fn raw_set(this: *mut Self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < core::mem::size_of::<Storage>());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= core::mem::size_of::<Storage>());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            unsafe { Self::raw_set_bit(this, index + bit_offset, val_bit_is_set) };
        }
    }
}
#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::core::marker::PhantomData<T>, [T; 0]);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub const fn new() -> Self {
        __IncompleteArrayField(::core::marker::PhantomData, [])
    }
    #[inline]
    pub fn as_ptr(&self) -> *const T {
        self as *const _ as *const T
    }
    #[inline]
    pub fn as_mut_ptr(&mut self) -> *mut T {
        self as *mut _ as *mut T
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        ::core::slice::from_raw_parts(self.as_ptr(), len)
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        ::core::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
    }
}
impl<T> ::core::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
#[repr(C)]
pub struct __BindgenUnionField<T>(::core::marker::PhantomData<T>);
impl<T> __BindgenUnionField<T> {
    #[inline]
    pub const fn new() -> Self {
        __BindgenUnionField(::core::marker::PhantomData)
    }
    #[inline]
    pub unsafe fn as_ref(&self) -> &T {
        ::core::mem::transmute(self)
    }
    #[inline]
    pub unsafe fn as_mut(&mut self) -> &mut T {
        ::core::mem::transmute(self)
    }
}
impl<T> ::core::default::Default for __BindgenUnionField<T> {
    #[inline]
    fn default() -> Self {
        Self::new()
    }
}
impl<T> ::core::clone::Clone for __BindgenUnionField<T> {
    #[inline]
    fn clone(&self) -> Self {
        *self
    }
}
impl<T> ::core::marker::Copy for __BindgenUnionField<T> {}
impl<T> ::core::fmt::Debug for __BindgenUnionField<T> {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.write_str("__BindgenUnionField")
    }
}
impl<T> ::core::hash::Hash for __BindgenUnionField<T> {
    fn hash<H: ::core::hash::Hasher>(&self, _state: &mut H) {}
}
impl<T> ::core::cmp::PartialEq for __BindgenUnionField<T> {
    fn eq(&self, _other: &__BindgenUnionField<T>) -> bool {
        true
    }
}
impl<T> ::core::cmp::Eq for __BindgenUnionField<T> {}
pub const CONFIG_RTC_DRV_CROS_EC_MODULE: u32 = 1;
pub const CONFIG_AIC79XX_RESET_DELAY_MS: u32 = 15000;
pub const CONFIG_REGULATOR_LP3972_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_RT288X: u32 = 1;
pub const CONFIG_VIDEO_PVRUSB2_MODULE: u32 = 1;
pub const CONFIG_LIQUIDIO_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SOF_REALTEK_COMMON_MODULE: u32 = 1;
pub const CONFIG_EDAC_GHES: u32 = 1;
pub const CONFIG_NFC_MRVL_MODULE: u32 = 1;
pub const CONFIG_IPV6_IOAM6_LWTUNNEL: u32 = 1;
pub const CONFIG_WM8350_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_INTEL_SOC_PMIC_MRFLD_MODULE: u32 = 1;
pub const CONFIG_PATA_OPTI_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_RUNTIME_UARTS: u32 = 32;
pub const CONFIG_USB_GSPCA_PAC7311_MODULE: u32 = 1;
pub const CONFIG_IIO_GTS_HELPER_MODULE: u32 = 1;
pub const CONFIG_GENERIC_PHY_MIPI_DPHY: u32 = 1;
pub const CONFIG_MFD_IQS62X_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_ACP_PROBES_MODULE: u32 = 1;
pub const CONFIG_MAX9611_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_NCT6694_MODULE: u32 = 1;
pub const CONFIG_NET_CLS_BPF_MODULE: u32 = 1;
pub const CONFIG_STM_PROTO_SYS_T_MODULE: u32 = 1;
pub const CONFIG_MTRR: u32 = 1;
pub const CONFIG_DHT11_MODULE: u32 = 1;
pub const CONFIG_USB_LD_MODULE: u32 = 1;
pub const CONFIG_W83627HF_WDT_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DA9063_MODULE: u32 = 1;
pub const CONFIG_ARCH_USES_HIGH_VMA_FLAGS: u32 = 1;
pub const CONFIG_LEDS_AS3645A_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_SQ930X_MODULE: u32 = 1;
pub const CONFIG_RFKILL_MODULE: u32 = 1;
pub const CONFIG_SPARSEMEM_VMEMMAP_ENABLE: u32 = 1;
pub const CONFIG_SERIAL_ALTERA_UART_BAUDRATE: u32 = 115200;
pub const CONFIG_NET_DSA_MSCC_SEVILLE_MODULE: u32 = 1;
pub const CONFIG_BATTERY_MAX1721X_MODULE: u32 = 1;
pub const CONFIG_NET_9P_VIRTIO_MODULE: u32 = 1;
pub const CONFIG_USB_COMMON: u32 = 1;
pub const CONFIG_SND_SB_COMMON_MODULE: u32 = 1;
pub const CONFIG_MTD_MAP_BANK_WIDTH_1: u32 = 1;
pub const CONFIG_TABLET_SERIAL_WACOM4_MODULE: u32 = 1;
pub const CONFIG_FS_VERITY_BUILTIN_SIGNATURES: u32 = 1;
pub const CONFIG_SND_SOC_RT1308_SDW_MODULE: u32 = 1;
pub const CONFIG_KVM_X86_MODULE: u32 = 1;
pub const CONFIG_SCSI_ENCLOSURE_MODULE: u32 = 1;
pub const CONFIG_MODULE_UNLOAD_TAINT_TRACKING: u32 = 1;
pub const CONFIG_BALLOON_COMPACTION: u32 = 1;
pub const CONFIG_NFT_FIB_IPV4_MODULE: u32 = 1;
pub const CONFIG_QRTR_MODULE: u32 = 1;
pub const CONFIG_XEN_512GB: u32 = 1;
pub const CONFIG_TULIP_NAPI_HW_MITIGATION: u32 = 1;
pub const CONFIG_SND_SOC_TAS6424_MODULE: u32 = 1;
pub const CONFIG_NET_ACT_PEDIT_MODULE: u32 = 1;
pub const CONFIG_MMC_MODULE: u32 = 1;
pub const CONFIG_CROS_EC_MODULE: u32 = 1;
pub const CONFIG_CM32181_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RL6347A_MODULE: u32 = 1;
pub const CONFIG_GPIOLIB: u32 = 1;
pub const CONFIG_USB_DWC2_MODULE: u32 = 1;
pub const CONFIG_DVB_LGS8GXX_MODULE: u32 = 1;
pub const CONFIG_MFD_TPS6586X: u32 = 1;
pub const CONFIG_HYPERV_UTILS_MODULE: u32 = 1;
pub const CONFIG_NF_CONNTRACK_EVENTS: u32 = 1;
pub const CONFIG_NET_EMATCH_NBYTE_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_SM3_GENERIC_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_AUO_PIXCIR_MODULE: u32 = 1;
pub const CONFIG_PARPORT_PC_FIFO: u32 = 1;
pub const CONFIG_DM_CACHE_SMQ_MODULE: u32 = 1;
pub const CONFIG_IR_SANYO_DECODER_MODULE: u32 = 1;
pub const CONFIG_NFS_V3_MODULE: u32 = 1;
pub const CONFIG_INPUT_KXTJ9_MODULE: u32 = 1;
pub const CONFIG_VIDEO_DEV_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_OV534_MODULE: u32 = 1;
pub const CONFIG_INPUT_XEN_KBDDEV_FRONTEND_MODULE: u32 = 1;
pub const CONFIG_ANDROID_BINDER_DEVICES: &[u8; 1] = b"\0";
pub const CONFIG_DMARD06_MODULE: u32 = 1;
pub const CONFIG_AD7923_MODULE: u32 = 1;
pub const CONFIG_SENSORS_KBATT_MODULE: u32 = 1;
pub const CONFIG_VDPA_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_PROBE_WORK_QUEUE: u32 = 1;
pub const CONFIG_NET_VENDOR_MICROSEMI: u32 = 1;
pub const CONFIG_SND_EMU10K1_MODULE: u32 = 1;
pub const CONFIG_SND_AMD_ASOC_REMBRANDT_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_MASQUERADE_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_NI: u32 = 1;
pub const CONFIG_VL6180_MODULE: u32 = 1;
pub const CONFIG_QSEMI_PHY_MODULE: u32 = 1;
pub const CONFIG_RFKILL_INPUT: u32 = 1;
pub const CONFIG_USB_GSPCA_TOUPTEK_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TAS2552_MODULE: u32 = 1;
pub const CONFIG_GENERIC_IRQ_CHIP: u32 = 1;
pub const CONFIG_SND_SOC_MT6357_MODULE: u32 = 1;
pub const CONFIG_USB_ROLE_SWITCH_MODULE: u32 = 1;
pub const CONFIG_ADT7316_MODULE: u32 = 1;
pub const CONFIG_SCSI_MYRB_MODULE: u32 = 1;
pub const CONFIG_IRQ_BYPASS_MANAGER_MODULE: u32 = 1;
pub const CONFIG_REGMAP_SOUNDWIRE_MODULE: u32 = 1;
pub const CONFIG_NET_HANDSHAKE: u32 = 1;
pub const CONFIG_USER_RETURN_NOTIFIER: u32 = 1;
pub const CONFIG_NF_CONNTRACK_OVS: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_RATEEST_MODULE: u32 = 1;
pub const CONFIG_HTS221_I2C_MODULE: u32 = 1;
pub const CONFIG_LIBFDT: u32 = 1;
pub const CONFIG_R8169_MODULE: u32 = 1;
pub const CONFIG_IWLMVM_MODULE: u32 = 1;
pub const CONFIG_ATH10K_CE: u32 = 1;
pub const CONFIG_RDS_TCP_MODULE: u32 = 1;
pub const CONFIG_RCU_DOUBLE_CHECK_CB_TIME: u32 = 1;
pub const CONFIG_WCN36XX_DEBUGFS: u32 = 1;
pub const CONFIG_NFC_PN533_I2C_MODULE: u32 = 1;
pub const CONFIG_PAGE_SHIFT: u32 = 12;
pub const CONFIG_NOA1305_MODULE: u32 = 1;
pub const CONFIG_NLS_ASCII: u32 = 1;
pub const CONFIG_UIO_HV_GENERIC_MODULE: u32 = 1;
pub const CONFIG_SND_ES1968_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_TIME_MODULE: u32 = 1;
pub const CONFIG_SND_VXPOCKET_MODULE: u32 = 1;
pub const CONFIG_USB_F_UAC1_LEGACY_MODULE: u32 = 1;
pub const CONFIG_BATTERY_INTEL_DC_TI_MODULE: u32 = 1;
pub const CONFIG_SATA_SVW_MODULE: u32 = 1;
pub const CONFIG_NFS_COMMON: u32 = 1;
pub const CONFIG_MMA9551_CORE_MODULE: u32 = 1;
pub const CONFIG_PPPOATM_MODULE: u32 = 1;
pub const CONFIG_SENSORS_HP_WMI_MODULE: u32 = 1;
pub const CONFIG_WL12XX_MODULE: u32 = 1;
pub const CONFIG_CGROUP_NET_CLASSID: u32 = 1;
pub const CONFIG_NET_DSA_TAG_EDSA_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV2735_MODULE: u32 = 1;
pub const CONFIG_LOGIG940_FF: u32 = 1;
pub const CONFIG_DVB_ISL6423_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX6697_MODULE: u32 = 1;
pub const CONFIG_INPUT_TWL4030_PWRBUTTON_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_MC13783_MODULE: u32 = 1;
pub const CONFIG_IKCONFIG: u32 = 1;
pub const CONFIG_TREE_RCU: u32 = 1;
pub const CONFIG_XEN_SYMS: u32 = 1;
pub const CONFIG_LRU_GEN_WALKS_MMU: u32 = 1;
pub const CONFIG_SYSVIPC_COMPAT: u32 = 1;
pub const CONFIG_USB_ISP1760_HCD: u32 = 1;
pub const CONFIG_CHARGER_MAX8998_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_CRYPTD_MODULE: u32 = 1;
pub const CONFIG_VIDEO_SAA711X_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_USER_MAD_MODULE: u32 = 1;
pub const CONFIG_SPI_INTEL_MODULE: u32 = 1;
pub const CONFIG_VIDEO_MT9M111_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_ECC: u32 = 1;
pub const CONFIG_BMC150_ACCEL_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_KS8995_MODULE: u32 = 1;
pub const CONFIG_CRC_CCITT: u32 = 1;
pub const CONFIG_FUNCTION_TRACE_ARGS: u32 = 1;
pub const CONFIG_USB_NET_AX8817X_MODULE: u32 = 1;
pub const CONFIG_SYSTEM_BLACKLIST_HASH_LIST: &[u8; 1] = b"\0";
pub const CONFIG_PANASONIC_LAPTOP_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_QEDR_MODULE: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_437: u32 = 1;
pub const CONFIG_SENSORS_GL518SM_MODULE: u32 = 1;
pub const CONFIG_RMI4_F03_SERIO_MODULE: u32 = 1;
pub const CONFIG_X9250_MODULE: u32 = 1;
pub const CONFIG_ALIENWARE_WMI_LEGACY: u32 = 1;
pub const CONFIG_SND_SOC_SOF_PCI_MODULE: u32 = 1;
pub const CONFIG_ISL76682_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_GCM_MODULE: u32 = 1;
pub const CONFIG_ICE_SWITCHDEV: u32 = 1;
pub const CONFIG_CRYPTO_WP512_MODULE: u32 = 1;
pub const CONFIG_INTEL_OAKTRAIL_MODULE: u32 = 1;
pub const CONFIG_ARCH_USE_BUILTIN_BSWAP: u32 = 1;
pub const CONFIG_SND_SOC_MAX98396_MODULE: u32 = 1;
pub const CONFIG_X86_REQUIRED_FEATURE_CMOV: u32 = 1;
pub const CONFIG_VEML6040_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_PCM1789_I2C_MODULE: u32 = 1;
pub const CONFIG_SBITMAP: u32 = 1;
pub const CONFIG_USB_SERIAL_AIRCABLE_MODULE: u32 = 1;
pub const CONFIG_USB_NET_CDCETHER_MODULE: u32 = 1;
pub const CONFIG_ATH11K_DEBUG: u32 = 1;
pub const CONFIG_NET_NCSI: u32 = 1;
pub const CONFIG_LRU_CACHE_MODULE: u32 = 1;
pub const CONFIG_CC_HAS_ASSUME: u32 = 1;
pub const CONFIG_SND_XEN_FRONTEND_MODULE: u32 = 1;
pub const CONFIG_AS_IS_GNU: u32 = 1;
pub const CONFIG_BACKLIGHT_APPLE_MODULE: u32 = 1;
pub const CONFIG_EARLY_PRINTK_USB_XDBC: u32 = 1;
pub const CONFIG_STACKPROTECTOR_STRONG: u32 = 1;
pub const CONFIG_RTW88_MODULE: u32 = 1;
pub const CONFIG_IR_RC6_DECODER_MODULE: u32 = 1;
pub const CONFIG_ENCRYPTED_KEYS_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_UMT_010_MODULE: u32 = 1;
pub const CONFIG_USB_EZUSB_FX2_MODULE: u32 = 1;
pub const CONFIG_IIO_TRIGGER: u32 = 1;
pub const CONFIG_USB_XHCI_PCI_RENESAS_MODULE: u32 = 1;
pub const CONFIG_MCTP_TRANSPORT_I2C_MODULE: u32 = 1;
pub const CONFIG_EXPORTFS_BLOCK_OPS: u32 = 1;
pub const CONFIG_EDAC_SBRIDGE_MODULE: u32 = 1;
pub const CONFIG_TERANETICS_PHY_MODULE: u32 = 1;
pub const CONFIG_V4L2_FWNODE_MODULE: u32 = 1;
pub const CONFIG_SENSORS_INA209_MODULE: u32 = 1;
pub const CONFIG_INIT_STACK_ALL_ZERO: u32 = 1;
pub const CONFIG_SENSORS_DELTA_AHE50DC_FAN_MODULE: u32 = 1;
pub const CONFIG_MFD_INTEL_LPSS_ACPI_MODULE: u32 = 1;
pub const CONFIG_USB_HCD_BCMA_MODULE: u32 = 1;
pub const CONFIG_ACPI_FAN: u32 = 1;
pub const CONFIG_SND_SOC_ADAU1373_MODULE: u32 = 1;
pub const CONFIG_HID_STEAM_MODULE: u32 = 1;
pub const CONFIG_RANDSTRUCT_NONE: u32 = 1;
pub const CONFIG_INTEL_SDSI_MODULE: u32 = 1;
pub const CONFIG_HTS221_MODULE: u32 = 1;
pub const CONFIG_RTC_I2C_AND_SPI: u32 = 1;
pub const CONFIG_RADIO_SHARK2_MODULE: u32 = 1;
pub const CONFIG_CMA_SIZE_SEL_MBYTES: u32 = 1;
pub const CONFIG_INTEL_IOMMU_PERF_EVENTS: u32 = 1;
pub const CONFIG_ROMFS_ON_BLOCK: u32 = 1;
pub const CONFIG_TMPFS: u32 = 1;
pub const CONFIG_FUNCTION_ALIGNMENT_4B: u32 = 1;
pub const CONFIG_TINYDRM_MI0283QT_MODULE: u32 = 1;
pub const CONFIG_RAVE_SP_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_CHARGER_MP2629_MODULE: u32 = 1;
pub const CONFIG_PMBUS_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_NETLINK_MODULE: u32 = 1;
pub const CONFIG_DM_MIRROR_MODULE: u32 = 1;
pub const CONFIG_RTW89_8852BT_MODULE: u32 = 1;
pub const CONFIG_FPGA_MGR_LATTICE_SYSCONFIG_SPI_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV02A10_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_IRTOUCH: u32 = 1;
pub const CONFIG_INFINIBAND_ISER_MODULE: u32 = 1;
pub const CONFIG_DRM_I915_PREEMPT_TIMEOUT_COMPUTE: u32 = 7500;
pub const CONFIG_BACKLIGHT_AAT2870_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV02E10_MODULE: u32 = 1;
pub const CONFIG_CARL9170_MODULE: u32 = 1;
pub const CONFIG_DNET_MODULE: u32 = 1;
pub const CONFIG_IPV6: u32 = 1;
pub const CONFIG_RTC_DRV_FM3130_MODULE: u32 = 1;
pub const CONFIG_MCTP_SERIAL_MODULE: u32 = 1;
pub const CONFIG_SCSI_DMA: u32 = 1;
pub const CONFIG_LIDAR_LITE_V2_MODULE: u32 = 1;
pub const CONFIG_SIGNALFD: u32 = 1;
pub const CONFIG_SENSORS_INTEL_M10_BMC_HWMON_MODULE: u32 = 1;
pub const CONFIG_PCMCIA_XIRC2PS_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_M48T59_MODULE: u32 = 1;
pub const CONFIG_DVB_DDBRIDGE_MODULE: u32 = 1;
pub const CONFIG_HID_ORTEK_MODULE: u32 = 1;
pub const CONFIG_USB_PWC_INPUT_EVDEV: u32 = 1;
pub const CONFIG_MP2629_ADC_MODULE: u32 = 1;
pub const CONFIG_ASYNC_RAID6_RECOV_MODULE: u32 = 1;
pub const CONFIG_ANON_VMA_NAME: u32 = 1;
pub const CONFIG_VIDEO_GC05A2_MODULE: u32 = 1;
pub const CONFIG_MLX5_SF_MANAGER: u32 = 1;
pub const CONFIG_CPU_FREQ_GOV_PERFORMANCE: u32 = 1;
pub const CONFIG_F2FS_FS_LZORLE: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_HDMI_NVIDIA_MCP_MODULE: u32 = 1;
pub const CONFIG_CHARGER_LT3651_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WM8782_MODULE: u32 = 1;
pub const CONFIG_USB_G_MULTI_RNDIS: u32 = 1;
pub const CONFIG_MFD_88PM860X: u32 = 1;
pub const CONFIG_ATM_IDT77252_MODULE: u32 = 1;
pub const CONFIG_KVM_AMD_MODULE: u32 = 1;
pub const CONFIG_HAVE_KVM_PFNCACHE: u32 = 1;
pub const CONFIG_MMC_CB710_MODULE: u32 = 1;
pub const CONFIG_NFT_TPROXY_MODULE: u32 = 1;
pub const CONFIG_DAMON_LRU_SORT: u32 = 1;
pub const CONFIG_OVERLAY_FS_REDIRECT_DIR: u32 = 1;
pub const CONFIG_MFD_ARIZONA_SPI_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_RTRS_SERVER_MODULE: u32 = 1;
pub const CONFIG_SENSORS_WM831X_MODULE: u32 = 1;
pub const CONFIG_MFD_TPS65910: u32 = 1;
pub const CONFIG_NET_VENDOR_MICREL: u32 = 1;
pub const CONFIG_TI_ADC0832_MODULE: u32 = 1;
pub const CONFIG_XEN_HAVE_PVMMU: u32 = 1;
pub const CONFIG_RT2X00_LIB_DEBUGFS: u32 = 1;
pub const CONFIG_AD7746_MODULE: u32 = 1;
pub const CONFIG_MTD_MAP_BANK_WIDTH_2: u32 = 1;
pub const CONFIG_DEFAULT_NET_SCH: &[u8; 9] = b"fq_codel\0";
pub const CONFIG_GPIO_F7188X_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_ASIX: u32 = 1;
pub const CONFIG_SND_SST_ATOM_HIFI2_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_INTEL_MODULE: u32 = 1;
pub const CONFIG_SXGBE_ETH_MODULE: u32 = 1;
pub const CONFIG_SND_PORTMAN2X4_MODULE: u32 = 1;
pub const CONFIG_DELL_RBTN_MODULE: u32 = 1;
pub const CONFIG_PERF_EVENTS_INTEL_UNCORE_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_XILINX_AUDIO_FORMATTER_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT700_MODULE: u32 = 1;
pub const CONFIG_KVM_GUEST: u32 = 1;
pub const CONFIG_MFD_RT5120_MODULE: u32 = 1;
pub const CONFIG_CAN_PEAK_PCMCIA_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TLV320AIC31XX_MODULE: u32 = 1;
pub const CONFIG_ATH11K_DEBUGFS: u32 = 1;
pub const CONFIG_SCSI_BUSLOGIC_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_AS3711_MODULE: u32 = 1;
pub const CONFIG_UNWINDER_ORC: u32 = 1;
pub const CONFIG_MTD_NAND_ECC_MXIC: u32 = 1;
pub const CONFIG_ACPI_HED: u32 = 1;
pub const CONFIG_USB_DWC3_MODULE: u32 = 1;
pub const CONFIG_HID_GOODIX_SPI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_PEB2466_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_EBT_IP6_MODULE: u32 = 1;
pub const CONFIG_MFD_UPBOARD_FPGA_MODULE: u32 = 1;
pub const CONFIG_HAVE_UID16: u32 = 1;
pub const CONFIG_DEVFREQ_GOV_POWERSAVE_MODULE: u32 = 1;
pub const CONFIG_DEFXX_MODULE: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_DEBUG_PAGEALLOC: u32 = 1;
pub const CONFIG_NFS_V2_MODULE: u32 = 1;
pub const CONFIG_VIDEO_AR0521_MODULE: u32 = 1;
pub const CONFIG_UHID_MODULE: u32 = 1;
pub const CONFIG_LEDS_LM355x_MODULE: u32 = 1;
pub const CONFIG_HID_RAZER_MODULE: u32 = 1;
pub const CONFIG_NFC_MRVL_UART_MODULE: u32 = 1;
pub const CONFIG_SECURITY_NETWORK: u32 = 1;
pub const CONFIG_DWC_XLGMAC_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DRBG: u32 = 1;
pub const CONFIG_SENSORS_RM3100_I2C_MODULE: u32 = 1;
pub const CONFIG_HOTPLUG_SMT: u32 = 1;
pub const CONFIG_FB_DEVICE: u32 = 1;
pub const CONFIG_X86_REQUIRED_FEATURE_FXSR: u32 = 1;
pub const CONFIG_IPE_PROP_DM_VERITY: u32 = 1;
pub const CONFIG_NET_IPIP_MODULE: u32 = 1;
pub const CONFIG_WDTPCI_MODULE: u32 = 1;
pub const CONFIG_MTK_NET_PHYLIB_MODULE: u32 = 1;
pub const CONFIG_AIO: u32 = 1;
pub const CONFIG_HID_SPEEDLINK_MODULE: u32 = 1;
pub const CONFIG_DRM_AMDGPU_USERPTR: u32 = 1;
pub const CONFIG_RMNET_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_DUALPI2_MODULE: u32 = 1;
pub const CONFIG_HP03_MODULE: u32 = 1;
pub const CONFIG_DRM_AMDGPU_SI: u32 = 1;
pub const CONFIG_RADIO_TEF6862_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_PALMAS_MODULE: u32 = 1;
pub const CONFIG_EXTCON_USBC_CROS_EC_MODULE: u32 = 1;
pub const CONFIG_INV_MPU6050_IIO_MODULE: u32 = 1;
pub const CONFIG_GENERIC_IRQ_SHOW: u32 = 1;
pub const CONFIG_SENSORS_INSPUR_IPSPS_MODULE: u32 = 1;
pub const CONFIG_DRM_AMD_ISP: u32 = 1;
pub const CONFIG_PATA_EFAR_MODULE: u32 = 1;
pub const CONFIG_SCSI_DH_RDAC_MODULE: u32 = 1;
pub const CONFIG_JFFS2_FS_SECURITY: u32 = 1;
pub const CONFIG_BLOCK_LEGACY_AUTOLOAD: u32 = 1;
pub const CONFIG_GPIB_INES_MODULE: u32 = 1;
pub const CONFIG_VIDEO_GC2145_MODULE: u32 = 1;
pub const CONFIG_HP_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_PCI_SW_SWITCHTEC_MODULE: u32 = 1;
pub const CONFIG_UIO_NETX_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_SKBPRIO_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_ARIA_AESNI_AVX2_X86_64_MODULE: u32 = 1;
pub const CONFIG_DWMAC_GENERIC_MODULE: u32 = 1;
pub const CONFIG_SECURITY_TOMOYO_MAX_ACCEPT_ENTRY: u32 = 2048;
pub const CONFIG_MPU3050_I2C_MODULE: u32 = 1;
pub const CONFIG_VIDEO_TDA7432_MODULE: u32 = 1;
pub const CONFIG_XILINX_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_NETFS_SUPPORT_MODULE: u32 = 1;
pub const CONFIG_ACPI_HOTPLUG_MEMORY: u32 = 1;
pub const CONFIG_CAN_KVASER_USB_MODULE: u32 = 1;
pub const CONFIG_MTD_RAW_NAND_MODULE: u32 = 1;
pub const CONFIG_TI_ADC128S052_MODULE: u32 = 1;
pub const CONFIG_HID_WINWING_MODULE: u32 = 1;
pub const CONFIG_INTEL_SCU_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_NHPOLY1305_AVX2_MODULE: u32 = 1;
pub const CONFIG_GPIO_DWAPB_MODULE: u32 = 1;
pub const CONFIG_PCI_PWRCTRL_MODULE: u32 = 1;
pub const CONFIG_RPCSEC_GSS_KRB5_MODULE: u32 = 1;
pub const CONFIG_AD3530R_MODULE: u32 = 1;
pub const CONFIG_INPUT_POWERMATE_MODULE: u32 = 1;
pub const CONFIG_DP83848_PHY_MODULE: u32 = 1;
pub const CONFIG_WDAT_WDT_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CX25821_ALSA_MODULE: u32 = 1;
pub const CONFIG_PCI_PASID: u32 = 1;
pub const CONFIG_NET_DSA_MICROCHIP_KSZ_PTP: u32 = 1;
pub const CONFIG_WL1251_SDIO_MODULE: u32 = 1;
pub const CONFIG_WIL6210_TRACING: u32 = 1;
pub const CONFIG_BACKLIGHT_ADP8860_MODULE: u32 = 1;
pub const CONFIG_F2FS_FS_MODULE: u32 = 1;
pub const CONFIG_SND_DMA_SGBUF: u32 = 1;
pub const CONFIG_IP_VS_MH_TAB_INDEX: u32 = 12;
pub const CONFIG_CRYPTO_KPP: u32 = 1;
pub const CONFIG_GENERIC_STRNLEN_USER: u32 = 1;
pub const CONFIG_NET_FOU_MODULE: u32 = 1;
pub const CONFIG_CHROMEOS_PSTORE_MODULE: u32 = 1;
pub const CONFIG_VIDEO_DW9714_MODULE: u32 = 1;
pub const CONFIG_ADIN1100_PHY_MODULE: u32 = 1;
pub const CONFIG_GOOGLE_MEMCONSOLE_MODULE: u32 = 1;
pub const CONFIG_SND_LAYLA20_MODULE: u32 = 1;
pub const CONFIG_BLK_SED_OPAL: u32 = 1;
pub const CONFIG_PGTABLE_LEVELS: u32 = 5;
pub const CONFIG_QFMT_V2_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_ECB: u32 = 1;
pub const CONFIG_DRM_AST_MODULE: u32 = 1;
pub const CONFIG_THINKPAD_ACPI_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_MICROSOFT: u32 = 1;
pub const CONFIG_IDLE_PAGE_TRACKING: u32 = 1;
pub const CONFIG_DRM_I915_DP_TUNNEL: u32 = 1;
pub const CONFIG_B44_MODULE: u32 = 1;
pub const CONFIG_BT_BNEP_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_XTKBD_MODULE: u32 = 1;
pub const CONFIG_SECURITY_LOADPIN: u32 = 1;
pub const CONFIG_MFD_QNAP_MCU_MODULE: u32 = 1;
pub const CONFIG_REGMAP: u32 = 1;
pub const CONFIG_SLAB_OBJ_EXT: u32 = 1;
pub const CONFIG_BT_HCIBPA10X_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX1619_MODULE: u32 = 1;
pub const CONFIG_PCI_ATS: u32 = 1;
pub const CONFIG_SCSI_SYM53C8XX_MAX_TAGS: u32 = 64;
pub const CONFIG_NET_VENDOR_8390: u32 = 1;
pub const CONFIG_LEDS_SPI_BYTE_MODULE: u32 = 1;
pub const CONFIG_NLS_MAC_ROMANIAN_MODULE: u32 = 1;
pub const CONFIG_USB_NET_GL620A_MODULE: u32 = 1;
pub const CONFIG_DVB_ZL10039_MODULE: u32 = 1;
pub const CONFIG_LED_TRIGGER_PHY: u32 = 1;
pub const CONFIG_HAVE_KVM_ARCH_GMEM_PREPARE: u32 = 1;
pub const CONFIG_DRM_FBDEV_EMULATION: u32 = 1;
pub const CONFIG_DRM_ANALOGIX_DP_MODULE: u32 = 1;
pub const CONFIG_USER_NS: u32 = 1;
pub const CONFIG_RT73USB_MODULE: u32 = 1;
pub const CONFIG_NFSD_V4_2_INTER_SSC: u32 = 1;
pub const CONFIG_TOUCHSCREEN_CY8CTMA140_MODULE: u32 = 1;
pub const CONFIG_XEN_GRANT_DMA_ALLOC: u32 = 1;
pub const CONFIG_HWMON_VID_MODULE: u32 = 1;
pub const CONFIG_MWL8K_MODULE: u32 = 1;
pub const CONFIG_RTW89_MODULE: u32 = 1;
pub const CONFIG_MITIGATION_SPECTRE_BHI: u32 = 1;
pub const CONFIG_MODULE_DEBUGFS: u32 = 1;
pub const CONFIG_MITIGATION_SLS: u32 = 1;
pub const CONFIG_X86_BOOTPARAM_MEMORY_CORRUPTION_CHECK: u32 = 1;
pub const CONFIG_LEDS_LM3601X_MODULE: u32 = 1;
pub const CONFIG_SECURITY_YAMA: u32 = 1;
pub const CONFIG_VIDEO_SONY_BTF_MPX_MODULE: u32 = 1;
pub const CONFIG_USB_GOKU_MODULE: u32 = 1;
pub const CONFIG_RTW88_8822BE_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_ADD_PAGES: u32 = 1;
pub const CONFIG_SND_SOC_ADAU1372_MODULE: u32 = 1;
pub const CONFIG_DRM_PANIC_SCREEN: &[u8; 8] = b"qr_code\0";
pub const CONFIG_ACPI_AC: u32 = 1;
pub const CONFIG_USB_SERIAL_OPTION_MODULE: u32 = 1;
pub const CONFIG_SCD30_SERIAL_MODULE: u32 = 1;
pub const CONFIG_IEEE802154_ATUSB_MODULE: u32 = 1;
pub const CONFIG_NVME_AUTH_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_QAT_C62XVF_MODULE: u32 = 1;
pub const CONFIG_EROFS_FS_POSIX_ACL: u32 = 1;
pub const CONFIG_SND_AU8810_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_MEMBARRIER_SYNC_CORE: u32 = 1;
pub const CONFIG_RTASE_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT5616_MODULE: u32 = 1;
pub const CONFIG_USB_RTL8152_MODULE: u32 = 1;
pub const CONFIG_KVM_ELIDE_TLB_FLUSH_IF_YOUNG: u32 = 1;
pub const CONFIG_PREFIX_SYMBOLS: u32 = 1;
pub const CONFIG_AD799X_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_ADC_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV8856_MODULE: u32 = 1;
pub const CONFIG_GAMEPORT_FM801_MODULE: u32 = 1;
pub const CONFIG_I2C_CP2615_MODULE: u32 = 1;
pub const CONFIG_W1_SLAVE_DS28E04_MODULE: u32 = 1;
pub const CONFIG_MMC_MTK_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MAX8660_MODULE: u32 = 1;
pub const CONFIG_HAVE_C_RECORDMCOUNT: u32 = 1;
pub const CONFIG_MAX44000_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_VIA: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_RT5663_MODULE: u32 = 1;
pub const CONFIG_NF_TABLES_IPV4: u32 = 1;
pub const CONFIG_MAC80211_STA_HASH_MAX_SIZE: u32 = 0;
pub const CONFIG_DEBUG_WX: u32 = 1;
pub const CONFIG_TICK_ONESHOT: u32 = 1;
pub const CONFIG_INET_ESP_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_SAFE_MODULE: u32 = 1;
pub const CONFIG_NFC_NXP_NCI_I2C_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_MODULE: u32 = 1;
pub const CONFIG_AK09911_MODULE: u32 = 1;
pub const CONFIG_VIDEO_TW9903_MODULE: u32 = 1;
pub const CONFIG_ARCH_WANT_HUGE_PMD_SHARE: u32 = 1;
pub const CONFIG_MFD_MC13XXX_SPI_MODULE: u32 = 1;
pub const CONFIG_RSI_USB_MODULE: u32 = 1;
pub const CONFIG_RSI_COEX: u32 = 1;
pub const CONFIG_DRM: u32 = 1;
pub const CONFIG_HAVE_KERNEL_LZMA: u32 = 1;
pub const CONFIG_BCMA_POSSIBLE: u32 = 1;
pub const CONFIG_NF_REJECT_IPV6_MODULE: u32 = 1;
pub const CONFIG_X86_DISABLED_FEATURE_CYRIX_ARR: u32 = 1;
pub const CONFIG_VIDEO_OV8865_MODULE: u32 = 1;
pub const CONFIG_NTB_AMD_MODULE: u32 = 1;
pub const CONFIG_NFC_MODULE: u32 = 1;
pub const CONFIG_NFSD_V4_SECURITY_LABEL: u32 = 1;
pub const CONFIG_MLXSW_MINIMAL_MODULE: u32 = 1;
pub const CONFIG_PWM_LPSS_MODULE: u32 = 1;
pub const CONFIG_LENOVO_WMI_TUNING_MODULE: u32 = 1;
pub const CONFIG_HUGETLB_PAGE_OPTIMIZE_VMEMMAP: u32 = 1;
pub const CONFIG_MFD_TPS6594_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_LIB_CHACHA_ARCH: u32 = 1;
pub const CONFIG_MT76_USB_MODULE: u32 = 1;
pub const CONFIG_TCG_TPM: u32 = 1;
pub const CONFIG_SILICOM_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_USB_ISIGHTFW_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_ACP_I2S_MODULE: u32 = 1;
pub const CONFIG_PCIE_DW_PLAT: u32 = 1;
pub const CONFIG_CRYPTO_DEV_PADLOCK_AES_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_TAG_DSA_COMMON_MODULE: u32 = 1;
pub const CONFIG_BMI270_MODULE: u32 = 1;
pub const CONFIG_AD5380_MODULE: u32 = 1;
pub const CONFIG_STMMAC_ETH_MODULE: u32 = 1;
pub const CONFIG_USB_YUREX_MODULE: u32 = 1;
pub const CONFIG_USB_IPHETH_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_PAC7302_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_VERTEXCOM: u32 = 1;
pub const CONFIG_LCD_LTV350QV_MODULE: u32 = 1;
pub const CONFIG_IIO_TIGHTLOOP_TRIGGER_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_MD_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_TAG_QCA_MODULE: u32 = 1;
pub const CONFIG_MEMSTICK_R592_MODULE: u32 = 1;
pub const CONFIG_VFIO_PCI_MODULE: u32 = 1;
pub const CONFIG_TEHUTI_MODULE: u32 = 1;
pub const CONFIG_SND_PCM_IEC958: u32 = 1;
pub const CONFIG_TOUCHSCREEN_TSC_SERIO_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_EMMITSBURG_MODULE: u32 = 1;
pub const CONFIG_CPUMASK_OFFSTACK: u32 = 1;
pub const CONFIG_SENSORS_ADM1177_MODULE: u32 = 1;
pub const CONFIG_JFS_STATISTICS: u32 = 1;
pub const CONFIG_USB_CONFIGFS_F_UAC2: u32 = 1;
pub const CONFIG_I2C_ALGOPCA_MODULE: u32 = 1;
pub const CONFIG_IPW2200_PROMISCUOUS: u32 = 1;
pub const CONFIG_BATTERY_BQ27XXX_I2C_MODULE: u32 = 1;
pub const CONFIG_ISCSI_TCP_MODULE: u32 = 1;
pub const CONFIG_X86_DISABLED_FEATURE_LAM: u32 = 1;
pub const CONFIG_MCP4725_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_TRACE_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_GENERIC: u32 = 1;
pub const CONFIG_DMIID: u32 = 1;
pub const CONFIG_NFC_DIGITAL_MODULE: u32 = 1;
pub const CONFIG_MLX5_SF: u32 = 1;
pub const CONFIG_DM9051_MODULE: u32 = 1;
pub const CONFIG_COMMON_CLK_TPS68470_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_EBT_NFLOG_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_MTHCA_MODULE: u32 = 1;
pub const CONFIG_HID_SIGMAMICRO_MODULE: u32 = 1;
pub const CONFIG_NF_DUP_IPV4_MODULE: u32 = 1;
pub const CONFIG_IR_IMON_RAW_MODULE: u32 = 1;
pub const CONFIG_SURFACE_3_POWER_OPREGION_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_PCM3168A_I2C_MODULE: u32 = 1;
pub const CONFIG_SCSI_AACRAID_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MC13783_MODULE: u32 = 1;
pub const CONFIG_CAN_IFI_CANFD_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_EBT_SNAT_MODULE: u32 = 1;
pub const CONFIG_USB_GPIO_VBUS_MODULE: u32 = 1;
pub const CONFIG_RELAY: u32 = 1;
pub const CONFIG_HAVE_KPROBES_ON_FTRACE: u32 = 1;
pub const CONFIG_CPUSETS: u32 = 1;
pub const CONFIG_DRM_NOUVEAU_MODULE: u32 = 1;
pub const CONFIG_VF610_ADC_MODULE: u32 = 1;
pub const CONFIG_AD4130_MODULE: u32 = 1;
pub const CONFIG_USB_KC2190: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_VIA_MODULE: u32 = 1;
pub const CONFIG_I2C_ISCH_MODULE: u32 = 1;
pub const CONFIG_NFP_APP_ABM_NIC: u32 = 1;
pub const CONFIG_CPU_FREQ_STAT: u32 = 1;
pub const CONFIG_LOOPBACK_TARGET_MODULE: u32 = 1;
pub const CONFIG_SCSI_MVSAS_MODULE: u32 = 1;
pub const CONFIG_AL3000A_MODULE: u32 = 1;
pub const CONFIG_MLX5_INFINIBAND_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_CLASSIFY_MODULE: u32 = 1;
pub const CONFIG_LXT_PHY_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_DAVICOM: u32 = 1;
pub const CONFIG_SENSORS_LM3533_MODULE: u32 = 1;
pub const CONFIG_NVME_TARGET_AUTH: u32 = 1;
pub const CONFIG_INTEL_VSC_MODULE: u32 = 1;
pub const CONFIG_NFS_V3_ACL: u32 = 1;
pub const CONFIG_DVB_SMIPCIE_MODULE: u32 = 1;
pub const CONFIG_MTD_NAND_ECC_SW_HAMMING_SMC: u32 = 1;
pub const CONFIG_X86_USER_SHADOW_STACK: u32 = 1;
pub const CONFIG_TOUCHSCREEN_WM9712: u32 = 1;
pub const CONFIG_CRC_T10DIF: u32 = 1;
pub const CONFIG_GPIO_SIOX_MODULE: u32 = 1;
pub const CONFIG_ATA_BMDMA: u32 = 1;
pub const CONFIG_USB_TMC_MODULE: u32 = 1;
pub const CONFIG_PPPOE_HASH_BITS_4: u32 = 1;
pub const CONFIG_BCMA_HOST_PCI: u32 = 1;
pub const CONFIG_QCA83XX_PHY_MODULE: u32 = 1;
pub const CONFIG_SECURITY_LANDLOCK: u32 = 1;
pub const CONFIG_NET_DSA_TAG_DSA_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MT6370_MODULE: u32 = 1;
pub const CONFIG_X509_CERTIFICATE_PARSER: u32 = 1;
pub const CONFIG_EDAC_I5100_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_DA903X_MODULE: u32 = 1;
pub const CONFIG_MAC80211_RC_DEFAULT: &[u8; 12] = b"minstrel_ht\0";
pub const CONFIG_MCP41010_MODULE: u32 = 1;
pub const CONFIG_HID_CYPRESS_MODULE: u32 = 1;
pub const CONFIG_MLX4_INFINIBAND_MODULE: u32 = 1;
pub const CONFIG_RICHTEK_RTQ6056_MODULE: u32 = 1;
pub const CONFIG_BT_HCIDTL1_MODULE: u32 = 1;
pub const CONFIG_ATH9K_HWRNG: u32 = 1;
pub const CONFIG_DP83822_PHY_MODULE: u32 = 1;
pub const CONFIG_SKGE_GENESIS: u32 = 1;
pub const CONFIG_EVENTFD: u32 = 1;
pub const CONFIG_SND_SOC_WM8903_MODULE: u32 = 1;
pub const CONFIG_NFC_NCI_SPI_MODULE: u32 = 1;
pub const CONFIG_GENERIC_CPU_VULNERABILITIES: u32 = 1;
pub const CONFIG_REGULATOR_DA9210_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_QT2160_MODULE: u32 = 1;
pub const CONFIG_X86_PCC_CPUFREQ_MODULE: u32 = 1;
pub const CONFIG_BACKLIGHT_LM3630A_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX31730_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_STOWAWAY_MODULE: u32 = 1;
pub const CONFIG_TCG_SVSM_MODULE: u32 = 1;
pub const CONFIG_FXAS21002C_MODULE: u32 = 1;
pub const CONFIG_SYSTEM_BLACKLIST_KEYRING: u32 = 1;
pub const CONFIG_I2C_MUX_GPIO_MODULE: u32 = 1;
pub const CONFIG_SENSORS_GPD_MODULE: u32 = 1;
pub const CONFIG_NFSD_V4: u32 = 1;
pub const CONFIG_NUMA: u32 = 1;
pub const CONFIG_VIDEO_HEXIUM_GEMINI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_I2C_AND_SPI_MODULE: u32 = 1;
pub const CONFIG_HID_VIVALDI_COMMON_MODULE: u32 = 1;
pub const CONFIG_CHARGER_MT6360_MODULE: u32 = 1;
pub const CONFIG_NET_SHAPER: u32 = 1;
pub const CONFIG_SND_SOC_PCM1754_MODULE: u32 = 1;
pub const CONFIG_INTEL_RAPL_TPMI_MODULE: u32 = 1;
pub const CONFIG_XEN_SCSI_BACKEND_MODULE: u32 = 1;
pub const CONFIG_ZLIB_DEFLATE: u32 = 1;
pub const CONFIG_ADT7316_I2C_MODULE: u32 = 1;
pub const CONFIG_BNXT_HWMON: u32 = 1;
pub const CONFIG_ATM_HE_MODULE: u32 = 1;
pub const CONFIG_CHARGER_WILCO_MODULE: u32 = 1;
pub const CONFIG_USB_NET_DM9601_MODULE: u32 = 1;
pub const CONFIG_SCSI_ARCMSR_MODULE: u32 = 1;
pub const CONFIG_LEDS_INTEL_SS4200_MODULE: u32 = 1;
pub const CONFIG_WLCORE_MODULE: u32 = 1;
pub const CONFIG_IP_NF_NAT_MODULE: u32 = 1;
pub const CONFIG_B43_PHY_HT: u32 = 1;
pub const CONFIG_ICE_HWTS: u32 = 1;
pub const CONFIG_PNP: u32 = 1;
pub const CONFIG_SATA_AHCI: u32 = 1;
pub const CONFIG_REGULATOR_MC13XXX_CORE_MODULE: u32 = 1;
pub const CONFIG_LENOVO_WMI_CAMERA_MODULE: u32 = 1;
pub const CONFIG_HID_SONY_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_PCRYPT_MODULE: u32 = 1;
pub const CONFIG_MITIGATION_L1TF: u32 = 1;
pub const CONFIG_NET_VENDOR_CHELSIO: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_CMEDIA_MODULE: u32 = 1;
pub const CONFIG_PHANTOM_MODULE: u32 = 1;
pub const CONFIG_TQMX86_WDT_MODULE: u32 = 1;
pub const CONFIG_NF_DEFRAG_IPV6_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ADP1050_MODULE: u32 = 1;
pub const CONFIG_ACPI_DPTF: u32 = 1;
pub const CONFIG_PCI_NPEM: u32 = 1;
pub const CONFIG_PATA_PARPORT_BPCK_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ADAU17X1_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SSM2518_MODULE: u32 = 1;
pub const CONFIG_NTB_INTEL_MODULE: u32 = 1;
pub const CONFIG_SERIAL_SC16IS7XX_SPI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_MAX98390_MODULE: u32 = 1;
pub const CONFIG_MITIGATION_SSB: u32 = 1;
pub const CONFIG_TOUCHSCREEN_BU21029_MODULE: u32 = 1;
pub const CONFIG_SECURITY_SAFESETID: u32 = 1;
pub const CONFIG_ZSMALLOC: u32 = 1;
pub const CONFIG_CRYPTO_RNG: u32 = 1;
pub const CONFIG_SND_SOC_SOF_ALDERLAKE_MODULE: u32 = 1;
pub const CONFIG_MFD_WM8400: u32 = 1;
pub const CONFIG_HID_SENSOR_ALS_MODULE: u32 = 1;
pub const CONFIG_TCP_CONG_DCTCP_MODULE: u32 = 1;
pub const CONFIG_CHARGER_88PM860X_MODULE: u32 = 1;
pub const CONFIG_NLMON_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TAS2783_SDW_MODULE: u32 = 1;
pub const CONFIG_FILE_LOCKING: u32 = 1;
pub const CONFIG_LEDS_88PM860X_MODULE: u32 = 1;
pub const CONFIG_TCG_TIS_ST33ZP24_SPI_MODULE: u32 = 1;
pub const CONFIG_USB_U_AUDIO_MODULE: u32 = 1;
pub const CONFIG_NOUVEAU_DEBUG: u32 = 5;
pub const CONFIG_MAG3110_MODULE: u32 = 1;
pub const CONFIG_PATA_IT8213_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TFA989X_MODULE: u32 = 1;
pub const CONFIG_I2C_AMD756_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SOF_BOARD_HELPERS_MODULE: u32 = 1;
pub const CONFIG_PATA_SIS_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_ABEOZ9_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_HMAC: u32 = 1;
pub const CONFIG_TEE_MODULE: u32 = 1;
pub const CONFIG_ADXL355_I2C_MODULE: u32 = 1;
pub const CONFIG_DMA_VIRTUAL_CHANNELS: u32 = 1;
pub const CONFIG_DRM_PANEL_ILITEK_ILI9341_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_ATC260X_MODULE: u32 = 1;
pub const CONFIG_SCSI_INITIO_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_FIXED_VOLTAGE_MODULE: u32 = 1;
pub const CONFIG_GP_PCI1XXXX_MODULE: u32 = 1;
pub const CONFIG_GPIO_VIRTIO_MODULE: u32 = 1;
pub const CONFIG_PGTABLE_HAS_HUGE_LEAVES: u32 = 1;
pub const CONFIG_TI_DAC082S085_MODULE: u32 = 1;
pub const CONFIG_FS_ENCRYPTION_ALGS: u32 = 1;
pub const CONFIG_TOUCHSCREEN_CYTTSP5_MODULE: u32 = 1;
pub const CONFIG_AD7766_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_USER_API_SKCIPHER_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TLV320AIC32X4_SPI_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_FCRYPT_MODULE: u32 = 1;
pub const CONFIG_RTC_INTF_DEV_UIE_EMUL: u32 = 1;
pub const CONFIG_CROS_EC_SENSORHUB_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ACPI_INTEL_MATCH_MODULE: u32 = 1;
pub const CONFIG_IEEE802154_CC2520_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_AES: u32 = 1;
pub const CONFIG_SND_HDA_PREALLOC_SIZE: u32 = 0;
pub const CONFIG_MFD_ARIZONA_I2C_MODULE: u32 = 1;
pub const CONFIG_USB_XUSBATM_MODULE: u32 = 1;
pub const CONFIG_PAGE_SIZE_4KB: u32 = 1;
pub const CONFIG_CAN_EMS_PCI_MODULE: u32 = 1;
pub const CONFIG_GPIO_SCH_MODULE: u32 = 1;
pub const CONFIG_I2C_CHARDEV_MODULE: u32 = 1;
pub const CONFIG_BCM_NET_PHYPTP_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX31760_MODULE: u32 = 1;
pub const CONFIG_STM_PROTO_BASIC_MODULE: u32 = 1;
pub const CONFIG_VIDEO_VIM2M_MODULE: u32 = 1;
pub const CONFIG_AF_UNIX_OOB: u32 = 1;
pub const CONFIG_QCOM_NET_PHYLIB_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_LP3971_MODULE: u32 = 1;
pub const CONFIG_SERIAL_RP2_NR_UARTS: u32 = 32;
pub const CONFIG_MMC_SPI_MODULE: u32 = 1;
pub const CONFIG_INPUT_JOYDEV_MODULE: u32 = 1;
pub const CONFIG_ENCX24J600_MODULE: u32 = 1;
pub const CONFIG_DVB_MN88472_MODULE: u32 = 1;
pub const CONFIG_PCIE_DW_DEBUGFS: u32 = 1;
pub const CONFIG_CRYPTO_DEV_CCP_DD_MODULE: u32 = 1;
pub const CONFIG_DMI: u32 = 1;
pub const CONFIG_HAVE_DYNAMIC_FTRACE: u32 = 1;
pub const CONFIG_SECURITY_APPARMOR_EXPORT_BINARY: u32 = 1;
pub const CONFIG_AFS_FS_MODULE: u32 = 1;
pub const CONFIG_BT_VIRTIO_MODULE: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_CRASH_DUMP: u32 = 1;
pub const CONFIG_DEV_SYNC_PROBE_MODULE: u32 = 1;
pub const CONFIG_VIRTIO_CONSOLE: u32 = 1;
pub const CONFIG_DRM_I915_PREEMPT_TIMEOUT: u32 = 640;
pub const CONFIG_MDIO_I2C_MODULE: u32 = 1;
pub const CONFIG_PATA_ATP867X_MODULE: u32 = 1;
pub const CONFIG_CC_HAS_SLS: u32 = 1;
pub const CONFIG_VIDEO_OV13858_MODULE: u32 = 1;
pub const CONFIG_IPW2200_MODULE: u32 = 1;
pub const CONFIG_SMC_MODULE: u32 = 1;
pub const CONFIG_ITG3200_MODULE: u32 = 1;
pub const CONFIG_IDPF_MODULE: u32 = 1;
pub const CONFIG_RPMSG_WWAN_CTRL_MODULE: u32 = 1;
pub const CONFIG_DVB_OR51211_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_MAX6916_MODULE: u32 = 1;
pub const CONFIG_CHARGER_BQ2415X_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_SUN: u32 = 1;
pub const CONFIG_SENSORS_MAX127_MODULE: u32 = 1;
pub const CONFIG_STK8312_MODULE: u32 = 1;
pub const CONFIG_NET_IFE_SKBTCINDEX_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_UPD78F0730_MODULE: u32 = 1;
pub const CONFIG_HID_ROCCAT_MODULE: u32 = 1;
pub const CONFIG_MAX34408_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_TWOFISH_X86_64_MODULE: u32 = 1;
pub const CONFIG_ATH10K_DEBUGFS: u32 = 1;
pub const CONFIG_TCM_PSCSI_MODULE: u32 = 1;
pub const CONFIG_HID_KYSONA_MODULE: u32 = 1;
pub const CONFIG_PATA_PARPORT_EPIA_MODULE: u32 = 1;
pub const CONFIG_IP6_NF_TARGET_SYNPROXY_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV5647_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_HFSC_MODULE: u32 = 1;
pub const CONFIG_PD6729_MODULE: u32 = 1;
pub const CONFIG_SENSORS_DRIVETEMP_MODULE: u32 = 1;
pub const CONFIG_IDEAPAD_LAPTOP_MODULE: u32 = 1;
pub const CONFIG_GENERIC_MSI_IRQ: u32 = 1;
pub const CONFIG_FB_SYS_COPYAREA: u32 = 1;
pub const CONFIG_POWER_SUPPLY: u32 = 1;
pub const CONFIG_HAVE_MOD_ARCH_SPECIFIC: u32 = 1;
pub const CONFIG_ROCKER_MODULE: u32 = 1;
pub const CONFIG_CROS_TYPEC_SWITCH_MODULE: u32 = 1;
pub const CONFIG_FPGA_DFL_EMIF_MODULE: u32 = 1;
pub const CONFIG_WLAN_VENDOR_ATMEL: u32 = 1;
pub const CONFIG_DEVTMPFS: u32 = 1;
pub const CONFIG_SURFACE_PLATFORMS: u32 = 1;
pub const CONFIG_HAVE_DEBUG_KMEMLEAK: u32 = 1;
pub const CONFIG_NET_VENDOR_CORTINA: u32 = 1;
pub const CONFIG_BLK_DEV_BSG: u32 = 1;
pub const CONFIG_MEDIA_PCI_SUPPORT: u32 = 1;
pub const CONFIG_PCMCIA_QLOGIC_MODULE: u32 = 1;
pub const CONFIG_AT803X_PHY_MODULE: u32 = 1;
pub const CONFIG_MACVTAP_MODULE: u32 = 1;
pub const CONFIG_IPE_PROP_FS_VERITY: u32 = 1;
pub const CONFIG_IPV6_FOU_MODULE: u32 = 1;
pub const CONFIG_DRM_DISPLAY_HDMI_HELPER: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_PHYSDEV_MODULE: u32 = 1;
pub const CONFIG_USB_ANNOUNCE_NEW_DEVICES: u32 = 1;
pub const CONFIG_USB_NET_QMI_WWAN_MODULE: u32 = 1;
pub const CONFIG_RT2800PCI_RT53XX: u32 = 1;
pub const CONFIG_SND_SOC_TSCS454_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_HDA_PROBES_MODULE: u32 = 1;
pub const CONFIG_USB_USBNET_MODULE: u32 = 1;
pub const CONFIG_INPUT_EVDEV: u32 = 1;
pub const CONFIG_IPV6_ROUTE_INFO: u32 = 1;
pub const CONFIG_TI_ADS1015_MODULE: u32 = 1;
pub const CONFIG_HZ_1000: u32 = 1;
pub const CONFIG_MOST_VIDEO_MODULE: u32 = 1;
pub const CONFIG_HUGETLBFS: u32 = 1;
pub const CONFIG_SCTP_DEFAULT_COOKIE_HMAC_SHA256: u32 = 1;
pub const CONFIG_INTEGRITY_PLATFORM_KEYRING: u32 = 1;
pub const CONFIG_EDAC_I7300_MODULE: u32 = 1;
pub const CONFIG_CIFS_XATTR: u32 = 1;
pub const CONFIG_MHI_BUS_MODULE: u32 = 1;
pub const CONFIG_MLX5_CORE_EN_DCB: u32 = 1;
pub const CONFIG_ZRAM_BACKEND_842: u32 = 1;
pub const CONFIG_SENSORS_NPCM7XX_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_WM9713: u32 = 1;
pub const CONFIG_PATA_SERVERWORKS_MODULE: u32 = 1;
pub const CONFIG_FAT_DEFAULT_UTF8: u32 = 1;
pub const CONFIG_SND_SOC_TS3A227E_MODULE: u32 = 1;
pub const CONFIG_USB_NET_RNDIS_HOST_MODULE: u32 = 1;
pub const CONFIG_TCG_TIS_ST33ZP24_MODULE: u32 = 1;
pub const CONFIG_SSB_PCMCIAHOST: u32 = 1;
pub const CONFIG_NETWORK_FILESYSTEMS: u32 = 1;
pub const CONFIG_PATA_SIL680_MODULE: u32 = 1;
pub const CONFIG_MISC_RTSX_PCI_MODULE: u32 = 1;
pub const CONFIG_XFS_QUOTA: u32 = 1;
pub const CONFIG_REGULATOR_SKY81452_MODULE: u32 = 1;
pub const CONFIG_TELCLOCK_MODULE: u32 = 1;
pub const CONFIG_AMD_3D_VCACHE_MODULE: u32 = 1;
pub const CONFIG_INTEL_IDXD_SVM: u32 = 1;
pub const CONFIG_RTW88_8814AE_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_SP_PSP: u32 = 1;
pub const CONFIG_SND_OXFW_MODULE: u32 = 1;
pub const CONFIG_COMPACT_UNEVICTABLE_DEFAULT: u32 = 1;
pub const CONFIG_NFC_ST_NCI_SPI_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_DEBUG_WX: u32 = 1;
pub const CONFIG_VIDEO_HI556_MODULE: u32 = 1;
pub const CONFIG_NET_EGRESS: u32 = 1;
pub const CONFIG_SND_USB_CAIAQ_MODULE: u32 = 1;
pub const CONFIG_MLX5_SW_STEERING: u32 = 1;
pub const CONFIG_W1_MASTER_DS2490_MODULE: u32 = 1;
pub const CONFIG_USB_XHCI_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TLV320AIC32X4_I2C_MODULE: u32 = 1;
pub const CONFIG_CROSS_MEMORY_ATTACH: u32 = 1;
pub const CONFIG_LD_ORPHAN_WARN: u32 = 1;
pub const CONFIG_EROFS_FS_BACKED_BY_FILE: u32 = 1;
pub const CONFIG_USB_SERIAL_CH341_MODULE: u32 = 1;
pub const CONFIG_YENTA_TI: u32 = 1;
pub const CONFIG_REGULATOR_DA9211_MODULE: u32 = 1;
pub const CONFIG_INET_TCP_DIAG_MODULE: u32 = 1;
pub const CONFIG_DRM_EXEC_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_ATKBD: u32 = 1;
pub const CONFIG_SENSORS_ASC7621_MODULE: u32 = 1;
pub const CONFIG_MXC6255_MODULE: u32 = 1;
pub const CONFIG_TMP006_MODULE: u32 = 1;
pub const CONFIG_HID_NTRIG_MODULE: u32 = 1;
pub const CONFIG_ARCH_WANT_LD_ORPHAN_WARN: u32 = 1;
pub const CONFIG_EROFS_FS_MODULE: u32 = 1;
pub const CONFIG_VIDEO_SAA7164_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_STK17TA8_MODULE: u32 = 1;
pub const CONFIG_SENSORS_QNAP_MCU_HWMON_MODULE: u32 = 1;
pub const CONFIG_USB_NET_CDC_SUBSET_ENABLE_MODULE: u32 = 1;
pub const CONFIG_NF_CONNTRACK_TFTP_MODULE: u32 = 1;
pub const CONFIG_AD7606_MODULE: u32 = 1;
pub const CONFIG_MFD_INTEL_QUARK_I2C_GPIO_MODULE: u32 = 1;
pub const CONFIG_XEN_PRIVCMD_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TLV320AIC23_SPI_MODULE: u32 = 1;
pub const CONFIG_PARAVIRT_TIME_ACCOUNTING: u32 = 1;
pub const CONFIG_I2C_NVIDIA_GPU_MODULE: u32 = 1;
pub const CONFIG_OBJAGG_MODULE: u32 = 1;
pub const CONFIG_SND_GINA20_MODULE: u32 = 1;
pub const CONFIG_DVB_BUDGET_CORE_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_INTEGRITY: u32 = 1;
pub const CONFIG_EDAC_I5400_MODULE: u32 = 1;
pub const CONFIG_USB_CDNS3_GADGET: u32 = 1;
pub const CONFIG_USB_G_HID_MODULE: u32 = 1;
pub const CONFIG_PPPOL2TP_MODULE: u32 = 1;
pub const CONFIG_ACPI_DEBUG: u32 = 1;
pub const CONFIG_IOMMU_SVA: u32 = 1;
pub const CONFIG_BACKLIGHT_ARCXCNN_MODULE: u32 = 1;
pub const CONFIG_SENSORS_DPS920AB_MODULE: u32 = 1;
pub const CONFIG_EXTCON_LC824206XA_MODULE: u32 = 1;
pub const CONFIG_SENSORS_IR38064_REGULATOR: u32 = 1;
pub const CONFIG_X86_MCE_INJECT_MODULE: u32 = 1;
pub const CONFIG_VIDEO: u32 = 1;
pub const CONFIG_VIDEO_MT9M114_MODULE: u32 = 1;
pub const CONFIG_VIDEO_GC0310_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS42L73_MODULE: u32 = 1;
pub const CONFIG_THERMAL_GOV_BANG_BANG: u32 = 1;
pub const CONFIG_VGA_CONSOLE: u32 = 1;
pub const CONFIG_ALIM7101_WDT_MODULE: u32 = 1;
pub const CONFIG_PSTORE_ZONE_MODULE: u32 = 1;
pub const CONFIG_RADIO_SAA7706H_MODULE: u32 = 1;
pub const CONFIG_XEN_PRIVCMD_EVENTFD: u32 = 1;
pub const CONFIG_MFD_SI476X_CORE_MODULE: u32 = 1;
pub const CONFIG_NET_ACT_CONNMARK_MODULE: u32 = 1;
pub const CONFIG_GENERIC_EARLY_IOREMAP: u32 = 1;
pub const CONFIG_SND_SOC_MAX98363_MODULE: u32 = 1;
pub const CONFIG_USB_SL811_CS_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_TSC2005_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_PCM5102A_MODULE: u32 = 1;
pub const CONFIG_RTL8821AE_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ADAU7118_MODULE: u32 = 1;
pub const CONFIG_BINDGEN_VERSION_TEXT: &[u8; 15] = b"bindgen 0.72.1\0";
pub const CONFIG_BT_RFCOMM_MODULE: u32 = 1;
pub const CONFIG_USB_ROLES_INTEL_XHCI_MODULE: u32 = 1;
pub const CONFIG_XFRM_ESP_MODULE: u32 = 1;
pub const CONFIG_MITIGATION_MDS: u32 = 1;
pub const CONFIG_XEN_NETDEV_BACKEND_MODULE: u32 = 1;
pub const CONFIG_CACHEFILES_ONDEMAND: u32 = 1;
pub const CONFIG_MAXSMP: u32 = 1;
pub const CONFIG_PATA_OPTIDMA_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_BCM590XX_MODULE: u32 = 1;
pub const CONFIG_USB_CDC_COMPOSITE_MODULE: u32 = 1;
pub const CONFIG_USB_EXTRON_DA_HD_4K_PLUS_CEC_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS42L42_SDW_MODULE: u32 = 1;
pub const CONFIG_AMD_XGBE_DCB: u32 = 1;
pub const CONFIG_DASHARO_ACPI_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_TM2_TOUCHKEY_MODULE: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_PAGE_TABLE_CHECK: u32 = 1;
pub const CONFIG_RTL8188EE_MODULE: u32 = 1;
pub const CONFIG_CXL_SUSPEND: u32 = 1;
pub const CONFIG_ZRAM_BACKEND_LZ4HC: u32 = 1;
pub const CONFIG_CAN_SLCAN_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_NW80X_MODULE: u32 = 1;
pub const CONFIG_SND_USB_CAIAQ_INPUT: u32 = 1;
pub const CONFIG_RT2800USB_RT35XX: u32 = 1;
pub const CONFIG_I2C_ALI15X3_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_MAGELLAN_MODULE: u32 = 1;
pub const CONFIG_WINMATE_FM07_KEYS_MODULE: u32 = 1;
pub const CONFIG_GPIB_NI_USB_MODULE: u32 = 1;
pub const CONFIG_SPEAKUP_SYNTH_SOFT_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_NAU8825_MODULE: u32 = 1;
pub const CONFIG_IP_NF_MATCH_ECN_MODULE: u32 = 1;
pub const CONFIG_ACPI_SYSTEM_POWER_STATES_SUPPORT: u32 = 1;
pub const CONFIG_REGULATOR_MT6331_MODULE: u32 = 1;
pub const CONFIG_DVB_B2C2_FLEXCOP_PCI_MODULE: u32 = 1;
pub const CONFIG_SND_USB_VARIAX_MODULE: u32 = 1;
pub const CONFIG_SERIAL_DEV_BUS: u32 = 1;
pub const CONFIG_USB_RTL8150_MODULE: u32 = 1;
pub const CONFIG_XEN_GRANT_DEV_ALLOC_MODULE: u32 = 1;
pub const CONFIG_L2TP_MODULE: u32 = 1;
pub const CONFIG_COMPAT_BINFMT_ELF: u32 = 1;
pub const CONFIG_WWAN_DEBUGFS: u32 = 1;
pub const CONFIG_CAN_ESD_USB_MODULE: u32 = 1;
pub const CONFIG_GPIB_NI_PCI_ISA_MODULE: u32 = 1;
pub const CONFIG_X86_DISABLED_FEATURE_VME: u32 = 1;
pub const CONFIG_USB_SEVSEG_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_CY8CTMG110_MODULE: u32 = 1;
pub const CONFIG_NETROM_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_SET_MODULE: u32 = 1;
pub const CONFIG_NF_TABLES_IPV6: u32 = 1;
pub const CONFIG_UIO_MF624_MODULE: u32 = 1;
pub const CONFIG_BSD_PROCESS_ACCT: u32 = 1;
pub const CONFIG_GAMEPORT_EMU10K1_MODULE: u32 = 1;
pub const CONFIG_AMD_SECURE_AVIC: u32 = 1;
pub const CONFIG_SND_SEQ_MIDI_MODULE: u32 = 1;
pub const CONFIG_SCSI_STEX_MODULE: u32 = 1;
pub const CONFIG_DVB_MN88473_MODULE: u32 = 1;
pub const CONFIG_INPUT_FF_MEMLESS_MODULE: u32 = 1;
pub const CONFIG_XZ_DEC_SPARC: u32 = 1;
pub const CONFIG_TYPEC_ANX7411_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV64A40_MODULE: u32 = 1;
pub const CONFIG_RXGK: u32 = 1;
pub const CONFIG_B43_LEDS: u32 = 1;
pub const CONFIG_SND_SOC_TAS2781_COMLIB_MODULE: u32 = 1;
pub const CONFIG_NF_REJECT_IPV4_MODULE: u32 = 1;
pub const CONFIG_MEMSTICK_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_TSC2007_IIO: u32 = 1;
pub const CONFIG_MWIFIEX_PCIE_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_MAX11801_MODULE: u32 = 1;
pub const CONFIG_W1_SLAVE_DS28E17_MODULE: u32 = 1;
pub const CONFIG_LEDS_TRIGGER_INPUT_EVENTS_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AK4642_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_EXTENDED: u32 = 1;
pub const CONFIG_LEDS_SIEMENS_SIMATIC_IPC_F7188X_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_PCM3168A_SPI_MODULE: u32 = 1;
pub const CONFIG_PCMCIA_AHA152X_MODULE: u32 = 1;
pub const CONFIG_KVM_COMPAT: u32 = 1;
pub const CONFIG_SYSTEM_BLACKLIST_AUTH_UPDATE: u32 = 1;
pub const CONFIG_AMD_PMF_MODULE: u32 = 1;
pub const CONFIG_CC_HAS_NO_PROFILE_FN_ATTR: u32 = 1;
pub const CONFIG_X86_64_ACPI_NUMA: u32 = 1;
pub const CONFIG_ATM_NICSTAR_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ADAU1372_I2C_MODULE: u32 = 1;
pub const CONFIG_MDIO_CAVIUM_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_ACPI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TPA6130A2_MODULE: u32 = 1;
pub const CONFIG_SENSORS_EMC1403_MODULE: u32 = 1;
pub const CONFIG_USB_U_SERIAL_MODULE: u32 = 1;
pub const CONFIG_ACPI_SPCR_TABLE: u32 = 1;
pub const CONFIG_MMC_CRYPTO: u32 = 1;
pub const CONFIG_NET_DSA_MV88E6060_MODULE: u32 = 1;
pub const CONFIG_MODULE_COMPRESS: u32 = 1;
pub const CONFIG_CGROUP_MISC: u32 = 1;
pub const CONFIG_RCU_FANOUT: u32 = 64;
pub const CONFIG_NATSEMI_MODULE: u32 = 1;
pub const CONFIG_NET_IPVTI_MODULE: u32 = 1;
pub const CONFIG_GENERIC_IOMAP: u32 = 1;
pub const CONFIG_LEDS_SIEMENS_SIMATIC_IPC_ELKHARTLAKE_MODULE: u32 = 1;
pub const CONFIG_SND_X86: u32 = 1;
pub const CONFIG_KXSD9_SPI_MODULE: u32 = 1;
pub const CONFIG_TYPEC_WUSB3801_MODULE: u32 = 1;
pub const CONFIG_I2C_VIPERBOARD_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_USERSPACE_CONSUMER_MODULE: u32 = 1;
pub const CONFIG_LTR390_MODULE: u32 = 1;
pub const CONFIG_MMA7660_MODULE: u32 = 1;
pub const CONFIG_MPRLS0025PA_MODULE: u32 = 1;
pub const CONFIG_MISC_RTSX_USB_MODULE: u32 = 1;
pub const CONFIG_BYTCRC_PMIC_OPREGION: u32 = 1;
pub const CONFIG_TI_DAC5571_MODULE: u32 = 1;
pub const CONFIG_DVB_MB86A20S_MODULE: u32 = 1;
pub const CONFIG_ADXL380_SPI_MODULE: u32 = 1;
pub const CONFIG_USB_ISP116X_HCD_MODULE: u32 = 1;
pub const CONFIG_OCTEON_EP_MODULE: u32 = 1;
pub const CONFIG_LIBERTAS_USB_MODULE: u32 = 1;
pub const CONFIG_RCU_CPU_STALL_TIMEOUT: u32 = 60;
pub const CONFIG_NF_DUP_IPV6_MODULE: u32 = 1;
pub const CONFIG_PMIC_ADP5520: u32 = 1;
pub const CONFIG_IP_MROUTE_COMMON: u32 = 1;
pub const CONFIG_USB_GADGET_TARGET_MODULE: u32 = 1;
pub const CONFIG_USB_EHCI_HCD: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_EASYTOUCH: u32 = 1;
pub const CONFIG_RTL8192DU_MODULE: u32 = 1;
pub const CONFIG_IRQ_REMAP: u32 = 1;
pub const CONFIG_PHY_QCOM_USB_HSIC_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_ANSI_CPRNG_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_ACP_LEGACY_COMMON_MODULE: u32 = 1;
pub const CONFIG_XILINX_EMACLITE_MODULE: u32 = 1;
pub const CONFIG_STRICT_KERNEL_RWX: u32 = 1;
pub const CONFIG_MMC_SDHCI_UHS2_MODULE: u32 = 1;
pub const CONFIG_EDD_MODULE: u32 = 1;
pub const CONFIG_MAX5821_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_ON_DEMAND_PAGING: u32 = 1;
pub const CONFIG_USB_CONFIGFS_OBEX: u32 = 1;
pub const CONFIG_USB_SERIAL_QUALCOMM_MODULE: u32 = 1;
pub const CONFIG_GENERIC_CLOCKEVENTS_MIN_ADJUST: u32 = 1;
pub const CONFIG_RTW88_SDIO_MODULE: u32 = 1;
pub const CONFIG_LZO_COMPRESS: u32 = 1;
pub const CONFIG_SPARSEMEM_VMEMMAP: u32 = 1;
pub const CONFIG_LEDS_CROS_EC_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_MT2266_MODULE: u32 = 1;
pub const CONFIG_I2C_NFORCE2_MODULE: u32 = 1;
pub const CONFIG_KFENCE_DEFERRABLE: u32 = 1;
pub const CONFIG_CRYPTO_STREEBOG_MODULE: u32 = 1;
pub const CONFIG_HID_SUPPORT: u32 = 1;
pub const CONFIG_CXL_PMEM_MODULE: u32 = 1;
pub const CONFIG_USB_CDC_PHONET_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_CHELSIO_MODULE: u32 = 1;
pub const CONFIG_IP_NF_ARPFILTER_MODULE: u32 = 1;
pub const CONFIG_MACB_MODULE: u32 = 1;
pub const CONFIG_EXTCON_MAX77693_MODULE: u32 = 1;
pub const CONFIG_CLOCKSOURCE_WATCHDOG_MAX_SKEW_US: u32 = 100;
pub const CONFIG_ARCH_WANT_HUGETLB_VMEMMAP_PREINIT: u32 = 1;
pub const CONFIG_GPIO_ICH_MODULE: u32 = 1;
pub const CONFIG_HID_SMARTJOYPLUS_MODULE: u32 = 1;
pub const CONFIG_I2C_CCGX_UCSI: u32 = 1;
pub const CONFIG_ASYNC_PQ_MODULE: u32 = 1;
pub const CONFIG_HX711_MODULE: u32 = 1;
pub const CONFIG_VFAT_FS_MODULE: u32 = 1;
pub const CONFIG_LCD_CLASS_DEVICE_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_ROCKER: u32 = 1;
pub const CONFIG_FONT_8x8: u32 = 1;
pub const CONFIG_EFIVAR_FS: u32 = 1;
pub const CONFIG_SND_SOC_WCD_MBHC_MODULE: u32 = 1;
pub const CONFIG_HOTPLUG_CORE_SYNC_FULL: u32 = 1;
pub const CONFIG_NFC_MICROREAD_I2C_MODULE: u32 = 1;
pub const CONFIG_UBIFS_FS_XATTR: u32 = 1;
pub const CONFIG_SECURITY_DMESG_RESTRICT: u32 = 1;
pub const CONFIG_INSPUR_PLATFORM_PROFILE_MODULE: u32 = 1;
pub const CONFIG_LEDS_GPIO_MODULE: u32 = 1;
pub const CONFIG_CHELSIO_T1_1G: u32 = 1;
pub const CONFIG_AD4080_MODULE: u32 = 1;
pub const CONFIG_DVB_HOPPER_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DEFLATE_MODULE: u32 = 1;
pub const CONFIG_LTR501_MODULE: u32 = 1;
pub const CONFIG_E100_MODULE: u32 = 1;
pub const CONFIG_MACSEC_MODULE: u32 = 1;
pub const CONFIG_IP_ROUTE_MULTIPATH: u32 = 1;
pub const CONFIG_MFD_RT4831_MODULE: u32 = 1;
pub const CONFIG_KFENCE_STRESS_TEST_FAULTS: u32 = 0;
pub const CONFIG_SND_SOC_RT5663_MODULE: u32 = 1;
pub const CONFIG_WLAN_VENDOR_ADMTEK: u32 = 1;
pub const CONFIG_TIME_NS: u32 = 1;
pub const CONFIG_TMP007_MODULE: u32 = 1;
pub const CONFIG_QEDI_MODULE: u32 = 1;
pub const CONFIG_UCS2_STRING: u32 = 1;
pub const CONFIG_DM_MULTIPATH_QL_MODULE: u32 = 1;
pub const CONFIG_MHP_DEFAULT_ONLINE_TYPE_ONLINE_AUTO: u32 = 1;
pub const CONFIG_REGULATOR_PF9453_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_PCM6240_MODULE: u32 = 1;
pub const CONFIG_FUNCTION_PADDING_BYTES: u32 = 16;
pub const CONFIG_MFD_ATC260X_I2C_MODULE: u32 = 1;
pub const CONFIG_MAGIC_SYSRQ_DEFAULT_ENABLE: u32 = 0;
pub const CONFIG_VIDEO_MT9M001_MODULE: u32 = 1;
pub const CONFIG_PACKET: u32 = 1;
pub const CONFIG_LEDS_TRIGGER_TRANSIENT_MODULE: u32 = 1;
pub const CONFIG_VGA_ARB_MAX_GPUS: u32 = 10;
pub const CONFIG_KVM_GENERIC_PRE_FAULT_MEMORY: u32 = 1;
pub const CONFIG_VF610_DAC_MODULE: u32 = 1;
pub const CONFIG_NO_HZ_COMMON: u32 = 1;
pub const CONFIG_SND_FIREFACE_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_METRO_MODULE: u32 = 1;
pub const CONFIG_USB_LJCA_MODULE: u32 = 1;
pub const CONFIG_SCSI_ESAS2R_MODULE: u32 = 1;
pub const CONFIG_MEMTEST: u32 = 1;
pub const CONFIG_6LOWPAN_GHC_EXT_HDR_HOP_MODULE: u32 = 1;
pub const CONFIG_IIO_HRTIMER_TRIGGER_MODULE: u32 = 1;
pub const CONFIG_DRM_VIRTIO_GPU_MODULE: u32 = 1;
pub const CONFIG_MFD_TPS65086_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_MXUPORT_MODULE: u32 = 1;
pub const CONFIG_USB_STORAGE_SDDR55_MODULE: u32 = 1;
pub const CONFIG_MISDN_HFCMULTI_MODULE: u32 = 1;
pub const CONFIG_CC_HAS_SANE_FUNCTION_ALIGNMENT: u32 = 1;
pub const CONFIG_SENSORS_LM95234_MODULE: u32 = 1;
pub const CONFIG_PCMCIA_FMVJ18X_MODULE: u32 = 1;
pub const CONFIG_CC_HAS_MARCH_NATIVE: u32 = 1;
pub const CONFIG_SND_PCM_OSS_PLUGINS: u32 = 1;
pub const CONFIG_I8253_LOCK: u32 = 1;
pub const CONFIG_STACKDEPOT_MAX_FRAMES: u32 = 64;
pub const CONFIG_BRIDGE_EBT_ARP_MODULE: u32 = 1;
pub const CONFIG_SND_SERIAL_U16550_MODULE: u32 = 1;
pub const CONFIG_FPGA_DFL_PCI_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MAX20086_MODULE: u32 = 1;
pub const CONFIG_PTP_1588_CLOCK_KVM_MODULE: u32 = 1;
pub const CONFIG_QFMT_V1_MODULE: u32 = 1;
pub const CONFIG_FB_CFB_FILLRECT: u32 = 1;
pub const CONFIG_TINYDRM_SHARP_MEMORY_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_RT286_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_EBT_T_NAT_MODULE: u32 = 1;
pub const CONFIG_NF_DEFRAG_IPV4_MODULE: u32 = 1;
pub const CONFIG_FAIR_GROUP_SCHED: u32 = 1;
pub const CONFIG_LEDS_MC13783_MODULE: u32 = 1;
pub const CONFIG_ZSTD_DECOMPRESS: u32 = 1;
pub const CONFIG_NETFILTER_ADVANCED: u32 = 1;
pub const CONFIG_FAT_FS_MODULE: u32 = 1;
pub const CONFIG_USB_CONFIGFS_NCM: u32 = 1;
pub const CONFIG_DRM_PANIC_FOREGROUND_COLOR: u32 = 16777215;
pub const CONFIG_REGULATOR_MAX77503_MODULE: u32 = 1;
pub const CONFIG_WM831X_POWER_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_TSC2004_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT274_MODULE: u32 = 1;
pub const CONFIG_VDPA_USER_MODULE: u32 = 1;
pub const CONFIG_INTEL_PMT_DISCOVERY_MODULE: u32 = 1;
pub const CONFIG_NVME_MULTIPATH: u32 = 1;
pub const CONFIG_B43LEGACY_DMA_AND_PIO_MODE: u32 = 1;
pub const CONFIG_PSTORE_DEFAULT_KMSG_BYTES: u32 = 10240;
pub const CONFIG_VIDEO_CX231XX_RC: u32 = 1;
pub const CONFIG_X86_PMEM_LEGACY_MODULE: u32 = 1;
pub const CONFIG_IP6_NF_TARGET_REJECT_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_LPASS_MACRO_COMMON_MODULE: u32 = 1;
pub const CONFIG_AIC79XX_CMDS_PER_DEVICE: u32 = 32;
pub const CONFIG_MLX5_BRIDGE: u32 = 1;
pub const CONFIG_RTW89_8852BTE_MODULE: u32 = 1;
pub const CONFIG_GENERIC_TIME_VSYSCALL: u32 = 1;
pub const CONFIG_MMU_GATHER_RCU_TABLE_FREE: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_PER_VMA_LOCK: u32 = 1;
pub const CONFIG_AS73211_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_ALC680_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_PCM3168A_MODULE: u32 = 1;
pub const CONFIG_SND_CS46XX_NEW_DSP: u32 = 1;
pub const CONFIG_BT_HCIBLUECARD_MODULE: u32 = 1;
pub const CONFIG_THERMAL_CORE_TESTING_MODULE: u32 = 1;
pub const CONFIG_DVB_AS102_FE_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_ACP5x_MODULE: u32 = 1;
pub const CONFIG_IR_IMON_DECODER_MODULE: u32 = 1;
pub const CONFIG_OVERLAY_FS_METACOPY: u32 = 1;
pub const CONFIG_DLN2_ADC_MODULE: u32 = 1;
pub const CONFIG_DS1682_MODULE: u32 = 1;
pub const CONFIG_NR_CPUS: u32 = 8192;
pub const CONFIG_V4L2_CCI_MODULE: u32 = 1;
pub const CONFIG_PATA_PARPORT_KTTI_MODULE: u32 = 1;
pub const CONFIG_PCI_PWRCTRL_SLOT_MODULE: u32 = 1;
pub const CONFIG_ARCH_HIBERNATION_POSSIBLE: u32 = 1;
pub const CONFIG_HID_ACCUTOUCH_MODULE: u32 = 1;
pub const CONFIG_X86_REQUIRED_FEATURE_MSR: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_E2I: u32 = 1;
pub const CONFIG_HAVE_FUNCTION_TRACER: u32 = 1;
pub const CONFIG_ASYNC_MEMCPY_MODULE: u32 = 1;
pub const CONFIG_MLXSW_PCI_MODULE: u32 = 1;
pub const CONFIG_SPI_OC_TINY_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_NAU8824_MODULE: u32 = 1;
pub const CONFIG_GPIO_MAX7301_MODULE: u32 = 1;
pub const CONFIG_SX9500_MODULE: u32 = 1;
pub const CONFIG_LOG_BUF_SHIFT: u32 = 17;
pub const CONFIG_REGULATOR_MT6332_MODULE: u32 = 1;
pub const CONFIG_LEDS_TRIGGER_DEFAULT_ON_MODULE: u32 = 1;
pub const CONFIG_IPV6_OPTIMISTIC_DAD: u32 = 1;
pub const CONFIG_SND_SOC_MAX98927_MODULE: u32 = 1;
pub const CONFIG_FB_EFI: u32 = 1;
pub const CONFIG_AUDIT: u32 = 1;
pub const CONFIG_SQUASHFS_XATTR: u32 = 1;
pub const CONFIG_BH1745_MODULE: u32 = 1;
pub const CONFIG_NET_9P_MODULE: u32 = 1;
pub const CONFIG_BATTERY_DA9052_MODULE: u32 = 1;
pub const CONFIG_SECURITY_SMACK_APPEND_SIGNALS: u32 = 1;
pub const CONFIG_USB_F_MIDI_MODULE: u32 = 1;
pub const CONFIG_BT_HCIBTUSB_MODULE: u32 = 1;
pub const CONFIG_XEN_ACPI: u32 = 1;
pub const CONFIG_GPIO_DA9052_MODULE: u32 = 1;
pub const CONFIG_DRM_XE_JOB_TIMEOUT_MAX: u32 = 10000;
pub const CONFIG_USB_HUB_USB251XB_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_CANNONLAKE_MODULE: u32 = 1;
pub const CONFIG_TCP_CONG_SCALABLE_MODULE: u32 = 1;
pub const CONFIG_INTEL_QUICKSPI_MODULE: u32 = 1;
pub const CONFIG_SND_SEQ_DEVICE_MODULE: u32 = 1;
pub const CONFIG_VEML3235_MODULE: u32 = 1;
pub const CONFIG_DVB_DRX39XYJ_MODULE: u32 = 1;
pub const CONFIG_RTW88_USB_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CROS_EC_CODEC_MODULE: u32 = 1;
pub const CONFIG_MOUSE_CYAPA_MODULE: u32 = 1;
pub const CONFIG_VIDEO_TW9906_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MT6323_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_ZONED_LOOP_MODULE: u32 = 1;
pub const CONFIG_AD3552R_HS_MODULE: u32 = 1;
pub const CONFIG_QED_MODULE: u32 = 1;
pub const CONFIG_DAMON_RECLAIM: u32 = 1;
pub const CONFIG_SDP500_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_CONNTRACK_MODULE: u32 = 1;
pub const CONFIG_NF_SOCKET_IPV4_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_ARIA_AESNI_AVX_X86_64_MODULE: u32 = 1;
pub const CONFIG_CAN_DEV_MODULE: u32 = 1;
pub const CONFIG_SND_SEQ_HRTIMER_DEFAULT: u32 = 1;
pub const CONFIG_YELLOWFIN_MODULE: u32 = 1;
pub const CONFIG_MSE102X_MODULE: u32 = 1;
pub const CONFIG_HW_RANDOM_INTEL_MODULE: u32 = 1;
pub const CONFIG_NVME_TCP_TLS: u32 = 1;
pub const CONFIG_COMPAT_NETLINK_MESSAGES: u32 = 1;
pub const CONFIG_JOYSTICK_TWIDJOY_MODULE: u32 = 1;
pub const CONFIG_USB_ATM_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_AXP20X_MODULE: u32 = 1;
pub const CONFIG_VSOCKETS_DIAG_MODULE: u32 = 1;
pub const CONFIG_USB_LED_TRIG: u32 = 1;
pub const CONFIG_NET_SCH_GRED_MODULE: u32 = 1;
pub const CONFIG_DM_MULTIPATH_MODULE: u32 = 1;
pub const CONFIG_AFE4403_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_YC_MACH_MODULE: u32 = 1;
pub const CONFIG_KVM_INTEL_MODULE: u32 = 1;
pub const CONFIG_CAN_J1939_MODULE: u32 = 1;
pub const CONFIG_RDS_RDMA_MODULE: u32 = 1;
pub const CONFIG_EVENT_TRACING: u32 = 1;
pub const CONFIG_KRETPROBES: u32 = 1;
pub const CONFIG_BCM_NET_PHYLIB_MODULE: u32 = 1;
pub const CONFIG_PAGE_POISONING: u32 = 1;
pub const CONFIG_BACKLIGHT_AS3711_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_CE6230_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_USER_SHADOW_STACK: u32 = 1;
pub const CONFIG_PATA_CMD640_PCI_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_SHARE_IRQ: u32 = 1;
pub const CONFIG_MLX5_HW_STEERING: u32 = 1;
pub const CONFIG_NETFS_DEBUG: u32 = 1;
pub const CONFIG_LOCKD_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_CYPRESS_M8_MODULE: u32 = 1;
pub const CONFIG_6LOWPAN_GHC_UDP_MODULE: u32 = 1;
pub const CONFIG_RPMSG_CTRL_MODULE: u32 = 1;
pub const CONFIG_USB_CONFIGFS_F_UAC1: u32 = 1;
pub const CONFIG_HID_CREATIVE_SB0540_MODULE: u32 = 1;
pub const CONFIG_BPF_LSM: u32 = 1;
pub const CONFIG_BACKLIGHT_RT4831_MODULE: u32 = 1;
pub const CONFIG_NVME_TARGET_RDMA_MODULE: u32 = 1;
pub const CONFIG_IP_ROUTE_VERBOSE: u32 = 1;
pub const CONFIG_COMPACTION: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_ALC861VD_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_RT4801_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_ALDERLAKE_MODULE: u32 = 1;
pub const CONFIG_FB_CFB_IMAGEBLIT: u32 = 1;
pub const CONFIG_PATA_SCH_MODULE: u32 = 1;
pub const CONFIG_SCSI_BFA_FC_MODULE: u32 = 1;
pub const CONFIG_HWPOISON_INJECT_MODULE: u32 = 1;
pub const CONFIG_BRANCH_PROFILE_NONE: u32 = 1;
pub const CONFIG_SND_SOC_NTP8918_MODULE: u32 = 1;
pub const CONFIG_VIDEOBUF2_VMALLOC_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_EBT_IP_MODULE: u32 = 1;
pub const CONFIG_INPUT: u32 = 1;
pub const CONFIG_BIG_KEYS: u32 = 1;
pub const CONFIG_SENSORS_OCC_P8_I2C_MODULE: u32 = 1;
pub const CONFIG_LEDS_UPBOARD_MODULE: u32 = 1;
pub const CONFIG_TI_ADS131E08_MODULE: u32 = 1;
pub const CONFIG_WLAN_VENDOR_RSI: u32 = 1;
pub const CONFIG_SND_SOC_RT711_MODULE: u32 = 1;
pub const CONFIG_USB_MAX3420_UDC_MODULE: u32 = 1;
pub const CONFIG_USB_NET_PLUSB_MODULE: u32 = 1;
pub const CONFIG_SPI_MICROCHIP_CORE_MODULE: u32 = 1;
pub const CONFIG_NFT_LOG_MODULE: u32 = 1;
pub const CONFIG_HAVE_MMIOTRACE_SUPPORT: u32 = 1;
pub const CONFIG_GENWQE_PLATFORM_ERROR_RECOVERY: u32 = 0;
pub const CONFIG_RADIO_ADAPTERS_MODULE: u32 = 1;
pub const CONFIG_HAVE_OBJTOOL_MCOUNT: u32 = 1;
pub const CONFIG_SND_SOC_MT6358_MODULE: u32 = 1;
pub const CONFIG_SMPRO_MISC_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_EBT_REDIRECT_MODULE: u32 = 1;
pub const CONFIG_FPGA_BRIDGE_MODULE: u32 = 1;
pub const CONFIG_TCG_TPM2_HMAC: u32 = 1;
pub const CONFIG_ROHM_BM1390_MODULE: u32 = 1;
pub const CONFIG_FUTEX_PRIVATE_HASH: u32 = 1;
pub const CONFIG_FUEL_GAUGE_MM8013_MODULE: u32 = 1;
pub const CONFIG_VXLAN_MODULE: u32 = 1;
pub const CONFIG_RXKAD: u32 = 1;
pub const CONFIG_SONY_FF: u32 = 1;
pub const CONFIG_MS5611_I2C_MODULE: u32 = 1;
pub const CONFIG_CAN_M_CAN_PCI_MODULE: u32 = 1;
pub const CONFIG_RTW88_8723DE_MODULE: u32 = 1;
pub const CONFIG_DEV_COREDUMP: u32 = 1;
pub const CONFIG_SLAB_MERGE_DEFAULT: u32 = 1;
pub const CONFIG_XEN: u32 = 1;
pub const CONFIG_DVB_USB_MODULE: u32 = 1;
pub const CONFIG_FB_DMAMEM_HELPERS_DEFERRED: u32 = 1;
pub const CONFIG_BATMAN_ADV_BATMAN_V: u32 = 1;
pub const CONFIG_QAT_VFIO_PCI_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_POLYVAL_MODULE: u32 = 1;
pub const CONFIG_TYPEC_MUX_PTN36502_MODULE: u32 = 1;
pub const CONFIG_USB_MIDI_GADGET_MODULE: u32 = 1;
pub const CONFIG_DVB_B2C2_FLEXCOP_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WM8998_MODULE: u32 = 1;
pub const CONFIG_GPIO_PCF857X_MODULE: u32 = 1;
pub const CONFIG_FUNCTION_ERROR_INJECTION: u32 = 1;
pub const CONFIG_TABLET_USB_HANWANG_MODULE: u32 = 1;
pub const CONFIG_E1000_MODULE: u32 = 1;
pub const CONFIG_FRAMEBUFFER_CONSOLE: u32 = 1;
pub const CONFIG_SND_INDIGO_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_ACP6x_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT5660_MODULE: u32 = 1;
pub const CONFIG_ADT7316_SPI_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_GENERIC_CRASHKERNEL_RESERVATION: u32 = 1;
pub const CONFIG_GPIO_LP873X_MODULE: u32 = 1;
pub const CONFIG_RADIO_SI476X_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_TPS6507X_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AW88166_MODULE: u32 = 1;
pub const CONFIG_MTD_NAND_ECC_SW_BCH: u32 = 1;
pub const CONFIG_JOYSTICK_XPAD_FF: u32 = 1;
pub const CONFIG_CRYPTO_ENGINE_MODULE: u32 = 1;
pub const CONFIG_COUNTER_MODULE: u32 = 1;
pub const CONFIG_POLYNOMIAL_MODULE: u32 = 1;
pub const CONFIG_BLK_ICQ: u32 = 1;
pub const CONFIG_MPL115_MODULE: u32 = 1;
pub const CONFIG_NF_CONNTRACK_MARK: u32 = 1;
pub const CONFIG_VFIO_PCI_VGA: u32 = 1;
pub const CONFIG_ATP_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_MSM6242_MODULE: u32 = 1;
pub const CONFIG_HAVE_GCC_PLUGINS: u32 = 1;
pub const CONFIG_USB_NET_SMSC95XX_MODULE: u32 = 1;
pub const CONFIG_SENSORS_NCT6683_MODULE: u32 = 1;
pub const CONFIG_PATA_ARTOP_MODULE: u32 = 1;
pub const CONFIG_FUSION_LAN_MODULE: u32 = 1;
pub const CONFIG_MEMSTICK_TIFM_MS_MODULE: u32 = 1;
pub const CONFIG_DRM_VMWGFX_MKSSTATS: u32 = 1;
pub const CONFIG_DVB_AF9033_MODULE: u32 = 1;
pub const CONFIG_SND_DESIGNWARE_PCM: u32 = 1;
pub const CONFIG_NO_HZ: u32 = 1;
pub const CONFIG_VIDEO_GO7007_USB_MODULE: u32 = 1;
pub const CONFIG_IQS624_POS_MODULE: u32 = 1;
pub const CONFIG_DP83869_PHY_MODULE: u32 = 1;
pub const CONFIG_TPL0102_MODULE: u32 = 1;
pub const CONFIG_LIBIE_FWLOG_MODULE: u32 = 1;
pub const CONFIG_GPIO_PALMAS_MODULE: u32 = 1;
pub const CONFIG_PWM_CLK_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LT3074_MODULE: u32 = 1;
pub const CONFIG_CEPH_FSCACHE: u32 = 1;
pub const CONFIG_INPUT_GPIO_DECODER_MODULE: u32 = 1;
pub const CONFIG_RING_BUFFER: u32 = 1;
pub const CONFIG_W1_MASTER_GPIO_MODULE: u32 = 1;
pub const CONFIG_I2C_MUX_PCA954x_MODULE: u32 = 1;
pub const CONFIG_ATH12K_DEBUG: u32 = 1;
pub const CONFIG_NET_DSA_TAG_MTK_MODULE: u32 = 1;
pub const CONFIG_I2C_SIS96X_MODULE: u32 = 1;
pub const CONFIG_D3323AA_MODULE: u32 = 1;
pub const CONFIG_USB_HSIC_USB4604_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_TSC2007_MODULE: u32 = 1;
pub const CONFIG_DM_SNAPSHOT_MODULE: u32 = 1;
pub const CONFIG_MCP4821_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_IUU_MODULE: u32 = 1;
pub const CONFIG_EDAC_E752X_MODULE: u32 = 1;
pub const CONFIG_NET_PKTGEN_MODULE: u32 = 1;
pub const CONFIG_LLC_MODULE: u32 = 1;
pub const CONFIG_VIDEO_AU0828_MODULE: u32 = 1;
pub const CONFIG_DYNAMIC_FTRACE_WITH_REGS: u32 = 1;
pub const CONFIG_LEDS_LM36274_MODULE: u32 = 1;
pub const CONFIG_MFD_SYSCON: u32 = 1;
pub const CONFIG_REGULATOR_PCAP_MODULE: u32 = 1;
pub const CONFIG_VIDEO_STK1160_MODULE: u32 = 1;
pub const CONFIG_USB_CYTHERM_MODULE: u32 = 1;
pub const CONFIG_INPUT_PCF8574_MODULE: u32 = 1;
pub const CONFIG_GPIOLIB_FASTPATH_LIMIT: u32 = 512;
pub const CONFIG_MAC80211_LEDS: u32 = 1;
pub const CONFIG_EXTCON_FSA9480_MODULE: u32 = 1;
pub const CONFIG_SCHED_MC_PRIO: u32 = 1;
pub const CONFIG_USB_NET_AQC111_MODULE: u32 = 1;
pub const CONFIG_NFC_ST_NCI_I2C_MODULE: u32 = 1;
pub const CONFIG_EZX_PCAP: u32 = 1;
pub const CONFIG_SECURITY_SELINUX_BOOTPARAM: u32 = 1;
pub const CONFIG_JFS_SECURITY: u32 = 1;
pub const CONFIG_PCIPCWATCHDOG_MODULE: u32 = 1;
pub const CONFIG_NFC_MRVL_USB_MODULE: u32 = 1;
pub const CONFIG_XEN_MCE_LOG: u32 = 1;
pub const CONFIG_RT2800USB_MODULE: u32 = 1;
pub const CONFIG_BT_BNEP_PROTO_FILTER: u32 = 1;
pub const CONFIG_RESET_CONTROLLER: u32 = 1;
pub const CONFIG_SND_SOC_SOF_GEMINILAKE_MODULE: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_HUGETLBFS: u32 = 1;
pub const CONFIG_RTC_DRV_M41T80_WDT: u32 = 1;
pub const CONFIG_VIDEO_MEM2MEM_DEINTERLACE_MODULE: u32 = 1;
pub const CONFIG_SURFACE_AGGREGATOR_HUB_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_MCP795_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_SM4_AESNI_AVX_X86_64_MODULE: u32 = 1;
pub const CONFIG_PID_NS: u32 = 1;
pub const CONFIG_DRM_GPUVM_MODULE: u32 = 1;
pub const CONFIG_GPIO_MAX7300_MODULE: u32 = 1;
pub const CONFIG_NVME_HWMON: u32 = 1;
pub const CONFIG_IP6_NF_TARGET_NPT_MODULE: u32 = 1;
pub const CONFIG_LEDS_RT8515_MODULE: u32 = 1;
pub const CONFIG_MB1232_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_MICROCHIP_KSZ8863_SMI_MODULE: u32 = 1;
pub const CONFIG_TINYDRM_ILI9163_MODULE: u32 = 1;
pub const CONFIG_HAVE_KVM_DIRTY_RING: u32 = 1;
pub const CONFIG_ROHM_BU27034_MODULE: u32 = 1;
pub const CONFIG_AS3935_MODULE: u32 = 1;
pub const CONFIG_CGROUP_PERF: u32 = 1;
pub const CONFIG_INET6_ESP_OFFLOAD_MODULE: u32 = 1;
pub const CONFIG_L2TP_ETH_MODULE: u32 = 1;
pub const CONFIG_IGC_LEDS: u32 = 1;
pub const CONFIG_VIDEO_MSP3400_MODULE: u32 = 1;
pub const CONFIG_USB_PWC_MODULE: u32 = 1;
pub const CONFIG_HARDIRQS_SW_RESEND: u32 = 1;
pub const CONFIG_IIO_CONSUMERS_PER_TRIGGER: u32 = 2;
pub const CONFIG_FRAMEBUFFER_CONSOLE_ROTATION: u32 = 1;
pub const CONFIG_BNX2X_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_NAU8810_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAVE_NMI_SAFE_CMPXCHG: u32 = 1;
pub const CONFIG_SSIF_IPMI_BMC_MODULE: u32 = 1;
pub const CONFIG_AW96103_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_NETLINK_GLUE_CT: u32 = 1;
pub const CONFIG_SENSORS_XDPE122_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_FINTEK: u32 = 1;
pub const CONFIG_ENIC_MODULE: u32 = 1;
pub const CONFIG_SCSI_MPT2SAS_MAX_SGE: u32 = 128;
pub const CONFIG_FREEZER: u32 = 1;
pub const CONFIG_RFD77402_MODULE: u32 = 1;
pub const CONFIG_XEN_GNTDEV_DMABUF: u32 = 1;
pub const CONFIG_INFINIBAND_USER_MEM: u32 = 1;
pub const CONFIG_PINCTRL_CS47L35: u32 = 1;
pub const CONFIG_SND_SOC_SSM2602_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_V2_MODULE: u32 = 1;
pub const CONFIG_AMD_PTDMA_MODULE: u32 = 1;
pub const CONFIG_MYRI10GE_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_INTEL_SOUNDWIRE_LINK_BASELINE_MODULE: u32 = 1;
pub const CONFIG_VM_EVENT_COUNTERS: u32 = 1;
pub const CONFIG_SQUASHFS_CHOICE_DECOMP_BY_MOUNT: u32 = 1;
pub const CONFIG_PAGE_SIZE_LESS_THAN_64KB: u32 = 1;
pub const CONFIG_VLAN_8021Q_MODULE: u32 = 1;
pub const CONFIG_HID_HAPTIC: u32 = 1;
pub const CONFIG_AQTION_MODULE: u32 = 1;
pub const CONFIG_ASSOCIATIVE_ARRAY: u32 = 1;
pub const CONFIG_PNFS_FILE_LAYOUT_MODULE: u32 = 1;
pub const CONFIG_RTL8723_COMMON_MODULE: u32 = 1;
pub const CONFIG_AXP288_ADC_MODULE: u32 = 1;
pub const CONFIG_SI7005_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_SPACEBALL_MODULE: u32 = 1;
pub const CONFIG_EFI_EARLYCON: u32 = 1;
pub const CONFIG_GPIOLIB_LEGACY: u32 = 1;
pub const CONFIG_MINIX_SUBPARTITION: u32 = 1;
pub const CONFIG_IPE_PROP_DM_VERITY_SIGNATURE: u32 = 1;
pub const CONFIG_LEDS_MLXCPLD_MODULE: u32 = 1;
pub const CONFIG_EXT4_FS_SECURITY: u32 = 1;
pub const CONFIG_SENSORS_SHT3x_MODULE: u32 = 1;
pub const CONFIG_BRCMFMAC_USB: u32 = 1;
pub const CONFIG_SUNRPC_SWAP: u32 = 1;
pub const CONFIG_XFS_SUPPORT_V4: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_DMC_TSC10: u32 = 1;
pub const CONFIG_BRIDGE_EBT_VLAN_MODULE: u32 = 1;
pub const CONFIG_SENSORS_G760A_MODULE: u32 = 1;
pub const CONFIG_CRASH_RESERVE: u32 = 1;
pub const CONFIG_SND_VIRTUOSO_MODULE: u32 = 1;
pub const CONFIG_ATH_COMMON_MODULE: u32 = 1;
pub const CONFIG_AD7816_MODULE: u32 = 1;
pub const CONFIG_UACCE_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV: u32 = 1;
pub const CONFIG_MISDN_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_SIG: u32 = 1;
pub const CONFIG_RT61PCI_MODULE: u32 = 1;
pub const CONFIG_OXP_EC_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_PCM179X_SPI_MODULE: u32 = 1;
pub const CONFIG_EFI_COCO_SECRET: u32 = 1;
pub const CONFIG_DRM_BUDDY_MODULE: u32 = 1;
pub const CONFIG_MAX8925_POWER_MODULE: u32 = 1;
pub const CONFIG_POWER_SEQUENCING_MODULE: u32 = 1;
pub const CONFIG_BT_HCIBTUSB_POLL_SYNC: u32 = 1;
pub const CONFIG_GPIO_DS4520_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_PL2303_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_MSG2638_MODULE: u32 = 1;
pub const CONFIG_TYPEC_MT6360_MODULE: u32 = 1;
pub const CONFIG_9P_FSCACHE: u32 = 1;
pub const CONFIG_AD5449_MODULE: u32 = 1;
pub const CONFIG_HID_SENSOR_PROX_MODULE: u32 = 1;
pub const CONFIG_CGROUP_PIDS: u32 = 1;
pub const CONFIG_DRM_ACCEL_AMDXDNA_MODULE: u32 = 1;
pub const CONFIG_X86_UMIP: u32 = 1;
pub const CONFIG_VIDEO_CX88_MODULE: u32 = 1;
pub const CONFIG_RMI4_F30: u32 = 1;
pub const CONFIG_SND_HDA_INTEL_HDMI_SILENT_STREAM: u32 = 1;
pub const CONFIG_PWM_IQS620A_MODULE: u32 = 1;
pub const CONFIG_NVDIMM_KEYS: u32 = 1;
pub const CONFIG_SENSORS_IBMAEM_MODULE: u32 = 1;
pub const CONFIG_SENSORS_W83L786NG_MODULE: u32 = 1;
pub const CONFIG_SOCK_VALIDATE_XMIT: u32 = 1;
pub const CONFIG_LIBETH_XDP_MODULE: u32 = 1;
pub const CONFIG_NFC_S3FWRN5_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_AZ6007_MODULE: u32 = 1;
pub const CONFIG_INTEGRITY_ASYMMETRIC_KEYS: u32 = 1;
pub const CONFIG_INSTRUCTION_DECODER: u32 = 1;
pub const CONFIG_INPUT_AD714X_I2C_MODULE: u32 = 1;
pub const CONFIG_INET6_ESP_MODULE: u32 = 1;
pub const CONFIG_HPWDT_NMI_DECODING: u32 = 1;
pub const CONFIG_FCOE_FNIC_MODULE: u32 = 1;
pub const CONFIG_FPROBE: u32 = 1;
pub const CONFIG_CAN_GW_MODULE: u32 = 1;
pub const CONFIG_NF_CONNTRACK_SIP_MODULE: u32 = 1;
pub const CONFIG_NET_RX_BUSY_POLL: u32 = 1;
pub const CONFIG_PHYSICAL_START: u32 = 16777216;
pub const CONFIG_PT_RECLAIM: u32 = 1;
pub const CONFIG_INPUT_ATI_REMOTE2_MODULE: u32 = 1;
pub const CONFIG_EDAC: u32 = 1;
pub const CONFIG_USB_CHIPIDEA_HOST: u32 = 1;
pub const CONFIG_PAHOLE_VERSION: u32 = 131;
pub const CONFIG_HTS221_SPI_MODULE: u32 = 1;
pub const CONFIG_SPI_AXI_SPI_ENGINE_MODULE: u32 = 1;
pub const CONFIG_LEDS_DAC124S085_MODULE: u32 = 1;
pub const CONFIG_SND_MPU401_MODULE: u32 = 1;
pub const CONFIG_PKCS7_MESSAGE_PARSER: u32 = 1;
pub const CONFIG_REGMAP_SLIMBUS_MODULE: u32 = 1;
pub const CONFIG_LRU_GEN_ENABLED: u32 = 1;
pub const CONFIG_ADXL355_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_SILEAD_MODULE: u32 = 1;
pub const CONFIG_PTP_1588_CLOCK_IDT82P33_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_GOODIX_BERLIN_SPI_MODULE: u32 = 1;
pub const CONFIG_PWM_CRC: u32 = 1;
pub const CONFIG_B43LEGACY_PCICORE_AUTOSELECT: u32 = 1;
pub const CONFIG_USB_CONFIGFS_PHONET: u32 = 1;
pub const CONFIG_LCD_AMS369FG06_MODULE: u32 = 1;
pub const CONFIG_ATM_FORE200E_USE_TASKLET: u32 = 1;
pub const CONFIG_MEDIA_SUPPORT_MODULE: u32 = 1;
pub const CONFIG_MOUSE_PS2_LOGIPS2PP: u32 = 1;
pub const CONFIG_I2C_DESIGNWARE_PLATFORM: u32 = 1;
pub const CONFIG_SENSORS_TSL2550_MODULE: u32 = 1;
pub const CONFIG_BPQETHER_MODULE: u32 = 1;
pub const CONFIG_CC_HAS_ENTRY_PADDING: u32 = 1;
pub const CONFIG_NET_VENDOR_SMSC: u32 = 1;
pub const CONFIG_MITIGATION_RETBLEED: u32 = 1;
pub const CONFIG_TRACE_CLOCK: u32 = 1;
pub const CONFIG_R6040_MODULE: u32 = 1;
pub const CONFIG_TCG_TIS_I2C_INFINEON_MODULE: u32 = 1;
pub const CONFIG_HAVE_KVM_IRQ_BYPASS_MODULE: u32 = 1;
pub const CONFIG_EXTCON_SM5502_MODULE: u32 = 1;
pub const CONFIG_ACPI_BUTTON: u32 = 1;
pub const CONFIG_USB_SERIAL_TI_MODULE: u32 = 1;
pub const CONFIG_FPGA_MGR_XILINX_CORE_MODULE: u32 = 1;
pub const CONFIG_CAVIUM_PTP_MODULE: u32 = 1;
pub const CONFIG_BATTERY_MAX1720X_MODULE: u32 = 1;
pub const CONFIG_NOZOMI_MODULE: u32 = 1;
pub const CONFIG_VIDEO_GC0308_MODULE: u32 = 1;
pub const CONFIG_DELL_WMI_LED_MODULE: u32 = 1;
pub const CONFIG_RTC_INTF_SYSFS: u32 = 1;
pub const CONFIG_MOUSE_PS2_FOCALTECH: u32 = 1;
pub const CONFIG_ATM_IDT77252_USE_SUNI: u32 = 1;
pub const CONFIG_PATA_HPT3X3_MODULE: u32 = 1;
pub const CONFIG_FB_NOTIFY: u32 = 1;
pub const CONFIG_QUOTA: u32 = 1;
pub const CONFIG_VIA_RHINE_MODULE: u32 = 1;
pub const CONFIG_ACPI_PRMT: u32 = 1;
pub const CONFIG_RCU_LAZY: u32 = 1;
pub const CONFIG_CRYPTO_NHPOLY1305_SSE2_MODULE: u32 = 1;
pub const CONFIG_BACKLIGHT_SKY81452_MODULE: u32 = 1;
pub const CONFIG_TCG_TIS_I2C_CR50_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_TCPMSS_MODULE: u32 = 1;
pub const CONFIG_NFT_TUNNEL_MODULE: u32 = 1;
pub const CONFIG_ADMV4420_MODULE: u32 = 1;
pub const CONFIG_ACPI_TABLE_UPGRADE: u32 = 1;
pub const CONFIG_SENSORS_LTC4282_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TLV320AIC3X_I2C_MODULE: u32 = 1;
pub const CONFIG_DVB_L64781_MODULE: u32 = 1;
pub const CONFIG_MT7663U_MODULE: u32 = 1;
pub const CONFIG_TASKS_RCU_GENERIC: u32 = 1;
pub const CONFIG_PATA_PARPORT_BPCK6_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_SHA1: u32 = 1;
pub const CONFIG_IP_SET_HASH_IPPORT_MODULE: u32 = 1;
pub const CONFIG_PREEMPT_NOTIFIERS: u32 = 1;
pub const CONFIG_UBIFS_FS_SECURITY: u32 = 1;
pub const CONFIG_INTEL_BXTWC_PMIC_TMU_MODULE: u32 = 1;
pub const CONFIG_MFD_MAX7360_MODULE: u32 = 1;
pub const CONFIG_NFC_MRVL_SPI_MODULE: u32 = 1;
pub const CONFIG_VIDEO_VP27SMPX_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ES83XX_DSM_COMMON_MODULE: u32 = 1;
pub const CONFIG_SND_VIRTIO_MODULE: u32 = 1;
pub const CONFIG_NFT_DUP_IPV6_MODULE: u32 = 1;
pub const CONFIG_FS_VERITY: u32 = 1;
pub const CONFIG_RC_ATI_REMOTE_MODULE: u32 = 1;
pub const CONFIG_PATA_ACPI_MODULE: u32 = 1;
pub const CONFIG_SMC_DIAG_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_PXRC_MODULE: u32 = 1;
pub const CONFIG_CONTEXT_TRACKING: u32 = 1;
pub const CONFIG_USB_CHAOSKEY_MODULE: u32 = 1;
pub const CONFIG_AMD_HSMP_ACPI_MODULE: u32 = 1;
pub const CONFIG_AGP_AMD64_MODULE: u32 = 1;
pub const CONFIG_NI_XGE_MANAGEMENT_ENET_MODULE: u32 = 1;
pub const CONFIG_CPU_IDLE_GOV_TEO: u32 = 1;
pub const CONFIG_SND_SOC_RT721_SDCA_SDW_MODULE: u32 = 1;
pub const CONFIG_ULI526X_MODULE: u32 = 1;
pub const CONFIG_DEVTMPFS_SAFE: u32 = 1;
pub const CONFIG_NET_EMATCH_U32_MODULE: u32 = 1;
pub const CONFIG_MEDIA_CEC_RC: u32 = 1;
pub const CONFIG_USB_SERIAL_CYBERJACK_MODULE: u32 = 1;
pub const CONFIG_GPIB_CEC_PCI_MODULE: u32 = 1;
pub const CONFIG_USB_XHCI_SIDEBAND: u32 = 1;
pub const CONFIG_TOUCHSCREEN_SIS_I2C_MODULE: u32 = 1;
pub const CONFIG_VIDEO_UPD64083_MODULE: u32 = 1;
pub const CONFIG_AL3320A_MODULE: u32 = 1;
pub const CONFIG_DVB_LGDT3305_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_SEEQ: u32 = 1;
pub const CONFIG_IP6_NF_MANGLE_MODULE: u32 = 1;
pub const CONFIG_GPIO_MAX732X_MODULE: u32 = 1;
pub const CONFIG_PARAVIRT_CLOCK: u32 = 1;
pub const CONFIG_LEDS_PCA955X_GPIO: u32 = 1;
pub const CONFIG_PAGE_IDLE_FLAG: u32 = 1;
pub const CONFIG_CRYPTO_LZ4HC_MODULE: u32 = 1;
pub const CONFIG_GPIO_TPS65912_MODULE: u32 = 1;
pub const CONFIG_TASK_IO_ACCOUNTING: u32 = 1;
pub const CONFIG_PSTORE_BLK_KMSG_SIZE: u32 = 64;
pub const CONFIG_WLAN: u32 = 1;
pub const CONFIG_PTP_DFL_TOD_MODULE: u32 = 1;
pub const CONFIG_MITIGATION_TAA: u32 = 1;
pub const CONFIG_INET6_AH_MODULE: u32 = 1;
pub const CONFIG_MOUSE_PS2_SYNAPTICS_SMBUS: u32 = 1;
pub const CONFIG_IEEE802154_6LOWPAN_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_TAG_AR9331_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_TSC200X_CORE_MODULE: u32 = 1;
pub const CONFIG_DRM_PANEL_ORIENTATION_QUIRKS: u32 = 1;
pub const CONFIG_ATH10K_USB_MODULE: u32 = 1;
pub const CONFIG_EEPROM_M24LR_MODULE: u32 = 1;
pub const CONFIG_CPU_SUP_CENTAUR: u32 = 1;
pub const CONFIG_I2C_VIA_MODULE: u32 = 1;
pub const CONFIG_SOFTLOCKUP_DETECTOR: u32 = 1;
pub const CONFIG_MPRLS0025PA_SPI_MODULE: u32 = 1;
pub const CONFIG_BT_HCIUART_BCSP: u32 = 1;
pub const CONFIG_ASUS_TF103C_DOCK_MODULE: u32 = 1;
pub const CONFIG_WLAN_VENDOR_INTERSIL: u32 = 1;
pub const CONFIG_ISL29501_MODULE: u32 = 1;
pub const CONFIG_USB4_MODULE: u32 = 1;
pub const CONFIG_MS5637_MODULE: u32 = 1;
pub const CONFIG_IP_NF_TARGET_TTL_MODULE: u32 = 1;
pub const CONFIG_COMMON_CLK_PWM_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_NFQUEUE_MODULE: u32 = 1;
pub const CONFIG_KVM_GENERIC_HARDWARE_ENABLING: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_ALC268_MODULE: u32 = 1;
pub const CONFIG_CHARGER_MAX77705_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XTABLES_LEGACY: u32 = 1;
pub const CONFIG_DVB_SP2_MODULE: u32 = 1;
pub const CONFIG_SENSORS_NCT7802_MODULE: u32 = 1;
pub const CONFIG_SPI_ZYNQMP_GQSPI_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_ISL9305_MODULE: u32 = 1;
pub const CONFIG_X86_DECODER_SELFTEST: u32 = 1;
pub const CONFIG_DVB_AU8522_MODULE: u32 = 1;
pub const CONFIG_RTL8192CE_MODULE: u32 = 1;
pub const CONFIG_SFC_SRIOV: u32 = 1;
pub const CONFIG_IR_FINTEK_MODULE: u32 = 1;
pub const CONFIG_DVB_CXD2820R_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MP29502_MODULE: u32 = 1;
pub const CONFIG_NF_SOCKET_IPV6_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_PINEPHONE_MODULE: u32 = 1;
pub const CONFIG_PCIE_DW_HOST: u32 = 1;
pub const CONFIG_ARCH_WANT_COMPAT_IPC_PARSE_VERSION: u32 = 1;
pub const CONFIG_IWLMLD_MODULE: u32 = 1;
pub const CONFIG_USB_MON_MODULE: u32 = 1;
pub const CONFIG_SND_SONICVIBES_MODULE: u32 = 1;
pub const CONFIG_EXTCON_GPIO_MODULE: u32 = 1;
pub const CONFIG_TIPC_DIAG_MODULE: u32 = 1;
pub const CONFIG_INTEL_IFS_MODULE: u32 = 1;
pub const CONFIG_DAVICOM_PHY_MODULE: u32 = 1;
pub const CONFIG_DRM_I915_FENCE_TIMEOUT: u32 = 10000;
pub const CONFIG_INET6_XFRM_TUNNEL_MODULE: u32 = 1;
pub const CONFIG_TSNEP_MODULE: u32 = 1;
pub const CONFIG_NETWORK_SECMARK: u32 = 1;
pub const CONFIG_MFD_DLN2_MODULE: u32 = 1;
pub const CONFIG_SENSORS_SY7636A_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_NEXIO: u32 = 1;
pub const CONFIG_AMD_PMC_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_IO_TRACE: u32 = 1;
pub const CONFIG_SND_TRIDENT_MODULE: u32 = 1;
pub const CONFIG_SND_OSSEMUL: u32 = 1;
pub const CONFIG_ISDN: u32 = 1;
pub const CONFIG_SND_SOC_AK4458_MODULE: u32 = 1;
pub const CONFIG_HW_RANDOM_BA431_MODULE: u32 = 1;
pub const CONFIG_MLXSW_CORE_MODULE: u32 = 1;
pub const CONFIG_SND_CMIPCI_MODULE: u32 = 1;
pub const CONFIG_PCCARD_NONSTATIC: u32 = 1;
pub const CONFIG_CRYPTO_ECDSA: u32 = 1;
pub const CONFIG_COMMON_CLK_SI544_MODULE: u32 = 1;
pub const CONFIG_DVB_DUMMY_FE_MODULE: u32 = 1;
pub const CONFIG_KVM_MODULE: u32 = 1;
pub const CONFIG_NFT_FLOW_OFFLOAD_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_CONNLIMIT_MODULE: u32 = 1;
pub const CONFIG_DEFAULT_MMAP_MIN_ADDR: u32 = 65536;
pub const CONFIG_SENSORS_LM95241_MODULE: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_936_MODULE: u32 = 1;
pub const CONFIG_SEN0322_MODULE: u32 = 1;
pub const CONFIG_GPIO_PCA953X_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_CMAC_MODULE: u32 = 1;
pub const CONFIG_TRANSPARENT_HUGEPAGE: u32 = 1;
pub const CONFIG_AIC7XXX_REG_PRETTY_PRINT: u32 = 1;
pub const CONFIG_BT_MSFTEXT: u32 = 1;
pub const CONFIG_REGULATOR_RT4803_MODULE: u32 = 1;
pub const CONFIG_AD4170_4_MODULE: u32 = 1;
pub const CONFIG_TYPEC_RT1711H_MODULE: u32 = 1;
pub const CONFIG_WLAN_VENDOR_BROADCOM: u32 = 1;
pub const CONFIG_NET_SCH_MULTIQ_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_ZET6223_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_HYNITRON_CSTXXX_MODULE: u32 = 1;
pub const CONFIG_BPF_JIT_DEFAULT_ON: u32 = 1;
pub const CONFIG_LEDS_LT3593_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_EXAR_MODULE: u32 = 1;
pub const CONFIG_SPI_DW_DMA: u32 = 1;
pub const CONFIG_QLCNIC_SRIOV: u32 = 1;
pub const CONFIG_ZRAM_WRITEBACK: u32 = 1;
pub const CONFIG_NFS_V4_MODULE: u32 = 1;
pub const CONFIG_INTEL_ISHTP_ECLITE_MODULE: u32 = 1;
pub const CONFIG_DVB_TUNER_ITD1000_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ES7134_MODULE: u32 = 1;
pub const CONFIG_NET_NSH_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV4689_MODULE: u32 = 1;
pub const CONFIG_HID_GOOGLE_STADIA_FF_MODULE: u32 = 1;
pub const CONFIG_HID_LCPOWER_MODULE: u32 = 1;
pub const CONFIG_F2FS_FS_SECURITY: u32 = 1;
pub const CONFIG_SND_AC97_CODEC_MODULE: u32 = 1;
pub const CONFIG_GENEVE_MODULE: u32 = 1;
pub const CONFIG_DVB_NXT6000_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_NBD_MODULE: u32 = 1;
pub const CONFIG_HID_SENSOR_CUSTOM_SENSOR_MODULE: u32 = 1;
pub const CONFIG_ATH9K_WOW: u32 = 1;
pub const CONFIG_IIO_ST_GYRO_SPI_3AXIS_MODULE: u32 = 1;
pub const CONFIG_KFENCE_NUM_OBJECTS: u32 = 255;
pub const CONFIG_IP_SET_HASH_NET_MODULE: u32 = 1;
pub const CONFIG_ZPA2326_SPI_MODULE: u32 = 1;
pub const CONFIG_I2C_ISMT_MODULE: u32 = 1;
pub const CONFIG_KCMP: u32 = 1;
pub const CONFIG_RTC_DRV_DS1742_MODULE: u32 = 1;
pub const CONFIG_DRM_NOUVEAU_CH7006_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ACPI_POWER_MODULE: u32 = 1;
pub const CONFIG_XFRM_ALGO_MODULE: u32 = 1;
pub const CONFIG_SD_ADC_MODULATOR_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_STMICRO: u32 = 1;
pub const CONFIG_VIDEO_INTEL_IPU6_MODULE: u32 = 1;
pub const CONFIG_IPWIRELESS_MODULE: u32 = 1;
pub const CONFIG_AX88796B_PHY_MODULE: u32 = 1;
pub const CONFIG_EDAC_SKX_MODULE: u32 = 1;
pub const CONFIG_AMD_NB: u32 = 1;
pub const CONFIG_PWM_LPSS_PCI_MODULE: u32 = 1;
pub const CONFIG_IPU_BRIDGE_MODULE: u32 = 1;
pub const CONFIG_LEDS_TRIGGER_TTY_MODULE: u32 = 1;
pub const CONFIG_BUILD_SALT: &[u8; 1] = b"\0";
pub const CONFIG_LG_LAPTOP_MODULE: u32 = 1;
pub const CONFIG_MFD_CS47L35: u32 = 1;
pub const CONFIG_ATH9K_COMMON_SPECTRAL: u32 = 1;
pub const CONFIG_SND_BT87X_MODULE: u32 = 1;
pub const CONFIG_DRM_XE_PREEMPT_TIMEOUT: u32 = 640000;
pub const CONFIG_PERF_EVENTS_AMD_POWER_MODULE: u32 = 1;
pub const CONFIG_HID_NINTENDO_MODULE: u32 = 1;
pub const CONFIG_X86_INTERNODE_CACHE_SHIFT: u32 = 6;
pub const CONFIG_SND_HDA_CODEC_CIRRUS_MODULE: u32 = 1;
pub const CONFIG_BH1780_MODULE: u32 = 1;
pub const CONFIG_GPIO_EXAR_MODULE: u32 = 1;
pub const CONFIG_DUMMY_CONSOLE_ROWS: u32 = 25;
pub const CONFIG_GPIO_VX855_MODULE: u32 = 1;
pub const CONFIG_NVME_FABRICS_MODULE: u32 = 1;
pub const CONFIG_FUNCTION_TRACER: u32 = 1;
pub const CONFIG_SURFACE_AGGREGATOR_TABLET_SWITCH_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_TCA8418_MODULE: u32 = 1;
pub const CONFIG_MEDIA_CONTROLLER_DVB: u32 = 1;
pub const CONFIG_AD5272_MODULE: u32 = 1;
pub const CONFIG_DM_DEBUG: u32 = 1;
pub const CONFIG_MODPROBE_PATH: &[u8; 15] = b"/sbin/modprobe\0";
pub const CONFIG_MLXSW_CORE_HWMON: u32 = 1;
pub const CONFIG_RTL8187_MODULE: u32 = 1;
pub const CONFIG_HID_MEGAWORLD_FF_MODULE: u32 = 1;
pub const CONFIG_MCB_LPC_MODULE: u32 = 1;
pub const CONFIG_POSIX_MQUEUE: u32 = 1;
pub const CONFIG_NV_TCO_MODULE: u32 = 1;
pub const CONFIG_SENSORS_POWR1220_MODULE: u32 = 1;
pub const CONFIG_I2C_EMEV2_MODULE: u32 = 1;
pub const CONFIG_TEXTSEARCH_FSM_MODULE: u32 = 1;
pub const CONFIG_VHOST_SCSI_MODULE: u32 = 1;
pub const CONFIG_PSTORE_BLK_MODULE: u32 = 1;
pub const CONFIG_NFSD_SCSILAYOUT: u32 = 1;
pub const CONFIG_RMI4_SMB_MODULE: u32 = 1;
pub const CONFIG_AMD_ATL_MODULE: u32 = 1;
pub const CONFIG_POWER_RESET_ATC260X_MODULE: u32 = 1;
pub const CONFIG_MQ_IOSCHED_DEADLINE: u32 = 1;
pub const CONFIG_HAVE_KVM_ARCH_GMEM_INVALIDATE: u32 = 1;
pub const CONFIG_HAVE_CLK: u32 = 1;
pub const CONFIG_USB_SERIAL_SIERRAWIRELESS_MODULE: u32 = 1;
pub const CONFIG_MAC_PARTITION: u32 = 1;
pub const CONFIG_SECURITY_APPARMOR_HASH: u32 = 1;
pub const CONFIG_SND_SOC_SIMPLE_AMPLIFIER_MODULE: u32 = 1;
pub const CONFIG_DRM_AMD_SECURE_DISPLAY: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_RT: u32 = 1;
pub const CONFIG_BATTERY_DA9030_MODULE: u32 = 1;
pub const CONFIG_DEBUG_FS: u32 = 1;
pub const CONFIG_MEDIA_CEC_SUPPORT: u32 = 1;
pub const CONFIG_SND_SOC_RT5677_MODULE: u32 = 1;
pub const CONFIG_CROS_KBD_LED_BACKLIGHT_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DS1307_MODULE: u32 = 1;
pub const CONFIG_PPTP_MODULE: u32 = 1;
pub const CONFIG_INTEL_MEI_TXE_MODULE: u32 = 1;
pub const CONFIG_FUTEX: u32 = 1;
pub const CONFIG_DM_VDO_MODULE: u32 = 1;
pub const CONFIG_USB_ETH_EEM: u32 = 1;
pub const CONFIG_HID_GLORIOUS_MODULE: u32 = 1;
pub const CONFIG_TSYS01_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_WACOM_W8001_MODULE: u32 = 1;
pub const CONFIG_IP_SET_MAX: u32 = 256;
pub const CONFIG_ASYNC_CORE_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_SM4_MODULE: u32 = 1;
pub const CONFIG_RTW88_DEBUG: u32 = 1;
pub const CONFIG_ADIS16475_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_MAX98504_MODULE: u32 = 1;
pub const CONFIG_ATALK_MODULE: u32 = 1;
pub const CONFIG_NF_TABLES_INET: u32 = 1;
pub const CONFIG_TCM_USER2_MODULE: u32 = 1;
pub const CONFIG_VIDEO_TDA9840_MODULE: u32 = 1;
pub const CONFIG_NEED_PER_CPU_EMBED_FIRST_CHUNK: u32 = 1;
pub const CONFIG_RTC_DRV_TPS65910_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ZL38060_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_XPAD_LEDS: u32 = 1;
pub const CONFIG_RTC_DRV_DS1685: u32 = 1;
pub const CONFIG_USB_LCD_MODULE: u32 = 1;
pub const CONFIG_NTB_MSI: u32 = 1;
pub const CONFIG_CM3232_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_CURRENT_STACK_POINTER: u32 = 1;
pub const CONFIG_SENSORS_CHIPCAP2_MODULE: u32 = 1;
pub const CONFIG_FB_SYSMEM_HELPERS: u32 = 1;
pub const CONFIG_REGULATOR_LP8755_MODULE: u32 = 1;
pub const CONFIG_MAX63XX_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_PNP: u32 = 1;
pub const CONFIG_USBIP_VHCI_NR_HCS: u32 = 1;
pub const CONFIG_SND_SOC_AMD_ACP_PCI_MODULE: u32 = 1;
pub const CONFIG_PCMCIA_SYM53C500_MODULE: u32 = 1;
pub const CONFIG_DELL_WMI_DDV_MODULE: u32 = 1;
pub const CONFIG_BE2NET_LANCER: u32 = 1;
pub const CONFIG_AD2S90_MODULE: u32 = 1;
pub const CONFIG_USB_ETH_RNDIS: u32 = 1;
pub const CONFIG_ADIS16460_MODULE: u32 = 1;
pub const CONFIG_HAVE_FUNCTION_ERROR_INJECTION: u32 = 1;
pub const CONFIG_CAN_CTUCANFD_PCI_MODULE: u32 = 1;
pub const CONFIG_RADIO_SHARK_MODULE: u32 = 1;
pub const CONFIG_LEDS_BD2606MVV_MODULE: u32 = 1;
pub const CONFIG_XILINX_XADC_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_DENVERTON_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_PIXCIR_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CX2072X_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_SENSEHAT_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX1668_MODULE: u32 = 1;
pub const CONFIG_MEGARAID_MM_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ADAU7118_I2C_MODULE: u32 = 1;
pub const CONFIG_MISDN_L1OIP_MODULE: u32 = 1;
pub const CONFIG_ROHM_BD79124_MODULE: u32 = 1;
pub const CONFIG_HAS_DMA: u32 = 1;
pub const CONFIG_FB_VESA: u32 = 1;
pub const CONFIG_SOFTIRQ_ON_OWN_STACK: u32 = 1;
pub const CONFIG_OPT3001_MODULE: u32 = 1;
pub const CONFIG_SENSORS_TDA38640_MODULE: u32 = 1;
pub const CONFIG_SND_MONA_MODULE: u32 = 1;
pub const CONFIG_W1_SLAVE_DS2413_MODULE: u32 = 1;
pub const CONFIG_MLX4_EN_MODULE: u32 = 1;
pub const CONFIG_ARCH_WANT_BATCHED_UNMAP_TLB_FLUSH: u32 = 1;
pub const CONFIG_SX9324_MODULE: u32 = 1;
pub const CONFIG_LENOVO_WMI_EVENTS_MODULE: u32 = 1;
pub const CONFIG_DRM_XEN_FRONTEND_MODULE: u32 = 1;
pub const CONFIG_USE_X86_SEG_SUPPORT: u32 = 1;
pub const CONFIG_CRYPTO_USER_API_MODULE: u32 = 1;
pub const CONFIG_AUDITSYSCALL: u32 = 1;
pub const CONFIG_REGULATOR_MAX8907_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_ST_ES8336_MACH_MODULE: u32 = 1;
pub const CONFIG_STACKDEPOT: u32 = 1;
pub const CONFIG_CHARGER_LTC4162L_MODULE: u32 = 1;
pub const CONFIG_IP_SET_BITMAP_IPMAC_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_ALC269_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TLV320AIC3X_MODULE: u32 = 1;
pub const CONFIG_KEBA_LAN9252_MODULE: u32 = 1;
pub const CONFIG_PHY_PXA_28NM_HSIC_MODULE: u32 = 1;
pub const CONFIG_USB_USS720_MODULE: u32 = 1;
pub const CONFIG_PTP_1588_CLOCK_OCP_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_IONIC_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_ACPI_TABLE_UPGRADE: u32 = 1;
pub const CONFIG_MAX11100_MODULE: u32 = 1;
pub const CONFIG_USB_CDNS_SUPPORT_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_TOUCHIT213_MODULE: u32 = 1;
pub const CONFIG_GENERIC_BUG: u32 = 1;
pub const CONFIG_XFS_MEMORY_BUFS: u32 = 1;
pub const CONFIG_TEE_DMABUF_HEAPS: u32 = 1;
pub const CONFIG_IP_VS_MODULE: u32 = 1;
pub const CONFIG_SND_LOLA_MODULE: u32 = 1;
pub const CONFIG_MOUSE_ELAN_I2C_I2C: u32 = 1;
pub const CONFIG_USB_WDM_MODULE: u32 = 1;
pub const CONFIG_TCP_CONG_ILLINOIS_MODULE: u32 = 1;
pub const CONFIG_GPIO_PISOSR_MODULE: u32 = 1;
pub const CONFIG_BT_RFCOMM_TTY: u32 = 1;
pub const CONFIG_BT_ATH3K_MODULE: u32 = 1;
pub const CONFIG_AD3552R_MODULE: u32 = 1;
pub const CONFIG_VFIO_DEBUGFS: u32 = 1;
pub const CONFIG_USBIP_CORE_MODULE: u32 = 1;
pub const CONFIG_UNION_FIND: u32 = 1;
pub const CONFIG_BRCMUTIL_MODULE: u32 = 1;
pub const CONFIG_BTRFS_FS: u32 = 1;
pub const CONFIG_KVFREE_RCU_BATCHED: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_REALTEK_MODULE: u32 = 1;
pub const CONFIG_DRM_I915_GVT: u32 = 1;
pub const CONFIG_MFD_INTEL_PMC_BXT_MODULE: u32 = 1;
pub const CONFIG_IP_VS_IPV6: u32 = 1;
pub const CONFIG_REGULATOR_TPS65910_MODULE: u32 = 1;
pub const CONFIG_CPU_FREQ_GOV_COMMON: u32 = 1;
pub const CONFIG_PPP_MPPE_MODULE: u32 = 1;
pub const CONFIG_SCSI_QLA_FC_MODULE: u32 = 1;
pub const CONFIG_HAVE_ALIGNED_STRUCT_PAGE: u32 = 1;
pub const CONFIG_THUNDER_NIC_VF_MODULE: u32 = 1;
pub const CONFIG_CB710_CORE_MODULE: u32 = 1;
pub const CONFIG_FUSE_IO_URING: u32 = 1;
pub const CONFIG_SCHED_OMIT_FRAME_POINTER: u32 = 1;
pub const CONFIG_CEPH_LIB_MODULE: u32 = 1;
pub const CONFIG_LEGACY_DIRECT_IO: u32 = 1;
pub const CONFIG_BATMAN_ADV_MCAST: u32 = 1;
pub const CONFIG_LOCK_SPIN_ON_OWNER: u32 = 1;
pub const CONFIG_HAVE_PERF_USER_STACK_DUMP: u32 = 1;
pub const CONFIG_SENSORS_ASB100_MODULE: u32 = 1;
pub const CONFIG_GPIO_IDIO_16_MODULE: u32 = 1;
pub const CONFIG_NVME_CORE_MODULE: u32 = 1;
pub const CONFIG_NVME_VERBOSE_ERRORS: u32 = 1;
pub const CONFIG_GPIB_MODULE: u32 = 1;
pub const CONFIG_AMD_PHY_MODULE: u32 = 1;
pub const CONFIG_USB_PCI_AMD: u32 = 1;
pub const CONFIG_VIDEO_OV13B10_MODULE: u32 = 1;
pub const CONFIG_SENSORS_AXI_FAN_CONTROL_MODULE: u32 = 1;
pub const CONFIG_NF_CT_NETLINK_TIMEOUT_MODULE: u32 = 1;
pub const CONFIG_OPTPROBES: u32 = 1;
pub const CONFIG_B43LEGACY_DMA: u32 = 1;
pub const CONFIG_SKB_EXTENSIONS: u32 = 1;
pub const CONFIG_HUGETLB_PAGE: u32 = 1;
pub const CONFIG_DEBUG_RODATA_TEST: u32 = 1;
pub const CONFIG_SND_SOC_TAS5805M_MODULE: u32 = 1;
pub const CONFIG_HMEM_REPORTING: u32 = 1;
pub const CONFIG_SND_SOC_ES8328_SPI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_MAX98088_MODULE: u32 = 1;
pub const CONFIG_XFRM_INTERFACE_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_RANDOMIZE_KSTACK_OFFSET: u32 = 1;
pub const CONFIG_LEDS_LP8788_MODULE: u32 = 1;
pub const CONFIG_SERIAL_CORE: u32 = 1;
pub const CONFIG_SND_SOC_WM8580_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_GP8PSK_MODULE: u32 = 1;
pub const CONFIG_ROSE_MODULE: u32 = 1;
pub const CONFIG_HOTPLUG_PCI_PCIE: u32 = 1;
pub const CONFIG_NFS_USE_KERNEL_DNS: u32 = 1;
pub const CONFIG_MLX_WDT_MODULE: u32 = 1;
pub const CONFIG_SPI_LOOPBACK_TEST_MODULE: u32 = 1;
pub const CONFIG_USB_OXU210HP_HCD_MODULE: u32 = 1;
pub const CONFIG_NO_HZ_FULL: u32 = 1;
pub const CONFIG_PINCTRL_CS47L15: u32 = 1;
pub const CONFIG_CAN_SOFTING_CS_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MP5023_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SDCA_OPTIONAL_MODULE: u32 = 1;
pub const CONFIG_DRM_I915_CAPTURE_ERROR: u32 = 1;
pub const CONFIG_TAHVO_USB_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS35L45_I2C_MODULE: u32 = 1;
pub const CONFIG_LEDS_TRIGGERS: u32 = 1;
pub const CONFIG_NET_SCH_TBF_MODULE: u32 = 1;
pub const CONFIG_SECURITY_NETWORK_XFRM: u32 = 1;
pub const CONFIG_BRCMSMAC_MODULE: u32 = 1;
pub const CONFIG_CAN_MCP251X_MODULE: u32 = 1;
pub const CONFIG_UBIFS_FS_LZO: u32 = 1;
pub const CONFIG_SND_SOC_WM8731_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LTC2945_MODULE: u32 = 1;
pub const CONFIG_INTEL_TDX_GUEST: u32 = 1;
pub const CONFIG_EROFS_FS_ZIP_ACCEL: u32 = 1;
pub const CONFIG_INTEL_ISH_HID_MODULE: u32 = 1;
pub const CONFIG_TI_ADS1119_MODULE: u32 = 1;
pub const CONFIG_MLX5_CORE_MODULE: u32 = 1;
pub const CONFIG_GENERIC_IRQ_STAT_SNAPSHOT: u32 = 1;
pub const CONFIG_NET_KEY_MODULE: u32 = 1;
pub const CONFIG_REMOTE_TARGET_MODULE: u32 = 1;
pub const CONFIG_SERIAL_MCTRL_GPIO: u32 = 1;
pub const CONFIG_ZIIRAVE_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SIGMADSP_I2C_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_TAG_HELLCREEK_MODULE: u32 = 1;
pub const CONFIG_THERMAL_GOV_POWER_ALLOCATOR: u32 = 1;
pub const CONFIG_SERIO_PARKBD_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_ZC3XX_MODULE: u32 = 1;
pub const CONFIG_MMC_TOSHIBA_PCI_MODULE: u32 = 1;
pub const CONFIG_X86_MSR: u32 = 1;
pub const CONFIG_CRYPTO_CCM_MODULE: u32 = 1;
pub const CONFIG_SATA_PROMISE_MODULE: u32 = 1;
pub const CONFIG_SCSI_INIA100_MODULE: u32 = 1;
pub const CONFIG_VIDEO_INTEL_IPU7_MODULE: u32 = 1;
pub const CONFIG_QLCNIC_MODULE: u32 = 1;
pub const CONFIG_EROFS_FS_ZIP_DEFLATE: u32 = 1;
pub const CONFIG_IP_VS_NQ_MODULE: u32 = 1;
pub const CONFIG_PRESTERA_PCI_MODULE: u32 = 1;
pub const CONFIG_CODA_FS_MODULE: u32 = 1;
pub const CONFIG_SPEAKUP_SYNTH_AUDPTR_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_IQS62X_MODULE: u32 = 1;
pub const CONFIG_XEN_DEV_EVTCHN_MODULE: u32 = 1;
pub const CONFIG_DWC_XLGMAC_PCI_MODULE: u32 = 1;
pub const CONFIG_INTEL_CHTWC_INT33FE_MODULE: u32 = 1;
pub const CONFIG_SND_RAWMIDI_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_SIDEWINDER_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SOF_PCM512x_MACH_MODULE: u32 = 1;
pub const CONFIG_GENERIC_GETTIMEOFDAY: u32 = 1;
pub const CONFIG_TOUCHSCREEN_WM9705: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_KEXEC_JUMP: u32 = 1;
pub const CONFIG_IP_SET_HASH_IPMARK_MODULE: u32 = 1;
pub const CONFIG_IIO_CROS_EC_SENSORS_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_JASPERLAKE_MODULE: u32 = 1;
pub const CONFIG_FW_UPLOAD: u32 = 1;
pub const CONFIG_HAVE_KVM_NO_POLL: u32 = 1;
pub const CONFIG_ATM_SOLOS_MODULE: u32 = 1;
pub const CONFIG_QEDE_MODULE: u32 = 1;
pub const CONFIG_SND_USB: u32 = 1;
pub const CONFIG_NET_DSA_SJA1105_PTP: u32 = 1;
pub const CONFIG_NET_ACT_CT_MODULE: u32 = 1;
pub const CONFIG_INTEL_PMC_SSRAM_TELEMETRY_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CX18_ALSA_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_TV8532_MODULE: u32 = 1;
pub const CONFIG_DPTF_POWER_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_RTL28XXU_MODULE: u32 = 1;
pub const CONFIG_ARCH_MIGHT_HAVE_ACPI_PDC: u32 = 1;
pub const CONFIG_PCS_XPCS_MODULE: u32 = 1;
pub const CONFIG_CAN_C_CAN_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SOF_DA7219_MACH_MODULE: u32 = 1;
pub const CONFIG_ND_CLAIM: u32 = 1;
pub const CONFIG_BRCMFMAC_PROTO_MSGBUF: u32 = 1;
pub const CONFIG_GPIO_CDEV_V1: u32 = 1;
pub const CONFIG_SYN_COOKIES: u32 = 1;
pub const CONFIG_SND_SOC_SIGMADSP_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_IPOIB_CM: u32 = 1;
pub const CONFIG_ARCH_HAS_FORTIFY_SOURCE: u32 = 1;
pub const CONFIG_DRM_PANIC_SCREEN_QR_VERSION: u32 = 40;
pub const CONFIG_MT7663S_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_SCTP_MODULE: u32 = 1;
pub const CONFIG_HID_GEMBIRD_MODULE: u32 = 1;
pub const CONFIG_NF_FLOW_TABLE_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_SHA3: u32 = 1;
pub const CONFIG_NFC_SIM_MODULE: u32 = 1;
pub const CONFIG_SND_PCMTEST_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_QUALCOMM: u32 = 1;
pub const CONFIG_STACKTRACE_SUPPORT: u32 = 1;
pub const CONFIG_WIRELESS_EXT: u32 = 1;
pub const CONFIG_JOYSTICK_ADC_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_HDA_MODULE: u32 = 1;
pub const CONFIG_NFT_DUP_IPV4_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_CONNMARK_MODULE: u32 = 1;
pub const CONFIG_PCIEASPM_DEFAULT: u32 = 1;
pub const CONFIG_USB_EHSET_TEST_FIXTURE_MODULE: u32 = 1;
pub const CONFIG_FPGA_MODULE: u32 = 1;
pub const CONFIG_SND_MODULE: u32 = 1;
pub const CONFIG_SENSORS_W83627EHF_MODULE: u32 = 1;
pub const CONFIG_SENSORS_IR38064_MODULE: u32 = 1;
pub const CONFIG_MEGARAID_LEGACY_MODULE: u32 = 1;
pub const CONFIG_MD_LINEAR_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_HDA_DSP_COMMON_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_AEAD_MODULE: u32 = 1;
pub const CONFIG_IEEE802154_MRF24J40_MODULE: u32 = 1;
pub const CONFIG_BCMGENET_MODULE: u32 = 1;
pub const CONFIG_MAX31856_MODULE: u32 = 1;
pub const CONFIG_CHARGER_RT9471_MODULE: u32 = 1;
pub const CONFIG_ACPI_QUICKSTART_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_THROTTLING: u32 = 1;
pub const CONFIG_PDS_VFIO_PCI_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_TAG_LAN9303_MODULE: u32 = 1;
pub const CONFIG_CHTCRC_PMIC_OPREGION: u32 = 1;
pub const CONFIG_SND_SOC_ADAU_UTILS_MODULE: u32 = 1;
pub const CONFIG_SECTION_MISMATCH_WARN_ONLY: u32 = 1;
pub const CONFIG_ASYNC_XOR_MODULE: u32 = 1;
pub const CONFIG_INTEL_IOMMU: u32 = 1;
pub const CONFIG_PROC_CHILDREN: u32 = 1;
pub const CONFIG_INET_MPTCP_DIAG_MODULE: u32 = 1;
pub const CONFIG_FPGA_DFL_AFU_MODULE: u32 = 1;
pub const CONFIG_DRM_DISPLAY_HDCP_HELPER: u32 = 1;
pub const CONFIG_CC_IS_GCC: u32 = 1;
pub const CONFIG_SQUASHFS_FILE_DIRECT: u32 = 1;
pub const CONFIG_GPIO_TPS65910: u32 = 1;
pub const CONFIG_AX25_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SOF_NAU8825_MACH_MODULE: u32 = 1;
pub const CONFIG_VSOCKETS_LOOPBACK_MODULE: u32 = 1;
pub const CONFIG_MPL115_SPI_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_SUNKBD_MODULE: u32 = 1;
pub const CONFIG_VIDEO_MXB_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_UBLK_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_SYNC_CORE_BEFORE_USERMODE: u32 = 1;
pub const CONFIG_CARDBUS: u32 = 1;
pub const CONFIG_RTW89_DEBUGFS: u32 = 1;
pub const CONFIG_SENSORS_IIO_HWMON_MODULE: u32 = 1;
pub const CONFIG_HAVE_CMPXCHG_LOCAL: u32 = 1;
pub const CONFIG_JOYSTICK_COBRA_MODULE: u32 = 1;
pub const CONFIG_HID_APPLETB_BL_MODULE: u32 = 1;
pub const CONFIG_INITRAMFS_PRESERVE_MTIME: u32 = 1;
pub const CONFIG_DELL_LAPTOP_MODULE: u32 = 1;
pub const CONFIG_X86_HV_CALLBACK_VECTOR: u32 = 1;
pub const CONFIG_MLXREG_IO_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_3W_XXXX_RAID_MODULE: u32 = 1;
pub const CONFIG_X86_X2APIC: u32 = 1;
pub const CONFIG_FPGA_MGR_ALTERA_PS_SPI_MODULE: u32 = 1;
pub const CONFIG_ADIS16260_MODULE: u32 = 1;
pub const CONFIG_RPMB_MODULE: u32 = 1;
pub const CONFIG_IPV6_ROUTER_PREF: u32 = 1;
pub const CONFIG_CGROUP_SCHED: u32 = 1;
pub const CONFIG_DMA_ENGINE: u32 = 1;
pub const CONFIG_VIRTIO_DEBUG: u32 = 1;
pub const CONFIG_FPGA_REGION_MODULE: u32 = 1;
pub const CONFIG_DA280_MODULE: u32 = 1;
pub const CONFIG_AMD_ISP_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_SENSORS_RM3100_SPI_MODULE: u32 = 1;
pub const CONFIG_XEN_WDT_MODULE: u32 = 1;
pub const CONFIG_MAX44009_MODULE: u32 = 1;
pub const CONFIG_SND_VIA82XX_MODULE: u32 = 1;
pub const CONFIG_DVB_TDA10048_MODULE: u32 = 1;
pub const CONFIG_SENSIRION_SGP30_MODULE: u32 = 1;
pub const CONFIG_EARLY_PRINTK: u32 = 1;
pub const CONFIG_F2FS_FS_COMPRESSION: u32 = 1;
pub const CONFIG_IP_SET_HASH_MAC_MODULE: u32 = 1;
pub const CONFIG_MFD_CS47L85: u32 = 1;
pub const CONFIG_NET_DSA_LOOP_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_CRC32C: u32 = 1;
pub const CONFIG_PM_STD_PARTITION: &[u8; 1] = b"\0";
pub const CONFIG_MOUSE_PS2_ELANTECH_SMBUS: u32 = 1;
pub const CONFIG_L2TP_IP_MODULE: u32 = 1;
pub const CONFIG_WATCHDOG_PRETIMEOUT_DEFAULT_GOV_PANIC: u32 = 1;
pub const CONFIG_DM_ZONED_MODULE: u32 = 1;
pub const CONFIG_SND_INDIGODJ_MODULE: u32 = 1;
pub const CONFIG_CHARGER_SBS_MODULE: u32 = 1;
pub const CONFIG_RD_BZIP2: u32 = 1;
pub const CONFIG_SCSI_3W_9XXX_MODULE: u32 = 1;
pub const CONFIG_WILCO_EC_TELEMETRY_MODULE: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_1250_MODULE: u32 = 1;
pub const CONFIG_GPIO_IT87_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_MAX2165_MODULE: u32 = 1;
pub const CONFIG_DVB_LNBP22_MODULE: u32 = 1;
pub const CONFIG_ECRYPT_FS_MODULE: u32 = 1;
pub const CONFIG_FRAMEBUFFER_CONSOLE_DEFERRED_TAKEOVER: u32 = 1;
pub const CONFIG_PHYS_ADDR_T_64BIT: u32 = 1;
pub const CONFIG_USB_F_NCM_MODULE: u32 = 1;
pub const CONFIG_UVC_COMMON_MODULE: u32 = 1;
pub const CONFIG_HAVE_FUNCTION_GRAPH_TRACER: u32 = 1;
pub const CONFIG_BPF_UNPRIV_DEFAULT_OFF: u32 = 1;
pub const CONFIG_USB_GSPCA_OV534_9_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_MID_MODULE: u32 = 1;
pub const CONFIG_MFD_TPS6594_I2C_MODULE: u32 = 1;
pub const CONFIG_SCSI_IPR_TRACE: u32 = 1;
pub const CONFIG_BAYCOM_PAR_MODULE: u32 = 1;
pub const CONFIG_CGROUP_BPF: u32 = 1;
pub const CONFIG_ANDROID_BINDER_IPC_RUST: u32 = 1;
pub const CONFIG_MT76_LEDS: u32 = 1;
pub const CONFIG_IIO_ST_LSM9DS0_SPI_MODULE: u32 = 1;
pub const CONFIG_BT_AOSPEXT: u32 = 1;
pub const CONFIG_NET_SCH_CBS_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_ERDMA_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TDA7419_MODULE: u32 = 1;
pub const CONFIG_HIDRAW: u32 = 1;
pub const CONFIG_X86_MCE: u32 = 1;
pub const CONFIG_MSPRO_BLOCK_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_AF9005_REMOTE_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DES_MODULE: u32 = 1;
pub const CONFIG_IR_NEC_DECODER_MODULE: u32 = 1;
pub const CONFIG_LOCK_DEBUGGING_SUPPORT: u32 = 1;
pub const CONFIG_VIDEOBUF2_DMA_CONTIG_MODULE: u32 = 1;
pub const CONFIG_ATH10K_PCI_MODULE: u32 = 1;
pub const CONFIG_MCTP: u32 = 1;
pub const CONFIG_SBC_EPX_C3_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_SCSI_ISCSI_ATTRS_MODULE: u32 = 1;
pub const CONFIG_SECURITY_SELINUX_SID2STR_CACHE_SIZE: u32 = 256;
pub const CONFIG_TWL6030_GPADC_MODULE: u32 = 1;
pub const CONFIG_SERIAL_UARTLITE_NR_UARTS: u32 = 1;
pub const CONFIG_P54_LEDS: u32 = 1;
pub const CONFIG_BUG: u32 = 1;
pub const CONFIG_USB_EG20T_MODULE: u32 = 1;
pub const CONFIG_JFFS2_RTIME: u32 = 1;
pub const CONFIG_DVB_AU8522_V4L_MODULE: u32 = 1;
pub const CONFIG_QCOM_TZMEM_MODE_GENERIC: u32 = 1;
pub const CONFIG_IPVTAP_MODULE: u32 = 1;
pub const CONFIG_SPI_LM70_LLP_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SOF_WM8804_MACH_MODULE: u32 = 1;
pub const CONFIG_VIDEO_MT9P031_MODULE: u32 = 1;
pub const CONFIG_M62332_MODULE: u32 = 1;
pub const CONFIG_MEMORY: u32 = 1;
pub const CONFIG_GDB_SCRIPTS: u32 = 1;
pub const CONFIG_SENSORS_ABITUGURU_MODULE: u32 = 1;
pub const CONFIG_TTPCI_EEPROM_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT715_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_SYNOPSYS: u32 = 1;
pub const CONFIG_ARCH_HAS_GCOV_PROFILE_ALL: u32 = 1;
pub const CONFIG_DMARD09_MODULE: u32 = 1;
pub const CONFIG_AF_KCM_MODULE: u32 = 1;
pub const CONFIG_SND_SYNTH_EMUX_MODULE: u32 = 1;
pub const CONFIG_INPUT_MMA8450_MODULE: u32 = 1;
pub const CONFIG_INTEL_RST_MODULE: u32 = 1;
pub const CONFIG_MFD_MAX8907_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SOF_SSP_AMP_MACH_MODULE: u32 = 1;
pub const CONFIG_PATA_RADISYS_MODULE: u32 = 1;
pub const CONFIG_NFC_SHDLC: u32 = 1;
pub const CONFIG_XZ_DEC_BCJ: u32 = 1;
pub const CONFIG_USB_SERIAL_OTI6858_MODULE: u32 = 1;
pub const CONFIG_QRTR_TUN_MODULE: u32 = 1;
pub const CONFIG_DRM_KMS_HELPER: u32 = 1;
pub const CONFIG_MOUSE_PS2_BYD: u32 = 1;
pub const CONFIG_CHELSIO_T4_DCB: u32 = 1;
pub const CONFIG_MISDN_ISAR_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_HDAC_HDA_MODULE: u32 = 1;
pub const CONFIG_SENSORS_DA9055_MODULE: u32 = 1;
pub const CONFIG_TCS3472_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_TCPOPTSTRIP_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_USERFAULTFD_WP: u32 = 1;
pub const CONFIG_FB_SYSMEM_FOPS: u32 = 1;
pub const CONFIG_X86_MCE_INTEL: u32 = 1;
pub const CONFIG_SND_SOC_SOF_INTEL_CNL_MODULE: u32 = 1;
pub const CONFIG_PAGE_REPORTING: u32 = 1;
pub const CONFIG_MOUSE_PS2_TRACKPOINT: u32 = 1;
pub const CONFIG_SCHED_HRTICK: u32 = 1;
pub const CONFIG_TRACING_SUPPORT: u32 = 1;
pub const CONFIG_INFINIBAND_BNXT_RE_MODULE: u32 = 1;
pub const CONFIG_WILCO_EC_EVENTS_MODULE: u32 = 1;
pub const CONFIG_IOMMU_MM_DATA: u32 = 1;
pub const CONFIG_MPLS: u32 = 1;
pub const CONFIG_SERIAL_SC16IS7XX_I2C_MODULE: u32 = 1;
pub const CONFIG_STACK_TRACER: u32 = 1;
pub const CONFIG_SND_UMP_LEGACY_RAWMIDI: u32 = 1;
pub const CONFIG_MAX1118_MODULE: u32 = 1;
pub const CONFIG_USB_F_SS_LB_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_HL_MODULE: u32 = 1;
pub const CONFIG_ISA_DMA_API: u32 = 1;
pub const CONFIG_NET_ACT_SKBMOD_MODULE: u32 = 1;
pub const CONFIG_LEDS_LP50XX_MODULE: u32 = 1;
pub const CONFIG_USB_EHCI_PCI: u32 = 1;
pub const CONFIG_EDAC_PND2_MODULE: u32 = 1;
pub const CONFIG_CHARGER_ADP5061_MODULE: u32 = 1;
pub const CONFIG_MFD_RT5033_MODULE: u32 = 1;
pub const CONFIG_DRM_DISPLAY_DP_TUNNEL: u32 = 1;
pub const CONFIG_ACPI_HMAT: u32 = 1;
pub const CONFIG_RUST_OVERFLOW_CHECKS: u32 = 1;
pub const CONFIG_REGULATOR_RT5120_MODULE: u32 = 1;
pub const CONFIG_GNSS_SIRF_SERIAL_MODULE: u32 = 1;
pub const CONFIG_IP_SET_HASH_IP_MODULE: u32 = 1;
pub const CONFIG_VIRTIO_MENU: u32 = 1;
pub const CONFIG_RTC_DRV_RX8581_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_HDA_AUDIO_CODEC: u32 = 1;
pub const CONFIG_SND_SOC_AMD_PS_MACH_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_MRP: u32 = 1;
pub const CONFIG_NVME_TARGET_TCP_TLS: u32 = 1;
pub const CONFIG_SURFACE_PRO3_BUTTON_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_CADENCE: u32 = 1;
pub const CONFIG_NFT_BRIDGE_META_MODULE: u32 = 1;
pub const CONFIG_SPLIT_PTE_PTLOCKS: u32 = 1;
pub const CONFIG_SND_SOC_RT9120_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_WRITE_MOUNTED: u32 = 1;
pub const CONFIG_CRYPTO_DEV_NITROX_CNN55XX_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_BROCADE: u32 = 1;
pub const CONFIG_HAVE_ARCH_KSTACK_ERASE: u32 = 1;
pub const CONFIG_MT76x02_USB_MODULE: u32 = 1;
pub const CONFIG_USB_NET_SMSC75XX_MODULE: u32 = 1;
pub const CONFIG_ROMFS_BACKED_BY_BLOCK: u32 = 1;
pub const CONFIG_SENSORS_K10TEMP_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DS1305_MODULE: u32 = 1;
pub const CONFIG_SENSORS_BH1770_MODULE: u32 = 1;
pub const CONFIG_ALTERA_PR_IP_CORE_MODULE: u32 = 1;
pub const CONFIG_ADXL372_MODULE: u32 = 1;
pub const CONFIG_SURFACE_ACPI_NOTIFY_MODULE: u32 = 1;
pub const CONFIG_MCB_PCI_MODULE: u32 = 1;
pub const CONFIG_HAVE_IOREMAP_PROT: u32 = 1;
pub const CONFIG_CC_NO_STRINGOP_OVERFLOW: u32 = 1;
pub const CONFIG_SECURITY_APPARMOR: u32 = 1;
pub const CONFIG_DRM_UDL_MODULE: u32 = 1;
pub const CONFIG_LEDS_TRIGGER_TIMER_MODULE: u32 = 1;
pub const CONFIG_MMC_REALTEK_USB_MODULE: u32 = 1;
pub const CONFIG_INTEGRITY_AUDIT: u32 = 1;
pub const CONFIG_VIRTIO_FS: u32 = 1;
pub const CONFIG_B53_MMAP_DRIVER_MODULE: u32 = 1;
pub const CONFIG_SECURITY_SMACK_NETFILTER: u32 = 1;
pub const CONFIG_TOUCHSCREEN_AD7879_MODULE: u32 = 1;
pub const CONFIG_NET_SELFTESTS_MODULE: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_MEMORY_FAILURE: u32 = 1;
pub const CONFIG_CRASH_HOTPLUG: u32 = 1;
pub const CONFIG_DW_DMAC_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_AMD_SOUNDWIRE_MODULE: u32 = 1;
pub const CONFIG_SENSORS_GL520SM_MODULE: u32 = 1;
pub const CONFIG_USB_CONFIGFS_F_LB_SS: u32 = 1;
pub const CONFIG_CRYPTO_DEV_ATMEL_I2C_MODULE: u32 = 1;
pub const CONFIG_CC10001_ADC_MODULE: u32 = 1;
pub const CONFIG_ARCH_WANT_PMD_MKWRITE: u32 = 1;
pub const CONFIG_USB_SERIAL_QCAUX_MODULE: u32 = 1;
pub const CONFIG_SENSORS_AD7314_MODULE: u32 = 1;
pub const CONFIG_6LOWPAN_DEBUGFS: u32 = 1;
pub const CONFIG_I2C_STUB_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_MSCC_FELIX_DSA_LIB_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_MACH_COMMON_MODULE: u32 = 1;
pub const CONFIG_MOST_MODULE: u32 = 1;
pub const CONFIG_BATTERY_DA9150_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_GARMIN_MODULE: u32 = 1;
pub const CONFIG_MITIGATION_RFDS: u32 = 1;
pub const CONFIG_LCD_TDO24M_MODULE: u32 = 1;
pub const CONFIG_SIEMENS_SIMATIC_IPC_BATT_ELKHARTLAKE_MODULE: u32 = 1;
pub const CONFIG_CHT_DC_TI_PMIC_OPREGION: u32 = 1;
pub const CONFIG_INTEL_PMT_TELEMETRY_MODULE: u32 = 1;
pub const CONFIG_USB_CYPRESS_CY7C63_MODULE: u32 = 1;
pub const CONFIG_QLA3XXX_MODULE: u32 = 1;
pub const CONFIG_AS_HAS_NON_CONST_ULEB128: u32 = 1;
pub const CONFIG_AD525X_DPOT_SPI_MODULE: u32 = 1;
pub const CONFIG_RTL8187_LEDS: u32 = 1;
pub const CONFIG_F2FS_UNFAIR_RWSEM: u32 = 1;
pub const CONFIG_US5182D_MODULE: u32 = 1;
pub const CONFIG_INTEL_SOC_DTS_IOSF_CORE_MODULE: u32 = 1;
pub const CONFIG_MISDN_AVMFRITZ_MODULE: u32 = 1;
pub const CONFIG_CHARGER_RT9467_MODULE: u32 = 1;
pub const CONFIG_LLD_VERSION: u32 = 0;
pub const CONFIG_ENS210_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_CHERRYVIEW: u32 = 1;
pub const CONFIG_USB_STORAGE_ONETOUCH_MODULE: u32 = 1;
pub const CONFIG_REMOTEPROC: u32 = 1;
pub const CONFIG_I2C_VIAPRO_MODULE: u32 = 1;
pub const CONFIG_OCFS2_FS_O2CB_MODULE: u32 = 1;
pub const CONFIG_6LOWPAN_NHC_DEST_MODULE: u32 = 1;
pub const CONFIG_W1_MODULE: u32 = 1;
pub const CONFIG_ALTERA_MBOX_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_HASH: u32 = 1;
pub const CONFIG_MOST_NET_MODULE: u32 = 1;
pub const CONFIG_SND_USB_UA101_MODULE: u32 = 1;
pub const CONFIG_GROUP_SCHED_BANDWIDTH: u32 = 1;
pub const CONFIG_SND_SOC_AMD_RENOIR_MODULE: u32 = 1;
pub const CONFIG_MLXSW_CORE_THERMAL: u32 = 1;
pub const CONFIG_MTD_INTEL_DG_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_AUTHENC_MODULE: u32 = 1;
pub const CONFIG_DRM_CLIENT_LIB: u32 = 1;
pub const CONFIG_ARCH_ENABLE_MEMORY_HOTPLUG: u32 = 1;
pub const CONFIG_NET_ACT_GACT_MODULE: u32 = 1;
pub const CONFIG_MEDIA_ATTACH: u32 = 1;
pub const CONFIG_IIO_ST_SENSORS_SPI_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_ATMEL_MXT_T37: u32 = 1;
pub const CONFIG_DRM_XE_DISPLAY: u32 = 1;
pub const CONFIG_VIDEO_VICODEC_MODULE: u32 = 1;
pub const CONFIG_IP_NF_TARGET_NETMAP_MODULE: u32 = 1;
pub const CONFIG_USB_DWC3_HAPS_MODULE: u32 = 1;
pub const CONFIG_IP_NF_MANGLE_MODULE: u32 = 1;
pub const CONFIG_IIO_ST_ACCEL_I2C_3AXIS_MODULE: u32 = 1;
pub const CONFIG_NF_CONNTRACK_SANE_MODULE: u32 = 1;
pub const CONFIG_MD_BITMAP: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_DEVGROUP_MODULE: u32 = 1;
pub const CONFIG_IP6_NF_MATCH_EUI64_MODULE: u32 = 1;
pub const CONFIG_SERIAL_ARC_MODULE: u32 = 1;
pub const CONFIG_THUNDER_NIC_RGX_MODULE: u32 = 1;
pub const CONFIG_ATL1_MODULE: u32 = 1;
pub const CONFIG_RPMSG_QCOM_GLINK_RPM_MODULE: u32 = 1;
pub const CONFIG_SND_AMD_SOUNDWIRE_ACPI_MODULE: u32 = 1;
pub const CONFIG_DAX: u32 = 1;
pub const CONFIG_GOOGLE_FIRMWARE: u32 = 1;
pub const CONFIG_MEMREGION: u32 = 1;
pub const CONFIG_INTEL_RAPL_CORE_MODULE: u32 = 1;
pub const CONFIG_LEDS_SGM3140_MODULE: u32 = 1;
pub const CONFIG_IOSM_MODULE: u32 = 1;
pub const CONFIG_TCP_CONG_WESTWOOD_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TAS2764_MODULE: u32 = 1;
pub const CONFIG_ACPI_EC: u32 = 1;
pub const CONFIG_NETFILTER_EGRESS: u32 = 1;
pub const CONFIG_NFC_S3FWRN82_UART_MODULE: u32 = 1;
pub const CONFIG_IR_NUVOTON_MODULE: u32 = 1;
pub const CONFIG_L2TP_V3: u32 = 1;
pub const CONFIG_USB_G_ACM_MS_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX15301_MODULE: u32 = 1;
pub const CONFIG_BD79703_MODULE: u32 = 1;
pub const CONFIG_I2C_HID_OF_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_AU6610_MODULE: u32 = 1;
pub const CONFIG_SYSTEM_TRUSTED_KEYS: &[u8; 1] = b"\0";
pub const CONFIG_LEDS_MT6323_MODULE: u32 = 1;
pub const CONFIG_CHARGER_SMB347_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_VANGOGH_MACH_MODULE: u32 = 1;
pub const CONFIG_IP_MROUTE_MULTIPLE_TABLES: u32 = 1;
pub const CONFIG_NET_DSA_TAG_BRCM_COMMON_MODULE: u32 = 1;
pub const CONFIG_FPGA_MGR_ALTERA_CVP_MODULE: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_1251_MODULE: u32 = 1;
pub const CONFIG_HID_PRODIKEYS_MODULE: u32 = 1;
pub const CONFIG_DRM_SSD130X_SPI_MODULE: u32 = 1;
pub const CONFIG_NTB_EPF_MODULE: u32 = 1;
pub const CONFIG_NVIDIA_WMI_EC_BACKLIGHT_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_TPS65912_MODULE: u32 = 1;
pub const CONFIG_PMIC_DA9052: u32 = 1;
pub const CONFIG_LEDS_PCA9532_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_CHT_BSW_NAU8824_MACH_MODULE: u32 = 1;
pub const CONFIG_GPIOLIB_IRQCHIP: u32 = 1;
pub const CONFIG_XILLYBUS_CLASS_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_DLINK_DIR685_MODULE: u32 = 1;
pub const CONFIG_RCU_BOOST_DELAY: u32 = 500;
pub const CONFIG_SPEAKUP_SYNTH_ACNTSA_MODULE: u32 = 1;
pub const CONFIG_TINYDRM_ILI9341_MODULE: u32 = 1;
pub const CONFIG_HYPERV_BALLOON_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_SFQ_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_APOLLOLAKE_MODULE: u32 = 1;
pub const CONFIG_SPEAKUP_SYNTH_BNS_MODULE: u32 = 1;
pub const CONFIG_INPUT_TPS6594_PWRBUTTON_MODULE: u32 = 1;
pub const CONFIG_QCOM_MDT_LOADER_MODULE: u32 = 1;
pub const CONFIG_SCSI_SAS_ATTRS_MODULE: u32 = 1;
pub const CONFIG_ATM_LANAI_MODULE: u32 = 1;
pub const CONFIG_LEDS_WM8350_MODULE: u32 = 1;
pub const CONFIG_EFI: u32 = 1;
pub const CONFIG_VBOXSF_FS_MODULE: u32 = 1;
pub const CONFIG_SUNRPC_MODULE: u32 = 1;
pub const CONFIG_NLS_MAC_CELTIC_MODULE: u32 = 1;
pub const CONFIG_TI_DAC7311_MODULE: u32 = 1;
pub const CONFIG_INTEL_SCU_IPC_UTIL_MODULE: u32 = 1;
pub const CONFIG_THERMAL_EMERGENCY_POWEROFF_DELAY_MS: u32 = 100;
pub const CONFIG_NF_CONNTRACK_NETBIOS_NS_MODULE: u32 = 1;
pub const CONFIG_NF_NAT_OVS: u32 = 1;
pub const CONFIG_TYPEC_RT1719_MODULE: u32 = 1;
pub const CONFIG_DVB_STV0900_MODULE: u32 = 1;
pub const CONFIG_USB_CDNS_HOST: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_HDAUDIO_MODULE: u32 = 1;
pub const CONFIG_RMI4_F34: u32 = 1;
pub const CONFIG_SND_PDAUDIOCF_MODULE: u32 = 1;
pub const CONFIG_CHELSIO_LIB_MODULE: u32 = 1;
pub const CONFIG_FS_STACK: u32 = 1;
pub const CONFIG_BMI088_ACCEL_MODULE: u32 = 1;
pub const CONFIG_LEDS_BRIGHTNESS_HW_CHANGED: u32 = 1;
pub const CONFIG_SENSORS_LTC2947_MODULE: u32 = 1;
pub const CONFIG_MT76x2E_MODULE: u32 = 1;
pub const CONFIG_VIDEO_MGB4_MODULE: u32 = 1;
pub const CONFIG_SOFTLOCKUP_DETECTOR_INTR_STORM: u32 = 1;
pub const CONFIG_YENTA_MODULE: u32 = 1;
pub const CONFIG_AD7091R_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_88PM860X_MODULE: u32 = 1;
pub const CONFIG_VIDEO_MAX96717_MODULE: u32 = 1;
pub const CONFIG_X86_SUPPORTS_MEMORY_FAILURE: u32 = 1;
pub const CONFIG_ARCH_SELECTS_KEXEC_FILE: u32 = 1;
pub const CONFIG_GENERIC_CPU_DEVICES: u32 = 1;
pub const CONFIG_LEDS_PCA963X_MODULE: u32 = 1;
pub const CONFIG_CONNECTOR: u32 = 1;
pub const CONFIG_SND_SOC_ARIZONA_MODULE: u32 = 1;
pub const CONFIG_SENSORS_TC654_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_MC13XXX_MODULE: u32 = 1;
pub const CONFIG_VIRTIO_PCI_LIB: u32 = 1;
pub const CONFIG_HVC_XEN_FRONTEND: u32 = 1;
pub const CONFIG_GPIO_RDC321X_MODULE: u32 = 1;
pub const CONFIG_DRM_VGEM_MODULE: u32 = 1;
pub const CONFIG_HSR_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_TPS6586X_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_INTEL_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_TCP_MD5SIG: u32 = 1;
pub const CONFIG_TSL2591_MODULE: u32 = 1;
pub const CONFIG_INTEL_PUNIT_IPC_MODULE: u32 = 1;
pub const CONFIG_INPUT_REGULATOR_HAPTIC_MODULE: u32 = 1;
pub const CONFIG_SSB_BLOCKIO: u32 = 1;
pub const CONFIG_ARCH_HAVE_EXTRA_ELF_NOTES: u32 = 1;
pub const CONFIG_DM_UEVENT: u32 = 1;
pub const CONFIG_UBIFS_FS_ZSTD: u32 = 1;
pub const CONFIG_MEMORY_HOTREMOVE: u32 = 1;
pub const CONFIG_CRYPTO_LIB_CHACHA: u32 = 1;
pub const CONFIG_SMSC_SCH311X_WDT_MODULE: u32 = 1;
pub const CONFIG_PAC1934_MODULE: u32 = 1;
pub const CONFIG_EDAC_I82975X_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_EBT_LOG_MODULE: u32 = 1;
pub const CONFIG_SFP_MODULE: u32 = 1;
pub const CONFIG_CPU_IDLE: u32 = 1;
pub const CONFIG_OBJTOOL: u32 = 1;
pub const CONFIG_CGROUP_FREEZER: u32 = 1;
pub const CONFIG_EROFS_FS_ZIP_ZSTD: u32 = 1;
pub const CONFIG_RT2X00_MODULE: u32 = 1;
pub const CONFIG_PREEMPT_COUNT: u32 = 1;
pub const CONFIG_GPIB_AGILENT_82350B_MODULE: u32 = 1;
pub const CONFIG_XEN_PVCALLS_BACKEND_MODULE: u32 = 1;
pub const CONFIG_LEDS_MENF21BMC_MODULE: u32 = 1;
pub const CONFIG_KXSD9_I2C_MODULE: u32 = 1;
pub const CONFIG_VGA_SWITCHEROO: u32 = 1;
pub const CONFIG_CAN_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_LAKEFIELD_MODULE: u32 = 1;
pub const CONFIG_AD7150_MODULE: u32 = 1;
pub const CONFIG_TI_ADS1100_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TAS571X_MODULE: u32 = 1;
pub const CONFIG_GVE_MODULE: u32 = 1;
pub const CONFIG_IIO_CONFIGFS_MODULE: u32 = 1;
pub const CONFIG_SCSI_LOWLEVEL_PCMCIA: u32 = 1;
pub const CONFIG_IP6_NF_IPTABLES_LEGACY_MODULE: u32 = 1;
pub const CONFIG_MLX5_CLS_ACT: u32 = 1;
pub const CONFIG_SWIOTLB_XEN: u32 = 1;
pub const CONFIG_HID_BATTERY_STRENGTH: u32 = 1;
pub const CONFIG_DVB_NXT200X_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_HHF_MODULE: u32 = 1;
pub const CONFIG_PTP_1588_CLOCK_VMW_MODULE: u32 = 1;
pub const CONFIG_LEDS_CLASS_MULTICOLOR_MODULE: u32 = 1;
pub const CONFIG_DW_EDMA_PCIE_MODULE: u32 = 1;
pub const CONFIG_AIC94XX_DEBUG: u32 = 1;
pub const CONFIG_SND_SOC_SOF_XTENSA_MODULE: u32 = 1;
pub const CONFIG_CHARGER_TPS65090_MODULE: u32 = 1;
pub const CONFIG_HID_SENSOR_TEMP_MODULE: u32 = 1;
pub const CONFIG_IOMMU_DEFAULT_DMA_LAZY: u32 = 1;
pub const CONFIG_HID_SENSOR_HUB_MODULE: u32 = 1;
pub const CONFIG_IPW2200_QOS: u32 = 1;
pub const CONFIG_HID_PICOLCD_CIR: u32 = 1;
pub const CONFIG_PM_CLK: u32 = 1;
pub const CONFIG_MC3230_MODULE: u32 = 1;
pub const CONFIG_NET_XGRESS: u32 = 1;
pub const CONFIG_XEN_GNTDEV_MODULE: u32 = 1;
pub const CONFIG_SND_VX222_MODULE: u32 = 1;
pub const CONFIG_KVM_XEN: u32 = 1;
pub const CONFIG_LMK04832_MODULE: u32 = 1;
pub const CONFIG_SATA_HOST: u32 = 1;
pub const CONFIG_CRASH_DM_CRYPT_CONFIGS: u32 = 1;
pub const CONFIG_SND_PCM_TIMER: u32 = 1;
pub const CONFIG_INV_MPU6050_SPI_MODULE: u32 = 1;
pub const CONFIG_SCSI_PROC_FS: u32 = 1;
pub const CONFIG_MITIGATION_MMIO_STALE_DATA: u32 = 1;
pub const CONFIG_SND_SOC_RT9123_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT5670_MODULE: u32 = 1;
pub const CONFIG_DVB_STB6000_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LTC4286: u32 = 1;
pub const CONFIG_QED_ISCSI: u32 = 1;
pub const CONFIG_CRYPTO_HW: u32 = 1;
pub const CONFIG_LTC1660_MODULE: u32 = 1;
pub const CONFIG_TIPC_MODULE: u32 = 1;
pub const CONFIG_ATM_MPOA_MODULE: u32 = 1;
pub const CONFIG_X86_PLATFORM_DEVICES: u32 = 1;
pub const CONFIG_REGULATOR_MT6358_MODULE: u32 = 1;
pub const CONFIG_MACINTOSH_DRIVERS: u32 = 1;
pub const CONFIG_NFT_SOCKET_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_NETLINK_QUEUE_MODULE: u32 = 1;
pub const CONFIG_CFG80211_REQUIRE_SIGNED_REGDB: u32 = 1;
pub const CONFIG_MPU3050_MODULE: u32 = 1;
pub const CONFIG_KALLSYMS_ALL: u32 = 1;
pub const CONFIG_USB_F_MASS_STORAGE_MODULE: u32 = 1;
pub const CONFIG_ATH12K_COREDUMP: u32 = 1;
pub const CONFIG_COREDUMP: u32 = 1;
pub const CONFIG_RELOCATABLE: u32 = 1;
pub const CONFIG_SERIAL_JSM_MODULE: u32 = 1;
pub const CONFIG_ACPI_CONFIGFS_MODULE: u32 = 1;
pub const CONFIG_VIRTIO_MEM_MODULE: u32 = 1;
pub const CONFIG_SATA_ACARD_AHCI_MODULE: u32 = 1;
pub const CONFIG_HAVE_KVM_MSI: u32 = 1;
pub const CONFIG_CC_HAS_ZERO_CALL_USED_REGS: u32 = 1;
pub const CONFIG_GOOGLE_VPD_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_EBT_PKTTYPE_MODULE: u32 = 1;
pub const CONFIG_INTEL_QUICKI2C_MODULE: u32 = 1;
pub const CONFIG_RC_DEVICES: u32 = 1;
pub const CONFIG_B43_BUSES_BCMA_AND_SSB: u32 = 1;
pub const CONFIG_JOYSTICK_GUILLEMOT_MODULE: u32 = 1;
pub const CONFIG_ARCH_KEEP_MEMBLOCK: u32 = 1;
pub const CONFIG_CRYPTO_HASH2: u32 = 1;
pub const CONFIG_SECCOMP: u32 = 1;
pub const CONFIG_SND_SOC_WM8978_MODULE: u32 = 1;
pub const CONFIG_SNET_VDPA_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS35L56_I2C_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_MV88E6XXX_PTP: u32 = 1;
pub const CONFIG_DAMON: u32 = 1;
pub const CONFIG_TIFM_CORE_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_LIB_GF128MUL: u32 = 1;
pub const CONFIG_SOUNDWIRE_INTEL_MODULE: u32 = 1;
pub const CONFIG_SPLIT_PMD_PTLOCKS: u32 = 1;
pub const CONFIG_ACPI_SBS_MODULE: u32 = 1;
pub const CONFIG_X86_CX8: u32 = 1;
pub const CONFIG_HID_MICROSOFT_MODULE: u32 = 1;
pub const CONFIG_LIBERTAS_MESH: u32 = 1;
pub const CONFIG_SGETMASK_SYSCALL: u32 = 1;
pub const CONFIG_USB_MUSB_DUAL_ROLE: u32 = 1;
pub const CONFIG_USB_G_MULTI_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CAMERA_LENS: u32 = 1;
pub const CONFIG_SND_SOC_PCM3060_MODULE: u32 = 1;
pub const CONFIG_IP6_NF_IPTABLES_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_RT274_MODULE: u32 = 1;
pub const CONFIG_MAX1027_MODULE: u32 = 1;
pub const CONFIG_SHMEM: u32 = 1;
pub const CONFIG_A11Y_BRAILLE_CONSOLE: u32 = 1;
pub const CONFIG_IWLWIFI_OPMODE_MODULAR: u32 = 1;
pub const CONFIG_FPGA_MGR_MACHXO2_SPI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS42L56_MODULE: u32 = 1;
pub const CONFIG_WIZNET_W5300_MODULE: u32 = 1;
pub const CONFIG_IIO_BUFFER_DMAENGINE_MODULE: u32 = 1;
pub const CONFIG_LEDS_IS31FL319X_MODULE: u32 = 1;
pub const CONFIG_NFT_CT_MODULE: u32 = 1;
pub const CONFIG_RTL8723BS_MODULE: u32 = 1;
pub const CONFIG_SND_ALS4000_MODULE: u32 = 1;
pub const CONFIG_IO_URING_ZCRX: u32 = 1;
pub const CONFIG_NET_ACT_IFE_MODULE: u32 = 1;
pub const CONFIG_VSOCKMON_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_NMI_SAFE_THIS_CPU_OPS: u32 = 1;
pub const CONFIG_DVB_DIB3000MC_MODULE: u32 = 1;
pub const CONFIG_I2C_BOARDINFO: u32 = 1;
pub const CONFIG_VIDEO_OV7740_MODULE: u32 = 1;
pub const CONFIG_SERIO_ALTERA_PS2_MODULE: u32 = 1;
pub const CONFIG_ATL2_MODULE: u32 = 1;
pub const CONFIG_GPIO_BD9571MWV_MODULE: u32 = 1;
pub const CONFIG_UIO_MODULE: u32 = 1;
pub const CONFIG_KEXEC_SIG: u32 = 1;
pub const CONFIG_SSB_PCIHOST: u32 = 1;
pub const CONFIG_NET_VENDOR_ALTEON: u32 = 1;
pub const CONFIG_ATA_VERBOSE_ERROR: u32 = 1;
pub const CONFIG_SECURITY_APPARMOR_HASH_DEFAULT: u32 = 1;
pub const CONFIG_WEXT_CORE: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_CONEXANT_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_R9701_MODULE: u32 = 1;
pub const CONFIG_DRM_PANEL_WIDECHIPS_WS2401_MODULE: u32 = 1;
pub const CONFIG_MFD_WM8998: u32 = 1;
pub const CONFIG_PLDMFW: u32 = 1;
pub const CONFIG_VIDEO_MAX9271_LIB_MODULE: u32 = 1;
pub const CONFIG_SENSORS_TPS40422_MODULE: u32 = 1;
pub const CONFIG_MS_BLOCK_MODULE: u32 = 1;
pub const CONFIG_THERMAL_NETLINK: u32 = 1;
pub const CONFIG_BACKLIGHT_LM3639_MODULE: u32 = 1;
pub const CONFIG_PSE_PD692X0_MODULE: u32 = 1;
pub const CONFIG_VIRTIO_ANCHOR: u32 = 1;
pub const CONFIG_SKGE_MODULE: u32 = 1;
pub const CONFIG_RMI4_SPI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ES8328_I2C_MODULE: u32 = 1;
pub const CONFIG_MT76_SDIO_MODULE: u32 = 1;
pub const CONFIG_CHELSIO_T3_MODULE: u32 = 1;
pub const CONFIG_LIBIE_ADMINQ_MODULE: u32 = 1;
pub const CONFIG_SATA_SIL_MODULE: u32 = 1;
pub const CONFIG_SND_TIMER_MODULE: u32 = 1;
pub const CONFIG_INTEL_SMARTCONNECT_MODULE: u32 = 1;
pub const CONFIG_NETLINK_DIAG_MODULE: u32 = 1;
pub const CONFIG_NLS_MAC_ICELAND_MODULE: u32 = 1;
pub const CONFIG_SMS_SIANO_RC: u32 = 1;
pub const CONFIG_HAVE_POSIX_CPU_TIMERS_TASK_WORK: u32 = 1;
pub const CONFIG_RPCSEC_GSS_KRB5_ENCTYPES_AES_SHA2: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_949_MODULE: u32 = 1;
pub const CONFIG_SENSORS_W83L785TS_MODULE: u32 = 1;
pub const CONFIG_CROS_EC_LIGHTBAR_MODULE: u32 = 1;
pub const CONFIG_SENSORS_XDPE152_MODULE: u32 = 1;
pub const CONFIG_VIRTIO_BLK: u32 = 1;
pub const CONFIG_CPU_SUP_INTEL: u32 = 1;
pub const CONFIG_BCH_MODULE: u32 = 1;
pub const CONFIG_RTLWIFI_PCI_MODULE: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_SCHED_CLUSTER: u32 = 1;
pub const CONFIG_DRM_HISI_HIBMC_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_MODULE: u32 = 1;
pub const CONFIG_IRQ_FORCED_THREADING: u32 = 1;
pub const CONFIG_HARDLOCKUP_DETECTOR: u32 = 1;
pub const CONFIG_VIDEO_GO7007_LOADER_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_MANAGER2: u32 = 1;
pub const CONFIG_NET_VENDOR_MICROCHIP: u32 = 1;
pub const CONFIG_MESSAGE_LOGLEVEL_DEFAULT: u32 = 4;
pub const CONFIG_SND_SOC_FS210X_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_CROS_EC_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DS1343_MODULE: u32 = 1;
pub const CONFIG_LCD_OTM3225A_MODULE: u32 = 1;
pub const CONFIG_INTEL_BXT_PMIC_THERMAL_MODULE: u32 = 1;
pub const CONFIG_SCSI_CXGB4_ISCSI_MODULE: u32 = 1;
pub const CONFIG_IP_NF_FILTER_MODULE: u32 = 1;
pub const CONFIG_SQUASHFS_MODULE: u32 = 1;
pub const CONFIG_WLAN_VENDOR_ATH: u32 = 1;
pub const CONFIG_SND_DUMMY_MODULE: u32 = 1;
pub const CONFIG_SPI_AMD_MODULE: u32 = 1;
pub const CONFIG_ITCO_WDT_MODULE: u32 = 1;
pub const CONFIG_CFG80211_WEXT: u32 = 1;
pub const CONFIG_MLXREG_LC_MODULE: u32 = 1;
pub const CONFIG_SENSORS_VIA_CPUTEMP_MODULE: u32 = 1;
pub const CONFIG_DVB_S921_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LM95245_MODULE: u32 = 1;
pub const CONFIG_DA9062_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_FPGA_DFL_FME_MODULE: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_932_MODULE: u32 = 1;
pub const CONFIG_WLAN_VENDOR_MARVELL: u32 = 1;
pub const CONFIG_NET_SCH_MQPRIO_LIB_MODULE: u32 = 1;
pub const CONFIG_AD4695_MODULE: u32 = 1;
pub const CONFIG_KVM_HYPERV: u32 = 1;
pub const CONFIG_HAVE_DYNAMIC_FTRACE_NO_PATCHABLE: u32 = 1;
pub const CONFIG_SOCK_RX_QUEUE_MAPPING: u32 = 1;
pub const CONFIG_X86_MCE_THRESHOLD: u32 = 1;
pub const CONFIG_RESCTRL_FS_PSEUDO_LOCK: u32 = 1;
pub const CONFIG_AUXILIARY_BUS: u32 = 1;
pub const CONFIG_RTC_DRV_RX8111_MODULE: u32 = 1;
pub const CONFIG_ARCH_HIBERNATION_HEADER: u32 = 1;
pub const CONFIG_DECOMPRESS_LZ4: u32 = 1;
pub const CONFIG_VFIO_CONTAINER: u32 = 1;
pub const CONFIG_RTC_DRV_LP8788_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_PCAP_MODULE: u32 = 1;
pub const CONFIG_SENSORS_VT1211_MODULE: u32 = 1;
pub const CONFIG_DVB_CX24117_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_ETOMS_MODULE: u32 = 1;
pub const CONFIG_ARCH_WANT_DEFAULT_BPF_JIT: u32 = 1;
pub const CONFIG_GPIO_SIM_MODULE: u32 = 1;
pub const CONFIG_NLS_ISO8859_1_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CHV3_CODEC_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_KCOV: u32 = 1;
pub const CONFIG_HID_TOPSEED_MODULE: u32 = 1;
pub const CONFIG_NET_EMATCH_META_MODULE: u32 = 1;
pub const CONFIG_DYNAMIC_FTRACE_WITH_DIRECT_CALLS: u32 = 1;
pub const CONFIG_MPLS_IPTUNNEL_MODULE: u32 = 1;
pub const CONFIG_PM_SLEEP_DEBUG: u32 = 1;
pub const CONFIG_BT_HCIUART_RTL: u32 = 1;
pub const CONFIG_GENERIC_IRQ_INJECTION: u32 = 1;
pub const CONFIG_AFS_FSCACHE: u32 = 1;
pub const CONFIG_HSC030PA_I2C_MODULE: u32 = 1;
pub const CONFIG_USB_TRANCEVIBRATOR_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_CAVIUM: u32 = 1;
pub const CONFIG_LEDS_TCA6507_MODULE: u32 = 1;
pub const CONFIG_WLAN_VENDOR_ZYDAS: u32 = 1;
pub const CONFIG_AD3552R_LIB_MODULE: u32 = 1;
pub const CONFIG_LIBERTAS_SDIO_MODULE: u32 = 1;
pub const CONFIG_SENSORS_SHT21_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_MR97310A_MODULE: u32 = 1;
pub const CONFIG_INPUT_AW86927_MODULE: u32 = 1;
pub const CONFIG_PCNET32_MODULE: u32 = 1;
pub const CONFIG_BCACHE_ASYNC_REGISTRATION: u32 = 1;
pub const CONFIG_INTEL_SAR_INT1092_MODULE: u32 = 1;
pub const CONFIG_PATA_TIMINGS: u32 = 1;
pub const CONFIG_NETFILTER_XT_MARK_MODULE: u32 = 1;
pub const CONFIG_COMPAT: u32 = 1;
pub const CONFIG_VIRT_CPU_ACCOUNTING: u32 = 1;
pub const CONFIG_SND_SOC_SOF_ELKHARTLAKE_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_DIGI_ACCELEPORT_MODULE: u32 = 1;
pub const CONFIG_ARCH_ENABLE_HUGEPAGE_MIGRATION: u32 = 1;
pub const CONFIG_PSTORE: u32 = 1;
pub const CONFIG_IIO_ST_LSM6DSX_SPI_MODULE: u32 = 1;
pub const CONFIG_HID_VRC2_MODULE: u32 = 1;
pub const CONFIG_NET_CLS_ROUTE4_MODULE: u32 = 1;
pub const CONFIG_TMPFS_INODE64: u32 = 1;
pub const CONFIG_TI_TSC2046_MODULE: u32 = 1;
pub const CONFIG_ZRAM_DEF_COMP_ZSTD: u32 = 1;
pub const CONFIG_SCSI_UFS_CRYPTO: u32 = 1;
pub const CONFIG_IIO_TRIGGERED_EVENT_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_AF9035_MODULE: u32 = 1;
pub const CONFIG_SND_BCD2000_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_CHOKE_MODULE: u32 = 1;
pub const CONFIG_MXM_WMI_MODULE: u32 = 1;
pub const CONFIG_NIC7018_WDT_MODULE: u32 = 1;
pub const CONFIG_SCSI_3W_SAS_MODULE: u32 = 1;
pub const CONFIG_WILC1000_MODULE: u32 = 1;
pub const CONFIG_PCI_ENDPOINT_TEST_MODULE: u32 = 1;
pub const CONFIG_INTEL_XWAY_PHY_MODULE: u32 = 1;
pub const CONFIG_RMI4_F55: u32 = 1;
pub const CONFIG_EXCLUSIVE_SYSTEM_RAM: u32 = 1;
pub const CONFIG_FW_LOADER_COMPRESS: u32 = 1;
pub const CONFIG_CRYPTO_LIB_POLY1305_RSIZE: u32 = 11;
pub const CONFIG_INIT_ENV_ARG_LIMIT: u32 = 32;
pub const CONFIG_CACHEFILES_MODULE: u32 = 1;
pub const CONFIG_QEDF_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_RT298_MODULE: u32 = 1;
pub const CONFIG_BCM_KONA_USB2_PHY_MODULE: u32 = 1;
pub const CONFIG_ADMV1013_MODULE: u32 = 1;
pub const CONFIG_STANDALONE: u32 = 1;
pub const CONFIG_XEN_PV_MSR_SAFE: u32 = 1;
pub const CONFIG_USB_SERIAL_CONSOLE: u32 = 1;
pub const CONFIG_USB_CONFIGFS_EEM: u32 = 1;
pub const CONFIG_TEHUTI_TN40_MODULE: u32 = 1;
pub const CONFIG_XFRM_MIGRATE: u32 = 1;
pub const CONFIG_SND_DYNAMIC_MINORS: u32 = 1;
pub const CONFIG_IP_PIMSM_V1: u32 = 1;
pub const CONFIG_CRYPTO_DEV_QAT_C62X_MODULE: u32 = 1;
pub const CONFIG_CC_HAS_AUTO_VAR_INIT_ZERO: u32 = 1;
pub const CONFIG_SCSI_VIRTIO_MODULE: u32 = 1;
pub const CONFIG_FPGA_DFL_NIOS_INTEL_PAC_N3000_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_LPASS_TX_MACRO_MODULE: u32 = 1;
pub const CONFIG_DM_FLAKEY_MODULE: u32 = 1;
pub const CONFIG_HOTPLUG_PCI_CPCI: u32 = 1;
pub const CONFIG_ZD1211RW_MODULE: u32 = 1;
pub const CONFIG_SPARSEMEM_VMEMMAP_PREINIT: u32 = 1;
pub const CONFIG_HOTPLUG_PARALLEL: u32 = 1;
pub const CONFIG_CHARGER_MAX8997_MODULE: u32 = 1;
pub const CONFIG_SECURITY_INFINIBAND: u32 = 1;
pub const CONFIG_VIDEO_GO7007_USB_S2250_BOARD_MODULE: u32 = 1;
pub const CONFIG_FUN_CORE_MODULE: u32 = 1;
pub const CONFIG_GPIB_COMMON_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_XIRLINK_CIT_MODULE: u32 = 1;
pub const CONFIG_DVB_DRXK_MODULE: u32 = 1;
pub const CONFIG_JFFS2_FS_POSIX_ACL: u32 = 1;
pub const CONFIG_REGULATOR_MT6359_MODULE: u32 = 1;
pub const CONFIG_I2C_PCA_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_ALC880_MODULE: u32 = 1;
pub const CONFIG_EXT_GROUP_SCHED: u32 = 1;
pub const CONFIG_EROFS_FS_SECURITY: u32 = 1;
pub const CONFIG_I2C_HID_MODULE: u32 = 1;
pub const CONFIG_PREEMPT_BUILD: u32 = 1;
pub const CONFIG_BT_HCIUART_MRVL: u32 = 1;
pub const CONFIG_TPS6594_ESM_MODULE: u32 = 1;
pub const CONFIG_DRM_DISPLAY_HDMI_CEC_NOTIFIER_HELPER: u32 = 1;
pub const CONFIG_MEM_SOFT_DIRTY: u32 = 1;
pub const CONFIG_LOGIWHEELS_FF: u32 = 1;
pub const CONFIG_DRM_AMDGPU_MODULE: u32 = 1;
pub const CONFIG_YENTA_O2: u32 = 1;
pub const CONFIG_RTC_DRV_MAX8997_MODULE: u32 = 1;
pub const CONFIG_SND_EMU10K1X_MODULE: u32 = 1;
pub const CONFIG_MANAGER_SBS_MODULE: u32 = 1;
pub const CONFIG_AF_RXRPC_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_STINGER_MODULE: u32 = 1;
pub const CONFIG_842_COMPRESS_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_PCM186X_MODULE: u32 = 1;
pub const CONFIG_SERIAL_ARC_NR_PORTS: u32 = 1;
pub const CONFIG_DVB_USB_ANYSEE_MODULE: u32 = 1;
pub const CONFIG_DEFAULT_TCP_CONG: &[u8; 6] = b"cubic\0";
pub const CONFIG_VL53L0X_I2C_MODULE: u32 = 1;
pub const CONFIG_DRM_XE_PREEMPT_TIMEOUT_MIN: u32 = 1;
pub const CONFIG_I2C_TINY_USB_MODULE: u32 = 1;
pub const CONFIG_IR_TTUSBIR_MODULE: u32 = 1;
pub const CONFIG_MPTCP_IPV6: u32 = 1;
pub const CONFIG_MSHV_ROOT_MODULE: u32 = 1;
pub const CONFIG_USER_EVENTS: u32 = 1;
pub const CONFIG_NETFILTER_NETLINK_ACCT_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_ACP_PCM_MODULE: u32 = 1;
pub const CONFIG_MWAVE_MODULE: u32 = 1;
pub const CONFIG_WLAN_VENDOR_SILABS: u32 = 1;
pub const CONFIG_IPW2100_MONITOR: u32 = 1;
pub const CONFIG_VORTEX_MODULE: u32 = 1;
pub const CONFIG_HAVE_KERNEL_ZSTD: u32 = 1;
pub const CONFIG_CRAMFS_BLOCKDEV: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_LTO_CLANG: u32 = 1;
pub const CONFIG_PHY_CAN_TRANSCEIVER_MODULE: u32 = 1;
pub const CONFIG_CPUFREQ_ARCH_CUR_FREQ: u32 = 1;
pub const CONFIG_SND_SOC_RT715_SDW_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AC97_BUS: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_L2TP_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_HDA_COMMON_MODULE: u32 = 1;
pub const CONFIG_VIDEO_PVRUSB2_SYSFS: u32 = 1;
pub const CONFIG_MFD_DA9063_MODULE: u32 = 1;
pub const CONFIG_IP6_NF_SECURITY_MODULE: u32 = 1;
pub const CONFIG_MEN_Z188_ADC_MODULE: u32 = 1;
pub const CONFIG_USB_STORAGE_REALTEK_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_OKI: u32 = 1;
pub const CONFIG_RTW88_8821CS_MODULE: u32 = 1;
pub const CONFIG_WIL6210_MODULE: u32 = 1;
pub const CONFIG_SECURITY_IPE: u32 = 1;
pub const CONFIG_I2C_TAOS_EVM_MODULE: u32 = 1;
pub const CONFIG_BLK_INLINE_ENCRYPTION_FALLBACK: u32 = 1;
pub const CONFIG_CRYPTO_CRC32_MODULE: u32 = 1;
pub const CONFIG_IQS620AT_TEMP_MODULE: u32 = 1;
pub const CONFIG_TPS6594_PFSM_MODULE: u32 = 1;
pub const CONFIG_SPI_MEM: u32 = 1;
pub const CONFIG_INTEL_UNCORE_FREQ_CONTROL_MODULE: u32 = 1;
pub const CONFIG_UCSI_ACPI_MODULE: u32 = 1;
pub const CONFIG_MMC_BLOCK_MODULE: u32 = 1;
pub const CONFIG_MFD_MENF21BMC_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_RX8025_MODULE: u32 = 1;
pub const CONFIG_GCC_NO_STRINGOP_OVERFLOW: u32 = 1;
pub const CONFIG_ATM_FORE200E_TX_RETRY: u32 = 16;
pub const CONFIG_CONTIG_ALLOC: u32 = 1;
pub const CONFIG_VIDEO_MT9V111_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_INTEL_HIFI_EP_IPC_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_LIB_SM3_MODULE: u32 = 1;
pub const CONFIG_SMBFS_MODULE: u32 = 1;
pub const CONFIG_PCI_DIRECT: u32 = 1;
pub const CONFIG_BROADCAST_TLB_FLUSH: u32 = 1;
pub const CONFIG_USB_DWC3_PCI_MODULE: u32 = 1;
pub const CONFIG_USB_SI4713_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_AS5011_MODULE: u32 = 1;
pub const CONFIG_AX25_DAMA_SLAVE: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_ALC662_MODULE: u32 = 1;
pub const CONFIG_CAN_PEAK_PCIEC: u32 = 1;
pub const CONFIG_CPU_FREQ_GOV_ATTR_SET: u32 = 1;
pub const CONFIG_SENSORS_CRPS_MODULE: u32 = 1;
pub const CONFIG_P2SB: u32 = 1;
pub const CONFIG_RWSEM_SPIN_ON_OWNER: u32 = 1;
pub const CONFIG_HAVE_BOOTMEM_INFO_NODE: u32 = 1;
pub const CONFIG_HOTPLUG_PCI_CPCI_ZT5550_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_STRICT_MODULE_RWX: u32 = 1;
pub const CONFIG_DRM_PRIVACY_SCREEN: u32 = 1;
pub const CONFIG_SND_SOC_AMD_ACP63_TOPLEVEL_MODULE: u32 = 1;
pub const CONFIG_SCSI_ACARD_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ES7241_MODULE: u32 = 1;
pub const CONFIG_DVB_DIB3000MB_MODULE: u32 = 1;
pub const CONFIG_DVB_TS2020_MODULE: u32 = 1;
pub const CONFIG_MFD_TPS6594_SPI_MODULE: u32 = 1;
pub const CONFIG_WATCHDOG_PRETIMEOUT_GOV_PANIC: u32 = 1;
pub const CONFIG_LRU_GEN: u32 = 1;
pub const CONFIG_PROC_PID_ARCH_STATUS: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_KEXEC_BZIMAGE_VERIFY_SIG: u32 = 1;
pub const CONFIG_EXAR_WDT_MODULE: u32 = 1;
pub const CONFIG_GPIO_WHISKEY_COVE_MODULE: u32 = 1;
pub const CONFIG_SENSORS_TPS23861_MODULE: u32 = 1;
pub const CONFIG_WLAN_VENDOR_INTEL: u32 = 1;
pub const CONFIG_HAVE_IRQ_EXIT_ON_IRQ_STACK: u32 = 1;
pub const CONFIG_CAN_CC770_ISA_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CX88_MPEG_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_METEORPOINT_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_ESSIV_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_SPCP8X5_MODULE: u32 = 1;
pub const CONFIG_FPGA_MGR_XILINX_SELECTMAP_MODULE: u32 = 1;
pub const CONFIG_ATH5K_DEBUG: u32 = 1;
pub const CONFIG_HINIC_MODULE: u32 = 1;
pub const CONFIG_BATTERY_GAUGE_LTC2941_MODULE: u32 = 1;
pub const CONFIG_GPIO_GENERIC_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_MITIGATION_IBRS_ENTRY: u32 = 1;
pub const CONFIG_ARCH_HAS_KERNEL_FPU_SUPPORT: u32 = 1;
pub const CONFIG_KEYBOARD_QT1070_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_GLK_DA7219_MAX98357A_MACH_MODULE: u32 = 1;
pub const CONFIG_RPMSG_TTY_MODULE: u32 = 1;
pub const CONFIG_AFE4404_MODULE: u32 = 1;
pub const CONFIG_OPEN_ALLIANCE_HELPERS: u32 = 1;
pub const CONFIG_EUROTECH_WDT_MODULE: u32 = 1;
pub const CONFIG_HID_CMEDIA_MODULE: u32 = 1;
pub const CONFIG_DVB_LNBP21_MODULE: u32 = 1;
pub const CONFIG_RPCSEC_GSS_KRB5_ENCTYPES_AES_SHA1: u32 = 1;
pub const CONFIG_HAVE_RELIABLE_STACKTRACE: u32 = 1;
pub const CONFIG_INPUT_PCSPKR_MODULE: u32 = 1;
pub const CONFIG_MFD_MC13XXX_MODULE: u32 = 1;
pub const CONFIG_HOTPLUG_CORE_SYNC: u32 = 1;
pub const CONFIG_MFD_ATC260X_MODULE: u32 = 1;
pub const CONFIG_DVB_AV7110_IR: u32 = 1;
pub const CONFIG_HID_ICADE_MODULE: u32 = 1;
pub const CONFIG_DVB_AU8522_DTV_MODULE: u32 = 1;
pub const CONFIG_SCSI_UFS_HWMON: u32 = 1;
pub const CONFIG_MELLANOX_PLATFORM: u32 = 1;
pub const CONFIG_RTC_DRV_TPS6594_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_ATHEROS: u32 = 1;
pub const CONFIG_DVB_SP887X_MODULE: u32 = 1;
pub const CONFIG_LEDS_TRIGGER_CAMERA_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_RTMV20_MODULE: u32 = 1;
pub const CONFIG_DVB_TDA10021_MODULE: u32 = 1;
pub const CONFIG_PATA_RZ1000_MODULE: u32 = 1;
pub const CONFIG_VMD_MODULE: u32 = 1;
pub const CONFIG_VIRTIO_MMIO_MODULE: u32 = 1;
pub const CONFIG_ELFCORE: u32 = 1;
pub const CONFIG_I2C_ALI1563_MODULE: u32 = 1;
pub const CONFIG_CARL9170_WPC: u32 = 1;
pub const CONFIG_IOSF_MBI: u32 = 1;
pub const CONFIG_BLK_PM: u32 = 1;
pub const CONFIG_X86_PM_TIMER: u32 = 1;
pub const CONFIG_SPI_ALTERA_DFL_MODULE: u32 = 1;
pub const CONFIG_HDC2010_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ASUS_WMI_MODULE: u32 = 1;
pub const CONFIG_SND_VMASTER: u32 = 1;
pub const CONFIG_SERIAL_8250_RSA: u32 = 1;
pub const CONFIG_PPS_CLIENT_PARPORT_MODULE: u32 = 1;
pub const CONFIG_SENSORS_STTS751_MODULE: u32 = 1;
pub const CONFIG_MLX5_CORE_EN: u32 = 1;
pub const CONFIG_VHOST_ENABLE_FORK_OWNER_CONTROL: u32 = 1;
pub const CONFIG_REGULATOR_MAX77541_MODULE: u32 = 1;
pub const CONFIG_CIFS_DEBUG: u32 = 1;
pub const CONFIG_USBIP_VHCI_HCD_MODULE: u32 = 1;
pub const CONFIG_DVB_CX24116_MODULE: u32 = 1;
pub const CONFIG_ISDN_CAPI: u32 = 1;
pub const CONFIG_BRIDGE_EBT_DNAT_MODULE: u32 = 1;
pub const CONFIG_POSIX_AUX_CLOCKS: u32 = 1;
pub const CONFIG_NET_VENDOR_SILAN: u32 = 1;
pub const CONFIG_MEDIA_TUNER_MXL5005S_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_MV88E6XXX_LEDS: u32 = 1;
pub const CONFIG_HID_MULTITOUCH_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_SI3054_MODULE: u32 = 1;
pub const CONFIG_DYNAMIC_SIGFRAME: u32 = 1;
pub const CONFIG_TOUCHSCREEN_ELO_MODULE: u32 = 1;
pub const CONFIG_BMG160_SPI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_COMETLAKE_MODULE: u32 = 1;
pub const CONFIG_SENSORS_UCD9000_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_PCM3168A_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_ZINITIX_MODULE: u32 = 1;
pub const CONFIG_GNSS_MODULE: u32 = 1;
pub const CONFIG_DRM_APPLETBDRM_MODULE: u32 = 1;
pub const CONFIG_SND_VERBOSE_PROCFS: u32 = 1;
pub const CONFIG_INPUT_MAX8997_HAPTIC_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_INGRESS_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_EBT_AMONG_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_TDA827X_MODULE: u32 = 1;
pub const CONFIG_SENSORS_HMC5843_MODULE: u32 = 1;
pub const CONFIG_LEDS_KTD202X_MODULE: u32 = 1;
pub const CONFIG_GENERIC_CPU_AUTOPROBE: u32 = 1;
pub const CONFIG_WLAN_VENDOR_ST: u32 = 1;
pub const CONFIG_SOLARIS_X86_PARTITION: u32 = 1;
pub const CONFIG_NIU_MODULE: u32 = 1;
pub const CONFIG_VMGENID: u32 = 1;
pub const CONFIG_ADIN_PHY_MODULE: u32 = 1;
pub const CONFIG_RETHOOK: u32 = 1;
pub const CONFIG_JFFS2_ZLIB: u32 = 1;
pub const CONFIG_NFC_MICROREAD_MODULE: u32 = 1;
pub const CONFIG_INPUT_MOUSEDEV_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_CAKE_MODULE: u32 = 1;
pub const CONFIG_NETDEVICES: u32 = 1;
pub const CONFIG_FW_CS_DSP_MODULE: u32 = 1;
pub const CONFIG_DRM_CLIENT_DEFAULT: &[u8; 6] = b"fbdev\0";
pub const CONFIG_X86_INTEL_TSX_MODE_AUTO: u32 = 1;
pub const CONFIG_LAN743X_MODULE: u32 = 1;
pub const CONFIG_IIO_BUFFER_DMA_MODULE: u32 = 1;
pub const CONFIG_WILCO_EC_MODULE: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_874_MODULE: u32 = 1;
pub const CONFIG_NR_CPUS_RANGE_END: u32 = 8192;
pub const CONFIG_VIDEO_TEA6415C_MODULE: u32 = 1;
pub const CONFIG_RTL8180_MODULE: u32 = 1;
pub const CONFIG_SPI_XILINX_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_BENQ_MODULE: u32 = 1;
pub const CONFIG_BMP280_MODULE: u32 = 1;
pub const CONFIG_BLK_RQ_ALLOC_TIME: u32 = 1;
pub const CONFIG_MFD_TI_LP873X_MODULE: u32 = 1;
pub const CONFIG_ARCH_CLOCKSOURCE_INIT: u32 = 1;
pub const CONFIG_INET_XFRM_TUNNEL_MODULE: u32 = 1;
pub const CONFIG_INPUT_MISC: u32 = 1;
pub const CONFIG_SENSORS_PXE1610_MODULE: u32 = 1;
pub const CONFIG_UBIFS_FS_ZLIB: u32 = 1;
pub const CONFIG_NF_NAT_H323_MODULE: u32 = 1;
pub const CONFIG_IP_PIMSM_V2: u32 = 1;
pub const CONFIG_MFD_OCELOT_MODULE: u32 = 1;
pub const CONFIG_PATA_PARPORT_EPAT_MODULE: u32 = 1;
pub const CONFIG_ETHTOOL_NETLINK: u32 = 1;
pub const CONFIG_AD7606_IFACE_SPI_MODULE: u32 = 1;
pub const CONFIG_WATCHDOG_PRETIMEOUT_GOV_SEL_MODULE: u32 = 1;
pub const CONFIG_NVME_TARGET_LOOP_MODULE: u32 = 1;
pub const CONFIG_GPIO_MAX730X_MODULE: u32 = 1;
pub const CONFIG_VIRTIO_PCI_LIB_LEGACY: u32 = 1;
pub const CONFIG_RCU_BOOST: u32 = 1;
pub const CONFIG_COMMON_CLK: u32 = 1;
pub const CONFIG_SND_SOC_TLV320ADC3XXX_MODULE: u32 = 1;
pub const CONFIG_USBPCWATCHDOG_MODULE: u32 = 1;
pub const CONFIG_DEBUG_INFO: u32 = 1;
pub const CONFIG_KXSD9_MODULE: u32 = 1;
pub const CONFIG_SND_RME96_MODULE: u32 = 1;
pub const CONFIG_ACRN_HSM_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CX2341X_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DS1302_MODULE: u32 = 1;
pub const CONFIG_ACPI_APEI_EINJ_MODULE: u32 = 1;
pub const CONFIG_RMI4_F3A: u32 = 1;
pub const CONFIG_RT2X00_LIB_LEDS: u32 = 1;
pub const CONFIG_MD_CLUSTER_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_HDA_LINK_BASELINE_MODULE: u32 = 1;
pub const CONFIG_X86_AMD_FREQ_SENSITIVITY_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DS1374_WDT: u32 = 1;
pub const CONFIG_POWER_RESET_MT6323: u32 = 1;
pub const CONFIG_VIDEO_CADENCE_CSI2TX_MODULE: u32 = 1;
pub const CONFIG_MAX31865_MODULE: u32 = 1;
pub const CONFIG_HID_PICOLCD_FB: u32 = 1;
pub const CONFIG_SCSI_SCAN_ASYNC: u32 = 1;
pub const CONFIG_RTC_DRV_M48T86_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_BDW_RT5677_MACH_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_BLOWFISH_MODULE: u32 = 1;
pub const CONFIG_BCM54140_PHY_MODULE: u32 = 1;
pub const CONFIG_RTW89_PCI_MODULE: u32 = 1;
pub const CONFIG_SENSORS_IBM_CFFPS_MODULE: u32 = 1;
pub const CONFIG_USB_PULSE8_CEC_MODULE: u32 = 1;
pub const CONFIG_SENSORS_KFAN_MODULE: u32 = 1;
pub const CONFIG_PHYLINK_MODULE: u32 = 1;
pub const CONFIG_EFI_SOFT_RESERVE: u32 = 1;
pub const CONFIG_SENSORS_MPQ7932_REGULATOR: u32 = 1;
pub const CONFIG_SENSORS_ISL29028_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_MAX8998_MODULE: u32 = 1;
pub const CONFIG_SATA_PMP: u32 = 1;
pub const CONFIG_PCIE_ECRC: u32 = 1;
pub const CONFIG_DMA_SHARED_BUFFER: u32 = 1;
pub const CONFIG_MODULES: u32 = 1;
pub const CONFIG_MLX5_VDPA: u32 = 1;
pub const CONFIG_SND_SOC_AMD_RENOIR_MACH_MODULE: u32 = 1;
pub const CONFIG_RT2800PCI_RT35XX: u32 = 1;
pub const CONFIG_IPV6_SEG6_HMAC: u32 = 1;
pub const CONFIG_SND_SEQ_VIRMIDI_MODULE: u32 = 1;
pub const CONFIG_SND_SIMPLE_CARD_UTILS_MODULE: u32 = 1;
pub const CONFIG_BACKLIGHT_ADP8870_MODULE: u32 = 1;
pub const CONFIG_IDLE_INJECT: u32 = 1;
pub const CONFIG_GPIO_TWL4030_MODULE: u32 = 1;
pub const CONFIG_NF_NAT_MODULE: u32 = 1;
pub const CONFIG_CACHESTAT_SYSCALL: u32 = 1;
pub const CONFIG_CMA_SIZE_MBYTES: u32 = 0;
pub const CONFIG_CROS_EC_SPI_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_INPUT_BEEP: u32 = 1;
pub const CONFIG_REGULATOR_TPS65023_MODULE: u32 = 1;
pub const CONFIG_CAN_MCP251XFD_MODULE: u32 = 1;
pub const CONFIG_USB_CONFIGFS_ACM: u32 = 1;
pub const CONFIG_PVH: u32 = 1;
pub const CONFIG_SPI_SIFIVE_MODULE: u32 = 1;
pub const CONFIG_IIO_ST_ACCEL_SPI_3AXIS_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_INTEL_COMMON_MODULE: u32 = 1;
pub const CONFIG_MAX_SKB_FRAGS: u32 = 17;
pub const CONFIG_USERFAULTFD: u32 = 1;
pub const CONFIG_MFD_DA9062_MODULE: u32 = 1;
pub const CONFIG_X86_ACPI_CPUFREQ_MODULE: u32 = 1;
pub const CONFIG_SENSORS_PC87427_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_INTEL_SOUNDWIRE_MODULE: u32 = 1;
pub const CONFIG_BOOT_PRINTK_DELAY: u32 = 1;
pub const CONFIG_AD5360_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_ACOMP2: u32 = 1;
pub const CONFIG_SND_CA0106_MODULE: u32 = 1;
pub const CONFIG_LEDS_EXPRESSWIRE: u32 = 1;
pub const CONFIG_VIDEO_AU0828_V4L2: u32 = 1;
pub const CONFIG_DM_WRITECACHE_MODULE: u32 = 1;
pub const CONFIG_HOTPLUG_PCI_ACPI_IBM_MODULE: u32 = 1;
pub const CONFIG_VIDEO_APTINA_PLL_MODULE: u32 = 1;
pub const CONFIG_DRM_I915_TIMESLICE_DURATION: u32 = 1;
pub const CONFIG_SND_SOC_ADAU7002_MODULE: u32 = 1;
pub const CONFIG_SENSORS_W83773G_MODULE: u32 = 1;
pub const CONFIG_V4L2_CCI_I2C_MODULE: u32 = 1;
pub const CONFIG_NF_NAT_TFTP_MODULE: u32 = 1;
pub const CONFIG_RTW88_8723D_MODULE: u32 = 1;
pub const CONFIG_MFD_CS42L43_SDW_MODULE: u32 = 1;
pub const CONFIG_PPS_CLIENT_GPIO_MODULE: u32 = 1;
pub const CONFIG_INET_TABLE_PERTURB_ORDER: u32 = 16;
pub const CONFIG_BACKLIGHT_BD6107_MODULE: u32 = 1;
pub const CONFIG_SND_ALS300_MODULE: u32 = 1;
pub const CONFIG_LEDS_TRIGGER_MTD: u32 = 1;
pub const CONFIG_VIRTIO_INPUT_MODULE: u32 = 1;
pub const CONFIG_IIO_SW_TRIGGER_MODULE: u32 = 1;
pub const CONFIG_HID_LOGITECH_MODULE: u32 = 1;
pub const CONFIG_SND_NM256_MODULE: u32 = 1;
pub const CONFIG_IXGBEVF_IPSEC: u32 = 1;
pub const CONFIG_SND_SOC_SOF_AMD_REMBRANDT_MODULE: u32 = 1;
pub const CONFIG_MAX30102_MODULE: u32 = 1;
pub const CONFIG_NITRO_ENCLAVES_MODULE: u32 = 1;
pub const CONFIG_HW_RANDOM_VIA_MODULE: u32 = 1;
pub const CONFIG_IO_DELAY_0X80: u32 = 1;
pub const CONFIG_KEYBOARD_NEWTON_MODULE: u32 = 1;
pub const CONFIG_X86_X32_ABI: u32 = 1;
pub const CONFIG_RT2X00_LIB_USB_MODULE: u32 = 1;
pub const CONFIG_CORTINA_PHY_MODULE: u32 = 1;
pub const CONFIG_SENSORS_HMC5843_SPI_MODULE: u32 = 1;
pub const CONFIG_IIO_BUFFER: u32 = 1;
pub const CONFIG_INPUT_RAVE_SP_PWRBUTTON_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SSM4567_MODULE: u32 = 1;
pub const CONFIG_GPIO_SCH311X_MODULE: u32 = 1;
pub const CONFIG_LIQUIDIO_VF_MODULE: u32 = 1;
pub const CONFIG_DS1803_MODULE: u32 = 1;
pub const CONFIG_DVB_B2C2_FLEXCOP_USB_MODULE: u32 = 1;
pub const CONFIG_HAVE_CONTEXT_TRACKING_USER_OFFSTACK: u32 = 1;
pub const CONFIG_INET_ESPINTCP: u32 = 1;
pub const CONFIG_SND_SOC_AW88395_LIB_MODULE: u32 = 1;
pub const CONFIG_SENSORS_FAM15H_POWER_MODULE: u32 = 1;
pub const CONFIG_ISCSI_BOOT_SYSFS_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT712_SDCA_SDW_MODULE: u32 = 1;
pub const CONFIG_TCM_IBLOCK_MODULE: u32 = 1;
pub const CONFIG_TSL4531_MODULE: u32 = 1;
pub const CONFIG_IIO_SYSFS_TRIGGER_MODULE: u32 = 1;
pub const CONFIG_HID_SENSOR_MAGNETOMETER_3D_MODULE: u32 = 1;
pub const CONFIG_AD9739A_MODULE: u32 = 1;
pub const CONFIG_NFC_PN544_I2C_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_I825XX: u32 = 1;
pub const CONFIG_DMA_ENGINE_RAID: u32 = 1;
pub const CONFIG_SENSORS_NCT7904_MODULE: u32 = 1;
pub const CONFIG_NF_CONNTRACK_FTP_MODULE: u32 = 1;
pub const CONFIG_MFD_MP2629_MODULE: u32 = 1;
pub const CONFIG_GPD_POCKET_FAN_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_PCA9450_MODULE: u32 = 1;
pub const CONFIG_MAXLINEAR_86110_PHY_MODULE: u32 = 1;
pub const CONFIG_ZPA2326_MODULE: u32 = 1;
pub const CONFIG_FWCTL_MLX5_MODULE: u32 = 1;
pub const CONFIG_MMU_GATHER_TABLE_FREE: u32 = 1;
pub const CONFIG_PERSISTENT_KEYRINGS: u32 = 1;
pub const CONFIG_BACKLIGHT_DA903X_MODULE: u32 = 1;
pub const CONFIG_CHELSIO_T1_MODULE: u32 = 1;
pub const CONFIG_PMS7003_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_TOPRO_MODULE: u32 = 1;
pub const CONFIG_GPIB_LPVO_MODULE: u32 = 1;
pub const CONFIG_SENSORS_PWM_FAN_MODULE: u32 = 1;
pub const CONFIG_ADXL355_SPI_MODULE: u32 = 1;
pub const CONFIG_BITREVERSE: u32 = 1;
pub const CONFIG_ACPI_LEGACY_TABLES_LOOKUP: u32 = 1;
pub const CONFIG_CRASH_DUMP: u32 = 1;
pub const CONFIG_PSI: u32 = 1;
pub const CONFIG_MAX517_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_KASAN_VMALLOC: u32 = 1;
pub const CONFIG_KEYBOARD_ADC_MODULE: u32 = 1;
pub const CONFIG_IPV6_NDISC_NODETYPE: u32 = 1;
pub const CONFIG_USB_ISP1761_UDC: u32 = 1;
pub const CONFIG_BACKLIGHT_PANDORA_MODULE: u32 = 1;
pub const CONFIG_EDAC_ECS: u32 = 1;
pub const CONFIG_SND_SOC_ES8323_MODULE: u32 = 1;
pub const CONFIG_XEN_PCIDEV_BACKEND_MODULE: u32 = 1;
pub const CONFIG_DRM_GUD_MODULE: u32 = 1;
pub const CONFIG_EXTCON_AXP288_MODULE: u32 = 1;
pub const CONFIG_MFD_CS47L92: u32 = 1;
pub const CONFIG_HID_MONTEREY_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_PACKET_ENGINES: u32 = 1;
pub const CONFIG_MSI_LAPTOP_MODULE: u32 = 1;
pub const CONFIG_GFS2_FS_LOCKING_DLM: u32 = 1;
pub const CONFIG_IIO_BACKEND_MODULE: u32 = 1;
pub const CONFIG_USB_NET_NET1080_MODULE: u32 = 1;
pub const CONFIG_LEDS_DA903X_MODULE: u32 = 1;
pub const CONFIG_INPUT_IQS269A_MODULE: u32 = 1;
pub const CONFIG_NCT6694_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_SPEAKUP_SYNTH_DECEXT_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_SD: u32 = 1;
pub const CONFIG_IIO_ST_GYRO_I2C_3AXIS_MODULE: u32 = 1;
pub const CONFIG_MT76x0U_MODULE: u32 = 1;
pub const CONFIG_INTEL_INT0002_VGPIO_MODULE: u32 = 1;
pub const CONFIG_USB_XHCI_PCI: u32 = 1;
pub const CONFIG_RT2800USB_RT3573: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MODULE: u32 = 1;
pub const CONFIG_SENSORS_VT8231_MODULE: u32 = 1;
pub const CONFIG_HAVE_FTRACE_GRAPH_FUNC: u32 = 1;
pub const CONFIG_ATH9K_BTCOEX_SUPPORT: u32 = 1;
pub const CONFIG_TOUCHSCREEN_HYCON_HY46XX_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS42XX8_I2C_MODULE: u32 = 1;
pub const CONFIG_SSB_DRIVER_PCICORE_POSSIBLE: u32 = 1;
pub const CONFIG_INPUT_MOUSEDEV_PSAUX: u32 = 1;
pub const CONFIG_IIO_ST_MAGN_SPI_3AXIS_MODULE: u32 = 1;
pub const CONFIG_NFC_PN544_MODULE: u32 = 1;
pub const CONFIG_MEMBLOCK_KHO_SCRATCH: u32 = 1;
pub const CONFIG_SCHED_INFO: u32 = 1;
pub const CONFIG_FUSION_CTL_MODULE: u32 = 1;
pub const CONFIG_AD74115_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_ELKHARTLAKE_MODULE: u32 = 1;
pub const CONFIG_ATH10K_TRACING: u32 = 1;
pub const CONFIG_IP_VS_LC_MODULE: u32 = 1;
pub const CONFIG_KVM_EXTERNAL_WRITE_TRACKING: u32 = 1;
pub const CONFIG_NLS_ISO8859_3_MODULE: u32 = 1;
pub const CONFIG_CC_OPTIMIZE_FOR_PERFORMANCE: u32 = 1;
pub const CONFIG_USB_CHIPIDEA_MODULE: u32 = 1;
pub const CONFIG_TPS6105X_MODULE: u32 = 1;
pub const CONFIG_DM_PCACHE_MODULE: u32 = 1;
pub const CONFIG_W1_SLAVE_DS2780_MODULE: u32 = 1;
pub const CONFIG_PVPANIC_MMIO_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WCD939X_SDW_MODULE: u32 = 1;
pub const CONFIG_UDF_FS_MODULE: u32 = 1;
pub const CONFIG_HAVE_KPROBES: u32 = 1;
pub const CONFIG_NET_SCH_ETF_MODULE: u32 = 1;
pub const CONFIG_NVME_FC_MODULE: u32 = 1;
pub const CONFIG_DRM_PANEL_ORISETECH_OTA5601A_MODULE: u32 = 1;
pub const CONFIG_IIO_INV_SENSORS_TIMESTAMP_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_TPS51632_MODULE: u32 = 1;
pub const CONFIG_IGB_HWMON: u32 = 1;
pub const CONFIG_ACPI_HOTPLUG_CPU: u32 = 1;
pub const CONFIG_DEV_DAX_KMEM_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_KRB5_MODULE: u32 = 1;
pub const CONFIG_GPIO_ALTERA_MODULE: u32 = 1;
pub const CONFIG_DEBUG_MEMORY_INIT: u32 = 1;
pub const CONFIG_USB_SERIAL_KEYSPAN_PDA_MODULE: u32 = 1;
pub const CONFIG_BOOTTIME_TRACING: u32 = 1;
pub const CONFIG_VIDEO_CX231XX_DVB_MODULE: u32 = 1;
pub const CONFIG_RC_MAP_MODULE: u32 = 1;
pub const CONFIG_RTLWIFI_USB_MODULE: u32 = 1;
pub const CONFIG_RTL8192D_COMMON_MODULE: u32 = 1;
pub const CONFIG_CM3605_MODULE: u32 = 1;
pub const CONFIG_HAVE_PCSPKR_PLATFORM: u32 = 1;
pub const CONFIG_NLS_UCS2_UTILS_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV5693_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_CA0110_MODULE: u32 = 1;
pub const CONFIG_MEDIA_PLATFORM_DRIVERS: u32 = 1;
pub const CONFIG_RADIO_TEA5764_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TEST_SUPPORT: u32 = 1;
pub const CONFIG_SERIAL_MEN_Z135_MODULE: u32 = 1;
pub const CONFIG_MFD_AXP20X_MODULE: u32 = 1;
pub const CONFIG_HAVE_KVM_CPU_RELAX_INTERCEPT: u32 = 1;
pub const CONFIG_SND_VX_LIB_MODULE: u32 = 1;
pub const CONFIG_HID_JABRA_MODULE: u32 = 1;
pub const CONFIG_VIDEO_ALVIUM_CSI2_MODULE: u32 = 1;
pub const CONFIG_ASN1_ENCODER_MODULE: u32 = 1;
pub const CONFIG_DVB_MB86A16_MODULE: u32 = 1;
pub const CONFIG_ACPI_CPU_FREQ_PSS: u32 = 1;
pub const CONFIG_INTEL_RAPL_MODULE: u32 = 1;
pub const CONFIG_GPIO_ELKHARTLAKE_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_MCP23S08_SPI_MODULE: u32 = 1;
pub const CONFIG_X86_CMOV: u32 = 1;
pub const CONFIG_CHELSIO_INLINE_CRYPTO: u32 = 1;
pub const CONFIG_MTD_PHRAM_MODULE: u32 = 1;
pub const CONFIG_ETHOC_MODULE: u32 = 1;
pub const CONFIG_LWTUNNEL: u32 = 1;
pub const CONFIG_X86_PMEM_LEGACY_DEVICE: u32 = 1;
pub const CONFIG_INTEL_WMI_THUNDERBOLT_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MT6360_MODULE: u32 = 1;
pub const CONFIG_SND_ICE1724_MODULE: u32 = 1;
pub const CONFIG_XPOWER_PMIC_OPREGION: u32 = 1;
pub const CONFIG_OMFS_FS_MODULE: u32 = 1;
pub const CONFIG_SND_RIPTIDE_MODULE: u32 = 1;
pub const CONFIG_BCM_VK_TTY: u32 = 1;
pub const CONFIG_CMA_ALIGNMENT: u32 = 8;
pub const CONFIG_RANDOMIZE_MEMORY: u32 = 1;
pub const CONFIG_SND_HDA_SCODEC_COMPONENT_MODULE: u32 = 1;
pub const CONFIG_MT7601U_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_BPF_MODULE: u32 = 1;
pub const CONFIG_IWLEGACY_MODULE: u32 = 1;
pub const CONFIG_FORCEDETH_MODULE: u32 = 1;
pub const CONFIG_ACER_WIRELESS_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_IPAQ_MODULE: u32 = 1;
pub const CONFIG_RTW88_8723CS_MODULE: u32 = 1;
pub const CONFIG_INTEL_UNCORE_FREQ_CONTROL_TPMI_MODULE: u32 = 1;
pub const CONFIG_FS_ENCRYPTION_INLINE_CRYPT: u32 = 1;
pub const CONFIG_ACPI_BGRT: u32 = 1;
pub const CONFIG_ENC28J60_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SMA1303_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MT6357_MODULE: u32 = 1;
pub const CONFIG_XEN_PVHVM_GUEST: u32 = 1;
pub const CONFIG_SSB_SDIOHOST: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_ALC882_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV9734_MODULE: u32 = 1;
pub const CONFIG_MDIO_THUNDER_MODULE: u32 = 1;
pub const CONFIG_SQUASHFS_COMP_CACHE_FULL: u32 = 1;
pub const CONFIG_SND_SOC_WM8960_MODULE: u32 = 1;
pub const CONFIG_8139TOO_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_XCTR_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_FUJITSU_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_PCF2123_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CX88_VP3054_MODULE: u32 = 1;
pub const CONFIG_RMI4_F1A: u32 = 1;
pub const CONFIG_TYPEC_UCSI_MODULE: u32 = 1;
pub const CONFIG_BATTERY_TWL4030_MADC_MODULE: u32 = 1;
pub const CONFIG_SYSVIPC_SYSCTL: u32 = 1;
pub const CONFIG_USB_SERIAL_OMNINET_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_ROHM_BU21023_MODULE: u32 = 1;
pub const CONFIG_I2C_MUX_MODULE: u32 = 1;
pub const CONFIG_DRM_PANEL: u32 = 1;
pub const CONFIG_PATA_CMD64X_MODULE: u32 = 1;
pub const CONFIG_AIC7XXX_CMDS_PER_DEVICE: u32 = 32;
pub const CONFIG_FANOTIFY: u32 = 1;
pub const CONFIG_LCD_L4F00242T03_MODULE: u32 = 1;
pub const CONFIG_DMADEVICES: u32 = 1;
pub const CONFIG_SND_SOC_SIMPLE_MUX_MODULE: u32 = 1;
pub const CONFIG_TCP_CONG_YEAH_MODULE: u32 = 1;
pub const CONFIG_SENSORS_APPLESMC_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_CPU_PASID: u32 = 1;
pub const CONFIG_FS_MBCACHE: u32 = 1;
pub const CONFIG_LEDS_PCA995X_MODULE: u32 = 1;
pub const CONFIG_RTW88_8821CU_MODULE: u32 = 1;
pub const CONFIG_ZPA2326_I2C_MODULE: u32 = 1;
pub const CONFIG_UEFI_CPER_X86: u32 = 1;
pub const CONFIG_GPIO_REGMAP_MODULE: u32 = 1;
pub const CONFIG_BCM87XX_PHY_MODULE: u32 = 1;
pub const CONFIG_INIT_ON_ALLOC_DEFAULT_ON: u32 = 1;
pub const CONFIG_SQUASHFS_FRAGMENT_CACHE_SIZE: u32 = 3;
pub const CONFIG_TPS68470_PMIC_OPREGION: u32 = 1;
pub const CONFIG_SND_SOC_XILINX_I2S_MODULE: u32 = 1;
pub const CONFIG_PTP_1588_CLOCK_FC3W_MODULE: u32 = 1;
pub const CONFIG_IIO_ST_PRESS_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS48L32_MODULE: u32 = 1;
pub const CONFIG_AXP20X_POWER_MODULE: u32 = 1;
pub const CONFIG_KSM: u32 = 1;
pub const CONFIG_USB_UAS_MODULE: u32 = 1;
pub const CONFIG_CAN_RX_OFFLOAD: u32 = 1;
pub const CONFIG_PHYSICAL_ALIGN: u32 = 2097152;
pub const CONFIG_SND_HWDEP_MODULE: u32 = 1;
pub const CONFIG_AHCI_DWC_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_APPLESPI_MODULE: u32 = 1;
pub const CONFIG_RC_XBOX_DVD_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_LIB_SHA256: u32 = 1;
pub const CONFIG_IIO_ST_LSM6DSX_MODULE: u32 = 1;
pub const CONFIG_AF_RXRPC_IPV6: u32 = 1;
pub const CONFIG_LZ4HC_COMPRESS_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT5677_SPI_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_DMA: u32 = 1;
pub const CONFIG_BT_HCIBTUSB_BCM: u32 = 1;
pub const CONFIG_EDAC_I10NM_MODULE: u32 = 1;
pub const CONFIG_NET_IP_TUNNEL_MODULE: u32 = 1;
pub const CONFIG_AD5592R_MODULE: u32 = 1;
pub const CONFIG_FXAS21002C_I2C_MODULE: u32 = 1;
pub const CONFIG_I2C_DESIGNWARE_PCI: u32 = 1;
pub const CONFIG_HAVE_NOINSTR_HACK: u32 = 1;
pub const CONFIG_SCSI_BNX2X_FCOE_MODULE: u32 = 1;
pub const CONFIG_HAVE_PCI: u32 = 1;
pub const CONFIG_DVB_TDA665x_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_QM1D1C0042_MODULE: u32 = 1;
pub const CONFIG_DM_CLONE_MODULE: u32 = 1;
pub const CONFIG_MFD_CS40L50_SPI_MODULE: u32 = 1;
pub const CONFIG_AD7124_MODULE: u32 = 1;
pub const CONFIG_SERIAL_ALTERA_UART_MODULE: u32 = 1;
pub const CONFIG_INTEGRITY_MACHINE_KEYRING: u32 = 1;
pub const CONFIG_MLXSW_I2C_MODULE: u32 = 1;
pub const CONFIG_NEED_SG_DMA_FLAGS: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_GLK_RT5682_MAX98357A_MACH_MODULE: u32 = 1;
pub const CONFIG_MISDN_INFINEON_MODULE: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_AUTOFDO_CLANG: u32 = 1;
pub const CONFIG_IP_NF_TARGET_SYNPROXY_MODULE: u32 = 1;
pub const CONFIG_USB_KEENE_MODULE: u32 = 1;
pub const CONFIG_SURFACE_HID_MODULE: u32 = 1;
pub const CONFIG_RC_DECODERS: u32 = 1;
pub const CONFIG_MT76x2_COMMON_MODULE: u32 = 1;
pub const CONFIG_BME680_SPI_MODULE: u32 = 1;
pub const CONFIG_AD7380_MODULE: u32 = 1;
pub const CONFIG_W1_SLAVE_SMEM_MODULE: u32 = 1;
pub const CONFIG_I2C_CHT_WC_MODULE: u32 = 1;
pub const CONFIG_DRM_ACCEL_HABANALABS_MODULE: u32 = 1;
pub const CONFIG_INTEL_MEI_VSC_MODULE: u32 = 1;
pub const CONFIG_GP2AP002_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_LIB_BLAKE2S_ARCH: u32 = 1;
pub const CONFIG_SND_SOC_PCM179X_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MT6311_MODULE: u32 = 1;
pub const CONFIG_PATA_TRIFLEX_MODULE: u32 = 1;
pub const CONFIG_ACRN_GUEST: u32 = 1;
pub const CONFIG_DELL_UART_BACKLIGHT_MODULE: u32 = 1;
pub const CONFIG_RTW89_8852B_COMMON_MODULE: u32 = 1;
pub const CONFIG_MFD_LP8788: u32 = 1;
pub const CONFIG_PCMCIA_FDOMAIN_MODULE: u32 = 1;
pub const CONFIG_ISL29020_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_SCODEC_CS35L41_SPI_MODULE: u32 = 1;
pub const CONFIG_6PACK_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_EBT_802_3_MODULE: u32 = 1;
pub const CONFIG_X86_P4_CLOCKMOD_MODULE: u32 = 1;
pub const CONFIG_INTEL_IDMA64_MODULE: u32 = 1;
pub const CONFIG_ACPI_CONTAINER: u32 = 1;
pub const CONFIG_SFC_FALCON_MTD: u32 = 1;
pub const CONFIG_CEC_GPIO_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_M920X_MODULE: u32 = 1;
pub const CONFIG_DVB_TDA10023_MODULE: u32 = 1;
pub const CONFIG_MEDIATEK_MT6370_ADC_MODULE: u32 = 1;
pub const CONFIG_CHR_DEV_SG_MODULE: u32 = 1;
pub const CONFIG_PROBE_EVENTS_BTF_ARGS: u32 = 1;
pub const CONFIG_RTC_DRV_RV3032_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_HW_PTE_YOUNG: u32 = 1;
pub const CONFIG_PINCTRL_CY8C95X0_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_COLIBRI_VF50_MODULE: u32 = 1;
pub const CONFIG_MMU: u32 = 1;
pub const CONFIG_QTNFMAC_PCIE_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_HIRSCHMANN_HELLCREEK_MODULE: u32 = 1;
pub const CONFIG_SSB_DRIVER_PCICORE: u32 = 1;
pub const CONFIG_BACKLIGHT_KTD2801_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_MT2131_MODULE: u32 = 1;
pub const CONFIG_DIBS_MODULE: u32 = 1;
pub const CONFIG_IEEE802154_SOCKET_MODULE: u32 = 1;
pub const CONFIG_HID_NVIDIA_SHIELD_MODULE: u32 = 1;
pub const CONFIG_IP6_NF_MATCH_MH_MODULE: u32 = 1;
pub const CONFIG_SECURITY: u32 = 1;
pub const CONFIG_SND_SOC_TAS2781_FMWLIB_MODULE: u32 = 1;
pub const CONFIG_DRM_MIPI_DSI: u32 = 1;
pub const CONFIG_FS_ENCRYPTION: u32 = 1;
pub const CONFIG_IR_XMP_DECODER_MODULE: u32 = 1;
pub const CONFIG_MEDIA_COMMON_OPTIONS: u32 = 1;
pub const CONFIG_USB_RAW_GADGET_MODULE: u32 = 1;
pub const CONFIG_MSCC_OCELOT_SWITCH_LIB_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_LTC3676_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_RNG2: u32 = 1;
pub const CONFIG_SENSORS_MP5920_MODULE: u32 = 1;
pub const CONFIG_NLS_ISO8859_2_MODULE: u32 = 1;
pub const CONFIG_HID_TIVO_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WM8737_MODULE: u32 = 1;
pub const CONFIG_W1_SLAVE_DS2781_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_RV_RT5682_MACH_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV7640_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AK4118_MODULE: u32 = 1;
pub const CONFIG_IPV6_GRE_MODULE: u32 = 1;
pub const CONFIG_DRM_XE_FORCE_PROBE: &[u8; 1] = b"\0";
pub const CONFIG_SND_HDA_I915: u32 = 1;
pub const CONFIG_W1_MASTER_SGI_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_GPIO_MODULE: u32 = 1;
pub const CONFIG_MUX_ADGS1408_MODULE: u32 = 1;
pub const CONFIG_WILC1000_SDIO_MODULE: u32 = 1;
pub const CONFIG_NET_FOU_IP_TUNNELS: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_EHL_RT5660_MACH_MODULE: u32 = 1;
pub const CONFIG_DRM_LOAD_EDID_FIRMWARE: u32 = 1;
pub const CONFIG_HAVE_DYNAMIC_FTRACE_WITH_REGS: u32 = 1;
pub const CONFIG_INPUT_PWM_VIBRA_MODULE: u32 = 1;
pub const CONFIG_KEXEC_HANDOVER: u32 = 1;
pub const CONFIG_MINIX_FS_MODULE: u32 = 1;
pub const CONFIG_SND_USB_AUDIO_MODULE: u32 = 1;
pub const CONFIG_RC_CORE: u32 = 1;
pub const CONFIG_DVB_VIDTV_MODULE: u32 = 1;
pub const CONFIG_ADXL380_I2C_MODULE: u32 = 1;
pub const CONFIG_BMP280_SPI_MODULE: u32 = 1;
pub const CONFIG_X86_REQUIRED_FEATURE_LM: u32 = 1;
pub const CONFIG_USB_CDNS3_PCI_WRAP_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ASUS_EC_MODULE: u32 = 1;
pub const CONFIG_HAMACHI_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DRBG_CTR: u32 = 1;
pub const CONFIG_XEN_BLKDEV_FRONTEND_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_QFQ_MODULE: u32 = 1;
pub const CONFIG_MANTIS_CORE_MODULE: u32 = 1;
pub const CONFIG_I2C_ZHAOXIN_MODULE: u32 = 1;
pub const CONFIG_LAN865X_MODULE: u32 = 1;
pub const CONFIG_ASUS_NB_WMI_MODULE: u32 = 1;
pub const CONFIG_IPE_POLICY_SIG_SECONDARY_KEYRING: u32 = 1;
pub const CONFIG_DRM_AMD_DC_FP: u32 = 1;
pub const CONFIG_SPI_DESIGNWARE_MODULE: u32 = 1;
pub const CONFIG_ND_BTT_MODULE: u32 = 1;
pub const CONFIG_CAN_KVASER_PCIEFD_MODULE: u32 = 1;
pub const CONFIG_USB_CDNSP_PCI_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_ZYTRONIC: u32 = 1;
pub const CONFIG_SHRINKER_DEBUG: u32 = 1;
pub const CONFIG_CRYPTO_AES_NI_INTEL_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_PCAP_MODULE: u32 = 1;
pub const CONFIG_NFT_OSF_MODULE: u32 = 1;
pub const CONFIG_BME680_I2C_MODULE: u32 = 1;
pub const CONFIG_MOUSE_SYNAPTICS_USB_MODULE: u32 = 1;
pub const CONFIG_MFD_CROS_EC_DEV_MODULE: u32 = 1;
pub const CONFIG_BNGE_MODULE: u32 = 1;
pub const CONFIG_GPIO_AMD8111_MODULE: u32 = 1;
pub const CONFIG_VCAP: u32 = 1;
pub const CONFIG_CFG80211_DEFAULT_PS: u32 = 1;
pub const CONFIG_GPIO_TQMX86_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT722_SDCA_SDW_MODULE: u32 = 1;
pub const CONFIG_XFS_ONLINE_REPAIR: u32 = 1;
pub const CONFIG_BT_LE_L2CAP_ECRED: u32 = 1;
pub const CONFIG_ADMV1014_MODULE: u32 = 1;
pub const CONFIG_MT76_CONNAC_LIB_MODULE: u32 = 1;
pub const CONFIG_CAN_KVASER_PCI_MODULE: u32 = 1;
pub const CONFIG_PSE_TPS23881_MODULE: u32 = 1;
pub const CONFIG_SND_SEQUENCER_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TAS2781_I2C_MODULE: u32 = 1;
pub const CONFIG_SOUNDWIRE_MODULE: u32 = 1;
pub const CONFIG_OPENVSWITCH_GENEVE_MODULE: u32 = 1;
pub const CONFIG_WATCHDOG_PRETIMEOUT_GOV: u32 = 1;
pub const CONFIG_XILLYBUS_MODULE: u32 = 1;
pub const CONFIG_MLXREG_DPU_MODULE: u32 = 1;
pub const CONFIG_NET_TC_SKB_EXT: u32 = 1;
pub const CONFIG_WLAN_VENDOR_MEDIATEK: u32 = 1;
pub const CONFIG_CAN_CALC_BITTIMING: u32 = 1;
pub const CONFIG_IPC_NS: u32 = 1;
pub const CONFIG_RTC_DRV_DS1390_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_DEBUG_VIRTUAL: u32 = 1;
pub const CONFIG_HID_PID: u32 = 1;
pub const CONFIG_PARPORT_PC_SUPERIO: u32 = 1;
pub const CONFIG_SND_SOC_FSL_XCVR_MODULE: u32 = 1;
pub const CONFIG_IOMMU_SUPPORT: u32 = 1;
pub const CONFIG_MUX_GPIO_MODULE: u32 = 1;
pub const CONFIG_IPMI_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_NET_ACT_NAT_MODULE: u32 = 1;
pub const CONFIG_BROADCOM_PHY_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_PALMAS_MODULE: u32 = 1;
pub const CONFIG_OVERLAY_FS_XINO_AUTO: u32 = 1;
pub const CONFIG_USB_CHIPIDEA_MSM_MODULE: u32 = 1;
pub const CONFIG_VDPA_SIM_MODULE: u32 = 1;
pub const CONFIG_DPLL: u32 = 1;
pub const CONFIG_SND_SOC_MAX98357A_MODULE: u32 = 1;
pub const CONFIG_HID_MACALLY_MODULE: u32 = 1;
pub const CONFIG_PATA_PARPORT_KBIC_MODULE: u32 = 1;
pub const CONFIG_VFIO_IOMMU_TYPE1_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_ADI_MODULE: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_KEXEC_PURGATORY: u32 = 1;
pub const CONFIG_MEMBARRIER: u32 = 1;
pub const CONFIG_SND_SOC_WM8961_MODULE: u32 = 1;
pub const CONFIG_SENSORS_DME1737_MODULE: u32 = 1;
pub const CONFIG_ENERGY_MODEL: u32 = 1;
pub const CONFIG_B43_BCMA: u32 = 1;
pub const CONFIG_SND_SOC_TAS5720_MODULE: u32 = 1;
pub const CONFIG_HID_GOOGLE_HAMMER_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_COFFEELAKE_MODULE: u32 = 1;
pub const CONFIG_CHARGER_BQ2515X_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS4341_MODULE: u32 = 1;
pub const CONFIG_EFI_MIXED: u32 = 1;
pub const CONFIG_PCI_IOV: u32 = 1;
pub const CONFIG_AD4030_MODULE: u32 = 1;
pub const CONFIG_AXP288_FUEL_GAUGE_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_NOVATEK_NVT_TS_MODULE: u32 = 1;
pub const CONFIG_USB_VL600_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MP5990_MODULE: u32 = 1;
pub const CONFIG_CPU_IDLE_GOV_MENU: u32 = 1;
pub const CONFIG_INV_ICM42600_MODULE: u32 = 1;
pub const CONFIG_CROS_EC_ISHTP_MODULE: u32 = 1;
pub const CONFIG_NETKIT: u32 = 1;
pub const CONFIG_SENSORS_XDP710_MODULE: u32 = 1;
pub const CONFIG_GPIO_KEMPLD_MODULE: u32 = 1;
pub const CONFIG_GPIO_PCA9570_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_CS_MODULE: u32 = 1;
pub const CONFIG_JFFS2_FS_DEBUG: u32 = 0;
pub const CONFIG_TYPEC_TCPCI_MT6370_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_HELPER_MODULE: u32 = 1;
pub const CONFIG_CRC32_ARCH: u32 = 1;
pub const CONFIG_INFINIBAND_IPOIB_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_FUJITSU: u32 = 1;
pub const CONFIG_I2C_SI4713_MODULE: u32 = 1;
pub const CONFIG_I40E_DCB: u32 = 1;
pub const CONFIG_X86_16BIT: u32 = 1;
pub const CONFIG_SND_SOC_WM8974_MODULE: u32 = 1;
pub const CONFIG_MACHZ_WDT_MODULE: u32 = 1;
pub const CONFIG_VIDEO_LM3560_MODULE: u32 = 1;
pub const CONFIG_EXTCON_MAX14577_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_MCT_U232_MODULE: u32 = 1;
pub const CONFIG_SND_FIREWIRE_MOTU_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV2640_MODULE: u32 = 1;
pub const CONFIG_SECURITY_TOMOYO_ACTIVATION_TRIGGER: &[u8; 25] = b"/usr/lib/systemd/systemd\0";
pub const CONFIG_VSOCKETS_MODULE: u32 = 1;
pub const CONFIG_SYSTEM_REVOCATION_LIST: u32 = 1;
pub const CONFIG_CHECK_SIGNATURE: u32 = 1;
pub const CONFIG_KEYBOARD_CYPRESS_SF_MODULE: u32 = 1;
pub const CONFIG_QED_OOO: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_CFI: u32 = 1;
pub const CONFIG_MEDIA_DIGITAL_TV_SUPPORT: u32 = 1;
pub const CONFIG_USB_CONFIGFS_RNDIS: u32 = 1;
pub const CONFIG_SENSORS_EMC2305_MODULE: u32 = 1;
pub const CONFIG_MXC4005_MODULE: u32 = 1;
pub const CONFIG_X86_ACPI_CPUFREQ_CPB: u32 = 1;
pub const CONFIG_NET_VENDOR_NETRONOME: u32 = 1;
pub const CONFIG_NET_CLS_CGROUP_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DRBG_MENU: u32 = 1;
pub const CONFIG_CLS_U32_MARK: u32 = 1;
pub const CONFIG_READ_ONLY_THP_FOR_FS: u32 = 1;
pub const CONFIG_ARCH_HAS_PARANOID_L1D_FLUSH: u32 = 1;
pub const CONFIG_SCSI_SNIC_MODULE: u32 = 1;
pub const CONFIG_DVB_LNBH25_MODULE: u32 = 1;
pub const CONFIG_BATTERY_CW2015_MODULE: u32 = 1;
pub const CONFIG_KEBA_CP500_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT1308_MODULE: u32 = 1;
pub const CONFIG_PCI_XEN: u32 = 1;
pub const CONFIG_SND_SOC_CS42L52_MODULE: u32 = 1;
pub const CONFIG_MT7996E_MODULE: u32 = 1;
pub const CONFIG_W1_SLAVE_THERM_MODULE: u32 = 1;
pub const CONFIG_MAX30100_MODULE: u32 = 1;
pub const CONFIG_SECURITY_LOADPIN_ENFORCE: u32 = 1;
pub const CONFIG_VHOST_IOTLB_MODULE: u32 = 1;
pub const CONFIG_IPMI_DMI_DECODE: u32 = 1;
pub const CONFIG_SND_SOC_WM8524_MODULE: u32 = 1;
pub const CONFIG_CW1200_WLAN_SPI_MODULE: u32 = 1;
pub const CONFIG_XZ_DEC: u32 = 1;
pub const CONFIG_HSA_AMD: u32 = 1;
pub const CONFIG_SENSORS_ADS7828_MODULE: u32 = 1;
pub const CONFIG_LCD_VGG2432A4_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_GEMINILAKE_MODULE: u32 = 1;
pub const CONFIG_BMI323_I2C_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_ALC260_MODULE: u32 = 1;
pub const CONFIG_IIO_MS_SENSORS_I2C_MODULE: u32 = 1;
pub const CONFIG_USB_DSBR_MODULE: u32 = 1;
pub const CONFIG_CC_HAS_KASAN_SW_TAGS: u32 = 1;
pub const CONFIG_CIFS_ALLOW_INSECURE_LEGACY: u32 = 1;
pub const CONFIG_EDAC_IGEN6_MODULE: u32 = 1;
pub const CONFIG_ATH11K_MODULE: u32 = 1;
pub const CONFIG_THERMAL_HWMON: u32 = 1;
pub const CONFIG_LEDS_TRIGGER_CPU: u32 = 1;
pub const CONFIG_GPIO_JANZ_TTL_MODULE: u32 = 1;
pub const CONFIG_HAVE_OBJTOOL: u32 = 1;
pub const CONFIG_MLX5_EN_ARFS: u32 = 1;
pub const CONFIG_HAVE_KERNEL_LZ4: u32 = 1;
pub const CONFIG_PCI_QUIRKS: u32 = 1;
pub const CONFIG_MFD_CS40L50_I2C_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_TAG_BRCM_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_FQ_CODEL: u32 = 1;
pub const CONFIG_IPV6_ILA_MODULE: u32 = 1;
pub const CONFIG_WM831X_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_PLX_DMA_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_FUNGIBLE: u32 = 1;
pub const CONFIG_PATA_MARVELL_MODULE: u32 = 1;
pub const CONFIG_MTD_NAND_NANDSIM_MODULE: u32 = 1;
pub const CONFIG_GENERIC_PINCONF: u32 = 1;
pub const CONFIG_MOUSE_PS2_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_SI2157_MODULE: u32 = 1;
pub const CONFIG_DW_DMAC_PCI: u32 = 1;
pub const CONFIG_NFS_COMMON_LOCALIO_SUPPORT_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_DA9034_MODULE: u32 = 1;
pub const CONFIG_BLK_CGROUP_IOPRIO: u32 = 1;
pub const CONFIG_IPACK_BUS_MODULE: u32 = 1;
pub const CONFIG_SCSI_FLASHPOINT: u32 = 1;
pub const CONFIG_MD: u32 = 1;
pub const CONFIG_EFI_DEV_PATH_PARSER: u32 = 1;
pub const CONFIG_INTEL_DC_TI_ADC_MODULE: u32 = 1;
pub const CONFIG_I2C_VIRTIO_MODULE: u32 = 1;
pub const CONFIG_PCPU_DEV_REFCNT: u32 = 1;
pub const CONFIG_SPI_SLAVE_SYSTEM_CONTROL_MODULE: u32 = 1;
pub const CONFIG_PVPANIC: u32 = 1;
pub const CONFIG_I40E_MODULE: u32 = 1;
pub const CONFIG_IR_ITE_CIR_MODULE: u32 = 1;
pub const CONFIG_MFD_CS47L90: u32 = 1;
pub const CONFIG_RTC_DRV_DS1347_MODULE: u32 = 1;
pub const CONFIG_MTRR_SANITIZER_SPARE_REG_NR_DEFAULT: u32 = 0;
pub const CONFIG_EDAC_ATOMIC_SCRUB: u32 = 1;
pub const CONFIG_SND_SOC_RT5631_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_AMAZON: u32 = 1;
pub const CONFIG_MODULE_UNLOAD: u32 = 1;
pub const CONFIG_NET_VENDOR_INTEL: u32 = 1;
pub const CONFIG_IGB_DCA: u32 = 1;
pub const CONFIG_THERMAL_DEFAULT_GOV_STEP_WISE: u32 = 1;
pub const CONFIG_DVB_TDA8261_MODULE: u32 = 1;
pub const CONFIG_ATH9K_RFKILL: u32 = 1;
pub const CONFIG_SENSORS_MENF21BMC_HWMON_MODULE: u32 = 1;
pub const CONFIG_BATTERY_MAX17042_MODULE: u32 = 1;
pub const CONFIG_XEN_XENBUS_FRONTEND: u32 = 1;
pub const CONFIG_FPGA_DFL_FME_MGR_MODULE: u32 = 1;
pub const CONFIG_CONSOLE_LOGLEVEL_DEFAULT: u32 = 4;
pub const CONFIG_CADENCE_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_RT2800USB_RT55XX: u32 = 1;
pub const CONFIG_SPEAKUP_SYNTH_LTLK_MODULE: u32 = 1;
pub const CONFIG_DVB_DIB7000M_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_T613_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_ADP5055_MODULE: u32 = 1;
pub const CONFIG_VITESSE_PHY_MODULE: u32 = 1;
pub const CONFIG_TCP_CONG_BIC_MODULE: u32 = 1;
pub const CONFIG_IGBVF_MODULE: u32 = 1;
pub const CONFIG_PAGE_COUNTER: u32 = 1;
pub const CONFIG_CONSOLE_TRANSLATIONS: u32 = 1;
pub const CONFIG_IP_VS_RR_MODULE: u32 = 1;
pub const CONFIG_CPU_FREQ_GOV_POWERSAVE: u32 = 1;
pub const CONFIG_CRYPTO_TWOFISH_COMMON_MODULE: u32 = 1;
pub const CONFIG_USB_ACM_MODULE: u32 = 1;
pub const CONFIG_DVB_CX22700_MODULE: u32 = 1;
pub const CONFIG_SENSORS_IR36021_MODULE: u32 = 1;
pub const CONFIG_WATCHDOG_OPEN_TIMEOUT: u32 = 0;
pub const CONFIG_GPIO_LATCH_MODULE: u32 = 1;
pub const CONFIG_BUILDTIME_TABLE_SORT: u32 = 1;
pub const CONFIG_BATTERY_DS2760_MODULE: u32 = 1;
pub const CONFIG_NLS_ISO8859_5_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_VP702X_MODULE: u32 = 1;
pub const CONFIG_E1000E_MODULE: u32 = 1;
pub const CONFIG_HAVE_CONTEXT_TRACKING_USER: u32 = 1;
pub const CONFIG_SND_SOC_SOF_AMD_VANGOGH_MODULE: u32 = 1;
pub const CONFIG_IEEE802154_DRIVERS_MODULE: u32 = 1;
pub const CONFIG_BINFMT_SCRIPT: u32 = 1;
pub const CONFIG_OPT4060_MODULE: u32 = 1;
pub const CONFIG_CPU_IDLE_GOV_LADDER: u32 = 1;
pub const CONFIG_SENSORS_CORSAIR_PSU_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_COPY_MC: u32 = 1;
pub const CONFIG_MD_RAID1_MODULE: u32 = 1;
pub const CONFIG_VIRTIO_NET_MODULE: u32 = 1;
pub const CONFIG_PINMUX: u32 = 1;
pub const CONFIG_REGULATOR_PV88060_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_SIG2: u32 = 1;
pub const CONFIG_XFS_DRAIN_INTENTS: u32 = 1;
pub const CONFIG_LCD_ILI9320_MODULE: u32 = 1;
pub const CONFIG_XEN_MEMORY_HOTPLUG_LIMIT: u32 = 512;
pub const CONFIG_MAC80211_MODULE: u32 = 1;
pub const CONFIG_ATLAS_EZO_SENSOR_MODULE: u32 = 1;
pub const CONFIG_DVB_STV0910_MODULE: u32 = 1;
pub const CONFIG_THRUSTMASTER_FF: u32 = 1;
pub const CONFIG_SND_MIXER_OSS_MODULE: u32 = 1;
pub const CONFIG_RTW88_8822CU_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WM8741_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SOF_CML_RT1011_RT5682_MACH_MODULE: u32 = 1;
pub const CONFIG_MYRI10GE_DCA: u32 = 1;
pub const CONFIG_MEDIA_TUNER_TDA18271_MODULE: u32 = 1;
pub const CONFIG_MULTIUSER: u32 = 1;
pub const CONFIG_RETU_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_842_MODULE: u32 = 1;
pub const CONFIG_USB_AN2720: u32 = 1;
pub const CONFIG_FONT_8x16: u32 = 1;
pub const CONFIG_HWLAT_TRACER: u32 = 1;
pub const CONFIG_SND_USB_US122L_MODULE: u32 = 1;
pub const CONFIG_PCMCIA_3C574_MODULE: u32 = 1;
pub const CONFIG_LIBERTAS_MODULE: u32 = 1;
pub const CONFIG_NLS_MAC_ROMAN_MODULE: u32 = 1;
pub const CONFIG_RTW88_8822C_MODULE: u32 = 1;
pub const CONFIG_PPP_MODULE: u32 = 1;
pub const CONFIG_ZOPT2201_MODULE: u32 = 1;
pub const CONFIG_HID_SENSOR_CUSTOM_INTEL_HINGE_MODULE: u32 = 1;
pub const CONFIG_PNP_DEBUG_MESSAGES: u32 = 1;
pub const CONFIG_HAVE_KVM_IRQ_ROUTING: u32 = 1;
pub const CONFIG_NETFILTER_SKIP_EGRESS: u32 = 1;
pub const CONFIG_TOOLS_SUPPORT_RELR: u32 = 1;
pub const CONFIG_SND_SOC_WM8804_SPI_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_IGMP_SNOOPING: u32 = 1;
pub const CONFIG_SECURITY_SELINUX_AVC_STATS: u32 = 1;
pub const CONFIG_USB_GSPCA_JL2005BCD_MODULE: u32 = 1;
pub const CONFIG_VCNL4035_MODULE: u32 = 1;
pub const CONFIG_I2C_DLN2_MODULE: u32 = 1;
pub const CONFIG_CMA: u32 = 1;
pub const CONFIG_USB_LINK_LAYER_TEST_MODULE: u32 = 1;
pub const CONFIG_SND_USB_TONEPORT_MODULE: u32 = 1;
pub const CONFIG_IP6_NF_FILTER_MODULE: u32 = 1;
pub const CONFIG_HID_SAITEK_MODULE: u32 = 1;
pub const CONFIG_CAN_UCAN_MODULE: u32 = 1;
pub const CONFIG_PATA_PCMCIA_MODULE: u32 = 1;
pub const CONFIG_IP_NF_ARPTABLES_MODULE: u32 = 1;
pub const CONFIG_HID_VIVALDI_MODULE: u32 = 1;
pub const CONFIG_MHI_WWAN_CTRL_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_MARK_MODULE: u32 = 1;
pub const CONFIG_EDAC_I3200_MODULE: u32 = 1;
pub const CONFIG_CHARGER_GPIO_MODULE: u32 = 1;
pub const CONFIG_SPI_SC18IS602_MODULE: u32 = 1;
pub const CONFIG_SCSI_DH: u32 = 1;
pub const CONFIG_HID_ACRUX_MODULE: u32 = 1;
pub const CONFIG_MFD_RETU_MODULE: u32 = 1;
pub const CONFIG_VIRT_XFER_TO_GUEST_WORK: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_LENGTH_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_M41T80_MODULE: u32 = 1;
pub const CONFIG_TMPFS_XATTR: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_GUNZE: u32 = 1;
pub const CONFIG_NEED_PER_CPU_PAGE_FIRST_CHUNK: u32 = 1;
pub const CONFIG_SND_SOC_WM8962_MODULE: u32 = 1;
pub const CONFIG_BRCMFMAC_PCIE: u32 = 1;
pub const CONFIG_TCG_INFINEON_MODULE: u32 = 1;
pub const CONFIG_DRM_XE_TIMESLICE_MIN: u32 = 1;
pub const CONFIG_RTC_DRV_FTRTC010_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_HDMI_GENERIC_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DS1307_CENTURY: u32 = 1;
pub const CONFIG_DVB_BCM3510_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_AD7877_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ADAU1761_SPI_MODULE: u32 = 1;
pub const CONFIG_BLOCK: u32 = 1;
pub const CONFIG_CYPRESS_FIRMWARE_MODULE: u32 = 1;
pub const CONFIG_PCI_LABEL: u32 = 1;
pub const CONFIG_MFD_BQ257XX_MODULE: u32 = 1;
pub const CONFIG_SLICOSS_MODULE: u32 = 1;
pub const CONFIG_TWL6040_CORE: u32 = 1;
pub const CONFIG_SND_LX6464ES_MODULE: u32 = 1;
pub const CONFIG_PTP_1588_CLOCK_OPTIONAL_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_JITTERENTROPY_MEMORY_BLOCKS: u32 = 64;
pub const CONFIG_DM_BUFIO_MODULE: u32 = 1;
pub const CONFIG_V4L2_FLASH_LED_CLASS_MODULE: u32 = 1;
pub const CONFIG_PRINTK_INDEX: u32 = 1;
pub const CONFIG_SPEAKUP_SYNTH_TXPRT_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_3COM: u32 = 1;
pub const CONFIG_MPTCP: u32 = 1;
pub const CONFIG_TYPEC_TCPCI_MAXIM_MODULE: u32 = 1;
pub const CONFIG_CPU_FREQ: u32 = 1;
pub const CONFIG_STACKTRACE_BUILD_ID: u32 = 1;
pub const CONFIG_USB_G_SERIAL_MODULE: u32 = 1;
pub const CONFIG_FAT_DEFAULT_IOCHARSET: &[u8; 6] = b"ascii\0";
pub const CONFIG_SND_SOC_MAX98388_MODULE: u32 = 1;
pub const CONFIG_SENSORS_DS620_MODULE: u32 = 1;
pub const CONFIG_NFSD_PNFS: u32 = 1;
pub const CONFIG_TTY: u32 = 1;
pub const CONFIG_USB_GR_UDC_MODULE: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_PMD_PFNMAP: u32 = 1;
pub const CONFIG_HPET_EMULATE_RTC: u32 = 1;
pub const CONFIG_MITIGATION_TSA: u32 = 1;
pub const CONFIG_HAVE_UNSTABLE_SCHED_CLOCK: u32 = 1;
pub const CONFIG_DVB_USB_ZD1301_MODULE: u32 = 1;
pub const CONFIG_DECOMPRESS_LZMA: u32 = 1;
pub const CONFIG_DVB_MANTIS_MODULE: u32 = 1;
pub const CONFIG_IR_IGUANA_MODULE: u32 = 1;
pub const CONFIG_DRM_SYSFB_HELPER: u32 = 1;
pub const CONFIG_SND_SOC_AK4375_MODULE: u32 = 1;
pub const CONFIG_CEC_NXP_TDA9950_MODULE: u32 = 1;
pub const CONFIG_IPW2200_MONITOR: u32 = 1;
pub const CONFIG_842_DECOMPRESS_MODULE: u32 = 1;
pub const CONFIG_FEALNX_MODULE: u32 = 1;
pub const CONFIG_I40EVF_MODULE: u32 = 1;
pub const CONFIG_CFS_BANDWIDTH: u32 = 1;
pub const CONFIG_LEDS_LM3530_MODULE: u32 = 1;
pub const CONFIG_MOUSE_PS2_CYPRESS: u32 = 1;
pub const CONFIG_B43_BCMA_PIO: u32 = 1;
pub const CONFIG_X86_DISABLED_FEATURE_K6_MTRR: u32 = 1;
pub const CONFIG_ACPI_TAD_MODULE: u32 = 1;
pub const CONFIG_SYMBOLIC_ERRNAME: u32 = 1;
pub const CONFIG_SENSORS_LINEAGE_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CX88_ENABLE_VP3054: u32 = 1;
pub const CONFIG_ARCH_HAS_CPU_RESCTRL: u32 = 1;
pub const CONFIG_CAN_PEAK_USB_MODULE: u32 = 1;
pub const CONFIG_LEDS_AW200XX_MODULE: u32 = 1;
pub const CONFIG_CHARGER_BQ257XX_MODULE: u32 = 1;
pub const CONFIG_QUEUED_SPINLOCKS: u32 = 1;
pub const CONFIG_SENSORS_LTC2978_MODULE: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_INT128: u32 = 1;
pub const CONFIG_TCP_CONG_BBR_MODULE: u32 = 1;
pub const CONFIG_PATA_PARPORT_ATEN_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_MD4_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_CONSOLE: u32 = 1;
pub const CONFIG_LOCK_MM_AND_FIND_VMA: u32 = 1;
pub const CONFIG_SOC_BUS: u32 = 1;
pub const CONFIG_JOYSTICK_WALKERA0701_MODULE: u32 = 1;
pub const CONFIG_MODULE_SIG_HASH: &[u8; 7] = b"sha512\0";
pub const CONFIG_NETWORK_PHY_TIMESTAMPING: u32 = 1;
pub const CONFIG_APPLICOM_MODULE: u32 = 1;
pub const CONFIG_PROC_KCORE: u32 = 1;
pub const CONFIG_ARCH_USE_CMPXCHG_LOCKREF: u32 = 1;
pub const CONFIG_FW_LOADER_DEBUG: u32 = 1;
pub const CONFIG_RTW88_LEDS: u32 = 1;
pub const CONFIG_CRYPTO_GHASH_CLMUL_NI_INTEL_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CX25840_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_GPIO_MODULE: u32 = 1;
pub const CONFIG_XFS_POSIX_ACL: u32 = 1;
pub const CONFIG_BLK_MQ_STACKING: u32 = 1;
pub const CONFIG_LEDS_BLINKM_MULTICOLOR: u32 = 1;
pub const CONFIG_TEST_POWER_MODULE: u32 = 1;
pub const CONFIG_SFC_SIENA_MCDI_MON: u32 = 1;
pub const CONFIG_CHARGER_SURFACE_MODULE: u32 = 1;
pub const CONFIG_SENSORS_NZXT_KRAKEN2_MODULE: u32 = 1;
pub const CONFIG_AOSONG_AGS02MA_MODULE: u32 = 1;
pub const CONFIG_HAVE_TRUSTED_KEYS: u32 = 1;
pub const CONFIG_SND_SOC_ES8326_MODULE: u32 = 1;
pub const CONFIG_MERAKI_MX100_MODULE: u32 = 1;
pub const CONFIG_CARL9170_LEDS: u32 = 1;
pub const CONFIG_NF_DUP_NETDEV_MODULE: u32 = 1;
pub const CONFIG_NET_ACT_CSUM_MODULE: u32 = 1;
pub const CONFIG_AD5593R_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_TDA9887_MODULE: u32 = 1;
pub const CONFIG_CROS_EC_CHARDEV_MODULE: u32 = 1;
pub const CONFIG_SCSI_UFSHCD_MODULE: u32 = 1;
pub const CONFIG_POWERCAP: u32 = 1;
pub const CONFIG_CHARGER_RT5033_MODULE: u32 = 1;
pub const CONFIG_IOMMUFD_MODULE: u32 = 1;
pub const CONFIG_TIMERLAT_TRACER: u32 = 1;
pub const CONFIG_MICROCHIP_T1_PHY_MODULE: u32 = 1;
pub const CONFIG_INET6_IPCOMP_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_SP_CCP: u32 = 1;
pub const CONFIG_TOUCHSCREEN_EKTF2127_MODULE: u32 = 1;
pub const CONFIG_FW_LOADER_SYSFS: u32 = 1;
pub const CONFIG_NFT_COMPAT_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_TAG_XRS700X_MODULE: u32 = 1;
pub const CONFIG_HAVE_KERNEL_XZ: u32 = 1;
pub const CONFIG_RTC_DRV_CMOS: u32 = 1;
pub const CONFIG_CRYPTO_ALGAPI2: u32 = 1;
pub const CONFIG_SQUASHFS_ZSTD: u32 = 1;
pub const CONFIG_SCSI_PMCRAID_MODULE: u32 = 1;
pub const CONFIG_DMA_CMA: u32 = 1;
pub const CONFIG_BCM7XXX_PHY_MODULE: u32 = 1;
pub const CONFIG_SENSORS_SBTSI_MODULE: u32 = 1;
pub const CONFIG_CPU_MITIGATIONS: u32 = 1;
pub const CONFIG_TOUCHSCREEN_WM97XX_MODULE: u32 = 1;
pub const CONFIG_OCFS2_DEBUG_MASKLOG: u32 = 1;
pub const CONFIG_MEDIA_TUNER_R820T_MODULE: u32 = 1;
pub const CONFIG_NTB_MODULE: u32 = 1;
pub const CONFIG_NLS_ISO8859_4_MODULE: u32 = 1;
pub const CONFIG_INTEL_CHTDC_TI_PWRBTN_MODULE: u32 = 1;
pub const CONFIG_RAID6_PQ: u32 = 1;
pub const CONFIG_SND_BEBOB_MODULE: u32 = 1;
pub const CONFIG_DRM_I915_GVT_KVMGT_MODULE: u32 = 1;
pub const CONFIG_ATM_FORE200E_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_SUR40_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_SLG51000_MODULE: u32 = 1;
pub const CONFIG_HID_WACOM_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MP2975_MODULE: u32 = 1;
pub const CONFIG_MD_RAID0_MODULE: u32 = 1;
pub const CONFIG_TULIP_NAPI: u32 = 1;
pub const CONFIG_CHARGER_MT6370_MODULE: u32 = 1;
pub const CONFIG_CLZ_TAB: u32 = 1;
pub const CONFIG_PROC_MEM_ALWAYS_FORCE: u32 = 1;
pub const CONFIG_SND_INTEL8X0M_MODULE: u32 = 1;
pub const CONFIG_BLKDEV_UBLK_LEGACY_OPCODES: u32 = 1;
pub const CONFIG_SND_CS4281_MODULE: u32 = 1;
pub const CONFIG_CHROME_PLATFORMS: u32 = 1;
pub const CONFIG_IA32_EMULATION: u32 = 1;
pub const CONFIG_ARCH_USES_PG_ARCH_2: u32 = 1;
pub const CONFIG_NVME_TARGET_MODULE: u32 = 1;
pub const CONFIG_PINCONF: u32 = 1;
pub const CONFIG_PM_DEVFREQ_EVENT: u32 = 1;
pub const CONFIG_SF_PDMA_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_PATCH_LOADER: u32 = 1;
pub const CONFIG_GPIO_CGBC_MODULE: u32 = 1;
pub const CONFIG_FUNCTION_ALIGNMENT: u32 = 16;
pub const CONFIG_X86_LOCAL_APIC: u32 = 1;
pub const CONFIG_F2FS_STAT_FS: u32 = 1;
pub const CONFIG_SND_COMPRESS_OFFLOAD_MODULE: u32 = 1;
pub const CONFIG_MODULE_COMPRESS_ZSTD: u32 = 1;
pub const CONFIG_VIRTIO_RTC_PTP: u32 = 1;
pub const CONFIG_SND_DESIGNWARE_I2S_MODULE: u32 = 1;
pub const CONFIG_ATH9K_AHB: u32 = 1;
pub const CONFIG_CFG80211_USE_KERNEL_REGDB_KEYS: u32 = 1;
pub const CONFIG_NCN26000_PHY_MODULE: u32 = 1;
pub const CONFIG_MTRR_SANITIZER_ENABLE_DEFAULT: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_PKTTYPE_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_XTS: u32 = 1;
pub const CONFIG_SND_SOC_SRC4XXX_I2C_MODULE: u32 = 1;
pub const CONFIG_PCMCIA_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_MAC_MODULE: u32 = 1;
pub const CONFIG_IIO_SW_DEVICE_MODULE: u32 = 1;
pub const CONFIG_INET6_ESPINTCP: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SOF_CS42L42_MACH_MODULE: u32 = 1;
pub const CONFIG_AMD_IOMMU: u32 = 1;
pub const CONFIG_DVB_TC90522_MODULE: u32 = 1;
pub const CONFIG_PHY_SAMSUNG_USB2_MODULE: u32 = 1;
pub const CONFIG_LEDS_TRIGGER_HEARTBEAT_MODULE: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_CRASH_HOTPLUG: u32 = 1;
pub const CONFIG_REGULATOR_TPS65086_MODULE: u32 = 1;
pub const CONFIG_INET_SCTP_DIAG_MODULE: u32 = 1;
pub const CONFIG_X86_PLATFORM_DRIVERS_HP: u32 = 1;
pub const CONFIG_SI1133_MODULE: u32 = 1;
pub const CONFIG_RTW88_8822B_MODULE: u32 = 1;
pub const CONFIG_PPS_MODULE: u32 = 1;
pub const CONFIG_NFC_PORT100_MODULE: u32 = 1;
pub const CONFIG_INTERCONNECT: u32 = 1;
pub const CONFIG_MAC80211_HAS_RC: u32 = 1;
pub const CONFIG_CRASH_MAX_MEMORY_RANGES: u32 = 8192;
pub const CONFIG_NLS_MAC_GREEK_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WM8753_MODULE: u32 = 1;
pub const CONFIG_VIDEO_EM28XX_MODULE: u32 = 1;
pub const CONFIG_GLOB: u32 = 1;
pub const CONFIG_RTW89_8851BU_MODULE: u32 = 1;
pub const CONFIG_CAN_SJA1000_ISA_MODULE: u32 = 1;
pub const CONFIG_ATH12K_MODULE: u32 = 1;
pub const CONFIG_OCTEON_EP_VF_MODULE: u32 = 1;
pub const CONFIG_CAN_BCM_MODULE: u32 = 1;
pub const CONFIG_PAC1921_MODULE: u32 = 1;
pub const CONFIG_SPI_MICROCHIP_CORE_QSPI_MODULE: u32 = 1;
pub const CONFIG_SCSI_SYM53C8XX_DMA_ADDRESSING_MODE: u32 = 1;
pub const CONFIG_SENSORS_TMP421_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_MARS_MODULE: u32 = 1;
pub const CONFIG_IP_ROUTE_CLASSID: u32 = 1;
pub const CONFIG_ST_UVIS25_I2C_MODULE: u32 = 1;
pub const CONFIG_VIDEO_VIVID_OSD: u32 = 1;
pub const CONFIG_BACKLIGHT_LV5207LP_MODULE: u32 = 1;
pub const CONFIG_GPIO_MAX7360_MODULE: u32 = 1;
pub const CONFIG_RPMSG_MODULE: u32 = 1;
pub const CONFIG_FM10K_MODULE: u32 = 1;
pub const CONFIG_DEVMEM: u32 = 1;
pub const CONFIG_SENSORS_ADS7871_MODULE: u32 = 1;
pub const CONFIG_USBIP_HOST_MODULE: u32 = 1;
pub const CONFIG_BACKLIGHT_GPIO_MODULE: u32 = 1;
pub const CONFIG_VIDEO_IMX214_MODULE: u32 = 1;
pub const CONFIG_SAMSUNG_Q10_MODULE: u32 = 1;
pub const CONFIG_USB_GADGET_VBUS_DRAW: u32 = 2;
pub const CONFIG_NETFILTER_XT_CONNMARK_MODULE: u32 = 1;
pub const CONFIG_NFS_V4_SECURITY_LABEL: u32 = 1;
pub const CONFIG_MFD_ARIZONA_MODULE: u32 = 1;
pub const CONFIG_ISCSI_IBFT_MODULE: u32 = 1;
pub const CONFIG_DRM_I915_USERFAULT_AUTOSUSPEND: u32 = 250;
pub const CONFIG_KEXEC_CORE: u32 = 1;
pub const CONFIG_MFD_BD9571MWV_MODULE: u32 = 1;
pub const CONFIG_NET_9P_FD_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_TDA18218_MODULE: u32 = 1;
pub const CONFIG_DVB_DRXD_MODULE: u32 = 1;
pub const CONFIG_LSM: &[u8; 37] = b"landlock,lockdown,yama,integrity,bpf\0";
pub const CONFIG_MTD_PSTORE_MODULE: u32 = 1;
pub const CONFIG_ATM_HE_USE_SUNI: u32 = 1;
pub const CONFIG_SND_HDA_EXT_CORE_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_WM8350_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_PKEYS: u32 = 1;
pub const CONFIG_USB_FUNCTIONFS_RNDIS: u32 = 1;
pub const CONFIG_I2C_USBIO_MODULE: u32 = 1;
pub const CONFIG_BMC150_ACCEL_I2C_MODULE: u32 = 1;
pub const CONFIG_DELL_WMI_PRIVACY: u32 = 1;
pub const CONFIG_SND_AMD_ASOC_RENOIR_MODULE: u32 = 1;
pub const CONFIG_PALMAS_GPADC_MODULE: u32 = 1;
pub const CONFIG_HID_RETRODE_MODULE: u32 = 1;
pub const CONFIG_TIPC_MEDIA_IB: u32 = 1;
pub const CONFIG_USB_NET_MCS7830_MODULE: u32 = 1;
pub const CONFIG_GNSS_USB_MODULE: u32 = 1;
pub const CONFIG_FB_CFB_COPYAREA: u32 = 1;
pub const CONFIG_IB700_WDT_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_ALGAPI: u32 = 1;
pub const CONFIG_ICP10100_MODULE: u32 = 1;
pub const CONFIG_DYNAMIC_EVENTS: u32 = 1;
pub const CONFIG_HTU21_MODULE: u32 = 1;
pub const CONFIG_SND_PCXHR_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TLV320AIC23_MODULE: u32 = 1;
pub const CONFIG_CHARGER_MAX77693_MODULE: u32 = 1;
pub const CONFIG_VIRTIO_VFIO_PCI_ADMIN_LEGACY: u32 = 1;
pub const CONFIG_SERIAL_EARLYCON: u32 = 1;
pub const CONFIG_HP_WMI_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_M41T94_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_USER_FRIENDLY_LONG_NAMES: u32 = 1;
pub const CONFIG_CAN_NCT6694_MODULE: u32 = 1;
pub const CONFIG_NF_NAT_IRC_MODULE: u32 = 1;
pub const CONFIG_GET_FREE_REGION: u32 = 1;
pub const CONFIG_USB_F_HID_MODULE: u32 = 1;
pub const CONFIG_AD5770R_MODULE: u32 = 1;
pub const CONFIG_DEVPORT: u32 = 1;
pub const CONFIG_SPI_ALTERA_CORE_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_HKDF_MODULE: u32 = 1;
pub const CONFIG_SENSORS_HIH6130_MODULE: u32 = 1;
pub const CONFIG_MFD_INTEL_M10_BMC_CORE_MODULE: u32 = 1;
pub const CONFIG_USB: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_CT_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_INTEL_ATOM_HIFI_EP_MODULE: u32 = 1;
pub const CONFIG_N_HDLC_MODULE: u32 = 1;
pub const CONFIG_ATH9K_STATION_STATISTICS: u32 = 1;
pub const CONFIG_ELF_CORE: u32 = 1;
pub const CONFIG_MFD_WM831X: u32 = 1;
pub const CONFIG_PCI_HOST_COMMON: u32 = 1;
pub const CONFIG_TASK_DELAY_ACCT: u32 = 1;
pub const CONFIG_F2FS_FS_XATTR: u32 = 1;
pub const CONFIG_JOYSTICK_DB9_MODULE: u32 = 1;
pub const CONFIG_DVB_ATBM8830_MODULE: u32 = 1;
pub const CONFIG_SERIAL_FSL_LPUART_MODULE: u32 = 1;
pub const CONFIG_DM_DELAY_MODULE: u32 = 1;
pub const CONFIG_SCSI_QLOGIC_1280_MODULE: u32 = 1;
pub const CONFIG_DVB_PLL_MODULE: u32 = 1;
pub const CONFIG_THERMAL: u32 = 1;
pub const CONFIG_SPI_AX88796C_COMPRESSION: u32 = 1;
pub const CONFIG_NFC_ST21NFCA_MODULE: u32 = 1;
pub const CONFIG_SI7020_MODULE: u32 = 1;
pub const CONFIG_DEBUG_INFO_DWARF5: u32 = 1;
pub const CONFIG_NETFILTER_BPF_LINK: u32 = 1;
pub const CONFIG_DVB_LG2160_MODULE: u32 = 1;
pub const CONFIG_BEFS_FS_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_TWL4030_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_DLINK: u32 = 1;
pub const CONFIG_IP_SET_HASH_IPPORTNET_MODULE: u32 = 1;
pub const CONFIG_I2C_MUX_MLXCPLD_MODULE: u32 = 1;
pub const CONFIG_SND_USB_US144MKII_MODULE: u32 = 1;
pub const CONFIG_KVM_SMM: u32 = 1;
pub const CONFIG_PPPOE_HASH_BITS: u32 = 4;
pub const CONFIG_CAN_EMS_USB_MODULE: u32 = 1;
pub const CONFIG_FTRACE_SYSCALLS: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_ALC262_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_BROXTON_MODULE: u32 = 1;
pub const CONFIG_NET_TEAM_MODE_ROUNDROBIN_MODULE: u32 = 1;
pub const CONFIG_CAN_VXCAN_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_NOVA_T_USB2_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LTC4245_MODULE: u32 = 1;
pub const CONFIG_SENSORS_AS370_MODULE: u32 = 1;
pub const CONFIG_UCSI_STM32G0_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_MD5: u32 = 1;
pub const CONFIG_SND_DRIVERS: u32 = 1;
pub const CONFIG_REGULATOR_FAN53555_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_EZCHIP: u32 = 1;
pub const CONFIG_IIO_KX022A_SPI_MODULE: u32 = 1;
pub const CONFIG_SND_AC97_POWER_SAVE_DEFAULT: u32 = 10;
pub const CONFIG_INTEL_MEI_LB_MODULE: u32 = 1;
pub const CONFIG_X86_BUS_LOCK_DETECT: u32 = 1;
pub const CONFIG_INPUT_CMA3000_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_CXUSB_ANALOG: u32 = 1;
pub const CONFIG_SMSC9420_MODULE: u32 = 1;
pub const CONFIG_ATH6KL_MODULE: u32 = 1;
pub const CONFIG_INPUT_KEYSPAN_REMOTE_MODULE: u32 = 1;
pub const CONFIG_ATH9K_HTC_MODULE: u32 = 1;
pub const CONFIG_DM_AUDIT: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_POLICY_MODULE: u32 = 1;
pub const CONFIG_HALTPOLL_CPUIDLE_MODULE: u32 = 1;
pub const CONFIG_XZ_DEC_X86: u32 = 1;
pub const CONFIG_USB_ISP1301_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_HWDEP: u32 = 1;
pub const CONFIG_DA9150_GPADC_MODULE: u32 = 1;
pub const CONFIG_VT_CONSOLE_SLEEP: u32 = 1;
pub const CONFIG_NLS_KOI8_U_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_SOCIONEXT: u32 = 1;
pub const CONFIG_SCSI_SPI_ATTRS_MODULE: u32 = 1;
pub const CONFIG_RUSTC_VERSION: u32 = 109200;
pub const CONFIG_CRYPTO_SERPENT_MODULE: u32 = 1;
pub const CONFIG_MTD_BLKDEVS_MODULE: u32 = 1;
pub const CONFIG_SENSORS_NZXT_KRAKEN3_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_MAX7359_MODULE: u32 = 1;
pub const CONFIG_MCP4018_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_BYTCR_RT5640_MACH_MODULE: u32 = 1;
pub const CONFIG_DEBUG_KERNEL: u32 = 1;
pub const CONFIG_MDIO_MSCC_MIIM_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SOUNDWIRE_SOF_MACH_MODULE: u32 = 1;
pub const CONFIG_RCU_NOCB_CPU: u32 = 1;
pub const CONFIG_SURFACE_HOTPLUG_MODULE: u32 = 1;
pub const CONFIG_ASYNC_TX_DMA: u32 = 1;
pub const CONFIG_MFD_MT6370_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_PCM512x_I2C_MODULE: u32 = 1;
pub const CONFIG_DRM_XE_DP_TUNNEL: u32 = 1;
pub const CONFIG_SCSI_QLA_ISCSI_MODULE: u32 = 1;
pub const CONFIG_NVME_TARGET_PASSTHRU: u32 = 1;
pub const CONFIG_CAN_M_CAN_MODULE: u32 = 1;
pub const CONFIG_MOUSE_ELAN_I2C_SMBUS: u32 = 1;
pub const CONFIG_CEC_CORE_MODULE: u32 = 1;
pub const CONFIG_BRCM_TRACING: u32 = 1;
pub const CONFIG_BATTERY_MAX17040_MODULE: u32 = 1;
pub const CONFIG_WLAN_VENDOR_TI: u32 = 1;
pub const CONFIG_EEPROM_93CX6_MODULE: u32 = 1;
pub const CONFIG_VIDEOBUF2_CORE_MODULE: u32 = 1;
pub const CONFIG_ATM_CLIP_MODULE: u32 = 1;
pub const CONFIG_PCIE_EDR: u32 = 1;
pub const CONFIG_USB_SERIAL_DEBUG_MODULE: u32 = 1;
pub const CONFIG_HID_VIEWSONIC_MODULE: u32 = 1;
pub const CONFIG_MISC_FILESYSTEMS: u32 = 1;
pub const CONFIG_QUOTA_TREE_MODULE: u32 = 1;
pub const CONFIG_NFT_FIB_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_REALTEK_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_GHASH_MODULE: u32 = 1;
pub const CONFIG_MDIO_BITBANG_MODULE: u32 = 1;
pub const CONFIG_NET_ACT_TUNNEL_KEY_MODULE: u32 = 1;
pub const CONFIG_CGROUP_RDMA: u32 = 1;
pub const CONFIG_USB_XEN_HCD_MODULE: u32 = 1;
pub const CONFIG_CAN_PLX_PCI_MODULE: u32 = 1;
pub const CONFIG_DP83TD510_PHY_MODULE: u32 = 1;
pub const CONFIG_INOTIFY_USER: u32 = 1;
pub const CONFIG_DVB_CX22702_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_VICAM_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_CHIPONE_ICN8505_MODULE: u32 = 1;
pub const CONFIG_NLS_ISO8859_7_MODULE: u32 = 1;
pub const CONFIG_ALTERA_MSGDMA_MODULE: u32 = 1;
pub const CONFIG_BMI088_ACCEL_SPI_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LTC2947_SPI_MODULE: u32 = 1;
pub const CONFIG_PHYLIB_MODULE: u32 = 1;
pub const CONFIG_HIBMCGE_MODULE: u32 = 1;
pub const CONFIG_B43_HWRNG: u32 = 1;
pub const CONFIG_DVB_GP8PSK_FE_MODULE: u32 = 1;
pub const CONFIG_SQUASHFS_MOUNT_DECOMP_THREADS: u32 = 1;
pub const CONFIG_SPI_MUX_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_RPL_ACP6x_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_GIGANTIC_PAGE: u32 = 1;
pub const CONFIG_KEYBOARD_OPENCORES_MODULE: u32 = 1;
pub const CONFIG_NR_CPUS_DEFAULT: u32 = 8192;
pub const CONFIG_FPGA_DFL_FME_REGION_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TLV320ADCX140_MODULE: u32 = 1;
pub const CONFIG_DEV_DAX_HMEM_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SKL_HDA_DSP_GENERIC_MACH_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_TPS65090_MODULE: u32 = 1;
pub const CONFIG_NET_EMATCH_IPT_MODULE: u32 = 1;
pub const CONFIG_USB_MICROTEK_MODULE: u32 = 1;
pub const CONFIG_HDMI: u32 = 1;
pub const CONFIG_SND_SOC_RT5659_MODULE: u32 = 1;
pub const CONFIG_NET_UDP_TUNNEL_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_COMPOSITE_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WM8804_I2C_MODULE: u32 = 1;
pub const CONFIG_X86_DEBUGCTLMSR: u32 = 1;
pub const CONFIG_DVB_USB_DIB3000MC_MODULE: u32 = 1;
pub const CONFIG_DRM_GM12U320_MODULE: u32 = 1;
pub const CONFIG_RTW88_8822CS_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_TAG_RTL8_4_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SSM2602_I2C_MODULE: u32 = 1;
pub const CONFIG_SIEMENS_SIMATIC_IPC_BATT_F7188X_MODULE: u32 = 1;
pub const CONFIG_MODULE_FORCE_LOAD: u32 = 1;
pub const CONFIG_GEHC_PMC_ADC_MODULE: u32 = 1;
pub const CONFIG_INPUT_TABLET: u32 = 1;
pub const CONFIG_CRYPTO_BLOWFISH_X86_64_MODULE: u32 = 1;
pub const CONFIG_V4L_PLATFORM_DRIVERS: u32 = 1;
pub const CONFIG_NCSI_OEM_CMD_GET_MAC: u32 = 1;
pub const CONFIG_MAXIM_THERMOCOUPLE_MODULE: u32 = 1;
pub const CONFIG_PPPOE_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_FSL_UTILS_MODULE: u32 = 1;
pub const CONFIG_LIBERTAS_THINFIRM_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_SOFT_DIRTY: u32 = 1;
pub const CONFIG_DP83867_PHY_MODULE: u32 = 1;
pub const CONFIG_XILINX_GMII2RGMII_MODULE: u32 = 1;
pub const CONFIG_SYSFB_SIMPLEFB: u32 = 1;
pub const CONFIG_HUAWEI_WMI_MODULE: u32 = 1;
pub const CONFIG_CAN_GS_USB_MODULE: u32 = 1;
pub const CONFIG_XILINX_DMA_MODULE: u32 = 1;
pub const CONFIG_HAVE_DYNAMIC_FTRACE_WITH_ARGS: u32 = 1;
pub const CONFIG_TSL2583_MODULE: u32 = 1;
pub const CONFIG_PATA_AMD_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_SYSCALL_WRAPPER: u32 = 1;
pub const CONFIG_WLAN_VENDOR_QUANTENNA: u32 = 1;
pub const CONFIG_REED_SOLOMON_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_MMAP_RND_COMPAT_BITS: u32 = 1;
pub const CONFIG_SND_SOC_SOF_JASPERLAKE_MODULE: u32 = 1;
pub const CONFIG_USERIO_MODULE: u32 = 1;
pub const CONFIG_FAT_DEFAULT_CODEPAGE: u32 = 437;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_MAX98357A_MODULE: u32 = 1;
pub const CONFIG_RDMA_SIW_MODULE: u32 = 1;
pub const CONFIG_SCSI_UFS_BSG: u32 = 1;
pub const CONFIG_VIDEO_OV01A10_MODULE: u32 = 1;
pub const CONFIG_RMI4_2D_SENSOR: u32 = 1;
pub const CONFIG_DMA_COHERENT_POOL: u32 = 1;
pub const CONFIG_JSA1212_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LM25066_MODULE: u32 = 1;
pub const CONFIG_AD9834_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_SJA1105_TAS: u32 = 1;
pub const CONFIG_MMC_REALTEK_PCI_MODULE: u32 = 1;
pub const CONFIG_SOUNDWIRE_AMD_MODULE: u32 = 1;
pub const CONFIG_SENSORS_PC87360_MODULE: u32 = 1;
pub const CONFIG_MFD_RC5T583: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_CATPT_MODULE: u32 = 1;
pub const CONFIG_HYPERV: u32 = 1;
pub const CONFIG_NLATTR: u32 = 1;
pub const CONFIG_TI_LMP92064_MODULE: u32 = 1;
pub const CONFIG_SUNRPC_XPRT_RDMA_MODULE: u32 = 1;
pub const CONFIG_DVB_SI21XX_MODULE: u32 = 1;
pub const CONFIG_SLAB_BUCKETS: u32 = 1;
pub const CONFIG_ACPI_PCI_SLOT: u32 = 1;
pub const CONFIG_PDC_ADMA_MODULE: u32 = 1;
pub const CONFIG_RT2800PCI_RT3290: u32 = 1;
pub const CONFIG_HAVE_GUP_FAST: u32 = 1;
pub const CONFIG_SENSORS_Q54SJ108A2_MODULE: u32 = 1;
pub const CONFIG_MLX4_EN_DCB: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_DA7219_MODULE: u32 = 1;
pub const CONFIG_NFT_REJECT_INET_MODULE: u32 = 1;
pub const CONFIG_SND_OXYGEN_LIB_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MAX8893_MODULE: u32 = 1;
pub const CONFIG_CORDIC_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_SSM4567_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SMA1307_MODULE: u32 = 1;
pub const CONFIG_ADXL372_SPI_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_M48T35_MODULE: u32 = 1;
pub const CONFIG_NUMA_BALANCING_DEFAULT_ENABLED: u32 = 1;
pub const CONFIG_MFD_AS3711: u32 = 1;
pub const CONFIG_SCHED_MC: u32 = 1;
pub const CONFIG_HYPERV_KEYBOARD_MODULE: u32 = 1;
pub const CONFIG_PATA_PARPORT_FRPW_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_PCF2127_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_DEFAULT: u32 = 1;
pub const CONFIG_TCP_CONG_ADVANCED: u32 = 1;
pub const CONFIG_CEPH_FS_SECURITY_LABEL: u32 = 1;
pub const CONFIG_AD5761_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_TPS62360_MODULE: u32 = 1;
pub const CONFIG_MLX5_TC_CT: u32 = 1;
pub const CONFIG_ARCH_HAS_CC_PLATFORM: u32 = 1;
pub const CONFIG_SND_SOC_RT5682_MODULE: u32 = 1;
pub const CONFIG_USB_KAWETH_MODULE: u32 = 1;
pub const CONFIG_USB_NET_CDC_MBIM_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LM90_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_QWIIC_MODULE: u32 = 1;
pub const CONFIG_MCTP_TRANSPORT_USB_MODULE: u32 = 1;
pub const CONFIG_CHROMEOS_PRIVACY_SCREEN_MODULE: u32 = 1;
pub const CONFIG_DE2104X_DSL: u32 = 0;
pub const CONFIG_MMU_NOTIFIER: u32 = 1;
pub const CONFIG_NFT_REJECT_NETDEV_MODULE: u32 = 1;
pub const CONFIG_FUSION: u32 = 1;
pub const CONFIG_CRYPTO_CAMELLIA_MODULE: u32 = 1;
pub const CONFIG_HID_GFRM_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_M41T93_MODULE: u32 = 1;
pub const CONFIG_SENSORS_DA9052_ADC_MODULE: u32 = 1;
pub const CONFIG_AD4851_MODULE: u32 = 1;
pub const CONFIG_MEDIA_USB_SUPPORT: u32 = 1;
pub const CONFIG_RTW89_DEBUG: u32 = 1;
pub const CONFIG_ADE9000_MODULE: u32 = 1;
pub const CONFIG_MOUSE_ELAN_I2C_MODULE: u32 = 1;
pub const CONFIG_RTLWIFI_MODULE: u32 = 1;
pub const CONFIG_SMB_SERVER_CHECK_CAP_NET_ADMIN: u32 = 1;
pub const CONFIG_HAVE_EBPF_JIT: u32 = 1;
pub const CONFIG_USB_SERIAL_EMPEG_MODULE: u32 = 1;
pub const CONFIG_NET_ACT_MIRRED_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_ADAPTEC: u32 = 1;
pub const CONFIG_BACKLIGHT_ADP5520_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_WANGXUN: u32 = 1;
pub const CONFIG_INTEGRITY: u32 = 1;
pub const CONFIG_PM_OPP: u32 = 1;
pub const CONFIG_RFS_ACCEL: u32 = 1;
pub const CONFIG_FUNCTION_ALIGNMENT_16B: u32 = 1;
pub const CONFIG_SCSI_MPT3SAS_MODULE: u32 = 1;
pub const CONFIG_YAM_MODULE: u32 = 1;
pub const CONFIG_KALLSYMS: u32 = 1;
pub const CONFIG_SND_SOC_SOF_PCI_DEV_MODULE: u32 = 1;
pub const CONFIG_INPUT_AXP20X_PEK_MODULE: u32 = 1;
pub const CONFIG_X86_AMD_PSTATE_DEFAULT_MODE: u32 = 3;
pub const CONFIG_FUSION_MAX_SGE: u32 = 128;
pub const CONFIG_LEDS_TRIGGER_ACTIVITY_MODULE: u32 = 1;
pub const CONFIG_HID_PLANTRONICS_MODULE: u32 = 1;
pub const CONFIG_HID_SEMITEK_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_RT4831_MODULE: u32 = 1;
pub const CONFIG_SMS_SIANO_MDTV_MODULE: u32 = 1;
pub const CONFIG_INPUT_E3X0_BUTTON_MODULE: u32 = 1;
pub const CONFIG_MDIO_BUS_MODULE: u32 = 1;
pub const CONFIG_XEN_AUTO_XLATE: u32 = 1;
pub const CONFIG_SND_SOC_CS42L51_MODULE: u32 = 1;
pub const CONFIG_I2C_CGBC_MODULE: u32 = 1;
pub const CONFIG_LEDS_LM3532_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_INTEL_TGL_MODULE: u32 = 1;
pub const CONFIG_SLIP_MODE_SLIP6: u32 = 1;
pub const CONFIG_SCSI_MOD: u32 = 1;
pub const CONFIG_SND_SEQ_UMP_CLIENT_MODULE: u32 = 1;
pub const CONFIG_PPS_CLIENT_KTIMER_MODULE: u32 = 1;
pub const CONFIG_INPUT_DRV260X_HAPTICS_MODULE: u32 = 1;
pub const CONFIG_ZSMALLOC_CHAIN_SIZE: u32 = 8;
pub const CONFIG_CUSE_MODULE: u32 = 1;
pub const CONFIG_IIO_MODULE: u32 = 1;
pub const CONFIG_ATH9K_HW_MODULE: u32 = 1;
pub const CONFIG_FUNCTION_GRAPH_TRACER: u32 = 1;
pub const CONFIG_BCMA_DRIVER_GPIO: u32 = 1;
pub const CONFIG_NET_DSA_AR9331_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_MAX8925_MODULE: u32 = 1;
pub const CONFIG_DVB_BUDGET_CI_MODULE: u32 = 1;
pub const CONFIG_MAX5432_MODULE: u32 = 1;
pub const CONFIG_I2C_HELPER_AUTO: u32 = 1;
pub const CONFIG_TOUCHSCREEN_TOUCHWIN_MODULE: u32 = 1;
pub const CONFIG_NTB_IDT_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_ARIZONA_LDO1_MODULE: u32 = 1;
pub const CONFIG_HZ: u32 = 1000;
pub const CONFIG_I2C_PARPORT_MODULE: u32 = 1;
pub const CONFIG_ATH12K_TRACING: u32 = 1;
pub const CONFIG_TRACING: u32 = 1;
pub const CONFIG_ACPI: u32 = 1;
pub const CONFIG_RCU_EXPERT: u32 = 1;
pub const CONFIG_HAMRADIO: u32 = 1;
pub const CONFIG_ARCH_USE_QUEUED_SPINLOCKS: u32 = 1;
pub const CONFIG_SP5100_TCO_MODULE: u32 = 1;
pub const CONFIG_MLX5_TC_SAMPLE: u32 = 1;
pub const CONFIG_IWLWIFI_LEDS: u32 = 1;
pub const CONFIG_CHECKPOINT_RESTORE: u32 = 1;
pub const CONFIG_PCI_LOCKLESS_CONFIG: u32 = 1;
pub const CONFIG_BLK_DEV_DM_MODULE: u32 = 1;
pub const CONFIG_FONT_TER16x32: u32 = 1;
pub const CONFIG_JAILHOUSE_GUEST: u32 = 1;
pub const CONFIG_ICE_HWMON: u32 = 1;
pub const CONFIG_NF_CONNTRACK_LABELS: u32 = 1;
pub const CONFIG_NETFILTER_NETLINK_OSF_MODULE: u32 = 1;
pub const CONFIG_KVM_COMMON: u32 = 1;
pub const CONFIG_W1_SLAVE_DS2406_MODULE: u32 = 1;
pub const CONFIG_RUNTIME_TESTING_MENU: u32 = 1;
pub const CONFIG_SND_SOC_AMD_LEGACY_SDW_MACH_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ISL29018_MODULE: u32 = 1;
pub const CONFIG_ENS160_I2C_MODULE: u32 = 1;
pub const CONFIG_RTW88_PCI_MODULE: u32 = 1;
pub const CONFIG_VIRTUALIZATION: u32 = 1;
pub const CONFIG_MFD_VX855_MODULE: u32 = 1;
pub const CONFIG_EDAC_LEGACY_SYSFS: u32 = 1;
pub const CONFIG_USB_SERIAL_NAVMAN_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS40L50_MODULE: u32 = 1;
pub const CONFIG_USB_CONFIGFS_F_PRINTER: u32 = 1;
pub const CONFIG_TCS3414_MODULE: u32 = 1;
pub const CONFIG_CHELSIO_T4_MODULE: u32 = 1;
pub const CONFIG_DRM_RADEON_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_AZ6027_MODULE: u32 = 1;
pub const CONFIG_NET_CLS_FLOWER_MODULE: u32 = 1;
pub const CONFIG_DVB_MT312_MODULE: u32 = 1;
pub const CONFIG_I2C_KEMPLD_MODULE: u32 = 1;
pub const CONFIG_INTEL_SOC_PMIC_CHTDC_TI_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_IQS5XX_MODULE: u32 = 1;
pub const CONFIG_TASKSTATS: u32 = 1;
pub const CONFIG_TI_TLC4541_MODULE: u32 = 1;
pub const CONFIG_TARGET_CORE_MODULE: u32 = 1;
pub const CONFIG_USB_CONFIGFS_F_FS: u32 = 1;
pub const CONFIG_NFT_FIB_NETDEV_MODULE: u32 = 1;
pub const CONFIG_IP6_NF_TARGET_MASQUERADE_MODULE: u32 = 1;
pub const CONFIG_PTDUMP: u32 = 1;
pub const CONFIG_SND_MIA_MODULE: u32 = 1;
pub const CONFIG_PATA_PARPORT_MODULE: u32 = 1;
pub const CONFIG_INTEL_THC_HID_MODULE: u32 = 1;
pub const CONFIG_VIDEO_IMX258_MODULE: u32 = 1;
pub const CONFIG_MDIO_REGMAP_MODULE: u32 = 1;
pub const CONFIG_CXL_REGION: u32 = 1;
pub const CONFIG_GENERIC_CLOCKEVENTS_BROADCAST_IDLE: u32 = 1;
pub const CONFIG_ZONEFS_FS_MODULE: u32 = 1;
pub const CONFIG_MT76_CORE_MODULE: u32 = 1;
pub const CONFIG_MTDRAM_ERASE_SIZE: u32 = 128;
pub const CONFIG_DYNAMIC_FTRACE_WITH_ARGS: u32 = 1;
pub const CONFIG_RTW89_DEBUGMSG: u32 = 1;
pub const CONFIG_SENSORS_MR75203_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_AUDIT_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_MTOUCH_MODULE: u32 = 1;
pub const CONFIG_ATH9K_DEBUGFS: u32 = 1;
pub const CONFIG_CXL_PORT_MODULE: u32 = 1;
pub const CONFIG_SMPRO_ERRMON_MODULE: u32 = 1;
pub const CONFIG_PHY_PXA_28NM_USB2_MODULE: u32 = 1;
pub const CONFIG_DRM_I915_PXP: u32 = 1;
pub const CONFIG_UIO_SERCOS3_MODULE: u32 = 1;
pub const CONFIG_OPENVSWITCH_MODULE: u32 = 1;
pub const CONFIG_COMMON_CLK_CS2000_CP_MODULE: u32 = 1;
pub const CONFIG_ACPI_FFH: u32 = 1;
pub const CONFIG_SFC_MCDI_LOGGING: u32 = 1;
pub const CONFIG_QLCNIC_DCB: u32 = 1;
pub const CONFIG_IPV6_SIT_MODULE: u32 = 1;
pub const CONFIG_INTEL_SCU_IPC: u32 = 1;
pub const CONFIG_RTC_DRV_WM8350_MODULE: u32 = 1;
pub const CONFIG_RT2800_LIB_MMIO_MODULE: u32 = 1;
pub const CONFIG_AD9523_MODULE: u32 = 1;
pub const CONFIG_DMABUF_HEAPS: u32 = 1;
pub const CONFIG_SND_SOC_RT5645_MODULE: u32 = 1;
pub const CONFIG_OA_TC6_MODULE: u32 = 1;
pub const CONFIG_STE10XP_MODULE: u32 = 1;
pub const CONFIG_FS_POSIX_ACL: u32 = 1;
pub const CONFIG_DVB_CX24110_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_RAM_COUNT: u32 = 16;
pub const CONFIG_INTERVAL_TREE_SPAN_ITER: u32 = 1;
pub const CONFIG_NLS_ISO8859_6_MODULE: u32 = 1;
pub const CONFIG_USB_STORAGE_USBAT_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ADC128D818_MODULE: u32 = 1;
pub const CONFIG_RTW88_8821AU_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_DSCP_MODULE: u32 = 1;
pub const CONFIG_INPUT_ATLAS_BTNS_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_ARIA_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_SQ905C_MODULE: u32 = 1;
pub const CONFIG_MT7921U_MODULE: u32 = 1;
pub const CONFIG_DRM_XE_MODULE: u32 = 1;
pub const CONFIG_INET_RAW_DIAG_MODULE: u32 = 1;
pub const CONFIG_DVB_TDA10086_MODULE: u32 = 1;
pub const CONFIG_ASUS_WIRELESS_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_HDMI_INTEL_MODULE: u32 = 1;
pub const CONFIG_DW_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_VALIDATE_FS_PARSER: u32 = 1;
pub const CONFIG_IR_IMON_MODULE: u32 = 1;
pub const CONFIG_SLIP_COMPRESSED: u32 = 1;
pub const CONFIG_HOTPLUG_PCI_CPCI_GENERIC_MODULE: u32 = 1;
pub const CONFIG_DRM_VMWGFX_MODULE: u32 = 1;
pub const CONFIG_PREEMPTION: u32 = 1;
pub const CONFIG_BINARY_PRINTF: u32 = 1;
pub const CONFIG_SND_SOC_PCM3060_SPI_MODULE: u32 = 1;
pub const CONFIG_INTEL_SCU: u32 = 1;
pub const CONFIG_TIGON3_HWMON: u32 = 1;
pub const CONFIG_HAVE_ARCH_KCSAN: u32 = 1;
pub const CONFIG_UIO_DMEM_GENIRQ_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_SDW_MACH_COMMON_MODULE: u32 = 1;
pub const CONFIG_HAVE_PERF_EVENTS_NMI: u32 = 1;
pub const CONFIG_USB_SERIAL_MOS7715_PARPORT: u32 = 1;
pub const CONFIG_SND_SOC_NAU8315_MODULE: u32 = 1;
pub const CONFIG_VIDEO_RDACM20_MODULE: u32 = 1;
pub const CONFIG_QCOM_TZMEM_MODULE: u32 = 1;
pub const CONFIG_INPUT_ADXL34X_SPI_MODULE: u32 = 1;
pub const CONFIG_MFD_CORE: u32 = 1;
pub const CONFIG_PVPANIC_PCI_MODULE: u32 = 1;
pub const CONFIG_SPI_PXA2XX_PCI_MODULE: u32 = 1;
pub const CONFIG_TRACE_IRQFLAGS_SUPPORT: u32 = 1;
pub const CONFIG_BATTERY_DS2782_MODULE: u32 = 1;
pub const CONFIG_IPVLAN_L3S: u32 = 1;
pub const CONFIG_CRYPTO_XXHASH: u32 = 1;
pub const CONFIG_SENSORS_NCT7363_MODULE: u32 = 1;
pub const CONFIG_AD525X_DPOT_I2C_MODULE: u32 = 1;
pub const CONFIG_IR_SHARP_DECODER_MODULE: u32 = 1;
pub const CONFIG_TIMERFD: u32 = 1;
pub const CONFIG_RTC_HCTOSYS_DEVICE: &[u8; 5] = b"rtc0\0";
pub const CONFIG_JOYSTICK_FSIA6B_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_LPASS_WSA_MACRO_MODULE: u32 = 1;
pub const CONFIG_MFD_DA9055: u32 = 1;
pub const CONFIG_SND_USB_POD_MODULE: u32 = 1;
pub const CONFIG_UFS_FS_MODULE: u32 = 1;
pub const CONFIG_PSTORE_BLK_BLKDEV: &[u8; 1] = b"\0";
pub const CONFIG_USB_STORAGE_FREECOM_MODULE: u32 = 1;
pub const CONFIG_DRM_SSD130X_MODULE: u32 = 1;
pub const CONFIG_PATA_PARPORT_DSTR_MODULE: u32 = 1;
pub const CONFIG_SENSORS_W83627HF_MODULE: u32 = 1;
pub const CONFIG_KEYS_REQUEST_CACHE: u32 = 1;
pub const CONFIG_SEL3350_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_BDW_RT5650_MACH_MODULE: u32 = 1;
pub const CONFIG_MLX5_VFIO_PCI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_NTP8835_MODULE: u32 = 1;
pub const CONFIG_BCM84881_PHY_MODULE: u32 = 1;
pub const CONFIG_SND_JACK_INPUT_DEV: u32 = 1;
pub const CONFIG_MFD_MAX8998: u32 = 1;
pub const CONFIG_JFFS2_FS_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_INTEL_PTL_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_UDA1334_MODULE: u32 = 1;
pub const CONFIG_DRM_CLIENT_SETUP: u32 = 1;
pub const CONFIG_VIDEO_OG0VE1B_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_MYRI: u32 = 1;
pub const CONFIG_NET_VENDOR_META: u32 = 1;
pub const CONFIG_REGULATOR_WM8400_MODULE: u32 = 1;
pub const CONFIG_IKCONFIG_PROC: u32 = 1;
pub const CONFIG_NET_TEAM_MODE_LOADBALANCE_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_ARK3116_MODULE: u32 = 1;
pub const CONFIG_SECURITY_PATH: u32 = 1;
pub const CONFIG_LEDS_PCA955X_MODULE: u32 = 1;
pub const CONFIG_HID_SUNPLUS_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_SERPENT_SSE2_X86_64_MODULE: u32 = 1;
pub const CONFIG_DRM_I915_USERPTR: u32 = 1;
pub const CONFIG_SERIO_I8042: u32 = 1;
pub const CONFIG_NET_IFE_SKBMARK_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_ACPI_MODULE: u32 = 1;
pub const CONFIG_UCLAMP_BUCKETS_COUNT: u32 = 5;
pub const CONFIG_MCP3422_MODULE: u32 = 1;
pub const CONFIG_NF_NAT_SNMP_BASIC_MODULE: u32 = 1;
pub const CONFIG_ADIS16201_MODULE: u32 = 1;
pub const CONFIG_SND_EMU10K1_SEQ_MODULE: u32 = 1;
pub const CONFIG_MEN_A21_WDT_MODULE: u32 = 1;
pub const CONFIG_LLC2_MODULE: u32 = 1;
pub const CONFIG_VMCORE_INFO: u32 = 1;
pub const CONFIG_CAN_MCBA_USB_MODULE: u32 = 1;
pub const CONFIG_SND_KORG1212_MODULE: u32 = 1;
pub const CONFIG_GPIB_TMS9914_MODULE: u32 = 1;
pub const CONFIG_INTEL_TH_ACPI_MODULE: u32 = 1;
pub const CONFIG_TI_ADS7950_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ACPI_MODULE: u32 = 1;
pub const CONFIG_SIOX_MODULE: u32 = 1;
pub const CONFIG_INTEL_TH_GTH_MODULE: u32 = 1;
pub const CONFIG_DRM_PANEL_MIPI_DBI_MODULE: u32 = 1;
pub const CONFIG_DLM_DEBUG: u32 = 1;
pub const CONFIG_SCD4X_MODULE: u32 = 1;
pub const CONFIG_USB_NET_CH9200_MODULE: u32 = 1;
pub const CONFIG_USB_SI470X_MODULE: u32 = 1;
pub const CONFIG_CHARGER_MAX8971_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS35L56_SHARED_MODULE: u32 = 1;
pub const CONFIG_NFT_FWD_NETDEV_MODULE: u32 = 1;
pub const CONFIG_LCD_LMS501KF03_MODULE: u32 = 1;
pub const CONFIG_AD5766_MODULE: u32 = 1;
pub const CONFIG_FB_CORE: u32 = 1;
pub const CONFIG_LENOVO_WMI_HOTKEY_UTILITIES_MODULE: u32 = 1;
pub const CONFIG_DRM_GEM_DMA_HELPER_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LM93_MODULE: u32 = 1;
pub const CONFIG_IRQ_DOMAIN: u32 = 1;
pub const CONFIG_HID_ELO_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_SOUNDWIRE_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_NAU8825_MODULE: u32 = 1;
pub const CONFIG_HAVE_KERNEL_GZIP: u32 = 1;
pub const CONFIG_PROBE_EVENTS: u32 = 1;
pub const CONFIG_BPF_JIT_ALWAYS_ON: u32 = 1;
pub const CONFIG_LDISC_AUTOLOAD: u32 = 1;
pub const CONFIG_MITIGATION_SPECTRE_V1: u32 = 1;
pub const CONFIG_DYNAMIC_DEBUG_CORE: u32 = 1;
pub const CONFIG_XDP_SOCKETS_DIAG_MODULE: u32 = 1;
pub const CONFIG_PCI_PRI: u32 = 1;
pub const CONFIG_ADXL313_SPI_MODULE: u32 = 1;
pub const CONFIG_MFD_JANZ_CMODIO_MODULE: u32 = 1;
pub const CONFIG_SIS190_MODULE: u32 = 1;
pub const CONFIG_DEVICE_PRIVATE: u32 = 1;
pub const CONFIG_CRYPTO_AKCIPHER2: u32 = 1;
pub const CONFIG_WATCHDOG_HANDLE_BOOT_ENABLED: u32 = 1;
pub const CONFIG_INTEL_POWERCLAMP_MODULE: u32 = 1;
pub const CONFIG_NF_NAT_REDIRECT: u32 = 1;
pub const CONFIG_GPIO_TPIC2810_MODULE: u32 = 1;
pub const CONFIG_SECURITY_SELINUX_SIDTAB_HASH_BITS: u32 = 9;
pub const CONFIG_SWIOTLB: u32 = 1;
pub const CONFIG_SENSORS_SMSC47B397_MODULE: u32 = 1;
pub const CONFIG_SCHED_AUTOGROUP: u32 = 1;
pub const CONFIG_GIGABYTE_WMI_MODULE: u32 = 1;
pub const CONFIG_IGC_MODULE: u32 = 1;
pub const CONFIG_FW_ATTR_CLASS_MODULE: u32 = 1;
pub const CONFIG_IP_VS_SH_MODULE: u32 = 1;
pub const CONFIG_USB_XHCI_DBGCAP: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_CPU_MODULE: u32 = 1;
pub const CONFIG_SCSI_MVSAS_DEBUG: u32 = 1;
pub const CONFIG_HAVE_ARCH_HUGE_VMALLOC: u32 = 1;
pub const CONFIG_DEVFREQ_GOV_USERSPACE_MODULE: u32 = 1;
pub const CONFIG_MFD_INTEL_M10_BMC_SPI_MODULE: u32 = 1;
pub const CONFIG_NFT_CONNLIMIT_MODULE: u32 = 1;
pub const CONFIG_INPUT_TWL4030_VIBRA_MODULE: u32 = 1;
pub const CONFIG_LEDS_LM3533_MODULE: u32 = 1;
pub const CONFIG_SCREEN_INFO: u32 = 1;
pub const CONFIG_NLS_MAC_CYRILLIC_MODULE: u32 = 1;
pub const CONFIG_INTEL_MEI_MODULE: u32 = 1;
pub const CONFIG_GPIO_RC5T583: u32 = 1;
pub const CONFIG_BT_BCM_MODULE: u32 = 1;
pub const CONFIG_HARDENED_USERCOPY: u32 = 1;
pub const CONFIG_BUILDTIME_MCOUNT_SORT: u32 = 1;
pub const CONFIG_TOUCHSCREEN_EETI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_ACP_COMMON_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_MARK_MODULE: u32 = 1;
pub const CONFIG_ACPI_EXTLOG_MODULE: u32 = 1;
pub const CONFIG_HAS_IOMEM: u32 = 1;
pub const CONFIG_NET_SCH_BPF: u32 = 1;
pub const CONFIG_SIEMENS_SIMATIC_IPC_BATT_APOLLOLAKE_MODULE: u32 = 1;
pub const CONFIG_HAVE_CMPXCHG_DOUBLE: u32 = 1;
pub const CONFIG_KEYBOARD_MAX7360_MODULE: u32 = 1;
pub const CONFIG_PCIEASPM: u32 = 1;
pub const CONFIG_CMA_AREAS: u32 = 7;
pub const CONFIG_MVMDIO_MODULE: u32 = 1;
pub const CONFIG_SECURITY_APPARMOR_PARANOID_LOAD: u32 = 1;
pub const CONFIG_NETFILTER_XTABLES_MODULE: u32 = 1;
pub const CONFIG_MT7915E_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_SOF_SDW_MACH_MODULE: u32 = 1;
pub const CONFIG_CM36651_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_MXL5007T_MODULE: u32 = 1;
pub const CONFIG_WAFER_WDT_MODULE: u32 = 1;
pub const CONFIG_BT_MRVL_SDIO_MODULE: u32 = 1;
pub const CONFIG_UIO_AEC_MODULE: u32 = 1;
pub const CONFIG_SERIAL_UARTLITE_MODULE: u32 = 1;
pub const CONFIG_LIBIPW_MODULE: u32 = 1;
pub const CONFIG_RESET_TI_TPS380X_MODULE: u32 = 1;
pub const CONFIG_B43LEGACY_MODULE: u32 = 1;
pub const CONFIG_X86_SGX_KVM: u32 = 1;
pub const CONFIG_SCSI_FDOMAIN_PCI_MODULE: u32 = 1;
pub const CONFIG_W1_SLAVE_DS2405_MODULE: u32 = 1;
pub const CONFIG_TRACER_MAX_TRACE: u32 = 1;
pub const CONFIG_KEY_NOTIFICATIONS: u32 = 1;
pub const CONFIG_XEN_GRANT_DMA_OPS: u32 = 1;
pub const CONFIG_USB_USBIO_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TAS2781_COMLIB_I2C_MODULE: u32 = 1;
pub const CONFIG_WWAN_HWSIM_MODULE: u32 = 1;
pub const CONFIG_IPV6_MULTIPLE_TABLES: u32 = 1;
pub const CONFIG_BRIDGE_EBT_T_FILTER_MODULE: u32 = 1;
pub const CONFIG_USB_ADUTUX_MODULE: u32 = 1;
pub const CONFIG_SENSORS_BPA_RS600_MODULE: u32 = 1;
pub const CONFIG_SENSORS_SMPRO_MODULE: u32 = 1;
pub const CONFIG_INTEL_IDXD_PERFMON: u32 = 1;
pub const CONFIG_SND_SOC_ACPI_INTEL_SDCA_QUIRKS_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_LIB_AESCFB: u32 = 1;
pub const CONFIG_BT_HCIBTSDIO_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_DA9062_MODULE: u32 = 1;
pub const CONFIG_SENSORS_IR35221_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_A800_MODULE: u32 = 1;
pub const CONFIG_IR_STREAMZAP_MODULE: u32 = 1;
pub const CONFIG_BNXT_DCB: u32 = 1;
pub const CONFIG_NF_CONNTRACK_PROCFS: u32 = 1;
pub const CONFIG_NF_CONNTRACK_H323_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_FC0011_MODULE: u32 = 1;
pub const CONFIG_HID_UNIVERSAL_PIDFF_MODULE: u32 = 1;
pub const CONFIG_VHOST_NET_MODULE: u32 = 1;
pub const CONFIG_B53_SPI_DRIVER_MODULE: u32 = 1;
pub const CONFIG_IP_VS_PROTO_UDP: u32 = 1;
pub const CONFIG_ARCH_HAS_DEVMEM_IS_ALLOWED: u32 = 1;
pub const CONFIG_USB_CHIPIDEA_UDC: u32 = 1;
pub const CONFIG_XZ_DEC_POWERPC: u32 = 1;
pub const CONFIG_SND_SOC_TAS2770_MODULE: u32 = 1;
pub const CONFIG_BPF: u32 = 1;
pub const CONFIG_USB_CONFIGFS_F_MIDI: u32 = 1;
pub const CONFIG_XZ_DEC_ARM64: u32 = 1;
pub const CONFIG_LOCALVERSION: &[u8; 1] = b"\0";
pub const CONFIG_IIO_CROS_EC_BARO_MODULE: u32 = 1;
pub const CONFIG_MMC_SDHCI_F_SDH30_MODULE: u32 = 1;
pub const CONFIG_USB_CONFIGFS_F_HID: u32 = 1;
pub const CONFIG_INTEL_MRFLD_PWRBTN_MODULE: u32 = 1;
pub const CONFIG_HID_GT683R_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS42XX8_MODULE: u32 = 1;
pub const CONFIG_MOUSE_PS2_SYNAPTICS: u32 = 1;
pub const CONFIG_SND_SOC_TAS2780_MODULE: u32 = 1;
pub const CONFIG_BT_INTEL_MODULE: u32 = 1;
pub const CONFIG_IOSCHED_BFQ: u32 = 1;
pub const CONFIG_AXP288_CHARGER_MODULE: u32 = 1;
pub const CONFIG_LIBETH_MODULE: u32 = 1;
pub const CONFIG_SECURITY_SMACK: u32 = 1;
pub const CONFIG_MICROCHIP_PHY_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_AMD: u32 = 1;
pub const CONFIG_HID_EVISION_MODULE: u32 = 1;
pub const CONFIG_TYPEC_NVIDIA_ALTMODE_MODULE: u32 = 1;
pub const CONFIG_DVB_RTL2830_MODULE: u32 = 1;
pub const CONFIG_USB_STORAGE_DATAFAB_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MPQ8785_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_AF9015_MODULE: u32 = 1;
pub const CONFIG_PATA_HPT366_MODULE: u32 = 1;
pub const CONFIG_HID_TWINHAN_MODULE: u32 = 1;
pub const CONFIG_GPIO_TPS6586X: u32 = 1;
pub const CONFIG_NET_DSA_SJA1105_MODULE: u32 = 1;
pub const CONFIG_REGMAP_MMIO: u32 = 1;
pub const CONFIG_IOMMU_IO_PGTABLE: u32 = 1;
pub const CONFIG_KEXEC: u32 = 1;
pub const CONFIG_MMC_TEST_MODULE: u32 = 1;
pub const CONFIG_TCG_TIS_ST33ZP24_I2C_MODULE: u32 = 1;
pub const CONFIG_SND_ALOOP_MODULE: u32 = 1;
pub const CONFIG_SND_HRTIMER_MODULE: u32 = 1;
pub const CONFIG_HPET: u32 = 1;
pub const CONFIG_NF_NAT_SIP_MODULE: u32 = 1;
pub const CONFIG_SFC_SIENA_MCDI_LOGGING: u32 = 1;
pub const CONFIG_HVC_IRQ: u32 = 1;
pub const CONFIG_B53_MDIO_DRIVER_MODULE: u32 = 1;
pub const CONFIG_RT2X00_LIB_MMIO_MODULE: u32 = 1;
pub const CONFIG_NLS_ISO8859_9_MODULE: u32 = 1;
pub const CONFIG_CHARGER_BD99954_MODULE: u32 = 1;
pub const CONFIG_IP_NF_TARGET_ECN_MODULE: u32 = 1;
pub const CONFIG_INTEL_MEI_WDT_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_PV88090_MODULE: u32 = 1;
pub const CONFIG_PDS_CORE_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_ADIANTUM_MODULE: u32 = 1;
pub const CONFIG_DRM_VIRTIO_GPU_KMS: u32 = 1;
pub const CONFIG_CRYPTO_BLOWFISH_COMMON_MODULE: u32 = 1;
pub const CONFIG_CROS_EC_TYPEC_MODULE: u32 = 1;
pub const CONFIG_DVB_TTUSB_BUDGET_MODULE: u32 = 1;
pub const CONFIG_SLUB: u32 = 1;
pub const CONFIG_SND_SOC_AMD_SOUNDWIRE_LINK_BASELINE_MODULE: u32 = 1;
pub const CONFIG_MFD_LP3943_MODULE: u32 = 1;
pub const CONFIG_X86_POWERNOW_K8_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_ACPI_MACH_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_PRIO_MODULE: u32 = 1;
pub const CONFIG_AD8460_MODULE: u32 = 1;
pub const CONFIG_DA9063_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_IFB_MODULE: u32 = 1;
pub const CONFIG_GPIO_74X164_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS35L56_SPI_MODULE: u32 = 1;
pub const CONFIG_VIDEO_RDACM21_MODULE: u32 = 1;
pub const CONFIG_STACKPROTECTOR: u32 = 1;
pub const CONFIG_INPUT_IMS_PCU_MODULE: u32 = 1;
pub const CONFIG_EXT4_FS_POSIX_ACL: u32 = 1;
pub const CONFIG_NET_VENDOR_AMD: u32 = 1;
pub const CONFIG_T5403_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_UDA1342_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV7670_MODULE: u32 = 1;
pub const CONFIG_BATTERY_DS2781_MODULE: u32 = 1;
pub const CONFIG_MOUSE_PS2_ALPS: u32 = 1;
pub const CONFIG_IR_MCEUSB_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_CP210X_MODULE: u32 = 1;
pub const CONFIG_PTP_NETC_V4_TIMER_MODULE: u32 = 1;
pub const CONFIG_TCG_CRB: u32 = 1;
pub const CONFIG_SLIP_MODULE: u32 = 1;
pub const CONFIG_HP_ILO_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SSM2602_SPI_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV5695_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AW88399_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TOPOLOGY: u32 = 1;
pub const CONFIG_DVB_USB_DW2102_MODULE: u32 = 1;
pub const CONFIG_IP_NF_IPTABLES_MODULE: u32 = 1;
pub const CONFIG_TSM_REPORTS_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ADAU1761_MODULE: u32 = 1;
pub const CONFIG_USB_IOWARRIOR_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MAX20411_MODULE: u32 = 1;
pub const CONFIG_ST_UVIS25_SPI_MODULE: u32 = 1;
pub const CONFIG_DRM_XE_PAGEMAP: u32 = 1;
pub const CONFIG_HID_KENSINGTON_MODULE: u32 = 1;
pub const CONFIG_SND_ES1938_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_STV0680_MODULE: u32 = 1;
pub const CONFIG_B43_PCICORE_AUTOSELECT: u32 = 1;
pub const CONFIG_HAVE_REGS_AND_STACK_ACCESS_API: u32 = 1;
pub const CONFIG_EARLY_PRINTK_DBGP: u32 = 1;
pub const CONFIG_GENERIC_ADC_THERMAL_MODULE: u32 = 1;
pub const CONFIG_X86_FRED: u32 = 1;
pub const CONFIG_SND_SOC_WM8750_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_SN9C20X_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MAX77838_MODULE: u32 = 1;
pub const CONFIG_HAVE_STACK_VALIDATION: u32 = 1;
pub const CONFIG_DVB_ZL10353_MODULE: u32 = 1;
pub const CONFIG_MFD_MAX8997: u32 = 1;
pub const CONFIG_OCTEONEP_VDPA_MODULE: u32 = 1;
pub const CONFIG_TABLET_USB_ACECAD_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_DSCP_MODULE: u32 = 1;
pub const CONFIG_LTC2309_MODULE: u32 = 1;
pub const CONFIG_USB_PXA27X_MODULE: u32 = 1;
pub const CONFIG_PWM_LPSS_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_SCD30_CORE_MODULE: u32 = 1;
pub const CONFIG_HAVE_SAMPLE_FTRACE_DIRECT: u32 = 1;
pub const CONFIG_SND_USB_PODHD_MODULE: u32 = 1;
pub const CONFIG_E1000E_HWTS: u32 = 1;
pub const CONFIG_USB_DUMMY_HCD_MODULE: u32 = 1;
pub const CONFIG_HAVE_GIGANTIC_FOLIOS: u32 = 1;
pub const CONFIG_DVB_TDA8083_MODULE: u32 = 1;
pub const CONFIG_PATA_PARPORT_COMM_MODULE: u32 = 1;
pub const CONFIG_B53_SERDES_MODULE: u32 = 1;
pub const CONFIG_USB_DWC2_PCI_MODULE: u32 = 1;
pub const CONFIG_INET_PSP: u32 = 1;
pub const CONFIG_KVM_INTEL_TDX: u32 = 1;
pub const CONFIG_AD9832_MODULE: u32 = 1;
pub const CONFIG_FIRMWARE_MEMMAP: u32 = 1;
pub const CONFIG_PORTWELL_EC_MODULE: u32 = 1;
pub const CONFIG_ARCH_DMA_ADDR_T_64BIT: u32 = 1;
pub const CONFIG_DVB_STV090x_MODULE: u32 = 1;
pub const CONFIG_AIC7XXX_RESET_DELAY_MS: u32 = 15000;
pub const CONFIG_VIRTIO_VSOCKETS_COMMON_MODULE: u32 = 1;
pub const CONFIG_NFT_COMPAT_ARP_MODULE: u32 = 1;
pub const CONFIG_ASUS_WMI_MODULE: u32 = 1;
pub const CONFIG_HID_A4TECH_MODULE: u32 = 1;
pub const CONFIG_VIDEO_IMX319_MODULE: u32 = 1;
pub const CONFIG_USB_F_FS_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ADT7X10_MODULE: u32 = 1;
pub const CONFIG_DVB_ASCOT2E_MODULE: u32 = 1;
pub const CONFIG_LEDS_CLASS_FLASH_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CX88_BLACKBIRD_MODULE: u32 = 1;
pub const CONFIG_ASUS_LAPTOP_MODULE: u32 = 1;
pub const CONFIG_LENOVO_WMI_GAMEZONE_MODULE: u32 = 1;
pub const CONFIG_EFI_ESRT: u32 = 1;
pub const CONFIG_MEDIA_TUNER_TEA5767_MODULE: u32 = 1;
pub const CONFIG_WATCH_QUEUE: u32 = 1;
pub const CONFIG_NET_TULIP: u32 = 1;
pub const CONFIG_DMABUF_SYSFS_STATS: u32 = 1;
pub const CONFIG_SND_SOC_TLV320AIC3X_SPI_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_LIB_ARC4_MODULE: u32 = 1;
pub const CONFIG_AGP: u32 = 1;
pub const CONFIG_MFD_CS40L50_CORE_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LM92_MODULE: u32 = 1;
pub const CONFIG_MMC_SDRICOH_CS_MODULE: u32 = 1;
pub const CONFIG_TEXTSEARCH_BM_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DS1553_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_HID_SENSOR_TIME_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_TPS6105X_MODULE: u32 = 1;
pub const CONFIG_SND_PROC_FS: u32 = 1;
pub const CONFIG_USB_GSPCA_SUNPLUS_MODULE: u32 = 1;
pub const CONFIG_HID_SENSOR_INCLINOMETER_3D_MODULE: u32 = 1;
pub const CONFIG_FPGA_MGR_XILINX_SPI_MODULE: u32 = 1;
pub const CONFIG_BATMAN_ADV_DAT: u32 = 1;
pub const CONFIG_UTS_NS: u32 = 1;
pub const CONFIG_MLX5_FPGA: u32 = 1;
pub const CONFIG_HAVE_IRQ_TIME_ACCOUNTING: u32 = 1;
pub const CONFIG_PATA_CYPRESS_MODULE: u32 = 1;
pub const CONFIG_ACPI_APEI_PCIEAER: u32 = 1;
pub const CONFIG_MITIGATION_SPECTRE_V2: u32 = 1;
pub const CONFIG_CRYPTO_CTR: u32 = 1;
pub const CONFIG_SND_SOC_RT1017_SDCA_SDW_MODULE: u32 = 1;
pub const CONFIG_DVB_M88DS3103_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_DA9052_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_PCILIB: u32 = 1;
pub const CONFIG_SHUFFLE_PAGE_ALLOCATOR: u32 = 1;
pub const CONFIG_WFX_MODULE: u32 = 1;
pub const CONFIG_DVB_AF9013_MODULE: u32 = 1;
pub const CONFIG_CAN_VCAN_MODULE: u32 = 1;
pub const CONFIG_POSIX_CPU_TIMERS_TASK_WORK: u32 = 1;
pub const CONFIG_SND_INTEL_NHLT: u32 = 1;
pub const CONFIG_HID_ALPS_MODULE: u32 = 1;
pub const CONFIG_IGB_MODULE: u32 = 1;
pub const CONFIG_INTEL_HID_EVENT_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_SECMARK_MODULE: u32 = 1;
pub const CONFIG_SCSI_AIC94XX_MODULE: u32 = 1;
pub const CONFIG_MWIFIEX_MODULE: u32 = 1;
pub const CONFIG_INTEL_HFI_THERMAL: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_ITM: u32 = 1;
pub const CONFIG_VHOST_MENU: u32 = 1;
pub const CONFIG_GPIO_MAX3191X_MODULE: u32 = 1;
pub const CONFIG_LOG_CPU_MAX_BUF_SHIFT: u32 = 12;
pub const CONFIG_TYPEC_STUSB160X_MODULE: u32 = 1;
pub const CONFIG_ARCH_CPUIDLE_HALTPOLL: u32 = 1;
pub const CONFIG_LEDS_USER_MODULE: u32 = 1;
pub const CONFIG_AD5686_SPI_MODULE: u32 = 1;
pub const CONFIG_SENSORS_FSCHMD_MODULE: u32 = 1;
pub const CONFIG_EXTCON_MAX8997_MODULE: u32 = 1;
pub const CONFIG_LENOVO_SE30_WDT_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_FD_MODULE: u32 = 1;
pub const CONFIG_USB_EHCI_TT_NEWSCHED: u32 = 1;
pub const CONFIG_SENSORS_NCT6775_CORE_MODULE: u32 = 1;
pub const CONFIG_PARPORT_SERIAL_MODULE: u32 = 1;
pub const CONFIG_REDMI_WMI_MODULE: u32 = 1;
pub const CONFIG_BMG160_I2C_MODULE: u32 = 1;
pub const CONFIG_RMI4_F03: u32 = 1;
pub const CONFIG_CRYPTO_CBC: u32 = 1;
pub const CONFIG_SND_USB_AUDIO_QMI_MODULE: u32 = 1;
pub const CONFIG_SND_PCM_MODULE: u32 = 1;
pub const CONFIG_ALIBABA_ENI_VDPA_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_GTM601_MODULE: u32 = 1;
pub const CONFIG_SND_SEQ_MIDI_EVENT_MODULE: u32 = 1;
pub const CONFIG_6LOWPAN_NHC_MOBILITY_MODULE: u32 = 1;
pub const CONFIG_INTEL_TPMI_MODULE: u32 = 1;
pub const CONFIG_NFS_ACL_SUPPORT_MODULE: u32 = 1;
pub const CONFIG_HAVE_KVM_PM_NOTIFIER: u32 = 1;
pub const CONFIG_HAVE_KERNEL_LZO: u32 = 1;
pub const CONFIG_CGROUP_WRITEBACK: u32 = 1;
pub const CONFIG_SECURITY_LOCKDOWN_LSM: u32 = 1;
pub const CONFIG_I2C_MUX_PCA9541_MODULE: u32 = 1;
pub const CONFIG_NET_DEVLINK: u32 = 1;
pub const CONFIG_DRM_I915_REQUEST_TIMEOUT: u32 = 20000;
pub const CONFIG_FUTEX_MPOL: u32 = 1;
pub const CONFIG_IIO_ST_LSM6DSX_I2C_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WCD939X_MODULE: u32 = 1;
pub const CONFIG_USB_CATC_MODULE: u32 = 1;
pub const CONFIG_RMI4_F12: u32 = 1;
pub const CONFIG_HOTPLUG_CORE_SYNC_DEAD: u32 = 1;
pub const CONFIG_AD8366_MODULE: u32 = 1;
pub const CONFIG_MARVELL_88X2222_PHY_MODULE: u32 = 1;
pub const CONFIG_BMG160_MODULE: u32 = 1;
pub const CONFIG_HP_ACCEL_MODULE: u32 = 1;
pub const CONFIG_DCA_MODULE: u32 = 1;
pub const CONFIG_MAC80211_RC_DEFAULT_MINSTREL: u32 = 1;
pub const CONFIG_NF_CONNTRACK_SNMP_MODULE: u32 = 1;
pub const CONFIG_CRASH_DM_CRYPT: u32 = 1;
pub const CONFIG_NLS_KOI8_R_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_LIB_POLY1305_ARCH: u32 = 1;
pub const CONFIG_SND_SOC_DA7219_MODULE: u32 = 1;
pub const CONFIG_RTW88_8821A_MODULE: u32 = 1;
pub const CONFIG_ENS160_SPI_MODULE: u32 = 1;
pub const CONFIG_TEXTSEARCH_KMP_MODULE: u32 = 1;
pub const CONFIG_DVB_EC100_MODULE: u32 = 1;
pub const CONFIG_P54_USB_MODULE: u32 = 1;
pub const CONFIG_SENSIRION_SGP40_MODULE: u32 = 1;
pub const CONFIG_IIO_ST_SENSORS_I2C_MODULE: u32 = 1;
pub const CONFIG_SPI_TLE62X0_MODULE: u32 = 1;
pub const CONFIG_HIST_TRIGGERS: u32 = 1;
pub const CONFIG_DM_MULTIPATH_ST_MODULE: u32 = 1;
pub const CONFIG_REGMAP_SCCB_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_INGRESS: u32 = 1;
pub const CONFIG_W1_SLAVE_DS2433_MODULE: u32 = 1;
pub const CONFIG_MFD_CS42L43_I2C_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_CONNMARK_MODULE: u32 = 1;
pub const CONFIG_WL1251_SPI_MODULE: u32 = 1;
pub const CONFIG_LEDS_NIC78BX_MODULE: u32 = 1;
pub const CONFIG_SERIO_PCIPS2_MODULE: u32 = 1;
pub const CONFIG_RT2800PCI_RT33XX: u32 = 1;
pub const CONFIG_IIO_BUFFER_HW_CONSUMER_MODULE: u32 = 1;
pub const CONFIG_DVB_DS3000_MODULE: u32 = 1;
pub const CONFIG_VIDEO_RJ54N1_MODULE: u32 = 1;
pub const CONFIG_AMD8111_ETH_MODULE: u32 = 1;
pub const CONFIG_NF_FLOW_TABLE_INET_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_POLYVAL_CLMUL_NI_MODULE: u32 = 1;
pub const CONFIG_ACCESSIBILITY: u32 = 1;
pub const CONFIG_KRETPROBE_ON_RETHOOK: u32 = 1;
pub const CONFIG_AM2315_MODULE: u32 = 1;
pub const CONFIG_I2C_DESIGNWARE_SLAVE: u32 = 1;
pub const CONFIG_NS83820_MODULE: u32 = 1;
pub const CONFIG_USB_NET_HUAWEI_CDC_NCM_MODULE: u32 = 1;
pub const CONFIG_DM_MULTIPATH_IOA_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TFA9879_MODULE: u32 = 1;
pub const CONFIG_ACPI_PROCESSOR_AGGREGATOR_MODULE: u32 = 1;
pub const CONFIG_USB_STORAGE_JUMPSHOT_MODULE: u32 = 1;
pub const CONFIG_BCMA_DRIVER_PCI: u32 = 1;
pub const CONFIG_BT_LEDS: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_PROBE_MODULE: u32 = 1;
pub const CONFIG_PATA_ATIIXP_MODULE: u32 = 1;
pub const CONFIG_PATA_HPT3X3_DMA: u32 = 1;
pub const CONFIG_USB_F_UVC_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_AMLOGIC_GXL_DEBUG: u32 = 1;
pub const CONFIG_NLS_ISO8859_8_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_ATMEL_MXT_MODULE: u32 = 1;
pub const CONFIG_ACPI_SLEEP: u32 = 1;
pub const CONFIG_SENSORS_ISL68137_MODULE: u32 = 1;
pub const CONFIG_CX_ECAT_MODULE: u32 = 1;
pub const CONFIG_UID16: u32 = 1;
pub const CONFIG_SND_SOC_ALC5623_MODULE: u32 = 1;
pub const CONFIG_PCENGINES_APU2_MODULE: u32 = 1;
pub const CONFIG_XZ_DEC_MICROLZMA: u32 = 1;
pub const CONFIG_TIPC_MEDIA_UDP: u32 = 1;
pub const CONFIG_CHROMEOS_LAPTOP_MODULE: u32 = 1;
pub const CONFIG_SWAP: u32 = 1;
pub const CONFIG_CB710_DEBUG_ASSUMPTIONS: u32 = 1;
pub const CONFIG_MTD_UBI_NVMEM_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WCD938X_SDW_MODULE: u32 = 1;
pub const CONFIG_ASYNC_RAID6_TEST_MODULE: u32 = 1;
pub const CONFIG_EPIC100_MODULE: u32 = 1;
pub const CONFIG_MAGIC_SYSRQ_SERIAL: u32 = 1;
pub const CONFIG_HAVE_STACKPROTECTOR: u32 = 1;
pub const CONFIG_BNX2_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_LOG_MODULE: u32 = 1;
pub const CONFIG_MT7615E_MODULE: u32 = 1;
pub const CONFIG_HW_RANDOM_AMD_MODULE: u32 = 1;
pub const CONFIG_ACPI_MDIO_MODULE: u32 = 1;
pub const CONFIG_FXOS8700_I2C_MODULE: u32 = 1;
pub const CONFIG_HMC425_MODULE: u32 = 1;
pub const CONFIG_SENSORS_THMC50_MODULE: u32 = 1;
pub const CONFIG_SENSORS_STPDDC60_MODULE: u32 = 1;
pub const CONFIG_MFD_MAX14577_MODULE: u32 = 1;
pub const CONFIG_BATTERY_DS2780_MODULE: u32 = 1;
pub const CONFIG_SND_SEQ_MIDI_EMUL_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WSA881X_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_JUMP_LABEL: u32 = 1;
pub const CONFIG_USB_CONFIGFS_ECM: u32 = 1;
pub const CONFIG_GPIO_VIPERBOARD_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_PCBC_MODULE: u32 = 1;
pub const CONFIG_COMPAL_LAPTOP_MODULE: u32 = 1;
pub const CONFIG_INPUT_ADXL34X_I2C_MODULE: u32 = 1;
pub const CONFIG_IEEE802154_MCR20A_MODULE: u32 = 1;
pub const CONFIG_PLATFORM_SI4713_MODULE: u32 = 1;
pub const CONFIG_NETDEVSIM_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_CAMELLIA_X86_64_MODULE: u32 = 1;
pub const CONFIG_STEAM_FF: u32 = 1;
pub const CONFIG_RTC_DRV_DA9052_MODULE: u32 = 1;
pub const CONFIG_WIZNET_BUS_ANY: u32 = 1;
pub const CONFIG_BCMA_MODULE: u32 = 1;
pub const CONFIG_LEDS_DA9052_MODULE: u32 = 1;
pub const CONFIG_PCMCIA_AXNET_MODULE: u32 = 1;
pub const CONFIG_HID_HOLTEK_MODULE: u32 = 1;
pub const CONFIG_DRM_VBOXVIDEO_MODULE: u32 = 1;
pub const CONFIG_NETCONSOLE_DYNAMIC: u32 = 1;
pub const CONFIG_NF_CONNTRACK_BROADCAST_MODULE: u32 = 1;
pub const CONFIG_BOARD_TPCI200_MODULE: u32 = 1;
pub const CONFIG_GENWQE_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_NON_OVERLAPPING_ADDRESS_SPACE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_RT5514_MODULE: u32 = 1;
pub const CONFIG_CHARGER_RT9455_MODULE: u32 = 1;
pub const CONFIG_RT2800USB_RT33XX: u32 = 1;
pub const CONFIG_ISL29125_MODULE: u32 = 1;
pub const CONFIG_MMC_SDHCI_PLTFM_MODULE: u32 = 1;
pub const CONFIG_PATA_PARPORT_FIT2_MODULE: u32 = 1;
pub const CONFIG_KVM_MAX_NR_VCPUS: u32 = 1024;
pub const CONFIG_SENSORS_SPD5118_DETECT: u32 = 1;
pub const CONFIG_MT76x0_COMMON_MODULE: u32 = 1;
pub const CONFIG_CXL_MEM_MODULE: u32 = 1;
pub const CONFIG_SND_OPL3_LIB_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_MCP23S08_I2C_MODULE: u32 = 1;
pub const CONFIG_BXT_WC_PMIC_OPREGION: u32 = 1;
pub const CONFIG_DELL_SMBIOS_SMM: u32 = 1;
pub const CONFIG_VIRTIO_PMEM_MODULE: u32 = 1;
pub const CONFIG_NFT_SYNPROXY_MODULE: u32 = 1;
pub const CONFIG_HID_ZYDACRON_MODULE: u32 = 1;
pub const CONFIG_PREEMPT_RCU: u32 = 1;
pub const CONFIG_KEMPLD_WDT_MODULE: u32 = 1;
pub const CONFIG_USB_NET_ZAURUS_MODULE: u32 = 1;
pub const CONFIG_VIDEO_SAA6588_MODULE: u32 = 1;
pub const CONFIG_ADIS16203_MODULE: u32 = 1;
pub const CONFIG_HAVE_SYSCALL_TRACEPOINTS: u32 = 1;
pub const CONFIG_IOMMU_IOVA: u32 = 1;
pub const CONFIG_EEEPC_LAPTOP_MODULE: u32 = 1;
pub const CONFIG_I2C_LJCA_MODULE: u32 = 1;
pub const CONFIG_XOR_BLOCKS: u32 = 1;
pub const CONFIG_DNOTIFY: u32 = 1;
pub const CONFIG_LEDS_TRIGGER_BACKLIGHT_MODULE: u32 = 1;
pub const CONFIG_BPF_STREAM_PARSER: u32 = 1;
pub const CONFIG_PCMCIA_3C589_MODULE: u32 = 1;
pub const CONFIG_MEDIA_SUBDRV_AUTOSELECT: u32 = 1;
pub const CONFIG_RDS_MODULE: u32 = 1;
pub const CONFIG_XILINX_VCU_MODULE: u32 = 1;
pub const CONFIG_I2C_ROBOTFUZZ_OSIF_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_MICROCHIP_KSZ9477_I2C_MODULE: u32 = 1;
pub const CONFIG_MACVLAN_MODULE: u32 = 1;
pub const CONFIG_SENSORS_SHT15_MODULE: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_KEXEC: u32 = 1;
pub const CONFIG_IP_NF_RAW_MODULE: u32 = 1;
pub const CONFIG_HAVE_HW_BREAKPOINT: u32 = 1;
pub const CONFIG_BRIDGE_NF_EBTABLES_LEGACY_MODULE: u32 = 1;
pub const CONFIG_SECURITY_SMACK_BRINGUP: u32 = 1;
pub const CONFIG_AD5764_MODULE: u32 = 1;
pub const CONFIG_MOUSE_VSXXXAA_MODULE: u32 = 1;
pub const CONFIG_CLK_TWL6040_MODULE: u32 = 1;
pub const CONFIG_SPI_CH341_MODULE: u32 = 1;
pub const CONFIG_VIDEO_TEA6420_MODULE: u32 = 1;
pub const CONFIG_SCSI_MPT3SAS_MAX_SGE: u32 = 128;
pub const CONFIG_VIDEO_DT3155_MODULE: u32 = 1;
pub const CONFIG_DRM_PANEL_BACKLIGHT_QUIRKS_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_CTS: u32 = 1;
pub const CONFIG_DVB_USB_EC168_MODULE: u32 = 1;
pub const CONFIG_TDX_GUEST_DRIVER_MODULE: u32 = 1;
pub const CONFIG_RSI_91X_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WCD_CLASSH_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_SPCA1528_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_ILI210X_MODULE: u32 = 1;
pub const CONFIG_AD7625_MODULE: u32 = 1;
pub const CONFIG_GPIO_AGGREGATOR_MODULE: u32 = 1;
pub const CONFIG_SND_FIREWIRE_LIB_MODULE: u32 = 1;
pub const CONFIG_ARCH_VMLINUX_NEEDS_RELOCS: u32 = 1;
pub const CONFIG_HAVE_NMI: u32 = 1;
pub const CONFIG_EXTCON_RT8973A_MODULE: u32 = 1;
pub const CONFIG_CC_HAS_INT128: u32 = 1;
pub const CONFIG_SENSORS_F75375S_MODULE: u32 = 1;
pub const CONFIG_SND_INDIGOIOX_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_TOPLEVEL: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SOF_NUVOTON_COMMON_MODULE: u32 = 1;
pub const CONFIG_SCSI_NETLINK: u32 = 1;
pub const CONFIG_CRYPTO_USER_API_AEAD_MODULE: u32 = 1;
pub const CONFIG_INTEL_VBTN_MODULE: u32 = 1;
pub const CONFIG_SPI_KSPI2_MODULE: u32 = 1;
pub const CONFIG_NETCONSOLE_MODULE: u32 = 1;
pub const CONFIG_THINKPAD_ACPI_ALSA_SUPPORT: u32 = 1;
pub const CONFIG_SND_SOC_PM4125_MODULE: u32 = 1;
pub const CONFIG_NVSW_SN2201_MODULE: u32 = 1;
pub const CONFIG_HAVE_VIRT_CPU_ACCOUNTING_GEN: u32 = 1;
pub const CONFIG_VIRTIO_VFIO_PCI_MODULE: u32 = 1;
pub const CONFIG_SND_HDSPM_MODULE: u32 = 1;
pub const CONFIG_X86_CHECK_BIOS_CORRUPTION: u32 = 1;
pub const CONFIG_ACPI_WMI_MODULE: u32 = 1;
pub const CONFIG_GENERIC_CLOCKEVENTS_BROADCAST: u32 = 1;
pub const CONFIG_CRYPTO_DEV_SAFEXCEL_MODULE: u32 = 1;
pub const CONFIG_DVB_TTUSB_DEC_MODULE: u32 = 1;
pub const CONFIG_RTC_NVMEM: u32 = 1;
pub const CONFIG_RTC_DRV_SD2405AL_MODULE: u32 = 1;
pub const CONFIG_SURFACE3_WMI_MODULE: u32 = 1;
pub const CONFIG_WATCHDOG_PRETIMEOUT_GOV_NOOP_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WCD937X_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_MAX7360_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_COMPAT_MMAP_BASES: u32 = 1;
pub const CONFIG_SPS30_I2C_MODULE: u32 = 1;
pub const CONFIG_XEN_PVHVM_SMP: u32 = 1;
pub const CONFIG_KEYBOARD_LM8323_MODULE: u32 = 1;
pub const CONFIG_IIO_SSP_SENSORHUB_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_IMAGIS_MODULE: u32 = 1;
pub const CONFIG_SCSI_HPTIOP_MODULE: u32 = 1;
pub const CONFIG_JFS_POSIX_ACL: u32 = 1;
pub const CONFIG_VIDEO_AU0828_RC: u32 = 1;
pub const CONFIG_LCD_HX8357_MODULE: u32 = 1;
pub const CONFIG_P54_SPI_MODULE: u32 = 1;
pub const CONFIG_DELL_WMI_DESCRIPTOR_MODULE: u32 = 1;
pub const CONFIG_WATCHDOG_SYSFS: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_PUD_PFNMAP: u32 = 1;
pub const CONFIG_OPT4001_MODULE: u32 = 1;
pub const CONFIG_SENSORS_POWERZ_MODULE: u32 = 1;
pub const CONFIG_MEDIA_ALTERA_CI_MODULE: u32 = 1;
pub const CONFIG_PM_TRACE_RTC: u32 = 1;
pub const CONFIG_SENSORS_TPS546D24_MODULE: u32 = 1;
pub const CONFIG_NCSI_OEM_CMD_KEEP_PHY: u32 = 1;
pub const CONFIG_USB_SERIAL_QT2_MODULE: u32 = 1;
pub const CONFIG_SPI_GPIO_MODULE: u32 = 1;
pub const CONFIG_HID_LED_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_ADP5588_MODULE: u32 = 1;
pub const CONFIG_FB_SYS_FILLRECT: u32 = 1;
pub const CONFIG_SENSORS_I5K_AMB_MODULE: u32 = 1;
pub const CONFIG_INTEL_IDXD_BUS_MODULE: u32 = 1;
pub const CONFIG_I2C_DIOLAN_U2C_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WCD9335_MODULE: u32 = 1;
pub const CONFIG_XARRAY_MULTI: u32 = 1;
pub const CONFIG_USB_SERIAL_IPW_MODULE: u32 = 1;
pub const CONFIG_DRM_ACCEL_QAIC_MODULE: u32 = 1;
pub const CONFIG_USBIP_VUDC_MODULE: u32 = 1;
pub const CONFIG_RMI4_F11: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_KEXEC_FILE: u32 = 1;
pub const CONFIG_DCB: u32 = 1;
pub const CONFIG_ZSWAP: u32 = 1;
pub const CONFIG_SENSORS_TMP103_MODULE: u32 = 1;
pub const CONFIG_MT7921_COMMON_MODULE: u32 = 1;
pub const CONFIG_HX9023S_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT1015P_MODULE: u32 = 1;
pub const CONFIG_RTLWIFI_DEBUG: u32 = 1;
pub const CONFIG_TI_ADS8344_MODULE: u32 = 1;
pub const CONFIG_USB_R8A66597_HCD_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_FC0013_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ADM1025_MODULE: u32 = 1;
pub const CONFIG_INPUT_AD714X_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_TWOFISH_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_PREL32_RELOCATIONS: u32 = 1;
pub const CONFIG_ATH5K_TRACER: u32 = 1;
pub const CONFIG_PACKING: u32 = 1;
pub const CONFIG_FUSION_SPI_MODULE: u32 = 1;
pub const CONFIG_IPV6_MIP6_MODULE: u32 = 1;
pub const CONFIG_SND_FM801_TEA575X_BOOL: u32 = 1;
pub const CONFIG_NET_DSA_QCA8K_LEDS_SUPPORT: u32 = 1;
pub const CONFIG_W1_SLAVE_DS2430_MODULE: u32 = 1;
pub const CONFIG_BT_HCIUART_QCA: u32 = 1;
pub const CONFIG_MHI_NET_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_RNG_DEFAULT: u32 = 1;
pub const CONFIG_STREAM_PARSER: u32 = 1;
pub const CONFIG_SND_SOC_SOF_AMD_RENOIR_MODULE: u32 = 1;
pub const CONFIG_KVM_GENERIC_MMU_NOTIFIER: u32 = 1;
pub const CONFIG_WINBOND_840_MODULE: u32 = 1;
pub const CONFIG_XEN_COMPAT_XENFS: u32 = 1;
pub const CONFIG_UEFI_CPER: u32 = 1;
pub const CONFIG_AS_WRUSS: u32 = 1;
pub const CONFIG_SENSORS_CORSAIR_CPRO_MODULE: u32 = 1;
pub const CONFIG_X86_CPA_STATISTICS: u32 = 1;
pub const CONFIG_X86_MPPARSE: u32 = 1;
pub const CONFIG_IP_VS_SED_MODULE: u32 = 1;
pub const CONFIG_LIBFCOE_MODULE: u32 = 1;
pub const CONFIG_ADF4377_MODULE: u32 = 1;
pub const CONFIG_X86_HAVE_PAE: u32 = 1;
pub const CONFIG_XZ_DEC_ARM: u32 = 1;
pub const CONFIG_SND_HDA_SCODEC_CS35L41_I2C_MODULE: u32 = 1;
pub const CONFIG_DVB_RTL2832_MODULE: u32 = 1;
pub const CONFIG_INET_ESP_OFFLOAD_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_MT7530_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_MODULE: u32 = 1;
pub const CONFIG_SENSORS_INA2XX_MODULE: u32 = 1;
pub const CONFIG_MEEGOPAD_ANX7428_MODULE: u32 = 1;
pub const CONFIG_MTD_UBI_BEB_LIMIT: u32 = 20;
pub const CONFIG_HOTPLUG_PCI: u32 = 1;
pub const CONFIG_VIDEO_S5K5BAF_MODULE: u32 = 1;
pub const CONFIG_USB_VIDEO_CLASS_MODULE: u32 = 1;
pub const CONFIG_CC_HAS_NAMED_AS_FIXED_SANITIZERS: u32 = 1;
pub const CONFIG_F2FS_FS_LZO: u32 = 1;
pub const CONFIG_SCSI_PM8001_MODULE: u32 = 1;
pub const CONFIG_SENSORS_AD7418_MODULE: u32 = 1;
pub const CONFIG_NFC_NCI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT5640_MODULE: u32 = 1;
pub const CONFIG_HAVE_FENTRY: u32 = 1;
pub const CONFIG_AXP20X_ADC_MODULE: u32 = 1;
pub const CONFIG_IEEE802154_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DS1374_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT1015_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_IDLETIMER_MODULE: u32 = 1;
pub const CONFIG_ZSMALLOC_STAT: u32 = 1;
pub const CONFIG_CIFS_POSIX: u32 = 1;
pub const CONFIG_HID_COUGAR_MODULE: u32 = 1;
pub const CONFIG_HSC030PA_MODULE: u32 = 1;
pub const CONFIG_MMC_HSQ_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_MAX98090_MODULE: u32 = 1;
pub const CONFIG_PWM: u32 = 1;
pub const CONFIG_PARAVIRT_XXL: u32 = 1;
pub const CONFIG_NET_VENDOR_HUAWEI: u32 = 1;
pub const CONFIG_HAVE_MIXED_BREAKPOINTS_REGS: u32 = 1;
pub const CONFIG_DRM_XE_JOB_TIMEOUT_MIN: u32 = 1;
pub const CONFIG_AD7780_MODULE: u32 = 1;
pub const CONFIG_CONFIGFS_FS: u32 = 1;
pub const CONFIG_QCOM_HIDMA_MGMT_MODULE: u32 = 1;
pub const CONFIG_NVIDIA_SHIELD_FF: u32 = 1;
pub const CONFIG_JFFS2_FS_WRITEBUFFER: u32 = 1;
pub const CONFIG_INTEL_MEI_VSC_HW_MODULE: u32 = 1;
pub const CONFIG_LPC_SCH_MODULE: u32 = 1;
pub const CONFIG_SAMSUNG_GALAXYBOOK_MODULE: u32 = 1;
pub const CONFIG_DEFAULT_INIT: &[u8; 1] = b"\0";
pub const CONFIG_SND_SOC_WM8985_MODULE: u32 = 1;
pub const CONFIG_RT2500PCI_MODULE: u32 = 1;
pub const CONFIG_SND_SPI: u32 = 1;
pub const CONFIG_XILLYUSB_MODULE: u32 = 1;
pub const CONFIG_SPS30_MODULE: u32 = 1;
pub const CONFIG_MAX1241_MODULE: u32 = 1;
pub const CONFIG_KXCJK1013_MODULE: u32 = 1;
pub const CONFIG_ARCH_MIGHT_HAVE_PC_SERIO: u32 = 1;
pub const CONFIG_MLX_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_VIRT_DRIVERS: u32 = 1;
pub const CONFIG_DMABUF_HEAPS_CMA: u32 = 1;
pub const CONFIG_CAN_ETAS_ES58X_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_NITROX_MODULE: u32 = 1;
pub const CONFIG_PCI_HYPERV_MODULE: u32 = 1;
pub const CONFIG_ATA_ACPI: u32 = 1;
pub const CONFIG_RTW88_8723DU_MODULE: u32 = 1;
pub const CONFIG_NET_CLS: u32 = 1;
pub const CONFIG_XFS_LIVE_HOOKS: u32 = 1;
pub const CONFIG_SND_SOC_ICS43432_MODULE: u32 = 1;
pub const CONFIG_HAVE_EXIT_THREAD: u32 = 1;
pub const CONFIG_NET_VENDOR_AGERE: u32 = 1;
pub const CONFIG_W1_CON: u32 = 1;
pub const CONFIG_HID_ACRUX_FF: u32 = 1;
pub const CONFIG_NFT_REJECT_IPV4_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DA9055_MODULE: u32 = 1;
pub const CONFIG_IP6_NF_MATCH_OPTS_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_EGALAX: u32 = 1;
pub const CONFIG_THUNDER_NIC_BGX_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_PADLOCK_SHA_MODULE: u32 = 1;
pub const CONFIG_SATA_MV_MODULE: u32 = 1;
pub const CONFIG_SCHEDSTATS: u32 = 1;
pub const CONFIG_ALTERA_STAPL_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_IPOIB_DEBUG: u32 = 1;
pub const CONFIG_VIA_VELOCITY_MODULE: u32 = 1;
pub const CONFIG_REALTEK_PHY_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_KPP2: u32 = 1;
pub const CONFIG_TCP_AO: u32 = 1;
pub const CONFIG_AD7091R8_MODULE: u32 = 1;
pub const CONFIG_NET_ACT_SKBEDIT_MODULE: u32 = 1;
pub const CONFIG_DRM_DISPLAY_DP_AUX_CEC: u32 = 1;
pub const CONFIG_MCP9600_MODULE: u32 = 1;
pub const CONFIG_DRM_I915_STOP_TIMEOUT: u32 = 100;
pub const CONFIG_SND_SOC_SOF_MERRIFIELD_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LENOVO_EC_MODULE: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_KEXEC_SIG: u32 = 1;
pub const CONFIG_PATA_PARPORT_FIT3_MODULE: u32 = 1;
pub const CONFIG_TPS65010_MODULE: u32 = 1;
pub const CONFIG_MOUSE_GPIO_MODULE: u32 = 1;
pub const CONFIG_VHOST_VSOCK_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_LOOP_MIN_COUNT: u32 = 0;
pub const CONFIG_SND_SOC_RT700_SDW_MODULE: u32 = 1;
pub const CONFIG_B43LEGACY_HWRNG: u32 = 1;
pub const CONFIG_NFT_QUEUE_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DRBG_HASH: u32 = 1;
pub const CONFIG_MCP4922_MODULE: u32 = 1;
pub const CONFIG_BRCMDBG: u32 = 1;
pub const CONFIG_ITCO_VENDOR_SUPPORT: u32 = 1;
pub const CONFIG_SUNDANCE_MODULE: u32 = 1;
pub const CONFIG_DCACHE_WORD_ACCESS: u32 = 1;
pub const CONFIG_RANDOMIZE_KSTACK_OFFSET_DEFAULT: u32 = 1;
pub const CONFIG_DRM_TTM_HELPER_MODULE: u32 = 1;
pub const CONFIG_CDROM_MODULE: u32 = 1;
pub const CONFIG_P54_COMMON_MODULE: u32 = 1;
pub const CONFIG_BACKLIGHT_RAVE_SP_MODULE: u32 = 1;
pub const CONFIG_SFC_SIENA_MTD: u32 = 1;
pub const CONFIG_ACERHDF_MODULE: u32 = 1;
pub const CONFIG_DRM_VKMS_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_TEA5761_MODULE: u32 = 1;
pub const CONFIG_AD7173_MODULE: u32 = 1;
pub const CONFIG_SENSORS_SCH56XX_COMMON_MODULE: u32 = 1;
pub const CONFIG_CONTEXT_SWITCH_TRACER: u32 = 1;
pub const CONFIG_USB_GSPCA_VC032X_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_NTPFW_MODULE: u32 = 1;
pub const CONFIG_XEN_SCSI_FRONTEND_MODULE: u32 = 1;
pub const CONFIG_RUSTC_LLVM_VERSION: u32 = 210106;
pub const CONFIG_EXTCON: u32 = 1;
pub const CONFIG_CRYPTO_DEV_QAT_DH895xCCVF_MODULE: u32 = 1;
pub const CONFIG_RESET_GPIO_MODULE: u32 = 1;
pub const CONFIG_BAYCOM_SER_FDX_MODULE: u32 = 1;
pub const CONFIG_ADXL367_MODULE: u32 = 1;
pub const CONFIG_DRM_ST7586_MODULE: u32 = 1;
pub const CONFIG_IIO_INTERRUPT_TRIGGER_MODULE: u32 = 1;
pub const CONFIG_IE6XX_WDT_MODULE: u32 = 1;
pub const CONFIG_MT7663_USB_SDIO_COMMON_MODULE: u32 = 1;
pub const CONFIG_I82092_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_PTDUMP: u32 = 1;
pub const CONFIG_DRM_I2C_NXP_TDA998X_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_STK014_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_SURFACE3_SPI_MODULE: u32 = 1;
pub const CONFIG_DMA_ACPI: u32 = 1;
pub const CONFIG_INPUT_KEYBOARD: u32 = 1;
pub const CONFIG_DP83TC811_PHY_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_QAT_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SOF_RT5682_MACH_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_EXC3000_MODULE: u32 = 1;
pub const CONFIG_TRUSTED_KEYS_MODULE: u32 = 1;
pub const CONFIG_CROS_EC_UART_MODULE: u32 = 1;
pub const CONFIG_ATH9K_COMMON_MODULE: u32 = 1;
pub const CONFIG_TCG_TIS_I2C_NUVOTON_MODULE: u32 = 1;
pub const CONFIG_MQ_IOSCHED_KYBER: u32 = 1;
pub const CONFIG_CHARGER_BQ24735_MODULE: u32 = 1;
pub const CONFIG_SND_SEQ_DUMMY_MODULE: u32 = 1;
pub const CONFIG_TOSHIBA_BT_RFKILL_MODULE: u32 = 1;
pub const CONFIG_XZ_DEC_RISCV: u32 = 1;
pub const CONFIG_DEVICE_MIGRATION: u32 = 1;
pub const CONFIG_KEYBOARD_LM8333_MODULE: u32 = 1;
pub const CONFIG_ACPI_REV_OVERRIDE_POSSIBLE: u32 = 1;
pub const CONFIG_MISDN_IPAC_MODULE: u32 = 1;
pub const CONFIG_SND_MPU401_UART_MODULE: u32 = 1;
pub const CONFIG_DELL_WMI_SYSMAN_MODULE: u32 = 1;
pub const CONFIG_DRAGONRISE_FF: u32 = 1;
pub const CONFIG_THREAD_INFO_IN_TASK: u32 = 1;
pub const CONFIG_SYSFS: u32 = 1;
pub const CONFIG_XFS_RT: u32 = 1;
pub const CONFIG_RD_ZSTD: u32 = 1;
pub const CONFIG_IRQ_TIME_ACCOUNTING: u32 = 1;
pub const CONFIG_USB_MR800_MODULE: u32 = 1;
pub const CONFIG_SECURITY_SELINUX_DEVELOP: u32 = 1;
pub const CONFIG_MT7925E_MODULE: u32 = 1;
pub const CONFIG_ADXL380_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_THREAD_STRUCT_WHITELIST: u32 = 1;
pub const CONFIG_PATA_PARPORT_ON26_MODULE: u32 = 1;
pub const CONFIG_BRCMFMAC_PROTO_BCDC: u32 = 1;
pub const CONFIG_ATH12K_AHB: u32 = 1;
pub const CONFIG_SIGNATURE: u32 = 1;
pub const CONFIG_MFD_SM501_GPIO: u32 = 1;
pub const CONFIG_HL_HLDIO: u32 = 1;
pub const CONFIG_CRYPTO_LIB_SHA512: u32 = 1;
pub const CONFIG_INFINIBAND_SRPT_MODULE: u32 = 1;
pub const CONFIG_X86_64: u32 = 1;
pub const CONFIG_NET_CLS_FLOW_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WM8523_MODULE: u32 = 1;
pub const CONFIG_VIDEO_SAA7146_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_BROADWELL_MACH_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_ST1232_MODULE: u32 = 1;
pub const CONFIG_DM_THIN_PROVISIONING_MODULE: u32 = 1;
pub const CONFIG_TPS6507X_MODULE: u32 = 1;
pub const CONFIG_TCP_CONG_HYBLA_MODULE: u32 = 1;
pub const CONFIG_SND_UMP_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AW87390_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_XC5000_MODULE: u32 = 1;
pub const CONFIG_HAVE_RSEQ: u32 = 1;
pub const CONFIG_ATLAS_PH_SENSOR_MODULE: u32 = 1;
pub const CONFIG_HID_AUREAL_MODULE: u32 = 1;
pub const CONFIG_LEDS_PCA9532_GPIO: u32 = 1;
pub const CONFIG_DVB_CORE_MODULE: u32 = 1;
pub const CONFIG_IP_NF_TARGET_REJECT_MODULE: u32 = 1;
pub const CONFIG_REGMAP_IRQ: u32 = 1;
pub const CONFIG_SND_SOC_COMPRESS: u32 = 1;
pub const CONFIG_NET_EMATCH_TEXT_MODULE: u32 = 1;
pub const CONFIG_HAVE_KCSAN_COMPILER: u32 = 1;
pub const CONFIG_TCG_VTPM_PROXY_MODULE: u32 = 1;
pub const CONFIG_EFI_VARS_PSTORE: u32 = 1;
pub const CONFIG_SND_ENS1370_MODULE: u32 = 1;
pub const CONFIG_ADMV8818_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_METEORLAKE_MODULE: u32 = 1;
pub const CONFIG_I2C_XILINX_MODULE: u32 = 1;
pub const CONFIG_ATA_OVER_ETH_MODULE: u32 = 1;
pub const CONFIG_SFC_MTD: u32 = 1;
pub const CONFIG_IPVLAN_MODULE: u32 = 1;
pub const CONFIG_MMC_ALCOR_MODULE: u32 = 1;
pub const CONFIG_SERIO_RAW_MODULE: u32 = 1;
pub const CONFIG_NCT7201_MODULE: u32 = 1;
pub const CONFIG_WMI_BMOF_MODULE: u32 = 1;
pub const CONFIG_STRICT_DEVMEM: u32 = 1;
pub const CONFIG_GCC10_NO_ARRAY_BOUNDS: u32 = 1;
pub const CONFIG_SND_SOC_CS35L41_LIB_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DS1672_MODULE: u32 = 1;
pub const CONFIG_SENSORS_TMP102_MODULE: u32 = 1;
pub const CONFIG_X86_PLATFORM_DRIVERS_DELL: u32 = 1;
pub const CONFIG_RTW88_8821C_MODULE: u32 = 1;
pub const CONFIG_SND_INDIGOIO_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_FC0012_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ADM1026_MODULE: u32 = 1;
pub const CONFIG_VIDEO_S5K6A3_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_STATE_MODULE: u32 = 1;
pub const CONFIG_DRM_DRAW: u32 = 1;
pub const CONFIG_ACPI_APEI_ERST_DEBUG_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ES8328_MODULE: u32 = 1;
pub const CONFIG_SENSORS_NCT6775_I2C_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_BAYTRAIL: u32 = 1;
pub const CONFIG_LEDS_MAX8997_MODULE: u32 = 1;
pub const CONFIG_MMC35240_MODULE: u32 = 1;
pub const CONFIG_SPI_DYNAMIC: u32 = 1;
pub const CONFIG_PPP_DEFLATE_MODULE: u32 = 1;
pub const CONFIG_W1_SLAVE_DS2431_MODULE: u32 = 1;
pub const CONFIG_CPU_FREQ_GOV_ONDEMAND: u32 = 1;
pub const CONFIG_PHY_CPCAP_USB_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX8688_MODULE: u32 = 1;
pub const CONFIG_MFD_WM5110: u32 = 1;
pub const CONFIG_MFD_88PM800_MODULE: u32 = 1;
pub const CONFIG_BCM_VK_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WM8728_MODULE: u32 = 1;
pub const CONFIG_PPDEV_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_HIDEEP_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_AD5398_MODULE: u32 = 1;
pub const CONFIG_DCDBAS_MODULE: u32 = 1;
pub const CONFIG_VT_HW_CONSOLE_BINDING: u32 = 1;
pub const CONFIG_I2C_ALGOBIT_MODULE: u32 = 1;
pub const CONFIG_SPI_SLAVE_TIME_MODULE: u32 = 1;
pub const CONFIG_INPUT_RT5120_PWRKEY_MODULE: u32 = 1;
pub const CONFIG_SENSORS_PM6764TR_MODULE: u32 = 1;
pub const CONFIG_DVB_AV7110_MODULE: u32 = 1;
pub const CONFIG_EXTCON_USBC_TUSB320_MODULE: u32 = 1;
pub const CONFIG_HAVE_RETHOOK: u32 = 1;
pub const CONFIG_INPUT_ADXL34X_MODULE: u32 = 1;
pub const CONFIG_I2C_HID_ACPI_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_CAST_COMMON_MODULE: u32 = 1;
pub const CONFIG_NF_NAT_MASQUERADE: u32 = 1;
pub const CONFIG_GENERIC_CLOCKEVENTS: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_PROPELLER_CLANG: u32 = 1;
pub const CONFIG_INPUT_DRV2665_HAPTICS_MODULE: u32 = 1;
pub const CONFIG_MMIOTRACE: u32 = 1;
pub const CONFIG_NF_CT_NETLINK_HELPER_MODULE: u32 = 1;
pub const CONFIG_MFD_MT6360_MODULE: u32 = 1;
pub const CONFIG_CMA_DEBUGFS: u32 = 1;
pub const CONFIG_SND_SOC_CS35L32_MODULE: u32 = 1;
pub const CONFIG_NFC_ST95HF_MODULE: u32 = 1;
pub const CONFIG_MOUSE_SYNAPTICS_I2C_MODULE: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_852_MODULE: u32 = 1;
pub const CONFIG_DIBS_LO: u32 = 1;
pub const CONFIG_ADC_BATTERY_HELPER_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_WHITEHEAT_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_ECN_MODULE: u32 = 1;
pub const CONFIG_SND_AW2_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_INTEL_TOPLEVEL: u32 = 1;
pub const CONFIG_BMC150_MAGN_I2C_MODULE: u32 = 1;
pub const CONFIG_BARCO_P50_GPIO_MODULE: u32 = 1;
pub const CONFIG_BT_HCIUART_MODULE: u32 = 1;
pub const CONFIG_IPMI_DEVICE_INTERFACE_MODULE: u32 = 1;
pub const CONFIG_SND_CTL_INPUT_VALIDATION: u32 = 1;
pub const CONFIG_DVB_USB_AF9005_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_CIRRUS_SCODEC_MODULE: u32 = 1;
pub const CONFIG_VIDEO_USBTV_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT5682_SDW_MODULE: u32 = 1;
pub const CONFIG_SND_HDSP_MODULE: u32 = 1;
pub const CONFIG_XEN_PCI_STUB: u32 = 1;
pub const CONFIG_SND_AMD_ASOC_ACP70_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_HDA_GENERIC_MODULE: u32 = 1;
pub const CONFIG_RTC_CLASS: u32 = 1;
pub const CONFIG_REGULATOR_RAA215300_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ASUS_ROG_RYUJIN_MODULE: u32 = 1;
pub const CONFIG_INPUT_PWM_BEEPER_MODULE: u32 = 1;
pub const CONFIG_CIFS_SWN_UPCALL: u32 = 1;
pub const CONFIG_JOYSTICK_SEESAW_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_LZO: u32 = 1;
pub const CONFIG_LATTICE_ECP3_CONFIG_MODULE: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_869_MODULE: u32 = 1;
pub const CONFIG_FWNODE_MDIO_MODULE: u32 = 1;
pub const CONFIG_BATTERY_AXP20X_MODULE: u32 = 1;
pub const CONFIG_PERF_EVENTS: u32 = 1;
pub const CONFIG_DRM_PANIC_BACKGROUND_COLOR: u32 = 170;
pub const CONFIG_GPIO_ARIZONA_MODULE: u32 = 1;
pub const CONFIG_RENESAS_PHY_MODULE: u32 = 1;
pub const CONFIG_IP6_NF_MATCH_AH_MODULE: u32 = 1;
pub const CONFIG_HAVE_HARDLOCKUP_DETECTOR_PERF: u32 = 1;
pub const CONFIG_SENSORS_SURFACE_FAN_MODULE: u32 = 1;
pub const CONFIG_MHI_WWAN_MBIM_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ADT7470_MODULE: u32 = 1;
pub const CONFIG_NET_ACT_VLAN_MODULE: u32 = 1;
pub const CONFIG_TCG_TIS: u32 = 1;
pub const CONFIG_PINCTRL_DA9062_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_RTQ2134_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_LED_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_NR_UARTS: u32 = 32;
pub const CONFIG_XEN_DOM0: u32 = 1;
pub const CONFIG_GP2AP020A00F_MODULE: u32 = 1;
pub const CONFIG_ADJD_S311_MODULE: u32 = 1;
pub const CONFIG_ADIS16550_MODULE: u32 = 1;
pub const CONFIG_CRC8_MODULE: u32 = 1;
pub const CONFIG_PCIEPORTBUS: u32 = 1;
pub const CONFIG_BATTERY_RX51_MODULE: u32 = 1;
pub const CONFIG_SYSTEMPORT_MODULE: u32 = 1;
pub const CONFIG_MISDN_HFCPCI_MODULE: u32 = 1;
pub const CONFIG_SENSORS_CORETEMP_MODULE: u32 = 1;
pub const CONFIG_PCIE_DPC: u32 = 1;
pub const CONFIG_USB_STORAGE_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_LME2510_MODULE: u32 = 1;
pub const CONFIG_X86_ESPFIX64: u32 = 1;
pub const CONFIG_REMOTEPROC_CDEV: u32 = 1;
pub const CONFIG_SENSORS_TPS53679_MODULE: u32 = 1;
pub const CONFIG_PATA_IT821X_MODULE: u32 = 1;
pub const CONFIG_IOMMU_API: u32 = 1;
pub const CONFIG_ZISOFS: u32 = 1;
pub const CONFIG_MAX5481_MODULE: u32 = 1;
pub const CONFIG_MAPPING_DIRTY_HELPERS: u32 = 1;
pub const CONFIG_USB_HCD_SSB_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_RSA: u32 = 1;
pub const CONFIG_IPMB_DEVICE_INTERFACE_MODULE: u32 = 1;
pub const CONFIG_HID_LOGITECH_HIDPP_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_WM8994_MODULE: u32 = 1;
pub const CONFIG_VMXNET3_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_MANY_PORTS: u32 = 1;
pub const CONFIG_IR_JVC_DECODER_MODULE: u32 = 1;
pub const CONFIG_SCSI_AIC79XX_MODULE: u32 = 1;
pub const CONFIG_NVME_TCP_MODULE: u32 = 1;
pub const CONFIG_NET_IPGRE_BROADCAST: u32 = 1;
pub const CONFIG_SENSORS_SHTC1_MODULE: u32 = 1;
pub const CONFIG_LOCKD_V4: u32 = 1;
pub const CONFIG_SURFACE_HID_CORE_MODULE: u32 = 1;
pub const CONFIG_DM_DUST_MODULE: u32 = 1;
pub const CONFIG_CIFS_DFS_UPCALL: u32 = 1;
pub const CONFIG_TYPEC_TCPCI_MODULE: u32 = 1;
pub const CONFIG_TI_ADC12138_MODULE: u32 = 1;
pub const CONFIG_CALL_THUNKS: u32 = 1;
pub const CONFIG_AQUANTIA_PHY_MODULE: u32 = 1;
pub const CONFIG_SENSORS_DELL_SMM_MODULE: u32 = 1;
pub const CONFIG_EROFS_FS_PCPU_KTHREAD_HIPRI: u32 = 1;
pub const CONFIG_TYPEC_TBT_ALTMODE_MODULE: u32 = 1;
pub const CONFIG_WATCHDOG_CORE: u32 = 1;
pub const CONFIG_X86_AMD_PSTATE_UT_MODULE: u32 = 1;
pub const CONFIG_IIO_ST_ACCEL_3AXIS_MODULE: u32 = 1;
pub const CONFIG_AD5421_MODULE: u32 = 1;
pub const CONFIG_UCSI_CCG_MODULE: u32 = 1;
pub const CONFIG_LTC2485_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_HDMI_MODULE: u32 = 1;
pub const CONFIG_SCSI_DH_EMC_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_VIRTUAL_CONSUMER_MODULE: u32 = 1;
pub const CONFIG_IBMASR_MODULE: u32 = 1;
pub const CONFIG_CROS_USBPD_NOTIFY_MODULE: u32 = 1;
pub const CONFIG_SPI_VIRTIO_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_RT6160_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS4349_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_MADERA_MODULE: u32 = 1;
pub const CONFIG_BQL: u32 = 1;
pub const CONFIG_IO_URING: u32 = 1;
pub const CONFIG_HID_SENSOR_ACCEL_3D_MODULE: u32 = 1;
pub const CONFIG_DAMON_PADDR: u32 = 1;
pub const CONFIG_IIO_ADIS_LIB_BUFFER: u32 = 1;
pub const CONFIG_SND_SOC_RT1316_SDW_MODULE: u32 = 1;
pub const CONFIG_ASYMMETRIC_KEY_TYPE: u32 = 1;
pub const CONFIG_INV_ICM42600_SPI_MODULE: u32 = 1;
pub const CONFIG_ACPI_TABLE_LIB: u32 = 1;
pub const CONFIG_NFC_S3FWRN5_I2C_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_PCF8523_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX20751_MODULE: u32 = 1;
pub const CONFIG_INPUT_MOUSE: u32 = 1;
pub const CONFIG_PROC_VMCORE: u32 = 1;
pub const CONFIG_SENSORS_MP2891_MODULE: u32 = 1;
pub const CONFIG_DEV_DAX_PMEM_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_X1205_MODULE: u32 = 1;
pub const CONFIG_MMC_USHC_MODULE: u32 = 1;
pub const CONFIG_GPIO_AMD_FCH_MODULE: u32 = 1;
pub const CONFIG_SATA_SX4_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MAX14577_MODULE: u32 = 1;
pub const CONFIG_BMA400_SPI_MODULE: u32 = 1;
pub const CONFIG_I2C_NCT6694_MODULE: u32 = 1;
pub const CONFIG_INTEL_IOMMU_FLOPPY_WA: u32 = 1;
pub const CONFIG_KVM_GENERIC_DIRTYLOG_READ_PROTECT: u32 = 1;
pub const CONFIG_DECOMPRESS_XZ: u32 = 1;
pub const CONFIG_MICROCHIP_T1S_PHY_MODULE: u32 = 1;
pub const CONFIG_INTEL_MEI_GSC_PROXY_MODULE: u32 = 1;
pub const CONFIG_NVME_HOST_AUTH: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_SIGMATEL_MODULE: u32 = 1;
pub const CONFIG_MLX5_ESWITCH: u32 = 1;
pub const CONFIG_LEDS_PWM_MODULE: u32 = 1;
pub const CONFIG_VIDEO_SAA7134_MODULE: u32 = 1;
pub const CONFIG_MAC_EMUMOUSEBTN_MODULE: u32 = 1;
pub const CONFIG_USB_LEGOTOWER_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_MAX6900_MODULE: u32 = 1;
pub const CONFIG_INTEL_WMI_SBL_FW_UPDATE_MODULE: u32 = 1;
pub const CONFIG_MTD_BLOCK_MODULE: u32 = 1;
pub const CONFIG_CC_HAS_MULTIDIMENSIONAL_NONSTRING: u32 = 1;
pub const CONFIG_SND_RME9652_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_BCM_SF2_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_GOODIX_BERLIN_I2C_MODULE: u32 = 1;
pub const CONFIG_TIPC_CRYPTO: u32 = 1;
pub const CONFIG_INFINIBAND_USER_ACCESS_MODULE: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_737_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_PANTHERLAKE_MODULE: u32 = 1;
pub const CONFIG_SENSORS_SMSC47M192_MODULE: u32 = 1;
pub const CONFIG_MODULES_USE_ELF_RELA: u32 = 1;
pub const CONFIG_NFS_V4_2: u32 = 1;
pub const CONFIG_NVME_KEYRING_MODULE: u32 = 1;
pub const CONFIG_LOCK_EVENT_COUNTS: u32 = 1;
pub const CONFIG_REGULATOR_TPS6524X_MODULE: u32 = 1;
pub const CONFIG_CPU_FREQ_DEFAULT_GOV_SCHEDUTIL: u32 = 1;
pub const CONFIG_RTC_DRV_RV3029C2_MODULE: u32 = 1;
pub const CONFIG_RT2400PCI_MODULE: u32 = 1;
pub const CONFIG_DRM_I915_MODULE: u32 = 1;
pub const CONFIG_CLOSURES: u32 = 1;
pub const CONFIG_MFD_AXP20X_I2C_MODULE: u32 = 1;
pub const CONFIG_HAVE_CALL_THUNKS: u32 = 1;
pub const CONFIG_BOOT_CONFIG: u32 = 1;
pub const CONFIG_X86_CET: u32 = 1;
pub const CONFIG_TULIP_MODULE: u32 = 1;
pub const CONFIG_MUX_ADG792A_MODULE: u32 = 1;
pub const CONFIG_PWM_PROVIDE_GPIO: u32 = 1;
pub const CONFIG_COMMON_CLK_CDCE706_MODULE: u32 = 1;
pub const CONFIG_HID_KYE_MODULE: u32 = 1;
pub const CONFIG_USB_XHCI_HCD: u32 = 1;
pub const CONFIG_ETHERNET: u32 = 1;
pub const CONFIG_DRM_PANIC: u32 = 1;
pub const CONFIG_INFINIBAND_RTRS_CLIENT_MODULE: u32 = 1;
pub const CONFIG_DRM_TTM_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV772X_MODULE: u32 = 1;
pub const CONFIG_NFSD_V3_ACL: u32 = 1;
pub const CONFIG_BLK_DEV_PCIESSD_MTIP32XX_MODULE: u32 = 1;
pub const CONFIG_PWM_TWL_LED_MODULE: u32 = 1;
pub const CONFIG_I2C_PIIX4_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_CHT_BSW_RT5645_MACH_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_CONNCOUNT_MODULE: u32 = 1;
pub const CONFIG_MTD_CFI_I2: u32 = 1;
pub const CONFIG_REGULATOR_LP8788_MODULE: u32 = 1;
pub const CONFIG_AD7266_MODULE: u32 = 1;
pub const CONFIG_DRM_NOUVEAU_SIL164_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_PF0900_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_LPASS_VA_MACRO_MODULE: u32 = 1;
pub const CONFIG_SND_ENS1371_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_LKKBD_MODULE: u32 = 1;
pub const CONFIG_INTEL_QEP_MODULE: u32 = 1;
pub const CONFIG_ZSWAP_COMPRESSOR_DEFAULT_ZSTD: u32 = 1;
pub const CONFIG_DELL_PC_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_QAT_4XXX_MODULE: u32 = 1;
pub const CONFIG_GTP_MODULE: u32 = 1;
pub const CONFIG_TREE_SRCU: u32 = 1;
pub const CONFIG_CXL_ACPI_MODULE: u32 = 1;
pub const CONFIG_DRM_ACCEL_IVPU_MODULE: u32 = 1;
pub const CONFIG_NETFS_STATS: u32 = 1;
pub const CONFIG_CRYPTO_CAMELLIA_AESNI_AVX2_X86_64_MODULE: u32 = 1;
pub const CONFIG_RADIO_SI470X_MODULE: u32 = 1;
pub const CONFIG_STK8BA50_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_LTC3589_MODULE: u32 = 1;
pub const CONFIG_NTFS_FS_MODULE: u32 = 1;
pub const CONFIG_C2PORT_DURAMAR_2150_MODULE: u32 = 1;
pub const CONFIG_IWLWIFI_MODULE: u32 = 1;
pub const CONFIG_BT_MTK_MODULE: u32 = 1;
pub const CONFIG_NF_CONNTRACK_AMANDA_MODULE: u32 = 1;
pub const CONFIG_VEML6075_MODULE: u32 = 1;
pub const CONFIG_TI_ADS7924_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_88PG86X_MODULE: u32 = 1;
pub const CONFIG_PSE_REGULATOR_MODULE: u32 = 1;
pub const CONFIG_EEPROM_AT24_MODULE: u32 = 1;
pub const CONFIG_BT_HIDP_MODULE: u32 = 1;
pub const CONFIG_SND_MAESTRO3_INPUT: u32 = 1;
pub const CONFIG_TSM_MEASUREMENTS: u32 = 1;
pub const CONFIG_SCSI_UFSHCD_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_MOXA_INTELLIO_MODULE: u32 = 1;
pub const CONFIG_ACPI_PROCESSOR: u32 = 1;
pub const CONFIG_BACKLIGHT_MP3309C_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_STRICT_KERNEL_RWX: u32 = 1;
pub const CONFIG_SUNRPC_BACKCHANNEL: u32 = 1;
pub const CONFIG_MFD_CGBC_MODULE: u32 = 1;
pub const CONFIG_I2C_SLAVE: u32 = 1;
pub const CONFIG_RTL8192SE_MODULE: u32 = 1;
pub const CONFIG_VMWARE_PVSCSI_MODULE: u32 = 1;
pub const CONFIG_WL1251_MODULE: u32 = 1;
pub const CONFIG_HAVE_LIVEPATCH: u32 = 1;
pub const CONFIG_SND_SOC_AK4554_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_DIBUSB_MB_FAULTY: u32 = 1;
pub const CONFIG_ZSWAP_DEFAULT_ON: u32 = 1;
pub const CONFIG_REGULATOR_RTQ6752_MODULE: u32 = 1;
pub const CONFIG_NF_CONNTRACK_TIMEOUT: u32 = 1;
pub const CONFIG_TOUCHSCREEN_MELFAS_MIP4_MODULE: u32 = 1;
pub const CONFIG_WWAN_MODULE: u32 = 1;
pub const CONFIG_GPIO_WINBOND_MODULE: u32 = 1;
pub const CONFIG_NET_ACT_POLICE_MODULE: u32 = 1;
pub const CONFIG_HID_UCLOGIC_MODULE: u32 = 1;
pub const CONFIG_BLOCK_HOLDER_DEPRECATED: u32 = 1;
pub const CONFIG_HID_WALTOP_MODULE: u32 = 1;
pub const CONFIG_PATA_OLDPIIX_MODULE: u32 = 1;
pub const CONFIG_ADF4371_MODULE: u32 = 1;
pub const CONFIG_PREEMPT: u32 = 1;
pub const CONFIG_USB_STORAGE_ISD200_MODULE: u32 = 1;
pub const CONFIG_INTEL_TCC: u32 = 1;
pub const CONFIG_GPIO_CROS_EC_MODULE: u32 = 1;
pub const CONFIG_ADRF6780_MODULE: u32 = 1;
pub const CONFIG_USB_SNP_CORE_MODULE: u32 = 1;
pub const CONFIG_ARCH_WANT_OLD_COMPAT_IPC: u32 = 1;
pub const CONFIG_SENSORS_AQUACOMPUTER_D5NEXT_MODULE: u32 = 1;
pub const CONFIG_DRM_MIPI_DBI_MODULE: u32 = 1;
pub const CONFIG_KEXEC_BZIMAGE_VERIFY_SIG: u32 = 1;
pub const CONFIG_SCSI_LPFC_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_HASWELL_MACH_MODULE: u32 = 1;
pub const CONFIG_GENERIC_IRQ_ENTRY: u32 = 1;
pub const CONFIG_INTEL_IDLE: u32 = 1;
pub const CONFIG_SND_SOC_CS35L33_MODULE: u32 = 1;
pub const CONFIG_REALTEK_AUTOPM: u32 = 1;
pub const CONFIG_MCP3911_MODULE: u32 = 1;
pub const CONFIG_VIDEO_IR_I2C_MODULE: u32 = 1;
pub const CONFIG_GENERIC_IRQ_MATRIX_ALLOCATOR: u32 = 1;
pub const CONFIG_LEDS_TRIGGER_GPIO_MODULE: u32 = 1;
pub const CONFIG_NI903X_WDT_MODULE: u32 = 1;
pub const CONFIG_LV0104CS_MODULE: u32 = 1;
pub const CONFIG_NFT_REJECT_MODULE: u32 = 1;
pub const CONFIG_SND_RME32_MODULE: u32 = 1;
pub const CONFIG_INET_DIAG_DESTROY: u32 = 1;
pub const CONFIG_LP_CONSOLE: u32 = 1;
pub const CONFIG_VIDEO_IVTV_ALSA_MODULE: u32 = 1;
pub const CONFIG_RANDOMIZE_MEMORY_PHYSICAL_PADDING: u32 = 10;
pub const CONFIG_8139CP_MODULE: u32 = 1;
pub const CONFIG_NET_NS: u32 = 1;
pub const CONFIG_NET_TEAM_MODE_BROADCAST_MODULE: u32 = 1;
pub const CONFIG_CRC16: u32 = 1;
pub const CONFIG_SOCK_CGROUP_DATA: u32 = 1;
pub const CONFIG_SCHED_CLUSTER: u32 = 1;
pub const CONFIG_VIDEO_CADENCE_CSI2RX_MODULE: u32 = 1;
pub const CONFIG_MITIGATION_RETHUNK: u32 = 1;
pub const CONFIG_TABLET_USB_PEGASUS_MODULE: u32 = 1;
pub const CONFIG_ISL29003_MODULE: u32 = 1;
pub const CONFIG_AD7606_IFACE_PARALLEL_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_PSXPAD_SPI_MODULE: u32 = 1;
pub const CONFIG_USB_AUTOSUSPEND_DELAY: u32 = 2;
pub const CONFIG_CRYPTO_SEQIV_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ADAU7118_HW_MODULE: u32 = 1;
pub const CONFIG_SERIAL_SCCNXP_MODULE: u32 = 1;
pub const CONFIG_DP83640_PHY_MODULE: u32 = 1;
pub const CONFIG_ARCH_MMAP_RND_COMPAT_BITS_MAX: u32 = 16;
pub const CONFIG_NLS_CODEPAGE_866_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT711_SDW_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_CAMELLIA_AESNI_AVX_X86_64_MODULE: u32 = 1;
pub const CONFIG_PRINTER_MODULE: u32 = 1;
pub const CONFIG_SENSORS_FTSTEUTATES_MODULE: u32 = 1;
pub const CONFIG_BRCMSMAC_LEDS: u32 = 1;
pub const CONFIG_IPMI_HANDLER_MODULE: u32 = 1;
pub const CONFIG_MUTEX_SPIN_ON_OWNER: u32 = 1;
pub const CONFIG_ACPI_APEI_GHES: u32 = 1;
pub const CONFIG_FSNOTIFY: u32 = 1;
pub const CONFIG_NET_FLOW_LIMIT: u32 = 1;
pub const CONFIG_NET_DSA_TAG_KSZ_MODULE: u32 = 1;
pub const CONFIG_FS_DAX_PMD: u32 = 1;
pub const CONFIG_MOUSE_PS2_VMMOUSE: u32 = 1;
pub const CONFIG_AMD_MEM_ENCRYPT: u32 = 1;
pub const CONFIG_NFT_REJECT_IPV6_MODULE: u32 = 1;
pub const CONFIG_CHELSIO_TLS_DEVICE_MODULE: u32 = 1;
pub const CONFIG_GNSS_UBX_SERIAL_MODULE: u32 = 1;
pub const CONFIG_CIFS_MODULE: u32 = 1;
pub const CONFIG_DW_EDMA_MODULE: u32 = 1;
pub const CONFIG_PCMCIA_SMC91C92_MODULE: u32 = 1;
pub const CONFIG_OCFS2_FS_USERSPACE_CLUSTER_MODULE: u32 = 1;
pub const CONFIG_DRM_ANALOGIX_ANX78XX_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_MICROCHIP_KSZ_COMMON_MODULE: u32 = 1;
pub const CONFIG_ATM_TCP_MODULE: u32 = 1;
pub const CONFIG_MSI_WMI_MODULE: u32 = 1;
pub const CONFIG_ALX_MODULE: u32 = 1;
pub const CONFIG_MISDN_DSP_MODULE: u32 = 1;
pub const CONFIG_INPUT_TOUCHSCREEN: u32 = 1;
pub const CONFIG_VIDEO_OV5670_MODULE: u32 = 1;
pub const CONFIG_BFQ_GROUP_IOSCHED: u32 = 1;
pub const CONFIG_CICADA_PHY_MODULE: u32 = 1;
pub const CONFIG_VIRTIO: u32 = 1;
pub const CONFIG_NET_DROP_MONITOR: u32 = 1;
pub const CONFIG_IP_SET_HASH_NETIFACE_MODULE: u32 = 1;
pub const CONFIG_INTEL_ATOMISP2_PM_MODULE: u32 = 1;
pub const CONFIG_I2C_SI470X_MODULE: u32 = 1;
pub const CONFIG_SND_INTEL_DSP_CONFIG_MODULE: u32 = 1;
pub const CONFIG_INPUT_DA9063_ONKEY_MODULE: u32 = 1;
pub const CONFIG_VIDEO_UPD64031A_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_TAG_BRCM_LEGACY_MODULE: u32 = 1;
pub const CONFIG_BOSCH_BNO055_I2C_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_HIMAX_HX852X_MODULE: u32 = 1;
pub const CONFIG_CLS_U32_PERF: u32 = 1;
pub const CONFIG_MMC_BLOCK_MINORS: u32 = 8;
pub const CONFIG_CRYPTO_USER_API_HASH_MODULE: u32 = 1;
pub const CONFIG_QED_FCOE: u32 = 1;
pub const CONFIG_CRYPTO_ARIA_GFNI_AVX512_X86_64_MODULE: u32 = 1;
pub const CONFIG_PARTITION_ADVANCED: u32 = 1;
pub const CONFIG_JOYSTICK_JOYDUMP_MODULE: u32 = 1;
pub const CONFIG_ACER_WMI_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_GAMECON_MODULE: u32 = 1;
pub const CONFIG_ROHM_BD79112_MODULE: u32 = 1;
pub const CONFIG_NFT_FIB_INET_MODULE: u32 = 1;
pub const CONFIG_DVB_MT352_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MC13783_ADC_MODULE: u32 = 1;
pub const CONFIG_EEPROM_IDT_89HPESX_MODULE: u32 = 1;
pub const CONFIG_ALTERA_FREEZE_BRIDGE_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS42L42_CORE_MODULE: u32 = 1;
pub const CONFIG_ALTERA_TSE_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LTC4151_MODULE: u32 = 1;
pub const CONFIG_LEDS_WM831X_STATUS_MODULE: u32 = 1;
pub const CONFIG_ZRAM_DEF_COMP: &[u8; 5] = b"zstd\0";
pub const CONFIG_I8K: u32 = 1;
pub const CONFIG_ATH9K_CHANNEL_CONTEXT: u32 = 1;
pub const CONFIG_FDDI_MODULE: u32 = 1;
pub const CONFIG_ATH5K_PCI: u32 = 1;
pub const CONFIG_REGULATOR_88PM8607_MODULE: u32 = 1;
pub const CONFIG_TCG_ATMEL_MODULE: u32 = 1;
pub const CONFIG_GPIO_LJCA_MODULE: u32 = 1;
pub const CONFIG_EDAC_I7CORE_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS35L41_MODULE: u32 = 1;
pub const CONFIG_INPUT_IDEAPAD_SLIDEBAR_MODULE: u32 = 1;
pub const CONFIG_CHARGER_LP8727_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WM8804_MODULE: u32 = 1;
pub const CONFIG_ATH11K_AHB_MODULE: u32 = 1;
pub const CONFIG_NFSD_MODULE: u32 = 1;
pub const CONFIG_PM_GENERIC_DOMAINS_SLEEP: u32 = 1;
pub const CONFIG_HID_CHICONY_MODULE: u32 = 1;
pub const CONFIG_USB_MA901_MODULE: u32 = 1;
pub const CONFIG_HP_BIOSCFG_MODULE: u32 = 1;
pub const CONFIG_ISCSI_IBFT_FIND: u32 = 1;
pub const CONFIG_DRM_GPUSVM_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX197_MODULE: u32 = 1;
pub const CONFIG_PCI_ECAM: u32 = 1;
pub const CONFIG_SYSTEM_TRUSTED_KEYRING: u32 = 1;
pub const CONFIG_SERIAL_SPRD_MODULE: u32 = 1;
pub const CONFIG_HAVE_KERNEL_BZIP2: u32 = 1;
pub const CONFIG_CRYPTO_ZSTD: u32 = 1;
pub const CONFIG_MFD_INTEL_LPSS_PCI_MODULE: u32 = 1;
pub const CONFIG_HID_MCP2200_MODULE: u32 = 1;
pub const CONFIG_DM_VERITY_VERIFY_ROOTHASH_SIG_PLATFORM_KEYRING: u32 = 1;
pub const CONFIG_ARCH_MMAP_RND_BITS_MAX: u32 = 32;
pub const CONFIG_BMP280_I2C_MODULE: u32 = 1;
pub const CONFIG_VIDEO_TUNER_MODULE: u32 = 1;
pub const CONFIG_LTC2497_MODULE: u32 = 1;
pub const CONFIG_NET_EMATCH_IPSET_MODULE: u32 = 1;
pub const CONFIG_ACPI_NHLT: u32 = 1;
pub const CONFIG_IP_VS_MH_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_XC2028_MODULE: u32 = 1;
pub const CONFIG_BATMAN_ADV_BLA: u32 = 1;
pub const CONFIG_REGULATOR_MAX77857_MODULE: u32 = 1;
pub const CONFIG_AD7192_MODULE: u32 = 1;
pub const CONFIG_CGROUP_DEVICE: u32 = 1;
pub const CONFIG_SMB_SERVER_MODULE: u32 = 1;
pub const CONFIG_BATTERY_BQ27XXX_HDQ_MODULE: u32 = 1;
pub const CONFIG_USB_NET_CDC_SUBSET_MODULE: u32 = 1;
pub const CONFIG_SENSORS_NTC_THERMISTOR_MODULE: u32 = 1;
pub const CONFIG_SCSI_FC_ATTRS_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_QUOTA_MODULE: u32 = 1;
pub const CONFIG_INPUT_CM109_MODULE: u32 = 1;
pub const CONFIG_MFD_SKY81452_MODULE: u32 = 1;
pub const CONFIG_VIDEO_SAA7134_DVB_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_OPERA1_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_PCF8583_MODULE: u32 = 1;
pub const CONFIG_PATA_PARPORT_ON20_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_INTEL: u32 = 1;
pub const CONFIG_PCIEAER_INJECT_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_MODULE: u32 = 1;
pub const CONFIG_SYNC_FILE: u32 = 1;
pub const CONFIG_BPF_SYSCALL: u32 = 1;
pub const CONFIG_USB_BDC_UDC_MODULE: u32 = 1;
pub const CONFIG_CAN_SOFTING_MODULE: u32 = 1;
pub const CONFIG_HYPERV_TIMER: u32 = 1;
pub const CONFIG_SYSTEM_REVOCATION_KEYS: &[u8; 1] = b"\0";
pub const CONFIG_DEVFREQ_GOV_PASSIVE_MODULE: u32 = 1;
pub const CONFIG_VIDEO_GO7007_MODULE: u32 = 1;
pub const CONFIG_SND_PCI: u32 = 1;
pub const CONFIG_VZ89X_MODULE: u32 = 1;
pub const CONFIG_USB_NET_INT51X1_MODULE: u32 = 1;
pub const CONFIG_USB_EHCI_HCD_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_HID_PENMOUNT_MODULE: u32 = 1;
pub const CONFIG_IP_SET_LIST_SET_MODULE: u32 = 1;
pub const CONFIG_LIBFC_MODULE: u32 = 1;
pub const CONFIG_IIO_ST_LSM9DS0_I2C_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_RS5C348_MODULE: u32 = 1;
pub const CONFIG_ICPLUS_PHY_MODULE: u32 = 1;
pub const CONFIG_DM_DEBUG_BLOCK_MANAGER_LOCKING: u32 = 1;
pub const CONFIG_VIDEO_OV08X40_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_EBT_ARPREPLY_MODULE: u32 = 1;
pub const CONFIG_NFS_V4_2_SSC_HELPER: u32 = 1;
pub const CONFIG_HAVE_KVM_DIRTY_RING_TSO: u32 = 1;
pub const CONFIG_IIO_KFIFO_BUF_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_INTERACT_MODULE: u32 = 1;
pub const CONFIG_MTD_CFI_I1: u32 = 1;
pub const CONFIG_LEDS_LP3944_MODULE: u32 = 1;
pub const CONFIG_VIRTIO_PCI: u32 = 1;
pub const CONFIG_RD_LZMA: u32 = 1;
pub const CONFIG_ADIS16480_MODULE: u32 = 1;
pub const CONFIG_DA311_MODULE: u32 = 1;
pub const CONFIG_MFD_INTEL_M10_BMC_PMCI_MODULE: u32 = 1;
pub const CONFIG_W1_SLAVE_DS2408_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_HAMPSHIRE_MODULE: u32 = 1;
pub const CONFIG_NFP_APP_FLOWER: u32 = 1;
pub const CONFIG_VIRTIO_PCI_LEGACY: u32 = 1;
pub const CONFIG_NTFS3_LZX_XPRESS: u32 = 1;
pub const CONFIG_SND_SOC_FS_AMP_LIB_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DS1685_FAMILY_MODULE: u32 = 1;
pub const CONFIG_DRM_XEN: u32 = 1;
pub const CONFIG_SND_SOC_WM8711_MODULE: u32 = 1;
pub const CONFIG_SENSORS_BEL_PFE_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_USERFAULTFD_MINOR: u32 = 1;
pub const CONFIG_MEDIA_TUNER_MXL301RF_MODULE: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_UPROBES: u32 = 1;
pub const CONFIG_SND_MAESTRO3_MODULE: u32 = 1;
pub const CONFIG_MEMORY_ISOLATION: u32 = 1;
pub const CONFIG_CIFS_SMB_DIRECT: u32 = 1;
pub const CONFIG_IWLEGACY_DEBUGFS: u32 = 1;
pub const CONFIG_IP_MROUTE: u32 = 1;
pub const CONFIG_JOYSTICK_TMDC_MODULE: u32 = 1;
pub const CONFIG_DRM_GMA500_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_DEBUG_VM_PGTABLE: u32 = 1;
pub const CONFIG_VIDEO_CS3308_MODULE: u32 = 1;
pub const CONFIG_INTEL_MRFLD_ADC_MODULE: u32 = 1;
pub const CONFIG_FB_SYS_IMAGEBLIT: u32 = 1;
pub const CONFIG_NET_DSA_TAG_NONE_MODULE: u32 = 1;
pub const CONFIG_PTE_MARKER_UFFD_WP: u32 = 1;
pub const CONFIG_MMA7455_MODULE: u32 = 1;
pub const CONFIG_USB_CONFIGFS_F_MIDI2: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_ACPI: u32 = 1;
pub const CONFIG_PREEMPT_DYNAMIC: u32 = 1;
pub const CONFIG_RTL8XXXU_MODULE: u32 = 1;
pub const CONFIG_TINYDRM_REPAPER_MODULE: u32 = 1;
pub const CONFIG_USB_NET_KALMIA_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_BELKIN_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_AES_TI_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_JITTERENTROPY_OSR: u32 = 1;
pub const CONFIG_HAVE_KRETPROBES: u32 = 1;
pub const CONFIG_ADVANTECH_EC_WDT_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_GOTOP: u32 = 1;
pub const CONFIG_SND_SOC_XTFPGA_I2S_MODULE: u32 = 1;
pub const CONFIG_ZSWAP_SHRINKER_DEFAULT_ON: u32 = 1;
pub const CONFIG_SPI_SPIDEV_MODULE: u32 = 1;
pub const CONFIG_RTW88_8814A_MODULE: u32 = 1;
pub const CONFIG_QRTR_SMD_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_PAC207_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_EMULEX: u32 = 1;
pub const CONFIG_SI1145_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_RC5T583_MODULE: u32 = 1;
pub const CONFIG_MARVELL_88Q2XXX_PHY_MODULE: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_850_MODULE: u32 = 1;
pub const CONFIG_IIO_RESCALE_MODULE: u32 = 1;
pub const CONFIG_IPE_BOOT_POLICY: &[u8; 1] = b"\0";
pub const CONFIG_AD7949_MODULE: u32 = 1;
pub const CONFIG_EFI_EMBEDDED_FIRMWARE: u32 = 1;
pub const CONFIG_SKB_DECRYPTED: u32 = 1;
pub const CONFIG_NINTENDO_FF: u32 = 1;
pub const CONFIG_OPENVSWITCH_GRE_MODULE: u32 = 1;
pub const CONFIG_NLS_MAC_INUIT_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_BYT_CHT_ES8316_MACH_MODULE: u32 = 1;
pub const CONFIG_MFD_MAX77693_MODULE: u32 = 1;
pub const CONFIG_NF_CONNTRACK_BRIDGE_MODULE: u32 = 1;
pub const CONFIG_X86_IO_APIC: u32 = 1;
pub const CONFIG_HID_SENSOR_DEVICE_ROTATION_MODULE: u32 = 1;
pub const CONFIG_VIDEO_IPU3_CIO2_MODULE: u32 = 1;
pub const CONFIG_KEYS: u32 = 1;
pub const CONFIG_ADUX1020_MODULE: u32 = 1;
pub const CONFIG_VIDEO_TVAUDIO_MODULE: u32 = 1;
pub const CONFIG_INPUT_YEALINK_MODULE: u32 = 1;
pub const CONFIG_MT7921S_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_LEWISBURG_MODULE: u32 = 1;
pub const CONFIG_IFCVF_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_ISL1208_MODULE: u32 = 1;
pub const CONFIG_DVB_OR51132_MODULE: u32 = 1;
pub const CONFIG_INA2XX_ADC_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS42L43_SDW_MODULE: u32 = 1;
pub const CONFIG_MFD_VIPERBOARD_MODULE: u32 = 1;
pub const CONFIG_IIO_ST_MAGN_I2C_3AXIS_MODULE: u32 = 1;
pub const CONFIG_SENSORS_NCT6694_MODULE: u32 = 1;
pub const CONFIG_CASSINI_MODULE: u32 = 1;
pub const CONFIG_HID_GREENASIA_MODULE: u32 = 1;
pub const CONFIG_CW1200_WLAN_SDIO_MODULE: u32 = 1;
pub const CONFIG_CXD2880_SPI_DRV_MODULE: u32 = 1;
pub const CONFIG_HAVE_INTEL_TXT: u32 = 1;
pub const CONFIG_TOUCHSCREEN_MMS114_MODULE: u32 = 1;
pub const CONFIG_SATA_NV_MODULE: u32 = 1;
pub const CONFIG_DVB_TEST_DRIVERS: u32 = 1;
pub const CONFIG_HID_SENSOR_GYRO_3D_MODULE: u32 = 1;
pub const CONFIG_IPMI_POWEROFF_MODULE: u32 = 1;
pub const CONFIG_TI_ADS7138_MODULE: u32 = 1;
pub const CONFIG_SERIO_CT82C710_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_SCODEC_CS35L56_MODULE: u32 = 1;
pub const CONFIG_CAN_M_CAN_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_ISL12022_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS4271_I2C_MODULE: u32 = 1;
pub const CONFIG_NET_SWITCHDEV: u32 = 1;
pub const CONFIG_REGULATOR_PV88080_MODULE: u32 = 1;
pub const CONFIG_X86_THERMAL_VECTOR: u32 = 1;
pub const CONFIG_REGMAP_SPI_AVMM_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MP9941_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LT3074_REGULATOR_MODULE: u32 = 1;
pub const CONFIG_MACB_USE_HWSTAMP: u32 = 1;
pub const CONFIG_ADXL372_I2C_MODULE: u32 = 1;
pub const CONFIG_DRM_ST7571_I2C_MODULE: u32 = 1;
pub const CONFIG_INTEL_SCU_PCI: u32 = 1;
pub const CONFIG_SND_AMD_ASOC_ACP63_MODULE: u32 = 1;
pub const CONFIG_SCSI_SYM53C8XX_2_MODULE: u32 = 1;
pub const CONFIG_PNFS_BLOCK_MODULE: u32 = 1;
pub const CONFIG_V4L2_ASYNC_MODULE: u32 = 1;
pub const CONFIG_DVB_FIREDTV_INPUT: u32 = 1;
pub const CONFIG_QLCNIC_HWMON: u32 = 1;
pub const CONFIG_ACPI_CMPC_MODULE: u32 = 1;
pub const CONFIG_PSAMPLE_MODULE: u32 = 1;
pub const CONFIG_RTW88_8822BS_MODULE: u32 = 1;
pub const CONFIG_I2C_SLAVE_EEPROM_MODULE: u32 = 1;
pub const CONFIG_ACPI_DOCK: u32 = 1;
pub const CONFIG_XEN_EFI: u32 = 1;
pub const CONFIG_HAVE_USER_RETURN_NOTIFIER: u32 = 1;
pub const CONFIG_ACPI_VIDEO_MODULE: u32 = 1;
pub const CONFIG_IO_WQ: u32 = 1;
pub const CONFIG_VHOST_MODULE: u32 = 1;
pub const CONFIG_USB_MASS_STORAGE_MODULE: u32 = 1;
pub const CONFIG_RADIO_SI4713_MODULE: u32 = 1;
pub const CONFIG_XEN_NETDEV_FRONTEND_MODULE: u32 = 1;
pub const CONFIG_INTEL_MEI_ME_MODULE: u32 = 1;
pub const CONFIG_IIO_CROS_EC_ACTIVITY_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_HUGE_VMAP: u32 = 1;
pub const CONFIG_VDSO_GETRANDOM: u32 = 1;
pub const CONFIG_SND_SOC_RT9123P_MODULE: u32 = 1;
pub const CONFIG_RTLBTCOEXIST_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_SCODEC_TAS2781_I2C_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_MV88E6XXX_MODULE: u32 = 1;
pub const CONFIG_VIA_RHINE_MMIO: u32 = 1;
pub const CONFIG_INTEL_TH_PTI_MODULE: u32 = 1;
pub const CONFIG_ADM8211_MODULE: u32 = 1;
pub const CONFIG_MCB_MODULE: u32 = 1;
pub const CONFIG_AS_VERSION: u32 = 24501;
pub const CONFIG_SENSORS_LT7182S_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_CCP: u32 = 1;
pub const CONFIG_RTW89_8852BE_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ACBEL_FSG032_MODULE: u32 = 1;
pub const CONFIG_AMT_MODULE: u32 = 1;
pub const CONFIG_BLK_CGROUP_PUNT_BIO: u32 = 1;
pub const CONFIG_YENTA_TOSHIBA: u32 = 1;
pub const CONFIG_INET_UDP_DIAG_MODULE: u32 = 1;
pub const CONFIG_USB_STORAGE_ALAUDA_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_HTB_MODULE: u32 = 1;
pub const CONFIG_IP_VS_FO_MODULE: u32 = 1;
pub const CONFIG_EDAC_IE31200_MODULE: u32 = 1;
pub const CONFIG_CHELSIO_IPSEC_INLINE_MODULE: u32 = 1;
pub const CONFIG_USB_NET_DRIVERS_MODULE: u32 = 1;
pub const CONFIG_ARCH_USE_QUEUED_RWLOCKS: u32 = 1;
pub const CONFIG_SCSI_SAS_LIBSAS_MODULE: u32 = 1;
pub const CONFIG_LTC2471_MODULE: u32 = 1;
pub const CONFIG_INPUT_PALMAS_PWRBUTTON_MODULE: u32 = 1;
pub const CONFIG_DVB_TUA6100_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_CYTTSP_I2C_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_LIB_SHA1_ARCH: u32 = 1;
pub const CONFIG_NFT_HASH_MODULE: u32 = 1;
pub const CONFIG_I2C_SIS5595_MODULE: u32 = 1;
pub const CONFIG_EXTCON_PTN5150_MODULE: u32 = 1;
pub const CONFIG_IEEE802154_FAKELB_MODULE: u32 = 1;
pub const CONFIG_AIR_EN8811H_PHY_MODULE: u32 = 1;
pub const CONFIG_PATA_NINJA32_MODULE: u32 = 1;
pub const CONFIG_INTEL_SOC_PMIC_CHTWC: u32 = 1;
pub const CONFIG_UBIFS_FS_AUTHENTICATION: u32 = 1;
pub const CONFIG_BTT: u32 = 1;
pub const CONFIG_USB_MAX3421_HCD_MODULE: u32 = 1;
pub const CONFIG_BRCMFMAC_SDIO: u32 = 1;
pub const CONFIG_EXTCON_USB_GPIO_MODULE: u32 = 1;
pub const CONFIG_ACPI_APEI_EINJ_CXL: u32 = 1;
pub const CONFIG_LEDS_TRIGGER_PATTERN_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_RTQ2208_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_ABX80X_MODULE: u32 = 1;
pub const CONFIG_EDAC_I3000_MODULE: u32 = 1;
pub const CONFIG_SND_SST_ATOM_HIFI2_PLATFORM_PCI_MODULE: u32 = 1;
pub const CONFIG_DM_CRYPT_MODULE: u32 = 1;
pub const CONFIG_IPV6_FOU_TUNNEL_MODULE: u32 = 1;
pub const CONFIG_IRQ_SIM: u32 = 1;
pub const CONFIG_HID_THRUSTMASTER_MODULE: u32 = 1;
pub const CONFIG_NFS_FS_MODULE: u32 = 1;
pub const CONFIG_LTC2496_MODULE: u32 = 1;
pub const CONFIG_DVB_S5H1420_MODULE: u32 = 1;
pub const CONFIG_BE2NET_BE3: u32 = 1;
pub const CONFIG_NET_VENDOR_NATSEMI: u32 = 1;
pub const CONFIG_IIO_CROS_EC_ACCEL_LEGACY_MODULE: u32 = 1;
pub const CONFIG_EEEPC_WMI_MODULE: u32 = 1;
pub const CONFIG_CROS_HPS_I2C_MODULE: u32 = 1;
pub const CONFIG_EXTCON_INTEL_CHT_WC_MODULE: u32 = 1;
pub const CONFIG_PATA_PARPORT_EPATC8: u32 = 1;
pub const CONFIG_RTC_DRV_BQ32K_MODULE: u32 = 1;
pub const CONFIG_MD_BITMAP_FILE: u32 = 1;
pub const CONFIG_FUTEX_PI: u32 = 1;
pub const CONFIG_HAS_IOPORT_MAP: u32 = 1;
pub const CONFIG_XFRM_STATISTICS: u32 = 1;
pub const CONFIG_STM_MODULE: u32 = 1;
pub const CONFIG_AD7191_MODULE: u32 = 1;
pub const CONFIG_THINKPAD_ACPI_HOTKEY_POLL: u32 = 1;
pub const CONFIG_SND_SOC_CS4271_SPI_MODULE: u32 = 1;
pub const CONFIG_ZRAM_BACKEND_LZO: u32 = 1;
pub const CONFIG_RTC_DRV_MAX6902_MODULE: u32 = 1;
pub const CONFIG_IP_VS_PROTO_AH: u32 = 1;
pub const CONFIG_SND_SOC_SOF_METEORLAKE_MODULE: u32 = 1;
pub const CONFIG_RTC_INTF_DEV: u32 = 1;
pub const CONFIG_NETFILTER_SYNPROXY_MODULE: u32 = 1;
pub const CONFIG_DVB_M88RS2000_MODULE: u32 = 1;
pub const CONFIG_IP6_NF_MATCH_IPV6HEADER_MODULE: u32 = 1;
pub const CONFIG_I2C_AMD_MP2_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DRBG_HMAC: u32 = 1;
pub const CONFIG_BRIDGE_EBT_STP_MODULE: u32 = 1;
pub const CONFIG_NFS_LOCALIO: u32 = 1;
pub const CONFIG_DRM_SSD130X_I2C_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_KEYSPAN_MODULE: u32 = 1;
pub const CONFIG_DVB_SI2165_MODULE: u32 = 1;
pub const CONFIG_MFD_WL1273_CORE_MODULE: u32 = 1;
pub const CONFIG_RTL8723BE_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_RT5033_MODULE: u32 = 1;
pub const CONFIG_QCOM_PMIC_PDCHARGER_ULOG_MODULE: u32 = 1;
pub const CONFIG_IP6_NF_MATCH_FRAG_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ADCXX_MODULE: u32 = 1;
pub const CONFIG_REALTEK_PHY_HWMON: u32 = 1;
pub const CONFIG_PATA_ALI_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_PCF85063_MODULE: u32 = 1;
pub const CONFIG_TSYS02D_MODULE: u32 = 1;
pub const CONFIG_MLX5_EN_IPSEC: u32 = 1;
pub const CONFIG_DVB_MMAP: u32 = 1;
pub const CONFIG_SENSORS_EMC6W201_MODULE: u32 = 1;
pub const CONFIG_RUST_IS_AVAILABLE: u32 = 1;
pub const CONFIG_USB_G_NCM_MODULE: u32 = 1;
pub const CONFIG_HIBERNATION_DEF_COMP: &[u8; 4] = b"lzo\0";
pub const CONFIG_SENSORS_AMC6821_MODULE: u32 = 1;
pub const CONFIG_MTD_NAND_ECC_SW_HAMMING: u32 = 1;
pub const CONFIG_BNA_MODULE: u32 = 1;
pub const CONFIG_SPI_OFFLOAD: u32 = 1;
pub const CONFIG_PARPORT_MODULE: u32 = 1;
pub const CONFIG_MT7615_COMMON_MODULE: u32 = 1;
pub const CONFIG_DRM_DISPLAY_HELPER_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_EBT_MARK_T_MODULE: u32 = 1;
pub const CONFIG_CROS_EC_SYSFS_MODULE: u32 = 1;
pub const CONFIG_NF_CONNTRACK_PPTP_MODULE: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_LTO_CLANG_THIN: u32 = 1;
pub const CONFIG_ARCH_MMAP_RND_BITS: u32 = 28;
pub const CONFIG_MITIGATION_RETPOLINE: u32 = 1;
pub const CONFIG_TYPEC_FUSB302_MODULE: u32 = 1;
pub const CONFIG_EXTCON_INTEL_INT3496_MODULE: u32 = 1;
pub const CONFIG_SENSORS_W83792D_MODULE: u32 = 1;
pub const CONFIG_EROFS_FS_ZIP_LZMA: u32 = 1;
pub const CONFIG_SENSORS_TMP464_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_IPCOMP_MODULE: u32 = 1;
pub const CONFIG_SFC_SIENA_SRIOV: u32 = 1;
pub const CONFIG_KPROBES_ON_FTRACE: u32 = 1;
pub const CONFIG_ADA4250_MODULE: u32 = 1;
pub const CONFIG_MLX5_MPFS: u32 = 1;
pub const CONFIG_SND_SOC_WCD938X_MODULE: u32 = 1;
pub const CONFIG_ALIM1535_WDT_MODULE: u32 = 1;
pub const CONFIG_PCIE_DW: u32 = 1;
pub const CONFIG_XFRM_SUB_POLICY: u32 = 1;
pub const CONFIG_ARCH_DEFAULT_CRASH_DUMP: u32 = 1;
pub const CONFIG_RT2800PCI_MODULE: u32 = 1;
pub const CONFIG_BMI323_SPI_MODULE: u32 = 1;
pub const CONFIG_IP6_NF_MATCH_RPFILTER_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_MODULE: u32 = 1;
pub const CONFIG_DRM_BOCHS_MODULE: u32 = 1;
pub const CONFIG_MISDN_HFCUSB_MODULE: u32 = 1;
pub const CONFIG_HID_SENSOR_PRESS_MODULE: u32 = 1;
pub const CONFIG_TI_DAC7612_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_USB_MODULE: u32 = 1;
pub const CONFIG_MM_ID: u32 = 1;
pub const CONFIG_NET_SCH_SFB_MODULE: u32 = 1;
pub const CONFIG_GENERIC_PINCTRL_GROUPS: u32 = 1;
pub const CONFIG_LTC2983_MODULE: u32 = 1;
pub const CONFIG_HID_SENSOR_HUMIDITY_MODULE: u32 = 1;
pub const CONFIG_BMC150_MAGN_SPI_MODULE: u32 = 1;
pub const CONFIG_RTW89_8851B_MODULE: u32 = 1;
pub const CONFIG_MDIO_MODULE: u32 = 1;
pub const CONFIG_AD7298_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_AMD_ACP70_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS35L45_SPI_MODULE: u32 = 1;
pub const CONFIG_NF_CT_PROTO_UDPLITE: u32 = 1;
pub const CONFIG_AD5504_MODULE: u32 = 1;
pub const CONFIG_YENTA_RICOH: u32 = 1;
pub const CONFIG_XFS_FS_MODULE: u32 = 1;
pub const CONFIG_SRF04_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_DVBSKY_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_SX8654_MODULE: u32 = 1;
pub const CONFIG_SX9310_MODULE: u32 = 1;
pub const CONFIG_SENSORS_AD7414_MODULE: u32 = 1;
pub const CONFIG_CAN_PEAK_PCI_MODULE: u32 = 1;
pub const CONFIG_MFD_WM5102: u32 = 1;
pub const CONFIG_BMI160_MODULE: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_857_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_TEE_MODULE: u32 = 1;
pub const CONFIG_X86_SGX: u32 = 1;
pub const CONFIG_PROFILING: u32 = 1;
pub const CONFIG_SND_SOC_RT1011_MODULE: u32 = 1;
pub const CONFIG_VIDEO_SAA7134_GO7007_MODULE: u32 = 1;
pub const CONFIG_CHARGER_BQ24190_MODULE: u32 = 1;
pub const CONFIG_THINKPAD_ACPI_VIDEO: u32 = 1;
pub const CONFIG_SND_SOC_AW88261_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_ALACRITECH: u32 = 1;
pub const CONFIG_RTW88_8812A_MODULE: u32 = 1;
pub const CONFIG_CROS_EC_TYPEC_ALTMODES: u32 = 1;
pub const CONFIG_HW_RANDOM_TIMERIOMEM_MODULE: u32 = 1;
pub const CONFIG_RT2X00_LIB_FIRMWARE: u32 = 1;
pub const CONFIG_BT_HCIBCM203X_MODULE: u32 = 1;
pub const CONFIG_IAQCORE_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_HDMI_ATI_MODULE: u32 = 1;
pub const CONFIG_ACPI_WATCHDOG: u32 = 1;
pub const CONFIG_HID_SAMSUNG_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SPDIF_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_IT913X_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RTQ9124_MODULE: u32 = 1;
pub const CONFIG_SND_SIMPLE_CARD_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT5651_MODULE: u32 = 1;
pub const CONFIG_USB4_NET_MODULE: u32 = 1;
pub const CONFIG_VFIO_DEVICE_CDEV: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_864_MODULE: u32 = 1;
pub const CONFIG_CAN_8DEV_USB_MODULE: u32 = 1;
pub const CONFIG_LEDS_SIEMENS_SIMATIC_IPC_MODULE: u32 = 1;
pub const CONFIG_WIRELESS_HOTKEY_MODULE: u32 = 1;
pub const CONFIG_USB_CXACRU_MODULE: u32 = 1;
pub const CONFIG_KVM_VFIO: u32 = 1;
pub const CONFIG_F2FS_IOSTAT: u32 = 1;
pub const CONFIG_HID_BPF: u32 = 1;
pub const CONFIG_COMMON_CLK_MAX9485_MODULE: u32 = 1;
pub const CONFIG_6LOWPAN_NHC_ROUTING_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_FTDI_SIO_MODULE: u32 = 1;
pub const CONFIG_ADIS16130_MODULE: u32 = 1;
pub const CONFIG_USB_CDNS2_UDC_MODULE: u32 = 1;
pub const CONFIG_SCSI_CONSTANTS: u32 = 1;
pub const CONFIG_HAVE_ARCH_TRANSPARENT_HUGEPAGE: u32 = 1;
pub const CONFIG_NET_SCH_FIFO: u32 = 1;
pub const CONFIG_SYSTEM76_ACPI_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_VLAN_FILTERING: u32 = 1;
pub const CONFIG_TRACE_IRQFLAGS_NMI_SUPPORT: u32 = 1;
pub const CONFIG_BT_HCIUART_ATH3K: u32 = 1;
pub const CONFIG_TYPEC_TCPM_MODULE: u32 = 1;
pub const CONFIG_IIO_ST_MAGN_3AXIS_MODULE: u32 = 1;
pub const CONFIG_GPIO_MPSSE_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_EFA_MODULE: u32 = 1;
pub const CONFIG_I2C_MLXCPLD_MODULE: u32 = 1;
pub const CONFIG_NLS_DEFAULT: &[u8; 5] = b"utf8\0";
pub const CONFIG_ZRAM_TRACK_ENTRY_ACTIME: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_CS420X_MODULE: u32 = 1;
pub const CONFIG_THP_SWAP: u32 = 1;
pub const CONFIG_MEDIA_TUNER_XC4000_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MP2975_REGULATOR: u32 = 1;
pub const CONFIG_SND_SOC_ADI_AXI_I2S_MODULE: u32 = 1;
pub const CONFIG_MFD_DA9150_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_ELO: u32 = 1;
pub const CONFIG_EROFS_FS_ONDEMAND: u32 = 1;
pub const CONFIG_RTW88_8723X_MODULE: u32 = 1;
pub const CONFIG_MITIGATION_VMSCAPE: u32 = 1;
pub const CONFIG_CRYPTO_DH_RFC7919_GROUPS: u32 = 1;
pub const CONFIG_SENSORS_ADT7462_MODULE: u32 = 1;
pub const CONFIG_MOUSE_PS2_SENTELIC: u32 = 1;
pub const CONFIG_RTW88_88XXA_MODULE: u32 = 1;
pub const CONFIG_CC_HAS_MIN_FUNCTION_ALIGNMENT: u32 = 1;
pub const CONFIG_SENSORS_HS3001_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_XPAD_MODULE: u32 = 1;
pub const CONFIG_BT_MRVL_MODULE: u32 = 1;
pub const CONFIG_SCSI_FDOMAIN_MODULE: u32 = 1;
pub const CONFIG_MOST_COMPONENTS_MODULE: u32 = 1;
pub const CONFIG_SENSORS_TC74_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_ICELAKE_MODULE: u32 = 1;
pub const CONFIG_DMA_NEED_SYNC: u32 = 1;
pub const CONFIG_VEML6030_MODULE: u32 = 1;
pub const CONFIG_AF_RXRPC_DEBUG: u32 = 1;
pub const CONFIG_NLS_ISO8859_13_MODULE: u32 = 1;
pub const CONFIG_INTEL_LDMA: u32 = 1;
pub const CONFIG_SND_SOC_CS35L56_MODULE: u32 = 1;
pub const CONFIG_MMC_SDHCI_PCI_MODULE: u32 = 1;
pub const CONFIG_MMC_VIA_SDMMC_MODULE: u32 = 1;
pub const CONFIG_MENZ069_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_AMD_ATL_PRM: u32 = 1;
pub const CONFIG_X86_REQUIRED_FEATURE_ALWAYS: u32 = 1;
pub const CONFIG_DRM_AMD_DC: u32 = 1;
pub const CONFIG_EARLY_PRINTK_USB: u32 = 1;
pub const CONFIG_REGULATOR_NETLINK_EVENTS: u32 = 1;
pub const CONFIG_DVB_NETUP_UNIDVB_MODULE: u32 = 1;
pub const CONFIG_MTDRAM_TOTAL_SIZE: u32 = 4096;
pub const CONFIG_LOCK_DOWN_KERNEL_FORCE_NONE: u32 = 1;
pub const CONFIG_REGULATOR: u32 = 1;
pub const CONFIG_TYPEC_MUX_PI3USB30532_MODULE: u32 = 1;
pub const CONFIG_HID_PLAYSTATION_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SOF_ES8336_MACH_MODULE: u32 = 1;
pub const CONFIG_MODULE_SRCVERSION_ALL: u32 = 1;
pub const CONFIG_SENSORS_INA3221_MODULE: u32 = 1;
pub const CONFIG_ACPI_I2C_OPREGION: u32 = 1;
pub const CONFIG_NFP_MODULE: u32 = 1;
pub const CONFIG_6LOWPAN_GHC_EXT_HDR_DEST_MODULE: u32 = 1;
pub const CONFIG_XEN_BLKDEV_BACKEND_MODULE: u32 = 1;
pub const CONFIG_VIDEO_LM3646_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TAS2562_MODULE: u32 = 1;
pub const CONFIG_MEDIATEK_MT6360_ADC_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_CLIENT_MODULE: u32 = 1;
pub const CONFIG_INPUT_SPARSEKMAP_MODULE: u32 = 1;
pub const CONFIG_BACKLIGHT_MT6370_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_CONNLABEL_MODULE: u32 = 1;
pub const CONFIG_DMI_SCAN_MACHINE_NON_EFI_FALLBACK: u32 = 1;
pub const CONFIG_DVB_LGDT3306A_MODULE: u32 = 1;
pub const CONFIG_TYPEC_WCOVE_MODULE: u32 = 1;
pub const CONFIG_GRO_CELLS: u32 = 1;
pub const CONFIG_TOUCHSCREEN_GOODIX_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_WM831X_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CX25821_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_JITTERENTROPY_MEMORY_BLOCKSIZE: u32 = 32;
pub const CONFIG_PACKET_DIAG_MODULE: u32 = 1;
pub const CONFIG_GENERIC_STRNCPY_FROM_USER: u32 = 1;
pub const CONFIG_ISCSI_TARGET_CXGB4_MODULE: u32 = 1;
pub const CONFIG_HID_RMI_MODULE: u32 = 1;
pub const CONFIG_BE2NET_BE2: u32 = 1;
pub const CONFIG_TOUCHSCREEN_WDT87XX_I2C_MODULE: u32 = 1;
pub const CONFIG_TEXTSEARCH: u32 = 1;
pub const CONFIG_XFS_BTREE_IN_MEM: u32 = 1;
pub const CONFIG_MFD_DA9052_SPI: u32 = 1;
pub const CONFIG_HAVE_MOVE_PMD: u32 = 1;
pub const CONFIG_NETXEN_NIC_MODULE: u32 = 1;
pub const CONFIG_DRM_XE_ENABLE_SCHEDTIMEOUT_LIMIT: u32 = 1;
pub const CONFIG_VHOST_VDPA_MODULE: u32 = 1;
pub const CONFIG_IWLWIFI_DEBUGFS: u32 = 1;
pub const CONFIG_USB_SERIAL_WISHBONE_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_RECENT_MODULE: u32 = 1;
pub const CONFIG_PROC_EVENTS: u32 = 1;
pub const CONFIG_IIO_CROS_EC_SENSORS_LID_ANGLE_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_SRP_MODULE: u32 = 1;
pub const CONFIG_USB_F_MIDI2_MODULE: u32 = 1;
pub const CONFIG_FAILOVER_MODULE: u32 = 1;
pub const CONFIG_TYPEC_MUX_NB7VPQ904M_MODULE: u32 = 1;
pub const CONFIG_PAGE_MAPCOUNT: u32 = 1;
pub const CONFIG_LINEAR_RANGES: u32 = 1;
pub const CONFIG_NFS_V4_1: u32 = 1;
pub const CONFIG_SATA_VIA_MODULE: u32 = 1;
pub const CONFIG_PATA_NS87415_MODULE: u32 = 1;
pub const CONFIG_TRUSTED_KEYS_TEE: u32 = 1;
pub const CONFIG_BOSCH_BNO055_SERIAL_MODULE: u32 = 1;
pub const CONFIG_WEXT_PROC: u32 = 1;
pub const CONFIG_CRYPTO_CAST6_AVX_X86_64_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AK5558_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_GOLDFISH_MODULE: u32 = 1;
pub const CONFIG_NF_TPROXY_IPV4_MODULE: u32 = 1;
pub const CONFIG_NF_CONNTRACK_IRC_MODULE: u32 = 1;
pub const CONFIG_SCHED_STACK_END_CHECK: u32 = 1;
pub const CONFIG_DM_LOG_USERSPACE_MODULE: u32 = 1;
pub const CONFIG_INT340X_THERMAL_MODULE: u32 = 1;
pub const CONFIG_PATA_MPIIX_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_EBT_BROUTE_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_PCM3060_I2C_MODULE: u32 = 1;
pub const CONFIG_AD5696_I2C_MODULE: u32 = 1;
pub const CONFIG_VIRTIO_DMA_SHARED_BUFFER_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_CORE_MODULE: u32 = 1;
pub const CONFIG_RAS_CEC: u32 = 1;
pub const CONFIG_SCSI_UFS_CDNS_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_HID: u32 = 1;
pub const CONFIG_X86_CPU_RESCTRL: u32 = 1;
pub const CONFIG_CRYPTO_LZ4_MODULE: u32 = 1;
pub const CONFIG_XILINX_XDMA_MODULE: u32 = 1;
pub const CONFIG_DM_VERITY_VERIFY_ROOTHASH_SIG_SECONDARY_KEYRING: u32 = 1;
pub const CONFIG_NET_VENDOR_HISILICON: u32 = 1;
pub const CONFIG_SCSI_MYRS_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SOF_MAXIM_COMMON_MODULE: u32 = 1;
pub const CONFIG_NFC_PN533_MODULE: u32 = 1;
pub const CONFIG_ALIENWARE_WMI_WMAX: u32 = 1;
pub const CONFIG_MTK_T7XX_MODULE: u32 = 1;
pub const CONFIG_NE2K_PCI_MODULE: u32 = 1;
pub const CONFIG_NET_TEAM_MODE_RANDOM_MODULE: u32 = 1;
pub const CONFIG_FBNIC_MODULE: u32 = 1;
pub const CONFIG_SATA_VITESSE_MODULE: u32 = 1;
pub const CONFIG_FPGA_MGR_LATTICE_SYSCONFIG_MODULE: u32 = 1;
pub const CONFIG_USB_GADGETFS_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_GENERIC_DMAENGINE_PCM: u32 = 1;
pub const CONFIG_NFT_MASQ_MODULE: u32 = 1;
pub const CONFIG_NET_IFE_SKBPRIO_MODULE: u32 = 1;
pub const CONFIG_AD7887_MODULE: u32 = 1;
pub const CONFIG_HID_CP2112_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_TEQL_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_LIB_UTILS: u32 = 1;
pub const CONFIG_SND_SOC_DA7213_MODULE: u32 = 1;
pub const CONFIG_VEML6070_MODULE: u32 = 1;
pub const CONFIG_SG_POOL: u32 = 1;
pub const CONFIG_X86: u32 = 1;
pub const CONFIG_MFD_WM831X_SPI: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_HUGE_PFNMAP: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_CM9825_MODULE: u32 = 1;
pub const CONFIG_SERIAL_RP2_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DH: u32 = 1;
pub const CONFIG_KFENCE: u32 = 1;
pub const CONFIG_MTD_BLOCK2MTD_MODULE: u32 = 1;
pub const CONFIG_EXTCON_MAX77843_MODULE: u32 = 1;
pub const CONFIG_CC_HAS_WORKING_NOSANITIZE_ADDRESS: u32 = 1;
pub const CONFIG_INPUT_BMA150_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_HMARK_MODULE: u32 = 1;
pub const CONFIG_BLK_CGROUP_RWSTAT: u32 = 1;
pub const CONFIG_MISDN_HDLC_MODULE: u32 = 1;
pub const CONFIG_USB_CDNS3_MODULE: u32 = 1;
pub const CONFIG_X86_REQUIRED_FEATURE_NOPL: u32 = 1;
pub const CONFIG_QCOM_HIDMA_MODULE: u32 = 1;
pub const CONFIG_NTFS3_FS_POSIX_ACL: u32 = 1;
pub const CONFIG_DELL_WMI_MODULE: u32 = 1;
pub const CONFIG_SMS_SDIO_DRV_MODULE: u32 = 1;
pub const CONFIG_USB_G_WEBCAM_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_CHT_BSW_MAX98090_TI_MACH_MODULE: u32 = 1;
pub const CONFIG_CROS_EC_PROTO_MODULE: u32 = 1;
pub const CONFIG_CORE_DUMP_DEFAULT_ELF_HEADERS: u32 = 1;
pub const CONFIG_EXTCON_MAX3355_MODULE: u32 = 1;
pub const CONFIG_SURFACE_AGGREGATOR_BUS: u32 = 1;
pub const CONFIG_NET_EMATCH: u32 = 1;
pub const CONFIG_SND_HDA_POWER_SAVE_DEFAULT: u32 = 10;
pub const CONFIG_SND_SOC_INTEL_BYT_CHT_CX2072X_MACH_MODULE: u32 = 1;
pub const CONFIG_PWM_TWL_MODULE: u32 = 1;
pub const CONFIG_B44_PCI_AUTOSELECT: u32 = 1;
pub const CONFIG_TYPEC_MODULE: u32 = 1;
pub const CONFIG_RPMSG_CHAR_MODULE: u32 = 1;
pub const CONFIG_MODULE_SIG_SHA512: u32 = 1;
pub const CONFIG_LTC2664_MODULE: u32 = 1;
pub const CONFIG_IP6_NF_MATCH_HL_MODULE: u32 = 1;
pub const CONFIG_MOST_CDEV_MODULE: u32 = 1;
pub const CONFIG_SENSORS_SMSC47M1_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MAX8952_MODULE: u32 = 1;
pub const CONFIG_SENSORS_NCT6775_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_OWNER_MODULE: u32 = 1;
pub const CONFIG_BINFMT_MISC: u32 = 1;
pub const CONFIG_CAN_PEAK_PCIEFD_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_RNBD_CLIENT_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS35L36_MODULE: u32 = 1;
pub const CONFIG_INTEL_TCC_COOLING_MODULE: u32 = 1;
pub const CONFIG_MT792x_LIB_MODULE: u32 = 1;
pub const CONFIG_SBC_FITPC2_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_DVB_STV6110x_MODULE: u32 = 1;
pub const CONFIG_USB_PCI: u32 = 1;
pub const CONFIG_SND_SOC_MSM8916_WCD_DIGITAL_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_FINEPIX_MODULE: u32 = 1;
pub const CONFIG_MRP_MODULE: u32 = 1;
pub const CONFIG_SCHED_MM_CID: u32 = 1;
pub const CONFIG_ACPI_VIOT: u32 = 1;
pub const CONFIG_NFSD_BLOCKLAYOUT: u32 = 1;
pub const CONFIG_VIDEO_THP7312_MODULE: u32 = 1;
pub const CONFIG_PWM_DWC_CORE_MODULE: u32 = 1;
pub const CONFIG_GPIO_MADERA_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_SM3_AVX_X86_64_MODULE: u32 = 1;
pub const CONFIG_MCP4131_MODULE: u32 = 1;
pub const CONFIG_ADVISE_SYSCALLS: u32 = 1;
pub const CONFIG_MT76x2U_MODULE: u32 = 1;
pub const CONFIG_THERMAL_GOV_STEP_WISE: u32 = 1;
pub const CONFIG_NET: u32 = 1;
pub const CONFIG_MODULE_FORCE_UNLOAD: u32 = 1;
pub const CONFIG_MOUSE_APPLETOUCH_MODULE: u32 = 1;
pub const CONFIG_X86_VSYSCALL_EMULATION: u32 = 1;
pub const CONFIG_ARCH_ENABLE_SPLIT_PMD_PTLOCK: u32 = 1;
pub const CONFIG_HAVE_OPTPROBES: u32 = 1;
pub const CONFIG_WLAN_VENDOR_MICROCHIP: u32 = 1;
pub const CONFIG_MPL115_I2C_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MAX8925_MODULE: u32 = 1;
pub const CONFIG_IEEE802154_ADF7242_MODULE: u32 = 1;
pub const CONFIG_SCSI_MVSAS_TASKLET: u32 = 1;
pub const CONFIG_NET_DSA_TAG_GSWIP_MODULE: u32 = 1;
pub const CONFIG_XFRM_IPCOMP_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_PCTV452E_MODULE: u32 = 1;
pub const CONFIG_HMC6352_MODULE: u32 = 1;
pub const CONFIG_GPIO_ACPI: u32 = 1;
pub const CONFIG_NFC_FDP_I2C_MODULE: u32 = 1;
pub const CONFIG_MTRR_SANITIZER: u32 = 1;
pub const CONFIG_AD5110_MODULE: u32 = 1;
pub const CONFIG_MFD_TQMX86_MODULE: u32 = 1;
pub const CONFIG_DEFAULT_CUBIC: u32 = 1;
pub const CONFIG_XFRM_USER_MODULE: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_865_MODULE: u32 = 1;
pub const CONFIG_USB_DEFAULT_AUTHORIZATION_MODE: u32 = 1;
pub const CONFIG_NET_REDIRECT: u32 = 1;
pub const CONFIG_ACPI_THERMAL: u32 = 1;
pub const CONFIG_INPUT_ARIZONA_HAPTICS_MODULE: u32 = 1;
pub const CONFIG_LOAD_UEFI_KEYS: u32 = 1;
pub const CONFIG_USB_LAN78XX_MODULE: u32 = 1;
pub const CONFIG_AD2S1200_MODULE: u32 = 1;
pub const CONFIG_VIRTIO_RTC_CLASS: u32 = 1;
pub const CONFIG_SMS_USB_DRV_MODULE: u32 = 1;
pub const CONFIG_GACT_PROB: u32 = 1;
pub const CONFIG_NET_VENDOR_ENGLEDER: u32 = 1;
pub const CONFIG_ATL1E_MODULE: u32 = 1;
pub const CONFIG_X86_SPEEDSTEP_LIB_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CAMERA_SENSOR: u32 = 1;
pub const CONFIG_TRACEPOINTS: u32 = 1;
pub const CONFIG_SCHED_SMT: u32 = 1;
pub const CONFIG_LIRC: u32 = 1;
pub const CONFIG_UNINLINE_SPIN_UNLOCK: u32 = 1;
pub const CONFIG_SND_SOC_MTK_BTCVSD_MODULE: u32 = 1;
pub const CONFIG_PCSPKR_PLATFORM: u32 = 1;
pub const CONFIG_INITRAMFS_SOURCE: &[u8; 1] = b"\0";
pub const CONFIG_EXFAT_FS_MODULE: u32 = 1;
pub const CONFIG_PROC_THERMAL_MMIO_RAPL_MODULE: u32 = 1;
pub const CONFIG_VCNL3020_MODULE: u32 = 1;
pub const CONFIG_B43_PHY_N: u32 = 1;
pub const CONFIG_SIGNED_PE_FILE_VERIFICATION: u32 = 1;
pub const CONFIG_UNIX98_PTYS: u32 = 1;
pub const CONFIG_RANDOMIZE_KSTACK_OFFSET: u32 = 1;
pub const CONFIG_CLKBLD_I8253: u32 = 1;
pub const CONFIG_SOUNDWIRE_QCOM_MODULE: u32 = 1;
pub const CONFIG_SPI_XCOMM_MODULE: u32 = 1;
pub const CONFIG_USB_APPLEDISPLAY_MODULE: u32 = 1;
pub const CONFIG_PPP_SYNC_TTY_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_CONNBYTES_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_NONLEAF_PMD_YOUNG: u32 = 1;
pub const CONFIG_TYPEC_MUX_INTEL_PMC_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_GRIP_MP_MODULE: u32 = 1;
pub const CONFIG_RTW88_8822BU_MODULE: u32 = 1;
pub const CONFIG_SATA_ULI_MODULE: u32 = 1;
pub const CONFIG_AMD_XGBE_HAVE_ECC: u32 = 1;
pub const CONFIG_PCI_PF_STUB_MODULE: u32 = 1;
pub const CONFIG_DRM_CIRRUS_QEMU_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_INTEL_ICL_MODULE: u32 = 1;
pub const CONFIG_ACPI_PROCESSOR_CSTATE: u32 = 1;
pub const CONFIG_DRM_SUBALLOC_HELPER_MODULE: u32 = 1;
pub const CONFIG_VIDEO_RP1_CFE_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX1111_MODULE: u32 = 1;
pub const CONFIG_PPP_BSDCOMP_MODULE: u32 = 1;
pub const CONFIG_USB_GADGET_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_EBT_LIMIT_MODULE: u32 = 1;
pub const CONFIG_ARCH_WANT_OPTIMIZE_HUGETLB_VMEMMAP: u32 = 1;
pub const CONFIG_SENSORS_MC34VR500_MODULE: u32 = 1;
pub const CONFIG_HID_WIIMOTE_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_SM4_GENERIC_MODULE: u32 = 1;
pub const CONFIG_INTEL_IDXD_MODULE: u32 = 1;
pub const CONFIG_ARCH_SPARSEMEM_DEFAULT: u32 = 1;
pub const CONFIG_BACKLIGHT_KTZ8866_MODULE: u32 = 1;
pub const CONFIG_KEXEC_JUMP: u32 = 1;
pub const CONFIG_MEMORY_BALLOON: u32 = 1;
pub const CONFIG_VFIO_MODULE: u32 = 1;
pub const CONFIG_NFC_HCI_MODULE: u32 = 1;
pub const CONFIG_NLS_ISO8859_14_MODULE: u32 = 1;
pub const CONFIG_EXECMEM: u32 = 1;
pub const CONFIG_HARDLOCKUP_DETECTOR_COUNTS_HRTIMER: u32 = 1;
pub const CONFIG_SND_SOC_SOF_IPC4: u32 = 1;
pub const CONFIG_DVB_ZD1301_DEMOD_MODULE: u32 = 1;
pub const CONFIG_DEBUG_INFO_BTF_MODULES: u32 = 1;
pub const CONFIG_SND_SOC_WM_ADSP_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_BYTCR_RT5651_MACH_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_REALTEK: u32 = 1;
pub const CONFIG_XFRM_OFFLOAD: u32 = 1;
pub const CONFIG_ZRAM_MULTI_COMP: u32 = 1;
pub const CONFIG_ADIS16209_MODULE: u32 = 1;
pub const CONFIG_IPV6_SEG6_LWTUNNEL: u32 = 1;
pub const CONFIG_MEDIA_TUNER_TDA18212_MODULE: u32 = 1;
pub const CONFIG_CHARGER_CROS_PCHG_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_TAG_RTL4_A_MODULE: u32 = 1;
pub const CONFIG_BMI088_ACCEL_I2C_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LTC2947_I2C_MODULE: u32 = 1;
pub const CONFIG_OVERLAY_FS_MODULE: u32 = 1;
pub const CONFIG_SECONDARY_TRUSTED_KEYRING: u32 = 1;
pub const CONFIG_ICS932S401_MODULE: u32 = 1;
pub const CONFIG_BT_MODULE: u32 = 1;
pub const CONFIG_ZRAM_BACKEND_DEFLATE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_IDEALTEK: u32 = 1;
pub const CONFIG_HOTPLUG_SPLIT_STARTUP: u32 = 1;
pub const CONFIG_VT: u32 = 1;
pub const CONFIG_USB_GSPCA_JEILINJ_MODULE: u32 = 1;
pub const CONFIG_NET_CLS_ACT: u32 = 1;
pub const CONFIG_XEN_PV_DOM0: u32 = 1;
pub const CONFIG_DVB_USB_MXL111SF_MODULE: u32 = 1;
pub const CONFIG_ET131X_MODULE: u32 = 1;
pub const CONFIG_COMPAT_OLD_SIGACTION: u32 = 1;
pub const CONFIG_EEPROM_MAX6875_MODULE: u32 = 1;
pub const CONFIG_VIDEO_VIMC_MODULE: u32 = 1;
pub const CONFIG_LIBNVDIMM_MODULE: u32 = 1;
pub const CONFIG_PAHOLE_HAS_LANG_EXCLUDE: u32 = 1;
pub const CONFIG_SERIAL_ALTERA_JTAGUART_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_ABB5ZES3_MODULE: u32 = 1;
pub const CONFIG_IP_SET_HASH_IPPORTIP_MODULE: u32 = 1;
pub const CONFIG_BATTERY_GOLDFISH_MODULE: u32 = 1;
pub const CONFIG_SMP: u32 = 1;
pub const CONFIG_ARCH_MMAP_RND_COMPAT_BITS: u32 = 8;
pub const CONFIG_AMD_SFH_HID_MODULE: u32 = 1;
pub const CONFIG_VLAN_8021Q_MVRP: u32 = 1;
pub const CONFIG_MITIGATION_GDS: u32 = 1;
pub const CONFIG_SCSI_BNX2_ISCSI_MODULE: u32 = 1;
pub const CONFIG_R8169_LEDS: u32 = 1;
pub const CONFIG_ATM_FORE200E_DEBUG: u32 = 0;
pub const CONFIG_INFINIBAND_RDMAVT_MODULE: u32 = 1;
pub const CONFIG_BT_HCIBTUSB_RTL: u32 = 1;
pub const CONFIG_W1_SLAVE_DS250X_MODULE: u32 = 1;
pub const CONFIG_VIDEO_GC08A3_MODULE: u32 = 1;
pub const CONFIG_DETECT_HUNG_TASK_BLOCKER: u32 = 1;
pub const CONFIG_CFG80211_MODULE: u32 = 1;
pub const CONFIG_NFT_QUOTA_MODULE: u32 = 1;
pub const CONFIG_PARPORT_PC_MODULE: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_MSEAL_SYSTEM_MAPPINGS: u32 = 1;
pub const CONFIG_LIQUIDIO_CORE_MODULE: u32 = 1;
pub const CONFIG_CEPH_FS_POSIX_ACL: u32 = 1;
pub const CONFIG_REGULATOR_MAX8997_MODULE: u32 = 1;
pub const CONFIG_HID_REDRAGON_MODULE: u32 = 1;
pub const CONFIG_BT_RTL_MODULE: u32 = 1;
pub const CONFIG_SECURITYFS: u32 = 1;
pub const CONFIG_VIDEO_CX88_DVB_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_GOODIX_BERLIN_CORE_MODULE: u32 = 1;
pub const CONFIG_MOST_I2C_MODULE: u32 = 1;
pub const CONFIG_VIDEO_SOLO6X10_MODULE: u32 = 1;
pub const CONFIG_QUEUED_RWLOCKS: u32 = 1;
pub const CONFIG_VMWARE_VMCI_VSOCKETS_MODULE: u32 = 1;
pub const CONFIG_BT_HCIVHCI_MODULE: u32 = 1;
pub const CONFIG_SND_SST_ATOM_HIFI2_PLATFORM_ACPI_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_DCCP_MODULE: u32 = 1;
pub const CONFIG_LSM_MMAP_MIN_ADDR: u32 = 65536;
pub const CONFIG_MAC80211_RC_MINSTREL: u32 = 1;
pub const CONFIG_X86_KERNEL_IBT: u32 = 1;
pub const CONFIG_XEN_PCIDEV_FRONTEND_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CX231XX_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_HASHLIMIT_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_AUDITSYSCALL: u32 = 1;
pub const CONFIG_FIREWIRE_SBP2_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_STI_SAS_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AK5386_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_SCODEC_TAS2781_SPI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_STA350_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_LOOP_MODULE: u32 = 1;
pub const CONFIG_TI_ADS1298_MODULE: u32 = 1;
pub const CONFIG_IPV6_SUBTREES: u32 = 1;
pub const CONFIG_SENSORS_ADT7310_MODULE: u32 = 1;
pub const CONFIG_INTEL_TH_PCI_MODULE: u32 = 1;
pub const CONFIG_HID_EMS_FF_MODULE: u32 = 1;
pub const CONFIG_SPEAKUP_MODULE: u32 = 1;
pub const CONFIG_MICROSEMI_PHY_MODULE: u32 = 1;
pub const CONFIG_HID_SENSOR_IIO_TRIGGER_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV2659_MODULE: u32 = 1;
pub const CONFIG_X86_REQUIRED_FEATURE_CPUID: u32 = 1;
pub const CONFIG_DELL_SMBIOS_MODULE: u32 = 1;
pub const CONFIG_BTRFS_FS_POSIX_ACL: u32 = 1;
pub const CONFIG_HID_UDRAW_PS3_MODULE: u32 = 1;
pub const CONFIG_HID_APPLE_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_DIGITV_MODULE: u32 = 1;
pub const CONFIG_AC97_BUS_MODULE: u32 = 1;
pub const CONFIG_VMWARE_BALLOON_MODULE: u32 = 1;
pub const CONFIG_STK3310_MODULE: u32 = 1;
pub const CONFIG_VIDEO_SAA7134_ALSA_MODULE: u32 = 1;
pub const CONFIG_USB_BELKIN: u32 = 1;
pub const CONFIG_DRM_RADEON_USERPTR: u32 = 1;
pub const CONFIG_INTEL_IOATDMA_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT5682S_MODULE: u32 = 1;
pub const CONFIG_XIAOMI_WMI_MODULE: u32 = 1;
pub const CONFIG_RCU_STALL_COMMON: u32 = 1;
pub const CONFIG_USB_UEAGLEATM_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_ZONED: u32 = 1;
pub const CONFIG_REGULATOR_LP872X_MODULE: u32 = 1;
pub const CONFIG_SATA_ZPODD: u32 = 1;
pub const CONFIG_RT2X00_LIB_MODULE: u32 = 1;
pub const CONFIG_HAVE_ASM_MODVERSIONS: u32 = 1;
pub const CONFIG_DVB_STB6100_MODULE: u32 = 1;
pub const CONFIG_HID_SENSOR_IIO_COMMON_MODULE: u32 = 1;
pub const CONFIG_RAS_FMPM_MODULE: u32 = 1;
pub const CONFIG_TCP_CONG_CDG_MODULE: u32 = 1;
pub const CONFIG_AD7405_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_ADDR_TRANS: u32 = 1;
pub const CONFIG_APDS9960_MODULE: u32 = 1;
pub const CONFIG_NFS_DEBUG: u32 = 1;
pub const CONFIG_XEN_PVH: u32 = 1;
pub const CONFIG_NET_FC: u32 = 1;
pub const CONFIG_BT_HCIRSI_MODULE: u32 = 1;
pub const CONFIG_DYNAMIC_PHYSICAL_MASK: u32 = 1;
pub const CONFIG_MFD_TPS65912_I2C_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WCD934X_MODULE: u32 = 1;
pub const CONFIG_TINYDRM_ILI9486_MODULE: u32 = 1;
pub const CONFIG_KS8851_MODULE: u32 = 1;
pub const CONFIG_SCSI_LOGGING: u32 = 1;
pub const CONFIG_HAVE_PERF_EVENTS: u32 = 1;
pub const CONFIG_TI_ADC084S021_MODULE: u32 = 1;
pub const CONFIG_RFKILL_LEDS: u32 = 1;
pub const CONFIG_AD7476_MODULE: u32 = 1;
pub const CONFIG_DRM_FBDEV_OVERALLOC: u32 = 100;
pub const CONFIG_SECRETMEM: u32 = 1;
pub const CONFIG_MSA311_MODULE: u32 = 1;
pub const CONFIG_MFD_88PM805_MODULE: u32 = 1;
pub const CONFIG_IO_STRICT_DEVMEM: u32 = 1;
pub const CONFIG_VIDEO_OV2685_MODULE: u32 = 1;
pub const CONFIG_IIO_SSP_SENSORS_COMMONS_MODULE: u32 = 1;
pub const CONFIG_DM_VERITY_MODULE: u32 = 1;
pub const CONFIG_NFT_NUMGEN_MODULE: u32 = 1;
pub const CONFIG_ATM_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_TPS68470_MODULE: u32 = 1;
pub const CONFIG_BACKLIGHT_88PM860X_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_MQPRIO_MODULE: u32 = 1;
pub const CONFIG_SENSORS_APDS990X_MODULE: u32 = 1;
pub const CONFIG_RUSTC_HAS_SPAN_FILE: u32 = 1;
pub const CONFIG_AIC7XXX_DEBUG_MASK: u32 = 0;
pub const CONFIG_W1_SLAVE_DS2423_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_U32_MODULE: u32 = 1;
pub const CONFIG_DVB_DM1105_MODULE: u32 = 1;
pub const CONFIG_SCSI_SYM53C8XX_MMIO: u32 = 1;
pub const CONFIG_IPW2100_MODULE: u32 = 1;
pub const CONFIG_GPIB_PCMCIA: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_855_MODULE: u32 = 1;
pub const CONFIG_USB_DWC2_DUAL_ROLE: u32 = 1;
pub const CONFIG_I2C_OCORES_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DS1511_MODULE: u32 = 1;
pub const CONFIG_MEDIATEK_MT6359_AUXADC_MODULE: u32 = 1;
pub const CONFIG_NGBE_MODULE: u32 = 1;
pub const CONFIG_X86_L1_CACHE_SHIFT: u32 = 6;
pub const CONFIG_IP6_NF_TARGET_HL_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_MAX98373_MODULE: u32 = 1;
pub const CONFIG_NFC_VIRTUAL_NCI_MODULE: u32 = 1;
pub const CONFIG_HUGETLB_PMD_PAGE_TABLE_SHARING: u32 = 1;
pub const CONFIG_REGULATOR_MC13892_MODULE: u32 = 1;
pub const CONFIG_BMI270_I2C_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MP2856_MODULE: u32 = 1;
pub const CONFIG_NET_KEY_MIGRATE: u32 = 1;
pub const CONFIG_APDS9160_MODULE: u32 = 1;
pub const CONFIG_SND_INDIGODJX_MODULE: u32 = 1;
pub const CONFIG_USB_STORAGE_KARMA_MODULE: u32 = 1;
pub const CONFIG_VIDEO_AK7375_MODULE: u32 = 1;
pub const CONFIG_HID_MAYFLASH_MODULE: u32 = 1;
pub const CONFIG_B43LEGACY_PCI_AUTOSELECT: u32 = 1;
pub const CONFIG_MEMSTICK_JMICRON_38X_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_QT1010_MODULE: u32 = 1;
pub const CONFIG_ATH9K_DYNACK: u32 = 1;
pub const CONFIG_INTEL_PMC_CORE_MODULE: u32 = 1;
pub const CONFIG_BONDING_MODULE: u32 = 1;
pub const CONFIG_SND_ISIGHT_MODULE: u32 = 1;
pub const CONFIG_PCIE_TPH: u32 = 1;
pub const CONFIG_LTO_NONE: u32 = 1;
pub const CONFIG_LEDS_QNAP_MCU_MODULE: u32 = 1;
pub const CONFIG_DELL_SMBIOS_WMI: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_HDMI_NVIDIA_MODULE: u32 = 1;
pub const CONFIG_SURFACE_DTX_MODULE: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_862_MODULE: u32 = 1;
pub const CONFIG_GPIO_WS16C48_MODULE: u32 = 1;
pub const CONFIG_TYPEC_MUX_IT5205_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_PCI1XXXX_MODULE: u32 = 1;
pub const CONFIG_TULIP_MWI: u32 = 1;
pub const CONFIG_HAVE_DMA_CONTIGUOUS: u32 = 1;
pub const CONFIG_KEYBOARD_SAMSUNG_MODULE: u32 = 1;
pub const CONFIG_DVB_ISL6405_MODULE: u32 = 1;
pub const CONFIG_ADIS16136_MODULE: u32 = 1;
pub const CONFIG_IR_WINBOND_CIR_MODULE: u32 = 1;
pub const CONFIG_CM3323_MODULE: u32 = 1;
pub const CONFIG_RTW88_8723DS_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ADT7475_MODULE: u32 = 1;
pub const CONFIG_ARCH_PROC_KCORE_TEXT: u32 = 1;
pub const CONFIG_SENSORS_MP2993_MODULE: u32 = 1;
pub const CONFIG_CAN_NETLINK: u32 = 1;
pub const CONFIG_JFFS2_FS_XATTR: u32 = 1;
pub const CONFIG_KEYBOARD_MATRIX_MODULE: u32 = 1;
pub const CONFIG_BACKLIGHT_CLASS_DEVICE: u32 = 1;
pub const CONFIG_CFG80211_DEBUGFS: u32 = 1;
pub const CONFIG_NF_TABLES_MODULE: u32 = 1;
pub const CONFIG_SERIAL_FSL_LINFLEXUART_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_MANAGER: u32 = 1;
pub const CONFIG_EPROBE_EVENTS: u32 = 1;
pub const CONFIG_ADXL367_SPI_MODULE: u32 = 1;
pub const CONFIG_USB_F_EEM_MODULE: u32 = 1;
pub const CONFIG_HIBERNATION_COMP_LZO: u32 = 1;
pub const CONFIG_SENSORS_PCF8591_MODULE: u32 = 1;
pub const CONFIG_SUSPEND_FREEZER: u32 = 1;
pub const CONFIG_NET_VENDOR_MARVELL: u32 = 1;
pub const CONFIG_CAN_ISOTP_MODULE: u32 = 1;
pub const CONFIG_RTW89_CORE_MODULE: u32 = 1;
pub const CONFIG_SCSI_DC395x_MODULE: u32 = 1;
pub const CONFIG_CPU_SUP_HYGON: u32 = 1;
pub const CONFIG_DVB_NET: u32 = 1;
pub const CONFIG_SSB_MODULE: u32 = 1;
pub const CONFIG_ADXRS450_MODULE: u32 = 1;
pub const CONFIG_W83877F_WDT_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_LIB_POLY1305_GENERIC: u32 = 1;
pub const CONFIG_DECOMPRESS_LZO: u32 = 1;
pub const CONFIG_SND_SOC_SOF_ACPI_DEV_MODULE: u32 = 1;
pub const CONFIG_QRTR_MHI_MODULE: u32 = 1;
pub const CONFIG_NLS_ISO8859_15_MODULE: u32 = 1;
pub const CONFIG_LEDS_PWM_MULTICOLOR_MODULE: u32 = 1;
pub const CONFIG_BACKLIGHT_QCOM_WLED_MODULE: u32 = 1;
pub const CONFIG_MEDIA_CAMERA_SUPPORT: u32 = 1;
pub const CONFIG_IWLWIFI_DEVICE_TRACING: u32 = 1;
pub const CONFIG_BACKLIGHT_SAHARA_MODULE: u32 = 1;
pub const CONFIG_RFKILL_GPIO_MODULE: u32 = 1;
pub const CONFIG_UNACCEPTED_MEMORY: u32 = 1;
pub const CONFIG_NET_DSA_SMSC_LAN9303_I2C_MODULE: u32 = 1;
pub const CONFIG_TYPEC_MUX_TUSB1046_MODULE: u32 = 1;
pub const CONFIG_NTB_NETDEV_MODULE: u32 = 1;
pub const CONFIG_SND_SEQ_UMP: u32 = 1;
pub const CONFIG_VIDEO_VIVID_CEC: u32 = 1;
pub const CONFIG_NET_SCH_PLUG_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_TAG_SJA1105_MODULE: u32 = 1;
pub const CONFIG_DEV_DAX_CXL_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_CLUSTER_MODULE: u32 = 1;
pub const CONFIG_VIDEO_SAA6752HS_MODULE: u32 = 1;
pub const CONFIG_PPP_MULTILINK: u32 = 1;
pub const CONFIG_QCOM_QMI_HELPERS_MODULE: u32 = 1;
pub const CONFIG_LZ4_DECOMPRESS: u32 = 1;
pub const CONFIG_USB_SERIAL_IR_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_CA0132_MODULE: u32 = 1;
pub const CONFIG_IP_VS_PROTO_ESP: u32 = 1;
pub const CONFIG_SND_SOC_CS35L45_MODULE: u32 = 1;
pub const CONFIG_SCSI_CHELSIO_FCOE_MODULE: u32 = 1;
pub const CONFIG_VIDEO_VD55G1_MODULE: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_SCHED_SMT: u32 = 1;
pub const CONFIG_QUOTA_NETLINK_INTERFACE: u32 = 1;
pub const CONFIG_USB_EMI62_MODULE: u32 = 1;
pub const CONFIG_NFT_DUP_NETDEV_MODULE: u32 = 1;
pub const CONFIG_PM_TRACE: u32 = 1;
pub const CONFIG_SENSORS_XGENE_MODULE: u32 = 1;
pub const CONFIG_MPRLS0025PA_I2C_MODULE: u32 = 1;
pub const CONFIG_SCSI_SAS_HOST_SMP: u32 = 1;
pub const CONFIG_IIO_ST_SENSORS_CORE_MODULE: u32 = 1;
pub const CONFIG_IP6_NF_NAT_MODULE: u32 = 1;
pub const CONFIG_RTC_MC146818_LIB: u32 = 1;
pub const CONFIG_RD_LZO: u32 = 1;
pub const CONFIG_RTW89_8852C_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_AQUANTIA: u32 = 1;
pub const CONFIG_HID_LENOVO_MODULE: u32 = 1;
pub const CONFIG_CEPH_FS_MODULE: u32 = 1;
pub const CONFIG_OVPN_MODULE: u32 = 1;
pub const CONFIG_RUSTC_HAS_UNNECESSARY_TRANSMUTES: u32 = 1;
pub const CONFIG_SND_SOC_ES8375_MODULE: u32 = 1;
pub const CONFIG_SENSORS_K8TEMP_MODULE: u32 = 1;
pub const CONFIG_ZL3073X_I2C_MODULE: u32 = 1;
pub const CONFIG_ATA_SFF: u32 = 1;
pub const CONFIG_INPUT_MOUSEDEV_SCREEN_X: u32 = 1024;
pub const CONFIG_INPUT_MAX7360_ROTARY_MODULE: u32 = 1;
pub const CONFIG_USB_RAREMONO_MODULE: u32 = 1;
pub const CONFIG_PINCTRL: u32 = 1;
pub const CONFIG_NET_DSA_VITESSE_VSC73XX_SPI_MODULE: u32 = 1;
pub const CONFIG_SENSORS_PIM4328_MODULE: u32 = 1;
pub const CONFIG_STP_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MAX8649_MODULE: u32 = 1;
pub const CONFIG_ATH9K_PCI_NO_EEPROM_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_SPACEORB_MODULE: u32 = 1;
pub const CONFIG_NFC_NXP_NCI_MODULE: u32 = 1;
pub const CONFIG_TCM_QLA2XXX_MODULE: u32 = 1;
pub const CONFIG_ATH12K_DEBUGFS: u32 = 1;
pub const CONFIG_SENSORS_HTU31_MODULE: u32 = 1;
pub const CONFIG_MCP320X_MODULE: u32 = 1;
pub const CONFIG_JME_MODULE: u32 = 1;
pub const CONFIG_XEN_ACPI_PROCESSOR_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_VISOR_MODULE: u32 = 1;
pub const CONFIG_MTD_SPI_NOR_USE_4K_SECTORS: u32 = 1;
pub const CONFIG_BE2NET_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_RED_MODULE: u32 = 1;
pub const CONFIG_DAMON_VADDR: u32 = 1;
pub const CONFIG_DVB_VES1X93_MODULE: u32 = 1;
pub const CONFIG_VIDEO_MT9V011_MODULE: u32 = 1;
pub const CONFIG_VIDEO_TVEEPROM_MODULE: u32 = 1;
pub const CONFIG_TI_ADS8688_MODULE: u32 = 1;
pub const CONFIG_NF_TPROXY_IPV6_MODULE: u32 = 1;
pub const CONFIG_MOST_USB_HDM_MODULE: u32 = 1;
pub const CONFIG_DEBUG_BOOT_PARAMS: u32 = 1;
pub const CONFIG_MFD_NCT6694_MODULE: u32 = 1;
pub const CONFIG_STAGING: u32 = 1;
pub const CONFIG_ACPI_LPIT: u32 = 1;
pub const CONFIG_SENSORS_CROS_EC_MODULE: u32 = 1;
pub const CONFIG_SCSI_DH_HP_SW_MODULE: u32 = 1;
pub const CONFIG_MCP3564_MODULE: u32 = 1;
pub const CONFIG_MISC_RTSX_MODULE: u32 = 1;
pub const CONFIG_MEDIA_CONTROLLER: u32 = 1;
pub const CONFIG_EFI_RCI2_TABLE: u32 = 1;
pub const CONFIG_RTC_DRV_EM3027_MODULE: u32 = 1;
pub const CONFIG_USB_SUPPORT: u32 = 1;
pub const CONFIG_WLCORE_SDIO_MODULE: u32 = 1;
pub const CONFIG_DVB_MXL5XX_MODULE: u32 = 1;
pub const CONFIG_TCG_TIS_CORE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_HYNITRON_CST816X_MODULE: u32 = 1;
pub const CONFIG_IP_VS_LBLC_MODULE: u32 = 1;
pub const CONFIG_ACPI_PROCESSOR_IDLE: u32 = 1;
pub const CONFIG_CRYPTO_JITTERENTROPY: u32 = 1;
pub const CONFIG_PREVENT_FIRMWARE_BUILD: u32 = 1;
pub const CONFIG_W1_MASTER_UART_MODULE: u32 = 1;
pub const CONFIG_PATA_VIA_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ATXP1_MODULE: u32 = 1;
pub const CONFIG_HW_RANDOM_VIRTIO_MODULE: u32 = 1;
pub const CONFIG_FXOS8700_SPI_MODULE: u32 = 1;
pub const CONFIG_MEGARAID_SAS_MODULE: u32 = 1;
pub const CONFIG_CHARGER_LP8788_MODULE: u32 = 1;
pub const CONFIG_DRM_XE_PREEMPT_TIMEOUT_MAX: u32 = 10000000;
pub const CONFIG_TOUCHSCREEN_EGALAX_SERIAL_MODULE: u32 = 1;
pub const CONFIG_IP_VS_TAB_BITS: u32 = 15;
pub const CONFIG_PWM_PCA9685_MODULE: u32 = 1;
pub const CONFIG_NFC_TRF7970A_MODULE: u32 = 1;
pub const CONFIG_USB_CONFIGFS_SERIAL: u32 = 1;
pub const CONFIG_MFD_MAX77705_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_LEGACY_MACH_MODULE: u32 = 1;
pub const CONFIG_SENSORS_FSP_3Y_MODULE: u32 = 1;
pub const CONFIG_PSTORE_COMPRESS: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_BYTCR_WM5102_MACH_MODULE: u32 = 1;
pub const CONFIG_DM_ZERO_MODULE: u32 = 1;
pub const CONFIG_XILINX_AXI_EMAC_MODULE: u32 = 1;
pub const CONFIG_RTW88_8814AU_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_CPU_RELAX: u32 = 1;
pub const CONFIG_I2C_GPIO_MODULE: u32 = 1;
pub const CONFIG_IP_SET_HASH_NETNET_MODULE: u32 = 1;
pub const CONFIG_KS8851_MLL_MODULE: u32 = 1;
pub const CONFIG_FW_LOADER_COMPRESS_ZSTD: u32 = 1;
pub const CONFIG_SND_FIREWIRE_TASCAM_MODULE: u32 = 1;
pub const CONFIG_ACPI_MADT_WAKEUP: u32 = 1;
pub const CONFIG_IR_REDRAT3_MODULE: u32 = 1;
pub const CONFIG_IEEE802154_HWSIM_MODULE: u32 = 1;
pub const CONFIG_NFT_LIMIT_MODULE: u32 = 1;
pub const CONFIG_IPV6_TUNNEL_MODULE: u32 = 1;
pub const CONFIG_XZ_DEC_ARMTHUMB: u32 = 1;
pub const CONFIG_BT_HCIUART_SERDEV: u32 = 1;
pub const CONFIG_INTEL_GTT_MODULE: u32 = 1;
pub const CONFIG_RMI4_F21: u32 = 1;
pub const CONFIG_ZONE_DMA32: u32 = 1;
pub const CONFIG_CC_HAS_KASAN_GENERIC: u32 = 1;
pub const CONFIG_NET_FAILOVER_MODULE: u32 = 1;
pub const CONFIG_MLXSW_SPECTRUM_DCB: u32 = 1;
pub const CONFIG_X86_IOPL_IOPERM: u32 = 1;
pub const CONFIG_KEXEC_FILE: u32 = 1;
pub const CONFIG_B43_PIO: u32 = 1;
pub const CONFIG_SENSORS_ADM1031_MODULE: u32 = 1;
pub const CONFIG_PRINTK_TIME: u32 = 1;
pub const CONFIG_SND_SOC_RT286_MODULE: u32 = 1;
pub const CONFIG_SPI_INTEL_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_DAMON_SYSFS: u32 = 1;
pub const CONFIG_TSL2772_MODULE: u32 = 1;
pub const CONFIG_TIFM_7XX1_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MAX77693_MODULE: u32 = 1;
pub const CONFIG_PING_MODULE: u32 = 1;
pub const CONFIG_HOLTEK_FF: u32 = 1;
pub const CONFIG_SOUNDWIRE_GENERIC_ALLOCATION_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS35L34_MODULE: u32 = 1;
pub const CONFIG_AMD_MP2_STB: u32 = 1;
pub const CONFIG_I2C_CROS_EC_TUNNEL_MODULE: u32 = 1;
pub const CONFIG_BOSCH_BNO055_MODULE: u32 = 1;
pub const CONFIG_INPUT_RETU_PWRBUTTON_MODULE: u32 = 1;
pub const CONFIG_GREENASIA_FF: u32 = 1;
pub const CONFIG_FSCACHE_STATS: u32 = 1;
pub const CONFIG_APPLE_MFI_FASTCHARGE_MODULE: u32 = 1;
pub const CONFIG_ACPI_CPPC_LIB: u32 = 1;
pub const CONFIG_STMMAC_PCI_MODULE: u32 = 1;
pub const CONFIG_DMI_SYSFS: u32 = 1;
pub const CONFIG_ZLIB_INFLATE: u32 = 1;
pub const CONFIG_ARCH_WANTS_THP_SWAP: u32 = 1;
pub const CONFIG_MISDN_SPEEDFAX_MODULE: u32 = 1;
pub const CONFIG_MMA7455_SPI_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_TPS6586X_MODULE: u32 = 1;
pub const CONFIG_FPROBE_EVENTS: u32 = 1;
pub const CONFIG_HID_BIGBEN_FF_MODULE: u32 = 1;
pub const CONFIG_HID_BETOP_FF_MODULE: u32 = 1;
pub const CONFIG_IPW2200_RADIOTAP: u32 = 1;
pub const CONFIG_SENSORS_AHT10_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_AMD_TOPLEVEL_MODULE: u32 = 1;
pub const CONFIG_W1_MASTER_DS2482_MODULE: u32 = 1;
pub const CONFIG_MTD_UBI_MODULE: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_863_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_RP5C01_MODULE: u32 = 1;
pub const CONFIG_OVMF_DEBUG_LOG: u32 = 1;
pub const CONFIG_BLK_DEV_RAM_MODULE: u32 = 1;
pub const CONFIG_VGA_ARB: u32 = 1;
pub const CONFIG_CRYPTO_LIB_CURVE25519_MODULE: u32 = 1;
pub const CONFIG_SND_FIREWIRE: u32 = 1;
pub const CONFIG_LOGIRUMBLEPAD2_FF: u32 = 1;
pub const CONFIG_PERF_EVENTS_AMD_UNCORE_MODULE: u32 = 1;
pub const CONFIG_DP83TG720_PHY_MODULE: u32 = 1;
pub const CONFIG_ATL1C_MODULE: u32 = 1;
pub const CONFIG_APDS9802ALS_MODULE: u32 = 1;
pub const CONFIG_TCG_XEN_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_CZ_DA7219MX98357_MACH_MODULE: u32 = 1;
pub const CONFIG_EXTCON_MAX14526_MODULE: u32 = 1;
pub const CONFIG_DE2104X_MODULE: u32 = 1;
pub const CONFIG_GPIO_ADP5520_MODULE: u32 = 1;
pub const CONFIG_MFD_KEMPLD_MODULE: u32 = 1;
pub const CONFIG_USB_EPSON2888: u32 = 1;
pub const CONFIG_ARCH_USE_MEMTEST: u32 = 1;
pub const CONFIG_HID_GENERIC: u32 = 1;
pub const CONFIG_ACPI_PFRUT_MODULE: u32 = 1;
pub const CONFIG_USB_PHY: u32 = 1;
pub const CONFIG_DEBUG_INFO_BTF: u32 = 1;
pub const CONFIG_TABLET_USB_AIPTEK_MODULE: u32 = 1;
pub const CONFIG_PMIC_OPREGION: u32 = 1;
pub const CONFIG_CAN_RAW_MODULE: u32 = 1;
pub const CONFIG_INTEL_IOMMU_SVM: u32 = 1;
pub const CONFIG_VIDEO_OV5675_MODULE: u32 = 1;
pub const CONFIG_TI_ADC108S102_MODULE: u32 = 1;
pub const CONFIG_QCA808X_PHY_MODULE: u32 = 1;
pub const CONFIG_CRC_OPTIMIZATIONS: u32 = 1;
pub const CONFIG_SND_HDA_SCODEC_CS35L41_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_XRS700X_MODULE: u32 = 1;
pub const CONFIG_X86_MCE_AMD: u32 = 1;
pub const CONFIG_MAX5487_MODULE: u32 = 1;
pub const CONFIG_DS4424_MODULE: u32 = 1;
pub const CONFIG_APERTURE_HELPERS: u32 = 1;
pub const CONFIG_UNICODE: u32 = 1;
pub const CONFIG_GAMEPORT_MODULE: u32 = 1;
pub const CONFIG_RMI4_I2C_MODULE: u32 = 1;
pub const CONFIG_DM_LOG_WRITES_MODULE: u32 = 1;
pub const CONFIG_B44_PCI: u32 = 1;
pub const CONFIG_VIDEO_GS1662_MODULE: u32 = 1;
pub const CONFIG_USB_SIERRA_NET_MODULE: u32 = 1;
pub const CONFIG_TINYDRM_ILI9225_MODULE: u32 = 1;
pub const CONFIG_IBM_ASM_MODULE: u32 = 1;
pub const CONFIG_SPI_BITBANG_MODULE: u32 = 1;
pub const CONFIG_SWPHY: u32 = 1;
pub const CONFIG_SND_SOC_RT712_SDCA_DMIC_SDW_MODULE: u32 = 1;
pub const CONFIG_CGROUP_CPUACCT: u32 = 1;
pub const CONFIG_SENSORS_ADM1275_MODULE: u32 = 1;
pub const CONFIG_SND_I2S_HI6210_I2S_MODULE: u32 = 1;
pub const CONFIG_MODULE_ALLOW_MISSING_NAMESPACE_IMPORTS: u32 = 1;
pub const CONFIG_VIDEO_SAA717X_MODULE: u32 = 1;
pub const CONFIG_MEMSTICK_REALTEK_USB_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_COMPONENT: u32 = 1;
pub const CONFIG_NETFILTER_NETLINK_HOOK_MODULE: u32 = 1;
pub const CONFIG_EFI_SECRET_MODULE: u32 = 1;
pub const CONFIG_SPI_DW_PCI_MODULE: u32 = 1;
pub const CONFIG_NFC_PN544_MEI_MODULE: u32 = 1;
pub const CONFIG_BMI323_MODULE: u32 = 1;
pub const CONFIG_PA12203001_MODULE: u32 = 1;
pub const CONFIG_USB_STORAGE_CYPRESS_ATACB_MODULE: u32 = 1;
pub const CONFIG_SIS900_MODULE: u32 = 1;
pub const CONFIG_PATA_WINBOND_MODULE: u32 = 1;
pub const CONFIG_DRM_SCHED_MODULE: u32 = 1;
pub const CONFIG_HSA_AMD_SVM: u32 = 1;
pub const CONFIG_REGULATOR_RT6190_MODULE: u32 = 1;
pub const CONFIG_DRM_PANEL_BRIDGE: u32 = 1;
pub const CONFIG_DVB_USB_GL861_MODULE: u32 = 1;
pub const CONFIG_IONIC_MODULE: u32 = 1;
pub const CONFIG_IP_VS_WLC_MODULE: u32 = 1;
pub const CONFIG_SERIAL_IPOCTAL_MODULE: u32 = 1;
pub const CONFIG_NET_POLL_CONTROLLER: u32 = 1;
pub const CONFIG_DW_DMAC_CORE: u32 = 1;
pub const CONFIG_JOYSTICK_ANALOG_MODULE: u32 = 1;
pub const CONFIG_CAN_JANZ_ICAN3_MODULE: u32 = 1;
pub const CONFIG_ACPI_EC_DEBUGFS_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_MTHCA_DEBUG: u32 = 1;
pub const CONFIG_HID_XIAOMI_MODULE: u32 = 1;
pub const CONFIG_FIREWIRE_OHCI_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_EDT_FT5X06_MODULE: u32 = 1;
pub const CONFIG_FS_DAX: u32 = 1;
pub const CONFIG_PWM_MAX7360_MODULE: u32 = 1;
pub const CONFIG_INPUT_MAX8925_ONKEY_MODULE: u32 = 1;
pub const CONFIG_RTW89_8852B_MODULE: u32 = 1;
pub const CONFIG_BT_HCIUART_3WIRE: u32 = 1;
pub const CONFIG_DIMLIB: u32 = 1;
pub const CONFIG_TWL4030_MADC_MODULE: u32 = 1;
pub const CONFIG_MMC_SDHCI_ACPI_MODULE: u32 = 1;
pub const CONFIG_6LOWPAN_GHC_ICMPV6_MODULE: u32 = 1;
pub const CONFIG_HAVE_KVM_READONLY_MEM: u32 = 1;
pub const CONFIG_GPIO_MB86S7X_MODULE: u32 = 1;
pub const CONFIG_INPUT_MOUSEDEV_SCREEN_Y: u32 = 768;
pub const CONFIG_MEMCG: u32 = 1;
pub const CONFIG_DRM_DISPLAY_DP_AUX_CHARDEV: u32 = 1;
pub const CONFIG_MD_LLBITMAP: u32 = 1;
pub const CONFIG_COMMON_CLK_SI5341_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_CANNONLAKE_MODULE: u32 = 1;
pub const CONFIG_GOOGLE_FRAMEBUFFER_COREBOOT_MODULE: u32 = 1;
pub const CONFIG_SENSORS_SPD5118_MODULE: u32 = 1;
pub const CONFIG_BH1750_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_LIB_CHACHA20POLY1305: u32 = 1;
pub const CONFIG_ZSTD_COMPRESS: u32 = 1;
pub const CONFIG_MAILBOX: u32 = 1;
pub const CONFIG_SPARSE_IRQ: u32 = 1;
pub const CONFIG_ADV_SWBUTTON_MODULE: u32 = 1;
pub const CONFIG_SENSORS_TSL2563_MODULE: u32 = 1;
pub const CONFIG_NEED_SG_DMA_LENGTH: u32 = 1;
pub const CONFIG_VHOST_TASK: u32 = 1;
pub const CONFIG_IPV6_SEG6_BPF: u32 = 1;
pub const CONFIG_BT_DEBUGFS: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_CHT_BSW_RT5672_MACH_MODULE: u32 = 1;
pub const CONFIG_KMX61_MODULE: u32 = 1;
pub const CONFIG_DVB_TUNER_DIB0070_MODULE: u32 = 1;
pub const CONFIG_AMD_AE4DMA_MODULE: u32 = 1;
pub const CONFIG_SUSPEND: u32 = 1;
pub const CONFIG_GPIO_MC33880_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_WM831X_MODULE: u32 = 1;
pub const CONFIG_GENERIC_ADC_BATTERY_MODULE: u32 = 1;
pub const CONFIG_I2C_DESIGNWARE_AMDISP_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_F8153X_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TSCS42XX_MODULE: u32 = 1;
pub const CONFIG_SND_USB_AUDIO_MIDI_V2: u32 = 1;
pub const CONFIG_SENSORS_GIGABYTE_WATERFORCE_MODULE: u32 = 1;
pub const CONFIG_MTD_PARTITIONED_MASTER: u32 = 1;
pub const CONFIG_SAMSUNG_LAPTOP_MODULE: u32 = 1;
pub const CONFIG_GRACE_PERIOD_MODULE: u32 = 1;
pub const CONFIG_HYPERV_VMBUS_MODULE: u32 = 1;
pub const CONFIG_ATH6KL_DEBUG: u32 = 1;
pub const CONFIG_NF_FLOW_TABLE_PROCFS: u32 = 1;
pub const CONFIG_SOC_TI: u32 = 1;
pub const CONFIG_MHI_BUS_EP_MODULE: u32 = 1;
pub const CONFIG_RTL8192DE_MODULE: u32 = 1;
pub const CONFIG_NFC_PN532_UART_MODULE: u32 = 1;
pub const CONFIG_CRC_T10DIF_ARCH: u32 = 1;
pub const CONFIG_HAVE_FUNCTION_ARG_ACCESS_API: u32 = 1;
pub const CONFIG_SUNGEM_PHY_MODULE: u32 = 1;
pub const CONFIG_MFD_CS42L43_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ES8316_MODULE: u32 = 1;
pub const CONFIG_ENVELOPE_DETECTOR_MODULE: u32 = 1;
pub const CONFIG_RT2800_LIB_MODULE: u32 = 1;
pub const CONFIG_CC_IMPLICIT_FALLTHROUGH: &[u8; 25] = b"-Wimplicit-fallthrough=5\0";
pub const CONFIG_FB_DMAMEM_HELPERS: u32 = 1;
pub const CONFIG_IP_MULTIPLE_TABLES: u32 = 1;
pub const CONFIG_MFD_WM831X_I2C: u32 = 1;
pub const CONFIG_MADERA_IRQ_MODULE: u32 = 1;
pub const CONFIG_USB_F_RNDIS_MODULE: u32 = 1;
pub const CONFIG_RT2X00_LIB_CRYPTO: u32 = 1;
pub const CONFIG_TMP117_MODULE: u32 = 1;
pub const CONFIG_PPP_FILTER: u32 = 1;
pub const CONFIG_PINCTRL_CS47L92: u32 = 1;
pub const CONFIG_PTP_1588_CLOCK_VMCLOCK_MODULE: u32 = 1;
pub const CONFIG_COMMON_CLK_WM831X_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_CCP_DEBUGFS: u32 = 1;
pub const CONFIG_VDPA_SIM_BLOCK_MODULE: u32 = 1;
pub const CONFIG_GPIO_PCA953X_IRQ: u32 = 1;
pub const CONFIG_NET_DSA_TAG_OCELOT_8021Q_MODULE: u32 = 1;
pub const CONFIG_USB_F_PRINTER_MODULE: u32 = 1;
pub const CONFIG_MFD_BCM590XX_MODULE: u32 = 1;
pub const CONFIG_WLAN_VENDOR_RALINK: u32 = 1;
pub const CONFIG_IR_MCE_KBD_DECODER_MODULE: u32 = 1;
pub const CONFIG_EDAC_MEM_REPAIR: u32 = 1;
pub const CONFIG_X86_INTEL_LPSS: u32 = 1;
pub const CONFIG_RATIONAL: u32 = 1;
pub const CONFIG_SENSORS_LM25066_REGULATOR: u32 = 1;
pub const CONFIG_INPUT_GPIO_BEEPER_MODULE: u32 = 1;
pub const CONFIG_MISDN_W6692_MODULE: u32 = 1;
pub const CONFIG_NF_CONNTRACK_MODULE: u32 = 1;
pub const CONFIG_SIEMENS_SIMATIC_IPC_BATT_MODULE: u32 = 1;
pub const CONFIG_GPIO_LP3943_MODULE: u32 = 1;
pub const CONFIG_WILCO_EC_DEBUGFS_MODULE: u32 = 1;
pub const CONFIG_EXTCON_ADC_JACK_MODULE: u32 = 1;
pub const CONFIG_MFD_DA9052_I2C: u32 = 1;
pub const CONFIG_W1_SLAVE_DS2438_MODULE: u32 = 1;
pub const CONFIG_MEMORY_HOTPLUG: u32 = 1;
pub const CONFIG_CRC64: u32 = 1;
pub const CONFIG_TRUSTED_KEYS_TPM: u32 = 1;
pub const CONFIG_MS5611_SPI_MODULE: u32 = 1;
pub const CONFIG_GPIO_ML_IOH_MODULE: u32 = 1;
pub const CONFIG_MS5611_MODULE: u32 = 1;
pub const CONFIG_PSE_CONTROLLER: u32 = 1;
pub const CONFIG_KEY_DH_OPERATIONS: u32 = 1;
pub const CONFIG_HID_GYRATION_MODULE: u32 = 1;
pub const CONFIG_NTSYNC: u32 = 1;
pub const CONFIG_ARCH_WANT_GENERAL_HUGETLB: u32 = 1;
pub const CONFIG_USB_U_ETHER_MODULE: u32 = 1;
pub const CONFIG_VIDEO_TW2804_MODULE: u32 = 1;
pub const CONFIG_ZONE_DMA: u32 = 1;
pub const CONFIG_GNSS_SERIAL_MODULE: u32 = 1;
pub const CONFIG_SND_USB_LINE6_MODULE: u32 = 1;
pub const CONFIG_CHARGER_TWL6030_MODULE: u32 = 1;
pub const CONFIG_TLS_DEVICE: u32 = 1;
pub const CONFIG_DVB_USB_TTUSB2_MODULE: u32 = 1;
pub const CONFIG_WIL6210_ISR_COR: u32 = 1;
pub const CONFIG_SND_MAX_CARDS: u32 = 32;
pub const CONFIG_REGULATOR_DA9055_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_PMEM_API: u32 = 1;
pub const CONFIG_YAMAHA_YAS530_MODULE: u32 = 1;
pub const CONFIG_CLOCKSOURCE_WATCHDOG: u32 = 1;
pub const CONFIG_IIO_MUX_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AK4104_MODULE: u32 = 1;
pub const CONFIG_RESCTRL_FS: u32 = 1;
pub const CONFIG_ARCH_MIGHT_HAVE_PC_PARPORT: u32 = 1;
pub const CONFIG_RD_GZIP: u32 = 1;
pub const CONFIG_SENSORS_I5500_MODULE: u32 = 1;
pub const CONFIG_AMD_XGBE_MODULE: u32 = 1;
pub const CONFIG_NVME_TARGET_DEBUGFS: u32 = 1;
pub const CONFIG_INPUT_DRV2667_HAPTICS_MODULE: u32 = 1;
pub const CONFIG_FB_DEFERRED_IO: u32 = 1;
pub const CONFIG_LIBWX_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS35L35_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_NETEM_MODULE: u32 = 1;
pub const CONFIG_IP_NF_MATCH_RPFILTER_MODULE: u32 = 1;
pub const CONFIG_MSDOS_PARTITION: u32 = 1;
pub const CONFIG_B43_SDIO: u32 = 1;
pub const CONFIG_PCC: u32 = 1;
pub const CONFIG_SYNTH_EVENTS: u32 = 1;
pub const CONFIG_DVB_USB_DTV5100_MODULE: u32 = 1;
pub const CONFIG_POWER_SUPPLY_HWMON: u32 = 1;
pub const CONFIG_NETFILTER_NETLINK_LOG_MODULE: u32 = 1;
pub const CONFIG_CPU_FREQ_GOV_CONSERVATIVE: u32 = 1;
pub const CONFIG_ZSTD_COMMON: u32 = 1;
pub const CONFIG_TCG_TIS_SPI_MODULE: u32 = 1;
pub const CONFIG_DEFAULT_SECURITY_DAC: u32 = 1;
pub const CONFIG_IIO_CROS_EC_LIGHT_PROX_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_3M: u32 = 1;
pub const CONFIG_WATCHDOG: u32 = 1;
pub const CONFIG_BRIDGE_NETFILTER_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_RDC: u32 = 1;
pub const CONFIG_FIND_NORMAL_PAGE: u32 = 1;
pub const CONFIG_SND_SOC_MAX9759_MODULE: u32 = 1;
pub const CONFIG_INT3406_THERMAL_MODULE: u32 = 1;
pub const CONFIG_MODULE_DECOMPRESS: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_860_MODULE: u32 = 1;
pub const CONFIG_LOGITECH_FF: u32 = 1;
pub const CONFIG_VIDEO_VIVID_MODULE: u32 = 1;
pub const CONFIG_IR_IGORPLUGUSB_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_CONNSECMARK_MODULE: u32 = 1;
pub const CONFIG_I2C_HID_CORE_MODULE: u32 = 1;
pub const CONFIG_MWIFIEX_SDIO_MODULE: u32 = 1;
pub const CONFIG_XFRM: u32 = 1;
pub const CONFIG_HAVE_NOINSTR_VALIDATION: u32 = 1;
pub const CONFIG_MFD_TPS65912_SPI_MODULE: u32 = 1;
pub const CONFIG_IPV6_PIMSM_V2: u32 = 1;
pub const CONFIG_ACPI_ADXL: u32 = 1;
pub const CONFIG_FIX_EARLYCON_MEM: u32 = 1;
pub const CONFIG_SCHED_CORE: u32 = 1;
pub const CONFIG_TCG_TIS_I2C_ATMEL_MODULE: u32 = 1;
pub const CONFIG_GNSS_MTK_SERIAL_MODULE: u32 = 1;
pub const CONFIG_DVB_A8293_MODULE: u32 = 1;
pub const CONFIG_PRESTERA_MODULE: u32 = 1;
pub const CONFIG_INTEL_MEI_GSC_MODULE: u32 = 1;
pub const CONFIG_X86_REQUIRED_FEATURE_XMM: u32 = 1;
pub const CONFIG_ORANGEFS_FS_MODULE: u32 = 1;
pub const CONFIG_MLX90614_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_DYNAPRO_MODULE: u32 = 1;
pub const CONFIG_INTEL_SOC_PMIC: u32 = 1;
pub const CONFIG_INPUT_AD714X_SPI_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_FAST_MULTIPLIER: u32 = 1;
pub const CONFIG_IOMMUFD_DRIVER_CORE: u32 = 1;
pub const CONFIG_REGULATOR_RC5T583_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_LIB_SHA512_ARCH: u32 = 1;
pub const CONFIG_CGROUP_HUGETLB: u32 = 1;
pub const CONFIG_FW_LOADER: u32 = 1;
pub const CONFIG_X86_POSTED_MSI: u32 = 1;
pub const CONFIG_INV_ICM42600_I2C_MODULE: u32 = 1;
pub const CONFIG_TWL4030_CORE: u32 = 1;
pub const CONFIG_USB_GSPCA_KINECT_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT1318_SDW_MODULE: u32 = 1;
pub const CONFIG_DPS310_MODULE: u32 = 1;
pub const CONFIG_RTC_SYSTOHC: u32 = 1;
pub const CONFIG_JFS_FS_MODULE: u32 = 1;
pub const CONFIG_CROS_EC_MKBP_PROXIMITY_MODULE: u32 = 1;
pub const CONFIG_SENSORS_W83791D_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_RM_TS_MODULE: u32 = 1;
pub const CONFIG_AMD_NUMA: u32 = 1;
pub const CONFIG_FPGA_DFL_MODULE: u32 = 1;
pub const CONFIG_INET_IPCOMP_MODULE: u32 = 1;
pub const CONFIG_ROMFS_FS_MODULE: u32 = 1;
pub const CONFIG_IP6_NF_MATCH_RT_MODULE: u32 = 1;
pub const CONFIG_MMC_USDHI6ROL0_MODULE: u32 = 1;
pub const CONFIG_SCSI_WD719X_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_TIGERLAKE_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_MICROCHIP_KSZ_SPI_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_MT20XX_MODULE: u32 = 1;
pub const CONFIG_GPIO_MENZ127_MODULE: u32 = 1;
pub const CONFIG_DRM_I915_HEARTBEAT_INTERVAL: u32 = 2500;
pub const CONFIG_INFINIBAND_CXGB4_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_IPC3: u32 = 1;
pub const CONFIG_VIDEO_IMX219_MODULE: u32 = 1;
pub const CONFIG_L2TP_DEBUGFS_MODULE: u32 = 1;
pub const CONFIG_PATA_TOSHIBA_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_CACHE_LINE_SIZE: u32 = 1;
pub const CONFIG_SENSORS_TPS25990_REGULATOR: u32 = 1;
pub const CONFIG_NTB_TRANSPORT_MODULE: u32 = 1;
pub const CONFIG_DM_RAID_MODULE: u32 = 1;
pub const CONFIG_F71808E_WDT_MODULE: u32 = 1;
pub const CONFIG_X86_MINIMUM_CPU_FAMILY: u32 = 64;
pub const CONFIG_EXPORTFS: u32 = 1;
pub const CONFIG_RPR0521_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS43130_MODULE: u32 = 1;
pub const CONFIG_BACKLIGHT_LP8788_MODULE: u32 = 1;
pub const CONFIG_INTEL_TURBO_MAX_3: u32 = 1;
pub const CONFIG_VIDEO_HDPVR_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_HCTR2_MODULE: u32 = 1;
pub const CONFIG_SURFACE_AGGREGATOR_CDEV_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_MT6397_MODULE: u32 = 1;
pub const CONFIG_EXTCON_INTEL_MRFLD_MODULE: u32 = 1;
pub const CONFIG_MAC80211_HWSIM_MODULE: u32 = 1;
pub const CONFIG_SCA3300_MODULE: u32 = 1;
pub const CONFIG_PARPORT_PC_PCMCIA_MODULE: u32 = 1;
pub const CONFIG_TCP_CONG_VEGAS_MODULE: u32 = 1;
pub const CONFIG_GPIO_DLN2_MODULE: u32 = 1;
pub const CONFIG_PANIC_TIMEOUT: u32 = 0;
pub const CONFIG_IBM_RTL_MODULE: u32 = 1;
pub const CONFIG_MISDN_NETJET_MODULE: u32 = 1;
pub const CONFIG_VIDEO_IMX296_MODULE: u32 = 1;
pub const CONFIG_NFC_MEI_PHY_MODULE: u32 = 1;
pub const CONFIG_PTP_1588_CLOCK_MODULE: u32 = 1;
pub const CONFIG_MDIO_BCM_UNIMAC_MODULE: u32 = 1;
pub const CONFIG_SCSI_IPS_MODULE: u32 = 1;
pub const CONFIG_FW_LOADER_COMPRESS_XZ: u32 = 1;
pub const CONFIG_TYPEC_MUX_PS883X_MODULE: u32 = 1;
pub const CONFIG_NET_CORE: u32 = 1;
pub const CONFIG_DVB_LGDT330X_MODULE: u32 = 1;
pub const CONFIG_AT76C50X_USB_MODULE: u32 = 1;
pub const CONFIG_DWMAC_INTEL_MODULE: u32 = 1;
pub const CONFIG_SOFT_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_RTW89_8852A_MODULE: u32 = 1;
pub const CONFIG_DRM_ST7735R_MODULE: u32 = 1;
pub const CONFIG_LD_IS_BFD: u32 = 1;
pub const CONFIG_INFINIBAND_ISERT_MODULE: u32 = 1;
pub const CONFIG_MMU_LAZY_TLB_REFCOUNT: u32 = 1;
pub const CONFIG_NAMESPACES: u32 = 1;
pub const CONFIG_SND_PCM_ELD: u32 = 1;
pub const CONFIG_DECOMPRESS_GZIP: u32 = 1;
pub const CONFIG_CROS_EC_I2C_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_OPA_VNIC_MODULE: u32 = 1;
pub const CONFIG_HWMON: u32 = 1;
pub const CONFIG_TYPEC_TPS6598X_MODULE: u32 = 1;
pub const CONFIG_BRCMFMAC_MODULE: u32 = 1;
pub const CONFIG_ACPI_BATTERY: u32 = 1;
pub const CONFIG_I2C_PCI1XXXX_MODULE: u32 = 1;
pub const CONFIG_TUXEDO_NB04_WMI_AB_MODULE: u32 = 1;
pub const CONFIG_IP_NF_ARP_MANGLE_MODULE: u32 = 1;
pub const CONFIG_RTW88_8821CE_MODULE: u32 = 1;
pub const CONFIG_USB_SISUSBVGA_MODULE: u32 = 1;
pub const CONFIG_CPU_RMAP: u32 = 1;
pub const CONFIG_IP6_NF_RAW_MODULE: u32 = 1;
pub const CONFIG_VFIO_PCI_CORE_MODULE: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_NUMA_BALANCING: u32 = 1;
pub const CONFIG_BUFFER_HEAD: u32 = 1;
pub const CONFIG_DVB_NGENE_MODULE: u32 = 1;
pub const CONFIG_MWIFIEX_USB_MODULE: u32 = 1;
pub const CONFIG_NET_9P_RDMA_MODULE: u32 = 1;
pub const CONFIG_PERF_EVENTS_INTEL_CSTATE_MODULE: u32 = 1;
pub const CONFIG_CC_HAS_AUTO_VAR_INIT_PATTERN: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_SENARYTECH_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CX23885_MODULE: u32 = 1;
pub const CONFIG_ALIENWARE_WMI_MODULE: u32 = 1;
pub const CONFIG_FORTIFY_SOURCE: u32 = 1;
pub const CONFIG_INPUT_IQS626A_MODULE: u32 = 1;
pub const CONFIG_HWSPINLOCK: u32 = 1;
pub const CONFIG_I2C_DESIGNWARE_CORE: u32 = 1;
pub const CONFIG_CAN_ESD_402_PCI_MODULE: u32 = 1;
pub const CONFIG_DRM_ACCEL: u32 = 1;
pub const CONFIG_ENCLOSURE_SERVICES_MODULE: u32 = 1;
pub const CONFIG_NFC_MRVL_I2C_MODULE: u32 = 1;
pub const CONFIG_BT_HCIBTUSB_MTK: u32 = 1;
pub const CONFIG_NAU7802_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WM5102_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RL6231_MODULE: u32 = 1;
pub const CONFIG_DVB_SI2168_MODULE: u32 = 1;
pub const CONFIG_FB_SYSMEM_HELPERS_DEFERRED: u32 = 1;
pub const CONFIG_MFD_SIMPLE_MFD_I2C_MODULE: u32 = 1;
pub const CONFIG_6LOWPAN_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_S6SY761_MODULE: u32 = 1;
pub const CONFIG_WPCM450_SOC_MODULE: u32 = 1;
pub const CONFIG_DUMMY_MODULE: u32 = 1;
pub const CONFIG_VIDEO_EM28XX_V4L2_MODULE: u32 = 1;
pub const CONFIG_DM_BIO_PRISON_MODULE: u32 = 1;
pub const CONFIG_MMC_SDHCI_IO_ACCESSORS: u32 = 1;
pub const CONFIG_NET_DSA_SJA1105_VL: u32 = 1;
pub const CONFIG_CRAMFS_MTD: u32 = 1;
pub const CONFIG_BMC150_ACCEL_SPI_MODULE: u32 = 1;
pub const CONFIG_MTD_ROM_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_FAMILY_ARP: u32 = 1;
pub const CONFIG_SND_SOC_XILINX_SPDIF_MODULE: u32 = 1;
pub const CONFIG_HIBERNATE_CALLBACKS: u32 = 1;
pub const CONFIG_STM_SOURCE_HEARTBEAT_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_CXUSB_MODULE: u32 = 1;
pub const CONFIG_IR_RCMM_DECODER_MODULE: u32 = 1;
pub const CONFIG_TASKS_TRACE_RCU: u32 = 1;
pub const CONFIG_XEN_FRONT_PGDIR_SHBUF_MODULE: u32 = 1;
pub const CONFIG_VIDEO_S5C73M3_MODULE: u32 = 1;
pub const CONFIG_6LOWPAN_NHC_MODULE: u32 = 1;
pub const CONFIG_MHP_MEMMAP_ON_MEMORY: u32 = 1;
pub const CONFIG_XEN_PVHVM: u32 = 1;
pub const CONFIG_MOUSE_PS2_ELANTECH: u32 = 1;
pub const CONFIG_VEML6046X00_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_RT6245_MODULE: u32 = 1;
pub const CONFIG_HARDENED_USERCOPY_DEFAULT_ON: u32 = 1;
pub const CONFIG_VIPERBOARD_ADC_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_MELLANOX: u32 = 1;
pub const CONFIG_IR_SERIAL_MODULE: u32 = 1;
pub const CONFIG_OCFS2_FS_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_SAMSUNG: u32 = 1;
pub const CONFIG_SKY2_MODULE: u32 = 1;
pub const CONFIG_GPIO_TPS68470_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AK4619_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT1320_SDW_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_SPCA501_MODULE: u32 = 1;
pub const CONFIG_MFD_RDC321X_MODULE: u32 = 1;
pub const CONFIG_BT_LE: u32 = 1;
pub const CONFIG_CGBC_WDT_MODULE: u32 = 1;
pub const CONFIG_PCCARD_MODULE: u32 = 1;
pub const CONFIG_DVB_SP8870_MODULE: u32 = 1;
pub const CONFIG_IXGBE_MODULE: u32 = 1;
pub const CONFIG_VIDEO_VD56G3_MODULE: u32 = 1;
pub const CONFIG_HDC3020_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_UPBOARD_MODULE: u32 = 1;
pub const CONFIG_SENSORS_NZXT_SMART2_MODULE: u32 = 1;
pub const CONFIG_MT76x02_LIB_MODULE: u32 = 1;
pub const CONFIG_BACKLIGHT_LM3509_MODULE: u32 = 1;
pub const CONFIG_X86_TSC: u32 = 1;
pub const CONFIG_USB_CONFIGFS_F_UVC: u32 = 1;
pub const CONFIG_SND_SOC_ADAU1701_MODULE: u32 = 1;
pub const CONFIG_DYNAMIC_DEBUG: u32 = 1;
pub const CONFIG_XENFS_MODULE: u32 = 1;
pub const CONFIG_ZRAM_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV2680_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SOF_CIRRUS_COMMON_MODULE: u32 = 1;
pub const CONFIG_SERIAL_DEV_CTRL_TTYPORT: u32 = 1;
pub const CONFIG_SND_AZT3328_MODULE: u32 = 1;
pub const CONFIG_PCI_DOMAINS: u32 = 1;
pub const CONFIG_CHARGER_DA9150_MODULE: u32 = 1;
pub const CONFIG_RTW89_8922AE_MODULE: u32 = 1;
pub const CONFIG_FUSION_SAS_MODULE: u32 = 1;
pub const CONFIG_CPU_FREQ_GOV_SCHEDUTIL: u32 = 1;
pub const CONFIG_REGULATOR_DA9052_MODULE: u32 = 1;
pub const CONFIG_LENOVO_SE10_WDT_MODULE: u32 = 1;
pub const CONFIG_DRM_I915_COMPRESS_ERROR: u32 = 1;
pub const CONFIG_BMC150_MAGN_MODULE: u32 = 1;
pub const CONFIG_TOPSTAR_LAPTOP_MODULE: u32 = 1;
pub const CONFIG_SURFACE_AGGREGATOR_REGISTRY_MODULE: u32 = 1;
pub const CONFIG_EFI_RUNTIME_WRAPPERS: u32 = 1;
pub const CONFIG_USB_MDC800_MODULE: u32 = 1;
pub const CONFIG_NF_CT_NETLINK_MODULE: u32 = 1;
pub const CONFIG_IIO_TRIGGERED_BUFFER_MODULE: u32 = 1;
pub const CONFIG_MEDIA_HIDE_ANCILLARY_SUBDRV: u32 = 1;
pub const CONFIG_INTEL_PCH_THERMAL_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_NAT_MODULE: u32 = 1;
pub const CONFIG_SERIAL_SC16IS7XX_MODULE: u32 = 1;
pub const CONFIG_ATH10K_LEDS: u32 = 1;
pub const CONFIG_DM9102_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DES3_EDE_X86_64_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ADI_AXI_SPDIF_MODULE: u32 = 1;
pub const CONFIG_FWCTL_PDS_MODULE: u32 = 1;
pub const CONFIG_6LOWPAN_NHC_FRAGMENT_MODULE: u32 = 1;
pub const CONFIG_PROC_SYSCTL: u32 = 1;
pub const CONFIG_MOST_SND_MODULE: u32 = 1;
pub const CONFIG_MODULE_SIG_KEY_TYPE_ECDSA: u32 = 1;
pub const CONFIG_HDC100X_MODULE: u32 = 1;
pub const CONFIG_MIGRATION: u32 = 1;
pub const CONFIG_DVB_PLUTO2_MODULE: u32 = 1;
pub const CONFIG_HAVE_EFFICIENT_UNALIGNED_ACCESS: u32 = 1;
pub const CONFIG_X86_REQUIRED_FEATURE_XMM2: u32 = 1;
pub const CONFIG_ATH9K_MODULE: u32 = 1;
pub const CONFIG_XILLYBUS_PCIE_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_AKCIPHER: u32 = 1;
pub const CONFIG_HID_APPLEIR_MODULE: u32 = 1;
pub const CONFIG_MTD_SPI_NOR_SWP_DISABLE_ON_VOLATILE: u32 = 1;
pub const CONFIG_SX9360_MODULE: u32 = 1;
pub const CONFIG_TSM_GUEST: u32 = 1;
pub const CONFIG_NET_SCHED: u32 = 1;
pub const CONFIG_VIRTIO_RTC_MODULE: u32 = 1;
pub const CONFIG_NET_CLS_FW_MODULE: u32 = 1;
pub const CONFIG_HAVE_HARDLOCKUP_DETECTOR_BUDDY: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_861_MODULE: u32 = 1;
pub const CONFIG_VIDEO_HEXIUM_ORION_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_CHACHA20_MODULE: u32 = 1;
pub const CONFIG_TXGBEVF_MODULE: u32 = 1;
pub const CONFIG_MPLS_ROUTING_MODULE: u32 = 1;
pub const CONFIG_SI7210_MODULE: u32 = 1;
pub const CONFIG_PAGE_POOL: u32 = 1;
pub const CONFIG_CRYPTO_USER_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_ESP_MODULE: u32 = 1;
pub const CONFIG_RT2500USB_MODULE: u32 = 1;
pub const CONFIG_NVME_TARGET_TCP_MODULE: u32 = 1;
pub const CONFIG_KFENCE_SAMPLE_INTERVAL: u32 = 100;
pub const CONFIG_HID_XINMO_MODULE: u32 = 1;
pub const CONFIG_NTFS3_FS_MODULE: u32 = 1;
pub const CONFIG_NETPOLL: u32 = 1;
pub const CONFIG_SCSI_DMX3191D_MODULE: u32 = 1;
pub const CONFIG_VIDEO_IPU3_IMGU_MODULE: u32 = 1;
pub const CONFIG_CPU_SUP_AMD: u32 = 1;
pub const CONFIG_VIDEOBUF2_MEMOPS_MODULE: u32 = 1;
pub const CONFIG_IIO_ST_PRESS_SPI_MODULE: u32 = 1;
pub const CONFIG_INTEL_WMI: u32 = 1;
pub const CONFIG_NET_MPLS_GSO_MODULE: u32 = 1;
pub const CONFIG_MII_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_BAYTRAIL_MODULE: u32 = 1;
pub const CONFIG_DM_VERITY_VERIFY_ROOTHASH_SIG: u32 = 1;
pub const CONFIG_BCMA_DRIVER_GMAC_CMN: u32 = 1;
pub const CONFIG_SONY_LAPTOP_MODULE: u32 = 1;
pub const CONFIG_USB_ZERO_MODULE: u32 = 1;
pub const CONFIG_NVMEM_SYSFS: u32 = 1;
pub const CONFIG_HYPERV_STORAGE_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ADAU1761_I2C_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ADM1266_MODULE: u32 = 1;
pub const CONFIG_DVB_TDA18271C2DD_MODULE: u32 = 1;
pub const CONFIG_9P_FS_POSIX_ACL: u32 = 1;
pub const CONFIG_USB_STORAGE_ENE_UB6250_MODULE: u32 = 1;
pub const CONFIG_B53_SRAB_DRIVER_MODULE: u32 = 1;
pub const CONFIG_SCSI_COMMON: u32 = 1;
pub const CONFIG_SPARSEMEM_EXTREME: u32 = 1;
pub const CONFIG_MLX5_EN_RXNFC: u32 = 1;
pub const CONFIG_USB_M5602_MODULE: u32 = 1;
pub const CONFIG_RSEQ: u32 = 1;
pub const CONFIG_SND_PCM_OSS_MODULE: u32 = 1;
pub const CONFIG_IOMMU_DMA: u32 = 1;
pub const CONFIG_SECURITY_TOMOYO_MAX_AUDIT_LOG: u32 = 1024;
pub const CONFIG_SND_HDA_CODEC_CS421X_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_IDT821034_MODULE: u32 = 1;
pub const CONFIG_VIA_WDT_MODULE: u32 = 1;
pub const CONFIG_INTEL_OC_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_GRIP_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_DRR_MODULE: u32 = 1;
pub const CONFIG_KARMA_PARTITION: u32 = 1;
pub const CONFIG_REGULATOR_MAX77826_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_PSXPAD_SPI_FF: u32 = 1;
pub const CONFIG_SENSORS_JC42_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_ILITEK_MODULE: u32 = 1;
pub const CONFIG_SYSCTL_EXCEPTION_TRACE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_I2S_TEST_MODULE: u32 = 1;
pub const CONFIG_NEW_LEDS: u32 = 1;
pub const CONFIG_USB_G_PRINTER_MODULE: u32 = 1;
pub const CONFIG_SPI_AX88796C_MODULE: u32 = 1;
pub const CONFIG_UCLAMP_TASK: u32 = 1;
pub const CONFIG_CIFS_COMPRESSION: u32 = 1;
pub const CONFIG_MHI_BUS_PCI_GENERIC_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_QAT_420XX_MODULE: u32 = 1;
pub const CONFIG_SPI_SLAVE: u32 = 1;
pub const CONFIG_RAS: u32 = 1;
pub const CONFIG_SND_SOC_CS4270_MODULE: u32 = 1;
pub const CONFIG_NF_TABLES_NETDEV: u32 = 1;
pub const CONFIG_SSB_SPROM: u32 = 1;
pub const CONFIG_SND_USB_6FIRE_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_LIB_CURVE25519_ARCH: u32 = 1;
pub const CONFIG_SND_SOC_SDCA_IRQ: u32 = 1;
pub const CONFIG_VIDEO_ADP1653_MODULE: u32 = 1;
pub const CONFIG_BT_6LOWPAN_MODULE: u32 = 1;
pub const CONFIG_KVM_ASYNC_PF: u32 = 1;
pub const CONFIG_DVB_STV0367_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_PERICOM_MODULE: u32 = 1;
pub const CONFIG_PWM_DWC_MODULE: u32 = 1;
pub const CONFIG_SPI_PCI1XXXX_MODULE: u32 = 1;
pub const CONFIG_SCSI_IPR_MODULE: u32 = 1;
pub const CONFIG_ARCH_WANT_IRQS_OFF_ACTIVATE_MM: u32 = 1;
pub const CONFIG_KVM_MMIO: u32 = 1;
pub const CONFIG_MOUSE_SERIAL_MODULE: u32 = 1;
pub const CONFIG_SCSI_CXGB3_ISCSI_MODULE: u32 = 1;
pub const CONFIG_SPI_DLN2_MODULE: u32 = 1;
pub const CONFIG_I2C_DESIGNWARE_BAYTRAIL: u32 = 1;
pub const CONFIG_SC1200_WDT_MODULE: u32 = 1;
pub const CONFIG_DRM_SIMPLEDRM: u32 = 1;
pub const CONFIG_PADATA: u32 = 1;
pub const CONFIG_KEYBOARD_GPIO_POLLED_MODULE: u32 = 1;
pub const CONFIG_HID_PXRC_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_PTE_SPECIAL: u32 = 1;
pub const CONFIG_BLK_DEV_RBD_MODULE: u32 = 1;
pub const CONFIG_SND_DARLA20_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS4265_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV5648_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_MT2060_MODULE: u32 = 1;
pub const CONFIG_CC_HAS_ASM_INLINE: u32 = 1;
pub const CONFIG_POWER_RESET_TPS65086: u32 = 1;
pub const CONFIG_HANGCHECK_TIMER_MODULE: u32 = 1;
pub const CONFIG_SATA_AHCI_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_SENSORS_W83781D_MODULE: u32 = 1;
pub const CONFIG_FB: u32 = 1;
pub const CONFIG_REGULATOR_RT5190A_MODULE: u32 = 1;
pub const CONFIG_IP_VS_FTP_MODULE: u32 = 1;
pub const CONFIG_BT_HCIBCM4377_MODULE: u32 = 1;
pub const CONFIG_INTEL_PMT_CLASS_MODULE: u32 = 1;
pub const CONFIG_INPUT_MC13783_PWRBUTTON_MODULE: u32 = 1;
pub const CONFIG_ADXL313_MODULE: u32 = 1;
pub const CONFIG_PATA_NS87410_MODULE: u32 = 1;
pub const CONFIG_HID_STEELSERIES_MODULE: u32 = 1;
pub const CONFIG_HAVE_ACPI_APEI_NMI: u32 = 1;
pub const CONFIG_TOUCHSCREEN_88PM860X_MODULE: u32 = 1;
pub const CONFIG_SQUASHFS_DECOMP_SINGLE: u32 = 1;
pub const CONFIG_USB_LEDS_TRIGGER_USBPORT_MODULE: u32 = 1;
pub const CONFIG_SENSORS_TMP513_MODULE: u32 = 1;
pub const CONFIG_CC_HAS_NAMED_AS: u32 = 1;
pub const CONFIG_CALL_PADDING: u32 = 1;
pub const CONFIG_FUJITSU_TABLET_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CS5345_MODULE: u32 = 1;
pub const CONFIG_GENERIC_SYSCALL: u32 = 1;
pub const CONFIG_F2FS_FS_LZ4: u32 = 1;
pub const CONFIG_HAS_SECURITY_AUDIT: u32 = 1;
pub const CONFIG_VIRT_WIFI_MODULE: u32 = 1;
pub const CONFIG_PLIP_MODULE: u32 = 1;
pub const CONFIG_V4L_TEST_DRIVERS: u32 = 1;
pub const CONFIG_REGULATOR_88PM800_MODULE: u32 = 1;
pub const CONFIG_DRM_PANIC_SCREEN_QR_CODE: u32 = 1;
pub const CONFIG_SND_SOC_BD28623_MODULE: u32 = 1;
pub const CONFIG_INPUT_88PM860X_ONKEY_MODULE: u32 = 1;
pub const CONFIG_PWM_CROS_EC_MODULE: u32 = 1;
pub const CONFIG_PDS_VDPA_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CX88_ALSA_MODULE: u32 = 1;
pub const CONFIG_HAVE_ACPI_APEI: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_KEXEC_SIG_FORCE: u32 = 1;
pub const CONFIG_SCSI_ISCI_MODULE: u32 = 1;
pub const CONFIG_X86_REQUIRED_FEATURE_FPU: u32 = 1;
pub const CONFIG_ATM_DRIVERS: u32 = 1;
pub const CONFIG_TOUCHSCREEN_PENMOUNT_MODULE: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_950_MODULE: u32 = 1;
pub const CONFIG_CHARGER_BQ25980_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_CS47L90: u32 = 1;
pub const CONFIG_IR_RC5_DECODER_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LM78_MODULE: u32 = 1;
pub const CONFIG_RTW89_8852AE_MODULE: u32 = 1;
pub const CONFIG_BT_HCIUART_INTEL: u32 = 1;
pub const CONFIG_KPROBE_EVENTS: u32 = 1;
pub const CONFIG_MLX4_DEBUG: u32 = 1;
pub const CONFIG_PROC_VMCORE_DEVICE_DUMP: u32 = 1;
pub const CONFIG_F2FS_FS_POSIX_ACL: u32 = 1;
pub const CONFIG_CRYPTO_DEV_QAT_C3XXX_MODULE: u32 = 1;
pub const CONFIG_CHARGER_BQ256XX_MODULE: u32 = 1;
pub const CONFIG_BATTERY_SURFACE_MODULE: u32 = 1;
pub const CONFIG_TI_FPC202_MODULE: u32 = 1;
pub const CONFIG_IQS621_ALS_MODULE: u32 = 1;
pub const CONFIG_CC_HAS_ASM_GOTO_TIED_OUTPUT: u32 = 1;
pub const CONFIG_MITIGATION_SRBDS: u32 = 1;
pub const CONFIG_ISCSI_TARGET_MODULE: u32 = 1;
pub const CONFIG_TABLET_USB_KBTAB_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_INITRD: u32 = 1;
pub const CONFIG_CIFS_FSCACHE: u32 = 1;
pub const CONFIG_SCSI_MPI3MR_MODULE: u32 = 1;
pub const CONFIG_MFD_MAX77843: u32 = 1;
pub const CONFIG_VIDEO_OV7251_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_TDA8290_MODULE: u32 = 1;
pub const CONFIG_BE2ISCSI_MODULE: u32 = 1;
pub const CONFIG_DWC_PCIE_PMU_MODULE: u32 = 1;
pub const CONFIG_USB_F_SERIAL_MODULE: u32 = 1;
pub const CONFIG_AFFS_FS_MODULE: u32 = 1;
pub const CONFIG_NEED_TASKS_RCU: u32 = 1;
pub const CONFIG_MICROSOFT_MANA_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_OPTICON_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_SPCA500_MODULE: u32 = 1;
pub const CONFIG_B43_PHY_LP: u32 = 1;
pub const CONFIG_INET: u32 = 1;
pub const CONFIG_MAX30208_MODULE: u32 = 1;
pub const CONFIG_NR_CPUS_RANGE_BEGIN: u32 = 8192;
pub const CONFIG_DL2K_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CX18_MODULE: u32 = 1;
pub const CONFIG_PATA_HPT3X2N_MODULE: u32 = 1;
pub const CONFIG_HID_PETALYNX_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_AMD_SOUNDWIRE_LINK_BASELINE_MODULE: u32 = 1;
pub const CONFIG_DEVFREQ_GOV_SIMPLE_ONDEMAND_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_SR_MODULE: u32 = 1;
pub const CONFIG_CHR_DEV_ST_MODULE: u32 = 1;
pub const CONFIG_AD5686_MODULE: u32 = 1;
pub const CONFIG_FUJITSU_ES_MODULE: u32 = 1;
pub const CONFIG_ATH11K_PCI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_CZ_RT5645_MACH_MODULE: u32 = 1;
pub const CONFIG_POWER_RESET: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_REDIRECT_MODULE: u32 = 1;
pub const CONFIG_ATA: u32 = 1;
pub const CONFIG_ADAPTEC_STARFIRE_MODULE: u32 = 1;
pub const CONFIG_ADXRS290_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_HFI1_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_QAT_6XXX_MODULE: u32 = 1;
pub const CONFIG_XEN_PV_SMP: u32 = 1;
pub const CONFIG_BLK_DEV_RAM_SIZE: u32 = 16384;
pub const CONFIG_MMA7455_I2C_MODULE: u32 = 1;
pub const CONFIG_USB_EMI26_MODULE: u32 = 1;
pub const CONFIG_NGBEVF_MODULE: u32 = 1;
pub const CONFIG_DLHL60D_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_MT6660_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ZL6100_MODULE: u32 = 1;
pub const CONFIG_ATH6KL_USB_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_SCODEC_CS35L56_I2C_MODULE: u32 = 1;
pub const CONFIG_MSI_WMI_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_TYPEC_MUX_FSA4480_MODULE: u32 = 1;
pub const CONFIG_RPS: u32 = 1;
pub const CONFIG_PCI_P2PDMA: u32 = 1;
pub const CONFIG_HID_PICOLCD_LCD: u32 = 1;
pub const CONFIG_TOUCHSCREEN_ELAN_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_CAST6_MODULE: u32 = 1;
pub const CONFIG_NF_CONNTRACK_SECMARK: u32 = 1;
pub const CONFIG_LEDS_TRIGGER_NETDEV_MODULE: u32 = 1;
pub const CONFIG_CGROUP_NET_PRIO: u32 = 1;
pub const CONFIG_MPILIB: u32 = 1;
pub const CONFIG_MT7603E_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_MC44S803_MODULE: u32 = 1;
pub const CONFIG_GARP_MODULE: u32 = 1;
pub const CONFIG_IPE_POLICY_SIG_PLATFORM_KEYRING: u32 = 1;
pub const CONFIG_RTC_DRV_RV3028_MODULE: u32 = 1;
pub const CONFIG_GPIB_CB7210_MODULE: u32 = 1;
pub const CONFIG_FIRMWARE_TABLE: u32 = 1;
pub const CONFIG_SND_DMAENGINE_PCM_MODULE: u32 = 1;
pub const CONFIG_LEDS_TLC591XX_MODULE: u32 = 1;
pub const CONFIG_NET_ACT_SIMP_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_CHECKSUM_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_SD3078_MODULE: u32 = 1;
pub const CONFIG_IP_NF_SECURITY_MODULE: u32 = 1;
pub const CONFIG_EPOLL: u32 = 1;
pub const CONFIG_SND_ATIIXP_MODULE: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_SCHED_MC: u32 = 1;
pub const CONFIG_USB_FUNCTIONFS_MODULE: u32 = 1;
pub const CONFIG_LEDS_MLXREG_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_PM4125_SDW_MODULE: u32 = 1;
pub const CONFIG_ACPI_PLATFORM_PROFILE_MODULE: u32 = 1;
pub const CONFIG_TYPEC_MUX_GPIO_SBU_MODULE: u32 = 1;
pub const CONFIG_USB_FUNCTIONFS_ETH: u32 = 1;
pub const CONFIG_VIDEO_CAFE_CCIC_MODULE: u32 = 1;
pub const CONFIG_GPIO_SWNODE_UNDEFINED: u32 = 1;
pub const CONFIG_RTC_DRV_DS3232_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_TIGERLAKE_MODULE: u32 = 1;
pub const CONFIG_CGROUPS: u32 = 1;
pub const CONFIG_USB_AMD5536UDC_MODULE: u32 = 1;
pub const CONFIG_VIDEO_SAA7146_VV_MODULE: u32 = 1;
pub const CONFIG_UDMABUF: u32 = 1;
pub const CONFIG_DRM_HYPERV_MODULE: u32 = 1;
pub const CONFIG_CNIC_MODULE: u32 = 1;
pub const CONFIG_SPS30_SERIAL_MODULE: u32 = 1;
pub const CONFIG_MITIGATION_IBPB_ENTRY: u32 = 1;
pub const CONFIG_CHARGER_CROS_CONTROL_MODULE: u32 = 1;
pub const CONFIG_NTB_SWITCHTEC_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AW88395_MODULE: u32 = 1;
pub const CONFIG_PATA_JMICRON_MODULE: u32 = 1;
pub const CONFIG_USB_F_SUBSET_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_PCF85363_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_KMSAN: u32 = 1;
pub const CONFIG_SENSORS_PLI1209BC_REGULATOR: u32 = 1;
pub const CONFIG_AD7791_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SGTL5000_MODULE: u32 = 1;
pub const CONFIG_I2C_ALI1535_MODULE: u32 = 1;
pub const CONFIG_NET_CLS_MATCHALL_MODULE: u32 = 1;
pub const CONFIG_XILINX_LL_TEMAC_MODULE: u32 = 1;
pub const CONFIG_RUST_FW_LOADER_ABSTRACTIONS: u32 = 1;
pub const CONFIG_PKCS8_PRIVATE_KEY_PARSER_MODULE: u32 = 1;
pub const CONFIG_AD2S1210_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250: u32 = 1;
pub const CONFIG_ABP060MG_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_MT7530_MMIO_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_KASAN: u32 = 1;
pub const CONFIG_USB_SERIAL: u32 = 1;
pub const CONFIG_CRYPTO_CHACHA20POLY1305_MODULE: u32 = 1;
pub const CONFIG_USE_PERCPU_NUMA_NODE_ID: u32 = 1;
pub const CONFIG_NUMA_KEEP_MEMINFO: u32 = 1;
pub const CONFIG_HID_ELAN_MODULE: u32 = 1;
pub const CONFIG_CEC_SECO_RC: u32 = 1;
pub const CONFIG_SPI_INTEL_PCI_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_HASH_INFO: u32 = 1;
pub const CONFIG_NET_DSA_MSCC_OCELOT_EXT_MODULE: u32 = 1;
pub const CONFIG_DRM_AMD_ACP: u32 = 1;
pub const CONFIG_QED_LL2: u32 = 1;
pub const CONFIG_MFD_MAX8925: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_IPVS_MODULE: u32 = 1;
pub const CONFIG_PHY_TUSB1210_MODULE: u32 = 1;
pub const CONFIG_CRC32: u32 = 1;
pub const CONFIG_CRYPTO_DEV_QAT_DH895xCC_MODULE: u32 = 1;
pub const CONFIG_EXT4_FS: u32 = 1;
pub const CONFIG_AK8975_MODULE: u32 = 1;
pub const CONFIG_SENSORS_INA238_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_TOUCHRIGHT_MODULE: u32 = 1;
pub const CONFIG_HID_EZKEY_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_TWOFISH_AVX_X86_64_MODULE: u32 = 1;
pub const CONFIG_FANOTIFY_ACCESS_PERMISSIONS: u32 = 1;
pub const CONFIG_EDAC_DECODE_MCE: u32 = 1;
pub const CONFIG_IR_SERIAL_TRANSMITTER: u32 = 1;
pub const CONFIG_JOYSTICK_ZHENHUA_MODULE: u32 = 1;
pub const CONFIG_FUEL_GAUGE_STC3117_MODULE: u32 = 1;
pub const CONFIG_AD7768_1_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_MACH: u32 = 1;
pub const CONFIG_TOUCHSCREEN_HIMAX_HX83112B_MODULE: u32 = 1;
pub const CONFIG_TCP_CONG_HSTCP_MODULE: u32 = 1;
pub const CONFIG_RTL8192CU_MODULE: u32 = 1;
pub const CONFIG_USB_G_DBGP_SERIAL: u32 = 1;
pub const CONFIG_SND_HDA_INPUT_BEEP_MODE: u32 = 0;
pub const CONFIG_GPIO_CDEV: u32 = 1;
pub const CONFIG_CAN_F81604_MODULE: u32 = 1;
pub const CONFIG_VIDEO_PVRUSB2_DVB: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_NOTRACK_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_UACCESS_FLUSHCACHE: u32 = 1;
pub const CONFIG_USB_SERIAL_XSENS_MT_MODULE: u32 = 1;
pub const CONFIG_BATTERY_SBS_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS42L43_MODULE: u32 = 1;
pub const CONFIG_RUST: u32 = 1;
pub const CONFIG_ATH9K_PCOEM: u32 = 1;
pub const CONFIG_KVM_MMU_LOCKLESS_AGING: u32 = 1;
pub const CONFIG_MLX5_CORE_IPOIB: u32 = 1;
pub const CONFIG_SOUND_OSS_CORE: u32 = 1;
pub const CONFIG_LIBIE_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS4271_MODULE: u32 = 1;
pub const CONFIG_VBOXGUEST_MODULE: u32 = 1;
pub const CONFIG_I2C_AMD8111_MODULE: u32 = 1;
pub const CONFIG_VIDEO_IMX290_MODULE: u32 = 1;
pub const CONFIG_BSD_PROCESS_ACCT_V3: u32 = 1;
pub const CONFIG_MAX77541_ADC_MODULE: u32 = 1;
pub const CONFIG_FUSE_PASSTHROUGH: u32 = 1;
pub const CONFIG_SND_SOC_ACPI_AMD_MATCH_MODULE: u32 = 1;
pub const CONFIG_CAN_C_CAN_PCI_MODULE: u32 = 1;
pub const CONFIG_RTL8192C_COMMON_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_TAG_VSC73XX_8021Q_MODULE: u32 = 1;
pub const CONFIG_USB_F_OBEX_MODULE: u32 = 1;
pub const CONFIG_HAVE_SETUP_PER_CPU_AREA: u32 = 1;
pub const CONFIG_USBIP_VHCI_HC_PORTS: u32 = 8;
pub const CONFIG_PCIE_PTM: u32 = 1;
pub const CONFIG_NFC_NCI_UART_MODULE: u32 = 1;
pub const CONFIG_SLIMBUS_MODULE: u32 = 1;
pub const CONFIG_PATA_NETCELL_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_SET_DIRECT_MAP: u32 = 1;
pub const CONFIG_USB_SERIAL_SIMPLE_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_REALM_MODULE: u32 = 1;
pub const CONFIG_USB_M66592_MODULE: u32 = 1;
pub const CONFIG_RUSTC_VERSION_TEXT: &[u8; 65] =
    b"rustc 1.92.0 (ded5c06cf 2025-12-08) (Arch Linux rust 1:1.92.0-1)\0";
pub const CONFIG_USB_CHIPIDEA_PCI_MODULE: u32 = 1;
pub const CONFIG_CIFS_UPCALL: u32 = 1;
pub const CONFIG_CRYPTO_DEV_QAT_C3XXXVF_MODULE: u32 = 1;
pub const CONFIG_USB_SL811_HCD_MODULE: u32 = 1;
pub const CONFIG_USB_TEST_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_RATEEST_MODULE: u32 = 1;
pub const CONFIG_X86_REQUIRED_FEATURE_CX8: u32 = 1;
pub const CONFIG_PCMCIA_LOAD_CIS: u32 = 1;
pub const CONFIG_SND_MIXART_MODULE: u32 = 1;
pub const CONFIG_SATA_MOBILE_LPM_POLICY: u32 = 3;
pub const CONFIG_NET_CRC32C: u32 = 1;
pub const CONFIG_DMARD10_MODULE: u32 = 1;
pub const CONFIG_CHARGER_MANAGER_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_SERPENT_AVX_X86_64_MODULE: u32 = 1;
pub const CONFIG_VCNL4000_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_SOF_MACH_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_GENERIC_MODULE: u32 = 1;
pub const CONFIG_MFD_CS47L15: u32 = 1;
pub const CONFIG_WL18XX_MODULE: u32 = 1;
pub const CONFIG_WILC1000_SPI_MODULE: u32 = 1;
pub const CONFIG_PCMCIA_PCNET_MODULE: u32 = 1;
pub const CONFIG_PMIC_DA903X: u32 = 1;
pub const CONFIG_IIO_ADC_HELPER_MODULE: u32 = 1;
pub const CONFIG_NVMEM_RAVE_SP_EEPROM_MODULE: u32 = 1;
pub const CONFIG_COMMON_CLK_SI5351_MODULE: u32 = 1;
pub const CONFIG_DVB_FIREDTV_MODULE: u32 = 1;
pub const CONFIG_SURFACE_KBD_MODULE: u32 = 1;
pub const CONFIG_DECOMPRESS_BZIP2: u32 = 1;
pub const CONFIG_ACPI_HOTPLUG_IOAPIC: u32 = 1;
pub const CONFIG_RDMA_RXE_MODULE: u32 = 1;
pub const CONFIG_MODULE_SIG: u32 = 1;
pub const CONFIG_MODULE_SIG_FORMAT: u32 = 1;
pub const CONFIG_BLK_DEV_RNBD_SERVER_MODULE: u32 = 1;
pub const CONFIG_SND_SOF_SOF_HDA_SDW_BPT_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_VMAP_STACK: u32 = 1;
pub const CONFIG_HAVE_OBJTOOL_NOP_MCOUNT: u32 = 1;
pub const CONFIG_EFI_STUB: u32 = 1;
pub const CONFIG_TOUCHSCREEN_CYTTSP_SPI_MODULE: u32 = 1;
pub const CONFIG_GPIO_USBIO_MODULE: u32 = 1;
pub const CONFIG_GPIO_WM8994_MODULE: u32 = 1;
pub const CONFIG_BT_HCIUART_H4: u32 = 1;
pub const CONFIG_VIDEO_OV6211_MODULE: u32 = 1;
pub const CONFIG_SENSORS_OCC_MODULE: u32 = 1;
pub const CONFIG_DMABUF_HEAPS_SYSTEM: u32 = 1;
pub const CONFIG_MIN_HEAP: u32 = 1;
pub const CONFIG_CAN_SJA1000_MODULE: u32 = 1;
pub const CONFIG_SSB_DRIVER_GPIO: u32 = 1;
pub const CONFIG_RTC_LIB: u32 = 1;
pub const CONFIG_HAVE_MOVE_PUD: u32 = 1;
pub const CONFIG_SND_SOC_SOF_INTEL_MTL_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LM77_MODULE: u32 = 1;
pub const CONFIG_QED_SRIOV: u32 = 1;
pub const CONFIG_THINKPAD_LMI_MODULE: u32 = 1;
pub const CONFIG_PSE_SI3474_MODULE: u32 = 1;
pub const CONFIG_INPUT_UINPUT_MODULE: u32 = 1;
pub const CONFIG_INPUT_GPIO_ROTARY_ENCODER_MODULE: u32 = 1;
pub const CONFIG_MFD_PALMAS_MODULE: u32 = 1;
pub const CONFIG_SCSI_DEBUG_MODULE: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_PT_RECLAIM: u32 = 1;
pub const CONFIG_LCD_LMS283GF05_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_AAT2870_MODULE: u32 = 1;
pub const CONFIG_CAN_HI311X_MODULE: u32 = 1;
pub const CONFIG_USB_F_PHONET_MODULE: u32 = 1;
pub const CONFIG_SENSORS_TMP108_MODULE: u32 = 1;
pub const CONFIG_PERF_EVENTS_AMD_BRS: u32 = 1;
pub const CONFIG_USB_CDNSP_GADGET: u32 = 1;
pub const CONFIG_PER_VMA_LOCK: u32 = 1;
pub const CONFIG_ND_PFN_MODULE: u32 = 1;
pub const CONFIG_NFT_REDIR_MODULE: u32 = 1;
pub const CONFIG_I2C_CBUS_GPIO_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_PCM186X_I2C_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_SONIXB_MODULE: u32 = 1;
pub const CONFIG_DQL: u32 = 1;
pub const CONFIG_RSI_DEBUGFS: u32 = 1;
pub const CONFIG_USB_CONFIGFS_F_UAC1_LEGACY: u32 = 1;
pub const CONFIG_IR_TOY_MODULE: u32 = 1;
pub const CONFIG_TCG_TIS_I2C_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_AMDISP_MODULE: u32 = 1;
pub const CONFIG_SECCOMP_FILTER: u32 = 1;
pub const CONFIG_SPI_PXA2XX_MODULE: u32 = 1;
pub const CONFIG_GPIO_PCI_IDIO_16_MODULE: u32 = 1;
pub const CONFIG_MEGARAID_NEWGEN: u32 = 1;
pub const CONFIG_TASKS_RCU: u32 = 1;
pub const CONFIG_BNXT_SRIOV: u32 = 1;
pub const CONFIG_GCC_VERSION: u32 = 150201;
pub const CONFIG_6LOWPAN_NHC_IPV6_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_JUMP_LABEL_RELATIVE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_AMD_COMMON_MODULE: u32 = 1;
pub const CONFIG_WEXT_PRIV: u32 = 1;
pub const CONFIG_TULIP_MMIO: u32 = 1;
pub const CONFIG_SND_SOC_CS42L84_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_RENESAS: u32 = 1;
pub const CONFIG_SND_SOC_CS4234_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_CML_LP_DA7219_MAX98357A_MACH_MODULE: u32 = 1;
pub const CONFIG_SERIAL_MAX310X_MODULE: u32 = 1;
pub const CONFIG_SYSCTL: u32 = 1;
pub const CONFIG_USB_CDNSP_HOST: u32 = 1;
pub const CONFIG_THERMAL_GOV_USER_SPACE: u32 = 1;
pub const CONFIG_SENSORS_CGBC_MODULE: u32 = 1;
pub const CONFIG_NVMEM: u32 = 1;
pub const CONFIG_CRYPTO_LIB_SHA1: u32 = 1;
pub const CONFIG_ZONE_DEVICE: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_HDMI_SIMPLE_MODULE: u32 = 1;
pub const CONFIG_VIDEO_EM28XX_ALSA_MODULE: u32 = 1;
pub const CONFIG_VLAN_8021Q_GVRP: u32 = 1;
pub const CONFIG_INTEL_PMT_CRASHLOG_MODULE: u32 = 1;
pub const CONFIG_GPIO_WM8350_MODULE: u32 = 1;
pub const CONFIG_IP_NF_IPTABLES_LEGACY_MODULE: u32 = 1;
pub const CONFIG_USB_ISP1760_MODULE: u32 = 1;
pub const CONFIG_HID_DRAGONRISE_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_STRING_MODULE: u32 = 1;
pub const CONFIG_SND_AU8830_MODULE: u32 = 1;
pub const CONFIG_SSB_POSSIBLE: u32 = 1;
pub const CONFIG_VIDEO_IMX274_MODULE: u32 = 1;
pub const CONFIG_SENSORS_PT5161L_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_XILINX: u32 = 1;
pub const CONFIG_AIC79XX_REG_PRETTY_PRINT: u32 = 1;
pub const CONFIG_TIGON3_MODULE: u32 = 1;
pub const CONFIG_MAXLINEAR_GPHY_MODULE: u32 = 1;
pub const CONFIG_XEN_SCRUB_PAGES_DEFAULT: u32 = 1;
pub const CONFIG_INTEL_SOC_DTS_THERMAL_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX31785_MODULE: u32 = 1;
pub const CONFIG_CEC_CROS_EC_MODULE: u32 = 1;
pub const CONFIG_NLS_UTF8_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV02C10_MODULE: u32 = 1;
pub const CONFIG_WLAN_VENDOR_REALTEK: u32 = 1;
pub const CONFIG_USB_LGM_PHY_MODULE: u32 = 1;
pub const CONFIG_B43_PCI_AUTOSELECT: u32 = 1;
pub const CONFIG_USB_GSPCA_STK1135_MODULE: u32 = 1;
pub const CONFIG_GPIO_GENERIC_MODULE: u32 = 1;
pub const CONFIG_SURFACE_GPE_MODULE: u32 = 1;
pub const CONFIG_SCHED_CLASS_EXT: u32 = 1;
pub const CONFIG_BACKLIGHT_LP855X_MODULE: u32 = 1;
pub const CONFIG_PM_SLEEP_SMP: u32 = 1;
pub const CONFIG_ARCH_MAY_HAVE_PC_FDC: u32 = 1;
pub const CONFIG_FIXED_PHY_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_NULL_MODULE: u32 = 1;
pub const CONFIG_POSIX_MQUEUE_SYSCTL: u32 = 1;
pub const CONFIG_HOTPLUG_PCI_ACPI: u32 = 1;
pub const CONFIG_AD7091R5_MODULE: u32 = 1;
pub const CONFIG_INTERRUPT_CNT_MODULE: u32 = 1;
pub const CONFIG_MULTIPLEXER_MODULE: u32 = 1;
pub const CONFIG_HIBERNATION: u32 = 1;
pub const CONFIG_SIEMENS_SIMATIC_IPC_WDT_MODULE: u32 = 1;
pub const CONFIG_IP_VS_DH_MODULE: u32 = 1;
pub const CONFIG_INPUT_QNAP_MCU_MODULE: u32 = 1;
pub const CONFIG_HAPPYMEAL_MODULE: u32 = 1;
pub const CONFIG_OUTPUT_FORMAT: &[u8; 13] = b"elf64-x86-64\0";
pub const CONFIG_VIDEO_TW686X_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_ADP5520_MODULE: u32 = 1;
pub const CONFIG_AD_SIGMA_DELTA_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_PCM512x_MODULE: u32 = 1;
pub const CONFIG_RTW89_8851BE_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_OSF_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_CS8409_MODULE: u32 = 1;
pub const CONFIG_IPMI_SI_MODULE: u32 = 1;
pub const CONFIG_IWL4965_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_BQ257XX_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_MEN_MCB_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DS3232_HWMON: u32 = 1;
pub const CONFIG_HID_FT260_MODULE: u32 = 1;
pub const CONFIG_TWL4030_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_NET_9P_XEN_MODULE: u32 = 1;
pub const CONFIG_PHY_INTEL_LGM_EMMC_MODULE: u32 = 1;
pub const CONFIG_SERIAL_CORE_CONSOLE: u32 = 1;
pub const CONFIG_NET_VENDOR_CISCO: u32 = 1;
pub const CONFIG_HP206C_MODULE: u32 = 1;
pub const CONFIG_AK8974_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV8858_MODULE: u32 = 1;
pub const CONFIG_XXHASH: u32 = 1;
pub const CONFIG_NET_L3_MASTER_DEV: u32 = 1;
pub const CONFIG_TASK_XACCT: u32 = 1;
pub const CONFIG_NET_SOCK_MSG: u32 = 1;
pub const CONFIG_SPI_MXIC_MODULE: u32 = 1;
pub const CONFIG_SENSORS_HDAPS_MODULE: u32 = 1;
pub const CONFIG_MODIFY_LDT_SYSCALL: u32 = 1;
pub const CONFIG_SENSORS_LTC2992_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ADM9240_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_LIB_DES_MODULE: u32 = 1;
pub const CONFIG_MLX90635_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS42L42_MODULE: u32 = 1;
pub const CONFIG_SND_SEQUENCER_OSS_MODULE: u32 = 1;
pub const CONFIG_AIC7XXX_DEBUG_ENABLE: u32 = 1;
pub const CONFIG_PARPORT_1284: u32 = 1;
pub const CONFIG_INPUT_MAX77693_HAPTIC_MODULE: u32 = 1;
pub const CONFIG_SND_MTS64_MODULE: u32 = 1;
pub const CONFIG_I2C_SLAVE_TESTUNIT_MODULE: u32 = 1;
pub const CONFIG_MOXA_SMARTIO_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_ECDH: u32 = 1;
pub const CONFIG_MMCONF_FAM10H: u32 = 1;
pub const CONFIG_ATA_PIIX_MODULE: u32 = 1;
pub const CONFIG_X86_ANDROID_TABLETS_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DS2404_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_MAX31335_MODULE: u32 = 1;
pub const CONFIG_LEDS_ADP5520_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_NODE_DEV_GROUP: u32 = 1;
pub const CONFIG_ARCH_CONFIGURES_CPU_MITIGATIONS: u32 = 1;
pub const CONFIG_DRM_NOUVEAU_BACKLIGHT: u32 = 1;
pub const CONFIG_DVB_DYNAMIC_MINORS: u32 = 1;
pub const CONFIG_HID_PICOLCD_MODULE: u32 = 1;
pub const CONFIG_CHT_WC_PMIC_OPREGION: u32 = 1;
pub const CONFIG_IA32_FEAT_CTL: u32 = 1;
pub const CONFIG_SND_SOC_CS42L51_I2C_MODULE: u32 = 1;
pub const CONFIG_IRQ_DOMAIN_HIERARCHY: u32 = 1;
pub const CONFIG_IIO_ST_LSM9DS0_MODULE: u32 = 1;
pub const CONFIG_SPI_CADENCE_MODULE: u32 = 1;
pub const CONFIG_SND_JACK: u32 = 1;
pub const CONFIG_I2C_AMD_ASF_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_HDA_LINK: u32 = 1;
pub const CONFIG_IWLDVM_MODULE: u32 = 1;
pub const CONFIG_NET_ACT_BPF_MODULE: u32 = 1;
pub const CONFIG_HID_ASUS_MODULE: u32 = 1;
pub const CONFIG_HID_LETSKETCH_MODULE: u32 = 1;
pub const CONFIG_CAN_CTUCANFD_MODULE: u32 = 1;
pub const CONFIG_FXLS8962AF_SPI_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_DIB0700_MODULE: u32 = 1;
pub const CONFIG_SENSORS_TMP401_MODULE: u32 = 1;
pub const CONFIG_CONTEXT_TRACKING_USER: u32 = 1;
pub const CONFIG_CRYPTO_LIB_POLY1305: u32 = 1;
pub const CONFIG_SND_SOC_CS_AMP_LIB_MODULE: u32 = 1;
pub const CONFIG_SLUB_CPU_PARTIAL: u32 = 1;
pub const CONFIG_I2C_SCMI_MODULE: u32 = 1;
pub const CONFIG_MTD_NAND_CORE_MODULE: u32 = 1;
pub const CONFIG_CC_HAS_IBT: u32 = 1;
pub const CONFIG_NET_DSA_XRS700X_I2C_MODULE: u32 = 1;
pub const CONFIG_INPUT_DA7280_HAPTICS_MODULE: u32 = 1;
pub const CONFIG_ACPI_NFIT_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_LYNXPOINT_MODULE: u32 = 1;
pub const CONFIG_GENERIC_IRQ_PROBE: u32 = 1;
pub const CONFIG_CRYPTO_ECRDSA_MODULE: u32 = 1;
pub const CONFIG_TCP_CONG_VENO_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_EXECMEM_ROX: u32 = 1;
pub const CONFIG_9P_FS_MODULE: u32 = 1;
pub const CONFIG_MHZ19B_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_MODULE: u32 = 1;
pub const CONFIG_SQUASHFS_LZO: u32 = 1;
pub const CONFIG_MOUSE_PS2_SMBUS: u32 = 1;
pub const CONFIG_FRAMEBUFFER_CONSOLE_DETECT_PRIMARY: u32 = 1;
pub const CONFIG_NET_SCH_TAPRIO_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_PCM1789_MODULE: u32 = 1;
pub const CONFIG_SENSORS_W83795_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LTC3815_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_KRB5ENC_MODULE: u32 = 1;
pub const CONFIG_FRAME_WARN: u32 = 2048;
pub const CONFIG_SERIAL_MAX3100_MODULE: u32 = 1;
pub const CONFIG_DYNAMIC_FTRACE: u32 = 1;
pub const CONFIG_SND_FIREWIRE_DIGI00X_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SIGMADSP_REGMAP_MODULE: u32 = 1;
pub const CONFIG_NLS_MAC_CENTEURO_MODULE: u32 = 1;
pub const CONFIG_VIDEO_DW9768_MODULE: u32 = 1;
pub const CONFIG_LD_VERSION: u32 = 24501;
pub const CONFIG_NET_CLS_U32_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MP2869_MODULE: u32 = 1;
pub const CONFIG_XEN_BACKEND: u32 = 1;
pub const CONFIG_VT_CONSOLE: u32 = 1;
pub const CONFIG_INET_AH_MODULE: u32 = 1;
pub const CONFIG_I2C: u32 = 1;
pub const CONFIG_CHARGER_BQ24257_MODULE: u32 = 1;
pub const CONFIG_HOTPLUG_PCI_SHPC: u32 = 1;
pub const CONFIG_NET_SCH_ETS_MODULE: u32 = 1;
pub const CONFIG_BATTERY_RT5033_MODULE: u32 = 1;
pub const CONFIG_INPUT_DA9052_ONKEY_MODULE: u32 = 1;
pub const CONFIG_X86_CPUID: u32 = 1;
pub const CONFIG_INTEL_TH_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_MODULE: u32 = 1;
pub const CONFIG_VIDEO_V4L2_TPG_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_NAU8540_MODULE: u32 = 1;
pub const CONFIG_ADXL313_I2C_MODULE: u32 = 1;
pub const CONFIG_USB_MUSB_HDRC_MODULE: u32 = 1;
pub const CONFIG_SENSORS_EMC2103_MODULE: u32 = 1;
pub const CONFIG_SCSI_MVUMI_MODULE: u32 = 1;
pub const CONFIG_PCIE_PME: u32 = 1;
pub const CONFIG_LEDS_LM3642_MODULE: u32 = 1;
pub const CONFIG_MD_RAID10_MODULE: u32 = 1;
pub const CONFIG_LEDS_CLASS: u32 = 1;
pub const CONFIG_SND_SOC_PCM179X_I2C_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_ICELAKE_MODULE: u32 = 1;
pub const CONFIG_MEDIA_RADIO_SUPPORT: u32 = 1;
pub const CONFIG_LSI_ET1011C_PHY_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_ADI: u32 = 1;
pub const CONFIG_LTC2688_MODULE: u32 = 1;
pub const CONFIG_LEDS_TRIGGER_PANIC: u32 = 1;
pub const CONFIG_BT_HCIUART_AG6XX: u32 = 1;
pub const CONFIG_PM_SLEEP: u32 = 1;
pub const CONFIG_NET_SCH_CODEL_MODULE: u32 = 1;
pub const CONFIG_MODULE_SIG_ALL: u32 = 1;
pub const CONFIG_CRC64_ARCH: u32 = 1;
pub const CONFIG_INTEL_TELEMETRY_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ADM1029_MODULE: u32 = 1;
pub const CONFIG_VIDEO_DW9807_VCM_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT298_MODULE: u32 = 1;
pub const CONFIG_DRM_BRIDGE: u32 = 1;
pub const CONFIG_REED_SOLOMON_DEC8: u32 = 1;
pub const CONFIG_MKISS_MODULE: u32 = 1;
pub const CONFIG_VIDEO_SAA7134_RC: u32 = 1;
pub const CONFIG_USB_GSPCA_SPCA506_MODULE: u32 = 1;
pub const CONFIG_COMMON_CLK_PALMAS_MODULE: u32 = 1;
pub const CONFIG_ACPI_NUMA: u32 = 1;
pub const CONFIG_AD74413R_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ADT7410_MODULE: u32 = 1;
pub const CONFIG_IWLWIFI_DEBUG: u32 = 1;
pub const CONFIG_LENOVO_WMI_DATA01_MODULE: u32 = 1;
pub const CONFIG_HID_MAGICMOUSE_MODULE: u32 = 1;
pub const CONFIG_EFI_DXE_MEM_ATTRIBUTES: u32 = 1;
pub const CONFIG_HID_APPLETB_KBD_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_FQ_MODULE: u32 = 1;
pub const CONFIG_VIDEO_BT848_MODULE: u32 = 1;
pub const CONFIG_RT2800USB_RT53XX: u32 = 1;
pub const CONFIG_DETECT_HUNG_TASK: u32 = 1;
pub const CONFIG_VIDEO_M52790_MODULE: u32 = 1;
pub const CONFIG_SYSTEM_DATA_VERIFICATION: u32 = 1;
pub const CONFIG_USB_G_MULTI_CDC: u32 = 1;
pub const CONFIG_VIRTIO_IOMMU_MODULE: u32 = 1;
pub const CONFIG_FUJITSU_LAPTOP_MODULE: u32 = 1;
pub const CONFIG_DRM_I915_MAX_REQUEST_BUSYWAIT: u32 = 8000;
pub const CONFIG_TOUCHSCREEN_WM831X_MODULE: u32 = 1;
pub const CONFIG_HIBERNATION_SNAPSHOT_DEV: u32 = 1;
pub const CONFIG_X86_INTEL_MEMORY_PROTECTION_KEYS: u32 = 1;
pub const CONFIG_HID_ZEROPLUS_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_DSP_LOADER: u32 = 1;
pub const CONFIG_MFD_MT6397_MODULE: u32 = 1;
pub const CONFIG_NET_PTP_CLASSIFY: u32 = 1;
pub const CONFIG_CC_HAS_RETURN_THUNK: u32 = 1;
pub const CONFIG_60XX_WDT_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT711_SDCA_SDW_MODULE: u32 = 1;
pub const CONFIG_VMAP_STACK: u32 = 1;
pub const CONFIG_ICE_MODULE: u32 = 1;
pub const CONFIG_PM: u32 = 1;
pub const CONFIG_AD5064_MODULE: u32 = 1;
pub const CONFIG_DST_CACHE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_VIRTIO_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_PADLOCK_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_CCP_CRYPTO_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_SHA512: u32 = 1;
pub const CONFIG_MEMORY_FAILURE: u32 = 1;
pub const CONFIG_SND_SOC_RT1019_MODULE: u32 = 1;
pub const CONFIG_LIST_HARDENED: u32 = 1;
pub const CONFIG_IIO_ST_PRESS_I2C_MODULE: u32 = 1;
pub const CONFIG_SENSORS_F71882FG_MODULE: u32 = 1;
pub const CONFIG_ADXL367_I2C_MODULE: u32 = 1;
pub const CONFIG_IRQ_POLL: u32 = 1;
pub const CONFIG_SND_SOC_AMD_PS_MODULE: u32 = 1;
pub const CONFIG_CHARGER_MAX14577_MODULE: u32 = 1;
pub const CONFIG_PCMCIA_NMCLAN_MODULE: u32 = 1;
pub const CONFIG_ATH10K_SPECTRAL: u32 = 1;
pub const CONFIG_NET_VENDOR_GOOGLE: u32 = 1;
pub const CONFIG_ARCH_SPARSEMEM_ENABLE: u32 = 1;
pub const CONFIG_SCSI_AIC7XXX_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_INTEL_LNL_MODULE: u32 = 1;
pub const CONFIG_ARCH_ENABLE_THP_MIGRATION: u32 = 1;
pub const CONFIG_ACPI_THERMAL_LIB: u32 = 1;
pub const CONFIG_USB_EHCI_ROOT_HUB_TT: u32 = 1;
pub const CONFIG_USB_NET_AX88179_178A_MODULE: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_775_MODULE: u32 = 1;
pub const CONFIG_CMA_SYSFS: u32 = 1;
pub const CONFIG_MARVELL_PHY_MODULE: u32 = 1;
pub const CONFIG_HID_PRIMAX_MODULE: u32 = 1;
pub const CONFIG_NLS: u32 = 1;
pub const CONFIG_USB_S2255_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_TPS6507X_MODULE: u32 = 1;
pub const CONFIG_IP_SET_HASH_NETPORTNET_MODULE: u32 = 1;
pub const CONFIG_GENERIC_IRQ_RESERVATION_MODE: u32 = 1;
pub const CONFIG_OID_REGISTRY: u32 = 1;
pub const CONFIG_IIO_KX022A_MODULE: u32 = 1;
pub const CONFIG_SSB_PCMCIAHOST_POSSIBLE: u32 = 1;
pub const CONFIG_MEDIATEK_GE_PHY_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_RT5640_MODULE: u32 = 1;
pub const CONFIG_INTEL_SKL_INT3472_MODULE: u32 = 1;
pub const CONFIG_USER_STACKTRACE_SUPPORT: u32 = 1;
pub const CONFIG_SND_CTXFI_MODULE: u32 = 1;
pub const CONFIG_CARL9170_DEBUGFS: u32 = 1;
pub const CONFIG_BT_NXPUART_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX77705_MODULE: u32 = 1;
pub const CONFIG_SPI_OFFLOAD_TRIGGER_PWM_MODULE: u32 = 1;
pub const CONFIG_THUNDER_NIC_PF_MODULE: u32 = 1;
pub const CONFIG_SCHED_TRACER: u32 = 1;
pub const CONFIG_MLXREG_HOTPLUG_MODULE: u32 = 1;
pub const CONFIG_B43_PHY_G: u32 = 1;
pub const CONFIG_INPUT_CMA3000_I2C_MODULE: u32 = 1;
pub const CONFIG_BNXT_FLOWER_OFFLOAD: u32 = 1;
pub const CONFIG_TOUCHSCREEN_WACOM_I2C_MODULE: u32 = 1;
pub const CONFIG_AD7793_MODULE: u32 = 1;
pub const CONFIG_ACPI_ALS_MODULE: u32 = 1;
pub const CONFIG_LPC_ICH_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OG01A1B_MODULE: u32 = 1;
pub const CONFIG_GENERIC_IRQ_MIGRATION: u32 = 1;
pub const CONFIG_SQUASHFS_ZLIB: u32 = 1;
pub const CONFIG_MLX4_CORE_MODULE: u32 = 1;
pub const CONFIG_MLX5_DPLL_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_WIZNET: u32 = 1;
pub const CONFIG_EDAC_AMD64_MODULE: u32 = 1;
pub const CONFIG_USB_AUDIO_MODULE: u32 = 1;
pub const CONFIG_CAN_CAN327_MODULE: u32 = 1;
pub const CONFIG_SPEAKUP_SYNTH_APOLLO_MODULE: u32 = 1;
pub const CONFIG_SPEAKUP_SYNTH_DECTLK_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_ACP_PDM_MODULE: u32 = 1;
pub const CONFIG_SPI_OFFLOAD_TRIGGER_ADI_UTIL_SD_MODULE: u32 = 1;
pub const CONFIG_DVB_HORUS3A_MODULE: u32 = 1;
pub const CONFIG_XFRM_IPTFS_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LM87_MODULE: u32 = 1;
pub const CONFIG_BACKLIGHT_PWM_MODULE: u32 = 1;
pub const CONFIG_APDS9300_MODULE: u32 = 1;
pub const CONFIG_RPCSEC_GSS_KRB5_ENCTYPES_CAMELLIA: u32 = 1;
pub const CONFIG_USB_VIDEO_CLASS_INPUT_EVDEV: u32 = 1;
pub const CONFIG_REGULATOR_LM363X_MODULE: u32 = 1;
pub const CONFIG_MITIGATION_PAGE_TABLE_ISOLATION: u32 = 1;
pub const CONFIG_DVB_STV0297_MODULE: u32 = 1;
pub const CONFIG_IPMI_IPMB_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_TAG_BRCM_PREPEND_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX6621_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LTC4215_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_FAMILY_BRIDGE: u32 = 1;
pub const CONFIG_CC_NO_ARRAY_BOUNDS: u32 = 1;
pub const CONFIG_6LOWPAN_GHC_EXT_HDR_ROUTE_MODULE: u32 = 1;
pub const CONFIG_AMD_NODE: u32 = 1;
pub const CONFIG_MLX90632_MODULE: u32 = 1;
pub const CONFIG_FIB_RULES: u32 = 1;
pub const CONFIG_NFT_XFRM_MODULE: u32 = 1;
pub const CONFIG_CONTEXT_TRACKING_IDLE: u32 = 1;
pub const CONFIG_AD7779_MODULE: u32 = 1;
pub const CONFIG_BLK_DEBUG_FS: u32 = 1;
pub const CONFIG_JBD2: u32 = 1;
pub const CONFIG_VIDEO_IMX208_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_DMIC_MODULE: u32 = 1;
pub const CONFIG_ATM_IA_MODULE: u32 = 1;
pub const CONFIG_FONT_SUPPORT: u32 = 1;
pub const CONFIG_NXP_CBTX_PHY_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LTC4222_MODULE: u32 = 1;
pub const CONFIG_USB_CDNS3_HOST: u32 = 1;
pub const CONFIG_GENERIC_IRQ_EFFECTIVE_AFF_MASK: u32 = 1;
pub const CONFIG_SND_SOC_WM8776_MODULE: u32 = 1;
pub const CONFIG_WIRELESS: u32 = 1;
pub const CONFIG_THERMAL_GOV_FAIR_SHARE: u32 = 1;
pub const CONFIG_BLK_DEV_BSGLIB: u32 = 1;
pub const CONFIG_USB_NET_SR9800_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_STA32X_MODULE: u32 = 1;
pub const CONFIG_MFD_WM8350_I2C: u32 = 1;
pub const CONFIG_9P_FS_SECURITY: u32 = 1;
pub const CONFIG_PC87413_WDT_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_FQ_PIE_MODULE: u32 = 1;
pub const CONFIG_MLXSW_SPECTRUM_MODULE: u32 = 1;
pub const CONFIG_SATA_SIL24_MODULE: u32 = 1;
pub const CONFIG_MAX1363_MODULE: u32 = 1;
pub const CONFIG_SCSI_DH_ALUA_MODULE: u32 = 1;
pub const CONFIG_VIDEO_IMX283_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MCP3021_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ES8389_MODULE: u32 = 1;
pub const CONFIG_SND_CS46XX_MODULE: u32 = 1;
pub const CONFIG_NETFILTER: u32 = 1;
pub const CONFIG_VIRTIO_PCI_ADMIN_LEGACY: u32 = 1;
pub const CONFIG_LIBERTAS_THINFIRM_USB_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_MT2063_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_HL_MODULE: u32 = 1;
pub const CONFIG_SIOX_BUS_GPIO_MODULE: u32 = 1;
pub const CONFIG_IEEE802154_NL802154_EXPERIMENTAL: u32 = 1;
pub const CONFIG_DVB_STV6111_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_STMFTS_MODULE: u32 = 1;
pub const CONFIG_NVME_RDMA_MODULE: u32 = 1;
pub const CONFIG_REGMAP_SPI: u32 = 1;
pub const CONFIG_NET_ACT_GATE_MODULE: u32 = 1;
pub const CONFIG_OPTEE_STATIC_PROTMEM_POOL: u32 = 1;
pub const CONFIG_ADIS16080_MODULE: u32 = 1;
pub const CONFIG_CXL_PCI_MODULE: u32 = 1;
pub const CONFIG_SND_VIRMIDI_MODULE: u32 = 1;
pub const CONFIG_GOOGLE_COREBOOT_TABLE_MODULE: u32 = 1;
pub const CONFIG_MMA9553_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_SN9C2028_MODULE: u32 = 1;
pub const CONFIG_NET_IPGRE_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_IRDMA_MODULE: u32 = 1;
pub const CONFIG_SND_USB_AUDIO_USE_MEDIA_CONTROLLER: u32 = 1;
pub const CONFIG_BSD_DISKLABEL: u32 = 1;
pub const CONFIG_USB_STORAGE_SDDR09_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV9650_MODULE: u32 = 1;
pub const CONFIG_INTEL_IOMMU_SCALABLE_MODE_DEFAULT_ON: u32 = 1;
pub const CONFIG_DRM_PANEL_RASPBERRYPI_TOUCHSCREEN_MODULE: u32 = 1;
pub const CONFIG_AD5446_MODULE: u32 = 1;
pub const CONFIG_BLK_WBT_MQ: u32 = 1;
pub const CONFIG_CHROMEOS_ACPI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_PCM186X_SPI_MODULE: u32 = 1;
pub const CONFIG_DVB_CXD2841ER_MODULE: u32 = 1;
pub const CONFIG_INTEL_VSEC_MODULE: u32 = 1;
pub const CONFIG_FUNCTION_GRAPH_RETVAL: u32 = 1;
pub const CONFIG_CRYPTO_LIB_MD5: u32 = 1;
pub const CONFIG_USB_SPEEDTOUCH_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SDW_UTILS_MODULE: u32 = 1;
pub const CONFIG_DRM_DISPLAY_DP_HELPER: u32 = 1;
pub const CONFIG_INTEL_MEI_HDCP_MODULE: u32 = 1;
pub const CONFIG_EFI_VARS_PSTORE_DEFAULT_DISABLE: u32 = 1;
pub const CONFIG_SND_SOC_ES8311_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_LPASS_RX_MACRO_MODULE: u32 = 1;
pub const CONFIG_VIDEO_TVP5150_MODULE: u32 = 1;
pub const CONFIG_INTEL_IPS_MODULE: u32 = 1;
pub const CONFIG_MFD_WM8350: u32 = 1;
pub const CONFIG_ENA_ETHERNET_MODULE: u32 = 1;
pub const CONFIG_HFSPLUS_FS_MODULE: u32 = 1;
pub const CONFIG_MFD_MAX77541_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_SKCIPHER: u32 = 1;
pub const CONFIG_USB_CONFIGFS_F_TCM: u32 = 1;
pub const CONFIG_MLX5_EN_TLS: u32 = 1;
pub const CONFIG_NET_DSA_VITESSE_VSC73XX_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LM75_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_MOS7840_MODULE: u32 = 1;
pub const CONFIG_ATH11K_SPECTRAL: u32 = 1;
pub const CONFIG_INTEL_SPEED_SELECT_TPMI_MODULE: u32 = 1;
pub const CONFIG_IR_SONY_DECODER_MODULE: u32 = 1;
pub const CONFIG_LENOVO_WMI_HELPERS_MODULE: u32 = 1;
pub const CONFIG_SERIO_ARC_PS2_MODULE: u32 = 1;
pub const CONFIG_HID_ITE_MODULE: u32 = 1;
pub const CONFIG_HAVE_FUNCTION_GRAPH_FREGS: u32 = 1;
pub const CONFIG_VIDEO_IMX355_MODULE: u32 = 1;
pub const CONFIG_X86_AMD_PSTATE: u32 = 1;
pub const CONFIG_SND_SOC_TLV320AIC23_I2C_MODULE: u32 = 1;
pub const CONFIG_PCP_BATCH_SCALE_MAX: u32 = 5;
pub const CONFIG_NETFILTER_XT_MATCH_NFACCT_MODULE: u32 = 1;
pub const CONFIG_PATA_RDC_MODULE: u32 = 1;
pub const CONFIG_SLAB_FREELIST_HARDENED: u32 = 1;
pub const CONFIG_PM_GENERIC_DOMAINS: u32 = 1;
pub const CONFIG_INPUT_IBM_PANEL_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_LRW_MODULE: u32 = 1;
pub const CONFIG_DEFAULT_HUNG_TASK_TIMEOUT: u32 = 120;
pub const CONFIG_XFS_ONLINE_SCRUB: u32 = 1;
pub const CONFIG_SERIO_LIBPS2: u32 = 1;
pub const CONFIG_MMA8452_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_SPCA505_MODULE: u32 = 1;
pub const CONFIG_TAP_MODULE: u32 = 1;
pub const CONFIG_TRANSPARENT_HUGEPAGE_ALWAYS: u32 = 1;
pub const CONFIG_CAN_CC770_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_HAVE_PREEMPT_DYNAMIC: u32 = 1;
pub const CONFIG_USB_DEFAULT_PERSIST: u32 = 1;
pub const CONFIG_SND_SOC_MAX98520_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ADT7411_MODULE: u32 = 1;
pub const CONFIG_TCP_CONG_CUBIC: u32 = 1;
pub const CONFIG_USB_G_DBGP_MODULE: u32 = 1;
pub const CONFIG_HID_THINGM_MODULE: u32 = 1;
pub const CONFIG_ATM_BR2684_MODULE: u32 = 1;
pub const CONFIG_ZRAM_MEMORY_TRACKING: u32 = 1;
pub const CONFIG_ACPI_MRRM: u32 = 1;
pub const CONFIG_XDP_SOCKETS: u32 = 1;
pub const CONFIG_CRYPTO_ECHAINIV_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_ISL6271A_MODULE: u32 = 1;
pub const CONFIG_TINYDRM_HX8357D_MODULE: u32 = 1;
pub const CONFIG_MEGARAID_MAILBOX_MODULE: u32 = 1;
pub const CONFIG_SEV_GUEST_MODULE: u32 = 1;
pub const CONFIG_RTW89_8922A_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_UBSAN: u32 = 1;
pub const CONFIG_AD7291_MODULE: u32 = 1;
pub const CONFIG_YT2_1380_MODULE: u32 = 1;
pub const CONFIG_MFD_WCD934X_MODULE: u32 = 1;
pub const CONFIG_INPUT_DA9055_ONKEY_MODULE: u32 = 1;
pub const CONFIG_HID_PICOLCD_LEDS: u32 = 1;
pub const CONFIG_DVB_DIB7000P_MODULE: u32 = 1;
pub const CONFIG_CW1200_MODULE: u32 = 1;
pub const CONFIG_LCD_ILI922X_MODULE: u32 = 1;
pub const CONFIG_JFFS2_SUMMARY: u32 = 1;
pub const CONFIG_VIDEO_CCS_PLL_MODULE: u32 = 1;
pub const CONFIG_IP_SET_BITMAP_IP_MODULE: u32 = 1;
pub const CONFIG_VMAP_PFN: u32 = 1;
pub const CONFIG_SENSORS_TPS25990_MODULE: u32 = 1;
pub const CONFIG_HAVE_SOFTIRQ_ON_OWN_STACK: u32 = 1;
pub const CONFIG_AIC79XX_DEBUG_ENABLE: u32 = 1;
pub const CONFIG_SND_SOC_WM8510_MODULE: u32 = 1;
pub const CONFIG_VIRT_CPU_ACCOUNTING_GEN: u32 = 1;
pub const CONFIG_LP8788_ADC_MODULE: u32 = 1;
pub const CONFIG_SMI240_MODULE: u32 = 1;
pub const CONFIG_BPF_JIT: u32 = 1;
pub const CONFIG_TRACE_GPU_MEM: u32 = 1;
pub const CONFIG_MOUSE_PS2_TOUCHKIT: u32 = 1;
pub const CONFIG_HPET_TIMER: u32 = 1;
pub const CONFIG_ARCH_HAS_MEM_ENCRYPT: u32 = 1;
pub const CONFIG_SUNRPC_DEBUG: u32 = 1;
pub const CONFIG_HID_MALTRON_MODULE: u32 = 1;
pub const CONFIG_MFD_TWL4030_AUDIO: u32 = 1;
pub const CONFIG_CRYPTO_CAST5_MODULE: u32 = 1;
pub const CONFIG_GPIB_AGILENT_82357A_MODULE: u32 = 1;
pub const CONFIG_PARPORT_NOT_PC: u32 = 1;
pub const CONFIG_NET_TEAM_MODE_ACTIVEBACKUP_MODULE: u32 = 1;
pub const CONFIG_MT7921E_MODULE: u32 = 1;
pub const CONFIG_DELL_WMI_AIO_MODULE: u32 = 1;
pub const CONFIG_DVB_AS102_MODULE: u32 = 1;
pub const CONFIG_HID_PANTHERLORD_MODULE: u32 = 1;
pub const CONFIG_HAVE_CLK_PREPARE: u32 = 1;
pub const CONFIG_USB_CONFIGFS_MASS_STORAGE: u32 = 1;
pub const CONFIG_WM8350_POWER_MODULE: u32 = 1;
pub const CONFIG_SENSORS_IRPS5401_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_HDA_MLINK_MODULE: u32 = 1;
pub const CONFIG_SENSORS_SURFACE_TEMP_MODULE: u32 = 1;
pub const CONFIG_WM831X_BACKUP_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_CAST5_AVX_X86_64_MODULE: u32 = 1;
pub const CONFIG_IR_ENE_MODULE: u32 = 1;
pub const CONFIG_SURFACE_PLATFORM_PROFILE_MODULE: u32 = 1;
pub const CONFIG_DVB_AV7110_OSD: u32 = 1;
pub const CONFIG_LEDS_APU_MODULE: u32 = 1;
pub const CONFIG_SERIAL_NONSTANDARD: u32 = 1;
pub const CONFIG_XEN_UNPOPULATED_ALLOC: u32 = 1;
pub const CONFIG_BACKLIGHT_DA9052_MODULE: u32 = 1;
pub const CONFIG_PTP_1588_CLOCK_MOCK_MODULE: u32 = 1;
pub const CONFIG_HAVE_RUST: u32 = 1;
pub const CONFIG_BE2NET_HWMON: u32 = 1;
pub const CONFIG_BLK_DEV_BSG_COMMON: u32 = 1;
pub const CONFIG_CFG80211_CRDA_SUPPORT: u32 = 1;
pub const CONFIG_NVRAM: u32 = 1;
pub const CONFIG_SND_SOC_RT5514_MODULE: u32 = 1;
pub const CONFIG_IP_ADVANCED_ROUTER: u32 = 1;
pub const CONFIG_HMM_MIRROR: u32 = 1;
pub const CONFIG_JOYSTICK_IFORCE_MODULE: u32 = 1;
pub const CONFIG_SND_ICE1712_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX20730_MODULE: u32 = 1;
pub const CONFIG_SND_ALI5451_MODULE: u32 = 1;
pub const CONFIG_IP_VS_OVF_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_GENIV_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_ACT8865_MODULE: u32 = 1;
pub const CONFIG_TRACER_SNAPSHOT: u32 = 1;
pub const CONFIG_VIDEO_EM28XX_RC_MODULE: u32 = 1;
pub const CONFIG_CHARGER_MAX8903_MODULE: u32 = 1;
pub const CONFIG_SPI_LJCA_MODULE: u32 = 1;
pub const CONFIG_MMU_GATHER_MERGE_VMAS: u32 = 1;
pub const CONFIG_USB_C67X00_HCD_MODULE: u32 = 1;
pub const CONFIG_AUDIT_ARCH: u32 = 1;
pub const CONFIG_FTRACE: u32 = 1;
pub const CONFIG_BAYCOM_SER_HDX_MODULE: u32 = 1;
pub const CONFIG_RTL8192EE_MODULE: u32 = 1;
pub const CONFIG_USB_DWC3_ULPI: u32 = 1;
pub const CONFIG_ATH9K_HTC_DEBUGFS: u32 = 1;
pub const CONFIG_TI_ADC161S626_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_HDMI_CODEC_MODULE: u32 = 1;
pub const CONFIG_DNS_RESOLVER_MODULE: u32 = 1;
pub const CONFIG_SUNRPC_GSS_MODULE: u32 = 1;
pub const CONFIG_PAGE_BLOCK_MAX_ORDER: u32 = 10;
pub const CONFIG_VIDEOMODE_HELPERS: u32 = 1;
pub const CONFIG_SQUASHFS_LZ4: u32 = 1;
pub const CONFIG_ZL3073X_SPI_MODULE: u32 = 1;
pub const CONFIG_EDAC_SUPPORT: u32 = 1;
pub const CONFIG_USB_PRINTER_MODULE: u32 = 1;
pub const CONFIG_FW_CFG_SYSFS_MODULE: u32 = 1;
pub const CONFIG_BACKLIGHT_WM831X_MODULE: u32 = 1;
pub const CONFIG_B44_PCICORE_AUTOSELECT: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_NETMAP_MODULE: u32 = 1;
pub const CONFIG_VDPA_SIM_NET_MODULE: u32 = 1;
pub const CONFIG_ACPI_IPMI_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_LPSS_MODULE: u32 = 1;
pub const CONFIG_SPI_MASTER: u32 = 1;
pub const CONFIG_PPS_GENERATOR_TIO_MODULE: u32 = 1;
pub const CONFIG_SND_INTEL_SOUNDWIRE_ACPI_MODULE: u32 = 1;
pub const CONFIG_F2FS_FS_LZ4HC: u32 = 1;
pub const CONFIG_USB_GSPCA_SE401_MODULE: u32 = 1;
pub const CONFIG_STRIP_ASM_SYMS: u32 = 1;
pub const CONFIG_LENOVO_YMC_MODULE: u32 = 1;
pub const CONFIG_SENSORS_SIS5595_MODULE: u32 = 1;
pub const CONFIG_PWM_GPIO_MODULE: u32 = 1;
pub const CONFIG_MDIO_MVUSB_MODULE: u32 = 1;
pub const CONFIG_EFI_PARTITION: u32 = 1;
pub const CONFIG_SENSORS_MAX6620_MODULE: u32 = 1;
pub const CONFIG_MTD_SPI_NOR_MODULE: u32 = 1;
pub const CONFIG_SND_AC97_POWER_SAVE: u32 = 1;
pub const CONFIG_HAVE_PREEMPT_DYNAMIC_CALL: u32 = 1;
pub const CONFIG_CAN_F81601_MODULE: u32 = 1;
pub const CONFIG_HAVE_GENERIC_TIF_BITS: u32 = 1;
pub const CONFIG_SND_SOC_PCM1681_MODULE: u32 = 1;
pub const CONFIG_INTEL_BYTCRC_PWRSRC_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LTC2990_MODULE: u32 = 1;
pub const CONFIG_MDIO_GPIO_MODULE: u32 = 1;
pub const CONFIG_MARVELL_10G_PHY_MODULE: u32 = 1;
pub const CONFIG_DA9052_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS530X_I2C_MODULE: u32 = 1;
pub const CONFIG_ST_UVIS25_MODULE: u32 = 1;
pub const CONFIG_MACB_PCI_MODULE: u32 = 1;
pub const CONFIG_VIDEO_SAA7127_MODULE: u32 = 1;
pub const CONFIG_MAX11205_MODULE: u32 = 1;
pub const CONFIG_MT792x_USB_MODULE: u32 = 1;
pub const CONFIG_IP_NF_MATCH_TTL_MODULE: u32 = 1;
pub const CONFIG_MMC_TIFM_SD_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SSM2305_MODULE: u32 = 1;
pub const CONFIG_FHANDLE: u32 = 1;
pub const CONFIG_SND_USB_HIFACE_MODULE: u32 = 1;
pub const CONFIG_XFS_SUPPORT_ASCII_CI: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_CGROUP_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_SSU100_MODULE: u32 = 1;
pub const CONFIG_SENSORS_G762_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_ACP3x_MODULE: u32 = 1;
pub const CONFIG_ARCH_MHP_MEMMAP_ON_MEMORY_ENABLE: u32 = 1;
pub const CONFIG_FPGA_DFL_FME_BRIDGE_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_F81232_MODULE: u32 = 1;
pub const CONFIG_NVME_TARGET_FCLOOP_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_SPCA561_MODULE: u32 = 1;
pub const CONFIG_SND_DARLA24_MODULE: u32 = 1;
pub const CONFIG_SYS_HYPERVISOR: u32 = 1;
pub const CONFIG_SURFACE_AGGREGATOR_MODULE: u32 = 1;
pub const CONFIG_SGL_ALLOC: u32 = 1;
pub const CONFIG_TYPEC_HD3SS3220_MODULE: u32 = 1;
pub const CONFIG_LEDS_BD2802_MODULE: u32 = 1;
pub const CONFIG_GENERIC_PCI_IOMAP: u32 = 1;
pub const CONFIG_AMD_WBRF: u32 = 1;
pub const CONFIG_GPIO_AMDPT_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_USER_API_RNG_MODULE: u32 = 1;
pub const CONFIG_DVB_STV6110_MODULE: u32 = 1;
pub const CONFIG_MLXFW_MODULE: u32 = 1;
pub const CONFIG_NF_CT_PROTO_GRE: u32 = 1;
pub const CONFIG_BT_HCIBFUSB_MODULE: u32 = 1;
pub const CONFIG_SOUND_MODULE: u32 = 1;
pub const CONFIG_TOSHIBA_WMI_MODULE: u32 = 1;
pub const CONFIG_LOCALVERSION_AUTO: u32 = 1;
pub const CONFIG_C2PORT_MODULE: u32 = 1;
pub const CONFIG_SENSORS_W83793_MODULE: u32 = 1;
pub const CONFIG_INTEL_TDX_HOST: u32 = 1;
pub const CONFIG_NET_DSA_TAG_TRAILER_MODULE: u32 = 1;
pub const CONFIG_CRAMFS_MODULE: u32 = 1;
pub const CONFIG_USB_DWC3_DUAL_ROLE: u32 = 1;
pub const CONFIG_SND_AD1889_MODULE: u32 = 1;
pub const CONFIG_NLS_MAC_TURKISH_MODULE: u32 = 1;
pub const CONFIG_GENERIC_ALLOCATOR: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_RT5682_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SI476X_MODULE: u32 = 1;
pub const CONFIG_DVB_TDA1004X_MODULE: u32 = 1;
pub const CONFIG_EFI_SBAT_FILE: &[u8; 1] = b"\0";
pub const CONFIG_HAVE_ARCH_KGDB: u32 = 1;
pub const CONFIG_CAN_C_CAN_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_HID_HYPERV_MOUSE_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_TWL4030_MODULE: u32 = 1;
pub const CONFIG_MTD_NAND_ECC: u32 = 1;
pub const CONFIG_SND_USB_USX2Y_MODULE: u32 = 1;
pub const CONFIG_NET_INGRESS: u32 = 1;
pub const CONFIG_WQ_POWER_EFFICIENT_DEFAULT: u32 = 1;
pub const CONFIG_CRYPTO_AEAD2: u32 = 1;
pub const CONFIG_INFINIBAND_VIRT_DMA: u32 = 1;
pub const CONFIG_VIDEO_HI846_MODULE: u32 = 1;
pub const CONFIG_MANA_INFINIBAND_MODULE: u32 = 1;
pub const CONFIG_GPIO_CRYSTAL_COVE: u32 = 1;
pub const CONFIG_DM_PERSISTENT_DATA_MODULE: u32 = 1;
pub const CONFIG_TOSHIBA_HAPS_MODULE: u32 = 1;
pub const CONFIG_NET_ACT_MPLS_MODULE: u32 = 1;
pub const CONFIG_FUNCTION_GRAPH_RETADDR: u32 = 1;
pub const CONFIG_VIDEO_TW5864_MODULE: u32 = 1;
pub const CONFIG_GENERIC_BUG_RELATIVE_POINTERS: u32 = 1;
pub const CONFIG_SND_YMFPCI_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_LIB_AESGCM: u32 = 1;
pub const CONFIG_KVM_GENERIC_MEMORY_ATTRIBUTES: u32 = 1;
pub const CONFIG_ARCH_STACKWALK: u32 = 1;
pub const CONFIG_BNXT_MODULE: u32 = 1;
pub const CONFIG_SPI: u32 = 1;
pub const CONFIG_CHARGER_BQ25890_MODULE: u32 = 1;
pub const CONFIG_SND_ATIIXP_MODEM_MODULE: u32 = 1;
pub const CONFIG_P54_PCI_MODULE: u32 = 1;
pub const CONFIG_NODES_SHIFT: u32 = 10;
pub const CONFIG_LCD_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_USB_HIDDEV: u32 = 1;
pub const CONFIG_CEC_CH7322_MODULE: u32 = 1;
pub const CONFIG_RPMSG_QCOM_GLINK_MODULE: u32 = 1;
pub const CONFIG_MITIGATION_CALL_DEPTH_TRACKING: u32 = 1;
pub const CONFIG_GPIO_GRANITERAPIDS_MODULE: u32 = 1;
pub const CONFIG_SENSORS_IT87_MODULE: u32 = 1;
pub const CONFIG_TCM_FILEIO_MODULE: u32 = 1;
pub const CONFIG_HID_U2FZERO_MODULE: u32 = 1;
pub const CONFIG_BACKLIGHT_KTD253_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_ZFORCE_MODULE: u32 = 1;
pub const CONFIG_WIZNET_W5100_MODULE: u32 = 1;
pub const CONFIG_HFS_FS_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_MMAP_RND_BITS: u32 = 1;
pub const CONFIG_LEDS_SIEMENS_SIMATIC_IPC_APOLLOLAKE_MODULE: u32 = 1;
pub const CONFIG_SND_FM801_MODULE: u32 = 1;
pub const CONFIG_HAVE_PERF_REGS: u32 = 1;
pub const CONFIG_USB_NET2280_MODULE: u32 = 1;
pub const CONFIG_HW_RANDOM_XIPHERA_MODULE: u32 = 1;
pub const CONFIG_GENERIC_PENDING_IRQ: u32 = 1;
pub const CONFIG_QCOM_EMAC_MODULE: u32 = 1;
pub const CONFIG_RTW89_USB_MODULE: u32 = 1;
pub const CONFIG_CXL_FEATURES: u32 = 1;
pub const CONFIG_SKFP_MODULE: u32 = 1;
pub const CONFIG_APPLE_PROPERTIES: u32 = 1;
pub const CONFIG_MOTORCOMM_PHY_MODULE: u32 = 1;
pub const CONFIG_VIDEO_AD5820_MODULE: u32 = 1;
pub const CONFIG_PPS_GENERATOR_MODULE: u32 = 1;
pub const CONFIG_VIDEO_MT9T112_MODULE: u32 = 1;
pub const CONFIG_RESET_TI_SYSCON_MODULE: u32 = 1;
pub const CONFIG_DVB_STB0899_MODULE: u32 = 1;
pub const CONFIG_AD7292_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_DEBUG_PROBES_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WM8731_I2C_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS35L41_SPI_MODULE: u32 = 1;
pub const CONFIG_PAGE_SIZE_LESS_THAN_256KB: u32 = 1;
pub const CONFIG_IPV6_SIT_6RD: u32 = 1;
pub const CONFIG_FUSE_DAX: u32 = 1;
pub const CONFIG_HAS_IOPORT: u32 = 1;
pub const CONFIG_REGULATOR_RT5759_MODULE: u32 = 1;
pub const CONFIG_NET_9P_USBG_MODULE: u32 = 1;
pub const CONFIG_HAVE_JUMP_LABEL_HACK: u32 = 1;
pub const CONFIG_STRICT_MODULE_RWX: u32 = 1;
pub const CONFIG_MCP4531_MODULE: u32 = 1;
pub const CONFIG_IXGBEVF_MODULE: u32 = 1;
pub const CONFIG_SENSORS_XDPE122_REGULATOR: u32 = 1;
pub const CONFIG_CXL_BUS_MODULE: u32 = 1;
pub const CONFIG_MAC802154_MODULE: u32 = 1;
pub const CONFIG_USB_NET_SR9700_MODULE: u32 = 1;
pub const CONFIG_PCS_MTK_LYNXI_MODULE: u32 = 1;
pub const CONFIG_FXOS8700_MODULE: u32 = 1;
pub const CONFIG_AD7944_MODULE: u32 = 1;
pub const CONFIG_DMABUF_HEAPS_CMA_LEGACY: u32 = 1;
pub const CONFIG_LIBERTAS_SPI_MODULE: u32 = 1;
pub const CONFIG_PCI: u32 = 1;
pub const CONFIG_SENSORS_PMBUS_MODULE: u32 = 1;
pub const CONFIG_USB_OHCI_HCD_PCI: u32 = 1;
pub const CONFIG_SND_OPL3_LIB_SEQ_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_CPIA1_MODULE: u32 = 1;
pub const CONFIG_CLANG_VERSION: u32 = 0;
pub const CONFIG_DEV_DAX_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_ARIZONA_MICSUPP_MODULE: u32 = 1;
pub const CONFIG_CEC_NOTIFIER: u32 = 1;
pub const CONFIG_BRIDGE_EBT_MARK_MODULE: u32 = 1;
pub const CONFIG_BATTERY_UG3105_MODULE: u32 = 1;
pub const CONFIG_IT8712F_WDT_MODULE: u32 = 1;
pub const CONFIG_HSC030PA_SPI_MODULE: u32 = 1;
pub const CONFIG_B43_MODULE: u32 = 1;
pub const CONFIG_DM_CACHE_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XTABLES_COMPAT: u32 = 1;
pub const CONFIG_GPIB_NEC7210_MODULE: u32 = 1;
pub const CONFIG_ATH6KL_TRACING: u32 = 1;
pub const CONFIG_B43_SSB: u32 = 1;
pub const CONFIG_SCD30_I2C_MODULE: u32 = 1;
pub const CONFIG_SBP_TARGET_MODULE: u32 = 1;
pub const CONFIG_BMI270_SPI_MODULE: u32 = 1;
pub const CONFIG_DVB_HELENE_MODULE: u32 = 1;
pub const CONFIG_SECURITY_APPARMOR_INTROSPECT_POLICY: u32 = 1;
pub const CONFIG_HAVE_ARCH_WITHIN_STACK_FRAMES: u32 = 1;
pub const CONFIG_ARCH_HAS_ELF_RANDOMIZE: u32 = 1;
pub const CONFIG_NFS_V4_1_IMPLEMENTATION_ID_DOMAIN: &[u8; 11] = b"kernel.org\0";
pub const CONFIG_SCSI: u32 = 1;
pub const CONFIG_X86_REQUIRED_FEATURE_PAE: u32 = 1;
pub const CONFIG_DVB_ZL10036_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_IPRANGE_MODULE: u32 = 1;
pub const CONFIG_NF_CONNTRACK_TIMESTAMP: u32 = 1;
pub const CONFIG_BOOT_VESA_SUPPORT: u32 = 1;
pub const CONFIG_SENSORS_SHT4x_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_MAX9867_MODULE: u32 = 1;
pub const CONFIG_INPUT_LEDS: u32 = 1;
pub const CONFIG_USB_RTL8153_ECM_MODULE: u32 = 1;
pub const CONFIG_IIO_CROS_EC_SENSORS_CORE_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WCD_COMMON_MODULE: u32 = 1;
pub const CONFIG_USB_CHIPIDEA_GENERIC_MODULE: u32 = 1;
pub const CONFIG_SQUASHFS_DECOMP_MULTI: u32 = 1;
pub const CONFIG_MAGIC_SYSRQ: u32 = 1;
pub const CONFIG_GENERIC_CALIBRATE_DELAY: u32 = 1;
pub const CONFIG_CRYPTO_KDF800108_CTR: u32 = 1;
pub const CONFIG_REGULATOR_RT5739_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_SOLARFLARE: u32 = 1;
pub const CONFIG_MAGIC_SYSRQ_SERIAL_SEQUENCE: &[u8; 1] = b"\0";
pub const CONFIG_BT_BNEP_MC_FILTER: u32 = 1;
pub const CONFIG_SENSORS_MAX34440_MODULE: u32 = 1;
pub const CONFIG_CRC7_MODULE: u32 = 1;
pub const CONFIG_MEDIA_ANALOG_TV_SUPPORT: u32 = 1;
pub const CONFIG_HAVE_KVM_IRQCHIP: u32 = 1;
pub const CONFIG_SND_DEBUG: u32 = 1;
pub const CONFIG_LD_ORPHAN_WARN_LEVEL: &[u8; 5] = b"warn\0";
pub const CONFIG_USB_OHCI_HCD_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_PCI_MESON_MODULE: u32 = 1;
pub const CONFIG_AIX_PARTITION: u32 = 1;
pub const CONFIG_RTW88_8703B_MODULE: u32 = 1;
pub const CONFIG_DVB_TDA10071_MODULE: u32 = 1;
pub const CONFIG_I2C_MUX_REG_MODULE: u32 = 1;
pub const CONFIG_FONTS: u32 = 1;
pub const CONFIG_MEDIA_TUNER_FC2580_MODULE: u32 = 1;
pub const CONFIG_XEN_BALLOON: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_JASTEC: u32 = 1;
pub const CONFIG_SFC_SIENA_MODULE: u32 = 1;
pub const CONFIG_CC_HAS_ASM_GOTO_OUTPUT: u32 = 1;
pub const CONFIG_64BIT: u32 = 1;
pub const CONFIG_I2C_MUX_LTC4306_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_USNIC_MODULE: u32 = 1;
pub const CONFIG_SENSORS_WM8350_MODULE: u32 = 1;
pub const CONFIG_USB_CONFIGFS_ECM_SUBSET: u32 = 1;
pub const CONFIG_DVB_IX2505V_MODULE: u32 = 1;
pub const CONFIG_USB_OHCI_LITTLE_ENDIAN: u32 = 1;
pub const CONFIG_ISO9660_FS_MODULE: u32 = 1;
pub const CONFIG_UNIX_DIAG_MODULE: u32 = 1;
pub const CONFIG_TCG_TIS_SPI_CR50: u32 = 1;
pub const CONFIG_QTNFMAC_MODULE: u32 = 1;
pub const CONFIG_PHY_PACKAGE_MODULE: u32 = 1;
pub const CONFIG_NFS_SWAP: u32 = 1;
pub const CONFIG_SND_HDA_GENERIC_LEDS: u32 = 1;
pub const CONFIG_DVB_VES1820_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LM85_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CHV3_I2S_MODULE: u32 = 1;
pub const CONFIG_AD5758_MODULE: u32 = 1;
pub const CONFIG_APDS9306_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_HDA_MODULE: u32 = 1;
pub const CONFIG_DMA_OPS_HELPERS: u32 = 1;
pub const CONFIG_VIDEOBUF2_DVB_MODULE: u32 = 1;
pub const CONFIG_DVB_STV0299_MODULE: u32 = 1;
pub const CONFIG_I2C_I801_MUX: u32 = 1;
pub const CONFIG_IP_SCTP_MODULE: u32 = 1;
pub const CONFIG_XEN_PV: u32 = 1;
pub const CONFIG_IP_VS_PROTO_SCTP: u32 = 1;
pub const CONFIG_MFD_MADERA_SPI_MODULE: u32 = 1;
pub const CONFIG_BATTERY_BQ27XXX_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ATK0110_MODULE: u32 = 1;
pub const CONFIG_IP_VS_TWOS_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LTC2991_MODULE: u32 = 1;
pub const CONFIG_USB_GADGET_STORAGE_NUM_BUFFERS: u32 = 2;
pub const CONFIG_RADIO_MAXIRADIO_MODULE: u32 = 1;
pub const CONFIG_PM_DEBUG: u32 = 1;
pub const CONFIG_VIDEOBUF2_DMA_SG_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_SMSC_LAN9303_MDIO_MODULE: u32 = 1;
pub const CONFIG_DPTF_PCH_FIVR_MODULE: u32 = 1;
pub const CONFIG_HAVE_STATIC_CALL_INLINE: u32 = 1;
pub const CONFIG_MMC_SDHCI_XENON_MODULE: u32 = 1;
pub const CONFIG_USB_F_UAC1_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_TI: u32 = 1;
pub const CONFIG_RAVE_SP_CORE_MODULE: u32 = 1;
pub const CONFIG_BLK_CGROUP: u32 = 1;
pub const CONFIG_HARDLOCKUP_CHECK_TIMESTAMP: u32 = 1;
pub const CONFIG_BNX2X_SRIOV: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_REALTEK_LIB_MODULE: u32 = 1;
pub const CONFIG_AGP_SIS_MODULE: u32 = 1;
pub const CONFIG_SIEMENS_SIMATIC_IPC_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_KFENCE: u32 = 1;
pub const CONFIG_RUSTC_HAS_FILE_WITH_NUL: u32 = 1;
pub const CONFIG_HYPERV_NET_MODULE: u32 = 1;
pub const CONFIG_AL3010_MODULE: u32 = 1;
pub const CONFIG_HID_CORSAIR_MODULE: u32 = 1;
pub const CONFIG_IPV6_VTI_MODULE: u32 = 1;
pub const CONFIG_RTL8XXXU_UNTESTED: u32 = 1;
pub const CONFIG_MICROCHIP_PHY_RDS_PTP_MODULE: u32 = 1;
pub const CONFIG_PERSISTENT_HUGE_ZERO_FOLIO: u32 = 1;
pub const CONFIG_U_SERIAL_CONSOLE: u32 = 1;
pub const CONFIG_HID_NTI_MODULE: u32 = 1;
pub const CONFIG_DECOMPRESS_ZSTD: u32 = 1;
pub const CONFIG_SND_SOC_WM8770_MODULE: u32 = 1;
pub const CONFIG_NF_LOG_ARP_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AW8738_MODULE: u32 = 1;
pub const CONFIG_EBC_C384_WDT_MODULE: u32 = 1;
pub const CONFIG_MTD_MAP_BANK_WIDTH_4: u32 = 1;
pub const CONFIG_NF_NAT_AMANDA_MODULE: u32 = 1;
pub const CONFIG_SND_UTIMER: u32 = 1;
pub const CONFIG_OLD_SIGSUSPEND3: u32 = 1;
pub const CONFIG_CROS_EC_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_MAX11410_MODULE: u32 = 1;
pub const CONFIG_NET_TEAM_MODULE: u32 = 1;
pub const CONFIG_LEDS_MAX77705_MODULE: u32 = 1;
pub const CONFIG_SSB_PCIHOST_POSSIBLE: u32 = 1;
pub const CONFIG_REGULATOR_MAX1586_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_ANALOG_MODULE: u32 = 1;
pub const CONFIG_CXL_MCE: u32 = 1;
pub const CONFIG_XPS: u32 = 1;
pub const CONFIG_W83977F_WDT_MODULE: u32 = 1;
pub const CONFIG_6LOWPAN_GHC_EXT_HDR_FRAG_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_STATISTIC_MODULE: u32 = 1;
pub const CONFIG_ZRAM_BACKEND_LZ4: u32 = 1;
pub const CONFIG_KVM_IOAPIC: u32 = 1;
pub const CONFIG_SPI_ALTERA_MODULE: u32 = 1;
pub const CONFIG_VIRTIO_VDPA_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MT6397_MODULE: u32 = 1;
pub const CONFIG_COMPAT_32BIT_TIME: u32 = 1;
pub const CONFIG_MMA9551_MODULE: u32 = 1;
pub const CONFIG_POWER_RESET_RESTART: u32 = 1;
pub const CONFIG_SENSORS_SCH5627_MODULE: u32 = 1;
pub const CONFIG_HOTPLUG_CPU: u32 = 1;
pub const CONFIG_NFS_FSCACHE: u32 = 1;
pub const CONFIG_INTEL_ATOMISP2_PDX86: u32 = 1;
pub const CONFIG_PAGE_POOL_STATS: u32 = 1;
pub const CONFIG_WANT_DEV_COREDUMP: u32 = 1;
pub const CONFIG_NET_IPGRE_DEMUX_MODULE: u32 = 1;
pub const CONFIG_USB_LIBCOMPOSITE_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MPQ7932_MODULE: u32 = 1;
pub const CONFIG_HAVE_KVM_ARCH_GMEM_POPULATE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_BYT_CHT_DA7213_MACH_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_GF2K_MODULE: u32 = 1;
pub const CONFIG_DVB_PT1_MODULE: u32 = 1;
pub const CONFIG_MISC_ALCOR_PCI_MODULE: u32 = 1;
pub const CONFIG_RANDOMIZE_BASE: u32 = 1;
pub const CONFIG_BHYVE_GUEST: u32 = 1;
pub const CONFIG_INTEGRITY_TRUSTED_KEYRING: u32 = 1;
pub const CONFIG_NET_VENDOR_PENSANDO: u32 = 1;
pub const CONFIG_VIDEO_HI847_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_DFL_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_SM4_AESNI_AVX2_X86_64_MODULE: u32 = 1;
pub const CONFIG_F2FS_FS_ZSTD: u32 = 1;
pub const CONFIG_SENSORS_SCH5636_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_NVME_MODULE: u32 = 1;
pub const CONFIG_MFD_CS47L24: u32 = 1;
pub const CONFIG_BT_HCIUART_AML: u32 = 1;
pub const CONFIG_NET_DSA_VITESSE_VSC73XX_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_SPI_BUTTERFLY_MODULE: u32 = 1;
pub const CONFIG_PHONET_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LM73_MODULE: u32 = 1;
pub const CONFIG_AMDTEE_MODULE: u32 = 1;
pub const CONFIG_EFI_HANDOVER_PROTOCOL: u32 = 1;
pub const CONFIG_DVB_USB_VP7045_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_SET_MEMORY: u32 = 1;
pub const CONFIG_SND_SOC_SDCA_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_DTT200U_MODULE: u32 = 1;
pub const CONFIG_PSTORE_BLK_MAX_REASON: u32 = 2;
pub const CONFIG_HID_CHERRY_MODULE: u32 = 1;
pub const CONFIG_MAC80211_MESH: u32 = 1;
pub const CONFIG_BLK_WBT: u32 = 1;
pub const CONFIG_REGMAP_W1_MODULE: u32 = 1;
pub const CONFIG_SATA_SIS_MODULE: u32 = 1;
pub const CONFIG_TASKS_RUDE_RCU: u32 = 1;
pub const CONFIG_AS21XXX_PHY_MODULE: u32 = 1;
pub const CONFIG_MTD_UBI_WL_THRESHOLD: u32 = 4096;
pub const CONFIG_REGMAP_SOUNDWIRE_MBQ_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_WWAN_MODULE: u32 = 1;
pub const CONFIG_IP_SET_HASH_NETPORT_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SDCA_HID: u32 = 1;
pub const CONFIG_YENTA_ENE_TUNE: u32 = 1;
pub const CONFIG_SERIO_PS2MULT_MODULE: u32 = 1;
pub const CONFIG_PAHOLE_HAS_SPLIT_BTF: u32 = 1;
pub const CONFIG_MFD_TPS65090: u32 = 1;
pub const CONFIG_NET_ACT_SAMPLE_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AK4613_MODULE: u32 = 1;
pub const CONFIG_FXLS8962AF_I2C_MODULE: u32 = 1;
pub const CONFIG_XEN_BALLOON_MEMORY_HOTPLUG: u32 = 1;
pub const CONFIG_USB_ARMLINUX: u32 = 1;
pub const CONFIG_ZEROPLUS_FF: u32 = 1;
pub const CONFIG_HID_KEYTOUCH_MODULE: u32 = 1;
pub const CONFIG_RTW89_8852CE_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_PCM512x_SPI_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_PWM_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AC97_CODEC_MODULE: u32 = 1;
pub const CONFIG_INPUT_ATC260X_ONKEY_MODULE: u32 = 1;
pub const CONFIG_INFINEON_TLV493D_MODULE: u32 = 1;
pub const CONFIG_SMSC_PHY_MODULE: u32 = 1;
pub const CONFIG_GPIO_XRA1403_MODULE: u32 = 1;
pub const CONFIG_BLK_INLINE_ENCRYPTION: u32 = 1;
pub const CONFIG_SND_SOC_DMIC_MODULE: u32 = 1;
pub const CONFIG_AD7293_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_ADDRTYPE_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LTC4260_MODULE: u32 = 1;
pub const CONFIG_CC_CAN_LINK: u32 = 1;
pub const CONFIG_BT_MTKSDIO_MODULE: u32 = 1;
pub const CONFIG_USB_FUNCTIONFS_GENERIC: u32 = 1;
pub const CONFIG_FUNCTION_PADDING_CFI: u32 = 11;
pub const CONFIG_B53_MODULE: u32 = 1;
pub const CONFIG_X86_REROUTE_FOR_BROKEN_BOOT_IRQS: u32 = 1;
pub const CONFIG_JOYSTICK_IFORCE_USB_MODULE: u32 = 1;
pub const CONFIG_MT7925_COMMON_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_MAX98927_MODULE: u32 = 1;
pub const CONFIG_CHARGER_MAX77976_MODULE: u32 = 1;
pub const CONFIG_NF_LOG_IPV6_MODULE: u32 = 1;
pub const CONFIG_CC_HAS_AUTO_VAR_INIT_ZERO_BARE: u32 = 1;
pub const CONFIG_MMC_VUB300_MODULE: u32 = 1;
pub const CONFIG_IPMI_PLAT_DATA: u32 = 1;
pub const CONFIG_SND_AMD_ACP_CONFIG_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_S35390A_MODULE: u32 = 1;
pub const CONFIG_KERNFS: u32 = 1;
pub const CONFIG_DRM_MGAG200_MODULE: u32 = 1;
pub const CONFIG_PARAVIRT_SPINLOCKS: u32 = 1;
pub const CONFIG_SND_SOC_TLV320AIC32X4_MODULE: u32 = 1;
pub const CONFIG_DM_MULTIPATH_HST_MODULE: u32 = 1;
pub const CONFIG_6LOWPAN_NHC_UDP_MODULE: u32 = 1;
pub const CONFIG_SERIO_SERPORT_MODULE: u32 = 1;
pub const CONFIG_ACPI_APEI_MEMORY_FAILURE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_GUNZE_MODULE: u32 = 1;
pub const CONFIG_INPUT_SOC_BUTTON_ARRAY_MODULE: u32 = 1;
pub const CONFIG_RD_XZ: u32 = 1;
pub const CONFIG_HAVE_PAGE_SIZE_4KB: u32 = 1;
pub const CONFIG_DRM_AMDGPU_CIK: u32 = 1;
pub const CONFIG_VIDEO_TW68_MODULE: u32 = 1;
pub const CONFIG_VIDEO_V4L2_I2C: u32 = 1;
pub const CONFIG_ARCH_WANTS_DYNAMIC_TASK_STRUCT: u32 = 1;
pub const CONFIG_IIO_ADIS_LIB_MODULE: u32 = 1;
pub const CONFIG_UIO_PDRV_GENIRQ_MODULE: u32 = 1;
pub const CONFIG_DEFAULT_FQ_CODEL: u32 = 1;
pub const CONFIG_AMD_HSMP_PLAT_MODULE: u32 = 1;
pub const CONFIG_MSDOS_FS_MODULE: u32 = 1;
pub const CONFIG_ADMFM2000_MODULE: u32 = 1;
pub const CONFIG_USB_ULPI_BUS_MODULE: u32 = 1;
pub const CONFIG_PERF_EVENTS_INTEL_RAPL_MODULE: u32 = 1;
pub const CONFIG_DM_EBS_MODULE: u32 = 1;
pub const CONFIG_SECURITY_TOMOYO_POLICY_LOADER: &[u8; 21] = b"/usr/bin/tomoyo-init\0";
pub const CONFIG_ARCH_PKEY_BITS: u32 = 4;
pub const CONFIG_EFI_RUNTIME_MAP: u32 = 1;
pub const CONFIG_JOYSTICK_WARRIOR_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_AEGIS128_AESNI_SSE2_MODULE: u32 = 1;
pub const CONFIG_STM_SOURCE_CONSOLE_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_DMI: u32 = 1;
pub const CONFIG_PCIEAER: u32 = 1;
pub const CONFIG_IP_VS_SH_TAB_BITS: u32 = 8;
pub const CONFIG_BE2NET_SKYHAWK: u32 = 1;
pub const CONFIG_SND_MTPAV_MODULE: u32 = 1;
pub const CONFIG_DVB_S5H1411_MODULE: u32 = 1;
pub const CONFIG_ATH6KL_SDIO_MODULE: u32 = 1;
pub const CONFIG_HAVE_SCHED_AVG_IRQ: u32 = 1;
pub const CONFIG_TI_ADS124S08_MODULE: u32 = 1;
pub const CONFIG_CRC_ITU_T_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_INEXIO_MODULE: u32 = 1;
pub const CONFIG_PFCP_MODULE: u32 = 1;
pub const CONFIG_SCSI_SRP_ATTRS_MODULE: u32 = 1;
pub const CONFIG_SND_ECHO3G_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_QT1050_MODULE: u32 = 1;
pub const CONFIG_PCI_MMCONFIG: u32 = 1;
pub const CONFIG_SSB_SDIOHOST_POSSIBLE: u32 = 1;
pub const CONFIG_RTC_DRV_RX6110_MODULE: u32 = 1;
pub const CONFIG_DEVFREQ_GOV_PERFORMANCE_MODULE: u32 = 1;
pub const CONFIG_SENSORS_UCD9200_MODULE: u32 = 1;
pub const CONFIG_AMD_HSMP_MODULE: u32 = 1;
pub const CONFIG_SENSORS_RM3100_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_RTRS_MODULE: u32 = 1;
pub const CONFIG_MFD_MADERA_MODULE: u32 = 1;
pub const CONFIG_IP_FIB_TRIE_STATS: u32 = 1;
pub const CONFIG_RPMSG_NS_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_MPR121_MODULE: u32 = 1;
pub const CONFIG_PROC_PAGE_MONITOR: u32 = 1;
pub const CONFIG_FUN_ETH_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_SECCOMP_FILTER: u32 = 1;
pub const CONFIG_NET_DSA_TAG_OCELOT_MODULE: u32 = 1;
pub const CONFIG_SPEAKUP_SYNTH_DUMMY_MODULE: u32 = 1;
pub const CONFIG_DEBUG_BUGVERBOSE: u32 = 1;
pub const CONFIG_RUSTC_HAS_FILE_AS_C_STR: u32 = 1;
pub const CONFIG_PLAYSTATION_FF: u32 = 1;
pub const CONFIG_SND_SOC_MAX98373_SDW_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MP2888_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_CPU_ATTACK_VECTORS: u32 = 1;
pub const CONFIG_ATH9K_COMMON_DEBUG: u32 = 1;
pub const CONFIG_EXT4_USE_FOR_EXT2: u32 = 1;
pub const CONFIG_USB_PEGASUS_MODULE: u32 = 1;
pub const CONFIG_PTP_1588_CLOCK_IDTCM_MODULE: u32 = 1;
pub const CONFIG_UIO_PCI_GENERIC_MODULE: u32 = 1;
pub const CONFIG_I2C_SIS630_MODULE: u32 = 1;
pub const CONFIG_SLAB_FREELIST_RANDOM: u32 = 1;
pub const CONFIG_TCG_NSC_MODULE: u32 = 1;
pub const CONFIG_FXAS21002C_SPI_MODULE: u32 = 1;
pub const CONFIG_ARCH_SUSPEND_POSSIBLE: u32 = 1;
pub const CONFIG_USB_IDMOUSE_MODULE: u32 = 1;
pub const CONFIG_X86_AMD_PLATFORM_DEVICE: u32 = 1;
pub const CONFIG_KPROBES: u32 = 1;
pub const CONFIG_TOUCHSCREEN_IQS7211_MODULE: u32 = 1;
pub const CONFIG_RT_MUTEXES: u32 = 1;
pub const CONFIG_UPROBE_EVENTS: u32 = 1;
pub const CONFIG_USB_F_UAC2_MODULE: u32 = 1;
pub const CONFIG_PCI_DOE: u32 = 1;
pub const CONFIG_BLK_CGROUP_IOLATENCY: u32 = 1;
pub const CONFIG_CEC_PIN: u32 = 1;
pub const CONFIG_MFD_WM8997: u32 = 1;
pub const CONFIG_BPF_KPROBE_OVERRIDE: u32 = 1;
pub const CONFIG_INTEL_MEI_PXP_MODULE: u32 = 1;
pub const CONFIG_GENERIC_VDSO_OVERFLOW_PROTECT: u32 = 1;
pub const CONFIG_NET_VENDOR_XIRCOM: u32 = 1;
pub const CONFIG_CHELSIO_T4VF_MODULE: u32 = 1;
pub const CONFIG_NET_IFE_MODULE: u32 = 1;
pub const CONFIG_HVC_XEN: u32 = 1;
pub const CONFIG_CHARGER_AXP20X_MODULE: u32 = 1;
pub const CONFIG_RD_LZ4: u32 = 1;
pub const CONFIG_SND_HDA_SCODEC_CS35L56_SPI_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_EDGEPORT_MODULE: u32 = 1;
pub const CONFIG_PLFXLC_MODULE: u32 = 1;
pub const CONFIG_SECURITY_TOMOYO: u32 = 1;
pub const CONFIG_IPMI_SSIF_MODULE: u32 = 1;
pub const CONFIG_IEEE802154_AT86RF230_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_XRS700X_MDIO_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LIS3_I2C_MODULE: u32 = 1;
pub const CONFIG_DVB_MXL692_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CX231XX_ALSA_MODULE: u32 = 1;
pub const CONFIG_MFD_SY7636A_MODULE: u32 = 1;
pub const CONFIG_DEFAULT_HOSTNAME: &[u8; 10] = b"archlinux\0";
pub const CONFIG_VFIO_PCI_INTX: u32 = 1;
pub const CONFIG_MLX5_MACSEC: u32 = 1;
pub const CONFIG_GENERIC_NET_UTILS: u32 = 1;
pub const CONFIG_REGULATOR_TPS65132_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_SUNRISEPOINT_MODULE: u32 = 1;
pub const CONFIG_USB_CONN_GPIO_MODULE: u32 = 1;
pub const CONFIG_KVM_AMD_SEV: u32 = 1;
pub const CONFIG_LMP91000_MODULE: u32 = 1;
pub const CONFIG_DM_ERA_MODULE: u32 = 1;
pub const CONFIG_RTW88_8812AU_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_RX8010_MODULE: u32 = 1;
pub const CONFIG_GENERIC_ISA_DMA: u32 = 1;
pub const CONFIG_IP_VS_WRR_MODULE: u32 = 1;
pub const CONFIG_SYSFB: u32 = 1;
pub const CONFIG_LEDS_TRIGGER_ONESHOT_MODULE: u32 = 1;
pub const CONFIG_NVDIMM_PFN: u32 = 1;
pub const CONFIG_SECURITY_SELINUX: u32 = 1;
pub const CONFIG_BLK_DEV_DRBD_MODULE: u32 = 1;
pub const CONFIG_INPUT_JOYSTICK: u32 = 1;
pub const CONFIG_BLK_DEV_DM_BUILTIN: u32 = 1;
pub const CONFIG_DRM_DISPLAY_DSC_HELPER: u32 = 1;
pub const CONFIG_MSI_EC_MODULE: u32 = 1;
pub const CONFIG_SMARTJOYPLUS_FF: u32 = 1;
pub const CONFIG_HSU_DMA_MODULE: u32 = 1;
pub const CONFIG_IP5XXX_POWER_MODULE: u32 = 1;
pub const CONFIG_VMWARE_VMCI_MODULE: u32 = 1;
pub const CONFIG_SCSI_LOWLEVEL: u32 = 1;
pub const CONFIG_SENSORS_LM63_MODULE: u32 = 1;
pub const CONFIG_AMILO_RFKILL_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WCD937X_SDW_MODULE: u32 = 1;
pub const CONFIG_INTERVAL_TREE: u32 = 1;
pub const CONFIG_GPIO_TWL6040_MODULE: u32 = 1;
pub const CONFIG_ADIN1110_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_PCF8563_MODULE: u32 = 1;
pub const CONFIG_FUSION_FC_MODULE: u32 = 1;
pub const CONFIG_CLK_TWL_MODULE: u32 = 1;
pub const CONFIG_W1_SLAVE_DS2805_MODULE: u32 = 1;
pub const CONFIG_SPARSEMEM: u32 = 1;
pub const CONFIG_CXL_PMU_MODULE: u32 = 1;
pub const CONFIG_BCACHE_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_ATMEL_SHA204A_MODULE: u32 = 1;
pub const CONFIG_INPUT_IQS7222_MODULE: u32 = 1;
pub const CONFIG_HVC_DRIVER: u32 = 1;
pub const CONFIG_BLK_CGROUP_IOCOST: u32 = 1;
pub const CONFIG_NLS_MAC_GAELIC_MODULE: u32 = 1;
pub const CONFIG_NFP_NET_IPSEC: u32 = 1;
pub const CONFIG_MFD_INTEL_LPSS_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_BROADCOM: u32 = 1;
pub const CONFIG_SPEAKUP_SYNTH_SPKOUT_MODULE: u32 = 1;
pub const CONFIG_RTC_SYSTOHC_DEVICE: &[u8; 5] = b"rtc0\0";
pub const CONFIG_DEV_DAX_HMEM_DEVICES: u32 = 1;
pub const CONFIG_RTC_DRV_RX4581_MODULE: u32 = 1;
pub const CONFIG_INPUT_GPIO_VIBRA_MODULE: u32 = 1;
pub const CONFIG_OSNOISE_TRACER: u32 = 1;
pub const CONFIG_RTC_INTF_PROC: u32 = 1;
pub const CONFIG_USB_CHIPIDEA_NPCM_MODULE: u32 = 1;
pub const CONFIG_RC_LOOPBACK_MODULE: u32 = 1;
pub const CONFIG_AUTOFS_FS: u32 = 1;
pub const CONFIG_AD5791_MODULE: u32 = 1;
pub const CONFIG_DVB_CX24123_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_ALC861_MODULE: u32 = 1;
pub const CONFIG_LD_CAN_USE_KEEP_IN_OVERLAY: u32 = 1;
pub const CONFIG_SND_FIREWORKS_MODULE: u32 = 1;
pub const CONFIG_CHARGER_ISP1704_MODULE: u32 = 1;
pub const CONFIG_I2C_SIMTEC_MODULE: u32 = 1;
pub const CONFIG_IPV6_MROUTE_MULTIPLE_TABLES: u32 = 1;
pub const CONFIG_FUNCTION_PROFILER: u32 = 1;
pub const CONFIG_ACQUIRE_WDT_MODULE: u32 = 1;
pub const CONFIG_BT_BREDR: u32 = 1;
pub const CONFIG_SND_SOC_AUDIO_IIO_AUX_MODULE: u32 = 1;
pub const CONFIG_TYPEC_DP_ALTMODE_MODULE: u32 = 1;
pub const CONFIG_KVM_GUEST_MEMFD: u32 = 1;
pub const CONFIG_XFRM_ESPINTCP: u32 = 1;
pub const CONFIG_LEDS_LP3952_MODULE: u32 = 1;
pub const CONFIG_ARCH_WANTS_NO_INSTR: u32 = 1;
pub const CONFIG_NET_DSA_QCA8K_MODULE: u32 = 1;
pub const CONFIG_USB_HID: u32 = 1;
pub const CONFIG_SMSC911X_MODULE: u32 = 1;
pub const CONFIG_SFC_MCDI_MON: u32 = 1;
pub const CONFIG_MITIGATION_SRSO: u32 = 1;
pub const CONFIG_SND_ES1968_RADIO: u32 = 1;
pub const CONFIG_USB_HSO_MODULE: u32 = 1;
pub const CONFIG_NFT_BRIDGE_REJECT_MODULE: u32 = 1;
pub const CONFIG_GPIO_PCIE_IDIO_24_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_RECONFIG: u32 = 1;
pub const CONFIG_ENS160_MODULE: u32 = 1;
pub const CONFIG_AD9467_MODULE: u32 = 1;
pub const CONFIG_PARMAN_MODULE: u32 = 1;
pub const CONFIG_IIO_BUFFER_CB_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_SKCIPHER2: u32 = 1;
pub const CONFIG_MTD_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LTC4261_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS42L83_MODULE: u32 = 1;
pub const CONFIG_IT87_WDT_MODULE: u32 = 1;
pub const CONFIG_GPIO_NCT6694_MODULE: u32 = 1;
pub const CONFIG_CHARGER_TWL4030_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_SCODEC_TAS2781_MODULE: u32 = 1;
pub const CONFIG_PCI_MSI: u32 = 1;
pub const CONFIG_SRF08_MODULE: u32 = 1;
pub const CONFIG_UBIFS_ATIME_SUPPORT: u32 = 1;
pub const CONFIG_SND_SOC_MAX98373_MODULE: u32 = 1;
pub const CONFIG_RMI4_CORE_MODULE: u32 = 1;
pub const CONFIG_PATA_PDC2027X_MODULE: u32 = 1;
pub const CONFIG_HAVE_GENERIC_VDSO: u32 = 1;
pub const CONFIG_MFD_LM3533_MODULE: u32 = 1;
pub const CONFIG_INTEL_SOC_PMIC_BXTWC_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_PANJIT: u32 = 1;
pub const CONFIG_VIDEO_DW9719_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT5682_I2C_MODULE: u32 = 1;
pub const CONFIG_WLAN_VENDOR_PURELIFI: u32 = 1;
pub const CONFIG_NF_TABLES_ARP: u32 = 1;
pub const CONFIG_TMPFS_POSIX_ACL: u32 = 1;
pub const CONFIG_PCMCIA_XIRCOM_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV08D10_MODULE: u32 = 1;
pub const CONFIG_PCIE_DW_PLAT_HOST: u32 = 1;
pub const CONFIG_MODULES_TREE_LOOKUP: u32 = 1;
pub const CONFIG_GOOGLE_CBMEM_MODULE: u32 = 1;
pub const CONFIG_CGROUP_DMEM: u32 = 1;
pub const CONFIG_SENSORS_ADP1050_REGULATOR: u32 = 1;
pub const CONFIG_FW_LOADER_PAGED_BUF: u32 = 1;
pub const CONFIG_AIC79XX_DEBUG_MASK: u32 = 0;
pub const CONFIG_IRQ_MSI_LIB: u32 = 1;
pub const CONFIG_NILFS2_FS_MODULE: u32 = 1;
pub const CONFIG_IP_VS_PE_SIP_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_KOBIL_SCT_MODULE: u32 = 1;
pub const CONFIG_BATMAN_ADV_MODULE: u32 = 1;
pub const CONFIG_NXP_C45_TJA11XX_PHY_MODULE: u32 = 1;
pub const CONFIG_SATA_INIC162X_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RTQ9128_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_AMD_ACP63_MODULE: u32 = 1;
pub const CONFIG_X86_VMX_FEATURE_NAMES: u32 = 1;
pub const CONFIG_NVMEM_RMEM_MODULE: u32 = 1;
pub const CONFIG_USB_NET_CDC_EEM_MODULE: u32 = 1;
pub const CONFIG_BMI160_I2C_MODULE: u32 = 1;
pub const CONFIG_YOGABOOK_MODULE: u32 = 1;
pub const CONFIG_SND_VIA82XX_MODEM_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_E4000_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DS1286_MODULE: u32 = 1;
pub const CONFIG_INTEGRITY_SIGNATURE: u32 = 1;
pub const CONFIG_STM_SOURCE_FTRACE_MODULE: u32 = 1;
pub const CONFIG_RTL8723AE_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MP8859_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_HDMI_TEGRA_MODULE: u32 = 1;
pub const CONFIG_DRM_CLIENT_DEFAULT_FBDEV: u32 = 1;
pub const CONFIG_SND_AU8820_MODULE: u32 = 1;
pub const CONFIG_SENSORS_TDA38640_REGULATOR: u32 = 1;
pub const CONFIG_CPU_FREQ_GOV_USERSPACE: u32 = 1;
pub const CONFIG_CHELSIO_T4_FCOE: u32 = 1;
pub const CONFIG_BACKLIGHT_LM3533_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_ETT_TC45USB: u32 = 1;
pub const CONFIG_SND_SOC_ADAU1372_SPI_MODULE: u32 = 1;
pub const CONFIG_RTW88_DEBUGFS: u32 = 1;
pub const CONFIG_INPUT_TWL6040_VIBRA_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WSA883X_MODULE: u32 = 1;
pub const CONFIG_SCSI_SYM53C8XX_DEFAULT_TAGS: u32 = 16;
pub const CONFIG_IXGBE_DCA: u32 = 1;
pub const CONFIG_BLK_DEV_NULL_BLK_MODULE: u32 = 1;
pub const CONFIG_IP_VS_PROTO_AH_ESP: u32 = 1;
pub const CONFIG_JOLIET: u32 = 1;
pub const CONFIG_ACPI_THERMAL_REL_MODULE: u32 = 1;
pub const CONFIG_DEVFREQ_THERMAL: u32 = 1;
pub const CONFIG_V4L_MEM2MEM_DRIVERS: u32 = 1;
pub const CONFIG_INTEL_TH_STH_MODULE: u32 = 1;
pub const CONFIG_X86_DIRECT_GBPAGES: u32 = 1;
pub const CONFIG_JOYSTICK_IFORCE_232_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_OCRDMA_MODULE: u32 = 1;
pub const CONFIG_ACPI_TOSHIBA_MODULE: u32 = 1;
pub const CONFIG_EROFS_FS_ZIP: u32 = 1;
pub const CONFIG_DVB_S5H1409_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LM83_MODULE: u32 = 1;
pub const CONFIG_SQUASHFS_DECOMP_MULTI_PERCPU: u32 = 1;
pub const CONFIG_B43LEGACY_PIO: u32 = 1;
pub const CONFIG_HAVE_DYNAMIC_FTRACE_WITH_DIRECT_CALLS: u32 = 1;
pub const CONFIG_ARCH_HAS_PREEMPT_LAZY: u32 = 1;
pub const CONFIG_SERIAL_8250_DW_MODULE: u32 = 1;
pub const CONFIG_SFC_FALCON_MODULE: u32 = 1;
pub const CONFIG_MFD_AAT2870_CORE: u32 = 1;
pub const CONFIG_ACENIC_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX16601_MODULE: u32 = 1;
pub const CONFIG_SPI_DW_MMIO_MODULE: u32 = 1;
pub const CONFIG_MD_RAID456_MODULE: u32 = 1;
pub const CONFIG_I6300ESB_WDT_MODULE: u32 = 1;
pub const CONFIG_PATA_PDC_OLD_MODULE: u32 = 1;
pub const CONFIG_MMC_WBSD_MODULE: u32 = 1;
pub const CONFIG_HW_RANDOM_TPM: u32 = 1;
pub const CONFIG_COMPAT_FOR_U64_ALIGNMENT: u32 = 1;
pub const CONFIG_ILLEGAL_POINTER_VALUE: i64 = -2401263026318606336;
pub const CONFIG_HI8435_MODULE: u32 = 1;
pub const CONFIG_IWLEGACY_DEBUG: u32 = 1;
pub const CONFIG_INPUT_MATRIXKMAP_MODULE: u32 = 1;
pub const CONFIG_CEPH_LIB_PRETTYDEBUG: u32 = 1;
pub const CONFIG_IP_NF_MATCH_AH_MODULE: u32 = 1;
pub const CONFIG_GROUP_SCHED_WEIGHT: u32 = 1;
pub const CONFIG_MEDIA_TUNER_SIMPLE_MODULE: u32 = 1;
pub const CONFIG_UPROBES: u32 = 1;
pub const CONFIG_TOUCHSCREEN_CYTTSP_CORE_MODULE: u32 = 1;
pub const CONFIG_VP_VDPA_MODULE: u32 = 1;
pub const CONFIG_DW_XDATA_PCIE_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_MAX8907_MODULE: u32 = 1;
pub const CONFIG_AD525X_DPOT_MODULE: u32 = 1;
pub const CONFIG_ADIS16400_MODULE: u32 = 1;
pub const CONFIG_ARCH_CORRECT_STACKTRACE_ON_KRETPROBE: u32 = 1;
pub const CONFIG_NFT_NAT_MODULE: u32 = 1;
pub const CONFIG_ZSWAP_COMPRESSOR_DEFAULT: &[u8; 5] = b"zstd\0";
pub const CONFIG_VIDEO_CS53L32A_MODULE: u32 = 1;
pub const CONFIG_MAX31827_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_LUNARLAKE_MODULE: u32 = 1;
pub const CONFIG_VFIO_MDEV_MODULE: u32 = 1;
pub const CONFIG_NXP_TJA11XX_PHY_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MAX8998_MODULE: u32 = 1;
pub const CONFIG_NF_CONNTRACK_ZONES: u32 = 1;
pub const CONFIG_LEGACY_VSYSCALL_XONLY: u32 = 1;
pub const CONFIG_DRM_CLIENT: u32 = 1;
pub const CONFIG_SCSI_AM53C974_MODULE: u32 = 1;
pub const CONFIG_MFD_SMPRO_MODULE: u32 = 1;
pub const CONFIG_USB_UHCI_HCD: u32 = 1;
pub const CONFIG_SENSORS_VIA686A_MODULE: u32 = 1;
pub const CONFIG_MT76x0E_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_MULTIPORT_MODULE: u32 = 1;
pub const CONFIG_EROFS_FS_PCPU_KTHREAD: u32 = 1;
pub const CONFIG_CRYPTO_NHPOLY1305_MODULE: u32 = 1;
pub const CONFIG_IIO_KX022A_I2C_MODULE: u32 = 1;
pub const CONFIG_GENERIC_PHY: u32 = 1;
pub const CONFIG_FCOE_MODULE: u32 = 1;
pub const CONFIG_HYPERV_IOMMU: u32 = 1;
pub const CONFIG_XILINX_SDFEC_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_LIMIT_MODULE: u32 = 1;
pub const CONFIG_IPV6_MROUTE: u32 = 1;
pub const CONFIG_USB_RAINSHADOW_CEC_MODULE: u32 = 1;
pub const CONFIG_INET6_TUNNEL_MODULE: u32 = 1;
pub const CONFIG_OCFS2_FS_STATS: u32 = 1;
pub const CONFIG_GUEST_PERF_EVENTS: u32 = 1;
pub const CONFIG_SCSI_ADVANSYS_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_SERPENT_AVX2_X86_64_MODULE: u32 = 1;
pub const CONFIG_MCP4728_MODULE: u32 = 1;
pub const CONFIG_XEN_FBDEV_FRONTEND_MODULE: u32 = 1;
pub const CONFIG_MPL3115_MODULE: u32 = 1;
pub const CONFIG_DVB_BT8XX_MODULE: u32 = 1;
pub const CONFIG_VIDEO_ET8EK8_MODULE: u32 = 1;
pub const CONFIG_MT7925U_MODULE: u32 = 1;
pub const CONFIG_IWL3945_MODULE: u32 = 1;
pub const CONFIG_USB_EHCI_FSL_MODULE: u32 = 1;
pub const CONFIG_DUMMY_CONSOLE: u32 = 1;
pub const CONFIG_MFD_TI_LMU_MODULE: u32 = 1;
pub const CONFIG_RTL_CARDS_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_TURBOGRAFX_MODULE: u32 = 1;
pub const CONFIG_VFIO_PCI_IGD: u32 = 1;
pub const CONFIG_PANTHERLORD_FF: u32 = 1;
pub const CONFIG_DVB_TUNER_DIB0090_MODULE: u32 = 1;
pub const CONFIG_USB_F_TCM_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_TRACEHOOK: u32 = 1;
pub const CONFIG_IXGBE_HWMON: u32 = 1;
pub const CONFIG_X86_INTEL_PSTATE: u32 = 1;
pub const CONFIG_ACPI_FPDT: u32 = 1;
pub const CONFIG_CRYPTO_DEV_AMLOGIC_GXL_MODULE: u32 = 1;
pub const CONFIG_DVB_PT3_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_SMSC_LAN9303_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_XR_MODULE: u32 = 1;
pub const CONFIG_IPE_PROP_FS_VERITY_BUILTIN_SIG: u32 = 1;
pub const CONFIG_IP_SET_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS530X_MODULE: u32 = 1;
pub const CONFIG_IP_SET_BITMAP_PORT_MODULE: u32 = 1;
pub const CONFIG_ACPI_APEI: u32 = 1;
pub const CONFIG_TCP_CONG_NV_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_ACP_MODULE: u32 = 1;
pub const CONFIG_AD8801_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CCS_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_TCPMSS_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_WILCO_EC_MODULE: u32 = 1;
pub const CONFIG_SLHC_MODULE: u32 = 1;
pub const CONFIG_VIDEO_WM8775_MODULE: u32 = 1;
pub const CONFIG_SLUB_DEBUG: u32 = 1;
pub const CONFIG_SND_SOC_SRC4XXX_MODULE: u32 = 1;
pub const CONFIG_PPS_CLIENT_LDISC_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_SQ905_MODULE: u32 = 1;
pub const CONFIG_EDAC_SCRUB: u32 = 1;
pub const CONFIG_CCS811_MODULE: u32 = 1;
pub const CONFIG_W1_MASTER_MATROX_MODULE: u32 = 1;
pub const CONFIG_BACKLIGHT_MAX8925_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_GENERAL_TOUCH: u32 = 1;
pub const CONFIG_SND_SOC_CS35L41_I2C_MODULE: u32 = 1;
pub const CONFIG_DVB_CX24120_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_MCP23S08_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_TAG_RZN1_A5PSW_MODULE: u32 = 1;
pub const CONFIG_ATH10K_SDIO_MODULE: u32 = 1;
pub const CONFIG_EFI_CAPSULE_LOADER_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_DIBUSB_MB_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_CFM: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SST_TOPLEVEL: u32 = 1;
pub const CONFIG_BAREUDP_MODULE: u32 = 1;
pub const CONFIG_PATA_HPT37X_MODULE: u32 = 1;
pub const CONFIG_LEDS_BLINKM_MODULE: u32 = 1;
pub const CONFIG_SFC_MODULE: u32 = 1;
pub const CONFIG_RADIO_TEA575X_MODULE: u32 = 1;
pub const CONFIG_MMC_RICOH_MMC: u32 = 1;
pub const CONFIG_CRYPTO_SHA256: u32 = 1;
pub const CONFIG_DRM_XE_TIMESLICE_MAX: u32 = 10000000;
pub const CONFIG_MCTP_FLOWS: u32 = 1;
pub const CONFIG_ATH10K_MODULE: u32 = 1;
pub const CONFIG_SND_CTL_LED_MODULE: u32 = 1;
pub const CONFIG_NUMA_BALANCING: u32 = 1;
pub const CONFIG_VIRTIO_MMIO_CMDLINE_DEVICES: u32 = 1;
pub const CONFIG_HAVE_BUILDTIME_MCOUNT_SORT: u32 = 1;
pub const CONFIG_ATM_LANE_MODULE: u32 = 1;
pub const CONFIG_FWCTL_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_KONICA_MODULE: u32 = 1;
pub const CONFIG_NET_EMATCH_CMP_MODULE: u32 = 1;
pub const CONFIG_QUOTACTL: u32 = 1;
pub const CONFIG_BRIDGE_NF_EBTABLES_MODULE: u32 = 1;
pub const CONFIG_EXFAT_DEFAULT_IOCHARSET: &[u8; 5] = b"utf8\0";
pub const CONFIG_VIDEOBUF2_V4L2_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_ARC: u32 = 1;
pub const CONFIG_WIL6210_DEBUGFS: u32 = 1;
pub const CONFIG_BT_HCIUART_BCM: u32 = 1;
pub const CONFIG_NET_VENDOR_NVIDIA: u32 = 1;
pub const CONFIG_UNIX: u32 = 1;
pub const CONFIG_CEC_SECO_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_M88RS6000T_MODULE: u32 = 1;
pub const CONFIG_IRQ_WORK: u32 = 1;
pub const CONFIG_IPV6_RPL_LWTUNNEL: u32 = 1;
pub const CONFIG_ARCH_ENABLE_MEMORY_HOTREMOVE: u32 = 1;
pub const CONFIG_SND_SOC_WSA884X_MODULE: u32 = 1;
pub const CONFIG_SATA_DWC_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_COMMENT_MODULE: u32 = 1;
pub const CONFIG_INPUT_APANEL_MODULE: u32 = 1;
pub const CONFIG_EROFS_FS_XATTR: u32 = 1;
pub const CONFIG_SMSC37B787_WDT_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_LIB_SHA256_ARCH: u32 = 1;
pub const CONFIG_CRYPTO_LIB_CURVE25519_GENERIC: u32 = 1;
pub const CONFIG_TRACING_MAP: u32 = 1;
pub const CONFIG_NLS_MAC_CROATIAN_MODULE: u32 = 1;
pub const CONFIG_SCSI_HPSA_MODULE: u32 = 1;
pub const CONFIG_APPLE_GMUX_MODULE: u32 = 1;
pub const CONFIG_HYPERVISOR_GUEST: u32 = 1;
pub const CONFIG_BT_HCIBT3C_MODULE: u32 = 1;
pub const CONFIG_XEN_HAVE_VPMU: u32 = 1;
pub const CONFIG_PWM_LP3943_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_TPROXY_MODULE: u32 = 1;
pub const CONFIG_DUMMY_CONSOLE_COLUMNS: u32 = 80;
pub const CONFIG_MENF21BMC_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_SUNGEM_MODULE: u32 = 1;
pub const CONFIG_NF_LOG_IPV4_MODULE: u32 = 1;
pub const CONFIG_TLS_MODULE: u32 = 1;
pub const CONFIG_PCI_HYPERV_INTERFACE_MODULE: u32 = 1;
pub const CONFIG_NET_DEVMEM: u32 = 1;
pub const CONFIG_ATH9K_PCI: u32 = 1;
pub const CONFIG_B43LEGACY_LEDS: u32 = 1;
pub const CONFIG_SND_INTEL8X0_MODULE: u32 = 1;
pub const CONFIG_TCP_CONG_HTCP_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_NI_MODULE: u32 = 1;
pub const CONFIG_CAN_SJA1000_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_SND_LAYLA24_MODULE: u32 = 1;
pub const CONFIG_HID_PICOLCD_BACKLIGHT: u32 = 1;
pub const CONFIG_STACKTRACE: u32 = 1;
pub const CONFIG_AD7280_MODULE: u32 = 1;
pub const CONFIG_WCN36XX_MODULE: u32 = 1;
pub const CONFIG_SND_DICE_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_CINERGY_T2_MODULE: u32 = 1;
pub const CONFIG_BT_HCIBTUSB_AUTOSUSPEND: u32 = 1;
pub const CONFIG_TYPHOON_MODULE: u32 = 1;
pub const CONFIG_8139TOO_8129: u32 = 1;
pub const CONFIG_X86_NEED_RELOCS: u32 = 1;
pub const CONFIG_PINCTRL_SX150X: u32 = 1;
pub const CONFIG_6LOWPAN_NHC_HOP_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_TRANSPARENT_HUGEPAGE_PUD: u32 = 1;
pub const CONFIG_NET_IEEE8021Q_HELPERS: u32 = 1;
pub const CONFIG_COMPAT_32: u32 = 1;
pub const CONFIG_TUN_MODULE: u32 = 1;
pub const CONFIG_SCSI_IPR_DUMP: u32 = 1;
pub const CONFIG_SCA3000_MODULE: u32 = 1;
pub const CONFIG_CAN_CC770_MODULE: u32 = 1;
pub const CONFIG_INTEL_TPMI_POWER_DOMAINS_MODULE: u32 = 1;
pub const CONFIG_NET_CLS_BASIC_MODULE: u32 = 1;
pub const CONFIG_TCP_CONG_LP_MODULE: u32 = 1;
pub const CONFIG_ADF4350_MODULE: u32 = 1;
pub const CONFIG_CAN_M_CAN_TCAN4X5X_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_TECHNISAT_USB2_MODULE: u32 = 1;
pub const CONFIG_CLKEVT_I8253: u32 = 1;
pub const CONFIG_SATA_QSTOR_MODULE: u32 = 1;
pub const CONFIG_ARCH_USE_SYM_ANNOTATIONS: u32 = 1;
pub const CONFIG_XEN_VIRTIO: u32 = 1;
pub const CONFIG_RTC_DRV_RV3029_HWMON: u32 = 1;
pub const CONFIG_DRM_CLIENT_LOG: u32 = 1;
pub const CONFIG_SENSORS_IBMPEX_MODULE: u32 = 1;
pub const CONFIG_MAC80211_DEBUGFS: u32 = 1;
pub const CONFIG_USB_G_NOKIA_MODULE: u32 = 1;
pub const CONFIG_SOUNDWIRE_CADENCE_MODULE: u32 = 1;
pub const CONFIG_B43LEGACY_DEBUG: u32 = 1;
pub const CONFIG_IXGBE_DCB: u32 = 1;
pub const CONFIG_MOUSE_BCM5974_MODULE: u32 = 1;
pub const CONFIG_ATH5K_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX6639_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX31790_MODULE: u32 = 1;
pub const CONFIG_SERIAL_ALTERA_UART_MAXPORTS: u32 = 4;
pub const CONFIG_CRYPTO_XCBC_MODULE: u32 = 1;
pub const CONFIG_GPIO_WM831X_MODULE: u32 = 1;
pub const CONFIG_MFD_MADERA_I2C_MODULE: u32 = 1;
pub const CONFIG_AR5523_MODULE: u32 = 1;
pub const CONFIG_MLX4_CORE_GEN2: u32 = 1;
pub const CONFIG_CROS_EC_DEBUGFS_MODULE: u32 = 1;
pub const CONFIG_CHROMEOS_TBMC_MODULE: u32 = 1;
pub const CONFIG_HW_RANDOM: u32 = 1;
pub const CONFIG_GPIO_FXL6408_MODULE: u32 = 1;
pub const CONFIG_CPU_IDLE_GOV_HALTPOLL: u32 = 1;
pub const CONFIG_IP_NF_TARGET_MASQUERADE_MODULE: u32 = 1;
pub const CONFIG_RCU_NEED_SEGCBLIST: u32 = 1;
pub const CONFIG_SND_SOC_WM8940_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LM80_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_TAG_BRCM_LEGACY_FCS_MODULE: u32 = 1;
pub const CONFIG_SENSORS_INA233_MODULE: u32 = 1;
pub const CONFIG_USB_NET_CX82310_ETH_MODULE: u32 = 1;
pub const CONFIG_AD5755_MODULE: u32 = 1;
pub const CONFIG_RUSTC_HAS_COERCE_POINTEE: u32 = 1;
pub const CONFIG_BT_QCA_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_RV8803_MODULE: u32 = 1;
pub const CONFIG_SLIP_SMART: u32 = 1;
pub const CONFIG_NEED_DMA_MAP_STATE: u32 = 1;
pub const CONFIG_BT_MTKUART_MODULE: u32 = 1;
pub const CONFIG_TCM_FC_MODULE: u32 = 1;
pub const CONFIG_UBIFS_FS_MODULE: u32 = 1;
pub const CONFIG_NFC_FDP_MODULE: u32 = 1;
pub const CONFIG_RCU_EXP_CPU_STALL_TIMEOUT: u32 = 0;
pub const CONFIG_KEYBOARD_MTK_PMIC_MODULE: u32 = 1;
pub const CONFIG_MOUSE_PS2_LIFEBOOK: u32 = 1;
pub const CONFIG_ZL3073X_MODULE: u32 = 1;
pub const CONFIG_MODULE_SIG_KEY: &[u8; 22] = b"certs/signing_key.pem\0";
pub const CONFIG_ARCH_MMAP_RND_BITS_MIN: u32 = 28;
pub const CONFIG_ARCH_WANT_OPTIMIZE_DAX_VMEMMAP: u32 = 1;
pub const CONFIG_ISA_BUS_API: u32 = 1;
pub const CONFIG_USB_SERIAL_SYMBOL_MODULE: u32 = 1;
pub const CONFIG_OPENVSWITCH_VXLAN_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_BLAKE2B: u32 = 1;
pub const CONFIG_DEBUG_SHIRQ: u32 = 1;
pub const CONFIG_NVDIMM_DAX: u32 = 1;
pub const CONFIG_AMD_HFI: u32 = 1;
pub const CONFIG_SENSORS_PLI1209BC_MODULE: u32 = 1;
pub const CONFIG_GFS2_FS_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_ADDR_TRANS_CONFIGFS: u32 = 1;
pub const CONFIG_UIO_DFL_MODULE: u32 = 1;
pub const CONFIG_ATA_FORCE: u32 = 1;
pub const CONFIG_NET_VENDOR_DEC: u32 = 1;
pub const CONFIG_IP_SET_HASH_IPMAC_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_MAX98373_I2C_MODULE: u32 = 1;
pub const CONFIG_SND_ES1968_INPUT: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_CA0132_DSP: u32 = 1;
pub const CONFIG_SENSORS_DS1621_MODULE: u32 = 1;
pub const CONFIG_RT2800USB_UNKNOWN: u32 = 1;
pub const CONFIG_SYSVIPC: u32 = 1;
pub const CONFIG_LOCKDEP_SUPPORT: u32 = 1;
pub const CONFIG_PHY_QCOM_USB_HS_MODULE: u32 = 1;
pub const CONFIG_NFT_FIB_IPV6_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_TDA18250_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_QM1D1B0004_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_NETERION: u32 = 1;
pub const CONFIG_IIO_ST_GYRO_3AXIS_MODULE: u32 = 1;
pub const CONFIG_BT_HCIUART_LL: u32 = 1;
pub const CONFIG_AD5933_MODULE: u32 = 1;
pub const CONFIG_TCP_SIGPOOL: u32 = 1;
pub const CONFIG_PINCTRL_CEDARFORK_MODULE: u32 = 1;
pub const CONFIG_RT2X00_LIB_PCI_MODULE: u32 = 1;
pub const CONFIG_FIREWIRE_NOSY_MODULE: u32 = 1;
pub const CONFIG_LTC2632_MODULE: u32 = 1;
pub const CONFIG_FSCACHE: u32 = 1;
pub const CONFIG_SND_SOC_TAS5086_MODULE: u32 = 1;
pub const CONFIG_MFD_SM501_MODULE: u32 = 1;
pub const CONFIG_DM_INTEGRITY_MODULE: u32 = 1;
pub const CONFIG_USB_CONFIGFS_MODULE: u32 = 1;
pub const CONFIG_USB_F_ECM_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_VMWARE_PVRDMA_MODULE: u32 = 1;
pub const CONFIG_X86_PKG_TEMP_THERMAL_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_INTEL_APL_MODULE: u32 = 1;
pub const CONFIG_MEDIA_SUPPORT_FILTER: u32 = 1;
pub const CONFIG_BATTERY_CHAGALL_MODULE: u32 = 1;
pub const CONFIG_CRYPTO: u32 = 1;
pub const CONFIG_NF_TABLES_BRIDGE_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_ELFCORE_COMPAT: u32 = 1;
pub const CONFIG_DELL_SMO8800_MODULE: u32 = 1;
pub const CONFIG_PCIEAER_CXL: u32 = 1;
pub const CONFIG_PARAVIRT: u32 = 1;
pub const CONFIG_HID_ELECOM_MODULE: u32 = 1;
pub const CONFIG_FPGA_M10_BMC_SEC_UPDATE_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_SECCOMP: u32 = 1;
pub const CONFIG_PATA_PARPORT_FRIQ_MODULE: u32 = 1;
pub const CONFIG_DVB_TUNER_CX24113_MODULE: u32 = 1;
pub const CONFIG_IOMMU_IOPF: u32 = 1;
pub const CONFIG_HID_MCP2221_MODULE: u32 = 1;
pub const CONFIG_VFIO_GROUP: u32 = 1;
pub const CONFIG_VIDEO_OV9640_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_MT6351_MODULE: u32 = 1;
pub const CONFIG_TI_ADC081C_MODULE: u32 = 1;
pub const CONFIG_USB_ISP1760_DUAL_ROLE: u32 = 1;
pub const CONFIG_SENSORS_LM70_MODULE: u32 = 1;
pub const CONFIG_BATTERY_88PM860X_MODULE: u32 = 1;
pub const CONFIG_VIDEO_VIVID_MAX_DEVS: u32 = 64;
pub const CONFIG_NFC_MICROREAD_MEI_MODULE: u32 = 1;
pub const CONFIG_BLK_CGROUP_FC_APPID: u32 = 1;
pub const CONFIG_PROC_FS: u32 = 1;
pub const CONFIG_SPI_CS42L43_MODULE: u32 = 1;
pub const CONFIG_USB_ALI_M5632: u32 = 1;
pub const CONFIG_RSI_SDIO_MODULE: u32 = 1;
pub const CONFIG_HAVE_UACCESS_VALIDATION: u32 = 1;
pub const CONFIG_VIDEO_OV2740_MODULE: u32 = 1;
pub const CONFIG_SND_CTL_FAST_LOOKUP: u32 = 1;
pub const CONFIG_DVB_USB_DIBUSB_MC_MODULE: u32 = 1;
pub const CONFIG_TXGBE_MODULE: u32 = 1;
pub const CONFIG_ARCH_USE_MEMREMAP_PROT: u32 = 1;
pub const CONFIG_BMA220_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX16064_MODULE: u32 = 1;
pub const CONFIG_CROS_EC_LPC_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS35L56_SDW_MODULE: u32 = 1;
pub const CONFIG_DEBUG_INFO_COMPRESSED_NONE: u32 = 1;
pub const CONFIG_CRYPTO_MICHAEL_MIC_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_ATMEL_ECC_MODULE: u32 = 1;
pub const CONFIG_PM_DEVFREQ: u32 = 1;
pub const CONFIG_DRM_CLIENT_SELECTION: u32 = 1;
pub const CONFIG_SENSORS_F71805F_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_TEHUTI: u32 = 1;
pub const CONFIG_NF_CT_PROTO_SCTP: u32 = 1;
pub const CONFIG_BLK_DEV_PMEM_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_SPCA508_MODULE: u32 = 1;
pub const CONFIG_SX_COMMON_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS53L30_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_CS47L85: u32 = 1;
pub const CONFIG_MITIGATION_UNRET_ENTRY: u32 = 1;
pub const CONFIG_BPF_EVENTS: u32 = 1;
pub const CONFIG_GENERIC_ENTRY: u32 = 1;
pub const CONFIG_MEDIA_PLATFORM_SUPPORT: u32 = 1;
pub const CONFIG_X86_DISABLED_FEATURE_CENTAUR_MCR: u32 = 1;
pub const CONFIG_TMPFS_QUOTA: u32 = 1;
pub const CONFIG_VIDEO_VISL_MODULE: u32 = 1;
pub const CONFIG_POSIX_TIMERS: u32 = 1;
pub const CONFIG_HID_BELKIN_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_CPU_FINALIZE_INIT: u32 = 1;
pub const CONFIG_DVB_ISL6421_MODULE: u32 = 1;
pub const CONFIG_UIO_CIF_MODULE: u32 = 1;
pub const CONFIG_SND_OXYGEN_MODULE: u32 = 1;
pub const CONFIG_I2C_ATR_MODULE: u32 = 1;
pub const CONFIG_MITIGATION_ITS: u32 = 1;
pub const CONFIG_PROC_CPU_RESCTRL: u32 = 1;
pub const CONFIG_USB_SERIAL_KLSI_MODULE: u32 = 1;
pub const CONFIG_ADVANTECH_WDT_MODULE: u32 = 1;
pub const CONFIG_LEDS_TI_LMU_COMMON_MODULE: u32 = 1;
pub const CONFIG_BME680_MODULE: u32 = 1;
pub const CONFIG_PCS_LYNX_MODULE: u32 = 1;
pub const CONFIG_HAVE_FTRACE_REGS_HAVING_PT_REGS: u32 = 1;
pub const CONFIG_RPMSG_VIRTIO_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_AD7879_SPI_MODULE: u32 = 1;
pub const CONFIG_NOP_USB_XCEIV_MODULE: u32 = 1;
pub const CONFIG_GENERIC_TRACER: u32 = 1;
pub const CONFIG_NET_DSA_MT7530_MDIO_MODULE: u32 = 1;
pub const CONFIG_ATA_GENERIC_MODULE: u32 = 1;
pub const CONFIG_I2C_I801_MODULE: u32 = 1;
pub const CONFIG_CPU_SUP_ZHAOXIN: u32 = 1;
pub const CONFIG_KS8842_MODULE: u32 = 1;
pub const CONFIG_SQUASHFS_XZ: u32 = 1;
pub const CONFIG_INTEL_PLR_TPMI_MODULE: u32 = 1;
pub const CONFIG_SCSI_SMARTPQI_MODULE: u32 = 1;
pub const CONFIG_CC_HAS_COUNTED_BY: u32 = 1;
pub const CONFIG_PPP_ASYNC_MODULE: u32 = 1;
pub const CONFIG_S2IO_MODULE: u32 = 1;
pub const CONFIG_DVB_MAX_ADAPTERS: u32 = 16;
pub const CONFIG_INPUT_PCAP_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_SIS: u32 = 1;
pub const CONFIG_BCMA_BLOCKIO: u32 = 1;
pub const CONFIG_V4L2_MEM2MEM_DEV_MODULE: u32 = 1;
pub const CONFIG_KERNEL_ZSTD: u32 = 1;
pub const CONFIG_LEDS_REGULATOR_MODULE: u32 = 1;
pub const CONFIG_SENSEAIR_SUNRISE_CO2_MODULE: u32 = 1;
pub const CONFIG_NOUVEAU_DEBUG_DEFAULT: u32 = 3;
pub const CONFIG_RTC_DRV_RS5C372_MODULE: u32 = 1;
pub const CONFIG_XFRM_AH_MODULE: u32 = 1;
pub const CONFIG_DVB_DIB8000_MODULE: u32 = 1;
pub const CONFIG_EFI_BOOTLOADER_CONTROL_MODULE: u32 = 1;
pub const CONFIG_INET_DIAG_MODULE: u32 = 1;
pub const CONFIG_OVERLAY_FS_INDEX: u32 = 1;
pub const CONFIG_JOYSTICK_A3D_MODULE: u32 = 1;
pub const CONFIG_ATM_ENI_MODULE: u32 = 1;
pub const CONFIG_SMB_SERVER_SMBDIRECT: u32 = 1;
pub const CONFIG_INPUT_88PM80X_ONKEY_MODULE: u32 = 1;
pub const CONFIG_FS_IOMAP: u32 = 1;
pub const CONFIG_DRM_PANEL_AUO_A030JTN01_MODULE: u32 = 1;
pub const CONFIG_FB_IOMEM_HELPERS: u32 = 1;
pub const CONFIG_USB_R8A66597_MODULE: u32 = 1;
pub const CONFIG_NATIONAL_PHY_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MLXREG_FAN_MODULE: u32 = 1;
pub const CONFIG_DRM_QXL_MODULE: u32 = 1;
pub const CONFIG_INPUT_VIVALDIFMAP: u32 = 1;
pub const CONFIG_CHARGER_CROS_USBPD_MODULE: u32 = 1;
pub const CONFIG_SCSI_IMM_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_DTCS033_MODULE: u32 = 1;
pub const CONFIG_IP_VS_PROTO_TCP: u32 = 1;
pub const CONFIG_8139TOO_TUNE_TWISTER: u32 = 1;
pub const CONFIG_USB_GL860_MODULE: u32 = 1;
pub const CONFIG_ALLOW_DEV_COREDUMP: u32 = 1;
pub const CONFIG_ASN1: u32 = 1;
pub const CONFIG_NF_NAT_PPTP_MODULE: u32 = 1;
pub const CONFIG_STAGING_MEDIA: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_ES8336_MODULE: u32 = 1;
pub const CONFIG_RAID_ATTRS_MODULE: u32 = 1;
pub const CONFIG_MMC_CQHCI_MODULE: u32 = 1;
pub const CONFIG_SND_ASIHPI_MODULE: u32 = 1;
pub const CONFIG_AD5624R_SPI_MODULE: u32 = 1;
pub const CONFIG_DEVTMPFS_MOUNT: u32 = 1;
pub const CONFIG_REGULATOR_BD9571MWV_MODULE: u32 = 1;
pub const CONFIG_NFC_ST21NFCA_I2C_MODULE: u32 = 1;
pub const CONFIG_FIREWIRE_NET_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_DMA_OPS: u32 = 1;
pub const CONFIG_HID_LOGITECH_DJ_MODULE: u32 = 1;
pub const CONFIG_SND_PCMCIA: u32 = 1;
pub const CONFIG_LEDS_MT6370_FLASH_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_EDGEPORT_TI_MODULE: u32 = 1;
pub const CONFIG_CONSOLE_LOGLEVEL_QUIET: u32 = 1;
pub const CONFIG_AD5592R_BASE_MODULE: u32 = 1;
pub const CONFIG_ACPI_PCC: u32 = 1;
pub const CONFIG_SERIO_GPIO_PS2_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_NFLOG_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_IAA_CRYPTO_MODULE: u32 = 1;
pub const CONFIG_SCSI_EFCT_MODULE: u32 = 1;
pub const CONFIG_USB_ETH_MODULE: u32 = 1;
pub const CONFIG_XILINX_PR_DECOUPLER_MODULE: u32 = 1;
pub const CONFIG_INET_TUNNEL_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_NAU8822_MODULE: u32 = 1;
pub const CONFIG_MLX5_EN_PSP: u32 = 1;
pub const CONFIG_XEN_SYS_HYPERVISOR: u32 = 1;
pub const CONFIG_W1_MASTER_AMD_AXI_MODULE: u32 = 1;
pub const CONFIG_VIDEO_WM8739_MODULE: u32 = 1;
pub const CONFIG_ATH10K_DEBUG: u32 = 1;
pub const CONFIG_HTE: u32 = 1;
pub const CONFIG_SONYPI_COMPAT: u32 = 1;
pub const CONFIG_IEEE802154_CA8210_MODULE: u32 = 1;
pub const CONFIG_LZO_DECOMPRESS: u32 = 1;
pub const CONFIG_DM_UNSTRIPED_MODULE: u32 = 1;
pub const CONFIG_VIRTIO_VSOCKETS_MODULE: u32 = 1;
pub const CONFIG_NUMA_MEMBLKS: u32 = 1;
pub const CONFIG_JUMP_LABEL: u32 = 1;
pub const CONFIG_GENERIC_SMP_IDLE_THREAD: u32 = 1;
pub const CONFIG_DRM_PANIC_SCREEN_QR_CODE_URL: &[u8; 42] =
    b"https://panic.archlinux.org/panic_report#\0";
pub const CONFIG_USB_ARCH_HAS_HCD: u32 = 1;
pub const CONFIG_GPIO_TPS65086_MODULE: u32 = 1;
pub const CONFIG_REED_SOLOMON_ENC8: u32 = 1;
pub const CONFIG_NET_EMATCH_STACK: u32 = 32;
pub const CONFIG_NF_NAT_FTP_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_AEGIS128_MODULE: u32 = 1;
pub const CONFIG_XEN_PVCALLS_FRONTEND_MODULE: u32 = 1;
pub const CONFIG_DPOT_DAC_MODULE: u32 = 1;
pub const CONFIG_LDM_PARTITION: u32 = 1;
pub const CONFIG_INPUT_WM831X_ON_MODULE: u32 = 1;
pub const CONFIG_EEPROM_EE1004_MODULE: u32 = 1;
pub const CONFIG_IAVF_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_AD7879_I2C_MODULE: u32 = 1;
pub const CONFIG_VIDEO_UDA1342_MODULE: u32 = 1;
pub const CONFIG_ARCH_MMAP_RND_COMPAT_BITS_MIN: u32 = 8;
pub const CONFIG_NET_EMATCH_CANID_MODULE: u32 = 1;
pub const CONFIG_RTC_HCTOSYS: u32 = 1;
pub const CONFIG_DRM_PIXPAPER_MODULE: u32 = 1;
pub const CONFIG_EXTRA_FIRMWARE: &[u8; 1] = b"\0";
pub const CONFIG_IP_MULTICAST: u32 = 1;
pub const CONFIG_SCSI_PPA_MODULE: u32 = 1;
pub const CONFIG_DVB_BUDGET_MODULE: u32 = 1;
pub const CONFIG_MFD_WM8994_MODULE: u32 = 1;
pub const CONFIG_SERIAL_MULTI_INSTANTIATE_MODULE: u32 = 1;
pub const CONFIG_NFC_ST_NCI_MODULE: u32 = 1;
pub const CONFIG_PNPACPI: u32 = 1;
pub const CONFIG_ASYMMETRIC_PUBLIC_KEY_SUBTYPE: u32 = 1;
pub const CONFIG_LEDS_TPS6105X_MODULE: u32 = 1;
pub const CONFIG_DVB_STV0288_MODULE: u32 = 1;
pub const CONFIG_X86_MEM_ENCRYPT: u32 = 1;
pub const CONFIG_SCSI_UFSHCD_PCI_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX6650_MODULE: u32 = 1;
pub const CONFIG_LOCKUP_DETECTOR: u32 = 1;
pub const CONFIG_FUSE_FS: u32 = 1;
pub const CONFIG_DMAR_TABLE: u32 = 1;
pub const CONFIG_USB_STV06XX_MODULE: u32 = 1;
pub const CONFIG_INTEL_ATOMISP2_LED_MODULE: u32 = 1;
pub const CONFIG_NFC_PN533_USB_MODULE: u32 = 1;
pub const CONFIG_QCOM_SCM_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LIS3LV02D_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_ADS7846_MODULE: u32 = 1;
pub const CONFIG_MFD_MC13XXX_I2C_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_DWLIB: u32 = 1;
pub const CONFIG_ZRAM_BACKEND_ZSTD: u32 = 1;
pub const CONFIG_MFD_TPS65912_MODULE: u32 = 1;
pub const CONFIG_USB_F_ACM_MODULE: u32 = 1;
pub const CONFIG_KSZ884X_PCI_MODULE: u32 = 1;
pub const CONFIG_RTW88_CORE_MODULE: u32 = 1;
pub const CONFIG_PSTORE_RAM_MODULE: u32 = 1;
pub const CONFIG_EFI_CUSTOM_SSDT_OVERLAYS: u32 = 1;
pub const CONFIG_MEDIA_TUNER_TUA9001_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ISL28022_MODULE: u32 = 1;
pub const CONFIG_X86_PAT: u32 = 1;
pub const CONFIG_BT_HCIUART_NOKIA_MODULE: u32 = 1;
pub const CONFIG_NOP_TRACER: u32 = 1;
pub const CONFIG_PTP_1588_CLOCK_INES_MODULE: u32 = 1;
pub const CONFIG_HAVE_KVM_DIRTY_RING_ACQ_REL: u32 = 1;
pub const CONFIG_MICREL_PHY_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_CPU_CACHE_INVALIDATE_MEMREGION: u32 = 1;
pub const CONFIG_BMA400_MODULE: u32 = 1;
pub const CONFIG_DRM_VRAM_HELPER_MODULE: u32 = 1;
pub const CONFIG_LZ4_COMPRESS_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_ETURBO: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_SOCKET_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_FORCE_DMA_UNENCRYPTED: u32 = 1;
pub const CONFIG_SMB_SERVER_KERBEROS5: u32 = 1;
pub const CONFIG_IP_VS_LBLCR_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_AW37503_MODULE: u32 = 1;
pub const CONFIG_BTREE: u32 = 1;
pub const CONFIG_PNFS_FLEXFILE_LAYOUT_MODULE: u32 = 1;
pub const CONFIG_AMD_QDMA_MODULE: u32 = 1;
pub const CONFIG_GENERIC_PINMUX_FUNCTIONS: u32 = 1;
pub const CONFIG_GPIO_MOCKUP_MODULE: u32 = 1;
pub const CONFIG_IRSD200_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AW88081_MODULE: u32 = 1;
pub const CONFIG_EDAC_X38_MODULE: u32 = 1;
pub const CONFIG_VETH_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_CONEX_MODULE: u32 = 1;
pub const CONFIG_LEDS_MT6370_RGB_MODULE: u32 = 1;
pub const CONFIG_TLAN_MODULE: u32 = 1;
pub const CONFIG_IP_VS_NFCT: u32 = 1;
pub const CONFIG_NSM_MODULE: u32 = 1;
pub const CONFIG_INTEL_SPEED_SELECT_INTERFACE_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT_SDW_COMMON_MODULE: u32 = 1;
pub const CONFIG_MAX5522_MODULE: u32 = 1;
pub const CONFIG_AD7303_MODULE: u32 = 1;
pub const CONFIG_DVB_CXD2099_MODULE: u32 = 1;
pub const CONFIG_SDIO_UART_MODULE: u32 = 1;
pub const CONFIG_SSB_B43_PCI_BRIDGE: u32 = 1;
pub const CONFIG_NET_SCH_PIE_MODULE: u32 = 1;
pub const CONFIG_UCLAMP_TASK_GROUP: u32 = 1;
pub const CONFIG_USB_SERIAL_MOS7720_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_LITEX: u32 = 1;
pub const CONFIG_RTW88_8822CE_MODULE: u32 = 1;
pub const CONFIG_DVB_PLATFORM_DRIVERS: u32 = 1;
pub const CONFIG_AD4000_MODULE: u32 = 1;
pub const CONFIG_VIDEO_V4L2_SUBDEV_API: u32 = 1;
pub const CONFIG_CEPH_LIB_USE_DNS_RESOLVER: u32 = 1;
pub const CONFIG_GPIO_TANGIER_MODULE: u32 = 1;
pub const CONFIG_SCSI_SAS_ATA: u32 = 1;
pub const CONFIG_INV_MPU6050_I2C_MODULE: u32 = 1;
pub const CONFIG_IKHEADERS_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX31722_MODULE: u32 = 1;
pub const CONFIG_MICROCODE: u32 = 1;
pub const CONFIG_NVME_TARGET_FC_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX16065_MODULE: u32 = 1;
pub const CONFIG_DRM_XE_GPUSVM: u32 = 1;
pub const CONFIG_VIRTIO_BALLOON_MODULE: u32 = 1;
pub const CONFIG_BCMA_HOST_PCI_POSSIBLE: u32 = 1;
pub const CONFIG_VHOST_RING_MODULE: u32 = 1;
pub const CONFIG_CPU_ISOLATION: u32 = 1;
pub const CONFIG_GENERIC_CMOS_UPDATE: u32 = 1;
pub const CONFIG_SERIAL_8250_PCI: u32 = 1;
pub const CONFIG_NET_VENDOR_QLOGIC: u32 = 1;
pub const CONFIG_USB_GSPCA_SONIXJ_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WM8904_MODULE: u32 = 1;
pub const CONFIG_EXTCON_PALMAS_MODULE: u32 = 1;
pub const CONFIG_GPIO_XILINX_MODULE: u32 = 1;
pub const CONFIG_LWTUNNEL_BPF: u32 = 1;
pub const CONFIG_NET_ACT_CTINFO_MODULE: u32 = 1;
pub const CONFIG_DLM_MODULE: u32 = 1;
pub const CONFIG_SERIO: u32 = 1;
pub const CONFIG_CHR_DEV_SCH_MODULE: u32 = 1;
pub const CONFIG_SC92031_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_OV519_MODULE: u32 = 1;
pub const CONFIG_NET_VRF_MODULE: u32 = 1;
pub const CONFIG_DRM_GEM_SHMEM_HELPER: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_ATOMIC_RMW: u32 = 1;
pub const CONFIG_CROS_EC_UCSI_MODULE: u32 = 1;
pub const CONFIG_HARDLOCKUP_DETECTOR_PERF: u32 = 1;
pub const CONFIG_DVB_TDA826X_MODULE: u32 = 1;
pub const CONFIG_FTRACE_MCOUNT_USE_CC: u32 = 1;
pub const CONFIG_BT_INTEL_PCIE_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_LIB_AES: u32 = 1;
pub const CONFIG_CRYPTO_TWOFISH_X86_64_3WAY_MODULE: u32 = 1;
pub const CONFIG_TYPEC_MUX_WCD939X_USBSS_MODULE: u32 = 1;
pub const CONFIG_HYPERV_VSOCKETS_MODULE: u32 = 1;
pub const CONFIG_BPF_LIRC_MODE2: u32 = 1;
pub const CONFIG_BMI160_SPI_MODULE: u32 = 1;
pub const CONFIG_SND_GINA24_MODULE: u32 = 1;
pub const CONFIG_CROS_USBPD_LOGGER_MODULE: u32 = 1;
pub const CONFIG_DM_VERITY_FEC: u32 = 1;
pub const CONFIG_MLX5_VDPA_NET_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_SY7636A_MODULE: u32 = 1;
pub const CONFIG_NF_LOG_SYSLOG_MODULE: u32 = 1;
pub const CONFIG_LTRF216A_MODULE: u32 = 1;
pub const CONFIG_USB_OHCI_HCD: u32 = 1;
pub const CONFIG_PATA_LEGACY_MODULE: u32 = 1;
pub const CONFIG_VFIO_VIRQFD: u32 = 1;
pub const CONFIG_BMA400_I2C_MODULE: u32 = 1;
pub const CONFIG_FB_IOMEM_FOPS: u32 = 1;
pub const CONFIG_FW_CACHE: u32 = 1;
pub const CONFIG_AGP_VIA_MODULE: u32 = 1;
pub const CONFIG_REGMAP_I2C: u32 = 1;
pub const CONFIG_STMMAC_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_IP_NF_TARGET_REDIRECT_MODULE: u32 = 1;
pub const CONFIG_RCU_FANOUT_LEAF: u32 = 16;
pub const CONFIG_MTD_MTDRAM_MODULE: u32 = 1;
pub const CONFIG_HID_TOPRE_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ABITUGURU3_MODULE: u32 = 1;
pub const CONFIG_SCSI_MPT2SAS_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WM8731_SPI_MODULE: u32 = 1;
pub const CONFIG_HINIC3_MODULE: u32 = 1;
pub const CONFIG_MMC_SDHCI_MODULE: u32 = 1;
pub const CONFIG_IOMMUFD_DRIVER: u32 = 1;
pub const CONFIG_PRINTK: u32 = 1;
pub const CONFIG_LEDS_TRIGGER_DISK: u32 = 1;
pub const CONFIG_FIREWIRE_MODULE: u32 = 1;
pub const CONFIG_F2FS_CHECK_FS: u32 = 1;
pub const CONFIG_DM_SWITCH_MODULE: u32 = 1;
pub const CONFIG_VIDEO_EM28XX_DVB_MODULE: u32 = 1;
pub const CONFIG_DRM_I915_FORCE_PROBE: &[u8; 2] = b"*\0";
pub const CONFIG_NETLABEL: u32 = 1;
pub const CONFIG_PINCTRL_CS42L43_MODULE: u32 = 1;
pub const CONFIG_I2C_KEBA_MODULE: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_KEXEC_HANDOVER: u32 = 1;
pub const CONFIG_SND_SOC_MAX9860_MODULE: u32 = 1;
pub const CONFIG_DRM_NOUVEAU_SVM: u32 = 1;
pub const CONFIG_PCI_STUB: u32 = 1;
pub const CONFIG_LEDS_CHT_WCOVE_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_RMD160_MODULE: u32 = 1;
pub const CONFIG_INTEL_TH_MSU_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_88PM80X_MODULE: u32 = 1;
pub const CONFIG_HAVE_STATIC_CALL: u32 = 1;
pub const CONFIG_USB_NET_CDC_NCM_MODULE: u32 = 1;
pub const CONFIG_DAMON_STAT: u32 = 1;
pub const CONFIG_AGP_INTEL_MODULE: u32 = 1;
pub const CONFIG_CC_VERSION_TEXT: &[u8; 26] = b"gcc (GCC) 15.2.1 20251112\0";
pub const CONFIG_TOUCHSCREEN_BU21013_MODULE: u32 = 1;
pub const CONFIG_EQUALIZER_MODULE: u32 = 1;
pub const CONFIG_INTEL_ISH_FIRMWARE_DOWNLOADER_MODULE: u32 = 1;
pub const CONFIG_VIDEO_IVTV_MODULE: u32 = 1;
pub const CONFIG_DVB_BUDGET_AV_MODULE: u32 = 1;
pub const CONFIG_IP6_NF_MATCH_SRH_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_NAU8821_MODULE: u32 = 1;
pub const CONFIG_BINFMT_ELF: u32 = 1;
pub const CONFIG_BLK_DEV_RNBD: u32 = 1;
pub const CONFIG_HIGH_RES_TIMERS: u32 = 1;
pub const CONFIG_I2C_SMBUS_MODULE: u32 = 1;
pub const CONFIG_DEBUG_FS_ALLOW_ALL: u32 = 1;
pub const CONFIG_NULL_TTY_MODULE: u32 = 1;
pub const CONFIG_ALS31300_MODULE: u32 = 1;
pub const CONFIG_QED_RDMA: u32 = 1;
pub const CONFIG_HAVE_SAMPLE_FTRACE_DIRECT_MULTI: u32 = 1;
pub const CONFIG_TI_TMAG5273_MODULE: u32 = 1;
pub const CONFIG_WIREGUARD_MODULE: u32 = 1;
pub const CONFIG_GOOGLE_MEMCONSOLE_COREBOOT_MODULE: u32 = 1;
pub const CONFIG_RTW89_8852BU_MODULE: u32 = 1;
pub const CONFIG_MEMFD_CREATE: u32 = 1;
pub const CONFIG_FPGA_MGR_MICROCHIP_SPI_MODULE: u32 = 1;
pub const CONFIG_HDMI_LPE_AUDIO_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT715_SDCA_SDW_MODULE: u32 = 1;
pub const CONFIG_FXLS8962AF_MODULE: u32 = 1;
pub const CONFIG_USB_HSIC_USB3503_MODULE: u32 = 1;
pub const CONFIG_GPIO_DA9055_MODULE: u32 = 1;
pub const CONFIG_SENSORS_HMC5843_I2C_MODULE: u32 = 1;
pub const CONFIG_DA9055_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_WIZNET_W5100_SPI_MODULE: u32 = 1;
pub const CONFIG_DRM_AMD_DC_SI: u32 = 1;
pub const __LITTLE_ENDIAN: u32 = 1234;
pub const KASAN_ABI_VERSION: u32 = 5;
pub const ASM_INPUT_G: &[u8; 3] = b"ir\0";
pub const ASM_INPUT_RM: &[u8; 2] = b"r\0";
pub const __BITS_PER_LONG: u32 = 64;
pub const __BITS_PER_LONG_LONG: u32 = 64;
pub const BITS_PER_LONG: u32 = 64;
pub const BITS_PER_LONG_LONG: u32 = 64;
pub const __FD_SETSIZE: u32 = 1024;
pub const READ: u32 = 0;
pub const WRITE: u32 = 1;
pub const EPERM: u32 = 1;
pub const ENOENT: u32 = 2;
pub const ESRCH: u32 = 3;
pub const EINTR: u32 = 4;
pub const EIO: u32 = 5;
pub const ENXIO: u32 = 6;
pub const E2BIG: u32 = 7;
pub const ENOEXEC: u32 = 8;
pub const EBADF: u32 = 9;
pub const ECHILD: u32 = 10;
pub const EAGAIN: u32 = 11;
pub const ENOMEM: u32 = 12;
pub const EACCES: u32 = 13;
pub const EFAULT: u32 = 14;
pub const ENOTBLK: u32 = 15;
pub const EBUSY: u32 = 16;
pub const EEXIST: u32 = 17;
pub const EXDEV: u32 = 18;
pub const ENODEV: u32 = 19;
pub const ENOTDIR: u32 = 20;
pub const EISDIR: u32 = 21;
pub const EINVAL: u32 = 22;
pub const ENFILE: u32 = 23;
pub const EMFILE: u32 = 24;
pub const ENOTTY: u32 = 25;
pub const ETXTBSY: u32 = 26;
pub const EFBIG: u32 = 27;
pub const ENOSPC: u32 = 28;
pub const ESPIPE: u32 = 29;
pub const EROFS: u32 = 30;
pub const EMLINK: u32 = 31;
pub const EPIPE: u32 = 32;
pub const EDOM: u32 = 33;
pub const ERANGE: u32 = 34;
pub const EDEADLK: u32 = 35;
pub const ENAMETOOLONG: u32 = 36;
pub const ENOLCK: u32 = 37;
pub const ENOSYS: u32 = 38;
pub const ENOTEMPTY: u32 = 39;
pub const ELOOP: u32 = 40;
pub const EWOULDBLOCK: u32 = 11;
pub const ENOMSG: u32 = 42;
pub const EIDRM: u32 = 43;
pub const ECHRNG: u32 = 44;
pub const EL2NSYNC: u32 = 45;
pub const EL3HLT: u32 = 46;
pub const EL3RST: u32 = 47;
pub const ELNRNG: u32 = 48;
pub const EUNATCH: u32 = 49;
pub const ENOCSI: u32 = 50;
pub const EL2HLT: u32 = 51;
pub const EBADE: u32 = 52;
pub const EBADR: u32 = 53;
pub const EXFULL: u32 = 54;
pub const ENOANO: u32 = 55;
pub const EBADRQC: u32 = 56;
pub const EBADSLT: u32 = 57;
pub const EDEADLOCK: u32 = 35;
pub const EBFONT: u32 = 59;
pub const ENOSTR: u32 = 60;
pub const ENODATA: u32 = 61;
pub const ETIME: u32 = 62;
pub const ENOSR: u32 = 63;
pub const ENONET: u32 = 64;
pub const ENOPKG: u32 = 65;
pub const EREMOTE: u32 = 66;
pub const ENOLINK: u32 = 67;
pub const EADV: u32 = 68;
pub const ESRMNT: u32 = 69;
pub const ECOMM: u32 = 70;
pub const EPROTO: u32 = 71;
pub const EMULTIHOP: u32 = 72;
pub const EDOTDOT: u32 = 73;
pub const EBADMSG: u32 = 74;
pub const EOVERFLOW: u32 = 75;
pub const ENOTUNIQ: u32 = 76;
pub const EBADFD: u32 = 77;
pub const EREMCHG: u32 = 78;
pub const ELIBACC: u32 = 79;
pub const ELIBBAD: u32 = 80;
pub const ELIBSCN: u32 = 81;
pub const ELIBMAX: u32 = 82;
pub const ELIBEXEC: u32 = 83;
pub const EILSEQ: u32 = 84;
pub const ERESTART: u32 = 85;
pub const ESTRPIPE: u32 = 86;
pub const EUSERS: u32 = 87;
pub const ENOTSOCK: u32 = 88;
pub const EDESTADDRREQ: u32 = 89;
pub const EMSGSIZE: u32 = 90;
pub const EPROTOTYPE: u32 = 91;
pub const ENOPROTOOPT: u32 = 92;
pub const EPROTONOSUPPORT: u32 = 93;
pub const ESOCKTNOSUPPORT: u32 = 94;
pub const EOPNOTSUPP: u32 = 95;
pub const EPFNOSUPPORT: u32 = 96;
pub const EAFNOSUPPORT: u32 = 97;
pub const EADDRINUSE: u32 = 98;
pub const EADDRNOTAVAIL: u32 = 99;
pub const ENETDOWN: u32 = 100;
pub const ENETUNREACH: u32 = 101;
pub const ENETRESET: u32 = 102;
pub const ECONNABORTED: u32 = 103;
pub const ECONNRESET: u32 = 104;
pub const ENOBUFS: u32 = 105;
pub const EISCONN: u32 = 106;
pub const ENOTCONN: u32 = 107;
pub const ESHUTDOWN: u32 = 108;
pub const ETOOMANYREFS: u32 = 109;
pub const ETIMEDOUT: u32 = 110;
pub const ECONNREFUSED: u32 = 111;
pub const EHOSTDOWN: u32 = 112;
pub const EHOSTUNREACH: u32 = 113;
pub const EALREADY: u32 = 114;
pub const EINPROGRESS: u32 = 115;
pub const ESTALE: u32 = 116;
pub const EUCLEAN: u32 = 117;
pub const ENOTNAM: u32 = 118;
pub const ENAVAIL: u32 = 119;
pub const EISNAM: u32 = 120;
pub const EREMOTEIO: u32 = 121;
pub const EDQUOT: u32 = 122;
pub const ENOMEDIUM: u32 = 123;
pub const EMEDIUMTYPE: u32 = 124;
pub const ECANCELED: u32 = 125;
pub const ENOKEY: u32 = 126;
pub const EKEYEXPIRED: u32 = 127;
pub const EKEYREVOKED: u32 = 128;
pub const EKEYREJECTED: u32 = 129;
pub const EOWNERDEAD: u32 = 130;
pub const ENOTRECOVERABLE: u32 = 131;
pub const ERFKILL: u32 = 132;
pub const EHWPOISON: u32 = 133;
pub const ERESTARTSYS: u32 = 512;
pub const ERESTARTNOINTR: u32 = 513;
pub const ERESTARTNOHAND: u32 = 514;
pub const ENOIOCTLCMD: u32 = 515;
pub const ERESTART_RESTARTBLOCK: u32 = 516;
pub const EPROBE_DEFER: u32 = 517;
pub const EOPENSTALE: u32 = 518;
pub const ENOPARAM: u32 = 519;
pub const EBADHANDLE: u32 = 521;
pub const ENOTSYNC: u32 = 522;
pub const EBADCOOKIE: u32 = 523;
pub const ENOTSUPP: u32 = 524;
pub const ETOOSMALL: u32 = 525;
pub const ESERVERFAULT: u32 = 526;
pub const EBADTYPE: u32 = 527;
pub const EJUKEBOX: u32 = 528;
pub const EIOCBQUEUED: u32 = 529;
pub const ERECALLCONFLICT: u32 = 530;
pub const ENOGRACE: u32 = 531;
pub const BITS_PER_BYTE: u32 = 8;
pub const USE_TYPEOF_UNQUAL: u32 = 1;
pub const KCSAN_ACCESS_WRITE: u32 = 1;
pub const KCSAN_ACCESS_COMPOUND: u32 = 2;
pub const KCSAN_ACCESS_ATOMIC: u32 = 4;
pub const KCSAN_ACCESS_ASSERT: u32 = 8;
pub const KCSAN_ACCESS_SCOPED: u32 = 16;
pub const NR_OPEN: u32 = 1024;
pub const NGROUPS_MAX: u32 = 65536;
pub const ARG_MAX: u32 = 131072;
pub const LINK_MAX: u32 = 127;
pub const MAX_CANON: u32 = 255;
pub const MAX_INPUT: u32 = 255;
pub const NAME_MAX: u32 = 255;
pub const PATH_MAX: u32 = 4096;
pub const PIPE_BUF: u32 = 4096;
pub const XATTR_NAME_MAX: u32 = 255;
pub const XATTR_SIZE_MAX: u32 = 65536;
pub const XATTR_LIST_MAX: u32 = 65536;
pub const RTSIG_MAX: u32 = 32;
pub const UINT_MAX: i32 = -1;
pub const ULONG_MAX: i32 = -1;
pub const ULLONG_MAX: i32 = -1;
pub const UINTPTR_MAX: i32 = -1;
pub const IORESOURCE_BITS: u32 = 255;
pub const IORESOURCE_TYPE_BITS: u32 = 7936;
pub const IORESOURCE_IO: u32 = 256;
pub const IORESOURCE_MEM: u32 = 512;
pub const IORESOURCE_REG: u32 = 768;
pub const IORESOURCE_IRQ: u32 = 1024;
pub const IORESOURCE_DMA: u32 = 2048;
pub const IORESOURCE_BUS: u32 = 4096;
pub const IORESOURCE_PREFETCH: u32 = 8192;
pub const IORESOURCE_READONLY: u32 = 16384;
pub const IORESOURCE_CACHEABLE: u32 = 32768;
pub const IORESOURCE_RANGELENGTH: u32 = 65536;
pub const IORESOURCE_SHADOWABLE: u32 = 131072;
pub const IORESOURCE_SIZEALIGN: u32 = 262144;
pub const IORESOURCE_STARTALIGN: u32 = 524288;
pub const IORESOURCE_MEM_64: u32 = 1048576;
pub const IORESOURCE_WINDOW: u32 = 2097152;
pub const IORESOURCE_MUXED: u32 = 4194304;
pub const IORESOURCE_EXT_TYPE_BITS: u32 = 16777216;
pub const IORESOURCE_SYSRAM: u32 = 16777216;
pub const IORESOURCE_SYSRAM_DRIVER_MANAGED: u32 = 33554432;
pub const IORESOURCE_SYSRAM_MERGEABLE: u32 = 67108864;
pub const IORESOURCE_EXCLUSIVE: u32 = 134217728;
pub const IORESOURCE_DISABLED: u32 = 268435456;
pub const IORESOURCE_UNSET: u32 = 536870912;
pub const IORESOURCE_AUTO: u32 = 1073741824;
pub const IORESOURCE_BUSY: u32 = 2147483648;
pub const IORESOURCE_SYSTEM_RAM: u32 = 16777728;
pub const IORESOURCE_IRQ_HIGHEDGE: u32 = 1;
pub const IORESOURCE_IRQ_LOWEDGE: u32 = 2;
pub const IORESOURCE_IRQ_HIGHLEVEL: u32 = 4;
pub const IORESOURCE_IRQ_LOWLEVEL: u32 = 8;
pub const IORESOURCE_IRQ_SHAREABLE: u32 = 16;
pub const IORESOURCE_IRQ_OPTIONAL: u32 = 32;
pub const IORESOURCE_IRQ_WAKECAPABLE: u32 = 64;
pub const IORESOURCE_DMA_TYPE_MASK: u32 = 3;
pub const IORESOURCE_DMA_8BIT: u32 = 0;
pub const IORESOURCE_DMA_8AND16BIT: u32 = 1;
pub const IORESOURCE_DMA_16BIT: u32 = 2;
pub const IORESOURCE_DMA_MASTER: u32 = 4;
pub const IORESOURCE_DMA_BYTE: u32 = 8;
pub const IORESOURCE_DMA_WORD: u32 = 16;
pub const IORESOURCE_DMA_SPEED_MASK: u32 = 192;
pub const IORESOURCE_DMA_COMPATIBLE: u32 = 0;
pub const IORESOURCE_DMA_TYPEA: u32 = 64;
pub const IORESOURCE_DMA_TYPEB: u32 = 128;
pub const IORESOURCE_DMA_TYPEF: u32 = 192;
pub const IORESOURCE_MEM_WRITEABLE: u32 = 1;
pub const IORESOURCE_MEM_CACHEABLE: u32 = 2;
pub const IORESOURCE_MEM_RANGELENGTH: u32 = 4;
pub const IORESOURCE_MEM_TYPE_MASK: u32 = 24;
pub const IORESOURCE_MEM_8BIT: u32 = 0;
pub const IORESOURCE_MEM_16BIT: u32 = 8;
pub const IORESOURCE_MEM_8AND16BIT: u32 = 16;
pub const IORESOURCE_MEM_32BIT: u32 = 24;
pub const IORESOURCE_MEM_SHADOWABLE: u32 = 32;
pub const IORESOURCE_MEM_EXPANSIONROM: u32 = 64;
pub const IORESOURCE_MEM_NONPOSTED: u32 = 128;
pub const IORESOURCE_IO_16BIT_ADDR: u32 = 1;
pub const IORESOURCE_IO_FIXED: u32 = 2;
pub const IORESOURCE_IO_SPARSE: u32 = 4;
pub const IORESOURCE_ROM_ENABLE: u32 = 1;
pub const IORESOURCE_ROM_SHADOW: u32 = 2;
pub const IORESOURCE_PCI_FIXED: u32 = 16;
pub const IORESOURCE_PCI_EA_BEI: u32 = 32;
pub const PAGE_POISON: u32 = 170;
pub const SLUB_RED_INACTIVE: u32 = 187;
pub const SLUB_RED_ACTIVE: u32 = 204;
pub const POISON_INUSE: u32 = 90;
pub const POISON_FREE: u32 = 107;
pub const POISON_END: u32 = 165;
pub const POISON_FREE_INITMEM: u32 = 204;
pub const JBD_POISON_FREE: u32 = 91;
pub const JBD2_POISON_FREE: u32 = 92;
pub const POOL_POISON_FREED: u32 = 167;
pub const POOL_POISON_ALLOCATED: u32 = 169;
pub const ATM_POISON_FREE: u32 = 18;
pub const ATM_POISON: u32 = 3735928559;
pub const MUTEX_DEBUG_INIT: u32 = 17;
pub const MUTEX_DEBUG_FREE: u32 = 34;
pub const KEY_DESTROY: u32 = 189;
pub const UNWIND_HINT_TYPE_UNDEFINED: u32 = 0;
pub const UNWIND_HINT_TYPE_END_OF_STACK: u32 = 1;
pub const UNWIND_HINT_TYPE_CALL: u32 = 2;
pub const UNWIND_HINT_TYPE_REGS: u32 = 3;
pub const UNWIND_HINT_TYPE_REGS_PARTIAL: u32 = 4;
pub const UNWIND_HINT_TYPE_FUNC: u32 = 5;
pub const UNWIND_HINT_TYPE_SAVE: u32 = 6;
pub const UNWIND_HINT_TYPE_RESTORE: u32 = 7;
pub const ANNOTYPE_NOENDBR: u32 = 1;
pub const ANNOTYPE_RETPOLINE_SAFE: u32 = 2;
pub const ANNOTYPE_INSTR_BEGIN: u32 = 3;
pub const ANNOTYPE_INSTR_END: u32 = 4;
pub const ANNOTYPE_UNRET_BEGIN: u32 = 5;
pub const ANNOTYPE_IGNORE_ALTS: u32 = 6;
pub const ANNOTYPE_INTRA_FUNCTION_CALL: u32 = 7;
pub const ANNOTYPE_REACHABLE: u32 = 8;
pub const ANNOTYPE_NOCFI: u32 = 9;
pub const EX_DATA_REG_SHIFT: u32 = 8;
pub const EX_DATA_FLAG_SHIFT: u32 = 12;
pub const EX_DATA_IMM_SHIFT: u32 = 16;
pub const EX_TYPE_NONE: u32 = 0;
pub const EX_TYPE_DEFAULT: u32 = 1;
pub const EX_TYPE_FAULT: u32 = 2;
pub const EX_TYPE_UACCESS: u32 = 3;
pub const EX_TYPE_CLEAR_FS: u32 = 5;
pub const EX_TYPE_FPU_RESTORE: u32 = 6;
pub const EX_TYPE_BPF: u32 = 7;
pub const EX_TYPE_WRMSR: u32 = 8;
pub const EX_TYPE_RDMSR: u32 = 9;
pub const EX_TYPE_WRMSR_SAFE: u32 = 10;
pub const EX_TYPE_RDMSR_SAFE: u32 = 11;
pub const EX_TYPE_WRMSR_IN_MCE: u32 = 12;
pub const EX_TYPE_RDMSR_IN_MCE: u32 = 13;
pub const EX_TYPE_DEFAULT_MCE_SAFE: u32 = 14;
pub const EX_TYPE_FAULT_MCE_SAFE: u32 = 15;
pub const EX_TYPE_POP_REG: u32 = 16;
pub const EX_TYPE_IMM_REG: u32 = 17;
pub const EX_TYPE_FAULT_SGX: u32 = 18;
pub const EX_TYPE_UCOPY_LEN: u32 = 19;
pub const EX_TYPE_ZEROPAD: u32 = 20;
pub const EX_TYPE_ERETU: u32 = 21;
pub const DEFINE_EXTABLE_TYPE_REG : & [u8 ; 533] = b".macro extable_type_reg type:req reg:req\n.set .Lfound, 0\n.set .Lregnr, 0\n.irp rs,rax,rcx,rdx,rbx,rsp,rbp,rsi,rdi,r8,r9,r10,r11,r12,r13,r14,r15\n.ifc \\reg, %%\\rs\n.set .Lfound, .Lfound+1\n.long \\type + (.Lregnr << 8)\n.endif\n.set .Lregnr, .Lregnr+1\n.endr\n.set .Lregnr, 0\n.irp rs,eax,ecx,edx,ebx,esp,ebp,esi,edi,r8d,r9d,r10d,r11d,r12d,r13d,r14d,r15d\n.ifc \\reg, %%\\rs\n.set .Lfound, .Lfound+1\n.long \\type + (.Lregnr << 8)\n.endif\n.set .Lregnr, .Lregnr+1\n.endr\n.if (.Lfound != 1)\n.error \"extable_type_reg: bad register argument\"\n.endif\n.endm\n\0" ;
pub const UNDEFINE_EXTABLE_TYPE_REG: &[u8; 26] = b".purgem extable_type_reg\n\0";
pub const ASM_REACHABLE: &[u8; 65] =
    b"998:\n\t.pushsection .discard.reachable\n\t.long 998b\n\t.popsection\n\t\0";
pub const INSN_UD2: u32 = 2831;
pub const LEN_UD2: u32 = 2;
pub const INSN_UDB: u32 = 214;
pub const LEN_UDB: u32 = 1;
pub const INSN_ASOP: u32 = 103;
pub const INSN_LOCK: u32 = 240;
pub const OPCODE_ESCAPE: u32 = 15;
pub const SECOND_BYTE_OPCODE_UD1: u32 = 185;
pub const SECOND_BYTE_OPCODE_UD2: u32 = 11;
pub const BUG_NONE: u32 = 65535;
pub const BUG_UD2: u32 = 65534;
pub const BUG_UD1: u32 = 65533;
pub const BUG_UD1_UBSAN: u32 = 65532;
pub const BUG_UDB: u32 = 65494;
pub const BUG_LOCK: u32 = 65520;
pub const CUT_HERE: &[u8; 38] = b"------------[ cut here ]------------\n\0";
pub const BUGFLAG_WARNING: u32 = 1;
pub const BUGFLAG_ONCE: u32 = 2;
pub const BUGFLAG_DONE: u32 = 4;
pub const BUGFLAG_NO_CUT_HERE: u32 = 8;
pub const PANIC_CPU_INVALID: i32 = -1;
pub const TAINT_PROPRIETARY_MODULE: u32 = 0;
pub const TAINT_FORCED_MODULE: u32 = 1;
pub const TAINT_CPU_OUT_OF_SPEC: u32 = 2;
pub const TAINT_FORCED_RMMOD: u32 = 3;
pub const TAINT_MACHINE_CHECK: u32 = 4;
pub const TAINT_BAD_PAGE: u32 = 5;
pub const TAINT_USER: u32 = 6;
pub const TAINT_DIE: u32 = 7;
pub const TAINT_OVERRIDDEN_ACPI_TABLE: u32 = 8;
pub const TAINT_WARN: u32 = 9;
pub const TAINT_CRAP: u32 = 10;
pub const TAINT_FIRMWARE_WORKAROUND: u32 = 11;
pub const TAINT_OOT_MODULE: u32 = 12;
pub const TAINT_UNSIGNED_MODULE: u32 = 13;
pub const TAINT_SOFTLOCKUP: u32 = 14;
pub const TAINT_LIVEPATCH: u32 = 15;
pub const TAINT_AUX: u32 = 16;
pub const TAINT_RANDSTRUCT: u32 = 17;
pub const TAINT_TEST: u32 = 18;
pub const TAINT_FWCTL: u32 = 19;
pub const TAINT_FLAGS_COUNT: u32 = 20;
pub const TAINT_FLAGS_MAX: u32 = 1048575;
pub const KERN_SOH: &[u8; 2] = b"\x01\0";
pub const KERN_SOH_ASCII: u8 = 1u8;
pub const KERN_EMERG: &[u8; 3] = b"\x010\0";
pub const KERN_ALERT: &[u8; 3] = b"\x011\0";
pub const KERN_CRIT: &[u8; 3] = b"\x012\0";
pub const KERN_ERR: &[u8; 3] = b"\x013\0";
pub const KERN_WARNING: &[u8; 3] = b"\x014\0";
pub const KERN_NOTICE: &[u8; 3] = b"\x015\0";
pub const KERN_INFO: &[u8; 3] = b"\x016\0";
pub const KERN_DEBUG: &[u8; 3] = b"\x017\0";
pub const KERN_DEFAULT: &[u8; 1] = b"\0";
pub const KERN_CONT: &[u8; 3] = b"\x01c\0";
pub const LOGLEVEL_SCHED: i32 = -2;
pub const LOGLEVEL_DEFAULT: i32 = -1;
pub const LOGLEVEL_EMERG: u32 = 0;
pub const LOGLEVEL_ALERT: u32 = 1;
pub const LOGLEVEL_CRIT: u32 = 2;
pub const LOGLEVEL_ERR: u32 = 3;
pub const LOGLEVEL_WARNING: u32 = 4;
pub const LOGLEVEL_NOTICE: u32 = 5;
pub const LOGLEVEL_INFO: u32 = 6;
pub const LOGLEVEL_DEBUG: u32 = 7;
pub const HAS_KERNEL_IBT: u32 = 1;
pub const ASM_ENDBR: &[u8; 10] = b"endbr64\n\t\0";
pub const ENDBR_INSN_SIZE: u32 = 4;
pub const ASM_RET: &[u8; 25] = b"jmp __x86_return_thunk\n\t\0";
pub const __USER_HZ: u32 = 100;
pub const HZ: u32 = 100;
pub const EXEC_PAGESIZE: u32 = 4096;
pub const NOGROUP: i32 = -1;
pub const MAXHOSTNAMELEN: u32 = 64;
pub const USER_HZ: u32 = 100;
pub const CLOCKS_PER_SEC: u32 = 100;
pub const _Q_LOCKED_OFFSET: u32 = 0;
pub const _Q_LOCKED_BITS: u32 = 8;
pub const _Q_PENDING_OFFSET: u32 = 8;
pub const _Q_PENDING_BITS: u32 = 8;
pub const _Q_TAIL_IDX_OFFSET: u32 = 16;
pub const _Q_TAIL_IDX_BITS: u32 = 2;
pub const _Q_TAIL_CPU_OFFSET: u32 = 18;
pub const _Q_TAIL_CPU_BITS: u32 = 14;
pub const _Q_TAIL_OFFSET: u32 = 16;
pub const _Q_LOCKED_VAL: u32 = 1;
pub const _Q_PENDING_VAL: u32 = 256;
pub const MAX_LOCKDEP_SUBCLASSES: u32 = 8;
pub const SPINLOCK_MAGIC: u32 = 3735899821;
pub const DEFAULT_RATELIMIT_INTERVAL: u32 = 5000;
pub const DEFAULT_RATELIMIT_BURST: u32 = 10;
pub const PRINTK_MAX_SINGLE_HEADER_LEN: u32 = 2;
pub const MESSAGE_LOGLEVEL_DEFAULT: u32 = 4;
pub const CONSOLE_LOGLEVEL_SILENT: u32 = 0;
pub const CONSOLE_LOGLEVEL_MIN: u32 = 1;
pub const CONSOLE_LOGLEVEL_DEBUG: u32 = 10;
pub const CONSOLE_LOGLEVEL_MOTORMOUTH: u32 = 15;
pub const CONSOLE_LOGLEVEL_DEFAULT: u32 = 4;
pub const CONSOLE_LOGLEVEL_QUIET: u32 = 1;
pub const DEVKMSG_STR_MAX_SIZE: u32 = 10;
pub const FW_BUG: &[u8; 17] = b"[Firmware Bug]: \0";
pub const FW_WARN: &[u8; 18] = b"[Firmware Warn]: \0";
pub const FW_INFO: &[u8; 18] = b"[Firmware Info]: \0";
pub const HW_ERR: &[u8; 19] = b"[Hardware Error]: \0";
pub const DEPRECATED: &[u8; 15] = b"[Deprecated]: \0";
pub const MAX_ERRNO: u32 = 4095;
pub const BYTES_NOP1: u32 = 144;
pub const ASM_NOP_MAX: u32 = 11;
pub const JUMP_TYPE_FALSE: u32 = 0;
pub const JUMP_TYPE_TRUE: u32 = 1;
pub const JUMP_TYPE_LINKED: u32 = 2;
pub const JUMP_TYPE_MASK: u32 = 3;
pub const CLS_BITS: u32 = 6;
pub const _DPRINTK_CLASS_DFLT: u32 = 63;
pub const _DPRINTK_FLAGS_NONE: u32 = 0;
pub const _DPRINTK_FLAGS_PRINT: u32 = 1;
pub const _DPRINTK_FLAGS_INCL_MODNAME: u32 = 2;
pub const _DPRINTK_FLAGS_INCL_FUNCNAME: u32 = 4;
pub const _DPRINTK_FLAGS_INCL_LINENO: u32 = 8;
pub const _DPRINTK_FLAGS_INCL_TID: u32 = 16;
pub const _DPRINTK_FLAGS_INCL_SOURCENAME: u32 = 32;
pub const _DPRINTK_FLAGS_INCL_ANY: u32 = 62;
pub const _DPRINTK_FLAGS_DEFAULT: u32 = 0;
pub const ALT_FLAGS_SHIFT: u32 = 16;
pub const ALT_FLAG_NOT: u32 = 1;
pub const ALT_FLAG_DIRECT_CALL: u32 = 2;
pub const LOCK_PREFIX_HERE: &[u8; 70] =
    b".pushsection .smp_locks,\"a\"\n.balign 4\n.long 671f - .\n.popsection\n671:\0";
pub const LOCK_PREFIX: &[u8; 77] =
    b".pushsection .smp_locks,\"a\"\n.balign 4\n.long 671f - .\n.popsection\n671:\n\tlock \0";
pub const ALT_CALL_INSTR: &[u8; 14] = b"call BUG_func\0";
pub const alt_slen: &[u8; 10] = b"772b-771b\0";
pub const alt_total_slen: &[u8; 10] = b"773b-771b\0";
pub const alt_rlen: &[u8; 10] = b"775f-774f\0";
pub const SI_LOAD_SHIFT: u32 = 16;
pub const L1_CACHE_SHIFT: u32 = 6;
pub const L1_CACHE_BYTES: u32 = 64;
pub const INTERNODE_CACHE_SHIFT: u32 = 6;
pub const INTERNODE_CACHE_BYTES: u32 = 64;
pub const SMP_CACHE_BYTES: u32 = 64;
pub const ___GFP_SKIP_ZERO: u32 = 0;
pub const ___GFP_SKIP_KASAN: u32 = 0;
pub const ___GFP_NOLOCKDEP: u32 = 0;
pub const PREEMPT_BITS: u32 = 8;
pub const SOFTIRQ_BITS: u32 = 8;
pub const HARDIRQ_BITS: u32 = 4;
pub const NMI_BITS: u32 = 4;
pub const PREEMPT_SHIFT: u32 = 0;
pub const SOFTIRQ_SHIFT: u32 = 8;
pub const HARDIRQ_SHIFT: u32 = 16;
pub const NMI_SHIFT: u32 = 20;
pub const PREEMPT_OFFSET: u32 = 1;
pub const SOFTIRQ_OFFSET: u32 = 256;
pub const HARDIRQ_OFFSET: u32 = 65536;
pub const NMI_OFFSET: u32 = 1048576;
pub const SOFTIRQ_DISABLE_OFFSET: u32 = 512;
pub const INIT_PREEMPT_COUNT: u32 = 1;
pub const NR_CPUS: u32 = 8192;
pub const MIN_THREADS_LEFT_FOR_ROOT: u32 = 4;
pub const PIDS_PER_CPU_DEFAULT: u32 = 1024;
pub const PIDS_PER_CPU_MIN: u32 = 8;
pub const PER_CPU_SHARED_ALIGNED_SECTION: &[u8; 1] = b"\0";
pub const PER_CPU_ALIGNED_SECTION: &[u8; 1] = b"\0";
pub const PER_CPU_BASE_SECTION: &[u8; 14] = b".data..percpu\0";
pub const STATIC_CALL_SITE_TAIL: u32 = 1;
pub const STATIC_CALL_SITE_INIT: u32 = 2;
pub const STATIC_CALL_SITE_FLAGS: u32 = 3;
pub const PREEMPT_NEED_RESCHED: u32 = 2147483648;
pub const PREEMPT_ENABLED: u32 = 2147483648;
pub const PREEMPT_DISABLE_OFFSET: u32 = 1;
pub const PREEMPT_LOCK_OFFSET: u32 = 1;
pub const SOFTIRQ_LOCK_OFFSET: u32 = 513;
pub const X86_EFLAGS_CF_BIT: u32 = 0;
pub const X86_EFLAGS_FIXED_BIT: u32 = 1;
pub const X86_EFLAGS_PF_BIT: u32 = 2;
pub const X86_EFLAGS_AF_BIT: u32 = 4;
pub const X86_EFLAGS_ZF_BIT: u32 = 6;
pub const X86_EFLAGS_SF_BIT: u32 = 7;
pub const X86_EFLAGS_TF_BIT: u32 = 8;
pub const X86_EFLAGS_IF_BIT: u32 = 9;
pub const X86_EFLAGS_DF_BIT: u32 = 10;
pub const X86_EFLAGS_OF_BIT: u32 = 11;
pub const X86_EFLAGS_IOPL_BIT: u32 = 12;
pub const X86_EFLAGS_NT_BIT: u32 = 14;
pub const X86_EFLAGS_RF_BIT: u32 = 16;
pub const X86_EFLAGS_VM_BIT: u32 = 17;
pub const X86_EFLAGS_AC_BIT: u32 = 18;
pub const X86_EFLAGS_VIF_BIT: u32 = 19;
pub const X86_EFLAGS_VIP_BIT: u32 = 20;
pub const X86_EFLAGS_ID_BIT: u32 = 21;
pub const X86_CR0_PE_BIT: u32 = 0;
pub const X86_CR0_MP_BIT: u32 = 1;
pub const X86_CR0_EM_BIT: u32 = 2;
pub const X86_CR0_TS_BIT: u32 = 3;
pub const X86_CR0_ET_BIT: u32 = 4;
pub const X86_CR0_NE_BIT: u32 = 5;
pub const X86_CR0_WP_BIT: u32 = 16;
pub const X86_CR0_AM_BIT: u32 = 18;
pub const X86_CR0_NW_BIT: u32 = 29;
pub const X86_CR0_CD_BIT: u32 = 30;
pub const X86_CR0_PG_BIT: u32 = 31;
pub const X86_CR3_PWT_BIT: u32 = 3;
pub const X86_CR3_PCD_BIT: u32 = 4;
pub const X86_CR3_PCID_BITS: u32 = 12;
pub const X86_CR3_LAM_U57_BIT: u32 = 61;
pub const X86_CR3_LAM_U48_BIT: u32 = 62;
pub const X86_CR3_PCID_NOFLUSH_BIT: u32 = 63;
pub const X86_CR4_VME_BIT: u32 = 0;
pub const X86_CR4_PVI_BIT: u32 = 1;
pub const X86_CR4_TSD_BIT: u32 = 2;
pub const X86_CR4_DE_BIT: u32 = 3;
pub const X86_CR4_PSE_BIT: u32 = 4;
pub const X86_CR4_PAE_BIT: u32 = 5;
pub const X86_CR4_MCE_BIT: u32 = 6;
pub const X86_CR4_PGE_BIT: u32 = 7;
pub const X86_CR4_PCE_BIT: u32 = 8;
pub const X86_CR4_OSFXSR_BIT: u32 = 9;
pub const X86_CR4_OSXMMEXCPT_BIT: u32 = 10;
pub const X86_CR4_UMIP_BIT: u32 = 11;
pub const X86_CR4_LA57_BIT: u32 = 12;
pub const X86_CR4_VMXE_BIT: u32 = 13;
pub const X86_CR4_SMXE_BIT: u32 = 14;
pub const X86_CR4_FSGSBASE_BIT: u32 = 16;
pub const X86_CR4_PCIDE_BIT: u32 = 17;
pub const X86_CR4_OSXSAVE_BIT: u32 = 18;
pub const X86_CR4_SMEP_BIT: u32 = 20;
pub const X86_CR4_SMAP_BIT: u32 = 21;
pub const X86_CR4_PKE_BIT: u32 = 22;
pub const X86_CR4_CET_BIT: u32 = 23;
pub const X86_CR4_LAM_SUP_BIT: u32 = 28;
pub const X86_CR4_FRED_BIT: u32 = 32;
pub const CX86_PCR0: u32 = 32;
pub const CX86_GCR: u32 = 184;
pub const CX86_CCR0: u32 = 192;
pub const CX86_CCR1: u32 = 193;
pub const CX86_CCR2: u32 = 194;
pub const CX86_CCR3: u32 = 195;
pub const CX86_CCR4: u32 = 232;
pub const CX86_CCR5: u32 = 233;
pub const CX86_CCR6: u32 = 234;
pub const CX86_CCR7: u32 = 235;
pub const CX86_PCR1: u32 = 240;
pub const CX86_DIR0: u32 = 254;
pub const CX86_DIR1: u32 = 255;
pub const CX86_ARR_BASE: u32 = 196;
pub const CX86_RCR_BASE: u32 = 220;
pub const X86_VM_MASK: u32 = 0;
pub const CR3_PCID_MASK: u32 = 4095;
pub const X86_CR3_PTI_PCID_USER_BIT: u32 = 11;
pub const NCAPINTS: u32 = 22;
pub const NBUGINTS: u32 = 2;
pub const X86_FEATURE_FPU: u32 = 0;
pub const X86_FEATURE_VME: u32 = 1;
pub const X86_FEATURE_DE: u32 = 2;
pub const X86_FEATURE_PSE: u32 = 3;
pub const X86_FEATURE_TSC: u32 = 4;
pub const X86_FEATURE_MSR: u32 = 5;
pub const X86_FEATURE_PAE: u32 = 6;
pub const X86_FEATURE_MCE: u32 = 7;
pub const X86_FEATURE_CX8: u32 = 8;
pub const X86_FEATURE_APIC: u32 = 9;
pub const X86_FEATURE_SEP: u32 = 11;
pub const X86_FEATURE_MTRR: u32 = 12;
pub const X86_FEATURE_PGE: u32 = 13;
pub const X86_FEATURE_MCA: u32 = 14;
pub const X86_FEATURE_CMOV: u32 = 15;
pub const X86_FEATURE_PAT: u32 = 16;
pub const X86_FEATURE_PSE36: u32 = 17;
pub const X86_FEATURE_PN: u32 = 18;
pub const X86_FEATURE_CLFLUSH: u32 = 19;
pub const X86_FEATURE_DS: u32 = 21;
pub const X86_FEATURE_ACPI: u32 = 22;
pub const X86_FEATURE_MMX: u32 = 23;
pub const X86_FEATURE_FXSR: u32 = 24;
pub const X86_FEATURE_XMM: u32 = 25;
pub const X86_FEATURE_XMM2: u32 = 26;
pub const X86_FEATURE_SELFSNOOP: u32 = 27;
pub const X86_FEATURE_HT: u32 = 28;
pub const X86_FEATURE_ACC: u32 = 29;
pub const X86_FEATURE_IA64: u32 = 30;
pub const X86_FEATURE_PBE: u32 = 31;
pub const X86_FEATURE_SYSCALL: u32 = 43;
pub const X86_FEATURE_MP: u32 = 51;
pub const X86_FEATURE_NX: u32 = 52;
pub const X86_FEATURE_MMXEXT: u32 = 54;
pub const X86_FEATURE_FXSR_OPT: u32 = 57;
pub const X86_FEATURE_GBPAGES: u32 = 58;
pub const X86_FEATURE_RDTSCP: u32 = 59;
pub const X86_FEATURE_LM: u32 = 61;
pub const X86_FEATURE_3DNOWEXT: u32 = 62;
pub const X86_FEATURE_3DNOW: u32 = 63;
pub const X86_FEATURE_RECOVERY: u32 = 64;
pub const X86_FEATURE_LONGRUN: u32 = 65;
pub const X86_FEATURE_LRTI: u32 = 67;
pub const X86_FEATURE_CXMMX: u32 = 96;
pub const X86_FEATURE_K6_MTRR: u32 = 97;
pub const X86_FEATURE_CYRIX_ARR: u32 = 98;
pub const X86_FEATURE_CENTAUR_MCR: u32 = 99;
pub const X86_FEATURE_K8: u32 = 100;
pub const X86_FEATURE_ZEN5: u32 = 101;
pub const X86_FEATURE_ZEN6: u32 = 102;
pub const X86_FEATURE_CONSTANT_TSC: u32 = 104;
pub const X86_FEATURE_UP: u32 = 105;
pub const X86_FEATURE_ART: u32 = 106;
pub const X86_FEATURE_ARCH_PERFMON: u32 = 107;
pub const X86_FEATURE_PEBS: u32 = 108;
pub const X86_FEATURE_BTS: u32 = 109;
pub const X86_FEATURE_SYSCALL32: u32 = 110;
pub const X86_FEATURE_SYSENTER32: u32 = 111;
pub const X86_FEATURE_REP_GOOD: u32 = 112;
pub const X86_FEATURE_AMD_LBR_V2: u32 = 113;
pub const X86_FEATURE_CLEAR_CPU_BUF: u32 = 114;
pub const X86_FEATURE_ACC_POWER: u32 = 115;
pub const X86_FEATURE_NOPL: u32 = 116;
pub const X86_FEATURE_ALWAYS: u32 = 117;
pub const X86_FEATURE_XTOPOLOGY: u32 = 118;
pub const X86_FEATURE_TSC_RELIABLE: u32 = 119;
pub const X86_FEATURE_NONSTOP_TSC: u32 = 120;
pub const X86_FEATURE_CPUID: u32 = 121;
pub const X86_FEATURE_EXTD_APICID: u32 = 122;
pub const X86_FEATURE_AMD_DCM: u32 = 123;
pub const X86_FEATURE_APERFMPERF: u32 = 124;
pub const X86_FEATURE_RAPL: u32 = 125;
pub const X86_FEATURE_NONSTOP_TSC_S3: u32 = 126;
pub const X86_FEATURE_TSC_KNOWN_FREQ: u32 = 127;
pub const X86_FEATURE_XMM3: u32 = 128;
pub const X86_FEATURE_PCLMULQDQ: u32 = 129;
pub const X86_FEATURE_DTES64: u32 = 130;
pub const X86_FEATURE_MWAIT: u32 = 131;
pub const X86_FEATURE_DSCPL: u32 = 132;
pub const X86_FEATURE_VMX: u32 = 133;
pub const X86_FEATURE_SMX: u32 = 134;
pub const X86_FEATURE_EST: u32 = 135;
pub const X86_FEATURE_TM2: u32 = 136;
pub const X86_FEATURE_SSSE3: u32 = 137;
pub const X86_FEATURE_CID: u32 = 138;
pub const X86_FEATURE_SDBG: u32 = 139;
pub const X86_FEATURE_FMA: u32 = 140;
pub const X86_FEATURE_CX16: u32 = 141;
pub const X86_FEATURE_XTPR: u32 = 142;
pub const X86_FEATURE_PDCM: u32 = 143;
pub const X86_FEATURE_PCID: u32 = 145;
pub const X86_FEATURE_DCA: u32 = 146;
pub const X86_FEATURE_XMM4_1: u32 = 147;
pub const X86_FEATURE_XMM4_2: u32 = 148;
pub const X86_FEATURE_X2APIC: u32 = 149;
pub const X86_FEATURE_MOVBE: u32 = 150;
pub const X86_FEATURE_POPCNT: u32 = 151;
pub const X86_FEATURE_TSC_DEADLINE_TIMER: u32 = 152;
pub const X86_FEATURE_AES: u32 = 153;
pub const X86_FEATURE_XSAVE: u32 = 154;
pub const X86_FEATURE_OSXSAVE: u32 = 155;
pub const X86_FEATURE_AVX: u32 = 156;
pub const X86_FEATURE_F16C: u32 = 157;
pub const X86_FEATURE_RDRAND: u32 = 158;
pub const X86_FEATURE_HYPERVISOR: u32 = 159;
pub const X86_FEATURE_XSTORE: u32 = 162;
pub const X86_FEATURE_XSTORE_EN: u32 = 163;
pub const X86_FEATURE_XCRYPT: u32 = 166;
pub const X86_FEATURE_XCRYPT_EN: u32 = 167;
pub const X86_FEATURE_ACE2: u32 = 168;
pub const X86_FEATURE_ACE2_EN: u32 = 169;
pub const X86_FEATURE_PHE: u32 = 170;
pub const X86_FEATURE_PHE_EN: u32 = 171;
pub const X86_FEATURE_PMM: u32 = 172;
pub const X86_FEATURE_PMM_EN: u32 = 173;
pub const X86_FEATURE_LAHF_LM: u32 = 192;
pub const X86_FEATURE_CMP_LEGACY: u32 = 193;
pub const X86_FEATURE_SVM: u32 = 194;
pub const X86_FEATURE_EXTAPIC: u32 = 195;
pub const X86_FEATURE_CR8_LEGACY: u32 = 196;
pub const X86_FEATURE_ABM: u32 = 197;
pub const X86_FEATURE_SSE4A: u32 = 198;
pub const X86_FEATURE_MISALIGNSSE: u32 = 199;
pub const X86_FEATURE_3DNOWPREFETCH: u32 = 200;
pub const X86_FEATURE_OSVW: u32 = 201;
pub const X86_FEATURE_IBS: u32 = 202;
pub const X86_FEATURE_XOP: u32 = 203;
pub const X86_FEATURE_SKINIT: u32 = 204;
pub const X86_FEATURE_WDT: u32 = 205;
pub const X86_FEATURE_LWP: u32 = 207;
pub const X86_FEATURE_FMA4: u32 = 208;
pub const X86_FEATURE_TCE: u32 = 209;
pub const X86_FEATURE_NODEID_MSR: u32 = 211;
pub const X86_FEATURE_TBM: u32 = 213;
pub const X86_FEATURE_TOPOEXT: u32 = 214;
pub const X86_FEATURE_PERFCTR_CORE: u32 = 215;
pub const X86_FEATURE_PERFCTR_NB: u32 = 216;
pub const X86_FEATURE_BPEXT: u32 = 218;
pub const X86_FEATURE_PTSC: u32 = 219;
pub const X86_FEATURE_PERFCTR_LLC: u32 = 220;
pub const X86_FEATURE_MWAITX: u32 = 221;
pub const X86_FEATURE_RING3MWAIT: u32 = 224;
pub const X86_FEATURE_CPUID_FAULT: u32 = 225;
pub const X86_FEATURE_CPB: u32 = 226;
pub const X86_FEATURE_EPB: u32 = 227;
pub const X86_FEATURE_CAT_L3: u32 = 228;
pub const X86_FEATURE_CAT_L2: u32 = 229;
pub const X86_FEATURE_CDP_L3: u32 = 230;
pub const X86_FEATURE_TDX_HOST_PLATFORM: u32 = 231;
pub const X86_FEATURE_HW_PSTATE: u32 = 232;
pub const X86_FEATURE_PROC_FEEDBACK: u32 = 233;
pub const X86_FEATURE_XCOMPACTED: u32 = 234;
pub const X86_FEATURE_PTI: u32 = 235;
pub const X86_FEATURE_KERNEL_IBRS: u32 = 236;
pub const X86_FEATURE_RSB_VMEXIT: u32 = 237;
pub const X86_FEATURE_INTEL_PPIN: u32 = 238;
pub const X86_FEATURE_CDP_L2: u32 = 239;
pub const X86_FEATURE_MSR_SPEC_CTRL: u32 = 240;
pub const X86_FEATURE_SSBD: u32 = 241;
pub const X86_FEATURE_MBA: u32 = 242;
pub const X86_FEATURE_RSB_CTXSW: u32 = 243;
pub const X86_FEATURE_PERFMON_V2: u32 = 244;
pub const X86_FEATURE_USE_IBRS_FW: u32 = 246;
pub const X86_FEATURE_SPEC_STORE_BYPASS_DISABLE: u32 = 247;
pub const X86_FEATURE_LS_CFG_SSBD: u32 = 248;
pub const X86_FEATURE_IBRS: u32 = 249;
pub const X86_FEATURE_IBPB: u32 = 250;
pub const X86_FEATURE_STIBP: u32 = 251;
pub const X86_FEATURE_ZEN: u32 = 252;
pub const X86_FEATURE_L1TF_PTEINV: u32 = 253;
pub const X86_FEATURE_IBRS_ENHANCED: u32 = 254;
pub const X86_FEATURE_MSR_IA32_FEAT_CTL: u32 = 255;
pub const X86_FEATURE_TPR_SHADOW: u32 = 256;
pub const X86_FEATURE_FLEXPRIORITY: u32 = 257;
pub const X86_FEATURE_EPT: u32 = 258;
pub const X86_FEATURE_VPID: u32 = 259;
pub const X86_FEATURE_COHERENCY_SFW_NO: u32 = 260;
pub const X86_FEATURE_VMMCALL: u32 = 271;
pub const X86_FEATURE_XENPV: u32 = 272;
pub const X86_FEATURE_EPT_AD: u32 = 273;
pub const X86_FEATURE_VMCALL: u32 = 274;
pub const X86_FEATURE_VMW_VMMCALL: u32 = 275;
pub const X86_FEATURE_PVUNLOCK: u32 = 276;
pub const X86_FEATURE_VCPUPREEMPT: u32 = 277;
pub const X86_FEATURE_TDX_GUEST: u32 = 278;
pub const X86_FEATURE_FSGSBASE: u32 = 288;
pub const X86_FEATURE_TSC_ADJUST: u32 = 289;
pub const X86_FEATURE_SGX: u32 = 290;
pub const X86_FEATURE_BMI1: u32 = 291;
pub const X86_FEATURE_HLE: u32 = 292;
pub const X86_FEATURE_AVX2: u32 = 293;
pub const X86_FEATURE_FDP_EXCPTN_ONLY: u32 = 294;
pub const X86_FEATURE_SMEP: u32 = 295;
pub const X86_FEATURE_BMI2: u32 = 296;
pub const X86_FEATURE_ERMS: u32 = 297;
pub const X86_FEATURE_INVPCID: u32 = 298;
pub const X86_FEATURE_RTM: u32 = 299;
pub const X86_FEATURE_CQM: u32 = 300;
pub const X86_FEATURE_ZERO_FCS_FDS: u32 = 301;
pub const X86_FEATURE_MPX: u32 = 302;
pub const X86_FEATURE_RDT_A: u32 = 303;
pub const X86_FEATURE_AVX512F: u32 = 304;
pub const X86_FEATURE_AVX512DQ: u32 = 305;
pub const X86_FEATURE_RDSEED: u32 = 306;
pub const X86_FEATURE_ADX: u32 = 307;
pub const X86_FEATURE_SMAP: u32 = 308;
pub const X86_FEATURE_AVX512IFMA: u32 = 309;
pub const X86_FEATURE_CLFLUSHOPT: u32 = 311;
pub const X86_FEATURE_CLWB: u32 = 312;
pub const X86_FEATURE_INTEL_PT: u32 = 313;
pub const X86_FEATURE_AVX512PF: u32 = 314;
pub const X86_FEATURE_AVX512ER: u32 = 315;
pub const X86_FEATURE_AVX512CD: u32 = 316;
pub const X86_FEATURE_SHA_NI: u32 = 317;
pub const X86_FEATURE_AVX512BW: u32 = 318;
pub const X86_FEATURE_AVX512VL: u32 = 319;
pub const X86_FEATURE_XSAVEOPT: u32 = 320;
pub const X86_FEATURE_XSAVEC: u32 = 321;
pub const X86_FEATURE_XGETBV1: u32 = 322;
pub const X86_FEATURE_XSAVES: u32 = 323;
pub const X86_FEATURE_XFD: u32 = 324;
pub const X86_FEATURE_CQM_LLC: u32 = 352;
pub const X86_FEATURE_CQM_OCCUP_LLC: u32 = 353;
pub const X86_FEATURE_CQM_MBM_TOTAL: u32 = 354;
pub const X86_FEATURE_CQM_MBM_LOCAL: u32 = 355;
pub const X86_FEATURE_FENCE_SWAPGS_USER: u32 = 356;
pub const X86_FEATURE_FENCE_SWAPGS_KERNEL: u32 = 357;
pub const X86_FEATURE_SPLIT_LOCK_DETECT: u32 = 358;
pub const X86_FEATURE_PER_THREAD_MBA: u32 = 359;
pub const X86_FEATURE_SGX1: u32 = 360;
pub const X86_FEATURE_SGX2: u32 = 361;
pub const X86_FEATURE_ENTRY_IBPB: u32 = 362;
pub const X86_FEATURE_RRSBA_CTRL: u32 = 363;
pub const X86_FEATURE_RETPOLINE: u32 = 364;
pub const X86_FEATURE_RETPOLINE_LFENCE: u32 = 365;
pub const X86_FEATURE_RETHUNK: u32 = 366;
pub const X86_FEATURE_UNRET: u32 = 367;
pub const X86_FEATURE_USE_IBPB_FW: u32 = 368;
pub const X86_FEATURE_RSB_VMEXIT_LITE: u32 = 369;
pub const X86_FEATURE_SGX_EDECCSSA: u32 = 370;
pub const X86_FEATURE_CALL_DEPTH: u32 = 371;
pub const X86_FEATURE_MSR_TSX_CTRL: u32 = 372;
pub const X86_FEATURE_SMBA: u32 = 373;
pub const X86_FEATURE_BMEC: u32 = 374;
pub const X86_FEATURE_USER_SHSTK: u32 = 375;
pub const X86_FEATURE_SRSO: u32 = 376;
pub const X86_FEATURE_SRSO_ALIAS: u32 = 377;
pub const X86_FEATURE_IBPB_ON_VMEXIT: u32 = 378;
pub const X86_FEATURE_APIC_MSRS_FENCE: u32 = 379;
pub const X86_FEATURE_ZEN2: u32 = 380;
pub const X86_FEATURE_ZEN3: u32 = 381;
pub const X86_FEATURE_ZEN4: u32 = 382;
pub const X86_FEATURE_ZEN1: u32 = 383;
pub const X86_FEATURE_SHA512: u32 = 384;
pub const X86_FEATURE_SM3: u32 = 385;
pub const X86_FEATURE_SM4: u32 = 386;
pub const X86_FEATURE_AVX_VNNI: u32 = 388;
pub const X86_FEATURE_AVX512_BF16: u32 = 389;
pub const X86_FEATURE_CMPCCXADD: u32 = 391;
pub const X86_FEATURE_ARCH_PERFMON_EXT: u32 = 392;
pub const X86_FEATURE_FZRM: u32 = 394;
pub const X86_FEATURE_FSRS: u32 = 395;
pub const X86_FEATURE_FSRC: u32 = 396;
pub const X86_FEATURE_FRED: u32 = 401;
pub const X86_FEATURE_LKGS: u32 = 402;
pub const X86_FEATURE_WRMSRNS: u32 = 403;
pub const X86_FEATURE_AMX_FP16: u32 = 405;
pub const X86_FEATURE_AVX_IFMA: u32 = 407;
pub const X86_FEATURE_LAM: u32 = 410;
pub const X86_FEATURE_CLZERO: u32 = 416;
pub const X86_FEATURE_IRPERF: u32 = 417;
pub const X86_FEATURE_XSAVEERPTR: u32 = 418;
pub const X86_FEATURE_INVLPGB: u32 = 419;
pub const X86_FEATURE_RDPRU: u32 = 420;
pub const X86_FEATURE_WBNOINVD: u32 = 425;
pub const X86_FEATURE_AMD_IBPB: u32 = 428;
pub const X86_FEATURE_AMD_IBRS: u32 = 430;
pub const X86_FEATURE_AMD_STIBP: u32 = 431;
pub const X86_FEATURE_AMD_STIBP_ALWAYS_ON: u32 = 433;
pub const X86_FEATURE_AMD_IBRS_SAME_MODE: u32 = 435;
pub const X86_FEATURE_AMD_PPIN: u32 = 439;
pub const X86_FEATURE_AMD_SSBD: u32 = 440;
pub const X86_FEATURE_VIRT_SSBD: u32 = 441;
pub const X86_FEATURE_AMD_SSB_NO: u32 = 442;
pub const X86_FEATURE_CPPC: u32 = 443;
pub const X86_FEATURE_AMD_PSFD: u32 = 444;
pub const X86_FEATURE_BTC_NO: u32 = 445;
pub const X86_FEATURE_AMD_IBPB_RET: u32 = 446;
pub const X86_FEATURE_BRS: u32 = 447;
pub const X86_FEATURE_DTHERM: u32 = 448;
pub const X86_FEATURE_IDA: u32 = 449;
pub const X86_FEATURE_ARAT: u32 = 450;
pub const X86_FEATURE_PLN: u32 = 452;
pub const X86_FEATURE_PTS: u32 = 454;
pub const X86_FEATURE_HWP: u32 = 455;
pub const X86_FEATURE_HWP_NOTIFY: u32 = 456;
pub const X86_FEATURE_HWP_ACT_WINDOW: u32 = 457;
pub const X86_FEATURE_HWP_EPP: u32 = 458;
pub const X86_FEATURE_HWP_PKG_REQ: u32 = 459;
pub const X86_FEATURE_HWP_HIGHEST_PERF_CHANGE: u32 = 463;
pub const X86_FEATURE_HFI: u32 = 467;
pub const X86_FEATURE_NPT: u32 = 480;
pub const X86_FEATURE_LBRV: u32 = 481;
pub const X86_FEATURE_SVML: u32 = 482;
pub const X86_FEATURE_NRIPS: u32 = 483;
pub const X86_FEATURE_TSCRATEMSR: u32 = 484;
pub const X86_FEATURE_VMCBCLEAN: u32 = 485;
pub const X86_FEATURE_FLUSHBYASID: u32 = 486;
pub const X86_FEATURE_DECODEASSISTS: u32 = 487;
pub const X86_FEATURE_PAUSEFILTER: u32 = 490;
pub const X86_FEATURE_PFTHRESHOLD: u32 = 492;
pub const X86_FEATURE_AVIC: u32 = 493;
pub const X86_FEATURE_V_VMSAVE_VMLOAD: u32 = 495;
pub const X86_FEATURE_VGIF: u32 = 496;
pub const X86_FEATURE_X2AVIC: u32 = 498;
pub const X86_FEATURE_V_SPEC_CTRL: u32 = 500;
pub const X86_FEATURE_VNMI: u32 = 505;
pub const X86_FEATURE_SVME_ADDR_CHK: u32 = 508;
pub const X86_FEATURE_BUS_LOCK_THRESHOLD: u32 = 509;
pub const X86_FEATURE_IDLE_HLT: u32 = 510;
pub const X86_FEATURE_AVX512VBMI: u32 = 513;
pub const X86_FEATURE_UMIP: u32 = 514;
pub const X86_FEATURE_PKU: u32 = 515;
pub const X86_FEATURE_OSPKE: u32 = 516;
pub const X86_FEATURE_WAITPKG: u32 = 517;
pub const X86_FEATURE_AVX512_VBMI2: u32 = 518;
pub const X86_FEATURE_SHSTK: u32 = 519;
pub const X86_FEATURE_GFNI: u32 = 520;
pub const X86_FEATURE_VAES: u32 = 521;
pub const X86_FEATURE_VPCLMULQDQ: u32 = 522;
pub const X86_FEATURE_AVX512_VNNI: u32 = 523;
pub const X86_FEATURE_AVX512_BITALG: u32 = 524;
pub const X86_FEATURE_TME: u32 = 525;
pub const X86_FEATURE_AVX512_VPOPCNTDQ: u32 = 526;
pub const X86_FEATURE_LA57: u32 = 528;
pub const X86_FEATURE_RDPID: u32 = 534;
pub const X86_FEATURE_BUS_LOCK_DETECT: u32 = 536;
pub const X86_FEATURE_CLDEMOTE: u32 = 537;
pub const X86_FEATURE_MOVDIRI: u32 = 539;
pub const X86_FEATURE_MOVDIR64B: u32 = 540;
pub const X86_FEATURE_ENQCMD: u32 = 541;
pub const X86_FEATURE_SGX_LC: u32 = 542;
pub const X86_FEATURE_OVERFLOW_RECOV: u32 = 544;
pub const X86_FEATURE_SUCCOR: u32 = 545;
pub const X86_FEATURE_SMCA: u32 = 547;
pub const X86_FEATURE_AVX512_4VNNIW: u32 = 578;
pub const X86_FEATURE_AVX512_4FMAPS: u32 = 579;
pub const X86_FEATURE_FSRM: u32 = 580;
pub const X86_FEATURE_AVX512_VP2INTERSECT: u32 = 584;
pub const X86_FEATURE_SRBDS_CTRL: u32 = 585;
pub const X86_FEATURE_MD_CLEAR: u32 = 586;
pub const X86_FEATURE_RTM_ALWAYS_ABORT: u32 = 587;
pub const X86_FEATURE_TSX_FORCE_ABORT: u32 = 589;
pub const X86_FEATURE_SERIALIZE: u32 = 590;
pub const X86_FEATURE_HYBRID_CPU: u32 = 591;
pub const X86_FEATURE_TSXLDTRK: u32 = 592;
pub const X86_FEATURE_PCONFIG: u32 = 594;
pub const X86_FEATURE_ARCH_LBR: u32 = 595;
pub const X86_FEATURE_IBT: u32 = 596;
pub const X86_FEATURE_AMX_BF16: u32 = 598;
pub const X86_FEATURE_AVX512_FP16: u32 = 599;
pub const X86_FEATURE_AMX_TILE: u32 = 600;
pub const X86_FEATURE_AMX_INT8: u32 = 601;
pub const X86_FEATURE_SPEC_CTRL: u32 = 602;
pub const X86_FEATURE_INTEL_STIBP: u32 = 603;
pub const X86_FEATURE_FLUSH_L1D: u32 = 604;
pub const X86_FEATURE_ARCH_CAPABILITIES: u32 = 605;
pub const X86_FEATURE_CORE_CAPABILITIES: u32 = 606;
pub const X86_FEATURE_SPEC_CTRL_SSBD: u32 = 607;
pub const X86_FEATURE_SME: u32 = 608;
pub const X86_FEATURE_SEV: u32 = 609;
pub const X86_FEATURE_VM_PAGE_FLUSH: u32 = 610;
pub const X86_FEATURE_SEV_ES: u32 = 611;
pub const X86_FEATURE_SEV_SNP: u32 = 612;
pub const X86_FEATURE_SNP_SECURE_TSC: u32 = 616;
pub const X86_FEATURE_V_TSC_AUX: u32 = 617;
pub const X86_FEATURE_SME_COHERENT: u32 = 618;
pub const X86_FEATURE_DEBUG_SWAP: u32 = 622;
pub const X86_FEATURE_RMPREAD: u32 = 629;
pub const X86_FEATURE_SEGMENTED_RMP: u32 = 631;
pub const X86_FEATURE_ALLOWED_SEV_FEATURES: u32 = 635;
pub const X86_FEATURE_SVSM: u32 = 636;
pub const X86_FEATURE_HV_INUSE_WR_ALLOWED: u32 = 638;
pub const X86_FEATURE_NO_NESTED_DATA_BP: u32 = 640;
pub const X86_FEATURE_WRMSR_XX_BASE_NS: u32 = 641;
pub const X86_FEATURE_LFENCE_RDTSC: u32 = 642;
pub const X86_FEATURE_VERW_CLEAR: u32 = 645;
pub const X86_FEATURE_NULL_SEL_CLR_BASE: u32 = 646;
pub const X86_FEATURE_AUTOIBRS: u32 = 648;
pub const X86_FEATURE_NO_SMM_CTL_MSR: u32 = 649;
pub const X86_FEATURE_GP_ON_USER_CPUID: u32 = 657;
pub const X86_FEATURE_PREFETCHI: u32 = 660;
pub const X86_FEATURE_SBPB: u32 = 667;
pub const X86_FEATURE_IBPB_BRTYPE: u32 = 668;
pub const X86_FEATURE_SRSO_NO: u32 = 669;
pub const X86_FEATURE_SRSO_USER_KERNEL_NO: u32 = 670;
pub const X86_FEATURE_SRSO_BP_SPEC_REDUCE: u32 = 671;
pub const X86_FEATURE_AMD_LBR_PMC_FREEZE: u32 = 672;
pub const X86_FEATURE_CLEAR_BHB_LOOP: u32 = 673;
pub const X86_FEATURE_BHI_CTRL: u32 = 674;
pub const X86_FEATURE_CLEAR_BHB_HW: u32 = 675;
pub const X86_FEATURE_CLEAR_BHB_VMEXIT: u32 = 676;
pub const X86_FEATURE_AMD_FAST_CPPC: u32 = 677;
pub const X86_FEATURE_AMD_HTR_CORES: u32 = 678;
pub const X86_FEATURE_AMD_WORKLOAD_CLASS: u32 = 679;
pub const X86_FEATURE_PREFER_YMM: u32 = 680;
pub const X86_FEATURE_APX: u32 = 681;
pub const X86_FEATURE_INDIRECT_THUNK_ITS: u32 = 682;
pub const X86_FEATURE_TSA_SQ_NO: u32 = 683;
pub const X86_FEATURE_TSA_L1_NO: u32 = 684;
pub const X86_FEATURE_CLEAR_CPU_BUF_VM: u32 = 685;
pub const X86_FEATURE_IBPB_EXIT_TO_USER: u32 = 686;
pub const X86_FEATURE_ABMC: u32 = 687;
pub const X86_FEATURE_MSR_IMM: u32 = 688;
pub const MSR_EFER: u32 = 3221225600;
pub const MSR_STAR: u32 = 3221225601;
pub const MSR_LSTAR: u32 = 3221225602;
pub const MSR_CSTAR: u32 = 3221225603;
pub const MSR_SYSCALL_MASK: u32 = 3221225604;
pub const MSR_FS_BASE: u32 = 3221225728;
pub const MSR_GS_BASE: u32 = 3221225729;
pub const MSR_KERNEL_GS_BASE: u32 = 3221225730;
pub const MSR_TSC_AUX: u32 = 3221225731;
pub const _EFER_SCE: u32 = 0;
pub const _EFER_LME: u32 = 8;
pub const _EFER_LMA: u32 = 10;
pub const _EFER_NX: u32 = 11;
pub const _EFER_SVME: u32 = 12;
pub const _EFER_LMSLE: u32 = 13;
pub const _EFER_FFXSR: u32 = 14;
pub const _EFER_TCE: u32 = 15;
pub const _EFER_AUTOIBRS: u32 = 21;
pub const EFER_SCE: u32 = 1;
pub const EFER_LME: u32 = 256;
pub const EFER_LMA: u32 = 1024;
pub const EFER_NX: u32 = 2048;
pub const EFER_SVME: u32 = 4096;
pub const EFER_LMSLE: u32 = 8192;
pub const EFER_FFXSR: u32 = 16384;
pub const EFER_TCE: u32 = 32768;
pub const EFER_AUTOIBRS: u32 = 2097152;
pub const X86_MEMTYPE_UC: u32 = 0;
pub const X86_MEMTYPE_WC: u32 = 1;
pub const X86_MEMTYPE_WT: u32 = 4;
pub const X86_MEMTYPE_WP: u32 = 5;
pub const X86_MEMTYPE_WB: u32 = 6;
pub const X86_MEMTYPE_UC_MINUS: u32 = 7;
pub const MSR_IA32_FRED_RSP0: u32 = 460;
pub const MSR_IA32_FRED_RSP1: u32 = 461;
pub const MSR_IA32_FRED_RSP2: u32 = 462;
pub const MSR_IA32_FRED_RSP3: u32 = 463;
pub const MSR_IA32_FRED_STKLVLS: u32 = 464;
pub const MSR_IA32_FRED_SSP1: u32 = 465;
pub const MSR_IA32_FRED_SSP2: u32 = 466;
pub const MSR_IA32_FRED_SSP3: u32 = 467;
pub const MSR_IA32_FRED_CONFIG: u32 = 468;
pub const MSR_TEST_CTRL: u32 = 51;
pub const MSR_TEST_CTRL_SPLIT_LOCK_DETECT_BIT: u32 = 29;
pub const MSR_IA32_SPEC_CTRL: u32 = 72;
pub const SPEC_CTRL_STIBP_SHIFT: u32 = 1;
pub const SPEC_CTRL_SSBD_SHIFT: u32 = 2;
pub const SPEC_CTRL_RRSBA_DIS_S_SHIFT: u32 = 6;
pub const SPEC_CTRL_BHI_DIS_S_SHIFT: u32 = 10;
pub const MSR_IA32_PRED_CMD: u32 = 73;
pub const MSR_PPIN_CTL: u32 = 78;
pub const MSR_PPIN: u32 = 79;
pub const MSR_IA32_PERFCTR0: u32 = 193;
pub const MSR_IA32_PERFCTR1: u32 = 194;
pub const MSR_FSB_FREQ: u32 = 205;
pub const MSR_PLATFORM_INFO: u32 = 206;
pub const MSR_PLATFORM_INFO_CPUID_FAULT_BIT: u32 = 31;
pub const MSR_IA32_UMWAIT_CONTROL: u32 = 225;
pub const MSR_IA32_UMWAIT_CONTROL_TIME_MASK: i32 = -4;
pub const MSR_IA32_CORE_CAPS: u32 = 207;
pub const MSR_IA32_CORE_CAPS_INTEGRITY_CAPS_BIT: u32 = 2;
pub const MSR_IA32_CORE_CAPS_SPLIT_LOCK_DETECT_BIT: u32 = 5;
pub const MSR_PKG_CST_CONFIG_CONTROL: u32 = 226;
pub const NHM_C3_AUTO_DEMOTE: u32 = 33554432;
pub const NHM_C1_AUTO_DEMOTE: u32 = 67108864;
pub const ATM_LNC_C6_AUTO_DEMOTE: u32 = 33554432;
pub const SNB_C3_AUTO_UNDEMOTE: u32 = 134217728;
pub const SNB_C1_AUTO_UNDEMOTE: u32 = 268435456;
pub const MSR_MTRRcap: u32 = 254;
pub const MSR_IA32_ARCH_CAPABILITIES: u32 = 266;
pub const MSR_IA32_FLUSH_CMD: u32 = 267;
pub const MSR_IA32_BBL_CR_CTL: u32 = 281;
pub const MSR_IA32_BBL_CR_CTL3: u32 = 286;
pub const MSR_IA32_TSX_CTRL: u32 = 290;
pub const MSR_IA32_MCU_OPT_CTRL: u32 = 291;
pub const MSR_IA32_SYSENTER_CS: u32 = 372;
pub const MSR_IA32_SYSENTER_ESP: u32 = 373;
pub const MSR_IA32_SYSENTER_EIP: u32 = 374;
pub const MSR_IA32_MCG_CAP: u32 = 377;
pub const MSR_IA32_MCG_STATUS: u32 = 378;
pub const MSR_IA32_MCG_CTL: u32 = 379;
pub const MSR_ERROR_CONTROL: u32 = 383;
pub const MSR_IA32_MCG_EXT_CTL: u32 = 1232;
pub const MSR_OFFCORE_RSP_0: u32 = 422;
pub const MSR_OFFCORE_RSP_1: u32 = 423;
pub const MSR_TURBO_RATIO_LIMIT: u32 = 429;
pub const MSR_TURBO_RATIO_LIMIT1: u32 = 430;
pub const MSR_TURBO_RATIO_LIMIT2: u32 = 431;
pub const MSR_SNOOP_RSP_0: u32 = 4904;
pub const MSR_SNOOP_RSP_1: u32 = 4905;
pub const MSR_LBR_SELECT: u32 = 456;
pub const MSR_LBR_TOS: u32 = 457;
pub const MSR_IA32_POWER_CTL: u32 = 508;
pub const MSR_IA32_POWER_CTL_BIT_EE: u32 = 19;
pub const MSR_INTEGRITY_CAPS: u32 = 729;
pub const MSR_INTEGRITY_CAPS_ARRAY_BIST_BIT: u32 = 2;
pub const MSR_INTEGRITY_CAPS_PERIODIC_BIST_BIT: u32 = 4;
pub const MSR_INTEGRITY_CAPS_SBAF_BIT: u32 = 8;
pub const MSR_LBR_NHM_FROM: u32 = 1664;
pub const MSR_LBR_NHM_TO: u32 = 1728;
pub const MSR_LBR_CORE_FROM: u32 = 64;
pub const MSR_LBR_CORE_TO: u32 = 96;
pub const MSR_LBR_INFO_0: u32 = 3520;
pub const LBR_INFO_CYCLES: u32 = 65535;
pub const LBR_INFO_BR_TYPE_OFFSET: u32 = 56;
pub const LBR_INFO_BR_TYPE: u64 = 1080863910568919040;
pub const LBR_INFO_BR_CNTR_OFFSET: u32 = 32;
pub const LBR_INFO_BR_CNTR_NUM: u32 = 4;
pub const LBR_INFO_BR_CNTR_BITS: u32 = 2;
pub const MSR_ARCH_LBR_CTL: u32 = 5326;
pub const ARCH_LBR_CTL_CPL_OFFSET: u32 = 1;
pub const ARCH_LBR_CTL_CPL: u32 = 6;
pub const ARCH_LBR_CTL_STACK_OFFSET: u32 = 3;
pub const ARCH_LBR_CTL_STACK: u32 = 8;
pub const ARCH_LBR_CTL_FILTER_OFFSET: u32 = 16;
pub const ARCH_LBR_CTL_FILTER: u32 = 8323072;
pub const MSR_ARCH_LBR_DEPTH: u32 = 5327;
pub const MSR_ARCH_LBR_FROM_0: u32 = 5376;
pub const MSR_ARCH_LBR_TO_0: u32 = 5632;
pub const MSR_ARCH_LBR_INFO_0: u32 = 4608;
pub const MSR_IA32_PEBS_ENABLE: u32 = 1009;
pub const MSR_PEBS_DATA_CFG: u32 = 1010;
pub const MSR_IA32_DS_AREA: u32 = 1536;
pub const MSR_IA32_PERF_CAPABILITIES: u32 = 837;
pub const PERF_CAP_METRICS_IDX: u32 = 15;
pub const PERF_CAP_PT_IDX: u32 = 16;
pub const MSR_PEBS_LD_LAT_THRESHOLD: u32 = 1014;
pub const PERF_CAP_LBR_FMT: u32 = 63;
pub const PERF_CAP_PEBS_FORMAT: u32 = 3840;
pub const MSR_IA32_RTIT_CTL: u32 = 1392;
pub const RTIT_CTL_MTC_RANGE_OFFSET: u32 = 14;
pub const RTIT_CTL_MTC_RANGE: u32 = 245760;
pub const RTIT_CTL_CYC_THRESH_OFFSET: u32 = 19;
pub const RTIT_CTL_CYC_THRESH: u32 = 7864320;
pub const RTIT_CTL_PSB_FREQ_OFFSET: u32 = 24;
pub const RTIT_CTL_PSB_FREQ: u32 = 251658240;
pub const RTIT_CTL_ADDR0_OFFSET: u32 = 32;
pub const RTIT_CTL_ADDR0: u64 = 64424509440;
pub const RTIT_CTL_ADDR1_OFFSET: u32 = 36;
pub const RTIT_CTL_ADDR1: u64 = 1030792151040;
pub const RTIT_CTL_ADDR2_OFFSET: u32 = 40;
pub const RTIT_CTL_ADDR2: u64 = 16492674416640;
pub const RTIT_CTL_ADDR3_OFFSET: u32 = 44;
pub const RTIT_CTL_ADDR3: u64 = 263882790666240;
pub const MSR_IA32_RTIT_STATUS: u32 = 1393;
pub const RTIT_STATUS_BYTECNT_OFFSET: u32 = 32;
pub const RTIT_STATUS_BYTECNT: u64 = 562945658454016;
pub const MSR_IA32_RTIT_ADDR0_A: u32 = 1408;
pub const MSR_IA32_RTIT_ADDR0_B: u32 = 1409;
pub const MSR_IA32_RTIT_ADDR1_A: u32 = 1410;
pub const MSR_IA32_RTIT_ADDR1_B: u32 = 1411;
pub const MSR_IA32_RTIT_ADDR2_A: u32 = 1412;
pub const MSR_IA32_RTIT_ADDR2_B: u32 = 1413;
pub const MSR_IA32_RTIT_ADDR3_A: u32 = 1414;
pub const MSR_IA32_RTIT_ADDR3_B: u32 = 1415;
pub const MSR_IA32_RTIT_CR3_MATCH: u32 = 1394;
pub const MSR_IA32_RTIT_OUTPUT_BASE: u32 = 1376;
pub const MSR_IA32_RTIT_OUTPUT_MASK: u32 = 1377;
pub const MSR_MTRRfix64K_00000: u32 = 592;
pub const MSR_MTRRfix16K_80000: u32 = 600;
pub const MSR_MTRRfix16K_A0000: u32 = 601;
pub const MSR_MTRRfix4K_C0000: u32 = 616;
pub const MSR_MTRRfix4K_C8000: u32 = 617;
pub const MSR_MTRRfix4K_D0000: u32 = 618;
pub const MSR_MTRRfix4K_D8000: u32 = 619;
pub const MSR_MTRRfix4K_E0000: u32 = 620;
pub const MSR_MTRRfix4K_E8000: u32 = 621;
pub const MSR_MTRRfix4K_F0000: u32 = 622;
pub const MSR_MTRRfix4K_F8000: u32 = 623;
pub const MSR_MTRRdefType: u32 = 767;
pub const MSR_IA32_CR_PAT: u32 = 631;
pub const MSR_IA32_DEBUGCTLMSR: u32 = 473;
pub const MSR_IA32_LASTBRANCHFROMIP: u32 = 475;
pub const MSR_IA32_LASTBRANCHTOIP: u32 = 476;
pub const MSR_IA32_LASTINTFROMIP: u32 = 477;
pub const MSR_IA32_LASTINTTOIP: u32 = 478;
pub const MSR_IA32_PASID: u32 = 3475;
pub const DEBUGCTLMSR_LBR_BIT: u32 = 0;
pub const DEBUGCTLMSR_LBR: u32 = 1;
pub const DEBUGCTLMSR_BTF_SHIFT: u32 = 1;
pub const DEBUGCTLMSR_BTF: u32 = 2;
pub const DEBUGCTLMSR_BUS_LOCK_DETECT: u32 = 4;
pub const DEBUGCTLMSR_TR: u32 = 64;
pub const DEBUGCTLMSR_BTS: u32 = 128;
pub const DEBUGCTLMSR_BTINT: u32 = 256;
pub const DEBUGCTLMSR_BTS_OFF_OS: u32 = 512;
pub const DEBUGCTLMSR_BTS_OFF_USR: u32 = 1024;
pub const DEBUGCTLMSR_FREEZE_LBRS_ON_PMI: u32 = 2048;
pub const DEBUGCTLMSR_FREEZE_PERFMON_ON_PMI: u32 = 4096;
pub const DEBUGCTLMSR_FREEZE_IN_SMM_BIT: u32 = 14;
pub const DEBUGCTLMSR_FREEZE_IN_SMM: u32 = 16384;
pub const MSR_PEBS_FRONTEND: u32 = 1015;
pub const MSR_IA32_MC0_CTL: u32 = 1024;
pub const MSR_IA32_MC0_STATUS: u32 = 1025;
pub const MSR_IA32_MC0_ADDR: u32 = 1026;
pub const MSR_IA32_MC0_MISC: u32 = 1027;
pub const MSR_PKG_C3_RESIDENCY: u32 = 1016;
pub const MSR_PKG_C6_RESIDENCY: u32 = 1017;
pub const MSR_ATOM_PKG_C6_RESIDENCY: u32 = 1018;
pub const MSR_PKG_C7_RESIDENCY: u32 = 1018;
pub const MSR_CORE_C3_RESIDENCY: u32 = 1020;
pub const MSR_CORE_C6_RESIDENCY: u32 = 1021;
pub const MSR_CORE_C7_RESIDENCY: u32 = 1022;
pub const MSR_KNL_CORE_C6_RESIDENCY: u32 = 1023;
pub const MSR_PKG_C2_RESIDENCY: u32 = 1549;
pub const MSR_PKG_C8_RESIDENCY: u32 = 1584;
pub const MSR_PKG_C9_RESIDENCY: u32 = 1585;
pub const MSR_PKG_C10_RESIDENCY: u32 = 1586;
pub const MSR_PKGC3_IRTL: u32 = 1546;
pub const MSR_PKGC6_IRTL: u32 = 1547;
pub const MSR_PKGC7_IRTL: u32 = 1548;
pub const MSR_PKGC8_IRTL: u32 = 1587;
pub const MSR_PKGC9_IRTL: u32 = 1588;
pub const MSR_PKGC10_IRTL: u32 = 1589;
pub const MSR_VR_CURRENT_CONFIG: u32 = 1537;
pub const MSR_RAPL_POWER_UNIT: u32 = 1542;
pub const MSR_PKG_POWER_LIMIT: u32 = 1552;
pub const MSR_PKG_ENERGY_STATUS: u32 = 1553;
pub const MSR_PKG_PERF_STATUS: u32 = 1555;
pub const MSR_PKG_POWER_INFO: u32 = 1556;
pub const MSR_DRAM_POWER_LIMIT: u32 = 1560;
pub const MSR_DRAM_ENERGY_STATUS: u32 = 1561;
pub const MSR_DRAM_PERF_STATUS: u32 = 1563;
pub const MSR_DRAM_POWER_INFO: u32 = 1564;
pub const MSR_PP0_POWER_LIMIT: u32 = 1592;
pub const MSR_PP0_ENERGY_STATUS: u32 = 1593;
pub const MSR_PP0_POLICY: u32 = 1594;
pub const MSR_PP0_PERF_STATUS: u32 = 1595;
pub const MSR_PP1_POWER_LIMIT: u32 = 1600;
pub const MSR_PP1_ENERGY_STATUS: u32 = 1601;
pub const MSR_PP1_POLICY: u32 = 1602;
pub const MSR_AMD_RAPL_POWER_UNIT: u32 = 3221291673;
pub const MSR_AMD_CORE_ENERGY_STATUS: u32 = 3221291674;
pub const MSR_AMD_PKG_ENERGY_STATUS: u32 = 3221291675;
pub const MSR_CONFIG_TDP_NOMINAL: u32 = 1608;
pub const MSR_CONFIG_TDP_LEVEL_1: u32 = 1609;
pub const MSR_CONFIG_TDP_LEVEL_2: u32 = 1610;
pub const MSR_CONFIG_TDP_CONTROL: u32 = 1611;
pub const MSR_TURBO_ACTIVATION_RATIO: u32 = 1612;
pub const MSR_PLATFORM_ENERGY_STATUS: u32 = 1613;
pub const MSR_SECONDARY_TURBO_RATIO_LIMIT: u32 = 1616;
pub const MSR_PKG_WEIGHTED_CORE_C0_RES: u32 = 1624;
pub const MSR_PKG_ANY_CORE_C0_RES: u32 = 1625;
pub const MSR_PKG_ANY_GFXE_C0_RES: u32 = 1626;
pub const MSR_PKG_BOTH_CORE_GFXE_C0_RES: u32 = 1627;
pub const MSR_CORE_C1_RES: u32 = 1632;
pub const MSR_MODULE_C6_RES_MS: u32 = 1636;
pub const MSR_CC6_DEMOTION_POLICY_CONFIG: u32 = 1640;
pub const MSR_MC6_DEMOTION_POLICY_CONFIG: u32 = 1641;
pub const MSR_ATOM_CORE_RATIOS: u32 = 1642;
pub const MSR_ATOM_CORE_VIDS: u32 = 1643;
pub const MSR_ATOM_CORE_TURBO_RATIOS: u32 = 1644;
pub const MSR_ATOM_CORE_TURBO_VIDS: u32 = 1645;
pub const MSR_CORE_PERF_LIMIT_REASONS: u32 = 1680;
pub const MSR_GFX_PERF_LIMIT_REASONS: u32 = 1712;
pub const MSR_RING_PERF_LIMIT_REASONS: u32 = 1713;
pub const MSR_IA32_U_CET: u32 = 1696;
pub const MSR_IA32_S_CET: u32 = 1698;
pub const MSR_IA32_PL0_SSP: u32 = 1700;
pub const MSR_IA32_PL1_SSP: u32 = 1701;
pub const MSR_IA32_PL2_SSP: u32 = 1702;
pub const MSR_IA32_PL3_SSP: u32 = 1703;
pub const MSR_IA32_INT_SSP_TAB: u32 = 1704;
pub const MSR_PPERF: u32 = 1614;
pub const MSR_PERF_LIMIT_REASONS: u32 = 1615;
pub const MSR_PM_ENABLE: u32 = 1904;
pub const MSR_HWP_CAPABILITIES: u32 = 1905;
pub const MSR_HWP_REQUEST_PKG: u32 = 1906;
pub const MSR_HWP_INTERRUPT: u32 = 1907;
pub const MSR_HWP_REQUEST: u32 = 1908;
pub const MSR_HWP_STATUS: u32 = 1911;
pub const HWP_BASE_BIT: u32 = 128;
pub const HWP_NOTIFICATIONS_BIT: u32 = 256;
pub const HWP_ACTIVITY_WINDOW_BIT: u32 = 512;
pub const HWP_ENERGY_PERF_PREFERENCE_BIT: u32 = 1024;
pub const HWP_PACKAGE_LEVEL_REQUEST_BIT: u32 = 2048;
pub const HWP_EPP_PERFORMANCE: u32 = 0;
pub const HWP_EPP_BALANCE_PERFORMANCE: u32 = 128;
pub const HWP_EPP_BALANCE_POWERSAVE: u32 = 192;
pub const HWP_EPP_POWERSAVE: u32 = 255;
pub const MSR_AMD64_MC0_MASK: u32 = 3221291076;
pub const MSR_IA32_MC0_CTL2: u32 = 640;
pub const MSR_P6_PERFCTR0: u32 = 193;
pub const MSR_P6_PERFCTR1: u32 = 194;
pub const MSR_P6_EVNTSEL0: u32 = 390;
pub const MSR_P6_EVNTSEL1: u32 = 391;
pub const MSR_KNC_PERFCTR0: u32 = 32;
pub const MSR_KNC_PERFCTR1: u32 = 33;
pub const MSR_KNC_EVNTSEL0: u32 = 40;
pub const MSR_KNC_EVNTSEL1: u32 = 41;
pub const MSR_IA32_PMC0: u32 = 1217;
pub const MSR_RELOAD_PMC0: u32 = 5313;
pub const MSR_RELOAD_FIXED_CTR0: u32 = 4873;
pub const MSR_IA32_PMC_V6_GP0_CTR: u32 = 6400;
pub const MSR_IA32_PMC_V6_GP0_CFG_A: u32 = 6401;
pub const MSR_IA32_PMC_V6_GP0_CFG_B: u32 = 6402;
pub const MSR_IA32_PMC_V6_GP0_CFG_C: u32 = 6403;
pub const MSR_IA32_PMC_V6_FX0_CTR: u32 = 6528;
pub const MSR_IA32_PMC_V6_FX0_CFG_B: u32 = 6530;
pub const MSR_IA32_PMC_V6_FX0_CFG_C: u32 = 6531;
pub const MSR_IA32_PMC_V6_STEP: u32 = 4;
pub const MSR_IA32_MKTME_KEYID_PARTITIONING: u32 = 135;
pub const MSR_AMD64_PATCH_LEVEL: u32 = 139;
pub const MSR_AMD64_TSC_RATIO: u32 = 3221225732;
pub const MSR_AMD64_NB_CFG: u32 = 3221291039;
pub const MSR_AMD64_PATCH_LOADER: u32 = 3221291040;
pub const MSR_AMD_PERF_CTL: u32 = 3221291106;
pub const MSR_AMD_PERF_STATUS: u32 = 3221291107;
pub const MSR_AMD_PSTATE_DEF_BASE: u32 = 3221291108;
pub const MSR_AMD64_GUEST_TSC_FREQ: u32 = 3221291316;
pub const MSR_AMD64_OSVW_ID_LENGTH: u32 = 3221291328;
pub const MSR_AMD64_OSVW_STATUS: u32 = 3221291329;
pub const MSR_AMD_PPIN_CTL: u32 = 3221291760;
pub const MSR_AMD_PPIN: u32 = 3221291761;
pub const MSR_AMD64_CPUID_FN_7: u32 = 3221295106;
pub const MSR_AMD64_CPUID_FN_1: u32 = 3221295108;
pub const MSR_AMD64_CPUID_EXT_FEAT: u32 = 3221295109;
pub const MSR_AMD64_CPUID_EXT_FEAT_TOPOEXT_BIT: u32 = 54;
pub const MSR_AMD64_LS_CFG: u32 = 3221295136;
pub const MSR_AMD64_DC_CFG: u32 = 3221295138;
pub const MSR_AMD64_TW_CFG: u32 = 3221295139;
pub const MSR_AMD64_DE_CFG: u32 = 3221295145;
pub const MSR_AMD64_DE_CFG_LFENCE_SERIALIZE_BIT: u32 = 1;
pub const MSR_AMD64_DE_CFG_ZEN2_FP_BACKUP_FIX_BIT: u32 = 9;
pub const MSR_AMD64_BU_CFG2: u32 = 3221295146;
pub const MSR_AMD64_IBSFETCHCTL: u32 = 3221295152;
pub const MSR_AMD64_IBSFETCHLINAD: u32 = 3221295153;
pub const MSR_AMD64_IBSFETCHPHYSAD: u32 = 3221295154;
pub const MSR_AMD64_IBSFETCH_REG_COUNT: u32 = 3;
pub const MSR_AMD64_IBSFETCH_REG_MASK: u32 = 7;
pub const MSR_AMD64_IBSOPCTL: u32 = 3221295155;
pub const MSR_AMD64_IBSOPRIP: u32 = 3221295156;
pub const MSR_AMD64_IBSOPDATA: u32 = 3221295157;
pub const MSR_AMD64_IBSOPDATA2: u32 = 3221295158;
pub const MSR_AMD64_IBSOPDATA3: u32 = 3221295159;
pub const MSR_AMD64_IBSDCLINAD: u32 = 3221295160;
pub const MSR_AMD64_IBSDCPHYSAD: u32 = 3221295161;
pub const MSR_AMD64_IBSOP_REG_COUNT: u32 = 7;
pub const MSR_AMD64_IBSOP_REG_MASK: u32 = 127;
pub const MSR_AMD64_IBSCTL: u32 = 3221295162;
pub const MSR_AMD64_IBSBRTARGET: u32 = 3221295163;
pub const MSR_AMD64_ICIBSEXTDCTL: u32 = 3221295164;
pub const MSR_AMD64_IBSOPDATA4: u32 = 3221295165;
pub const MSR_AMD64_IBS_REG_COUNT_MAX: u32 = 8;
pub const MSR_AMD64_SVM_AVIC_DOORBELL: u32 = 3221291291;
pub const MSR_AMD64_VM_PAGE_FLUSH: u32 = 3221291294;
pub const MSR_AMD64_VIRT_SPEC_CTRL: u32 = 3221291295;
pub const MSR_AMD64_SEV_ES_GHCB: u32 = 3221291312;
pub const MSR_AMD64_SEV: u32 = 3221291313;
pub const MSR_AMD64_SEV_ENABLED_BIT: u32 = 0;
pub const MSR_AMD64_SEV_ES_ENABLED_BIT: u32 = 1;
pub const MSR_AMD64_SEV_SNP_ENABLED_BIT: u32 = 2;
pub const MSR_AMD64_SNP_VTOM_BIT: u32 = 3;
pub const MSR_AMD64_SNP_REFLECT_VC_BIT: u32 = 4;
pub const MSR_AMD64_SNP_RESTRICTED_INJ_BIT: u32 = 5;
pub const MSR_AMD64_SNP_ALT_INJ_BIT: u32 = 6;
pub const MSR_AMD64_SNP_DEBUG_SWAP_BIT: u32 = 7;
pub const MSR_AMD64_SNP_PREVENT_HOST_IBS_BIT: u32 = 8;
pub const MSR_AMD64_SNP_BTB_ISOLATION_BIT: u32 = 9;
pub const MSR_AMD64_SNP_VMPL_SSS_BIT: u32 = 10;
pub const MSR_AMD64_SNP_SECURE_TSC_BIT: u32 = 11;
pub const MSR_AMD64_SNP_VMGEXIT_PARAM_BIT: u32 = 12;
pub const MSR_AMD64_SNP_IBS_VIRT_BIT: u32 = 14;
pub const MSR_AMD64_SNP_VMSA_REG_PROT_BIT: u32 = 16;
pub const MSR_AMD64_SNP_SMT_PROT_BIT: u32 = 17;
pub const MSR_AMD64_SNP_SECURE_AVIC_BIT: u32 = 18;
pub const MSR_AMD64_SNP_RESV_BIT: u32 = 19;
pub const MSR_AMD64_SAVIC_CONTROL: u32 = 3221291320;
pub const MSR_AMD64_SAVIC_EN_BIT: u32 = 0;
pub const MSR_AMD64_SAVIC_ALLOWEDNMI_BIT: u32 = 1;
pub const MSR_AMD64_RMP_BASE: u32 = 3221291314;
pub const MSR_AMD64_RMP_END: u32 = 3221291315;
pub const MSR_AMD64_RMP_CFG: u32 = 3221291318;
pub const MSR_AMD64_SEG_RMP_ENABLED_BIT: u32 = 0;
pub const MSR_SVSM_CAA: u32 = 3221352448;
pub const MSR_AMD_CPPC_CAP1: u32 = 3221291696;
pub const MSR_AMD_CPPC_ENABLE: u32 = 3221291697;
pub const MSR_AMD_CPPC_CAP2: u32 = 3221291698;
pub const MSR_AMD_CPPC_REQ: u32 = 3221291699;
pub const MSR_AMD_CPPC_STATUS: u32 = 3221291700;
pub const MSR_AMD64_PERF_CNTR_GLOBAL_STATUS: u32 = 3221226240;
pub const MSR_AMD64_PERF_CNTR_GLOBAL_CTL: u32 = 3221226241;
pub const MSR_AMD64_PERF_CNTR_GLOBAL_STATUS_CLR: u32 = 3221226242;
pub const MSR_AMD64_PERF_CNTR_GLOBAL_STATUS_SET: u32 = 3221226243;
pub const MSR_AMD_WORKLOAD_CLASS_CONFIG: u32 = 3221226752;
pub const MSR_AMD_WORKLOAD_CLASS_ID: u32 = 3221226753;
pub const MSR_AMD_WORKLOAD_HRST: u32 = 3221226754;
pub const MSR_AMD64_LBR_SELECT: u32 = 3221225742;
pub const MSR_ZEN4_BP_CFG: u32 = 3221295150;
pub const MSR_ZEN4_BP_CFG_BP_SPEC_REDUCE_BIT: u32 = 4;
pub const MSR_ZEN4_BP_CFG_SHARED_BTB_FIX_BIT: u32 = 5;
pub const MSR_F19H_UMC_PERF_CTL: u32 = 3221293056;
pub const MSR_F19H_UMC_PERF_CTR: u32 = 3221293057;
pub const MSR_ZEN2_SPECTRAL_CHICKEN: u32 = 3221295331;
pub const MSR_F17H_IRPERF: u32 = 3221225705;
pub const MSR_F16H_L2I_PERF_CTL: u32 = 3221291568;
pub const MSR_F16H_L2I_PERF_CTR: u32 = 3221291569;
pub const MSR_F16H_DR1_ADDR_MASK: u32 = 3221295129;
pub const MSR_F16H_DR2_ADDR_MASK: u32 = 3221295130;
pub const MSR_F16H_DR3_ADDR_MASK: u32 = 3221295131;
pub const MSR_F16H_DR0_ADDR_MASK: u32 = 3221295143;
pub const MSR_F15H_CU_PWR_ACCUMULATOR: u32 = 3221291130;
pub const MSR_F15H_CU_MAX_PWR_ACCUMULATOR: u32 = 3221291131;
pub const MSR_F15H_PERF_CTL: u32 = 3221291520;
pub const MSR_F15H_PERF_CTL0: u32 = 3221291520;
pub const MSR_F15H_PERF_CTL1: u32 = 3221291522;
pub const MSR_F15H_PERF_CTL2: u32 = 3221291524;
pub const MSR_F15H_PERF_CTL3: u32 = 3221291526;
pub const MSR_F15H_PERF_CTL4: u32 = 3221291528;
pub const MSR_F15H_PERF_CTL5: u32 = 3221291530;
pub const MSR_F15H_PERF_CTR: u32 = 3221291521;
pub const MSR_F15H_PERF_CTR0: u32 = 3221291521;
pub const MSR_F15H_PERF_CTR1: u32 = 3221291523;
pub const MSR_F15H_PERF_CTR2: u32 = 3221291525;
pub const MSR_F15H_PERF_CTR3: u32 = 3221291527;
pub const MSR_F15H_PERF_CTR4: u32 = 3221291529;
pub const MSR_F15H_PERF_CTR5: u32 = 3221291531;
pub const MSR_F15H_NB_PERF_CTL: u32 = 3221291584;
pub const MSR_F15H_NB_PERF_CTR: u32 = 3221291585;
pub const MSR_F15H_PTSC: u32 = 3221291648;
pub const MSR_F15H_IC_CFG: u32 = 3221295137;
pub const MSR_F15H_EX_CFG: u32 = 3221295148;
pub const MSR_FAM10H_MMIO_CONF_BASE: u32 = 3221291096;
pub const FAM10H_MMIO_CONF_ENABLE: u32 = 1;
pub const FAM10H_MMIO_CONF_BUSRANGE_MASK: u32 = 15;
pub const FAM10H_MMIO_CONF_BUSRANGE_SHIFT: u32 = 2;
pub const FAM10H_MMIO_CONF_BASE_MASK: u32 = 268435455;
pub const FAM10H_MMIO_CONF_BASE_SHIFT: u32 = 20;
pub const MSR_FAM10H_NODE_ID: u32 = 3221295116;
pub const MSR_K8_TOP_MEM1: u32 = 3221291034;
pub const MSR_K8_TOP_MEM2: u32 = 3221291037;
pub const MSR_AMD64_SYSCFG: u32 = 3221291024;
pub const MSR_AMD64_SYSCFG_MEM_ENCRYPT_BIT: u32 = 23;
pub const MSR_AMD64_SYSCFG_SNP_EN_BIT: u32 = 24;
pub const MSR_AMD64_SYSCFG_SNP_VMPL_EN_BIT: u32 = 25;
pub const MSR_AMD64_SYSCFG_MFDM_BIT: u32 = 19;
pub const MSR_K8_INT_PENDING_MSG: u32 = 3221291093;
pub const K8_INTP_C1E_ACTIVE_MASK: u32 = 402653184;
pub const MSR_K8_TSEG_ADDR: u32 = 3221291282;
pub const MSR_K8_TSEG_MASK: u32 = 3221291283;
pub const K8_MTRRFIXRANGE_DRAM_ENABLE: u32 = 262144;
pub const K8_MTRRFIXRANGE_DRAM_MODIFY: u32 = 524288;
pub const K8_MTRR_RDMEM_WRMEM_MASK: u32 = 404232216;
pub const MSR_K7_EVNTSEL0: u32 = 3221291008;
pub const MSR_K7_PERFCTR0: u32 = 3221291012;
pub const MSR_K7_EVNTSEL1: u32 = 3221291009;
pub const MSR_K7_PERFCTR1: u32 = 3221291013;
pub const MSR_K7_EVNTSEL2: u32 = 3221291010;
pub const MSR_K7_PERFCTR2: u32 = 3221291014;
pub const MSR_K7_EVNTSEL3: u32 = 3221291011;
pub const MSR_K7_PERFCTR3: u32 = 3221291015;
pub const MSR_K7_CLK_CTL: u32 = 3221291035;
pub const MSR_K7_HWCR: u32 = 3221291029;
pub const MSR_K7_HWCR_SMMLOCK_BIT: u32 = 0;
pub const MSR_K7_HWCR_IRPERF_EN_BIT: u32 = 30;
pub const MSR_K7_HWCR_CPUID_USER_DIS_BIT: u32 = 35;
pub const MSR_K7_FID_VID_CTL: u32 = 3221291073;
pub const MSR_K7_FID_VID_STATUS: u32 = 3221291074;
pub const MSR_K7_HWCR_CPB_DIS_BIT: u32 = 25;
pub const MSR_K6_WHCR: u32 = 3221225602;
pub const MSR_K6_UWCCR: u32 = 3221225605;
pub const MSR_K6_EPMR: u32 = 3221225606;
pub const MSR_K6_PSOR: u32 = 3221225607;
pub const MSR_K6_PFIR: u32 = 3221225608;
pub const MSR_IDT_FCR1: u32 = 263;
pub const MSR_IDT_FCR2: u32 = 264;
pub const MSR_IDT_FCR3: u32 = 265;
pub const MSR_IDT_FCR4: u32 = 266;
pub const MSR_IDT_MCR0: u32 = 272;
pub const MSR_IDT_MCR1: u32 = 273;
pub const MSR_IDT_MCR2: u32 = 274;
pub const MSR_IDT_MCR3: u32 = 275;
pub const MSR_IDT_MCR4: u32 = 276;
pub const MSR_IDT_MCR5: u32 = 277;
pub const MSR_IDT_MCR6: u32 = 278;
pub const MSR_IDT_MCR7: u32 = 279;
pub const MSR_IDT_MCR_CTRL: u32 = 288;
pub const MSR_VIA_FCR: u32 = 4359;
pub const MSR_VIA_LONGHAUL: u32 = 4362;
pub const MSR_VIA_RNG: u32 = 4363;
pub const MSR_VIA_BCR2: u32 = 4423;
pub const MSR_TMTA_LONGRUN_CTRL: u32 = 2156298256;
pub const MSR_TMTA_LONGRUN_FLAGS: u32 = 2156298257;
pub const MSR_TMTA_LRTI_READOUT: u32 = 2156298264;
pub const MSR_TMTA_LRTI_VOLT_MHZ: u32 = 2156298266;
pub const MSR_IA32_P5_MC_ADDR: u32 = 0;
pub const MSR_IA32_P5_MC_TYPE: u32 = 1;
pub const MSR_IA32_TSC: u32 = 16;
pub const MSR_IA32_PLATFORM_ID: u32 = 23;
pub const MSR_IA32_EBL_CR_POWERON: u32 = 42;
pub const MSR_EBC_FREQUENCY_ID: u32 = 44;
pub const MSR_SMI_COUNT: u32 = 52;
pub const MSR_IA32_FEAT_CTL: u32 = 58;
pub const MSR_IA32_TSC_ADJUST: u32 = 59;
pub const MSR_IA32_BNDCFGS: u32 = 3472;
pub const MSR_IA32_BNDCFGS_RSVD: u32 = 4092;
pub const MSR_IA32_XFD: u32 = 452;
pub const MSR_IA32_XFD_ERR: u32 = 453;
pub const MSR_IA32_XSS: u32 = 3488;
pub const MSR_IA32_APICBASE: u32 = 27;
pub const MSR_IA32_APICBASE_BSP: u32 = 256;
pub const MSR_IA32_APICBASE_ENABLE: u32 = 2048;
pub const MSR_IA32_APICBASE_BASE: u32 = 4294963200;
pub const MSR_IA32_UCODE_WRITE: u32 = 121;
pub const MSR_IA32_UCODE_REV: u32 = 139;
pub const MSR_IA32_SGXLEPUBKEYHASH0: u32 = 140;
pub const MSR_IA32_SGXLEPUBKEYHASH1: u32 = 141;
pub const MSR_IA32_SGXLEPUBKEYHASH2: u32 = 142;
pub const MSR_IA32_SGXLEPUBKEYHASH3: u32 = 143;
pub const MSR_IA32_SMM_MONITOR_CTL: u32 = 155;
pub const MSR_IA32_SMBASE: u32 = 158;
pub const MSR_IA32_PERF_STATUS: u32 = 408;
pub const MSR_IA32_PERF_CTL: u32 = 409;
pub const INTEL_PERF_CTL_MASK: u32 = 65535;
pub const MSR_AMD_DBG_EXTN_CFG: u32 = 3221225743;
pub const MSR_AMD_SAMP_BR_FROM: u32 = 3221291776;
pub const MSR_IA32_MPERF: u32 = 231;
pub const MSR_IA32_APERF: u32 = 232;
pub const MSR_IA32_THERM_CONTROL: u32 = 410;
pub const MSR_IA32_THERM_INTERRUPT: u32 = 411;
pub const THERM_INT_HIGH_ENABLE: u32 = 1;
pub const THERM_INT_LOW_ENABLE: u32 = 2;
pub const THERM_INT_PLN_ENABLE: u32 = 16777216;
pub const MSR_IA32_THERM_STATUS: u32 = 412;
pub const THERM_STATUS_PROCHOT: u32 = 1;
pub const THERM_STATUS_POWER_LIMIT: u32 = 1024;
pub const MSR_THERM2_CTL: u32 = 413;
pub const MSR_THERM2_CTL_TM_SELECT: u32 = 65536;
pub const MSR_IA32_MISC_ENABLE: u32 = 416;
pub const MSR_IA32_TEMPERATURE_TARGET: u32 = 418;
pub const MSR_MISC_FEATURE_CONTROL: u32 = 420;
pub const MSR_MISC_PWR_MGMT: u32 = 426;
pub const MSR_IA32_ENERGY_PERF_BIAS: u32 = 432;
pub const ENERGY_PERF_BIAS_PERFORMANCE: u32 = 0;
pub const ENERGY_PERF_BIAS_BALANCE_PERFORMANCE: u32 = 4;
pub const ENERGY_PERF_BIAS_NORMAL: u32 = 6;
pub const ENERGY_PERF_BIAS_NORMAL_POWERSAVE: u32 = 7;
pub const ENERGY_PERF_BIAS_BALANCE_POWERSAVE: u32 = 8;
pub const ENERGY_PERF_BIAS_POWERSAVE: u32 = 15;
pub const MSR_IA32_PACKAGE_THERM_STATUS: u32 = 433;
pub const PACKAGE_THERM_STATUS_PROCHOT: u32 = 1;
pub const PACKAGE_THERM_STATUS_POWER_LIMIT: u32 = 1024;
pub const PACKAGE_THERM_STATUS_HFI_UPDATED: u32 = 67108864;
pub const MSR_IA32_PACKAGE_THERM_INTERRUPT: u32 = 434;
pub const PACKAGE_THERM_INT_HIGH_ENABLE: u32 = 1;
pub const PACKAGE_THERM_INT_LOW_ENABLE: u32 = 2;
pub const PACKAGE_THERM_INT_PLN_ENABLE: u32 = 16777216;
pub const PACKAGE_THERM_INT_HFI_ENABLE: u32 = 33554432;
pub const THERM_INT_THRESHOLD0_ENABLE: u32 = 32768;
pub const THERM_SHIFT_THRESHOLD0: u32 = 8;
pub const THERM_MASK_THRESHOLD0: u32 = 32512;
pub const THERM_INT_THRESHOLD1_ENABLE: u32 = 8388608;
pub const THERM_SHIFT_THRESHOLD1: u32 = 16;
pub const THERM_MASK_THRESHOLD1: u32 = 8323072;
pub const THERM_STATUS_THRESHOLD0: u32 = 64;
pub const THERM_LOG_THRESHOLD0: u32 = 128;
pub const THERM_STATUS_THRESHOLD1: u32 = 256;
pub const THERM_LOG_THRESHOLD1: u32 = 512;
pub const MSR_IA32_MISC_ENABLE_FAST_STRING_BIT: u32 = 0;
pub const MSR_IA32_MISC_ENABLE_FAST_STRING: u32 = 1;
pub const MSR_IA32_MISC_ENABLE_TCC_BIT: u32 = 1;
pub const MSR_IA32_MISC_ENABLE_TCC: u32 = 2;
pub const MSR_IA32_MISC_ENABLE_EMON_BIT: u32 = 7;
pub const MSR_IA32_MISC_ENABLE_EMON: u32 = 128;
pub const MSR_IA32_MISC_ENABLE_BTS_UNAVAIL_BIT: u32 = 11;
pub const MSR_IA32_MISC_ENABLE_BTS_UNAVAIL: u32 = 2048;
pub const MSR_IA32_MISC_ENABLE_PEBS_UNAVAIL_BIT: u32 = 12;
pub const MSR_IA32_MISC_ENABLE_PEBS_UNAVAIL: u32 = 4096;
pub const MSR_IA32_MISC_ENABLE_ENHANCED_SPEEDSTEP_BIT: u32 = 16;
pub const MSR_IA32_MISC_ENABLE_ENHANCED_SPEEDSTEP: u32 = 65536;
pub const MSR_IA32_MISC_ENABLE_MWAIT_BIT: u32 = 18;
pub const MSR_IA32_MISC_ENABLE_MWAIT: u32 = 262144;
pub const MSR_IA32_MISC_ENABLE_LIMIT_CPUID_BIT: u32 = 22;
pub const MSR_IA32_MISC_ENABLE_LIMIT_CPUID: u32 = 4194304;
pub const MSR_IA32_MISC_ENABLE_XTPR_DISABLE_BIT: u32 = 23;
pub const MSR_IA32_MISC_ENABLE_XTPR_DISABLE: u32 = 8388608;
pub const MSR_IA32_MISC_ENABLE_XD_DISABLE_BIT: u32 = 34;
pub const MSR_IA32_MISC_ENABLE_XD_DISABLE: u64 = 17179869184;
pub const MSR_IA32_MISC_ENABLE_X87_COMPAT_BIT: u32 = 2;
pub const MSR_IA32_MISC_ENABLE_X87_COMPAT: u32 = 4;
pub const MSR_IA32_MISC_ENABLE_TM1_BIT: u32 = 3;
pub const MSR_IA32_MISC_ENABLE_TM1: u32 = 8;
pub const MSR_IA32_MISC_ENABLE_SPLIT_LOCK_DISABLE_BIT: u32 = 4;
pub const MSR_IA32_MISC_ENABLE_SPLIT_LOCK_DISABLE: u32 = 16;
pub const MSR_IA32_MISC_ENABLE_L3CACHE_DISABLE_BIT: u32 = 6;
pub const MSR_IA32_MISC_ENABLE_L3CACHE_DISABLE: u32 = 64;
pub const MSR_IA32_MISC_ENABLE_SUPPRESS_LOCK_BIT: u32 = 8;
pub const MSR_IA32_MISC_ENABLE_SUPPRESS_LOCK: u32 = 256;
pub const MSR_IA32_MISC_ENABLE_PREFETCH_DISABLE_BIT: u32 = 9;
pub const MSR_IA32_MISC_ENABLE_PREFETCH_DISABLE: u32 = 512;
pub const MSR_IA32_MISC_ENABLE_FERR_BIT: u32 = 10;
pub const MSR_IA32_MISC_ENABLE_FERR: u32 = 1024;
pub const MSR_IA32_MISC_ENABLE_FERR_MULTIPLEX_BIT: u32 = 10;
pub const MSR_IA32_MISC_ENABLE_FERR_MULTIPLEX: u32 = 1024;
pub const MSR_IA32_MISC_ENABLE_TM2_BIT: u32 = 13;
pub const MSR_IA32_MISC_ENABLE_TM2: u32 = 8192;
pub const MSR_IA32_MISC_ENABLE_ADJ_PREF_DISABLE_BIT: u32 = 19;
pub const MSR_IA32_MISC_ENABLE_ADJ_PREF_DISABLE: u32 = 524288;
pub const MSR_IA32_MISC_ENABLE_SPEEDSTEP_LOCK_BIT: u32 = 20;
pub const MSR_IA32_MISC_ENABLE_SPEEDSTEP_LOCK: u32 = 1048576;
pub const MSR_IA32_MISC_ENABLE_L1D_CONTEXT_BIT: u32 = 24;
pub const MSR_IA32_MISC_ENABLE_L1D_CONTEXT: u32 = 16777216;
pub const MSR_IA32_MISC_ENABLE_DCU_PREF_DISABLE_BIT: u32 = 37;
pub const MSR_IA32_MISC_ENABLE_DCU_PREF_DISABLE: u64 = 137438953472;
pub const MSR_IA32_MISC_ENABLE_TURBO_DISABLE_BIT: u32 = 38;
pub const MSR_IA32_MISC_ENABLE_TURBO_DISABLE: u64 = 274877906944;
pub const MSR_IA32_MISC_ENABLE_IP_PREF_DISABLE_BIT: u32 = 39;
pub const MSR_IA32_MISC_ENABLE_IP_PREF_DISABLE: u64 = 549755813888;
pub const MSR_MISC_FEATURES_ENABLES: u32 = 320;
pub const MSR_MISC_FEATURES_ENABLES_CPUID_FAULT_BIT: u32 = 0;
pub const MSR_MISC_FEATURES_ENABLES_RING3MWAIT_BIT: u32 = 1;
pub const MSR_IA32_TSC_DEADLINE: u32 = 1760;
pub const MSR_TSX_FORCE_ABORT: u32 = 271;
pub const MSR_TFA_RTM_FORCE_ABORT_BIT: u32 = 0;
pub const MSR_TFA_TSX_CPUID_CLEAR_BIT: u32 = 1;
pub const MSR_TFA_SDV_ENABLE_RTM_BIT: u32 = 2;
pub const MSR_IA32_MCG_EAX: u32 = 384;
pub const MSR_IA32_MCG_EBX: u32 = 385;
pub const MSR_IA32_MCG_ECX: u32 = 386;
pub const MSR_IA32_MCG_EDX: u32 = 387;
pub const MSR_IA32_MCG_ESI: u32 = 388;
pub const MSR_IA32_MCG_EDI: u32 = 389;
pub const MSR_IA32_MCG_EBP: u32 = 390;
pub const MSR_IA32_MCG_ESP: u32 = 391;
pub const MSR_IA32_MCG_EFLAGS: u32 = 392;
pub const MSR_IA32_MCG_EIP: u32 = 393;
pub const MSR_IA32_MCG_RESERVED: u32 = 394;
pub const MSR_P4_BPU_PERFCTR0: u32 = 768;
pub const MSR_P4_BPU_PERFCTR1: u32 = 769;
pub const MSR_P4_BPU_PERFCTR2: u32 = 770;
pub const MSR_P4_BPU_PERFCTR3: u32 = 771;
pub const MSR_P4_MS_PERFCTR0: u32 = 772;
pub const MSR_P4_MS_PERFCTR1: u32 = 773;
pub const MSR_P4_MS_PERFCTR2: u32 = 774;
pub const MSR_P4_MS_PERFCTR3: u32 = 775;
pub const MSR_P4_FLAME_PERFCTR0: u32 = 776;
pub const MSR_P4_FLAME_PERFCTR1: u32 = 777;
pub const MSR_P4_FLAME_PERFCTR2: u32 = 778;
pub const MSR_P4_FLAME_PERFCTR3: u32 = 779;
pub const MSR_P4_IQ_PERFCTR0: u32 = 780;
pub const MSR_P4_IQ_PERFCTR1: u32 = 781;
pub const MSR_P4_IQ_PERFCTR2: u32 = 782;
pub const MSR_P4_IQ_PERFCTR3: u32 = 783;
pub const MSR_P4_IQ_PERFCTR4: u32 = 784;
pub const MSR_P4_IQ_PERFCTR5: u32 = 785;
pub const MSR_P4_BPU_CCCR0: u32 = 864;
pub const MSR_P4_BPU_CCCR1: u32 = 865;
pub const MSR_P4_BPU_CCCR2: u32 = 866;
pub const MSR_P4_BPU_CCCR3: u32 = 867;
pub const MSR_P4_MS_CCCR0: u32 = 868;
pub const MSR_P4_MS_CCCR1: u32 = 869;
pub const MSR_P4_MS_CCCR2: u32 = 870;
pub const MSR_P4_MS_CCCR3: u32 = 871;
pub const MSR_P4_FLAME_CCCR0: u32 = 872;
pub const MSR_P4_FLAME_CCCR1: u32 = 873;
pub const MSR_P4_FLAME_CCCR2: u32 = 874;
pub const MSR_P4_FLAME_CCCR3: u32 = 875;
pub const MSR_P4_IQ_CCCR0: u32 = 876;
pub const MSR_P4_IQ_CCCR1: u32 = 877;
pub const MSR_P4_IQ_CCCR2: u32 = 878;
pub const MSR_P4_IQ_CCCR3: u32 = 879;
pub const MSR_P4_IQ_CCCR4: u32 = 880;
pub const MSR_P4_IQ_CCCR5: u32 = 881;
pub const MSR_P4_ALF_ESCR0: u32 = 970;
pub const MSR_P4_ALF_ESCR1: u32 = 971;
pub const MSR_P4_BPU_ESCR0: u32 = 946;
pub const MSR_P4_BPU_ESCR1: u32 = 947;
pub const MSR_P4_BSU_ESCR0: u32 = 928;
pub const MSR_P4_BSU_ESCR1: u32 = 929;
pub const MSR_P4_CRU_ESCR0: u32 = 952;
pub const MSR_P4_CRU_ESCR1: u32 = 953;
pub const MSR_P4_CRU_ESCR2: u32 = 972;
pub const MSR_P4_CRU_ESCR3: u32 = 973;
pub const MSR_P4_CRU_ESCR4: u32 = 992;
pub const MSR_P4_CRU_ESCR5: u32 = 993;
pub const MSR_P4_DAC_ESCR0: u32 = 936;
pub const MSR_P4_DAC_ESCR1: u32 = 937;
pub const MSR_P4_FIRM_ESCR0: u32 = 932;
pub const MSR_P4_FIRM_ESCR1: u32 = 933;
pub const MSR_P4_FLAME_ESCR0: u32 = 934;
pub const MSR_P4_FLAME_ESCR1: u32 = 935;
pub const MSR_P4_FSB_ESCR0: u32 = 930;
pub const MSR_P4_FSB_ESCR1: u32 = 931;
pub const MSR_P4_IQ_ESCR0: u32 = 954;
pub const MSR_P4_IQ_ESCR1: u32 = 955;
pub const MSR_P4_IS_ESCR0: u32 = 948;
pub const MSR_P4_IS_ESCR1: u32 = 949;
pub const MSR_P4_ITLB_ESCR0: u32 = 950;
pub const MSR_P4_ITLB_ESCR1: u32 = 951;
pub const MSR_P4_IX_ESCR0: u32 = 968;
pub const MSR_P4_IX_ESCR1: u32 = 969;
pub const MSR_P4_MOB_ESCR0: u32 = 938;
pub const MSR_P4_MOB_ESCR1: u32 = 939;
pub const MSR_P4_MS_ESCR0: u32 = 960;
pub const MSR_P4_MS_ESCR1: u32 = 961;
pub const MSR_P4_PMH_ESCR0: u32 = 940;
pub const MSR_P4_PMH_ESCR1: u32 = 941;
pub const MSR_P4_RAT_ESCR0: u32 = 956;
pub const MSR_P4_RAT_ESCR1: u32 = 957;
pub const MSR_P4_SAAT_ESCR0: u32 = 942;
pub const MSR_P4_SAAT_ESCR1: u32 = 943;
pub const MSR_P4_SSU_ESCR0: u32 = 958;
pub const MSR_P4_SSU_ESCR1: u32 = 959;
pub const MSR_P4_TBPU_ESCR0: u32 = 962;
pub const MSR_P4_TBPU_ESCR1: u32 = 963;
pub const MSR_P4_TC_ESCR0: u32 = 964;
pub const MSR_P4_TC_ESCR1: u32 = 965;
pub const MSR_P4_U2L_ESCR0: u32 = 944;
pub const MSR_P4_U2L_ESCR1: u32 = 945;
pub const MSR_P4_PEBS_MATRIX_VERT: u32 = 1010;
pub const MSR_CORE_PERF_FIXED_CTR0: u32 = 777;
pub const MSR_CORE_PERF_FIXED_CTR1: u32 = 778;
pub const MSR_CORE_PERF_FIXED_CTR2: u32 = 779;
pub const MSR_CORE_PERF_FIXED_CTR3: u32 = 780;
pub const MSR_CORE_PERF_FIXED_CTR_CTRL: u32 = 909;
pub const MSR_CORE_PERF_GLOBAL_STATUS: u32 = 910;
pub const MSR_CORE_PERF_GLOBAL_CTRL: u32 = 911;
pub const MSR_CORE_PERF_GLOBAL_OVF_CTRL: u32 = 912;
pub const MSR_PERF_METRICS: u32 = 809;
pub const MSR_CORE_PERF_GLOBAL_OVF_CTRL_TRACE_TOPA_PMI_BIT: u32 = 55;
pub const MSR_CORE_PERF_GLOBAL_OVF_CTRL_TRACE_TOPA_PMI: u64 = 36028797018963968;
pub const MSR_CORE_PERF_GLOBAL_OVF_CTRL_OVF_BUF_BIT: u32 = 62;
pub const MSR_CORE_PERF_GLOBAL_OVF_CTRL_OVF_BUF: u64 = 4611686018427387904;
pub const MSR_CORE_PERF_GLOBAL_OVF_CTRL_COND_CHGD_BIT: u32 = 63;
pub const MSR_CORE_PERF_GLOBAL_OVF_CTRL_COND_CHGD: i64 = -9223372036854775808;
pub const MSR_GEODE_BUSCONT_CONF0: u32 = 6400;
pub const MSR_IA32_VMX_BASIC: u32 = 1152;
pub const MSR_IA32_VMX_PINBASED_CTLS: u32 = 1153;
pub const MSR_IA32_VMX_PROCBASED_CTLS: u32 = 1154;
pub const MSR_IA32_VMX_EXIT_CTLS: u32 = 1155;
pub const MSR_IA32_VMX_ENTRY_CTLS: u32 = 1156;
pub const MSR_IA32_VMX_MISC: u32 = 1157;
pub const MSR_IA32_VMX_CR0_FIXED0: u32 = 1158;
pub const MSR_IA32_VMX_CR0_FIXED1: u32 = 1159;
pub const MSR_IA32_VMX_CR4_FIXED0: u32 = 1160;
pub const MSR_IA32_VMX_CR4_FIXED1: u32 = 1161;
pub const MSR_IA32_VMX_VMCS_ENUM: u32 = 1162;
pub const MSR_IA32_VMX_PROCBASED_CTLS2: u32 = 1163;
pub const MSR_IA32_VMX_EPT_VPID_CAP: u32 = 1164;
pub const MSR_IA32_VMX_TRUE_PINBASED_CTLS: u32 = 1165;
pub const MSR_IA32_VMX_TRUE_PROCBASED_CTLS: u32 = 1166;
pub const MSR_IA32_VMX_TRUE_EXIT_CTLS: u32 = 1167;
pub const MSR_IA32_VMX_TRUE_ENTRY_CTLS: u32 = 1168;
pub const MSR_IA32_VMX_VMFUNC: u32 = 1169;
pub const MSR_IA32_VMX_PROCBASED_CTLS3: u32 = 1170;
pub const MSR_IA32_L3_QOS_CFG: u32 = 3201;
pub const MSR_IA32_L2_QOS_CFG: u32 = 3202;
pub const MSR_IA32_QM_EVTSEL: u32 = 3213;
pub const MSR_IA32_QM_CTR: u32 = 3214;
pub const MSR_IA32_PQR_ASSOC: u32 = 3215;
pub const MSR_IA32_L3_CBM_BASE: u32 = 3216;
pub const MSR_RMID_SNC_CONFIG: u32 = 3232;
pub const MSR_IA32_L2_CBM_BASE: u32 = 3344;
pub const MSR_IA32_MBA_THRTL_BASE: u32 = 3408;
pub const MSR_IA32_MBA_BW_BASE: u32 = 3221225984;
pub const MSR_IA32_SMBA_BW_BASE: u32 = 3221226112;
pub const MSR_IA32_L3_QOS_ABMC_CFG: u32 = 3221226493;
pub const MSR_IA32_L3_QOS_EXT_CFG: u32 = 3221226495;
pub const MSR_IA32_EVT_CFG_BASE: u32 = 3221226496;
pub const MSR_VM_CR: u32 = 3221291284;
pub const MSR_VM_IGNNE: u32 = 3221291285;
pub const MSR_VM_HSAVE_PA: u32 = 3221291287;
pub const SVM_VM_CR_VALID_MASK: u32 = 31;
pub const SVM_VM_CR_SVM_LOCK_MASK: u32 = 8;
pub const SVM_VM_CR_SVM_DIS_MASK: u32 = 16;
pub const MSR_IA32_HW_FEEDBACK_PTR: u32 = 6096;
pub const MSR_IA32_HW_FEEDBACK_CONFIG: u32 = 6097;
pub const MSR_IA32_XAPIC_DISABLE_STATUS: u32 = 189;
pub const ORC_REG_UNDEFINED: u32 = 0;
pub const ORC_REG_PREV_SP: u32 = 1;
pub const ORC_REG_DX: u32 = 2;
pub const ORC_REG_DI: u32 = 3;
pub const ORC_REG_BP: u32 = 4;
pub const ORC_REG_SP: u32 = 5;
pub const ORC_REG_R10: u32 = 6;
pub const ORC_REG_R13: u32 = 7;
pub const ORC_REG_BP_INDIRECT: u32 = 8;
pub const ORC_REG_SP_INDIRECT: u32 = 9;
pub const ORC_REG_MAX: u32 = 15;
pub const ORC_TYPE_UNDEFINED: u32 = 0;
pub const ORC_TYPE_END_OF_STACK: u32 = 1;
pub const ORC_TYPE_CALL: u32 = 2;
pub const ORC_TYPE_REGS: u32 = 3;
pub const ORC_TYPE_REGS_PARTIAL: u32 = 4;
pub const RET_DEPTH_SHIFT: u32 = 5;
pub const RSB_RET_STUFF_LOOPS: u32 = 16;
pub const RET_DEPTH_INIT: i64 = -9223372036854775808;
pub const RET_DEPTH_INIT_FROM_CALL: i64 = -288230376151711744;
pub const RET_DEPTH_CREDIT: i32 = -1;
pub const KVM_STEAL_TIME_preempted: u32 = 16;
pub const pt_regs_bx: u32 = 40;
pub const pt_regs_cx: u32 = 88;
pub const pt_regs_dx: u32 = 96;
pub const pt_regs_sp: u32 = 152;
pub const pt_regs_bp: u32 = 32;
pub const pt_regs_si: u32 = 104;
pub const pt_regs_di: u32 = 112;
pub const pt_regs_r8: u32 = 72;
pub const pt_regs_r9: u32 = 64;
pub const pt_regs_r10: u32 = 56;
pub const pt_regs_r11: u32 = 48;
pub const pt_regs_r12: u32 = 24;
pub const pt_regs_r13: u32 = 16;
pub const pt_regs_r14: u32 = 8;
pub const pt_regs_r15: u32 = 0;
pub const pt_regs_flags: u32 = 144;
pub const saved_context_cr0: u32 = 200;
pub const saved_context_cr2: u32 = 208;
pub const saved_context_cr3: u32 = 216;
pub const saved_context_cr4: u32 = 224;
pub const saved_context_gdt_desc: u32 = 266;
pub const CPUINFO_x86: u32 = 1;
pub const CPUINFO_x86_vendor: u32 = 2;
pub const CPUINFO_x86_model: u32 = 0;
pub const CPUINFO_x86_stepping: u32 = 4;
pub const CPUINFO_cpuid_level: u32 = 40;
pub const CPUINFO_x86_capability: u32 = 48;
pub const CPUINFO_x86_vendor_id: u32 = 144;
pub const TASK_threadsp: u32 = 5744;
pub const TASK_stack_canary: u32 = 2776;
pub const pbe_address: u32 = 0;
pub const pbe_orig_address: u32 = 8;
pub const pbe_next: u32 = 16;
pub const IA32_SIGCONTEXT_ax: u32 = 44;
pub const IA32_SIGCONTEXT_bx: u32 = 32;
pub const IA32_SIGCONTEXT_cx: u32 = 40;
pub const IA32_SIGCONTEXT_dx: u32 = 36;
pub const IA32_SIGCONTEXT_si: u32 = 20;
pub const IA32_SIGCONTEXT_di: u32 = 16;
pub const IA32_SIGCONTEXT_bp: u32 = 24;
pub const IA32_SIGCONTEXT_sp: u32 = 28;
pub const IA32_SIGCONTEXT_ip: u32 = 56;
pub const IA32_RT_SIGFRAME_sigcontext: u32 = 164;
pub const XEN_vcpu_info_mask: u32 = 1;
pub const XEN_vcpu_info_pending: u32 = 0;
pub const XEN_vcpu_info_arch_cr2: u32 = 16;
pub const TDX_MODULE_rcx: u32 = 0;
pub const TDX_MODULE_rdx: u32 = 8;
pub const TDX_MODULE_r8: u32 = 16;
pub const TDX_MODULE_r9: u32 = 24;
pub const TDX_MODULE_r10: u32 = 32;
pub const TDX_MODULE_r11: u32 = 40;
pub const TDX_MODULE_r12: u32 = 48;
pub const TDX_MODULE_r13: u32 = 56;
pub const TDX_MODULE_r14: u32 = 64;
pub const TDX_MODULE_r15: u32 = 72;
pub const TDX_MODULE_rbx: u32 = 80;
pub const TDX_MODULE_rdi: u32 = 88;
pub const TDX_MODULE_rsi: u32 = 96;
pub const BP_scratch: u32 = 484;
pub const BP_secure_boot: u32 = 492;
pub const BP_loadflags: u32 = 529;
pub const BP_hardware_subarch: u32 = 572;
pub const BP_version: u32 = 518;
pub const BP_kernel_alignment: u32 = 560;
pub const BP_init_size: u32 = 608;
pub const BP_pref_address: u32 = 600;
pub const PTREGS_SIZE: u32 = 168;
pub const C_PTREGS_SIZE: u32 = 120;
pub const TLB_STATE_user_pcid_flush_mask: u32 = 22;
pub const CPU_ENTRY_AREA_entry_stack: u32 = 4096;
pub const SIZEOF_entry_stack: u32 = 4096;
pub const MASK_entry_stack: i32 = -4096;
pub const TSS_sp0: u32 = 4;
pub const TSS_sp1: u32 = 12;
pub const TSS_sp2: u32 = 20;
pub const ARIA_CTX_enc_key: u32 = 0;
pub const ARIA_CTX_dec_key: u32 = 272;
pub const ARIA_CTX_rounds: u32 = 544;
pub const RETPOLINE_THUNK_SIZE: u32 = 32;
pub const RSB_CLEAR_LOOPS: u32 = 32;
pub const ITS_THUNK_SIZE: u32 = 64;
pub const GDT_ENTRY_BOOT_CS: u32 = 2;
pub const GDT_ENTRY_BOOT_DS: u32 = 3;
pub const GDT_ENTRY_BOOT_TSS: u32 = 4;
pub const __BOOT_CS: u32 = 16;
pub const __BOOT_DS: u32 = 24;
pub const __BOOT_TSS: u32 = 32;
pub const SEGMENT_RPL_MASK: u32 = 3;
pub const USER_SEGMENT_RPL_MASK: u32 = 2;
pub const USER_RPL: u32 = 3;
pub const SEGMENT_TI_MASK: u32 = 4;
pub const SEGMENT_LDT: u32 = 4;
pub const SEGMENT_GDT: u32 = 0;
pub const GDT_ENTRY_INVALID_SEG: u32 = 0;
pub const GDT_ENTRY_KERNEL32_CS: u32 = 1;
pub const GDT_ENTRY_KERNEL_CS: u32 = 2;
pub const GDT_ENTRY_KERNEL_DS: u32 = 3;
pub const GDT_ENTRY_DEFAULT_USER32_CS: u32 = 4;
pub const GDT_ENTRY_DEFAULT_USER_DS: u32 = 5;
pub const GDT_ENTRY_DEFAULT_USER_CS: u32 = 6;
pub const GDT_ENTRY_TSS: u32 = 8;
pub const GDT_ENTRY_LDT: u32 = 10;
pub const GDT_ENTRY_TLS_MIN: u32 = 12;
pub const GDT_ENTRY_TLS_MAX: u32 = 14;
pub const GDT_ENTRY_CPUNODE: u32 = 15;
pub const GDT_ENTRIES: u32 = 16;
pub const __KERNEL32_CS: u32 = 8;
pub const __KERNEL_CS: u32 = 16;
pub const __KERNEL_DS: u32 = 24;
pub const __USER32_CS: u32 = 35;
pub const __USER_DS: u32 = 43;
pub const __USER_CS: u32 = 51;
pub const __CPUNODE_SEG: u32 = 123;
pub const IDT_ENTRIES: u32 = 256;
pub const NUM_EXCEPTION_VECTORS: u32 = 32;
pub const EXCEPTION_ERRCODE_MASK: u32 = 537033984;
pub const GDT_SIZE: u32 = 128;
pub const GDT_ENTRY_TLS_ENTRIES: u32 = 3;
pub const TLS_SIZE: u32 = 24;
pub const VDSO_CPUNODE_BITS: u32 = 12;
pub const VDSO_CPUNODE_MASK: u32 = 4095;
pub const EARLY_IDT_HANDLER_SIZE: u32 = 13;
pub const XEN_EARLY_IDT_HANDLER_SIZE: u32 = 12;
pub const _DESC_ACCESSED: u32 = 1;
pub const _DESC_DATA_WRITABLE: u32 = 2;
pub const _DESC_CODE_READABLE: u32 = 2;
pub const _DESC_DATA_EXPAND_DOWN: u32 = 4;
pub const _DESC_CODE_CONFORMING: u32 = 4;
pub const _DESC_CODE_EXECUTABLE: u32 = 8;
pub const _DESC_S: u32 = 16;
pub const _DESC_PRESENT: u32 = 128;
pub const _DESC_LONG_CODE: u32 = 8192;
pub const _DESC_DB: u32 = 16384;
pub const _DESC_GRANULARITY_4K: u32 = 32768;
pub const _DESC_DATA: u32 = 147;
pub const _DESC_CODE: u32 = 155;
pub const DESC_DATA16: u32 = 147;
pub const DESC_CODE16: u32 = 155;
pub const DESC_DATA32: u32 = 49299;
pub const DESC_DATA32_BIOS: u32 = 16531;
pub const DESC_CODE32: u32 = 49307;
pub const DESC_CODE32_BIOS: u32 = 16539;
pub const DESC_DATA64: u32 = 49299;
pub const DESC_CODE64: u32 = 41115;
pub const BOOT_IDT_ENTRIES: u32 = 32;
pub const AR_TYPE_RODATA: u32 = 0;
pub const AR_TYPE_RWDATA: u32 = 512;
pub const AR_TYPE_RODATA_EXPDOWN: u32 = 1024;
pub const AR_TYPE_RWDATA_EXPDOWN: u32 = 1536;
pub const AR_TYPE_XOCODE: u32 = 2048;
pub const AR_TYPE_XRCODE: u32 = 2560;
pub const AR_TYPE_XOCODE_CONF: u32 = 3072;
pub const AR_TYPE_XRCODE_CONF: u32 = 3584;
pub const AR_TYPE_MASK: u32 = 3584;
pub const AR_DPL0: u32 = 0;
pub const AR_DPL3: u32 = 24576;
pub const AR_DPL_MASK: u32 = 24576;
pub const AR_A: u32 = 256;
pub const AR_S: u32 = 4096;
pub const AR_P: u32 = 32768;
pub const AR_AVL: u32 = 1048576;
pub const AR_L: u32 = 2097152;
pub const AR_DB: u32 = 4194304;
pub const AR_G: u32 = 8388608;
pub const PAGE_SHIFT: u32 = 12;
pub const HUGE_MAX_HSTATE: u32 = 2;
pub const KASAN_STACK_ORDER: u32 = 0;
pub const THREAD_SIZE_ORDER: u32 = 2;
pub const EXCEPTION_STACK_ORDER: u32 = 1;
pub const IRQ_STACK_ORDER: u32 = 2;
pub const IST_INDEX_DF: u32 = 0;
pub const IST_INDEX_NMI: u32 = 1;
pub const IST_INDEX_DB: u32 = 2;
pub const IST_INDEX_MCE: u32 = 3;
pub const IST_INDEX_VC: u32 = 4;
pub const __PHYSICAL_MASK_SHIFT: u32 = 52;
pub const KERNEL_IMAGE_SIZE: u32 = 1073741824;
pub const _PAGE_BIT_PRESENT: u32 = 0;
pub const _PAGE_BIT_RW: u32 = 1;
pub const _PAGE_BIT_USER: u32 = 2;
pub const _PAGE_BIT_PWT: u32 = 3;
pub const _PAGE_BIT_PCD: u32 = 4;
pub const _PAGE_BIT_ACCESSED: u32 = 5;
pub const _PAGE_BIT_DIRTY: u32 = 6;
pub const _PAGE_BIT_PSE: u32 = 7;
pub const _PAGE_BIT_PAT: u32 = 7;
pub const _PAGE_BIT_GLOBAL: u32 = 8;
pub const _PAGE_BIT_SOFTW1: u32 = 9;
pub const _PAGE_BIT_SOFTW2: u32 = 10;
pub const _PAGE_BIT_SOFTW3: u32 = 11;
pub const _PAGE_BIT_PAT_LARGE: u32 = 12;
pub const _PAGE_BIT_SOFTW4: u32 = 57;
pub const _PAGE_BIT_SOFTW5: u32 = 58;
pub const _PAGE_BIT_PKEY_BIT0: u32 = 59;
pub const _PAGE_BIT_PKEY_BIT1: u32 = 60;
pub const _PAGE_BIT_PKEY_BIT2: u32 = 61;
pub const _PAGE_BIT_PKEY_BIT3: u32 = 62;
pub const _PAGE_BIT_NX: u32 = 63;
pub const _PAGE_BIT_SPECIAL: u32 = 9;
pub const _PAGE_BIT_CPA_TEST: u32 = 9;
pub const _PAGE_BIT_UFFD_WP: u32 = 10;
pub const _PAGE_BIT_SOFT_DIRTY: u32 = 11;
pub const _PAGE_BIT_KERNEL_4K: u32 = 11;
pub const _PAGE_BIT_SAVED_DIRTY: u32 = 58;
pub const _PAGE_BIT_NOPTISHADOW: u32 = 58;
pub const _PAGE_BIT_PROTNONE: u32 = 8;
pub const SECTION_SIZE_BITS: u32 = 27;
pub const PTRS_PER_PGD: u32 = 512;
pub const P4D_SHIFT: u32 = 39;
pub const MAX_PTRS_PER_P4D: u32 = 512;
pub const MAX_POSSIBLE_PHYSMEM_BITS: u32 = 52;
pub const PUD_SHIFT: u32 = 30;
pub const PTRS_PER_PUD: u32 = 512;
pub const PMD_SHIFT: u32 = 21;
pub const PTRS_PER_PMD: u32 = 512;
pub const PTRS_PER_PTE: u32 = 512;
pub const GUARD_HOLE_PGD_ENTRY: i32 = -256;
pub const LDT_PGD_ENTRY: i32 = -240;
pub const __VMALLOC_BASE_L4: i64 = -60473139527680;
pub const __VMALLOC_BASE_L5: i64 = -27021597764222976;
pub const VMALLOC_SIZE_TB_L4: u32 = 32;
pub const VMALLOC_SIZE_TB_L5: u32 = 12800;
pub const __VMEMMAP_BASE_L4: i64 = -24189255811072;
pub const __VMEMMAP_BASE_L5: i64 = -12384898975268864;
pub const EARLY_DYNAMIC_PAGE_TABLES: u32 = 64;
pub const PGD_ALLOWED_BITS: i32 = -1;
pub const _BITOPS_LONG_SHIFT: u32 = 6;
pub const REG_IN: &[u8; 2] = b"D\0";
pub const REG_OUT: &[u8; 2] = b"a\0";
pub const BITOP_LE_SWIZZLE: u32 = 0;
pub const STACK_MAGIC: u32 = 3735928559;
pub const __HAVE_ARCH_MEMCPY: u32 = 1;
pub const __HAVE_ARCH_MEMCPY_FLUSHCACHE: u32 = 1;
pub const FORTIFY_READ: u32 = 0;
pub const FORTIFY_WRITE: u32 = 1;
pub const BITMAP_MEM_ALIGNMENT: u32 = 8;
pub const BITMAP_MEM_MASK: u32 = 7;
pub const __X86_CASE_B: u32 = 1;
pub const __X86_CASE_W: u32 = 2;
pub const __X86_CASE_L: u32 = 4;
pub const __X86_CASE_Q: u32 = 8;
pub const NODES_SHIFT: u32 = 10;
pub const MAX_NUMNODES: u32 = 1024;
pub const NUMA_NO_NODE: i32 = -1;
pub const _IOC_NRBITS: u32 = 8;
pub const _IOC_TYPEBITS: u32 = 8;
pub const _IOC_SIZEBITS: u32 = 14;
pub const _IOC_DIRBITS: u32 = 2;
pub const _IOC_NRMASK: u32 = 255;
pub const _IOC_TYPEMASK: u32 = 255;
pub const _IOC_SIZEMASK: u32 = 16383;
pub const _IOC_DIRMASK: u32 = 3;
pub const _IOC_NRSHIFT: u32 = 0;
pub const _IOC_TYPESHIFT: u32 = 8;
pub const _IOC_SIZESHIFT: u32 = 16;
pub const _IOC_DIRSHIFT: u32 = 30;
pub const _IOC_NONE: u32 = 0;
pub const _IOC_WRITE: u32 = 1;
pub const _IOC_READ: u32 = 2;
pub const IOC_IN: u32 = 1073741824;
pub const IOC_OUT: u32 = 2147483648;
pub const IOC_INOUT: u32 = 3221225472;
pub const IOCSIZE_MASK: u32 = 1073676288;
pub const IOCSIZE_SHIFT: u32 = 16;
pub const GRND_NONBLOCK: u32 = 1;
pub const GRND_RANDOM: u32 = 2;
pub const GRND_INSECURE: u32 = 4;
pub const NUMA_NO_MEMBLK: i32 = -1;
pub const FRAME_OFFSET: u32 = 0;
pub const PV_SAVE_ALL_CALLER_REGS: &[u8; 79] =
    b"push %rcx;push %rdx;push %rsi;push %rdi;push %r8;push %r9;push %r10;push %r11;\0";
pub const PV_RESTORE_ALL_CALLER_REGS: &[u8; 71] =
    b"pop %r11;pop %r10;pop %r9;pop %r8;pop %rdi;pop %rsi;pop %rdx;pop %rcx;\0";
pub const __HAVE_ARCH_GATE_AREA: u32 = 1;
pub const TOP_OF_KERNEL_STACK_PADDING: u32 = 16;
pub const FRAME_SIZE: u32 = 168;
pub const PTRACE_GETREGS: u32 = 12;
pub const PTRACE_SETREGS: u32 = 13;
pub const PTRACE_GETFPREGS: u32 = 14;
pub const PTRACE_SETFPREGS: u32 = 15;
pub const PTRACE_GETFPXREGS: u32 = 18;
pub const PTRACE_SETFPXREGS: u32 = 19;
pub const PTRACE_OLDSETOPTIONS: u32 = 21;
pub const PTRACE_GET_THREAD_AREA: u32 = 25;
pub const PTRACE_SET_THREAD_AREA: u32 = 26;
pub const PTRACE_ARCH_PRCTL: u32 = 30;
pub const PTRACE_SYSEMU: u32 = 31;
pub const PTRACE_SYSEMU_SINGLESTEP: u32 = 32;
pub const PTRACE_SINGLEBLOCK: u32 = 33;
pub const LDT_ENTRIES: u32 = 8192;
pub const LDT_ENTRY_SIZE: u32 = 8;
pub const MODIFY_LDT_CONTENTS_DATA: u32 = 0;
pub const MODIFY_LDT_CONTENTS_STACK: u32 = 1;
pub const MODIFY_LDT_CONTENTS_CODE: u32 = 2;
pub const NR_REG_ARGUMENTS: u32 = 6;
pub const FP_XSTATE_MAGIC1: u32 = 1179670611;
pub const FP_XSTATE_MAGIC2: u32 = 1179670597;
pub const X86_FXSR_MAGIC: u32 = 0;
pub const CPUID_LEAF_MWAIT: u32 = 5;
pub const CPUID_LEAF_DCA: u32 = 9;
pub const CPUID_LEAF_XSTATE: u32 = 13;
pub const CPUID_LEAF_TSC: u32 = 21;
pub const CPUID_LEAF_FREQ: u32 = 22;
pub const CPUID_LEAF_TILE: u32 = 29;
pub const TLB_0x63_2M_4M_ENTRIES: u32 = 32;
pub const MXCSR_DEFAULT: u32 = 8064;
pub const NVMXINTS: u32 = 5;
pub const VMX_FEATURE_INTR_EXITING: u32 = 0;
pub const VMX_FEATURE_NMI_EXITING: u32 = 3;
pub const VMX_FEATURE_VIRTUAL_NMIS: u32 = 5;
pub const VMX_FEATURE_PREEMPTION_TIMER: u32 = 6;
pub const VMX_FEATURE_POSTED_INTR: u32 = 7;
pub const VMX_FEATURE_INVVPID: u32 = 16;
pub const VMX_FEATURE_EPT_EXECUTE_ONLY: u32 = 17;
pub const VMX_FEATURE_EPT_AD: u32 = 18;
pub const VMX_FEATURE_EPT_1GB: u32 = 19;
pub const VMX_FEATURE_EPT_5LEVEL: u32 = 20;
pub const VMX_FEATURE_FLEXPRIORITY: u32 = 24;
pub const VMX_FEATURE_APICV: u32 = 25;
pub const VMX_FEATURE_EPTP_SWITCHING: u32 = 28;
pub const VMX_FEATURE_INTR_WINDOW_EXITING: u32 = 34;
pub const VMX_FEATURE_USE_TSC_OFFSETTING: u32 = 35;
pub const VMX_FEATURE_HLT_EXITING: u32 = 39;
pub const VMX_FEATURE_INVLPG_EXITING: u32 = 41;
pub const VMX_FEATURE_MWAIT_EXITING: u32 = 42;
pub const VMX_FEATURE_RDPMC_EXITING: u32 = 43;
pub const VMX_FEATURE_RDTSC_EXITING: u32 = 44;
pub const VMX_FEATURE_CR3_LOAD_EXITING: u32 = 47;
pub const VMX_FEATURE_CR3_STORE_EXITING: u32 = 48;
pub const VMX_FEATURE_TERTIARY_CONTROLS: u32 = 49;
pub const VMX_FEATURE_CR8_LOAD_EXITING: u32 = 51;
pub const VMX_FEATURE_CR8_STORE_EXITING: u32 = 52;
pub const VMX_FEATURE_VIRTUAL_TPR: u32 = 53;
pub const VMX_FEATURE_NMI_WINDOW_EXITING: u32 = 54;
pub const VMX_FEATURE_MOV_DR_EXITING: u32 = 55;
pub const VMX_FEATURE_UNCOND_IO_EXITING: u32 = 56;
pub const VMX_FEATURE_USE_IO_BITMAPS: u32 = 57;
pub const VMX_FEATURE_MONITOR_TRAP_FLAG: u32 = 59;
pub const VMX_FEATURE_USE_MSR_BITMAPS: u32 = 60;
pub const VMX_FEATURE_MONITOR_EXITING: u32 = 61;
pub const VMX_FEATURE_PAUSE_EXITING: u32 = 62;
pub const VMX_FEATURE_SEC_CONTROLS: u32 = 63;
pub const VMX_FEATURE_VIRT_APIC_ACCESSES: u32 = 64;
pub const VMX_FEATURE_EPT: u32 = 65;
pub const VMX_FEATURE_DESC_EXITING: u32 = 66;
pub const VMX_FEATURE_RDTSCP: u32 = 67;
pub const VMX_FEATURE_VIRTUAL_X2APIC: u32 = 68;
pub const VMX_FEATURE_VPID: u32 = 69;
pub const VMX_FEATURE_WBINVD_EXITING: u32 = 70;
pub const VMX_FEATURE_UNRESTRICTED_GUEST: u32 = 71;
pub const VMX_FEATURE_APIC_REGISTER_VIRT: u32 = 72;
pub const VMX_FEATURE_VIRT_INTR_DELIVERY: u32 = 73;
pub const VMX_FEATURE_PAUSE_LOOP_EXITING: u32 = 74;
pub const VMX_FEATURE_RDRAND_EXITING: u32 = 75;
pub const VMX_FEATURE_INVPCID: u32 = 76;
pub const VMX_FEATURE_VMFUNC: u32 = 77;
pub const VMX_FEATURE_SHADOW_VMCS: u32 = 78;
pub const VMX_FEATURE_ENCLS_EXITING: u32 = 79;
pub const VMX_FEATURE_RDSEED_EXITING: u32 = 80;
pub const VMX_FEATURE_PAGE_MOD_LOGGING: u32 = 81;
pub const VMX_FEATURE_EPT_VIOLATION_VE: u32 = 82;
pub const VMX_FEATURE_PT_CONCEAL_VMX: u32 = 83;
pub const VMX_FEATURE_XSAVES: u32 = 84;
pub const VMX_FEATURE_MODE_BASED_EPT_EXEC: u32 = 86;
pub const VMX_FEATURE_PT_USE_GPA: u32 = 88;
pub const VMX_FEATURE_TSC_SCALING: u32 = 89;
pub const VMX_FEATURE_USR_WAIT_PAUSE: u32 = 90;
pub const VMX_FEATURE_ENCLV_EXITING: u32 = 92;
pub const VMX_FEATURE_BUS_LOCK_DETECTION: u32 = 94;
pub const VMX_FEATURE_NOTIFY_VM_EXITING: u32 = 95;
pub const VMX_FEATURE_IPI_VIRT: u32 = 100;
pub const NET_IP_ALIGN: u32 = 0;
pub const HBP_NUM: u32 = 4;
pub const ARCH_MIN_MMSTRUCT_ALIGN: u32 = 0;
pub const X86_VENDOR_INTEL: u32 = 0;
pub const X86_VENDOR_CYRIX: u32 = 1;
pub const X86_VENDOR_AMD: u32 = 2;
pub const X86_VENDOR_UMC: u32 = 3;
pub const X86_VENDOR_CENTAUR: u32 = 5;
pub const X86_VENDOR_TRANSMETA: u32 = 7;
pub const X86_VENDOR_NSC: u32 = 8;
pub const X86_VENDOR_HYGON: u32 = 9;
pub const X86_VENDOR_ZHAOXIN: u32 = 10;
pub const X86_VENDOR_VORTEX: u32 = 11;
pub const X86_VENDOR_NUM: u32 = 12;
pub const X86_VENDOR_UNKNOWN: u32 = 255;
pub const IO_BITMAP_BITS: u32 = 65536;
pub const IO_BITMAP_BYTES: u32 = 8192;
pub const HAVE_ARCH_PICK_MMAP_LAYOUT: u32 = 1;
pub const BASE_PREFETCH: &[u8; 14] = b"prefetcht0 %1\0";
pub const REQUIRED_MASK0: u32 = 117473633;
pub const REQUIRED_MASK1: u32 = 536870912;
pub const REQUIRED_MASK2: u32 = 0;
pub const REQUIRED_MASK3: u32 = 36700160;
pub const REQUIRED_MASK4: u32 = 0;
pub const REQUIRED_MASK5: u32 = 0;
pub const REQUIRED_MASK6: u32 = 0;
pub const REQUIRED_MASK7: u32 = 0;
pub const REQUIRED_MASK8: u32 = 0;
pub const REQUIRED_MASK9: u32 = 0;
pub const REQUIRED_MASK10: u32 = 0;
pub const REQUIRED_MASK11: u32 = 0;
pub const REQUIRED_MASK12: u32 = 0;
pub const REQUIRED_MASK13: u32 = 0;
pub const REQUIRED_MASK14: u32 = 0;
pub const REQUIRED_MASK15: u32 = 0;
pub const REQUIRED_MASK16: u32 = 0;
pub const REQUIRED_MASK17: u32 = 0;
pub const REQUIRED_MASK18: u32 = 0;
pub const REQUIRED_MASK19: u32 = 0;
pub const REQUIRED_MASK20: u32 = 0;
pub const REQUIRED_MASK21: u32 = 0;
pub const DISABLED_MASK0: u32 = 2;
pub const DISABLED_MASK1: u32 = 0;
pub const DISABLED_MASK2: u32 = 0;
pub const DISABLED_MASK3: u32 = 14;
pub const DISABLED_MASK4: u32 = 0;
pub const DISABLED_MASK5: u32 = 0;
pub const DISABLED_MASK6: u32 = 0;
pub const DISABLED_MASK7: u32 = 0;
pub const DISABLED_MASK8: u32 = 0;
pub const DISABLED_MASK9: u32 = 0;
pub const DISABLED_MASK10: u32 = 0;
pub const DISABLED_MASK11: u32 = 0;
pub const DISABLED_MASK12: u32 = 67108864;
pub const DISABLED_MASK13: u32 = 0;
pub const DISABLED_MASK14: u32 = 0;
pub const DISABLED_MASK15: u32 = 0;
pub const DISABLED_MASK16: u32 = 0;
pub const DISABLED_MASK17: u32 = 0;
pub const DISABLED_MASK18: u32 = 0;
pub const DISABLED_MASK19: u32 = 0;
pub const DISABLED_MASK20: u32 = 0;
pub const DISABLED_MASK21: u32 = 0;
pub const MAX_CPU_FEATURES: u32 = 704;
pub const CPU_FEATURE_TYPEFMT: &[u8; 26] = b"x86,ven%04Xfam%04Xmod%04X\0";
pub const TIF_NOTIFY_RESUME: u32 = 0;
pub const TIF_SIGPENDING: u32 = 1;
pub const TIF_NOTIFY_SIGNAL: u32 = 2;
pub const TIF_MEMDIE: u32 = 3;
pub const TIF_NEED_RESCHED: u32 = 4;
pub const TIF_NEED_RESCHED_LAZY: u32 = 5;
pub const TIF_POLLING_NRFLAG: u32 = 6;
pub const TIF_USER_RETURN_NOTIFY: u32 = 7;
pub const TIF_UPROBE: u32 = 8;
pub const TIF_PATCH_PENDING: u32 = 9;
pub const TIF_SSBD: u32 = 16;
pub const TIF_SPEC_IB: u32 = 17;
pub const TIF_SPEC_L1D_FLUSH: u32 = 18;
pub const TIF_NEED_FPU_LOAD: u32 = 19;
pub const TIF_NOCPUID: u32 = 20;
pub const TIF_NOTSC: u32 = 21;
pub const TIF_IO_BITMAP: u32 = 22;
pub const TIF_SPEC_FORCE_UPDATE: u32 = 23;
pub const TIF_FORCED_TF: u32 = 24;
pub const TIF_SINGLESTEP: u32 = 25;
pub const TIF_BLOCKSTEP: u32 = 26;
pub const TIF_LAZY_MMU_UPDATES: u32 = 27;
pub const TIF_ADDR32: u32 = 28;
pub const TS_COMPAT: u32 = 2;
pub const TS_I386_REGS_POKED: u32 = 4;
pub const STARTUP_READ_APICID: u32 = 2147483648;
pub const STARTUP_PARALLEL_MASK: u32 = 4278190080;
pub const force_read_lock_recursive: u32 = 0;
pub const SINGLE_DEPTH_NESTING: u32 = 1;
pub const LOCK_SECTION_END: &[u8; 12] = b".previous\n\t\0";
pub const RWLOCK_MAGIC: u32 = 3736018669;
pub const SPIN_THRESHOLD: u32 = 32768;
pub const _Q_PENDING_LOOPS: u32 = 512;
pub const _QW_WAITING: u32 = 256;
pub const _QW_LOCKED: u32 = 255;
pub const _QW_WMASK: u32 = 511;
pub const _QR_SHIFT: u32 = 9;
pub const _QR_BIAS: u32 = 512;
pub const WQ_FLAG_EXCLUSIVE: u32 = 1;
pub const WQ_FLAG_WOKEN: u32 = 2;
pub const WQ_FLAG_CUSTOM: u32 = 4;
pub const WQ_FLAG_DONE: u32 = 8;
pub const WQ_FLAG_PRIORITY: u32 = 16;
pub const OSQ_UNLOCKED_VAL: u32 = 0;
pub const KCSAN_SEQLOCK_REGION_MAX: u32 = 1000;
pub const NR_PAGEFLAGS: u32 = 25;
pub const MAX_NR_ZONES: u32 = 5;
pub const NR_CPUS_BITS: u32 = 13;
pub const SPINLOCK_SIZE: u32 = 4;
pub const LRU_GEN_WIDTH: u32 = 3;
pub const __LRU_REFS_WIDTH: u32 = 2;
pub const ZONES_SHIFT: u32 = 3;
pub const ZONES_WIDTH: u32 = 3;
pub const SECTIONS_WIDTH: u32 = 0;
pub const NODES_WIDTH: u32 = 10;
pub const KASAN_TAG_WIDTH: u32 = 0;
pub const LAST__PID_SHIFT: u32 = 8;
pub const LAST__PID_MASK: u32 = 255;
pub const LAST__CPU_SHIFT: u32 = 13;
pub const LAST__CPU_MASK: u32 = 8191;
pub const LAST_CPUPID_SHIFT: u32 = 21;
pub const LAST_CPUPID_WIDTH: u32 = 21;
pub const AT_SYSINFO_EHDR: u32 = 33;
pub const AT_VECTOR_SIZE_ARCH: u32 = 3;
pub const AT_NULL: u32 = 0;
pub const AT_IGNORE: u32 = 1;
pub const AT_EXECFD: u32 = 2;
pub const AT_PHDR: u32 = 3;
pub const AT_PHENT: u32 = 4;
pub const AT_PHNUM: u32 = 5;
pub const AT_PAGESZ: u32 = 6;
pub const AT_BASE: u32 = 7;
pub const AT_FLAGS: u32 = 8;
pub const AT_ENTRY: u32 = 9;
pub const AT_NOTELF: u32 = 10;
pub const AT_UID: u32 = 11;
pub const AT_EUID: u32 = 12;
pub const AT_GID: u32 = 13;
pub const AT_EGID: u32 = 14;
pub const AT_PLATFORM: u32 = 15;
pub const AT_HWCAP: u32 = 16;
pub const AT_CLKTCK: u32 = 17;
pub const AT_SECURE: u32 = 23;
pub const AT_BASE_PLATFORM: u32 = 24;
pub const AT_RANDOM: u32 = 25;
pub const AT_HWCAP2: u32 = 26;
pub const AT_RSEQ_FEATURE_SIZE: u32 = 27;
pub const AT_RSEQ_ALIGN: u32 = 28;
pub const AT_HWCAP3: u32 = 29;
pub const AT_HWCAP4: u32 = 30;
pub const AT_EXECFN: u32 = 31;
pub const AT_MINSIGSTKSZ: u32 = 51;
pub const AT_VECTOR_SIZE_BASE: u32 = 22;
pub const CSIGNAL: u32 = 255;
pub const CLONE_VM: u32 = 256;
pub const CLONE_FS: u32 = 512;
pub const CLONE_FILES: u32 = 1024;
pub const CLONE_SIGHAND: u32 = 2048;
pub const CLONE_PIDFD: u32 = 4096;
pub const CLONE_PTRACE: u32 = 8192;
pub const CLONE_VFORK: u32 = 16384;
pub const CLONE_PARENT: u32 = 32768;
pub const CLONE_THREAD: u32 = 65536;
pub const CLONE_NEWNS: u32 = 131072;
pub const CLONE_SYSVSEM: u32 = 262144;
pub const CLONE_SETTLS: u32 = 524288;
pub const CLONE_PARENT_SETTID: u32 = 1048576;
pub const CLONE_CHILD_CLEARTID: u32 = 2097152;
pub const CLONE_DETACHED: u32 = 4194304;
pub const CLONE_UNTRACED: u32 = 8388608;
pub const CLONE_CHILD_SETTID: u32 = 16777216;
pub const CLONE_NEWCGROUP: u32 = 33554432;
pub const CLONE_NEWUTS: u32 = 67108864;
pub const CLONE_NEWIPC: u32 = 134217728;
pub const CLONE_NEWUSER: u32 = 268435456;
pub const CLONE_NEWPID: u32 = 536870912;
pub const CLONE_NEWNET: u32 = 1073741824;
pub const CLONE_IO: u32 = 2147483648;
pub const CLONE_CLEAR_SIGHAND: u64 = 4294967296;
pub const CLONE_INTO_CGROUP: u64 = 8589934592;
pub const CLONE_NEWTIME: u32 = 128;
pub const CLONE_ARGS_SIZE_VER0: u32 = 64;
pub const CLONE_ARGS_SIZE_VER1: u32 = 80;
pub const CLONE_ARGS_SIZE_VER2: u32 = 88;
pub const SCHED_NORMAL: u32 = 0;
pub const SCHED_FIFO: u32 = 1;
pub const SCHED_RR: u32 = 2;
pub const SCHED_BATCH: u32 = 3;
pub const SCHED_IDLE: u32 = 5;
pub const SCHED_DEADLINE: u32 = 6;
pub const SCHED_EXT: u32 = 7;
pub const SCHED_RESET_ON_FORK: u32 = 1073741824;
pub const SCHED_FLAG_RESET_ON_FORK: u32 = 1;
pub const SCHED_FLAG_RECLAIM: u32 = 2;
pub const SCHED_FLAG_DL_OVERRUN: u32 = 4;
pub const SCHED_FLAG_KEEP_POLICY: u32 = 8;
pub const SCHED_FLAG_KEEP_PARAMS: u32 = 16;
pub const SCHED_FLAG_UTIL_CLAMP_MIN: u32 = 32;
pub const SCHED_FLAG_UTIL_CLAMP_MAX: u32 = 64;
pub const SCHED_FLAG_KEEP_ALL: u32 = 24;
pub const SCHED_FLAG_UTIL_CLAMP: u32 = 96;
pub const SCHED_FLAG_ALL: u32 = 127;
pub const KMSAN_RETVAL_SIZE: u32 = 800;
pub const KMSAN_PARAM_SIZE: u32 = 800;
pub const RUSAGE_SELF: u32 = 0;
pub const RUSAGE_CHILDREN: i32 = -1;
pub const RUSAGE_BOTH: i32 = -2;
pub const RUSAGE_THREAD: u32 = 1;
pub const RLIM64_INFINITY: i32 = -1;
pub const PRIO_MIN: i32 = -20;
pub const PRIO_MAX: u32 = 20;
pub const PRIO_PROCESS: u32 = 0;
pub const PRIO_PGRP: u32 = 1;
pub const PRIO_USER: u32 = 2;
pub const _STK_LIM: u32 = 8388608;
pub const MLOCK_LIMIT: u32 = 8388608;
pub const RLIMIT_CPU: u32 = 0;
pub const RLIMIT_FSIZE: u32 = 1;
pub const RLIMIT_DATA: u32 = 2;
pub const RLIMIT_STACK: u32 = 3;
pub const RLIMIT_CORE: u32 = 4;
pub const RLIMIT_RSS: u32 = 5;
pub const RLIMIT_NPROC: u32 = 6;
pub const RLIMIT_NOFILE: u32 = 7;
pub const RLIMIT_MEMLOCK: u32 = 8;
pub const RLIMIT_AS: u32 = 9;
pub const RLIMIT_LOCKS: u32 = 10;
pub const RLIMIT_SIGPENDING: u32 = 11;
pub const RLIMIT_MSGQUEUE: u32 = 12;
pub const RLIMIT_NICE: u32 = 13;
pub const RLIMIT_RTPRIO: u32 = 14;
pub const RLIMIT_RTTIME: u32 = 15;
pub const RLIM_NLIMITS: u32 = 16;
pub const RLIM_INFINITY: i32 = -1;
pub const MAX_NICE: u32 = 19;
pub const MIN_NICE: i32 = -20;
pub const NICE_WIDTH: u32 = 40;
pub const MAX_RT_PRIO: u32 = 100;
pub const MAX_DL_PRIO: u32 = 0;
pub const MAX_PRIO: u32 = 140;
pub const DEFAULT_PRIO: u32 = 120;
pub const _NSIG: u32 = 64;
pub const _NSIG_BPW: u32 = 64;
pub const _NSIG_WORDS: u32 = 1;
pub const SA_IA32_ABI: u32 = 33554432;
pub const SA_X32_ABI: u32 = 16777216;
pub const SIGHUP: u32 = 1;
pub const SIGINT: u32 = 2;
pub const SIGQUIT: u32 = 3;
pub const SIGILL: u32 = 4;
pub const SIGTRAP: u32 = 5;
pub const SIGABRT: u32 = 6;
pub const SIGIOT: u32 = 6;
pub const SIGBUS: u32 = 7;
pub const SIGFPE: u32 = 8;
pub const SIGKILL: u32 = 9;
pub const SIGUSR1: u32 = 10;
pub const SIGSEGV: u32 = 11;
pub const SIGUSR2: u32 = 12;
pub const SIGPIPE: u32 = 13;
pub const SIGALRM: u32 = 14;
pub const SIGTERM: u32 = 15;
pub const SIGSTKFLT: u32 = 16;
pub const SIGCHLD: u32 = 17;
pub const SIGCONT: u32 = 18;
pub const SIGSTOP: u32 = 19;
pub const SIGTSTP: u32 = 20;
pub const SIGTTIN: u32 = 21;
pub const SIGTTOU: u32 = 22;
pub const SIGURG: u32 = 23;
pub const SIGXCPU: u32 = 24;
pub const SIGXFSZ: u32 = 25;
pub const SIGVTALRM: u32 = 26;
pub const SIGPROF: u32 = 27;
pub const SIGWINCH: u32 = 28;
pub const SIGIO: u32 = 29;
pub const SIGPOLL: u32 = 29;
pub const SIGPWR: u32 = 30;
pub const SIGSYS: u32 = 31;
pub const SIGUNUSED: u32 = 31;
pub const SIGRTMIN: u32 = 32;
pub const SIGRTMAX: u32 = 64;
pub const SA_RESTORER: u32 = 67108864;
pub const MINSIGSTKSZ: u32 = 2048;
pub const SIGSTKSZ: u32 = 8192;
pub const SA_NOCLDSTOP: u32 = 1;
pub const SA_NOCLDWAIT: u32 = 2;
pub const SA_SIGINFO: u32 = 4;
pub const SA_UNSUPPORTED: u32 = 1024;
pub const SA_EXPOSE_TAGBITS: u32 = 2048;
pub const SA_ONSTACK: u32 = 134217728;
pub const SA_RESTART: u32 = 268435456;
pub const SA_NODEFER: u32 = 1073741824;
pub const SA_RESETHAND: u32 = 2147483648;
pub const SA_NOMASK: u32 = 1073741824;
pub const SA_ONESHOT: u32 = 2147483648;
pub const SIG_BLOCK: u32 = 0;
pub const SIG_UNBLOCK: u32 = 1;
pub const SIG_SETMASK: u32 = 2;
pub const SI_MAX_SIZE: u32 = 128;
pub const SI_USER: u32 = 0;
pub const SI_KERNEL: u32 = 128;
pub const SI_QUEUE: i32 = -1;
pub const SI_TIMER: i32 = -2;
pub const SI_MESGQ: i32 = -3;
pub const SI_ASYNCIO: i32 = -4;
pub const SI_SIGIO: i32 = -5;
pub const SI_TKILL: i32 = -6;
pub const SI_DETHREAD: i32 = -7;
pub const SI_ASYNCNL: i32 = -60;
pub const ILL_ILLOPC: u32 = 1;
pub const ILL_ILLOPN: u32 = 2;
pub const ILL_ILLADR: u32 = 3;
pub const ILL_ILLTRP: u32 = 4;
pub const ILL_PRVOPC: u32 = 5;
pub const ILL_PRVREG: u32 = 6;
pub const ILL_COPROC: u32 = 7;
pub const ILL_BADSTK: u32 = 8;
pub const ILL_BADIADDR: u32 = 9;
pub const __ILL_BREAK: u32 = 10;
pub const __ILL_BNDMOD: u32 = 11;
pub const NSIGILL: u32 = 11;
pub const FPE_INTDIV: u32 = 1;
pub const FPE_INTOVF: u32 = 2;
pub const FPE_FLTDIV: u32 = 3;
pub const FPE_FLTOVF: u32 = 4;
pub const FPE_FLTUND: u32 = 5;
pub const FPE_FLTRES: u32 = 6;
pub const FPE_FLTINV: u32 = 7;
pub const FPE_FLTSUB: u32 = 8;
pub const __FPE_DECOVF: u32 = 9;
pub const __FPE_DECDIV: u32 = 10;
pub const __FPE_DECERR: u32 = 11;
pub const __FPE_INVASC: u32 = 12;
pub const __FPE_INVDEC: u32 = 13;
pub const FPE_FLTUNK: u32 = 14;
pub const FPE_CONDTRAP: u32 = 15;
pub const NSIGFPE: u32 = 15;
pub const SEGV_MAPERR: u32 = 1;
pub const SEGV_ACCERR: u32 = 2;
pub const SEGV_BNDERR: u32 = 3;
pub const SEGV_PKUERR: u32 = 4;
pub const SEGV_ACCADI: u32 = 5;
pub const SEGV_ADIDERR: u32 = 6;
pub const SEGV_ADIPERR: u32 = 7;
pub const SEGV_MTEAERR: u32 = 8;
pub const SEGV_MTESERR: u32 = 9;
pub const SEGV_CPERR: u32 = 10;
pub const NSIGSEGV: u32 = 10;
pub const BUS_ADRALN: u32 = 1;
pub const BUS_ADRERR: u32 = 2;
pub const BUS_OBJERR: u32 = 3;
pub const BUS_MCEERR_AR: u32 = 4;
pub const BUS_MCEERR_AO: u32 = 5;
pub const NSIGBUS: u32 = 5;
pub const TRAP_BRKPT: u32 = 1;
pub const TRAP_TRACE: u32 = 2;
pub const TRAP_BRANCH: u32 = 3;
pub const TRAP_HWBKPT: u32 = 4;
pub const TRAP_UNK: u32 = 5;
pub const TRAP_PERF: u32 = 6;
pub const NSIGTRAP: u32 = 6;
pub const TRAP_PERF_FLAG_ASYNC: u32 = 1;
pub const CLD_EXITED: u32 = 1;
pub const CLD_KILLED: u32 = 2;
pub const CLD_DUMPED: u32 = 3;
pub const CLD_TRAPPED: u32 = 4;
pub const CLD_STOPPED: u32 = 5;
pub const CLD_CONTINUED: u32 = 6;
pub const NSIGCHLD: u32 = 6;
pub const POLL_IN: u32 = 1;
pub const POLL_OUT: u32 = 2;
pub const POLL_MSG: u32 = 3;
pub const POLL_ERR: u32 = 4;
pub const POLL_PRI: u32 = 5;
pub const POLL_HUP: u32 = 6;
pub const NSIGPOLL: u32 = 6;
pub const SYS_SECCOMP: u32 = 1;
pub const SYS_USER_DISPATCH: u32 = 2;
pub const NSIGSYS: u32 = 2;
pub const EMT_TAGOVF: u32 = 1;
pub const NSIGEMT: u32 = 1;
pub const SIGEV_SIGNAL: u32 = 0;
pub const SIGEV_NONE: u32 = 1;
pub const SIGEV_THREAD: u32 = 2;
pub const SIGEV_THREAD_ID: u32 = 4;
pub const SIGEV_MAX_SIZE: u32 = 64;
pub const SS_ONSTACK: u32 = 1;
pub const SS_DISABLE: u32 = 2;
pub const SS_AUTODISARM: u32 = 2147483648;
pub const SS_FLAG_BITS: u32 = 2147483648;
pub const SIGQUEUE_PREALLOC: u32 = 1;
pub const SA_IMMUTABLE: u32 = 8388608;
pub const __ARCH_UAPI_SA_FLAGS: u32 = 67108864;
pub const UAPI_SA_FLAGS: u32 = 3690989575;
pub const CPUCLOCK_PERTHREAD_MASK: u32 = 4;
pub const CPUCLOCK_CLOCK_MASK: u32 = 3;
pub const CPUCLOCK_PROF: u32 = 0;
pub const CPUCLOCK_VIRT: u32 = 1;
pub const CPUCLOCK_SCHED: u32 = 2;
pub const CPUCLOCK_MAX: u32 = 3;
pub const CLOCKFD: u32 = 3;
pub const CLOCKFD_MASK: u32 = 7;
pub const MAX_DA_NAME_LEN: u32 = 32;
pub const MAX_DA_RETRY_RACING_EVENTS: u32 = 3;
pub const TRACEPOINT_DEFS_H: u32 = 1;
pub const KM_MAX_IDX: u32 = 16;
pub const RQ_nr_pinned: u32 = 3872;
pub const CODETAG_SECTION_START_PREFIX: &[u8; 9] = b"__start_\0";
pub const CODETAG_SECTION_STOP_PREFIX: &[u8; 8] = b"__stop_\0";
pub const CODETAG_FLAG_INACCURATE: u32 = 1;
pub const TASK_RUNNING: u32 = 0;
pub const TASK_INTERRUPTIBLE: u32 = 1;
pub const TASK_UNINTERRUPTIBLE: u32 = 2;
pub const __TASK_STOPPED: u32 = 4;
pub const __TASK_TRACED: u32 = 8;
pub const EXIT_DEAD: u32 = 16;
pub const EXIT_ZOMBIE: u32 = 32;
pub const EXIT_TRACE: u32 = 48;
pub const TASK_PARKED: u32 = 64;
pub const TASK_DEAD: u32 = 128;
pub const TASK_WAKEKILL: u32 = 256;
pub const TASK_WAKING: u32 = 512;
pub const TASK_NOLOAD: u32 = 1024;
pub const TASK_NEW: u32 = 2048;
pub const TASK_RTLOCK_WAIT: u32 = 4096;
pub const TASK_FREEZABLE: u32 = 8192;
pub const TASK_FROZEN: u32 = 32768;
pub const TASK_STATE_MAX: u32 = 65536;
pub const TASK_ANY: u32 = 65535;
pub const TASK_KILLABLE: u32 = 258;
pub const TASK_STOPPED: u32 = 260;
pub const TASK_TRACED: u32 = 8;
pub const TASK_IDLE: u32 = 1026;
pub const TASK_NORMAL: u32 = 3;
pub const TASK_REPORT: u32 = 127;
pub const SCHED_FIXEDPOINT_SHIFT: u32 = 10;
pub const SCHED_FIXEDPOINT_SCALE: u32 = 1024;
pub const SCHED_CAPACITY_SHIFT: u32 = 10;
pub const SCHED_CAPACITY_SCALE: u32 = 1024;
pub const UTIL_EST_WEIGHT_SHIFT: u32 = 2;
pub const UTIL_AVG_UNCHANGED: u32 = 2147483648;
pub const UCLAMP_BUCKETS: u32 = 5;
pub const PERF_NR_CONTEXTS: u32 = 4;
pub const TASK_REPORT_IDLE: u32 = 128;
pub const TASK_REPORT_MAX: u32 = 256;
pub const PF_VCPU: u32 = 1;
pub const PF_IDLE: u32 = 2;
pub const PF_EXITING: u32 = 4;
pub const PF_POSTCOREDUMP: u32 = 8;
pub const PF_IO_WORKER: u32 = 16;
pub const PF_WQ_WORKER: u32 = 32;
pub const PF_FORKNOEXEC: u32 = 64;
pub const PF_MCE_PROCESS: u32 = 128;
pub const PF_SUPERPRIV: u32 = 256;
pub const PF_DUMPCORE: u32 = 512;
pub const PF_SIGNALED: u32 = 1024;
pub const PF_MEMALLOC: u32 = 2048;
pub const PF_NPROC_EXCEEDED: u32 = 4096;
pub const PF_USED_MATH: u32 = 8192;
pub const PF_USER_WORKER: u32 = 16384;
pub const PF_NOFREEZE: u32 = 32768;
pub const PF_KCOMPACTD: u32 = 65536;
pub const PF_KSWAPD: u32 = 131072;
pub const PF_MEMALLOC_NOFS: u32 = 262144;
pub const PF_MEMALLOC_NOIO: u32 = 524288;
pub const PF_LOCAL_THROTTLE: u32 = 1048576;
pub const PF_KTHREAD: u32 = 2097152;
pub const PF_RANDOMIZE: u32 = 4194304;
pub const PF__HOLE__00800000: u32 = 8388608;
pub const PF__HOLE__01000000: u32 = 16777216;
pub const PF__HOLE__02000000: u32 = 33554432;
pub const PF_NO_SETAFFINITY: u32 = 67108864;
pub const PF_MCE_EARLY: u32 = 134217728;
pub const PF_MEMALLOC_PIN: u32 = 268435456;
pub const PF_BLOCK_TS: u32 = 536870912;
pub const PF__HOLE__40000000: u32 = 1073741824;
pub const PF_SUSPEND_TASK: u32 = 2147483648;
pub const PFA_NO_NEW_PRIVS: u32 = 0;
pub const PFA_SPREAD_PAGE: u32 = 1;
pub const PFA_SPREAD_SLAB: u32 = 2;
pub const PFA_SPEC_SSB_DISABLE: u32 = 3;
pub const PFA_SPEC_SSB_FORCE_DISABLE: u32 = 4;
pub const PFA_SPEC_IB_DISABLE: u32 = 5;
pub const PFA_SPEC_IB_FORCE_DISABLE: u32 = 6;
pub const PFA_SPEC_SSB_NOEXEC: u32 = 7;
pub const MIGHT_RESCHED_RCU_SHIFT: u32 = 8;
pub const MIGHT_RESCHED_PREEMPT_MASK: u32 = 255;
pub const PREEMPT_LOCK_RESCHED_OFFSETS: u32 = 1;
pub const RCU_SEQ_CTR_SHIFT: u32 = 2;
pub const RCU_SEQ_STATE_MASK: u32 = 3;
pub const NUM_ACTIVE_RCU_POLL_OLDSTATE: u32 = 2;
pub const TRC_NEED_QS: u32 = 1;
pub const TRC_NEED_QS_CHECKED: u32 = 2;
pub const NUM_ACTIVE_RCU_POLL_FULL_OLDSTATE: u32 = 4;
pub const MAPLE_NODE_SLOTS: u32 = 31;
pub const MAPLE_RANGE64_SLOTS: u32 = 16;
pub const MAPLE_ARANGE64_SLOTS: u32 = 10;
pub const MAPLE_ALLOC_SLOTS: u32 = 30;
pub const MAPLE_NODE_MASK: u32 = 255;
pub const MT_FLAGS_ALLOC_RANGE: u32 = 1;
pub const MT_FLAGS_USE_RCU: u32 = 2;
pub const MT_FLAGS_HEIGHT_OFFSET: u32 = 2;
pub const MT_FLAGS_HEIGHT_MASK: u32 = 124;
pub const MT_FLAGS_LOCK_MASK: u32 = 768;
pub const MT_FLAGS_LOCK_IRQ: u32 = 256;
pub const MT_FLAGS_LOCK_BH: u32 = 512;
pub const MT_FLAGS_LOCK_EXTERN: u32 = 768;
pub const MT_FLAGS_ALLOC_WRAPPED: u32 = 2048;
pub const MAPLE_HEIGHT_MAX: u32 = 31;
pub const MAPLE_NODE_TYPE_MASK: u32 = 15;
pub const MAPLE_NODE_TYPE_SHIFT: u32 = 3;
pub const MAPLE_RESERVED_RANGE: u32 = 4096;
pub const RWSEM_UNLOCKED_VALUE: u32 = 0;
pub const RWSEM_WRITER_LOCKED: u32 = 1;
pub const MSEC_PER_SEC: u32 = 1000;
pub const USEC_PER_MSEC: u32 = 1000;
pub const NSEC_PER_USEC: u32 = 1000;
pub const NSEC_PER_MSEC: u32 = 1000000;
pub const USEC_PER_SEC: u32 = 1000000;
pub const NSEC_PER_SEC: u32 = 1000000000;
pub const PSEC_PER_SEC: u64 = 1000000000000;
pub const FSEC_PER_SEC: u64 = 1000000000000000;
pub const ITIMER_REAL: u32 = 0;
pub const ITIMER_VIRTUAL: u32 = 1;
pub const ITIMER_PROF: u32 = 2;
pub const CLOCK_REALTIME: u32 = 0;
pub const CLOCK_MONOTONIC: u32 = 1;
pub const CLOCK_PROCESS_CPUTIME_ID: u32 = 2;
pub const CLOCK_THREAD_CPUTIME_ID: u32 = 3;
pub const CLOCK_MONOTONIC_RAW: u32 = 4;
pub const CLOCK_REALTIME_COARSE: u32 = 5;
pub const CLOCK_MONOTONIC_COARSE: u32 = 6;
pub const CLOCK_BOOTTIME: u32 = 7;
pub const CLOCK_REALTIME_ALARM: u32 = 8;
pub const CLOCK_BOOTTIME_ALARM: u32 = 9;
pub const CLOCK_SGI_CYCLE: u32 = 10;
pub const CLOCK_TAI: u32 = 11;
pub const MAX_CLOCKS: u32 = 16;
pub const CLOCK_AUX: u32 = 16;
pub const MAX_AUX_CLOCKS: u32 = 8;
pub const CLOCK_AUX_LAST: u32 = 23;
pub const CLOCKS_MASK: u32 = 1;
pub const CLOCKS_MONO: u32 = 1;
pub const TIMER_ABSTIME: u32 = 1;
pub const PSEC_PER_NSEC: u32 = 1000;
pub const TIME_UPTIME_SEC_MAX: u32 = 946080000;
pub const NTP_API: u32 = 4;
pub const ADJ_OFFSET: u32 = 1;
pub const ADJ_FREQUENCY: u32 = 2;
pub const ADJ_MAXERROR: u32 = 4;
pub const ADJ_ESTERROR: u32 = 8;
pub const ADJ_STATUS: u32 = 16;
pub const ADJ_TIMECONST: u32 = 32;
pub const ADJ_TAI: u32 = 128;
pub const ADJ_SETOFFSET: u32 = 256;
pub const ADJ_MICRO: u32 = 4096;
pub const ADJ_NANO: u32 = 8192;
pub const ADJ_TICK: u32 = 16384;
pub const MOD_OFFSET: u32 = 1;
pub const MOD_FREQUENCY: u32 = 2;
pub const MOD_MAXERROR: u32 = 4;
pub const MOD_ESTERROR: u32 = 8;
pub const MOD_STATUS: u32 = 16;
pub const MOD_TIMECONST: u32 = 32;
pub const MOD_TAI: u32 = 128;
pub const MOD_MICRO: u32 = 4096;
pub const MOD_NANO: u32 = 8192;
pub const STA_PLL: u32 = 1;
pub const STA_PPSFREQ: u32 = 2;
pub const STA_PPSTIME: u32 = 4;
pub const STA_FLL: u32 = 8;
pub const STA_INS: u32 = 16;
pub const STA_DEL: u32 = 32;
pub const STA_UNSYNC: u32 = 64;
pub const STA_FREQHOLD: u32 = 128;
pub const STA_PPSSIGNAL: u32 = 256;
pub const STA_PPSJITTER: u32 = 512;
pub const STA_PPSWANDER: u32 = 1024;
pub const STA_PPSERROR: u32 = 2048;
pub const STA_CLOCKERR: u32 = 4096;
pub const STA_NANO: u32 = 8192;
pub const STA_MODE: u32 = 16384;
pub const STA_CLK: u32 = 32768;
pub const STA_RONLY: u32 = 65280;
pub const TIME_OK: u32 = 0;
pub const TIME_INS: u32 = 1;
pub const TIME_DEL: u32 = 2;
pub const TIME_OOP: u32 = 3;
pub const TIME_WAIT: u32 = 4;
pub const TIME_ERROR: u32 = 5;
pub const TIME_BAD: u32 = 5;
pub const ADJ_ADJTIME: u32 = 32768;
pub const ADJ_OFFSET_SINGLESHOT: u32 = 1;
pub const ADJ_OFFSET_READONLY: u32 = 8192;
pub const LINUX_MM_DEBUG_H: u32 = 1;
pub const PERCPU_MODULE_RESERVE: u32 = 8192;
pub const PCPU_MIN_ALLOC_SHIFT: u32 = 2;
pub const PCPU_MIN_ALLOC_SIZE: u32 = 4;
pub const PERCPU_DYNAMIC_SIZE_SHIFT: u32 = 10;
pub const PERCPU_DYNAMIC_EARLY_SIZE: u32 = 20480;
pub const PERCPU_DYNAMIC_RESERVE: u32 = 28672;
pub const SHIFT_PLL: u32 = 2;
pub const SHIFT_FLL: u32 = 2;
pub const MAXTC: u32 = 10;
pub const SHIFT_USEC: u32 = 16;
pub const PPM_SCALE_INV_SHIFT: u32 = 19;
pub const MAXPHASE: u32 = 500000000;
pub const MAXFREQ: u32 = 500000;
pub const MINSEC: u32 = 256;
pub const MAXSEC: u32 = 2048;
pub const NTP_PHASE_LIMIT: u32 = 16000000;
pub const NTP_SCALE_SHIFT: u32 = 32;
pub const NTP_INTERVAL_FREQ: u32 = 1000;
pub const NTP_INTERVAL_LENGTH: u32 = 1000000;
pub const PIT_TICK_RATE: u32 = 1193182;
pub const TICK_NSEC: u32 = 1000000;
pub const HZ_TO_MSEC_SHR32: u32 = 31;
pub const MSEC_TO_HZ_SHR32: u32 = 31;
pub const HZ_TO_MSEC_NUM: u32 = 1;
pub const HZ_TO_MSEC_DEN: u32 = 1;
pub const MSEC_TO_HZ_NUM: u32 = 1;
pub const MSEC_TO_HZ_DEN: u32 = 1;
pub const HZ_TO_USEC_SHR32: u32 = 22;
pub const USEC_TO_HZ_SHR32: u32 = 41;
pub const HZ_TO_USEC_NUM: u32 = 1000;
pub const HZ_TO_USEC_DEN: u32 = 1;
pub const USEC_TO_HZ_NUM: u32 = 1;
pub const USEC_TO_HZ_DEN: u32 = 1000;
pub const HZ_TO_NSEC_NUM: u32 = 1000000;
pub const HZ_TO_NSEC_DEN: u32 = 1;
pub const NSEC_TO_HZ_NUM: u32 = 1;
pub const NSEC_TO_HZ_DEN: u32 = 1000000;
pub const SHIFT_HZ: u32 = 10;
pub const TICK_USEC: u32 = 1000;
pub const USER_TICK_USEC: u32 = 10000;
pub const SEC_JIFFIE_SC: u32 = 21;
pub const NSEC_JIFFIE_SC: u32 = 51;
pub const TIMESTAMP_SIZE: u32 = 30;
pub const LOW_RES_NSEC: u32 = 1000000;
pub const KTIME_LOW_RES: u32 = 1000000;
pub const TIMER_CPUMASK: u32 = 262143;
pub const TIMER_MIGRATING: u32 = 262144;
pub const TIMER_BASEMASK: u32 = 524287;
pub const TIMER_DEFERRABLE: u32 = 524288;
pub const TIMER_PINNED: u32 = 1048576;
pub const TIMER_IRQSAFE: u32 = 2097152;
pub const TIMER_INIT_FLAGS: u32 = 3670016;
pub const TIMER_ARRAYSHIFT: u32 = 22;
pub const TIMER_ARRAYMASK: u32 = 4290772992;
pub const TIMER_TRACE_FLAGMASK: u32 = 3932160;
pub const TIMER_NEXT_MAX_DELTA: u32 = 1073741823;
pub const UPROBE_HANDLER_REMOVE: u32 = 1;
pub const UPROBE_HANDLER_IGNORE: u32 = 2;
pub const MAX_URETPROBE_DEPTH: u32 = 64;
pub const UPROBE_NO_TRAMPOLINE_VADDR: i32 = -1;
pub const RCU_DONE_TAIL: u32 = 0;
pub const RCU_WAIT_TAIL: u32 = 1;
pub const RCU_NEXT_READY_TAIL: u32 = 2;
pub const RCU_NEXT_TAIL: u32 = 3;
pub const RCU_CBLIST_NSEGS: u32 = 4;
pub const SRCU_READ_FLAVOR_NORMAL: u32 = 1;
pub const SRCU_READ_FLAVOR_NMI: u32 = 2;
pub const SRCU_READ_FLAVOR_FAST: u32 = 8;
pub const SRCU_READ_FLAVOR_ALL: u32 = 11;
pub const SRCU_READ_FLAVOR_SLOWGP: u32 = 8;
pub const RCU_FANOUT: u32 = 64;
pub const RCU_FANOUT_LEAF: u32 = 16;
pub const RCU_FANOUT_1: u32 = 16;
pub const RCU_FANOUT_2: u32 = 1024;
pub const RCU_FANOUT_3: u32 = 65536;
pub const RCU_FANOUT_4: u32 = 4194304;
pub const RCU_NUM_LVLS: u32 = 3;
pub const NUM_RCU_LVL_0: u32 = 1;
pub const SRCU_SIZE_SMALL: u32 = 0;
pub const SRCU_SIZE_ALLOC: u32 = 1;
pub const SRCU_SIZE_WAIT_BARRIER: u32 = 2;
pub const SRCU_SIZE_WAIT_CALL: u32 = 3;
pub const SRCU_SIZE_WAIT_CBS1: u32 = 4;
pub const SRCU_SIZE_WAIT_CBS2: u32 = 5;
pub const SRCU_SIZE_WAIT_CBS3: u32 = 6;
pub const SRCU_SIZE_WAIT_CBS4: u32 = 7;
pub const SRCU_SIZE_BIG: u32 = 8;
pub const SRCU_STATE_IDLE: u32 = 0;
pub const SRCU_STATE_SCAN1: u32 = 1;
pub const SRCU_STATE_SCAN2: u32 = 2;
pub const SRCU_GP_SEQ_INITIAL_VAL: i32 = -400;
pub const SRCU_GP_SEQ_INITIAL_VAL_WITH_STATE: i32 = -401;
pub const SRCU_GET_STATE_COMPLETED: u32 = 1;
pub const NUM_ACTIVE_SRCU_POLL_OLDSTATE: u32 = 2;
pub const NOTIFY_DONE: u32 = 0;
pub const NOTIFY_OK: u32 = 1;
pub const NOTIFY_STOP_MASK: u32 = 32768;
pub const NOTIFY_BAD: u32 = 32770;
pub const NOTIFY_STOP: u32 = 32769;
pub const NETLINK_URELEASE: u32 = 1;
pub const KBD_KEYCODE: u32 = 1;
pub const KBD_UNBOUND_KEYCODE: u32 = 2;
pub const KBD_UNICODE: u32 = 3;
pub const KBD_KEYSYM: u32 = 4;
pub const KBD_POST_KEYSYM: u32 = 5;
pub const MAX_UINSN_BYTES: u32 = 16;
pub const UPROBE_XOL_SLOT_BYTES: u32 = 128;
pub const UPROBE_SWBP_INSN: u32 = 204;
pub const UPROBE_SWBP_INSN_SIZE: u32 = 1;
pub const MM_CONTEXT_UPROBE_IA32: u32 = 0;
pub const MM_CONTEXT_HAS_VSYSCALL: u32 = 1;
pub const MM_CONTEXT_LOCK_LAM: u32 = 2;
pub const MM_CONTEXT_FORCE_TAGGED_SVA: u32 = 3;
pub const MM_CONTEXT_NOTRACK: u32 = 4;
pub const AT_VECTOR_SIZE: u32 = 52;
pub const ENCODED_PAGE_BITS: u32 = 3;
pub const ENCODED_PAGE_BIT_DELAY_RMAP: u32 = 1;
pub const ENCODED_PAGE_BIT_NR_PAGES_NEXT: u32 = 2;
pub const MM_ID_DUMMY: u32 = 0;
pub const MM_ID_MIN: u32 = 1;
pub const VMA_LOCK_OFFSET: u32 = 1073741824;
pub const VMA_REF_LIMIT: u32 = 1073741823;
pub const NUM_MM_FLAG_BITS: u32 = 64;
pub const MM_MT_FLAGS: u32 = 771;
pub const MMF_DUMPABLE_BITS: u32 = 2;
pub const MMF_DUMP_ANON_PRIVATE: u32 = 2;
pub const MMF_DUMP_ANON_SHARED: u32 = 3;
pub const MMF_DUMP_MAPPED_PRIVATE: u32 = 4;
pub const MMF_DUMP_MAPPED_SHARED: u32 = 5;
pub const MMF_DUMP_ELF_HEADERS: u32 = 6;
pub const MMF_DUMP_HUGETLB_PRIVATE: u32 = 7;
pub const MMF_DUMP_HUGETLB_SHARED: u32 = 8;
pub const MMF_DUMP_DAX_PRIVATE: u32 = 9;
pub const MMF_DUMP_DAX_SHARED: u32 = 10;
pub const MMF_DUMP_FILTER_SHIFT: u32 = 2;
pub const MMF_DUMP_FILTER_BITS: u32 = 9;
pub const MMF_VM_MERGEABLE: u32 = 16;
pub const MMF_VM_HUGEPAGE: u32 = 17;
pub const MMF_HUGE_ZERO_FOLIO: u32 = 18;
pub const MMF_HAS_UPROBES: u32 = 19;
pub const MMF_RECALC_UPROBES: u32 = 20;
pub const MMF_OOM_SKIP: u32 = 21;
pub const MMF_UNSTABLE: u32 = 22;
pub const MMF_DISABLE_THP_EXCEPT_ADVISED: u32 = 23;
pub const MMF_DISABLE_THP_COMPLETELY: u32 = 24;
pub const MMF_OOM_REAP_QUEUED: u32 = 25;
pub const MMF_MULTIPROCESS: u32 = 26;
pub const MMF_HAS_PINNED: u32 = 27;
pub const MMF_HAS_MDWE: u32 = 28;
pub const MMF_HAS_MDWE_NO_INHERIT: u32 = 29;
pub const MMF_VM_MERGE_ANY: u32 = 30;
pub const MMF_TOPDOWN: u32 = 31;
pub const PAGEFLAGS_MASK: u32 = 33554431;
pub const PAGE_POISON_PATTERN: i32 = -1;
pub const FOLIO_PF_ANY: u32 = 0;
pub const FOLIO_PF_HEAD: u32 = 0;
pub const FOLIO_PF_NO_TAIL: u32 = 0;
pub const FOLIO_PF_NO_COMPOUND: u32 = 0;
pub const FOLIO_PF_SECOND: u32 = 1;
pub const FOLIO_HEAD_PAGE: u32 = 0;
pub const FOLIO_SECOND_PAGE: u32 = 1;
pub const FOLIO_MAPPING_ANON: u32 = 1;
pub const FOLIO_MAPPING_ANON_KSM: u32 = 2;
pub const FOLIO_MAPPING_KSM: u32 = 3;
pub const FOLIO_MAPPING_FLAGS: u32 = 3;
pub const MAX_PAGE_ORDER: u32 = 10;
pub const MAX_ORDER_NR_PAGES: u32 = 1024;
pub const NR_PAGE_ORDERS: u32 = 11;
pub const PAGE_BLOCK_MAX_ORDER: u32 = 10;
pub const PAGE_ALLOC_COSTLY_ORDER: u32 = 3;
pub const LRU_BASE: u32 = 0;
pub const LRU_ACTIVE: u32 = 1;
pub const LRU_FILE: u32 = 2;
pub const WORKINGSET_ANON: u32 = 0;
pub const WORKINGSET_FILE: u32 = 1;
pub const ANON_AND_FILE: u32 = 2;
pub const MIN_NR_GENS: u32 = 2;
pub const MAX_NR_GENS: u32 = 4;
pub const MAX_NR_TIERS: u32 = 4;
pub const MIN_LRU_BATCH: u32 = 64;
pub const MAX_LRU_BATCH: u32 = 4096;
pub const NR_HIST_GENS: u32 = 1;
pub const NR_BLOOM_FILTERS: u32 = 2;
pub const MEMCG_NR_GENS: u32 = 3;
pub const MEMCG_NR_BINS: u32 = 8;
pub const NR_PCP_THP: u32 = 2;
pub const ASYNC_AND_SYNC: u32 = 2;
pub const ZONEID_SHIFT: u32 = 13;
pub const ZONES_MASK: u32 = 7;
pub const NODES_MASK: u32 = 1023;
pub const SECTIONS_MASK: u32 = 0;
pub const LAST_CPUPID_MASK: u32 = 2097151;
pub const KASAN_TAG_MASK: u32 = 0;
pub const ZONEID_MASK: u32 = 8191;
pub const DEF_PRIORITY: u32 = 12;
pub const MAX_ZONES_PER_ZONELIST: u32 = 5120;
pub const PA_SECTION_SHIFT: u32 = 27;
pub const PFN_SECTION_SHIFT: u32 = 15;
pub const PAGES_PER_SECTION: u32 = 32768;
pub const PAGE_SECTION_MASK: i32 = -32768;
pub const SUBSECTION_SHIFT: u32 = 21;
pub const SUBSECTION_SIZE: u32 = 2097152;
pub const PFN_SUBSECTION_SHIFT: u32 = 9;
pub const PAGES_PER_SUBSECTION: u32 = 512;
pub const PAGE_SUBSECTION_MASK: i32 = -512;
pub const SUBSECTIONS_PER_SECTION: u32 = 64;
pub const MPC_SIGNATURE: &[u8; 5] = b"PCMP\0";
pub const MP_PROCESSOR: u32 = 0;
pub const MP_BUS: u32 = 1;
pub const MP_IOAPIC: u32 = 2;
pub const MP_INTSRC: u32 = 3;
pub const MP_LINTSRC: u32 = 4;
pub const MP_TRANSLATION: u32 = 192;
pub const CPU_ENABLED: u32 = 1;
pub const CPU_BOOTPROCESSOR: u32 = 2;
pub const CPU_STEPPING_MASK: u32 = 15;
pub const CPU_MODEL_MASK: u32 = 240;
pub const CPU_FAMILY_MASK: u32 = 3840;
pub const BUSTYPE_EISA: &[u8; 5] = b"EISA\0";
pub const BUSTYPE_ISA: &[u8; 4] = b"ISA\0";
pub const BUSTYPE_INTERN: &[u8; 7] = b"INTERN\0";
pub const BUSTYPE_MCA: &[u8; 4] = b"MCA\0";
pub const BUSTYPE_VL: &[u8; 3] = b"VL\0";
pub const BUSTYPE_PCI: &[u8; 4] = b"PCI\0";
pub const BUSTYPE_PCMCIA: &[u8; 7] = b"PCMCIA\0";
pub const BUSTYPE_CBUS: &[u8; 5] = b"CBUS\0";
pub const BUSTYPE_CBUSII: &[u8; 7] = b"CBUSII\0";
pub const BUSTYPE_FUTURE: &[u8; 7] = b"FUTURE\0";
pub const BUSTYPE_MBI: &[u8; 4] = b"MBI\0";
pub const BUSTYPE_MBII: &[u8; 5] = b"MBII\0";
pub const BUSTYPE_MPI: &[u8; 4] = b"MPI\0";
pub const BUSTYPE_MPSA: &[u8; 5] = b"MPSA\0";
pub const BUSTYPE_NUBUS: &[u8; 6] = b"NUBUS\0";
pub const BUSTYPE_TC: &[u8; 3] = b"TC\0";
pub const BUSTYPE_VME: &[u8; 4] = b"VME\0";
pub const BUSTYPE_XPRESS: &[u8; 7] = b"XPRESS\0";
pub const MPC_APIC_USABLE: u32 = 1;
pub const MP_IRQPOL_DEFAULT: u32 = 0;
pub const MP_IRQPOL_ACTIVE_HIGH: u32 = 1;
pub const MP_IRQPOL_RESERVED: u32 = 2;
pub const MP_IRQPOL_ACTIVE_LOW: u32 = 3;
pub const MP_IRQPOL_MASK: u32 = 3;
pub const MP_IRQTRIG_DEFAULT: u32 = 0;
pub const MP_IRQTRIG_EDGE: u32 = 4;
pub const MP_IRQTRIG_RESERVED: u32 = 8;
pub const MP_IRQTRIG_LEVEL: u32 = 12;
pub const MP_IRQTRIG_MASK: u32 = 12;
pub const MP_APIC_ALL: u32 = 255;
pub const MPC_OEM_SIGNATURE: &[u8; 5] = b"_OEM\0";
pub const IO_APIC_DEFAULT_PHYS_BASE: u32 = 4273995776;
pub const APIC_DEFAULT_PHYS_BASE: u32 = 4276092928;
pub const IO_APIC_SLOT_SIZE: u32 = 1024;
pub const APIC_DELIVERY_MODE_FIXED: u32 = 0;
pub const APIC_DELIVERY_MODE_LOWESTPRIO: u32 = 1;
pub const APIC_DELIVERY_MODE_SMI: u32 = 2;
pub const APIC_DELIVERY_MODE_NMI: u32 = 4;
pub const APIC_DELIVERY_MODE_INIT: u32 = 5;
pub const APIC_DELIVERY_MODE_EXTINT: u32 = 7;
pub const APIC_ID: u32 = 32;
pub const APIC_LVR: u32 = 48;
pub const APIC_LVR_MASK: u32 = 16711935;
pub const APIC_LVR_DIRECTED_EOI: u32 = 16777216;
pub const APIC_TASKPRI: u32 = 128;
pub const APIC_TPRI_MASK: u32 = 255;
pub const APIC_ARBPRI: u32 = 144;
pub const APIC_ARBPRI_MASK: u32 = 255;
pub const APIC_PROCPRI: u32 = 160;
pub const APIC_EOI: u32 = 176;
pub const APIC_EOI_ACK: u32 = 0;
pub const APIC_RRR: u32 = 192;
pub const APIC_LDR: u32 = 208;
pub const APIC_LDR_MASK: u32 = 4278190080;
pub const APIC_ALL_CPUS: u32 = 255;
pub const APIC_DFR: u32 = 224;
pub const APIC_DFR_CLUSTER: u32 = 268435455;
pub const APIC_DFR_FLAT: u32 = 4294967295;
pub const APIC_SPIV: u32 = 240;
pub const APIC_SPIV_DIRECTED_EOI: u32 = 4096;
pub const APIC_SPIV_FOCUS_DISABLED: u32 = 512;
pub const APIC_SPIV_APIC_ENABLED: u32 = 256;
pub const APIC_ISR: u32 = 256;
pub const APIC_ISR_NR: u32 = 8;
pub const APIC_TMR: u32 = 384;
pub const APIC_IRR: u32 = 512;
pub const APIC_ESR: u32 = 640;
pub const APIC_ESR_SEND_CS: u32 = 1;
pub const APIC_ESR_RECV_CS: u32 = 2;
pub const APIC_ESR_SEND_ACC: u32 = 4;
pub const APIC_ESR_RECV_ACC: u32 = 8;
pub const APIC_ESR_SENDILL: u32 = 32;
pub const APIC_ESR_RECVILL: u32 = 64;
pub const APIC_ESR_ILLREGA: u32 = 128;
pub const APIC_LVTCMCI: u32 = 752;
pub const APIC_ICR: u32 = 768;
pub const APIC_DEST_SELF: u32 = 262144;
pub const APIC_DEST_ALLINC: u32 = 524288;
pub const APIC_DEST_ALLBUT: u32 = 786432;
pub const APIC_ICR_RR_MASK: u32 = 196608;
pub const APIC_ICR_RR_INVALID: u32 = 0;
pub const APIC_ICR_RR_INPROG: u32 = 65536;
pub const APIC_ICR_RR_VALID: u32 = 131072;
pub const APIC_INT_LEVELTRIG: u32 = 32768;
pub const APIC_INT_ASSERT: u32 = 16384;
pub const APIC_ICR_BUSY: u32 = 4096;
pub const APIC_DEST_LOGICAL: u32 = 2048;
pub const APIC_DEST_PHYSICAL: u32 = 0;
pub const APIC_DM_FIXED: u32 = 0;
pub const APIC_DM_FIXED_MASK: u32 = 1792;
pub const APIC_DM_LOWEST: u32 = 256;
pub const APIC_DM_SMI: u32 = 512;
pub const APIC_DM_REMRD: u32 = 768;
pub const APIC_DM_NMI: u32 = 1024;
pub const APIC_DM_INIT: u32 = 1280;
pub const APIC_DM_STARTUP: u32 = 1536;
pub const APIC_DM_EXTINT: u32 = 1792;
pub const APIC_VECTOR_MASK: u32 = 255;
pub const APIC_ICR2: u32 = 784;
pub const APIC_LVTT: u32 = 800;
pub const APIC_LVTTHMR: u32 = 816;
pub const APIC_LVTPC: u32 = 832;
pub const APIC_LVT0: u32 = 848;
pub const APIC_LVT_TIMER_ONESHOT: u32 = 0;
pub const APIC_LVT_TIMER_PERIODIC: u32 = 131072;
pub const APIC_LVT_TIMER_TSCDEADLINE: u32 = 262144;
pub const APIC_LVT_MASKED: u32 = 65536;
pub const APIC_LVT_LEVEL_TRIGGER: u32 = 32768;
pub const APIC_LVT_REMOTE_IRR: u32 = 16384;
pub const APIC_INPUT_POLARITY: u32 = 8192;
pub const APIC_SEND_PENDING: u32 = 4096;
pub const APIC_MODE_MASK: u32 = 1792;
pub const APIC_MODE_FIXED: u32 = 0;
pub const APIC_MODE_NMI: u32 = 4;
pub const APIC_MODE_EXTINT: u32 = 7;
pub const APIC_LVT1: u32 = 864;
pub const APIC_LVTERR: u32 = 880;
pub const APIC_TMICT: u32 = 896;
pub const APIC_TMCCT: u32 = 912;
pub const APIC_TDCR: u32 = 992;
pub const APIC_SELF_IPI: u32 = 1008;
pub const APIC_TDR_DIV_TMBASE: u32 = 4;
pub const APIC_TDR_DIV_1: u32 = 11;
pub const APIC_TDR_DIV_2: u32 = 0;
pub const APIC_TDR_DIV_4: u32 = 1;
pub const APIC_TDR_DIV_8: u32 = 2;
pub const APIC_TDR_DIV_16: u32 = 3;
pub const APIC_TDR_DIV_32: u32 = 8;
pub const APIC_TDR_DIV_64: u32 = 9;
pub const APIC_TDR_DIV_128: u32 = 10;
pub const APIC_EFEAT: u32 = 1024;
pub const APIC_ECTRL: u32 = 1040;
pub const APIC_SEOI: u32 = 1056;
pub const APIC_IER: u32 = 1152;
pub const APIC_EILVT_NR_AMD_K8: u32 = 1;
pub const APIC_EILVT_NR_AMD_10H: u32 = 4;
pub const APIC_EILVT_NR_MAX: u32 = 4;
pub const APIC_EILVT_MSG_FIX: u32 = 0;
pub const APIC_EILVT_MSG_SMI: u32 = 2;
pub const APIC_EILVT_MSG_NMI: u32 = 4;
pub const APIC_EILVT_MSG_EXT: u32 = 7;
pub const APIC_EILVT_MASKED: u32 = 65536;
pub const APIC_BASE_MSR: u32 = 2048;
pub const APIC_X2APIC_ID_MSR: u32 = 2050;
pub const MAX_IO_APICS: u32 = 128;
pub const MAX_LOCAL_APIC: u32 = 32768;
pub const XAPIC_DEST_CPUS_SHIFT: u32 = 4;
pub const XAPIC_DEST_CPUS_MASK: u32 = 15;
pub const XAPIC_DEST_CLUSTER_MASK: u32 = 240;
pub const BAD_APICID: u32 = 65535;
pub const MAX_MP_BUSSES: u32 = 256;
pub const MAX_IRQ_SOURCES: u32 = 1024;
pub const LOCAL_DISTANCE: u32 = 10;
pub const REMOTE_DISTANCE: u32 = 20;
pub const DISTANCE_BITS: u32 = 8;
pub const RECLAIM_DISTANCE: u32 = 30;
pub const PENALTY_FOR_NODE_WITH_CPUS: u32 = 1;
pub const GFP_MOVABLE_SHIFT: u32 = 3;
pub const GFP_ZONES_SHIFT: u32 = 2;
pub const GOLDEN_RATIO_32: u32 = 1640531527;
pub const GOLDEN_RATIO_64: u64 = 7046029254386353131;
pub const KASAN_TAG_KERNEL: u32 = 255;
pub const KASAN_TAG_INVALID: u32 = 254;
pub const KASAN_TAG_MAX: u32 = 253;
pub const KASAN_TAG_MIN: u32 = 0;
pub const KASAN_VMALLOC_PAGE_RANGE: u32 = 1;
pub const KASAN_VMALLOC_TLB_FLUSH: u32 = 2;
pub const KMALLOC_SHIFT_HIGH: u32 = 13;
pub const KMALLOC_SHIFT_MAX: u32 = 22;
pub const KMALLOC_SHIFT_LOW: u32 = 3;
pub const KMALLOC_MAX_SIZE: u32 = 4194304;
pub const KMALLOC_MAX_CACHE_SIZE: u32 = 8192;
pub const KMALLOC_MAX_ORDER: u32 = 10;
pub const KMALLOC_MIN_SIZE: u32 = 8;
pub const RANDOM_KMALLOC_CACHES_NR: u32 = 0;
pub const PRINTK_INFO_SUBSYSTEM_LEN: u32 = 16;
pub const PRINTK_INFO_DEVICE_LEN: u32 = 48;
pub const SUID_DUMP_DISABLE: u32 = 0;
pub const SUID_DUMP_USER: u32 = 1;
pub const SUID_DUMP_ROOT: u32 = 2;
pub const BITS_PER_XA_VALUE: u32 = 63;
pub const XA_MAX_MARKS: u32 = 3;
pub const RADIX_TREE_ENTRY_MASK: u32 = 3;
pub const RADIX_TREE_INTERNAL_NODE: u32 = 2;
pub const RADIX_TREE_MAX_TAGS: u32 = 3;
pub const IDR_FREE: u32 = 0;
pub const IDA_CHUNK_SIZE: u32 = 128;
pub const DEFAULT_OVERFLOWUID: u32 = 65534;
pub const DEFAULT_OVERFLOWGID: u32 = 65534;
pub const DEFAULT_FS_OVERFLOWUID: u32 = 65534;
pub const DEFAULT_FS_OVERFLOWGID: u32 = 65534;
pub const KERNFS_TYPE_MASK: u32 = 15;
pub const KERNFS_FLAG_MASK: i32 = -16;
pub const KERNFS_MAX_USER_XATTRS: u32 = 128;
pub const KERNFS_USER_XATTR_SIZE_LIMIT: u32 = 131072;
pub const STAT_HAVE_NSEC: u32 = 1;
pub const S_IFMT: u32 = 61440;
pub const S_IFSOCK: u32 = 49152;
pub const S_IFLNK: u32 = 40960;
pub const S_IFREG: u32 = 32768;
pub const S_IFBLK: u32 = 24576;
pub const S_IFDIR: u32 = 16384;
pub const S_IFCHR: u32 = 8192;
pub const S_IFIFO: u32 = 4096;
pub const S_ISUID: u32 = 2048;
pub const S_ISGID: u32 = 1024;
pub const S_ISVTX: u32 = 512;
pub const S_IRWXU: u32 = 448;
pub const S_IRUSR: u32 = 256;
pub const S_IWUSR: u32 = 128;
pub const S_IXUSR: u32 = 64;
pub const S_IRWXG: u32 = 56;
pub const S_IRGRP: u32 = 32;
pub const S_IWGRP: u32 = 16;
pub const S_IXGRP: u32 = 8;
pub const S_IRWXO: u32 = 7;
pub const S_IROTH: u32 = 4;
pub const S_IWOTH: u32 = 2;
pub const S_IXOTH: u32 = 1;
pub const STATX_TYPE: u32 = 1;
pub const STATX_MODE: u32 = 2;
pub const STATX_NLINK: u32 = 4;
pub const STATX_UID: u32 = 8;
pub const STATX_GID: u32 = 16;
pub const STATX_ATIME: u32 = 32;
pub const STATX_MTIME: u32 = 64;
pub const STATX_CTIME: u32 = 128;
pub const STATX_INO: u32 = 256;
pub const STATX_SIZE: u32 = 512;
pub const STATX_BLOCKS: u32 = 1024;
pub const STATX_BASIC_STATS: u32 = 2047;
pub const STATX_BTIME: u32 = 2048;
pub const STATX_MNT_ID: u32 = 4096;
pub const STATX_DIOALIGN: u32 = 8192;
pub const STATX_MNT_ID_UNIQUE: u32 = 16384;
pub const STATX_SUBVOL: u32 = 32768;
pub const STATX_WRITE_ATOMIC: u32 = 65536;
pub const STATX_DIO_READ_ALIGN: u32 = 131072;
pub const STATX__RESERVED: u32 = 2147483648;
pub const STATX_ATTR_COMPRESSED: u32 = 4;
pub const STATX_ATTR_IMMUTABLE: u32 = 16;
pub const STATX_ATTR_APPEND: u32 = 32;
pub const STATX_ATTR_NODUMP: u32 = 64;
pub const STATX_ATTR_ENCRYPTED: u32 = 2048;
pub const STATX_ATTR_AUTOMOUNT: u32 = 4096;
pub const STATX_ATTR_MOUNT_ROOT: u32 = 8192;
pub const STATX_ATTR_VERITY: u32 = 1048576;
pub const STATX_ATTR_DAX: u32 = 2097152;
pub const STATX_ATTR_WRITE_ATOMIC: u32 = 4194304;
pub const S_IRWXUGO: u32 = 511;
pub const S_IALLUGO: u32 = 4095;
pub const S_IRUGO: u32 = 292;
pub const S_IWUGO: u32 = 146;
pub const S_IXUGO: u32 = 73;
pub const UTIME_NOW: u32 = 1073741823;
pub const UTIME_OMIT: u32 = 1073741822;
pub const KSTAT_ATTR_FS_IOC_FLAGS: u32 = 1050740;
pub const KSTAT_ATTR_VFS_FLAGS: u32 = 48;
pub const STATX_CHANGE_COOKIE: u32 = 1073741824;
pub const STATX_ATTR_CHANGE_MONOTONIC: i64 = -9223372036854775808;
pub const SYSFS_PREALLOC: u32 = 4096;
pub const SYSFS_GROUP_INVISIBLE: u32 = 8192;
pub const UEVENT_HELPER_PATH_LEN: u32 = 256;
pub const UEVENT_NUM_ENVP: u32 = 64;
pub const UEVENT_BUFFER_SIZE: u32 = 2048;
pub const SCHED_CPUFREQ_IOWAIT: u32 = 1;
pub const SDF_SHARED_CHILD: u32 = 1;
pub const SDF_SHARED_PARENT: u32 = 2;
pub const SDF_NEEDS_GROUPS: u32 = 4;
pub const EM_MAX_POWER: u32 = 64000000;
pub const EM_MAX_NUM_CPUS: u32 = 4096;
pub const PM_EVENT_INVALID: i32 = -1;
pub const PM_EVENT_ON: u32 = 0;
pub const PM_EVENT_FREEZE: u32 = 1;
pub const PM_EVENT_SUSPEND: u32 = 2;
pub const PM_EVENT_HIBERNATE: u32 = 4;
pub const PM_EVENT_QUIESCE: u32 = 8;
pub const PM_EVENT_RESUME: u32 = 16;
pub const PM_EVENT_THAW: u32 = 32;
pub const PM_EVENT_RESTORE: u32 = 64;
pub const PM_EVENT_RECOVER: u32 = 128;
pub const PM_EVENT_USER: u32 = 256;
pub const PM_EVENT_REMOTE: u32 = 512;
pub const PM_EVENT_AUTO: u32 = 1024;
pub const PM_EVENT_SLEEP: u32 = 6;
pub const PM_EVENT_USER_SUSPEND: u32 = 258;
pub const PM_EVENT_USER_RESUME: u32 = 272;
pub const PM_EVENT_REMOTE_RESUME: u32 = 528;
pub const PM_EVENT_AUTO_SUSPEND: u32 = 1026;
pub const PM_EVENT_AUTO_RESUME: u32 = 1040;
pub const PM_EVENT_PRETHAW: u32 = 8;
pub const BUILD_ID_SIZE_MAX: u32 = 20;
pub const CTL_MAXNAME: u32 = 10;
pub const UMH_NO_WAIT: u32 = 0;
pub const UMH_WAIT_EXEC: u32 = 1;
pub const UMH_WAIT_PROC: u32 = 2;
pub const UMH_KILLABLE: u32 = 4;
pub const UMH_FREEZABLE: u32 = 8;
pub const IPC_CREAT: u32 = 512;
pub const IPC_EXCL: u32 = 1024;
pub const IPC_NOWAIT: u32 = 2048;
pub const IPC_DIPC: u32 = 4096;
pub const IPC_OWN: u32 = 8192;
pub const IPC_RMID: u32 = 0;
pub const IPC_SET: u32 = 1;
pub const IPC_STAT: u32 = 2;
pub const IPC_INFO: u32 = 3;
pub const IPC_OLD: u32 = 0;
pub const IPC_64: u32 = 256;
pub const SEMOP: u32 = 1;
pub const SEMGET: u32 = 2;
pub const SEMCTL: u32 = 3;
pub const SEMTIMEDOP: u32 = 4;
pub const MSGSND: u32 = 11;
pub const MSGRCV: u32 = 12;
pub const MSGGET: u32 = 13;
pub const MSGCTL: u32 = 14;
pub const SHMAT: u32 = 21;
pub const SHMDT: u32 = 22;
pub const SHMGET: u32 = 23;
pub const SHMCTL: u32 = 24;
pub const DIPC: u32 = 25;
pub const SEM_UNDO: u32 = 4096;
pub const GETPID: u32 = 11;
pub const GETVAL: u32 = 12;
pub const GETALL: u32 = 13;
pub const GETNCNT: u32 = 14;
pub const GETZCNT: u32 = 15;
pub const SETVAL: u32 = 16;
pub const SETALL: u32 = 17;
pub const SEM_STAT: u32 = 18;
pub const SEM_INFO: u32 = 19;
pub const SEM_STAT_ANY: u32 = 20;
pub const SEMMNI: u32 = 32000;
pub const SEMMSL: u32 = 32000;
pub const SEMMNS: u32 = 1024000000;
pub const SEMOPM: u32 = 500;
pub const SEMVMX: u32 = 32767;
pub const SEMAEM: u32 = 32767;
pub const SEMUME: u32 = 500;
pub const SEMMNU: u32 = 1024000000;
pub const SEMMAP: u32 = 1024000000;
pub const SEMUSZ: u32 = 20;
pub const FIOSETOWN: u32 = 35073;
pub const SIOCSPGRP: u32 = 35074;
pub const FIOGETOWN: u32 = 35075;
pub const SIOCGPGRP: u32 = 35076;
pub const SIOCATMARK: u32 = 35077;
pub const SIOCGSTAMP_OLD: u32 = 35078;
pub const SIOCGSTAMPNS_OLD: u32 = 35079;
pub const SOL_SOCKET: u32 = 1;
pub const SO_DEBUG: u32 = 1;
pub const SO_REUSEADDR: u32 = 2;
pub const SO_TYPE: u32 = 3;
pub const SO_ERROR: u32 = 4;
pub const SO_DONTROUTE: u32 = 5;
pub const SO_BROADCAST: u32 = 6;
pub const SO_SNDBUF: u32 = 7;
pub const SO_RCVBUF: u32 = 8;
pub const SO_SNDBUFFORCE: u32 = 32;
pub const SO_RCVBUFFORCE: u32 = 33;
pub const SO_KEEPALIVE: u32 = 9;
pub const SO_OOBINLINE: u32 = 10;
pub const SO_NO_CHECK: u32 = 11;
pub const SO_PRIORITY: u32 = 12;
pub const SO_LINGER: u32 = 13;
pub const SO_BSDCOMPAT: u32 = 14;
pub const SO_REUSEPORT: u32 = 15;
pub const SO_PASSCRED: u32 = 16;
pub const SO_PEERCRED: u32 = 17;
pub const SO_RCVLOWAT: u32 = 18;
pub const SO_SNDLOWAT: u32 = 19;
pub const SO_RCVTIMEO_OLD: u32 = 20;
pub const SO_SNDTIMEO_OLD: u32 = 21;
pub const SO_SECURITY_AUTHENTICATION: u32 = 22;
pub const SO_SECURITY_ENCRYPTION_TRANSPORT: u32 = 23;
pub const SO_SECURITY_ENCRYPTION_NETWORK: u32 = 24;
pub const SO_BINDTODEVICE: u32 = 25;
pub const SO_ATTACH_FILTER: u32 = 26;
pub const SO_DETACH_FILTER: u32 = 27;
pub const SO_GET_FILTER: u32 = 26;
pub const SO_PEERNAME: u32 = 28;
pub const SO_ACCEPTCONN: u32 = 30;
pub const SO_PEERSEC: u32 = 31;
pub const SO_PASSSEC: u32 = 34;
pub const SO_MARK: u32 = 36;
pub const SO_PROTOCOL: u32 = 38;
pub const SO_DOMAIN: u32 = 39;
pub const SO_RXQ_OVFL: u32 = 40;
pub const SO_WIFI_STATUS: u32 = 41;
pub const SCM_WIFI_STATUS: u32 = 41;
pub const SO_PEEK_OFF: u32 = 42;
pub const SO_NOFCS: u32 = 43;
pub const SO_LOCK_FILTER: u32 = 44;
pub const SO_SELECT_ERR_QUEUE: u32 = 45;
pub const SO_BUSY_POLL: u32 = 46;
pub const SO_MAX_PACING_RATE: u32 = 47;
pub const SO_BPF_EXTENSIONS: u32 = 48;
pub const SO_INCOMING_CPU: u32 = 49;
pub const SO_ATTACH_BPF: u32 = 50;
pub const SO_DETACH_BPF: u32 = 27;
pub const SO_ATTACH_REUSEPORT_CBPF: u32 = 51;
pub const SO_ATTACH_REUSEPORT_EBPF: u32 = 52;
pub const SO_CNX_ADVICE: u32 = 53;
pub const SCM_TIMESTAMPING_OPT_STATS: u32 = 54;
pub const SO_MEMINFO: u32 = 55;
pub const SO_INCOMING_NAPI_ID: u32 = 56;
pub const SO_COOKIE: u32 = 57;
pub const SCM_TIMESTAMPING_PKTINFO: u32 = 58;
pub const SO_PEERGROUPS: u32 = 59;
pub const SO_ZEROCOPY: u32 = 60;
pub const SO_TXTIME: u32 = 61;
pub const SCM_TXTIME: u32 = 61;
pub const SO_BINDTOIFINDEX: u32 = 62;
pub const SO_TIMESTAMP_OLD: u32 = 29;
pub const SO_TIMESTAMPNS_OLD: u32 = 35;
pub const SO_TIMESTAMPING_OLD: u32 = 37;
pub const SO_TIMESTAMP_NEW: u32 = 63;
pub const SO_TIMESTAMPNS_NEW: u32 = 64;
pub const SO_TIMESTAMPING_NEW: u32 = 65;
pub const SO_RCVTIMEO_NEW: u32 = 66;
pub const SO_SNDTIMEO_NEW: u32 = 67;
pub const SO_DETACH_REUSEPORT_BPF: u32 = 68;
pub const SO_PREFER_BUSY_POLL: u32 = 69;
pub const SO_BUSY_POLL_BUDGET: u32 = 70;
pub const SO_NETNS_COOKIE: u32 = 71;
pub const SO_BUF_LOCK: u32 = 72;
pub const SO_RESERVE_MEM: u32 = 73;
pub const SO_TXREHASH: u32 = 74;
pub const SO_RCVMARK: u32 = 75;
pub const SO_PASSPIDFD: u32 = 76;
pub const SO_PEERPIDFD: u32 = 77;
pub const SO_DEVMEM_LINEAR: u32 = 78;
pub const SCM_DEVMEM_LINEAR: u32 = 78;
pub const SO_DEVMEM_DMABUF: u32 = 79;
pub const SCM_DEVMEM_DMABUF: u32 = 79;
pub const SO_DEVMEM_DONTNEED: u32 = 80;
pub const SCM_TS_OPT_ID: u32 = 81;
pub const SO_RCVPRIORITY: u32 = 82;
pub const SO_PASSRIGHTS: u32 = 83;
pub const SO_INQ: u32 = 84;
pub const SCM_INQ: u32 = 84;
pub const SOCK_IOC_TYPE: u32 = 137;
pub const SIOCGSTAMP: u32 = 35078;
pub const SIOCGSTAMPNS: u32 = 35079;
pub const SIOCADDRT: u32 = 35083;
pub const SIOCDELRT: u32 = 35084;
pub const SIOCRTMSG: u32 = 35085;
pub const SIOCGIFNAME: u32 = 35088;
pub const SIOCSIFLINK: u32 = 35089;
pub const SIOCGIFCONF: u32 = 35090;
pub const SIOCGIFFLAGS: u32 = 35091;
pub const SIOCSIFFLAGS: u32 = 35092;
pub const SIOCGIFADDR: u32 = 35093;
pub const SIOCSIFADDR: u32 = 35094;
pub const SIOCGIFDSTADDR: u32 = 35095;
pub const SIOCSIFDSTADDR: u32 = 35096;
pub const SIOCGIFBRDADDR: u32 = 35097;
pub const SIOCSIFBRDADDR: u32 = 35098;
pub const SIOCGIFNETMASK: u32 = 35099;
pub const SIOCSIFNETMASK: u32 = 35100;
pub const SIOCGIFMETRIC: u32 = 35101;
pub const SIOCSIFMETRIC: u32 = 35102;
pub const SIOCGIFMEM: u32 = 35103;
pub const SIOCSIFMEM: u32 = 35104;
pub const SIOCGIFMTU: u32 = 35105;
pub const SIOCSIFMTU: u32 = 35106;
pub const SIOCSIFNAME: u32 = 35107;
pub const SIOCSIFHWADDR: u32 = 35108;
pub const SIOCGIFENCAP: u32 = 35109;
pub const SIOCSIFENCAP: u32 = 35110;
pub const SIOCGIFHWADDR: u32 = 35111;
pub const SIOCGIFSLAVE: u32 = 35113;
pub const SIOCSIFSLAVE: u32 = 35120;
pub const SIOCADDMULTI: u32 = 35121;
pub const SIOCDELMULTI: u32 = 35122;
pub const SIOCGIFINDEX: u32 = 35123;
pub const SIOGIFINDEX: u32 = 35123;
pub const SIOCSIFPFLAGS: u32 = 35124;
pub const SIOCGIFPFLAGS: u32 = 35125;
pub const SIOCDIFADDR: u32 = 35126;
pub const SIOCSIFHWBROADCAST: u32 = 35127;
pub const SIOCGIFCOUNT: u32 = 35128;
pub const SIOCGIFBR: u32 = 35136;
pub const SIOCSIFBR: u32 = 35137;
pub const SIOCGIFTXQLEN: u32 = 35138;
pub const SIOCSIFTXQLEN: u32 = 35139;
pub const SIOCETHTOOL: u32 = 35142;
pub const SIOCGMIIPHY: u32 = 35143;
pub const SIOCGMIIREG: u32 = 35144;
pub const SIOCSMIIREG: u32 = 35145;
pub const SIOCWANDEV: u32 = 35146;
pub const SIOCOUTQNSD: u32 = 35147;
pub const SIOCGSKNS: u32 = 35148;
pub const SIOCDARP: u32 = 35155;
pub const SIOCGARP: u32 = 35156;
pub const SIOCSARP: u32 = 35157;
pub const SIOCDRARP: u32 = 35168;
pub const SIOCGRARP: u32 = 35169;
pub const SIOCSRARP: u32 = 35170;
pub const SIOCGIFMAP: u32 = 35184;
pub const SIOCSIFMAP: u32 = 35185;
pub const SIOCADDDLCI: u32 = 35200;
pub const SIOCDELDLCI: u32 = 35201;
pub const SIOCGIFVLAN: u32 = 35202;
pub const SIOCSIFVLAN: u32 = 35203;
pub const SIOCBONDENSLAVE: u32 = 35216;
pub const SIOCBONDRELEASE: u32 = 35217;
pub const SIOCBONDSETHWADDR: u32 = 35218;
pub const SIOCBONDSLAVEINFOQUERY: u32 = 35219;
pub const SIOCBONDINFOQUERY: u32 = 35220;
pub const SIOCBONDCHANGEACTIVE: u32 = 35221;
pub const SIOCBRADDBR: u32 = 35232;
pub const SIOCBRDELBR: u32 = 35233;
pub const SIOCBRADDIF: u32 = 35234;
pub const SIOCBRDELIF: u32 = 35235;
pub const SIOCSHWTSTAMP: u32 = 35248;
pub const SIOCGHWTSTAMP: u32 = 35249;
pub const SIOCDEVPRIVATE: u32 = 35312;
pub const SIOCPROTOPRIVATE: u32 = 35296;
pub const UIO_FASTIOV: u32 = 8;
pub const UIO_MAXIOV: u32 = 1024;
pub const ITER_SOURCE: u32 = 1;
pub const ITER_DEST: u32 = 0;
pub const _K_SS_MAXSIZE: u32 = 128;
pub const SOCK_SNDBUF_LOCK: u32 = 1;
pub const SOCK_RCVBUF_LOCK: u32 = 2;
pub const SOCK_BUF_LOCK_MASK: u32 = 3;
pub const SOCK_TXREHASH_DEFAULT: u32 = 255;
pub const SOCK_TXREHASH_DISABLED: u32 = 0;
pub const SOCK_TXREHASH_ENABLED: u32 = 1;
pub const SCM_RIGHTS: u32 = 1;
pub const SCM_CREDENTIALS: u32 = 2;
pub const SCM_SECURITY: u32 = 3;
pub const SCM_PIDFD: u32 = 4;
pub const AF_UNSPEC: u32 = 0;
pub const AF_UNIX: u32 = 1;
pub const AF_LOCAL: u32 = 1;
pub const AF_INET: u32 = 2;
pub const AF_AX25: u32 = 3;
pub const AF_IPX: u32 = 4;
pub const AF_APPLETALK: u32 = 5;
pub const AF_NETROM: u32 = 6;
pub const AF_BRIDGE: u32 = 7;
pub const AF_ATMPVC: u32 = 8;
pub const AF_X25: u32 = 9;
pub const AF_INET6: u32 = 10;
pub const AF_ROSE: u32 = 11;
pub const AF_DECnet: u32 = 12;
pub const AF_NETBEUI: u32 = 13;
pub const AF_SECURITY: u32 = 14;
pub const AF_KEY: u32 = 15;
pub const AF_NETLINK: u32 = 16;
pub const AF_ROUTE: u32 = 16;
pub const AF_PACKET: u32 = 17;
pub const AF_ASH: u32 = 18;
pub const AF_ECONET: u32 = 19;
pub const AF_ATMSVC: u32 = 20;
pub const AF_RDS: u32 = 21;
pub const AF_SNA: u32 = 22;
pub const AF_IRDA: u32 = 23;
pub const AF_PPPOX: u32 = 24;
pub const AF_WANPIPE: u32 = 25;
pub const AF_LLC: u32 = 26;
pub const AF_IB: u32 = 27;
pub const AF_MPLS: u32 = 28;
pub const AF_CAN: u32 = 29;
pub const AF_TIPC: u32 = 30;
pub const AF_BLUETOOTH: u32 = 31;
pub const AF_IUCV: u32 = 32;
pub const AF_RXRPC: u32 = 33;
pub const AF_ISDN: u32 = 34;
pub const AF_PHONET: u32 = 35;
pub const AF_IEEE802154: u32 = 36;
pub const AF_CAIF: u32 = 37;
pub const AF_ALG: u32 = 38;
pub const AF_NFC: u32 = 39;
pub const AF_VSOCK: u32 = 40;
pub const AF_KCM: u32 = 41;
pub const AF_QIPCRTR: u32 = 42;
pub const AF_SMC: u32 = 43;
pub const AF_XDP: u32 = 44;
pub const AF_MCTP: u32 = 45;
pub const AF_MAX: u32 = 46;
pub const PF_UNSPEC: u32 = 0;
pub const PF_UNIX: u32 = 1;
pub const PF_LOCAL: u32 = 1;
pub const PF_INET: u32 = 2;
pub const PF_AX25: u32 = 3;
pub const PF_IPX: u32 = 4;
pub const PF_APPLETALK: u32 = 5;
pub const PF_NETROM: u32 = 6;
pub const PF_BRIDGE: u32 = 7;
pub const PF_ATMPVC: u32 = 8;
pub const PF_X25: u32 = 9;
pub const PF_INET6: u32 = 10;
pub const PF_ROSE: u32 = 11;
pub const PF_DECnet: u32 = 12;
pub const PF_NETBEUI: u32 = 13;
pub const PF_SECURITY: u32 = 14;
pub const PF_KEY: u32 = 15;
pub const PF_NETLINK: u32 = 16;
pub const PF_ROUTE: u32 = 16;
pub const PF_PACKET: u32 = 17;
pub const PF_ASH: u32 = 18;
pub const PF_ECONET: u32 = 19;
pub const PF_ATMSVC: u32 = 20;
pub const PF_RDS: u32 = 21;
pub const PF_SNA: u32 = 22;
pub const PF_IRDA: u32 = 23;
pub const PF_PPPOX: u32 = 24;
pub const PF_WANPIPE: u32 = 25;
pub const PF_LLC: u32 = 26;
pub const PF_IB: u32 = 27;
pub const PF_MPLS: u32 = 28;
pub const PF_CAN: u32 = 29;
pub const PF_TIPC: u32 = 30;
pub const PF_BLUETOOTH: u32 = 31;
pub const PF_IUCV: u32 = 32;
pub const PF_RXRPC: u32 = 33;
pub const PF_ISDN: u32 = 34;
pub const PF_PHONET: u32 = 35;
pub const PF_IEEE802154: u32 = 36;
pub const PF_CAIF: u32 = 37;
pub const PF_ALG: u32 = 38;
pub const PF_NFC: u32 = 39;
pub const PF_VSOCK: u32 = 40;
pub const PF_KCM: u32 = 41;
pub const PF_QIPCRTR: u32 = 42;
pub const PF_SMC: u32 = 43;
pub const PF_XDP: u32 = 44;
pub const PF_MCTP: u32 = 45;
pub const PF_MAX: u32 = 46;
pub const SOMAXCONN: u32 = 4096;
pub const MSG_OOB: u32 = 1;
pub const MSG_PEEK: u32 = 2;
pub const MSG_DONTROUTE: u32 = 4;
pub const MSG_TRYHARD: u32 = 4;
pub const MSG_CTRUNC: u32 = 8;
pub const MSG_PROBE: u32 = 16;
pub const MSG_TRUNC: u32 = 32;
pub const MSG_DONTWAIT: u32 = 64;
pub const MSG_EOR: u32 = 128;
pub const MSG_WAITALL: u32 = 256;
pub const MSG_FIN: u32 = 512;
pub const MSG_SYN: u32 = 1024;
pub const MSG_CONFIRM: u32 = 2048;
pub const MSG_RST: u32 = 4096;
pub const MSG_ERRQUEUE: u32 = 8192;
pub const MSG_NOSIGNAL: u32 = 16384;
pub const MSG_MORE: u32 = 32768;
pub const MSG_WAITFORONE: u32 = 65536;
pub const MSG_SENDPAGE_NOPOLICY: u32 = 65536;
pub const MSG_BATCH: u32 = 262144;
pub const MSG_EOF: u32 = 512;
pub const MSG_NO_SHARED_FRAGS: u32 = 524288;
pub const MSG_SENDPAGE_DECRYPTED: u32 = 1048576;
pub const MSG_SOCK_DEVMEM: u32 = 33554432;
pub const MSG_ZEROCOPY: u32 = 67108864;
pub const MSG_SPLICE_PAGES: u32 = 134217728;
pub const MSG_FASTOPEN: u32 = 536870912;
pub const MSG_CMSG_CLOEXEC: u32 = 1073741824;
pub const MSG_CMSG_COMPAT: u32 = 2147483648;
pub const MSG_INTERNAL_SENDMSG_FLAGS: u32 = 135331840;
pub const SOL_IP: u32 = 0;
pub const SOL_TCP: u32 = 6;
pub const SOL_UDP: u32 = 17;
pub const SOL_IPV6: u32 = 41;
pub const SOL_ICMPV6: u32 = 58;
pub const SOL_SCTP: u32 = 132;
pub const SOL_UDPLITE: u32 = 136;
pub const SOL_RAW: u32 = 255;
pub const SOL_IPX: u32 = 256;
pub const SOL_AX25: u32 = 257;
pub const SOL_ATALK: u32 = 258;
pub const SOL_NETROM: u32 = 259;
pub const SOL_ROSE: u32 = 260;
pub const SOL_DECNET: u32 = 261;
pub const SOL_X25: u32 = 262;
pub const SOL_PACKET: u32 = 263;
pub const SOL_ATM: u32 = 264;
pub const SOL_AAL: u32 = 265;
pub const SOL_IRDA: u32 = 266;
pub const SOL_NETBEUI: u32 = 267;
pub const SOL_LLC: u32 = 268;
pub const SOL_DCCP: u32 = 269;
pub const SOL_NETLINK: u32 = 270;
pub const SOL_TIPC: u32 = 271;
pub const SOL_RXRPC: u32 = 272;
pub const SOL_PPPOL2TP: u32 = 273;
pub const SOL_BLUETOOTH: u32 = 274;
pub const SOL_PNPIPE: u32 = 275;
pub const SOL_RDS: u32 = 276;
pub const SOL_IUCV: u32 = 277;
pub const SOL_CAIF: u32 = 278;
pub const SOL_ALG: u32 = 279;
pub const SOL_NFC: u32 = 280;
pub const SOL_KCM: u32 = 281;
pub const SOL_TLS: u32 = 282;
pub const SOL_XDP: u32 = 283;
pub const SOL_MPTCP: u32 = 284;
pub const SOL_MCTP: u32 = 285;
pub const SOL_SMC: u32 = 286;
pub const SOL_VSOCK: u32 = 287;
pub const IPX_TYPE: u32 = 1;
pub const __UAPI_DEF_IF_IFCONF: u32 = 1;
pub const __UAPI_DEF_IF_IFMAP: u32 = 1;
pub const __UAPI_DEF_IF_IFNAMSIZ: u32 = 1;
pub const __UAPI_DEF_IF_IFREQ: u32 = 1;
pub const __UAPI_DEF_IF_NET_DEVICE_FLAGS: u32 = 1;
pub const __UAPI_DEF_IF_NET_DEVICE_FLAGS_LOWER_UP_DORMANT_ECHO: u32 = 1;
pub const __UAPI_DEF_IN_ADDR: u32 = 1;
pub const __UAPI_DEF_IN_IPPROTO: u32 = 1;
pub const __UAPI_DEF_IN_PKTINFO: u32 = 1;
pub const __UAPI_DEF_IP_MREQ: u32 = 1;
pub const __UAPI_DEF_SOCKADDR_IN: u32 = 1;
pub const __UAPI_DEF_IN_CLASS: u32 = 1;
pub const __UAPI_DEF_IN6_ADDR: u32 = 1;
pub const __UAPI_DEF_IN6_ADDR_ALT: u32 = 1;
pub const __UAPI_DEF_SOCKADDR_IN6: u32 = 1;
pub const __UAPI_DEF_IPV6_MREQ: u32 = 1;
pub const __UAPI_DEF_IPPROTO_V6: u32 = 1;
pub const __UAPI_DEF_IPV6_OPTIONS: u32 = 1;
pub const __UAPI_DEF_IN6_PKTINFO: u32 = 1;
pub const __UAPI_DEF_IP6_MTUINFO: u32 = 1;
pub const __UAPI_DEF_XATTR: u32 = 1;
pub const IFNAMSIZ: u32 = 16;
pub const IFALIASZ: u32 = 256;
pub const ALTIFNAMSIZ: u32 = 128;
pub const GENERIC_HDLC_VERSION: u32 = 4;
pub const CLOCK_DEFAULT: u32 = 0;
pub const CLOCK_EXT: u32 = 1;
pub const CLOCK_INT: u32 = 2;
pub const CLOCK_TXINT: u32 = 3;
pub const CLOCK_TXFROMRX: u32 = 4;
pub const ENCODING_DEFAULT: u32 = 0;
pub const ENCODING_NRZ: u32 = 1;
pub const ENCODING_NRZI: u32 = 2;
pub const ENCODING_FM_MARK: u32 = 3;
pub const ENCODING_FM_SPACE: u32 = 4;
pub const ENCODING_MANCHESTER: u32 = 5;
pub const PARITY_DEFAULT: u32 = 0;
pub const PARITY_NONE: u32 = 1;
pub const PARITY_CRC16_PR0: u32 = 2;
pub const PARITY_CRC16_PR1: u32 = 3;
pub const PARITY_CRC16_PR0_CCITT: u32 = 4;
pub const PARITY_CRC16_PR1_CCITT: u32 = 5;
pub const PARITY_CRC32_PR0_CCITT: u32 = 6;
pub const PARITY_CRC32_PR1_CCITT: u32 = 7;
pub const LMI_DEFAULT: u32 = 0;
pub const LMI_NONE: u32 = 1;
pub const LMI_ANSI: u32 = 2;
pub const LMI_CCITT: u32 = 3;
pub const LMI_CISCO: u32 = 4;
pub const IF_GET_IFACE: u32 = 1;
pub const IF_GET_PROTO: u32 = 2;
pub const IF_IFACE_V35: u32 = 4096;
pub const IF_IFACE_V24: u32 = 4097;
pub const IF_IFACE_X21: u32 = 4098;
pub const IF_IFACE_T1: u32 = 4099;
pub const IF_IFACE_E1: u32 = 4100;
pub const IF_IFACE_SYNC_SERIAL: u32 = 4101;
pub const IF_IFACE_X21D: u32 = 4102;
pub const IF_PROTO_HDLC: u32 = 8192;
pub const IF_PROTO_PPP: u32 = 8193;
pub const IF_PROTO_CISCO: u32 = 8194;
pub const IF_PROTO_FR: u32 = 8195;
pub const IF_PROTO_FR_ADD_PVC: u32 = 8196;
pub const IF_PROTO_FR_DEL_PVC: u32 = 8197;
pub const IF_PROTO_X25: u32 = 8198;
pub const IF_PROTO_HDLC_ETH: u32 = 8199;
pub const IF_PROTO_FR_ADD_ETH_PVC: u32 = 8200;
pub const IF_PROTO_FR_DEL_ETH_PVC: u32 = 8201;
pub const IF_PROTO_FR_PVC: u32 = 8202;
pub const IF_PROTO_FR_ETH_PVC: u32 = 8203;
pub const IF_PROTO_RAW: u32 = 8204;
pub const IFHWADDRLEN: u32 = 6;
pub const LINUX_VFS_DEBUG_H: u32 = 1;
pub const MINORBITS: u32 = 20;
pub const MINORMASK: u32 = 1048575;
pub const LIST_BL_LOCKMASK: u32 = 1;
pub const DNAME_INLINE_WORDS: u32 = 5;
pub const SHRINKER_UNIT_BITS: u32 = 64;
pub const SHRINK_STOP: i32 = -1;
pub const SHRINK_EMPTY: i32 = -2;
pub const DEFAULT_SEEKS: u32 = 2;
pub const RESERVED_PIDS: u32 = 300;
pub const _LINUX_CAPABILITY_VERSION_1: u32 = 429392688;
pub const _LINUX_CAPABILITY_U32S_1: u32 = 1;
pub const _LINUX_CAPABILITY_VERSION_2: u32 = 537333798;
pub const _LINUX_CAPABILITY_U32S_2: u32 = 2;
pub const _LINUX_CAPABILITY_VERSION_3: u32 = 537396514;
pub const _LINUX_CAPABILITY_U32S_3: u32 = 2;
pub const VFS_CAP_REVISION_MASK: u32 = 4278190080;
pub const VFS_CAP_REVISION_SHIFT: u32 = 24;
pub const VFS_CAP_FLAGS_MASK: i64 = -4278190081;
pub const VFS_CAP_FLAGS_EFFECTIVE: u32 = 1;
pub const VFS_CAP_REVISION_1: u32 = 16777216;
pub const VFS_CAP_U32_1: u32 = 1;
pub const VFS_CAP_REVISION_2: u32 = 33554432;
pub const VFS_CAP_U32_2: u32 = 2;
pub const VFS_CAP_REVISION_3: u32 = 50331648;
pub const VFS_CAP_U32_3: u32 = 2;
pub const VFS_CAP_U32: u32 = 2;
pub const VFS_CAP_REVISION: u32 = 50331648;
pub const CAP_CHOWN: u32 = 0;
pub const CAP_DAC_OVERRIDE: u32 = 1;
pub const CAP_DAC_READ_SEARCH: u32 = 2;
pub const CAP_FOWNER: u32 = 3;
pub const CAP_FSETID: u32 = 4;
pub const CAP_KILL: u32 = 5;
pub const CAP_SETGID: u32 = 6;
pub const CAP_SETUID: u32 = 7;
pub const CAP_SETPCAP: u32 = 8;
pub const CAP_LINUX_IMMUTABLE: u32 = 9;
pub const CAP_NET_BIND_SERVICE: u32 = 10;
pub const CAP_NET_BROADCAST: u32 = 11;
pub const CAP_NET_ADMIN: u32 = 12;
pub const CAP_NET_RAW: u32 = 13;
pub const CAP_IPC_LOCK: u32 = 14;
pub const CAP_IPC_OWNER: u32 = 15;
pub const CAP_SYS_MODULE: u32 = 16;
pub const CAP_SYS_RAWIO: u32 = 17;
pub const CAP_SYS_CHROOT: u32 = 18;
pub const CAP_SYS_PTRACE: u32 = 19;
pub const CAP_SYS_PACCT: u32 = 20;
pub const CAP_SYS_ADMIN: u32 = 21;
pub const CAP_SYS_BOOT: u32 = 22;
pub const CAP_SYS_NICE: u32 = 23;
pub const CAP_SYS_RESOURCE: u32 = 24;
pub const CAP_SYS_TIME: u32 = 25;
pub const CAP_SYS_TTY_CONFIG: u32 = 26;
pub const CAP_MKNOD: u32 = 27;
pub const CAP_LEASE: u32 = 28;
pub const CAP_AUDIT_WRITE: u32 = 29;
pub const CAP_AUDIT_CONTROL: u32 = 30;
pub const CAP_SETFCAP: u32 = 31;
pub const CAP_MAC_OVERRIDE: u32 = 32;
pub const CAP_MAC_ADMIN: u32 = 33;
pub const CAP_SYSLOG: u32 = 34;
pub const CAP_WAKE_ALARM: u32 = 35;
pub const CAP_BLOCK_SUSPEND: u32 = 36;
pub const CAP_AUDIT_READ: u32 = 37;
pub const CAP_PERFMON: u32 = 38;
pub const CAP_BPF: u32 = 39;
pub const CAP_CHECKPOINT_RESTORE: u32 = 40;
pub const CAP_LAST_CAP: u32 = 40;
pub const _KERNEL_CAPABILITY_VERSION: u32 = 537396514;
pub const O_ACCMODE: u32 = 3;
pub const O_RDONLY: u32 = 0;
pub const O_WRONLY: u32 = 1;
pub const O_RDWR: u32 = 2;
pub const O_CREAT: u32 = 64;
pub const O_EXCL: u32 = 128;
pub const O_NOCTTY: u32 = 256;
pub const O_TRUNC: u32 = 512;
pub const O_APPEND: u32 = 1024;
pub const O_NONBLOCK: u32 = 2048;
pub const O_DSYNC: u32 = 4096;
pub const FASYNC: u32 = 8192;
pub const O_DIRECT: u32 = 16384;
pub const O_LARGEFILE: u32 = 32768;
pub const O_DIRECTORY: u32 = 65536;
pub const O_NOFOLLOW: u32 = 131072;
pub const O_NOATIME: u32 = 262144;
pub const O_CLOEXEC: u32 = 524288;
pub const __O_SYNC: u32 = 1048576;
pub const O_SYNC: u32 = 1052672;
pub const O_PATH: u32 = 2097152;
pub const __O_TMPFILE: u32 = 4194304;
pub const O_TMPFILE: u32 = 4259840;
pub const O_NDELAY: u32 = 2048;
pub const F_DUPFD: u32 = 0;
pub const F_GETFD: u32 = 1;
pub const F_SETFD: u32 = 2;
pub const F_GETFL: u32 = 3;
pub const F_SETFL: u32 = 4;
pub const F_GETLK: u32 = 5;
pub const F_SETLK: u32 = 6;
pub const F_SETLKW: u32 = 7;
pub const F_SETOWN: u32 = 8;
pub const F_GETOWN: u32 = 9;
pub const F_SETSIG: u32 = 10;
pub const F_GETSIG: u32 = 11;
pub const F_GETLK64: u32 = 12;
pub const F_SETLK64: u32 = 13;
pub const F_SETLKW64: u32 = 14;
pub const F_SETOWN_EX: u32 = 15;
pub const F_GETOWN_EX: u32 = 16;
pub const F_GETOWNER_UIDS: u32 = 17;
pub const F_OFD_GETLK: u32 = 36;
pub const F_OFD_SETLK: u32 = 37;
pub const F_OFD_SETLKW: u32 = 38;
pub const F_OWNER_TID: u32 = 0;
pub const F_OWNER_PID: u32 = 1;
pub const F_OWNER_PGRP: u32 = 2;
pub const FD_CLOEXEC: u32 = 1;
pub const F_RDLCK: u32 = 0;
pub const F_WRLCK: u32 = 1;
pub const F_UNLCK: u32 = 2;
pub const F_EXLCK: u32 = 4;
pub const F_SHLCK: u32 = 8;
pub const LOCK_SH: u32 = 1;
pub const LOCK_EX: u32 = 2;
pub const LOCK_NB: u32 = 4;
pub const LOCK_UN: u32 = 8;
pub const LOCK_MAND: u32 = 32;
pub const LOCK_READ: u32 = 64;
pub const LOCK_WRITE: u32 = 128;
pub const LOCK_RW: u32 = 192;
pub const F_LINUX_SPECIFIC_BASE: u32 = 1024;
pub const RESOLVE_NO_XDEV: u32 = 1;
pub const RESOLVE_NO_MAGICLINKS: u32 = 2;
pub const RESOLVE_NO_SYMLINKS: u32 = 4;
pub const RESOLVE_BENEATH: u32 = 8;
pub const RESOLVE_IN_ROOT: u32 = 16;
pub const RESOLVE_CACHED: u32 = 32;
pub const F_SETLEASE: u32 = 1024;
pub const F_GETLEASE: u32 = 1025;
pub const F_NOTIFY: u32 = 1026;
pub const F_DUPFD_QUERY: u32 = 1027;
pub const F_CREATED_QUERY: u32 = 1028;
pub const F_CANCELLK: u32 = 1029;
pub const F_DUPFD_CLOEXEC: u32 = 1030;
pub const F_SETPIPE_SZ: u32 = 1031;
pub const F_GETPIPE_SZ: u32 = 1032;
pub const F_ADD_SEALS: u32 = 1033;
pub const F_GET_SEALS: u32 = 1034;
pub const F_SEAL_SEAL: u32 = 1;
pub const F_SEAL_SHRINK: u32 = 2;
pub const F_SEAL_GROW: u32 = 4;
pub const F_SEAL_WRITE: u32 = 8;
pub const F_SEAL_FUTURE_WRITE: u32 = 16;
pub const F_SEAL_EXEC: u32 = 32;
pub const F_GET_RW_HINT: u32 = 1035;
pub const F_SET_RW_HINT: u32 = 1036;
pub const F_GET_FILE_RW_HINT: u32 = 1037;
pub const F_SET_FILE_RW_HINT: u32 = 1038;
pub const RWH_WRITE_LIFE_NOT_SET: u32 = 0;
pub const RWH_WRITE_LIFE_NONE: u32 = 1;
pub const RWH_WRITE_LIFE_SHORT: u32 = 2;
pub const RWH_WRITE_LIFE_MEDIUM: u32 = 3;
pub const RWH_WRITE_LIFE_LONG: u32 = 4;
pub const RWH_WRITE_LIFE_EXTREME: u32 = 5;
pub const RWF_WRITE_LIFE_NOT_SET: u32 = 0;
pub const DN_ACCESS: u32 = 1;
pub const DN_MODIFY: u32 = 2;
pub const DN_CREATE: u32 = 4;
pub const DN_DELETE: u32 = 8;
pub const DN_RENAME: u32 = 16;
pub const DN_ATTRIB: u32 = 32;
pub const DN_MULTISHOT: u32 = 2147483648;
pub const AT_FDCWD: i32 = -100;
pub const PIDFD_SELF_THREAD: i32 = -10000;
pub const PIDFD_SELF_THREAD_GROUP: i32 = -10001;
pub const FD_PIDFS_ROOT: i32 = -10002;
pub const FD_NSFS_ROOT: i32 = -10003;
pub const FD_INVALID: i32 = -10009;
pub const AT_SYMLINK_NOFOLLOW: u32 = 256;
pub const AT_SYMLINK_FOLLOW: u32 = 1024;
pub const AT_NO_AUTOMOUNT: u32 = 2048;
pub const AT_EMPTY_PATH: u32 = 4096;
pub const AT_STATX_SYNC_TYPE: u32 = 24576;
pub const AT_STATX_SYNC_AS_STAT: u32 = 0;
pub const AT_STATX_FORCE_SYNC: u32 = 8192;
pub const AT_STATX_DONT_SYNC: u32 = 16384;
pub const AT_RECURSIVE: u32 = 32768;
pub const AT_RENAME_NOREPLACE: u32 = 1;
pub const AT_RENAME_EXCHANGE: u32 = 2;
pub const AT_RENAME_WHITEOUT: u32 = 4;
pub const AT_EACCESS: u32 = 512;
pub const AT_REMOVEDIR: u32 = 512;
pub const AT_HANDLE_FID: u32 = 512;
pub const AT_HANDLE_MNT_ID_UNIQUE: u32 = 1;
pub const AT_HANDLE_CONNECTABLE: u32 = 2;
pub const AT_EXECVE_CHECK: u32 = 65536;
pub const VALID_OPEN_FLAGS: u32 = 8388547;
pub const VALID_RESOLVE_FLAGS: u32 = 63;
pub const OPEN_HOW_SIZE_VER0: u32 = 24;
pub const OPEN_HOW_SIZE_LATEST: u32 = 24;
pub const SIGEMT_MASK: u32 = 0;
pub const JOBCTL_STOP_SIGMASK: u32 = 65535;
pub const JOBCTL_STOP_DEQUEUED_BIT: u32 = 16;
pub const JOBCTL_STOP_PENDING_BIT: u32 = 17;
pub const JOBCTL_STOP_CONSUME_BIT: u32 = 18;
pub const JOBCTL_TRAP_STOP_BIT: u32 = 19;
pub const JOBCTL_TRAP_NOTIFY_BIT: u32 = 20;
pub const JOBCTL_TRAPPING_BIT: u32 = 21;
pub const JOBCTL_LISTENING_BIT: u32 = 22;
pub const JOBCTL_TRAP_FREEZE_BIT: u32 = 23;
pub const JOBCTL_PTRACE_FROZEN_BIT: u32 = 24;
pub const JOBCTL_STOPPED_BIT: u32 = 26;
pub const JOBCTL_TRACED_BIT: u32 = 27;
pub const JOBCTL_STOP_DEQUEUED: u32 = 65536;
pub const JOBCTL_STOP_PENDING: u32 = 131072;
pub const JOBCTL_STOP_CONSUME: u32 = 262144;
pub const JOBCTL_TRAP_STOP: u32 = 524288;
pub const JOBCTL_TRAP_NOTIFY: u32 = 1048576;
pub const JOBCTL_TRAPPING: u32 = 2097152;
pub const JOBCTL_LISTENING: u32 = 4194304;
pub const JOBCTL_TRAP_FREEZE: u32 = 8388608;
pub const JOBCTL_PTRACE_FROZEN: u32 = 16777216;
pub const JOBCTL_STOPPED: u32 = 67108864;
pub const JOBCTL_TRACED: u32 = 134217728;
pub const JOBCTL_TRAP_MASK: u32 = 1572864;
pub const JOBCTL_PENDING_MASK: u32 = 1703936;
pub const MMU_NOTIFIER_RANGE_BLOCKABLE: u32 = 1;
pub const INVPCID_TYPE_INDIV_ADDR: u32 = 0;
pub const INVPCID_TYPE_SINGLE_CTXT: u32 = 1;
pub const INVPCID_TYPE_ALL_INCL_GLOBAL: u32 = 2;
pub const INVPCID_TYPE_ALL_NON_GLOBAL: u32 = 3;
pub const PKRU_AD_BIT: u32 = 1;
pub const PKRU_WD_BIT: u32 = 2;
pub const PKRU_BITS_PER_PKEY: u32 = 2;
pub const PFN_PTE_SHIFT: u32 = 12;
pub const FIXMAP_PMD_NUM: u32 = 2;
pub const FIXMAP_PMD_TOP: u32 = 507;
pub const VSYSCALL_ADDR: i32 = -10485760;
pub const NR_FIX_BTMAPS: u32 = 64;
pub const FIX_BTMAPS_SLOTS: u32 = 8;
pub const TOTAL_FIX_BTMAPS: u32 = 512;
pub const SWP_TYPE_BITS: u32 = 5;
pub const SWP_OFFSET_FIRST_BIT: u32 = 9;
pub const SWP_OFFSET_SHIFT: u32 = 14;
pub const HAVE_PAGE_AGP: u32 = 1;
pub const _ASM_PGTABLE_INVERT_H: u32 = 1;
pub const PTI_PGTABLE_SWITCH_BIT: u32 = 12;
pub const __HAVE_ARCH_PFN_MODIFY_ALLOWED: u32 = 1;
pub const TLB_FLUSH_ALL: i32 = -1;
pub const TLB_GENERATION_INVALID: u32 = 0;
pub const ARCH_HAS_NOCACHE_UACCESS: u32 = 1;
pub const CLONE_LEGACY_FLAGS: u32 = 4294967295;
pub const ASSOC_ARRAY_KEY_CHUNK_SIZE: u32 = 64;
pub const KEY_POS_VIEW: u32 = 16777216;
pub const KEY_POS_READ: u32 = 33554432;
pub const KEY_POS_WRITE: u32 = 67108864;
pub const KEY_POS_SEARCH: u32 = 134217728;
pub const KEY_POS_LINK: u32 = 268435456;
pub const KEY_POS_SETATTR: u32 = 536870912;
pub const KEY_POS_ALL: u32 = 1056964608;
pub const KEY_USR_VIEW: u32 = 65536;
pub const KEY_USR_READ: u32 = 131072;
pub const KEY_USR_WRITE: u32 = 262144;
pub const KEY_USR_SEARCH: u32 = 524288;
pub const KEY_USR_LINK: u32 = 1048576;
pub const KEY_USR_SETATTR: u32 = 2097152;
pub const KEY_USR_ALL: u32 = 4128768;
pub const KEY_GRP_VIEW: u32 = 256;
pub const KEY_GRP_READ: u32 = 512;
pub const KEY_GRP_WRITE: u32 = 1024;
pub const KEY_GRP_SEARCH: u32 = 2048;
pub const KEY_GRP_LINK: u32 = 4096;
pub const KEY_GRP_SETATTR: u32 = 8192;
pub const KEY_GRP_ALL: u32 = 16128;
pub const KEY_OTH_VIEW: u32 = 1;
pub const KEY_OTH_READ: u32 = 2;
pub const KEY_OTH_WRITE: u32 = 4;
pub const KEY_OTH_SEARCH: u32 = 8;
pub const KEY_OTH_LINK: u32 = 16;
pub const KEY_OTH_SETATTR: u32 = 32;
pub const KEY_OTH_ALL: u32 = 63;
pub const KEY_PERM_UNDEF: u32 = 4294967295;
pub const KEY_FLAG_DEAD: u32 = 0;
pub const KEY_FLAG_REVOKED: u32 = 1;
pub const KEY_FLAG_IN_QUOTA: u32 = 2;
pub const KEY_FLAG_USER_CONSTRUCT: u32 = 3;
pub const KEY_FLAG_ROOT_CAN_CLEAR: u32 = 4;
pub const KEY_FLAG_INVALIDATED: u32 = 5;
pub const KEY_FLAG_BUILTIN: u32 = 6;
pub const KEY_FLAG_ROOT_CAN_INVAL: u32 = 7;
pub const KEY_FLAG_KEEP: u32 = 8;
pub const KEY_FLAG_UID_KEYRING: u32 = 9;
pub const KEY_FLAG_USER_ALIVE: u32 = 10;
pub const KEY_ALLOC_IN_QUOTA: u32 = 0;
pub const KEY_ALLOC_QUOTA_OVERRUN: u32 = 1;
pub const KEY_ALLOC_NOT_IN_QUOTA: u32 = 2;
pub const KEY_ALLOC_BUILT_IN: u32 = 4;
pub const KEY_ALLOC_BYPASS_RESTRICTION: u32 = 8;
pub const KEY_ALLOC_UID_KEYRING: u32 = 16;
pub const KEY_ALLOC_SET_KEEP: u32 = 32;
pub const HIGH_RES_NSEC: u32 = 1;
pub const KTIME_HIGH_RES: u32 = 1;
pub const MONOTONIC_RES_NSEC: u32 = 1;
pub const KTIME_MONOTONIC_RES: u32 = 1;
pub const HRTIMER_STATE_INACTIVE: u32 = 0;
pub const HRTIMER_STATE_ENQUEUED: u32 = 1;
pub const ALARMTIMER_STATE_INACTIVE: u32 = 0;
pub const ALARMTIMER_STATE_ENQUEUED: u32 = 1;
pub const RCUREF_ONEREF: u32 = 0;
pub const RCUREF_MAXREF: u32 = 2147483647;
pub const RCUREF_SATURATED: u32 = 2684354560;
pub const RCUREF_RELEASED: u32 = 3221225472;
pub const RCUREF_DEAD: u32 = 3758096384;
pub const RCUREF_NOREF: u32 = 4294967295;
pub const SIGNAL_STOP_STOPPED: u32 = 1;
pub const SIGNAL_STOP_CONTINUED: u32 = 2;
pub const SIGNAL_GROUP_EXIT: u32 = 4;
pub const SIGNAL_CLD_STOPPED: u32 = 16;
pub const SIGNAL_CLD_CONTINUED: u32 = 32;
pub const SIGNAL_CLD_MASK: u32 = 48;
pub const SIGNAL_UNKILLABLE: u32 = 64;
pub const SIGNAL_STOP_MASK: u32 = 51;
pub const UUID_SIZE: u32 = 16;
pub const UUID_STRING_LEN: u32 = 36;
pub const RR_TIMESLICE: u32 = 100;
pub const IOPRIO_CLASS_SHIFT: u32 = 13;
pub const IOPRIO_NR_CLASSES: u32 = 8;
pub const IOPRIO_CLASS_MASK: u32 = 7;
pub const IOPRIO_PRIO_MASK: u32 = 8191;
pub const IOPRIO_LEVEL_NR_BITS: u32 = 3;
pub const IOPRIO_NR_LEVELS: u32 = 8;
pub const IOPRIO_LEVEL_MASK: u32 = 7;
pub const IOPRIO_BE_NR: u32 = 8;
pub const IOPRIO_NORM: u32 = 4;
pub const IOPRIO_BE_NORM: u32 = 4;
pub const IOPRIO_HINT_SHIFT: u32 = 3;
pub const IOPRIO_HINT_NR_BITS: u32 = 10;
pub const IOPRIO_NR_HINTS: u32 = 1024;
pub const IOPRIO_HINT_MASK: u32 = 1023;
pub const S_DT_SHIFT: u32 = 12;
pub const S_DT_MASK: u32 = 15;
pub const DT_UNKNOWN: u32 = 0;
pub const DT_FIFO: u32 = 1;
pub const DT_CHR: u32 = 2;
pub const DT_DIR: u32 = 4;
pub const DT_BLK: u32 = 6;
pub const DT_REG: u32 = 8;
pub const DT_LNK: u32 = 10;
pub const DT_SOCK: u32 = 12;
pub const DT_WHT: u32 = 14;
pub const DT_MAX: u32 = 16;
pub const FT_UNKNOWN: u32 = 0;
pub const FT_REG_FILE: u32 = 1;
pub const FT_DIR: u32 = 2;
pub const FT_CHRDEV: u32 = 3;
pub const FT_BLKDEV: u32 = 4;
pub const FT_FIFO: u32 = 5;
pub const FT_SOCK: u32 = 6;
pub const FT_SYMLINK: u32 = 7;
pub const FT_MAX: u32 = 8;
pub const FILE_REF_ONEREF: u32 = 0;
pub const FILE_REF_MAXREF: u64 = 9223372036854775807;
pub const FILE_REF_SATURATED: i64 = -6917529027641081856;
pub const FILE_REF_RELEASED: i64 = -4611686018427387904;
pub const FILE_REF_DEAD: i64 = -2305843009213693952;
pub const FILE_REF_NOREF: i32 = -1;
pub const UNICODE_MAJ_SHIFT: u32 = 16;
pub const UNICODE_MIN_SHIFT: u32 = 8;
pub const INR_OPEN_CUR: u32 = 1024;
pub const INR_OPEN_MAX: u32 = 4096;
pub const BLOCK_SIZE_BITS: u32 = 10;
pub const BLOCK_SIZE: u32 = 1024;
pub const IO_INTEGRITY_CHK_GUARD: u32 = 1;
pub const IO_INTEGRITY_CHK_REFTAG: u32 = 2;
pub const IO_INTEGRITY_CHK_APPTAG: u32 = 4;
pub const IO_INTEGRITY_VALID_FLAGS: u32 = 7;
pub const SEEK_SET: u32 = 0;
pub const SEEK_CUR: u32 = 1;
pub const SEEK_END: u32 = 2;
pub const SEEK_DATA: u32 = 3;
pub const SEEK_HOLE: u32 = 4;
pub const SEEK_MAX: u32 = 4;
pub const RENAME_NOREPLACE: u32 = 1;
pub const RENAME_EXCHANGE: u32 = 2;
pub const RENAME_WHITEOUT: u32 = 4;
pub const LBMD_PI_CAP_INTEGRITY: u32 = 1;
pub const LBMD_PI_CAP_REFTAG: u32 = 2;
pub const LBMD_PI_CSUM_NONE: u32 = 0;
pub const LBMD_PI_CSUM_IP: u32 = 1;
pub const LBMD_PI_CSUM_CRC16_T10DIF: u32 = 2;
pub const LBMD_PI_CSUM_CRC64_NVME: u32 = 4;
pub const LBMD_SIZE_VER0: u32 = 16;
pub const FILE_DEDUPE_RANGE_SAME: u32 = 0;
pub const FILE_DEDUPE_RANGE_DIFFERS: u32 = 1;
pub const NR_FILE: u32 = 8192;
pub const FILE_ATTR_SIZE_VER0: u32 = 24;
pub const FILE_ATTR_SIZE_LATEST: u32 = 24;
pub const FS_XFLAG_REALTIME: u32 = 1;
pub const FS_XFLAG_PREALLOC: u32 = 2;
pub const FS_XFLAG_IMMUTABLE: u32 = 8;
pub const FS_XFLAG_APPEND: u32 = 16;
pub const FS_XFLAG_SYNC: u32 = 32;
pub const FS_XFLAG_NOATIME: u32 = 64;
pub const FS_XFLAG_NODUMP: u32 = 128;
pub const FS_XFLAG_RTINHERIT: u32 = 256;
pub const FS_XFLAG_PROJINHERIT: u32 = 512;
pub const FS_XFLAG_NOSYMLINKS: u32 = 1024;
pub const FS_XFLAG_EXTSIZE: u32 = 2048;
pub const FS_XFLAG_EXTSZINHERIT: u32 = 4096;
pub const FS_XFLAG_NODEFRAG: u32 = 8192;
pub const FS_XFLAG_FILESTREAM: u32 = 16384;
pub const FS_XFLAG_DAX: u32 = 32768;
pub const FS_XFLAG_COWEXTSIZE: u32 = 65536;
pub const FS_XFLAG_HASATTR: u32 = 2147483648;
pub const BMAP_IOCTL: u32 = 1;
pub const FSLABEL_MAX: u32 = 256;
pub const FS_SECRM_FL: u32 = 1;
pub const FS_UNRM_FL: u32 = 2;
pub const FS_COMPR_FL: u32 = 4;
pub const FS_SYNC_FL: u32 = 8;
pub const FS_IMMUTABLE_FL: u32 = 16;
pub const FS_APPEND_FL: u32 = 32;
pub const FS_NODUMP_FL: u32 = 64;
pub const FS_NOATIME_FL: u32 = 128;
pub const FS_DIRTY_FL: u32 = 256;
pub const FS_COMPRBLK_FL: u32 = 512;
pub const FS_NOCOMP_FL: u32 = 1024;
pub const FS_ENCRYPT_FL: u32 = 2048;
pub const FS_BTREE_FL: u32 = 4096;
pub const FS_INDEX_FL: u32 = 4096;
pub const FS_IMAGIC_FL: u32 = 8192;
pub const FS_JOURNAL_DATA_FL: u32 = 16384;
pub const FS_NOTAIL_FL: u32 = 32768;
pub const FS_DIRSYNC_FL: u32 = 65536;
pub const FS_TOPDIR_FL: u32 = 131072;
pub const FS_HUGE_FILE_FL: u32 = 262144;
pub const FS_EXTENT_FL: u32 = 524288;
pub const FS_VERITY_FL: u32 = 1048576;
pub const FS_EA_INODE_FL: u32 = 2097152;
pub const FS_EOFBLOCKS_FL: u32 = 4194304;
pub const FS_NOCOW_FL: u32 = 8388608;
pub const FS_DAX_FL: u32 = 33554432;
pub const FS_INLINE_DATA_FL: u32 = 268435456;
pub const FS_PROJINHERIT_FL: u32 = 536870912;
pub const FS_CASEFOLD_FL: u32 = 1073741824;
pub const FS_RESERVED_FL: u32 = 2147483648;
pub const FS_FL_USER_VISIBLE: u32 = 253951;
pub const FS_FL_USER_MODIFIABLE: u32 = 229631;
pub const SYNC_FILE_RANGE_WAIT_BEFORE: u32 = 1;
pub const SYNC_FILE_RANGE_WRITE: u32 = 2;
pub const SYNC_FILE_RANGE_WAIT_AFTER: u32 = 4;
pub const SYNC_FILE_RANGE_WRITE_AND_WAIT: u32 = 7;
pub const PROCFS_IOCTL_MAGIC: u8 = 102u8;
pub const PAGE_IS_WPALLOWED: u32 = 1;
pub const PAGE_IS_WRITTEN: u32 = 2;
pub const PAGE_IS_FILE: u32 = 4;
pub const PAGE_IS_PRESENT: u32 = 8;
pub const PAGE_IS_SWAPPED: u32 = 16;
pub const PAGE_IS_PFNZERO: u32 = 32;
pub const PAGE_IS_HUGE: u32 = 64;
pub const PAGE_IS_SOFT_DIRTY: u32 = 128;
pub const PAGE_IS_GUARD: u32 = 256;
pub const PM_SCAN_WP_MATCHING: u32 = 1;
pub const PM_SCAN_CHECK_WPASYNC: u32 = 2;
pub const MAY_EXEC: u32 = 1;
pub const MAY_WRITE: u32 = 2;
pub const MAY_READ: u32 = 4;
pub const MAY_APPEND: u32 = 8;
pub const MAY_ACCESS: u32 = 16;
pub const MAY_OPEN: u32 = 32;
pub const MAY_CHDIR: u32 = 64;
pub const MAY_NOT_BLOCK: u32 = 128;
pub const ATTR_MODE: u32 = 1;
pub const ATTR_UID: u32 = 2;
pub const ATTR_GID: u32 = 4;
pub const ATTR_SIZE: u32 = 8;
pub const ATTR_ATIME: u32 = 16;
pub const ATTR_MTIME: u32 = 32;
pub const ATTR_CTIME: u32 = 64;
pub const ATTR_ATIME_SET: u32 = 128;
pub const ATTR_MTIME_SET: u32 = 256;
pub const ATTR_FORCE: u32 = 512;
pub const ATTR_CTIME_SET: u32 = 1024;
pub const ATTR_KILL_SUID: u32 = 2048;
pub const ATTR_KILL_SGID: u32 = 4096;
pub const ATTR_FILE: u32 = 8192;
pub const ATTR_KILL_PRIV: u32 = 16384;
pub const ATTR_OPEN: u32 = 32768;
pub const ATTR_TIMES_SET: u32 = 65536;
pub const ATTR_TOUCH: u32 = 131072;
pub const ATTR_DELEG: u32 = 262144;
pub const WHITEOUT_MODE: u32 = 0;
pub const WHITEOUT_DEV: u32 = 0;
pub const XQM_USRQUOTA: u32 = 0;
pub const XQM_GRPQUOTA: u32 = 1;
pub const XQM_PRJQUOTA: u32 = 2;
pub const XQM_MAXQUOTAS: u32 = 3;
pub const FS_DQUOT_VERSION: u32 = 1;
pub const FS_DQ_ISOFT: u32 = 1;
pub const FS_DQ_IHARD: u32 = 2;
pub const FS_DQ_BSOFT: u32 = 4;
pub const FS_DQ_BHARD: u32 = 8;
pub const FS_DQ_RTBSOFT: u32 = 16;
pub const FS_DQ_RTBHARD: u32 = 32;
pub const FS_DQ_LIMIT_MASK: u32 = 63;
pub const FS_DQ_BTIMER: u32 = 64;
pub const FS_DQ_ITIMER: u32 = 128;
pub const FS_DQ_RTBTIMER: u32 = 256;
pub const FS_DQ_TIMER_MASK: u32 = 448;
pub const FS_DQ_BWARNS: u32 = 512;
pub const FS_DQ_IWARNS: u32 = 1024;
pub const FS_DQ_RTBWARNS: u32 = 2048;
pub const FS_DQ_WARNS_MASK: u32 = 3584;
pub const FS_DQ_BCOUNT: u32 = 4096;
pub const FS_DQ_ICOUNT: u32 = 8192;
pub const FS_DQ_RTBCOUNT: u32 = 16384;
pub const FS_DQ_ACCT_MASK: u32 = 28672;
pub const FS_DQ_BIGTIME: u32 = 32768;
pub const FS_QUOTA_UDQ_ACCT: u32 = 1;
pub const FS_QUOTA_UDQ_ENFD: u32 = 2;
pub const FS_QUOTA_GDQ_ACCT: u32 = 4;
pub const FS_QUOTA_GDQ_ENFD: u32 = 8;
pub const FS_QUOTA_PDQ_ACCT: u32 = 16;
pub const FS_QUOTA_PDQ_ENFD: u32 = 32;
pub const FS_USER_QUOTA: u32 = 1;
pub const FS_PROJ_QUOTA: u32 = 2;
pub const FS_GROUP_QUOTA: u32 = 4;
pub const FS_QSTAT_VERSION: u32 = 1;
pub const FS_QSTATV_VERSION1: u32 = 1;
pub const V1_INIT_ALLOC: u32 = 1;
pub const V1_INIT_REWRITE: u32 = 1;
pub const V1_DEL_ALLOC: u32 = 0;
pub const V1_DEL_REWRITE: u32 = 2;
pub const QTREE_INIT_ALLOC: u32 = 4;
pub const QTREE_INIT_REWRITE: u32 = 2;
pub const QTREE_DEL_ALLOC: u32 = 0;
pub const QTREE_DEL_REWRITE: u32 = 6;
pub const V2_INIT_ALLOC: u32 = 4;
pub const V2_INIT_REWRITE: u32 = 2;
pub const V2_DEL_ALLOC: u32 = 0;
pub const V2_DEL_REWRITE: u32 = 6;
pub const OVERFLOW_PROJID: u32 = 65534;
pub const __DQUOT_VERSION__: &[u8; 12] = b"dquot_6.6.0\0";
pub const MAXQUOTAS: u32 = 3;
pub const USRQUOTA: u32 = 0;
pub const GRPQUOTA: u32 = 1;
pub const PRJQUOTA: u32 = 2;
pub const SUBCMDMASK: u32 = 255;
pub const SUBCMDSHIFT: u32 = 8;
pub const Q_SYNC: u32 = 8388609;
pub const Q_QUOTAON: u32 = 8388610;
pub const Q_QUOTAOFF: u32 = 8388611;
pub const Q_GETFMT: u32 = 8388612;
pub const Q_GETINFO: u32 = 8388613;
pub const Q_SETINFO: u32 = 8388614;
pub const Q_GETQUOTA: u32 = 8388615;
pub const Q_SETQUOTA: u32 = 8388616;
pub const Q_GETNEXTQUOTA: u32 = 8388617;
pub const QFMT_VFS_OLD: u32 = 1;
pub const QFMT_VFS_V0: u32 = 2;
pub const QFMT_OCFS2: u32 = 3;
pub const QFMT_VFS_V1: u32 = 4;
pub const QFMT_SHMEM: u32 = 5;
pub const QIF_DQBLKSIZE_BITS: u32 = 10;
pub const QIF_DQBLKSIZE: u32 = 1024;
pub const IIF_BGRACE: u32 = 1;
pub const IIF_IGRACE: u32 = 2;
pub const IIF_FLAGS: u32 = 4;
pub const IIF_ALL: u32 = 7;
pub const QUOTA_NL_NOWARN: u32 = 0;
pub const QUOTA_NL_IHARDWARN: u32 = 1;
pub const QUOTA_NL_ISOFTLONGWARN: u32 = 2;
pub const QUOTA_NL_ISOFTWARN: u32 = 3;
pub const QUOTA_NL_BHARDWARN: u32 = 4;
pub const QUOTA_NL_BSOFTLONGWARN: u32 = 5;
pub const QUOTA_NL_BSOFTWARN: u32 = 6;
pub const QUOTA_NL_IHARDBELOW: u32 = 7;
pub const QUOTA_NL_ISOFTBELOW: u32 = 8;
pub const QUOTA_NL_BHARDBELOW: u32 = 9;
pub const QUOTA_NL_BSOFTBELOW: u32 = 10;
pub const QTYPE_MASK_USR: u32 = 1;
pub const QTYPE_MASK_GRP: u32 = 2;
pub const QTYPE_MASK_PRJ: u32 = 4;
pub const DQ_MOD_B: u32 = 0;
pub const DQ_BLKS_B: u32 = 1;
pub const DQ_INODES_B: u32 = 2;
pub const DQ_FAKE_B: u32 = 3;
pub const DQ_READ_B: u32 = 4;
pub const DQ_ACTIVE_B: u32 = 5;
pub const DQ_RELEASING_B: u32 = 6;
pub const DQ_LASTSET_B: u32 = 7;
pub const QC_INO_SOFT: u32 = 1;
pub const QC_INO_HARD: u32 = 2;
pub const QC_SPC_SOFT: u32 = 4;
pub const QC_SPC_HARD: u32 = 8;
pub const QC_RT_SPC_SOFT: u32 = 16;
pub const QC_RT_SPC_HARD: u32 = 32;
pub const QC_LIMIT_MASK: u32 = 63;
pub const QC_SPC_TIMER: u32 = 64;
pub const QC_INO_TIMER: u32 = 128;
pub const QC_RT_SPC_TIMER: u32 = 256;
pub const QC_TIMER_MASK: u32 = 448;
pub const QC_SPC_WARNS: u32 = 512;
pub const QC_INO_WARNS: u32 = 1024;
pub const QC_RT_SPC_WARNS: u32 = 2048;
pub const QC_WARNS_MASK: u32 = 3584;
pub const QC_SPACE: u32 = 4096;
pub const QC_INO_COUNT: u32 = 8192;
pub const QC_RT_SPACE: u32 = 16384;
pub const QC_ACCT_MASK: u32 = 28672;
pub const QC_FLAGS: u32 = 32768;
pub const QCI_SYSFILE: u32 = 1;
pub const QCI_ROOT_SQUASH: u32 = 2;
pub const QCI_ACCT_ENABLED: u32 = 4;
pub const QCI_LIMITS_ENFORCED: u32 = 8;
pub const FILESYSTEM_MAX_STACK_DEPTH: u32 = 2;
pub const IOCB_EVENTFD: u32 = 65536;
pub const IOCB_DIRECT: u32 = 131072;
pub const IOCB_WRITE: u32 = 262144;
pub const IOCB_WAITQ: u32 = 524288;
pub const IOCB_NOIO: u32 = 1048576;
pub const IOCB_ALLOC_CACHE: u32 = 2097152;
pub const IOCB_DIO_CALLER_COMP: u32 = 4194304;
pub const IOCB_AIO_RW: u32 = 8388608;
pub const IOCB_HAS_METADATA: u32 = 16777216;
pub const IOP_FASTPERM: u32 = 1;
pub const IOP_LOOKUP: u32 = 2;
pub const IOP_NOFOLLOW: u32 = 4;
pub const IOP_XATTR: u32 = 8;
pub const IOP_DEFAULT_READLINK: u32 = 16;
pub const IOP_MGTIME: u32 = 32;
pub const IOP_CACHED_LINK: u32 = 64;
pub const MAX_NON_LFS: u32 = 2147483647;
pub const FASYNC_MAGIC: u32 = 17921;
pub const SB_ENC_STRICT_MODE_FL: u32 = 1;
pub const SB_ENC_NO_COMPAT_FALLBACK_FL: u32 = 2;
pub const MNT_FORCE: u32 = 1;
pub const MNT_DETACH: u32 = 2;
pub const MNT_EXPIRE: u32 = 4;
pub const UMOUNT_NOFOLLOW: u32 = 8;
pub const UMOUNT_UNUSED: u32 = 2147483648;
pub const SB_I_CGROUPWB: u32 = 1;
pub const SB_I_NOEXEC: u32 = 2;
pub const SB_I_NODEV: u32 = 4;
pub const SB_I_STABLE_WRITES: u32 = 8;
pub const SB_I_USERNS_VISIBLE: u32 = 16;
pub const SB_I_IMA_UNVERIFIABLE_SIGNATURE: u32 = 32;
pub const SB_I_UNTRUSTED_MOUNTER: u32 = 64;
pub const SB_I_EVM_HMAC_UNSUPPORTED: u32 = 128;
pub const SB_I_SKIP_SYNC: u32 = 256;
pub const SB_I_PERSB_BDI: u32 = 512;
pub const SB_I_TS_EXPIRY_WARNED: u32 = 1024;
pub const SB_I_RETIRED: u32 = 2048;
pub const SB_I_NOUMASK: u32 = 4096;
pub const SB_I_NOIDMAP: u32 = 8192;
pub const SB_I_ALLOW_HSM: u32 = 16384;
pub const FILLDIR_FLAG_NOINTR: u32 = 4096;
pub const NOMMU_MAP_COPY: u32 = 1;
pub const NOMMU_MAP_DIRECT: u32 = 8;
pub const REMAP_FILE_DEDUP: u32 = 1;
pub const REMAP_FILE_CAN_SHORTEN: u32 = 2;
pub const REMAP_FILE_ADVISORY: u32 = 2;
pub const COPY_FILE_SPLICE: u32 = 1;
pub const S_SYNC: u32 = 1;
pub const S_NOATIME: u32 = 2;
pub const S_APPEND: u32 = 4;
pub const S_IMMUTABLE: u32 = 8;
pub const S_DEAD: u32 = 16;
pub const S_NOQUOTA: u32 = 32;
pub const S_DIRSYNC: u32 = 64;
pub const S_NOCMTIME: u32 = 128;
pub const S_SWAPFILE: u32 = 256;
pub const S_PRIVATE: u32 = 512;
pub const S_IMA: u32 = 1024;
pub const S_AUTOMOUNT: u32 = 2048;
pub const S_NOSEC: u32 = 4096;
pub const S_DAX: u32 = 8192;
pub const S_ENCRYPTED: u32 = 16384;
pub const S_CASEFOLD: u32 = 32768;
pub const S_VERITY: u32 = 65536;
pub const S_KERNEL_FILE: u32 = 131072;
pub const S_ANON_INODE: u32 = 524288;
pub const FS_REQUIRES_DEV: u32 = 1;
pub const FS_BINARY_MOUNTDATA: u32 = 2;
pub const FS_HAS_SUBTYPE: u32 = 4;
pub const FS_USERNS_MOUNT: u32 = 8;
pub const FS_DISALLOW_NOTIFY_PERM: u32 = 16;
pub const FS_ALLOW_IDMAP: u32 = 32;
pub const FS_MGTIME: u32 = 64;
pub const FS_LBS: u32 = 128;
pub const FS_POWER_FREEZE: u32 = 256;
pub const FS_RENAME_DOES_D_MOVE: u32 = 32768;
pub const CHRDEV_MAJOR_MAX: u32 = 512;
pub const CHRDEV_MAJOR_DYN_END: u32 = 234;
pub const CHRDEV_MAJOR_DYN_EXT_START: u32 = 511;
pub const CHRDEV_MAJOR_DYN_EXT_END: u32 = 384;
pub const IOCB_FLAG_RESFD: u32 = 1;
pub const IOCB_FLAG_IOPRIO: u32 = 2;
pub const _ASM_X86_UNISTD_H: u32 = 1;
pub const __X32_SYSCALL_BIT: u32 = 1073741824;
pub const __NR_read: u32 = 0;
pub const __NR_write: u32 = 1;
pub const __NR_open: u32 = 2;
pub const __NR_close: u32 = 3;
pub const __NR_stat: u32 = 4;
pub const __NR_fstat: u32 = 5;
pub const __NR_lstat: u32 = 6;
pub const __NR_poll: u32 = 7;
pub const __NR_lseek: u32 = 8;
pub const __NR_mmap: u32 = 9;
pub const __NR_mprotect: u32 = 10;
pub const __NR_munmap: u32 = 11;
pub const __NR_brk: u32 = 12;
pub const __NR_rt_sigaction: u32 = 13;
pub const __NR_rt_sigprocmask: u32 = 14;
pub const __NR_rt_sigreturn: u32 = 15;
pub const __NR_ioctl: u32 = 16;
pub const __NR_pread64: u32 = 17;
pub const __NR_pwrite64: u32 = 18;
pub const __NR_readv: u32 = 19;
pub const __NR_writev: u32 = 20;
pub const __NR_access: u32 = 21;
pub const __NR_pipe: u32 = 22;
pub const __NR_select: u32 = 23;
pub const __NR_sched_yield: u32 = 24;
pub const __NR_mremap: u32 = 25;
pub const __NR_msync: u32 = 26;
pub const __NR_mincore: u32 = 27;
pub const __NR_madvise: u32 = 28;
pub const __NR_shmget: u32 = 29;
pub const __NR_shmat: u32 = 30;
pub const __NR_shmctl: u32 = 31;
pub const __NR_dup: u32 = 32;
pub const __NR_dup2: u32 = 33;
pub const __NR_pause: u32 = 34;
pub const __NR_nanosleep: u32 = 35;
pub const __NR_getitimer: u32 = 36;
pub const __NR_alarm: u32 = 37;
pub const __NR_setitimer: u32 = 38;
pub const __NR_getpid: u32 = 39;
pub const __NR_sendfile: u32 = 40;
pub const __NR_socket: u32 = 41;
pub const __NR_connect: u32 = 42;
pub const __NR_accept: u32 = 43;
pub const __NR_sendto: u32 = 44;
pub const __NR_recvfrom: u32 = 45;
pub const __NR_sendmsg: u32 = 46;
pub const __NR_recvmsg: u32 = 47;
pub const __NR_shutdown: u32 = 48;
pub const __NR_bind: u32 = 49;
pub const __NR_listen: u32 = 50;
pub const __NR_getsockname: u32 = 51;
pub const __NR_getpeername: u32 = 52;
pub const __NR_socketpair: u32 = 53;
pub const __NR_setsockopt: u32 = 54;
pub const __NR_getsockopt: u32 = 55;
pub const __NR_clone: u32 = 56;
pub const __NR_fork: u32 = 57;
pub const __NR_vfork: u32 = 58;
pub const __NR_execve: u32 = 59;
pub const __NR_exit: u32 = 60;
pub const __NR_wait4: u32 = 61;
pub const __NR_kill: u32 = 62;
pub const __NR_uname: u32 = 63;
pub const __NR_semget: u32 = 64;
pub const __NR_semop: u32 = 65;
pub const __NR_semctl: u32 = 66;
pub const __NR_shmdt: u32 = 67;
pub const __NR_msgget: u32 = 68;
pub const __NR_msgsnd: u32 = 69;
pub const __NR_msgrcv: u32 = 70;
pub const __NR_msgctl: u32 = 71;
pub const __NR_fcntl: u32 = 72;
pub const __NR_flock: u32 = 73;
pub const __NR_fsync: u32 = 74;
pub const __NR_fdatasync: u32 = 75;
pub const __NR_truncate: u32 = 76;
pub const __NR_ftruncate: u32 = 77;
pub const __NR_getdents: u32 = 78;
pub const __NR_getcwd: u32 = 79;
pub const __NR_chdir: u32 = 80;
pub const __NR_fchdir: u32 = 81;
pub const __NR_rename: u32 = 82;
pub const __NR_mkdir: u32 = 83;
pub const __NR_rmdir: u32 = 84;
pub const __NR_creat: u32 = 85;
pub const __NR_link: u32 = 86;
pub const __NR_unlink: u32 = 87;
pub const __NR_symlink: u32 = 88;
pub const __NR_readlink: u32 = 89;
pub const __NR_chmod: u32 = 90;
pub const __NR_fchmod: u32 = 91;
pub const __NR_chown: u32 = 92;
pub const __NR_fchown: u32 = 93;
pub const __NR_lchown: u32 = 94;
pub const __NR_umask: u32 = 95;
pub const __NR_gettimeofday: u32 = 96;
pub const __NR_getrlimit: u32 = 97;
pub const __NR_getrusage: u32 = 98;
pub const __NR_sysinfo: u32 = 99;
pub const __NR_times: u32 = 100;
pub const __NR_ptrace: u32 = 101;
pub const __NR_getuid: u32 = 102;
pub const __NR_syslog: u32 = 103;
pub const __NR_getgid: u32 = 104;
pub const __NR_setuid: u32 = 105;
pub const __NR_setgid: u32 = 106;
pub const __NR_geteuid: u32 = 107;
pub const __NR_getegid: u32 = 108;
pub const __NR_setpgid: u32 = 109;
pub const __NR_getppid: u32 = 110;
pub const __NR_getpgrp: u32 = 111;
pub const __NR_setsid: u32 = 112;
pub const __NR_setreuid: u32 = 113;
pub const __NR_setregid: u32 = 114;
pub const __NR_getgroups: u32 = 115;
pub const __NR_setgroups: u32 = 116;
pub const __NR_setresuid: u32 = 117;
pub const __NR_getresuid: u32 = 118;
pub const __NR_setresgid: u32 = 119;
pub const __NR_getresgid: u32 = 120;
pub const __NR_getpgid: u32 = 121;
pub const __NR_setfsuid: u32 = 122;
pub const __NR_setfsgid: u32 = 123;
pub const __NR_getsid: u32 = 124;
pub const __NR_capget: u32 = 125;
pub const __NR_capset: u32 = 126;
pub const __NR_rt_sigpending: u32 = 127;
pub const __NR_rt_sigtimedwait: u32 = 128;
pub const __NR_rt_sigqueueinfo: u32 = 129;
pub const __NR_rt_sigsuspend: u32 = 130;
pub const __NR_sigaltstack: u32 = 131;
pub const __NR_utime: u32 = 132;
pub const __NR_mknod: u32 = 133;
pub const __NR_uselib: u32 = 134;
pub const __NR_personality: u32 = 135;
pub const __NR_ustat: u32 = 136;
pub const __NR_statfs: u32 = 137;
pub const __NR_fstatfs: u32 = 138;
pub const __NR_sysfs: u32 = 139;
pub const __NR_getpriority: u32 = 140;
pub const __NR_setpriority: u32 = 141;
pub const __NR_sched_setparam: u32 = 142;
pub const __NR_sched_getparam: u32 = 143;
pub const __NR_sched_setscheduler: u32 = 144;
pub const __NR_sched_getscheduler: u32 = 145;
pub const __NR_sched_get_priority_max: u32 = 146;
pub const __NR_sched_get_priority_min: u32 = 147;
pub const __NR_sched_rr_get_interval: u32 = 148;
pub const __NR_mlock: u32 = 149;
pub const __NR_munlock: u32 = 150;
pub const __NR_mlockall: u32 = 151;
pub const __NR_munlockall: u32 = 152;
pub const __NR_vhangup: u32 = 153;
pub const __NR_modify_ldt: u32 = 154;
pub const __NR_pivot_root: u32 = 155;
pub const __NR__sysctl: u32 = 156;
pub const __NR_prctl: u32 = 157;
pub const __NR_arch_prctl: u32 = 158;
pub const __NR_adjtimex: u32 = 159;
pub const __NR_setrlimit: u32 = 160;
pub const __NR_chroot: u32 = 161;
pub const __NR_sync: u32 = 162;
pub const __NR_acct: u32 = 163;
pub const __NR_settimeofday: u32 = 164;
pub const __NR_mount: u32 = 165;
pub const __NR_umount2: u32 = 166;
pub const __NR_swapon: u32 = 167;
pub const __NR_swapoff: u32 = 168;
pub const __NR_reboot: u32 = 169;
pub const __NR_sethostname: u32 = 170;
pub const __NR_setdomainname: u32 = 171;
pub const __NR_iopl: u32 = 172;
pub const __NR_ioperm: u32 = 173;
pub const __NR_create_module: u32 = 174;
pub const __NR_init_module: u32 = 175;
pub const __NR_delete_module: u32 = 176;
pub const __NR_get_kernel_syms: u32 = 177;
pub const __NR_query_module: u32 = 178;
pub const __NR_quotactl: u32 = 179;
pub const __NR_nfsservctl: u32 = 180;
pub const __NR_getpmsg: u32 = 181;
pub const __NR_putpmsg: u32 = 182;
pub const __NR_afs_syscall: u32 = 183;
pub const __NR_tuxcall: u32 = 184;
pub const __NR_security: u32 = 185;
pub const __NR_gettid: u32 = 186;
pub const __NR_readahead: u32 = 187;
pub const __NR_setxattr: u32 = 188;
pub const __NR_lsetxattr: u32 = 189;
pub const __NR_fsetxattr: u32 = 190;
pub const __NR_getxattr: u32 = 191;
pub const __NR_lgetxattr: u32 = 192;
pub const __NR_fgetxattr: u32 = 193;
pub const __NR_listxattr: u32 = 194;
pub const __NR_llistxattr: u32 = 195;
pub const __NR_flistxattr: u32 = 196;
pub const __NR_removexattr: u32 = 197;
pub const __NR_lremovexattr: u32 = 198;
pub const __NR_fremovexattr: u32 = 199;
pub const __NR_tkill: u32 = 200;
pub const __NR_time: u32 = 201;
pub const __NR_futex: u32 = 202;
pub const __NR_sched_setaffinity: u32 = 203;
pub const __NR_sched_getaffinity: u32 = 204;
pub const __NR_set_thread_area: u32 = 205;
pub const __NR_io_setup: u32 = 206;
pub const __NR_io_destroy: u32 = 207;
pub const __NR_io_getevents: u32 = 208;
pub const __NR_io_submit: u32 = 209;
pub const __NR_io_cancel: u32 = 210;
pub const __NR_get_thread_area: u32 = 211;
pub const __NR_lookup_dcookie: u32 = 212;
pub const __NR_epoll_create: u32 = 213;
pub const __NR_epoll_ctl_old: u32 = 214;
pub const __NR_epoll_wait_old: u32 = 215;
pub const __NR_remap_file_pages: u32 = 216;
pub const __NR_getdents64: u32 = 217;
pub const __NR_set_tid_address: u32 = 218;
pub const __NR_restart_syscall: u32 = 219;
pub const __NR_semtimedop: u32 = 220;
pub const __NR_fadvise64: u32 = 221;
pub const __NR_timer_create: u32 = 222;
pub const __NR_timer_settime: u32 = 223;
pub const __NR_timer_gettime: u32 = 224;
pub const __NR_timer_getoverrun: u32 = 225;
pub const __NR_timer_delete: u32 = 226;
pub const __NR_clock_settime: u32 = 227;
pub const __NR_clock_gettime: u32 = 228;
pub const __NR_clock_getres: u32 = 229;
pub const __NR_clock_nanosleep: u32 = 230;
pub const __NR_exit_group: u32 = 231;
pub const __NR_epoll_wait: u32 = 232;
pub const __NR_epoll_ctl: u32 = 233;
pub const __NR_tgkill: u32 = 234;
pub const __NR_utimes: u32 = 235;
pub const __NR_vserver: u32 = 236;
pub const __NR_mbind: u32 = 237;
pub const __NR_set_mempolicy: u32 = 238;
pub const __NR_get_mempolicy: u32 = 239;
pub const __NR_mq_open: u32 = 240;
pub const __NR_mq_unlink: u32 = 241;
pub const __NR_mq_timedsend: u32 = 242;
pub const __NR_mq_timedreceive: u32 = 243;
pub const __NR_mq_notify: u32 = 244;
pub const __NR_mq_getsetattr: u32 = 245;
pub const __NR_kexec_load: u32 = 246;
pub const __NR_waitid: u32 = 247;
pub const __NR_add_key: u32 = 248;
pub const __NR_request_key: u32 = 249;
pub const __NR_keyctl: u32 = 250;
pub const __NR_ioprio_set: u32 = 251;
pub const __NR_ioprio_get: u32 = 252;
pub const __NR_inotify_init: u32 = 253;
pub const __NR_inotify_add_watch: u32 = 254;
pub const __NR_inotify_rm_watch: u32 = 255;
pub const __NR_migrate_pages: u32 = 256;
pub const __NR_openat: u32 = 257;
pub const __NR_mkdirat: u32 = 258;
pub const __NR_mknodat: u32 = 259;
pub const __NR_fchownat: u32 = 260;
pub const __NR_futimesat: u32 = 261;
pub const __NR_newfstatat: u32 = 262;
pub const __NR_unlinkat: u32 = 263;
pub const __NR_renameat: u32 = 264;
pub const __NR_linkat: u32 = 265;
pub const __NR_symlinkat: u32 = 266;
pub const __NR_readlinkat: u32 = 267;
pub const __NR_fchmodat: u32 = 268;
pub const __NR_faccessat: u32 = 269;
pub const __NR_pselect6: u32 = 270;
pub const __NR_ppoll: u32 = 271;
pub const __NR_unshare: u32 = 272;
pub const __NR_set_robust_list: u32 = 273;
pub const __NR_get_robust_list: u32 = 274;
pub const __NR_splice: u32 = 275;
pub const __NR_tee: u32 = 276;
pub const __NR_sync_file_range: u32 = 277;
pub const __NR_vmsplice: u32 = 278;
pub const __NR_move_pages: u32 = 279;
pub const __NR_utimensat: u32 = 280;
pub const __NR_epoll_pwait: u32 = 281;
pub const __NR_signalfd: u32 = 282;
pub const __NR_timerfd_create: u32 = 283;
pub const __NR_eventfd: u32 = 284;
pub const __NR_fallocate: u32 = 285;
pub const __NR_timerfd_settime: u32 = 286;
pub const __NR_timerfd_gettime: u32 = 287;
pub const __NR_accept4: u32 = 288;
pub const __NR_signalfd4: u32 = 289;
pub const __NR_eventfd2: u32 = 290;
pub const __NR_epoll_create1: u32 = 291;
pub const __NR_dup3: u32 = 292;
pub const __NR_pipe2: u32 = 293;
pub const __NR_inotify_init1: u32 = 294;
pub const __NR_preadv: u32 = 295;
pub const __NR_pwritev: u32 = 296;
pub const __NR_rt_tgsigqueueinfo: u32 = 297;
pub const __NR_perf_event_open: u32 = 298;
pub const __NR_recvmmsg: u32 = 299;
pub const __NR_fanotify_init: u32 = 300;
pub const __NR_fanotify_mark: u32 = 301;
pub const __NR_prlimit64: u32 = 302;
pub const __NR_name_to_handle_at: u32 = 303;
pub const __NR_open_by_handle_at: u32 = 304;
pub const __NR_clock_adjtime: u32 = 305;
pub const __NR_syncfs: u32 = 306;
pub const __NR_sendmmsg: u32 = 307;
pub const __NR_setns: u32 = 308;
pub const __NR_getcpu: u32 = 309;
pub const __NR_process_vm_readv: u32 = 310;
pub const __NR_process_vm_writev: u32 = 311;
pub const __NR_kcmp: u32 = 312;
pub const __NR_finit_module: u32 = 313;
pub const __NR_sched_setattr: u32 = 314;
pub const __NR_sched_getattr: u32 = 315;
pub const __NR_renameat2: u32 = 316;
pub const __NR_seccomp: u32 = 317;
pub const __NR_getrandom: u32 = 318;
pub const __NR_memfd_create: u32 = 319;
pub const __NR_kexec_file_load: u32 = 320;
pub const __NR_bpf: u32 = 321;
pub const __NR_execveat: u32 = 322;
pub const __NR_userfaultfd: u32 = 323;
pub const __NR_membarrier: u32 = 324;
pub const __NR_mlock2: u32 = 325;
pub const __NR_copy_file_range: u32 = 326;
pub const __NR_preadv2: u32 = 327;
pub const __NR_pwritev2: u32 = 328;
pub const __NR_pkey_mprotect: u32 = 329;
pub const __NR_pkey_alloc: u32 = 330;
pub const __NR_pkey_free: u32 = 331;
pub const __NR_statx: u32 = 332;
pub const __NR_io_pgetevents: u32 = 333;
pub const __NR_rseq: u32 = 334;
pub const __NR_uretprobe: u32 = 335;
pub const __NR_uprobe: u32 = 336;
pub const __NR_pidfd_send_signal: u32 = 424;
pub const __NR_io_uring_setup: u32 = 425;
pub const __NR_io_uring_enter: u32 = 426;
pub const __NR_io_uring_register: u32 = 427;
pub const __NR_open_tree: u32 = 428;
pub const __NR_move_mount: u32 = 429;
pub const __NR_fsopen: u32 = 430;
pub const __NR_fsconfig: u32 = 431;
pub const __NR_fsmount: u32 = 432;
pub const __NR_fspick: u32 = 433;
pub const __NR_pidfd_open: u32 = 434;
pub const __NR_clone3: u32 = 435;
pub const __NR_close_range: u32 = 436;
pub const __NR_openat2: u32 = 437;
pub const __NR_pidfd_getfd: u32 = 438;
pub const __NR_faccessat2: u32 = 439;
pub const __NR_process_madvise: u32 = 440;
pub const __NR_epoll_pwait2: u32 = 441;
pub const __NR_mount_setattr: u32 = 442;
pub const __NR_quotactl_fd: u32 = 443;
pub const __NR_landlock_create_ruleset: u32 = 444;
pub const __NR_landlock_add_rule: u32 = 445;
pub const __NR_landlock_restrict_self: u32 = 446;
pub const __NR_memfd_secret: u32 = 447;
pub const __NR_process_mrelease: u32 = 448;
pub const __NR_futex_waitv: u32 = 449;
pub const __NR_set_mempolicy_home_node: u32 = 450;
pub const __NR_cachestat: u32 = 451;
pub const __NR_fchmodat2: u32 = 452;
pub const __NR_map_shadow_stack: u32 = 453;
pub const __NR_futex_wake: u32 = 454;
pub const __NR_futex_wait: u32 = 455;
pub const __NR_futex_requeue: u32 = 456;
pub const __NR_statmount: u32 = 457;
pub const __NR_listmount: u32 = 458;
pub const __NR_lsm_get_self_attr: u32 = 459;
pub const __NR_lsm_set_self_attr: u32 = 460;
pub const __NR_lsm_list_modules: u32 = 461;
pub const __NR_mseal: u32 = 462;
pub const __NR_setxattrat: u32 = 463;
pub const __NR_getxattrat: u32 = 464;
pub const __NR_listxattrat: u32 = 465;
pub const __NR_removexattrat: u32 = 466;
pub const __NR_open_tree_attr: u32 = 467;
pub const __NR_file_getattr: u32 = 468;
pub const __NR_file_setattr: u32 = 469;
pub const __NR_syscalls: u32 = 470;
pub const __NR_x32_rt_sigaction: u32 = 512;
pub const __NR_x32_rt_sigreturn: u32 = 513;
pub const __NR_x32_ioctl: u32 = 514;
pub const __NR_x32_readv: u32 = 515;
pub const __NR_x32_writev: u32 = 516;
pub const __NR_x32_recvfrom: u32 = 517;
pub const __NR_x32_sendmsg: u32 = 518;
pub const __NR_x32_recvmsg: u32 = 519;
pub const __NR_x32_execve: u32 = 520;
pub const __NR_x32_ptrace: u32 = 521;
pub const __NR_x32_rt_sigpending: u32 = 522;
pub const __NR_x32_rt_sigtimedwait: u32 = 523;
pub const __NR_x32_rt_sigqueueinfo: u32 = 524;
pub const __NR_x32_sigaltstack: u32 = 525;
pub const __NR_x32_timer_create: u32 = 526;
pub const __NR_x32_mq_notify: u32 = 527;
pub const __NR_x32_kexec_load: u32 = 528;
pub const __NR_x32_waitid: u32 = 529;
pub const __NR_x32_set_robust_list: u32 = 530;
pub const __NR_x32_get_robust_list: u32 = 531;
pub const __NR_x32_vmsplice: u32 = 532;
pub const __NR_x32_move_pages: u32 = 533;
pub const __NR_x32_preadv: u32 = 534;
pub const __NR_x32_pwritev: u32 = 535;
pub const __NR_x32_rt_tgsigqueueinfo: u32 = 536;
pub const __NR_x32_recvmmsg: u32 = 537;
pub const __NR_x32_sendmmsg: u32 = 538;
pub const __NR_x32_process_vm_readv: u32 = 539;
pub const __NR_x32_process_vm_writev: u32 = 540;
pub const __NR_x32_setsockopt: u32 = 541;
pub const __NR_x32_getsockopt: u32 = 542;
pub const __NR_x32_io_setup: u32 = 543;
pub const __NR_x32_io_submit: u32 = 544;
pub const __NR_x32_execveat: u32 = 545;
pub const __NR_x32_preadv2: u32 = 546;
pub const __NR_x32_pwritev2: u32 = 547;
pub const __NR_x32_syscalls: u32 = 548;
pub const __NR_ia32_restart_syscall: u32 = 0;
pub const __NR_ia32_exit: u32 = 1;
pub const __NR_ia32_fork: u32 = 2;
pub const __NR_ia32_read: u32 = 3;
pub const __NR_ia32_write: u32 = 4;
pub const __NR_ia32_open: u32 = 5;
pub const __NR_ia32_close: u32 = 6;
pub const __NR_ia32_waitpid: u32 = 7;
pub const __NR_ia32_creat: u32 = 8;
pub const __NR_ia32_link: u32 = 9;
pub const __NR_ia32_unlink: u32 = 10;
pub const __NR_ia32_execve: u32 = 11;
pub const __NR_ia32_chdir: u32 = 12;
pub const __NR_ia32_time: u32 = 13;
pub const __NR_ia32_mknod: u32 = 14;
pub const __NR_ia32_chmod: u32 = 15;
pub const __NR_ia32_lchown: u32 = 16;
pub const __NR_ia32_break: u32 = 17;
pub const __NR_ia32_oldstat: u32 = 18;
pub const __NR_ia32_lseek: u32 = 19;
pub const __NR_ia32_getpid: u32 = 20;
pub const __NR_ia32_mount: u32 = 21;
pub const __NR_ia32_umount: u32 = 22;
pub const __NR_ia32_setuid: u32 = 23;
pub const __NR_ia32_getuid: u32 = 24;
pub const __NR_ia32_stime: u32 = 25;
pub const __NR_ia32_ptrace: u32 = 26;
pub const __NR_ia32_alarm: u32 = 27;
pub const __NR_ia32_oldfstat: u32 = 28;
pub const __NR_ia32_pause: u32 = 29;
pub const __NR_ia32_utime: u32 = 30;
pub const __NR_ia32_stty: u32 = 31;
pub const __NR_ia32_gtty: u32 = 32;
pub const __NR_ia32_access: u32 = 33;
pub const __NR_ia32_nice: u32 = 34;
pub const __NR_ia32_ftime: u32 = 35;
pub const __NR_ia32_sync: u32 = 36;
pub const __NR_ia32_kill: u32 = 37;
pub const __NR_ia32_rename: u32 = 38;
pub const __NR_ia32_mkdir: u32 = 39;
pub const __NR_ia32_rmdir: u32 = 40;
pub const __NR_ia32_dup: u32 = 41;
pub const __NR_ia32_pipe: u32 = 42;
pub const __NR_ia32_times: u32 = 43;
pub const __NR_ia32_prof: u32 = 44;
pub const __NR_ia32_brk: u32 = 45;
pub const __NR_ia32_setgid: u32 = 46;
pub const __NR_ia32_getgid: u32 = 47;
pub const __NR_ia32_signal: u32 = 48;
pub const __NR_ia32_geteuid: u32 = 49;
pub const __NR_ia32_getegid: u32 = 50;
pub const __NR_ia32_acct: u32 = 51;
pub const __NR_ia32_umount2: u32 = 52;
pub const __NR_ia32_lock: u32 = 53;
pub const __NR_ia32_ioctl: u32 = 54;
pub const __NR_ia32_fcntl: u32 = 55;
pub const __NR_ia32_mpx: u32 = 56;
pub const __NR_ia32_setpgid: u32 = 57;
pub const __NR_ia32_ulimit: u32 = 58;
pub const __NR_ia32_oldolduname: u32 = 59;
pub const __NR_ia32_umask: u32 = 60;
pub const __NR_ia32_chroot: u32 = 61;
pub const __NR_ia32_ustat: u32 = 62;
pub const __NR_ia32_dup2: u32 = 63;
pub const __NR_ia32_getppid: u32 = 64;
pub const __NR_ia32_getpgrp: u32 = 65;
pub const __NR_ia32_setsid: u32 = 66;
pub const __NR_ia32_sigaction: u32 = 67;
pub const __NR_ia32_sgetmask: u32 = 68;
pub const __NR_ia32_ssetmask: u32 = 69;
pub const __NR_ia32_setreuid: u32 = 70;
pub const __NR_ia32_setregid: u32 = 71;
pub const __NR_ia32_sigsuspend: u32 = 72;
pub const __NR_ia32_sigpending: u32 = 73;
pub const __NR_ia32_sethostname: u32 = 74;
pub const __NR_ia32_setrlimit: u32 = 75;
pub const __NR_ia32_getrlimit: u32 = 76;
pub const __NR_ia32_getrusage: u32 = 77;
pub const __NR_ia32_gettimeofday: u32 = 78;
pub const __NR_ia32_settimeofday: u32 = 79;
pub const __NR_ia32_getgroups: u32 = 80;
pub const __NR_ia32_setgroups: u32 = 81;
pub const __NR_ia32_select: u32 = 82;
pub const __NR_ia32_symlink: u32 = 83;
pub const __NR_ia32_oldlstat: u32 = 84;
pub const __NR_ia32_readlink: u32 = 85;
pub const __NR_ia32_uselib: u32 = 86;
pub const __NR_ia32_swapon: u32 = 87;
pub const __NR_ia32_reboot: u32 = 88;
pub const __NR_ia32_readdir: u32 = 89;
pub const __NR_ia32_mmap: u32 = 90;
pub const __NR_ia32_munmap: u32 = 91;
pub const __NR_ia32_truncate: u32 = 92;
pub const __NR_ia32_ftruncate: u32 = 93;
pub const __NR_ia32_fchmod: u32 = 94;
pub const __NR_ia32_fchown: u32 = 95;
pub const __NR_ia32_getpriority: u32 = 96;
pub const __NR_ia32_setpriority: u32 = 97;
pub const __NR_ia32_profil: u32 = 98;
pub const __NR_ia32_statfs: u32 = 99;
pub const __NR_ia32_fstatfs: u32 = 100;
pub const __NR_ia32_ioperm: u32 = 101;
pub const __NR_ia32_socketcall: u32 = 102;
pub const __NR_ia32_syslog: u32 = 103;
pub const __NR_ia32_setitimer: u32 = 104;
pub const __NR_ia32_getitimer: u32 = 105;
pub const __NR_ia32_stat: u32 = 106;
pub const __NR_ia32_lstat: u32 = 107;
pub const __NR_ia32_fstat: u32 = 108;
pub const __NR_ia32_olduname: u32 = 109;
pub const __NR_ia32_iopl: u32 = 110;
pub const __NR_ia32_vhangup: u32 = 111;
pub const __NR_ia32_idle: u32 = 112;
pub const __NR_ia32_vm86old: u32 = 113;
pub const __NR_ia32_wait4: u32 = 114;
pub const __NR_ia32_swapoff: u32 = 115;
pub const __NR_ia32_sysinfo: u32 = 116;
pub const __NR_ia32_ipc: u32 = 117;
pub const __NR_ia32_fsync: u32 = 118;
pub const __NR_ia32_sigreturn: u32 = 119;
pub const __NR_ia32_clone: u32 = 120;
pub const __NR_ia32_setdomainname: u32 = 121;
pub const __NR_ia32_uname: u32 = 122;
pub const __NR_ia32_modify_ldt: u32 = 123;
pub const __NR_ia32_adjtimex: u32 = 124;
pub const __NR_ia32_mprotect: u32 = 125;
pub const __NR_ia32_sigprocmask: u32 = 126;
pub const __NR_ia32_create_module: u32 = 127;
pub const __NR_ia32_init_module: u32 = 128;
pub const __NR_ia32_delete_module: u32 = 129;
pub const __NR_ia32_get_kernel_syms: u32 = 130;
pub const __NR_ia32_quotactl: u32 = 131;
pub const __NR_ia32_getpgid: u32 = 132;
pub const __NR_ia32_fchdir: u32 = 133;
pub const __NR_ia32_bdflush: u32 = 134;
pub const __NR_ia32_sysfs: u32 = 135;
pub const __NR_ia32_personality: u32 = 136;
pub const __NR_ia32_afs_syscall: u32 = 137;
pub const __NR_ia32_setfsuid: u32 = 138;
pub const __NR_ia32_setfsgid: u32 = 139;
pub const __NR_ia32__llseek: u32 = 140;
pub const __NR_ia32_getdents: u32 = 141;
pub const __NR_ia32__newselect: u32 = 142;
pub const __NR_ia32_flock: u32 = 143;
pub const __NR_ia32_msync: u32 = 144;
pub const __NR_ia32_readv: u32 = 145;
pub const __NR_ia32_writev: u32 = 146;
pub const __NR_ia32_getsid: u32 = 147;
pub const __NR_ia32_fdatasync: u32 = 148;
pub const __NR_ia32__sysctl: u32 = 149;
pub const __NR_ia32_mlock: u32 = 150;
pub const __NR_ia32_munlock: u32 = 151;
pub const __NR_ia32_mlockall: u32 = 152;
pub const __NR_ia32_munlockall: u32 = 153;
pub const __NR_ia32_sched_setparam: u32 = 154;
pub const __NR_ia32_sched_getparam: u32 = 155;
pub const __NR_ia32_sched_setscheduler: u32 = 156;
pub const __NR_ia32_sched_getscheduler: u32 = 157;
pub const __NR_ia32_sched_yield: u32 = 158;
pub const __NR_ia32_sched_get_priority_max: u32 = 159;
pub const __NR_ia32_sched_get_priority_min: u32 = 160;
pub const __NR_ia32_sched_rr_get_interval: u32 = 161;
pub const __NR_ia32_nanosleep: u32 = 162;
pub const __NR_ia32_mremap: u32 = 163;
pub const __NR_ia32_setresuid: u32 = 164;
pub const __NR_ia32_getresuid: u32 = 165;
pub const __NR_ia32_vm86: u32 = 166;
pub const __NR_ia32_query_module: u32 = 167;
pub const __NR_ia32_poll: u32 = 168;
pub const __NR_ia32_nfsservctl: u32 = 169;
pub const __NR_ia32_setresgid: u32 = 170;
pub const __NR_ia32_getresgid: u32 = 171;
pub const __NR_ia32_prctl: u32 = 172;
pub const __NR_ia32_rt_sigreturn: u32 = 173;
pub const __NR_ia32_rt_sigaction: u32 = 174;
pub const __NR_ia32_rt_sigprocmask: u32 = 175;
pub const __NR_ia32_rt_sigpending: u32 = 176;
pub const __NR_ia32_rt_sigtimedwait: u32 = 177;
pub const __NR_ia32_rt_sigqueueinfo: u32 = 178;
pub const __NR_ia32_rt_sigsuspend: u32 = 179;
pub const __NR_ia32_pread64: u32 = 180;
pub const __NR_ia32_pwrite64: u32 = 181;
pub const __NR_ia32_chown: u32 = 182;
pub const __NR_ia32_getcwd: u32 = 183;
pub const __NR_ia32_capget: u32 = 184;
pub const __NR_ia32_capset: u32 = 185;
pub const __NR_ia32_sigaltstack: u32 = 186;
pub const __NR_ia32_sendfile: u32 = 187;
pub const __NR_ia32_getpmsg: u32 = 188;
pub const __NR_ia32_putpmsg: u32 = 189;
pub const __NR_ia32_vfork: u32 = 190;
pub const __NR_ia32_ugetrlimit: u32 = 191;
pub const __NR_ia32_mmap2: u32 = 192;
pub const __NR_ia32_truncate64: u32 = 193;
pub const __NR_ia32_ftruncate64: u32 = 194;
pub const __NR_ia32_stat64: u32 = 195;
pub const __NR_ia32_lstat64: u32 = 196;
pub const __NR_ia32_fstat64: u32 = 197;
pub const __NR_ia32_lchown32: u32 = 198;
pub const __NR_ia32_getuid32: u32 = 199;
pub const __NR_ia32_getgid32: u32 = 200;
pub const __NR_ia32_geteuid32: u32 = 201;
pub const __NR_ia32_getegid32: u32 = 202;
pub const __NR_ia32_setreuid32: u32 = 203;
pub const __NR_ia32_setregid32: u32 = 204;
pub const __NR_ia32_getgroups32: u32 = 205;
pub const __NR_ia32_setgroups32: u32 = 206;
pub const __NR_ia32_fchown32: u32 = 207;
pub const __NR_ia32_setresuid32: u32 = 208;
pub const __NR_ia32_getresuid32: u32 = 209;
pub const __NR_ia32_setresgid32: u32 = 210;
pub const __NR_ia32_getresgid32: u32 = 211;
pub const __NR_ia32_chown32: u32 = 212;
pub const __NR_ia32_setuid32: u32 = 213;
pub const __NR_ia32_setgid32: u32 = 214;
pub const __NR_ia32_setfsuid32: u32 = 215;
pub const __NR_ia32_setfsgid32: u32 = 216;
pub const __NR_ia32_pivot_root: u32 = 217;
pub const __NR_ia32_mincore: u32 = 218;
pub const __NR_ia32_madvise: u32 = 219;
pub const __NR_ia32_getdents64: u32 = 220;
pub const __NR_ia32_fcntl64: u32 = 221;
pub const __NR_ia32_gettid: u32 = 224;
pub const __NR_ia32_readahead: u32 = 225;
pub const __NR_ia32_setxattr: u32 = 226;
pub const __NR_ia32_lsetxattr: u32 = 227;
pub const __NR_ia32_fsetxattr: u32 = 228;
pub const __NR_ia32_getxattr: u32 = 229;
pub const __NR_ia32_lgetxattr: u32 = 230;
pub const __NR_ia32_fgetxattr: u32 = 231;
pub const __NR_ia32_listxattr: u32 = 232;
pub const __NR_ia32_llistxattr: u32 = 233;
pub const __NR_ia32_flistxattr: u32 = 234;
pub const __NR_ia32_removexattr: u32 = 235;
pub const __NR_ia32_lremovexattr: u32 = 236;
pub const __NR_ia32_fremovexattr: u32 = 237;
pub const __NR_ia32_tkill: u32 = 238;
pub const __NR_ia32_sendfile64: u32 = 239;
pub const __NR_ia32_futex: u32 = 240;
pub const __NR_ia32_sched_setaffinity: u32 = 241;
pub const __NR_ia32_sched_getaffinity: u32 = 242;
pub const __NR_ia32_set_thread_area: u32 = 243;
pub const __NR_ia32_get_thread_area: u32 = 244;
pub const __NR_ia32_io_setup: u32 = 245;
pub const __NR_ia32_io_destroy: u32 = 246;
pub const __NR_ia32_io_getevents: u32 = 247;
pub const __NR_ia32_io_submit: u32 = 248;
pub const __NR_ia32_io_cancel: u32 = 249;
pub const __NR_ia32_fadvise64: u32 = 250;
pub const __NR_ia32_exit_group: u32 = 252;
pub const __NR_ia32_lookup_dcookie: u32 = 253;
pub const __NR_ia32_epoll_create: u32 = 254;
pub const __NR_ia32_epoll_ctl: u32 = 255;
pub const __NR_ia32_epoll_wait: u32 = 256;
pub const __NR_ia32_remap_file_pages: u32 = 257;
pub const __NR_ia32_set_tid_address: u32 = 258;
pub const __NR_ia32_timer_create: u32 = 259;
pub const __NR_ia32_timer_settime: u32 = 260;
pub const __NR_ia32_timer_gettime: u32 = 261;
pub const __NR_ia32_timer_getoverrun: u32 = 262;
pub const __NR_ia32_timer_delete: u32 = 263;
pub const __NR_ia32_clock_settime: u32 = 264;
pub const __NR_ia32_clock_gettime: u32 = 265;
pub const __NR_ia32_clock_getres: u32 = 266;
pub const __NR_ia32_clock_nanosleep: u32 = 267;
pub const __NR_ia32_statfs64: u32 = 268;
pub const __NR_ia32_fstatfs64: u32 = 269;
pub const __NR_ia32_tgkill: u32 = 270;
pub const __NR_ia32_utimes: u32 = 271;
pub const __NR_ia32_fadvise64_64: u32 = 272;
pub const __NR_ia32_vserver: u32 = 273;
pub const __NR_ia32_mbind: u32 = 274;
pub const __NR_ia32_get_mempolicy: u32 = 275;
pub const __NR_ia32_set_mempolicy: u32 = 276;
pub const __NR_ia32_mq_open: u32 = 277;
pub const __NR_ia32_mq_unlink: u32 = 278;
pub const __NR_ia32_mq_timedsend: u32 = 279;
pub const __NR_ia32_mq_timedreceive: u32 = 280;
pub const __NR_ia32_mq_notify: u32 = 281;
pub const __NR_ia32_mq_getsetattr: u32 = 282;
pub const __NR_ia32_kexec_load: u32 = 283;
pub const __NR_ia32_waitid: u32 = 284;
pub const __NR_ia32_add_key: u32 = 286;
pub const __NR_ia32_request_key: u32 = 287;
pub const __NR_ia32_keyctl: u32 = 288;
pub const __NR_ia32_ioprio_set: u32 = 289;
pub const __NR_ia32_ioprio_get: u32 = 290;
pub const __NR_ia32_inotify_init: u32 = 291;
pub const __NR_ia32_inotify_add_watch: u32 = 292;
pub const __NR_ia32_inotify_rm_watch: u32 = 293;
pub const __NR_ia32_migrate_pages: u32 = 294;
pub const __NR_ia32_openat: u32 = 295;
pub const __NR_ia32_mkdirat: u32 = 296;
pub const __NR_ia32_mknodat: u32 = 297;
pub const __NR_ia32_fchownat: u32 = 298;
pub const __NR_ia32_futimesat: u32 = 299;
pub const __NR_ia32_fstatat64: u32 = 300;
pub const __NR_ia32_unlinkat: u32 = 301;
pub const __NR_ia32_renameat: u32 = 302;
pub const __NR_ia32_linkat: u32 = 303;
pub const __NR_ia32_symlinkat: u32 = 304;
pub const __NR_ia32_readlinkat: u32 = 305;
pub const __NR_ia32_fchmodat: u32 = 306;
pub const __NR_ia32_faccessat: u32 = 307;
pub const __NR_ia32_pselect6: u32 = 308;
pub const __NR_ia32_ppoll: u32 = 309;
pub const __NR_ia32_unshare: u32 = 310;
pub const __NR_ia32_set_robust_list: u32 = 311;
pub const __NR_ia32_get_robust_list: u32 = 312;
pub const __NR_ia32_splice: u32 = 313;
pub const __NR_ia32_sync_file_range: u32 = 314;
pub const __NR_ia32_tee: u32 = 315;
pub const __NR_ia32_vmsplice: u32 = 316;
pub const __NR_ia32_move_pages: u32 = 317;
pub const __NR_ia32_getcpu: u32 = 318;
pub const __NR_ia32_epoll_pwait: u32 = 319;
pub const __NR_ia32_utimensat: u32 = 320;
pub const __NR_ia32_signalfd: u32 = 321;
pub const __NR_ia32_timerfd_create: u32 = 322;
pub const __NR_ia32_eventfd: u32 = 323;
pub const __NR_ia32_fallocate: u32 = 324;
pub const __NR_ia32_timerfd_settime: u32 = 325;
pub const __NR_ia32_timerfd_gettime: u32 = 326;
pub const __NR_ia32_signalfd4: u32 = 327;
pub const __NR_ia32_eventfd2: u32 = 328;
pub const __NR_ia32_epoll_create1: u32 = 329;
pub const __NR_ia32_dup3: u32 = 330;
pub const __NR_ia32_pipe2: u32 = 331;
pub const __NR_ia32_inotify_init1: u32 = 332;
pub const __NR_ia32_preadv: u32 = 333;
pub const __NR_ia32_pwritev: u32 = 334;
pub const __NR_ia32_rt_tgsigqueueinfo: u32 = 335;
pub const __NR_ia32_perf_event_open: u32 = 336;
pub const __NR_ia32_recvmmsg: u32 = 337;
pub const __NR_ia32_fanotify_init: u32 = 338;
pub const __NR_ia32_fanotify_mark: u32 = 339;
pub const __NR_ia32_prlimit64: u32 = 340;
pub const __NR_ia32_name_to_handle_at: u32 = 341;
pub const __NR_ia32_open_by_handle_at: u32 = 342;
pub const __NR_ia32_clock_adjtime: u32 = 343;
pub const __NR_ia32_syncfs: u32 = 344;
pub const __NR_ia32_sendmmsg: u32 = 345;
pub const __NR_ia32_setns: u32 = 346;
pub const __NR_ia32_process_vm_readv: u32 = 347;
pub const __NR_ia32_process_vm_writev: u32 = 348;
pub const __NR_ia32_kcmp: u32 = 349;
pub const __NR_ia32_finit_module: u32 = 350;
pub const __NR_ia32_sched_setattr: u32 = 351;
pub const __NR_ia32_sched_getattr: u32 = 352;
pub const __NR_ia32_renameat2: u32 = 353;
pub const __NR_ia32_seccomp: u32 = 354;
pub const __NR_ia32_getrandom: u32 = 355;
pub const __NR_ia32_memfd_create: u32 = 356;
pub const __NR_ia32_bpf: u32 = 357;
pub const __NR_ia32_execveat: u32 = 358;
pub const __NR_ia32_socket: u32 = 359;
pub const __NR_ia32_socketpair: u32 = 360;
pub const __NR_ia32_bind: u32 = 361;
pub const __NR_ia32_connect: u32 = 362;
pub const __NR_ia32_listen: u32 = 363;
pub const __NR_ia32_accept4: u32 = 364;
pub const __NR_ia32_getsockopt: u32 = 365;
pub const __NR_ia32_setsockopt: u32 = 366;
pub const __NR_ia32_getsockname: u32 = 367;
pub const __NR_ia32_getpeername: u32 = 368;
pub const __NR_ia32_sendto: u32 = 369;
pub const __NR_ia32_sendmsg: u32 = 370;
pub const __NR_ia32_recvfrom: u32 = 371;
pub const __NR_ia32_recvmsg: u32 = 372;
pub const __NR_ia32_shutdown: u32 = 373;
pub const __NR_ia32_userfaultfd: u32 = 374;
pub const __NR_ia32_membarrier: u32 = 375;
pub const __NR_ia32_mlock2: u32 = 376;
pub const __NR_ia32_copy_file_range: u32 = 377;
pub const __NR_ia32_preadv2: u32 = 378;
pub const __NR_ia32_pwritev2: u32 = 379;
pub const __NR_ia32_pkey_mprotect: u32 = 380;
pub const __NR_ia32_pkey_alloc: u32 = 381;
pub const __NR_ia32_pkey_free: u32 = 382;
pub const __NR_ia32_statx: u32 = 383;
pub const __NR_ia32_arch_prctl: u32 = 384;
pub const __NR_ia32_io_pgetevents: u32 = 385;
pub const __NR_ia32_rseq: u32 = 386;
pub const __NR_ia32_semget: u32 = 393;
pub const __NR_ia32_semctl: u32 = 394;
pub const __NR_ia32_shmget: u32 = 395;
pub const __NR_ia32_shmctl: u32 = 396;
pub const __NR_ia32_shmat: u32 = 397;
pub const __NR_ia32_shmdt: u32 = 398;
pub const __NR_ia32_msgget: u32 = 399;
pub const __NR_ia32_msgsnd: u32 = 400;
pub const __NR_ia32_msgrcv: u32 = 401;
pub const __NR_ia32_msgctl: u32 = 402;
pub const __NR_ia32_clock_gettime64: u32 = 403;
pub const __NR_ia32_clock_settime64: u32 = 404;
pub const __NR_ia32_clock_adjtime64: u32 = 405;
pub const __NR_ia32_clock_getres_time64: u32 = 406;
pub const __NR_ia32_clock_nanosleep_time64: u32 = 407;
pub const __NR_ia32_timer_gettime64: u32 = 408;
pub const __NR_ia32_timer_settime64: u32 = 409;
pub const __NR_ia32_timerfd_gettime64: u32 = 410;
pub const __NR_ia32_timerfd_settime64: u32 = 411;
pub const __NR_ia32_utimensat_time64: u32 = 412;
pub const __NR_ia32_pselect6_time64: u32 = 413;
pub const __NR_ia32_ppoll_time64: u32 = 414;
pub const __NR_ia32_io_pgetevents_time64: u32 = 416;
pub const __NR_ia32_recvmmsg_time64: u32 = 417;
pub const __NR_ia32_mq_timedsend_time64: u32 = 418;
pub const __NR_ia32_mq_timedreceive_time64: u32 = 419;
pub const __NR_ia32_semtimedop_time64: u32 = 420;
pub const __NR_ia32_rt_sigtimedwait_time64: u32 = 421;
pub const __NR_ia32_futex_time64: u32 = 422;
pub const __NR_ia32_sched_rr_get_interval_time64: u32 = 423;
pub const __NR_ia32_pidfd_send_signal: u32 = 424;
pub const __NR_ia32_io_uring_setup: u32 = 425;
pub const __NR_ia32_io_uring_enter: u32 = 426;
pub const __NR_ia32_io_uring_register: u32 = 427;
pub const __NR_ia32_open_tree: u32 = 428;
pub const __NR_ia32_move_mount: u32 = 429;
pub const __NR_ia32_fsopen: u32 = 430;
pub const __NR_ia32_fsconfig: u32 = 431;
pub const __NR_ia32_fsmount: u32 = 432;
pub const __NR_ia32_fspick: u32 = 433;
pub const __NR_ia32_pidfd_open: u32 = 434;
pub const __NR_ia32_clone3: u32 = 435;
pub const __NR_ia32_close_range: u32 = 436;
pub const __NR_ia32_openat2: u32 = 437;
pub const __NR_ia32_pidfd_getfd: u32 = 438;
pub const __NR_ia32_faccessat2: u32 = 439;
pub const __NR_ia32_process_madvise: u32 = 440;
pub const __NR_ia32_epoll_pwait2: u32 = 441;
pub const __NR_ia32_mount_setattr: u32 = 442;
pub const __NR_ia32_quotactl_fd: u32 = 443;
pub const __NR_ia32_landlock_create_ruleset: u32 = 444;
pub const __NR_ia32_landlock_add_rule: u32 = 445;
pub const __NR_ia32_landlock_restrict_self: u32 = 446;
pub const __NR_ia32_memfd_secret: u32 = 447;
pub const __NR_ia32_process_mrelease: u32 = 448;
pub const __NR_ia32_futex_waitv: u32 = 449;
pub const __NR_ia32_set_mempolicy_home_node: u32 = 450;
pub const __NR_ia32_cachestat: u32 = 451;
pub const __NR_ia32_fchmodat2: u32 = 452;
pub const __NR_ia32_map_shadow_stack: u32 = 453;
pub const __NR_ia32_futex_wake: u32 = 454;
pub const __NR_ia32_futex_wait: u32 = 455;
pub const __NR_ia32_futex_requeue: u32 = 456;
pub const __NR_ia32_statmount: u32 = 457;
pub const __NR_ia32_listmount: u32 = 458;
pub const __NR_ia32_lsm_get_self_attr: u32 = 459;
pub const __NR_ia32_lsm_set_self_attr: u32 = 460;
pub const __NR_ia32_lsm_list_modules: u32 = 461;
pub const __NR_ia32_mseal: u32 = 462;
pub const __NR_ia32_setxattrat: u32 = 463;
pub const __NR_ia32_getxattrat: u32 = 464;
pub const __NR_ia32_listxattrat: u32 = 465;
pub const __NR_ia32_removexattrat: u32 = 466;
pub const __NR_ia32_open_tree_attr: u32 = 467;
pub const __NR_ia32_file_getattr: u32 = 468;
pub const __NR_ia32_file_setattr: u32 = 469;
pub const __NR_ia32_syscalls: u32 = 470;
pub const X32_NR_syscalls: u32 = 548;
pub const IA32_NR_syscalls: u32 = 470;
pub const NR_syscalls: u32 = 470;
pub const ADFS_SUPER_MAGIC: u32 = 44533;
pub const AFFS_SUPER_MAGIC: u32 = 44543;
pub const AFS_SUPER_MAGIC: u32 = 1397113167;
pub const AUTOFS_SUPER_MAGIC: u32 = 391;
pub const CEPH_SUPER_MAGIC: u32 = 12805120;
pub const CODA_SUPER_MAGIC: u32 = 1937076805;
pub const CRAMFS_MAGIC: u32 = 684539205;
pub const CRAMFS_MAGIC_WEND: u32 = 1161678120;
pub const DEBUGFS_MAGIC: u32 = 1684170528;
pub const SECURITYFS_MAGIC: u32 = 1935894131;
pub const SELINUX_MAGIC: u32 = 4185718668;
pub const SMACK_MAGIC: u32 = 1128357203;
pub const RAMFS_MAGIC: u32 = 2240043254;
pub const TMPFS_MAGIC: u32 = 16914836;
pub const HUGETLBFS_MAGIC: u32 = 2508478710;
pub const SQUASHFS_MAGIC: u32 = 1936814952;
pub const ECRYPTFS_SUPER_MAGIC: u32 = 61791;
pub const EFS_SUPER_MAGIC: u32 = 4278867;
pub const EROFS_SUPER_MAGIC_V1: u32 = 3774210530;
pub const EXT2_SUPER_MAGIC: u32 = 61267;
pub const EXT3_SUPER_MAGIC: u32 = 61267;
pub const XENFS_SUPER_MAGIC: u32 = 2881100148;
pub const EXT4_SUPER_MAGIC: u32 = 61267;
pub const BTRFS_SUPER_MAGIC: u32 = 2435016766;
pub const NILFS_SUPER_MAGIC: u32 = 13364;
pub const F2FS_SUPER_MAGIC: u32 = 4076150800;
pub const HPFS_SUPER_MAGIC: u32 = 4187351113;
pub const ISOFS_SUPER_MAGIC: u32 = 38496;
pub const JFFS2_SUPER_MAGIC: u32 = 29366;
pub const XFS_SUPER_MAGIC: u32 = 1481003842;
pub const PSTOREFS_MAGIC: u32 = 1634035564;
pub const EFIVARFS_MAGIC: u32 = 3730735588;
pub const HOSTFS_SUPER_MAGIC: u32 = 12648430;
pub const OVERLAYFS_SUPER_MAGIC: u32 = 2035054128;
pub const FUSE_SUPER_MAGIC: u32 = 1702057286;
pub const BCACHEFS_SUPER_MAGIC: u32 = 3393526350;
pub const MINIX_SUPER_MAGIC: u32 = 4991;
pub const MINIX_SUPER_MAGIC2: u32 = 5007;
pub const MINIX2_SUPER_MAGIC: u32 = 9320;
pub const MINIX2_SUPER_MAGIC2: u32 = 9336;
pub const MINIX3_SUPER_MAGIC: u32 = 19802;
pub const MSDOS_SUPER_MAGIC: u32 = 19780;
pub const EXFAT_SUPER_MAGIC: u32 = 538032816;
pub const NCP_SUPER_MAGIC: u32 = 22092;
pub const NFS_SUPER_MAGIC: u32 = 26985;
pub const OCFS2_SUPER_MAGIC: u32 = 1952539503;
pub const OPENPROM_SUPER_MAGIC: u32 = 40865;
pub const QNX4_SUPER_MAGIC: u32 = 47;
pub const QNX6_SUPER_MAGIC: u32 = 1746473250;
pub const AFS_FS_MAGIC: u32 = 1799439955;
pub const REISERFS_SUPER_MAGIC: u32 = 1382369651;
pub const REISERFS_SUPER_MAGIC_STRING: &[u8; 9] = b"ReIsErFs\0";
pub const REISER2FS_SUPER_MAGIC_STRING: &[u8; 10] = b"ReIsEr2Fs\0";
pub const REISER2FS_JR_SUPER_MAGIC_STRING: &[u8; 10] = b"ReIsEr3Fs\0";
pub const SMB_SUPER_MAGIC: u32 = 20859;
pub const CIFS_SUPER_MAGIC: u32 = 4283649346;
pub const SMB2_SUPER_MAGIC: u32 = 4266872130;
pub const CGROUP_SUPER_MAGIC: u32 = 2613483;
pub const CGROUP2_SUPER_MAGIC: u32 = 1667723888;
pub const RDTGROUP_SUPER_MAGIC: u32 = 124082209;
pub const STACK_END_MAGIC: u32 = 1470918301;
pub const TRACEFS_MAGIC: u32 = 1953653091;
pub const V9FS_MAGIC: u32 = 16914839;
pub const BDEVFS_MAGIC: u32 = 1650746742;
pub const DAXFS_MAGIC: u32 = 1684300152;
pub const BINFMTFS_MAGIC: u32 = 1112100429;
pub const DEVPTS_SUPER_MAGIC: u32 = 7377;
pub const BINDERFS_SUPER_MAGIC: u32 = 1819242352;
pub const FUTEXFS_SUPER_MAGIC: u32 = 195894762;
pub const PIPEFS_MAGIC: u32 = 1346981957;
pub const PROC_SUPER_MAGIC: u32 = 40864;
pub const SOCKFS_MAGIC: u32 = 1397703499;
pub const SYSFS_MAGIC: u32 = 1650812274;
pub const USBDEVICE_SUPER_MAGIC: u32 = 40866;
pub const MTD_INODE_FS_MAGIC: u32 = 288389204;
pub const ANON_INODE_FS_MAGIC: u32 = 151263540;
pub const BTRFS_TEST_MAGIC: u32 = 1936880249;
pub const NSFS_MAGIC: u32 = 1853056627;
pub const BPF_FS_MAGIC: u32 = 3405662737;
pub const AAFS_MAGIC: u32 = 1513908720;
pub const ZONEFS_MAGIC: u32 = 1515144787;
pub const UDF_SUPER_MAGIC: u32 = 352400198;
pub const DMA_BUF_MAGIC: u32 = 1145913666;
pub const DEVMEM_MAGIC: u32 = 1162691661;
pub const SECRETMEM_MAGIC: u32 = 1397048141;
pub const PID_FS_MAGIC: u32 = 1346978886;
pub const COMPAT_USER_HZ: u32 = 100;
pub const COMPAT_RLIM_INFINITY: u32 = 4294967295;
pub const COMPAT_OFF_T_MAX: u32 = 2147483647;
pub const _COMPAT_NSIG: u32 = 64;
pub const _COMPAT_NSIG_BPW: u32 = 32;
pub const COMPAT_UTS_MACHINE: &[u8; 7] = b"i686\0\0\0";
pub const COMPAT_MINSIGSTKSZ: u32 = 2048;
pub const _COMPAT_NSIG_WORDS: u32 = 2;
pub const STAT64_HAS_BROKEN_ST_INO: u32 = 1;
pub const USER_XSTATE_FX_SW_WORDS: u32 = 6;
pub const USER_XSTATE_XCR0_WORD: u32 = 0;
pub const R_X86_64_NONE: u32 = 0;
pub const R_X86_64_64: u32 = 1;
pub const R_X86_64_PC32: u32 = 2;
pub const R_X86_64_GOT32: u32 = 3;
pub const R_X86_64_PLT32: u32 = 4;
pub const R_X86_64_COPY: u32 = 5;
pub const R_X86_64_GLOB_DAT: u32 = 6;
pub const R_X86_64_JUMP_SLOT: u32 = 7;
pub const R_X86_64_RELATIVE: u32 = 8;
pub const R_X86_64_GOTPCREL: u32 = 9;
pub const R_X86_64_GOTPCRELX: u32 = 41;
pub const R_X86_64_REX_GOTPCRELX: u32 = 42;
pub const R_X86_64_32: u32 = 10;
pub const R_X86_64_32S: u32 = 11;
pub const R_X86_64_16: u32 = 12;
pub const R_X86_64_PC16: u32 = 13;
pub const R_X86_64_8: u32 = 14;
pub const R_X86_64_PC8: u32 = 15;
pub const R_X86_64_PC64: u32 = 24;
pub const COMPAT_ELF_PLATFORM: &[u8; 5] = b"i686\0";
pub const ELF_PLATFORM: &[u8; 7] = b"x86_64\0";
pub const ELF_EXEC_PAGESIZE: u32 = 4096;
pub const AT_SYSINFO: u32 = 32;
pub const ARCH_HAS_SETUP_ADDITIONAL_PAGES: u32 = 1;
pub const EM_NONE: u32 = 0;
pub const EM_M32: u32 = 1;
pub const EM_SPARC: u32 = 2;
pub const EM_386: u32 = 3;
pub const EM_68K: u32 = 4;
pub const EM_88K: u32 = 5;
pub const EM_486: u32 = 6;
pub const EM_860: u32 = 7;
pub const EM_MIPS: u32 = 8;
pub const EM_MIPS_RS3_LE: u32 = 10;
pub const EM_MIPS_RS4_BE: u32 = 10;
pub const EM_PARISC: u32 = 15;
pub const EM_SPARC32PLUS: u32 = 18;
pub const EM_PPC: u32 = 20;
pub const EM_PPC64: u32 = 21;
pub const EM_SPU: u32 = 23;
pub const EM_ARM: u32 = 40;
pub const EM_SH: u32 = 42;
pub const EM_SPARCV9: u32 = 43;
pub const EM_H8_300: u32 = 46;
pub const EM_IA_64: u32 = 50;
pub const EM_X86_64: u32 = 62;
pub const EM_S390: u32 = 22;
pub const EM_CRIS: u32 = 76;
pub const EM_M32R: u32 = 88;
pub const EM_MN10300: u32 = 89;
pub const EM_OPENRISC: u32 = 92;
pub const EM_ARCOMPACT: u32 = 93;
pub const EM_XTENSA: u32 = 94;
pub const EM_BLACKFIN: u32 = 106;
pub const EM_UNICORE: u32 = 110;
pub const EM_ALTERA_NIOS2: u32 = 113;
pub const EM_TI_C6000: u32 = 140;
pub const EM_HEXAGON: u32 = 164;
pub const EM_NDS32: u32 = 167;
pub const EM_AARCH64: u32 = 183;
pub const EM_TILEPRO: u32 = 188;
pub const EM_MICROBLAZE: u32 = 189;
pub const EM_TILEGX: u32 = 191;
pub const EM_ARCV2: u32 = 195;
pub const EM_RISCV: u32 = 243;
pub const EM_BPF: u32 = 247;
pub const EM_CSKY: u32 = 252;
pub const EM_LOONGARCH: u32 = 258;
pub const EM_FRV: u32 = 21569;
pub const EM_ALPHA: u32 = 36902;
pub const EM_CYGNUS_M32R: u32 = 36929;
pub const EM_S390_OLD: u32 = 41872;
pub const EM_CYGNUS_MN10300: u32 = 48879;
pub const PT_NULL: u32 = 0;
pub const PT_LOAD: u32 = 1;
pub const PT_DYNAMIC: u32 = 2;
pub const PT_INTERP: u32 = 3;
pub const PT_NOTE: u32 = 4;
pub const PT_SHLIB: u32 = 5;
pub const PT_PHDR: u32 = 6;
pub const PT_TLS: u32 = 7;
pub const PT_LOOS: u32 = 1610612736;
pub const PT_HIOS: u32 = 1879048191;
pub const PT_LOPROC: u32 = 1879048192;
pub const PT_HIPROC: u32 = 2147483647;
pub const PT_GNU_EH_FRAME: u32 = 1685382480;
pub const PT_GNU_STACK: u32 = 1685382481;
pub const PT_GNU_RELRO: u32 = 1685382482;
pub const PT_GNU_PROPERTY: u32 = 1685382483;
pub const PT_AARCH64_MEMTAG_MTE: u32 = 1879048194;
pub const PN_XNUM: u32 = 65535;
pub const ET_NONE: u32 = 0;
pub const ET_REL: u32 = 1;
pub const ET_EXEC: u32 = 2;
pub const ET_DYN: u32 = 3;
pub const ET_CORE: u32 = 4;
pub const ET_LOPROC: u32 = 65280;
pub const ET_HIPROC: u32 = 65535;
pub const DT_NULL: u32 = 0;
pub const DT_NEEDED: u32 = 1;
pub const DT_PLTRELSZ: u32 = 2;
pub const DT_PLTGOT: u32 = 3;
pub const DT_HASH: u32 = 4;
pub const DT_STRTAB: u32 = 5;
pub const DT_SYMTAB: u32 = 6;
pub const DT_RELA: u32 = 7;
pub const DT_RELASZ: u32 = 8;
pub const DT_RELAENT: u32 = 9;
pub const DT_STRSZ: u32 = 10;
pub const DT_SYMENT: u32 = 11;
pub const DT_INIT: u32 = 12;
pub const DT_FINI: u32 = 13;
pub const DT_SONAME: u32 = 14;
pub const DT_RPATH: u32 = 15;
pub const DT_SYMBOLIC: u32 = 16;
pub const DT_REL: u32 = 17;
pub const DT_RELSZ: u32 = 18;
pub const DT_RELENT: u32 = 19;
pub const DT_PLTREL: u32 = 20;
pub const DT_DEBUG: u32 = 21;
pub const DT_TEXTREL: u32 = 22;
pub const DT_JMPREL: u32 = 23;
pub const DT_ENCODING: u32 = 32;
pub const OLD_DT_LOOS: u32 = 1610612736;
pub const DT_LOOS: u32 = 1610612749;
pub const DT_HIOS: u32 = 1879044096;
pub const DT_VALRNGLO: u32 = 1879047424;
pub const DT_VALRNGHI: u32 = 1879047679;
pub const DT_ADDRRNGLO: u32 = 1879047680;
pub const DT_GNU_HASH: u32 = 1879047925;
pub const DT_ADDRRNGHI: u32 = 1879047935;
pub const DT_VERSYM: u32 = 1879048176;
pub const DT_RELACOUNT: u32 = 1879048185;
pub const DT_RELCOUNT: u32 = 1879048186;
pub const DT_FLAGS_1: u32 = 1879048187;
pub const DT_VERDEF: u32 = 1879048188;
pub const DT_VERDEFNUM: u32 = 1879048189;
pub const DT_VERNEED: u32 = 1879048190;
pub const DT_VERNEEDNUM: u32 = 1879048191;
pub const OLD_DT_HIOS: u32 = 1879048191;
pub const DT_LOPROC: u32 = 1879048192;
pub const DT_HIPROC: u32 = 2147483647;
pub const STB_LOCAL: u32 = 0;
pub const STB_GLOBAL: u32 = 1;
pub const STB_WEAK: u32 = 2;
pub const STN_UNDEF: u32 = 0;
pub const STT_NOTYPE: u32 = 0;
pub const STT_OBJECT: u32 = 1;
pub const STT_FUNC: u32 = 2;
pub const STT_SECTION: u32 = 3;
pub const STT_FILE: u32 = 4;
pub const STT_COMMON: u32 = 5;
pub const STT_TLS: u32 = 6;
pub const VER_FLG_BASE: u32 = 1;
pub const VER_FLG_WEAK: u32 = 2;
pub const EI_NIDENT: u32 = 16;
pub const PF_R: u32 = 4;
pub const PF_W: u32 = 2;
pub const PF_X: u32 = 1;
pub const SHT_NULL: u32 = 0;
pub const SHT_PROGBITS: u32 = 1;
pub const SHT_SYMTAB: u32 = 2;
pub const SHT_STRTAB: u32 = 3;
pub const SHT_RELA: u32 = 4;
pub const SHT_HASH: u32 = 5;
pub const SHT_DYNAMIC: u32 = 6;
pub const SHT_NOTE: u32 = 7;
pub const SHT_NOBITS: u32 = 8;
pub const SHT_REL: u32 = 9;
pub const SHT_SHLIB: u32 = 10;
pub const SHT_DYNSYM: u32 = 11;
pub const SHT_NUM: u32 = 12;
pub const SHT_LOPROC: u32 = 1879048192;
pub const SHT_HIPROC: u32 = 2147483647;
pub const SHT_LOUSER: u32 = 2147483648;
pub const SHT_HIUSER: u32 = 4294967295;
pub const SHF_WRITE: u32 = 1;
pub const SHF_ALLOC: u32 = 2;
pub const SHF_EXECINSTR: u32 = 4;
pub const SHF_MERGE: u32 = 16;
pub const SHF_STRINGS: u32 = 32;
pub const SHF_INFO_LINK: u32 = 64;
pub const SHF_LINK_ORDER: u32 = 128;
pub const SHF_OS_NONCONFORMING: u32 = 256;
pub const SHF_GROUP: u32 = 512;
pub const SHF_TLS: u32 = 1024;
pub const SHF_RELA_LIVEPATCH: u32 = 1048576;
pub const SHF_RO_AFTER_INIT: u32 = 2097152;
pub const SHF_ORDERED: u32 = 67108864;
pub const SHF_EXCLUDE: u32 = 134217728;
pub const SHF_MASKOS: u32 = 267386880;
pub const SHF_MASKPROC: u32 = 4026531840;
pub const SHN_UNDEF: u32 = 0;
pub const SHN_LORESERVE: u32 = 65280;
pub const SHN_LOPROC: u32 = 65280;
pub const SHN_HIPROC: u32 = 65311;
pub const SHN_LIVEPATCH: u32 = 65312;
pub const SHN_ABS: u32 = 65521;
pub const SHN_COMMON: u32 = 65522;
pub const SHN_HIRESERVE: u32 = 65535;
pub const EI_MAG0: u32 = 0;
pub const EI_MAG1: u32 = 1;
pub const EI_MAG2: u32 = 2;
pub const EI_MAG3: u32 = 3;
pub const EI_CLASS: u32 = 4;
pub const EI_DATA: u32 = 5;
pub const EI_VERSION: u32 = 6;
pub const EI_OSABI: u32 = 7;
pub const EI_PAD: u32 = 8;
pub const ELFMAG0: u32 = 127;
pub const ELFMAG1: u8 = 69u8;
pub const ELFMAG2: u8 = 76u8;
pub const ELFMAG3: u8 = 70u8;
pub const ELFMAG: &[u8; 5] = b"\x7FELF\0";
pub const SELFMAG: u32 = 4;
pub const ELFCLASSNONE: u32 = 0;
pub const ELFCLASS32: u32 = 1;
pub const ELFCLASS64: u32 = 2;
pub const ELFCLASSNUM: u32 = 3;
pub const ELFDATANONE: u32 = 0;
pub const ELFDATA2LSB: u32 = 1;
pub const ELFDATA2MSB: u32 = 2;
pub const EV_NONE: u32 = 0;
pub const EV_CURRENT: u32 = 1;
pub const EV_NUM: u32 = 2;
pub const ELFOSABI_NONE: u32 = 0;
pub const ELFOSABI_LINUX: u32 = 3;
pub const ELF_OSABI: u32 = 0;
pub const NN_GNU_PROPERTY_TYPE_0: &[u8; 4] = b"GNU\0";
pub const NT_GNU_PROPERTY_TYPE_0: u32 = 5;
pub const NN_PRSTATUS: &[u8; 5] = b"CORE\0";
pub const NT_PRSTATUS: u32 = 1;
pub const NN_PRFPREG: &[u8; 5] = b"CORE\0";
pub const NT_PRFPREG: u32 = 2;
pub const NN_PRPSINFO: &[u8; 5] = b"CORE\0";
pub const NT_PRPSINFO: u32 = 3;
pub const NN_TASKSTRUCT: &[u8; 5] = b"CORE\0";
pub const NT_TASKSTRUCT: u32 = 4;
pub const NN_AUXV: &[u8; 5] = b"CORE\0";
pub const NT_AUXV: u32 = 6;
pub const NN_SIGINFO: &[u8; 5] = b"CORE\0";
pub const NT_SIGINFO: u32 = 1397311305;
pub const NN_FILE: &[u8; 5] = b"CORE\0";
pub const NT_FILE: u32 = 1179208773;
pub const NN_PRXFPREG: &[u8; 6] = b"LINUX\0";
pub const NT_PRXFPREG: u32 = 1189489535;
pub const NN_PPC_VMX: &[u8; 6] = b"LINUX\0";
pub const NT_PPC_VMX: u32 = 256;
pub const NN_PPC_SPE: &[u8; 6] = b"LINUX\0";
pub const NT_PPC_SPE: u32 = 257;
pub const NN_PPC_VSX: &[u8; 6] = b"LINUX\0";
pub const NT_PPC_VSX: u32 = 258;
pub const NN_PPC_TAR: &[u8; 6] = b"LINUX\0";
pub const NT_PPC_TAR: u32 = 259;
pub const NN_PPC_PPR: &[u8; 6] = b"LINUX\0";
pub const NT_PPC_PPR: u32 = 260;
pub const NN_PPC_DSCR: &[u8; 6] = b"LINUX\0";
pub const NT_PPC_DSCR: u32 = 261;
pub const NN_PPC_EBB: &[u8; 6] = b"LINUX\0";
pub const NT_PPC_EBB: u32 = 262;
pub const NN_PPC_PMU: &[u8; 6] = b"LINUX\0";
pub const NT_PPC_PMU: u32 = 263;
pub const NN_PPC_TM_CGPR: &[u8; 6] = b"LINUX\0";
pub const NT_PPC_TM_CGPR: u32 = 264;
pub const NN_PPC_TM_CFPR: &[u8; 6] = b"LINUX\0";
pub const NT_PPC_TM_CFPR: u32 = 265;
pub const NN_PPC_TM_CVMX: &[u8; 6] = b"LINUX\0";
pub const NT_PPC_TM_CVMX: u32 = 266;
pub const NN_PPC_TM_CVSX: &[u8; 6] = b"LINUX\0";
pub const NT_PPC_TM_CVSX: u32 = 267;
pub const NN_PPC_TM_SPR: &[u8; 6] = b"LINUX\0";
pub const NT_PPC_TM_SPR: u32 = 268;
pub const NN_PPC_TM_CTAR: &[u8; 6] = b"LINUX\0";
pub const NT_PPC_TM_CTAR: u32 = 269;
pub const NN_PPC_TM_CPPR: &[u8; 6] = b"LINUX\0";
pub const NT_PPC_TM_CPPR: u32 = 270;
pub const NN_PPC_TM_CDSCR: &[u8; 6] = b"LINUX\0";
pub const NT_PPC_TM_CDSCR: u32 = 271;
pub const NN_PPC_PKEY: &[u8; 6] = b"LINUX\0";
pub const NT_PPC_PKEY: u32 = 272;
pub const NN_PPC_DEXCR: &[u8; 6] = b"LINUX\0";
pub const NT_PPC_DEXCR: u32 = 273;
pub const NN_PPC_HASHKEYR: &[u8; 6] = b"LINUX\0";
pub const NT_PPC_HASHKEYR: u32 = 274;
pub const NN_386_TLS: &[u8; 6] = b"LINUX\0";
pub const NT_386_TLS: u32 = 512;
pub const NN_386_IOPERM: &[u8; 6] = b"LINUX\0";
pub const NT_386_IOPERM: u32 = 513;
pub const NN_X86_XSTATE: &[u8; 6] = b"LINUX\0";
pub const NT_X86_XSTATE: u32 = 514;
pub const NN_X86_SHSTK: &[u8; 6] = b"LINUX\0";
pub const NT_X86_SHSTK: u32 = 516;
pub const NN_X86_XSAVE_LAYOUT: &[u8; 6] = b"LINUX\0";
pub const NT_X86_XSAVE_LAYOUT: u32 = 517;
pub const NN_S390_HIGH_GPRS: &[u8; 6] = b"LINUX\0";
pub const NT_S390_HIGH_GPRS: u32 = 768;
pub const NN_S390_TIMER: &[u8; 6] = b"LINUX\0";
pub const NT_S390_TIMER: u32 = 769;
pub const NN_S390_TODCMP: &[u8; 6] = b"LINUX\0";
pub const NT_S390_TODCMP: u32 = 770;
pub const NN_S390_TODPREG: &[u8; 6] = b"LINUX\0";
pub const NT_S390_TODPREG: u32 = 771;
pub const NN_S390_CTRS: &[u8; 6] = b"LINUX\0";
pub const NT_S390_CTRS: u32 = 772;
pub const NN_S390_PREFIX: &[u8; 6] = b"LINUX\0";
pub const NT_S390_PREFIX: u32 = 773;
pub const NN_S390_LAST_BREAK: &[u8; 6] = b"LINUX\0";
pub const NT_S390_LAST_BREAK: u32 = 774;
pub const NN_S390_SYSTEM_CALL: &[u8; 6] = b"LINUX\0";
pub const NT_S390_SYSTEM_CALL: u32 = 775;
pub const NN_S390_TDB: &[u8; 6] = b"LINUX\0";
pub const NT_S390_TDB: u32 = 776;
pub const NN_S390_VXRS_LOW: &[u8; 6] = b"LINUX\0";
pub const NT_S390_VXRS_LOW: u32 = 777;
pub const NN_S390_VXRS_HIGH: &[u8; 6] = b"LINUX\0";
pub const NT_S390_VXRS_HIGH: u32 = 778;
pub const NN_S390_GS_CB: &[u8; 6] = b"LINUX\0";
pub const NT_S390_GS_CB: u32 = 779;
pub const NN_S390_GS_BC: &[u8; 6] = b"LINUX\0";
pub const NT_S390_GS_BC: u32 = 780;
pub const NN_S390_RI_CB: &[u8; 6] = b"LINUX\0";
pub const NT_S390_RI_CB: u32 = 781;
pub const NN_S390_PV_CPU_DATA: &[u8; 6] = b"LINUX\0";
pub const NT_S390_PV_CPU_DATA: u32 = 782;
pub const NN_ARM_VFP: &[u8; 6] = b"LINUX\0";
pub const NT_ARM_VFP: u32 = 1024;
pub const NN_ARM_TLS: &[u8; 6] = b"LINUX\0";
pub const NT_ARM_TLS: u32 = 1025;
pub const NN_ARM_HW_BREAK: &[u8; 6] = b"LINUX\0";
pub const NT_ARM_HW_BREAK: u32 = 1026;
pub const NN_ARM_HW_WATCH: &[u8; 6] = b"LINUX\0";
pub const NT_ARM_HW_WATCH: u32 = 1027;
pub const NN_ARM_SYSTEM_CALL: &[u8; 6] = b"LINUX\0";
pub const NT_ARM_SYSTEM_CALL: u32 = 1028;
pub const NN_ARM_SVE: &[u8; 6] = b"LINUX\0";
pub const NT_ARM_SVE: u32 = 1029;
pub const NN_ARM_PAC_MASK: &[u8; 6] = b"LINUX\0";
pub const NT_ARM_PAC_MASK: u32 = 1030;
pub const NN_ARM_PACA_KEYS: &[u8; 6] = b"LINUX\0";
pub const NT_ARM_PACA_KEYS: u32 = 1031;
pub const NN_ARM_PACG_KEYS: &[u8; 6] = b"LINUX\0";
pub const NT_ARM_PACG_KEYS: u32 = 1032;
pub const NN_ARM_TAGGED_ADDR_CTRL: &[u8; 6] = b"LINUX\0";
pub const NT_ARM_TAGGED_ADDR_CTRL: u32 = 1033;
pub const NN_ARM_PAC_ENABLED_KEYS: &[u8; 6] = b"LINUX\0";
pub const NT_ARM_PAC_ENABLED_KEYS: u32 = 1034;
pub const NN_ARM_SSVE: &[u8; 6] = b"LINUX\0";
pub const NT_ARM_SSVE: u32 = 1035;
pub const NN_ARM_ZA: &[u8; 6] = b"LINUX\0";
pub const NT_ARM_ZA: u32 = 1036;
pub const NN_ARM_ZT: &[u8; 6] = b"LINUX\0";
pub const NT_ARM_ZT: u32 = 1037;
pub const NN_ARM_FPMR: &[u8; 6] = b"LINUX\0";
pub const NT_ARM_FPMR: u32 = 1038;
pub const NN_ARM_POE: &[u8; 6] = b"LINUX\0";
pub const NT_ARM_POE: u32 = 1039;
pub const NN_ARM_GCS: &[u8; 6] = b"LINUX\0";
pub const NT_ARM_GCS: u32 = 1040;
pub const NN_ARC_V2: &[u8; 6] = b"LINUX\0";
pub const NT_ARC_V2: u32 = 1536;
pub const NN_VMCOREDD: &[u8; 6] = b"LINUX\0";
pub const NT_VMCOREDD: u32 = 1792;
pub const NN_MIPS_DSP: &[u8; 6] = b"LINUX\0";
pub const NT_MIPS_DSP: u32 = 2048;
pub const NN_MIPS_FP_MODE: &[u8; 6] = b"LINUX\0";
pub const NT_MIPS_FP_MODE: u32 = 2049;
pub const NN_MIPS_MSA: &[u8; 6] = b"LINUX\0";
pub const NT_MIPS_MSA: u32 = 2050;
pub const NN_RISCV_CSR: &[u8; 6] = b"LINUX\0";
pub const NT_RISCV_CSR: u32 = 2304;
pub const NN_RISCV_VECTOR: &[u8; 6] = b"LINUX\0";
pub const NT_RISCV_VECTOR: u32 = 2305;
pub const NN_RISCV_TAGGED_ADDR_CTRL: &[u8; 6] = b"LINUX\0";
pub const NT_RISCV_TAGGED_ADDR_CTRL: u32 = 2306;
pub const NN_LOONGARCH_CPUCFG: &[u8; 6] = b"LINUX\0";
pub const NT_LOONGARCH_CPUCFG: u32 = 2560;
pub const NN_LOONGARCH_CSR: &[u8; 6] = b"LINUX\0";
pub const NT_LOONGARCH_CSR: u32 = 2561;
pub const NN_LOONGARCH_LSX: &[u8; 6] = b"LINUX\0";
pub const NT_LOONGARCH_LSX: u32 = 2562;
pub const NN_LOONGARCH_LASX: &[u8; 6] = b"LINUX\0";
pub const NT_LOONGARCH_LASX: u32 = 2563;
pub const NN_LOONGARCH_LBT: &[u8; 6] = b"LINUX\0";
pub const NT_LOONGARCH_LBT: u32 = 2564;
pub const NN_LOONGARCH_HW_BREAK: &[u8; 6] = b"LINUX\0";
pub const NT_LOONGARCH_HW_BREAK: u32 = 2565;
pub const NN_LOONGARCH_HW_WATCH: &[u8; 6] = b"LINUX\0";
pub const NT_LOONGARCH_HW_WATCH: u32 = 2566;
pub const GNU_PROPERTY_AARCH64_FEATURE_1_AND: u32 = 3221225472;
pub const GNU_PROPERTY_AARCH64_FEATURE_1_BTI: u32 = 1;
pub const ELF32_GNU_PROPERTY_ALIGN: u32 = 4;
pub const ELF64_GNU_PROPERTY_ALIGN: u32 = 8;
pub const ELF_GNU_PROPERTY_ALIGN: u32 = 8;
pub const PCI_ANY_ID: i32 = -1;
pub const IEEE1394_MATCH_VENDOR_ID: u32 = 1;
pub const IEEE1394_MATCH_MODEL_ID: u32 = 2;
pub const IEEE1394_MATCH_SPECIFIER_ID: u32 = 4;
pub const IEEE1394_MATCH_VERSION: u32 = 8;
pub const USB_DEVICE_ID_MATCH_VENDOR: u32 = 1;
pub const USB_DEVICE_ID_MATCH_PRODUCT: u32 = 2;
pub const USB_DEVICE_ID_MATCH_DEV_LO: u32 = 4;
pub const USB_DEVICE_ID_MATCH_DEV_HI: u32 = 8;
pub const USB_DEVICE_ID_MATCH_DEV_CLASS: u32 = 16;
pub const USB_DEVICE_ID_MATCH_DEV_SUBCLASS: u32 = 32;
pub const USB_DEVICE_ID_MATCH_DEV_PROTOCOL: u32 = 64;
pub const USB_DEVICE_ID_MATCH_INT_CLASS: u32 = 128;
pub const USB_DEVICE_ID_MATCH_INT_SUBCLASS: u32 = 256;
pub const USB_DEVICE_ID_MATCH_INT_PROTOCOL: u32 = 512;
pub const USB_DEVICE_ID_MATCH_INT_NUMBER: u32 = 1024;
pub const HID_ANY_ID: i32 = -1;
pub const HID_BUS_ANY: u32 = 65535;
pub const HID_GROUP_ANY: u32 = 0;
pub const CCW_DEVICE_ID_MATCH_CU_TYPE: u32 = 1;
pub const CCW_DEVICE_ID_MATCH_CU_MODEL: u32 = 2;
pub const CCW_DEVICE_ID_MATCH_DEVICE_TYPE: u32 = 4;
pub const CCW_DEVICE_ID_MATCH_DEVICE_MODEL: u32 = 8;
pub const AP_DEVICE_ID_MATCH_CARD_TYPE: u32 = 1;
pub const AP_DEVICE_ID_MATCH_QUEUE_TYPE: u32 = 2;
pub const ACPI_ID_LEN: u32 = 16;
pub const PNP_ID_LEN: u32 = 8;
pub const PNP_MAX_DEVICES: u32 = 8;
pub const SERIO_ANY: u32 = 255;
pub const PCMCIA_DEV_ID_MATCH_MANF_ID: u32 = 1;
pub const PCMCIA_DEV_ID_MATCH_CARD_ID: u32 = 2;
pub const PCMCIA_DEV_ID_MATCH_FUNC_ID: u32 = 4;
pub const PCMCIA_DEV_ID_MATCH_FUNCTION: u32 = 8;
pub const PCMCIA_DEV_ID_MATCH_PROD_ID1: u32 = 16;
pub const PCMCIA_DEV_ID_MATCH_PROD_ID2: u32 = 32;
pub const PCMCIA_DEV_ID_MATCH_PROD_ID3: u32 = 64;
pub const PCMCIA_DEV_ID_MATCH_PROD_ID4: u32 = 128;
pub const PCMCIA_DEV_ID_MATCH_DEVICE_NO: u32 = 256;
pub const PCMCIA_DEV_ID_MATCH_FAKE_CIS: u32 = 512;
pub const PCMCIA_DEV_ID_MATCH_ANONYMOUS: u32 = 1024;
pub const INPUT_DEVICE_ID_EV_MAX: u32 = 31;
pub const INPUT_DEVICE_ID_KEY_MIN_INTERESTING: u32 = 113;
pub const INPUT_DEVICE_ID_KEY_MAX: u32 = 767;
pub const INPUT_DEVICE_ID_REL_MAX: u32 = 15;
pub const INPUT_DEVICE_ID_ABS_MAX: u32 = 63;
pub const INPUT_DEVICE_ID_MSC_MAX: u32 = 7;
pub const INPUT_DEVICE_ID_LED_MAX: u32 = 15;
pub const INPUT_DEVICE_ID_SND_MAX: u32 = 7;
pub const INPUT_DEVICE_ID_FF_MAX: u32 = 127;
pub const INPUT_DEVICE_ID_SW_MAX: u32 = 17;
pub const INPUT_DEVICE_ID_PROP_MAX: u32 = 31;
pub const INPUT_DEVICE_ID_MATCH_BUS: u32 = 1;
pub const INPUT_DEVICE_ID_MATCH_VENDOR: u32 = 2;
pub const INPUT_DEVICE_ID_MATCH_PRODUCT: u32 = 4;
pub const INPUT_DEVICE_ID_MATCH_VERSION: u32 = 8;
pub const INPUT_DEVICE_ID_MATCH_EVBIT: u32 = 16;
pub const INPUT_DEVICE_ID_MATCH_KEYBIT: u32 = 32;
pub const INPUT_DEVICE_ID_MATCH_RELBIT: u32 = 64;
pub const INPUT_DEVICE_ID_MATCH_ABSBIT: u32 = 128;
pub const INPUT_DEVICE_ID_MATCH_MSCIT: u32 = 256;
pub const INPUT_DEVICE_ID_MATCH_LEDBIT: u32 = 512;
pub const INPUT_DEVICE_ID_MATCH_SNDBIT: u32 = 1024;
pub const INPUT_DEVICE_ID_MATCH_FFBIT: u32 = 2048;
pub const INPUT_DEVICE_ID_MATCH_SWBIT: u32 = 4096;
pub const INPUT_DEVICE_ID_MATCH_PROPBIT: u32 = 8192;
pub const EISA_SIG_LEN: u32 = 8;
pub const EISA_DEVICE_MODALIAS_FMT: &[u8; 9] = b"eisa:s%s\0";
pub const PA_HWTYPE_ANY_ID: u32 = 255;
pub const PA_HVERSION_REV_ANY_ID: u32 = 255;
pub const PA_HVERSION_ANY_ID: u32 = 65535;
pub const PA_SVERSION_ANY_ID: u32 = 4294967295;
pub const SDIO_ANY_ID: i32 = -1;
pub const SSB_ANY_VENDOR: u32 = 65535;
pub const SSB_ANY_ID: u32 = 65535;
pub const SSB_ANY_REV: u32 = 255;
pub const BCMA_ANY_MANUF: u32 = 65535;
pub const BCMA_ANY_ID: u32 = 65535;
pub const BCMA_ANY_REV: u32 = 255;
pub const BCMA_ANY_CLASS: u32 = 255;
pub const VIRTIO_DEV_ANY_ID: u32 = 4294967295;
pub const RPMSG_NAME_SIZE: u32 = 32;
pub const RPMSG_DEVICE_MODALIAS_FMT: &[u8; 9] = b"rpmsg:%s\0";
pub const I2C_NAME_SIZE: u32 = 20;
pub const I2C_MODULE_PREFIX: &[u8; 5] = b"i2c:\0";
pub const PCI_EPF_NAME_SIZE: u32 = 20;
pub const PCI_EPF_MODULE_PREFIX: &[u8; 9] = b"pci_epf:\0";
pub const I3C_MATCH_DCR: u32 = 1;
pub const I3C_MATCH_MANUF: u32 = 2;
pub const I3C_MATCH_PART: u32 = 4;
pub const I3C_MATCH_EXTRA_INFO: u32 = 8;
pub const SPI_NAME_SIZE: u32 = 32;
pub const SPI_MODULE_PREFIX: &[u8; 5] = b"spi:\0";
pub const SLIMBUS_NAME_SIZE: u32 = 32;
pub const SLIMBUS_MODULE_PREFIX: &[u8; 6] = b"slim:\0";
pub const APR_NAME_SIZE: u32 = 32;
pub const APR_MODULE_PREFIX: &[u8; 5] = b"apr:\0";
pub const SPMI_NAME_SIZE: u32 = 32;
pub const SPMI_MODULE_PREFIX: &[u8; 6] = b"spmi:\0";
pub const PLATFORM_NAME_SIZE: u32 = 24;
pub const PLATFORM_MODULE_PREFIX: &[u8; 10] = b"platform:\0";
pub const MDIO_NAME_SIZE: u32 = 32;
pub const MDIO_MODULE_PREFIX: &[u8; 6] = b"mdio:\0";
pub const MDIO_ID_FMT: &[u8; 65] =
    b"%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u\0";
pub const ZORRO_WILDCARD: u32 = 4294967295;
pub const ZORRO_DEVICE_MODALIAS_FMT: &[u8; 12] = b"zorro:i%08X\0";
pub const ISAPNP_ANY_ID: u32 = 65535;
pub const X86_VENDOR_ANY: u32 = 65535;
pub const X86_FAMILY_ANY: u32 = 0;
pub const X86_MODEL_ANY: u32 = 0;
pub const X86_STEPPING_ANY: u32 = 0;
pub const X86_STEP_MIN: u32 = 0;
pub const X86_STEP_MAX: u32 = 15;
pub const X86_FEATURE_ANY: u32 = 0;
pub const X86_CPU_TYPE_ANY: u32 = 0;
pub const IPACK_ANY_FORMAT: u32 = 255;
pub const IPACK_ANY_ID: i32 = -1;
pub const MEI_CL_MODULE_PREFIX: &[u8; 5] = b"mei:\0";
pub const MEI_CL_NAME_SIZE: u32 = 32;
pub const MEI_CL_VERSION_ANY: u32 = 255;
pub const RIO_ANY_ID: u32 = 65535;
pub const TBSVC_MATCH_PROTOCOL_KEY: u32 = 1;
pub const TBSVC_MATCH_PROTOCOL_ID: u32 = 2;
pub const TBSVC_MATCH_PROTOCOL_VERSION: u32 = 4;
pub const TBSVC_MATCH_PROTOCOL_REVISION: u32 = 8;
pub const TYPEC_ANY_MODE: u32 = 7;
pub const WMI_MODULE_PREFIX: &[u8; 5] = b"wmi:\0";
pub const MHI_DEVICE_MODALIAS_FMT: &[u8; 7] = b"mhi:%s\0";
pub const MHI_NAME_SIZE: u32 = 32;
pub const MHI_EP_DEVICE_MODALIAS_FMT: &[u8; 10] = b"mhi_ep:%s\0";
pub const AUXILIARY_NAME_SIZE: u32 = 32;
pub const AUXILIARY_MODULE_PREFIX: &[u8; 11] = b"auxiliary:\0";
pub const SSAM_MATCH_TARGET: u32 = 1;
pub const SSAM_MATCH_INSTANCE: u32 = 2;
pub const SSAM_MATCH_FUNCTION: u32 = 4;
pub const ISHTP_MODULE_PREFIX: &[u8; 7] = b"ishtp:\0";
pub const CDX_ANY_ID: u32 = 65535;
pub const SWNODE_GRAPH_PORT_NAME_FMT: &[u8; 8] = b"port@%u\0";
pub const SWNODE_GRAPH_ENDPOINT_NAME_FMT: &[u8; 12] = b"endpoint@%u\0";
pub const NR_FWNODE_REFERENCE_ARGS: u32 = 16;
pub const NODE_ADDING_FIRST_MEMORY: u32 = 1;
pub const NODE_ADDED_FIRST_MEMORY: u32 = 2;
pub const NODE_CANCEL_ADDING_FIRST_MEMORY: u32 = 4;
pub const NODE_REMOVING_LAST_MEMORY: u32 = 8;
pub const NODE_REMOVED_LAST_MEMORY: u32 = 16;
pub const NODE_CANCEL_REMOVING_LAST_MEMORY: u32 = 32;
pub const ACPI_BINARY_SEMAPHORE: u32 = 0;
pub const ACPI_OSL_MUTEX: u32 = 1;
pub const DEBUGGER_SINGLE_THREADED: u32 = 0;
pub const DEBUGGER_MULTI_THREADED: u32 = 1;
pub const ACPI_SRC_OS_LF_ONLY: u32 = 0;
pub const COMPILER_VA_MACRO: u32 = 1;
pub const _U: u32 = 1;
pub const _L: u32 = 2;
pub const _D: u32 = 4;
pub const _C: u32 = 8;
pub const _P: u32 = 16;
pub const _S: u32 = 32;
pub const _X: u32 = 64;
pub const _SP: u32 = 128;
pub const ACPI_MACHINE_WIDTH: u32 = 64;
pub const ACPI_MSG_ERROR: &[u8; 15] = b"\x013ACPI Error: \0";
pub const ACPI_MSG_EXCEPTION: &[u8; 19] = b"\x013ACPI Exception: \0";
pub const ACPI_MSG_WARNING: &[u8; 17] = b"\x014ACPI Warning: \0";
pub const ACPI_MSG_INFO: &[u8; 9] = b"\x016ACPI: \0";
pub const ACPI_MSG_BIOS_ERROR: &[u8; 26] = b"\x013ACPI BIOS Error (bug): \0";
pub const ACPI_MSG_BIOS_WARNING: &[u8; 28] = b"\x014ACPI BIOS Warning (bug): \0";
pub const ACPI_MUTEX_TYPE: u32 = 0;
pub const DEBUGGER_THREADING: u32 = 1;
pub const METHOD_NAME__ADR: &[u8; 5] = b"_ADR\0";
pub const METHOD_NAME__AEI: &[u8; 5] = b"_AEI\0";
pub const METHOD_NAME__BBN: &[u8; 5] = b"_BBN\0";
pub const METHOD_NAME__CBA: &[u8; 5] = b"_CBA\0";
pub const METHOD_NAME__CID: &[u8; 5] = b"_CID\0";
pub const METHOD_NAME__CLS: &[u8; 5] = b"_CLS\0";
pub const METHOD_NAME__CRS: &[u8; 5] = b"_CRS\0";
pub const METHOD_NAME__DDN: &[u8; 5] = b"_DDN\0";
pub const METHOD_NAME__DIS: &[u8; 5] = b"_DIS\0";
pub const METHOD_NAME__DMA: &[u8; 5] = b"_DMA\0";
pub const METHOD_NAME__EVT: &[u8; 5] = b"_EVT\0";
pub const METHOD_NAME__HID: &[u8; 5] = b"_HID\0";
pub const METHOD_NAME__INI: &[u8; 5] = b"_INI\0";
pub const METHOD_NAME__PLD: &[u8; 5] = b"_PLD\0";
pub const METHOD_NAME__DSD: &[u8; 5] = b"_DSD\0";
pub const METHOD_NAME__PRS: &[u8; 5] = b"_PRS\0";
pub const METHOD_NAME__PRT: &[u8; 5] = b"_PRT\0";
pub const METHOD_NAME__PRW: &[u8; 5] = b"_PRW\0";
pub const METHOD_NAME__PS0: &[u8; 5] = b"_PS0\0";
pub const METHOD_NAME__PS1: &[u8; 5] = b"_PS1\0";
pub const METHOD_NAME__PS2: &[u8; 5] = b"_PS2\0";
pub const METHOD_NAME__PS3: &[u8; 5] = b"_PS3\0";
pub const METHOD_NAME__REG: &[u8; 5] = b"_REG\0";
pub const METHOD_NAME__SB_: &[u8; 5] = b"_SB_\0";
pub const METHOD_NAME__SEG: &[u8; 5] = b"_SEG\0";
pub const METHOD_NAME__SRS: &[u8; 5] = b"_SRS\0";
pub const METHOD_NAME__STA: &[u8; 5] = b"_STA\0";
pub const METHOD_NAME__SUB: &[u8; 5] = b"_SUB\0";
pub const METHOD_NAME__UID: &[u8; 5] = b"_UID\0";
pub const METHOD_PATHNAME__PTS: &[u8; 6] = b"\\_PTS\0";
pub const METHOD_PATHNAME__SST: &[u8; 10] = b"\\_SI._SST\0";
pub const METHOD_PATHNAME__WAK: &[u8; 6] = b"\\_WAK\0";
pub const ACPI_ROOT_PATHNAME: &[u8; 5] = b"\\___\0";
pub const ACPI_NAMESPACE_ROOT: &[u8; 15] = b"Namespace Root\0";
pub const ACPI_NS_ROOT_PATH: &[u8; 2] = b"\\\0";
pub const ACPI_ASCII_MAX: u32 = 127;
pub const ACPI_MAX_GPE_BLOCKS: u32 = 2;
pub const ACPI_GPE_REGISTER_WIDTH: u32 = 8;
pub const ACPI_PM1_REGISTER_WIDTH: u32 = 16;
pub const ACPI_PM2_REGISTER_WIDTH: u32 = 8;
pub const ACPI_PM_TIMER_WIDTH: u32 = 32;
pub const ACPI_RESET_REGISTER_WIDTH: u32 = 8;
pub const ACPI_NAMESEG_SIZE: u32 = 4;
pub const ACPI_PATH_SEGMENT_LENGTH: u32 = 5;
pub const ACPI_PATH_SEPARATOR: u8 = 46u8;
pub const ACPI_OEM_ID_SIZE: u32 = 6;
pub const ACPI_OEM_TABLE_ID_SIZE: u32 = 8;
pub const PCI_ROOT_HID_STRING: &[u8; 8] = b"PNP0A03\0";
pub const PCI_EXPRESS_ROOT_HID_STRING: &[u8; 8] = b"PNP0A08\0";
pub const ACPI_PM_TIMER_FREQUENCY: u32 = 3579545;
pub const ACPI_MSEC_PER_SEC: u32 = 1000;
pub const ACPI_USEC_PER_MSEC: u32 = 1000;
pub const ACPI_USEC_PER_SEC: u32 = 1000000;
pub const ACPI_100NSEC_PER_USEC: u32 = 10;
pub const ACPI_100NSEC_PER_MSEC: u32 = 10000;
pub const ACPI_100NSEC_PER_SEC: u32 = 10000000;
pub const ACPI_NSEC_PER_USEC: u32 = 1000;
pub const ACPI_NSEC_PER_MSEC: u32 = 1000000;
pub const ACPI_NSEC_PER_SEC: u32 = 1000000000;
pub const ACPI_OWNER_ID_MAX: u32 = 4095;
pub const ACPI_INTEGER_BIT_SIZE: u32 = 64;
pub const ACPI_MAX_DECIMAL_DIGITS: u32 = 20;
pub const ACPI_MAX64_DECIMAL_DIGITS: u32 = 20;
pub const ACPI_MAX32_DECIMAL_DIGITS: u32 = 10;
pub const ACPI_MAX16_DECIMAL_DIGITS: u32 = 5;
pub const ACPI_MAX8_DECIMAL_DIGITS: u32 = 3;
pub const ACPI_WAIT_FOREVER: u32 = 65535;
pub const ACPI_DO_NOT_WAIT: u32 = 0;
pub const ACPI_ACCESS_BIT_SHIFT: u32 = 2;
pub const ACPI_ACCESS_BYTE_SHIFT: i32 = -1;
pub const ACPI_ACCESS_BIT_MAX: u32 = 29;
pub const ACPI_ACCESS_BYTE_MAX: u32 = 32;
pub const ACPI_ACCESS_BIT_DEFAULT: u32 = 6;
pub const ACPI_ACCESS_BYTE_DEFAULT: u32 = 9;
pub const ACPI_FULL_INITIALIZATION: u32 = 0;
pub const ACPI_NO_FACS_INIT: u32 = 1;
pub const ACPI_NO_ACPI_ENABLE: u32 = 2;
pub const ACPI_NO_HARDWARE_INIT: u32 = 4;
pub const ACPI_NO_EVENT_INIT: u32 = 8;
pub const ACPI_NO_HANDLER_INIT: u32 = 16;
pub const ACPI_NO_OBJECT_INIT: u32 = 32;
pub const ACPI_NO_DEVICE_INIT: u32 = 64;
pub const ACPI_NO_ADDRESS_SPACE_INIT: u32 = 128;
pub const ACPI_SUBSYSTEM_INITIALIZE: u32 = 1;
pub const ACPI_INITIALIZED_OK: u32 = 2;
pub const ACPI_S_STATE_COUNT: u32 = 6;
pub const ACPI_D_STATE_COUNT: u32 = 5;
pub const ACPI_C_STATE_COUNT: u32 = 4;
pub const ACPI_SLEEP_TYPE_MAX: u32 = 7;
pub const ACPI_SLEEP_TYPE_INVALID: u32 = 255;
pub const ACPI_GENERIC_NOTIFY_MAX: u32 = 15;
pub const ACPI_SPECIFIC_NOTIFY_MAX: u32 = 132;
pub const ACPI_TYPE_ANY: u32 = 0;
pub const ACPI_TYPE_INTEGER: u32 = 1;
pub const ACPI_TYPE_STRING: u32 = 2;
pub const ACPI_TYPE_BUFFER: u32 = 3;
pub const ACPI_TYPE_PACKAGE: u32 = 4;
pub const ACPI_TYPE_FIELD_UNIT: u32 = 5;
pub const ACPI_TYPE_DEVICE: u32 = 6;
pub const ACPI_TYPE_EVENT: u32 = 7;
pub const ACPI_TYPE_METHOD: u32 = 8;
pub const ACPI_TYPE_MUTEX: u32 = 9;
pub const ACPI_TYPE_REGION: u32 = 10;
pub const ACPI_TYPE_POWER: u32 = 11;
pub const ACPI_TYPE_PROCESSOR: u32 = 12;
pub const ACPI_TYPE_THERMAL: u32 = 13;
pub const ACPI_TYPE_BUFFER_FIELD: u32 = 14;
pub const ACPI_TYPE_DDB_HANDLE: u32 = 15;
pub const ACPI_TYPE_DEBUG_OBJECT: u32 = 16;
pub const ACPI_TYPE_EXTERNAL_MAX: u32 = 16;
pub const ACPI_NUM_TYPES: u32 = 17;
pub const ACPI_TYPE_LOCAL_REGION_FIELD: u32 = 17;
pub const ACPI_TYPE_LOCAL_BANK_FIELD: u32 = 18;
pub const ACPI_TYPE_LOCAL_INDEX_FIELD: u32 = 19;
pub const ACPI_TYPE_LOCAL_REFERENCE: u32 = 20;
pub const ACPI_TYPE_LOCAL_ALIAS: u32 = 21;
pub const ACPI_TYPE_LOCAL_METHOD_ALIAS: u32 = 22;
pub const ACPI_TYPE_LOCAL_NOTIFY: u32 = 23;
pub const ACPI_TYPE_LOCAL_ADDRESS_HANDLER: u32 = 24;
pub const ACPI_TYPE_LOCAL_RESOURCE: u32 = 25;
pub const ACPI_TYPE_LOCAL_RESOURCE_FIELD: u32 = 26;
pub const ACPI_TYPE_LOCAL_SCOPE: u32 = 27;
pub const ACPI_TYPE_NS_NODE_MAX: u32 = 27;
pub const ACPI_TOTAL_TYPES: u32 = 28;
pub const ACPI_TYPE_LOCAL_EXTRA: u32 = 28;
pub const ACPI_TYPE_LOCAL_DATA: u32 = 29;
pub const ACPI_TYPE_LOCAL_MAX: u32 = 29;
pub const ACPI_TYPE_INVALID: u32 = 30;
pub const ACPI_TYPE_NOT_FOUND: u32 = 255;
pub const ACPI_NUM_NS_TYPES: u32 = 31;
pub const ACPI_READ: u32 = 0;
pub const ACPI_WRITE: u32 = 1;
pub const ACPI_IO_MASK: u32 = 1;
pub const ACPI_EVENT_PMTIMER: u32 = 0;
pub const ACPI_EVENT_GLOBAL: u32 = 1;
pub const ACPI_EVENT_POWER_BUTTON: u32 = 2;
pub const ACPI_EVENT_SLEEP_BUTTON: u32 = 3;
pub const ACPI_EVENT_RTC: u32 = 4;
pub const ACPI_EVENT_MAX: u32 = 4;
pub const ACPI_NUM_FIXED_EVENTS: u32 = 5;
pub const ACPI_GPE_ENABLE: u32 = 0;
pub const ACPI_GPE_DISABLE: u32 = 1;
pub const ACPI_GPE_CONDITIONAL_ENABLE: u32 = 2;
pub const ACPI_NOT_ISR: u32 = 1;
pub const ACPI_ISR: u32 = 0;
pub const ACPI_SYSTEM_NOTIFY: u32 = 1;
pub const ACPI_DEVICE_NOTIFY: u32 = 2;
pub const ACPI_ALL_NOTIFY: u32 = 3;
pub const ACPI_MAX_NOTIFY_HANDLER_TYPE: u32 = 3;
pub const ACPI_NUM_NOTIFY_TYPES: u32 = 2;
pub const ACPI_MAX_SYS_NOTIFY: u32 = 127;
pub const ACPI_MAX_DEVICE_SPECIFIC_NOTIFY: u32 = 191;
pub const ACPI_SYSTEM_HANDLER_LIST: u32 = 0;
pub const ACPI_DEVICE_HANDLER_LIST: u32 = 1;
pub const ACPI_NUM_PREDEFINED_REGIONS: u32 = 12;
pub const ACPI_REG_DISCONNECT: u32 = 0;
pub const ACPI_REG_CONNECT: u32 = 1;
pub const ACPI_BITREG_TIMER_STATUS: u32 = 0;
pub const ACPI_BITREG_BUS_MASTER_STATUS: u32 = 1;
pub const ACPI_BITREG_GLOBAL_LOCK_STATUS: u32 = 2;
pub const ACPI_BITREG_POWER_BUTTON_STATUS: u32 = 3;
pub const ACPI_BITREG_SLEEP_BUTTON_STATUS: u32 = 4;
pub const ACPI_BITREG_RT_CLOCK_STATUS: u32 = 5;
pub const ACPI_BITREG_WAKE_STATUS: u32 = 6;
pub const ACPI_BITREG_PCIEXP_WAKE_STATUS: u32 = 7;
pub const ACPI_BITREG_TIMER_ENABLE: u32 = 8;
pub const ACPI_BITREG_GLOBAL_LOCK_ENABLE: u32 = 9;
pub const ACPI_BITREG_POWER_BUTTON_ENABLE: u32 = 10;
pub const ACPI_BITREG_SLEEP_BUTTON_ENABLE: u32 = 11;
pub const ACPI_BITREG_RT_CLOCK_ENABLE: u32 = 12;
pub const ACPI_BITREG_PCIEXP_WAKE_DISABLE: u32 = 13;
pub const ACPI_BITREG_SCI_ENABLE: u32 = 14;
pub const ACPI_BITREG_BUS_MASTER_RLD: u32 = 15;
pub const ACPI_BITREG_GLOBAL_LOCK_RELEASE: u32 = 16;
pub const ACPI_BITREG_SLEEP_TYPE: u32 = 17;
pub const ACPI_BITREG_SLEEP_ENABLE: u32 = 18;
pub const ACPI_BITREG_ARB_DISABLE: u32 = 19;
pub const ACPI_BITREG_MAX: u32 = 19;
pub const ACPI_NUM_BITREG: u32 = 20;
pub const ACPI_CLEAR_STATUS: u32 = 1;
pub const ACPI_ENABLE_EVENT: u32 = 1;
pub const ACPI_DISABLE_EVENT: u32 = 0;
pub const ACPI_NO_BUFFER: u32 = 0;
pub const ACPI_FULL_PATHNAME: u32 = 0;
pub const ACPI_SINGLE_NAME: u32 = 1;
pub const ACPI_FULL_PATHNAME_NO_TRAILING: u32 = 2;
pub const ACPI_NAME_TYPE_MAX: u32 = 2;
pub const ACPI_SYS_MODE_UNKNOWN: u32 = 0;
pub const ACPI_SYS_MODE_ACPI: u32 = 1;
pub const ACPI_SYS_MODE_LEGACY: u32 = 2;
pub const ACPI_SYS_MODES_MASK: u32 = 3;
pub const ACPI_EVENT_TYPE_GPE: u32 = 0;
pub const ACPI_EVENT_TYPE_FIXED: u32 = 1;
pub const ACPI_INIT_DEVICE_INI: u32 = 1;
pub const ACPI_TABLE_EVENT_LOAD: u32 = 0;
pub const ACPI_TABLE_EVENT_UNLOAD: u32 = 1;
pub const ACPI_TABLE_EVENT_INSTALL: u32 = 2;
pub const ACPI_TABLE_EVENT_UNINSTALL: u32 = 3;
pub const ACPI_NUM_TABLE_EVENTS: u32 = 4;
pub const ACPI_REGION_ACTIVATE: u32 = 0;
pub const ACPI_REGION_DEACTIVATE: u32 = 1;
pub const ACPI_INTERRUPT_NOT_HANDLED: u32 = 0;
pub const ACPI_INTERRUPT_HANDLED: u32 = 1;
pub const ACPI_REENABLE_GPE: u32 = 128;
pub const ACPI_EISAID_STRING_SIZE: u32 = 8;
pub const ACPI_UUID_LENGTH: u32 = 16;
pub const ACPI_PCICLS_STRING_SIZE: u32 = 7;
pub const ACPI_PCI_ROOT_BRIDGE: u32 = 1;
pub const ACPI_VALID_ADR: u32 = 2;
pub const ACPI_VALID_HID: u32 = 4;
pub const ACPI_VALID_UID: u32 = 8;
pub const ACPI_VALID_CID: u32 = 32;
pub const ACPI_VALID_CLS: u32 = 64;
pub const ACPI_VALID_SXDS: u32 = 256;
pub const ACPI_VALID_SXWS: u32 = 512;
pub const ACPI_STA_DEVICE_PRESENT: u32 = 1;
pub const ACPI_STA_DEVICE_ENABLED: u32 = 2;
pub const ACPI_STA_DEVICE_UI: u32 = 4;
pub const ACPI_STA_DEVICE_FUNCTIONING: u32 = 8;
pub const ACPI_STA_DEVICE_OK: u32 = 8;
pub const ACPI_STA_BATTERY_PRESENT: u32 = 16;
pub const ACPI_VENDOR_STRINGS: u32 = 1;
pub const ACPI_FEATURE_STRINGS: u32 = 2;
pub const ACPI_ENABLE_INTERFACES: u32 = 0;
pub const ACPI_DISABLE_INTERFACES: u32 = 4;
pub const ACPI_DISABLE_ALL_VENDOR_STRINGS: u32 = 5;
pub const ACPI_DISABLE_ALL_FEATURE_STRINGS: u32 = 6;
pub const ACPI_DISABLE_ALL_STRINGS: u32 = 7;
pub const ACPI_ENABLE_ALL_VENDOR_STRINGS: u32 = 1;
pub const ACPI_ENABLE_ALL_FEATURE_STRINGS: u32 = 2;
pub const ACPI_ENABLE_ALL_STRINGS: u32 = 3;
pub const ACPI_OSI_WIN_2000: u32 = 1;
pub const ACPI_OSI_WIN_XP: u32 = 2;
pub const ACPI_OSI_WIN_XP_SP1: u32 = 3;
pub const ACPI_OSI_WINSRV_2003: u32 = 4;
pub const ACPI_OSI_WIN_XP_SP2: u32 = 5;
pub const ACPI_OSI_WINSRV_2003_SP1: u32 = 6;
pub const ACPI_OSI_WIN_VISTA: u32 = 7;
pub const ACPI_OSI_WINSRV_2008: u32 = 8;
pub const ACPI_OSI_WIN_VISTA_SP1: u32 = 9;
pub const ACPI_OSI_WIN_VISTA_SP2: u32 = 10;
pub const ACPI_OSI_WIN_7: u32 = 11;
pub const ACPI_OSI_WIN_8: u32 = 12;
pub const ACPI_OSI_WIN_8_1: u32 = 13;
pub const ACPI_OSI_WIN_10: u32 = 14;
pub const ACPI_OSI_WIN_10_RS1: u32 = 15;
pub const ACPI_OSI_WIN_10_RS2: u32 = 16;
pub const ACPI_OSI_WIN_10_RS3: u32 = 17;
pub const ACPI_OSI_WIN_10_RS4: u32 = 18;
pub const ACPI_OSI_WIN_10_RS5: u32 = 19;
pub const ACPI_OSI_WIN_10_19H1: u32 = 20;
pub const ACPI_OSI_WIN_10_20H1: u32 = 21;
pub const ACPI_OSI_WIN_11: u32 = 22;
pub const ACPI_OSI_WIN_11_22H2: u32 = 23;
pub const ACPI_OPT_END: i32 = -1;
pub const AE_CODE_ENVIRONMENTAL: u32 = 0;
pub const AE_CODE_PROGRAMMER: u32 = 4096;
pub const AE_CODE_ACPI_TABLES: u32 = 8192;
pub const AE_CODE_AML: u32 = 12288;
pub const AE_CODE_CONTROL: u32 = 16384;
pub const AE_CODE_MAX: u32 = 16384;
pub const AE_CODE_MASK: u32 = 61440;
pub const AE_CODE_ENV_MAX: u32 = 35;
pub const AE_CODE_PGM_MAX: u32 = 9;
pub const AE_CODE_TBL_MAX: u32 = 5;
pub const AE_CODE_AML_MAX: u32 = 39;
pub const AE_CODE_CTRL_MAX: u32 = 12;
pub const ACPI_SIG_DSDT: &[u8; 5] = b"DSDT\0";
pub const ACPI_SIG_FADT: &[u8; 5] = b"FACP\0";
pub const ACPI_SIG_FACS: &[u8; 5] = b"FACS\0";
pub const ACPI_SIG_OSDT: &[u8; 5] = b"OSDT\0";
pub const ACPI_SIG_PSDT: &[u8; 5] = b"PSDT\0";
pub const ACPI_SIG_RSDP: &[u8; 9] = b"RSD PTR \0";
pub const ACPI_SIG_RSDT: &[u8; 5] = b"RSDT\0";
pub const ACPI_SIG_XSDT: &[u8; 5] = b"XSDT\0";
pub const ACPI_SIG_SSDT: &[u8; 5] = b"SSDT\0";
pub const ACPI_RSDP_NAME: &[u8; 5] = b"RSDP\0";
pub const ACPI_OEM_NAME: &[u8; 4] = b"OEM\0";
pub const ACPI_GLOCK_PENDING: u32 = 1;
pub const ACPI_GLOCK_OWNED: u32 = 2;
pub const ACPI_FACS_S4_BIOS_PRESENT: u32 = 1;
pub const ACPI_FACS_64BIT_WAKE: u32 = 2;
pub const ACPI_FACS_64BIT_ENVIRONMENT: u32 = 1;
pub const ACPI_FADT_LEGACY_DEVICES: u32 = 1;
pub const ACPI_FADT_8042: u32 = 2;
pub const ACPI_FADT_NO_VGA: u32 = 4;
pub const ACPI_FADT_NO_MSI: u32 = 8;
pub const ACPI_FADT_NO_ASPM: u32 = 16;
pub const ACPI_FADT_NO_CMOS_RTC: u32 = 32;
pub const FADT2_REVISION_ID: u32 = 3;
pub const ACPI_FADT_PSCI_COMPLIANT: u32 = 1;
pub const ACPI_FADT_PSCI_USE_HVC: u32 = 2;
pub const ACPI_FADT_WBINVD: u32 = 1;
pub const ACPI_FADT_WBINVD_FLUSH: u32 = 2;
pub const ACPI_FADT_C1_SUPPORTED: u32 = 4;
pub const ACPI_FADT_C2_MP_SUPPORTED: u32 = 8;
pub const ACPI_FADT_POWER_BUTTON: u32 = 16;
pub const ACPI_FADT_SLEEP_BUTTON: u32 = 32;
pub const ACPI_FADT_FIXED_RTC: u32 = 64;
pub const ACPI_FADT_S4_RTC_WAKE: u32 = 128;
pub const ACPI_FADT_32BIT_TIMER: u32 = 256;
pub const ACPI_FADT_DOCKING_SUPPORTED: u32 = 512;
pub const ACPI_FADT_RESET_REGISTER: u32 = 1024;
pub const ACPI_FADT_SEALED_CASE: u32 = 2048;
pub const ACPI_FADT_HEADLESS: u32 = 4096;
pub const ACPI_FADT_SLEEP_TYPE: u32 = 8192;
pub const ACPI_FADT_PCI_EXPRESS_WAKE: u32 = 16384;
pub const ACPI_FADT_PLATFORM_CLOCK: u32 = 32768;
pub const ACPI_FADT_S4_RTC_VALID: u32 = 65536;
pub const ACPI_FADT_REMOTE_POWER_ON: u32 = 131072;
pub const ACPI_FADT_APIC_CLUSTER: u32 = 262144;
pub const ACPI_FADT_APIC_PHYSICAL: u32 = 524288;
pub const ACPI_FADT_HW_REDUCED: u32 = 1048576;
pub const ACPI_FADT_LOW_POWER_S0: u32 = 2097152;
pub const ACPI_X_WAKE_STATUS: u32 = 128;
pub const ACPI_X_SLEEP_TYPE_MASK: u32 = 28;
pub const ACPI_X_SLEEP_TYPE_POSITION: u32 = 2;
pub const ACPI_X_SLEEP_ENABLE: u32 = 32;
pub const ACPI_TABLE_ORIGIN_EXTERNAL_VIRTUAL: u32 = 0;
pub const ACPI_TABLE_ORIGIN_INTERNAL_PHYSICAL: u32 = 1;
pub const ACPI_TABLE_ORIGIN_INTERNAL_VIRTUAL: u32 = 2;
pub const ACPI_TABLE_ORIGIN_MASK: u32 = 3;
pub const ACPI_TABLE_IS_VERIFIED: u32 = 4;
pub const ACPI_TABLE_IS_LOADED: u32 = 8;
pub const ACPI_SIG_AEST: &[u8; 5] = b"AEST\0";
pub const ACPI_SIG_ASF: &[u8; 5] = b"ASF!\0";
pub const ACPI_SIG_ASPT: &[u8; 5] = b"ASPT\0";
pub const ACPI_SIG_BERT: &[u8; 5] = b"BERT\0";
pub const ACPI_SIG_BGRT: &[u8; 5] = b"BGRT\0";
pub const ACPI_SIG_BOOT: &[u8; 5] = b"BOOT\0";
pub const ACPI_SIG_CEDT: &[u8; 5] = b"CEDT\0";
pub const ACPI_SIG_CPEP: &[u8; 5] = b"CPEP\0";
pub const ACPI_SIG_CSRT: &[u8; 5] = b"CSRT\0";
pub const ACPI_SIG_DBG2: &[u8; 5] = b"DBG2\0";
pub const ACPI_SIG_DBGP: &[u8; 5] = b"DBGP\0";
pub const ACPI_SIG_DMAR: &[u8; 5] = b"DMAR\0";
pub const ACPI_SIG_DRTM: &[u8; 5] = b"DRTM\0";
pub const ACPI_SIG_ECDT: &[u8; 5] = b"ECDT\0";
pub const ACPI_SIG_EINJ: &[u8; 5] = b"EINJ\0";
pub const ACPI_SIG_ERST: &[u8; 5] = b"ERST\0";
pub const ACPI_SIG_FPDT: &[u8; 5] = b"FPDT\0";
pub const ACPI_SIG_GTDT: &[u8; 5] = b"GTDT\0";
pub const ACPI_SIG_HEST: &[u8; 5] = b"HEST\0";
pub const ACPI_SIG_HMAT: &[u8; 5] = b"HMAT\0";
pub const ACPI_SIG_HPET: &[u8; 5] = b"HPET\0";
pub const ACPI_SIG_IBFT: &[u8; 5] = b"IBFT\0";
pub const ACPI_SIG_MSCT: &[u8; 5] = b"MSCT\0";
pub const ACPI_SIG_S3PT: &[u8; 5] = b"S3PT\0";
pub const ACPI_SIG_PCCS: &[u8; 4] = b"PCC\0";
pub const ACPI_SIG_NBFT: &[u8; 5] = b"NBFT\0";
pub const ACPI_SIG_MATR: &[u8; 5] = b"MATR\0";
pub const ACPI_SIG_MSDM: &[u8; 5] = b"MSDM\0";
pub const ASPT_REVISION_ID: u32 = 1;
pub const ACPI_ASF_SMBUS_PROTOCOLS: u32 = 1;
pub const ACPI_BERT_UNCORRECTABLE: u32 = 1;
pub const ACPI_BERT_CORRECTABLE: u32 = 2;
pub const ACPI_BERT_MULTIPLE_UNCORRECTABLE: u32 = 4;
pub const ACPI_BERT_MULTIPLE_CORRECTABLE: u32 = 8;
pub const ACPI_BERT_ERROR_ENTRY_COUNT: u32 = 4080;
pub const ACPI_BGRT_DISPLAYED: u32 = 1;
pub const ACPI_BGRT_ORIENTATION_OFFSET: u32 = 6;
pub const ACPI_CDAT_DSMAS_NON_VOLATILE: u32 = 4;
pub const ACPI_CDAT_DSMAS_SHAREABLE: u32 = 8;
pub const ACPI_CDAT_DSMAS_READ_ONLY: u32 = 64;
pub const ACPI_CDAT_DSIS_MEM_ATTACHED: u32 = 1;
pub const ACPI_CDAT_SSLBIS_US_PORT: u32 = 256;
pub const ACPI_CDAT_SSLBIS_ANY_PORT: u32 = 65535;
pub const ACPI_CEDT_CHBS_VERSION_CXL11: u32 = 0;
pub const ACPI_CEDT_CHBS_VERSION_CXL20: u32 = 1;
pub const ACPI_CEDT_CHBS_LENGTH_CXL11: u32 = 8192;
pub const ACPI_CEDT_CHBS_LENGTH_CXL20: u32 = 65536;
pub const ACPI_CEDT_CFMWS_ARITHMETIC_MODULO: u32 = 0;
pub const ACPI_CEDT_CFMWS_ARITHMETIC_XOR: u32 = 1;
pub const ACPI_CEDT_CFMWS_RESTRICT_DEVMEM: u32 = 1;
pub const ACPI_CEDT_CFMWS_RESTRICT_HOSTONLYMEM: u32 = 2;
pub const ACPI_CEDT_CFMWS_RESTRICT_VOLATILE: u32 = 4;
pub const ACPI_CEDT_CFMWS_RESTRICT_PMEM: u32 = 8;
pub const ACPI_CEDT_CFMWS_RESTRICT_FIXED: u32 = 16;
pub const ACPI_CEDT_CFMWS_RESTRICT_BI: u32 = 32;
pub const ACPI_CEDT_RDPAS_BUS_MASK: u32 = 65280;
pub const ACPI_CEDT_RDPAS_DEVICE_MASK: u32 = 248;
pub const ACPI_CEDT_RDPAS_FUNCTION_MASK: u32 = 7;
pub const ACPI_CEDT_RDPAS_PROTOCOL_IO: u32 = 0;
pub const ACPI_CEDT_RDPAS_PROTOCOL_CACHEMEM: u32 = 1;
pub const ACPI_CSRT_TYPE_INTERRUPT: u32 = 1;
pub const ACPI_CSRT_TYPE_TIMER: u32 = 2;
pub const ACPI_CSRT_TYPE_DMA: u32 = 3;
pub const ACPI_CSRT_XRUPT_LINE: u32 = 0;
pub const ACPI_CSRT_XRUPT_CONTROLLER: u32 = 1;
pub const ACPI_CSRT_TIMER: u32 = 0;
pub const ACPI_CSRT_DMA_CHANNEL: u32 = 0;
pub const ACPI_CSRT_DMA_CONTROLLER: u32 = 1;
pub const ACPI_DBG2_SERIAL_PORT: u32 = 32768;
pub const ACPI_DBG2_1394_PORT: u32 = 32769;
pub const ACPI_DBG2_USB_PORT: u32 = 32770;
pub const ACPI_DBG2_NET_PORT: u32 = 32771;
pub const ACPI_DBG2_16550_COMPATIBLE: u32 = 0;
pub const ACPI_DBG2_16550_SUBSET: u32 = 1;
pub const ACPI_DBG2_MAX311XE_SPI: u32 = 2;
pub const ACPI_DBG2_ARM_PL011: u32 = 3;
pub const ACPI_DBG2_MSM8X60: u32 = 4;
pub const ACPI_DBG2_16550_NVIDIA: u32 = 5;
pub const ACPI_DBG2_TI_OMAP: u32 = 6;
pub const ACPI_DBG2_APM88XXXX: u32 = 8;
pub const ACPI_DBG2_MSM8974: u32 = 9;
pub const ACPI_DBG2_SAM5250: u32 = 10;
pub const ACPI_DBG2_INTEL_USIF: u32 = 11;
pub const ACPI_DBG2_IMX6: u32 = 12;
pub const ACPI_DBG2_ARM_SBSA_32BIT: u32 = 13;
pub const ACPI_DBG2_ARM_SBSA_GENERIC: u32 = 14;
pub const ACPI_DBG2_ARM_DCC: u32 = 15;
pub const ACPI_DBG2_BCM2835: u32 = 16;
pub const ACPI_DBG2_SDM845_1_8432MHZ: u32 = 17;
pub const ACPI_DBG2_16550_WITH_GAS: u32 = 18;
pub const ACPI_DBG2_SDM845_7_372MHZ: u32 = 19;
pub const ACPI_DBG2_INTEL_LPSS: u32 = 20;
pub const ACPI_DBG2_RISCV_SBI_CON: u32 = 21;
pub const ACPI_DBG2_1394_STANDARD: u32 = 0;
pub const ACPI_DBG2_USB_XHCI: u32 = 0;
pub const ACPI_DBG2_USB_EHCI: u32 = 1;
pub const ACPI_DMAR_INTR_REMAP: u32 = 1;
pub const ACPI_DMAR_X2APIC_OPT_OUT: u32 = 2;
pub const ACPI_DMAR_X2APIC_MODE: u32 = 4;
pub const ACPI_DMAR_INCLUDE_ALL: u32 = 1;
pub const ACPI_DMAR_ALLOW_ALL: u32 = 1;
pub const ACPI_DMAR_ALL_PORTS: u32 = 1;
pub const ACPI_DRTM_ACCESS_ALLOWED: u32 = 1;
pub const ACPI_DRTM_ENABLE_GAP_CODE: u32 = 2;
pub const ACPI_DRTM_INCOMPLETE_MEASUREMENTS: u32 = 4;
pub const ACPI_DRTM_AUTHORITY_ORDER: u32 = 8;
pub const ACPI_EINJ_PRESERVE: u32 = 1;
pub const ACPI_EINJ_PROCESSOR_CORRECTABLE: u32 = 1;
pub const ACPI_EINJ_PROCESSOR_UNCORRECTABLE: u32 = 2;
pub const ACPI_EINJ_PROCESSOR_FATAL: u32 = 4;
pub const ACPI_EINJ_MEMORY_CORRECTABLE: u32 = 8;
pub const ACPI_EINJ_MEMORY_UNCORRECTABLE: u32 = 16;
pub const ACPI_EINJ_MEMORY_FATAL: u32 = 32;
pub const ACPI_EINJ_PCIX_CORRECTABLE: u32 = 64;
pub const ACPI_EINJ_PCIX_UNCORRECTABLE: u32 = 128;
pub const ACPI_EINJ_PCIX_FATAL: u32 = 256;
pub const ACPI_EINJ_PLATFORM_CORRECTABLE: u32 = 512;
pub const ACPI_EINJ_PLATFORM_UNCORRECTABLE: u32 = 1024;
pub const ACPI_EINJ_PLATFORM_FATAL: u32 = 2048;
pub const ACPI_EINJ_CXL_CACHE_CORRECTABLE: u32 = 4096;
pub const ACPI_EINJ_CXL_CACHE_UNCORRECTABLE: u32 = 8192;
pub const ACPI_EINJ_CXL_CACHE_FATAL: u32 = 16384;
pub const ACPI_EINJ_CXL_MEM_CORRECTABLE: u32 = 32768;
pub const ACPI_EINJ_CXL_MEM_UNCORRECTABLE: u32 = 65536;
pub const ACPI_EINJ_CXL_MEM_FATAL: u32 = 131072;
pub const ACPI_EINJ_VENDOR_DEFINED: u32 = 2147483648;
pub const ACPI_ERST_PRESERVE: u32 = 1;
pub const ACPI_GTDT_INTERRUPT_MODE: u32 = 1;
pub const ACPI_GTDT_INTERRUPT_POLARITY: u32 = 2;
pub const ACPI_GTDT_ALWAYS_ON: u32 = 4;
pub const ACPI_GTDT_GT_IRQ_MODE: u32 = 1;
pub const ACPI_GTDT_GT_IRQ_POLARITY: u32 = 2;
pub const ACPI_GTDT_GT_IS_SECURE_TIMER: u32 = 1;
pub const ACPI_GTDT_GT_ALWAYS_ON: u32 = 2;
pub const ACPI_GTDT_WATCHDOG_IRQ_MODE: u32 = 1;
pub const ACPI_GTDT_WATCHDOG_IRQ_POLARITY: u32 = 2;
pub const ACPI_GTDT_WATCHDOG_SECURE: u32 = 4;
pub const ACPI_HEST_FIRMWARE_FIRST: u32 = 1;
pub const ACPI_HEST_GLOBAL: u32 = 2;
pub const ACPI_HEST_GHES_ASSIST: u32 = 4;
pub const ACPI_HEST_TYPE: u32 = 1;
pub const ACPI_HEST_POLL_INTERVAL: u32 = 2;
pub const ACPI_HEST_POLL_THRESHOLD_VALUE: u32 = 4;
pub const ACPI_HEST_POLL_THRESHOLD_WINDOW: u32 = 8;
pub const ACPI_HEST_ERR_THRESHOLD_VALUE: u32 = 16;
pub const ACPI_HEST_ERR_THRESHOLD_WINDOW: u32 = 32;
pub const ACPI_HEST_UNCORRECTABLE: u32 = 1;
pub const ACPI_HEST_CORRECTABLE: u32 = 2;
pub const ACPI_HEST_MULTIPLE_UNCORRECTABLE: u32 = 4;
pub const ACPI_HEST_MULTIPLE_CORRECTABLE: u32 = 8;
pub const ACPI_HEST_ERROR_ENTRY_COUNT: u32 = 4080;
pub const ACPI_HEST_GEN_ERROR_RECOVERABLE: u32 = 0;
pub const ACPI_HEST_GEN_ERROR_FATAL: u32 = 1;
pub const ACPI_HEST_GEN_ERROR_CORRECTED: u32 = 2;
pub const ACPI_HEST_GEN_ERROR_NONE: u32 = 3;
pub const ACPI_HEST_GEN_VALID_FRU_ID: u32 = 1;
pub const ACPI_HEST_GEN_VALID_FRU_STRING: u32 = 2;
pub const ACPI_HEST_GEN_VALID_TIMESTAMP: u32 = 4;
pub const ACPI_HMAT_PROCESSOR_PD_VALID: u32 = 1;
pub const ACPI_HMAT_MEMORY_PD_VALID: u32 = 2;
pub const ACPI_HMAT_RESERVATION_HINT: u32 = 4;
pub const ACPI_HMAT_MEMORY_HIERARCHY: u32 = 15;
pub const ACPI_HMAT_MEMORY: u32 = 0;
pub const ACPI_HMAT_LAST_LEVEL_CACHE: u32 = 1;
pub const ACPI_HMAT_1ST_LEVEL_CACHE: u32 = 2;
pub const ACPI_HMAT_2ND_LEVEL_CACHE: u32 = 3;
pub const ACPI_HMAT_3RD_LEVEL_CACHE: u32 = 4;
pub const ACPI_HMAT_MINIMUM_XFER_SIZE: u32 = 16;
pub const ACPI_HMAT_NON_SEQUENTIAL_XFERS: u32 = 32;
pub const ACPI_HMAT_ACCESS_LATENCY: u32 = 0;
pub const ACPI_HMAT_READ_LATENCY: u32 = 1;
pub const ACPI_HMAT_WRITE_LATENCY: u32 = 2;
pub const ACPI_HMAT_ACCESS_BANDWIDTH: u32 = 3;
pub const ACPI_HMAT_READ_BANDWIDTH: u32 = 4;
pub const ACPI_HMAT_WRITE_BANDWIDTH: u32 = 5;
pub const ACPI_HMAT_TOTAL_CACHE_LEVEL: u32 = 15;
pub const ACPI_HMAT_CACHE_LEVEL: u32 = 240;
pub const ACPI_HMAT_CACHE_ASSOCIATIVITY: u32 = 3840;
pub const ACPI_HMAT_WRITE_POLICY: u32 = 61440;
pub const ACPI_HMAT_CACHE_LINE_SIZE: u32 = 4294901760;
pub const ACPI_HMAT_CACHE_MODE_UNKNOWN: u32 = 0;
pub const ACPI_HMAT_CACHE_MODE_EXTENDED_LINEAR: u32 = 1;
pub const ACPI_HMAT_CA_NONE: u32 = 0;
pub const ACPI_HMAT_CA_DIRECT_MAPPED: u32 = 1;
pub const ACPI_HMAT_CA_COMPLEX_CACHE_INDEXING: u32 = 2;
pub const ACPI_HMAT_CP_NONE: u32 = 0;
pub const ACPI_HMAT_CP_WB: u32 = 1;
pub const ACPI_HMAT_CP_WT: u32 = 2;
pub const ACPI_HPET_PAGE_PROTECT_MASK: u32 = 3;
pub const ACPI_SIG_AGDI: &[u8; 5] = b"AGDI\0";
pub const ACPI_SIG_APMT: &[u8; 5] = b"APMT\0";
pub const ACPI_SIG_BDAT: &[u8; 5] = b"BDAT\0";
pub const ACPI_SIG_CCEL: &[u8; 5] = b"CCEL\0";
pub const ACPI_SIG_CDAT: &[u8; 5] = b"CDAT\0";
pub const ACPI_SIG_ERDT: &[u8; 5] = b"ERDT\0";
pub const ACPI_SIG_IORT: &[u8; 5] = b"IORT\0";
pub const ACPI_SIG_IVRS: &[u8; 5] = b"IVRS\0";
pub const ACPI_SIG_LPIT: &[u8; 5] = b"LPIT\0";
pub const ACPI_SIG_MADT: &[u8; 5] = b"APIC\0";
pub const ACPI_SIG_MCFG: &[u8; 5] = b"MCFG\0";
pub const ACPI_SIG_MCHI: &[u8; 5] = b"MCHI\0";
pub const ACPI_SIG_MPAM: &[u8; 5] = b"MPAM\0";
pub const ACPI_SIG_MPST: &[u8; 5] = b"MPST\0";
pub const ACPI_SIG_MRRM: &[u8; 5] = b"MRRM\0";
pub const ACPI_SIG_NFIT: &[u8; 5] = b"NFIT\0";
pub const ACPI_SIG_NHLT: &[u8; 5] = b"NHLT\0";
pub const ACPI_SIG_PCCT: &[u8; 5] = b"PCCT\0";
pub const ACPI_SIG_PDTT: &[u8; 5] = b"PDTT\0";
pub const ACPI_SIG_PHAT: &[u8; 5] = b"PHAT\0";
pub const ACPI_SIG_PMTT: &[u8; 5] = b"PMTT\0";
pub const ACPI_SIG_PPTT: &[u8; 5] = b"PPTT\0";
pub const ACPI_SIG_PRMT: &[u8; 5] = b"PRMT\0";
pub const ACPI_SIG_RASF: &[u8; 5] = b"RASF\0";
pub const ACPI_SIG_RAS2: &[u8; 5] = b"RAS2\0";
pub const ACPI_SIG_RGRT: &[u8; 5] = b"RGRT\0";
pub const ACPI_SIG_RHCT: &[u8; 5] = b"RHCT\0";
pub const ACPI_SIG_RIMT: &[u8; 5] = b"RIMT\0";
pub const ACPI_SIG_SBST: &[u8; 5] = b"SBST\0";
pub const ACPI_SIG_SDEI: &[u8; 5] = b"SDEI\0";
pub const ACPI_SIG_SDEV: &[u8; 5] = b"SDEV\0";
pub const ACPI_SIG_SVKL: &[u8; 5] = b"SVKL\0";
pub const ACPI_SIG_SWFT: &[u8; 5] = b"SWFT\0";
pub const ACPI_SIG_TDEL: &[u8; 5] = b"TDEL\0";
pub const ACPI_AEST_PROCESSOR_ERROR_NODE: u32 = 0;
pub const ACPI_AEST_MEMORY_ERROR_NODE: u32 = 1;
pub const ACPI_AEST_SMMU_ERROR_NODE: u32 = 2;
pub const ACPI_AEST_VENDOR_ERROR_NODE: u32 = 3;
pub const ACPI_AEST_GIC_ERROR_NODE: u32 = 4;
pub const ACPI_AEST_PCIE_ERROR_NODE: u32 = 5;
pub const ACPI_AEST_PROXY_ERROR_NODE: u32 = 6;
pub const ACPI_AEST_NODE_TYPE_RESERVED: u32 = 7;
pub const ACPI_AEST_CACHE_RESOURCE: u32 = 0;
pub const ACPI_AEST_TLB_RESOURCE: u32 = 1;
pub const ACPI_AEST_GENERIC_RESOURCE: u32 = 2;
pub const ACPI_AEST_RESOURCE_RESERVED: u32 = 3;
pub const ACPI_AEST_CACHE_DATA: u32 = 0;
pub const ACPI_AEST_CACHE_INSTRUCTION: u32 = 1;
pub const ACPI_AEST_CACHE_UNIFIED: u32 = 2;
pub const ACPI_AEST_CACHE_RESERVED: u32 = 3;
pub const ACPI_AEST_GIC_CPU: u32 = 0;
pub const ACPI_AEST_GIC_DISTRIBUTOR: u32 = 1;
pub const ACPI_AEST_GIC_REDISTRIBUTOR: u32 = 2;
pub const ACPI_AEST_GIC_ITS: u32 = 3;
pub const ACPI_AEST_GIC_RESERVED: u32 = 4;
pub const ACPI_AEST_NODE_GROUP_FORMAT_4K: u32 = 0;
pub const ACPI_AEST_NODE_GROUP_FORMAT_16K: u32 = 1;
pub const ACPI_AEST_NODE_GROUP_FORMAT_64K: u32 = 2;
pub const ACPI_AEST_NODE_SYSTEM_REGISTER: u32 = 0;
pub const ACPI_AEST_NODE_MEMORY_MAPPED: u32 = 1;
pub const ACPI_AEST_NODE_SINGLE_RECORD_MEMORY_MAPPED: u32 = 2;
pub const ACPI_AEST_XFACE_RESERVED: u32 = 3;
pub const ACPI_AEST_NODE_FAULT_HANDLING: u32 = 0;
pub const ACPI_AEST_NODE_ERROR_RECOVERY: u32 = 1;
pub const ACPI_AEST_XRUPT_RESERVED: u32 = 2;
pub const ACPI_AGDI_SIGNALING_MODE: u32 = 1;
pub const ACPI_APMT_NODE_ID_LENGTH: u32 = 4;
pub const ACPI_APMT_FLAGS_DUAL_PAGE: u32 = 1;
pub const ACPI_APMT_FLAGS_AFFINITY: u32 = 2;
pub const ACPI_APMT_FLAGS_ATOMIC: u32 = 4;
pub const ACPI_APMT_FLAGS_DUAL_PAGE_NSUPP: u32 = 0;
pub const ACPI_APMT_FLAGS_DUAL_PAGE_SUPP: u32 = 1;
pub const ACPI_APMT_FLAGS_AFFINITY_PROC: u32 = 0;
pub const ACPI_APMT_FLAGS_AFFINITY_PROC_CONTAINER: u32 = 2;
pub const ACPI_APMT_FLAGS_ATOMIC_NSUPP: u32 = 0;
pub const ACPI_APMT_FLAGS_ATOMIC_SUPP: u32 = 4;
pub const ACPI_APMT_OVFLW_IRQ_FLAGS_MODE: u32 = 1;
pub const ACPI_APMT_OVFLW_IRQ_FLAGS_TYPE: u32 = 2;
pub const ACPI_APMT_OVFLW_IRQ_FLAGS_MODE_LEVEL: u32 = 0;
pub const ACPI_APMT_OVFLW_IRQ_FLAGS_MODE_EDGE: u32 = 1;
pub const ACPI_APMT_OVFLW_IRQ_FLAGS_TYPE_WIRED: u32 = 0;
pub const ACPI_IORT_ID_SINGLE_MAPPING: u32 = 1;
pub const ACPI_IORT_NODE_COHERENT: u32 = 1;
pub const ACPI_IORT_NODE_NOT_COHERENT: u32 = 0;
pub const ACPI_IORT_HT_TRANSIENT: u32 = 1;
pub const ACPI_IORT_HT_WRITE: u32 = 2;
pub const ACPI_IORT_HT_READ: u32 = 4;
pub const ACPI_IORT_HT_OVERRIDE: u32 = 8;
pub const ACPI_IORT_MF_COHERENCY: u32 = 1;
pub const ACPI_IORT_MF_ATTRIBUTES: u32 = 2;
pub const ACPI_IORT_MF_CANWBS: u32 = 4;
pub const ACPI_IORT_NC_STALL_SUPPORTED: u32 = 1;
pub const ACPI_IORT_NC_PASID_BITS: u32 = 62;
pub const ACPI_IORT_ATS_SUPPORTED: u32 = 1;
pub const ACPI_IORT_PRI_SUPPORTED: u32 = 2;
pub const ACPI_IORT_PASID_FWD_SUPPORTED: u32 = 4;
pub const ACPI_IORT_PASID_MAX_WIDTH: u32 = 31;
pub const ACPI_IORT_SMMU_V1: u32 = 0;
pub const ACPI_IORT_SMMU_V2: u32 = 1;
pub const ACPI_IORT_SMMU_CORELINK_MMU400: u32 = 2;
pub const ACPI_IORT_SMMU_CORELINK_MMU500: u32 = 3;
pub const ACPI_IORT_SMMU_CORELINK_MMU401: u32 = 4;
pub const ACPI_IORT_SMMU_CAVIUM_THUNDERX: u32 = 5;
pub const ACPI_IORT_SMMU_DVM_SUPPORTED: u32 = 1;
pub const ACPI_IORT_SMMU_COHERENT_WALK: u32 = 2;
pub const ACPI_IORT_SMMU_V3_GENERIC: u32 = 0;
pub const ACPI_IORT_SMMU_V3_HISILICON_HI161X: u32 = 1;
pub const ACPI_IORT_SMMU_V3_CAVIUM_CN99XX: u32 = 2;
pub const ACPI_IORT_SMMU_V3_COHACC_OVERRIDE: u32 = 1;
pub const ACPI_IORT_SMMU_V3_HTTU_OVERRIDE: u32 = 6;
pub const ACPI_IORT_SMMU_V3_PXM_VALID: u32 = 8;
pub const ACPI_IORT_SMMU_V3_DEVICEID_VALID: u32 = 16;
pub const ACPI_IORT_RMR_REMAP_PERMITTED: u32 = 1;
pub const ACPI_IORT_RMR_ACCESS_PRIVILEGE: u32 = 2;
pub const ACPI_IORT_RMR_ATTR_DEVICE_NGNRNE: u32 = 0;
pub const ACPI_IORT_RMR_ATTR_DEVICE_NGNRE: u32 = 1;
pub const ACPI_IORT_RMR_ATTR_DEVICE_NGRE: u32 = 2;
pub const ACPI_IORT_RMR_ATTR_DEVICE_GRE: u32 = 3;
pub const ACPI_IORT_RMR_ATTR_NORMAL_NC: u32 = 4;
pub const ACPI_IORT_RMR_ATTR_NORMAL_IWB_OWB: u32 = 5;
pub const ACPI_IVRS_PHYSICAL_SIZE: u32 = 32512;
pub const ACPI_IVRS_VIRTUAL_SIZE: u32 = 4161536;
pub const ACPI_IVRS_ATS_RESERVED: u32 = 4194304;
pub const ACPI_IVHD_TT_ENABLE: u32 = 1;
pub const ACPI_IVHD_PASS_PW: u32 = 2;
pub const ACPI_IVHD_RES_PASS_PW: u32 = 4;
pub const ACPI_IVHD_ISOC: u32 = 8;
pub const ACPI_IVHD_IOTLB: u32 = 16;
pub const ACPI_IVMD_UNITY: u32 = 1;
pub const ACPI_IVMD_READ: u32 = 2;
pub const ACPI_IVMD_WRITE: u32 = 4;
pub const ACPI_IVMD_EXCLUSION_RANGE: u32 = 8;
pub const ACPI_IVHD_MSI_NUMBER_MASK: u32 = 31;
pub const ACPI_IVHD_UNIT_ID_MASK: u32 = 7936;
pub const ACPI_IVHD_ENTRY_LENGTH: u32 = 192;
pub const ACPI_IVHD_INIT_PASS: u32 = 1;
pub const ACPI_IVHD_EINT_PASS: u32 = 2;
pub const ACPI_IVHD_NMI_PASS: u32 = 4;
pub const ACPI_IVHD_SYSTEM_MGMT: u32 = 48;
pub const ACPI_IVHD_LINT0_PASS: u32 = 64;
pub const ACPI_IVHD_LINT1_PASS: u32 = 128;
pub const ACPI_IVHD_ATS_DISABLED: u32 = 2147483648;
pub const ACPI_IVHD_IOAPIC: u32 = 1;
pub const ACPI_IVHD_HPET: u32 = 2;
pub const ACPI_IVRS_UID_NOT_PRESENT: u32 = 0;
pub const ACPI_IVRS_UID_IS_INTEGER: u32 = 1;
pub const ACPI_IVRS_UID_IS_STRING: u32 = 2;
pub const ACPI_LPIT_STATE_DISABLED: u32 = 1;
pub const ACPI_LPIT_NO_COUNTER: u32 = 2;
pub const ACPI_MADT_PCAT_COMPAT: u32 = 1;
pub const ACPI_MADT_DUAL_PIC: u32 = 1;
pub const ACPI_MADT_MULTIPLE_APIC: u32 = 0;
pub const ACPI_MADT_CPEI_OVERRIDE: u32 = 1;
pub const ACPI_MADT_PERFORMANCE_IRQ_MODE: u32 = 2;
pub const ACPI_MADT_VGIC_IRQ_MODE: u32 = 4;
pub const ACPI_MADT_GICC_ONLINE_CAPABLE: u32 = 8;
pub const ACPI_MADT_GICC_NON_COHERENT: u32 = 16;
pub const ACPI_MADT_OVERRIDE_SPI_VALUES: u32 = 1;
pub const ACPI_MADT_GICR_NON_COHERENT: u32 = 1;
pub const ACPI_MADT_ITS_NON_COHERENT: u32 = 1;
pub const ACPI_MADT_MP_WAKEUP_SIZE_V0: u32 = 16;
pub const ACPI_MADT_MP_WAKEUP_SIZE_V1: u32 = 24;
pub const ACPI_MULTIPROC_WAKEUP_MB_OS_SIZE: u32 = 2032;
pub const ACPI_MULTIPROC_WAKEUP_MB_FIRMWARE_SIZE: u32 = 2048;
pub const ACPI_MP_WAKE_COMMAND_WAKEUP: u32 = 1;
pub const ACPI_MP_WAKE_COMMAND_TEST: u32 = 2;
pub const ACPI_MADT_ENABLED: u32 = 1;
pub const ACPI_MADT_ONLINE_CAPABLE: u32 = 2;
pub const ACPI_MADT_POLARITY_MASK: u32 = 3;
pub const ACPI_MADT_TRIGGER_MASK: u32 = 12;
pub const ACPI_MADT_POLARITY_CONFORMS: u32 = 0;
pub const ACPI_MADT_POLARITY_ACTIVE_HIGH: u32 = 1;
pub const ACPI_MADT_POLARITY_RESERVED: u32 = 2;
pub const ACPI_MADT_POLARITY_ACTIVE_LOW: u32 = 3;
pub const ACPI_MADT_TRIGGER_CONFORMS: u32 = 0;
pub const ACPI_MADT_TRIGGER_EDGE: u32 = 4;
pub const ACPI_MADT_TRIGGER_RESERVED: u32 = 8;
pub const ACPI_MADT_TRIGGER_LEVEL: u32 = 12;
pub const ACPI_MPST_ENABLED: u32 = 1;
pub const ACPI_MPST_POWER_MANAGED: u32 = 2;
pub const ACPI_MPST_HOT_PLUG_CAPABLE: u32 = 4;
pub const ACPI_MPST_PRESERVE: u32 = 1;
pub const ACPI_MPST_AUTOENTRY: u32 = 2;
pub const ACPI_MPST_AUTOEXIT: u32 = 4;
pub const ACPI_MRRM_FLAGS_REGION_ASSIGNMENT_OS: u32 = 1;
pub const ACPI_MRRM_VALID_REGION_ID_FLAGS_LOCAL: u32 = 1;
pub const ACPI_MRRM_VALID_REGION_ID_FLAGS_REMOTE: u32 = 2;
pub const ACPI_NFIT_ADD_ONLINE_ONLY: u32 = 1;
pub const ACPI_NFIT_PROXIMITY_VALID: u32 = 2;
pub const ACPI_NFIT_LOCATION_COOKIE_VALID: u32 = 4;
pub const ACPI_NFIT_MEM_SAVE_FAILED: u32 = 1;
pub const ACPI_NFIT_MEM_RESTORE_FAILED: u32 = 2;
pub const ACPI_NFIT_MEM_FLUSH_FAILED: u32 = 4;
pub const ACPI_NFIT_MEM_NOT_ARMED: u32 = 8;
pub const ACPI_NFIT_MEM_HEALTH_OBSERVED: u32 = 16;
pub const ACPI_NFIT_MEM_HEALTH_ENABLED: u32 = 32;
pub const ACPI_NFIT_MEM_MAP_FAILED: u32 = 64;
pub const ACPI_NFIT_CONTROL_BUFFERED: u32 = 1;
pub const ACPI_NFIT_CONTROL_MFG_INFO_VALID: u32 = 1;
pub const ACPI_NFIT_CAPABILITY_CACHE_FLUSH: u32 = 1;
pub const ACPI_NFIT_CAPABILITY_MEM_FLUSH: u32 = 2;
pub const ACPI_NFIT_CAPABILITY_MEM_MIRRORING: u32 = 4;
pub const ACPI_NFIT_DIMM_NUMBER_MASK: u32 = 15;
pub const ACPI_NFIT_CHANNEL_NUMBER_MASK: u32 = 240;
pub const ACPI_NFIT_MEMORY_ID_MASK: u32 = 3840;
pub const ACPI_NFIT_SOCKET_ID_MASK: u32 = 61440;
pub const ACPI_NFIT_NODE_ID_MASK: u32 = 268369920;
pub const ACPI_NFIT_DIMM_NUMBER_OFFSET: u32 = 0;
pub const ACPI_NFIT_CHANNEL_NUMBER_OFFSET: u32 = 4;
pub const ACPI_NFIT_MEMORY_ID_OFFSET: u32 = 8;
pub const ACPI_NFIT_SOCKET_ID_OFFSET: u32 = 12;
pub const ACPI_NFIT_NODE_ID_OFFSET: u32 = 16;
pub const ACPI_NHLT_LINKTYPE_HDA: u32 = 0;
pub const ACPI_NHLT_LINKTYPE_DSP: u32 = 1;
pub const ACPI_NHLT_LINKTYPE_PDM: u32 = 2;
pub const ACPI_NHLT_LINKTYPE_SSP: u32 = 3;
pub const ACPI_NHLT_LINKTYPE_SLIMBUS: u32 = 4;
pub const ACPI_NHLT_LINKTYPE_SDW: u32 = 5;
pub const ACPI_NHLT_LINKTYPE_UAOL: u32 = 6;
pub const ACPI_NHLT_DEVICEID_DMIC: u32 = 44576;
pub const ACPI_NHLT_DEVICEID_BT: u32 = 44592;
pub const ACPI_NHLT_DEVICEID_I2S: u32 = 44596;
pub const ACPI_NHLT_DEVICETYPE_PDM: u32 = 0;
pub const ACPI_NHLT_DEVICETYPE_PDM_SKL: u32 = 1;
pub const ACPI_NHLT_DEVICETYPE_BT: u32 = 0;
pub const ACPI_NHLT_DEVICETYPE_FM: u32 = 1;
pub const ACPI_NHLT_DEVICETYPE_MODEM: u32 = 2;
pub const ACPI_NHLT_DEVICETYPE_CODEC: u32 = 4;
pub const ACPI_NHLT_DIR_RENDER: u32 = 0;
pub const ACPI_NHLT_DIR_CAPTURE: u32 = 1;
pub const ACPI_NHLT_CONFIGTYPE_GENERIC: u32 = 0;
pub const ACPI_NHLT_CONFIGTYPE_MICARRAY: u32 = 1;
pub const ACPI_NHLT_ARRAYTYPE_LINEAR2_SMALL: u32 = 10;
pub const ACPI_NHLT_ARRAYTYPE_LINEAR2_BIG: u32 = 11;
pub const ACPI_NHLT_ARRAYTYPE_LINEAR4_GEO1: u32 = 12;
pub const ACPI_NHLT_ARRAYTYPE_PLANAR4_LSHAPED: u32 = 13;
pub const ACPI_NHLT_ARRAYTYPE_LINEAR4_GEO2: u32 = 14;
pub const ACPI_NHLT_ARRAYTYPE_VENDOR: u32 = 15;
pub const ACPI_NHLT_MICTYPE_OMNIDIRECTIONAL: u32 = 0;
pub const ACPI_NHLT_MICTYPE_SUBCARDIOID: u32 = 1;
pub const ACPI_NHLT_MICTYPE_CARDIOID: u32 = 2;
pub const ACPI_NHLT_MICTYPE_SUPERCARDIOID: u32 = 3;
pub const ACPI_NHLT_MICTYPE_HYPERCARDIOID: u32 = 4;
pub const ACPI_NHLT_MICTYPE_8SHAPED: u32 = 5;
pub const ACPI_NHLT_MICTYPE_RESERVED: u32 = 6;
pub const ACPI_NHLT_MICTYPE_VENDORDEFINED: u32 = 7;
pub const ACPI_NHLT_MICLOCATION_TOP: u32 = 0;
pub const ACPI_NHLT_MICLOCATION_BOTTOM: u32 = 1;
pub const ACPI_NHLT_MICLOCATION_LEFT: u32 = 2;
pub const ACPI_NHLT_MICLOCATION_RIGHT: u32 = 3;
pub const ACPI_NHLT_MICLOCATION_FRONT: u32 = 4;
pub const ACPI_NHLT_MICLOCATION_REAR: u32 = 5;
pub const ACPI_PCCT_DOORBELL: u32 = 1;
pub const ACPI_PCCT_INTERRUPT_POLARITY: u32 = 1;
pub const ACPI_PCCT_INTERRUPT_MODE: u32 = 2;
pub const ACPI_PDTT_RUNTIME_TRIGGER: u32 = 1;
pub const ACPI_PDTT_WAIT_COMPLETION: u32 = 2;
pub const ACPI_PDTT_TRIGGER_ORDER: u32 = 4;
pub const ACPI_PHAT_TYPE_FW_VERSION_DATA: u32 = 0;
pub const ACPI_PHAT_TYPE_FW_HEALTH_DATA: u32 = 1;
pub const ACPI_PHAT_TYPE_RESERVED: u32 = 2;
pub const ACPI_PHAT_ERRORS_FOUND: u32 = 0;
pub const ACPI_PHAT_NO_ERRORS: u32 = 1;
pub const ACPI_PHAT_UNKNOWN_ERRORS: u32 = 2;
pub const ACPI_PHAT_ADVISORY: u32 = 3;
pub const ACPI_PMTT_TYPE_SOCKET: u32 = 0;
pub const ACPI_PMTT_TYPE_CONTROLLER: u32 = 1;
pub const ACPI_PMTT_TYPE_DIMM: u32 = 2;
pub const ACPI_PMTT_TYPE_RESERVED: u32 = 3;
pub const ACPI_PMTT_TYPE_VENDOR: u32 = 255;
pub const ACPI_PMTT_TOP_LEVEL: u32 = 1;
pub const ACPI_PMTT_PHYSICAL: u32 = 2;
pub const ACPI_PMTT_MEMORY_TYPE: u32 = 12;
pub const ACPI_PPTT_PHYSICAL_PACKAGE: u32 = 1;
pub const ACPI_PPTT_ACPI_PROCESSOR_ID_VALID: u32 = 2;
pub const ACPI_PPTT_ACPI_PROCESSOR_IS_THREAD: u32 = 4;
pub const ACPI_PPTT_ACPI_LEAF_NODE: u32 = 8;
pub const ACPI_PPTT_ACPI_IDENTICAL: u32 = 16;
pub const ACPI_PPTT_SIZE_PROPERTY_VALID: u32 = 1;
pub const ACPI_PPTT_NUMBER_OF_SETS_VALID: u32 = 2;
pub const ACPI_PPTT_ASSOCIATIVITY_VALID: u32 = 4;
pub const ACPI_PPTT_ALLOCATION_TYPE_VALID: u32 = 8;
pub const ACPI_PPTT_CACHE_TYPE_VALID: u32 = 16;
pub const ACPI_PPTT_WRITE_POLICY_VALID: u32 = 32;
pub const ACPI_PPTT_LINE_SIZE_VALID: u32 = 64;
pub const ACPI_PPTT_CACHE_ID_VALID: u32 = 128;
pub const ACPI_PPTT_MASK_ALLOCATION_TYPE: u32 = 3;
pub const ACPI_PPTT_MASK_CACHE_TYPE: u32 = 12;
pub const ACPI_PPTT_MASK_WRITE_POLICY: u32 = 16;
pub const ACPI_PPTT_CACHE_READ_ALLOCATE: u32 = 0;
pub const ACPI_PPTT_CACHE_WRITE_ALLOCATE: u32 = 1;
pub const ACPI_PPTT_CACHE_RW_ALLOCATE: u32 = 2;
pub const ACPI_PPTT_CACHE_RW_ALLOCATE_ALT: u32 = 3;
pub const ACPI_PPTT_CACHE_TYPE_DATA: u32 = 0;
pub const ACPI_PPTT_CACHE_TYPE_INSTR: u32 = 4;
pub const ACPI_PPTT_CACHE_TYPE_UNIFIED: u32 = 8;
pub const ACPI_PPTT_CACHE_TYPE_UNIFIED_ALT: u32 = 12;
pub const ACPI_PPTT_CACHE_POLICY_WB: u32 = 0;
pub const ACPI_PPTT_CACHE_POLICY_WT: u32 = 16;
pub const ACPI_RASF_SCRUBBER_RUNNING: u32 = 1;
pub const ACPI_RASF_SPEED: u32 = 14;
pub const ACPI_RASF_SPEED_SLOW: u32 = 0;
pub const ACPI_RASF_SPEED_MEDIUM: u32 = 8;
pub const ACPI_RASF_SPEED_FAST: u32 = 14;
pub const ACPI_RASF_GENERATE_SCI: u32 = 32768;
pub const ACPI_RASF_COMMAND_COMPLETE: u32 = 1;
pub const ACPI_RASF_SCI_DOORBELL: u32 = 2;
pub const ACPI_RASF_ERROR: u32 = 4;
pub const ACPI_RASF_STATUS: u32 = 248;
pub const ACPI_RAS2_SCRUBBER_RUNNING: u32 = 1;
pub const ACPI_RAS2_GENERATE_SCI: u32 = 32768;
pub const ACPI_RAS2_COMMAND_COMPLETE: u32 = 1;
pub const ACPI_RAS2_SCI_DOORBELL: u32 = 2;
pub const ACPI_RAS2_ERROR: u32 = 4;
pub const ACPI_RAS2_STATUS: u32 = 248;
pub const ACPI_RHCT_TIMER_CANNOT_WAKEUP_CPU: u32 = 1;
pub const ACPI_RIMT_IOMMU_FLAGS_PCIE: u32 = 1;
pub const ACPI_RIMT_IOMMU_FLAGS_PXM_VALID: u32 = 2;
pub const ACPI_RIMT_GSI_LEVEL_TRIGGERRED: u32 = 1;
pub const ACPI_RIMT_GSI_ACTIVE_HIGH: u32 = 2;
pub const ACPI_RIMT_PCIE_ATS_SUPPORTED: u32 = 1;
pub const ACPI_RIMT_PCIE_PRI_SUPPORTED: u32 = 2;
pub const ACPI_SDEV_HANDOFF_TO_UNSECURE_OS: u32 = 1;
pub const ACPI_SDEV_SECURE_COMPONENTS_PRESENT: u32 = 2;
pub const ACPI_SIG_SLIC: &[u8; 5] = b"SLIC\0";
pub const ACPI_SIG_SLIT: &[u8; 5] = b"SLIT\0";
pub const ACPI_SIG_SPCR: &[u8; 5] = b"SPCR\0";
pub const ACPI_SIG_SPMI: &[u8; 5] = b"SPMI\0";
pub const ACPI_SIG_SRAT: &[u8; 5] = b"SRAT\0";
pub const ACPI_SIG_STAO: &[u8; 5] = b"STAO\0";
pub const ACPI_SIG_TCPA: &[u8; 5] = b"TCPA\0";
pub const ACPI_SIG_TPM2: &[u8; 5] = b"TPM2\0";
pub const ACPI_SIG_UEFI: &[u8; 5] = b"UEFI\0";
pub const ACPI_SIG_VIOT: &[u8; 5] = b"VIOT\0";
pub const ACPI_SIG_WAET: &[u8; 5] = b"WAET\0";
pub const ACPI_SIG_WDAT: &[u8; 5] = b"WDAT\0";
pub const ACPI_SIG_WDDT: &[u8; 5] = b"WDDT\0";
pub const ACPI_SIG_WDRT: &[u8; 5] = b"WDRT\0";
pub const ACPI_SIG_WPBT: &[u8; 5] = b"WPBT\0";
pub const ACPI_SIG_WSMT: &[u8; 5] = b"WSMT\0";
pub const ACPI_SIG_XENV: &[u8; 5] = b"XENV\0";
pub const ACPI_SIG_XXXX: &[u8; 5] = b"XXXX\0";
pub const ACPI_SPCR_DO_NOT_DISABLE: u32 = 1;
pub const ACPI_SRAT_CPU_USE_AFFINITY: u32 = 1;
pub const ACPI_SRAT_MEM_ENABLED: u32 = 1;
pub const ACPI_SRAT_MEM_HOT_PLUGGABLE: u32 = 2;
pub const ACPI_SRAT_MEM_NON_VOLATILE: u32 = 4;
pub const ACPI_SRAT_CPU_ENABLED: u32 = 1;
pub const ACPI_SRAT_GICC_ENABLED: u32 = 1;
pub const ACPI_SRAT_DEVICE_HANDLE_SIZE: u32 = 16;
pub const ACPI_SRAT_GENERIC_AFFINITY_ENABLED: u32 = 1;
pub const ACPI_SRAT_ARCHITECTURAL_TRANSACTIONS: u32 = 2;
pub const ACPI_SRAT_RINTC_ENABLED: u32 = 1;
pub const ACPI_TCPA_CLIENT_TABLE: u32 = 0;
pub const ACPI_TCPA_SERVER_TABLE: u32 = 1;
pub const ACPI_TCPA_PCI_DEVICE: u32 = 1;
pub const ACPI_TCPA_BUS_PNP: u32 = 2;
pub const ACPI_TCPA_ADDRESS_VALID: u32 = 4;
pub const ACPI_TCPA_INTERRUPT_MODE: u32 = 1;
pub const ACPI_TCPA_INTERRUPT_POLARITY: u32 = 2;
pub const ACPI_TCPA_SCI_VIA_GPE: u32 = 4;
pub const ACPI_TCPA_GLOBAL_INTERRUPT: u32 = 8;
pub const ACPI_TPM23_ACPI_START_METHOD: u32 = 2;
pub const ACPI_TPM2_NOT_ALLOWED: u32 = 0;
pub const ACPI_TPM2_RESERVED1: u32 = 1;
pub const ACPI_TPM2_START_METHOD: u32 = 2;
pub const ACPI_TPM2_RESERVED3: u32 = 3;
pub const ACPI_TPM2_RESERVED4: u32 = 4;
pub const ACPI_TPM2_RESERVED5: u32 = 5;
pub const ACPI_TPM2_MEMORY_MAPPED: u32 = 6;
pub const ACPI_TPM2_COMMAND_BUFFER: u32 = 7;
pub const ACPI_TPM2_COMMAND_BUFFER_WITH_START_METHOD: u32 = 8;
pub const ACPI_TPM2_RESERVED9: u32 = 9;
pub const ACPI_TPM2_RESERVED10: u32 = 10;
pub const ACPI_TPM2_COMMAND_BUFFER_WITH_ARM_SMC: u32 = 11;
pub const ACPI_TPM2_RESERVED: u32 = 12;
pub const ACPI_TPM2_COMMAND_BUFFER_WITH_PLUTON: u32 = 13;
pub const ACPI_TPM2_CRB_WITH_ARM_FFA: u32 = 15;
pub const ACPI_TPM2_INTERRUPT_SUPPORT: u32 = 1;
pub const ACPI_TPM2_IDLE_SUPPORT: u32 = 1;
pub const ACPI_WAET_RTC_NO_ACK: u32 = 1;
pub const ACPI_WAET_TIMER_ONE_READ: u32 = 2;
pub const ACPI_WDAT_ENABLED: u32 = 1;
pub const ACPI_WDAT_STOPPED: u32 = 128;
pub const ACPI_WDDT_AVAILABLE: u32 = 1;
pub const ACPI_WDDT_ACTIVE: u32 = 2;
pub const ACPI_WDDT_TCO_OS_OWNED: u32 = 4;
pub const ACPI_WDDT_USER_RESET: u32 = 2048;
pub const ACPI_WDDT_WDT_RESET: u32 = 4096;
pub const ACPI_WDDT_POWER_FAIL: u32 = 8192;
pub const ACPI_WDDT_UNKNOWN_RESET: u32 = 16384;
pub const ACPI_WDDT_AUTO_RESET: u32 = 1;
pub const ACPI_WDDT_ALERT_SUPPORT: u32 = 2;
pub const ACPI_WSMT_FIXED_COMM_BUFFERS: u32 = 1;
pub const ACPI_WSMT_COMM_BUFFER_NESTED_PTR_PROTECTION: u32 = 2;
pub const ACPI_WSMT_SYSTEM_RESOURCE_PROTECTION: u32 = 4;
pub const ACPI_FADT_CONFORMANCE: &[u8; 26] = b"ACPI 6.1 (FADT version 6)\0";
pub const ACPI_DMA_WIDTH8: u32 = 0;
pub const ACPI_DMA_WIDTH16: u32 = 1;
pub const ACPI_DMA_WIDTH32: u32 = 2;
pub const ACPI_DMA_WIDTH64: u32 = 3;
pub const ACPI_DMA_WIDTH128: u32 = 4;
pub const ACPI_DMA_WIDTH256: u32 = 5;
pub const ACPI_RESOURCE_GPIO_TYPE_INT: u32 = 0;
pub const ACPI_RESOURCE_GPIO_TYPE_IO: u32 = 1;
pub const ACPI_PIN_CONFIG_DEFAULT: u32 = 0;
pub const ACPI_PIN_CONFIG_PULLUP: u32 = 1;
pub const ACPI_PIN_CONFIG_PULLDOWN: u32 = 2;
pub const ACPI_PIN_CONFIG_NOPULL: u32 = 3;
pub const ACPI_IO_RESTRICT_NONE: u32 = 0;
pub const ACPI_IO_RESTRICT_INPUT: u32 = 1;
pub const ACPI_IO_RESTRICT_OUTPUT: u32 = 2;
pub const ACPI_IO_RESTRICT_NONE_PRESERVE: u32 = 3;
pub const ACPI_RESOURCE_SERIAL_TYPE_I2C: u32 = 1;
pub const ACPI_RESOURCE_SERIAL_TYPE_SPI: u32 = 2;
pub const ACPI_RESOURCE_SERIAL_TYPE_UART: u32 = 3;
pub const ACPI_RESOURCE_SERIAL_TYPE_CSI2: u32 = 4;
pub const ACPI_CONTROLLER_INITIATED: u32 = 0;
pub const ACPI_DEVICE_INITIATED: u32 = 1;
pub const ACPI_I2C_7BIT_MODE: u32 = 0;
pub const ACPI_I2C_10BIT_MODE: u32 = 1;
pub const ACPI_SPI_4WIRE_MODE: u32 = 0;
pub const ACPI_SPI_3WIRE_MODE: u32 = 1;
pub const ACPI_SPI_ACTIVE_LOW: u32 = 0;
pub const ACPI_SPI_ACTIVE_HIGH: u32 = 1;
pub const ACPI_SPI_FIRST_PHASE: u32 = 0;
pub const ACPI_SPI_SECOND_PHASE: u32 = 1;
pub const ACPI_SPI_START_LOW: u32 = 0;
pub const ACPI_SPI_START_HIGH: u32 = 1;
pub const ACPI_UART_LITTLE_ENDIAN: u32 = 0;
pub const ACPI_UART_BIG_ENDIAN: u32 = 1;
pub const ACPI_UART_5_DATA_BITS: u32 = 0;
pub const ACPI_UART_6_DATA_BITS: u32 = 1;
pub const ACPI_UART_7_DATA_BITS: u32 = 2;
pub const ACPI_UART_8_DATA_BITS: u32 = 3;
pub const ACPI_UART_9_DATA_BITS: u32 = 4;
pub const ACPI_UART_NO_STOP_BITS: u32 = 0;
pub const ACPI_UART_1_STOP_BIT: u32 = 1;
pub const ACPI_UART_1P5_STOP_BITS: u32 = 2;
pub const ACPI_UART_2_STOP_BITS: u32 = 3;
pub const ACPI_UART_FLOW_CONTROL_NONE: u32 = 0;
pub const ACPI_UART_FLOW_CONTROL_HW: u32 = 1;
pub const ACPI_UART_FLOW_CONTROL_XON_XOFF: u32 = 2;
pub const ACPI_UART_PARITY_NONE: u32 = 0;
pub const ACPI_UART_PARITY_EVEN: u32 = 1;
pub const ACPI_UART_PARITY_ODD: u32 = 2;
pub const ACPI_UART_PARITY_MARK: u32 = 3;
pub const ACPI_UART_PARITY_SPACE: u32 = 4;
pub const ACPI_UART_CARRIER_DETECT: u32 = 4;
pub const ACPI_UART_RING_INDICATOR: u32 = 8;
pub const ACPI_UART_DATA_SET_READY: u32 = 16;
pub const ACPI_UART_DATA_TERMINAL_READY: u32 = 32;
pub const ACPI_UART_CLEAR_TO_SEND: u32 = 64;
pub const ACPI_UART_REQUEST_TO_SEND: u32 = 128;
pub const ACPI_PIN_CONFIG_BIAS_PULL_UP: u32 = 1;
pub const ACPI_PIN_CONFIG_BIAS_PULL_DOWN: u32 = 2;
pub const ACPI_PIN_CONFIG_BIAS_DEFAULT: u32 = 3;
pub const ACPI_PIN_CONFIG_BIAS_DISABLE: u32 = 4;
pub const ACPI_PIN_CONFIG_BIAS_HIGH_IMPEDANCE: u32 = 5;
pub const ACPI_PIN_CONFIG_BIAS_BUS_HOLD: u32 = 6;
pub const ACPI_PIN_CONFIG_DRIVE_OPEN_DRAIN: u32 = 7;
pub const ACPI_PIN_CONFIG_DRIVE_OPEN_SOURCE: u32 = 8;
pub const ACPI_PIN_CONFIG_DRIVE_PUSH_PULL: u32 = 9;
pub const ACPI_PIN_CONFIG_DRIVE_STRENGTH: u32 = 10;
pub const ACPI_PIN_CONFIG_SLEW_RATE: u32 = 11;
pub const ACPI_PIN_CONFIG_INPUT_DEBOUNCE: u32 = 12;
pub const ACPI_PIN_CONFIG_INPUT_SCHMITT_TRIGGER: u32 = 13;
pub const ACPI_RESOURCE_TYPE_IRQ: u32 = 0;
pub const ACPI_RESOURCE_TYPE_DMA: u32 = 1;
pub const ACPI_RESOURCE_TYPE_START_DEPENDENT: u32 = 2;
pub const ACPI_RESOURCE_TYPE_END_DEPENDENT: u32 = 3;
pub const ACPI_RESOURCE_TYPE_IO: u32 = 4;
pub const ACPI_RESOURCE_TYPE_FIXED_IO: u32 = 5;
pub const ACPI_RESOURCE_TYPE_VENDOR: u32 = 6;
pub const ACPI_RESOURCE_TYPE_END_TAG: u32 = 7;
pub const ACPI_RESOURCE_TYPE_MEMORY24: u32 = 8;
pub const ACPI_RESOURCE_TYPE_MEMORY32: u32 = 9;
pub const ACPI_RESOURCE_TYPE_FIXED_MEMORY32: u32 = 10;
pub const ACPI_RESOURCE_TYPE_ADDRESS16: u32 = 11;
pub const ACPI_RESOURCE_TYPE_ADDRESS32: u32 = 12;
pub const ACPI_RESOURCE_TYPE_ADDRESS64: u32 = 13;
pub const ACPI_RESOURCE_TYPE_EXTENDED_ADDRESS64: u32 = 14;
pub const ACPI_RESOURCE_TYPE_EXTENDED_IRQ: u32 = 15;
pub const ACPI_RESOURCE_TYPE_GENERIC_REGISTER: u32 = 16;
pub const ACPI_RESOURCE_TYPE_GPIO: u32 = 17;
pub const ACPI_RESOURCE_TYPE_FIXED_DMA: u32 = 18;
pub const ACPI_RESOURCE_TYPE_SERIAL_BUS: u32 = 19;
pub const ACPI_RESOURCE_TYPE_PIN_FUNCTION: u32 = 20;
pub const ACPI_RESOURCE_TYPE_PIN_CONFIG: u32 = 21;
pub const ACPI_RESOURCE_TYPE_PIN_GROUP: u32 = 22;
pub const ACPI_RESOURCE_TYPE_PIN_GROUP_FUNCTION: u32 = 23;
pub const ACPI_RESOURCE_TYPE_PIN_GROUP_CONFIG: u32 = 24;
pub const ACPI_RESOURCE_TYPE_CLOCK_INPUT: u32 = 25;
pub const ACPI_RESOURCE_TYPE_MAX: u32 = 25;
pub const ACPI_RS_SIZE_NO_DATA: u32 = 8;
pub const ACPI_UTILITIES: u32 = 1;
pub const ACPI_HARDWARE: u32 = 2;
pub const ACPI_EVENTS: u32 = 4;
pub const ACPI_TABLES: u32 = 8;
pub const ACPI_NAMESPACE: u32 = 16;
pub const ACPI_PARSER: u32 = 32;
pub const ACPI_DISPATCHER: u32 = 64;
pub const ACPI_EXECUTER: u32 = 128;
pub const ACPI_RESOURCES: u32 = 256;
pub const ACPI_CA_DEBUGGER: u32 = 512;
pub const ACPI_OS_SERVICES: u32 = 1024;
pub const ACPI_CA_DISASSEMBLER: u32 = 2048;
pub const ACPI_COMPILER: u32 = 4096;
pub const ACPI_TOOLS: u32 = 8192;
pub const ACPI_EXAMPLE: u32 = 16384;
pub const ACPI_DRIVER: u32 = 32768;
pub const DT_COMPILER: u32 = 65536;
pub const ASL_PREPROCESSOR: u32 = 131072;
pub const ACPI_ALL_COMPONENTS: u32 = 131071;
pub const ACPI_COMPONENT_DEFAULT: u32 = 131071;
pub const ACPI_ALL_DRIVERS: u32 = 4294901760;
pub const ACPI_LV_INIT: u32 = 1;
pub const ACPI_LV_DEBUG_OBJECT: u32 = 2;
pub const ACPI_LV_INFO: u32 = 4;
pub const ACPI_LV_REPAIR: u32 = 8;
pub const ACPI_LV_TRACE_POINT: u32 = 16;
pub const ACPI_LV_ALL_EXCEPTIONS: u32 = 31;
pub const ACPI_LV_INIT_NAMES: u32 = 32;
pub const ACPI_LV_PARSE: u32 = 64;
pub const ACPI_LV_LOAD: u32 = 128;
pub const ACPI_LV_DISPATCH: u32 = 256;
pub const ACPI_LV_EXEC: u32 = 512;
pub const ACPI_LV_NAMES: u32 = 1024;
pub const ACPI_LV_OPREGION: u32 = 2048;
pub const ACPI_LV_BFIELD: u32 = 4096;
pub const ACPI_LV_TABLES: u32 = 8192;
pub const ACPI_LV_VALUES: u32 = 16384;
pub const ACPI_LV_OBJECTS: u32 = 32768;
pub const ACPI_LV_RESOURCES: u32 = 65536;
pub const ACPI_LV_USER_REQUESTS: u32 = 131072;
pub const ACPI_LV_PACKAGE: u32 = 262144;
pub const ACPI_LV_EVALUATION: u32 = 524288;
pub const ACPI_LV_VERBOSITY1: u32 = 1048415;
pub const ACPI_LV_ALLOCATIONS: u32 = 1048576;
pub const ACPI_LV_FUNCTIONS: u32 = 2097152;
pub const ACPI_LV_OPTIMIZATIONS: u32 = 4194304;
pub const ACPI_LV_PARSE_TREES: u32 = 8388608;
pub const ACPI_LV_VERBOSITY2: u32 = 16777055;
pub const ACPI_LV_ALL: u32 = 16777055;
pub const ACPI_LV_MUTEX: u32 = 16777216;
pub const ACPI_LV_THREADS: u32 = 33554432;
pub const ACPI_LV_IO: u32 = 67108864;
pub const ACPI_LV_INTERRUPTS: u32 = 134217728;
pub const ACPI_LV_VERBOSITY3: u32 = 268435295;
pub const ACPI_LV_AML_DISASSEMBLE: u32 = 268435456;
pub const ACPI_LV_VERBOSE_INFO: u32 = 536870912;
pub const ACPI_LV_FULL_TABLES: u32 = 1073741824;
pub const ACPI_LV_EVENTS: u32 = 2147483648;
pub const ACPI_LV_VERBOSE: u32 = 4026531840;
pub const ACPI_NORMAL_DEFAULT: u32 = 11;
pub const ACPI_DEBUG_ALL: u32 = 285212511;
pub const ACPI_TRACE_LEVEL_ALL: u32 = 16777055;
pub const ACPI_TRACE_LAYER_ALL: u32 = 511;
pub const ACPI_TRACE_LEVEL_DEFAULT: u32 = 16;
pub const ACPI_TRACE_LAYER_DEFAULT: u32 = 128;
pub const ACPI_MUTEX_SEM: u32 = 1;
pub const ACPI_SIGNAL_FATAL: u32 = 0;
pub const ACPI_SIGNAL_BREAKPOINT: u32 = 1;
pub const REQUEST_FILE_ONLY: u32 = 0;
pub const REQUEST_DIR_ONLY: u32 = 1;
pub const ACPI_CA_VERSION: u32 = 539297799;
pub const ACPI_OS_NAME: &[u8; 21] = b"Microsoft Windows NT\0";
pub const ACPI_MAX_STATE_CACHE_DEPTH: u32 = 96;
pub const ACPI_MAX_PARSE_CACHE_DEPTH: u32 = 96;
pub const ACPI_MAX_EXTPARSE_CACHE_DEPTH: u32 = 96;
pub const ACPI_MAX_OBJECT_CACHE_DEPTH: u32 = 96;
pub const ACPI_MAX_NAMESPACE_CACHE_DEPTH: u32 = 96;
pub const ACPI_MAX_COMMENT_CACHE_DEPTH: u32 = 96;
pub const ACPI_CA_SUPPORT_LEVEL: u32 = 5;
pub const ACPI_MAX_SEMAPHORE_COUNT: u32 = 256;
pub const ACPI_MAX_REFERENCE_COUNT: u32 = 16384;
pub const ACPI_DEFAULT_PAGE_SIZE: u32 = 4096;
pub const ACPI_NUM_OWNERID_MASKS: u32 = 128;
pub const ACPI_ROOT_TABLE_SIZE_INCREMENT: u32 = 4;
pub const ACPI_MAX_SLEEP: u32 = 2000;
pub const ACPI_ADDRESS_RANGE_MAX: u32 = 2;
pub const ACPI_MAX_LOOP_TIMEOUT: u32 = 30;
pub const ACPI_METHOD_NUM_LOCALS: u32 = 8;
pub const ACPI_METHOD_MAX_LOCAL: u32 = 7;
pub const ACPI_METHOD_NUM_ARGS: u32 = 7;
pub const ACPI_METHOD_MAX_ARG: u32 = 6;
pub const ACPI_OBJ_NUM_OPERANDS: u32 = 8;
pub const ACPI_OBJ_MAX_OPERAND: u32 = 7;
pub const ACPI_RESULTS_FRAME_OBJ_NUM: u32 = 8;
pub const ACPI_RESULTS_OBJ_NUM_MAX: u32 = 255;
pub const ACPI_EBDA_PTR_LOCATION: u32 = 1038;
pub const ACPI_EBDA_PTR_LENGTH: u32 = 2;
pub const ACPI_EBDA_WINDOW_SIZE: u32 = 1024;
pub const ACPI_HI_RSDP_WINDOW_BASE: u32 = 917504;
pub const ACPI_HI_RSDP_WINDOW_SIZE: u32 = 131072;
pub const ACPI_RSDP_SCAN_STEP: u32 = 16;
pub const ACPI_USER_REGION_BEGIN: u32 = 128;
pub const ACPI_MAX_ADDRESS_SPACE: u32 = 255;
pub const ACPI_NUM_DEFAULT_SPACES: u32 = 4;
pub const ACPI_MAX_MATCH_OPCODE: u32 = 5;
pub const ACPI_RSDP_CHECKSUM_LENGTH: u32 = 20;
pub const ACPI_RSDP_XCHECKSUM_LENGTH: u32 = 36;
pub const ACPI_SERIAL_HEADER_SIZE: u32 = 2;
pub const ACPI_SMBUS_DATA_SIZE: u32 = 32;
pub const ACPI_SMBUS_BUFFER_SIZE: u32 = 34;
pub const ACPI_IPMI_DATA_SIZE: u32 = 64;
pub const ACPI_IPMI_BUFFER_SIZE: u32 = 66;
pub const ACPI_MAX_GSBUS_DATA_SIZE: u32 = 255;
pub const ACPI_MAX_GSBUS_BUFFER_SIZE: u32 = 257;
pub const ACPI_PRM_INPUT_BUFFER_SIZE: u32 = 26;
pub const ACPI_FFH_INPUT_BUFFER_SIZE: u32 = 256;
pub const ACPI_NUM_sx_d_METHODS: u32 = 4;
pub const ACPI_NUM_sx_w_METHODS: u32 = 5;
pub const UUID_BUFFER_LENGTH: u32 = 16;
pub const UUID_STRING_LENGTH: u32 = 36;
pub const UUID_HYPHEN1_OFFSET: u32 = 8;
pub const UUID_HYPHEN2_OFFSET: u32 = 13;
pub const UUID_HYPHEN3_OFFSET: u32 = 18;
pub const UUID_HYPHEN4_OFFSET: u32 = 23;
pub const ACPI_DEBUGGER_MAX_ARGS: u32 = 11;
pub const ACPI_DB_LINE_BUFFER_SIZE: u32 = 512;
pub const ACPI_DEBUGGER_COMMAND_PROMPT: u8 = 45u8;
pub const ACPI_DEBUGGER_EXECUTE_PROMPT: u8 = 37u8;
pub const ACPI_PLD_REV1_BUFFER_SIZE: u32 = 16;
pub const ACPI_PLD_REV2_BUFFER_SIZE: u32 = 20;
pub const ACPI_PLD_BUFFER_SIZE: u32 = 20;
pub const ACPI_PLD_PANEL_TOP: u32 = 0;
pub const ACPI_PLD_PANEL_BOTTOM: u32 = 1;
pub const ACPI_PLD_PANEL_LEFT: u32 = 2;
pub const ACPI_PLD_PANEL_RIGHT: u32 = 3;
pub const ACPI_PLD_PANEL_FRONT: u32 = 4;
pub const ACPI_PLD_PANEL_BACK: u32 = 5;
pub const ACPI_PLD_PANEL_UNKNOWN: u32 = 6;
pub const MAX_PXM_DOMAINS: u32 = 1024;
pub const ACPI_BUS_FILE_ROOT: &[u8; 5] = b"acpi\0";
pub const ACPI_DRIVER_ALL_NOTIFY_EVENTS: u32 = 1;
pub const MAX_ACPI_DEVICE_NAME_LEN: u32 = 40;
pub const MAX_ACPI_CLASS_NAME_LEN: u32 = 20;
pub const ACPI_DEVICE_SWNODE_ROOT: u32 = 0;
pub const ACPI_DEVICE_CSI2_DATA_LANES: u32 = 8;
pub const ACPI_DEVICE_SWNODE_PORT_NAME_LENGTH: u32 = 8;
pub const ACPI_MAX_STRING: u32 = 80;
pub const ACPI_POWER_HID: &[u8; 9] = b"LNXPOWER\0";
pub const ACPI_PROCESSOR_OBJECT_HID: &[u8; 7] = b"LNXCPU\0";
pub const ACPI_SYSTEM_HID: &[u8; 9] = b"LNXSYSTM\0";
pub const ACPI_THERMAL_HID: &[u8; 9] = b"LNXTHERM\0";
pub const ACPI_BUTTON_HID_POWERF: &[u8; 9] = b"LNXPWRBN\0";
pub const ACPI_BUTTON_HID_SLEEPF: &[u8; 9] = b"LNXSLPBN\0";
pub const ACPI_VIDEO_HID: &[u8; 9] = b"LNXVIDEO\0";
pub const ACPI_BAY_HID: &[u8; 9] = b"LNXIOBAY\0";
pub const ACPI_DOCK_HID: &[u8; 8] = b"LNXDOCK\0";
pub const ACPI_ECDT_HID: &[u8; 6] = b"LNXEC\0";
pub const ACPI_SMBUS_MS_HID: &[u8; 8] = b"SMB0001\0";
pub const ACPI_SMBUS_IBM_HID: &[u8; 9] = b"SMBUSIBM\0";
pub const ACPI_FIXED_HARDWARE_EVENT: u32 = 256;
pub const SZ_1: u32 = 1;
pub const SZ_2: u32 = 2;
pub const SZ_4: u32 = 4;
pub const SZ_8: u32 = 8;
pub const SZ_16: u32 = 16;
pub const SZ_32: u32 = 32;
pub const SZ_64: u32 = 64;
pub const SZ_128: u32 = 128;
pub const SZ_256: u32 = 256;
pub const SZ_512: u32 = 512;
pub const SZ_1K: u32 = 1024;
pub const SZ_2K: u32 = 2048;
pub const SZ_4K: u32 = 4096;
pub const SZ_8K: u32 = 8192;
pub const SZ_16K: u32 = 16384;
pub const SZ_24K: u32 = 24576;
pub const SZ_32K: u32 = 32768;
pub const SZ_64K: u32 = 65536;
pub const SZ_128K: u32 = 131072;
pub const SZ_192K: u32 = 196608;
pub const SZ_256K: u32 = 262144;
pub const SZ_384K: u32 = 393216;
pub const SZ_512K: u32 = 524288;
pub const SZ_1M: u32 = 1048576;
pub const SZ_2M: u32 = 2097152;
pub const SZ_3M: u32 = 3145728;
pub const SZ_4M: u32 = 4194304;
pub const SZ_6M: u32 = 6291456;
pub const SZ_8M: u32 = 8388608;
pub const SZ_12M: u32 = 12582912;
pub const SZ_16M: u32 = 16777216;
pub const SZ_18M: u32 = 18874368;
pub const SZ_24M: u32 = 25165824;
pub const SZ_32M: u32 = 33554432;
pub const SZ_64M: u32 = 67108864;
pub const SZ_128M: u32 = 134217728;
pub const SZ_256M: u32 = 268435456;
pub const SZ_512M: u32 = 536870912;
pub const SZ_1G: u32 = 1073741824;
pub const SZ_2G: u32 = 2147483648;
pub const IO_SPACE_LIMIT: u32 = 65535;
pub const PIO_INDIRECT_SIZE: u32 = 0;
pub const MMIO_UPPER_LIMIT: u32 = 65535;
pub const ACPI_PROC_CAP_P_FFH: u32 = 1;
pub const ACPI_PROC_CAP_C_C1_HALT: u32 = 2;
pub const ACPI_PROC_CAP_T_FFH: u32 = 4;
pub const ACPI_PROC_CAP_SMP_C1PT: u32 = 8;
pub const ACPI_PROC_CAP_SMP_C2C3: u32 = 16;
pub const ACPI_PROC_CAP_SMP_P_SWCOORD: u32 = 32;
pub const ACPI_PROC_CAP_SMP_C_SWCOORD: u32 = 64;
pub const ACPI_PROC_CAP_SMP_T_SWCOORD: u32 = 128;
pub const ACPI_PROC_CAP_C_C1_FFH: u32 = 256;
pub const ACPI_PROC_CAP_C_C2C3_FFH: u32 = 512;
pub const ACPI_PROC_CAP_SMP_P_HWCOORD: u32 = 2048;
pub const ACPI_PROC_CAP_COLLAB_PROC_PERF: u32 = 4096;
pub const ACPI_PROC_CAP_EST_CAPABILITY_SMP: u32 = 11;
pub const ACPI_PROC_CAP_EST_CAPABILITY_SWSMP: u32 = 2091;
pub const ACPI_PROC_CAP_C_CAPABILITY_SMP: u32 = 794;
pub const NMI_VECTOR: u32 = 2;
pub const FIRST_EXTERNAL_VECTOR: u32 = 32;
pub const IA32_SYSCALL_VECTOR: u32 = 128;
pub const SPURIOUS_APIC_VECTOR: u32 = 255;
pub const ERROR_APIC_VECTOR: u32 = 254;
pub const RESCHEDULE_VECTOR: u32 = 253;
pub const CALL_FUNCTION_VECTOR: u32 = 252;
pub const CALL_FUNCTION_SINGLE_VECTOR: u32 = 251;
pub const THERMAL_APIC_VECTOR: u32 = 250;
pub const THRESHOLD_APIC_VECTOR: u32 = 249;
pub const REBOOT_VECTOR: u32 = 248;
pub const X86_PLATFORM_IPI_VECTOR: u32 = 247;
pub const IRQ_WORK_VECTOR: u32 = 246;
pub const DEFERRED_ERROR_VECTOR: u32 = 244;
pub const HYPERVISOR_CALLBACK_VECTOR: u32 = 243;
pub const POSTED_INTR_VECTOR: u32 = 242;
pub const POSTED_INTR_WAKEUP_VECTOR: u32 = 241;
pub const POSTED_INTR_NESTED_VECTOR: u32 = 240;
pub const MANAGED_IRQ_SHUTDOWN_VECTOR: u32 = 239;
pub const HYPERV_REENLIGHTENMENT_VECTOR: u32 = 238;
pub const HYPERV_STIMER0_VECTOR: u32 = 237;
pub const LOCAL_TIMER_VECTOR: u32 = 236;
pub const POSTED_MSI_NOTIFICATION_VECTOR: u32 = 235;
pub const NR_VECTORS: u32 = 256;
pub const FIRST_SYSTEM_VECTOR: u32 = 235;
pub const NR_EXTERNAL_VECTORS: u32 = 203;
pub const NR_SYSTEM_VECTORS: u32 = 21;
pub const NR_IRQS_LEGACY: u32 = 16;
pub const CPU_VECTOR_LIMIT: u32 = 524288;
pub const IO_APIC_VECTOR_LIMIT: u32 = 4096;
pub const XEN_SIGNATURE: &[u8; 13] = b"XenVMMXenVMM\0";
pub const XEN_HVM_START_MAGIC_VALUE: u32 = 862897528;
pub const XEN_HVM_MEMMAP_TYPE_RAM: u32 = 1;
pub const XEN_HVM_MEMMAP_TYPE_RESERVED: u32 = 2;
pub const XEN_HVM_MEMMAP_TYPE_ACPI: u32 = 3;
pub const XEN_HVM_MEMMAP_TYPE_NVS: u32 = 4;
pub const XEN_HVM_MEMMAP_TYPE_UNUSABLE: u32 = 5;
pub const XEN_HVM_MEMMAP_TYPE_DISABLED: u32 = 6;
pub const XEN_HVM_MEMMAP_TYPE_PMEM: u32 = 7;
pub const PRI_xen_pfn: &[u8; 3] = b"lx\0";
pub const PRI_xen_ulong: &[u8; 3] = b"lx\0";
pub const PRI_xen_long: &[u8; 3] = b"lx\0";
pub const MAX_VIRT_CPUS: u32 = 32;
pub const FIRST_RESERVED_GDT_PAGE: u32 = 14;
pub const FIRST_RESERVED_GDT_BYTE: u32 = 57344;
pub const FIRST_RESERVED_GDT_ENTRY: u32 = 7168;
pub const FLAT_RING3_CS32: u32 = 57379;
pub const FLAT_RING3_CS64: u32 = 57395;
pub const FLAT_RING3_DS32: u32 = 57387;
pub const FLAT_RING3_DS64: u32 = 0;
pub const FLAT_RING3_SS32: u32 = 57387;
pub const FLAT_RING3_SS64: u32 = 57387;
pub const FLAT_KERNEL_DS64: u32 = 0;
pub const FLAT_KERNEL_DS32: u32 = 57387;
pub const FLAT_KERNEL_DS: u32 = 0;
pub const FLAT_KERNEL_CS64: u32 = 57395;
pub const FLAT_KERNEL_CS32: u32 = 57379;
pub const FLAT_KERNEL_CS: u32 = 57395;
pub const FLAT_KERNEL_SS64: u32 = 57387;
pub const FLAT_KERNEL_SS32: u32 = 57387;
pub const FLAT_KERNEL_SS: u32 = 57387;
pub const FLAT_USER_DS64: u32 = 0;
pub const FLAT_USER_DS32: u32 = 57387;
pub const FLAT_USER_DS: u32 = 0;
pub const FLAT_USER_CS64: u32 = 57395;
pub const FLAT_USER_CS32: u32 = 57379;
pub const FLAT_USER_CS: u32 = 57395;
pub const FLAT_USER_SS64: u32 = 57387;
pub const FLAT_USER_SS32: u32 = 57387;
pub const FLAT_USER_SS: u32 = 57387;
pub const __HYPERVISOR_VIRT_START: i64 = -140737488355328;
pub const __HYPERVISOR_VIRT_END: i64 = -131941395333120;
pub const __MACH2PHYS_VIRT_START: i64 = -140737488355328;
pub const __MACH2PHYS_VIRT_END: i64 = -140462610448384;
pub const __MACH2PHYS_SHIFT: u32 = 3;
pub const SEGBASE_FS: u32 = 0;
pub const SEGBASE_GS_USER: u32 = 1;
pub const SEGBASE_GS_KERNEL: u32 = 2;
pub const SEGBASE_GS_USER_SEL: u32 = 3;
pub const _VGCF_in_syscall: u32 = 8;
pub const VGCF_in_syscall: u32 = 256;
pub const VGCF_IN_SYSCALL: u32 = 256;
pub const PVCLOCK_TSC_STABLE_BIT: u32 = 1;
pub const PVCLOCK_GUEST_STOPPED: u32 = 2;
pub const PVCLOCK_COUNTS_FROM_ZERO: u32 = 4;
pub const VGCF_I387_VALID: u32 = 1;
pub const VGCF_IN_KERNEL: u32 = 4;
pub const _VGCF_i387_valid: u32 = 0;
pub const VGCF_i387_valid: u32 = 1;
pub const _VGCF_in_kernel: u32 = 2;
pub const VGCF_in_kernel: u32 = 4;
pub const _VGCF_failsafe_disables_events: u32 = 3;
pub const VGCF_failsafe_disables_events: u32 = 8;
pub const _VGCF_syscall_disables_events: u32 = 4;
pub const VGCF_syscall_disables_events: u32 = 16;
pub const _VGCF_online: u32 = 5;
pub const VGCF_online: u32 = 32;
pub const PMU_CACHED: u32 = 1;
pub const PMU_SAMPLE_USER: u32 = 2;
pub const PMU_SAMPLE_REAL: u32 = 4;
pub const PMU_SAMPLE_PV: u32 = 8;
pub const XENPMU_REGS_PAD_SZ: u32 = 64;
pub const XENPMU_CTXT_PAD_SZ: u32 = 128;
pub const __HYPERVISOR_set_trap_table: u32 = 0;
pub const __HYPERVISOR_mmu_update: u32 = 1;
pub const __HYPERVISOR_set_gdt: u32 = 2;
pub const __HYPERVISOR_stack_switch: u32 = 3;
pub const __HYPERVISOR_set_callbacks: u32 = 4;
pub const __HYPERVISOR_fpu_taskswitch: u32 = 5;
pub const __HYPERVISOR_sched_op_compat: u32 = 6;
pub const __HYPERVISOR_platform_op: u32 = 7;
pub const __HYPERVISOR_set_debugreg: u32 = 8;
pub const __HYPERVISOR_get_debugreg: u32 = 9;
pub const __HYPERVISOR_update_descriptor: u32 = 10;
pub const __HYPERVISOR_memory_op: u32 = 12;
pub const __HYPERVISOR_multicall: u32 = 13;
pub const __HYPERVISOR_update_va_mapping: u32 = 14;
pub const __HYPERVISOR_set_timer_op: u32 = 15;
pub const __HYPERVISOR_event_channel_op_compat: u32 = 16;
pub const __HYPERVISOR_xen_version: u32 = 17;
pub const __HYPERVISOR_console_io: u32 = 18;
pub const __HYPERVISOR_physdev_op_compat: u32 = 19;
pub const __HYPERVISOR_grant_table_op: u32 = 20;
pub const __HYPERVISOR_vm_assist: u32 = 21;
pub const __HYPERVISOR_update_va_mapping_otherdomain: u32 = 22;
pub const __HYPERVISOR_iret: u32 = 23;
pub const __HYPERVISOR_vcpu_op: u32 = 24;
pub const __HYPERVISOR_set_segment_base: u32 = 25;
pub const __HYPERVISOR_mmuext_op: u32 = 26;
pub const __HYPERVISOR_xsm_op: u32 = 27;
pub const __HYPERVISOR_nmi_op: u32 = 28;
pub const __HYPERVISOR_sched_op: u32 = 29;
pub const __HYPERVISOR_callback_op: u32 = 30;
pub const __HYPERVISOR_xenoprof_op: u32 = 31;
pub const __HYPERVISOR_event_channel_op: u32 = 32;
pub const __HYPERVISOR_physdev_op: u32 = 33;
pub const __HYPERVISOR_hvm_op: u32 = 34;
pub const __HYPERVISOR_sysctl: u32 = 35;
pub const __HYPERVISOR_domctl: u32 = 36;
pub const __HYPERVISOR_kexec_op: u32 = 37;
pub const __HYPERVISOR_tmem_op: u32 = 38;
pub const __HYPERVISOR_xc_reserved_op: u32 = 39;
pub const __HYPERVISOR_xenpmu_op: u32 = 40;
pub const __HYPERVISOR_dm_op: u32 = 41;
pub const __HYPERVISOR_arch_0: u32 = 48;
pub const __HYPERVISOR_arch_1: u32 = 49;
pub const __HYPERVISOR_arch_2: u32 = 50;
pub const __HYPERVISOR_arch_3: u32 = 51;
pub const __HYPERVISOR_arch_4: u32 = 52;
pub const __HYPERVISOR_arch_5: u32 = 53;
pub const __HYPERVISOR_arch_6: u32 = 54;
pub const __HYPERVISOR_arch_7: u32 = 55;
pub const VIRQ_TIMER: u32 = 0;
pub const VIRQ_DEBUG: u32 = 1;
pub const VIRQ_CONSOLE: u32 = 2;
pub const VIRQ_DOM_EXC: u32 = 3;
pub const VIRQ_TBUF: u32 = 4;
pub const VIRQ_DEBUGGER: u32 = 6;
pub const VIRQ_XENOPROF: u32 = 7;
pub const VIRQ_CON_RING: u32 = 8;
pub const VIRQ_PCPU_STATE: u32 = 9;
pub const VIRQ_MEM_EVENT: u32 = 10;
pub const VIRQ_XC_RESERVED: u32 = 11;
pub const VIRQ_ENOMEM: u32 = 12;
pub const VIRQ_XENPMU: u32 = 13;
pub const VIRQ_ARCH_0: u32 = 16;
pub const VIRQ_ARCH_1: u32 = 17;
pub const VIRQ_ARCH_2: u32 = 18;
pub const VIRQ_ARCH_3: u32 = 19;
pub const VIRQ_ARCH_4: u32 = 20;
pub const VIRQ_ARCH_5: u32 = 21;
pub const VIRQ_ARCH_6: u32 = 22;
pub const VIRQ_ARCH_7: u32 = 23;
pub const NR_VIRQS: u32 = 24;
pub const MMU_NORMAL_PT_UPDATE: u32 = 0;
pub const MMU_MACHPHYS_UPDATE: u32 = 1;
pub const MMU_PT_UPDATE_PRESERVE_AD: u32 = 2;
pub const MMU_PT_UPDATE_NO_TRANSLATE: u32 = 3;
pub const MMUEXT_PIN_L1_TABLE: u32 = 0;
pub const MMUEXT_PIN_L2_TABLE: u32 = 1;
pub const MMUEXT_PIN_L3_TABLE: u32 = 2;
pub const MMUEXT_PIN_L4_TABLE: u32 = 3;
pub const MMUEXT_UNPIN_TABLE: u32 = 4;
pub const MMUEXT_NEW_BASEPTR: u32 = 5;
pub const MMUEXT_TLB_FLUSH_LOCAL: u32 = 6;
pub const MMUEXT_INVLPG_LOCAL: u32 = 7;
pub const MMUEXT_TLB_FLUSH_MULTI: u32 = 8;
pub const MMUEXT_INVLPG_MULTI: u32 = 9;
pub const MMUEXT_TLB_FLUSH_ALL: u32 = 10;
pub const MMUEXT_INVLPG_ALL: u32 = 11;
pub const MMUEXT_FLUSH_CACHE: u32 = 12;
pub const MMUEXT_SET_LDT: u32 = 13;
pub const MMUEXT_NEW_USER_BASEPTR: u32 = 15;
pub const MMUEXT_CLEAR_PAGE: u32 = 16;
pub const MMUEXT_COPY_PAGE: u32 = 17;
pub const MMUEXT_FLUSH_CACHE_GLOBAL: u32 = 18;
pub const MMUEXT_MARK_SUPER: u32 = 19;
pub const MMUEXT_UNMARK_SUPER: u32 = 20;
pub const UVMF_NONE: u32 = 0;
pub const UVMF_TLB_FLUSH: u32 = 1;
pub const UVMF_INVLPG: u32 = 2;
pub const UVMF_FLUSHTYPE_MASK: u32 = 3;
pub const UVMF_MULTI: u32 = 0;
pub const UVMF_LOCAL: u32 = 0;
pub const UVMF_ALL: u32 = 4;
pub const CONSOLEIO_write: u32 = 0;
pub const CONSOLEIO_read: u32 = 1;
pub const VMASST_CMD_enable: u32 = 0;
pub const VMASST_CMD_disable: u32 = 1;
pub const VMASST_TYPE_4gb_segments: u32 = 0;
pub const VMASST_TYPE_4gb_segments_notify: u32 = 1;
pub const VMASST_TYPE_writable_pagetables: u32 = 2;
pub const VMASST_TYPE_pae_extended_cr3: u32 = 3;
pub const VMASST_TYPE_architectural_iopl: u32 = 4;
pub const VMASST_TYPE_runstate_update_flag: u32 = 5;
pub const MAX_VMASST_TYPE: u32 = 5;
pub const DOMID_FIRST_RESERVED: u32 = 32752;
pub const DOMID_SELF: u32 = 32752;
pub const DOMID_IO: u32 = 32753;
pub const DOMID_XEN: u32 = 32754;
pub const DOMID_COW: u32 = 32755;
pub const DOMID_INVALID: u32 = 32756;
pub const DOMID_IDLE: u32 = 32767;
pub const MAX_GUEST_CMDLINE: u32 = 1024;
pub const SIF_PRIVILEGED: u32 = 1;
pub const SIF_INITDOMAIN: u32 = 2;
pub const SIF_MULTIBOOT_MOD: u32 = 4;
pub const SIF_MOD_START_PFN: u32 = 8;
pub const SIF_VIRT_P2M_4TOOLS: u32 = 16;
pub const SIF_PM_MASK: u32 = 65280;
pub const XEN_VGATYPE_TEXT_MODE_3: u32 = 3;
pub const XEN_VGATYPE_VESA_LFB: u32 = 35;
pub const XEN_VGATYPE_EFI_LFB: u32 = 112;
pub const TMEM_SPEC_VERSION: u32 = 1;
pub const ARCH_HAS_POWER_INIT: u32 = 1;
pub const ACPI_SPACE_MEM: u32 = 0;
pub const ACPI_VIDEO_OUTPUT_SWITCHING: u32 = 1;
pub const ACPI_VIDEO_DEVICE_POSTING: u32 = 2;
pub const ACPI_VIDEO_ROM_AVAILABLE: u32 = 4;
pub const ACPI_VIDEO_BACKLIGHT: u32 = 8;
pub const ACPI_VIDEO_BACKLIGHT_FORCE_VENDOR: u32 = 16;
pub const ACPI_VIDEO_BACKLIGHT_FORCE_VIDEO: u32 = 32;
pub const ACPI_VIDEO_OUTPUT_SWITCHING_FORCE_VENDOR: u32 = 64;
pub const ACPI_VIDEO_OUTPUT_SWITCHING_FORCE_VIDEO: u32 = 128;
pub const ACPI_VIDEO_BACKLIGHT_DMI_VENDOR: u32 = 256;
pub const ACPI_VIDEO_BACKLIGHT_DMI_VIDEO: u32 = 512;
pub const ACPI_VIDEO_OUTPUT_SWITCHING_DMI_VENDOR: u32 = 1024;
pub const ACPI_VIDEO_OUTPUT_SWITCHING_DMI_VIDEO: u32 = 2048;
pub const PXM_INVAL: i32 = -1;
pub const OSC_PCI_CAPABILITY_DWORDS: u32 = 3;
pub const OSC_CXL_CAPABILITY_DWORDS: u32 = 5;
pub const OSC_QUERY_DWORD: u32 = 0;
pub const OSC_SUPPORT_DWORD: u32 = 1;
pub const OSC_CONTROL_DWORD: u32 = 2;
pub const OSC_EXT_SUPPORT_DWORD: u32 = 3;
pub const OSC_EXT_CONTROL_DWORD: u32 = 4;
pub const OSC_QUERY_ENABLE: u32 = 1;
pub const OSC_REQUEST_ERROR: u32 = 2;
pub const OSC_INVALID_UUID_ERROR: u32 = 4;
pub const OSC_INVALID_REVISION_ERROR: u32 = 8;
pub const OSC_CAPABILITIES_MASK_ERROR: u32 = 16;
pub const OSC_SB_PAD_SUPPORT: u32 = 1;
pub const OSC_SB_PPC_OST_SUPPORT: u32 = 2;
pub const OSC_SB_PR3_SUPPORT: u32 = 4;
pub const OSC_SB_HOTPLUG_OST_SUPPORT: u32 = 8;
pub const OSC_SB_APEI_SUPPORT: u32 = 16;
pub const OSC_SB_CPC_SUPPORT: u32 = 32;
pub const OSC_SB_CPCV2_SUPPORT: u32 = 64;
pub const OSC_SB_PCLPI_SUPPORT: u32 = 128;
pub const OSC_SB_OSLPI_SUPPORT: u32 = 256;
pub const OSC_SB_FAST_THERMAL_SAMPLING_SUPPORT: u32 = 512;
pub const OSC_SB_OVER_16_PSTATES_SUPPORT: u32 = 1024;
pub const OSC_SB_GED_SUPPORT: u32 = 2048;
pub const OSC_SB_CPC_DIVERSE_HIGH_SUPPORT: u32 = 4096;
pub const OSC_SB_IRQ_RESOURCE_SOURCE_SUPPORT: u32 = 8192;
pub const OSC_SB_CPC_FLEXIBLE_ADR_SPACE: u32 = 16384;
pub const OSC_SB_GENERIC_INITIATOR_SUPPORT: u32 = 131072;
pub const OSC_SB_NATIVE_USB4_SUPPORT: u32 = 262144;
pub const OSC_SB_BATTERY_CHARGE_LIMITING_SUPPORT: u32 = 524288;
pub const OSC_SB_PRM_SUPPORT: u32 = 2097152;
pub const OSC_SB_FFH_OPR_SUPPORT: u32 = 4194304;
pub const OSC_USB_USB3_TUNNELING: u32 = 1;
pub const OSC_USB_DP_TUNNELING: u32 = 2;
pub const OSC_USB_PCIE_TUNNELING: u32 = 4;
pub const OSC_USB_XDOMAIN: u32 = 8;
pub const OSC_PCI_EXT_CONFIG_SUPPORT: u32 = 1;
pub const OSC_PCI_ASPM_SUPPORT: u32 = 2;
pub const OSC_PCI_CLOCK_PM_SUPPORT: u32 = 4;
pub const OSC_PCI_SEGMENT_GROUPS_SUPPORT: u32 = 8;
pub const OSC_PCI_MSI_SUPPORT: u32 = 16;
pub const OSC_PCI_EDR_SUPPORT: u32 = 128;
pub const OSC_PCI_HPX_TYPE_3_SUPPORT: u32 = 256;
pub const OSC_PCI_EXPRESS_NATIVE_HP_CONTROL: u32 = 1;
pub const OSC_PCI_SHPC_NATIVE_HP_CONTROL: u32 = 2;
pub const OSC_PCI_EXPRESS_PME_CONTROL: u32 = 4;
pub const OSC_PCI_EXPRESS_AER_CONTROL: u32 = 8;
pub const OSC_PCI_EXPRESS_CAPABILITY_CONTROL: u32 = 16;
pub const OSC_PCI_EXPRESS_LTR_CONTROL: u32 = 32;
pub const OSC_PCI_EXPRESS_DPC_CONTROL: u32 = 128;
pub const OSC_CXL_1_1_PORT_REG_ACCESS_SUPPORT: u32 = 1;
pub const OSC_CXL_2_0_PORT_DEV_REG_ACCESS_SUPPORT: u32 = 2;
pub const OSC_CXL_PROTOCOL_ERR_REPORTING_SUPPORT: u32 = 4;
pub const OSC_CXL_NATIVE_HP_SUPPORT: u32 = 8;
pub const OSC_CXL_ERROR_REPORTING_CONTROL: u32 = 1;
pub const ACPI_GSB_ACCESS_ATTRIB_QUICK: u32 = 2;
pub const ACPI_GSB_ACCESS_ATTRIB_SEND_RCV: u32 = 4;
pub const ACPI_GSB_ACCESS_ATTRIB_BYTE: u32 = 6;
pub const ACPI_GSB_ACCESS_ATTRIB_WORD: u32 = 8;
pub const ACPI_GSB_ACCESS_ATTRIB_BLOCK: u32 = 10;
pub const ACPI_GSB_ACCESS_ATTRIB_MULTIBYTE: u32 = 11;
pub const ACPI_GSB_ACCESS_ATTRIB_WORD_CALL: u32 = 12;
pub const ACPI_GSB_ACCESS_ATTRIB_BLOCK_CALL: u32 = 13;
pub const ACPI_GSB_ACCESS_ATTRIB_RAW_BYTES: u32 = 14;
pub const ACPI_GSB_ACCESS_ATTRIB_RAW_PROCESS: u32 = 15;
pub const ACPI_OST_EC_OSPM_SHUTDOWN: u32 = 256;
pub const ACPI_OST_EC_OSPM_EJECT: u32 = 259;
pub const ACPI_OST_EC_OSPM_INSERTION: u32 = 512;
pub const ACPI_OST_SC_SUCCESS: u32 = 0;
pub const ACPI_OST_SC_NON_SPECIFIC_FAILURE: u32 = 1;
pub const ACPI_OST_SC_UNRECOGNIZED_NOTIFY: u32 = 2;
pub const ACPI_OST_SC_OS_SHUTDOWN_DENIED: u32 = 128;
pub const ACPI_OST_SC_OS_SHUTDOWN_IN_PROGRESS: u32 = 129;
pub const ACPI_OST_SC_OS_SHUTDOWN_COMPLETED: u32 = 130;
pub const ACPI_OST_SC_OS_SHUTDOWN_NOT_SUPPORTED: u32 = 131;
pub const ACPI_OST_SC_EJECT_NOT_SUPPORTED: u32 = 128;
pub const ACPI_OST_SC_DEVICE_IN_USE: u32 = 129;
pub const ACPI_OST_SC_DEVICE_BUSY: u32 = 130;
pub const ACPI_OST_SC_EJECT_DEPENDENCY_BUSY: u32 = 131;
pub const ACPI_OST_SC_EJECT_IN_PROGRESS: u32 = 132;
pub const ACPI_OST_SC_INSERT_IN_PROGRESS: u32 = 128;
pub const ACPI_OST_SC_DRIVER_LOAD_FAILURE: u32 = 129;
pub const ACPI_OST_SC_INSERT_NOT_SUPPORTED: u32 = 130;
pub const ACPI_TABLE_ID_LEN: u32 = 5;
pub const STACK_DEPOT_EXTRA_BITS: u32 = 5;
pub const DEPOT_POOL_ORDER: u32 = 2;
pub const DEPOT_POOL_SIZE: u32 = 16384;
pub const DEPOT_STACK_ALIGN: u32 = 4;
pub const DEPOT_OFFSET_BITS: u32 = 10;
pub const STACK_DEPOT_FLAGS_NUM: u32 = 2;
pub const RT_MUTEX_HAS_WAITERS: u32 = 1;
pub const DRM_NAME: &[u8; 4] = b"drm\0";
pub const DRM_MIN_ORDER: u32 = 5;
pub const DRM_MAX_ORDER: u32 = 22;
pub const DRM_RAM_PERCENT: u32 = 10;
pub const _DRM_LOCK_HELD: u32 = 2147483648;
pub const _DRM_LOCK_CONT: u32 = 1073741824;
pub const _DRM_VBLANK_HIGH_CRTC_SHIFT: u32 = 1;
pub const _DRM_PRE_MODESET: u32 = 1;
pub const _DRM_POST_MODESET: u32 = 2;
pub const DRM_CAP_DUMB_BUFFER: u32 = 1;
pub const DRM_CAP_VBLANK_HIGH_CRTC: u32 = 2;
pub const DRM_CAP_DUMB_PREFERRED_DEPTH: u32 = 3;
pub const DRM_CAP_DUMB_PREFER_SHADOW: u32 = 4;
pub const DRM_CAP_PRIME: u32 = 5;
pub const DRM_PRIME_CAP_IMPORT: u32 = 1;
pub const DRM_PRIME_CAP_EXPORT: u32 = 2;
pub const DRM_CAP_TIMESTAMP_MONOTONIC: u32 = 6;
pub const DRM_CAP_ASYNC_PAGE_FLIP: u32 = 7;
pub const DRM_CAP_CURSOR_WIDTH: u32 = 8;
pub const DRM_CAP_CURSOR_HEIGHT: u32 = 9;
pub const DRM_CAP_ADDFB2_MODIFIERS: u32 = 16;
pub const DRM_CAP_PAGE_FLIP_TARGET: u32 = 17;
pub const DRM_CAP_CRTC_IN_VBLANK_EVENT: u32 = 18;
pub const DRM_CAP_SYNCOBJ: u32 = 19;
pub const DRM_CAP_SYNCOBJ_TIMELINE: u32 = 20;
pub const DRM_CAP_ATOMIC_ASYNC_PAGE_FLIP: u32 = 21;
pub const DRM_CLIENT_CAP_STEREO_3D: u32 = 1;
pub const DRM_CLIENT_CAP_UNIVERSAL_PLANES: u32 = 2;
pub const DRM_CLIENT_CAP_ATOMIC: u32 = 3;
pub const DRM_CLIENT_CAP_ASPECT_RATIO: u32 = 4;
pub const DRM_CLIENT_CAP_WRITEBACK_CONNECTORS: u32 = 5;
pub const DRM_CLIENT_CAP_CURSOR_PLANE_HOTSPOT: u32 = 6;
pub const DRM_RDWR: u32 = 2;
pub const DRM_CLOEXEC: u32 = 524288;
pub const DRM_SYNCOBJ_CREATE_SIGNALED: u32 = 1;
pub const DRM_SYNCOBJ_FD_TO_HANDLE_FLAGS_IMPORT_SYNC_FILE: u32 = 1;
pub const DRM_SYNCOBJ_FD_TO_HANDLE_FLAGS_TIMELINE: u32 = 2;
pub const DRM_SYNCOBJ_HANDLE_TO_FD_FLAGS_EXPORT_SYNC_FILE: u32 = 1;
pub const DRM_SYNCOBJ_HANDLE_TO_FD_FLAGS_TIMELINE: u32 = 2;
pub const DRM_SYNCOBJ_WAIT_FLAGS_WAIT_ALL: u32 = 1;
pub const DRM_SYNCOBJ_WAIT_FLAGS_WAIT_FOR_SUBMIT: u32 = 2;
pub const DRM_SYNCOBJ_WAIT_FLAGS_WAIT_AVAILABLE: u32 = 4;
pub const DRM_SYNCOBJ_WAIT_FLAGS_WAIT_DEADLINE: u32 = 8;
pub const DRM_SYNCOBJ_QUERY_FLAGS_LAST_SUBMITTED: u32 = 1;
pub const DRM_CRTC_SEQUENCE_RELATIVE: u32 = 1;
pub const DRM_CRTC_SEQUENCE_NEXT_ON_MISS: u32 = 2;
pub const DRM_CLIENT_NAME_MAX_LEN: u32 = 64;
pub const DRM_CONNECTOR_NAME_LEN: u32 = 32;
pub const DRM_DISPLAY_MODE_LEN: u32 = 32;
pub const DRM_PROP_NAME_LEN: u32 = 32;
pub const DRM_MODE_TYPE_BUILTIN: u32 = 1;
pub const DRM_MODE_TYPE_CLOCK_C: u32 = 3;
pub const DRM_MODE_TYPE_CRTC_C: u32 = 5;
pub const DRM_MODE_TYPE_PREFERRED: u32 = 8;
pub const DRM_MODE_TYPE_DEFAULT: u32 = 16;
pub const DRM_MODE_TYPE_USERDEF: u32 = 32;
pub const DRM_MODE_TYPE_DRIVER: u32 = 64;
pub const DRM_MODE_TYPE_ALL: u32 = 104;
pub const DRM_MODE_FLAG_PHSYNC: u32 = 1;
pub const DRM_MODE_FLAG_NHSYNC: u32 = 2;
pub const DRM_MODE_FLAG_PVSYNC: u32 = 4;
pub const DRM_MODE_FLAG_NVSYNC: u32 = 8;
pub const DRM_MODE_FLAG_INTERLACE: u32 = 16;
pub const DRM_MODE_FLAG_DBLSCAN: u32 = 32;
pub const DRM_MODE_FLAG_CSYNC: u32 = 64;
pub const DRM_MODE_FLAG_PCSYNC: u32 = 128;
pub const DRM_MODE_FLAG_NCSYNC: u32 = 256;
pub const DRM_MODE_FLAG_HSKEW: u32 = 512;
pub const DRM_MODE_FLAG_BCAST: u32 = 1024;
pub const DRM_MODE_FLAG_PIXMUX: u32 = 2048;
pub const DRM_MODE_FLAG_DBLCLK: u32 = 4096;
pub const DRM_MODE_FLAG_CLKDIV2: u32 = 8192;
pub const DRM_MODE_FLAG_3D_MASK: u32 = 507904;
pub const DRM_MODE_FLAG_3D_NONE: u32 = 0;
pub const DRM_MODE_FLAG_3D_FRAME_PACKING: u32 = 16384;
pub const DRM_MODE_FLAG_3D_FIELD_ALTERNATIVE: u32 = 32768;
pub const DRM_MODE_FLAG_3D_LINE_ALTERNATIVE: u32 = 49152;
pub const DRM_MODE_FLAG_3D_SIDE_BY_SIDE_FULL: u32 = 65536;
pub const DRM_MODE_FLAG_3D_L_DEPTH: u32 = 81920;
pub const DRM_MODE_FLAG_3D_L_DEPTH_GFX_GFX_DEPTH: u32 = 98304;
pub const DRM_MODE_FLAG_3D_TOP_AND_BOTTOM: u32 = 114688;
pub const DRM_MODE_FLAG_3D_SIDE_BY_SIDE_HALF: u32 = 131072;
pub const DRM_MODE_PICTURE_ASPECT_NONE: u32 = 0;
pub const DRM_MODE_PICTURE_ASPECT_4_3: u32 = 1;
pub const DRM_MODE_PICTURE_ASPECT_16_9: u32 = 2;
pub const DRM_MODE_PICTURE_ASPECT_64_27: u32 = 3;
pub const DRM_MODE_PICTURE_ASPECT_256_135: u32 = 4;
pub const DRM_MODE_CONTENT_TYPE_NO_DATA: u32 = 0;
pub const DRM_MODE_CONTENT_TYPE_GRAPHICS: u32 = 1;
pub const DRM_MODE_CONTENT_TYPE_PHOTO: u32 = 2;
pub const DRM_MODE_CONTENT_TYPE_CINEMA: u32 = 3;
pub const DRM_MODE_CONTENT_TYPE_GAME: u32 = 4;
pub const DRM_MODE_FLAG_PIC_AR_MASK: u32 = 7864320;
pub const DRM_MODE_FLAG_PIC_AR_NONE: u32 = 0;
pub const DRM_MODE_FLAG_PIC_AR_4_3: u32 = 524288;
pub const DRM_MODE_FLAG_PIC_AR_16_9: u32 = 1048576;
pub const DRM_MODE_FLAG_PIC_AR_64_27: u32 = 1572864;
pub const DRM_MODE_FLAG_PIC_AR_256_135: u32 = 2097152;
pub const DRM_MODE_FLAG_ALL: u32 = 521215;
pub const DRM_MODE_DPMS_ON: u32 = 0;
pub const DRM_MODE_DPMS_STANDBY: u32 = 1;
pub const DRM_MODE_DPMS_SUSPEND: u32 = 2;
pub const DRM_MODE_DPMS_OFF: u32 = 3;
pub const DRM_MODE_SCALE_NONE: u32 = 0;
pub const DRM_MODE_SCALE_FULLSCREEN: u32 = 1;
pub const DRM_MODE_SCALE_CENTER: u32 = 2;
pub const DRM_MODE_SCALE_ASPECT: u32 = 3;
pub const DRM_MODE_DITHERING_OFF: u32 = 0;
pub const DRM_MODE_DITHERING_ON: u32 = 1;
pub const DRM_MODE_DITHERING_AUTO: u32 = 2;
pub const DRM_MODE_DIRTY_OFF: u32 = 0;
pub const DRM_MODE_DIRTY_ON: u32 = 1;
pub const DRM_MODE_DIRTY_ANNOTATE: u32 = 2;
pub const DRM_MODE_LINK_STATUS_GOOD: u32 = 0;
pub const DRM_MODE_LINK_STATUS_BAD: u32 = 1;
pub const DRM_MODE_ROTATE_0: u32 = 1;
pub const DRM_MODE_ROTATE_90: u32 = 2;
pub const DRM_MODE_ROTATE_180: u32 = 4;
pub const DRM_MODE_ROTATE_270: u32 = 8;
pub const DRM_MODE_ROTATE_MASK: u32 = 15;
pub const DRM_MODE_REFLECT_X: u32 = 16;
pub const DRM_MODE_REFLECT_Y: u32 = 32;
pub const DRM_MODE_REFLECT_MASK: u32 = 48;
pub const DRM_MODE_CONTENT_PROTECTION_UNDESIRED: u32 = 0;
pub const DRM_MODE_CONTENT_PROTECTION_DESIRED: u32 = 1;
pub const DRM_MODE_CONTENT_PROTECTION_ENABLED: u32 = 2;
pub const DRM_MODE_PRESENT_TOP_FIELD: u32 = 1;
pub const DRM_MODE_PRESENT_BOTTOM_FIELD: u32 = 2;
pub const DRM_MODE_ENCODER_NONE: u32 = 0;
pub const DRM_MODE_ENCODER_DAC: u32 = 1;
pub const DRM_MODE_ENCODER_TMDS: u32 = 2;
pub const DRM_MODE_ENCODER_LVDS: u32 = 3;
pub const DRM_MODE_ENCODER_TVDAC: u32 = 4;
pub const DRM_MODE_ENCODER_VIRTUAL: u32 = 5;
pub const DRM_MODE_ENCODER_DSI: u32 = 6;
pub const DRM_MODE_ENCODER_DPMST: u32 = 7;
pub const DRM_MODE_ENCODER_DPI: u32 = 8;
pub const DRM_MODE_CONNECTOR_Unknown: u32 = 0;
pub const DRM_MODE_CONNECTOR_VGA: u32 = 1;
pub const DRM_MODE_CONNECTOR_DVII: u32 = 2;
pub const DRM_MODE_CONNECTOR_DVID: u32 = 3;
pub const DRM_MODE_CONNECTOR_DVIA: u32 = 4;
pub const DRM_MODE_CONNECTOR_Composite: u32 = 5;
pub const DRM_MODE_CONNECTOR_SVIDEO: u32 = 6;
pub const DRM_MODE_CONNECTOR_LVDS: u32 = 7;
pub const DRM_MODE_CONNECTOR_Component: u32 = 8;
pub const DRM_MODE_CONNECTOR_9PinDIN: u32 = 9;
pub const DRM_MODE_CONNECTOR_DisplayPort: u32 = 10;
pub const DRM_MODE_CONNECTOR_HDMIA: u32 = 11;
pub const DRM_MODE_CONNECTOR_HDMIB: u32 = 12;
pub const DRM_MODE_CONNECTOR_TV: u32 = 13;
pub const DRM_MODE_CONNECTOR_eDP: u32 = 14;
pub const DRM_MODE_CONNECTOR_VIRTUAL: u32 = 15;
pub const DRM_MODE_CONNECTOR_DSI: u32 = 16;
pub const DRM_MODE_CONNECTOR_DPI: u32 = 17;
pub const DRM_MODE_CONNECTOR_WRITEBACK: u32 = 18;
pub const DRM_MODE_CONNECTOR_SPI: u32 = 19;
pub const DRM_MODE_CONNECTOR_USB: u32 = 20;
pub const DRM_MODE_PROP_PENDING: u32 = 1;
pub const DRM_MODE_PROP_RANGE: u32 = 2;
pub const DRM_MODE_PROP_IMMUTABLE: u32 = 4;
pub const DRM_MODE_PROP_ENUM: u32 = 8;
pub const DRM_MODE_PROP_BLOB: u32 = 16;
pub const DRM_MODE_PROP_BITMASK: u32 = 32;
pub const DRM_MODE_PROP_LEGACY_TYPE: u32 = 58;
pub const DRM_MODE_PROP_EXTENDED_TYPE: u32 = 65472;
pub const DRM_MODE_PROP_ATOMIC: u32 = 2147483648;
pub const DRM_MODE_OBJECT_CRTC: u32 = 3435973836;
pub const DRM_MODE_OBJECT_CONNECTOR: u32 = 3233857728;
pub const DRM_MODE_OBJECT_ENCODER: u32 = 3772834016;
pub const DRM_MODE_OBJECT_MODE: u32 = 3739147998;
pub const DRM_MODE_OBJECT_PROPERTY: u32 = 2964369584;
pub const DRM_MODE_OBJECT_FB: u32 = 4227595259;
pub const DRM_MODE_OBJECT_BLOB: u32 = 3149642683;
pub const DRM_MODE_OBJECT_PLANE: u32 = 4008636142;
pub const DRM_MODE_OBJECT_ANY: u32 = 0;
pub const DRM_MODE_FB_INTERLACED: u32 = 1;
pub const DRM_MODE_FB_MODIFIERS: u32 = 2;
pub const DRM_MODE_FB_DIRTY_ANNOTATE_COPY: u32 = 1;
pub const DRM_MODE_FB_DIRTY_ANNOTATE_FILL: u32 = 2;
pub const DRM_MODE_FB_DIRTY_FLAGS: u32 = 3;
pub const DRM_MODE_FB_DIRTY_MAX_CLIPS: u32 = 256;
pub const DRM_MODE_CURSOR_BO: u32 = 1;
pub const DRM_MODE_CURSOR_MOVE: u32 = 2;
pub const DRM_MODE_CURSOR_FLAGS: u32 = 3;
pub const DRM_MODE_PAGE_FLIP_EVENT: u32 = 1;
pub const DRM_MODE_PAGE_FLIP_ASYNC: u32 = 2;
pub const DRM_MODE_PAGE_FLIP_TARGET_ABSOLUTE: u32 = 4;
pub const DRM_MODE_PAGE_FLIP_TARGET_RELATIVE: u32 = 8;
pub const DRM_MODE_PAGE_FLIP_TARGET: u32 = 12;
pub const DRM_MODE_PAGE_FLIP_FLAGS: u32 = 15;
pub const DRM_MODE_ATOMIC_TEST_ONLY: u32 = 256;
pub const DRM_MODE_ATOMIC_NONBLOCK: u32 = 512;
pub const DRM_MODE_ATOMIC_ALLOW_MODESET: u32 = 1024;
pub const DRM_MODE_ATOMIC_FLAGS: u32 = 1795;
pub const FORMAT_BLOB_CURRENT: u32 = 1;
pub const DRM_IOCTL_BASE: u8 = 100u8;
pub const DRM_COMMAND_BASE: u32 = 64;
pub const DRM_COMMAND_END: u32 = 160;
pub const DRM_EVENT_VBLANK: u32 = 1;
pub const DRM_EVENT_FLIP_COMPLETE: u32 = 2;
pub const DRM_EVENT_CRTC_SEQUENCE: u32 = 3;
pub const PMD_ORDER: u32 = 9;
pub const PUD_ORDER: u32 = 18;
pub const USER_PGTABLES_CEILING: u32 = 0;
pub const FIRST_USER_ADDRESS: u32 = 0;
pub const __PGTBL_PGD_MODIFIED: u32 = 0;
pub const __PGTBL_P4D_MODIFIED: u32 = 1;
pub const __PGTBL_PUD_MODIFIED: u32 = 2;
pub const __PGTBL_PMD_MODIFIED: u32 = 3;
pub const __PGTBL_PTE_MODIFIED: u32 = 4;
pub const MAX_PTRS_PER_PTE: u32 = 512;
pub const MAX_PTRS_PER_PMD: u32 = 512;
pub const MAX_PTRS_PER_PUD: u32 = 512;
pub const PGMAP_ALTMAP_VALID: u32 = 1;
pub const MAPCOUNT_ELF_CORE_MARGIN: u32 = 5;
pub const VM_NONE: u32 = 0;
pub const VM_READ: u32 = 1;
pub const VM_WRITE: u32 = 2;
pub const VM_EXEC: u32 = 4;
pub const VM_SHARED: u32 = 8;
pub const VM_MAYREAD: u32 = 16;
pub const VM_MAYWRITE: u32 = 32;
pub const VM_MAYEXEC: u32 = 64;
pub const VM_MAYSHARE: u32 = 128;
pub const VM_GROWSDOWN: u32 = 256;
pub const VM_UFFD_MISSING: u32 = 512;
pub const VM_PFNMAP: u32 = 1024;
pub const VM_UFFD_WP: u32 = 4096;
pub const VM_LOCKED: u32 = 8192;
pub const VM_IO: u32 = 16384;
pub const VM_SEQ_READ: u32 = 32768;
pub const VM_RAND_READ: u32 = 65536;
pub const VM_DONTCOPY: u32 = 131072;
pub const VM_DONTEXPAND: u32 = 262144;
pub const VM_LOCKONFAULT: u32 = 524288;
pub const VM_ACCOUNT: u32 = 1048576;
pub const VM_NORESERVE: u32 = 2097152;
pub const VM_HUGETLB: u32 = 4194304;
pub const VM_SYNC: u32 = 8388608;
pub const VM_ARCH_1: u32 = 16777216;
pub const VM_WIPEONFORK: u32 = 33554432;
pub const VM_DONTDUMP: u32 = 67108864;
pub const VM_SOFTDIRTY: u32 = 134217728;
pub const VM_MIXEDMAP: u32 = 268435456;
pub const VM_HUGEPAGE: u32 = 536870912;
pub const VM_NOHUGEPAGE: u32 = 1073741824;
pub const VM_HIGH_ARCH_BIT_0: u32 = 32;
pub const VM_HIGH_ARCH_BIT_1: u32 = 33;
pub const VM_HIGH_ARCH_BIT_2: u32 = 34;
pub const VM_HIGH_ARCH_BIT_3: u32 = 35;
pub const VM_HIGH_ARCH_BIT_4: u32 = 36;
pub const VM_HIGH_ARCH_BIT_5: u32 = 37;
pub const VM_HIGH_ARCH_BIT_6: u32 = 38;
pub const VM_PKEY_SHIFT: u32 = 32;
pub const VM_PKEY_BIT4: u32 = 0;
pub const VM_MTE: u32 = 0;
pub const VM_MTE_ALLOWED: u32 = 0;
pub const VM_GROWSUP: u32 = 0;
pub const VM_UFFD_MINOR_BIT: u32 = 41;
pub const VM_ALLOW_ANY_UNCACHED_BIT: u32 = 39;
pub const VM_DROPPABLE_BIT: u32 = 40;
pub const VM_SEALED_BIT: u32 = 42;
pub const VM_DATA_FLAGS_NON_EXEC: u32 = 115;
pub const VM_DATA_FLAGS_EXEC: u32 = 119;
pub const VM_STACK: u32 = 256;
pub const VM_STACK_EARLY: u32 = 0;
pub const VM_ACCESS_FLAGS: u32 = 7;
pub const VM_SPECIAL: u32 = 268715008;
pub const VM_NO_KHUGEPAGED: u32 = 272909312;
pub const VM_INIT_DEF_MASK: u32 = 1073741824;
pub const VM_LOCKED_MASK: u32 = 532480;
pub const VM_ARCH_CLEAR: u32 = 0;
pub const HPAGE_PMD_SHIFT: u32 = 21;
pub const HPAGE_PUD_SHIFT: u32 = 30;
pub const HPAGE_PMD_ORDER: u32 = 9;
pub const HPAGE_PMD_NR: u32 = 512;
pub const HPAGE_PMD_SIZE: u32 = 2097152;
pub const HPAGE_PUD_ORDER: u32 = 18;
pub const HPAGE_PUD_NR: u32 = 262144;
pub const HPAGE_PUD_SIZE: u32 = 1073741824;
pub const GUP_PIN_COUNTING_BIAS: u32 = 1024;
pub const PAGE_ACCESS_TIME_MIN_BITS: u32 = 12;
pub const PAGE_ACCESS_TIME_BUCKETS: u32 = 0;
pub const PAGE_ACCESS_TIME_MASK: u32 = 2097151;
pub const MM_CP_TRY_CHANGE_WRITABLE: u32 = 1;
pub const MM_CP_PROT_NUMA: u32 = 2;
pub const MM_CP_UFFD_WP: u32 = 4;
pub const MM_CP_UFFD_WP_RESOLVE: u32 = 8;
pub const MM_CP_UFFD_WP_ALL: u32 = 12;
pub const VM_UNMAPPED_AREA_TOPDOWN: u32 = 1;
pub const VMEMMAP_RESERVE_NR: u32 = 2;
pub const VM_SEALED_SYSMAP: u32 = 0;
pub const PAGE_SNAPSHOT_FAITHFUL: u32 = 1;
pub const PAGE_SNAPSHOT_PG_BUDDY: u32 = 2;
pub const PAGE_SNAPSHOT_PG_IDLE: u32 = 4;
pub const SG_CHAIN: u32 = 1;
pub const SG_END: u32 = 2;
pub const SG_PAGE_LINK_MASK: u32 = 3;
pub const SG_DMA_BUS_ADDRESS: u32 = 1;
pub const SG_DMA_SWIOTLB: u32 = 2;
pub const SG_CHUNK_SIZE: u32 = 128;
pub const SG_MAX_SEGMENTS: u32 = 2048;
pub const SG_MITER_ATOMIC: u32 = 1;
pub const SG_MITER_TO_SG: u32 = 2;
pub const SG_MITER_FROM_SG: u32 = 4;
pub const SG_MITER_LOCAL: u32 = 8;
pub const FDPUT_FPUT: u32 = 1;
pub const FDPUT_POS_UNLOCK: u32 = 2;
pub const DMA_ATTR_WEAK_ORDERING: u32 = 2;
pub const DMA_ATTR_WRITE_COMBINE: u32 = 4;
pub const DMA_ATTR_NO_KERNEL_MAPPING: u32 = 16;
pub const DMA_ATTR_SKIP_CPU_SYNC: u32 = 32;
pub const DMA_ATTR_FORCE_CONTIGUOUS: u32 = 64;
pub const DMA_ATTR_ALLOC_SINGLE_PAGES: u32 = 128;
pub const DMA_ATTR_NO_WARN: u32 = 256;
pub const DMA_ATTR_PRIVILEGED: u32 = 512;
pub const DMA_ATTR_MMIO: u32 = 1024;
pub const DMA_IOVA_USE_SWIOTLB: i64 = -9223372036854775808;
pub const DRM_MM_NODE_ALLOCATED_BIT: u32 = 0;
pub const DRM_MM_NODE_SCANNED_BIT: u32 = 1;
pub const DRM_FILE_PAGE_OFFSET_START: u32 = 1048576;
pub const DRM_FILE_PAGE_OFFSET_SIZE: u32 = 268435200;
pub const DRM_MAJOR: u32 = 226;
pub const KUNIT_PARAM_DESC_SIZE: u32 = 128;
pub const KUNIT_STATUS_COMMENT_SIZE: u32 = 256;
pub const KUNIT_INDENT_LEN: u32 = 4;
pub const KUNIT_SUBTEST_INDENT: &[u8; 5] = b"    \0";
pub const KUNIT_SUBSUBTEST_INDENT: &[u8; 9] = b"        \0";
pub const ARCH_IMPLEMENTS_FLUSH_DCACHE_PAGE: u32 = 0;
pub const SECTOR_SHIFT: u32 = 9;
pub const SECTOR_SIZE: u32 = 512;
pub const PAGE_SECTORS_SHIFT: u32 = 3;
pub const PAGE_SECTORS: u32 = 8;
pub const SECTOR_MASK: u32 = 7;
pub const BD_PARTNO: u32 = 255;
pub const BD_READ_ONLY: u32 = 256;
pub const BD_WRITE_HOLDER: u32 = 512;
pub const BD_HAS_SUBMIT_BIO: u32 = 1024;
pub const BD_RO_WARNED: u32 = 2048;
pub const BLK_STS_OK: u32 = 0;
pub const BLK_QC_T_NONE: i32 = -1;
pub const BIO_MAX_SECTORS: i32 = -1;
pub const REQ_OP_BITS: u32 = 8;
pub const REQ_FLAG_BITS: u32 = 24;
pub const BIO_MAX_VECS: u32 = 256;
pub const BIO_MAX_INLINE_VECS: u32 = 1024;
pub const BIO_POOL_SIZE: u32 = 2;
pub const SBQ_WAIT_QUEUES: u32 = 8;
pub const SBQ_WAKE_BATCH: u32 = 8;
pub const BLKCG_MAX_POLS: u32 = 6;
pub const DISK_MAX_PARTS: u32 = 256;
pub const DISK_NAME_LEN: u32 = 32;
pub const PARTITION_META_INFO_VOLNAMELTH: u32 = 64;
pub const PARTITION_META_INFO_UUIDLTH: u32 = 37;
pub const GD_NEED_PART_SCAN: u32 = 0;
pub const GD_READ_ONLY: u32 = 1;
pub const GD_DEAD: u32 = 2;
pub const GD_NATIVE_CAPACITY: u32 = 3;
pub const GD_ADDED: u32 = 4;
pub const GD_SUPPRESS_PART_SCAN: u32 = 5;
pub const GD_OWNS_QUEUE: u32 = 6;
pub const BLK_MAX_BLOCK_SIZE: u32 = 65536;
pub const BLK_DEFAULT_SG_TIMEOUT: u32 = 60000;
pub const BLK_MIN_SG_TIMEOUT: u32 = 7000;
pub const BLK_POLL_ONESHOT: u32 = 1;
pub const BLKDEV_ZERO_NOUNMAP: u32 = 1;
pub const BLKDEV_ZERO_NOFALLBACK: u32 = 2;
pub const BLKDEV_ZERO_KILLABLE: u32 = 4;
pub const BDEVNAME_SIZE: u32 = 32;
pub const BDEVT_SIZE: u32 = 10;
pub const BLKDEV_MAJOR_MAX: u32 = 512;
pub const PREFETCH_STRIDE: u32 = 256;
pub const BLKDEV_MIN_RQ: u32 = 4;
pub const BLKDEV_DEFAULT_RQ: u32 = 128;
pub const BLK_MQ_MAX_DEPTH: u32 = 10240;
pub const BLK_MQ_NO_HCTX_IDX: i32 = -1;
pub const CONFIGFS_ITEM_NAME_LEN: u32 = 20;
pub const CPU_ONLINE: u32 = 2;
pub const CPU_UP_PREPARE: u32 = 3;
pub const CPU_DEAD: u32 = 7;
pub const CPU_DEAD_FROZEN: u32 = 8;
pub const CPU_POST_DEAD: u32 = 9;
pub const CPU_BROKEN: u32 = 11;
pub const MAX_PHANDLE_ARGS: u32 = 16;
pub const OF_DYNAMIC: u32 = 1;
pub const OF_DETACHED: u32 = 2;
pub const OF_POPULATED: u32 = 3;
pub const OF_POPULATED_BUS: u32 = 4;
pub const OF_OVERLAY: u32 = 5;
pub const OF_OVERLAY_FREE_CSET: u32 = 6;
pub const PM_QOS_DEFAULT_VALUE: i32 = -1;
pub const PM_QOS_CPU_LATENCY_DEFAULT_VALUE: u32 = 2000000000;
pub const PM_QOS_LATENCY_TOLERANCE_DEFAULT_VALUE: u32 = 0;
pub const PM_QOS_MIN_FREQUENCY_DEFAULT_VALUE: u32 = 0;
pub const PM_QOS_LATENCY_TOLERANCE_NO_CONSTRAINT: i32 = -1;
pub const PM_QOS_FLAG_NO_POWER_OFF: u32 = 1;
pub const FREQ_QOS_MIN_DEFAULT_VALUE: u32 = 0;
pub const CPUFREQ_DEFAULT_TRANSITION_LATENCY_NS: u32 = 1000000;
pub const CPUFREQ_NAME_LEN: u32 = 16;
pub const CPUFREQ_NAME_PLEN: u32 = 17;
pub const CPUFREQ_SHARED_TYPE_NONE: u32 = 0;
pub const CPUFREQ_SHARED_TYPE_HW: u32 = 1;
pub const CPUFREQ_SHARED_TYPE_ALL: u32 = 2;
pub const CPUFREQ_SHARED_TYPE_ANY: u32 = 3;
pub const CPUFREQ_RELATION_L: u32 = 0;
pub const CPUFREQ_RELATION_H: u32 = 1;
pub const CPUFREQ_RELATION_C: u32 = 2;
pub const CPUFREQ_TRANSITION_NOTIFIER: u32 = 0;
pub const CPUFREQ_POLICY_NOTIFIER: u32 = 1;
pub const CPUFREQ_PRECHANGE: u32 = 0;
pub const CPUFREQ_POSTCHANGE: u32 = 1;
pub const CPUFREQ_CREATE_POLICY: u32 = 0;
pub const CPUFREQ_REMOVE_POLICY: u32 = 1;
pub const CPUFREQ_POLICY_UNKNOWN: u32 = 0;
pub const CPUFREQ_POLICY_POWERSAVE: u32 = 1;
pub const CPUFREQ_POLICY_PERFORMANCE: u32 = 2;
pub const CPUFREQ_ENTRY_INVALID: i32 = -1;
pub const CPUFREQ_TABLE_END: i32 = -2;
pub const CPUFREQ_BOOST_FREQ: u32 = 1;
pub const CPUFREQ_INEFFICIENT_FREQ: u32 = 2;
pub const SEQ_SKIP: u32 = 1;
pub const _HAVE_ARCH_COPY_AND_CSUM_FROM_USER: u32 = 1;
pub const _HAVE_ARCH_IPV6_CSUM: u32 = 1;
pub const IPV6_FL_A_GET: u32 = 0;
pub const IPV6_FL_A_PUT: u32 = 1;
pub const IPV6_FL_A_RENEW: u32 = 2;
pub const IPV6_FL_F_CREATE: u32 = 1;
pub const IPV6_FL_F_EXCL: u32 = 2;
pub const IPV6_FL_F_REFLECT: u32 = 4;
pub const IPV6_FL_F_REMOTE: u32 = 8;
pub const IPV6_FL_S_NONE: u32 = 0;
pub const IPV6_FL_S_EXCL: u32 = 1;
pub const IPV6_FL_S_PROCESS: u32 = 2;
pub const IPV6_FL_S_USER: u32 = 3;
pub const IPV6_FL_S_ANY: u32 = 255;
pub const IPV6_FLOWINFO_FLOWLABEL: u32 = 1048575;
pub const IPV6_FLOWINFO_PRIORITY: u32 = 267386880;
pub const IPV6_PRIORITY_UNCHARACTERIZED: u32 = 0;
pub const IPV6_PRIORITY_FILLER: u32 = 256;
pub const IPV6_PRIORITY_UNATTENDED: u32 = 512;
pub const IPV6_PRIORITY_RESERVED1: u32 = 768;
pub const IPV6_PRIORITY_BULK: u32 = 1024;
pub const IPV6_PRIORITY_RESERVED2: u32 = 1280;
pub const IPV6_PRIORITY_INTERACTIVE: u32 = 1536;
pub const IPV6_PRIORITY_CONTROL: u32 = 1792;
pub const IPV6_PRIORITY_8: u32 = 2048;
pub const IPV6_PRIORITY_9: u32 = 2304;
pub const IPV6_PRIORITY_10: u32 = 2560;
pub const IPV6_PRIORITY_11: u32 = 2816;
pub const IPV6_PRIORITY_12: u32 = 3072;
pub const IPV6_PRIORITY_13: u32 = 3328;
pub const IPV6_PRIORITY_14: u32 = 3584;
pub const IPV6_PRIORITY_15: u32 = 3840;
pub const IPPROTO_HOPOPTS: u32 = 0;
pub const IPPROTO_ROUTING: u32 = 43;
pub const IPPROTO_FRAGMENT: u32 = 44;
pub const IPPROTO_ICMPV6: u32 = 58;
pub const IPPROTO_NONE: u32 = 59;
pub const IPPROTO_DSTOPTS: u32 = 60;
pub const IPPROTO_MH: u32 = 135;
pub const IPV6_TLV_PAD1: u32 = 0;
pub const IPV6_TLV_PADN: u32 = 1;
pub const IPV6_TLV_ROUTERALERT: u32 = 5;
pub const IPV6_TLV_CALIPSO: u32 = 7;
pub const IPV6_TLV_IOAM: u32 = 49;
pub const IPV6_TLV_JUMBO: u32 = 194;
pub const IPV6_TLV_HAO: u32 = 201;
pub const IPV6_ADDRFORM: u32 = 1;
pub const IPV6_2292PKTINFO: u32 = 2;
pub const IPV6_2292HOPOPTS: u32 = 3;
pub const IPV6_2292DSTOPTS: u32 = 4;
pub const IPV6_2292RTHDR: u32 = 5;
pub const IPV6_2292PKTOPTIONS: u32 = 6;
pub const IPV6_CHECKSUM: u32 = 7;
pub const IPV6_2292HOPLIMIT: u32 = 8;
pub const IPV6_NEXTHOP: u32 = 9;
pub const IPV6_AUTHHDR: u32 = 10;
pub const IPV6_FLOWINFO: u32 = 11;
pub const IPV6_UNICAST_HOPS: u32 = 16;
pub const IPV6_MULTICAST_IF: u32 = 17;
pub const IPV6_MULTICAST_HOPS: u32 = 18;
pub const IPV6_MULTICAST_LOOP: u32 = 19;
pub const IPV6_ADD_MEMBERSHIP: u32 = 20;
pub const IPV6_DROP_MEMBERSHIP: u32 = 21;
pub const IPV6_ROUTER_ALERT: u32 = 22;
pub const IPV6_MTU_DISCOVER: u32 = 23;
pub const IPV6_MTU: u32 = 24;
pub const IPV6_RECVERR: u32 = 25;
pub const IPV6_V6ONLY: u32 = 26;
pub const IPV6_JOIN_ANYCAST: u32 = 27;
pub const IPV6_LEAVE_ANYCAST: u32 = 28;
pub const IPV6_MULTICAST_ALL: u32 = 29;
pub const IPV6_ROUTER_ALERT_ISOLATE: u32 = 30;
pub const IPV6_RECVERR_RFC4884: u32 = 31;
pub const IPV6_PMTUDISC_DONT: u32 = 0;
pub const IPV6_PMTUDISC_WANT: u32 = 1;
pub const IPV6_PMTUDISC_DO: u32 = 2;
pub const IPV6_PMTUDISC_PROBE: u32 = 3;
pub const IPV6_PMTUDISC_INTERFACE: u32 = 4;
pub const IPV6_PMTUDISC_OMIT: u32 = 5;
pub const IPV6_FLOWLABEL_MGR: u32 = 32;
pub const IPV6_FLOWINFO_SEND: u32 = 33;
pub const IPV6_IPSEC_POLICY: u32 = 34;
pub const IPV6_XFRM_POLICY: u32 = 35;
pub const IPV6_HDRINCL: u32 = 36;
pub const IPV6_RECVPKTINFO: u32 = 49;
pub const IPV6_PKTINFO: u32 = 50;
pub const IPV6_RECVHOPLIMIT: u32 = 51;
pub const IPV6_HOPLIMIT: u32 = 52;
pub const IPV6_RECVHOPOPTS: u32 = 53;
pub const IPV6_HOPOPTS: u32 = 54;
pub const IPV6_RTHDRDSTOPTS: u32 = 55;
pub const IPV6_RECVRTHDR: u32 = 56;
pub const IPV6_RTHDR: u32 = 57;
pub const IPV6_RECVDSTOPTS: u32 = 58;
pub const IPV6_DSTOPTS: u32 = 59;
pub const IPV6_RECVPATHMTU: u32 = 60;
pub const IPV6_PATHMTU: u32 = 61;
pub const IPV6_DONTFRAG: u32 = 62;
pub const IPV6_RECVTCLASS: u32 = 66;
pub const IPV6_TCLASS: u32 = 67;
pub const IPV6_AUTOFLOWLABEL: u32 = 70;
pub const IPV6_ADDR_PREFERENCES: u32 = 72;
pub const IPV6_PREFER_SRC_TMP: u32 = 1;
pub const IPV6_PREFER_SRC_PUBLIC: u32 = 2;
pub const IPV6_PREFER_SRC_PUBTMP_DEFAULT: u32 = 256;
pub const IPV6_PREFER_SRC_COA: u32 = 4;
pub const IPV6_PREFER_SRC_HOME: u32 = 1024;
pub const IPV6_PREFER_SRC_CGA: u32 = 8;
pub const IPV6_PREFER_SRC_NONCGA: u32 = 2048;
pub const IPV6_MINHOPCOUNT: u32 = 73;
pub const IPV6_ORIGDSTADDR: u32 = 74;
pub const IPV6_RECVORIGDSTADDR: u32 = 74;
pub const IPV6_TRANSPARENT: u32 = 75;
pub const IPV6_UNICAST_IF: u32 = 76;
pub const IPV6_RECVFRAGSIZE: u32 = 77;
pub const IPV6_FREEBIND: u32 = 78;
pub const SIPHASH_CONST_0: u64 = 8317987319222330741;
pub const SIPHASH_CONST_1: u64 = 7237128888997146477;
pub const SIPHASH_CONST_2: u64 = 7816392313619706465;
pub const SIPHASH_CONST_3: u64 = 8387220255154660723;
pub const HSIPHASH_CONST_0: u32 = 0;
pub const HSIPHASH_CONST_1: u32 = 0;
pub const HSIPHASH_CONST_2: u32 = 1819895653;
pub const HSIPHASH_CONST_3: u32 = 1952801890;
pub const ETH_ALEN: u32 = 6;
pub const ETH_TLEN: u32 = 2;
pub const ETH_HLEN: u32 = 14;
pub const ETH_ZLEN: u32 = 60;
pub const ETH_DATA_LEN: u32 = 1500;
pub const ETH_FRAME_LEN: u32 = 1514;
pub const ETH_FCS_LEN: u32 = 4;
pub const ETH_MIN_MTU: u32 = 68;
pub const ETH_MAX_MTU: u32 = 65535;
pub const ETH_P_LOOP: u32 = 96;
pub const ETH_P_PUP: u32 = 512;
pub const ETH_P_PUPAT: u32 = 513;
pub const ETH_P_TSN: u32 = 8944;
pub const ETH_P_ERSPAN2: u32 = 8939;
pub const ETH_P_IP: u32 = 2048;
pub const ETH_P_X25: u32 = 2053;
pub const ETH_P_ARP: u32 = 2054;
pub const ETH_P_BPQ: u32 = 2303;
pub const ETH_P_IEEEPUP: u32 = 2560;
pub const ETH_P_IEEEPUPAT: u32 = 2561;
pub const ETH_P_BATMAN: u32 = 17157;
pub const ETH_P_DEC: u32 = 24576;
pub const ETH_P_DNA_DL: u32 = 24577;
pub const ETH_P_DNA_RC: u32 = 24578;
pub const ETH_P_DNA_RT: u32 = 24579;
pub const ETH_P_LAT: u32 = 24580;
pub const ETH_P_DIAG: u32 = 24581;
pub const ETH_P_CUST: u32 = 24582;
pub const ETH_P_SCA: u32 = 24583;
pub const ETH_P_TEB: u32 = 25944;
pub const ETH_P_RARP: u32 = 32821;
pub const ETH_P_ATALK: u32 = 32923;
pub const ETH_P_AARP: u32 = 33011;
pub const ETH_P_8021Q: u32 = 33024;
pub const ETH_P_ERSPAN: u32 = 35006;
pub const ETH_P_IPX: u32 = 33079;
pub const ETH_P_IPV6: u32 = 34525;
pub const ETH_P_PAUSE: u32 = 34824;
pub const ETH_P_SLOW: u32 = 34825;
pub const ETH_P_WCCP: u32 = 34878;
pub const ETH_P_MPLS_UC: u32 = 34887;
pub const ETH_P_MPLS_MC: u32 = 34888;
pub const ETH_P_ATMMPOA: u32 = 34892;
pub const ETH_P_PPP_DISC: u32 = 34915;
pub const ETH_P_PPP_SES: u32 = 34916;
pub const ETH_P_LINK_CTL: u32 = 34924;
pub const ETH_P_ATMFATE: u32 = 34948;
pub const ETH_P_PAE: u32 = 34958;
pub const ETH_P_PROFINET: u32 = 34962;
pub const ETH_P_REALTEK: u32 = 34969;
pub const ETH_P_AOE: u32 = 34978;
pub const ETH_P_ETHERCAT: u32 = 34980;
pub const ETH_P_8021AD: u32 = 34984;
pub const ETH_P_802_EX1: u32 = 34997;
pub const ETH_P_PREAUTH: u32 = 35015;
pub const ETH_P_TIPC: u32 = 35018;
pub const ETH_P_LLDP: u32 = 35020;
pub const ETH_P_MRP: u32 = 35043;
pub const ETH_P_MACSEC: u32 = 35045;
pub const ETH_P_8021AH: u32 = 35047;
pub const ETH_P_MVRP: u32 = 35061;
pub const ETH_P_1588: u32 = 35063;
pub const ETH_P_NCSI: u32 = 35064;
pub const ETH_P_PRP: u32 = 35067;
pub const ETH_P_CFM: u32 = 35074;
pub const ETH_P_FCOE: u32 = 35078;
pub const ETH_P_IBOE: u32 = 35093;
pub const ETH_P_TDLS: u32 = 35085;
pub const ETH_P_FIP: u32 = 35092;
pub const ETH_P_80221: u32 = 35095;
pub const ETH_P_HSR: u32 = 35119;
pub const ETH_P_NSH: u32 = 35151;
pub const ETH_P_LOOPBACK: u32 = 36864;
pub const ETH_P_QINQ1: u32 = 37120;
pub const ETH_P_QINQ2: u32 = 37376;
pub const ETH_P_QINQ3: u32 = 37632;
pub const ETH_P_EDSA: u32 = 56026;
pub const ETH_P_DSA_8021Q: u32 = 56027;
pub const ETH_P_DSA_A5PSW: u32 = 57345;
pub const ETH_P_IFE: u32 = 60734;
pub const ETH_P_AF_IUCV: u32 = 64507;
pub const ETH_P_802_3_MIN: u32 = 1536;
pub const ETH_P_802_3: u32 = 1;
pub const ETH_P_AX25: u32 = 2;
pub const ETH_P_ALL: u32 = 3;
pub const ETH_P_802_2: u32 = 4;
pub const ETH_P_SNAP: u32 = 5;
pub const ETH_P_DDCMP: u32 = 6;
pub const ETH_P_WAN_PPP: u32 = 7;
pub const ETH_P_PPP_MP: u32 = 8;
pub const ETH_P_LOCALTALK: u32 = 9;
pub const ETH_P_CAN: u32 = 12;
pub const ETH_P_CANFD: u32 = 13;
pub const ETH_P_CANXL: u32 = 14;
pub const ETH_P_PPPTALK: u32 = 16;
pub const ETH_P_TR_802_2: u32 = 17;
pub const ETH_P_MOBITEX: u32 = 21;
pub const ETH_P_CONTROL: u32 = 22;
pub const ETH_P_IRDA: u32 = 23;
pub const ETH_P_ECONET: u32 = 24;
pub const ETH_P_HDLC: u32 = 25;
pub const ETH_P_ARCNET: u32 = 26;
pub const ETH_P_DSA: u32 = 27;
pub const ETH_P_TRAILER: u32 = 28;
pub const ETH_P_PHONET: u32 = 245;
pub const ETH_P_IEEE802154: u32 = 246;
pub const ETH_P_CAIF: u32 = 247;
pub const ETH_P_XDSA: u32 = 248;
pub const ETH_P_MAP: u32 = 249;
pub const ETH_P_MCTP: u32 = 250;
pub const __UAPI_DEF_ETHHDR: u32 = 1;
pub const TC_PRIO_BESTEFFORT: u32 = 0;
pub const TC_PRIO_FILLER: u32 = 1;
pub const TC_PRIO_BULK: u32 = 2;
pub const TC_PRIO_INTERACTIVE_BULK: u32 = 4;
pub const TC_PRIO_INTERACTIVE: u32 = 6;
pub const TC_PRIO_CONTROL: u32 = 7;
pub const TC_PRIO_MAX: u32 = 15;
pub const TC_H_MAJ_MASK: u32 = 4294901760;
pub const TC_H_MIN_MASK: u32 = 65535;
pub const TC_H_UNSPEC: u32 = 0;
pub const TC_H_ROOT: u32 = 4294967295;
pub const TC_H_INGRESS: u32 = 4294967281;
pub const TC_H_CLSACT: u32 = 4294967281;
pub const TC_H_MIN_PRIORITY: u32 = 65504;
pub const TC_H_MIN_INGRESS: u32 = 65522;
pub const TC_H_MIN_EGRESS: u32 = 65523;
pub const TC_LINKLAYER_MASK: u32 = 15;
pub const TC_RTAB_SIZE: u32 = 1024;
pub const SKBPRIO_MAX_PRIORITY: u32 = 64;
pub const TCQ_PRIO_BANDS: u32 = 16;
pub const TCQ_MIN_PRIO_BANDS: u32 = 2;
pub const TCQ_PLUG_BUFFER: u32 = 0;
pub const TCQ_PLUG_RELEASE_ONE: u32 = 1;
pub const TCQ_PLUG_RELEASE_INDEFINITE: u32 = 2;
pub const TCQ_PLUG_LIMIT: u32 = 3;
pub const TC_RED_ECN: u32 = 1;
pub const TC_RED_HARDDROP: u32 = 2;
pub const TC_RED_ADAPTATIVE: u32 = 4;
pub const TC_RED_NODROP: u32 = 8;
pub const TC_RED_HISTORIC_FLAGS: u32 = 7;
pub const MAX_DPs: u32 = 16;
pub const TC_HTB_NUMPRIO: u32 = 8;
pub const TC_HTB_MAXDEPTH: u32 = 8;
pub const TC_HTB_PROTOVER: u32 = 3;
pub const NETEM_DIST_SCALE: u32 = 8192;
pub const NETEM_DIST_MAX: u32 = 16384;
pub const TC_QOPT_BITMASK: u32 = 15;
pub const TC_QOPT_MAX_QUEUE: u32 = 16;
pub const TC_MQPRIO_F_MODE: u32 = 1;
pub const TC_MQPRIO_F_SHAPER: u32 = 2;
pub const TC_MQPRIO_F_MIN_RATE: u32 = 4;
pub const TC_MQPRIO_F_MAX_RATE: u32 = 8;
pub const SFB_MAX_PROB: u32 = 65535;
pub const FQ_CODEL_QUANTUM_MAX: u32 = 1048576;
pub const FQ_BANDS: u32 = 3;
pub const FQ_MIN_WEIGHT: u32 = 16384;
pub const TC_CAKE_MAX_TINS: u32 = 8;
pub const TCQ_ETS_MAX_BANDS: u32 = 16;
pub const TC_COOKIE_MAX_SIZE: u32 = 16;
pub const TCA_ACT_FLAGS_NO_PERCPU_STATS: u32 = 1;
pub const TCA_ACT_FLAGS_SKIP_HW: u32 = 2;
pub const TCA_ACT_FLAGS_SKIP_SW: u32 = 4;
pub const TCA_ACT_HW_STATS_IMMEDIATE: u32 = 1;
pub const TCA_ACT_HW_STATS_DELAYED: u32 = 2;
pub const TCA_ACT_MAX_PRIO: u32 = 32;
pub const TCA_ACT_BIND: u32 = 1;
pub const TCA_ACT_NOBIND: u32 = 0;
pub const TCA_ACT_UNBIND: u32 = 1;
pub const TCA_ACT_NOUNBIND: u32 = 0;
pub const TCA_ACT_REPLACE: u32 = 1;
pub const TCA_ACT_NOREPLACE: u32 = 0;
pub const TC_ACT_UNSPEC: i32 = -1;
pub const TC_ACT_OK: u32 = 0;
pub const TC_ACT_RECLASSIFY: u32 = 1;
pub const TC_ACT_SHOT: u32 = 2;
pub const TC_ACT_PIPE: u32 = 3;
pub const TC_ACT_STOLEN: u32 = 4;
pub const TC_ACT_QUEUED: u32 = 5;
pub const TC_ACT_REPEAT: u32 = 6;
pub const TC_ACT_REDIRECT: u32 = 7;
pub const TC_ACT_TRAP: u32 = 8;
pub const TC_ACT_VALUE_MAX: u32 = 8;
pub const __TC_ACT_EXT_SHIFT: u32 = 28;
pub const TC_ACT_EXT_VAL_MASK: u32 = 268435455;
pub const TCA_ACT_GACT: u32 = 5;
pub const TCA_ACT_IPT: u32 = 6;
pub const TCA_ACT_PEDIT: u32 = 7;
pub const TCA_ACT_MIRRED: u32 = 8;
pub const TCA_ACT_NAT: u32 = 9;
pub const TCA_ACT_XT: u32 = 10;
pub const TCA_ACT_SKBEDIT: u32 = 11;
pub const TCA_ACT_VLAN: u32 = 12;
pub const TCA_ACT_BPF: u32 = 13;
pub const TCA_ACT_CONNMARK: u32 = 14;
pub const TCA_ACT_SKBMOD: u32 = 15;
pub const TCA_ACT_CSUM: u32 = 16;
pub const TCA_ACT_TUNNEL_KEY: u32 = 17;
pub const TCA_ACT_SIMP: u32 = 22;
pub const TCA_ACT_IFE: u32 = 25;
pub const TCA_ACT_SAMPLE: u32 = 26;
pub const TC_POLICE_UNSPEC: i32 = -1;
pub const TC_POLICE_OK: u32 = 0;
pub const TC_POLICE_RECLASSIFY: u32 = 1;
pub const TC_POLICE_SHOT: u32 = 2;
pub const TC_POLICE_PIPE: u32 = 3;
pub const TCA_CLS_FLAGS_SKIP_HW: u32 = 1;
pub const TCA_CLS_FLAGS_SKIP_SW: u32 = 2;
pub const TCA_CLS_FLAGS_IN_HW: u32 = 4;
pub const TCA_CLS_FLAGS_NOT_IN_HW: u32 = 8;
pub const TCA_CLS_FLAGS_VERBOSE: u32 = 16;
pub const TC_U32_UNSPEC: u32 = 0;
pub const TC_U32_ROOT: u32 = 4293918720;
pub const TC_U32_TERMINAL: u32 = 1;
pub const TC_U32_OFFSET: u32 = 2;
pub const TC_U32_VAROFFSET: u32 = 4;
pub const TC_U32_EAT: u32 = 8;
pub const TC_U32_MAXDEPTH: u32 = 8;
pub const TCA_BPF_FLAG_ACT_DIRECT: u32 = 1;
pub const TCA_FLOWER_MASK_FLAGS_RANGE: u32 = 1;
pub const TCF_EM_REL_END: u32 = 0;
pub const TCF_EM_REL_AND: u32 = 1;
pub const TCF_EM_REL_OR: u32 = 2;
pub const TCF_EM_INVERT: u32 = 4;
pub const TCF_EM_SIMPLE: u32 = 8;
pub const TCF_EM_REL_MASK: u32 = 3;
pub const TCF_EM_CONTAINER: u32 = 0;
pub const TCF_EM_CMP: u32 = 1;
pub const TCF_EM_NBYTE: u32 = 2;
pub const TCF_EM_U32: u32 = 3;
pub const TCF_EM_META: u32 = 4;
pub const TCF_EM_TEXT: u32 = 5;
pub const TCF_EM_VLAN: u32 = 6;
pub const TCF_EM_CANID: u32 = 7;
pub const TCF_EM_IPSET: u32 = 8;
pub const TCF_EM_IPT: u32 = 9;
pub const TCF_EM_MAX: u32 = 9;
pub const FLOW_DIS_MPLS_MAX: u32 = 7;
pub const FLOW_DIS_TUN_OPTS_MAX: u32 = 255;
pub const FLOW_DIS_CFM_MDL_MAX: u32 = 7;
pub const FLOW_KEYS_DIGEST_LEN: u32 = 16;
pub const PACKET_HOST: u32 = 0;
pub const PACKET_BROADCAST: u32 = 1;
pub const PACKET_MULTICAST: u32 = 2;
pub const PACKET_OTHERHOST: u32 = 3;
pub const PACKET_OUTGOING: u32 = 4;
pub const PACKET_LOOPBACK: u32 = 5;
pub const PACKET_USER: u32 = 6;
pub const PACKET_KERNEL: u32 = 7;
pub const PACKET_FASTROUTE: u32 = 6;
pub const PACKET_ADD_MEMBERSHIP: u32 = 1;
pub const PACKET_DROP_MEMBERSHIP: u32 = 2;
pub const PACKET_RECV_OUTPUT: u32 = 3;
pub const PACKET_RX_RING: u32 = 5;
pub const PACKET_STATISTICS: u32 = 6;
pub const PACKET_COPY_THRESH: u32 = 7;
pub const PACKET_AUXDATA: u32 = 8;
pub const PACKET_ORIGDEV: u32 = 9;
pub const PACKET_VERSION: u32 = 10;
pub const PACKET_HDRLEN: u32 = 11;
pub const PACKET_RESERVE: u32 = 12;
pub const PACKET_TX_RING: u32 = 13;
pub const PACKET_LOSS: u32 = 14;
pub const PACKET_VNET_HDR: u32 = 15;
pub const PACKET_TX_TIMESTAMP: u32 = 16;
pub const PACKET_TIMESTAMP: u32 = 17;
pub const PACKET_FANOUT: u32 = 18;
pub const PACKET_TX_HAS_OFF: u32 = 19;
pub const PACKET_QDISC_BYPASS: u32 = 20;
pub const PACKET_ROLLOVER_STATS: u32 = 21;
pub const PACKET_FANOUT_DATA: u32 = 22;
pub const PACKET_IGNORE_OUTGOING: u32 = 23;
pub const PACKET_VNET_HDR_SZ: u32 = 24;
pub const PACKET_FANOUT_HASH: u32 = 0;
pub const PACKET_FANOUT_LB: u32 = 1;
pub const PACKET_FANOUT_CPU: u32 = 2;
pub const PACKET_FANOUT_ROLLOVER: u32 = 3;
pub const PACKET_FANOUT_RND: u32 = 4;
pub const PACKET_FANOUT_QM: u32 = 5;
pub const PACKET_FANOUT_CBPF: u32 = 6;
pub const PACKET_FANOUT_EBPF: u32 = 7;
pub const PACKET_FANOUT_FLAG_ROLLOVER: u32 = 4096;
pub const PACKET_FANOUT_FLAG_UNIQUEID: u32 = 8192;
pub const PACKET_FANOUT_FLAG_IGNORE_OUTGOING: u32 = 16384;
pub const PACKET_FANOUT_FLAG_DEFRAG: u32 = 32768;
pub const TP_STATUS_KERNEL: u32 = 0;
pub const TP_STATUS_USER: u32 = 1;
pub const TP_STATUS_COPY: u32 = 2;
pub const TP_STATUS_LOSING: u32 = 4;
pub const TP_STATUS_CSUMNOTREADY: u32 = 8;
pub const TP_STATUS_VLAN_VALID: u32 = 16;
pub const TP_STATUS_BLK_TMO: u32 = 32;
pub const TP_STATUS_VLAN_TPID_VALID: u32 = 64;
pub const TP_STATUS_CSUM_VALID: u32 = 128;
pub const TP_STATUS_GSO_TCP: u32 = 256;
pub const TP_STATUS_AVAILABLE: u32 = 0;
pub const TP_STATUS_SEND_REQUEST: u32 = 1;
pub const TP_STATUS_SENDING: u32 = 2;
pub const TP_STATUS_WRONG_FORMAT: u32 = 4;
pub const TP_STATUS_TS_SOFTWARE: u32 = 536870912;
pub const TP_STATUS_TS_SYS_HARDWARE: u32 = 1073741824;
pub const TP_STATUS_TS_RAW_HARDWARE: u32 = 2147483648;
pub const TP_FT_REQ_FILL_RXHASH: u32 = 1;
pub const TPACKET_ALIGNMENT: u32 = 16;
pub const PACKET_MR_MULTICAST: u32 = 0;
pub const PACKET_MR_PROMISC: u32 = 1;
pub const PACKET_MR_ALLMULTI: u32 = 2;
pub const PACKET_MR_UNICAST: u32 = 3;
pub const INET_DSCP_MASK: u32 = 252;
pub const LOOPBACK_IFINDEX: u32 = 1;
pub const FLOWI_FLAG_ANYSRC: u32 = 1;
pub const FLOWI_FLAG_KNOWN_NH: u32 = 2;
pub const FLOWI_FLAG_L3MDEV_OIF: u32 = 4;
pub const FLOWI_FLAG_ANY_SPORT: u32 = 8;
pub const NF_CT_STATE_INVALID_BIT: u32 = 1;
pub const NF_CT_STATE_UNTRACKED_BIT: u32 = 64;
pub const NF_CT_EXPECT_PERMANENT: u32 = 1;
pub const NF_CT_EXPECT_INACTIVE: u32 = 2;
pub const NF_CT_EXPECT_USERSPACE: u32 = 4;
pub const NFCT_INFOMASK: u32 = 7;
pub const NFCT_PTRMASK: i32 = -8;
pub const SKB_DROP_REASON_SUBSYS_SHIFT: u32 = 16;
pub const NET_IOV: u32 = 1;
pub const CHECKSUM_NONE: u32 = 0;
pub const CHECKSUM_UNNECESSARY: u32 = 1;
pub const CHECKSUM_COMPLETE: u32 = 2;
pub const CHECKSUM_PARTIAL: u32 = 3;
pub const SKB_MAX_CSUM_LEVEL: u32 = 3;
pub const MAX_SKB_FRAGS: u32 = 17;
pub const GSO_BY_FRAGS: u32 = 65535;
pub const SKB_DATAREF_SHIFT: u32 = 16;
pub const SKB_DATAREF_MASK: u32 = 65535;
pub const NET_SKBUFF_DATA_USES_OFFSET: u32 = 1;
pub const CLONED_MASK: u32 = 1;
pub const PKT_TYPE_MAX: u32 = 7;
pub const SKB_TSTAMP_TYPE_MASK: u32 = 3;
pub const TC_AT_INGRESS_MASK: u32 = 4;
pub const SKB_ALLOC_FCLONE: u32 = 1;
pub const SKB_ALLOC_RX: u32 = 2;
pub const SKB_ALLOC_NAPI: u32 = 4;
pub const SKB_DST_NOREF: u32 = 1;
pub const SKB_DST_PTRMASK: i32 = -2;
pub const ENCAP_TYPE_ETHER: u32 = 0;
pub const ENCAP_TYPE_IPPROTO: u32 = 1;
pub const CHECKSUM_BREAK: u32 = 76;
pub const MAC_ADDR_STR_LEN: u32 = 17;
pub const NPROTO: u32 = 46;
pub const SYS_SOCKET: u32 = 1;
pub const SYS_BIND: u32 = 2;
pub const SYS_CONNECT: u32 = 3;
pub const SYS_LISTEN: u32 = 4;
pub const SYS_ACCEPT: u32 = 5;
pub const SYS_GETSOCKNAME: u32 = 6;
pub const SYS_GETPEERNAME: u32 = 7;
pub const SYS_SOCKETPAIR: u32 = 8;
pub const SYS_SEND: u32 = 9;
pub const SYS_RECV: u32 = 10;
pub const SYS_SENDTO: u32 = 11;
pub const SYS_RECVFROM: u32 = 12;
pub const SYS_SHUTDOWN: u32 = 13;
pub const SYS_SETSOCKOPT: u32 = 14;
pub const SYS_GETSOCKOPT: u32 = 15;
pub const SYS_SENDMSG: u32 = 16;
pub const SYS_RECVMSG: u32 = 17;
pub const SYS_ACCEPT4: u32 = 18;
pub const SYS_RECVMMSG: u32 = 19;
pub const SYS_SENDMMSG: u32 = 20;
pub const __SO_ACCEPTCON: u32 = 65536;
pub const SOCK_TYPE_MASK: u32 = 15;
pub const SOCK_CLOEXEC: u32 = 524288;
pub const SOCK_NONBLOCK: u32 = 2048;
pub const SOCK_COREDUMP: u32 = 256;
pub const _LINUX_BPF_H: u32 = 1;
pub const BPF_LD: u32 = 0;
pub const BPF_LDX: u32 = 1;
pub const BPF_ST: u32 = 2;
pub const BPF_STX: u32 = 3;
pub const BPF_ALU: u32 = 4;
pub const BPF_JMP: u32 = 5;
pub const BPF_RET: u32 = 6;
pub const BPF_MISC: u32 = 7;
pub const BPF_W: u32 = 0;
pub const BPF_H: u32 = 8;
pub const BPF_B: u32 = 16;
pub const BPF_IMM: u32 = 0;
pub const BPF_ABS: u32 = 32;
pub const BPF_IND: u32 = 64;
pub const BPF_MEM: u32 = 96;
pub const BPF_LEN: u32 = 128;
pub const BPF_MSH: u32 = 160;
pub const BPF_ADD: u32 = 0;
pub const BPF_SUB: u32 = 16;
pub const BPF_MUL: u32 = 32;
pub const BPF_DIV: u32 = 48;
pub const BPF_OR: u32 = 64;
pub const BPF_AND: u32 = 80;
pub const BPF_LSH: u32 = 96;
pub const BPF_RSH: u32 = 112;
pub const BPF_NEG: u32 = 128;
pub const BPF_MOD: u32 = 144;
pub const BPF_XOR: u32 = 160;
pub const BPF_JA: u32 = 0;
pub const BPF_JEQ: u32 = 16;
pub const BPF_JGT: u32 = 32;
pub const BPF_JGE: u32 = 48;
pub const BPF_JSET: u32 = 64;
pub const BPF_K: u32 = 0;
pub const BPF_X: u32 = 8;
pub const BPF_MAXINSNS: u32 = 4096;
pub const BPF_JMP32: u32 = 6;
pub const BPF_ALU64: u32 = 7;
pub const BPF_DW: u32 = 24;
pub const BPF_MEMSX: u32 = 128;
pub const BPF_ATOMIC: u32 = 192;
pub const BPF_XADD: u32 = 192;
pub const BPF_MOV: u32 = 176;
pub const BPF_ARSH: u32 = 192;
pub const BPF_END: u32 = 208;
pub const BPF_TO_LE: u32 = 0;
pub const BPF_TO_BE: u32 = 8;
pub const BPF_FROM_LE: u32 = 0;
pub const BPF_FROM_BE: u32 = 8;
pub const BPF_JNE: u32 = 80;
pub const BPF_JLT: u32 = 160;
pub const BPF_JLE: u32 = 176;
pub const BPF_JSGT: u32 = 96;
pub const BPF_JSGE: u32 = 112;
pub const BPF_JSLT: u32 = 192;
pub const BPF_JSLE: u32 = 208;
pub const BPF_JCOND: u32 = 224;
pub const BPF_CALL: u32 = 128;
pub const BPF_EXIT: u32 = 144;
pub const BPF_FETCH: u32 = 1;
pub const BPF_XCHG: u32 = 225;
pub const BPF_CMPXCHG: u32 = 241;
pub const BPF_LOAD_ACQ: u32 = 256;
pub const BPF_STORE_REL: u32 = 272;
pub const BPF_F_ALLOW_OVERRIDE: u32 = 1;
pub const BPF_F_ALLOW_MULTI: u32 = 2;
pub const BPF_F_REPLACE: u32 = 4;
pub const BPF_F_BEFORE: u32 = 8;
pub const BPF_F_AFTER: u32 = 16;
pub const BPF_F_ID: u32 = 32;
pub const BPF_F_PREORDER: u32 = 64;
pub const BPF_F_STRICT_ALIGNMENT: u32 = 1;
pub const BPF_F_ANY_ALIGNMENT: u32 = 2;
pub const BPF_F_TEST_RND_HI32: u32 = 4;
pub const BPF_F_TEST_STATE_FREQ: u32 = 8;
pub const BPF_F_SLEEPABLE: u32 = 16;
pub const BPF_F_XDP_HAS_FRAGS: u32 = 32;
pub const BPF_F_XDP_DEV_BOUND_ONLY: u32 = 64;
pub const BPF_F_TEST_REG_INVARIANTS: u32 = 128;
pub const BPF_F_NETFILTER_IP_DEFRAG: u32 = 1;
pub const BPF_PSEUDO_MAP_FD: u32 = 1;
pub const BPF_PSEUDO_MAP_IDX: u32 = 5;
pub const BPF_PSEUDO_MAP_VALUE: u32 = 2;
pub const BPF_PSEUDO_MAP_IDX_VALUE: u32 = 6;
pub const BPF_PSEUDO_BTF_ID: u32 = 3;
pub const BPF_PSEUDO_FUNC: u32 = 4;
pub const BPF_PSEUDO_CALL: u32 = 1;
pub const BPF_PSEUDO_KFUNC_CALL: u32 = 2;
pub const BPF_F_QUERY_EFFECTIVE: u32 = 1;
pub const BPF_F_TEST_RUN_ON_CPU: u32 = 1;
pub const BPF_F_TEST_XDP_LIVE_FRAMES: u32 = 2;
pub const BPF_F_TEST_SKB_CHECKSUM_COMPLETE: u32 = 4;
pub const BPF_BUILD_ID_SIZE: u32 = 20;
pub const BPF_OBJ_NAME_LEN: u32 = 16;
pub const XDP_PACKET_HEADROOM: u32 = 256;
pub const BPF_TAG_SIZE: u32 = 8;
pub const BPF_MAJOR_VERSION: u32 = 1;
pub const BPF_MINOR_VERSION: u32 = 1;
pub const BPF_A: u32 = 16;
pub const BPF_TAX: u32 = 0;
pub const BPF_TXA: u32 = 128;
pub const BPF_MEMWORDS: u32 = 16;
pub const SKF_AD_OFF: i32 = -4096;
pub const SKF_AD_PROTOCOL: u32 = 0;
pub const SKF_AD_PKTTYPE: u32 = 4;
pub const SKF_AD_IFINDEX: u32 = 8;
pub const SKF_AD_NLATTR: u32 = 12;
pub const SKF_AD_NLATTR_NEST: u32 = 16;
pub const SKF_AD_MARK: u32 = 20;
pub const SKF_AD_QUEUE: u32 = 24;
pub const SKF_AD_HATYPE: u32 = 28;
pub const SKF_AD_RXHASH: u32 = 32;
pub const SKF_AD_CPU: u32 = 36;
pub const SKF_AD_ALU_XOR_X: u32 = 40;
pub const SKF_AD_VLAN_TAG: u32 = 44;
pub const SKF_AD_VLAN_TAG_PRESENT: u32 = 48;
pub const SKF_AD_PAY_OFFSET: u32 = 52;
pub const SKF_AD_RANDOM: u32 = 56;
pub const SKF_AD_VLAN_TPID: u32 = 60;
pub const SKF_AD_MAX: u32 = 64;
pub const SKF_NET_OFF: i32 = -1048576;
pub const SKF_LL_OFF: i32 = -2097152;
pub const BPF_NET_OFF: i32 = -1048576;
pub const BPF_LL_OFF: i32 = -2097152;
pub const SHA224_DIGEST_SIZE: u32 = 28;
pub const SHA224_BLOCK_SIZE: u32 = 64;
pub const SHA256_DIGEST_SIZE: u32 = 32;
pub const SHA256_BLOCK_SIZE: u32 = 64;
pub const SHA256_STATE_WORDS: u32 = 8;
pub const SHA384_DIGEST_SIZE: u32 = 48;
pub const SHA384_BLOCK_SIZE: u32 = 128;
pub const SHA512_DIGEST_SIZE: u32 = 64;
pub const SHA512_BLOCK_SIZE: u32 = 128;
pub const SHA512_STATE_SIZE: u32 = 80;
pub const SHA224_H0: u32 = 3238371032;
pub const SHA224_H1: u32 = 914150663;
pub const SHA224_H2: u32 = 812702999;
pub const SHA224_H3: u32 = 4144912697;
pub const SHA224_H4: u32 = 4290775857;
pub const SHA224_H5: u32 = 1750603025;
pub const SHA224_H6: u32 = 1694076839;
pub const SHA224_H7: u32 = 3204075428;
pub const SHA256_H0: u32 = 1779033703;
pub const SHA256_H1: u32 = 3144134277;
pub const SHA256_H2: u32 = 1013904242;
pub const SHA256_H3: u32 = 2773480762;
pub const SHA256_H4: u32 = 1359893119;
pub const SHA256_H5: u32 = 2600822924;
pub const SHA256_H6: u32 = 528734635;
pub const SHA256_H7: u32 = 1541459225;
pub const SHA384_H0: i64 = -3766243637369397544;
pub const SHA384_H1: u64 = 7105036623409894663;
pub const SHA384_H2: i64 = -7973340178411365097;
pub const SHA384_H3: u64 = 1526699215303891257;
pub const SHA384_H4: u64 = 7436329637833083697;
pub const SHA384_H5: i64 = -8163818279084223215;
pub const SHA384_H6: i64 = -2662702644619276377;
pub const SHA384_H7: u64 = 5167115440072839076;
pub const SHA512_H0: u64 = 7640891576956012808;
pub const SHA512_H1: i64 = -4942790177534073029;
pub const SHA512_H2: u64 = 4354685564936845355;
pub const SHA512_H3: i64 = -6534734903238641935;
pub const SHA512_H4: u64 = 5840696475078001361;
pub const SHA512_H5: i64 = -7276294671716946913;
pub const SHA512_H6: u64 = 2270897969802886507;
pub const SHA512_H7: u64 = 6620516959819538809;
pub const KSYM_NAME_LEN: u32 = 512;
pub const _LINUX_BTF_H: u32 = 1;
pub const BTF_SET8_KFUNCS: u32 = 1;
pub const BTF_IDS_SECTION: &[u8; 9] = b".BTF_ids\0";
pub const BTF_MAGIC: u32 = 60319;
pub const BTF_VERSION: u32 = 1;
pub const BTF_MAX_TYPE: u32 = 1048575;
pub const BTF_MAX_NAME_OFFSET: u32 = 16777215;
pub const BTF_MAX_VLEN: u32 = 65535;
pub const BTF_INT_SIGNED: u32 = 1;
pub const BTF_INT_CHAR: u32 = 2;
pub const BTF_INT_BOOL: u32 = 4;
pub const KF_ACQUIRE: u32 = 1;
pub const KF_RELEASE: u32 = 2;
pub const KF_RET_NULL: u32 = 4;
pub const KF_TRUSTED_ARGS: u32 = 16;
pub const KF_SLEEPABLE: u32 = 32;
pub const KF_DESTRUCTIVE: u32 = 64;
pub const KF_RCU: u32 = 128;
pub const KF_ITER_NEW: u32 = 256;
pub const KF_ITER_NEXT: u32 = 512;
pub const KF_ITER_DESTROY: u32 = 1024;
pub const KF_RCU_PROTECTED: u32 = 2048;
pub const KF_FASTCALL: u32 = 4096;
pub const KF_ARENA_RET: u32 = 8192;
pub const KF_ARENA_ARG1: u32 = 16384;
pub const KF_ARENA_ARG2: u32 = 32768;
pub const BTF_SHOW_UNSAFE: u32 = 16;
pub const TEXT_POKE_MAX_OPCODE_SIZE: u32 = 5;
pub const INT3_INSN_SIZE: u32 = 1;
pub const INT3_INSN_OPCODE: u32 = 204;
pub const RET_INSN_SIZE: u32 = 1;
pub const RET_INSN_OPCODE: u32 = 195;
pub const CALL_INSN_SIZE: u32 = 5;
pub const CALL_INSN_OPCODE: u32 = 232;
pub const JMP32_INSN_SIZE: u32 = 5;
pub const JMP32_INSN_OPCODE: u32 = 233;
pub const JMP8_INSN_SIZE: u32 = 2;
pub const JMP8_INSN_OPCODE: u32 = 235;
pub const DISP32_SIZE: u32 = 4;
pub const TASKSTATS_VERSION: u32 = 16;
pub const TS_COMM_LEN: u32 = 32;
pub const TASKSTATS_GENL_NAME: &[u8; 10] = b"TASKSTATS\0";
pub const TASKSTATS_GENL_VERSION: u32 = 1;
pub const UID_GID_MAP_MAX_BASE_EXTENTS: u32 = 5;
pub const UID_GID_MAP_MAX_EXTENTS: u32 = 340;
pub const USERNS_SETGROUPS_ALLOWED: u32 = 1;
pub const USERNS_INIT_FLAGS: u32 = 1;
pub const IRQF_TRIGGER_NONE: u32 = 0;
pub const IRQF_TRIGGER_RISING: u32 = 1;
pub const IRQF_TRIGGER_FALLING: u32 = 2;
pub const IRQF_TRIGGER_HIGH: u32 = 4;
pub const IRQF_TRIGGER_LOW: u32 = 8;
pub const IRQF_TRIGGER_MASK: u32 = 15;
pub const IRQF_TRIGGER_PROBE: u32 = 16;
pub const IRQF_SHARED: u32 = 128;
pub const IRQF_PROBE_SHARED: u32 = 256;
pub const __IRQF_TIMER: u32 = 512;
pub const IRQF_PERCPU: u32 = 1024;
pub const IRQF_NOBALANCING: u32 = 2048;
pub const IRQF_IRQPOLL: u32 = 4096;
pub const IRQF_ONESHOT: u32 = 8192;
pub const IRQF_NO_SUSPEND: u32 = 16384;
pub const IRQF_FORCE_RESUME: u32 = 32768;
pub const IRQF_NO_THREAD: u32 = 65536;
pub const IRQF_EARLY_RESUME: u32 = 131072;
pub const IRQF_COND_SUSPEND: u32 = 262144;
pub const IRQF_NO_AUTOEN: u32 = 524288;
pub const IRQF_NO_DEBUG: u32 = 1048576;
pub const IRQF_COND_ONESHOT: u32 = 2097152;
pub const IRQF_TIMER: u32 = 82432;
pub const IRQ_NOTCONNECTED: u32 = 2147483648;
pub const IRQ_AFFINITY_MAX_SETS: u32 = 4;
pub const CGROUP_LSM_NUM: u32 = 10;
pub const MAX_CGROUP_TYPE_NAMELEN: u32 = 32;
pub const MAX_CGROUP_ROOT_NAMELEN: u32 = 64;
pub const MAX_CFTYPE_NAME: u32 = 64;
pub const CGROUP_WEIGHT_MIN: u32 = 1;
pub const CGROUP_WEIGHT_DFL: u32 = 100;
pub const CGROUP_WEIGHT_MAX: u32 = 10000;
pub const EFD_SEMAPHORE: u32 = 1;
pub const EFD_CLOEXEC: u32 = 524288;
pub const EFD_NONBLOCK: u32 = 2048;
pub const EFD_SHARED_FCNTL_FLAGS: u32 = 526336;
pub const EFD_FLAGS_SET: u32 = 526337;
pub const FPROP_FRAC_SHIFT: u32 = 10;
pub const FPROP_FRAC_BASE: u32 = 1024;
pub const PAGEVEC_SIZE: u32 = 31;
pub const DIRTY_SCOPE: u32 = 8;
pub const BDP_ASYNC: u32 = 1;
pub const MEM_CGROUP_ID_SHIFT: u32 = 16;
pub const MEMCG_CGWB_FRN_CNT: u32 = 4;
pub const MEMCG_CHARGE_BATCH: u32 = 64;
pub const cfi_bhi: u32 = 0;
pub const cfi_bpf_hash: u32 = 0;
pub const cfi_bpf_subprog_hash: u32 = 0;
pub const RES_DEF_TIMEOUT: u32 = 250000000;
pub const RES_NR_HELD: u32 = 31;
pub const BPF_BASE_TYPE_BITS: u32 = 8;
pub const BPF_BASE_TYPE_LIMIT: u32 = 256;
pub const MAX_BPF_FUNC_ARGS: u32 = 12;
pub const MAX_BPF_FUNC_REG_ARGS: u32 = 5;
pub const BPF_DISPATCHER_MAX: u32 = 48;
pub const BPF_STRUCT_OPS_MAX_NR_MEMBERS: u32 = 64;
pub const BPF_COMPLEXITY_LIMIT_INSNS: u32 = 1000000;
pub const MAX_TAIL_CALL_CNT: u32 = 33;
pub const BPF_MAX_USER_RINGBUF_SAMPLES: u32 = 131072;
pub const BPF_RET_BIND_NO_CAP_NET_BIND_SERVICE: u32 = 1;
pub const BPF_RET_SET_CN: u32 = 1;
pub const BPF_ITER_FUNC_PREFIX: &[u8; 10] = b"bpf_iter_\0";
pub const BPF_ITER_CTX_ARG_MAX: u32 = 2;
pub const MAX_BPRINTF_VARARGS: u32 = 12;
pub const MAX_BPRINTF_BUF: u32 = 1024;
pub const MAX_BPRINTF_BIN_ARGS: u32 = 512;
pub const LSM_ID_UNDEF: u32 = 0;
pub const LSM_ID_CAPABILITY: u32 = 100;
pub const LSM_ID_SELINUX: u32 = 101;
pub const LSM_ID_SMACK: u32 = 102;
pub const LSM_ID_TOMOYO: u32 = 103;
pub const LSM_ID_APPARMOR: u32 = 104;
pub const LSM_ID_YAMA: u32 = 105;
pub const LSM_ID_LOADPIN: u32 = 106;
pub const LSM_ID_SAFESETID: u32 = 107;
pub const LSM_ID_LOCKDOWN: u32 = 108;
pub const LSM_ID_BPF: u32 = 109;
pub const LSM_ID_LANDLOCK: u32 = 110;
pub const LSM_ID_IMA: u32 = 111;
pub const LSM_ID_EVM: u32 = 112;
pub const LSM_ID_IPE: u32 = 113;
pub const LSM_ATTR_UNDEF: u32 = 0;
pub const LSM_ATTR_CURRENT: u32 = 100;
pub const LSM_ATTR_EXEC: u32 = 101;
pub const LSM_ATTR_FSCREATE: u32 = 102;
pub const LSM_ATTR_KEYCREATE: u32 = 103;
pub const LSM_ATTR_PREV: u32 = 104;
pub const LSM_ATTR_SOCKCREATE: u32 = 105;
pub const LSM_FLAG_SINGLE: u32 = 1;
pub const CAP_OPT_NONE: u32 = 0;
pub const SECURITY_LSM_NATIVE_LABELS: u32 = 1;
pub const LSM_SETID_ID: u32 = 1;
pub const LSM_SETID_RE: u32 = 2;
pub const LSM_SETID_RES: u32 = 4;
pub const LSM_SETID_FS: u32 = 8;
pub const LSM_PRLIMIT_READ: u32 = 1;
pub const LSM_PRLIMIT_WRITE: u32 = 2;
pub const LSM_UNSAFE_SHARE: u32 = 1;
pub const LSM_UNSAFE_PTRACE: u32 = 2;
pub const LSM_UNSAFE_NO_NEW_PRIVS: u32 = 4;
pub const SCM_MAX_FD: u32 = 253;
pub const NETLINK_ROUTE: u32 = 0;
pub const NETLINK_UNUSED: u32 = 1;
pub const NETLINK_USERSOCK: u32 = 2;
pub const NETLINK_FIREWALL: u32 = 3;
pub const NETLINK_SOCK_DIAG: u32 = 4;
pub const NETLINK_NFLOG: u32 = 5;
pub const NETLINK_XFRM: u32 = 6;
pub const NETLINK_SELINUX: u32 = 7;
pub const NETLINK_ISCSI: u32 = 8;
pub const NETLINK_AUDIT: u32 = 9;
pub const NETLINK_FIB_LOOKUP: u32 = 10;
pub const NETLINK_CONNECTOR: u32 = 11;
pub const NETLINK_NETFILTER: u32 = 12;
pub const NETLINK_IP6_FW: u32 = 13;
pub const NETLINK_DNRTMSG: u32 = 14;
pub const NETLINK_KOBJECT_UEVENT: u32 = 15;
pub const NETLINK_GENERIC: u32 = 16;
pub const NETLINK_SCSITRANSPORT: u32 = 18;
pub const NETLINK_ECRYPTFS: u32 = 19;
pub const NETLINK_RDMA: u32 = 20;
pub const NETLINK_CRYPTO: u32 = 21;
pub const NETLINK_SMC: u32 = 22;
pub const NETLINK_INET_DIAG: u32 = 4;
pub const MAX_LINKS: u32 = 32;
pub const NLM_F_REQUEST: u32 = 1;
pub const NLM_F_MULTI: u32 = 2;
pub const NLM_F_ACK: u32 = 4;
pub const NLM_F_ECHO: u32 = 8;
pub const NLM_F_DUMP_INTR: u32 = 16;
pub const NLM_F_DUMP_FILTERED: u32 = 32;
pub const NLM_F_ROOT: u32 = 256;
pub const NLM_F_MATCH: u32 = 512;
pub const NLM_F_ATOMIC: u32 = 1024;
pub const NLM_F_DUMP: u32 = 768;
pub const NLM_F_REPLACE: u32 = 256;
pub const NLM_F_EXCL: u32 = 512;
pub const NLM_F_CREATE: u32 = 1024;
pub const NLM_F_APPEND: u32 = 2048;
pub const NLM_F_NONREC: u32 = 256;
pub const NLM_F_BULK: u32 = 512;
pub const NLM_F_CAPPED: u32 = 256;
pub const NLM_F_ACK_TLVS: u32 = 512;
pub const NLMSG_ALIGNTO: u32 = 4;
pub const NLMSG_NOOP: u32 = 1;
pub const NLMSG_ERROR: u32 = 2;
pub const NLMSG_DONE: u32 = 3;
pub const NLMSG_OVERRUN: u32 = 4;
pub const NLMSG_MIN_TYPE: u32 = 16;
pub const NETLINK_ADD_MEMBERSHIP: u32 = 1;
pub const NETLINK_DROP_MEMBERSHIP: u32 = 2;
pub const NETLINK_PKTINFO: u32 = 3;
pub const NETLINK_BROADCAST_ERROR: u32 = 4;
pub const NETLINK_NO_ENOBUFS: u32 = 5;
pub const NETLINK_LISTEN_ALL_NSID: u32 = 8;
pub const NETLINK_LIST_MEMBERSHIPS: u32 = 9;
pub const NETLINK_CAP_ACK: u32 = 10;
pub const NETLINK_EXT_ACK: u32 = 11;
pub const NETLINK_GET_STRICT_CHK: u32 = 12;
pub const NET_MAJOR: u32 = 36;
pub const NLA_F_NESTED: u32 = 32768;
pub const NLA_F_NET_BYTEORDER: u32 = 16384;
pub const NLA_TYPE_MASK: i32 = -49153;
pub const NLA_ALIGNTO: u32 = 4;
pub const NETLINK_CTX_SIZE: u32 = 48;
pub const NL_CFG_F_NONROOT_RECV: u32 = 1;
pub const NL_CFG_F_NONROOT_SEND: u32 = 2;
pub const NETLINK_MAX_COOKIE_LEN: u32 = 8;
pub const NETLINK_MAX_FMTMSG_LEN: u32 = 80;
pub const ETH_MDIO_SUPPORTS_C22: u32 = 1;
pub const ETH_MDIO_SUPPORTS_C45: u32 = 2;
pub const ETHTOOL_FWVERS_LEN: u32 = 32;
pub const ETHTOOL_BUSINFO_LEN: u32 = 32;
pub const ETHTOOL_EROMVERS_LEN: u32 = 32;
pub const SOPASS_MAX: u32 = 6;
pub const PFC_STORM_PREVENTION_AUTO: u32 = 65535;
pub const PFC_STORM_PREVENTION_DISABLE: u32 = 0;
pub const DOWNSHIFT_DEV_DEFAULT_COUNT: u32 = 255;
pub const DOWNSHIFT_DEV_DISABLE: u32 = 0;
pub const ETHTOOL_PHY_FAST_LINK_DOWN_ON: u32 = 0;
pub const ETHTOOL_PHY_FAST_LINK_DOWN_OFF: u32 = 255;
pub const ETHTOOL_PHY_EDPD_DFLT_TX_MSECS: u32 = 65535;
pub const ETHTOOL_PHY_EDPD_NO_TX: u32 = 65534;
pub const ETHTOOL_PHY_EDPD_DISABLE: u32 = 0;
pub const ETH_GSTRING_LEN: u32 = 32;
pub const ETH_RX_NFC_IP4: u32 = 1;
pub const ETHTOOL_RX_FLOW_SPEC_RING: u32 = 4294967295;
pub const ETHTOOL_RX_FLOW_SPEC_RING_VF: u64 = 1095216660480;
pub const ETHTOOL_RX_FLOW_SPEC_RING_VF_OFF: u32 = 32;
pub const ETH_RXFH_CONTEXT_ALLOC: u32 = 4294967295;
pub const ETH_RXFH_INDIR_NO_CHANGE: u32 = 4294967295;
pub const ETHTOOL_RXNTUPLE_ACTION_DROP: i32 = -1;
pub const ETHTOOL_RXNTUPLE_ACTION_CLEAR: i32 = -2;
pub const ETHTOOL_FLASH_MAX_FILENAME: u32 = 128;
pub const ETH_FW_DUMP_DISABLE: u32 = 0;
pub const MAX_NUM_QUEUE: u32 = 4096;
pub const ETHTOOL_GSET: u32 = 1;
pub const ETHTOOL_SSET: u32 = 2;
pub const ETHTOOL_GDRVINFO: u32 = 3;
pub const ETHTOOL_GREGS: u32 = 4;
pub const ETHTOOL_GWOL: u32 = 5;
pub const ETHTOOL_SWOL: u32 = 6;
pub const ETHTOOL_GMSGLVL: u32 = 7;
pub const ETHTOOL_SMSGLVL: u32 = 8;
pub const ETHTOOL_NWAY_RST: u32 = 9;
pub const ETHTOOL_GLINK: u32 = 10;
pub const ETHTOOL_GEEPROM: u32 = 11;
pub const ETHTOOL_SEEPROM: u32 = 12;
pub const ETHTOOL_GCOALESCE: u32 = 14;
pub const ETHTOOL_SCOALESCE: u32 = 15;
pub const ETHTOOL_GRINGPARAM: u32 = 16;
pub const ETHTOOL_SRINGPARAM: u32 = 17;
pub const ETHTOOL_GPAUSEPARAM: u32 = 18;
pub const ETHTOOL_SPAUSEPARAM: u32 = 19;
pub const ETHTOOL_GRXCSUM: u32 = 20;
pub const ETHTOOL_SRXCSUM: u32 = 21;
pub const ETHTOOL_GTXCSUM: u32 = 22;
pub const ETHTOOL_STXCSUM: u32 = 23;
pub const ETHTOOL_GSG: u32 = 24;
pub const ETHTOOL_SSG: u32 = 25;
pub const ETHTOOL_TEST: u32 = 26;
pub const ETHTOOL_GSTRINGS: u32 = 27;
pub const ETHTOOL_PHYS_ID: u32 = 28;
pub const ETHTOOL_GSTATS: u32 = 29;
pub const ETHTOOL_GTSO: u32 = 30;
pub const ETHTOOL_STSO: u32 = 31;
pub const ETHTOOL_GPERMADDR: u32 = 32;
pub const ETHTOOL_GUFO: u32 = 33;
pub const ETHTOOL_SUFO: u32 = 34;
pub const ETHTOOL_GGSO: u32 = 35;
pub const ETHTOOL_SGSO: u32 = 36;
pub const ETHTOOL_GFLAGS: u32 = 37;
pub const ETHTOOL_SFLAGS: u32 = 38;
pub const ETHTOOL_GPFLAGS: u32 = 39;
pub const ETHTOOL_SPFLAGS: u32 = 40;
pub const ETHTOOL_GRXFH: u32 = 41;
pub const ETHTOOL_SRXFH: u32 = 42;
pub const ETHTOOL_GGRO: u32 = 43;
pub const ETHTOOL_SGRO: u32 = 44;
pub const ETHTOOL_GRXRINGS: u32 = 45;
pub const ETHTOOL_GRXCLSRLCNT: u32 = 46;
pub const ETHTOOL_GRXCLSRULE: u32 = 47;
pub const ETHTOOL_GRXCLSRLALL: u32 = 48;
pub const ETHTOOL_SRXCLSRLDEL: u32 = 49;
pub const ETHTOOL_SRXCLSRLINS: u32 = 50;
pub const ETHTOOL_FLASHDEV: u32 = 51;
pub const ETHTOOL_RESET: u32 = 52;
pub const ETHTOOL_SRXNTUPLE: u32 = 53;
pub const ETHTOOL_GRXNTUPLE: u32 = 54;
pub const ETHTOOL_GSSET_INFO: u32 = 55;
pub const ETHTOOL_GRXFHINDIR: u32 = 56;
pub const ETHTOOL_SRXFHINDIR: u32 = 57;
pub const ETHTOOL_GFEATURES: u32 = 58;
pub const ETHTOOL_SFEATURES: u32 = 59;
pub const ETHTOOL_GCHANNELS: u32 = 60;
pub const ETHTOOL_SCHANNELS: u32 = 61;
pub const ETHTOOL_SET_DUMP: u32 = 62;
pub const ETHTOOL_GET_DUMP_FLAG: u32 = 63;
pub const ETHTOOL_GET_DUMP_DATA: u32 = 64;
pub const ETHTOOL_GET_TS_INFO: u32 = 65;
pub const ETHTOOL_GMODULEINFO: u32 = 66;
pub const ETHTOOL_GMODULEEEPROM: u32 = 67;
pub const ETHTOOL_GEEE: u32 = 68;
pub const ETHTOOL_SEEE: u32 = 69;
pub const ETHTOOL_GRSSH: u32 = 70;
pub const ETHTOOL_SRSSH: u32 = 71;
pub const ETHTOOL_GTUNABLE: u32 = 72;
pub const ETHTOOL_STUNABLE: u32 = 73;
pub const ETHTOOL_GPHYSTATS: u32 = 74;
pub const ETHTOOL_PERQUEUE: u32 = 75;
pub const ETHTOOL_GLINKSETTINGS: u32 = 76;
pub const ETHTOOL_SLINKSETTINGS: u32 = 77;
pub const ETHTOOL_PHY_GTUNABLE: u32 = 78;
pub const ETHTOOL_PHY_STUNABLE: u32 = 79;
pub const ETHTOOL_GFECPARAM: u32 = 80;
pub const ETHTOOL_SFECPARAM: u32 = 81;
pub const SPARC_ETH_GSET: u32 = 1;
pub const SPARC_ETH_SSET: u32 = 2;
pub const SPEED_10: u32 = 10;
pub const SPEED_100: u32 = 100;
pub const SPEED_1000: u32 = 1000;
pub const SPEED_2500: u32 = 2500;
pub const SPEED_5000: u32 = 5000;
pub const SPEED_10000: u32 = 10000;
pub const SPEED_14000: u32 = 14000;
pub const SPEED_20000: u32 = 20000;
pub const SPEED_25000: u32 = 25000;
pub const SPEED_40000: u32 = 40000;
pub const SPEED_50000: u32 = 50000;
pub const SPEED_56000: u32 = 56000;
pub const SPEED_100000: u32 = 100000;
pub const SPEED_200000: u32 = 200000;
pub const SPEED_400000: u32 = 400000;
pub const SPEED_800000: u32 = 800000;
pub const SPEED_UNKNOWN: i32 = -1;
pub const DUPLEX_HALF: u32 = 0;
pub const DUPLEX_FULL: u32 = 1;
pub const DUPLEX_UNKNOWN: u32 = 255;
pub const MASTER_SLAVE_CFG_UNSUPPORTED: u32 = 0;
pub const MASTER_SLAVE_CFG_UNKNOWN: u32 = 1;
pub const MASTER_SLAVE_CFG_MASTER_PREFERRED: u32 = 2;
pub const MASTER_SLAVE_CFG_SLAVE_PREFERRED: u32 = 3;
pub const MASTER_SLAVE_CFG_MASTER_FORCE: u32 = 4;
pub const MASTER_SLAVE_CFG_SLAVE_FORCE: u32 = 5;
pub const MASTER_SLAVE_STATE_UNSUPPORTED: u32 = 0;
pub const MASTER_SLAVE_STATE_UNKNOWN: u32 = 1;
pub const MASTER_SLAVE_STATE_MASTER: u32 = 2;
pub const MASTER_SLAVE_STATE_SLAVE: u32 = 3;
pub const MASTER_SLAVE_STATE_ERR: u32 = 4;
pub const RATE_MATCH_NONE: u32 = 0;
pub const RATE_MATCH_PAUSE: u32 = 1;
pub const RATE_MATCH_CRS: u32 = 2;
pub const RATE_MATCH_OPEN_LOOP: u32 = 3;
pub const PORT_TP: u32 = 0;
pub const PORT_AUI: u32 = 1;
pub const PORT_MII: u32 = 2;
pub const PORT_FIBRE: u32 = 3;
pub const PORT_BNC: u32 = 4;
pub const PORT_DA: u32 = 5;
pub const PORT_NONE: u32 = 239;
pub const PORT_OTHER: u32 = 255;
pub const XCVR_INTERNAL: u32 = 0;
pub const XCVR_EXTERNAL: u32 = 1;
pub const XCVR_DUMMY1: u32 = 2;
pub const XCVR_DUMMY2: u32 = 3;
pub const XCVR_DUMMY3: u32 = 4;
pub const AUTONEG_DISABLE: u32 = 0;
pub const AUTONEG_ENABLE: u32 = 1;
pub const ETH_TP_MDI_INVALID: u32 = 0;
pub const ETH_TP_MDI: u32 = 1;
pub const ETH_TP_MDI_X: u32 = 2;
pub const ETH_TP_MDI_AUTO: u32 = 3;
pub const WAKE_PHY: u32 = 1;
pub const WAKE_UCAST: u32 = 2;
pub const WAKE_MCAST: u32 = 4;
pub const WAKE_BCAST: u32 = 8;
pub const WAKE_ARP: u32 = 16;
pub const WAKE_MAGIC: u32 = 32;
pub const WAKE_MAGICSECURE: u32 = 64;
pub const WAKE_FILTER: u32 = 128;
pub const WOL_MODE_COUNT: u32 = 8;
pub const RXH_XFRM_SYM_XOR: u32 = 1;
pub const RXH_XFRM_SYM_OR_XOR: u32 = 2;
pub const RXH_XFRM_NO_CHANGE: u32 = 255;
pub const FLOW_EXT: u32 = 2147483648;
pub const FLOW_MAC_EXT: u32 = 1073741824;
pub const FLOW_RSS: u32 = 536870912;
pub const RXH_L2DA: u32 = 2;
pub const RXH_VLAN: u32 = 4;
pub const RXH_L3_PROTO: u32 = 8;
pub const RXH_IP_SRC: u32 = 16;
pub const RXH_IP_DST: u32 = 32;
pub const RXH_L4_B_0_1: u32 = 64;
pub const RXH_L4_B_2_3: u32 = 128;
pub const RXH_GTP_TEID: u32 = 256;
pub const RXH_IP6_FL: u32 = 512;
pub const RXH_DISCARD: u32 = 2147483648;
pub const RX_CLS_FLOW_DISC: i32 = -1;
pub const RX_CLS_FLOW_WAKE: i32 = -2;
pub const RX_CLS_LOC_SPECIAL: u32 = 2147483648;
pub const RX_CLS_LOC_ANY: u32 = 4294967295;
pub const RX_CLS_LOC_FIRST: u32 = 4294967294;
pub const RX_CLS_LOC_LAST: u32 = 4294967293;
pub const ETH_MODULE_SFF_8079: u32 = 1;
pub const ETH_MODULE_SFF_8079_LEN: u32 = 256;
pub const ETH_MODULE_SFF_8472: u32 = 2;
pub const ETH_MODULE_SFF_8472_LEN: u32 = 512;
pub const ETH_MODULE_SFF_8636: u32 = 3;
pub const ETH_MODULE_SFF_8636_LEN: u32 = 256;
pub const ETH_MODULE_SFF_8436: u32 = 4;
pub const ETH_MODULE_SFF_8436_LEN: u32 = 256;
pub const ETH_MODULE_SFF_8636_MAX_LEN: u32 = 640;
pub const ETH_MODULE_SFF_8436_MAX_LEN: u32 = 640;
pub const ETH_RESET_SHARED_SHIFT: u32 = 16;
pub const ETHTOOL_GENL_NAME: &[u8; 8] = b"ethtool\0";
pub const ETHTOOL_GENL_VERSION: u32 = 1;
pub const ETHTOOL_MCGRP_MONITOR_NAME: &[u8; 8] = b"monitor\0";
pub const ETHTOOL_MM_MAX_VERIFY_TIME_MS: u32 = 128;
pub const ETHTOOL_MM_MAX_VERIFY_RETRIES: u32 = 3;
pub const ETH_RSS_HASH_UNKNOWN: u32 = 0;
pub const ETH_RSS_HASH_NO_CHANGE: u32 = 0;
pub const ETHTOOL_STAT_NOT_SET: i32 = -1;
pub const ETHTOOL_MAX_LANES: u32 = 8;
pub const ETHTOOL_FEC_HIST_MAX: u32 = 17;
pub const ETHTOOL_RMON_HIST_MAX: u32 = 11;
pub const ETH_MODULE_EEPROM_PAGE_LEN: u32 = 128;
pub const ETH_MODULE_MAX_I2C_ADDRESS: u32 = 127;
pub const NR_OPEN_DEFAULT: u32 = 64;
pub const FW_ACTION_NOUEVENT: u32 = 0;
pub const FW_ACTION_UEVENT: u32 = 1;
pub const MII_BMCR: u32 = 0;
pub const MII_BMSR: u32 = 1;
pub const MII_PHYSID1: u32 = 2;
pub const MII_PHYSID2: u32 = 3;
pub const MII_ADVERTISE: u32 = 4;
pub const MII_LPA: u32 = 5;
pub const MII_EXPANSION: u32 = 6;
pub const MII_CTRL1000: u32 = 9;
pub const MII_STAT1000: u32 = 10;
pub const MII_MMD_CTRL: u32 = 13;
pub const MII_MMD_DATA: u32 = 14;
pub const MII_ESTATUS: u32 = 15;
pub const MII_DCOUNTER: u32 = 18;
pub const MII_FCSCOUNTER: u32 = 19;
pub const MII_NWAYTEST: u32 = 20;
pub const MII_RERRCOUNTER: u32 = 21;
pub const MII_SREVISION: u32 = 22;
pub const MII_RESV1: u32 = 23;
pub const MII_LBRERROR: u32 = 24;
pub const MII_PHYADDR: u32 = 25;
pub const MII_RESV2: u32 = 26;
pub const MII_TPISTATUS: u32 = 27;
pub const MII_NCONFIG: u32 = 28;
pub const BMCR_RESV: u32 = 63;
pub const BMCR_SPEED1000: u32 = 64;
pub const BMCR_CTST: u32 = 128;
pub const BMCR_FULLDPLX: u32 = 256;
pub const BMCR_ANRESTART: u32 = 512;
pub const BMCR_ISOLATE: u32 = 1024;
pub const BMCR_PDOWN: u32 = 2048;
pub const BMCR_ANENABLE: u32 = 4096;
pub const BMCR_SPEED100: u32 = 8192;
pub const BMCR_LOOPBACK: u32 = 16384;
pub const BMCR_RESET: u32 = 32768;
pub const BMCR_SPEED10: u32 = 0;
pub const BMSR_ERCAP: u32 = 1;
pub const BMSR_JCD: u32 = 2;
pub const BMSR_LSTATUS: u32 = 4;
pub const BMSR_ANEGCAPABLE: u32 = 8;
pub const BMSR_RFAULT: u32 = 16;
pub const BMSR_ANEGCOMPLETE: u32 = 32;
pub const BMSR_RESV: u32 = 192;
pub const BMSR_ESTATEN: u32 = 256;
pub const BMSR_100HALF2: u32 = 512;
pub const BMSR_100FULL2: u32 = 1024;
pub const BMSR_10HALF: u32 = 2048;
pub const BMSR_10FULL: u32 = 4096;
pub const BMSR_100HALF: u32 = 8192;
pub const BMSR_100FULL: u32 = 16384;
pub const BMSR_100BASE4: u32 = 32768;
pub const ADVERTISE_SLCT: u32 = 31;
pub const ADVERTISE_CSMA: u32 = 1;
pub const ADVERTISE_10HALF: u32 = 32;
pub const ADVERTISE_1000XFULL: u32 = 32;
pub const ADVERTISE_10FULL: u32 = 64;
pub const ADVERTISE_1000XHALF: u32 = 64;
pub const ADVERTISE_100HALF: u32 = 128;
pub const ADVERTISE_1000XPAUSE: u32 = 128;
pub const ADVERTISE_100FULL: u32 = 256;
pub const ADVERTISE_1000XPSE_ASYM: u32 = 256;
pub const ADVERTISE_100BASE4: u32 = 512;
pub const ADVERTISE_PAUSE_CAP: u32 = 1024;
pub const ADVERTISE_PAUSE_ASYM: u32 = 2048;
pub const ADVERTISE_RESV: u32 = 4096;
pub const ADVERTISE_RFAULT: u32 = 8192;
pub const ADVERTISE_LPACK: u32 = 16384;
pub const ADVERTISE_NPAGE: u32 = 32768;
pub const ADVERTISE_FULL: u32 = 321;
pub const ADVERTISE_ALL: u32 = 480;
pub const LPA_SLCT: u32 = 31;
pub const LPA_10HALF: u32 = 32;
pub const LPA_1000XFULL: u32 = 32;
pub const LPA_10FULL: u32 = 64;
pub const LPA_1000XHALF: u32 = 64;
pub const LPA_100HALF: u32 = 128;
pub const LPA_1000XPAUSE: u32 = 128;
pub const LPA_100FULL: u32 = 256;
pub const LPA_1000XPAUSE_ASYM: u32 = 256;
pub const LPA_100BASE4: u32 = 512;
pub const LPA_PAUSE_CAP: u32 = 1024;
pub const LPA_PAUSE_ASYM: u32 = 2048;
pub const LPA_RESV: u32 = 4096;
pub const LPA_RFAULT: u32 = 8192;
pub const LPA_LPACK: u32 = 16384;
pub const LPA_NPAGE: u32 = 32768;
pub const LPA_DUPLEX: u32 = 320;
pub const LPA_100: u32 = 896;
pub const EXPANSION_NWAY: u32 = 1;
pub const EXPANSION_LCWP: u32 = 2;
pub const EXPANSION_ENABLENPAGE: u32 = 4;
pub const EXPANSION_NPCAPABLE: u32 = 8;
pub const EXPANSION_MFAULTS: u32 = 16;
pub const EXPANSION_RESV: u32 = 65504;
pub const ESTATUS_1000_XFULL: u32 = 32768;
pub const ESTATUS_1000_XHALF: u32 = 16384;
pub const ESTATUS_1000_TFULL: u32 = 8192;
pub const ESTATUS_1000_THALF: u32 = 4096;
pub const NWAYTEST_RESV1: u32 = 255;
pub const NWAYTEST_LOOPBACK: u32 = 256;
pub const NWAYTEST_RESV2: u32 = 65024;
pub const ADVERTISE_SGMII: u32 = 1;
pub const LPA_SGMII: u32 = 1;
pub const LPA_SGMII_SPD_MASK: u32 = 3072;
pub const LPA_SGMII_FULL_DUPLEX: u32 = 4096;
pub const LPA_SGMII_DPX_SPD_MASK: u32 = 7168;
pub const LPA_SGMII_10: u32 = 0;
pub const LPA_SGMII_10HALF: u32 = 0;
pub const LPA_SGMII_10FULL: u32 = 4096;
pub const LPA_SGMII_100: u32 = 1024;
pub const LPA_SGMII_100HALF: u32 = 1024;
pub const LPA_SGMII_100FULL: u32 = 5120;
pub const LPA_SGMII_1000: u32 = 2048;
pub const LPA_SGMII_1000HALF: u32 = 2048;
pub const LPA_SGMII_1000FULL: u32 = 6144;
pub const LPA_SGMII_LINK: u32 = 32768;
pub const ADVERTISE_1000FULL: u32 = 512;
pub const ADVERTISE_1000HALF: u32 = 256;
pub const CTL1000_PREFER_MASTER: u32 = 1024;
pub const CTL1000_AS_MASTER: u32 = 2048;
pub const CTL1000_ENABLE_MASTER: u32 = 4096;
pub const LPA_1000MSFAIL: u32 = 32768;
pub const LPA_1000MSRES: u32 = 16384;
pub const LPA_1000LOCALRXOK: u32 = 8192;
pub const LPA_1000REMRXOK: u32 = 4096;
pub const LPA_1000FULL: u32 = 2048;
pub const LPA_1000HALF: u32 = 1024;
pub const FLOW_CTRL_TX: u32 = 1;
pub const FLOW_CTRL_RX: u32 = 2;
pub const MII_MMD_CTRL_DEVAD_MASK: u32 = 31;
pub const MII_MMD_CTRL_ADDR: u32 = 0;
pub const MII_MMD_CTRL_NOINCR: u32 = 16384;
pub const MII_MMD_CTRL_INCR_RDWT: u32 = 32768;
pub const MII_MMD_CTRL_INCR_ON_WT: u32 = 49152;
pub const MDIO_MMD_PMAPMD: u32 = 1;
pub const MDIO_MMD_WIS: u32 = 2;
pub const MDIO_MMD_PCS: u32 = 3;
pub const MDIO_MMD_PHYXS: u32 = 4;
pub const MDIO_MMD_DTEXS: u32 = 5;
pub const MDIO_MMD_TC: u32 = 6;
pub const MDIO_MMD_AN: u32 = 7;
pub const MDIO_MMD_POWER_UNIT: u32 = 13;
pub const MDIO_MMD_C22EXT: u32 = 29;
pub const MDIO_MMD_VEND1: u32 = 30;
pub const MDIO_MMD_VEND2: u32 = 31;
pub const MDIO_CTRL1: u32 = 0;
pub const MDIO_STAT1: u32 = 1;
pub const MDIO_DEVID1: u32 = 2;
pub const MDIO_DEVID2: u32 = 3;
pub const MDIO_SPEED: u32 = 4;
pub const MDIO_DEVS1: u32 = 5;
pub const MDIO_DEVS2: u32 = 6;
pub const MDIO_CTRL2: u32 = 7;
pub const MDIO_STAT2: u32 = 8;
pub const MDIO_PMA_TXDIS: u32 = 9;
pub const MDIO_PMA_RXDET: u32 = 10;
pub const MDIO_PMA_EXTABLE: u32 = 11;
pub const MDIO_PKGID1: u32 = 14;
pub const MDIO_PKGID2: u32 = 15;
pub const MDIO_AN_ADVERTISE: u32 = 16;
pub const MDIO_AN_LPA: u32 = 19;
pub const MDIO_PCS_EEE_ABLE: u32 = 20;
pub const MDIO_PCS_EEE_ABLE2: u32 = 21;
pub const MDIO_PMA_NG_EXTABLE: u32 = 21;
pub const MDIO_PCS_EEE_WK_ERR: u32 = 22;
pub const MDIO_PHYXS_LNSTAT: u32 = 24;
pub const MDIO_AN_EEE_ADV: u32 = 60;
pub const MDIO_AN_EEE_LPABLE: u32 = 61;
pub const MDIO_AN_EEE_ADV2: u32 = 62;
pub const MDIO_AN_EEE_LPABLE2: u32 = 63;
pub const MDIO_AN_CTRL2: u32 = 64;
pub const MDIO_PMA_10GBT_SWAPPOL: u32 = 130;
pub const MDIO_PMA_10GBT_TXPWR: u32 = 131;
pub const MDIO_PMA_10GBT_SNR: u32 = 133;
pub const MDIO_PMA_10GBR_FSRT_CSR: u32 = 147;
pub const MDIO_PMA_10GBR_FECABLE: u32 = 170;
pub const MDIO_PCS_10GBX_STAT1: u32 = 24;
pub const MDIO_PCS_10GBRT_STAT1: u32 = 32;
pub const MDIO_PCS_10GBRT_STAT2: u32 = 33;
pub const MDIO_AN_10GBT_CTRL: u32 = 32;
pub const MDIO_AN_10GBT_STAT: u32 = 33;
pub const MDIO_B10L_PMA_CTRL: u32 = 2294;
pub const MDIO_PMA_10T1L_STAT: u32 = 2295;
pub const MDIO_PCS_10T1L_CTRL: u32 = 2278;
pub const MDIO_PMA_PMD_BT1: u32 = 18;
pub const MDIO_AN_T1_CTRL: u32 = 512;
pub const MDIO_AN_T1_STAT: u32 = 513;
pub const MDIO_AN_T1_ADV_L: u32 = 514;
pub const MDIO_AN_T1_ADV_M: u32 = 515;
pub const MDIO_AN_T1_ADV_H: u32 = 516;
pub const MDIO_AN_T1_LP_L: u32 = 517;
pub const MDIO_AN_T1_LP_M: u32 = 518;
pub const MDIO_AN_T1_LP_H: u32 = 519;
pub const MDIO_AN_10BT1_AN_CTRL: u32 = 526;
pub const MDIO_AN_10BT1_AN_STAT: u32 = 527;
pub const MDIO_PMA_PMD_BT1_CTRL: u32 = 2100;
pub const MDIO_PCS_1000BT1_CTRL: u32 = 2304;
pub const MDIO_PCS_1000BT1_STAT: u32 = 2305;
pub const MDIO_PMA_LASI_RXCTRL: u32 = 36864;
pub const MDIO_PMA_LASI_TXCTRL: u32 = 36865;
pub const MDIO_PMA_LASI_CTRL: u32 = 36866;
pub const MDIO_PMA_LASI_RXSTAT: u32 = 36867;
pub const MDIO_PMA_LASI_TXSTAT: u32 = 36868;
pub const MDIO_PMA_LASI_STAT: u32 = 36869;
pub const MDIO_CTRL1_SPEEDSELEXT: u32 = 8256;
pub const MDIO_CTRL1_SPEEDSEL: u32 = 8316;
pub const MDIO_CTRL1_FULLDPLX: u32 = 256;
pub const MDIO_CTRL1_LPOWER: u32 = 2048;
pub const MDIO_CTRL1_RESET: u32 = 32768;
pub const MDIO_PMA_CTRL1_LOOPBACK: u32 = 1;
pub const MDIO_PMA_CTRL1_SPEED1000: u32 = 64;
pub const MDIO_PMA_CTRL1_SPEED100: u32 = 8192;
pub const MDIO_PCS_CTRL1_LOOPBACK: u32 = 16384;
pub const MDIO_PHYXS_CTRL1_LOOPBACK: u32 = 16384;
pub const MDIO_AN_CTRL1_RESTART: u32 = 512;
pub const MDIO_AN_CTRL1_ENABLE: u32 = 4096;
pub const MDIO_AN_CTRL1_XNP: u32 = 8192;
pub const MDIO_PCS_CTRL1_CLKSTOP_EN: u32 = 1024;
pub const MDIO_CTRL1_SPEED10G: u32 = 8256;
pub const MDIO_CTRL1_SPEED10P2B: u32 = 8260;
pub const MDIO_CTRL1_SPEED2_5G: u32 = 8280;
pub const MDIO_CTRL1_SPEED5G: u32 = 8284;
pub const MDIO_STAT1_LPOWERABLE: u32 = 2;
pub const MDIO_STAT1_LSTATUS: u32 = 4;
pub const MDIO_STAT1_FAULT: u32 = 128;
pub const MDIO_PCS_STAT1_CLKSTOP_CAP: u32 = 64;
pub const MDIO_AN_STAT1_LPABLE: u32 = 1;
pub const MDIO_AN_STAT1_ABLE: u32 = 8;
pub const MDIO_AN_STAT1_RFAULT: u32 = 16;
pub const MDIO_AN_STAT1_COMPLETE: u32 = 32;
pub const MDIO_AN_STAT1_PAGE: u32 = 64;
pub const MDIO_AN_STAT1_XNP: u32 = 128;
pub const MDIO_SPEED_10G: u32 = 1;
pub const MDIO_PMA_SPEED_2B: u32 = 2;
pub const MDIO_PMA_SPEED_10P: u32 = 4;
pub const MDIO_PMA_SPEED_1000: u32 = 16;
pub const MDIO_PMA_SPEED_100: u32 = 32;
pub const MDIO_PMA_SPEED_10: u32 = 64;
pub const MDIO_PMA_SPEED_2_5G: u32 = 8192;
pub const MDIO_PMA_SPEED_5G: u32 = 16384;
pub const MDIO_PCS_SPEED_10P2B: u32 = 2;
pub const MDIO_PCS_SPEED_2_5G: u32 = 64;
pub const MDIO_PCS_SPEED_5G: u32 = 128;
pub const MDIO_PMA_CTRL2_TYPE: u32 = 15;
pub const MDIO_PMA_CTRL2_10GBCX4: u32 = 0;
pub const MDIO_PMA_CTRL2_10GBEW: u32 = 1;
pub const MDIO_PMA_CTRL2_10GBLW: u32 = 2;
pub const MDIO_PMA_CTRL2_10GBSW: u32 = 3;
pub const MDIO_PMA_CTRL2_10GBLX4: u32 = 4;
pub const MDIO_PMA_CTRL2_10GBER: u32 = 5;
pub const MDIO_PMA_CTRL2_10GBLR: u32 = 6;
pub const MDIO_PMA_CTRL2_10GBSR: u32 = 7;
pub const MDIO_PMA_CTRL2_10GBLRM: u32 = 8;
pub const MDIO_PMA_CTRL2_10GBT: u32 = 9;
pub const MDIO_PMA_CTRL2_10GBKX4: u32 = 10;
pub const MDIO_PMA_CTRL2_10GBKR: u32 = 11;
pub const MDIO_PMA_CTRL2_1000BT: u32 = 12;
pub const MDIO_PMA_CTRL2_1000BKX: u32 = 13;
pub const MDIO_PMA_CTRL2_100BTX: u32 = 14;
pub const MDIO_PMA_CTRL2_10BT: u32 = 15;
pub const MDIO_PMA_CTRL2_2_5GBT: u32 = 48;
pub const MDIO_PMA_CTRL2_5GBT: u32 = 49;
pub const MDIO_PMA_CTRL2_BASET1: u32 = 61;
pub const MDIO_PCS_CTRL2_TYPE: u32 = 3;
pub const MDIO_PCS_CTRL2_10GBR: u32 = 0;
pub const MDIO_PCS_CTRL2_10GBX: u32 = 1;
pub const MDIO_PCS_CTRL2_10GBW: u32 = 2;
pub const MDIO_PCS_CTRL2_10GBT: u32 = 3;
pub const MDIO_STAT2_RXFAULT: u32 = 1024;
pub const MDIO_STAT2_TXFAULT: u32 = 2048;
pub const MDIO_STAT2_DEVPRST: u32 = 49152;
pub const MDIO_STAT2_DEVPRST_VAL: u32 = 32768;
pub const MDIO_PMA_STAT2_LBABLE: u32 = 1;
pub const MDIO_PMA_STAT2_10GBEW: u32 = 2;
pub const MDIO_PMA_STAT2_10GBLW: u32 = 4;
pub const MDIO_PMA_STAT2_10GBSW: u32 = 8;
pub const MDIO_PMA_STAT2_10GBLX4: u32 = 16;
pub const MDIO_PMA_STAT2_10GBER: u32 = 32;
pub const MDIO_PMA_STAT2_10GBLR: u32 = 64;
pub const MDIO_PMA_STAT2_10GBSR: u32 = 128;
pub const MDIO_PMD_STAT2_TXDISAB: u32 = 256;
pub const MDIO_PMA_STAT2_EXTABLE: u32 = 512;
pub const MDIO_PMA_STAT2_RXFLTABLE: u32 = 4096;
pub const MDIO_PMA_STAT2_TXFLTABLE: u32 = 8192;
pub const MDIO_PCS_STAT2_10GBR: u32 = 1;
pub const MDIO_PCS_STAT2_10GBX: u32 = 2;
pub const MDIO_PCS_STAT2_10GBW: u32 = 4;
pub const MDIO_PCS_STAT2_RXFLTABLE: u32 = 4096;
pub const MDIO_PCS_STAT2_TXFLTABLE: u32 = 8192;
pub const MDIO_PMD_TXDIS_GLOBAL: u32 = 1;
pub const MDIO_PMD_TXDIS_0: u32 = 2;
pub const MDIO_PMD_TXDIS_1: u32 = 4;
pub const MDIO_PMD_TXDIS_2: u32 = 8;
pub const MDIO_PMD_TXDIS_3: u32 = 16;
pub const MDIO_PMD_RXDET_GLOBAL: u32 = 1;
pub const MDIO_PMD_RXDET_0: u32 = 2;
pub const MDIO_PMD_RXDET_1: u32 = 4;
pub const MDIO_PMD_RXDET_2: u32 = 8;
pub const MDIO_PMD_RXDET_3: u32 = 16;
pub const MDIO_PMA_EXTABLE_10GCX4: u32 = 1;
pub const MDIO_PMA_EXTABLE_10GBLRM: u32 = 2;
pub const MDIO_PMA_EXTABLE_10GBT: u32 = 4;
pub const MDIO_PMA_EXTABLE_10GBKX4: u32 = 8;
pub const MDIO_PMA_EXTABLE_10GBKR: u32 = 16;
pub const MDIO_PMA_EXTABLE_1000BT: u32 = 32;
pub const MDIO_PMA_EXTABLE_1000BKX: u32 = 64;
pub const MDIO_PMA_EXTABLE_100BTX: u32 = 128;
pub const MDIO_PMA_EXTABLE_10BT: u32 = 256;
pub const MDIO_PMA_EXTABLE_BT1: u32 = 2048;
pub const MDIO_PMA_EXTABLE_NBT: u32 = 16384;
pub const MDIO_PHYXS_LNSTAT_SYNC0: u32 = 1;
pub const MDIO_PHYXS_LNSTAT_SYNC1: u32 = 2;
pub const MDIO_PHYXS_LNSTAT_SYNC2: u32 = 4;
pub const MDIO_PHYXS_LNSTAT_SYNC3: u32 = 8;
pub const MDIO_PHYXS_LNSTAT_ALIGN: u32 = 4096;
pub const MDIO_PMA_10GBT_SWAPPOL_ABNX: u32 = 1;
pub const MDIO_PMA_10GBT_SWAPPOL_CDNX: u32 = 2;
pub const MDIO_PMA_10GBT_SWAPPOL_AREV: u32 = 256;
pub const MDIO_PMA_10GBT_SWAPPOL_BREV: u32 = 512;
pub const MDIO_PMA_10GBT_SWAPPOL_CREV: u32 = 1024;
pub const MDIO_PMA_10GBT_SWAPPOL_DREV: u32 = 2048;
pub const MDIO_PMA_10GBT_TXPWR_SHORT: u32 = 1;
pub const MDIO_PMA_10GBT_SNR_BIAS: u32 = 32768;
pub const MDIO_PMA_10GBT_SNR_MAX: u32 = 127;
pub const MDIO_PMA_10GBR_FECABLE_ABLE: u32 = 1;
pub const MDIO_PMA_10GBR_FECABLE_ERRABLE: u32 = 2;
pub const MDIO_PMA_10GBR_FSRT_ENABLE: u32 = 1;
pub const MDIO_PCS_10GBRT_STAT1_BLKLK: u32 = 1;
pub const MDIO_PCS_10GBRT_STAT2_ERR: u32 = 255;
pub const MDIO_PCS_10GBRT_STAT2_BER: u32 = 16128;
pub const MDIO_AN_10GBT_CTRL_ADVFSRT2_5G: u32 = 32;
pub const MDIO_AN_10GBT_CTRL_ADV2_5G: u32 = 128;
pub const MDIO_AN_10GBT_CTRL_ADV5G: u32 = 256;
pub const MDIO_AN_10GBT_CTRL_ADV10G: u32 = 4096;
pub const MDIO_AN_10GBT_STAT_LP2_5G: u32 = 32;
pub const MDIO_AN_10GBT_STAT_LP5G: u32 = 64;
pub const MDIO_AN_10GBT_STAT_LPTRR: u32 = 512;
pub const MDIO_AN_10GBT_STAT_LPLTABLE: u32 = 1024;
pub const MDIO_AN_10GBT_STAT_LP10G: u32 = 2048;
pub const MDIO_AN_10GBT_STAT_REMOK: u32 = 4096;
pub const MDIO_AN_10GBT_STAT_LOCOK: u32 = 8192;
pub const MDIO_AN_10GBT_STAT_MS: u32 = 16384;
pub const MDIO_AN_10GBT_STAT_MSFLT: u32 = 32768;
pub const MDIO_PMA_10T1L_CTRL_LB_EN: u32 = 1;
pub const MDIO_PMA_10T1L_CTRL_EEE_EN: u32 = 1024;
pub const MDIO_PMA_10T1L_CTRL_LOW_POWER: u32 = 2048;
pub const MDIO_PMA_10T1L_CTRL_2V4_EN: u32 = 4096;
pub const MDIO_PMA_10T1L_CTRL_TX_DIS: u32 = 16384;
pub const MDIO_PMA_10T1L_CTRL_PMA_RST: u32 = 32768;
pub const MDIO_PMA_10T1L_STAT_LINK: u32 = 1;
pub const MDIO_PMA_10T1L_STAT_FAULT: u32 = 2;
pub const MDIO_PMA_10T1L_STAT_POLARITY: u32 = 4;
pub const MDIO_PMA_10T1L_STAT_RECV_FAULT: u32 = 512;
pub const MDIO_PMA_10T1L_STAT_EEE: u32 = 1024;
pub const MDIO_PMA_10T1L_STAT_LOW_POWER: u32 = 2048;
pub const MDIO_PMA_10T1L_STAT_2V4_ABLE: u32 = 4096;
pub const MDIO_PMA_10T1L_STAT_LB_ABLE: u32 = 8192;
pub const MDIO_PCS_10T1L_CTRL_LB: u32 = 16384;
pub const MDIO_PCS_10T1L_CTRL_RESET: u32 = 32768;
pub const MDIO_PMA_PMD_BT1_B100_ABLE: u32 = 1;
pub const MDIO_PMA_PMD_BT1_B1000_ABLE: u32 = 2;
pub const MDIO_PMA_PMD_BT1_B10L_ABLE: u32 = 4;
pub const MDIO_AN_T1_ADV_L_PAUSE_CAP: u32 = 1024;
pub const MDIO_AN_T1_ADV_L_PAUSE_ASYM: u32 = 2048;
pub const MDIO_AN_T1_ADV_L_FORCE_MS: u32 = 4096;
pub const MDIO_AN_T1_ADV_L_REMOTE_FAULT: u32 = 8192;
pub const MDIO_AN_T1_ADV_L_ACK: u32 = 16384;
pub const MDIO_AN_T1_ADV_L_NEXT_PAGE_REQ: u32 = 32768;
pub const MDIO_AN_T1_ADV_M_B10L: u32 = 16384;
pub const MDIO_AN_T1_ADV_M_1000BT1: u32 = 128;
pub const MDIO_AN_T1_ADV_M_100BT1: u32 = 32;
pub const MDIO_AN_T1_ADV_M_MST: u32 = 16;
pub const MDIO_AN_T1_ADV_H_10L_TX_HI_REQ: u32 = 4096;
pub const MDIO_AN_T1_ADV_H_10L_TX_HI: u32 = 8192;
pub const MDIO_AN_T1_LP_L_PAUSE_CAP: u32 = 1024;
pub const MDIO_AN_T1_LP_L_PAUSE_ASYM: u32 = 2048;
pub const MDIO_AN_T1_LP_L_FORCE_MS: u32 = 4096;
pub const MDIO_AN_T1_LP_L_REMOTE_FAULT: u32 = 8192;
pub const MDIO_AN_T1_LP_L_ACK: u32 = 16384;
pub const MDIO_AN_T1_LP_L_NEXT_PAGE_REQ: u32 = 32768;
pub const MDIO_AN_T1_LP_M_MST: u32 = 16;
pub const MDIO_AN_T1_LP_M_B10L: u32 = 16384;
pub const MDIO_AN_T1_LP_H_10L_TX_HI_REQ: u32 = 4096;
pub const MDIO_AN_T1_LP_H_10L_TX_HI: u32 = 8192;
pub const MDIO_AN_10BT1_AN_CTRL_ADV_EEE_T1L: u32 = 16384;
pub const MDIO_AN_10BT1_AN_STAT_LPA_EEE_T1L: u32 = 16384;
pub const MDIO_PMA_PMD_BT1_CTRL_STRAP: u32 = 15;
pub const MDIO_PMA_PMD_BT1_CTRL_STRAP_B1000: u32 = 1;
pub const MDIO_PMA_PMD_BT1_CTRL_CFG_MST: u32 = 16384;
pub const MDIO_PCS_1000BT1_CTRL_LOW_POWER: u32 = 2048;
pub const MDIO_PCS_1000BT1_CTRL_DISABLE_TX: u32 = 16384;
pub const MDIO_PCS_1000BT1_CTRL_RESET: u32 = 32768;
pub const MDIO_PCS_1000BT1_STAT_LINK: u32 = 4;
pub const MDIO_PCS_1000BT1_STAT_FAULT: u32 = 128;
pub const MDIO_AN_EEE_ADV_100TX: u32 = 2;
pub const MDIO_AN_EEE_ADV_1000T: u32 = 4;
pub const MDIO_EEE_100TX: u32 = 2;
pub const MDIO_EEE_1000T: u32 = 4;
pub const MDIO_EEE_10GT: u32 = 8;
pub const MDIO_EEE_1000KX: u32 = 16;
pub const MDIO_EEE_10GKX4: u32 = 32;
pub const MDIO_EEE_10GKR: u32 = 64;
pub const MDIO_EEE_40GR_FW: u32 = 256;
pub const MDIO_EEE_40GR_DS: u32 = 512;
pub const MDIO_EEE_100GR_FW: u32 = 4096;
pub const MDIO_EEE_100GR_DS: u32 = 8192;
pub const MDIO_EEE_2_5GT: u32 = 1;
pub const MDIO_EEE_5GT: u32 = 2;
pub const MDIO_AN_THP_BP2_5GT: u32 = 8;
pub const MDIO_PMA_NG_EXTABLE_2_5GBT: u32 = 1;
pub const MDIO_PMA_NG_EXTABLE_5GBT: u32 = 2;
pub const MDIO_PMA_LASI_RX_PHYXSLFLT: u32 = 1;
pub const MDIO_PMA_LASI_RX_PCSLFLT: u32 = 8;
pub const MDIO_PMA_LASI_RX_PMALFLT: u32 = 16;
pub const MDIO_PMA_LASI_RX_OPTICPOWERFLT: u32 = 32;
pub const MDIO_PMA_LASI_RX_WISLFLT: u32 = 512;
pub const MDIO_PMA_LASI_TX_PHYXSLFLT: u32 = 1;
pub const MDIO_PMA_LASI_TX_PCSLFLT: u32 = 8;
pub const MDIO_PMA_LASI_TX_PMALFLT: u32 = 16;
pub const MDIO_PMA_LASI_TX_LASERPOWERFLT: u32 = 128;
pub const MDIO_PMA_LASI_TX_LASERTEMPFLT: u32 = 256;
pub const MDIO_PMA_LASI_TX_LASERBICURRFLT: u32 = 512;
pub const MDIO_PMA_LASI_LSALARM: u32 = 1;
pub const MDIO_PMA_LASI_TXALARM: u32 = 2;
pub const MDIO_PMA_LASI_RXALARM: u32 = 4;
pub const MDIO_PHY_ID_C45: u32 = 32768;
pub const MDIO_PHY_ID_PRTAD: u32 = 992;
pub const MDIO_PHY_ID_DEVAD: u32 = 31;
pub const MDIO_PHY_ID_C45_MASK: u32 = 33791;
pub const MDIO_USXGMII_EEE_CLK_STP: u32 = 128;
pub const MDIO_USXGMII_EEE: u32 = 256;
pub const MDIO_USXGMII_SPD_MASK: u32 = 3584;
pub const MDIO_USXGMII_FULL_DUPLEX: u32 = 4096;
pub const MDIO_USXGMII_DPX_SPD_MASK: u32 = 7680;
pub const MDIO_USXGMII_10: u32 = 0;
pub const MDIO_USXGMII_10HALF: u32 = 0;
pub const MDIO_USXGMII_10FULL: u32 = 4096;
pub const MDIO_USXGMII_100: u32 = 512;
pub const MDIO_USXGMII_100HALF: u32 = 512;
pub const MDIO_USXGMII_100FULL: u32 = 4608;
pub const MDIO_USXGMII_1000: u32 = 1024;
pub const MDIO_USXGMII_1000HALF: u32 = 1024;
pub const MDIO_USXGMII_1000FULL: u32 = 5120;
pub const MDIO_USXGMII_10G: u32 = 1536;
pub const MDIO_USXGMII_10GHALF: u32 = 1536;
pub const MDIO_USXGMII_10GFULL: u32 = 5632;
pub const MDIO_USXGMII_2500: u32 = 2048;
pub const MDIO_USXGMII_2500HALF: u32 = 2048;
pub const MDIO_USXGMII_2500FULL: u32 = 6144;
pub const MDIO_USXGMII_5000: u32 = 2560;
pub const MDIO_USXGMII_5000HALF: u32 = 2560;
pub const MDIO_USXGMII_5000FULL: u32 = 6656;
pub const MDIO_USXGMII_LINK: u32 = 32768;
pub const MDIO_DEVICE_FLAG_PHY: u32 = 1;
pub const MDIO_PRTAD_NONE: i32 = -1;
pub const MDIO_DEVAD_NONE: i32 = -1;
pub const MDIO_SUPPORTS_C22: u32 = 1;
pub const MDIO_SUPPORTS_C45: u32 = 2;
pub const MDIO_EMULATE_C22: u32 = 4;
pub const UNNAMED_MAJOR: u32 = 0;
pub const MEM_MAJOR: u32 = 1;
pub const RAMDISK_MAJOR: u32 = 1;
pub const FLOPPY_MAJOR: u32 = 2;
pub const PTY_MASTER_MAJOR: u32 = 2;
pub const IDE0_MAJOR: u32 = 3;
pub const HD_MAJOR: u32 = 3;
pub const PTY_SLAVE_MAJOR: u32 = 3;
pub const TTY_MAJOR: u32 = 4;
pub const TTYAUX_MAJOR: u32 = 5;
pub const LP_MAJOR: u32 = 6;
pub const VCS_MAJOR: u32 = 7;
pub const LOOP_MAJOR: u32 = 7;
pub const SCSI_DISK0_MAJOR: u32 = 8;
pub const SCSI_TAPE_MAJOR: u32 = 9;
pub const MD_MAJOR: u32 = 9;
pub const MISC_MAJOR: u32 = 10;
pub const SCSI_CDROM_MAJOR: u32 = 11;
pub const MUX_MAJOR: u32 = 11;
pub const XT_DISK_MAJOR: u32 = 13;
pub const INPUT_MAJOR: u32 = 13;
pub const SOUND_MAJOR: u32 = 14;
pub const CDU31A_CDROM_MAJOR: u32 = 15;
pub const JOYSTICK_MAJOR: u32 = 15;
pub const GOLDSTAR_CDROM_MAJOR: u32 = 16;
pub const OPTICS_CDROM_MAJOR: u32 = 17;
pub const SANYO_CDROM_MAJOR: u32 = 18;
pub const MITSUMI_X_CDROM_MAJOR: u32 = 20;
pub const MFM_ACORN_MAJOR: u32 = 21;
pub const SCSI_GENERIC_MAJOR: u32 = 21;
pub const IDE1_MAJOR: u32 = 22;
pub const DIGICU_MAJOR: u32 = 22;
pub const DIGI_MAJOR: u32 = 23;
pub const MITSUMI_CDROM_MAJOR: u32 = 23;
pub const CDU535_CDROM_MAJOR: u32 = 24;
pub const STL_SERIALMAJOR: u32 = 24;
pub const MATSUSHITA_CDROM_MAJOR: u32 = 25;
pub const STL_CALLOUTMAJOR: u32 = 25;
pub const MATSUSHITA_CDROM2_MAJOR: u32 = 26;
pub const QIC117_TAPE_MAJOR: u32 = 27;
pub const MATSUSHITA_CDROM3_MAJOR: u32 = 27;
pub const MATSUSHITA_CDROM4_MAJOR: u32 = 28;
pub const STL_SIOMEMMAJOR: u32 = 28;
pub const ACSI_MAJOR: u32 = 28;
pub const AZTECH_CDROM_MAJOR: u32 = 29;
pub const FB_MAJOR: u32 = 29;
pub const MTD_BLOCK_MAJOR: u32 = 31;
pub const CM206_CDROM_MAJOR: u32 = 32;
pub const IDE2_MAJOR: u32 = 33;
pub const IDE3_MAJOR: u32 = 34;
pub const Z8530_MAJOR: u32 = 34;
pub const XPRAM_MAJOR: u32 = 35;
pub const NETLINK_MAJOR: u32 = 36;
pub const PS2ESDI_MAJOR: u32 = 36;
pub const IDETAPE_MAJOR: u32 = 37;
pub const Z2RAM_MAJOR: u32 = 37;
pub const APBLOCK_MAJOR: u32 = 38;
pub const DDV_MAJOR: u32 = 39;
pub const NBD_MAJOR: u32 = 43;
pub const RISCOM8_NORMAL_MAJOR: u32 = 48;
pub const DAC960_MAJOR: u32 = 48;
pub const RISCOM8_CALLOUT_MAJOR: u32 = 49;
pub const MKISS_MAJOR: u32 = 55;
pub const DSP56K_MAJOR: u32 = 55;
pub const IDE4_MAJOR: u32 = 56;
pub const IDE5_MAJOR: u32 = 57;
pub const SCSI_DISK1_MAJOR: u32 = 65;
pub const SCSI_DISK2_MAJOR: u32 = 66;
pub const SCSI_DISK3_MAJOR: u32 = 67;
pub const SCSI_DISK4_MAJOR: u32 = 68;
pub const SCSI_DISK5_MAJOR: u32 = 69;
pub const SCSI_DISK6_MAJOR: u32 = 70;
pub const SCSI_DISK7_MAJOR: u32 = 71;
pub const COMPAQ_SMART2_MAJOR: u32 = 72;
pub const COMPAQ_SMART2_MAJOR1: u32 = 73;
pub const COMPAQ_SMART2_MAJOR2: u32 = 74;
pub const COMPAQ_SMART2_MAJOR3: u32 = 75;
pub const COMPAQ_SMART2_MAJOR4: u32 = 76;
pub const COMPAQ_SMART2_MAJOR5: u32 = 77;
pub const COMPAQ_SMART2_MAJOR6: u32 = 78;
pub const COMPAQ_SMART2_MAJOR7: u32 = 79;
pub const SPECIALIX_NORMAL_MAJOR: u32 = 75;
pub const SPECIALIX_CALLOUT_MAJOR: u32 = 76;
pub const AURORA_MAJOR: u32 = 79;
pub const I2O_MAJOR: u32 = 80;
pub const SHMIQ_MAJOR: u32 = 85;
pub const SCSI_CHANGER_MAJOR: u32 = 86;
pub const IDE6_MAJOR: u32 = 88;
pub const IDE7_MAJOR: u32 = 89;
pub const IDE8_MAJOR: u32 = 90;
pub const MTD_CHAR_MAJOR: u32 = 90;
pub const IDE9_MAJOR: u32 = 91;
pub const DASD_MAJOR: u32 = 94;
pub const MDISK_MAJOR: u32 = 95;
pub const UBD_MAJOR: u32 = 98;
pub const PP_MAJOR: u32 = 99;
pub const JSFD_MAJOR: u32 = 99;
pub const PHONE_MAJOR: u32 = 100;
pub const COMPAQ_CISS_MAJOR: u32 = 104;
pub const COMPAQ_CISS_MAJOR1: u32 = 105;
pub const COMPAQ_CISS_MAJOR2: u32 = 106;
pub const COMPAQ_CISS_MAJOR3: u32 = 107;
pub const COMPAQ_CISS_MAJOR4: u32 = 108;
pub const COMPAQ_CISS_MAJOR5: u32 = 109;
pub const COMPAQ_CISS_MAJOR6: u32 = 110;
pub const COMPAQ_CISS_MAJOR7: u32 = 111;
pub const VIODASD_MAJOR: u32 = 112;
pub const VIOCD_MAJOR: u32 = 113;
pub const ATARAID_MAJOR: u32 = 114;
pub const SCSI_DISK8_MAJOR: u32 = 128;
pub const SCSI_DISK9_MAJOR: u32 = 129;
pub const SCSI_DISK10_MAJOR: u32 = 130;
pub const SCSI_DISK11_MAJOR: u32 = 131;
pub const SCSI_DISK12_MAJOR: u32 = 132;
pub const SCSI_DISK13_MAJOR: u32 = 133;
pub const SCSI_DISK14_MAJOR: u32 = 134;
pub const SCSI_DISK15_MAJOR: u32 = 135;
pub const UNIX98_PTY_MASTER_MAJOR: u32 = 128;
pub const UNIX98_PTY_MAJOR_COUNT: u32 = 8;
pub const UNIX98_PTY_SLAVE_MAJOR: u32 = 136;
pub const DRBD_MAJOR: u32 = 147;
pub const RTF_MAJOR: u32 = 150;
pub const RAW_MAJOR: u32 = 162;
pub const USB_ACM_MAJOR: u32 = 166;
pub const USB_ACM_AUX_MAJOR: u32 = 167;
pub const USB_CHAR_MAJOR: u32 = 180;
pub const MMC_BLOCK_MAJOR: u32 = 179;
pub const VXVM_MAJOR: u32 = 199;
pub const VXSPEC_MAJOR: u32 = 200;
pub const VXDMP_MAJOR: u32 = 201;
pub const XENVBD_MAJOR: u32 = 202;
pub const MSR_MAJOR: u32 = 202;
pub const CPUID_MAJOR: u32 = 203;
pub const OSST_MAJOR: u32 = 206;
pub const IBM_TTY3270_MAJOR: u32 = 227;
pub const IBM_FS3270_MAJOR: u32 = 228;
pub const VIOTAPE_MAJOR: u32 = 230;
pub const BLOCK_EXT_MAJOR: u32 = 259;
pub const SCSI_OSD_MAJOR: u32 = 260;
pub const PSMOUSE_MINOR: u32 = 1;
pub const MS_BUSMOUSE_MINOR: u32 = 2;
pub const ATIXL_BUSMOUSE_MINOR: u32 = 3;
pub const ATARIMOUSE_MINOR: u32 = 5;
pub const SUN_MOUSE_MINOR: u32 = 6;
pub const APOLLO_MOUSE_MINOR: u32 = 7;
pub const PC110PAD_MINOR: u32 = 9;
pub const WATCHDOG_MINOR: u32 = 130;
pub const TEMP_MINOR: u32 = 131;
pub const APM_MINOR_DEV: u32 = 134;
pub const RTC_MINOR: u32 = 135;
pub const VHCI_MINOR: u32 = 137;
pub const SUN_OPENPROM_MINOR: u32 = 139;
pub const DMAPI_MINOR: u32 = 140;
pub const NVRAM_MINOR: u32 = 144;
pub const SBUS_FLASH_MINOR: u32 = 152;
pub const SGI_MMTIMER: u32 = 153;
pub const PMU_MINOR: u32 = 154;
pub const STORE_QUEUE_MINOR: u32 = 155;
pub const LCD_MINOR: u32 = 156;
pub const AC_MINOR: u32 = 157;
pub const BUTTON_MINOR: u32 = 158;
pub const NWFLASH_MINOR: u32 = 160;
pub const ENVCTRL_MINOR: u32 = 162;
pub const I2O_MINOR: u32 = 166;
pub const UCTRL_MINOR: u32 = 174;
pub const AGPGART_MINOR: u32 = 175;
pub const TOSH_MINOR_DEV: u32 = 181;
pub const HWRNG_MINOR: u32 = 183;
pub const KEYPAD_MINOR: u32 = 185;
pub const IRNET_MINOR: u32 = 187;
pub const D7S_MINOR: u32 = 193;
pub const VFIO_MINOR: u32 = 196;
pub const PXA3XX_GCU_MINOR: u32 = 197;
pub const TUN_MINOR: u32 = 200;
pub const CUSE_MINOR: u32 = 203;
pub const MWAVE_MINOR: u32 = 219;
pub const MPT_MINOR: u32 = 220;
pub const MPT2SAS_MINOR: u32 = 221;
pub const MPT3SAS_MINOR: u32 = 222;
pub const UINPUT_MINOR: u32 = 223;
pub const MISC_MCELOG_MINOR: u32 = 227;
pub const HPET_MINOR: u32 = 228;
pub const FUSE_MINOR: u32 = 229;
pub const SNAPSHOT_MINOR: u32 = 231;
pub const KVM_MINOR: u32 = 232;
pub const BTRFS_MINOR: u32 = 234;
pub const AUTOFS_MINOR: u32 = 235;
pub const MAPPER_CTRL_MINOR: u32 = 236;
pub const LOOP_CTRL_MINOR: u32 = 237;
pub const VHOST_NET_MINOR: u32 = 238;
pub const UHID_MINOR: u32 = 239;
pub const USERIO_MINOR: u32 = 240;
pub const VHOST_VSOCK_MINOR: u32 = 241;
pub const EISA_EEPROM_MINOR: u32 = 241;
pub const RFKILL_MINOR: u32 = 242;
pub const MISC_DYNAMIC_MINOR: u32 = 255;
pub const MSI_ANY_INDEX: i32 = -1;
pub const PCI_CFG_SPACE_SIZE: u32 = 256;
pub const PCI_CFG_SPACE_EXP_SIZE: u32 = 4096;
pub const PCI_STD_HEADER_SIZEOF: u32 = 64;
pub const PCI_STD_NUM_BARS: u32 = 6;
pub const PCI_VENDOR_ID: u32 = 0;
pub const PCI_DEVICE_ID: u32 = 2;
pub const PCI_COMMAND: u32 = 4;
pub const PCI_COMMAND_IO: u32 = 1;
pub const PCI_COMMAND_MEMORY: u32 = 2;
pub const PCI_COMMAND_MASTER: u32 = 4;
pub const PCI_COMMAND_SPECIAL: u32 = 8;
pub const PCI_COMMAND_INVALIDATE: u32 = 16;
pub const PCI_COMMAND_VGA_PALETTE: u32 = 32;
pub const PCI_COMMAND_PARITY: u32 = 64;
pub const PCI_COMMAND_WAIT: u32 = 128;
pub const PCI_COMMAND_SERR: u32 = 256;
pub const PCI_COMMAND_FAST_BACK: u32 = 512;
pub const PCI_COMMAND_INTX_DISABLE: u32 = 1024;
pub const PCI_STATUS: u32 = 6;
pub const PCI_STATUS_IMM_READY: u32 = 1;
pub const PCI_STATUS_INTERRUPT: u32 = 8;
pub const PCI_STATUS_CAP_LIST: u32 = 16;
pub const PCI_STATUS_66MHZ: u32 = 32;
pub const PCI_STATUS_UDF: u32 = 64;
pub const PCI_STATUS_FAST_BACK: u32 = 128;
pub const PCI_STATUS_PARITY: u32 = 256;
pub const PCI_STATUS_DEVSEL_MASK: u32 = 1536;
pub const PCI_STATUS_DEVSEL_FAST: u32 = 0;
pub const PCI_STATUS_DEVSEL_MEDIUM: u32 = 512;
pub const PCI_STATUS_DEVSEL_SLOW: u32 = 1024;
pub const PCI_STATUS_SIG_TARGET_ABORT: u32 = 2048;
pub const PCI_STATUS_REC_TARGET_ABORT: u32 = 4096;
pub const PCI_STATUS_REC_MASTER_ABORT: u32 = 8192;
pub const PCI_STATUS_SIG_SYSTEM_ERROR: u32 = 16384;
pub const PCI_STATUS_DETECTED_PARITY: u32 = 32768;
pub const PCI_CLASS_REVISION: u32 = 8;
pub const PCI_REVISION_ID: u32 = 8;
pub const PCI_CLASS_PROG: u32 = 9;
pub const PCI_CLASS_DEVICE: u32 = 10;
pub const PCI_CACHE_LINE_SIZE: u32 = 12;
pub const PCI_LATENCY_TIMER: u32 = 13;
pub const PCI_HEADER_TYPE: u32 = 14;
pub const PCI_HEADER_TYPE_MASK: u32 = 127;
pub const PCI_HEADER_TYPE_NORMAL: u32 = 0;
pub const PCI_HEADER_TYPE_BRIDGE: u32 = 1;
pub const PCI_HEADER_TYPE_CARDBUS: u32 = 2;
pub const PCI_HEADER_TYPE_MFD: u32 = 128;
pub const PCI_BIST: u32 = 15;
pub const PCI_BIST_CODE_MASK: u32 = 15;
pub const PCI_BIST_START: u32 = 64;
pub const PCI_BIST_CAPABLE: u32 = 128;
pub const PCI_BASE_ADDRESS_0: u32 = 16;
pub const PCI_BASE_ADDRESS_1: u32 = 20;
pub const PCI_BASE_ADDRESS_2: u32 = 24;
pub const PCI_BASE_ADDRESS_3: u32 = 28;
pub const PCI_BASE_ADDRESS_4: u32 = 32;
pub const PCI_BASE_ADDRESS_5: u32 = 36;
pub const PCI_BASE_ADDRESS_SPACE: u32 = 1;
pub const PCI_BASE_ADDRESS_SPACE_IO: u32 = 1;
pub const PCI_BASE_ADDRESS_SPACE_MEMORY: u32 = 0;
pub const PCI_BASE_ADDRESS_MEM_TYPE_MASK: u32 = 6;
pub const PCI_BASE_ADDRESS_MEM_TYPE_32: u32 = 0;
pub const PCI_BASE_ADDRESS_MEM_TYPE_1M: u32 = 2;
pub const PCI_BASE_ADDRESS_MEM_TYPE_64: u32 = 4;
pub const PCI_BASE_ADDRESS_MEM_PREFETCH: u32 = 8;
pub const PCI_BASE_ADDRESS_MEM_MASK: i32 = -16;
pub const PCI_BASE_ADDRESS_IO_MASK: i32 = -4;
pub const PCI_CARDBUS_CIS: u32 = 40;
pub const PCI_SUBSYSTEM_VENDOR_ID: u32 = 44;
pub const PCI_SUBSYSTEM_ID: u32 = 46;
pub const PCI_ROM_ADDRESS: u32 = 48;
pub const PCI_ROM_ADDRESS_ENABLE: u32 = 1;
pub const PCI_ROM_ADDRESS_MASK: i32 = -2048;
pub const PCI_CAPABILITY_LIST: u32 = 52;
pub const PCI_INTERRUPT_LINE: u32 = 60;
pub const PCI_INTERRUPT_PIN: u32 = 61;
pub const PCI_MIN_GNT: u32 = 62;
pub const PCI_MAX_LAT: u32 = 63;
pub const PCI_PRIMARY_BUS: u32 = 24;
pub const PCI_SECONDARY_BUS: u32 = 25;
pub const PCI_SUBORDINATE_BUS: u32 = 26;
pub const PCI_SEC_LATENCY_TIMER: u32 = 27;
pub const PCI_IO_BASE: u32 = 28;
pub const PCI_IO_LIMIT: u32 = 29;
pub const PCI_IO_RANGE_TYPE_MASK: u32 = 15;
pub const PCI_IO_RANGE_TYPE_16: u32 = 0;
pub const PCI_IO_RANGE_TYPE_32: u32 = 1;
pub const PCI_IO_RANGE_MASK: i32 = -16;
pub const PCI_IO_1K_RANGE_MASK: i32 = -4;
pub const PCI_SEC_STATUS: u32 = 30;
pub const PCI_MEMORY_BASE: u32 = 32;
pub const PCI_MEMORY_LIMIT: u32 = 34;
pub const PCI_MEMORY_RANGE_TYPE_MASK: u32 = 15;
pub const PCI_MEMORY_RANGE_MASK: i32 = -16;
pub const PCI_PREF_MEMORY_BASE: u32 = 36;
pub const PCI_PREF_MEMORY_LIMIT: u32 = 38;
pub const PCI_PREF_RANGE_TYPE_MASK: u32 = 15;
pub const PCI_PREF_RANGE_TYPE_32: u32 = 0;
pub const PCI_PREF_RANGE_TYPE_64: u32 = 1;
pub const PCI_PREF_RANGE_MASK: i32 = -16;
pub const PCI_PREF_BASE_UPPER32: u32 = 40;
pub const PCI_PREF_LIMIT_UPPER32: u32 = 44;
pub const PCI_IO_BASE_UPPER16: u32 = 48;
pub const PCI_IO_LIMIT_UPPER16: u32 = 50;
pub const PCI_ROM_ADDRESS1: u32 = 56;
pub const PCI_BRIDGE_CONTROL: u32 = 62;
pub const PCI_BRIDGE_CTL_PARITY: u32 = 1;
pub const PCI_BRIDGE_CTL_SERR: u32 = 2;
pub const PCI_BRIDGE_CTL_ISA: u32 = 4;
pub const PCI_BRIDGE_CTL_VGA: u32 = 8;
pub const PCI_BRIDGE_CTL_MASTER_ABORT: u32 = 32;
pub const PCI_BRIDGE_CTL_BUS_RESET: u32 = 64;
pub const PCI_BRIDGE_CTL_FAST_BACK: u32 = 128;
pub const PCI_CB_CAPABILITY_LIST: u32 = 20;
pub const PCI_CB_SEC_STATUS: u32 = 22;
pub const PCI_CB_PRIMARY_BUS: u32 = 24;
pub const PCI_CB_CARD_BUS: u32 = 25;
pub const PCI_CB_SUBORDINATE_BUS: u32 = 26;
pub const PCI_CB_LATENCY_TIMER: u32 = 27;
pub const PCI_CB_MEMORY_BASE_0: u32 = 28;
pub const PCI_CB_MEMORY_LIMIT_0: u32 = 32;
pub const PCI_CB_MEMORY_BASE_1: u32 = 36;
pub const PCI_CB_MEMORY_LIMIT_1: u32 = 40;
pub const PCI_CB_IO_BASE_0: u32 = 44;
pub const PCI_CB_IO_BASE_0_HI: u32 = 46;
pub const PCI_CB_IO_LIMIT_0: u32 = 48;
pub const PCI_CB_IO_LIMIT_0_HI: u32 = 50;
pub const PCI_CB_IO_BASE_1: u32 = 52;
pub const PCI_CB_IO_BASE_1_HI: u32 = 54;
pub const PCI_CB_IO_LIMIT_1: u32 = 56;
pub const PCI_CB_IO_LIMIT_1_HI: u32 = 58;
pub const PCI_CB_IO_RANGE_MASK: i32 = -4;
pub const PCI_CB_BRIDGE_CONTROL: u32 = 62;
pub const PCI_CB_BRIDGE_CTL_PARITY: u32 = 1;
pub const PCI_CB_BRIDGE_CTL_SERR: u32 = 2;
pub const PCI_CB_BRIDGE_CTL_ISA: u32 = 4;
pub const PCI_CB_BRIDGE_CTL_VGA: u32 = 8;
pub const PCI_CB_BRIDGE_CTL_MASTER_ABORT: u32 = 32;
pub const PCI_CB_BRIDGE_CTL_CB_RESET: u32 = 64;
pub const PCI_CB_BRIDGE_CTL_16BIT_INT: u32 = 128;
pub const PCI_CB_BRIDGE_CTL_PREFETCH_MEM0: u32 = 256;
pub const PCI_CB_BRIDGE_CTL_PREFETCH_MEM1: u32 = 512;
pub const PCI_CB_BRIDGE_CTL_POST_WRITES: u32 = 1024;
pub const PCI_CB_SUBSYSTEM_VENDOR_ID: u32 = 64;
pub const PCI_CB_SUBSYSTEM_ID: u32 = 66;
pub const PCI_CB_LEGACY_MODE_BASE: u32 = 68;
pub const PCI_CAP_ID_MASK: u32 = 255;
pub const PCI_CAP_LIST_NEXT_MASK: u32 = 65280;
pub const PCI_CAP_LIST_ID: u32 = 0;
pub const PCI_CAP_ID_PM: u32 = 1;
pub const PCI_CAP_ID_AGP: u32 = 2;
pub const PCI_CAP_ID_VPD: u32 = 3;
pub const PCI_CAP_ID_SLOTID: u32 = 4;
pub const PCI_CAP_ID_MSI: u32 = 5;
pub const PCI_CAP_ID_CHSWP: u32 = 6;
pub const PCI_CAP_ID_PCIX: u32 = 7;
pub const PCI_CAP_ID_HT: u32 = 8;
pub const PCI_CAP_ID_VNDR: u32 = 9;
pub const PCI_CAP_ID_DBG: u32 = 10;
pub const PCI_CAP_ID_CCRC: u32 = 11;
pub const PCI_CAP_ID_SHPC: u32 = 12;
pub const PCI_CAP_ID_SSVID: u32 = 13;
pub const PCI_CAP_ID_AGP3: u32 = 14;
pub const PCI_CAP_ID_SECDEV: u32 = 15;
pub const PCI_CAP_ID_EXP: u32 = 16;
pub const PCI_CAP_ID_MSIX: u32 = 17;
pub const PCI_CAP_ID_SATA: u32 = 18;
pub const PCI_CAP_ID_AF: u32 = 19;
pub const PCI_CAP_ID_EA: u32 = 20;
pub const PCI_CAP_ID_MAX: u32 = 20;
pub const PCI_CAP_LIST_NEXT: u32 = 1;
pub const PCI_CAP_FLAGS: u32 = 2;
pub const PCI_CAP_SIZEOF: u32 = 4;
pub const PCI_PM_PMC: u32 = 2;
pub const PCI_PM_CAP_VER_MASK: u32 = 7;
pub const PCI_PM_CAP_PME_CLOCK: u32 = 8;
pub const PCI_PM_CAP_RESERVED: u32 = 16;
pub const PCI_PM_CAP_DSI: u32 = 32;
pub const PCI_PM_CAP_AUX_POWER: u32 = 448;
pub const PCI_PM_CAP_D1: u32 = 512;
pub const PCI_PM_CAP_D2: u32 = 1024;
pub const PCI_PM_CAP_PME: u32 = 2048;
pub const PCI_PM_CAP_PME_MASK: u32 = 63488;
pub const PCI_PM_CAP_PME_D0: u32 = 2048;
pub const PCI_PM_CAP_PME_D1: u32 = 4096;
pub const PCI_PM_CAP_PME_D2: u32 = 8192;
pub const PCI_PM_CAP_PME_D3hot: u32 = 16384;
pub const PCI_PM_CAP_PME_D3cold: u32 = 32768;
pub const PCI_PM_CAP_PME_SHIFT: u32 = 11;
pub const PCI_PM_CTRL: u32 = 4;
pub const PCI_PM_CTRL_STATE_MASK: u32 = 3;
pub const PCI_PM_CTRL_NO_SOFT_RESET: u32 = 8;
pub const PCI_PM_CTRL_PME_ENABLE: u32 = 256;
pub const PCI_PM_CTRL_DATA_SEL_MASK: u32 = 7680;
pub const PCI_PM_CTRL_DATA_SCALE_MASK: u32 = 24576;
pub const PCI_PM_CTRL_PME_STATUS: u32 = 32768;
pub const PCI_PM_PPB_EXTENSIONS: u32 = 6;
pub const PCI_PM_PPB_B2_B3: u32 = 64;
pub const PCI_PM_BPCC_ENABLE: u32 = 128;
pub const PCI_PM_DATA_REGISTER: u32 = 7;
pub const PCI_PM_SIZEOF: u32 = 8;
pub const PCI_AGP_VERSION: u32 = 2;
pub const PCI_AGP_RFU: u32 = 3;
pub const PCI_AGP_STATUS: u32 = 4;
pub const PCI_AGP_STATUS_RQ_MASK: u32 = 4278190080;
pub const PCI_AGP_STATUS_SBA: u32 = 512;
pub const PCI_AGP_STATUS_64BIT: u32 = 32;
pub const PCI_AGP_STATUS_FW: u32 = 16;
pub const PCI_AGP_STATUS_RATE4: u32 = 4;
pub const PCI_AGP_STATUS_RATE2: u32 = 2;
pub const PCI_AGP_STATUS_RATE1: u32 = 1;
pub const PCI_AGP_COMMAND: u32 = 8;
pub const PCI_AGP_COMMAND_RQ_MASK: u32 = 4278190080;
pub const PCI_AGP_COMMAND_SBA: u32 = 512;
pub const PCI_AGP_COMMAND_AGP: u32 = 256;
pub const PCI_AGP_COMMAND_64BIT: u32 = 32;
pub const PCI_AGP_COMMAND_FW: u32 = 16;
pub const PCI_AGP_COMMAND_RATE4: u32 = 4;
pub const PCI_AGP_COMMAND_RATE2: u32 = 2;
pub const PCI_AGP_COMMAND_RATE1: u32 = 1;
pub const PCI_AGP_SIZEOF: u32 = 12;
pub const PCI_VPD_ADDR: u32 = 2;
pub const PCI_VPD_ADDR_MASK: u32 = 32767;
pub const PCI_VPD_ADDR_F: u32 = 32768;
pub const PCI_VPD_DATA: u32 = 4;
pub const PCI_CAP_VPD_SIZEOF: u32 = 8;
pub const PCI_SID_ESR: u32 = 2;
pub const PCI_SID_ESR_NSLOTS: u32 = 31;
pub const PCI_SID_ESR_FIC: u32 = 32;
pub const PCI_SID_CHASSIS_NR: u32 = 3;
pub const PCI_MSI_FLAGS: u32 = 2;
pub const PCI_MSI_FLAGS_ENABLE: u32 = 1;
pub const PCI_MSI_FLAGS_QMASK: u32 = 14;
pub const PCI_MSI_FLAGS_QSIZE: u32 = 112;
pub const PCI_MSI_FLAGS_64BIT: u32 = 128;
pub const PCI_MSI_FLAGS_MASKBIT: u32 = 256;
pub const PCI_MSI_RFU: u32 = 3;
pub const PCI_MSI_ADDRESS_LO: u32 = 4;
pub const PCI_MSI_ADDRESS_HI: u32 = 8;
pub const PCI_MSI_DATA_32: u32 = 8;
pub const PCI_MSI_MASK_32: u32 = 12;
pub const PCI_MSI_PENDING_32: u32 = 16;
pub const PCI_MSI_DATA_64: u32 = 12;
pub const PCI_MSI_MASK_64: u32 = 16;
pub const PCI_MSI_PENDING_64: u32 = 20;
pub const PCI_MSIX_FLAGS: u32 = 2;
pub const PCI_MSIX_FLAGS_QSIZE: u32 = 2047;
pub const PCI_MSIX_FLAGS_MASKALL: u32 = 16384;
pub const PCI_MSIX_FLAGS_ENABLE: u32 = 32768;
pub const PCI_MSIX_TABLE: u32 = 4;
pub const PCI_MSIX_TABLE_BIR: u32 = 7;
pub const PCI_MSIX_TABLE_OFFSET: u32 = 4294967288;
pub const PCI_MSIX_PBA: u32 = 8;
pub const PCI_MSIX_PBA_BIR: u32 = 7;
pub const PCI_MSIX_PBA_OFFSET: u32 = 4294967288;
pub const PCI_MSIX_FLAGS_BIRMASK: u32 = 7;
pub const PCI_CAP_MSIX_SIZEOF: u32 = 12;
pub const PCI_MSIX_ENTRY_SIZE: u32 = 16;
pub const PCI_MSIX_ENTRY_LOWER_ADDR: u32 = 0;
pub const PCI_MSIX_ENTRY_UPPER_ADDR: u32 = 4;
pub const PCI_MSIX_ENTRY_DATA: u32 = 8;
pub const PCI_MSIX_ENTRY_VECTOR_CTRL: u32 = 12;
pub const PCI_MSIX_ENTRY_CTRL_MASKBIT: u32 = 1;
pub const PCI_MSIX_ENTRY_CTRL_ST: u32 = 4294901760;
pub const PCI_CHSWP_CSR: u32 = 2;
pub const PCI_CHSWP_DHA: u32 = 1;
pub const PCI_CHSWP_EIM: u32 = 2;
pub const PCI_CHSWP_PIE: u32 = 4;
pub const PCI_CHSWP_LOO: u32 = 8;
pub const PCI_CHSWP_PI: u32 = 48;
pub const PCI_CHSWP_EXT: u32 = 64;
pub const PCI_CHSWP_INS: u32 = 128;
pub const PCI_AF_LENGTH: u32 = 2;
pub const PCI_AF_CAP: u32 = 3;
pub const PCI_AF_CAP_TP: u32 = 1;
pub const PCI_AF_CAP_FLR: u32 = 2;
pub const PCI_AF_CTRL: u32 = 4;
pub const PCI_AF_CTRL_FLR: u32 = 1;
pub const PCI_AF_STATUS: u32 = 5;
pub const PCI_AF_STATUS_TP: u32 = 1;
pub const PCI_CAP_AF_SIZEOF: u32 = 6;
pub const PCI_EA_NUM_ENT: u32 = 2;
pub const PCI_EA_NUM_ENT_MASK: u32 = 63;
pub const PCI_EA_FIRST_ENT: u32 = 4;
pub const PCI_EA_FIRST_ENT_BRIDGE: u32 = 8;
pub const PCI_EA_ES: u32 = 7;
pub const PCI_EA_BEI: u32 = 240;
pub const PCI_EA_SEC_BUS_MASK: u32 = 255;
pub const PCI_EA_SUB_BUS_MASK: u32 = 65280;
pub const PCI_EA_SUB_BUS_SHIFT: u32 = 8;
pub const PCI_EA_BEI_BAR0: u32 = 0;
pub const PCI_EA_BEI_BAR5: u32 = 5;
pub const PCI_EA_BEI_BRIDGE: u32 = 6;
pub const PCI_EA_BEI_ENI: u32 = 7;
pub const PCI_EA_BEI_ROM: u32 = 8;
pub const PCI_EA_BEI_VF_BAR0: u32 = 9;
pub const PCI_EA_BEI_VF_BAR5: u32 = 14;
pub const PCI_EA_BEI_RESERVED: u32 = 15;
pub const PCI_EA_PP: u32 = 65280;
pub const PCI_EA_SP: u32 = 16711680;
pub const PCI_EA_P_MEM: u32 = 0;
pub const PCI_EA_P_MEM_PREFETCH: u32 = 1;
pub const PCI_EA_P_IO: u32 = 2;
pub const PCI_EA_P_VF_MEM_PREFETCH: u32 = 3;
pub const PCI_EA_P_VF_MEM: u32 = 4;
pub const PCI_EA_P_BRIDGE_MEM: u32 = 5;
pub const PCI_EA_P_BRIDGE_MEM_PREFETCH: u32 = 6;
pub const PCI_EA_P_BRIDGE_IO: u32 = 7;
pub const PCI_EA_P_MEM_RESERVED: u32 = 253;
pub const PCI_EA_P_IO_RESERVED: u32 = 254;
pub const PCI_EA_P_UNAVAILABLE: u32 = 255;
pub const PCI_EA_WRITABLE: u32 = 1073741824;
pub const PCI_EA_ENABLE: u32 = 2147483648;
pub const PCI_EA_BASE: u32 = 4;
pub const PCI_EA_MAX_OFFSET: u32 = 8;
pub const PCI_EA_IS_64: u32 = 2;
pub const PCI_EA_FIELD_MASK: u32 = 4294967292;
pub const PCI_X_CMD: u32 = 2;
pub const PCI_X_CMD_DPERR_E: u32 = 1;
pub const PCI_X_CMD_ERO: u32 = 2;
pub const PCI_X_CMD_READ_512: u32 = 0;
pub const PCI_X_CMD_READ_1K: u32 = 4;
pub const PCI_X_CMD_READ_2K: u32 = 8;
pub const PCI_X_CMD_READ_4K: u32 = 12;
pub const PCI_X_CMD_MAX_READ: u32 = 12;
pub const PCI_X_CMD_SPLIT_1: u32 = 0;
pub const PCI_X_CMD_SPLIT_2: u32 = 16;
pub const PCI_X_CMD_SPLIT_3: u32 = 32;
pub const PCI_X_CMD_SPLIT_4: u32 = 48;
pub const PCI_X_CMD_SPLIT_8: u32 = 64;
pub const PCI_X_CMD_SPLIT_12: u32 = 80;
pub const PCI_X_CMD_SPLIT_16: u32 = 96;
pub const PCI_X_CMD_SPLIT_32: u32 = 112;
pub const PCI_X_CMD_MAX_SPLIT: u32 = 112;
pub const PCI_X_STATUS: u32 = 4;
pub const PCI_X_STATUS_DEVFN: u32 = 255;
pub const PCI_X_STATUS_BUS: u32 = 65280;
pub const PCI_X_STATUS_64BIT: u32 = 65536;
pub const PCI_X_STATUS_133MHZ: u32 = 131072;
pub const PCI_X_STATUS_SPL_DISC: u32 = 262144;
pub const PCI_X_STATUS_UNX_SPL: u32 = 524288;
pub const PCI_X_STATUS_COMPLEX: u32 = 1048576;
pub const PCI_X_STATUS_MAX_READ: u32 = 6291456;
pub const PCI_X_STATUS_MAX_SPLIT: u32 = 58720256;
pub const PCI_X_STATUS_MAX_CUM: u32 = 469762048;
pub const PCI_X_STATUS_SPL_ERR: u32 = 536870912;
pub const PCI_X_STATUS_266MHZ: u32 = 1073741824;
pub const PCI_X_STATUS_533MHZ: u32 = 2147483648;
pub const PCI_X_ECC_CSR: u32 = 8;
pub const PCI_CAP_PCIX_SIZEOF_V0: u32 = 8;
pub const PCI_CAP_PCIX_SIZEOF_V1: u32 = 24;
pub const PCI_CAP_PCIX_SIZEOF_V2: u32 = 24;
pub const PCI_X_BRIDGE_SSTATUS: u32 = 2;
pub const PCI_X_SSTATUS_64BIT: u32 = 1;
pub const PCI_X_SSTATUS_133MHZ: u32 = 2;
pub const PCI_X_SSTATUS_FREQ: u32 = 960;
pub const PCI_X_SSTATUS_VERS: u32 = 12288;
pub const PCI_X_SSTATUS_V1: u32 = 4096;
pub const PCI_X_SSTATUS_V2: u32 = 8192;
pub const PCI_X_SSTATUS_266MHZ: u32 = 16384;
pub const PCI_X_SSTATUS_533MHZ: u32 = 32768;
pub const PCI_X_BRIDGE_STATUS: u32 = 4;
pub const PCI_SSVID_VENDOR_ID: u32 = 4;
pub const PCI_SSVID_DEVICE_ID: u32 = 6;
pub const PCI_EXP_FLAGS: u32 = 2;
pub const PCI_EXP_FLAGS_VERS: u32 = 15;
pub const PCI_EXP_FLAGS_TYPE: u32 = 240;
pub const PCI_EXP_TYPE_ENDPOINT: u32 = 0;
pub const PCI_EXP_TYPE_LEG_END: u32 = 1;
pub const PCI_EXP_TYPE_ROOT_PORT: u32 = 4;
pub const PCI_EXP_TYPE_UPSTREAM: u32 = 5;
pub const PCI_EXP_TYPE_DOWNSTREAM: u32 = 6;
pub const PCI_EXP_TYPE_PCI_BRIDGE: u32 = 7;
pub const PCI_EXP_TYPE_PCIE_BRIDGE: u32 = 8;
pub const PCI_EXP_TYPE_RC_END: u32 = 9;
pub const PCI_EXP_TYPE_RC_EC: u32 = 10;
pub const PCI_EXP_FLAGS_SLOT: u32 = 256;
pub const PCI_EXP_FLAGS_IRQ: u32 = 15872;
pub const PCI_EXP_FLAGS_FLIT: u32 = 32768;
pub const PCI_EXP_DEVCAP: u32 = 4;
pub const PCI_EXP_DEVCAP_PAYLOAD: u32 = 7;
pub const PCI_EXP_DEVCAP_PHANTOM: u32 = 24;
pub const PCI_EXP_DEVCAP_EXT_TAG: u32 = 32;
pub const PCI_EXP_DEVCAP_L0S: u32 = 448;
pub const PCI_EXP_DEVCAP_L1: u32 = 3584;
pub const PCI_EXP_DEVCAP_ATN_BUT: u32 = 4096;
pub const PCI_EXP_DEVCAP_ATN_IND: u32 = 8192;
pub const PCI_EXP_DEVCAP_PWR_IND: u32 = 16384;
pub const PCI_EXP_DEVCAP_RBER: u32 = 32768;
pub const PCI_EXP_DEVCAP_PWR_VAL: u32 = 66846720;
pub const PCI_EXP_DEVCAP_PWR_SCL: u32 = 201326592;
pub const PCI_EXP_DEVCAP_FLR: u32 = 268435456;
pub const PCI_EXP_DEVCTL: u32 = 8;
pub const PCI_EXP_DEVCTL_CERE: u32 = 1;
pub const PCI_EXP_DEVCTL_NFERE: u32 = 2;
pub const PCI_EXP_DEVCTL_FERE: u32 = 4;
pub const PCI_EXP_DEVCTL_URRE: u32 = 8;
pub const PCI_EXP_DEVCTL_RELAX_EN: u32 = 16;
pub const PCI_EXP_DEVCTL_PAYLOAD: u32 = 224;
pub const PCI_EXP_DEVCTL_PAYLOAD_128B: u32 = 0;
pub const PCI_EXP_DEVCTL_PAYLOAD_256B: u32 = 32;
pub const PCI_EXP_DEVCTL_PAYLOAD_512B: u32 = 64;
pub const PCI_EXP_DEVCTL_PAYLOAD_1024B: u32 = 96;
pub const PCI_EXP_DEVCTL_PAYLOAD_2048B: u32 = 128;
pub const PCI_EXP_DEVCTL_PAYLOAD_4096B: u32 = 160;
pub const PCI_EXP_DEVCTL_EXT_TAG: u32 = 256;
pub const PCI_EXP_DEVCTL_PHANTOM: u32 = 512;
pub const PCI_EXP_DEVCTL_AUX_PME: u32 = 1024;
pub const PCI_EXP_DEVCTL_NOSNOOP_EN: u32 = 2048;
pub const PCI_EXP_DEVCTL_READRQ: u32 = 28672;
pub const PCI_EXP_DEVCTL_READRQ_128B: u32 = 0;
pub const PCI_EXP_DEVCTL_READRQ_256B: u32 = 4096;
pub const PCI_EXP_DEVCTL_READRQ_512B: u32 = 8192;
pub const PCI_EXP_DEVCTL_READRQ_1024B: u32 = 12288;
pub const PCI_EXP_DEVCTL_READRQ_2048B: u32 = 16384;
pub const PCI_EXP_DEVCTL_READRQ_4096B: u32 = 20480;
pub const PCI_EXP_DEVCTL_BCR_FLR: u32 = 32768;
pub const PCI_EXP_DEVSTA: u32 = 10;
pub const PCI_EXP_DEVSTA_CED: u32 = 1;
pub const PCI_EXP_DEVSTA_NFED: u32 = 2;
pub const PCI_EXP_DEVSTA_FED: u32 = 4;
pub const PCI_EXP_DEVSTA_URD: u32 = 8;
pub const PCI_EXP_DEVSTA_AUXPD: u32 = 16;
pub const PCI_EXP_DEVSTA_TRPND: u32 = 32;
pub const PCI_CAP_EXP_RC_ENDPOINT_SIZEOF_V1: u32 = 12;
pub const PCI_EXP_LNKCAP: u32 = 12;
pub const PCI_EXP_LNKCAP_SLS: u32 = 15;
pub const PCI_EXP_LNKCAP_SLS_2_5GB: u32 = 1;
pub const PCI_EXP_LNKCAP_SLS_5_0GB: u32 = 2;
pub const PCI_EXP_LNKCAP_SLS_8_0GB: u32 = 3;
pub const PCI_EXP_LNKCAP_SLS_16_0GB: u32 = 4;
pub const PCI_EXP_LNKCAP_SLS_32_0GB: u32 = 5;
pub const PCI_EXP_LNKCAP_SLS_64_0GB: u32 = 6;
pub const PCI_EXP_LNKCAP_MLW: u32 = 1008;
pub const PCI_EXP_LNKCAP_ASPMS: u32 = 3072;
pub const PCI_EXP_LNKCAP_ASPM_L0S: u32 = 1024;
pub const PCI_EXP_LNKCAP_ASPM_L1: u32 = 2048;
pub const PCI_EXP_LNKCAP_L0SEL: u32 = 28672;
pub const PCI_EXP_LNKCAP_L1EL: u32 = 229376;
pub const PCI_EXP_LNKCAP_CLKPM: u32 = 262144;
pub const PCI_EXP_LNKCAP_SDERC: u32 = 524288;
pub const PCI_EXP_LNKCAP_DLLLARC: u32 = 1048576;
pub const PCI_EXP_LNKCAP_LBNC: u32 = 2097152;
pub const PCI_EXP_LNKCAP_PN: u32 = 4278190080;
pub const PCI_EXP_LNKCTL: u32 = 16;
pub const PCI_EXP_LNKCTL_ASPMC: u32 = 3;
pub const PCI_EXP_LNKCTL_ASPM_L0S: u32 = 1;
pub const PCI_EXP_LNKCTL_ASPM_L1: u32 = 2;
pub const PCI_EXP_LNKCTL_RCB: u32 = 8;
pub const PCI_EXP_LNKCTL_LD: u32 = 16;
pub const PCI_EXP_LNKCTL_RL: u32 = 32;
pub const PCI_EXP_LNKCTL_CCC: u32 = 64;
pub const PCI_EXP_LNKCTL_ES: u32 = 128;
pub const PCI_EXP_LNKCTL_CLKREQ_EN: u32 = 256;
pub const PCI_EXP_LNKCTL_HAWD: u32 = 512;
pub const PCI_EXP_LNKCTL_LBMIE: u32 = 1024;
pub const PCI_EXP_LNKCTL_LABIE: u32 = 2048;
pub const PCI_EXP_LNKSTA: u32 = 18;
pub const PCI_EXP_LNKSTA_CLS: u32 = 15;
pub const PCI_EXP_LNKSTA_CLS_2_5GB: u32 = 1;
pub const PCI_EXP_LNKSTA_CLS_5_0GB: u32 = 2;
pub const PCI_EXP_LNKSTA_CLS_8_0GB: u32 = 3;
pub const PCI_EXP_LNKSTA_CLS_16_0GB: u32 = 4;
pub const PCI_EXP_LNKSTA_CLS_32_0GB: u32 = 5;
pub const PCI_EXP_LNKSTA_CLS_64_0GB: u32 = 6;
pub const PCI_EXP_LNKSTA_NLW: u32 = 1008;
pub const PCI_EXP_LNKSTA_NLW_X1: u32 = 16;
pub const PCI_EXP_LNKSTA_NLW_X2: u32 = 32;
pub const PCI_EXP_LNKSTA_NLW_X4: u32 = 64;
pub const PCI_EXP_LNKSTA_NLW_X8: u32 = 128;
pub const PCI_EXP_LNKSTA_NLW_SHIFT: u32 = 4;
pub const PCI_EXP_LNKSTA_LT: u32 = 2048;
pub const PCI_EXP_LNKSTA_SLC: u32 = 4096;
pub const PCI_EXP_LNKSTA_DLLLA: u32 = 8192;
pub const PCI_EXP_LNKSTA_LBMS: u32 = 16384;
pub const PCI_EXP_LNKSTA_LABS: u32 = 32768;
pub const PCI_CAP_EXP_ENDPOINT_SIZEOF_V1: u32 = 20;
pub const PCI_EXP_SLTCAP: u32 = 20;
pub const PCI_EXP_SLTCAP_ABP: u32 = 1;
pub const PCI_EXP_SLTCAP_PCP: u32 = 2;
pub const PCI_EXP_SLTCAP_MRLSP: u32 = 4;
pub const PCI_EXP_SLTCAP_AIP: u32 = 8;
pub const PCI_EXP_SLTCAP_PIP: u32 = 16;
pub const PCI_EXP_SLTCAP_HPS: u32 = 32;
pub const PCI_EXP_SLTCAP_HPC: u32 = 64;
pub const PCI_EXP_SLTCAP_SPLV: u32 = 32640;
pub const PCI_EXP_SLTCAP_SPLS: u32 = 98304;
pub const PCI_EXP_SLTCAP_EIP: u32 = 131072;
pub const PCI_EXP_SLTCAP_NCCS: u32 = 262144;
pub const PCI_EXP_SLTCAP_PSN: u32 = 4294443008;
pub const PCI_EXP_SLTCTL: u32 = 24;
pub const PCI_EXP_SLTCTL_ABPE: u32 = 1;
pub const PCI_EXP_SLTCTL_PFDE: u32 = 2;
pub const PCI_EXP_SLTCTL_MRLSCE: u32 = 4;
pub const PCI_EXP_SLTCTL_PDCE: u32 = 8;
pub const PCI_EXP_SLTCTL_CCIE: u32 = 16;
pub const PCI_EXP_SLTCTL_HPIE: u32 = 32;
pub const PCI_EXP_SLTCTL_AIC: u32 = 192;
pub const PCI_EXP_SLTCTL_ATTN_IND_SHIFT: u32 = 6;
pub const PCI_EXP_SLTCTL_ATTN_IND_ON: u32 = 64;
pub const PCI_EXP_SLTCTL_ATTN_IND_BLINK: u32 = 128;
pub const PCI_EXP_SLTCTL_ATTN_IND_OFF: u32 = 192;
pub const PCI_EXP_SLTCTL_PIC: u32 = 768;
pub const PCI_EXP_SLTCTL_PWR_IND_ON: u32 = 256;
pub const PCI_EXP_SLTCTL_PWR_IND_BLINK: u32 = 512;
pub const PCI_EXP_SLTCTL_PWR_IND_OFF: u32 = 768;
pub const PCI_EXP_SLTCTL_PCC: u32 = 1024;
pub const PCI_EXP_SLTCTL_PWR_ON: u32 = 0;
pub const PCI_EXP_SLTCTL_PWR_OFF: u32 = 1024;
pub const PCI_EXP_SLTCTL_EIC: u32 = 2048;
pub const PCI_EXP_SLTCTL_DLLSCE: u32 = 4096;
pub const PCI_EXP_SLTCTL_ASPL_DISABLE: u32 = 8192;
pub const PCI_EXP_SLTCTL_IBPD_DISABLE: u32 = 16384;
pub const PCI_EXP_SLTSTA: u32 = 26;
pub const PCI_EXP_SLTSTA_ABP: u32 = 1;
pub const PCI_EXP_SLTSTA_PFD: u32 = 2;
pub const PCI_EXP_SLTSTA_MRLSC: u32 = 4;
pub const PCI_EXP_SLTSTA_PDC: u32 = 8;
pub const PCI_EXP_SLTSTA_CC: u32 = 16;
pub const PCI_EXP_SLTSTA_MRLSS: u32 = 32;
pub const PCI_EXP_SLTSTA_PDS: u32 = 64;
pub const PCI_EXP_SLTSTA_EIS: u32 = 128;
pub const PCI_EXP_SLTSTA_DLLSC: u32 = 256;
pub const PCI_EXP_RTCTL: u32 = 28;
pub const PCI_EXP_RTCTL_SECEE: u32 = 1;
pub const PCI_EXP_RTCTL_SENFEE: u32 = 2;
pub const PCI_EXP_RTCTL_SEFEE: u32 = 4;
pub const PCI_EXP_RTCTL_PMEIE: u32 = 8;
pub const PCI_EXP_RTCTL_RRS_SVE: u32 = 16;
pub const PCI_EXP_RTCTL_CRSSVE: u32 = 16;
pub const PCI_EXP_RTCAP: u32 = 30;
pub const PCI_EXP_RTCAP_RRS_SV: u32 = 1;
pub const PCI_EXP_RTCAP_CRSVIS: u32 = 1;
pub const PCI_EXP_RTSTA: u32 = 32;
pub const PCI_EXP_RTSTA_PME_RQ_ID: u32 = 65535;
pub const PCI_EXP_RTSTA_PME: u32 = 65536;
pub const PCI_EXP_RTSTA_PENDING: u32 = 131072;
pub const PCI_EXP_DEVCAP2: u32 = 36;
pub const PCI_EXP_DEVCAP2_COMP_TMOUT_DIS: u32 = 16;
pub const PCI_EXP_DEVCAP2_ARI: u32 = 32;
pub const PCI_EXP_DEVCAP2_ATOMIC_ROUTE: u32 = 64;
pub const PCI_EXP_DEVCAP2_ATOMIC_COMP32: u32 = 128;
pub const PCI_EXP_DEVCAP2_ATOMIC_COMP64: u32 = 256;
pub const PCI_EXP_DEVCAP2_ATOMIC_COMP128: u32 = 512;
pub const PCI_EXP_DEVCAP2_LTR: u32 = 2048;
pub const PCI_EXP_DEVCAP2_TPH_COMP_MASK: u32 = 12288;
pub const PCI_EXP_DEVCAP2_OBFF_MASK: u32 = 786432;
pub const PCI_EXP_DEVCAP2_OBFF_MSG: u32 = 262144;
pub const PCI_EXP_DEVCAP2_OBFF_WAKE: u32 = 524288;
pub const PCI_EXP_DEVCAP2_EE_PREFIX: u32 = 2097152;
pub const PCI_EXP_DEVCAP2_EE_PREFIX_MAX: u32 = 12582912;
pub const PCI_EXP_DEVCTL2: u32 = 40;
pub const PCI_EXP_DEVCTL2_COMP_TIMEOUT: u32 = 15;
pub const PCI_EXP_DEVCTL2_COMP_TMOUT_DIS: u32 = 16;
pub const PCI_EXP_DEVCTL2_ARI: u32 = 32;
pub const PCI_EXP_DEVCTL2_ATOMIC_REQ: u32 = 64;
pub const PCI_EXP_DEVCTL2_ATOMIC_EGRESS_BLOCK: u32 = 128;
pub const PCI_EXP_DEVCTL2_IDO_REQ_EN: u32 = 256;
pub const PCI_EXP_DEVCTL2_IDO_CMP_EN: u32 = 512;
pub const PCI_EXP_DEVCTL2_LTR_EN: u32 = 1024;
pub const PCI_EXP_DEVCTL2_OBFF_MSGA_EN: u32 = 8192;
pub const PCI_EXP_DEVCTL2_OBFF_MSGB_EN: u32 = 16384;
pub const PCI_EXP_DEVCTL2_OBFF_WAKE_EN: u32 = 24576;
pub const PCI_EXP_DEVSTA2: u32 = 42;
pub const PCI_CAP_EXP_RC_ENDPOINT_SIZEOF_V2: u32 = 44;
pub const PCI_EXP_LNKCAP2: u32 = 44;
pub const PCI_EXP_LNKCAP2_SLS: u32 = 254;
pub const PCI_EXP_LNKCAP2_SLS_2_5GB: u32 = 2;
pub const PCI_EXP_LNKCAP2_SLS_5_0GB: u32 = 4;
pub const PCI_EXP_LNKCAP2_SLS_8_0GB: u32 = 8;
pub const PCI_EXP_LNKCAP2_SLS_16_0GB: u32 = 16;
pub const PCI_EXP_LNKCAP2_SLS_32_0GB: u32 = 32;
pub const PCI_EXP_LNKCAP2_SLS_64_0GB: u32 = 64;
pub const PCI_EXP_LNKCAP2_CROSSLINK: u32 = 256;
pub const PCI_EXP_LNKCTL2: u32 = 48;
pub const PCI_EXP_LNKCTL2_TLS: u32 = 15;
pub const PCI_EXP_LNKCTL2_TLS_2_5GT: u32 = 1;
pub const PCI_EXP_LNKCTL2_TLS_5_0GT: u32 = 2;
pub const PCI_EXP_LNKCTL2_TLS_8_0GT: u32 = 3;
pub const PCI_EXP_LNKCTL2_TLS_16_0GT: u32 = 4;
pub const PCI_EXP_LNKCTL2_TLS_32_0GT: u32 = 5;
pub const PCI_EXP_LNKCTL2_TLS_64_0GT: u32 = 6;
pub const PCI_EXP_LNKCTL2_ENTER_COMP: u32 = 16;
pub const PCI_EXP_LNKCTL2_TX_MARGIN: u32 = 896;
pub const PCI_EXP_LNKCTL2_HASD: u32 = 32;
pub const PCI_EXP_LNKSTA2: u32 = 50;
pub const PCI_EXP_LNKSTA2_FLIT: u32 = 1024;
pub const PCI_CAP_EXP_ENDPOINT_SIZEOF_V2: u32 = 50;
pub const PCI_EXP_SLTCAP2: u32 = 52;
pub const PCI_EXP_SLTCAP2_IBPD: u32 = 1;
pub const PCI_EXP_SLTCTL2: u32 = 56;
pub const PCI_EXP_SLTSTA2: u32 = 58;
pub const PCI_EXT_CAP_ID_ERR: u32 = 1;
pub const PCI_EXT_CAP_ID_VC: u32 = 2;
pub const PCI_EXT_CAP_ID_DSN: u32 = 3;
pub const PCI_EXT_CAP_ID_PWR: u32 = 4;
pub const PCI_EXT_CAP_ID_RCLD: u32 = 5;
pub const PCI_EXT_CAP_ID_RCILC: u32 = 6;
pub const PCI_EXT_CAP_ID_RCEC: u32 = 7;
pub const PCI_EXT_CAP_ID_MFVC: u32 = 8;
pub const PCI_EXT_CAP_ID_VC9: u32 = 9;
pub const PCI_EXT_CAP_ID_RCRB: u32 = 10;
pub const PCI_EXT_CAP_ID_VNDR: u32 = 11;
pub const PCI_EXT_CAP_ID_CAC: u32 = 12;
pub const PCI_EXT_CAP_ID_ACS: u32 = 13;
pub const PCI_EXT_CAP_ID_ARI: u32 = 14;
pub const PCI_EXT_CAP_ID_ATS: u32 = 15;
pub const PCI_EXT_CAP_ID_SRIOV: u32 = 16;
pub const PCI_EXT_CAP_ID_MRIOV: u32 = 17;
pub const PCI_EXT_CAP_ID_MCAST: u32 = 18;
pub const PCI_EXT_CAP_ID_PRI: u32 = 19;
pub const PCI_EXT_CAP_ID_AMD_XXX: u32 = 20;
pub const PCI_EXT_CAP_ID_REBAR: u32 = 21;
pub const PCI_EXT_CAP_ID_DPA: u32 = 22;
pub const PCI_EXT_CAP_ID_TPH: u32 = 23;
pub const PCI_EXT_CAP_ID_LTR: u32 = 24;
pub const PCI_EXT_CAP_ID_SECPCI: u32 = 25;
pub const PCI_EXT_CAP_ID_PMUX: u32 = 26;
pub const PCI_EXT_CAP_ID_PASID: u32 = 27;
pub const PCI_EXT_CAP_ID_DPC: u32 = 29;
pub const PCI_EXT_CAP_ID_L1SS: u32 = 30;
pub const PCI_EXT_CAP_ID_PTM: u32 = 31;
pub const PCI_EXT_CAP_ID_DVSEC: u32 = 35;
pub const PCI_EXT_CAP_ID_VF_REBAR: u32 = 36;
pub const PCI_EXT_CAP_ID_DLF: u32 = 37;
pub const PCI_EXT_CAP_ID_PL_16GT: u32 = 38;
pub const PCI_EXT_CAP_ID_NPEM: u32 = 41;
pub const PCI_EXT_CAP_ID_PL_32GT: u32 = 42;
pub const PCI_EXT_CAP_ID_DOE: u32 = 46;
pub const PCI_EXT_CAP_ID_PL_64GT: u32 = 49;
pub const PCI_EXT_CAP_ID_MAX: u32 = 49;
pub const PCI_EXT_CAP_DSN_SIZEOF: u32 = 12;
pub const PCI_EXT_CAP_MCAST_ENDPOINT_SIZEOF: u32 = 40;
pub const PCI_ERR_UNCOR_STATUS: u32 = 4;
pub const PCI_ERR_UNC_UND: u32 = 1;
pub const PCI_ERR_UNC_DLP: u32 = 16;
pub const PCI_ERR_UNC_SURPDN: u32 = 32;
pub const PCI_ERR_UNC_POISON_TLP: u32 = 4096;
pub const PCI_ERR_UNC_FCP: u32 = 8192;
pub const PCI_ERR_UNC_COMP_TIME: u32 = 16384;
pub const PCI_ERR_UNC_COMP_ABORT: u32 = 32768;
pub const PCI_ERR_UNC_UNX_COMP: u32 = 65536;
pub const PCI_ERR_UNC_RX_OVER: u32 = 131072;
pub const PCI_ERR_UNC_MALF_TLP: u32 = 262144;
pub const PCI_ERR_UNC_ECRC: u32 = 524288;
pub const PCI_ERR_UNC_UNSUP: u32 = 1048576;
pub const PCI_ERR_UNC_ACSV: u32 = 2097152;
pub const PCI_ERR_UNC_INTN: u32 = 4194304;
pub const PCI_ERR_UNC_MCBTLP: u32 = 8388608;
pub const PCI_ERR_UNC_ATOMEG: u32 = 16777216;
pub const PCI_ERR_UNC_TLPPRE: u32 = 33554432;
pub const PCI_ERR_UNC_POISON_BLK: u32 = 67108864;
pub const PCI_ERR_UNC_DMWR_BLK: u32 = 134217728;
pub const PCI_ERR_UNC_IDE_CHECK: u32 = 268435456;
pub const PCI_ERR_UNC_MISR_IDE: u32 = 536870912;
pub const PCI_ERR_UNC_PCRC_CHECK: u32 = 1073741824;
pub const PCI_ERR_UNC_XLAT_BLK: u32 = 2147483648;
pub const PCI_ERR_UNCOR_MASK: u32 = 8;
pub const PCI_ERR_UNCOR_SEVER: u32 = 12;
pub const PCI_ERR_COR_STATUS: u32 = 16;
pub const PCI_ERR_COR_RCVR: u32 = 1;
pub const PCI_ERR_COR_BAD_TLP: u32 = 64;
pub const PCI_ERR_COR_BAD_DLLP: u32 = 128;
pub const PCI_ERR_COR_REP_ROLL: u32 = 256;
pub const PCI_ERR_COR_REP_TIMER: u32 = 4096;
pub const PCI_ERR_COR_ADV_NFAT: u32 = 8192;
pub const PCI_ERR_COR_INTERNAL: u32 = 16384;
pub const PCI_ERR_COR_LOG_OVER: u32 = 32768;
pub const PCI_ERR_COR_MASK: u32 = 20;
pub const PCI_ERR_CAP: u32 = 24;
pub const PCI_ERR_CAP_ECRC_GENC: u32 = 32;
pub const PCI_ERR_CAP_ECRC_GENE: u32 = 64;
pub const PCI_ERR_CAP_ECRC_CHKC: u32 = 128;
pub const PCI_ERR_CAP_ECRC_CHKE: u32 = 256;
pub const PCI_ERR_CAP_PREFIX_LOG_PRESENT: u32 = 2048;
pub const PCI_ERR_CAP_COMP_TIME_LOG: u32 = 4096;
pub const PCI_ERR_CAP_TLP_LOG_FLIT: u32 = 262144;
pub const PCI_ERR_CAP_TLP_LOG_SIZE: u32 = 16252928;
pub const PCI_ERR_HEADER_LOG: u32 = 28;
pub const PCI_ERR_ROOT_COMMAND: u32 = 44;
pub const PCI_ERR_ROOT_CMD_COR_EN: u32 = 1;
pub const PCI_ERR_ROOT_CMD_NONFATAL_EN: u32 = 2;
pub const PCI_ERR_ROOT_CMD_FATAL_EN: u32 = 4;
pub const PCI_ERR_ROOT_STATUS: u32 = 48;
pub const PCI_ERR_ROOT_COR_RCV: u32 = 1;
pub const PCI_ERR_ROOT_MULTI_COR_RCV: u32 = 2;
pub const PCI_ERR_ROOT_UNCOR_RCV: u32 = 4;
pub const PCI_ERR_ROOT_MULTI_UNCOR_RCV: u32 = 8;
pub const PCI_ERR_ROOT_FIRST_FATAL: u32 = 16;
pub const PCI_ERR_ROOT_NONFATAL_RCV: u32 = 32;
pub const PCI_ERR_ROOT_FATAL_RCV: u32 = 64;
pub const PCI_ERR_ROOT_AER_IRQ: u32 = 4160749568;
pub const PCI_ERR_ROOT_ERR_SRC: u32 = 52;
pub const PCI_ERR_PREFIX_LOG: u32 = 56;
pub const PCI_VC_PORT_CAP1: u32 = 4;
pub const PCI_VC_CAP1_EVCC: u32 = 7;
pub const PCI_VC_CAP1_LPEVCC: u32 = 112;
pub const PCI_VC_CAP1_ARB_SIZE: u32 = 3072;
pub const PCI_VC_PORT_CAP2: u32 = 8;
pub const PCI_VC_CAP2_32_PHASE: u32 = 2;
pub const PCI_VC_CAP2_64_PHASE: u32 = 4;
pub const PCI_VC_CAP2_128_PHASE: u32 = 8;
pub const PCI_VC_CAP2_ARB_OFF: u32 = 4278190080;
pub const PCI_VC_PORT_CTRL: u32 = 12;
pub const PCI_VC_PORT_CTRL_LOAD_TABLE: u32 = 1;
pub const PCI_VC_PORT_STATUS: u32 = 14;
pub const PCI_VC_PORT_STATUS_TABLE: u32 = 1;
pub const PCI_VC_RES_CAP: u32 = 16;
pub const PCI_VC_RES_CAP_32_PHASE: u32 = 2;
pub const PCI_VC_RES_CAP_64_PHASE: u32 = 4;
pub const PCI_VC_RES_CAP_128_PHASE: u32 = 8;
pub const PCI_VC_RES_CAP_128_PHASE_TB: u32 = 16;
pub const PCI_VC_RES_CAP_256_PHASE: u32 = 32;
pub const PCI_VC_RES_CAP_ARB_OFF: u32 = 4278190080;
pub const PCI_VC_RES_CTRL: u32 = 20;
pub const PCI_VC_RES_CTRL_LOAD_TABLE: u32 = 65536;
pub const PCI_VC_RES_CTRL_ARB_SELECT: u32 = 917504;
pub const PCI_VC_RES_CTRL_ID: u32 = 117440512;
pub const PCI_VC_RES_CTRL_ENABLE: u32 = 2147483648;
pub const PCI_VC_RES_STATUS: u32 = 26;
pub const PCI_VC_RES_STATUS_TABLE: u32 = 1;
pub const PCI_VC_RES_STATUS_NEGO: u32 = 2;
pub const PCI_CAP_VC_BASE_SIZEOF: u32 = 16;
pub const PCI_CAP_VC_PER_VC_SIZEOF: u32 = 12;
pub const PCI_PWR_DSR: u32 = 4;
pub const PCI_PWR_DATA: u32 = 8;
pub const PCI_PWR_CAP: u32 = 12;
pub const PCI_EXT_CAP_PWR_SIZEOF: u32 = 16;
pub const PCI_RCEC_RCIEP_BITMAP: u32 = 4;
pub const PCI_RCEC_BUSN: u32 = 8;
pub const PCI_RCEC_BUSN_REG_VER: u32 = 2;
pub const PCI_VNDR_HEADER: u32 = 4;
pub const HT_3BIT_CAP_MASK: u32 = 224;
pub const HT_CAPTYPE_SLAVE: u32 = 0;
pub const HT_CAPTYPE_HOST: u32 = 32;
pub const HT_5BIT_CAP_MASK: u32 = 248;
pub const HT_CAPTYPE_IRQ: u32 = 128;
pub const HT_CAPTYPE_REMAPPING_40: u32 = 160;
pub const HT_CAPTYPE_REMAPPING_64: u32 = 162;
pub const HT_CAPTYPE_UNITID_CLUMP: u32 = 144;
pub const HT_CAPTYPE_EXTCONF: u32 = 152;
pub const HT_CAPTYPE_MSI_MAPPING: u32 = 168;
pub const HT_MSI_FLAGS: u32 = 2;
pub const HT_MSI_FLAGS_ENABLE: u32 = 1;
pub const HT_MSI_FLAGS_FIXED: u32 = 2;
pub const HT_MSI_FIXED_ADDR: u32 = 4276092928;
pub const HT_MSI_ADDR_LO: u32 = 4;
pub const HT_MSI_ADDR_LO_MASK: u32 = 4293918720;
pub const HT_MSI_ADDR_HI: u32 = 8;
pub const HT_CAPTYPE_DIRECT_ROUTE: u32 = 176;
pub const HT_CAPTYPE_VCSET: u32 = 184;
pub const HT_CAPTYPE_ERROR_RETRY: u32 = 192;
pub const HT_CAPTYPE_GEN3: u32 = 208;
pub const HT_CAPTYPE_PM: u32 = 224;
pub const HT_CAP_SIZEOF_LONG: u32 = 28;
pub const HT_CAP_SIZEOF_SHORT: u32 = 24;
pub const PCI_ARI_CAP: u32 = 4;
pub const PCI_ARI_CAP_MFVC: u32 = 1;
pub const PCI_ARI_CAP_ACS: u32 = 2;
pub const PCI_ARI_CTRL: u32 = 6;
pub const PCI_ARI_CTRL_MFVC: u32 = 1;
pub const PCI_ARI_CTRL_ACS: u32 = 2;
pub const PCI_EXT_CAP_ARI_SIZEOF: u32 = 8;
pub const PCI_ATS_CAP: u32 = 4;
pub const PCI_ATS_MAX_QDEP: u32 = 32;
pub const PCI_ATS_CAP_PAGE_ALIGNED: u32 = 32;
pub const PCI_ATS_CTRL: u32 = 6;
pub const PCI_ATS_CTRL_ENABLE: u32 = 32768;
pub const PCI_ATS_MIN_STU: u32 = 12;
pub const PCI_EXT_CAP_ATS_SIZEOF: u32 = 8;
pub const PCI_PRI_CTRL: u32 = 4;
pub const PCI_PRI_CTRL_ENABLE: u32 = 1;
pub const PCI_PRI_CTRL_RESET: u32 = 2;
pub const PCI_PRI_STATUS: u32 = 6;
pub const PCI_PRI_STATUS_RF: u32 = 1;
pub const PCI_PRI_STATUS_UPRGI: u32 = 2;
pub const PCI_PRI_STATUS_STOPPED: u32 = 256;
pub const PCI_PRI_STATUS_PASID: u32 = 32768;
pub const PCI_PRI_MAX_REQ: u32 = 8;
pub const PCI_PRI_ALLOC_REQ: u32 = 12;
pub const PCI_EXT_CAP_PRI_SIZEOF: u32 = 16;
pub const PCI_PASID_CAP: u32 = 4;
pub const PCI_PASID_CAP_EXEC: u32 = 2;
pub const PCI_PASID_CAP_PRIV: u32 = 4;
pub const PCI_PASID_CAP_WIDTH: u32 = 7936;
pub const PCI_PASID_CTRL: u32 = 6;
pub const PCI_PASID_CTRL_ENABLE: u32 = 1;
pub const PCI_PASID_CTRL_EXEC: u32 = 2;
pub const PCI_PASID_CTRL_PRIV: u32 = 4;
pub const PCI_EXT_CAP_PASID_SIZEOF: u32 = 8;
pub const PCI_SRIOV_CAP: u32 = 4;
pub const PCI_SRIOV_CAP_VFM: u32 = 1;
pub const PCI_SRIOV_CTRL: u32 = 8;
pub const PCI_SRIOV_CTRL_VFE: u32 = 1;
pub const PCI_SRIOV_CTRL_VFM: u32 = 2;
pub const PCI_SRIOV_CTRL_INTR: u32 = 4;
pub const PCI_SRIOV_CTRL_MSE: u32 = 8;
pub const PCI_SRIOV_CTRL_ARI: u32 = 16;
pub const PCI_SRIOV_STATUS: u32 = 10;
pub const PCI_SRIOV_STATUS_VFM: u32 = 1;
pub const PCI_SRIOV_INITIAL_VF: u32 = 12;
pub const PCI_SRIOV_TOTAL_VF: u32 = 14;
pub const PCI_SRIOV_NUM_VF: u32 = 16;
pub const PCI_SRIOV_FUNC_LINK: u32 = 18;
pub const PCI_SRIOV_VF_OFFSET: u32 = 20;
pub const PCI_SRIOV_VF_STRIDE: u32 = 22;
pub const PCI_SRIOV_VF_DID: u32 = 26;
pub const PCI_SRIOV_SUP_PGSIZE: u32 = 28;
pub const PCI_SRIOV_SYS_PGSIZE: u32 = 32;
pub const PCI_SRIOV_BAR: u32 = 36;
pub const PCI_SRIOV_NUM_BARS: u32 = 6;
pub const PCI_SRIOV_VFM: u32 = 60;
pub const PCI_SRIOV_VFM_UA: u32 = 0;
pub const PCI_SRIOV_VFM_MI: u32 = 1;
pub const PCI_SRIOV_VFM_MO: u32 = 2;
pub const PCI_SRIOV_VFM_AV: u32 = 3;
pub const PCI_EXT_CAP_SRIOV_SIZEOF: u32 = 64;
pub const PCI_LTR_MAX_SNOOP_LAT: u32 = 4;
pub const PCI_LTR_MAX_NOSNOOP_LAT: u32 = 6;
pub const PCI_LTR_VALUE_MASK: u32 = 1023;
pub const PCI_LTR_SCALE_MASK: u32 = 7168;
pub const PCI_LTR_SCALE_SHIFT: u32 = 10;
pub const PCI_LTR_NOSNOOP_VALUE: u32 = 67043328;
pub const PCI_LTR_NOSNOOP_SCALE: u32 = 469762048;
pub const PCI_EXT_CAP_LTR_SIZEOF: u32 = 8;
pub const PCI_ACS_CAP: u32 = 4;
pub const PCI_ACS_SV: u32 = 1;
pub const PCI_ACS_TB: u32 = 2;
pub const PCI_ACS_RR: u32 = 4;
pub const PCI_ACS_CR: u32 = 8;
pub const PCI_ACS_UF: u32 = 16;
pub const PCI_ACS_EC: u32 = 32;
pub const PCI_ACS_DT: u32 = 64;
pub const PCI_ACS_EGRESS_BITS: u32 = 5;
pub const PCI_ACS_CTRL: u32 = 6;
pub const PCI_ACS_EGRESS_CTL_V: u32 = 8;
pub const PCI_SATA_REGS: u32 = 4;
pub const PCI_SATA_REGS_MASK: u32 = 15;
pub const PCI_SATA_REGS_INLINE: u32 = 15;
pub const PCI_SATA_SIZEOF_SHORT: u32 = 8;
pub const PCI_SATA_SIZEOF_LONG: u32 = 16;
pub const PCI_REBAR_CAP: u32 = 4;
pub const PCI_REBAR_CAP_SIZES: u32 = 4294967280;
pub const PCI_REBAR_CTRL: u32 = 8;
pub const PCI_REBAR_CTRL_BAR_IDX: u32 = 7;
pub const PCI_REBAR_CTRL_NBAR_MASK: u32 = 224;
pub const PCI_REBAR_CTRL_NBAR_SHIFT: u32 = 5;
pub const PCI_REBAR_CTRL_BAR_SIZE: u32 = 7936;
pub const PCI_REBAR_CTRL_BAR_SHIFT: u32 = 8;
pub const PCI_DPA_CAP: u32 = 4;
pub const PCI_DPA_CAP_SUBSTATE_MASK: u32 = 31;
pub const PCI_DPA_BASE_SIZEOF: u32 = 16;
pub const PCI_EXP_DEVCAP2_TPH_COMP_NONE: u32 = 0;
pub const PCI_EXP_DEVCAP2_TPH_COMP_TPH_ONLY: u32 = 1;
pub const PCI_EXP_DEVCAP2_TPH_COMP_EXT_TPH: u32 = 3;
pub const PCI_TPH_CAP: u32 = 4;
pub const PCI_TPH_CAP_ST_NS: u32 = 1;
pub const PCI_TPH_CAP_ST_IV: u32 = 2;
pub const PCI_TPH_CAP_ST_DS: u32 = 4;
pub const PCI_TPH_CAP_EXT_TPH: u32 = 256;
pub const PCI_TPH_CAP_LOC_MASK: u32 = 1536;
pub const PCI_TPH_LOC_NONE: u32 = 0;
pub const PCI_TPH_LOC_CAP: u32 = 512;
pub const PCI_TPH_LOC_MSIX: u32 = 1024;
pub const PCI_TPH_CAP_ST_MASK: u32 = 134152192;
pub const PCI_TPH_CAP_ST_SHIFT: u32 = 16;
pub const PCI_TPH_BASE_SIZEOF: u32 = 12;
pub const PCI_TPH_CTRL: u32 = 8;
pub const PCI_TPH_CTRL_MODE_SEL_MASK: u32 = 7;
pub const PCI_TPH_ST_NS_MODE: u32 = 0;
pub const PCI_TPH_ST_IV_MODE: u32 = 1;
pub const PCI_TPH_ST_DS_MODE: u32 = 2;
pub const PCI_TPH_CTRL_REQ_EN_MASK: u32 = 768;
pub const PCI_TPH_REQ_DISABLE: u32 = 0;
pub const PCI_TPH_REQ_TPH_ONLY: u32 = 1;
pub const PCI_TPH_REQ_EXT_TPH: u32 = 3;
pub const PCI_EXP_DPC_CAP: u32 = 4;
pub const PCI_EXP_DPC_IRQ: u32 = 31;
pub const PCI_EXP_DPC_CAP_RP_EXT: u32 = 32;
pub const PCI_EXP_DPC_CAP_POISONED_TLP: u32 = 64;
pub const PCI_EXP_DPC_CAP_SW_TRIGGER: u32 = 128;
pub const PCI_EXP_DPC_RP_PIO_LOG_SIZE: u32 = 3840;
pub const PCI_EXP_DPC_CAP_DL_ACTIVE: u32 = 4096;
pub const PCI_EXP_DPC_RP_PIO_LOG_SIZE4: u32 = 8192;
pub const PCI_EXP_DPC_CTL: u32 = 6;
pub const PCI_EXP_DPC_CTL_EN_FATAL: u32 = 1;
pub const PCI_EXP_DPC_CTL_EN_NONFATAL: u32 = 2;
pub const PCI_EXP_DPC_CTL_INT_EN: u32 = 8;
pub const PCI_EXP_DPC_STATUS: u32 = 8;
pub const PCI_EXP_DPC_STATUS_TRIGGER: u32 = 1;
pub const PCI_EXP_DPC_STATUS_TRIGGER_RSN: u32 = 6;
pub const PCI_EXP_DPC_STATUS_TRIGGER_RSN_UNCOR: u32 = 0;
pub const PCI_EXP_DPC_STATUS_TRIGGER_RSN_NFE: u32 = 2;
pub const PCI_EXP_DPC_STATUS_TRIGGER_RSN_FE: u32 = 4;
pub const PCI_EXP_DPC_STATUS_TRIGGER_RSN_IN_EXT: u32 = 6;
pub const PCI_EXP_DPC_STATUS_INTERRUPT: u32 = 8;
pub const PCI_EXP_DPC_RP_BUSY: u32 = 16;
pub const PCI_EXP_DPC_STATUS_TRIGGER_RSN_EXT: u32 = 96;
pub const PCI_EXP_DPC_STATUS_TRIGGER_RSN_RP_PIO: u32 = 0;
pub const PCI_EXP_DPC_STATUS_TRIGGER_RSN_SW_TRIGGER: u32 = 32;
pub const PCI_EXP_DPC_RP_PIO_FEP: u32 = 7936;
pub const PCI_EXP_DPC_SOURCE_ID: u32 = 10;
pub const PCI_EXP_DPC_RP_PIO_STATUS: u32 = 12;
pub const PCI_EXP_DPC_RP_PIO_MASK: u32 = 16;
pub const PCI_EXP_DPC_RP_PIO_SEVERITY: u32 = 20;
pub const PCI_EXP_DPC_RP_PIO_SYSERROR: u32 = 24;
pub const PCI_EXP_DPC_RP_PIO_EXCEPTION: u32 = 28;
pub const PCI_EXP_DPC_RP_PIO_HEADER_LOG: u32 = 32;
pub const PCI_EXP_DPC_RP_PIO_IMPSPEC_LOG: u32 = 48;
pub const PCI_EXP_DPC_RP_PIO_TLPPREFIX_LOG: u32 = 52;
pub const PCI_PTM_CAP: u32 = 4;
pub const PCI_PTM_CAP_REQ: u32 = 1;
pub const PCI_PTM_CAP_RES: u32 = 2;
pub const PCI_PTM_CAP_ROOT: u32 = 4;
pub const PCI_PTM_GRANULARITY_MASK: u32 = 65280;
pub const PCI_PTM_CTRL: u32 = 8;
pub const PCI_PTM_CTRL_ENABLE: u32 = 1;
pub const PCI_PTM_CTRL_ROOT: u32 = 2;
pub const PCI_L1SS_CAP: u32 = 4;
pub const PCI_L1SS_CAP_PCIPM_L1_2: u32 = 1;
pub const PCI_L1SS_CAP_PCIPM_L1_1: u32 = 2;
pub const PCI_L1SS_CAP_ASPM_L1_2: u32 = 4;
pub const PCI_L1SS_CAP_ASPM_L1_1: u32 = 8;
pub const PCI_L1SS_CAP_L1_PM_SS: u32 = 16;
pub const PCI_L1SS_CAP_CM_RESTORE_TIME: u32 = 65280;
pub const PCI_L1SS_CAP_P_PWR_ON_SCALE: u32 = 196608;
pub const PCI_L1SS_CAP_P_PWR_ON_VALUE: u32 = 16252928;
pub const PCI_L1SS_CTL1: u32 = 8;
pub const PCI_L1SS_CTL1_PCIPM_L1_2: u32 = 1;
pub const PCI_L1SS_CTL1_PCIPM_L1_1: u32 = 2;
pub const PCI_L1SS_CTL1_ASPM_L1_2: u32 = 4;
pub const PCI_L1SS_CTL1_ASPM_L1_1: u32 = 8;
pub const PCI_L1SS_CTL1_L1_2_MASK: u32 = 5;
pub const PCI_L1SS_CTL1_L1SS_MASK: u32 = 15;
pub const PCI_L1SS_CTL1_CM_RESTORE_TIME: u32 = 65280;
pub const PCI_L1SS_CTL1_LTR_L12_TH_VALUE: u32 = 67043328;
pub const PCI_L1SS_CTL1_LTR_L12_TH_SCALE: u32 = 3758096384;
pub const PCI_L1SS_CTL2: u32 = 12;
pub const PCI_L1SS_CTL2_T_PWR_ON_SCALE: u32 = 3;
pub const PCI_L1SS_CTL2_T_PWR_ON_VALUE: u32 = 248;
pub const PCI_DVSEC_HEADER1: u32 = 4;
pub const PCI_DVSEC_HEADER2: u32 = 8;
pub const PCI_VF_REBAR_CAP: u32 = 4;
pub const PCI_VF_REBAR_CAP_SIZES: u32 = 4294967280;
pub const PCI_VF_REBAR_CTRL: u32 = 8;
pub const PCI_VF_REBAR_CTRL_BAR_IDX: u32 = 7;
pub const PCI_VF_REBAR_CTRL_NBAR_MASK: u32 = 224;
pub const PCI_VF_REBAR_CTRL_BAR_SIZE: u32 = 7936;
pub const PCI_DLF_CAP: u32 = 4;
pub const PCI_DLF_EXCHANGE_ENABLE: u32 = 2147483648;
pub const PCI_SECPCI_LE_CTRL: u32 = 12;
pub const PCI_PL_16GT_LE_CTRL: u32 = 32;
pub const PCI_PL_16GT_LE_CTRL_DSP_TX_PRESET_MASK: u32 = 15;
pub const PCI_PL_16GT_LE_CTRL_USP_TX_PRESET_MASK: u32 = 240;
pub const PCI_PL_16GT_LE_CTRL_USP_TX_PRESET_SHIFT: u32 = 4;
pub const PCI_PL_32GT_LE_CTRL: u32 = 32;
pub const PCI_PL_64GT_LE_CTRL: u32 = 32;
pub const PCI_NPEM_CAP: u32 = 4;
pub const PCI_NPEM_CAP_CAPABLE: u32 = 1;
pub const PCI_NPEM_CTRL: u32 = 8;
pub const PCI_NPEM_CTRL_ENABLE: u32 = 1;
pub const PCI_NPEM_CMD_RESET: u32 = 2;
pub const PCI_NPEM_IND_OK: u32 = 4;
pub const PCI_NPEM_IND_LOCATE: u32 = 8;
pub const PCI_NPEM_IND_FAIL: u32 = 16;
pub const PCI_NPEM_IND_REBUILD: u32 = 32;
pub const PCI_NPEM_IND_PFA: u32 = 64;
pub const PCI_NPEM_IND_HOTSPARE: u32 = 128;
pub const PCI_NPEM_IND_ICA: u32 = 256;
pub const PCI_NPEM_IND_IFA: u32 = 512;
pub const PCI_NPEM_IND_IDT: u32 = 1024;
pub const PCI_NPEM_IND_DISABLED: u32 = 2048;
pub const PCI_NPEM_IND_SPEC_0: u32 = 16777216;
pub const PCI_NPEM_IND_SPEC_1: u32 = 33554432;
pub const PCI_NPEM_IND_SPEC_2: u32 = 67108864;
pub const PCI_NPEM_IND_SPEC_3: u32 = 134217728;
pub const PCI_NPEM_IND_SPEC_4: u32 = 268435456;
pub const PCI_NPEM_IND_SPEC_5: u32 = 536870912;
pub const PCI_NPEM_IND_SPEC_6: u32 = 1073741824;
pub const PCI_NPEM_IND_SPEC_7: u32 = 2147483648;
pub const PCI_NPEM_STATUS: u32 = 12;
pub const PCI_NPEM_STATUS_CC: u32 = 1;
pub const PCI_DOE_CAP: u32 = 4;
pub const PCI_DOE_CAP_INT_SUP: u32 = 1;
pub const PCI_DOE_CAP_INT_MSG_NUM: u32 = 4094;
pub const PCI_DOE_CTRL: u32 = 8;
pub const PCI_DOE_CTRL_ABORT: u32 = 1;
pub const PCI_DOE_CTRL_INT_EN: u32 = 2;
pub const PCI_DOE_CTRL_GO: u32 = 2147483648;
pub const PCI_DOE_STATUS: u32 = 12;
pub const PCI_DOE_STATUS_BUSY: u32 = 1;
pub const PCI_DOE_STATUS_INT_STATUS: u32 = 2;
pub const PCI_DOE_STATUS_ERROR: u32 = 4;
pub const PCI_DOE_STATUS_DATA_OBJECT_READY: u32 = 2147483648;
pub const PCI_DOE_WRITE: u32 = 16;
pub const PCI_DOE_READ: u32 = 20;
pub const PCI_DOE_CAP_SIZEOF: u32 = 24;
pub const PCI_DOE_DATA_OBJECT_HEADER_1_VID: u32 = 65535;
pub const PCI_DOE_DATA_OBJECT_HEADER_1_TYPE: u32 = 16711680;
pub const PCI_DOE_DATA_OBJECT_HEADER_2_LENGTH: u32 = 262143;
pub const PCI_DOE_DATA_OBJECT_DISC_REQ_3_INDEX: u32 = 255;
pub const PCI_DOE_DATA_OBJECT_DISC_REQ_3_VER: u32 = 65280;
pub const PCI_DOE_DATA_OBJECT_DISC_RSP_3_VID: u32 = 65535;
pub const PCI_DOE_DATA_OBJECT_DISC_RSP_3_TYPE: u32 = 16711680;
pub const PCI_DOE_DATA_OBJECT_DISC_RSP_3_NEXT_INDEX: u32 = 4278190080;
pub const PCI_DOE_DATA_OBJECT_DISC_RSP_3_PROTOCOL: u32 = 16711680;
pub const PCI_DVSEC_CXL_PORT: u32 = 3;
pub const PCI_DVSEC_CXL_PORT_CTL: u32 = 12;
pub const PCI_DVSEC_CXL_PORT_CTL_UNMASK_SBR: u32 = 1;
pub const PCI_CLASS_NOT_DEFINED: u32 = 0;
pub const PCI_CLASS_NOT_DEFINED_VGA: u32 = 1;
pub const PCI_BASE_CLASS_STORAGE: u32 = 1;
pub const PCI_CLASS_STORAGE_SCSI: u32 = 256;
pub const PCI_CLASS_STORAGE_IDE: u32 = 257;
pub const PCI_CLASS_STORAGE_FLOPPY: u32 = 258;
pub const PCI_CLASS_STORAGE_IPI: u32 = 259;
pub const PCI_CLASS_STORAGE_RAID: u32 = 260;
pub const PCI_CLASS_STORAGE_SATA: u32 = 262;
pub const PCI_CLASS_STORAGE_SATA_AHCI: u32 = 67073;
pub const PCI_CLASS_STORAGE_SAS: u32 = 263;
pub const PCI_CLASS_STORAGE_EXPRESS: u32 = 67586;
pub const PCI_CLASS_STORAGE_OTHER: u32 = 384;
pub const PCI_BASE_CLASS_NETWORK: u32 = 2;
pub const PCI_CLASS_NETWORK_ETHERNET: u32 = 512;
pub const PCI_CLASS_NETWORK_TOKEN_RING: u32 = 513;
pub const PCI_CLASS_NETWORK_FDDI: u32 = 514;
pub const PCI_CLASS_NETWORK_ATM: u32 = 515;
pub const PCI_CLASS_NETWORK_OTHER: u32 = 640;
pub const PCI_BASE_CLASS_DISPLAY: u32 = 3;
pub const PCI_CLASS_DISPLAY_VGA: u32 = 768;
pub const PCI_CLASS_DISPLAY_XGA: u32 = 769;
pub const PCI_CLASS_DISPLAY_3D: u32 = 770;
pub const PCI_CLASS_DISPLAY_OTHER: u32 = 896;
pub const PCI_BASE_CLASS_MULTIMEDIA: u32 = 4;
pub const PCI_CLASS_MULTIMEDIA_VIDEO: u32 = 1024;
pub const PCI_CLASS_MULTIMEDIA_AUDIO: u32 = 1025;
pub const PCI_CLASS_MULTIMEDIA_PHONE: u32 = 1026;
pub const PCI_CLASS_MULTIMEDIA_HD_AUDIO: u32 = 1027;
pub const PCI_CLASS_MULTIMEDIA_OTHER: u32 = 1152;
pub const PCI_BASE_CLASS_MEMORY: u32 = 5;
pub const PCI_CLASS_MEMORY_RAM: u32 = 1280;
pub const PCI_CLASS_MEMORY_FLASH: u32 = 1281;
pub const PCI_CLASS_MEMORY_CXL: u32 = 1282;
pub const PCI_CLASS_MEMORY_OTHER: u32 = 1408;
pub const PCI_BASE_CLASS_BRIDGE: u32 = 6;
pub const PCI_CLASS_BRIDGE_HOST: u32 = 1536;
pub const PCI_CLASS_BRIDGE_ISA: u32 = 1537;
pub const PCI_CLASS_BRIDGE_EISA: u32 = 1538;
pub const PCI_CLASS_BRIDGE_MC: u32 = 1539;
pub const PCI_CLASS_BRIDGE_PCI: u32 = 1540;
pub const PCI_CLASS_BRIDGE_PCI_NORMAL: u32 = 394240;
pub const PCI_CLASS_BRIDGE_PCI_SUBTRACTIVE: u32 = 394241;
pub const PCI_CLASS_BRIDGE_PCMCIA: u32 = 1541;
pub const PCI_CLASS_BRIDGE_NUBUS: u32 = 1542;
pub const PCI_CLASS_BRIDGE_CARDBUS: u32 = 1543;
pub const PCI_CLASS_BRIDGE_RACEWAY: u32 = 1544;
pub const PCI_CLASS_BRIDGE_OTHER: u32 = 1664;
pub const PCI_BASE_CLASS_COMMUNICATION: u32 = 7;
pub const PCI_CLASS_COMMUNICATION_SERIAL: u32 = 1792;
pub const PCI_CLASS_COMMUNICATION_PARALLEL: u32 = 1793;
pub const PCI_CLASS_COMMUNICATION_MULTISERIAL: u32 = 1794;
pub const PCI_CLASS_COMMUNICATION_MODEM: u32 = 1795;
pub const PCI_CLASS_COMMUNICATION_OTHER: u32 = 1920;
pub const PCI_SERIAL_16550_COMPATIBLE: u32 = 2;
pub const PCI_BASE_CLASS_SYSTEM: u32 = 8;
pub const PCI_CLASS_SYSTEM_PIC: u32 = 2048;
pub const PCI_CLASS_SYSTEM_PIC_IOAPIC: u32 = 524304;
pub const PCI_CLASS_SYSTEM_PIC_IOXAPIC: u32 = 524320;
pub const PCI_CLASS_SYSTEM_DMA: u32 = 2049;
pub const PCI_CLASS_SYSTEM_TIMER: u32 = 2050;
pub const PCI_CLASS_SYSTEM_RTC: u32 = 2051;
pub const PCI_CLASS_SYSTEM_PCI_HOTPLUG: u32 = 2052;
pub const PCI_CLASS_SYSTEM_SDHCI: u32 = 2053;
pub const PCI_CLASS_SYSTEM_RCEC: u32 = 2055;
pub const PCI_CLASS_SYSTEM_OTHER: u32 = 2176;
pub const PCI_BASE_CLASS_INPUT: u32 = 9;
pub const PCI_CLASS_INPUT_KEYBOARD: u32 = 2304;
pub const PCI_CLASS_INPUT_PEN: u32 = 2305;
pub const PCI_CLASS_INPUT_MOUSE: u32 = 2306;
pub const PCI_CLASS_INPUT_SCANNER: u32 = 2307;
pub const PCI_CLASS_INPUT_GAMEPORT: u32 = 2308;
pub const PCI_CLASS_INPUT_OTHER: u32 = 2432;
pub const PCI_BASE_CLASS_DOCKING: u32 = 10;
pub const PCI_CLASS_DOCKING_GENERIC: u32 = 2560;
pub const PCI_CLASS_DOCKING_OTHER: u32 = 2688;
pub const PCI_BASE_CLASS_PROCESSOR: u32 = 11;
pub const PCI_CLASS_PROCESSOR_386: u32 = 2816;
pub const PCI_CLASS_PROCESSOR_486: u32 = 2817;
pub const PCI_CLASS_PROCESSOR_PENTIUM: u32 = 2818;
pub const PCI_CLASS_PROCESSOR_ALPHA: u32 = 2832;
pub const PCI_CLASS_PROCESSOR_POWERPC: u32 = 2848;
pub const PCI_CLASS_PROCESSOR_MIPS: u32 = 2864;
pub const PCI_CLASS_PROCESSOR_CO: u32 = 2880;
pub const PCI_BASE_CLASS_SERIAL: u32 = 12;
pub const PCI_CLASS_SERIAL_FIREWIRE: u32 = 3072;
pub const PCI_CLASS_SERIAL_FIREWIRE_OHCI: u32 = 786448;
pub const PCI_CLASS_SERIAL_ACCESS: u32 = 3073;
pub const PCI_CLASS_SERIAL_SSA: u32 = 3074;
pub const PCI_CLASS_SERIAL_USB: u32 = 3075;
pub const PCI_CLASS_SERIAL_USB_UHCI: u32 = 787200;
pub const PCI_CLASS_SERIAL_USB_OHCI: u32 = 787216;
pub const PCI_CLASS_SERIAL_USB_EHCI: u32 = 787232;
pub const PCI_CLASS_SERIAL_USB_XHCI: u32 = 787248;
pub const PCI_CLASS_SERIAL_USB_CDNS: u32 = 787328;
pub const PCI_CLASS_SERIAL_USB_DEVICE: u32 = 787454;
pub const PCI_CLASS_SERIAL_FIBER: u32 = 3076;
pub const PCI_CLASS_SERIAL_SMBUS: u32 = 3077;
pub const PCI_CLASS_SERIAL_IPMI: u32 = 3079;
pub const PCI_CLASS_SERIAL_IPMI_SMIC: u32 = 788224;
pub const PCI_CLASS_SERIAL_IPMI_KCS: u32 = 788225;
pub const PCI_CLASS_SERIAL_IPMI_BT: u32 = 788226;
pub const PCI_BASE_CLASS_WIRELESS: u32 = 13;
pub const PCI_CLASS_WIRELESS_RF_CONTROLLER: u32 = 3344;
pub const PCI_CLASS_WIRELESS_WHCI: u32 = 856080;
pub const PCI_BASE_CLASS_INTELLIGENT: u32 = 14;
pub const PCI_CLASS_INTELLIGENT_I2O: u32 = 3584;
pub const PCI_BASE_CLASS_SATELLITE: u32 = 15;
pub const PCI_CLASS_SATELLITE_TV: u32 = 3840;
pub const PCI_CLASS_SATELLITE_AUDIO: u32 = 3841;
pub const PCI_CLASS_SATELLITE_VOICE: u32 = 3843;
pub const PCI_CLASS_SATELLITE_DATA: u32 = 3844;
pub const PCI_BASE_CLASS_CRYPT: u32 = 16;
pub const PCI_CLASS_CRYPT_NETWORK: u32 = 4096;
pub const PCI_CLASS_CRYPT_ENTERTAINMENT: u32 = 4097;
pub const PCI_CLASS_CRYPT_OTHER: u32 = 4224;
pub const PCI_BASE_CLASS_SIGNAL_PROCESSING: u32 = 17;
pub const PCI_CLASS_SP_DPIO: u32 = 4352;
pub const PCI_CLASS_SP_OTHER: u32 = 4480;
pub const PCI_BASE_CLASS_ACCELERATOR: u32 = 18;
pub const PCI_CLASS_ACCELERATOR_PROCESSING: u32 = 4608;
pub const PCI_CLASS_OTHERS: u32 = 255;
pub const PCI_VENDOR_ID_PCI_SIG: u32 = 1;
pub const PCI_VENDOR_ID_LOONGSON: u32 = 20;
pub const PCI_DEVICE_ID_LOONGSON_HDA: u32 = 31239;
pub const PCI_DEVICE_ID_LOONGSON_HDMI: u32 = 31287;
pub const PCI_VENDOR_ID_SOLIDIGM: u32 = 606;
pub const PCI_VENDOR_ID_TTTECH: u32 = 855;
pub const PCI_DEVICE_ID_TTTECH_MC322: u32 = 10;
pub const PCI_VENDOR_ID_DYNALINK: u32 = 1653;
pub const PCI_DEVICE_ID_DYNALINK_IS64PH: u32 = 5890;
pub const PCI_VENDOR_ID_UBIQUITI: u32 = 1911;
pub const PCI_VENDOR_ID_BERKOM: u32 = 2161;
pub const PCI_DEVICE_ID_BERKOM_A1T: u32 = 65441;
pub const PCI_DEVICE_ID_BERKOM_T_CONCEPT: u32 = 65442;
pub const PCI_DEVICE_ID_BERKOM_A4T: u32 = 65444;
pub const PCI_DEVICE_ID_BERKOM_SCITEL_QUADRO: u32 = 65448;
pub const PCI_VENDOR_ID_ITTIM: u32 = 2888;
pub const PCI_VENDOR_ID_COMPAQ: u32 = 3601;
pub const PCI_DEVICE_ID_COMPAQ_TOKENRING: u32 = 1288;
pub const PCI_DEVICE_ID_COMPAQ_TACHYON: u32 = 41212;
pub const PCI_DEVICE_ID_COMPAQ_SMART2P: u32 = 44560;
pub const PCI_DEVICE_ID_COMPAQ_NETEL100: u32 = 44594;
pub const PCI_DEVICE_ID_COMPAQ_NETEL10: u32 = 44596;
pub const PCI_DEVICE_ID_COMPAQ_TRIFLEX_IDE: u32 = 44595;
pub const PCI_DEVICE_ID_COMPAQ_NETFLEX3I: u32 = 44597;
pub const PCI_DEVICE_ID_COMPAQ_NETEL100D: u32 = 44608;
pub const PCI_DEVICE_ID_COMPAQ_NETEL100PI: u32 = 44611;
pub const PCI_DEVICE_ID_COMPAQ_NETEL100I: u32 = 45073;
pub const PCI_DEVICE_ID_COMPAQ_CISS: u32 = 45152;
pub const PCI_DEVICE_ID_COMPAQ_CISSB: u32 = 45432;
pub const PCI_DEVICE_ID_COMPAQ_CISSC: u32 = 70;
pub const PCI_DEVICE_ID_COMPAQ_THUNDER: u32 = 61744;
pub const PCI_DEVICE_ID_COMPAQ_NETFLEX3B: u32 = 61776;
pub const PCI_VENDOR_ID_NCR: u32 = 4096;
pub const PCI_VENDOR_ID_LSI_LOGIC: u32 = 4096;
pub const PCI_DEVICE_ID_NCR_53C810: u32 = 1;
pub const PCI_DEVICE_ID_NCR_53C820: u32 = 2;
pub const PCI_DEVICE_ID_NCR_53C825: u32 = 3;
pub const PCI_DEVICE_ID_NCR_53C815: u32 = 4;
pub const PCI_DEVICE_ID_LSI_53C810AP: u32 = 5;
pub const PCI_DEVICE_ID_NCR_53C860: u32 = 6;
pub const PCI_DEVICE_ID_LSI_53C1510: u32 = 10;
pub const PCI_DEVICE_ID_NCR_53C896: u32 = 11;
pub const PCI_DEVICE_ID_NCR_53C895: u32 = 12;
pub const PCI_DEVICE_ID_NCR_53C885: u32 = 13;
pub const PCI_DEVICE_ID_NCR_53C875: u32 = 15;
pub const PCI_DEVICE_ID_NCR_53C1510: u32 = 16;
pub const PCI_DEVICE_ID_LSI_53C895A: u32 = 18;
pub const PCI_DEVICE_ID_LSI_53C875A: u32 = 19;
pub const PCI_DEVICE_ID_LSI_53C1010_33: u32 = 32;
pub const PCI_DEVICE_ID_LSI_53C1010_66: u32 = 33;
pub const PCI_DEVICE_ID_LSI_53C1030: u32 = 48;
pub const PCI_DEVICE_ID_LSI_1030_53C1035: u32 = 50;
pub const PCI_DEVICE_ID_LSI_53C1035: u32 = 64;
pub const PCI_DEVICE_ID_NCR_53C875J: u32 = 143;
pub const PCI_DEVICE_ID_LSI_FC909: u32 = 1569;
pub const PCI_DEVICE_ID_LSI_FC929: u32 = 1570;
pub const PCI_DEVICE_ID_LSI_FC929_LAN: u32 = 1571;
pub const PCI_DEVICE_ID_LSI_FC919: u32 = 1572;
pub const PCI_DEVICE_ID_LSI_FC919_LAN: u32 = 1573;
pub const PCI_DEVICE_ID_LSI_FC929X: u32 = 1574;
pub const PCI_DEVICE_ID_LSI_FC939X: u32 = 1602;
pub const PCI_DEVICE_ID_LSI_FC949X: u32 = 1600;
pub const PCI_DEVICE_ID_LSI_FC949ES: u32 = 1606;
pub const PCI_DEVICE_ID_LSI_FC919X: u32 = 1576;
pub const PCI_DEVICE_ID_NCR_YELLOWFIN: u32 = 1793;
pub const PCI_DEVICE_ID_LSI_61C102: u32 = 2305;
pub const PCI_DEVICE_ID_LSI_63C815: u32 = 4096;
pub const PCI_DEVICE_ID_LSI_SAS1064: u32 = 80;
pub const PCI_DEVICE_ID_LSI_SAS1064R: u32 = 1041;
pub const PCI_DEVICE_ID_LSI_SAS1066: u32 = 94;
pub const PCI_DEVICE_ID_LSI_SAS1068: u32 = 84;
pub const PCI_DEVICE_ID_LSI_SAS1064A: u32 = 92;
pub const PCI_DEVICE_ID_LSI_SAS1064E: u32 = 86;
pub const PCI_DEVICE_ID_LSI_SAS1066E: u32 = 90;
pub const PCI_DEVICE_ID_LSI_SAS1068E: u32 = 88;
pub const PCI_DEVICE_ID_LSI_SAS1078: u32 = 96;
pub const PCI_VENDOR_ID_ATI: u32 = 4098;
pub const PCI_DEVICE_ID_ATI_68800: u32 = 16728;
pub const PCI_DEVICE_ID_ATI_215CT222: u32 = 17236;
pub const PCI_DEVICE_ID_ATI_210888CX: u32 = 17240;
pub const PCI_DEVICE_ID_ATI_215ET222: u32 = 17748;
pub const PCI_DEVICE_ID_ATI_215GB: u32 = 18242;
pub const PCI_DEVICE_ID_ATI_215GD: u32 = 18244;
pub const PCI_DEVICE_ID_ATI_215GI: u32 = 18249;
pub const PCI_DEVICE_ID_ATI_215GP: u32 = 18256;
pub const PCI_DEVICE_ID_ATI_215GQ: u32 = 18257;
pub const PCI_DEVICE_ID_ATI_215XL: u32 = 18258;
pub const PCI_DEVICE_ID_ATI_215GT: u32 = 18260;
pub const PCI_DEVICE_ID_ATI_215GTB: u32 = 18261;
pub const PCI_DEVICE_ID_ATI_215_IV: u32 = 18262;
pub const PCI_DEVICE_ID_ATI_215_IW: u32 = 18263;
pub const PCI_DEVICE_ID_ATI_215_IZ: u32 = 18266;
pub const PCI_DEVICE_ID_ATI_210888GX: u32 = 18264;
pub const PCI_DEVICE_ID_ATI_215_LB: u32 = 19522;
pub const PCI_DEVICE_ID_ATI_215_LD: u32 = 19524;
pub const PCI_DEVICE_ID_ATI_215_LG: u32 = 19527;
pub const PCI_DEVICE_ID_ATI_215_LI: u32 = 19529;
pub const PCI_DEVICE_ID_ATI_215_LM: u32 = 19533;
pub const PCI_DEVICE_ID_ATI_215_LN: u32 = 19534;
pub const PCI_DEVICE_ID_ATI_215_LR: u32 = 19538;
pub const PCI_DEVICE_ID_ATI_215_LS: u32 = 19539;
pub const PCI_DEVICE_ID_ATI_264_LT: u32 = 19540;
pub const PCI_DEVICE_ID_ATI_264VT: u32 = 22100;
pub const PCI_DEVICE_ID_ATI_264VU: u32 = 22101;
pub const PCI_DEVICE_ID_ATI_264VV: u32 = 22102;
pub const PCI_DEVICE_ID_ATI_RAGE128_RE: u32 = 21061;
pub const PCI_DEVICE_ID_ATI_RAGE128_RF: u32 = 21062;
pub const PCI_DEVICE_ID_ATI_RAGE128_RG: u32 = 21063;
pub const PCI_DEVICE_ID_ATI_RAGE128_RK: u32 = 21067;
pub const PCI_DEVICE_ID_ATI_RAGE128_RL: u32 = 21068;
pub const PCI_DEVICE_ID_ATI_RAGE128_SE: u32 = 21317;
pub const PCI_DEVICE_ID_ATI_RAGE128_SF: u32 = 21318;
pub const PCI_DEVICE_ID_ATI_RAGE128_SG: u32 = 21319;
pub const PCI_DEVICE_ID_ATI_RAGE128_SH: u32 = 21320;
pub const PCI_DEVICE_ID_ATI_RAGE128_SK: u32 = 21323;
pub const PCI_DEVICE_ID_ATI_RAGE128_SL: u32 = 21324;
pub const PCI_DEVICE_ID_ATI_RAGE128_SM: u32 = 21325;
pub const PCI_DEVICE_ID_ATI_RAGE128_SN: u32 = 21326;
pub const PCI_DEVICE_ID_ATI_RAGE128_TF: u32 = 21574;
pub const PCI_DEVICE_ID_ATI_RAGE128_TL: u32 = 21580;
pub const PCI_DEVICE_ID_ATI_RAGE128_TR: u32 = 21586;
pub const PCI_DEVICE_ID_ATI_RAGE128_TS: u32 = 21587;
pub const PCI_DEVICE_ID_ATI_RAGE128_TT: u32 = 21588;
pub const PCI_DEVICE_ID_ATI_RAGE128_TU: u32 = 21589;
pub const PCI_DEVICE_ID_ATI_RAGE128_LE: u32 = 19525;
pub const PCI_DEVICE_ID_ATI_RAGE128_LF: u32 = 19526;
pub const PCI_DEVICE_ID_ATI_RAGE128_MF: u32 = 19782;
pub const PCI_DEVICE_ID_ATI_RAGE128_ML: u32 = 19788;
pub const PCI_DEVICE_ID_ATI_RAGE128_PA: u32 = 20545;
pub const PCI_DEVICE_ID_ATI_RAGE128_PB: u32 = 20546;
pub const PCI_DEVICE_ID_ATI_RAGE128_PC: u32 = 20547;
pub const PCI_DEVICE_ID_ATI_RAGE128_PD: u32 = 20548;
pub const PCI_DEVICE_ID_ATI_RAGE128_PE: u32 = 20549;
pub const PCI_DEVICE_ID_ATI_RAGE128_PF: u32 = 20550;
pub const PCI_DEVICE_ID_ATI_RAGE128_PG: u32 = 20551;
pub const PCI_DEVICE_ID_ATI_RAGE128_PH: u32 = 20552;
pub const PCI_DEVICE_ID_ATI_RAGE128_PI: u32 = 20553;
pub const PCI_DEVICE_ID_ATI_RAGE128_PJ: u32 = 20554;
pub const PCI_DEVICE_ID_ATI_RAGE128_PK: u32 = 20555;
pub const PCI_DEVICE_ID_ATI_RAGE128_PL: u32 = 20556;
pub const PCI_DEVICE_ID_ATI_RAGE128_PM: u32 = 20557;
pub const PCI_DEVICE_ID_ATI_RAGE128_PN: u32 = 20558;
pub const PCI_DEVICE_ID_ATI_RAGE128_PO: u32 = 20559;
pub const PCI_DEVICE_ID_ATI_RAGE128_PP: u32 = 20560;
pub const PCI_DEVICE_ID_ATI_RAGE128_PQ: u32 = 20561;
pub const PCI_DEVICE_ID_ATI_RAGE128_PR: u32 = 20562;
pub const PCI_DEVICE_ID_ATI_RAGE128_PS: u32 = 20563;
pub const PCI_DEVICE_ID_ATI_RAGE128_PT: u32 = 20564;
pub const PCI_DEVICE_ID_ATI_RAGE128_PU: u32 = 20565;
pub const PCI_DEVICE_ID_ATI_RAGE128_PV: u32 = 20566;
pub const PCI_DEVICE_ID_ATI_RAGE128_PW: u32 = 20567;
pub const PCI_DEVICE_ID_ATI_RAGE128_PX: u32 = 20568;
pub const PCI_DEVICE_ID_ATI_RADEON_QD: u32 = 20804;
pub const PCI_DEVICE_ID_ATI_RADEON_QE: u32 = 20805;
pub const PCI_DEVICE_ID_ATI_RADEON_QF: u32 = 20806;
pub const PCI_DEVICE_ID_ATI_RADEON_QG: u32 = 20807;
pub const PCI_DEVICE_ID_ATI_RADEON_QY: u32 = 20825;
pub const PCI_DEVICE_ID_ATI_RADEON_QZ: u32 = 20826;
pub const PCI_DEVICE_ID_ATI_RADEON_QL: u32 = 20812;
pub const PCI_DEVICE_ID_ATI_RADEON_QN: u32 = 20814;
pub const PCI_DEVICE_ID_ATI_RADEON_QO: u32 = 20815;
pub const PCI_DEVICE_ID_ATI_RADEON_Ql: u32 = 20844;
pub const PCI_DEVICE_ID_ATI_RADEON_BB: u32 = 16962;
pub const PCI_DEVICE_ID_ATI_RADEON_QM: u32 = 20813;
pub const PCI_DEVICE_ID_ATI_RADEON_QW: u32 = 20823;
pub const PCI_DEVICE_ID_ATI_RADEON_QX: u32 = 20824;
pub const PCI_DEVICE_ID_ATI_RADEON_Id: u32 = 18788;
pub const PCI_DEVICE_ID_ATI_RADEON_Ie: u32 = 18789;
pub const PCI_DEVICE_ID_ATI_RADEON_If: u32 = 18790;
pub const PCI_DEVICE_ID_ATI_RADEON_Ig: u32 = 18791;
pub const PCI_DEVICE_ID_ATI_RADEON_Ya: u32 = 22881;
pub const PCI_DEVICE_ID_ATI_RADEON_Yd: u32 = 22884;
pub const PCI_DEVICE_ID_ATI_RADEON_ND: u32 = 20036;
pub const PCI_DEVICE_ID_ATI_RADEON_NE: u32 = 20037;
pub const PCI_DEVICE_ID_ATI_RADEON_NF: u32 = 20038;
pub const PCI_DEVICE_ID_ATI_RADEON_NG: u32 = 20039;
pub const PCI_DEVICE_ID_ATI_RADEON_LY: u32 = 19545;
pub const PCI_DEVICE_ID_ATI_RADEON_LZ: u32 = 19546;
pub const PCI_DEVICE_ID_ATI_RADEON_LW: u32 = 19543;
pub const PCI_DEVICE_ID_ATI_RADEON_LX: u32 = 19544;
pub const PCI_DEVICE_ID_ATI_RADEON_Ld: u32 = 19556;
pub const PCI_DEVICE_ID_ATI_RADEON_Le: u32 = 19557;
pub const PCI_DEVICE_ID_ATI_RADEON_Lf: u32 = 19558;
pub const PCI_DEVICE_ID_ATI_RADEON_Lg: u32 = 19559;
pub const PCI_DEVICE_ID_ATI_RS100: u32 = 51888;
pub const PCI_DEVICE_ID_ATI_RS200: u32 = 51890;
pub const PCI_DEVICE_ID_ATI_RS200_B: u32 = 52146;
pub const PCI_DEVICE_ID_ATI_RS250: u32 = 51891;
pub const PCI_DEVICE_ID_ATI_RS300_100: u32 = 22576;
pub const PCI_DEVICE_ID_ATI_RS300_133: u32 = 22577;
pub const PCI_DEVICE_ID_ATI_RS300_166: u32 = 22578;
pub const PCI_DEVICE_ID_ATI_RS300_200: u32 = 22579;
pub const PCI_DEVICE_ID_ATI_RS350_100: u32 = 30768;
pub const PCI_DEVICE_ID_ATI_RS350_133: u32 = 30769;
pub const PCI_DEVICE_ID_ATI_RS350_166: u32 = 30770;
pub const PCI_DEVICE_ID_ATI_RS350_200: u32 = 30771;
pub const PCI_DEVICE_ID_ATI_RS400_100: u32 = 23088;
pub const PCI_DEVICE_ID_ATI_RS400_133: u32 = 23089;
pub const PCI_DEVICE_ID_ATI_RS400_166: u32 = 23090;
pub const PCI_DEVICE_ID_ATI_RS400_200: u32 = 23091;
pub const PCI_DEVICE_ID_ATI_RS480: u32 = 22864;
pub const PCI_DEVICE_ID_ATI_IXP200_IDE: u32 = 17225;
pub const PCI_DEVICE_ID_ATI_IXP200_SMBUS: u32 = 17235;
pub const PCI_DEVICE_ID_ATI_IXP300_SMBUS: u32 = 17251;
pub const PCI_DEVICE_ID_ATI_IXP300_IDE: u32 = 17257;
pub const PCI_DEVICE_ID_ATI_IXP300_SATA: u32 = 17262;
pub const PCI_DEVICE_ID_ATI_IXP400_SMBUS: u32 = 17266;
pub const PCI_DEVICE_ID_ATI_IXP400_IDE: u32 = 17270;
pub const PCI_DEVICE_ID_ATI_IXP400_SATA: u32 = 17273;
pub const PCI_DEVICE_ID_ATI_IXP400_SATA2: u32 = 17274;
pub const PCI_DEVICE_ID_ATI_IXP600_SATA: u32 = 17280;
pub const PCI_DEVICE_ID_ATI_SBX00_SMBUS: u32 = 17285;
pub const PCI_DEVICE_ID_ATI_IXP600_IDE: u32 = 17292;
pub const PCI_DEVICE_ID_ATI_IXP700_SATA: u32 = 17296;
pub const PCI_DEVICE_ID_ATI_IXP700_IDE: u32 = 17308;
pub const PCI_VENDOR_ID_VLSI: u32 = 4100;
pub const PCI_DEVICE_ID_VLSI_82C592: u32 = 5;
pub const PCI_DEVICE_ID_VLSI_82C593: u32 = 6;
pub const PCI_DEVICE_ID_VLSI_82C594: u32 = 7;
pub const PCI_DEVICE_ID_VLSI_82C597: u32 = 9;
pub const PCI_DEVICE_ID_VLSI_82C541: u32 = 12;
pub const PCI_DEVICE_ID_VLSI_82C543: u32 = 13;
pub const PCI_DEVICE_ID_VLSI_82C532: u32 = 257;
pub const PCI_DEVICE_ID_VLSI_82C534: u32 = 258;
pub const PCI_DEVICE_ID_VLSI_82C535: u32 = 260;
pub const PCI_DEVICE_ID_VLSI_82C147: u32 = 261;
pub const PCI_DEVICE_ID_VLSI_VAS96011: u32 = 1794;
pub const PCI_DEVICE_ID_RD890_IOMMU: u32 = 23075;
pub const PCI_VENDOR_ID_ADL: u32 = 4101;
pub const PCI_DEVICE_ID_ADL_2301: u32 = 8961;
pub const PCI_VENDOR_ID_NS: u32 = 4107;
pub const PCI_DEVICE_ID_NS_87415: u32 = 2;
pub const PCI_DEVICE_ID_NS_87560_LIO: u32 = 14;
pub const PCI_DEVICE_ID_NS_87560_USB: u32 = 18;
pub const PCI_DEVICE_ID_NS_83815: u32 = 32;
pub const PCI_DEVICE_ID_NS_83820: u32 = 34;
pub const PCI_DEVICE_ID_NS_CS5535_ISA: u32 = 43;
pub const PCI_DEVICE_ID_NS_CS5535_IDE: u32 = 45;
pub const PCI_DEVICE_ID_NS_CS5535_AUDIO: u32 = 46;
pub const PCI_DEVICE_ID_NS_CS5535_USB: u32 = 47;
pub const PCI_DEVICE_ID_NS_GX_VIDEO: u32 = 48;
pub const PCI_DEVICE_ID_NS_SATURN: u32 = 53;
pub const PCI_DEVICE_ID_NS_SCx200_BRIDGE: u32 = 1280;
pub const PCI_DEVICE_ID_NS_SCx200_SMI: u32 = 1281;
pub const PCI_DEVICE_ID_NS_SCx200_IDE: u32 = 1282;
pub const PCI_DEVICE_ID_NS_SCx200_AUDIO: u32 = 1283;
pub const PCI_DEVICE_ID_NS_SCx200_VIDEO: u32 = 1284;
pub const PCI_DEVICE_ID_NS_SCx200_XBUS: u32 = 1285;
pub const PCI_DEVICE_ID_NS_SC1100_BRIDGE: u32 = 1296;
pub const PCI_DEVICE_ID_NS_SC1100_SMI: u32 = 1297;
pub const PCI_DEVICE_ID_NS_SC1100_XBUS: u32 = 1301;
pub const PCI_DEVICE_ID_NS_87410: u32 = 53249;
pub const PCI_DEVICE_ID_NS_GX_HOST_BRIDGE: u32 = 40;
pub const PCI_VENDOR_ID_TSENG: u32 = 4108;
pub const PCI_DEVICE_ID_TSENG_W32P_2: u32 = 12802;
pub const PCI_DEVICE_ID_TSENG_W32P_b: u32 = 12805;
pub const PCI_DEVICE_ID_TSENG_W32P_c: u32 = 12806;
pub const PCI_DEVICE_ID_TSENG_W32P_d: u32 = 12807;
pub const PCI_DEVICE_ID_TSENG_ET6000: u32 = 12808;
pub const PCI_VENDOR_ID_WEITEK: u32 = 4110;
pub const PCI_DEVICE_ID_WEITEK_P9000: u32 = 36865;
pub const PCI_DEVICE_ID_WEITEK_P9100: u32 = 37120;
pub const PCI_VENDOR_ID_DEC: u32 = 4113;
pub const PCI_DEVICE_ID_DEC_BRD: u32 = 1;
pub const PCI_DEVICE_ID_DEC_TULIP: u32 = 2;
pub const PCI_DEVICE_ID_DEC_TGA: u32 = 4;
pub const PCI_DEVICE_ID_DEC_TULIP_FAST: u32 = 9;
pub const PCI_DEVICE_ID_DEC_TGA2: u32 = 13;
pub const PCI_DEVICE_ID_DEC_FDDI: u32 = 15;
pub const PCI_DEVICE_ID_DEC_TULIP_PLUS: u32 = 20;
pub const PCI_DEVICE_ID_DEC_21142: u32 = 25;
pub const PCI_DEVICE_ID_DEC_21052: u32 = 33;
pub const PCI_DEVICE_ID_DEC_21150: u32 = 34;
pub const PCI_DEVICE_ID_DEC_21152: u32 = 36;
pub const PCI_DEVICE_ID_DEC_21153: u32 = 37;
pub const PCI_DEVICE_ID_DEC_21154: u32 = 38;
pub const PCI_DEVICE_ID_DEC_21285: u32 = 4197;
pub const PCI_DEVICE_ID_COMPAQ_42XX: u32 = 70;
pub const PCI_VENDOR_ID_CIRRUS: u32 = 4115;
pub const PCI_DEVICE_ID_CIRRUS_7548: u32 = 56;
pub const PCI_DEVICE_ID_CIRRUS_5430: u32 = 160;
pub const PCI_DEVICE_ID_CIRRUS_5434_4: u32 = 164;
pub const PCI_DEVICE_ID_CIRRUS_5434_8: u32 = 168;
pub const PCI_DEVICE_ID_CIRRUS_5436: u32 = 172;
pub const PCI_DEVICE_ID_CIRRUS_5446: u32 = 184;
pub const PCI_DEVICE_ID_CIRRUS_5480: u32 = 188;
pub const PCI_DEVICE_ID_CIRRUS_5462: u32 = 208;
pub const PCI_DEVICE_ID_CIRRUS_5464: u32 = 212;
pub const PCI_DEVICE_ID_CIRRUS_5465: u32 = 214;
pub const PCI_DEVICE_ID_CIRRUS_6729: u32 = 4352;
pub const PCI_DEVICE_ID_CIRRUS_6832: u32 = 4368;
pub const PCI_DEVICE_ID_CIRRUS_7543: u32 = 4610;
pub const PCI_DEVICE_ID_CIRRUS_4610: u32 = 24577;
pub const PCI_DEVICE_ID_CIRRUS_4612: u32 = 24579;
pub const PCI_DEVICE_ID_CIRRUS_4615: u32 = 24580;
pub const PCI_VENDOR_ID_IBM: u32 = 4116;
pub const PCI_DEVICE_ID_IBM_TR: u32 = 24;
pub const PCI_DEVICE_ID_IBM_TR_WAKE: u32 = 62;
pub const PCI_DEVICE_ID_IBM_CPC710_PCI64: u32 = 252;
pub const PCI_DEVICE_ID_IBM_SNIPE: u32 = 384;
pub const PCI_DEVICE_ID_IBM_CITRINE: u32 = 652;
pub const PCI_DEVICE_ID_IBM_GEMSTONE: u32 = 45414;
pub const PCI_DEVICE_ID_IBM_OBSIDIAN: u32 = 701;
pub const PCI_DEVICE_ID_IBM_ICOM_DEV_ID_1: u32 = 49;
pub const PCI_DEVICE_ID_IBM_ICOM_DEV_ID_2: u32 = 537;
pub const PCI_DEVICE_ID_IBM_ICOM_V2_TWO_PORTS_RVX: u32 = 538;
pub const PCI_DEVICE_ID_IBM_ICOM_V2_ONE_PORT_RVX_ONE_PORT_MDM: u32 = 593;
pub const PCI_DEVICE_ID_IBM_ICOM_V2_ONE_PORT_RVX_ONE_PORT_MDM_PCIE: u32 = 865;
pub const PCI_DEVICE_ID_IBM_ICOM_FOUR_PORT_MODEL: u32 = 594;
pub const PCI_DEVICE_ID_IBM_ISM: u32 = 1261;
pub const PCI_SUBVENDOR_ID_IBM: u32 = 4116;
pub const PCI_SUBDEVICE_ID_IBM_SATURN_SERIAL_ONE_PORT: u32 = 980;
pub const PCI_VENDOR_ID_UNISYS: u32 = 4120;
pub const PCI_DEVICE_ID_UNISYS_DMA_DIRECTOR: u32 = 28;
pub const PCI_VENDOR_ID_COMPEX2: u32 = 4122;
pub const PCI_DEVICE_ID_COMPEX2_100VG: u32 = 5;
pub const PCI_VENDOR_ID_WD: u32 = 4124;
pub const PCI_DEVICE_ID_WD_90C: u32 = 49738;
pub const PCI_VENDOR_ID_AMI: u32 = 4126;
pub const PCI_DEVICE_ID_AMI_MEGARAID3: u32 = 6496;
pub const PCI_DEVICE_ID_AMI_MEGARAID: u32 = 36880;
pub const PCI_DEVICE_ID_AMI_MEGARAID2: u32 = 36960;
pub const PCI_VENDOR_ID_AMD: u32 = 4130;
pub const PCI_DEVICE_ID_AMD_K8_NB: u32 = 4352;
pub const PCI_DEVICE_ID_AMD_K8_NB_ADDRMAP: u32 = 4353;
pub const PCI_DEVICE_ID_AMD_K8_NB_MEMCTL: u32 = 4354;
pub const PCI_DEVICE_ID_AMD_K8_NB_MISC: u32 = 4355;
pub const PCI_DEVICE_ID_AMD_10H_NB_HT: u32 = 4608;
pub const PCI_DEVICE_ID_AMD_10H_NB_MAP: u32 = 4609;
pub const PCI_DEVICE_ID_AMD_10H_NB_DRAM: u32 = 4610;
pub const PCI_DEVICE_ID_AMD_10H_NB_MISC: u32 = 4611;
pub const PCI_DEVICE_ID_AMD_10H_NB_LINK: u32 = 4612;
pub const PCI_DEVICE_ID_AMD_11H_NB_HT: u32 = 4864;
pub const PCI_DEVICE_ID_AMD_11H_NB_MAP: u32 = 4865;
pub const PCI_DEVICE_ID_AMD_11H_NB_DRAM: u32 = 4866;
pub const PCI_DEVICE_ID_AMD_11H_NB_MISC: u32 = 4867;
pub const PCI_DEVICE_ID_AMD_11H_NB_LINK: u32 = 4868;
pub const PCI_DEVICE_ID_AMD_15H_M10H_F3: u32 = 5123;
pub const PCI_DEVICE_ID_AMD_15H_M30H_NB_F3: u32 = 5149;
pub const PCI_DEVICE_ID_AMD_15H_M30H_NB_F4: u32 = 5150;
pub const PCI_DEVICE_ID_AMD_15H_M60H_NB_F3: u32 = 5491;
pub const PCI_DEVICE_ID_AMD_15H_M60H_NB_F4: u32 = 5492;
pub const PCI_DEVICE_ID_AMD_15H_NB_F0: u32 = 5632;
pub const PCI_DEVICE_ID_AMD_15H_NB_F1: u32 = 5633;
pub const PCI_DEVICE_ID_AMD_15H_NB_F2: u32 = 5634;
pub const PCI_DEVICE_ID_AMD_15H_NB_F3: u32 = 5635;
pub const PCI_DEVICE_ID_AMD_15H_NB_F4: u32 = 5636;
pub const PCI_DEVICE_ID_AMD_15H_NB_F5: u32 = 5637;
pub const PCI_DEVICE_ID_AMD_16H_NB_F3: u32 = 5427;
pub const PCI_DEVICE_ID_AMD_16H_NB_F4: u32 = 5428;
pub const PCI_DEVICE_ID_AMD_16H_M30H_NB_F3: u32 = 5507;
pub const PCI_DEVICE_ID_AMD_16H_M30H_NB_F4: u32 = 5508;
pub const PCI_DEVICE_ID_AMD_17H_DF_F3: u32 = 5219;
pub const PCI_DEVICE_ID_AMD_17H_M10H_DF_F3: u32 = 5611;
pub const PCI_DEVICE_ID_AMD_17H_M30H_DF_F3: u32 = 5267;
pub const PCI_DEVICE_ID_AMD_17H_M40H_DF_F3: u32 = 5107;
pub const PCI_DEVICE_ID_AMD_17H_M60H_DF_F3: u32 = 5195;
pub const PCI_DEVICE_ID_AMD_17H_M70H_DF_F3: u32 = 5187;
pub const PCI_DEVICE_ID_AMD_17H_MA0H_DF_F3: u32 = 5927;
pub const PCI_DEVICE_ID_AMD_19H_DF_F3: u32 = 5715;
pub const PCI_DEVICE_ID_AMD_19H_M10H_DF_F3: u32 = 5296;
pub const PCI_DEVICE_ID_AMD_19H_M40H_DF_F3: u32 = 5756;
pub const PCI_DEVICE_ID_AMD_19H_M50H_DF_F3: u32 = 5741;
pub const PCI_DEVICE_ID_AMD_19H_M60H_DF_F3: u32 = 5347;
pub const PCI_DEVICE_ID_AMD_19H_M70H_DF_F3: u32 = 5363;
pub const PCI_DEVICE_ID_AMD_19H_M78H_DF_F3: u32 = 4859;
pub const PCI_DEVICE_ID_AMD_1AH_M00H_DF_F3: u32 = 4803;
pub const PCI_DEVICE_ID_AMD_1AH_M20H_DF_F3: u32 = 5883;
pub const PCI_DEVICE_ID_AMD_1AH_M60H_DF_F3: u32 = 4683;
pub const PCI_DEVICE_ID_AMD_1AH_M70H_DF_F3: u32 = 4795;
pub const PCI_DEVICE_ID_AMD_MI200_DF_F3: u32 = 5331;
pub const PCI_DEVICE_ID_AMD_MI300_DF_F3: u32 = 5419;
pub const PCI_DEVICE_ID_AMD_VANGOGH_USB: u32 = 5690;
pub const PCI_DEVICE_ID_AMD_CNB17H_F3: u32 = 5891;
pub const PCI_DEVICE_ID_AMD_LANCE: u32 = 8192;
pub const PCI_DEVICE_ID_AMD_LANCE_HOME: u32 = 8193;
pub const PCI_DEVICE_ID_AMD_SCSI: u32 = 8224;
pub const PCI_DEVICE_ID_AMD_SERENADE: u32 = 14016;
pub const PCI_DEVICE_ID_AMD_FE_GATE_7006: u32 = 28678;
pub const PCI_DEVICE_ID_AMD_FE_GATE_7007: u32 = 28679;
pub const PCI_DEVICE_ID_AMD_FE_GATE_700C: u32 = 28684;
pub const PCI_DEVICE_ID_AMD_FE_GATE_700E: u32 = 28686;
pub const PCI_DEVICE_ID_AMD_COBRA_7401: u32 = 29697;
pub const PCI_DEVICE_ID_AMD_VIPER_7409: u32 = 29705;
pub const PCI_DEVICE_ID_AMD_VIPER_740B: u32 = 29707;
pub const PCI_DEVICE_ID_AMD_VIPER_7410: u32 = 29712;
pub const PCI_DEVICE_ID_AMD_VIPER_7411: u32 = 29713;
pub const PCI_DEVICE_ID_AMD_VIPER_7413: u32 = 29715;
pub const PCI_DEVICE_ID_AMD_VIPER_7440: u32 = 29760;
pub const PCI_DEVICE_ID_AMD_OPUS_7441: u32 = 29761;
pub const PCI_DEVICE_ID_AMD_OPUS_7443: u32 = 29763;
pub const PCI_DEVICE_ID_AMD_VIPER_7443: u32 = 29763;
pub const PCI_DEVICE_ID_AMD_OPUS_7445: u32 = 29765;
pub const PCI_DEVICE_ID_AMD_GOLAM_7450: u32 = 29776;
pub const PCI_DEVICE_ID_AMD_8111_PCI: u32 = 29792;
pub const PCI_DEVICE_ID_AMD_8111_LPC: u32 = 29800;
pub const PCI_DEVICE_ID_AMD_8111_IDE: u32 = 29801;
pub const PCI_DEVICE_ID_AMD_8111_SMBUS2: u32 = 29802;
pub const PCI_DEVICE_ID_AMD_8111_SMBUS: u32 = 29803;
pub const PCI_DEVICE_ID_AMD_8111_AUDIO: u32 = 29805;
pub const PCI_DEVICE_ID_AMD_8151_0: u32 = 29780;
pub const PCI_DEVICE_ID_AMD_8131_BRIDGE: u32 = 29776;
pub const PCI_DEVICE_ID_AMD_8131_APIC: u32 = 29777;
pub const PCI_DEVICE_ID_AMD_8132_BRIDGE: u32 = 29784;
pub const PCI_DEVICE_ID_AMD_NL_USB: u32 = 30994;
pub const PCI_DEVICE_ID_AMD_CS5535_IDE: u32 = 8335;
pub const PCI_DEVICE_ID_AMD_CS5536_ISA: u32 = 8336;
pub const PCI_DEVICE_ID_AMD_CS5536_FLASH: u32 = 8337;
pub const PCI_DEVICE_ID_AMD_CS5536_AUDIO: u32 = 8339;
pub const PCI_DEVICE_ID_AMD_CS5536_OHC: u32 = 8340;
pub const PCI_DEVICE_ID_AMD_CS5536_EHC: u32 = 8341;
pub const PCI_DEVICE_ID_AMD_CS5536_UDC: u32 = 8342;
pub const PCI_DEVICE_ID_AMD_CS5536_UOC: u32 = 8343;
pub const PCI_DEVICE_ID_AMD_CS5536_DEV_IDE: u32 = 8338;
pub const PCI_DEVICE_ID_AMD_CS5536_IDE: u32 = 8346;
pub const PCI_DEVICE_ID_AMD_LX_VIDEO: u32 = 8321;
pub const PCI_DEVICE_ID_AMD_LX_AES: u32 = 8322;
pub const PCI_DEVICE_ID_AMD_HUDSON2_SATA_IDE: u32 = 30720;
pub const PCI_DEVICE_ID_AMD_HUDSON2_SMBUS: u32 = 30731;
pub const PCI_DEVICE_ID_AMD_HUDSON2_IDE: u32 = 30732;
pub const PCI_DEVICE_ID_AMD_KERNCZ_SMBUS: u32 = 30987;
pub const PCI_VENDOR_ID_TRIDENT: u32 = 4131;
pub const PCI_DEVICE_ID_TRIDENT_4DWAVE_DX: u32 = 8192;
pub const PCI_DEVICE_ID_TRIDENT_4DWAVE_NX: u32 = 8193;
pub const PCI_DEVICE_ID_TRIDENT_9320: u32 = 37664;
pub const PCI_DEVICE_ID_TRIDENT_9388: u32 = 37768;
pub const PCI_DEVICE_ID_TRIDENT_9397: u32 = 37783;
pub const PCI_DEVICE_ID_TRIDENT_939A: u32 = 37786;
pub const PCI_DEVICE_ID_TRIDENT_9520: u32 = 38176;
pub const PCI_DEVICE_ID_TRIDENT_9525: u32 = 38181;
pub const PCI_DEVICE_ID_TRIDENT_9420: u32 = 37920;
pub const PCI_DEVICE_ID_TRIDENT_9440: u32 = 37952;
pub const PCI_DEVICE_ID_TRIDENT_9660: u32 = 38496;
pub const PCI_DEVICE_ID_TRIDENT_9750: u32 = 38736;
pub const PCI_DEVICE_ID_TRIDENT_9850: u32 = 38992;
pub const PCI_DEVICE_ID_TRIDENT_9880: u32 = 39040;
pub const PCI_DEVICE_ID_TRIDENT_8400: u32 = 33792;
pub const PCI_DEVICE_ID_TRIDENT_8420: u32 = 33824;
pub const PCI_DEVICE_ID_TRIDENT_8500: u32 = 34048;
pub const PCI_VENDOR_ID_AI: u32 = 4133;
pub const PCI_DEVICE_ID_AI_M1435: u32 = 5173;
pub const PCI_VENDOR_ID_DELL: u32 = 4136;
pub const PCI_DEVICE_ID_DELL_RACIII: u32 = 8;
pub const PCI_DEVICE_ID_DELL_RAC4: u32 = 18;
pub const PCI_DEVICE_ID_DELL_PERC5: u32 = 21;
pub const PCI_SUBVENDOR_ID_DELL: u32 = 4136;
pub const PCI_VENDOR_ID_MATROX: u32 = 4139;
pub const PCI_DEVICE_ID_MATROX_MGA_2: u32 = 1304;
pub const PCI_DEVICE_ID_MATROX_MIL: u32 = 1305;
pub const PCI_DEVICE_ID_MATROX_MYS: u32 = 1306;
pub const PCI_DEVICE_ID_MATROX_MIL_2: u32 = 1307;
pub const PCI_DEVICE_ID_MATROX_MYS_AGP: u32 = 1310;
pub const PCI_DEVICE_ID_MATROX_MIL_2_AGP: u32 = 1311;
pub const PCI_DEVICE_ID_MATROX_MGA_IMP: u32 = 3344;
pub const PCI_DEVICE_ID_MATROX_G100_MM: u32 = 4096;
pub const PCI_DEVICE_ID_MATROX_G100_AGP: u32 = 4097;
pub const PCI_DEVICE_ID_MATROX_G200_PCI: u32 = 1312;
pub const PCI_DEVICE_ID_MATROX_G200_AGP: u32 = 1313;
pub const PCI_DEVICE_ID_MATROX_G400: u32 = 1317;
pub const PCI_DEVICE_ID_MATROX_G200EV_PCI: u32 = 1328;
pub const PCI_DEVICE_ID_MATROX_G550: u32 = 9511;
pub const PCI_DEVICE_ID_MATROX_VIA: u32 = 17718;
pub const PCI_VENDOR_ID_MOBILITY_ELECTRONICS: u32 = 5362;
pub const PCI_VENDOR_ID_CT: u32 = 4140;
pub const PCI_DEVICE_ID_CT_69000: u32 = 192;
pub const PCI_DEVICE_ID_CT_65545: u32 = 216;
pub const PCI_DEVICE_ID_CT_65548: u32 = 220;
pub const PCI_DEVICE_ID_CT_65550: u32 = 224;
pub const PCI_DEVICE_ID_CT_65554: u32 = 228;
pub const PCI_DEVICE_ID_CT_65555: u32 = 229;
pub const PCI_VENDOR_ID_MIRO: u32 = 4145;
pub const PCI_DEVICE_ID_MIRO_36050: u32 = 22017;
pub const PCI_DEVICE_ID_MIRO_DC10PLUS: u32 = 32510;
pub const PCI_DEVICE_ID_MIRO_DC30PLUS: u32 = 55297;
pub const PCI_VENDOR_ID_NEC: u32 = 4147;
pub const PCI_DEVICE_ID_NEC_CBUS_1: u32 = 1;
pub const PCI_DEVICE_ID_NEC_LOCAL: u32 = 2;
pub const PCI_DEVICE_ID_NEC_ATM: u32 = 3;
pub const PCI_DEVICE_ID_NEC_R4000: u32 = 4;
pub const PCI_DEVICE_ID_NEC_486: u32 = 5;
pub const PCI_DEVICE_ID_NEC_ACCEL_1: u32 = 6;
pub const PCI_DEVICE_ID_NEC_UXBUS: u32 = 7;
pub const PCI_DEVICE_ID_NEC_ACCEL_2: u32 = 8;
pub const PCI_DEVICE_ID_NEC_GRAPH: u32 = 9;
pub const PCI_DEVICE_ID_NEC_VL: u32 = 22;
pub const PCI_DEVICE_ID_NEC_STARALPHA2: u32 = 44;
pub const PCI_DEVICE_ID_NEC_CBUS_2: u32 = 45;
pub const PCI_DEVICE_ID_NEC_USB: u32 = 53;
pub const PCI_DEVICE_ID_NEC_CBUS_3: u32 = 59;
pub const PCI_DEVICE_ID_NEC_NAPCCARD: u32 = 62;
pub const PCI_DEVICE_ID_NEC_PCX2: u32 = 70;
pub const PCI_DEVICE_ID_NEC_VRC5476: u32 = 155;
pub const PCI_DEVICE_ID_NEC_VRC4173: u32 = 165;
pub const PCI_DEVICE_ID_NEC_VRC5477_AC97: u32 = 166;
pub const PCI_DEVICE_ID_NEC_PC9821CS01: u32 = 32780;
pub const PCI_DEVICE_ID_NEC_PC9821NRB06: u32 = 32781;
pub const PCI_VENDOR_ID_FD: u32 = 4150;
pub const PCI_DEVICE_ID_FD_36C70: u32 = 0;
pub const PCI_VENDOR_ID_SI: u32 = 4153;
pub const PCI_DEVICE_ID_SI_5591_AGP: u32 = 1;
pub const PCI_DEVICE_ID_SI_6202: u32 = 2;
pub const PCI_DEVICE_ID_SI_503: u32 = 8;
pub const PCI_DEVICE_ID_SI_ACPI: u32 = 9;
pub const PCI_DEVICE_ID_SI_SMBUS: u32 = 22;
pub const PCI_DEVICE_ID_SI_LPC: u32 = 24;
pub const PCI_DEVICE_ID_SI_5597_VGA: u32 = 512;
pub const PCI_DEVICE_ID_SI_6205: u32 = 517;
pub const PCI_DEVICE_ID_SI_501: u32 = 1030;
pub const PCI_DEVICE_ID_SI_496: u32 = 1174;
pub const PCI_DEVICE_ID_SI_300: u32 = 768;
pub const PCI_DEVICE_ID_SI_315H: u32 = 784;
pub const PCI_DEVICE_ID_SI_315: u32 = 789;
pub const PCI_DEVICE_ID_SI_315PRO: u32 = 805;
pub const PCI_DEVICE_ID_SI_530: u32 = 1328;
pub const PCI_DEVICE_ID_SI_540: u32 = 1344;
pub const PCI_DEVICE_ID_SI_550: u32 = 1360;
pub const PCI_DEVICE_ID_SI_540_VGA: u32 = 21248;
pub const PCI_DEVICE_ID_SI_550_VGA: u32 = 21269;
pub const PCI_DEVICE_ID_SI_620: u32 = 1568;
pub const PCI_DEVICE_ID_SI_630: u32 = 1584;
pub const PCI_DEVICE_ID_SI_633: u32 = 1587;
pub const PCI_DEVICE_ID_SI_635: u32 = 1589;
pub const PCI_DEVICE_ID_SI_640: u32 = 1600;
pub const PCI_DEVICE_ID_SI_645: u32 = 1605;
pub const PCI_DEVICE_ID_SI_646: u32 = 1606;
pub const PCI_DEVICE_ID_SI_648: u32 = 1608;
pub const PCI_DEVICE_ID_SI_650: u32 = 1616;
pub const PCI_DEVICE_ID_SI_651: u32 = 1617;
pub const PCI_DEVICE_ID_SI_655: u32 = 1621;
pub const PCI_DEVICE_ID_SI_661: u32 = 1633;
pub const PCI_DEVICE_ID_SI_730: u32 = 1840;
pub const PCI_DEVICE_ID_SI_733: u32 = 1843;
pub const PCI_DEVICE_ID_SI_630_VGA: u32 = 25344;
pub const PCI_DEVICE_ID_SI_735: u32 = 1845;
pub const PCI_DEVICE_ID_SI_740: u32 = 1856;
pub const PCI_DEVICE_ID_SI_741: u32 = 1857;
pub const PCI_DEVICE_ID_SI_745: u32 = 1861;
pub const PCI_DEVICE_ID_SI_746: u32 = 1862;
pub const PCI_DEVICE_ID_SI_755: u32 = 1877;
pub const PCI_DEVICE_ID_SI_760: u32 = 1888;
pub const PCI_DEVICE_ID_SI_900: u32 = 2304;
pub const PCI_DEVICE_ID_SI_961: u32 = 2401;
pub const PCI_DEVICE_ID_SI_962: u32 = 2402;
pub const PCI_DEVICE_ID_SI_963: u32 = 2403;
pub const PCI_DEVICE_ID_SI_965: u32 = 2405;
pub const PCI_DEVICE_ID_SI_966: u32 = 2406;
pub const PCI_DEVICE_ID_SI_968: u32 = 2408;
pub const PCI_DEVICE_ID_SI_1180: u32 = 4480;
pub const PCI_DEVICE_ID_SI_5511: u32 = 21777;
pub const PCI_DEVICE_ID_SI_5513: u32 = 21779;
pub const PCI_DEVICE_ID_SI_5517: u32 = 21783;
pub const PCI_DEVICE_ID_SI_5518: u32 = 21784;
pub const PCI_DEVICE_ID_SI_5571: u32 = 21873;
pub const PCI_DEVICE_ID_SI_5581: u32 = 21889;
pub const PCI_DEVICE_ID_SI_5582: u32 = 21890;
pub const PCI_DEVICE_ID_SI_5591: u32 = 21905;
pub const PCI_DEVICE_ID_SI_5596: u32 = 21910;
pub const PCI_DEVICE_ID_SI_5597: u32 = 21911;
pub const PCI_DEVICE_ID_SI_5598: u32 = 21912;
pub const PCI_DEVICE_ID_SI_5600: u32 = 22016;
pub const PCI_DEVICE_ID_SI_7012: u32 = 28690;
pub const PCI_DEVICE_ID_SI_7013: u32 = 28691;
pub const PCI_DEVICE_ID_SI_7016: u32 = 28694;
pub const PCI_DEVICE_ID_SI_7018: u32 = 28696;
pub const PCI_VENDOR_ID_HP: u32 = 4156;
pub const PCI_VENDOR_ID_HP_3PAR: u32 = 5520;
pub const PCI_DEVICE_ID_HP_VISUALIZE_EG: u32 = 4101;
pub const PCI_DEVICE_ID_HP_VISUALIZE_FX6: u32 = 4102;
pub const PCI_DEVICE_ID_HP_VISUALIZE_FX4: u32 = 4104;
pub const PCI_DEVICE_ID_HP_VISUALIZE_FX2: u32 = 4106;
pub const PCI_DEVICE_ID_HP_TACHYON: u32 = 4136;
pub const PCI_DEVICE_ID_HP_TACHLITE: u32 = 4137;
pub const PCI_DEVICE_ID_HP_J2585A: u32 = 4144;
pub const PCI_DEVICE_ID_HP_J2585B: u32 = 4145;
pub const PCI_DEVICE_ID_HP_J2973A: u32 = 4160;
pub const PCI_DEVICE_ID_HP_J2970A: u32 = 4162;
pub const PCI_DEVICE_ID_HP_DIVA: u32 = 4168;
pub const PCI_DEVICE_ID_HP_DIVA_TOSCA1: u32 = 4169;
pub const PCI_DEVICE_ID_HP_DIVA_TOSCA2: u32 = 4170;
pub const PCI_DEVICE_ID_HP_DIVA_MAESTRO: u32 = 4171;
pub const PCI_DEVICE_ID_HP_REO_IOC: u32 = 4337;
pub const PCI_DEVICE_ID_HP_VISUALIZE_FXE: u32 = 4235;
pub const PCI_DEVICE_ID_HP_DIVA_HALFDOME: u32 = 4643;
pub const PCI_DEVICE_ID_HP_DIVA_KEYSTONE: u32 = 4646;
pub const PCI_DEVICE_ID_HP_DIVA_POWERBAR: u32 = 4647;
pub const PCI_DEVICE_ID_HP_ZX1_IOC: u32 = 4650;
pub const PCI_DEVICE_ID_HP_PCIX_LBA: u32 = 4654;
pub const PCI_DEVICE_ID_HP_SX1000_IOC: u32 = 4732;
pub const PCI_DEVICE_ID_HP_DIVA_EVEREST: u32 = 4738;
pub const PCI_DEVICE_ID_HP_DIVA_AUX: u32 = 4752;
pub const PCI_DEVICE_ID_HP_DIVA_RMP3: u32 = 4865;
pub const PCI_DEVICE_ID_HP_DIVA_HURRICANE: u32 = 4906;
pub const PCI_DEVICE_ID_HP_CISSA: u32 = 12832;
pub const PCI_DEVICE_ID_HP_CISSC: u32 = 12848;
pub const PCI_DEVICE_ID_HP_CISSD: u32 = 12856;
pub const PCI_DEVICE_ID_HP_CISSE: u32 = 12858;
pub const PCI_DEVICE_ID_HP_CISSF: u32 = 12859;
pub const PCI_DEVICE_ID_HP_CISSH: u32 = 12860;
pub const PCI_DEVICE_ID_HP_CISSI: u32 = 12857;
pub const PCI_DEVICE_ID_HP_ZX2_IOC: u32 = 16433;
pub const PCI_VENDOR_ID_PCTECH: u32 = 4162;
pub const PCI_DEVICE_ID_PCTECH_RZ1000: u32 = 4096;
pub const PCI_DEVICE_ID_PCTECH_RZ1001: u32 = 4097;
pub const PCI_DEVICE_ID_PCTECH_SAMURAI_IDE: u32 = 12320;
pub const PCI_VENDOR_ID_ASUSTEK: u32 = 4163;
pub const PCI_DEVICE_ID_ASUSTEK_0675: u32 = 1653;
pub const PCI_VENDOR_ID_DPT: u32 = 4164;
pub const PCI_DEVICE_ID_DPT: u32 = 41984;
pub const PCI_VENDOR_ID_OPTI: u32 = 4165;
pub const PCI_DEVICE_ID_OPTI_82C558: u32 = 50520;
pub const PCI_DEVICE_ID_OPTI_82C621: u32 = 50721;
pub const PCI_DEVICE_ID_OPTI_82C700: u32 = 50944;
pub const PCI_DEVICE_ID_OPTI_82C825: u32 = 54632;
pub const PCI_VENDOR_ID_ELSA: u32 = 4168;
pub const PCI_DEVICE_ID_ELSA_MICROLINK: u32 = 4096;
pub const PCI_DEVICE_ID_ELSA_QS3000: u32 = 12288;
pub const PCI_VENDOR_ID_STMICRO: u32 = 4170;
pub const PCI_DEVICE_ID_STMICRO_USB_HOST: u32 = 52224;
pub const PCI_DEVICE_ID_STMICRO_USB_OHCI: u32 = 52225;
pub const PCI_DEVICE_ID_STMICRO_USB_OTG: u32 = 52226;
pub const PCI_DEVICE_ID_STMICRO_UART_HWFC: u32 = 52227;
pub const PCI_DEVICE_ID_STMICRO_UART_NO_HWFC: u32 = 52228;
pub const PCI_DEVICE_ID_STMICRO_SOC_DMA: u32 = 52229;
pub const PCI_DEVICE_ID_STMICRO_SATA: u32 = 52230;
pub const PCI_DEVICE_ID_STMICRO_I2C: u32 = 52231;
pub const PCI_DEVICE_ID_STMICRO_SPI_HS: u32 = 52232;
pub const PCI_DEVICE_ID_STMICRO_MAC: u32 = 52233;
pub const PCI_DEVICE_ID_STMICRO_SDIO_EMMC: u32 = 52234;
pub const PCI_DEVICE_ID_STMICRO_SDIO: u32 = 52235;
pub const PCI_DEVICE_ID_STMICRO_GPIO: u32 = 52236;
pub const PCI_DEVICE_ID_STMICRO_VIP: u32 = 52237;
pub const PCI_DEVICE_ID_STMICRO_AUDIO_ROUTER_DMA: u32 = 52238;
pub const PCI_DEVICE_ID_STMICRO_AUDIO_ROUTER_SRCS: u32 = 52239;
pub const PCI_DEVICE_ID_STMICRO_AUDIO_ROUTER_MSPS: u32 = 52240;
pub const PCI_DEVICE_ID_STMICRO_CAN: u32 = 52241;
pub const PCI_DEVICE_ID_STMICRO_MLB: u32 = 52242;
pub const PCI_DEVICE_ID_STMICRO_DBP: u32 = 52243;
pub const PCI_DEVICE_ID_STMICRO_SATA_PHY: u32 = 52244;
pub const PCI_DEVICE_ID_STMICRO_ESRAM: u32 = 52245;
pub const PCI_DEVICE_ID_STMICRO_VIC: u32 = 52246;
pub const PCI_VENDOR_ID_BUSLOGIC: u32 = 4171;
pub const PCI_DEVICE_ID_BUSLOGIC_MULTIMASTER_NC: u32 = 320;
pub const PCI_DEVICE_ID_BUSLOGIC_MULTIMASTER: u32 = 4160;
pub const PCI_DEVICE_ID_BUSLOGIC_FLASHPOINT: u32 = 33072;
pub const PCI_VENDOR_ID_TI: u32 = 4172;
pub const PCI_DEVICE_ID_TI_TVP4020: u32 = 15623;
pub const PCI_DEVICE_ID_TI_4450: u32 = 32785;
pub const PCI_DEVICE_ID_TI_XX21_XX11: u32 = 32817;
pub const PCI_DEVICE_ID_TI_XX21_XX11_FM: u32 = 32819;
pub const PCI_DEVICE_ID_TI_XX21_XX11_SD: u32 = 32820;
pub const PCI_DEVICE_ID_TI_X515: u32 = 32822;
pub const PCI_DEVICE_ID_TI_XX12: u32 = 32825;
pub const PCI_DEVICE_ID_TI_XX12_FM: u32 = 32827;
pub const PCI_DEVICE_ID_TI_XIO2000A: u32 = 33329;
pub const PCI_DEVICE_ID_TI_1130: u32 = 44050;
pub const PCI_DEVICE_ID_TI_1031: u32 = 44051;
pub const PCI_DEVICE_ID_TI_1131: u32 = 44053;
pub const PCI_DEVICE_ID_TI_1250: u32 = 44054;
pub const PCI_DEVICE_ID_TI_1220: u32 = 44055;
pub const PCI_DEVICE_ID_TI_1221: u32 = 44057;
pub const PCI_DEVICE_ID_TI_1210: u32 = 44058;
pub const PCI_DEVICE_ID_TI_1450: u32 = 44059;
pub const PCI_DEVICE_ID_TI_1225: u32 = 44060;
pub const PCI_DEVICE_ID_TI_1251A: u32 = 44061;
pub const PCI_DEVICE_ID_TI_1211: u32 = 44062;
pub const PCI_DEVICE_ID_TI_1251B: u32 = 44063;
pub const PCI_DEVICE_ID_TI_4410: u32 = 44097;
pub const PCI_DEVICE_ID_TI_4451: u32 = 44098;
pub const PCI_DEVICE_ID_TI_4510: u32 = 44100;
pub const PCI_DEVICE_ID_TI_4520: u32 = 44102;
pub const PCI_DEVICE_ID_TI_7510: u32 = 44103;
pub const PCI_DEVICE_ID_TI_7610: u32 = 44104;
pub const PCI_DEVICE_ID_TI_7410: u32 = 44105;
pub const PCI_DEVICE_ID_TI_1410: u32 = 44112;
pub const PCI_DEVICE_ID_TI_1420: u32 = 44113;
pub const PCI_DEVICE_ID_TI_1451A: u32 = 44114;
pub const PCI_DEVICE_ID_TI_1620: u32 = 44116;
pub const PCI_DEVICE_ID_TI_1520: u32 = 44117;
pub const PCI_DEVICE_ID_TI_1510: u32 = 44118;
pub const PCI_DEVICE_ID_TI_X620: u32 = 44173;
pub const PCI_DEVICE_ID_TI_X420: u32 = 44174;
pub const PCI_DEVICE_ID_TI_XX20_FM: u32 = 44175;
pub const PCI_DEVICE_ID_TI_J721E: u32 = 45069;
pub const PCI_DEVICE_ID_TI_DRA74x: u32 = 46336;
pub const PCI_DEVICE_ID_TI_DRA72x: u32 = 46337;
pub const PCI_VENDOR_ID_SONY: u32 = 4173;
pub const PCI_VENDOR_ID_WINBOND2: u32 = 4176;
pub const PCI_DEVICE_ID_WINBOND2_89C940F: u32 = 23130;
pub const PCI_DEVICE_ID_WINBOND2_6692: u32 = 26258;
pub const PCI_VENDOR_ID_ANIGMA: u32 = 4177;
pub const PCI_DEVICE_ID_ANIGMA_MC145575: u32 = 256;
pub const PCI_VENDOR_ID_EFAR: u32 = 4181;
pub const PCI_DEVICE_ID_EFAR_SLC90E66_1: u32 = 37168;
pub const PCI_DEVICE_ID_EFAR_SLC90E66_3: u32 = 37987;
pub const PCI_VENDOR_ID_MOTOROLA: u32 = 4183;
pub const PCI_DEVICE_ID_MOTOROLA_MPC105: u32 = 1;
pub const PCI_DEVICE_ID_MOTOROLA_MPC106: u32 = 2;
pub const PCI_DEVICE_ID_MOTOROLA_MPC107: u32 = 4;
pub const PCI_DEVICE_ID_MOTOROLA_RAVEN: u32 = 18433;
pub const PCI_DEVICE_ID_MOTOROLA_FALCON: u32 = 18434;
pub const PCI_DEVICE_ID_MOTOROLA_HAWK: u32 = 18435;
pub const PCI_DEVICE_ID_MOTOROLA_HARRIER: u32 = 18443;
pub const PCI_DEVICE_ID_MOTOROLA_MPC5200: u32 = 22531;
pub const PCI_DEVICE_ID_MOTOROLA_MPC5200B: u32 = 22537;
pub const PCI_VENDOR_ID_PROMISE: u32 = 4186;
pub const PCI_DEVICE_ID_PROMISE_20265: u32 = 3376;
pub const PCI_DEVICE_ID_PROMISE_20267: u32 = 19760;
pub const PCI_DEVICE_ID_PROMISE_20246: u32 = 19763;
pub const PCI_DEVICE_ID_PROMISE_20262: u32 = 19768;
pub const PCI_DEVICE_ID_PROMISE_20263: u32 = 3384;
pub const PCI_DEVICE_ID_PROMISE_20268: u32 = 19816;
pub const PCI_DEVICE_ID_PROMISE_20269: u32 = 19817;
pub const PCI_DEVICE_ID_PROMISE_20270: u32 = 25192;
pub const PCI_DEVICE_ID_PROMISE_20271: u32 = 25193;
pub const PCI_DEVICE_ID_PROMISE_20275: u32 = 4725;
pub const PCI_DEVICE_ID_PROMISE_20276: u32 = 21109;
pub const PCI_DEVICE_ID_PROMISE_20277: u32 = 29301;
pub const PCI_VENDOR_ID_FOXCONN: u32 = 4187;
pub const PCI_VENDOR_ID_UMC: u32 = 4192;
pub const PCI_DEVICE_ID_UMC_UM8673F: u32 = 257;
pub const PCI_DEVICE_ID_UMC_UM8886BF: u32 = 26426;
pub const PCI_DEVICE_ID_UMC_UM8886A: u32 = 34922;
pub const PCI_VENDOR_ID_PICOPOWER: u32 = 4198;
pub const PCI_DEVICE_ID_PICOPOWER_PT86C523: u32 = 2;
pub const PCI_DEVICE_ID_PICOPOWER_PT86C523BBP: u32 = 32770;
pub const PCI_VENDOR_ID_MYLEX: u32 = 4201;
pub const PCI_DEVICE_ID_MYLEX_DAC960_P: u32 = 1;
pub const PCI_DEVICE_ID_MYLEX_DAC960_PD: u32 = 2;
pub const PCI_DEVICE_ID_MYLEX_DAC960_PG: u32 = 16;
pub const PCI_DEVICE_ID_MYLEX_DAC960_LA: u32 = 32;
pub const PCI_DEVICE_ID_MYLEX_DAC960_LP: u32 = 80;
pub const PCI_DEVICE_ID_MYLEX_DAC960_BA: u32 = 47702;
pub const PCI_DEVICE_ID_MYLEX_DAC960_GEM: u32 = 45414;
pub const PCI_VENDOR_ID_APPLE: u32 = 4203;
pub const PCI_DEVICE_ID_APPLE_BANDIT: u32 = 1;
pub const PCI_DEVICE_ID_APPLE_HYDRA: u32 = 14;
pub const PCI_DEVICE_ID_APPLE_UNI_N_FW: u32 = 24;
pub const PCI_DEVICE_ID_APPLE_UNI_N_AGP: u32 = 32;
pub const PCI_DEVICE_ID_APPLE_UNI_N_GMAC: u32 = 33;
pub const PCI_DEVICE_ID_APPLE_UNI_N_GMACP: u32 = 36;
pub const PCI_DEVICE_ID_APPLE_UNI_N_AGP_P: u32 = 39;
pub const PCI_DEVICE_ID_APPLE_UNI_N_AGP15: u32 = 45;
pub const PCI_DEVICE_ID_APPLE_UNI_N_PCI15: u32 = 46;
pub const PCI_DEVICE_ID_APPLE_UNI_N_GMAC2: u32 = 50;
pub const PCI_DEVICE_ID_APPLE_UNI_N_ATA: u32 = 51;
pub const PCI_DEVICE_ID_APPLE_UNI_N_AGP2: u32 = 52;
pub const PCI_DEVICE_ID_APPLE_IPID_ATA100: u32 = 59;
pub const PCI_DEVICE_ID_APPLE_K2_ATA100: u32 = 67;
pub const PCI_DEVICE_ID_APPLE_U3_AGP: u32 = 75;
pub const PCI_DEVICE_ID_APPLE_K2_GMAC: u32 = 76;
pub const PCI_DEVICE_ID_APPLE_SH_ATA: u32 = 80;
pub const PCI_DEVICE_ID_APPLE_SH_SUNGEM: u32 = 81;
pub const PCI_DEVICE_ID_APPLE_U3L_AGP: u32 = 88;
pub const PCI_DEVICE_ID_APPLE_U3H_AGP: u32 = 89;
pub const PCI_DEVICE_ID_APPLE_U4_PCIE: u32 = 91;
pub const PCI_DEVICE_ID_APPLE_IPID2_AGP: u32 = 102;
pub const PCI_DEVICE_ID_APPLE_IPID2_ATA: u32 = 105;
pub const PCI_DEVICE_ID_APPLE_IPID2_FW: u32 = 106;
pub const PCI_DEVICE_ID_APPLE_IPID2_GMAC: u32 = 107;
pub const PCI_DEVICE_ID_APPLE_TIGON3: u32 = 5701;
pub const PCI_VENDOR_ID_YAMAHA: u32 = 4211;
pub const PCI_DEVICE_ID_YAMAHA_724: u32 = 4;
pub const PCI_DEVICE_ID_YAMAHA_724F: u32 = 13;
pub const PCI_DEVICE_ID_YAMAHA_740: u32 = 10;
pub const PCI_DEVICE_ID_YAMAHA_740C: u32 = 12;
pub const PCI_DEVICE_ID_YAMAHA_744: u32 = 16;
pub const PCI_DEVICE_ID_YAMAHA_754: u32 = 18;
pub const PCI_VENDOR_ID_QLOGIC: u32 = 4215;
pub const PCI_DEVICE_ID_QLOGIC_ISP10160: u32 = 4118;
pub const PCI_DEVICE_ID_QLOGIC_ISP1020: u32 = 4128;
pub const PCI_DEVICE_ID_QLOGIC_ISP1080: u32 = 4224;
pub const PCI_DEVICE_ID_QLOGIC_ISP12160: u32 = 4630;
pub const PCI_DEVICE_ID_QLOGIC_ISP1240: u32 = 4672;
pub const PCI_DEVICE_ID_QLOGIC_ISP1280: u32 = 4736;
pub const PCI_DEVICE_ID_QLOGIC_ISP2100: u32 = 8448;
pub const PCI_DEVICE_ID_QLOGIC_ISP2200: u32 = 8704;
pub const PCI_DEVICE_ID_QLOGIC_ISP2300: u32 = 8960;
pub const PCI_DEVICE_ID_QLOGIC_ISP2312: u32 = 8978;
pub const PCI_DEVICE_ID_QLOGIC_ISP2322: u32 = 8994;
pub const PCI_DEVICE_ID_QLOGIC_ISP6312: u32 = 25362;
pub const PCI_DEVICE_ID_QLOGIC_ISP6322: u32 = 25378;
pub const PCI_DEVICE_ID_QLOGIC_ISP2422: u32 = 9250;
pub const PCI_DEVICE_ID_QLOGIC_ISP2432: u32 = 9266;
pub const PCI_DEVICE_ID_QLOGIC_ISP2512: u32 = 9490;
pub const PCI_DEVICE_ID_QLOGIC_ISP2522: u32 = 9506;
pub const PCI_DEVICE_ID_QLOGIC_ISP5422: u32 = 21538;
pub const PCI_DEVICE_ID_QLOGIC_ISP5432: u32 = 21554;
pub const PCI_VENDOR_ID_CYRIX: u32 = 4216;
pub const PCI_DEVICE_ID_CYRIX_5510: u32 = 0;
pub const PCI_DEVICE_ID_CYRIX_PCI_MASTER: u32 = 1;
pub const PCI_DEVICE_ID_CYRIX_5520: u32 = 2;
pub const PCI_DEVICE_ID_CYRIX_5530_LEGACY: u32 = 256;
pub const PCI_DEVICE_ID_CYRIX_5530_IDE: u32 = 258;
pub const PCI_DEVICE_ID_CYRIX_5530_AUDIO: u32 = 259;
pub const PCI_DEVICE_ID_CYRIX_5530_VIDEO: u32 = 260;
pub const PCI_VENDOR_ID_CONTAQ: u32 = 4224;
pub const PCI_DEVICE_ID_CONTAQ_82C693: u32 = 50835;
pub const PCI_VENDOR_ID_OLICOM: u32 = 4237;
pub const PCI_DEVICE_ID_OLICOM_OC2325: u32 = 18;
pub const PCI_DEVICE_ID_OLICOM_OC2183: u32 = 19;
pub const PCI_DEVICE_ID_OLICOM_OC2326: u32 = 20;
pub const PCI_VENDOR_ID_SUN: u32 = 4238;
pub const PCI_DEVICE_ID_SUN_EBUS: u32 = 4096;
pub const PCI_DEVICE_ID_SUN_HAPPYMEAL: u32 = 4097;
pub const PCI_DEVICE_ID_SUN_RIO_EBUS: u32 = 4352;
pub const PCI_DEVICE_ID_SUN_RIO_GEM: u32 = 4353;
pub const PCI_DEVICE_ID_SUN_RIO_1394: u32 = 4354;
pub const PCI_DEVICE_ID_SUN_RIO_USB: u32 = 4355;
pub const PCI_DEVICE_ID_SUN_GEM: u32 = 11181;
pub const PCI_DEVICE_ID_SUN_SIMBA: u32 = 20480;
pub const PCI_DEVICE_ID_SUN_PBM: u32 = 32768;
pub const PCI_DEVICE_ID_SUN_SCHIZO: u32 = 32769;
pub const PCI_DEVICE_ID_SUN_SABRE: u32 = 40960;
pub const PCI_DEVICE_ID_SUN_HUMMINGBIRD: u32 = 40961;
pub const PCI_DEVICE_ID_SUN_TOMATILLO: u32 = 43009;
pub const PCI_DEVICE_ID_SUN_CASSINI: u32 = 43962;
pub const PCI_VENDOR_ID_NI: u32 = 4243;
pub const PCI_DEVICE_ID_NI_PCI2322: u32 = 53552;
pub const PCI_DEVICE_ID_NI_PCI2324: u32 = 53568;
pub const PCI_DEVICE_ID_NI_PCI2328: u32 = 53584;
pub const PCI_DEVICE_ID_NI_PXI8422_2322: u32 = 53648;
pub const PCI_DEVICE_ID_NI_PXI8422_2324: u32 = 53664;
pub const PCI_DEVICE_ID_NI_PXI8420_2322: u32 = 53712;
pub const PCI_DEVICE_ID_NI_PXI8420_2324: u32 = 53728;
pub const PCI_DEVICE_ID_NI_PXI8420_2328: u32 = 53744;
pub const PCI_DEVICE_ID_NI_PXI8420_23216: u32 = 53745;
pub const PCI_DEVICE_ID_NI_PCI2322I: u32 = 53840;
pub const PCI_DEVICE_ID_NI_PCI2324I: u32 = 53872;
pub const PCI_DEVICE_ID_NI_PCI23216: u32 = 53936;
pub const PCI_DEVICE_ID_NI_PXI8430_2322: u32 = 28800;
pub const PCI_DEVICE_ID_NI_PCI8430_2322: u32 = 28891;
pub const PCI_DEVICE_ID_NI_PXI8430_2324: u32 = 28893;
pub const PCI_DEVICE_ID_NI_PCI8430_2324: u32 = 28895;
pub const PCI_DEVICE_ID_NI_PXI8430_2328: u32 = 28898;
pub const PCI_DEVICE_ID_NI_PCI8430_2328: u32 = 28900;
pub const PCI_DEVICE_ID_NI_PXI8430_23216: u32 = 28902;
pub const PCI_DEVICE_ID_NI_PCI8430_23216: u32 = 28903;
pub const PCI_DEVICE_ID_NI_PXI8432_2322: u32 = 28904;
pub const PCI_DEVICE_ID_NI_PCI8432_2322: u32 = 28906;
pub const PCI_DEVICE_ID_NI_PXI8432_2324: u32 = 28908;
pub const PCI_DEVICE_ID_NI_PCI8432_2324: u32 = 28910;
pub const PCI_VENDOR_ID_CMD: u32 = 4245;
pub const PCI_DEVICE_ID_CMD_643: u32 = 1603;
pub const PCI_DEVICE_ID_CMD_646: u32 = 1606;
pub const PCI_DEVICE_ID_CMD_648: u32 = 1608;
pub const PCI_DEVICE_ID_CMD_649: u32 = 1609;
pub const PCI_DEVICE_ID_SII_680: u32 = 1664;
pub const PCI_DEVICE_ID_SII_3112: u32 = 12562;
pub const PCI_DEVICE_ID_SII_1210SA: u32 = 576;
pub const PCI_VENDOR_ID_BROOKTREE: u32 = 4254;
pub const PCI_DEVICE_ID_BROOKTREE_878: u32 = 2168;
pub const PCI_DEVICE_ID_BROOKTREE_879: u32 = 2169;
pub const PCI_VENDOR_ID_SGI: u32 = 4265;
pub const PCI_DEVICE_ID_SGI_IOC3: u32 = 3;
pub const PCI_DEVICE_ID_SGI_LITHIUM: u32 = 4098;
pub const PCI_VENDOR_ID_WINBOND: u32 = 4269;
pub const PCI_DEVICE_ID_WINBOND_82C105: u32 = 261;
pub const PCI_DEVICE_ID_WINBOND_83C553: u32 = 1381;
pub const PCI_VENDOR_ID_PLX: u32 = 4277;
pub const PCI_DEVICE_ID_PLX_R685: u32 = 4144;
pub const PCI_DEVICE_ID_PLX_ROMULUS: u32 = 4202;
pub const PCI_DEVICE_ID_PLX_SPCOM800: u32 = 4214;
pub const PCI_DEVICE_ID_PLX_1077: u32 = 4215;
pub const PCI_DEVICE_ID_PLX_SPCOM200: u32 = 4355;
pub const PCI_DEVICE_ID_PLX_DJINN_ITOO: u32 = 4433;
pub const PCI_DEVICE_ID_PLX_R753: u32 = 4434;
pub const PCI_DEVICE_ID_PLX_OLITEC: u32 = 4487;
pub const PCI_DEVICE_ID_PLX_PCI200SYN: u32 = 12694;
pub const PCI_DEVICE_ID_PLX_9030: u32 = 36912;
pub const PCI_DEVICE_ID_PLX_9050: u32 = 36944;
pub const PCI_DEVICE_ID_PLX_9056: u32 = 36950;
pub const PCI_DEVICE_ID_PLX_9080: u32 = 36992;
pub const PCI_DEVICE_ID_PLX_GTEK_SERIAL2: u32 = 40961;
pub const PCI_VENDOR_ID_MADGE: u32 = 4278;
pub const PCI_DEVICE_ID_MADGE_MK2: u32 = 2;
pub const PCI_VENDOR_ID_3COM: u32 = 4279;
pub const PCI_DEVICE_ID_3COM_3C985: u32 = 1;
pub const PCI_DEVICE_ID_3COM_3C940: u32 = 5888;
pub const PCI_DEVICE_ID_3COM_3C339: u32 = 13200;
pub const PCI_DEVICE_ID_3COM_3C359: u32 = 13712;
pub const PCI_DEVICE_ID_3COM_3C940B: u32 = 33003;
pub const PCI_DEVICE_ID_3COM_3CR990: u32 = 39168;
pub const PCI_DEVICE_ID_3COM_3CR990_TX_95: u32 = 39170;
pub const PCI_DEVICE_ID_3COM_3CR990_TX_97: u32 = 39171;
pub const PCI_DEVICE_ID_3COM_3CR990B: u32 = 39172;
pub const PCI_DEVICE_ID_3COM_3CR990_FX: u32 = 39173;
pub const PCI_DEVICE_ID_3COM_3CR990SVR95: u32 = 39176;
pub const PCI_DEVICE_ID_3COM_3CR990SVR97: u32 = 39177;
pub const PCI_DEVICE_ID_3COM_3CR990SVR: u32 = 39178;
pub const PCI_VENDOR_ID_AL: u32 = 4281;
pub const PCI_DEVICE_ID_AL_M1489: u32 = 5257;
pub const PCI_DEVICE_ID_AL_M1533: u32 = 5427;
pub const PCI_DEVICE_ID_AL_M1535: u32 = 5429;
pub const PCI_DEVICE_ID_AL_M1541: u32 = 5441;
pub const PCI_DEVICE_ID_AL_M1563: u32 = 5475;
pub const PCI_DEVICE_ID_AL_M1621: u32 = 5665;
pub const PCI_DEVICE_ID_AL_M1631: u32 = 5681;
pub const PCI_DEVICE_ID_AL_M1632: u32 = 5682;
pub const PCI_DEVICE_ID_AL_M1641: u32 = 5697;
pub const PCI_DEVICE_ID_AL_M1644: u32 = 5700;
pub const PCI_DEVICE_ID_AL_M1647: u32 = 5703;
pub const PCI_DEVICE_ID_AL_M1651: u32 = 5713;
pub const PCI_DEVICE_ID_AL_M1671: u32 = 5745;
pub const PCI_DEVICE_ID_AL_M1681: u32 = 5761;
pub const PCI_DEVICE_ID_AL_M1683: u32 = 5763;
pub const PCI_DEVICE_ID_AL_M1689: u32 = 5769;
pub const PCI_DEVICE_ID_AL_M5219: u32 = 21017;
pub const PCI_DEVICE_ID_AL_M5228: u32 = 21032;
pub const PCI_DEVICE_ID_AL_M5229: u32 = 21033;
pub const PCI_DEVICE_ID_AL_M5451: u32 = 21585;
pub const PCI_DEVICE_ID_AL_M7101: u32 = 28929;
pub const PCI_VENDOR_ID_NEOMAGIC: u32 = 4296;
pub const PCI_DEVICE_ID_NEOMAGIC_NM256AV_AUDIO: u32 = 32773;
pub const PCI_DEVICE_ID_NEOMAGIC_NM256ZX_AUDIO: u32 = 32774;
pub const PCI_DEVICE_ID_NEOMAGIC_NM256XL_PLUS_AUDIO: u32 = 32790;
pub const PCI_VENDOR_ID_TCONRAD: u32 = 4314;
pub const PCI_DEVICE_ID_TCONRAD_TOKENRING: u32 = 1288;
pub const PCI_VENDOR_ID_ROHM: u32 = 4315;
pub const PCI_VENDOR_ID_NVIDIA: u32 = 4318;
pub const PCI_DEVICE_ID_NVIDIA_TNT: u32 = 32;
pub const PCI_DEVICE_ID_NVIDIA_TNT2: u32 = 40;
pub const PCI_DEVICE_ID_NVIDIA_UTNT2: u32 = 41;
pub const PCI_DEVICE_ID_NVIDIA_TNT_UNKNOWN: u32 = 42;
pub const PCI_DEVICE_ID_NVIDIA_VTNT2: u32 = 44;
pub const PCI_DEVICE_ID_NVIDIA_UVTNT2: u32 = 45;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE_MCP04_SMBUS: u32 = 52;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE_MCP04_IDE: u32 = 53;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE_MCP04_SATA: u32 = 54;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE_MCP04_SATA2: u32 = 62;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_6800_ULTRA: u32 = 64;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_6800: u32 = 65;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_6800_LE: u32 = 66;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_6800_GT: u32 = 69;
pub const PCI_DEVICE_ID_NVIDIA_QUADRO_FX_4000: u32 = 78;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE4_SMBUS: u32 = 82;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE_CK804_IDE: u32 = 83;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE_CK804_SATA: u32 = 84;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE_CK804_SATA2: u32 = 85;
pub const PCI_DEVICE_ID_NVIDIA_CK804_AUDIO: u32 = 89;
pub const PCI_DEVICE_ID_NVIDIA_CK804_PCIE: u32 = 93;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE2_SMBUS: u32 = 100;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE2_IDE: u32 = 101;
pub const PCI_DEVICE_ID_NVIDIA_MCP2_MODEM: u32 = 105;
pub const PCI_DEVICE_ID_NVIDIA_MCP2_AUDIO: u32 = 106;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE2S_SMBUS: u32 = 132;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE2S_IDE: u32 = 133;
pub const PCI_DEVICE_ID_NVIDIA_MCP2S_MODEM: u32 = 137;
pub const PCI_DEVICE_ID_NVIDIA_CK8_AUDIO: u32 = 138;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE2S_SATA: u32 = 142;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_7800_GT: u32 = 144;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_7800_GTX: u32 = 145;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_GO_7800: u32 = 152;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_GO_7800_GTX: u32 = 153;
pub const PCI_DEVICE_ID_NVIDIA_ITNT2: u32 = 160;
pub const PCI_DEVICE_ID_GEFORCE_6800A: u32 = 193;
pub const PCI_DEVICE_ID_GEFORCE_6800A_LE: u32 = 194;
pub const PCI_DEVICE_ID_GEFORCE_GO_6800: u32 = 200;
pub const PCI_DEVICE_ID_GEFORCE_GO_6800_ULTRA: u32 = 201;
pub const PCI_DEVICE_ID_QUADRO_FX_GO1400: u32 = 204;
pub const PCI_DEVICE_ID_QUADRO_FX_1400: u32 = 206;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE3: u32 = 209;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE3_SMBUS: u32 = 212;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE3_IDE: u32 = 213;
pub const PCI_DEVICE_ID_NVIDIA_MCP3_MODEM: u32 = 217;
pub const PCI_DEVICE_ID_NVIDIA_MCP3_AUDIO: u32 = 218;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE3S: u32 = 225;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE3S_SATA: u32 = 227;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE3S_SMBUS: u32 = 228;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE3S_IDE: u32 = 229;
pub const PCI_DEVICE_ID_NVIDIA_CK8S_AUDIO: u32 = 234;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE3S_SATA2: u32 = 238;
pub const PCIE_DEVICE_ID_NVIDIA_GEFORCE_6800_ALT1: u32 = 240;
pub const PCIE_DEVICE_ID_NVIDIA_GEFORCE_6600_ALT1: u32 = 241;
pub const PCIE_DEVICE_ID_NVIDIA_GEFORCE_6600_ALT2: u32 = 242;
pub const PCIE_DEVICE_ID_NVIDIA_GEFORCE_6200_ALT1: u32 = 243;
pub const PCIE_DEVICE_ID_NVIDIA_GEFORCE_6800_GT: u32 = 249;
pub const PCIE_DEVICE_ID_NVIDIA_QUADRO_NVS280: u32 = 253;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_SDR: u32 = 256;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_DDR: u32 = 257;
pub const PCI_DEVICE_ID_NVIDIA_QUADRO: u32 = 259;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE2_MX: u32 = 272;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE2_MX2: u32 = 273;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE2_GO: u32 = 274;
pub const PCI_DEVICE_ID_NVIDIA_QUADRO2_MXR: u32 = 275;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_6600_GT: u32 = 320;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_6600: u32 = 321;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_6610_XL: u32 = 325;
pub const PCI_DEVICE_ID_NVIDIA_QUADRO_FX_540: u32 = 334;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_6200: u32 = 335;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE2_GTS: u32 = 336;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE2_GTS2: u32 = 337;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE2_ULTRA: u32 = 338;
pub const PCI_DEVICE_ID_NVIDIA_QUADRO2_PRO: u32 = 339;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_6200_TURBOCACHE: u32 = 353;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_GO_6200: u32 = 356;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_GO_6250: u32 = 358;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_GO_6200_1: u32 = 359;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_GO_6250_1: u32 = 360;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE4_MX_460: u32 = 368;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE4_MX_440: u32 = 369;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE4_MX_420: u32 = 370;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE4_MX_440_SE: u32 = 371;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE4_440_GO: u32 = 372;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE4_420_GO: u32 = 373;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE4_420_GO_M32: u32 = 374;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE4_460_GO: u32 = 375;
pub const PCI_DEVICE_ID_NVIDIA_QUADRO4_500XGL: u32 = 376;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE4_440_GO_M64: u32 = 377;
pub const PCI_DEVICE_ID_NVIDIA_QUADRO4_200: u32 = 378;
pub const PCI_DEVICE_ID_NVIDIA_QUADRO4_550XGL: u32 = 379;
pub const PCI_DEVICE_ID_NVIDIA_QUADRO4_500_GOGL: u32 = 380;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE4_410_GO_M16: u32 = 381;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE4_MX_440_8X: u32 = 385;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE4_MX_440SE_8X: u32 = 386;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE4_MX_420_8X: u32 = 387;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE4_MX_4000: u32 = 389;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE4_448_GO: u32 = 390;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE4_488_GO: u32 = 391;
pub const PCI_DEVICE_ID_NVIDIA_QUADRO4_580_XGL: u32 = 392;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE4_MX_MAC: u32 = 393;
pub const PCI_DEVICE_ID_NVIDIA_QUADRO4_280_NVS: u32 = 394;
pub const PCI_DEVICE_ID_NVIDIA_QUADRO4_380_XGL: u32 = 395;
pub const PCI_DEVICE_ID_NVIDIA_IGEFORCE2: u32 = 416;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE: u32 = 420;
pub const PCI_DEVICE_ID_NVIDIA_MCP1_AUDIO: u32 = 433;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE_SMBUS: u32 = 436;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE_IDE: u32 = 444;
pub const PCI_DEVICE_ID_NVIDIA_MCP1_MODEM: u32 = 449;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE2: u32 = 480;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE3: u32 = 512;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE3_1: u32 = 513;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE3_2: u32 = 514;
pub const PCI_DEVICE_ID_NVIDIA_QUADRO_DDC: u32 = 515;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_6800B: u32 = 529;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_6800B_LE: u32 = 530;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_6800B_GT: u32 = 533;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4600: u32 = 592;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4400: u32 = 593;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4200: u32 = 595;
pub const PCI_DEVICE_ID_NVIDIA_QUADRO4_900XGL: u32 = 600;
pub const PCI_DEVICE_ID_NVIDIA_QUADRO4_750XGL: u32 = 601;
pub const PCI_DEVICE_ID_NVIDIA_QUADRO4_700XGL: u32 = 603;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE_MCP51_SMBUS: u32 = 612;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE_MCP51_IDE: u32 = 613;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE_MCP51_SATA: u32 = 614;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE_MCP51_SATA2: u32 = 615;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE_MCP55_SMBUS: u32 = 872;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE_MCP55_IDE: u32 = 878;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE_MCP55_SATA: u32 = 894;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE_MCP55_SATA2: u32 = 895;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4800: u32 = 640;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4800_8X: u32 = 641;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE4_TI_4800SE: u32 = 642;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE4_4200_GO: u32 = 646;
pub const PCI_DEVICE_ID_NVIDIA_QUADRO4_980_XGL: u32 = 648;
pub const PCI_DEVICE_ID_NVIDIA_QUADRO4_780_XGL: u32 = 649;
pub const PCI_DEVICE_ID_NVIDIA_QUADRO4_700_GOGL: u32 = 652;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5800_ULTRA: u32 = 769;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5800: u32 = 770;
pub const PCI_DEVICE_ID_NVIDIA_QUADRO_FX_2000: u32 = 776;
pub const PCI_DEVICE_ID_NVIDIA_QUADRO_FX_1000: u32 = 777;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5600_ULTRA: u32 = 785;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5600: u32 = 786;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5600SE: u32 = 788;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_GO5600: u32 = 794;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_GO5650: u32 = 795;
pub const PCI_DEVICE_ID_NVIDIA_QUADRO_FX_GO700: u32 = 796;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5200: u32 = 800;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5200_ULTRA: u32 = 801;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5200_1: u32 = 802;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5200SE: u32 = 803;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_GO5200: u32 = 804;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_GO5250: u32 = 805;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5500: u32 = 806;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5100: u32 = 807;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_GO5250_32: u32 = 808;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_GO_5200: u32 = 809;
pub const PCI_DEVICE_ID_NVIDIA_QUADRO_NVS_280_PCI: u32 = 810;
pub const PCI_DEVICE_ID_NVIDIA_QUADRO_FX_500: u32 = 811;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_GO5300: u32 = 812;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_GO5100: u32 = 813;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5900_ULTRA: u32 = 816;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5900: u32 = 817;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5900XT: u32 = 818;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5950_ULTRA: u32 = 819;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5900ZT: u32 = 820;
pub const PCI_DEVICE_ID_NVIDIA_QUADRO_FX_3000: u32 = 824;
pub const PCI_DEVICE_ID_NVIDIA_QUADRO_FX_700: u32 = 831;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5700_ULTRA: u32 = 833;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5700: u32 = 834;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5700LE: u32 = 835;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_5700VE: u32 = 836;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_GO5700_1: u32 = 839;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_FX_GO5700_2: u32 = 840;
pub const PCI_DEVICE_ID_NVIDIA_QUADRO_FX_GO1000: u32 = 844;
pub const PCI_DEVICE_ID_NVIDIA_QUADRO_FX_1100: u32 = 846;
pub const PCI_DEVICE_ID_NVIDIA_MCP55_BRIDGE_V0: u32 = 864;
pub const PCI_DEVICE_ID_NVIDIA_MCP55_BRIDGE_V4: u32 = 868;
pub const PCI_DEVICE_ID_NVIDIA_NVENET_15: u32 = 883;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE_MCP61_SATA: u32 = 999;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE_MCP61_SMBUS: u32 = 1003;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE_MCP61_IDE: u32 = 1004;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE_MCP61_SATA2: u32 = 1014;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE_MCP61_SATA3: u32 = 1015;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE_MCP65_SMBUS: u32 = 1094;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE_MCP65_IDE: u32 = 1096;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE_MCP67_SMBUS: u32 = 1346;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE_MCP67_IDE: u32 = 1376;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE_MCP73_IDE: u32 = 1388;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE_MCP78S_SMBUS: u32 = 1874;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE_MCP77_IDE: u32 = 1881;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE_MCP73_SMBUS: u32 = 2008;
pub const PCI_DEVICE_ID_NVIDIA_GEFORCE_320M: u32 = 2208;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE_MCP79_SMBUS: u32 = 2722;
pub const PCI_DEVICE_ID_NVIDIA_NFORCE_MCP89_SATA: u32 = 3461;
pub const PCI_VENDOR_ID_IMS: u32 = 4320;
pub const PCI_DEVICE_ID_IMS_TT128: u32 = 37160;
pub const PCI_DEVICE_ID_IMS_TT3D: u32 = 37173;
pub const PCI_VENDOR_ID_AMCC: u32 = 4328;
pub const PCI_VENDOR_ID_AMPERE: u32 = 7663;
pub const PCI_VENDOR_ID_INTERG: u32 = 4330;
pub const PCI_DEVICE_ID_INTERG_1682: u32 = 5762;
pub const PCI_DEVICE_ID_INTERG_2000: u32 = 8192;
pub const PCI_DEVICE_ID_INTERG_2010: u32 = 8208;
pub const PCI_DEVICE_ID_INTERG_5000: u32 = 20480;
pub const PCI_DEVICE_ID_INTERG_5050: u32 = 20560;
pub const PCI_VENDOR_ID_REALTEK: u32 = 4332;
pub const PCI_DEVICE_ID_REALTEK_8139: u32 = 33081;
pub const PCI_VENDOR_ID_XILINX: u32 = 4334;
pub const PCI_DEVICE_ID_RME_DIGI96: u32 = 16320;
pub const PCI_DEVICE_ID_RME_DIGI96_8: u32 = 16321;
pub const PCI_DEVICE_ID_RME_DIGI96_8_PRO: u32 = 16322;
pub const PCI_DEVICE_ID_RME_DIGI96_8_PAD_OR_PST: u32 = 16323;
pub const PCI_DEVICE_ID_XILINX_HAMMERFALL_DSP: u32 = 16325;
pub const PCI_DEVICE_ID_XILINX_HAMMERFALL_DSP_MADI: u32 = 16326;
pub const PCI_VENDOR_ID_INIT: u32 = 4353;
pub const PCI_VENDOR_ID_CREATIVE: u32 = 4354;
pub const PCI_DEVICE_ID_CREATIVE_EMU10K1: u32 = 2;
pub const PCI_DEVICE_ID_CREATIVE_20K1: u32 = 5;
pub const PCI_DEVICE_ID_CREATIVE_20K2: u32 = 11;
pub const PCI_SUBDEVICE_ID_CREATIVE_SB0760: u32 = 36;
pub const PCI_SUBDEVICE_ID_CREATIVE_SB08801: u32 = 65;
pub const PCI_SUBDEVICE_ID_CREATIVE_SB08802: u32 = 66;
pub const PCI_SUBDEVICE_ID_CREATIVE_SB08803: u32 = 67;
pub const PCI_SUBDEVICE_ID_CREATIVE_SB1270: u32 = 98;
pub const PCI_SUBDEVICE_ID_CREATIVE_HENDRIX: u32 = 24576;
pub const PCI_VENDOR_ID_ECTIVA: u32 = 4354;
pub const PCI_DEVICE_ID_ECTIVA_EV1938: u32 = 35128;
pub const PCI_VENDOR_ID_TTI: u32 = 4355;
pub const PCI_DEVICE_ID_TTI_HPT343: u32 = 3;
pub const PCI_DEVICE_ID_TTI_HPT366: u32 = 4;
pub const PCI_DEVICE_ID_TTI_HPT372: u32 = 5;
pub const PCI_DEVICE_ID_TTI_HPT302: u32 = 6;
pub const PCI_DEVICE_ID_TTI_HPT371: u32 = 7;
pub const PCI_DEVICE_ID_TTI_HPT374: u32 = 8;
pub const PCI_DEVICE_ID_TTI_HPT372N: u32 = 9;
pub const PCI_VENDOR_ID_SIGMA: u32 = 4357;
pub const PCI_VENDOR_ID_VIA: u32 = 4358;
pub const PCI_DEVICE_ID_VIA_8763_0: u32 = 408;
pub const PCI_DEVICE_ID_VIA_8380_0: u32 = 516;
pub const PCI_DEVICE_ID_VIA_3238_0: u32 = 568;
pub const PCI_DEVICE_ID_VIA_PT880: u32 = 600;
pub const PCI_DEVICE_ID_VIA_PT880ULTRA: u32 = 776;
pub const PCI_DEVICE_ID_VIA_PX8X0_0: u32 = 601;
pub const PCI_DEVICE_ID_VIA_3269_0: u32 = 617;
pub const PCI_DEVICE_ID_VIA_K8T800PRO_0: u32 = 642;
pub const PCI_DEVICE_ID_VIA_3296_0: u32 = 662;
pub const PCI_DEVICE_ID_VIA_8363_0: u32 = 773;
pub const PCI_DEVICE_ID_VIA_P4M800CE: u32 = 788;
pub const PCI_DEVICE_ID_VIA_P4M890: u32 = 807;
pub const PCI_DEVICE_ID_VIA_VT3324: u32 = 804;
pub const PCI_DEVICE_ID_VIA_VT3336: u32 = 822;
pub const PCI_DEVICE_ID_VIA_VT3351: u32 = 849;
pub const PCI_DEVICE_ID_VIA_VT3364: u32 = 868;
pub const PCI_DEVICE_ID_VIA_8371_0: u32 = 913;
pub const PCI_DEVICE_ID_VIA_6415: u32 = 1045;
pub const PCI_DEVICE_ID_VIA_8501_0: u32 = 1281;
pub const PCI_DEVICE_ID_VIA_82C561: u32 = 1377;
pub const PCI_DEVICE_ID_VIA_82C586_1: u32 = 1393;
pub const PCI_DEVICE_ID_VIA_82C576: u32 = 1398;
pub const PCI_DEVICE_ID_VIA_82C586_0: u32 = 1414;
pub const PCI_DEVICE_ID_VIA_82C596: u32 = 1430;
pub const PCI_DEVICE_ID_VIA_82C597_0: u32 = 1431;
pub const PCI_DEVICE_ID_VIA_82C598_0: u32 = 1432;
pub const PCI_DEVICE_ID_VIA_8601_0: u32 = 1537;
pub const PCI_DEVICE_ID_VIA_8605_0: u32 = 1541;
pub const PCI_DEVICE_ID_VIA_82C686: u32 = 1670;
pub const PCI_DEVICE_ID_VIA_82C691_0: u32 = 1681;
pub const PCI_DEVICE_ID_VIA_82C576_1: u32 = 5489;
pub const PCI_DEVICE_ID_VIA_82C586_2: u32 = 12344;
pub const PCI_DEVICE_ID_VIA_82C586_3: u32 = 12352;
pub const PCI_DEVICE_ID_VIA_82C596_3: u32 = 12368;
pub const PCI_DEVICE_ID_VIA_82C596B_3: u32 = 12369;
pub const PCI_DEVICE_ID_VIA_82C686_4: u32 = 12375;
pub const PCI_DEVICE_ID_VIA_82C686_5: u32 = 12376;
pub const PCI_DEVICE_ID_VIA_8233_5: u32 = 12377;
pub const PCI_DEVICE_ID_VIA_8233_0: u32 = 12404;
pub const PCI_DEVICE_ID_VIA_8633_0: u32 = 12433;
pub const PCI_DEVICE_ID_VIA_8367_0: u32 = 12441;
pub const PCI_DEVICE_ID_VIA_8653_0: u32 = 12545;
pub const PCI_DEVICE_ID_VIA_8622: u32 = 12546;
pub const PCI_DEVICE_ID_VIA_8235_USB_2: u32 = 12548;
pub const PCI_DEVICE_ID_VIA_8233C_0: u32 = 12553;
pub const PCI_DEVICE_ID_VIA_8361: u32 = 12562;
pub const PCI_DEVICE_ID_VIA_XM266: u32 = 12566;
pub const PCI_DEVICE_ID_VIA_612X: u32 = 12569;
pub const PCI_DEVICE_ID_VIA_862X_0: u32 = 12579;
pub const PCI_DEVICE_ID_VIA_8753_0: u32 = 12584;
pub const PCI_DEVICE_ID_VIA_8233A: u32 = 12615;
pub const PCI_DEVICE_ID_VIA_8703_51_0: u32 = 12616;
pub const PCI_DEVICE_ID_VIA_8237_SATA: u32 = 12617;
pub const PCI_DEVICE_ID_VIA_XN266: u32 = 12630;
pub const PCI_DEVICE_ID_VIA_6410: u32 = 12644;
pub const PCI_DEVICE_ID_VIA_8754C_0: u32 = 12648;
pub const PCI_DEVICE_ID_VIA_8235: u32 = 12663;
pub const PCI_DEVICE_ID_VIA_8385_0: u32 = 12680;
pub const PCI_DEVICE_ID_VIA_8377_0: u32 = 12681;
pub const PCI_DEVICE_ID_VIA_8378_0: u32 = 12805;
pub const PCI_DEVICE_ID_VIA_8783_0: u32 = 12808;
pub const PCI_DEVICE_ID_VIA_8237: u32 = 12839;
pub const PCI_DEVICE_ID_VIA_8251: u32 = 12935;
pub const PCI_DEVICE_ID_VIA_8261: u32 = 13314;
pub const PCI_DEVICE_ID_VIA_8237A: u32 = 13111;
pub const PCI_DEVICE_ID_VIA_8237S: u32 = 13170;
pub const PCI_DEVICE_ID_VIA_SATA_EIDE: u32 = 21284;
pub const PCI_DEVICE_ID_VIA_8231: u32 = 33329;
pub const PCI_DEVICE_ID_VIA_8231_4: u32 = 33333;
pub const PCI_DEVICE_ID_VIA_8365_1: u32 = 33541;
pub const PCI_DEVICE_ID_VIA_CX700: u32 = 33572;
pub const PCI_DEVICE_ID_VIA_CX700_IDE: u32 = 1409;
pub const PCI_DEVICE_ID_VIA_VX800: u32 = 33619;
pub const PCI_DEVICE_ID_VIA_VX855: u32 = 33801;
pub const PCI_DEVICE_ID_VIA_VX900: u32 = 33808;
pub const PCI_DEVICE_ID_VIA_8371_1: u32 = 33681;
pub const PCI_DEVICE_ID_VIA_82C598_1: u32 = 34200;
pub const PCI_DEVICE_ID_VIA_838X_1: u32 = 45448;
pub const PCI_DEVICE_ID_VIA_83_87XX_1: u32 = 45464;
pub const PCI_DEVICE_ID_VIA_VX855_IDE: u32 = 50185;
pub const PCI_DEVICE_ID_VIA_ANON: u32 = 65535;
pub const PCI_VENDOR_ID_SIEMENS: u32 = 4362;
pub const PCI_DEVICE_ID_SIEMENS_DSCC4: u32 = 8450;
pub const PCI_VENDOR_ID_VORTEX: u32 = 4377;
pub const PCI_DEVICE_ID_VORTEX_GDT60x0: u32 = 0;
pub const PCI_DEVICE_ID_VORTEX_GDT6000B: u32 = 1;
pub const PCI_DEVICE_ID_VORTEX_GDT6x10: u32 = 2;
pub const PCI_DEVICE_ID_VORTEX_GDT6x20: u32 = 3;
pub const PCI_DEVICE_ID_VORTEX_GDT6530: u32 = 4;
pub const PCI_DEVICE_ID_VORTEX_GDT6550: u32 = 5;
pub const PCI_DEVICE_ID_VORTEX_GDT6x17: u32 = 6;
pub const PCI_DEVICE_ID_VORTEX_GDT6x27: u32 = 7;
pub const PCI_DEVICE_ID_VORTEX_GDT6537: u32 = 8;
pub const PCI_DEVICE_ID_VORTEX_GDT6557: u32 = 9;
pub const PCI_DEVICE_ID_VORTEX_GDT6x15: u32 = 10;
pub const PCI_DEVICE_ID_VORTEX_GDT6x25: u32 = 11;
pub const PCI_DEVICE_ID_VORTEX_GDT6535: u32 = 12;
pub const PCI_DEVICE_ID_VORTEX_GDT6555: u32 = 13;
pub const PCI_DEVICE_ID_VORTEX_GDT6x17RP: u32 = 256;
pub const PCI_DEVICE_ID_VORTEX_GDT6x27RP: u32 = 257;
pub const PCI_DEVICE_ID_VORTEX_GDT6537RP: u32 = 258;
pub const PCI_DEVICE_ID_VORTEX_GDT6557RP: u32 = 259;
pub const PCI_DEVICE_ID_VORTEX_GDT6x11RP: u32 = 260;
pub const PCI_DEVICE_ID_VORTEX_GDT6x21RP: u32 = 261;
pub const PCI_VENDOR_ID_EF: u32 = 4378;
pub const PCI_DEVICE_ID_EF_ATM_FPGA: u32 = 0;
pub const PCI_DEVICE_ID_EF_ATM_ASIC: u32 = 2;
pub const PCI_DEVICE_ID_EF_ATM_LANAI2: u32 = 3;
pub const PCI_DEVICE_ID_EF_ATM_LANAIHB: u32 = 5;
pub const PCI_VENDOR_ID_IDT: u32 = 4381;
pub const PCI_DEVICE_ID_IDT_IDT77201: u32 = 1;
pub const PCI_VENDOR_ID_FORE: u32 = 4391;
pub const PCI_DEVICE_ID_FORE_PCA200E: u32 = 768;
pub const PCI_VENDOR_ID_PHILIPS: u32 = 4401;
pub const PCI_DEVICE_ID_PHILIPS_SAA7146: u32 = 28998;
pub const PCI_DEVICE_ID_PHILIPS_SAA9730: u32 = 38704;
pub const PCI_VENDOR_ID_EICON: u32 = 4403;
pub const PCI_DEVICE_ID_EICON_DIVA20: u32 = 57346;
pub const PCI_DEVICE_ID_EICON_DIVA20_U: u32 = 57348;
pub const PCI_DEVICE_ID_EICON_DIVA201: u32 = 57349;
pub const PCI_DEVICE_ID_EICON_DIVA202: u32 = 57355;
pub const PCI_DEVICE_ID_EICON_MAESTRA: u32 = 57360;
pub const PCI_DEVICE_ID_EICON_MAESTRAQ: u32 = 57362;
pub const PCI_DEVICE_ID_EICON_MAESTRAQ_U: u32 = 57363;
pub const PCI_DEVICE_ID_EICON_MAESTRAP: u32 = 57364;
pub const PCI_VENDOR_ID_CISCO: u32 = 4407;
pub const PCI_VENDOR_ID_ZIATECH: u32 = 4408;
pub const PCI_DEVICE_ID_ZIATECH_5550_HC: u32 = 21840;
pub const PCI_VENDOR_ID_SYSKONNECT: u32 = 4424;
pub const PCI_DEVICE_ID_SYSKONNECT_TR: u32 = 16896;
pub const PCI_DEVICE_ID_SYSKONNECT_GE: u32 = 17152;
pub const PCI_DEVICE_ID_SYSKONNECT_YU: u32 = 17184;
pub const PCI_DEVICE_ID_SYSKONNECT_9DXX: u32 = 17408;
pub const PCI_DEVICE_ID_SYSKONNECT_9MXX: u32 = 17664;
pub const PCI_VENDOR_ID_DIGI: u32 = 4431;
pub const PCI_DEVICE_ID_DIGI_DF_M_IOM2_E: u32 = 112;
pub const PCI_DEVICE_ID_DIGI_DF_M_E: u32 = 113;
pub const PCI_DEVICE_ID_DIGI_DF_M_IOM2_A: u32 = 114;
pub const PCI_DEVICE_ID_DIGI_DF_M_A: u32 = 115;
pub const PCI_DEVICE_ID_DIGI_NEO_8: u32 = 177;
pub const PCI_DEVICE_ID_NEO_2DB9: u32 = 200;
pub const PCI_DEVICE_ID_NEO_2DB9PRI: u32 = 201;
pub const PCI_DEVICE_ID_NEO_2RJ45: u32 = 202;
pub const PCI_DEVICE_ID_NEO_2RJ45PRI: u32 = 203;
pub const PCIE_DEVICE_ID_NEO_4_IBM: u32 = 244;
pub const PCI_VENDOR_ID_XIRCOM: u32 = 4445;
pub const PCI_DEVICE_ID_XIRCOM_RBM56G: u32 = 257;
pub const PCI_DEVICE_ID_XIRCOM_X3201_MDM: u32 = 259;
pub const PCI_VENDOR_ID_SERVERWORKS: u32 = 4454;
pub const PCI_DEVICE_ID_SERVERWORKS_HE: u32 = 8;
pub const PCI_DEVICE_ID_SERVERWORKS_LE: u32 = 9;
pub const PCI_DEVICE_ID_SERVERWORKS_GCNB_LE: u32 = 23;
pub const PCI_DEVICE_ID_SERVERWORKS_HT1000_PXB: u32 = 54;
pub const PCI_DEVICE_ID_SERVERWORKS_EPB: u32 = 259;
pub const PCI_DEVICE_ID_SERVERWORKS_HT2000_PCIE: u32 = 306;
pub const PCI_DEVICE_ID_SERVERWORKS_OSB4: u32 = 512;
pub const PCI_DEVICE_ID_SERVERWORKS_CSB5: u32 = 513;
pub const PCI_DEVICE_ID_SERVERWORKS_CSB6: u32 = 515;
pub const PCI_DEVICE_ID_SERVERWORKS_HT1000SB: u32 = 517;
pub const PCI_DEVICE_ID_SERVERWORKS_OSB4IDE: u32 = 529;
pub const PCI_DEVICE_ID_SERVERWORKS_CSB5IDE: u32 = 530;
pub const PCI_DEVICE_ID_SERVERWORKS_CSB6IDE: u32 = 531;
pub const PCI_DEVICE_ID_SERVERWORKS_HT1000IDE: u32 = 532;
pub const PCI_DEVICE_ID_SERVERWORKS_CSB6IDE2: u32 = 535;
pub const PCI_DEVICE_ID_SERVERWORKS_CSB6LPC: u32 = 551;
pub const PCI_DEVICE_ID_SERVERWORKS_HT1100LD: u32 = 1032;
pub const PCI_VENDOR_ID_ALTERA: u32 = 4466;
pub const PCI_VENDOR_ID_SBE: u32 = 4470;
pub const PCI_DEVICE_ID_SBE_WANXL100: u32 = 769;
pub const PCI_DEVICE_ID_SBE_WANXL200: u32 = 770;
pub const PCI_DEVICE_ID_SBE_WANXL400: u32 = 260;
pub const PCI_SUBDEVICE_ID_SBE_T3E3: u32 = 9;
pub const PCI_SUBDEVICE_ID_SBE_2T3E3_P0: u32 = 2305;
pub const PCI_SUBDEVICE_ID_SBE_2T3E3_P1: u32 = 2306;
pub const PCI_VENDOR_ID_TOSHIBA: u32 = 4473;
pub const PCI_DEVICE_ID_TOSHIBA_PICCOLO_1: u32 = 257;
pub const PCI_DEVICE_ID_TOSHIBA_PICCOLO_2: u32 = 258;
pub const PCI_DEVICE_ID_TOSHIBA_PICCOLO_3: u32 = 259;
pub const PCI_DEVICE_ID_TOSHIBA_PICCOLO_5: u32 = 261;
pub const PCI_DEVICE_ID_TOSHIBA_TOPIC95: u32 = 1546;
pub const PCI_DEVICE_ID_TOSHIBA_TOPIC97: u32 = 1551;
pub const PCI_DEVICE_ID_TOSHIBA_TOPIC100: u32 = 1559;
pub const PCI_VENDOR_ID_TOSHIBA_2: u32 = 4143;
pub const PCI_DEVICE_ID_TOSHIBA_TC35815CF: u32 = 48;
pub const PCI_DEVICE_ID_TOSHIBA_TC35815_NWU: u32 = 49;
pub const PCI_DEVICE_ID_TOSHIBA_TC35815_TX4939: u32 = 50;
pub const PCI_DEVICE_ID_TOSHIBA_TC86C001_IDE: u32 = 261;
pub const PCI_DEVICE_ID_TOSHIBA_TC86C001_MISC: u32 = 264;
pub const PCI_DEVICE_ID_TOSHIBA_SPIDER_NET: u32 = 435;
pub const PCI_VENDOR_ID_ATTO: u32 = 4476;
pub const PCI_VENDOR_ID_RICOH: u32 = 4480;
pub const PCI_DEVICE_ID_RICOH_RL5C465: u32 = 1125;
pub const PCI_DEVICE_ID_RICOH_RL5C466: u32 = 1126;
pub const PCI_DEVICE_ID_RICOH_RL5C475: u32 = 1141;
pub const PCI_DEVICE_ID_RICOH_RL5C476: u32 = 1142;
pub const PCI_DEVICE_ID_RICOH_RL5C478: u32 = 1144;
pub const PCI_DEVICE_ID_RICOH_R5C822: u32 = 2082;
pub const PCI_DEVICE_ID_RICOH_R5CE822: u32 = 59426;
pub const PCI_DEVICE_ID_RICOH_R5CE823: u32 = 59427;
pub const PCI_DEVICE_ID_RICOH_R5C832: u32 = 2098;
pub const PCI_DEVICE_ID_RICOH_R5C843: u32 = 2115;
pub const PCI_VENDOR_ID_DLINK: u32 = 4486;
pub const PCI_DEVICE_ID_DLINK_DGE510T: u32 = 19456;
pub const PCI_VENDOR_ID_ARTOP: u32 = 4497;
pub const PCI_DEVICE_ID_ARTOP_ATP850UF: u32 = 5;
pub const PCI_DEVICE_ID_ARTOP_ATP860: u32 = 6;
pub const PCI_DEVICE_ID_ARTOP_ATP860R: u32 = 7;
pub const PCI_DEVICE_ID_ARTOP_ATP865: u32 = 8;
pub const PCI_DEVICE_ID_ARTOP_ATP865R: u32 = 9;
pub const PCI_DEVICE_ID_ARTOP_ATP867A: u32 = 10;
pub const PCI_DEVICE_ID_ARTOP_ATP867B: u32 = 11;
pub const PCI_DEVICE_ID_ARTOP_AEC7610: u32 = 32770;
pub const PCI_DEVICE_ID_ARTOP_AEC7612UW: u32 = 32784;
pub const PCI_DEVICE_ID_ARTOP_AEC7612U: u32 = 32800;
pub const PCI_DEVICE_ID_ARTOP_AEC7612S: u32 = 32816;
pub const PCI_DEVICE_ID_ARTOP_AEC7612D: u32 = 32832;
pub const PCI_DEVICE_ID_ARTOP_AEC7612SUW: u32 = 32848;
pub const PCI_DEVICE_ID_ARTOP_8060: u32 = 32864;
pub const PCI_VENDOR_ID_ZEITNET: u32 = 4499;
pub const PCI_DEVICE_ID_ZEITNET_1221: u32 = 1;
pub const PCI_DEVICE_ID_ZEITNET_1225: u32 = 2;
pub const PCI_VENDOR_ID_FUJITSU_ME: u32 = 4510;
pub const PCI_DEVICE_ID_FUJITSU_FS155: u32 = 1;
pub const PCI_DEVICE_ID_FUJITSU_FS50: u32 = 3;
pub const PCI_SUBVENDOR_ID_KEYSPAN: u32 = 4521;
pub const PCI_SUBDEVICE_ID_KEYSPAN_SX2: u32 = 21300;
pub const PCI_VENDOR_ID_MARVELL: u32 = 4523;
pub const PCI_VENDOR_ID_MARVELL_EXT: u32 = 6987;
pub const PCI_DEVICE_ID_MARVELL_GT64111: u32 = 16710;
pub const PCI_DEVICE_ID_MARVELL_GT64260: u32 = 25648;
pub const PCI_DEVICE_ID_MARVELL_MV64360: u32 = 25696;
pub const PCI_DEVICE_ID_MARVELL_MV64460: u32 = 25728;
pub const PCI_DEVICE_ID_MARVELL_88ALP01_NAND: u32 = 16640;
pub const PCI_DEVICE_ID_MARVELL_88ALP01_SD: u32 = 16641;
pub const PCI_DEVICE_ID_MARVELL_88ALP01_CCIC: u32 = 16642;
pub const PCI_VENDOR_ID_V3: u32 = 4528;
pub const PCI_DEVICE_ID_V3_V960: u32 = 1;
pub const PCI_DEVICE_ID_V3_V351: u32 = 2;
pub const PCI_VENDOR_ID_ATT: u32 = 4545;
pub const PCI_DEVICE_ID_ATT_VENUS_MODEM: u32 = 1152;
pub const PCI_VENDOR_ID_SPECIALIX: u32 = 4555;
pub const PCI_SUBDEVICE_ID_SPECIALIX_SPEED4: u32 = 40964;
pub const PCI_VENDOR_ID_ANALOG_DEVICES: u32 = 4564;
pub const PCI_DEVICE_ID_AD1889JS: u32 = 6281;
pub const PCI_DEVICE_ID_SEGA_BBA: u32 = 4660;
pub const PCI_VENDOR_ID_ZORAN: u32 = 4574;
pub const PCI_DEVICE_ID_ZORAN_36057: u32 = 24663;
pub const PCI_DEVICE_ID_ZORAN_36120: u32 = 24864;
pub const PCI_VENDOR_ID_COMPEX: u32 = 4598;
pub const PCI_DEVICE_ID_COMPEX_ENET100VG4: u32 = 274;
pub const PCI_VENDOR_ID_PMC_Sierra: u32 = 4600;
pub const PCI_VENDOR_ID_MICROSEMI: u32 = 4600;
pub const PCI_VENDOR_ID_RP: u32 = 4606;
pub const PCI_VENDOR_ID_CYCLADES: u32 = 4622;
pub const PCI_DEVICE_ID_PC300_RX_2: u32 = 768;
pub const PCI_DEVICE_ID_PC300_RX_1: u32 = 769;
pub const PCI_DEVICE_ID_PC300_TE_2: u32 = 784;
pub const PCI_DEVICE_ID_PC300_TE_1: u32 = 785;
pub const PCI_DEVICE_ID_PC300_TE_M_2: u32 = 800;
pub const PCI_DEVICE_ID_PC300_TE_M_1: u32 = 801;
pub const PCI_VENDOR_ID_ESSENTIAL: u32 = 4623;
pub const PCI_DEVICE_ID_ESSENTIAL_ROADRUNNER: u32 = 1;
pub const PCI_VENDOR_ID_O2: u32 = 4631;
pub const PCI_DEVICE_ID_O2_6729: u32 = 26409;
pub const PCI_DEVICE_ID_O2_6730: u32 = 26426;
pub const PCI_DEVICE_ID_O2_6832: u32 = 26674;
pub const PCI_DEVICE_ID_O2_6836: u32 = 26678;
pub const PCI_DEVICE_ID_O2_6812: u32 = 26738;
pub const PCI_DEVICE_ID_O2_6933: u32 = 26931;
pub const PCI_DEVICE_ID_O2_8120: u32 = 33056;
pub const PCI_DEVICE_ID_O2_8220: u32 = 33312;
pub const PCI_DEVICE_ID_O2_8221: u32 = 33313;
pub const PCI_DEVICE_ID_O2_8320: u32 = 33568;
pub const PCI_DEVICE_ID_O2_8321: u32 = 33569;
pub const PCI_VENDOR_ID_3DFX: u32 = 4634;
pub const PCI_DEVICE_ID_3DFX_VOODOO: u32 = 1;
pub const PCI_DEVICE_ID_3DFX_VOODOO2: u32 = 2;
pub const PCI_DEVICE_ID_3DFX_BANSHEE: u32 = 3;
pub const PCI_DEVICE_ID_3DFX_VOODOO3: u32 = 5;
pub const PCI_DEVICE_ID_3DFX_VOODOO5: u32 = 9;
pub const PCI_VENDOR_ID_AVM: u32 = 4676;
pub const PCI_DEVICE_ID_AVM_B1: u32 = 1792;
pub const PCI_DEVICE_ID_AVM_C4: u32 = 2048;
pub const PCI_DEVICE_ID_AVM_A1: u32 = 2560;
pub const PCI_DEVICE_ID_AVM_A1_V2: u32 = 3584;
pub const PCI_DEVICE_ID_AVM_C2: u32 = 4352;
pub const PCI_DEVICE_ID_AVM_T1: u32 = 4608;
pub const PCI_VENDOR_ID_STALLION: u32 = 4685;
pub const PCI_VENDOR_ID_AT: u32 = 4697;
pub const PCI_SUBDEVICE_ID_AT_2700FX: u32 = 9985;
pub const PCI_SUBDEVICE_ID_AT_2701FX: u32 = 9987;
pub const PCI_VENDOR_ID_ASIX: u32 = 4699;
pub const PCI_DEVICE_ID_ASIX_AX99100: u32 = 37120;
pub const PCI_DEVICE_ID_ASIX_AX99100_LB: u32 = 37136;
pub const PCI_VENDOR_ID_ESS: u32 = 4701;
pub const PCI_DEVICE_ID_ESS_ESS1968: u32 = 6504;
pub const PCI_DEVICE_ID_ESS_ESS1978: u32 = 6520;
pub const PCI_DEVICE_ID_ESS_ALLEGRO_1: u32 = 6536;
pub const PCI_DEVICE_ID_ESS_ALLEGRO: u32 = 6537;
pub const PCI_DEVICE_ID_ESS_CANYON3D_2LE: u32 = 6544;
pub const PCI_DEVICE_ID_ESS_CANYON3D_2: u32 = 6546;
pub const PCI_DEVICE_ID_ESS_MAESTRO3: u32 = 6552;
pub const PCI_DEVICE_ID_ESS_MAESTRO3_1: u32 = 6553;
pub const PCI_DEVICE_ID_ESS_MAESTRO3_HW: u32 = 6554;
pub const PCI_DEVICE_ID_ESS_MAESTRO3_2: u32 = 6555;
pub const PCI_VENDOR_ID_SATSAGEM: u32 = 4711;
pub const PCI_DEVICE_ID_SATSAGEM_NICCY: u32 = 4118;
pub const PCI_VENDOR_ID_ENSONIQ: u32 = 4724;
pub const PCI_DEVICE_ID_ENSONIQ_CT5880: u32 = 22656;
pub const PCI_DEVICE_ID_ENSONIQ_ES1370: u32 = 20480;
pub const PCI_DEVICE_ID_ENSONIQ_ES1371: u32 = 4977;
pub const PCI_VENDOR_ID_TRANSMETA: u32 = 4729;
pub const PCI_DEVICE_ID_EFFICEON: u32 = 96;
pub const PCI_VENDOR_ID_ROCKWELL: u32 = 4730;
pub const PCI_VENDOR_ID_ITE: u32 = 4739;
pub const PCI_DEVICE_ID_ITE_8172: u32 = 33138;
pub const PCI_DEVICE_ID_ITE_8211: u32 = 33297;
pub const PCI_DEVICE_ID_ITE_8212: u32 = 33298;
pub const PCI_DEVICE_ID_ITE_8213: u32 = 33299;
pub const PCI_DEVICE_ID_ITE_8152: u32 = 33106;
pub const PCI_DEVICE_ID_ITE_8872: u32 = 34930;
pub const PCI_DEVICE_ID_ITE_IT8330G_0: u32 = 59526;
pub const PCI_DEVICE_ID_ESS_ESS0100: u32 = 256;
pub const PCI_VENDOR_ID_ALTEON: u32 = 4782;
pub const PCI_SUBVENDOR_ID_CONNECT_TECH: u32 = 4804;
pub const PCI_SUBDEVICE_ID_CONNECT_TECH_BH8_232: u32 = 1;
pub const PCI_SUBDEVICE_ID_CONNECT_TECH_BH4_232: u32 = 2;
pub const PCI_SUBDEVICE_ID_CONNECT_TECH_BH2_232: u32 = 3;
pub const PCI_SUBDEVICE_ID_CONNECT_TECH_BH8_485: u32 = 4;
pub const PCI_SUBDEVICE_ID_CONNECT_TECH_BH8_485_4_4: u32 = 5;
pub const PCI_SUBDEVICE_ID_CONNECT_TECH_BH4_485: u32 = 6;
pub const PCI_SUBDEVICE_ID_CONNECT_TECH_BH4_485_2_2: u32 = 7;
pub const PCI_SUBDEVICE_ID_CONNECT_TECH_BH2_485: u32 = 8;
pub const PCI_SUBDEVICE_ID_CONNECT_TECH_BH8_485_2_6: u32 = 9;
pub const PCI_SUBDEVICE_ID_CONNECT_TECH_BH081101V1: u32 = 10;
pub const PCI_SUBDEVICE_ID_CONNECT_TECH_BH041101V1: u32 = 11;
pub const PCI_SUBDEVICE_ID_CONNECT_TECH_BH2_20MHZ: u32 = 12;
pub const PCI_SUBDEVICE_ID_CONNECT_TECH_BH2_PTM: u32 = 13;
pub const PCI_SUBDEVICE_ID_CONNECT_TECH_NT960PCI: u32 = 256;
pub const PCI_SUBDEVICE_ID_CONNECT_TECH_TITAN_2: u32 = 513;
pub const PCI_SUBDEVICE_ID_CONNECT_TECH_TITAN_4: u32 = 514;
pub const PCI_SUBDEVICE_ID_CONNECT_TECH_PCI_UART_2_232: u32 = 768;
pub const PCI_SUBDEVICE_ID_CONNECT_TECH_PCI_UART_4_232: u32 = 769;
pub const PCI_SUBDEVICE_ID_CONNECT_TECH_PCI_UART_8_232: u32 = 770;
pub const PCI_SUBDEVICE_ID_CONNECT_TECH_PCI_UART_1_1: u32 = 784;
pub const PCI_SUBDEVICE_ID_CONNECT_TECH_PCI_UART_2_2: u32 = 785;
pub const PCI_SUBDEVICE_ID_CONNECT_TECH_PCI_UART_4_4: u32 = 786;
pub const PCI_SUBDEVICE_ID_CONNECT_TECH_PCI_UART_2: u32 = 800;
pub const PCI_SUBDEVICE_ID_CONNECT_TECH_PCI_UART_4: u32 = 801;
pub const PCI_SUBDEVICE_ID_CONNECT_TECH_PCI_UART_8: u32 = 802;
pub const PCI_SUBDEVICE_ID_CONNECT_TECH_PCI_UART_2_485: u32 = 816;
pub const PCI_SUBDEVICE_ID_CONNECT_TECH_PCI_UART_4_485: u32 = 817;
pub const PCI_SUBDEVICE_ID_CONNECT_TECH_PCI_UART_8_485: u32 = 818;
pub const PCI_VENDOR_ID_NVIDIA_SGS: u32 = 4818;
pub const PCI_DEVICE_ID_NVIDIA_SGS_RIVA128: u32 = 24;
pub const PCI_VENDOR_ID_PERICOM: u32 = 4824;
pub const PCI_DEVICE_ID_PERICOM_PI7C9X7951: u32 = 31057;
pub const PCI_DEVICE_ID_PERICOM_PI7C9X7952: u32 = 31058;
pub const PCI_DEVICE_ID_PERICOM_PI7C9X7954: u32 = 31060;
pub const PCI_DEVICE_ID_PERICOM_PI7C9X7958: u32 = 31064;
pub const PCI_SUBVENDOR_ID_CHASE_PCIFAST: u32 = 4832;
pub const PCI_SUBDEVICE_ID_CHASE_PCIFAST4: u32 = 49;
pub const PCI_SUBDEVICE_ID_CHASE_PCIFAST8: u32 = 33;
pub const PCI_SUBDEVICE_ID_CHASE_PCIFAST16: u32 = 17;
pub const PCI_SUBDEVICE_ID_CHASE_PCIFAST16FMC: u32 = 65;
pub const PCI_SUBVENDOR_ID_CHASE_PCIRAS: u32 = 4685;
pub const PCI_SUBDEVICE_ID_CHASE_PCIRAS4: u32 = 61441;
pub const PCI_SUBDEVICE_ID_CHASE_PCIRAS8: u32 = 61456;
pub const PCI_VENDOR_ID_AUREAL: u32 = 4843;
pub const PCI_DEVICE_ID_AUREAL_VORTEX_1: u32 = 1;
pub const PCI_DEVICE_ID_AUREAL_VORTEX_2: u32 = 2;
pub const PCI_DEVICE_ID_AUREAL_ADVANTAGE: u32 = 3;
pub const PCI_VENDOR_ID_ELECTRONICDESIGNGMBH: u32 = 4856;
pub const PCI_DEVICE_ID_LML_33R10: u32 = 35330;
pub const PCI_VENDOR_ID_ESDGMBH: u32 = 4862;
pub const PCI_DEVICE_ID_ESDGMBH_CPCIASIO4: u32 = 273;
pub const PCI_VENDOR_ID_CB: u32 = 4871;
pub const PCI_VENDOR_ID_SIIG: u32 = 4895;
pub const PCI_SUBVENDOR_ID_SIIG: u32 = 4895;
pub const PCI_DEVICE_ID_SIIG_1S_10x_550: u32 = 4096;
pub const PCI_DEVICE_ID_SIIG_1S_10x_650: u32 = 4097;
pub const PCI_DEVICE_ID_SIIG_1S_10x_850: u32 = 4098;
pub const PCI_DEVICE_ID_SIIG_1S1P_10x_550: u32 = 4112;
pub const PCI_DEVICE_ID_SIIG_1S1P_10x_650: u32 = 4113;
pub const PCI_DEVICE_ID_SIIG_1S1P_10x_850: u32 = 4114;
pub const PCI_DEVICE_ID_SIIG_1P_10x: u32 = 4128;
pub const PCI_DEVICE_ID_SIIG_2P_10x: u32 = 4129;
pub const PCI_DEVICE_ID_SIIG_2S_10x_550: u32 = 4144;
pub const PCI_DEVICE_ID_SIIG_2S_10x_650: u32 = 4145;
pub const PCI_DEVICE_ID_SIIG_2S_10x_850: u32 = 4146;
pub const PCI_DEVICE_ID_SIIG_2S1P_10x_550: u32 = 4148;
pub const PCI_DEVICE_ID_SIIG_2S1P_10x_650: u32 = 4149;
pub const PCI_DEVICE_ID_SIIG_2S1P_10x_850: u32 = 4150;
pub const PCI_DEVICE_ID_SIIG_4S_10x_550: u32 = 4176;
pub const PCI_DEVICE_ID_SIIG_4S_10x_650: u32 = 4177;
pub const PCI_DEVICE_ID_SIIG_4S_10x_850: u32 = 4178;
pub const PCI_DEVICE_ID_SIIG_1S_20x_550: u32 = 8192;
pub const PCI_DEVICE_ID_SIIG_1S_20x_650: u32 = 8193;
pub const PCI_DEVICE_ID_SIIG_1S_20x_850: u32 = 8194;
pub const PCI_DEVICE_ID_SIIG_1P_20x: u32 = 8224;
pub const PCI_DEVICE_ID_SIIG_2P_20x: u32 = 8225;
pub const PCI_DEVICE_ID_SIIG_2S_20x_550: u32 = 8240;
pub const PCI_DEVICE_ID_SIIG_2S_20x_650: u32 = 8241;
pub const PCI_DEVICE_ID_SIIG_2S_20x_850: u32 = 8242;
pub const PCI_DEVICE_ID_SIIG_2P1S_20x_550: u32 = 8256;
pub const PCI_DEVICE_ID_SIIG_2P1S_20x_650: u32 = 8257;
pub const PCI_DEVICE_ID_SIIG_2P1S_20x_850: u32 = 8258;
pub const PCI_DEVICE_ID_SIIG_1S1P_20x_550: u32 = 8208;
pub const PCI_DEVICE_ID_SIIG_1S1P_20x_650: u32 = 8209;
pub const PCI_DEVICE_ID_SIIG_1S1P_20x_850: u32 = 8210;
pub const PCI_DEVICE_ID_SIIG_4S_20x_550: u32 = 8272;
pub const PCI_DEVICE_ID_SIIG_4S_20x_650: u32 = 8273;
pub const PCI_DEVICE_ID_SIIG_4S_20x_850: u32 = 8274;
pub const PCI_DEVICE_ID_SIIG_2S1P_20x_550: u32 = 8288;
pub const PCI_DEVICE_ID_SIIG_2S1P_20x_650: u32 = 8289;
pub const PCI_DEVICE_ID_SIIG_2S1P_20x_850: u32 = 8290;
pub const PCI_DEVICE_ID_SIIG_8S_20x_550: u32 = 8320;
pub const PCI_DEVICE_ID_SIIG_8S_20x_650: u32 = 8321;
pub const PCI_DEVICE_ID_SIIG_8S_20x_850: u32 = 8322;
pub const PCI_SUBDEVICE_ID_SIIG_QUARTET_SERIAL: u32 = 8272;
pub const PCI_VENDOR_ID_RADISYS: u32 = 4913;
pub const PCI_VENDOR_ID_MICRO_MEMORY: u32 = 4914;
pub const PCI_DEVICE_ID_MICRO_MEMORY_5415CN: u32 = 21525;
pub const PCI_DEVICE_ID_MICRO_MEMORY_5425CN: u32 = 21541;
pub const PCI_DEVICE_ID_MICRO_MEMORY_6155: u32 = 24917;
pub const PCI_VENDOR_ID_DOMEX: u32 = 4938;
pub const PCI_DEVICE_ID_DOMEX_DMX3191D: u32 = 1;
pub const PCI_VENDOR_ID_INTASHIELD: u32 = 4954;
pub const PCI_DEVICE_ID_INTASHIELD_IS200: u32 = 3456;
pub const PCI_DEVICE_ID_INTASHIELD_IS400: u32 = 3520;
pub const PCI_VENDOR_ID_QUATECH: u32 = 4956;
pub const PCI_DEVICE_ID_QUATECH_QSC100: u32 = 16;
pub const PCI_DEVICE_ID_QUATECH_DSC100: u32 = 32;
pub const PCI_DEVICE_ID_QUATECH_DSC200: u32 = 48;
pub const PCI_DEVICE_ID_QUATECH_QSC200: u32 = 64;
pub const PCI_DEVICE_ID_QUATECH_ESC100D: u32 = 80;
pub const PCI_DEVICE_ID_QUATECH_ESC100M: u32 = 96;
pub const PCI_DEVICE_ID_QUATECH_QSCP100: u32 = 288;
pub const PCI_DEVICE_ID_QUATECH_DSCP100: u32 = 304;
pub const PCI_DEVICE_ID_QUATECH_QSCP200: u32 = 320;
pub const PCI_DEVICE_ID_QUATECH_DSCP200: u32 = 336;
pub const PCI_DEVICE_ID_QUATECH_QSCLP100: u32 = 368;
pub const PCI_DEVICE_ID_QUATECH_DSCLP100: u32 = 384;
pub const PCI_DEVICE_ID_QUATECH_DSC100E: u32 = 385;
pub const PCI_DEVICE_ID_QUATECH_SSCLP100: u32 = 400;
pub const PCI_DEVICE_ID_QUATECH_QSCLP200: u32 = 416;
pub const PCI_DEVICE_ID_QUATECH_DSCLP200: u32 = 432;
pub const PCI_DEVICE_ID_QUATECH_DSC200E: u32 = 433;
pub const PCI_DEVICE_ID_QUATECH_SSCLP200: u32 = 448;
pub const PCI_DEVICE_ID_QUATECH_ESCLP100: u32 = 480;
pub const PCI_DEVICE_ID_QUATECH_SPPXP_100: u32 = 632;
pub const PCI_VENDOR_ID_SEALEVEL: u32 = 4958;
pub const PCI_DEVICE_ID_SEALEVEL_U530: u32 = 28929;
pub const PCI_DEVICE_ID_SEALEVEL_UCOMM2: u32 = 29185;
pub const PCI_DEVICE_ID_SEALEVEL_UCOMM422: u32 = 29698;
pub const PCI_DEVICE_ID_SEALEVEL_UCOMM232: u32 = 29186;
pub const PCI_DEVICE_ID_SEALEVEL_COMM4: u32 = 29697;
pub const PCI_DEVICE_ID_SEALEVEL_COMM8: u32 = 30721;
pub const PCI_DEVICE_ID_SEALEVEL_7803: u32 = 30723;
pub const PCI_DEVICE_ID_SEALEVEL_UCOMM8: u32 = 30724;
pub const PCI_VENDOR_ID_HYPERCOPE: u32 = 4965;
pub const PCI_DEVICE_ID_HYPERCOPE_PLX: u32 = 36944;
pub const PCI_SUBDEVICE_ID_HYPERCOPE_OLD_ERGO: u32 = 260;
pub const PCI_SUBDEVICE_ID_HYPERCOPE_ERGO: u32 = 262;
pub const PCI_SUBDEVICE_ID_HYPERCOPE_METRO: u32 = 263;
pub const PCI_SUBDEVICE_ID_HYPERCOPE_CHAMP2: u32 = 264;
pub const PCI_VENDOR_ID_DIGIGRAM: u32 = 4969;
pub const PCI_SUBDEVICE_ID_DIGIGRAM_LX6464ES_SERIAL_SUBSYSTEM: u32 = 49153;
pub const PCI_SUBDEVICE_ID_DIGIGRAM_LX6464ES_CAE_SERIAL_SUBSYSTEM: u32 = 49154;
pub const PCI_SUBDEVICE_ID_DIGIGRAM_LX6464ESE_SERIAL_SUBSYSTEM: u32 = 49185;
pub const PCI_SUBDEVICE_ID_DIGIGRAM_LX6464ESE_CAE_SERIAL_SUBSYSTEM: u32 = 49186;
pub const PCI_VENDOR_ID_KAWASAKI: u32 = 4971;
pub const PCI_DEVICE_ID_MCHIP_KL5A72002: u32 = 65281;
pub const PCI_VENDOR_ID_CNET: u32 = 4977;
pub const PCI_DEVICE_ID_CNET_GIGACARD: u32 = 17230;
pub const PCI_VENDOR_ID_LMC: u32 = 4982;
pub const PCI_DEVICE_ID_LMC_HSSI: u32 = 3;
pub const PCI_DEVICE_ID_LMC_DS3: u32 = 4;
pub const PCI_DEVICE_ID_LMC_SSI: u32 = 5;
pub const PCI_DEVICE_ID_LMC_T1: u32 = 6;
pub const PCI_VENDOR_ID_NETGEAR: u32 = 4997;
pub const PCI_DEVICE_ID_NETGEAR_GA620: u32 = 25098;
pub const PCI_VENDOR_ID_APPLICOM: u32 = 5001;
pub const PCI_DEVICE_ID_APPLICOM_PCIGENERIC: u32 = 1;
pub const PCI_DEVICE_ID_APPLICOM_PCI2000IBS_CAN: u32 = 2;
pub const PCI_DEVICE_ID_APPLICOM_PCI2000PFB: u32 = 3;
pub const PCI_VENDOR_ID_MOXA: u32 = 5011;
pub const PCI_DEVICE_ID_MOXA_CP204J: u32 = 8256;
pub const PCI_DEVICE_ID_MOXA_C218: u32 = 8576;
pub const PCI_DEVICE_ID_MOXA_C320: u32 = 12800;
pub const PCI_VENDOR_ID_CCD: u32 = 5015;
pub const PCI_DEVICE_ID_CCD_HFC4S: u32 = 2228;
pub const PCI_SUBDEVICE_ID_CCD_PMX2S: u32 = 4660;
pub const PCI_DEVICE_ID_CCD_HFC8S: u32 = 5816;
pub const PCI_DEVICE_ID_CCD_2BD0: u32 = 11216;
pub const PCI_DEVICE_ID_CCD_HFCE1: u32 = 12465;
pub const PCI_SUBDEVICE_ID_CCD_SPD4S: u32 = 12598;
pub const PCI_SUBDEVICE_ID_CCD_SPDE1: u32 = 12599;
pub const PCI_DEVICE_ID_CCD_B000: u32 = 45056;
pub const PCI_DEVICE_ID_CCD_B006: u32 = 45062;
pub const PCI_DEVICE_ID_CCD_B007: u32 = 45063;
pub const PCI_DEVICE_ID_CCD_B008: u32 = 45064;
pub const PCI_DEVICE_ID_CCD_B009: u32 = 45065;
pub const PCI_DEVICE_ID_CCD_B00A: u32 = 45066;
pub const PCI_DEVICE_ID_CCD_B00B: u32 = 45067;
pub const PCI_DEVICE_ID_CCD_B00C: u32 = 45068;
pub const PCI_DEVICE_ID_CCD_B100: u32 = 45312;
pub const PCI_SUBDEVICE_ID_CCD_IOB4ST: u32 = 46368;
pub const PCI_SUBDEVICE_ID_CCD_IOB8STR: u32 = 46369;
pub const PCI_SUBDEVICE_ID_CCD_IOB8ST: u32 = 46370;
pub const PCI_SUBDEVICE_ID_CCD_IOB1E1: u32 = 46371;
pub const PCI_SUBDEVICE_ID_CCD_SWYX4S: u32 = 46400;
pub const PCI_SUBDEVICE_ID_CCD_JH4S20: u32 = 46416;
pub const PCI_SUBDEVICE_ID_CCD_IOB8ST_1: u32 = 46418;
pub const PCI_SUBDEVICE_ID_CCD_JHSE1: u32 = 46419;
pub const PCI_SUBDEVICE_ID_CCD_JH8S: u32 = 46427;
pub const PCI_SUBDEVICE_ID_CCD_BN4S: u32 = 46432;
pub const PCI_SUBDEVICE_ID_CCD_BN8S: u32 = 46434;
pub const PCI_SUBDEVICE_ID_CCD_BNE1: u32 = 46435;
pub const PCI_SUBDEVICE_ID_CCD_BNE1D: u32 = 46436;
pub const PCI_SUBDEVICE_ID_CCD_BNE1DP: u32 = 46437;
pub const PCI_SUBDEVICE_ID_CCD_BN2S: u32 = 46438;
pub const PCI_SUBDEVICE_ID_CCD_BN1SM: u32 = 46439;
pub const PCI_SUBDEVICE_ID_CCD_BN4SM: u32 = 46440;
pub const PCI_SUBDEVICE_ID_CCD_BN2SM: u32 = 46441;
pub const PCI_SUBDEVICE_ID_CCD_BNE1M: u32 = 46442;
pub const PCI_SUBDEVICE_ID_CCD_BN8SP: u32 = 46443;
pub const PCI_SUBDEVICE_ID_CCD_HFC4S: u32 = 46624;
pub const PCI_SUBDEVICE_ID_CCD_HFC8S: u32 = 46626;
pub const PCI_DEVICE_ID_CCD_B700: u32 = 46848;
pub const PCI_DEVICE_ID_CCD_B701: u32 = 46849;
pub const PCI_SUBDEVICE_ID_CCD_HFCE1: u32 = 50467;
pub const PCI_SUBDEVICE_ID_CCD_OV2S: u32 = 59524;
pub const PCI_SUBDEVICE_ID_CCD_OV4S: u32 = 59528;
pub const PCI_SUBDEVICE_ID_CCD_OV8S: u32 = 59800;
pub const PCI_VENDOR_ID_EXAR: u32 = 5032;
pub const PCI_DEVICE_ID_EXAR_XR17C152: u32 = 338;
pub const PCI_DEVICE_ID_EXAR_XR17C154: u32 = 340;
pub const PCI_DEVICE_ID_EXAR_XR17C158: u32 = 344;
pub const PCI_DEVICE_ID_EXAR_XR17V352: u32 = 850;
pub const PCI_DEVICE_ID_EXAR_XR17V354: u32 = 852;
pub const PCI_DEVICE_ID_EXAR_XR17V358: u32 = 856;
pub const PCI_VENDOR_ID_MICROGATE: u32 = 5056;
pub const PCI_VENDOR_ID_3WARE: u32 = 5057;
pub const PCI_DEVICE_ID_3WARE_1000: u32 = 4096;
pub const PCI_DEVICE_ID_3WARE_7000: u32 = 4097;
pub const PCI_DEVICE_ID_3WARE_9000: u32 = 4098;
pub const PCI_VENDOR_ID_IOMEGA: u32 = 5066;
pub const PCI_DEVICE_ID_IOMEGA_BUZ: u32 = 16945;
pub const PCI_VENDOR_ID_ABOCOM: u32 = 5073;
pub const PCI_DEVICE_ID_ABOCOM_2BD1: u32 = 11217;
pub const PCI_VENDOR_ID_SUNDANCE: u32 = 5104;
pub const PCI_VENDOR_ID_CMEDIA: u32 = 5110;
pub const PCI_DEVICE_ID_CMEDIA_CM8338A: u32 = 256;
pub const PCI_DEVICE_ID_CMEDIA_CM8338B: u32 = 257;
pub const PCI_DEVICE_ID_CMEDIA_CM8738: u32 = 273;
pub const PCI_DEVICE_ID_CMEDIA_CM8738B: u32 = 274;
pub const PCI_VENDOR_ID_ADVANTECH: u32 = 5118;
pub const PCI_VENDOR_ID_MEILHAUS: u32 = 5122;
pub const PCI_VENDOR_ID_LAVA: u32 = 5127;
pub const PCI_DEVICE_ID_LAVA_DSERIAL: u32 = 256;
pub const PCI_DEVICE_ID_LAVA_QUATRO_A: u32 = 257;
pub const PCI_DEVICE_ID_LAVA_QUATRO_B: u32 = 258;
pub const PCI_DEVICE_ID_LAVA_QUATTRO_A: u32 = 288;
pub const PCI_DEVICE_ID_LAVA_QUATTRO_B: u32 = 289;
pub const PCI_DEVICE_ID_LAVA_OCTO_A: u32 = 384;
pub const PCI_DEVICE_ID_LAVA_OCTO_B: u32 = 385;
pub const PCI_DEVICE_ID_LAVA_PORT_PLUS: u32 = 512;
pub const PCI_DEVICE_ID_LAVA_QUAD_A: u32 = 513;
pub const PCI_DEVICE_ID_LAVA_QUAD_B: u32 = 514;
pub const PCI_DEVICE_ID_LAVA_SSERIAL: u32 = 1280;
pub const PCI_DEVICE_ID_LAVA_PORT_650: u32 = 1536;
pub const PCI_DEVICE_ID_LAVA_PARALLEL: u32 = 32768;
pub const PCI_DEVICE_ID_LAVA_DUAL_PAR_A: u32 = 32770;
pub const PCI_DEVICE_ID_LAVA_DUAL_PAR_B: u32 = 32771;
pub const PCI_DEVICE_ID_LAVA_BOCA_IOPPAR: u32 = 34816;
pub const PCI_VENDOR_ID_TIMEDIA: u32 = 5129;
pub const PCI_DEVICE_ID_TIMEDIA_1889: u32 = 29032;
pub const PCI_VENDOR_ID_ICE: u32 = 5138;
pub const PCI_DEVICE_ID_ICE_1712: u32 = 5906;
pub const PCI_DEVICE_ID_VT1724: u32 = 5924;
pub const PCI_VENDOR_ID_MICROSOFT: u32 = 5140;
pub const PCI_DEVICE_ID_HYPERV_VIDEO: u32 = 21331;
pub const PCI_VENDOR_ID_OXSEMI: u32 = 5141;
pub const PCI_DEVICE_ID_OXSEMI_12PCI840: u32 = 33795;
pub const PCI_DEVICE_ID_OXSEMI_PCIe840: u32 = 49152;
pub const PCI_DEVICE_ID_OXSEMI_PCIe840_G: u32 = 49156;
pub const PCI_DEVICE_ID_OXSEMI_PCIe952_0: u32 = 49408;
pub const PCI_DEVICE_ID_OXSEMI_PCIe952_0_G: u32 = 49412;
pub const PCI_DEVICE_ID_OXSEMI_PCIe952_1: u32 = 49424;
pub const PCI_DEVICE_ID_OXSEMI_PCIe952_1_G: u32 = 49428;
pub const PCI_DEVICE_ID_OXSEMI_PCIe952_1_U: u32 = 49432;
pub const PCI_DEVICE_ID_OXSEMI_PCIe952_1_GU: u32 = 49436;
pub const PCI_DEVICE_ID_OXSEMI_16PCI954: u32 = 38145;
pub const PCI_DEVICE_ID_OXSEMI_C950: u32 = 38155;
pub const PCI_DEVICE_ID_OXSEMI_16PCI95N: u32 = 38161;
pub const PCI_DEVICE_ID_OXSEMI_16PCI954PP: u32 = 38163;
pub const PCI_DEVICE_ID_OXSEMI_16PCI952: u32 = 38177;
pub const PCI_DEVICE_ID_OXSEMI_16PCI952PP: u32 = 38179;
pub const PCI_SUBDEVICE_ID_OXSEMI_C950: u32 = 1;
pub const PCI_VENDOR_ID_CHELSIO: u32 = 5157;
pub const PCI_VENDOR_ID_EDIMAX: u32 = 5170;
pub const PCI_VENDOR_ID_ADLINK: u32 = 5194;
pub const PCI_VENDOR_ID_SAMSUNG: u32 = 5197;
pub const PCI_VENDOR_ID_GIGABYTE: u32 = 5208;
pub const PCI_VENDOR_ID_AMBIT: u32 = 5224;
pub const PCI_VENDOR_ID_MYRICOM: u32 = 5313;
pub const PCI_VENDOR_ID_MEDIATEK: u32 = 5315;
pub const PCI_DEVICE_ID_MEDIATEK_7629: u32 = 30249;
pub const PCI_VENDOR_ID_TITAN: u32 = 5330;
pub const PCI_DEVICE_ID_TITAN_010L: u32 = 32769;
pub const PCI_DEVICE_ID_TITAN_100L: u32 = 32784;
pub const PCI_DEVICE_ID_TITAN_110L: u32 = 32785;
pub const PCI_DEVICE_ID_TITAN_200L: u32 = 32800;
pub const PCI_DEVICE_ID_TITAN_210L: u32 = 32801;
pub const PCI_DEVICE_ID_TITAN_400L: u32 = 32832;
pub const PCI_DEVICE_ID_TITAN_800L: u32 = 32896;
pub const PCI_DEVICE_ID_TITAN_100: u32 = 40961;
pub const PCI_DEVICE_ID_TITAN_200: u32 = 40965;
pub const PCI_DEVICE_ID_TITAN_400: u32 = 40963;
pub const PCI_DEVICE_ID_TITAN_800B: u32 = 40964;
pub const PCI_VENDOR_ID_PANACOM: u32 = 5332;
pub const PCI_DEVICE_ID_PANACOM_QUADMODEM: u32 = 1024;
pub const PCI_DEVICE_ID_PANACOM_DUALMODEM: u32 = 1026;
pub const PCI_VENDOR_ID_SIPACKETS: u32 = 5337;
pub const PCI_DEVICE_ID_SP1011: u32 = 16;
pub const PCI_VENDOR_ID_AFAVLAB: u32 = 5339;
pub const PCI_DEVICE_ID_AFAVLAB_P028: u32 = 8576;
pub const PCI_DEVICE_ID_AFAVLAB_P030: u32 = 8578;
pub const PCI_SUBDEVICE_ID_AFAVLAB_P061: u32 = 8528;
pub const PCI_VENDOR_ID_AMPLICON: u32 = 5340;
pub const PCI_VENDOR_ID_BCM_GVC: u32 = 5284;
pub const PCI_VENDOR_ID_BROADCOM: u32 = 5348;
pub const PCI_DEVICE_ID_TIGON3_5752: u32 = 5632;
pub const PCI_DEVICE_ID_TIGON3_5752M: u32 = 5633;
pub const PCI_DEVICE_ID_NX2_5709: u32 = 5689;
pub const PCI_DEVICE_ID_NX2_5709S: u32 = 5690;
pub const PCI_DEVICE_ID_TIGON3_5700: u32 = 5700;
pub const PCI_DEVICE_ID_TIGON3_5701: u32 = 5701;
pub const PCI_DEVICE_ID_TIGON3_5702: u32 = 5702;
pub const PCI_DEVICE_ID_TIGON3_5703: u32 = 5703;
pub const PCI_DEVICE_ID_TIGON3_5704: u32 = 5704;
pub const PCI_DEVICE_ID_TIGON3_5704S_2: u32 = 5705;
pub const PCI_DEVICE_ID_NX2_5706: u32 = 5706;
pub const PCI_DEVICE_ID_NX2_5708: u32 = 5708;
pub const PCI_DEVICE_ID_TIGON3_5702FE: u32 = 5709;
pub const PCI_DEVICE_ID_NX2_57710: u32 = 5710;
pub const PCI_DEVICE_ID_NX2_57711: u32 = 5711;
pub const PCI_DEVICE_ID_NX2_57711E: u32 = 5712;
pub const PCI_DEVICE_ID_TIGON3_5705: u32 = 5715;
pub const PCI_DEVICE_ID_TIGON3_5705_2: u32 = 5716;
pub const PCI_DEVICE_ID_TIGON3_5719: u32 = 5719;
pub const PCI_DEVICE_ID_TIGON3_5721: u32 = 5721;
pub const PCI_DEVICE_ID_TIGON3_5722: u32 = 5722;
pub const PCI_DEVICE_ID_TIGON3_5723: u32 = 5723;
pub const PCI_DEVICE_ID_TIGON3_5705M: u32 = 5725;
pub const PCI_DEVICE_ID_TIGON3_5705M_2: u32 = 5726;
pub const PCI_DEVICE_ID_NX2_57712: u32 = 5730;
pub const PCI_DEVICE_ID_NX2_57712E: u32 = 5731;
pub const PCI_DEVICE_ID_NX2_57712_MF: u32 = 5731;
pub const PCI_DEVICE_ID_TIGON3_5714: u32 = 5736;
pub const PCI_DEVICE_ID_TIGON3_5714S: u32 = 5737;
pub const PCI_DEVICE_ID_TIGON3_5780: u32 = 5738;
pub const PCI_DEVICE_ID_TIGON3_5780S: u32 = 5739;
pub const PCI_DEVICE_ID_TIGON3_5705F: u32 = 5742;
pub const PCI_DEVICE_ID_NX2_57712_VF: u32 = 5743;
pub const PCI_DEVICE_ID_TIGON3_5754M: u32 = 5746;
pub const PCI_DEVICE_ID_TIGON3_5755M: u32 = 5747;
pub const PCI_DEVICE_ID_TIGON3_5756: u32 = 5748;
pub const PCI_DEVICE_ID_TIGON3_5750: u32 = 5750;
pub const PCI_DEVICE_ID_TIGON3_5751: u32 = 5751;
pub const PCI_DEVICE_ID_TIGON3_5715: u32 = 5752;
pub const PCI_DEVICE_ID_TIGON3_5715S: u32 = 5753;
pub const PCI_DEVICE_ID_TIGON3_5754: u32 = 5754;
pub const PCI_DEVICE_ID_TIGON3_5755: u32 = 5755;
pub const PCI_DEVICE_ID_TIGON3_5751M: u32 = 5757;
pub const PCI_DEVICE_ID_TIGON3_5751F: u32 = 5758;
pub const PCI_DEVICE_ID_TIGON3_5787F: u32 = 5759;
pub const PCI_DEVICE_ID_TIGON3_5761E: u32 = 5760;
pub const PCI_DEVICE_ID_TIGON3_5761: u32 = 5761;
pub const PCI_DEVICE_ID_TIGON3_5764: u32 = 5764;
pub const PCI_DEVICE_ID_NX2_57800: u32 = 5770;
pub const PCI_DEVICE_ID_NX2_57840: u32 = 5773;
pub const PCI_DEVICE_ID_NX2_57810: u32 = 5774;
pub const PCI_DEVICE_ID_TIGON3_5787M: u32 = 5779;
pub const PCI_DEVICE_ID_TIGON3_5782: u32 = 5782;
pub const PCI_DEVICE_ID_TIGON3_5784: u32 = 5784;
pub const PCI_DEVICE_ID_TIGON3_5786: u32 = 5786;
pub const PCI_DEVICE_ID_TIGON3_5787: u32 = 5787;
pub const PCI_DEVICE_ID_TIGON3_5788: u32 = 5788;
pub const PCI_DEVICE_ID_TIGON3_5789: u32 = 5789;
pub const PCI_DEVICE_ID_NX2_57840_4_10: u32 = 5793;
pub const PCI_DEVICE_ID_NX2_57840_2_20: u32 = 5794;
pub const PCI_DEVICE_ID_NX2_57840_MF: u32 = 5796;
pub const PCI_DEVICE_ID_NX2_57800_MF: u32 = 5797;
pub const PCI_DEVICE_ID_TIGON3_5702X: u32 = 5798;
pub const PCI_DEVICE_ID_TIGON3_5703X: u32 = 5799;
pub const PCI_DEVICE_ID_TIGON3_5704S: u32 = 5800;
pub const PCI_DEVICE_ID_NX2_57800_VF: u32 = 5801;
pub const PCI_DEVICE_ID_NX2_5706S: u32 = 5802;
pub const PCI_DEVICE_ID_NX2_5708S: u32 = 5804;
pub const PCI_DEVICE_ID_NX2_57840_VF: u32 = 5805;
pub const PCI_DEVICE_ID_NX2_57810_MF: u32 = 5806;
pub const PCI_DEVICE_ID_NX2_57810_VF: u32 = 5807;
pub const PCI_DEVICE_ID_TIGON3_5702A3: u32 = 5830;
pub const PCI_DEVICE_ID_TIGON3_5703A3: u32 = 5831;
pub const PCI_DEVICE_ID_TIGON3_5781: u32 = 5853;
pub const PCI_DEVICE_ID_TIGON3_5753: u32 = 5879;
pub const PCI_DEVICE_ID_TIGON3_5753M: u32 = 5885;
pub const PCI_DEVICE_ID_TIGON3_5753F: u32 = 5886;
pub const PCI_DEVICE_ID_TIGON3_5901: u32 = 5901;
pub const PCI_DEVICE_ID_BCM4401B1: u32 = 5900;
pub const PCI_DEVICE_ID_TIGON3_5901_2: u32 = 5902;
pub const PCI_DEVICE_ID_TIGON3_5906: u32 = 5906;
pub const PCI_DEVICE_ID_TIGON3_5906M: u32 = 5907;
pub const PCI_DEVICE_ID_BCM4401: u32 = 17409;
pub const PCI_DEVICE_ID_BCM4401B0: u32 = 17410;
pub const PCI_VENDOR_ID_TOPIC: u32 = 5407;
pub const PCI_DEVICE_ID_TOPIC_TP560: u32 = 0;
pub const PCI_VENDOR_ID_MAINPINE: u32 = 5410;
pub const PCI_DEVICE_ID_MAINPINE_PBRIDGE: u32 = 256;
pub const PCI_VENDOR_ID_ENE: u32 = 5412;
pub const PCI_DEVICE_ID_ENE_CB710_FLASH: u32 = 1296;
pub const PCI_DEVICE_ID_ENE_CB712_SD: u32 = 1360;
pub const PCI_DEVICE_ID_ENE_CB712_SD_2: u32 = 1361;
pub const PCI_DEVICE_ID_ENE_CB714_SD: u32 = 1872;
pub const PCI_DEVICE_ID_ENE_CB714_SD_2: u32 = 1873;
pub const PCI_DEVICE_ID_ENE_1211: u32 = 4625;
pub const PCI_DEVICE_ID_ENE_1225: u32 = 4645;
pub const PCI_DEVICE_ID_ENE_1410: u32 = 5136;
pub const PCI_DEVICE_ID_ENE_710: u32 = 5137;
pub const PCI_DEVICE_ID_ENE_712: u32 = 5138;
pub const PCI_DEVICE_ID_ENE_1420: u32 = 5152;
pub const PCI_DEVICE_ID_ENE_720: u32 = 5153;
pub const PCI_DEVICE_ID_ENE_722: u32 = 5154;
pub const PCI_SUBVENDOR_ID_PERLE: u32 = 5471;
pub const PCI_SUBDEVICE_ID_PCI_RAS4: u32 = 61441;
pub const PCI_SUBDEVICE_ID_PCI_RAS8: u32 = 61456;
pub const PCI_VENDOR_ID_SYBA: u32 = 5522;
pub const PCI_DEVICE_ID_SYBA_2P_EPP: u32 = 1922;
pub const PCI_DEVICE_ID_SYBA_1P_ECP: u32 = 1923;
pub const PCI_VENDOR_ID_MORETON: u32 = 5546;
pub const PCI_DEVICE_ID_RASTEL_2PORT: u32 = 8192;
pub const PCI_VENDOR_ID_VMWARE: u32 = 5549;
pub const PCI_DEVICE_ID_VMWARE_VMXNET3: u32 = 1968;
pub const PCI_VENDOR_ID_ZOLTRIX: u32 = 5552;
pub const PCI_DEVICE_ID_ZOLTRIX_2BD0: u32 = 11216;
pub const PCI_VENDOR_ID_MELLANOX: u32 = 5555;
pub const PCI_DEVICE_ID_MELLANOX_CONNECTX3: u32 = 4099;
pub const PCI_DEVICE_ID_MELLANOX_CONNECTX3_PRO: u32 = 4103;
pub const PCI_DEVICE_ID_MELLANOX_CONNECTIB: u32 = 4113;
pub const PCI_DEVICE_ID_MELLANOX_CONNECTX4: u32 = 4115;
pub const PCI_DEVICE_ID_MELLANOX_CONNECTX4_LX: u32 = 4117;
pub const PCI_DEVICE_ID_MELLANOX_TAVOR: u32 = 23108;
pub const PCI_DEVICE_ID_MELLANOX_TAVOR_BRIDGE: u32 = 23110;
pub const PCI_DEVICE_ID_MELLANOX_SINAI_OLD: u32 = 24204;
pub const PCI_DEVICE_ID_MELLANOX_SINAI: u32 = 25204;
pub const PCI_DEVICE_ID_MELLANOX_ARBEL_COMPAT: u32 = 25208;
pub const PCI_DEVICE_ID_MELLANOX_ARBEL: u32 = 25218;
pub const PCI_DEVICE_ID_MELLANOX_HERMON_SDR: u32 = 25408;
pub const PCI_DEVICE_ID_MELLANOX_HERMON_DDR: u32 = 25418;
pub const PCI_DEVICE_ID_MELLANOX_HERMON_QDR: u32 = 25428;
pub const PCI_DEVICE_ID_MELLANOX_HERMON_EN: u32 = 25448;
pub const PCI_DEVICE_ID_MELLANOX_CONNECTX_EN: u32 = 25458;
pub const PCI_DEVICE_ID_MELLANOX_HERMON_DDR_GEN2: u32 = 26418;
pub const PCI_DEVICE_ID_MELLANOX_HERMON_QDR_GEN2: u32 = 26428;
pub const PCI_DEVICE_ID_MELLANOX_CONNECTX_EN_5_GEN2: u32 = 26438;
pub const PCI_DEVICE_ID_MELLANOX_HERMON_EN_GEN2: u32 = 26448;
pub const PCI_DEVICE_ID_MELLANOX_CONNECTX_EN_T_GEN2: u32 = 26458;
pub const PCI_DEVICE_ID_MELLANOX_CONNECTX_EN_GEN2: u32 = 26468;
pub const PCI_DEVICE_ID_MELLANOX_CONNECTX2: u32 = 26478;
pub const PCI_VENDOR_ID_DFI: u32 = 5565;
pub const PCI_VENDOR_ID_QUICKNET: u32 = 5602;
pub const PCI_DEVICE_ID_QUICKNET_XJ: u32 = 1280;
pub const PCI_VENDOR_ID_ADDIDATA: u32 = 5560;
pub const PCI_DEVICE_ID_ADDIDATA_APCI7500: u32 = 28672;
pub const PCI_DEVICE_ID_ADDIDATA_APCI7420: u32 = 28673;
pub const PCI_DEVICE_ID_ADDIDATA_APCI7300: u32 = 28674;
pub const PCI_DEVICE_ID_ADDIDATA_APCI7500_2: u32 = 28681;
pub const PCI_DEVICE_ID_ADDIDATA_APCI7420_2: u32 = 28682;
pub const PCI_DEVICE_ID_ADDIDATA_APCI7300_2: u32 = 28683;
pub const PCI_DEVICE_ID_ADDIDATA_APCI7500_3: u32 = 28684;
pub const PCI_DEVICE_ID_ADDIDATA_APCI7420_3: u32 = 28685;
pub const PCI_DEVICE_ID_ADDIDATA_APCI7300_3: u32 = 28686;
pub const PCI_DEVICE_ID_ADDIDATA_APCI7800_3: u32 = 28687;
pub const PCI_DEVICE_ID_ADDIDATA_APCIe7300: u32 = 28688;
pub const PCI_DEVICE_ID_ADDIDATA_APCIe7420: u32 = 28689;
pub const PCI_DEVICE_ID_ADDIDATA_APCIe7500: u32 = 28690;
pub const PCI_DEVICE_ID_ADDIDATA_APCIe7800: u32 = 28691;
pub const PCI_VENDOR_ID_PDC: u32 = 5609;
pub const PCI_VENDOR_ID_FARSITE: u32 = 5657;
pub const PCI_DEVICE_ID_FARSITE_T2P: u32 = 1024;
pub const PCI_DEVICE_ID_FARSITE_T4P: u32 = 1088;
pub const PCI_DEVICE_ID_FARSITE_T1U: u32 = 1552;
pub const PCI_DEVICE_ID_FARSITE_T2U: u32 = 1568;
pub const PCI_DEVICE_ID_FARSITE_T4U: u32 = 1600;
pub const PCI_DEVICE_ID_FARSITE_TE1: u32 = 5648;
pub const PCI_DEVICE_ID_FARSITE_TE1C: u32 = 5650;
pub const PCI_VENDOR_ID_ARIMA: u32 = 5663;
pub const PCI_VENDOR_ID_BROCADE: u32 = 5719;
pub const PCI_DEVICE_ID_BROCADE_CT: u32 = 20;
pub const PCI_DEVICE_ID_BROCADE_FC_8G1P: u32 = 23;
pub const PCI_DEVICE_ID_BROCADE_CT_FC: u32 = 33;
pub const PCI_VENDOR_ID_SIBYTE: u32 = 5741;
pub const PCI_DEVICE_ID_BCM1250_PCI: u32 = 1;
pub const PCI_DEVICE_ID_BCM1250_HT: u32 = 2;
pub const PCI_VENDOR_ID_ATHEROS: u32 = 5772;
pub const PCI_VENDOR_ID_NETCELL: u32 = 5788;
pub const PCI_DEVICE_ID_REVOLUTION: u32 = 68;
pub const PCI_VENDOR_ID_CENATEK: u32 = 5834;
pub const PCI_DEVICE_ID_CENATEK_IDE: u32 = 1;
pub const PCI_VENDOR_ID_SYNOPSYS: u32 = 5827;
pub const PCI_DEVICE_ID_SYNOPSYS_HAPSUSB3: u32 = 43981;
pub const PCI_DEVICE_ID_SYNOPSYS_HAPSUSB3_AXI: u32 = 43982;
pub const PCI_DEVICE_ID_SYNOPSYS_HAPSUSB31: u32 = 43983;
pub const PCI_DEVICE_ID_SYNOPSYS_EDDA: u32 = 60890;
pub const PCI_VENDOR_ID_USR: u32 = 5868;
pub const PCI_VENDOR_ID_VITESSE: u32 = 5925;
pub const PCI_DEVICE_ID_VITESSE_VSC7174: u32 = 29044;
pub const PCI_VENDOR_ID_LINKSYS: u32 = 5943;
pub const PCI_DEVICE_ID_LINKSYS_EG1064: u32 = 4196;
pub const PCI_VENDOR_ID_ALTIMA: u32 = 594