/* THIS FILE IS AUTOGENERATED FROM VideoEncoder.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_VIDEOENCODERBINDING_H_
#define DOM_VIDEOENCODERBINDING_H_

#include "VideoDecoderBinding.h"
#include "VideoFrameBinding.h"
#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/EnumTypeTraits.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/RootedDictionary.h"
#include "mozilla/dom/ToJSValue.h"
#include "nsCycleCollectionParticipant.h"

namespace mozilla {
namespace dom {

struct AvcEncoderConfig;
struct AvcEncoderConfigAtoms;
class EncodedVideoChunk;
struct EncodedVideoChunkMetadata;
struct EncodedVideoChunkMetadataAtoms;
class EncodedVideoChunkOutputCallback;
struct NativePropertyHooks;
class ProtoAndIfaceCache;
struct SvcOutputMetadata;
struct SvcOutputMetadataAtoms;
struct VideoDecoderConfig;
class VideoEncoder;
struct VideoEncoderConfig;
struct VideoEncoderConfigAtoms;
struct VideoEncoderEncodeOptionsAtoms;
struct VideoEncoderEncodeOptionsForAvc;
struct VideoEncoderEncodeOptionsForAvcAtoms;
struct VideoEncoderInitAtoms;
struct VideoEncoderSupportAtoms;
class WebCodecsErrorCallback;

} // namespace dom
} // namespace mozilla

namespace mozilla {

namespace dom {

enum class AvcBitstreamFormat : uint8_t {
  Annexb,
  Avc,
};

namespace binding_detail {
template <> struct EnumStrings<AvcBitstreamFormat> {
  static constexpr nsLiteralCString Values[2] {
    "annexb"_ns,
    "avc"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, AvcBitstreamFormat aArgument, JS::MutableHandle<JS::Value> aValue);


enum class VideoEncoderBitrateMode : uint8_t {
  Constant,
  Variable,
  Quantizer,
};

namespace binding_detail {
template <> struct EnumStrings<VideoEncoderBitrateMode> {
  static constexpr nsLiteralCString Values[3] {
    "constant"_ns,
    "variable"_ns,
    "quantizer"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, VideoEncoderBitrateMode aArgument, JS::MutableHandle<JS::Value> aValue);


enum class LatencyMode : uint8_t {
  Quality,
  Realtime,
};

namespace binding_detail {
template <> struct EnumStrings<LatencyMode> {
  static constexpr nsLiteralCString Values[2] {
    "quality"_ns,
    "realtime"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, LatencyMode aArgument, JS::MutableHandle<JS::Value> aValue);


struct AvcEncoderConfig : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR AvcBitstreamFormat mFormat;

  AvcEncoderConfig();

  explicit inline AvcEncoderConfig(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  AvcEncoderConfig(AvcEncoderConfig&& aOther) = default;

  explicit inline AvcEncoderConfig(const AvcEncoderConfig& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  AvcEncoderConfig&
  operator=(const AvcEncoderConfig& aOther);

private:
  static bool
  InitIds(JSContext* cx, AvcEncoderConfigAtoms* atomsCache);
};

namespace binding_detail {
struct FastAvcEncoderConfig : public AvcEncoderConfig
{
  inline FastAvcEncoderConfig()
    : AvcEncoderConfig(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class EncodedVideoChunkOutputCallback : public CallbackFunction
{
public:
  explicit inline EncodedVideoChunkOutputCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline EncodedVideoChunkOutputCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline EncodedVideoChunkOutputCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline EncodedVideoChunkOutputCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, EncodedVideoChunk& chunk, const EncodedVideoChunkMetadata& metadata, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "EncodedVideoChunkOutputCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, chunk, metadata, aRv);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(EncodedVideoChunk& chunk, const EncodedVideoChunkMetadata& metadata, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "EncodedVideoChunkOutputCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, chunk, metadata, aRv);
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, EncodedVideoChunk& chunk, const EncodedVideoChunkMetadata& metadata, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, chunk, metadata, IgnoreErrors(), aExecutionReason);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(EncodedVideoChunk& chunk, const EncodedVideoChunkMetadata& metadata, const char* aExecutionReason = nullptr)
  {
    return Call(chunk, metadata, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const EncodedVideoChunkOutputCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  MOZ_CAN_RUN_SCRIPT void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, EncodedVideoChunk& chunk, const EncodedVideoChunkMetadata& metadata, ErrorResult& aRv);
};


namespace binding_detail {
class FastEncodedVideoChunkOutputCallback : public EncodedVideoChunkOutputCallback
{
public:
  explicit inline FastEncodedVideoChunkOutputCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : EncodedVideoChunkOutputCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    EncodedVideoChunkOutputCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    EncodedVideoChunkOutputCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


struct SvcOutputMetadata : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mTemporalLayerId;

  SvcOutputMetadata();

  explicit inline SvcOutputMetadata(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  SvcOutputMetadata(SvcOutputMetadata&& aOther) = default;

  explicit inline SvcOutputMetadata(const SvcOutputMetadata& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  SvcOutputMetadata&
  operator=(const SvcOutputMetadata& aOther);

private:
  static bool
  InitIds(JSContext* cx, SvcOutputMetadataAtoms* atomsCache);
};

namespace binding_detail {
struct FastSvcOutputMetadata : public SvcOutputMetadata
{
  inline FastSvcOutputMetadata()
    : SvcOutputMetadata(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct VideoEncoderEncodeOptionsForAvc : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<Nullable<uint16_t>> mQuantizer;

  VideoEncoderEncodeOptionsForAvc();

  explicit inline VideoEncoderEncodeOptionsForAvc(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  VideoEncoderEncodeOptionsForAvc(VideoEncoderEncodeOptionsForAvc&& aOther) = default;

  explicit inline VideoEncoderEncodeOptionsForAvc(const VideoEncoderEncodeOptionsForAvc& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  VideoEncoderEncodeOptionsForAvc&
  operator=(const VideoEncoderEncodeOptionsForAvc& aOther);

private:
  static bool
  InitIds(JSContext* cx, VideoEncoderEncodeOptionsForAvcAtoms* atomsCache);
};

namespace binding_detail {
struct FastVideoEncoderEncodeOptionsForAvc : public VideoEncoderEncodeOptionsForAvc
{
  inline FastVideoEncoderEncodeOptionsForAvc()
    : VideoEncoderEncodeOptionsForAvc(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct VideoEncoderInit : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<WebCodecsErrorCallback> mError;
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<EncodedVideoChunkOutputCallback> mOutput;

  VideoEncoderInit();

  explicit inline VideoEncoderInit(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  VideoEncoderInit(VideoEncoderInit&& aOther) = default;

private:
  VideoEncoderInit(const VideoEncoderInit&) = delete;
  VideoEncoderInit& operator=(const VideoEncoderInit&) = delete;

  static bool
  InitIds(JSContext* cx, VideoEncoderInitAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mError, "mError", aFlags);
    ImplCycleCollectionTraverse(aCallback, mOutput, "mOutput", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mError);
    ImplCycleCollectionUnlink(mOutput);
  }
};

namespace binding_detail {
struct FastVideoEncoderInit : public VideoEncoderInit
{
  inline FastVideoEncoderInit()
    : VideoEncoderInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct EncodedVideoChunkMetadata : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<VideoDecoderConfig> mDecoderConfig;
  MOZ_INIT_OUTSIDE_CTOR Optional<SvcOutputMetadata> mSvc;

  EncodedVideoChunkMetadata();

  explicit inline EncodedVideoChunkMetadata(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  EncodedVideoChunkMetadata(EncodedVideoChunkMetadata&& aOther) = default;

private:
  EncodedVideoChunkMetadata(const EncodedVideoChunkMetadata&) = delete;
  EncodedVideoChunkMetadata& operator=(const EncodedVideoChunkMetadata&) = delete;

  static bool
  InitIds(JSContext* cx, EncodedVideoChunkMetadataAtoms* atomsCache);

public:
  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastEncodedVideoChunkMetadata : public EncodedVideoChunkMetadata
{
  inline FastEncodedVideoChunkMetadata()
    : EncodedVideoChunkMetadata(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct VideoEncoderConfig : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR AlphaOption mAlpha;
  MOZ_INIT_OUTSIDE_CTOR Optional<AvcEncoderConfig> mAvc;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint64_t> mBitrate;
  MOZ_INIT_OUTSIDE_CTOR VideoEncoderBitrateMode mBitrateMode;
  MOZ_INIT_OUTSIDE_CTOR nsString mCodec;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mContentHint;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mDisplayHeight;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mDisplayWidth;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mFramerate;
  MOZ_INIT_OUTSIDE_CTOR HardwareAcceleration mHardwareAcceleration;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mHeight;
  MOZ_INIT_OUTSIDE_CTOR LatencyMode mLatencyMode;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mScalabilityMode;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mWidth;

  VideoEncoderConfig();

  explicit inline VideoEncoderConfig(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  VideoEncoderConfig(VideoEncoderConfig&& aOther) = default;

  explicit inline VideoEncoderConfig(const VideoEncoderConfig& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  VideoEncoderConfig&
  operator=(const VideoEncoderConfig& aOther);

private:
  static bool
  InitIds(JSContext* cx, VideoEncoderConfigAtoms* atomsCache);
};

namespace binding_detail {
struct FastVideoEncoderConfig : public VideoEncoderConfig
{
  inline FastVideoEncoderConfig()
    : VideoEncoderConfig(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct VideoEncoderEncodeOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<VideoEncoderEncodeOptionsForAvc> mAvc;
  MOZ_INIT_OUTSIDE_CTOR bool mKeyFrame;

  VideoEncoderEncodeOptions();

  explicit inline VideoEncoderEncodeOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  VideoEncoderEncodeOptions(VideoEncoderEncodeOptions&& aOther) = default;

  explicit inline VideoEncoderEncodeOptions(const VideoEncoderEncodeOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  VideoEncoderEncodeOptions&
  operator=(const VideoEncoderEncodeOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, VideoEncoderEncodeOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastVideoEncoderEncodeOptions : public VideoEncoderEncodeOptions
{
  inline FastVideoEncoderEncodeOptions()
    : VideoEncoderEncodeOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct VideoEncoderSupport : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<VideoEncoderConfig> mConfig;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mSupported;

  VideoEncoderSupport();

  explicit inline VideoEncoderSupport(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  VideoEncoderSupport(VideoEncoderSupport&& aOther) = default;

  explicit inline VideoEncoderSupport(const VideoEncoderSupport& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  VideoEncoderSupport&
  operator=(const VideoEncoderSupport& aOther);

private:
  static bool
  InitIds(JSContext* cx, VideoEncoderSupportAtoms* atomsCache);
};

namespace binding_detail {
struct FastVideoEncoderSupport : public VideoEncoderSupport
{
  inline FastVideoEncoderSupport()
    : VideoEncoderSupport(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace VideoEncoder_Binding {

  typedef mozilla::dom::VideoEncoder NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::VideoEncoder* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::VideoEncoder,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace VideoEncoder_Binding



} // namespace dom


template <>
struct MaxContiguousEnumValue<dom::AvcBitstreamFormat>
{
  static constexpr dom::AvcBitstreamFormat value = dom::AvcBitstreamFormat::Avc;

  static_assert(static_cast<uint8_t>(dom::AvcBitstreamFormat::Annexb) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::AvcBitstreamFormat>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::VideoEncoderBitrateMode>
{
  static constexpr dom::VideoEncoderBitrateMode value = dom::VideoEncoderBitrateMode::Quantizer;

  static_assert(static_cast<uint8_t>(dom::VideoEncoderBitrateMode::Constant) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::VideoEncoderBitrateMode>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::LatencyMode>
{
  static constexpr dom::LatencyMode value = dom::LatencyMode::Realtime;

  static_assert(static_cast<uint8_t>(dom::LatencyMode::Quality) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::LatencyMode>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};


} // namespace mozilla

#endif // DOM_VIDEOENCODERBINDING_H_
