/* THIS FILE IS AUTOGENERATED FROM GeometryUtils.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_GEOMETRYUTILSBINDING_H_
#define DOM_GEOMETRYUTILSBINDING_H_

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/EnumTypeTraits.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/UnionMember.h"
#include "nsCycleCollectionParticipant.h"

namespace mozilla {
namespace dom {

struct BoxQuadOptionsAtoms;
struct ConvertCoordinateOptionsAtoms;
class Document;
class Element;
struct GeometryUtilsOptionsAtoms;
struct NativePropertyHooks;
class OwningTextOrElementOrDocument;
class ProtoAndIfaceCache;
class Text;
class TextOrElementOrDocument;

} // namespace dom
} // namespace mozilla

namespace mozilla {

namespace dom {

enum class CSSBoxType : uint8_t {
  Margin,
  Border,
  Padding,
  Content,
};

namespace binding_detail {
template <> struct EnumStrings<CSSBoxType> {
  static constexpr nsLiteralCString Values[4] {
    "margin"_ns,
    "border"_ns,
    "padding"_ns,
    "content"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, CSSBoxType aArgument, JS::MutableHandle<JS::Value> aValue);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningTextOrElementOrDocument& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningTextOrElementOrDocument& aUnion);


struct GeometryUtilsOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mCreateFramesForSuppressedWhitespace;
  MOZ_INIT_OUTSIDE_CTOR bool mFlush;

  GeometryUtilsOptions();

  explicit inline GeometryUtilsOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GeometryUtilsOptions(GeometryUtilsOptions&& aOther) = default;

  explicit inline GeometryUtilsOptions(const GeometryUtilsOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GeometryUtilsOptions&
  operator=(const GeometryUtilsOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, GeometryUtilsOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastGeometryUtilsOptions : public GeometryUtilsOptions
{
  inline FastGeometryUtilsOptions()
    : GeometryUtilsOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class TextOrElementOrDocument : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eText,
    eElement,
    eDocument
  };
public:
  enum class Type
  {
    eText = TypeOrUninit::eText,
    eElement = TypeOrUninit::eElement,
    eDocument = TypeOrUninit::eDocument
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::Text> > mText;
    UnionMember<NonNull<mozilla::dom::Element> > mElement;
    UnionMember<NonNull<mozilla::dom::Document> > mDocument;

  };

  TypeOrUninit mType;
  Value mValue;

  TextOrElementOrDocument(const TextOrElementOrDocument&) = delete;
  TextOrElementOrDocument& operator=(const TextOrElementOrDocument&) = delete;
public:
  explicit inline TextOrElementOrDocument()
    : mType(eUninitialized)
  {
  }

  inline ~TextOrElementOrDocument()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Text>&
  RawSetAsText()
  {
    if (mType == eText) {
      return mValue.mText.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eText;
    return mValue.mText.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Text>&
  SetAsText()
  {
    if (mType == eText) {
      return mValue.mText.Value();
    }
    Uninit();
    mType = eText;
    return mValue.mText.SetValue();
  }

  inline bool
  IsText() const
  {
    return mType == eText;
  }

  inline NonNull<mozilla::dom::Text>&
  GetAsText()
  {
    MOZ_RELEASE_ASSERT(IsText(), "Wrong type!");
    return mValue.mText.Value();
  }

  inline mozilla::dom::Text&
  GetAsText() const
  {
    MOZ_RELEASE_ASSERT(IsText(), "Wrong type!");
    return mValue.mText.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Element>&
  RawSetAsElement()
  {
    if (mType == eElement) {
      return mValue.mElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eElement;
    return mValue.mElement.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Element>&
  SetAsElement()
  {
    if (mType == eElement) {
      return mValue.mElement.Value();
    }
    Uninit();
    mType = eElement;
    return mValue.mElement.SetValue();
  }

  inline bool
  IsElement() const
  {
    return mType == eElement;
  }

  inline NonNull<mozilla::dom::Element>&
  GetAsElement()
  {
    MOZ_RELEASE_ASSERT(IsElement(), "Wrong type!");
    return mValue.mElement.Value();
  }

  inline mozilla::dom::Element&
  GetAsElement() const
  {
    MOZ_RELEASE_ASSERT(IsElement(), "Wrong type!");
    return mValue.mElement.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Document>&
  RawSetAsDocument()
  {
    if (mType == eDocument) {
      return mValue.mDocument.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDocument;
    return mValue.mDocument.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Document>&
  SetAsDocument()
  {
    if (mType == eDocument) {
      return mValue.mDocument.Value();
    }
    Uninit();
    mType = eDocument;
    return mValue.mDocument.SetValue();
  }

  inline bool
  IsDocument() const
  {
    return mType == eDocument;
  }

  inline NonNull<mozilla::dom::Document>&
  GetAsDocument()
  {
    MOZ_RELEASE_ASSERT(IsDocument(), "Wrong type!");
    return mValue.mDocument.Value();
  }

  inline mozilla::dom::Document&
  GetAsDocument() const
  {
    MOZ_RELEASE_ASSERT(IsDocument(), "Wrong type!");
    return mValue.mDocument.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eText: {
        DestroyText();
        break;
      }
      case eElement: {
        DestroyElement();
        break;
      }
      case eDocument: {
        DestroyDocument();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToText(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToText(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyText()
  {
    MOZ_RELEASE_ASSERT(IsText(), "Wrong type!");
    mValue.mText.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyElement()
  {
    MOZ_RELEASE_ASSERT(IsElement(), "Wrong type!");
    mValue.mElement.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToDocument(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDocument(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyDocument()
  {
    MOZ_RELEASE_ASSERT(IsDocument(), "Wrong type!");
    mValue.mDocument.Destroy();
    mType = eUninitialized;
  }
};


class OwningTextOrElementOrDocument : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningTextOrElementOrDocument& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eText,
    eElement,
    eDocument
  };
public:
  enum class Type
  {
    eText = TypeOrUninit::eText,
    eElement = TypeOrUninit::eElement,
    eDocument = TypeOrUninit::eDocument
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::Text> > mText;
    UnionMember<OwningNonNull<mozilla::dom::Element> > mElement;
    UnionMember<OwningNonNull<mozilla::dom::Document> > mDocument;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningTextOrElementOrDocument()
    : mType(eUninitialized)
  {
  }

  OwningTextOrElementOrDocument(OwningTextOrElementOrDocument&& aOther);

  explicit inline OwningTextOrElementOrDocument(const OwningTextOrElementOrDocument& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningTextOrElementOrDocument()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::Text>&
  RawSetAsText();

  [[nodiscard]] OwningNonNull<mozilla::dom::Text>&
  SetAsText();

  inline bool
  IsText() const
  {
    return mType == eText;
  }

  inline OwningNonNull<mozilla::dom::Text>&
  GetAsText()
  {
    MOZ_RELEASE_ASSERT(IsText(), "Wrong type!");
    return mValue.mText.Value();
  }

  inline OwningNonNull<mozilla::dom::Text> const &
  GetAsText() const
  {
    MOZ_RELEASE_ASSERT(IsText(), "Wrong type!");
    return mValue.mText.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::Element>&
  RawSetAsElement();

  [[nodiscard]] OwningNonNull<mozilla::dom::Element>&
  SetAsElement();

  inline bool
  IsElement() const
  {
    return mType == eElement;
  }

  inline OwningNonNull<mozilla::dom::Element>&
  GetAsElement()
  {
    MOZ_RELEASE_ASSERT(IsElement(), "Wrong type!");
    return mValue.mElement.Value();
  }

  inline OwningNonNull<mozilla::dom::Element> const &
  GetAsElement() const
  {
    MOZ_RELEASE_ASSERT(IsElement(), "Wrong type!");
    return mValue.mElement.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::Document>&
  RawSetAsDocument();

  [[nodiscard]] OwningNonNull<mozilla::dom::Document>&
  SetAsDocument();

  inline bool
  IsDocument() const
  {
    return mType == eDocument;
  }

  inline OwningNonNull<mozilla::dom::Document>&
  GetAsDocument()
  {
    MOZ_RELEASE_ASSERT(IsDocument(), "Wrong type!");
    return mValue.mDocument.Value();
  }

  inline OwningNonNull<mozilla::dom::Document> const &
  GetAsDocument() const
  {
    MOZ_RELEASE_ASSERT(IsDocument(), "Wrong type!");
    return mValue.mDocument.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningTextOrElementOrDocument&
  operator=(OwningTextOrElementOrDocument&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningTextOrElementOrDocument&
  operator=(const OwningTextOrElementOrDocument& aOther);

private:
  bool
  TrySetToText(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToText(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyText();

  bool
  TrySetToElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyElement();

  bool
  TrySetToDocument(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDocument(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyDocument();
};


struct BoxQuadOptions : public GeometryUtilsOptions
{
  MOZ_INIT_OUTSIDE_CTOR CSSBoxType mBox;
  MOZ_INIT_OUTSIDE_CTOR bool mIgnoreTransforms;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningTextOrElementOrDocument> mRelativeTo;

  BoxQuadOptions();

  explicit inline BoxQuadOptions(const FastDictionaryInitializer& )
    : GeometryUtilsOptions(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  BoxQuadOptions(BoxQuadOptions&& aOther) = default;

  explicit inline BoxQuadOptions(const BoxQuadOptions& aOther)
    : GeometryUtilsOptions(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mRelativeTo, "mRelativeTo", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mRelativeTo);
  }

  BoxQuadOptions&
  operator=(const BoxQuadOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, BoxQuadOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastBoxQuadOptions : public BoxQuadOptions
{
  inline FastBoxQuadOptions()
    : BoxQuadOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ConvertCoordinateOptions : public GeometryUtilsOptions
{
  MOZ_INIT_OUTSIDE_CTOR CSSBoxType mFromBox;
  MOZ_INIT_OUTSIDE_CTOR CSSBoxType mToBox;

  ConvertCoordinateOptions();

  explicit inline ConvertCoordinateOptions(const FastDictionaryInitializer& )
    : GeometryUtilsOptions(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ConvertCoordinateOptions(ConvertCoordinateOptions&& aOther) = default;

  explicit inline ConvertCoordinateOptions(const ConvertCoordinateOptions& aOther)
    : GeometryUtilsOptions(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ConvertCoordinateOptions&
  operator=(const ConvertCoordinateOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, ConvertCoordinateOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastConvertCoordinateOptions : public ConvertCoordinateOptions
{
  inline FastConvertCoordinateOptions()
    : ConvertCoordinateOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


} // namespace dom


template <>
struct MaxContiguousEnumValue<dom::CSSBoxType>
{
  static constexpr dom::CSSBoxType value = dom::CSSBoxType::Content;

  static_assert(static_cast<uint8_t>(dom::CSSBoxType::Margin) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::CSSBoxType>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};


} // namespace mozilla

#endif // DOM_GEOMETRYUTILSBINDING_H_
