// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from property.h.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#pragma once

// clang-format off

#include <QDebug>


#include "../PropertiesTypes.h"

#include "PropertiesTypes.h"

#include "union_export.h"

// clang-format on

namespace Union
{
namespace Properties
{

class AlignmentPropertyPrivate;

/*!
\class Union::Properties::AlignmentProperty
\inmodule core
\ingroup core-properties

\brief A property group with properties related to alignment.

*/
class UNION_EXPORT AlignmentProperty
{
public:
    /*!
     * Default constructor. Constructs a null instance.
     *
     * A null instance in this case means an instance that does not have any
     * values for its properties. This includes property groups.
     */
    AlignmentProperty();
    /*!
     * Copy constructor.
     */
    AlignmentProperty(const AlignmentProperty &other);
    /*!
     * Move constructor.
     */
    AlignmentProperty(AlignmentProperty &&other);
    ~AlignmentProperty();

    /*!
     * Copy assignment operator.
     */
    AlignmentProperty &operator=(const AlignmentProperty &other);
    /*!
     * Move assignment operator.
     */
    AlignmentProperty &operator=(AlignmentProperty &&other);

    /*!
     * Returns the value of container.
     */
    std::optional<Union::Properties::AlignmentContainer> container() const;

    /*!
     * Set the value of container.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setContainer(const std::optional<Union::Properties::AlignmentContainer> &newValue);

    /*!
     * Returns the value of horizontal.
     */
    std::optional<Union::Properties::Alignment> horizontal() const;

    /*!
     * Set the value of horizontal.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setHorizontal(const std::optional<Union::Properties::Alignment> &newValue);

    /*!
     * Returns the value of vertical.
     */
    std::optional<Union::Properties::Alignment> vertical() const;

    /*!
     * Set the value of vertical.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setVertical(const std::optional<Union::Properties::Alignment> &newValue);

    /*!
     * Returns the value of order.
     */
    std::optional<int> order() const;

    /*!
     * Set the value of order.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setOrder(const std::optional<int> &newValue);

    /*!
     * Returns if this property group has any value set.
     *
     * Note that for any property that is also a property group, this will also
     * check if that group has any value.
     */
    bool hasAnyValue() const;

    /*!
     * Returns if this property is considered empty.
     *
     * A property is considered empty if it has no values or if the values it
     * contains are all considered empty values.
     */
    bool isEmpty() const;

    /*!
     * Returns a string representation of this property group.
     *
     * This is intended for debugging.
     *
     * \a indentation The amount of indentation to apply. Defaults to 0.
     * \a flags A set of flags that control conversion behavior.
     */
    QString toString(int indentation = 0, ToStringFlags flags = ToStringFlags{}) const;

    /*!
     * Copy property values from source to destination if destination does not have a property value.
     *
     * This will recursively copy property values of grouped properties.
     *
     * \a source      The source property group to copy from.
     * \a destination The destination property group to copy to.
     */
    static void resolveProperties(const AlignmentProperty *source, AlignmentProperty *destination);

    /*!
     * Create and return an empty AlignmentProperty instance.
     *
     * This will create an empty AlignmentProperty instance, which is defined as
     * an instance with all of its values default-constructed. Note that this is
     * different from a default-constructed instance which will have all its
     * values unset.
     */
    static std::unique_ptr<AlignmentProperty> empty();

private:
    std::unique_ptr<AlignmentPropertyPrivate> d;
};

/*!
 * \relates Union::Properties::AlignmentProperty
 * Equality comparison for AlignmentProperty.
 */
UNION_EXPORT bool operator==(const AlignmentProperty &left, const AlignmentProperty &right);
}
}

/*!
 * \relates Union::Properties::AlignmentProperty
 * QDebug support for AlignmentProperty.
 */
UNION_EXPORT QDebug operator<<(QDebug debug, Union::Properties::AlignmentProperty *type);